// mailboxmenu.cc for bbmail - an tool for display the mail in X11.
//
//  Copyright (c) 1998-2000 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//
#include "menu.hh"

Menu::Menu(ToolWindow *toolwindow) :
  Basemenu(toolwindow)
{
  bbtool=toolwindow;
  
  /* Menu settings */
  setTitleVisibility(False);
  setMovable(False);
  setHidable(False);
  setAlignment(AlignBottom);
  defaultMenu();

  /* Temperature unit */
  celcius = bbtool->getResource()->show.label_temperature_celcius;
  if (bbtool->getResource()->show.label_temperature) {
    if (celcius)
      strcpy(temperature_menuitem, "Farenheit");
    else 
      strcpy(temperature_menuitem, "Celcius");
    insert(temperature_menuitem);
  }
  movemenu = false;

  /* Movement */
  insert("Move (n)");

  /* ACPI infos */
  insert("ACPI");

  /* Refresh */
  insert("Refresh");

  /* Close */
  insert("Close");
}


Menu::~Menu(void) {}


void Menu::ClearMenu()
{
  if (bbtool->getResource()->show.label_temperature)
    remove(0);
  remove(0);
  remove(0);
  remove(0);
  remove(0);
}


void Menu::Reconfigure()
{
  /* Temperature unit */
  if (bbtool->getResource()->show.label_temperature) {
    if (celcius)
      strcpy(temperature_menuitem, "Farenheit");
    else 
      strcpy(temperature_menuitem, "Celcius");
    insert(temperature_menuitem);
  }

  /* Move */
  if (!movemenu) insert("Move (n)");
  else insert("Move (y)");

  /* ACPI infos */
  insert("ACPI");

  /* Refresh */
  insert("Refresh");

  /* Close */
  insert("Close");
  Basemenu::reconfigure();
}


void Menu::Move(int x, int y, bool withdrawn)
{
  if (!withdrawn) {
    int y_old=y;
    y= y - getHeight() -1;
    if ((x+getWidth())>bbtool->getCurrentScreenInfo()->getWidth())
      x=bbtool->getCurrentScreenInfo()->getWidth()-getWidth();
    if (y<0)
      y=y_old; 
    Basemenu::move(x, y);
  } else {
    x= x - getWidth() - 6;
    if (x<0)
      x=x + getWidth() + 12;
    if (y<0)
      y=0;
    if (y+getHeight()>bbtool->getCurrentScreenInfo()->getHeight())
      y=bbtool->getCurrentScreenInfo()->getHeight()-getHeight();
    Basemenu::move(x, y);
  }
}


void Menu::Update()
{
  wait_for_update=False;
  Basemenu::update();
}


void Menu::itemSelected(int button, int index)
{  
  if (button == 1) {
    int i = -1;
    int temperature = i++;
    int move = i++;
    int acpi = i++;
    int reconfigure = i++;
    int close = i++;
    
    if (bbtool->getResource()->show.label_temperature) {
      temperature = 0;
      move++;
      acpi++;
      close++;
      reconfigure++;
    }

    /* Temperature */
    if (index == temperature) {
      if (celcius) {
	strcpy(temperature_menuitem, "Celcius");
	celcius = false;
      }
      else { 
	strcpy(temperature_menuitem, "Farenheit");
	celcius = true;
      }
      bbtool->reconfigure();
    }

    /* Move */
    if (index == move) {
      movemenu = !movemenu;
    }

    /* ACPI */
    if (index == acpi) {
      bbtool->printACPI();
    }

    /* Reconfigure */
    if (index == reconfigure) {
      bbtool->reconfigure();
    }

    /* Close */
    if (index == close)
      bbtool->shutdown();

    hide();
    ClearMenu();
    Reconfigure();
  }
}


void Menu::show(void)
{
  XRaiseWindow(bbtool->getXDisplay(), getWindowID());
  Basemenu::show();
}


