// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Source source
//
// swagger:model source
type Source struct {

	// address
	// Required: true
	Address *string `json:"address"`

	// address second
	AddressSecond string `json:"address_second,omitempty"`

	// hdr
	Hdr string `json:"hdr,omitempty"`

	// interface
	Interface string `json:"interface,omitempty"`

	// occ
	Occ string `json:"occ,omitempty"`

	// port
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	Port int64 `json:"port,omitempty"`

	// port second
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	PortSecond int64 `json:"port_second,omitempty"`

	// usesrc
	// Enum: ["address","client","clientip","hdr_ip"]
	// +kubebuilder:validation:Enum="address","client","clientip","hdr_ip";
	Usesrc string `json:"usesrc,omitempty"`
}

// Validate validates this source
func (m *Source) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortSecond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsesrc(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Source) validateAddress(formats strfmt.Registry) error {

	if err := validate.Required("address", "body", m.Address); err != nil {
		return err
	}

	return nil
}

func (m *Source) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("port", "body", m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", m.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *Source) validatePortSecond(formats strfmt.Registry) error {
	if swag.IsZero(m.PortSecond) { // not required
		return nil
	}

	if err := validate.MinimumInt("port_second", "body", m.PortSecond, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port_second", "body", m.PortSecond, 65535, false); err != nil {
		return err
	}

	return nil
}

var sourceTypeUsesrcPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["address","client","clientip","hdr_ip"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sourceTypeUsesrcPropEnum = append(sourceTypeUsesrcPropEnum, v)
	}
}

const (

	// SourceUsesrcAddress captures enum value "address"
	SourceUsesrcAddress string = "address"

	// SourceUsesrcClient captures enum value "client"
	SourceUsesrcClient string = "client"

	// SourceUsesrcClientip captures enum value "clientip"
	SourceUsesrcClientip string = "clientip"

	// SourceUsesrcHdrIP captures enum value "hdr_ip"
	SourceUsesrcHdrIP string = "hdr_ip"
)

// prop value enum
func (m *Source) validateUsesrcEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sourceTypeUsesrcPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Source) validateUsesrc(formats strfmt.Registry) error {
	if swag.IsZero(m.Usesrc) { // not required
		return nil
	}

	// value enum
	if err := m.validateUsesrcEnum("usesrc", "body", m.Usesrc); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this source based on context it is used
func (m *Source) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Source) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Source) UnmarshalBinary(b []byte) error {
	var res Source
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
