;;; nerd-icons-data-codicon.el --- glyphset codicon -*- lexical-binding: t -*-

;; Copyright (C) 2023 Hongyu Ding <rainstormstudio@yahoo.com>

;; Author: Hongyu Ding <rainstormstudio@yahoo.com>
;; Keywords: lisp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; codicon
;; from Nerd Font Version: 3.0.2

;;; Code:

(defvar nerd-icons/codicon-alist
  '(
    ("nf-cod-account" . "\xeb99")
    ("nf-cod-activate_breakpoints" . "\xea97")
    ("nf-cod-add" . "\xea60")
    ("nf-cod-archive" . "\xea98")
    ("nf-cod-arrow_both" . "\xea99")
    ("nf-cod-arrow_down" . "\xea9a")
    ("nf-cod-arrow_left" . "\xea9b")
    ("nf-cod-arrow_right" . "\xea9c")
    ("nf-cod-arrow_small_down" . "\xea9d")
    ("nf-cod-arrow_small_left" . "\xea9e")
    ("nf-cod-arrow_small_right" . "\xea9f")
    ("nf-cod-arrow_small_up" . "\xeaa0")
    ("nf-cod-arrow_swap" . "\xebcb")
    ("nf-cod-arrow_up" . "\xeaa1")
    ("nf-cod-azure" . "\xebd8")
    ("nf-cod-azure_devops" . "\xebe8")
    ("nf-cod-beaker" . "\xea79")
    ("nf-cod-beaker_stop" . "\xebe1")
    ("nf-cod-bell" . "\xeaa2")
    ("nf-cod-bell_dot" . "\xeb9a")
    ("nf-cod-bold" . "\xeaa3")
    ("nf-cod-book" . "\xeaa4")
    ("nf-cod-bookmark" . "\xeaa5")
    ("nf-cod-bracket_dot" . "\xebe5")
    ("nf-cod-bracket_error" . "\xebe6")
    ("nf-cod-briefcase" . "\xeaac")
    ("nf-cod-broadcast" . "\xeaad")
    ("nf-cod-browser" . "\xeaae")
    ("nf-cod-bug" . "\xeaaf")
    ("nf-cod-calendar" . "\xeab0")
    ("nf-cod-call_incoming" . "\xeb92")
    ("nf-cod-call_outgoing" . "\xeb93")
    ("nf-cod-case_sensitive" . "\xeab1")
    ("nf-cod-check" . "\xeab2")
    ("nf-cod-check_all" . "\xebb1")
    ("nf-cod-checklist" . "\xeab3")
    ("nf-cod-chevron_down" . "\xeab4")
    ("nf-cod-chevron_left" . "\xeab5")
    ("nf-cod-chevron_right" . "\xeab6")
    ("nf-cod-chevron_up" . "\xeab7")
    ("nf-cod-chrome_close" . "\xeab8")
    ("nf-cod-chrome_maximize" . "\xeab9")
    ("nf-cod-chrome_minimize" . "\xeaba")
    ("nf-cod-chrome_restore" . "\xeabb")
    ("nf-cod-circle" . "\xeabc")
    ("nf-cod-circle_filled" . "\xea71")
    ("nf-cod-circle_large" . "\xebb5")
    ("nf-cod-circle_large_filled" . "\xebb4")
    ("nf-cod-circle_slash" . "\xeabd")
    ("nf-cod-circle_small_filled" . "\xeb8a")
    ("nf-cod-circuit_board" . "\xeabe")
    ("nf-cod-clear_all" . "\xeabf")
    ("nf-cod-clippy" . "\xeac0")
    ("nf-cod-close" . "\xea76")
    ("nf-cod-close_all" . "\xeac1")
    ("nf-cod-cloud" . "\xebaa")
    ("nf-cod-cloud_download" . "\xeac2")
    ("nf-cod-cloud_upload" . "\xeac3")
    ("nf-cod-code" . "\xeac4")
    ("nf-cod-collapse_all" . "\xeac5")
    ("nf-cod-color_mode" . "\xeac6")
    ("nf-cod-combine" . "\xebb6")
    ("nf-cod-comment" . "\xea6b")
    ("nf-cod-comment_discussion" . "\xeac7")
    ("nf-cod-compass" . "\xebd5")
    ("nf-cod-compass_active" . "\xebd7")
    ("nf-cod-compass_dot" . "\xebd6")
    ("nf-cod-copy" . "\xebcc")
    ("nf-cod-credit_card" . "\xeac9")
    ("nf-cod-dash" . "\xeacc")
    ("nf-cod-dashboard" . "\xeacd")
    ("nf-cod-database" . "\xeace")
    ("nf-cod-debug" . "\xead8")
    ("nf-cod-debug_all" . "\xebdc")
    ("nf-cod-debug_alt" . "\xeb91")
    ("nf-cod-debug_alt_small" . "\xeba8")
    ("nf-cod-debug_breakpoint_conditional" . "\xeaa7")
    ("nf-cod-debug_breakpoint_conditional_unverified" . "\xeaa6")
    ("nf-cod-debug_breakpoint_data" . "\xeaa9")
    ("nf-cod-debug_breakpoint_data_unverified" . "\xeaa8")
    ("nf-cod-debug_breakpoint_function" . "\xeb88")
    ("nf-cod-debug_breakpoint_function_unverified" . "\xeb87")
    ("nf-cod-debug_breakpoint_log" . "\xeaab")
    ("nf-cod-debug_breakpoint_log_unverified" . "\xeaaa")
    ("nf-cod-debug_breakpoint_unsupported" . "\xeb8c")
    ("nf-cod-debug_console" . "\xeb9b")
    ("nf-cod-debug_continue" . "\xeacf")
    ("nf-cod-debug_continue_small" . "\xebe0")
    ("nf-cod-debug_coverage" . "\xebdd")
    ("nf-cod-debug_disconnect" . "\xead0")
    ("nf-cod-debug_line_by_line" . "\xebd0")
    ("nf-cod-debug_pause" . "\xead1")
    ("nf-cod-debug_rerun" . "\xebc0")
    ("nf-cod-debug_restart" . "\xead2")
    ("nf-cod-debug_restart_frame" . "\xeb90")
    ("nf-cod-debug_reverse_continue" . "\xeb8e")
    ("nf-cod-debug_stackframe" . "\xeb8b")
    ("nf-cod-debug_stackframe_active" . "\xeb89")
    ("nf-cod-debug_start" . "\xead3")
    ("nf-cod-debug_step_back" . "\xeb8f")
    ("nf-cod-debug_step_into" . "\xead4")
    ("nf-cod-debug_step_out" . "\xead5")
    ("nf-cod-debug_step_over" . "\xead6")
    ("nf-cod-debug_stop" . "\xead7")
    ("nf-cod-desktop_download" . "\xea78")
    ("nf-cod-device_camera" . "\xeada")
    ("nf-cod-device_camera_video" . "\xead9")
    ("nf-cod-device_mobile" . "\xeadb")
    ("nf-cod-diff" . "\xeae1")
    ("nf-cod-diff_added" . "\xeadc")
    ("nf-cod-diff_ignored" . "\xeadd")
    ("nf-cod-diff_modified" . "\xeade")
    ("nf-cod-diff_removed" . "\xeadf")
    ("nf-cod-diff_renamed" . "\xeae0")
    ("nf-cod-discard" . "\xeae2")
    ("nf-cod-edit" . "\xea73")
    ("nf-cod-editor_layout" . "\xeae3")
    ("nf-cod-ellipsis" . "\xea7c")
    ("nf-cod-empty_window" . "\xeae4")
    ("nf-cod-error" . "\xea87")
    ("nf-cod-exclude" . "\xeae5")
    ("nf-cod-expand_all" . "\xeb95")
    ("nf-cod-export" . "\xebac")
    ("nf-cod-extensions" . "\xeae6")
    ("nf-cod-eye" . "\xea70")
    ("nf-cod-eye_closed" . "\xeae7")
    ("nf-cod-feedback" . "\xeb96")
    ("nf-cod-file" . "\xea7b")
    ("nf-cod-file_binary" . "\xeae8")
    ("nf-cod-file_code" . "\xeae9")
    ("nf-cod-file_media" . "\xeaea")
    ("nf-cod-file_pdf" . "\xeaeb")
    ("nf-cod-file_submodule" . "\xeaec")
    ("nf-cod-file_symlink_directory" . "\xeaed")
    ("nf-cod-file_symlink_file" . "\xeaee")
    ("nf-cod-file_zip" . "\xeaef")
    ("nf-cod-files" . "\xeaf0")
    ("nf-cod-filter" . "\xeaf1")
    ("nf-cod-filter_filled" . "\xebce")
    ("nf-cod-flame" . "\xeaf2")
    ("nf-cod-fold" . "\xeaf5")
    ("nf-cod-fold_down" . "\xeaf3")
    ("nf-cod-fold_up" . "\xeaf4")
    ("nf-cod-folder" . "\xea83")
    ("nf-cod-folder_active" . "\xeaf6")
    ("nf-cod-folder_library" . "\xebdf")
    ("nf-cod-folder_opened" . "\xeaf7")
    ("nf-cod-gear" . "\xeaf8")
    ("nf-cod-gift" . "\xeaf9")
    ("nf-cod-gist_secret" . "\xeafa")
    ("nf-cod-git_commit" . "\xeafc")
    ("nf-cod-git_compare" . "\xeafd")
    ("nf-cod-git_merge" . "\xeafe")
    ("nf-cod-git_pull_request" . "\xea64")
    ("nf-cod-git_pull_request_closed" . "\xebda")
    ("nf-cod-git_pull_request_create" . "\xebbc")
    ("nf-cod-git_pull_request_draft" . "\xebdb")
    ("nf-cod-github" . "\xea84")
    ("nf-cod-github_action" . "\xeaff")
    ("nf-cod-github_alt" . "\xeb00")
    ("nf-cod-github_inverted" . "\xeba1")
    ("nf-cod-globe" . "\xeb01")
    ("nf-cod-go_to_file" . "\xea94")
    ("nf-cod-grabber" . "\xeb02")
    ("nf-cod-graph" . "\xeb03")
    ("nf-cod-graph_left" . "\xebad")
    ("nf-cod-graph_line" . "\xebe2")
    ("nf-cod-graph_scatter" . "\xebe3")
    ("nf-cod-gripper" . "\xeb04")
    ("nf-cod-group_by_ref_type" . "\xeb97")
    ("nf-cod-heart" . "\xeb05")
    ("nf-cod-history" . "\xea82")
    ("nf-cod-home" . "\xeb06")
    ("nf-cod-horizontal_rule" . "\xeb07")
    ("nf-cod-hubot" . "\xeb08")
    ("nf-cod-inbox" . "\xeb09")
    ("nf-cod-info" . "\xea74")
    ("nf-cod-inspect" . "\xebd1")
    ("nf-cod-issue_draft" . "\xebd9")
    ("nf-cod-issue_reopened" . "\xeb0b")
    ("nf-cod-issues" . "\xeb0c")
    ("nf-cod-italic" . "\xeb0d")
    ("nf-cod-jersey" . "\xeb0e")
    ("nf-cod-json" . "\xeb0f")
    ("nf-cod-kebab_vertical" . "\xeb10")
    ("nf-cod-key" . "\xeb11")
    ("nf-cod-law" . "\xeb12")
    ("nf-cod-layers" . "\xebd2")
    ("nf-cod-layers_active" . "\xebd4")
    ("nf-cod-layers_dot" . "\xebd3")
    ("nf-cod-layout" . "\xebeb")
    ("nf-cod-library" . "\xeb9c")
    ("nf-cod-lightbulb" . "\xea61")
    ("nf-cod-lightbulb_autofix" . "\xeb13")
    ("nf-cod-link" . "\xeb15")
    ("nf-cod-link_external" . "\xeb14")
    ("nf-cod-list_filter" . "\xeb83")
    ("nf-cod-list_flat" . "\xeb84")
    ("nf-cod-list_ordered" . "\xeb16")
    ("nf-cod-list_selection" . "\xeb85")
    ("nf-cod-list_tree" . "\xeb86")
    ("nf-cod-list_unordered" . "\xeb17")
    ("nf-cod-live_share" . "\xeb18")
    ("nf-cod-loading" . "\xeb19")
    ("nf-cod-location" . "\xeb1a")
    ("nf-cod-lock" . "\xea75")
    ("nf-cod-lock_small" . "\xebe7")
    ("nf-cod-magnet" . "\xebae")
    ("nf-cod-mail" . "\xeb1c")
    ("nf-cod-mail_read" . "\xeb1b")
    ("nf-cod-markdown" . "\xeb1d")
    ("nf-cod-megaphone" . "\xeb1e")
    ("nf-cod-mention" . "\xeb1f")
    ("nf-cod-menu" . "\xeb94")
    ("nf-cod-merge" . "\xebab")
    ("nf-cod-milestone" . "\xeb20")
    ("nf-cod-mirror" . "\xea69")
    ("nf-cod-mortar_board" . "\xeb21")
    ("nf-cod-move" . "\xeb22")
    ("nf-cod-multiple_windows" . "\xeb23")
    ("nf-cod-mute" . "\xeb24")
    ("nf-cod-new_file" . "\xea7f")
    ("nf-cod-new_folder" . "\xea80")
    ("nf-cod-newline" . "\xebea")
    ("nf-cod-no_newline" . "\xeb25")
    ("nf-cod-note" . "\xeb26")
    ("nf-cod-notebook" . "\xebaf")
    ("nf-cod-notebook_template" . "\xebbf")
    ("nf-cod-octoface" . "\xeb27")
    ("nf-cod-open_preview" . "\xeb28")
    ("nf-cod-organization" . "\xea7e")
    ("nf-cod-output" . "\xeb9d")
    ("nf-cod-package" . "\xeb29")
    ("nf-cod-paintcan" . "\xeb2a")
    ("nf-cod-pass" . "\xeba4")
    ("nf-cod-pass_filled" . "\xebb3")
    ("nf-cod-person" . "\xea67")
    ("nf-cod-person_add" . "\xebcd")
    ("nf-cod-pie_chart" . "\xebe4")
    ("nf-cod-pin" . "\xeb2b")
    ("nf-cod-pinned" . "\xeba0")
    ("nf-cod-pinned_dirty" . "\xebb2")
    ("nf-cod-play" . "\xeb2c")
    ("nf-cod-play_circle" . "\xeba6")
    ("nf-cod-plug" . "\xeb2d")
    ("nf-cod-preserve_case" . "\xeb2e")
    ("nf-cod-preview" . "\xeb2f")
    ("nf-cod-primitive_square" . "\xea72")
    ("nf-cod-project" . "\xeb30")
    ("nf-cod-pulse" . "\xeb31")
    ("nf-cod-question" . "\xeb32")
    ("nf-cod-quote" . "\xeb33")
    ("nf-cod-radio_tower" . "\xeb34")
    ("nf-cod-reactions" . "\xeb35")
    ("nf-cod-record" . "\xeba7")
    ("nf-cod-record_keys" . "\xea65")
    ("nf-cod-redo" . "\xebb0")
    ("nf-cod-references" . "\xeb36")
    ("nf-cod-refresh" . "\xeb37")
    ("nf-cod-regex" . "\xeb38")
    ("nf-cod-remote" . "\xeb3a")
    ("nf-cod-remote_explorer" . "\xeb39")
    ("nf-cod-remove" . "\xeb3b")
    ("nf-cod-replace" . "\xeb3d")
    ("nf-cod-replace_all" . "\xeb3c")
    ("nf-cod-reply" . "\xea7d")
    ("nf-cod-repo" . "\xea62")
    ("nf-cod-repo_clone" . "\xeb3e")
    ("nf-cod-repo_force_push" . "\xeb3f")
    ("nf-cod-repo_forked" . "\xea63")
    ("nf-cod-repo_pull" . "\xeb40")
    ("nf-cod-repo_push" . "\xeb41")
    ("nf-cod-report" . "\xeb42")
    ("nf-cod-request_changes" . "\xeb43")
    ("nf-cod-rocket" . "\xeb44")
    ("nf-cod-root_folder" . "\xeb46")
    ("nf-cod-root_folder_opened" . "\xeb45")
    ("nf-cod-rss" . "\xeb47")
    ("nf-cod-ruby" . "\xeb48")
    ("nf-cod-run_above" . "\xebbd")
    ("nf-cod-run_all" . "\xeb9e")
    ("nf-cod-run_below" . "\xebbe")
    ("nf-cod-run_errors" . "\xebde")
    ("nf-cod-save" . "\xeb4b")
    ("nf-cod-save_all" . "\xeb49")
    ("nf-cod-save_as" . "\xeb4a")
    ("nf-cod-screen_full" . "\xeb4c")
    ("nf-cod-screen_normal" . "\xeb4d")
    ("nf-cod-search" . "\xea6d")
    ("nf-cod-search_stop" . "\xeb4e")
    ("nf-cod-server" . "\xeb50")
    ("nf-cod-server_environment" . "\xeba3")
    ("nf-cod-server_process" . "\xeba2")
    ("nf-cod-settings" . "\xeb52")
    ("nf-cod-settings_gear" . "\xeb51")
    ("nf-cod-shield" . "\xeb53")
    ("nf-cod-sign_in" . "\xea6f")
    ("nf-cod-sign_out" . "\xea6e")
    ("nf-cod-smiley" . "\xeb54")
    ("nf-cod-sort_precedence" . "\xeb55")
    ("nf-cod-source_control" . "\xea68")
    ("nf-cod-split_horizontal" . "\xeb56")
    ("nf-cod-split_vertical" . "\xeb57")
    ("nf-cod-squirrel" . "\xeb58")
    ("nf-cod-star_empty" . "\xea6a")
    ("nf-cod-star_full" . "\xeb59")
    ("nf-cod-star_half" . "\xeb5a")
    ("nf-cod-stop_circle" . "\xeba5")
    ("nf-cod-symbol_array" . "\xea8a")
    ("nf-cod-symbol_boolean" . "\xea8f")
    ("nf-cod-symbol_class" . "\xeb5b")
    ("nf-cod-symbol_color" . "\xeb5c")
    ("nf-cod-symbol_constant" . "\xeb5d")
    ("nf-cod-symbol_enum" . "\xea95")
    ("nf-cod-symbol_enum_member" . "\xeb5e")
    ("nf-cod-symbol_event" . "\xea86")
    ("nf-cod-symbol_field" . "\xeb5f")
    ("nf-cod-symbol_file" . "\xeb60")
    ("nf-cod-symbol_interface" . "\xeb61")
    ("nf-cod-symbol_key" . "\xea93")
    ("nf-cod-symbol_keyword" . "\xeb62")
    ("nf-cod-symbol_method" . "\xea8c")
    ("nf-cod-symbol_misc" . "\xeb63")
    ("nf-cod-symbol_namespace" . "\xea8b")
    ("nf-cod-symbol_numeric" . "\xea90")
    ("nf-cod-symbol_operator" . "\xeb64")
    ("nf-cod-symbol_parameter" . "\xea92")
    ("nf-cod-symbol_property" . "\xeb65")
    ("nf-cod-symbol_ruler" . "\xea96")
    ("nf-cod-symbol_snippet" . "\xeb66")
    ("nf-cod-symbol_string" . "\xeb8d")
    ("nf-cod-symbol_structure" . "\xea91")
    ("nf-cod-symbol_variable" . "\xea88")
    ("nf-cod-sync" . "\xea77")
    ("nf-cod-sync_ignored" . "\xeb9f")
    ("nf-cod-table" . "\xebb7")
    ("nf-cod-tag" . "\xea66")
    ("nf-cod-tasklist" . "\xeb67")
    ("nf-cod-telescope" . "\xeb68")
    ("nf-cod-terminal" . "\xea85")
    ("nf-cod-terminal_bash" . "\xebca")
    ("nf-cod-terminal_cmd" . "\xebc4")
    ("nf-cod-terminal_debian" . "\xebc5")
    ("nf-cod-terminal_linux" . "\xebc6")
    ("nf-cod-terminal_powershell" . "\xebc7")
    ("nf-cod-terminal_tmux" . "\xebc8")
    ("nf-cod-terminal_ubuntu" . "\xebc9")
    ("nf-cod-text_size" . "\xeb69")
    ("nf-cod-three_bars" . "\xeb6a")
    ("nf-cod-thumbsdown" . "\xeb6b")
    ("nf-cod-thumbsup" . "\xeb6c")
    ("nf-cod-tools" . "\xeb6d")
    ("nf-cod-trash" . "\xea81")
    ("nf-cod-triangle_down" . "\xeb6e")
    ("nf-cod-triangle_left" . "\xeb6f")
    ("nf-cod-triangle_right" . "\xeb70")
    ("nf-cod-triangle_up" . "\xeb71")
    ("nf-cod-twitter" . "\xeb72")
    ("nf-cod-type_hierarchy" . "\xebb9")
    ("nf-cod-type_hierarchy_sub" . "\xebba")
    ("nf-cod-type_hierarchy_super" . "\xebbb")
    ("nf-cod-unfold" . "\xeb73")
    ("nf-cod-ungroup_by_ref_type" . "\xeb98")
    ("nf-cod-unlock" . "\xeb74")
    ("nf-cod-unmute" . "\xeb75")
    ("nf-cod-unverified" . "\xeb76")
    ("nf-cod-variable_group" . "\xebb8")
    ("nf-cod-verified" . "\xeb77")
    ("nf-cod-verified_filled" . "\xebe9")
    ("nf-cod-versions" . "\xeb78")
    ("nf-cod-vm" . "\xea7a")
    ("nf-cod-vm_active" . "\xeb79")
    ("nf-cod-vm_connect" . "\xeba9")
    ("nf-cod-vm_outline" . "\xeb7a")
    ("nf-cod-vm_running" . "\xeb7b")
    ("nf-cod-wand" . "\xebcf")
    ("nf-cod-warning" . "\xea6c")
    ("nf-cod-watch" . "\xeb7c")
    ("nf-cod-whitespace" . "\xeb7d")
    ("nf-cod-whole_word" . "\xeb7e")
    ("nf-cod-window" . "\xeb7f")
    ("nf-cod-word_wrap" . "\xeb80")
    ("nf-cod-workspace_trusted" . "\xebc1")
    ("nf-cod-workspace_unknown" . "\xebc3")
    ("nf-cod-workspace_untrusted" . "\xebc2")
    ("nf-cod-zoom_in" . "\xeb81")
    ("nf-cod-zoom_out" . "\xeb82")
    ))

(provide 'nerd-icons-data-codicon)
;;; nerd-icons-data-codicon.el ends here