// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package vault provides access to the G Suite Vault API.
//
// For product documentation, see: https://developers.google.com/vault
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/vault/v1"
//   ...
//   ctx := context.Background()
//   vaultService, err := vault.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   vaultService, err := vault.NewService(ctx, option.WithScopes(vault.EdiscoveryReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   vaultService, err := vault.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   vaultService, err := vault.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package vault // import "google.golang.org/api/vault/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "vault:v1"
const apiName = "vault"
const apiVersion = "v1"
const basePath = "https://vault.googleapis.com/"
const mtlsBasePath = "https://vault.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage your eDiscovery data
	EdiscoveryScope = "https://www.googleapis.com/auth/ediscovery"

	// View your eDiscovery data
	EdiscoveryReadonlyScope = "https://www.googleapis.com/auth/ediscovery.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/ediscovery",
		"https://www.googleapis.com/auth/ediscovery.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Matters = NewMattersService(s)
	s.Operations = NewOperationsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Matters *MattersService

	Operations *OperationsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewMattersService(s *Service) *MattersService {
	rs := &MattersService{s: s}
	rs.Exports = NewMattersExportsService(s)
	rs.Holds = NewMattersHoldsService(s)
	rs.SavedQueries = NewMattersSavedQueriesService(s)
	return rs
}

type MattersService struct {
	s *Service

	Exports *MattersExportsService

	Holds *MattersHoldsService

	SavedQueries *MattersSavedQueriesService
}

func NewMattersExportsService(s *Service) *MattersExportsService {
	rs := &MattersExportsService{s: s}
	return rs
}

type MattersExportsService struct {
	s *Service
}

func NewMattersHoldsService(s *Service) *MattersHoldsService {
	rs := &MattersHoldsService{s: s}
	rs.Accounts = NewMattersHoldsAccountsService(s)
	return rs
}

type MattersHoldsService struct {
	s *Service

	Accounts *MattersHoldsAccountsService
}

func NewMattersHoldsAccountsService(s *Service) *MattersHoldsAccountsService {
	rs := &MattersHoldsAccountsService{s: s}
	return rs
}

type MattersHoldsAccountsService struct {
	s *Service
}

func NewMattersSavedQueriesService(s *Service) *MattersSavedQueriesService {
	rs := &MattersSavedQueriesService{s: s}
	return rs
}

type MattersSavedQueriesService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

// AccountCount: Count number for each account.
type AccountCount struct {
	// Account: Account owner.
	Account *UserInfo `json:"account,omitempty"`

	// Count: The number of artifacts found for this account.
	Count int64 `json:"count,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountCount) MarshalJSON() ([]byte, error) {
	type NoMethod AccountCount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountCountError: An error that occurred when querying a specific
// account
type AccountCountError struct {
	// Account: Account owner.
	Account *UserInfo `json:"account,omitempty"`

	// ErrorType: Account query error.
	//
	// Possible values:
	//   "ERROR_TYPE_UNSPECIFIED" - Default.
	//   "WILDCARD_TOO_BROAD" - Permanent - prefix terms expanded to too
	// many query terms.
	//   "TOO_MANY_TERMS" - Permanent - query contains too many terms.
	//   "LOCATION_UNAVAILABLE" - Transient - data in transit between
	// storage replicas, temporarily unavailable.
	//   "UNKNOWN" - Unrecognized error.
	//   "DEADLINE_EXCEEDED" - Deadline exceeded when querying the account.
	ErrorType string `json:"errorType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountCountError) MarshalJSON() ([]byte, error) {
	type NoMethod AccountCountError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccountInfo: Accounts to search
type AccountInfo struct {
	// Emails: A set of accounts to search.
	Emails []string `json:"emails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Emails") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Emails") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccountInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AccountInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddHeldAccountResult: A status detailing the status of each account
// creation, and the HeldAccount, if successful.
type AddHeldAccountResult struct {
	// Account: If present, this account was successfully created.
	Account *HeldAccount `json:"account,omitempty"`

	// Status: This represents the success status. If failed, check message.
	Status *Status `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddHeldAccountResult) MarshalJSON() ([]byte, error) {
	type NoMethod AddHeldAccountResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddHeldAccountsRequest: Add a list of accounts to a hold.
type AddHeldAccountsRequest struct {
	// AccountIds: Account IDs to identify which accounts to add. Only
	// account_ids or only emails should be specified, but not both.
	AccountIds []string `json:"accountIds,omitempty"`

	// Emails: Emails to identify which accounts to add. Only emails or only
	// account_ids should be specified, but not both.
	Emails []string `json:"emails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountIds") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddHeldAccountsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddHeldAccountsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddHeldAccountsResponse: Response for batch create held accounts.
type AddHeldAccountsResponse struct {
	// Responses: The list of responses, in the same order as the batch
	// request.
	Responses []*AddHeldAccountResult `json:"responses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Responses") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Responses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddHeldAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AddHeldAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddMatterPermissionsRequest: Add an account with the permission
// specified. The role cannot be owner. If an account already has a role
// in the matter, it will be overwritten.
type AddMatterPermissionsRequest struct {
	// CcMe: Only relevant if send_emails is true. True to CC requestor in
	// the email message. False to not CC requestor.
	CcMe bool `json:"ccMe,omitempty"`

	// MatterPermission: The MatterPermission to add.
	MatterPermission *MatterPermission `json:"matterPermission,omitempty"`

	// SendEmails: True to send notification email to the added account.
	// False to not send notification email.
	SendEmails bool `json:"sendEmails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CcMe") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CcMe") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddMatterPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddMatterPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for
// Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CloseMatterRequest: Close a matter by ID.
type CloseMatterRequest struct {
}

// CloseMatterResponse: Response to a CloseMatterRequest.
type CloseMatterResponse struct {
	// Matter: The updated matter, with state CLOSED.
	Matter *Matter `json:"matter,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Matter") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Matter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloseMatterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloseMatterResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudStorageFile: An export file on cloud storage
type CloudStorageFile struct {
	// BucketName: The cloud storage bucket name of this export file. Can be
	// used in cloud storage JSON/XML API, but not to list the bucket
	// contents. Instead, you can get individual export files by object
	// name.
	BucketName string `json:"bucketName,omitempty"`

	// Md5Hash: The md5 hash of the file.
	Md5Hash string `json:"md5Hash,omitempty"`

	// ObjectName: The cloud storage object name of this export file. Can be
	// used in cloud storage JSON/XML API.
	ObjectName string `json:"objectName,omitempty"`

	// Size: The size of the export file.
	Size int64 `json:"size,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BucketName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudStorageFile) MarshalJSON() ([]byte, error) {
	type NoMethod CloudStorageFile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloudStorageSink: Export sink for cloud storage files.
type CloudStorageSink struct {
	// Files: Output only. The exported files on cloud storage.
	Files []*CloudStorageFile `json:"files,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Files") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Files") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CloudStorageSink) MarshalJSON() ([]byte, error) {
	type NoMethod CloudStorageSink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CorpusQuery: Corpus specific queries.
type CorpusQuery struct {
	// DriveQuery: Details pertaining to Drive holds. If set, corpus must be
	// Drive.
	DriveQuery *HeldDriveQuery `json:"driveQuery,omitempty"`

	// GroupsQuery: Details pertaining to Groups holds. If set, corpus must
	// be Groups.
	GroupsQuery *HeldGroupsQuery `json:"groupsQuery,omitempty"`

	// HangoutsChatQuery: Details pertaining to Hangouts Chat holds. If set,
	// corpus must be Hangouts Chat.
	HangoutsChatQuery *HeldHangoutsChatQuery `json:"hangoutsChatQuery,omitempty"`

	// MailQuery: Details pertaining to mail holds. If set, corpus must be
	// mail.
	MailQuery *HeldMailQuery `json:"mailQuery,omitempty"`

	// VoiceQuery: Details pertaining to Voice holds. If set, corpus must be
	// Voice.
	VoiceQuery *HeldVoiceQuery `json:"voiceQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DriveQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DriveQuery") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CorpusQuery) MarshalJSON() ([]byte, error) {
	type NoMethod CorpusQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CountArtifactsMetadata: Long running operation metadata for
// CountArtifacts.
type CountArtifactsMetadata struct {
	// EndTime: End time of count operation. Available when operation is
	// done.
	EndTime string `json:"endTime,omitempty"`

	// MatterId: The matter ID of the associated matter.
	MatterId string `json:"matterId,omitempty"`

	// Query: The search query from the request.
	Query *Query `json:"query,omitempty"`

	// StartTime: Creation time of count operation.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CountArtifactsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CountArtifactsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CountArtifactsRequest: Count artifacts request.
type CountArtifactsRequest struct {
	// Query: The search query.
	Query *Query `json:"query,omitempty"`

	// View: Specifies the granularity of the count result returned in
	// response.
	//
	// Possible values:
	//   "COUNT_RESULT_VIEW_UNSPECIFIED" - Default. It works the same as
	// TOTAL_COUNT.
	//   "TOTAL_COUNT" - Response includes: total count, queried accounts
	// count, matching accounts count, non-queryable accounts, queried
	// account errors.
	//   "ALL" - Response includes additional breakdown of account count.
	View string `json:"view,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Query") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CountArtifactsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CountArtifactsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CountArtifactsResponse: Definition of the response for method
// CountArtifacts.
type CountArtifactsResponse struct {
	// GroupsCountResult: Count metrics of Groups.
	GroupsCountResult *GroupsCountResult `json:"groupsCountResult,omitempty"`

	// MailCountResult: Count metrics of Mail.
	MailCountResult *MailCountResult `json:"mailCountResult,omitempty"`

	// TotalCount: Total count of artifacts. For mail and groups, artifacts
	// refers to messages.
	TotalCount int64 `json:"totalCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "GroupsCountResult")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupsCountResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CountArtifactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CountArtifactsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveExportOptions: The options for Drive export.
type DriveExportOptions struct {
	// IncludeAccessInfo: Set to true to include access level information
	// for users with indirect access to files.
	IncludeAccessInfo bool `json:"includeAccessInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeAccessInfo")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeAccessInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DriveExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DriveExportOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DriveOptions: Drive search advanced options
type DriveOptions struct {
	// IncludeSharedDrives: Set to true to include shared drive.
	IncludeSharedDrives bool `json:"includeSharedDrives,omitempty"`

	// IncludeTeamDrives: Set to true to include Team Drive.
	IncludeTeamDrives bool `json:"includeTeamDrives,omitempty"`

	// VersionDate: Search the versions of the Drive file as of the
	// reference date. These timestamps are in GMT and rounded down to the
	// given date.
	VersionDate string `json:"versionDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeSharedDrives")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeSharedDrives") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DriveOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DriveOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); } The JSON representation for `Empty` is
// empty JSON object `{}`.
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// Export: An export
type Export struct {
	// CloudStorageSink: Output only. Export sink for cloud storage files.
	CloudStorageSink *CloudStorageSink `json:"cloudStorageSink,omitempty"`

	// CreateTime: Output only. The time when the export was created.
	CreateTime string `json:"createTime,omitempty"`

	// ExportOptions: Advanced options of the export.
	ExportOptions *ExportOptions `json:"exportOptions,omitempty"`

	// Id: Output only. The generated export ID.
	Id string `json:"id,omitempty"`

	// MatterId: Output only. The matter ID.
	MatterId string `json:"matterId,omitempty"`

	// Name: The export name.
	Name string `json:"name,omitempty"`

	// Query: The search query being exported.
	Query *Query `json:"query,omitempty"`

	// Requester: Output only. The requester of the export.
	Requester *UserInfo `json:"requester,omitempty"`

	// Stats: Output only. Export statistics.
	Stats *ExportStats `json:"stats,omitempty"`

	// Status: Output only. The export status.
	//
	// Possible values:
	//   "EXPORT_STATUS_UNSPECIFIED" - The status is unspecified.
	//   "COMPLETED" - The export completed.
	//   "FAILED" - The export failed.
	//   "IN_PROGRESS" - The export is still being executed.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CloudStorageSink") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudStorageSink") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Export) MarshalJSON() ([]byte, error) {
	type NoMethod Export
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExportOptions: Export advanced options
type ExportOptions struct {
	// DriveOptions: Option available for Drive export.
	DriveOptions *DriveExportOptions `json:"driveOptions,omitempty"`

	// GroupsOptions: Option available for groups export.
	GroupsOptions *GroupsExportOptions `json:"groupsOptions,omitempty"`

	// HangoutsChatOptions: Option available for hangouts chat export.
	HangoutsChatOptions *HangoutsChatExportOptions `json:"hangoutsChatOptions,omitempty"`

	// MailOptions: Option available for mail export.
	MailOptions *MailExportOptions `json:"mailOptions,omitempty"`

	// Region: The requested export location.
	//
	// Possible values:
	//   "EXPORT_REGION_UNSPECIFIED" - The region is unspecified. Will be
	// treated the same as ANY.
	//   "ANY" - Any region.
	//   "US" - US region.
	//   "EUROPE" - Europe region.
	Region string `json:"region,omitempty"`

	// VoiceOptions: Option available for voice export.
	VoiceOptions *VoiceExportOptions `json:"voiceOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DriveOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DriveOptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExportStats: Stats of an export.
type ExportStats struct {
	// ExportedArtifactCount: The number of documents already processed by
	// the export.
	ExportedArtifactCount int64 `json:"exportedArtifactCount,omitempty,string"`

	// SizeInBytes: The size of export in bytes.
	SizeInBytes int64 `json:"sizeInBytes,omitempty,string"`

	// TotalArtifactCount: The number of documents to be exported.
	TotalArtifactCount int64 `json:"totalArtifactCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "ExportedArtifactCount") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportedArtifactCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExportStats) MarshalJSON() ([]byte, error) {
	type NoMethod ExportStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupsCountResult: Groups specific count metrics.
type GroupsCountResult struct {
	// AccountCountErrors: Error occurred when querying these accounts.
	AccountCountErrors []*AccountCountError `json:"accountCountErrors,omitempty"`

	// AccountCounts: Subtotal count per matching account that have more
	// than zero messages.
	AccountCounts []*AccountCount `json:"accountCounts,omitempty"`

	// MatchingAccountsCount: Total number of accounts that can be queried
	// and have more than zero messages.
	MatchingAccountsCount int64 `json:"matchingAccountsCount,omitempty,string"`

	// NonQueryableAccounts: When data scope is HELD_DATA in the request
	// Query, these accounts in the request are not queried because they are
	// not on hold. For other data scope, this field is not set.
	NonQueryableAccounts []string `json:"nonQueryableAccounts,omitempty"`

	// QueriedAccountsCount: Total number of accounts involved in this count
	// operation.
	QueriedAccountsCount int64 `json:"queriedAccountsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AccountCountErrors")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountCountErrors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GroupsCountResult) MarshalJSON() ([]byte, error) {
	type NoMethod GroupsCountResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupsExportOptions: The options for groups export.
type GroupsExportOptions struct {
	// ExportFormat: The export format for groups export.
	//
	// Possible values:
	//   "EXPORT_FORMAT_UNSPECIFIED" - No export format specified.
	//   "MBOX" - MBOX as export format.
	//   "PST" - PST as export format
	ExportFormat string `json:"exportFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExportFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportFormat") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GroupsExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GroupsExportOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HangoutsChatExportOptions: The options for hangouts chat export.
type HangoutsChatExportOptions struct {
	// ExportFormat: The export format for hangouts chat export.
	//
	// Possible values:
	//   "EXPORT_FORMAT_UNSPECIFIED" - No export format specified.
	//   "MBOX" - MBOX as export format.
	//   "PST" - PST as export format
	ExportFormat string `json:"exportFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExportFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportFormat") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HangoutsChatExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod HangoutsChatExportOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HangoutsChatInfo: Accounts to search
type HangoutsChatInfo struct {
	// RoomId: A set of rooms to search.
	RoomId []string `json:"roomId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RoomId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RoomId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HangoutsChatInfo) MarshalJSON() ([]byte, error) {
	type NoMethod HangoutsChatInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HangoutsChatOptions: Hangouts chat search advanced options
type HangoutsChatOptions struct {
	// IncludeRooms: Set to true to include rooms.
	IncludeRooms bool `json:"includeRooms,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeRooms") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeRooms") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HangoutsChatOptions) MarshalJSON() ([]byte, error) {
	type NoMethod HangoutsChatOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldAccount: An account being held in a particular hold. This
// structure is immutable. This can be either a single user or a google
// group, depending on the corpus.
type HeldAccount struct {
	// AccountId: The account's ID as provided by the Admin SDK.
	AccountId string `json:"accountId,omitempty"`

	// Email: The primary email address of the account. If used as an input,
	// this takes precedence over account ID.
	Email string `json:"email,omitempty"`

	// FirstName: Output only. The first name of the account holder.
	FirstName string `json:"firstName,omitempty"`

	// HoldTime: Output only. When the account was put on hold.
	HoldTime string `json:"holdTime,omitempty"`

	// LastName: Output only. The last name of the account holder.
	LastName string `json:"lastName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HeldAccount) MarshalJSON() ([]byte, error) {
	type NoMethod HeldAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldDriveQuery: Query options for Drive holds.
type HeldDriveQuery struct {
	// IncludeSharedDriveFiles: If true, include files in shared drives in
	// the hold.
	IncludeSharedDriveFiles bool `json:"includeSharedDriveFiles,omitempty"`

	// IncludeTeamDriveFiles: If true, include files in Team Drives in the
	// hold.
	IncludeTeamDriveFiles bool `json:"includeTeamDriveFiles,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IncludeSharedDriveFiles") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeSharedDriveFiles")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HeldDriveQuery) MarshalJSON() ([]byte, error) {
	type NoMethod HeldDriveQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldGroupsQuery: Query options for group holds.
type HeldGroupsQuery struct {
	// EndTime: The end time range for the search query. These timestamps
	// are in GMT and rounded down to the start of the given date.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: The start time range for the search query. These
	// timestamps are in GMT and rounded down to the start of the given
	// date.
	StartTime string `json:"startTime,omitempty"`

	// Terms: The search terms for the hold.
	Terms string `json:"terms,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HeldGroupsQuery) MarshalJSON() ([]byte, error) {
	type NoMethod HeldGroupsQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldHangoutsChatQuery: Query options for hangouts chat holds.
type HeldHangoutsChatQuery struct {
	// IncludeRooms: If true, include rooms the user has participated in.
	IncludeRooms bool `json:"includeRooms,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeRooms") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeRooms") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HeldHangoutsChatQuery) MarshalJSON() ([]byte, error) {
	type NoMethod HeldHangoutsChatQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldMailQuery: Query options for mail holds.
type HeldMailQuery struct {
	// EndTime: The end time range for the search query. These timestamps
	// are in GMT and rounded down to the start of the given date.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: The start time range for the search query. These
	// timestamps are in GMT and rounded down to the start of the given
	// date.
	StartTime string `json:"startTime,omitempty"`

	// Terms: The search terms for the hold.
	Terms string `json:"terms,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HeldMailQuery) MarshalJSON() ([]byte, error) {
	type NoMethod HeldMailQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldOrgUnit: A organizational unit being held in a particular hold.
// This structure is immutable.
type HeldOrgUnit struct {
	// HoldTime: When the org unit was put on hold. This property is
	// immutable.
	HoldTime string `json:"holdTime,omitempty"`

	// OrgUnitId: The org unit's immutable ID as provided by the Admin SDK.
	OrgUnitId string `json:"orgUnitId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HoldTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HoldTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HeldOrgUnit) MarshalJSON() ([]byte, error) {
	type NoMethod HeldOrgUnit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HeldVoiceQuery: Query options for Voice holds.
type HeldVoiceQuery struct {
	// CoveredData: Data covered by this rule. Should be non-empty. Order
	// does not matter and duplicates will be ignored.
	//
	// Possible values:
	//   "COVERED_DATA_UNSPECIFIED" - Covered data unspecified.
	//   "TEXT_MESSAGES" - Voice text message will be covered.
	//   "VOICEMAILS" - Voicemail will be covered.
	//   "CALL_LOGS" - Call logs will be covered.
	CoveredData []string `json:"coveredData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoveredData") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoveredData") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HeldVoiceQuery) MarshalJSON() ([]byte, error) {
	type NoMethod HeldVoiceQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Hold: Represents a hold within Vault. A hold restricts purging of
// artifacts based on the combination of the query and accounts
// restrictions. A hold can be configured to either apply to an
// explicitly configured set of accounts, or can be applied to all
// members of an organizational unit.
type Hold struct {
	// Accounts: If set, the hold applies to the enumerated accounts and
	// org_unit must be empty.
	Accounts []*HeldAccount `json:"accounts,omitempty"`

	// Corpus: The corpus to be searched.
	//
	// Possible values:
	//   "CORPUS_TYPE_UNSPECIFIED" - No corpus specified.
	//   "DRIVE" - Drive.
	//   "MAIL" - Mail.
	//   "GROUPS" - Groups.
	//   "HANGOUTS_CHAT" - Hangouts Chat.
	//   "VOICE" - Google Voice.
	Corpus string `json:"corpus,omitempty"`

	// HoldId: The unique immutable ID of the hold. Assigned during
	// creation.
	HoldId string `json:"holdId,omitempty"`

	// Name: The name of the hold.
	Name string `json:"name,omitempty"`

	// OrgUnit: If set, the hold applies to all members of the
	// organizational unit and accounts must be empty. This property is
	// mutable. For groups holds, set the accounts field.
	OrgUnit *HeldOrgUnit `json:"orgUnit,omitempty"`

	// Query: The corpus-specific query. If set, the corpusQuery must match
	// corpus type.
	Query *CorpusQuery `json:"query,omitempty"`

	// UpdateTime: The last time this hold was modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Hold) MarshalJSON() ([]byte, error) {
	type NoMethod Hold
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListExportsResponse: The holds for a matter.
type ListExportsResponse struct {
	// Exports: The list of exports.
	Exports []*Export `json:"exports,omitempty"`

	// NextPageToken: Page token to retrieve the next page of results in the
	// list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Exports") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Exports") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListExportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListHeldAccountsResponse: Returns a list of held accounts for a hold.
type ListHeldAccountsResponse struct {
	// Accounts: The held accounts on a hold.
	Accounts []*HeldAccount `json:"accounts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListHeldAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListHeldAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListHoldsResponse: The holds for a matter.
type ListHoldsResponse struct {
	// Holds: The list of holds.
	Holds []*Hold `json:"holds,omitempty"`

	// NextPageToken: Page token to retrieve the next page of results in the
	// list. If this is empty, then there are no more holds to list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Holds") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Holds") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListHoldsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListHoldsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListMattersResponse: Provides the list of matters.
type ListMattersResponse struct {
	// Matters: List of matters.
	Matters []*Matter `json:"matters,omitempty"`

	// NextPageToken: Page token to retrieve the next page of results in the
	// list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Matters") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Matters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListMattersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMattersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for
// Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListSavedQueriesResponse: Definition of the response for method
// ListSaveQuery.
type ListSavedQueriesResponse struct {
	// NextPageToken: Page token to retrieve the next page of results in the
	// list. If this is empty, then there are no more saved queries to list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SavedQueries: List of output saved queries.
	SavedQueries []*SavedQuery `json:"savedQueries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListSavedQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSavedQueriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MailCountResult: Mail specific count metrics.
type MailCountResult struct {
	// AccountCountErrors: Error occurred when querying these accounts.
	AccountCountErrors []*AccountCountError `json:"accountCountErrors,omitempty"`

	// AccountCounts: Subtotal count per matching account that have more
	// than zero messages.
	AccountCounts []*AccountCount `json:"accountCounts,omitempty"`

	// MatchingAccountsCount: Total number of accounts that can be queried
	// and have more than zero messages.
	MatchingAccountsCount int64 `json:"matchingAccountsCount,omitempty,string"`

	// NonQueryableAccounts: When data scope is HELD_DATA in the request
	// Query, these accounts in the request are not queried because they are
	// not on hold. For other data scope, this field is not set.
	NonQueryableAccounts []string `json:"nonQueryableAccounts,omitempty"`

	// QueriedAccountsCount: Total number of accounts involved in this count
	// operation.
	QueriedAccountsCount int64 `json:"queriedAccountsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AccountCountErrors")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountCountErrors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MailCountResult) MarshalJSON() ([]byte, error) {
	type NoMethod MailCountResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MailExportOptions: The options for mail export.
type MailExportOptions struct {
	// ExportFormat: The export file format.
	//
	// Possible values:
	//   "EXPORT_FORMAT_UNSPECIFIED" - No export format specified.
	//   "MBOX" - MBOX as export format.
	//   "PST" - PST as export format
	ExportFormat string `json:"exportFormat,omitempty"`

	// ShowConfidentialModeContent: Set to true to export confidential mode
	// content.
	ShowConfidentialModeContent bool `json:"showConfidentialModeContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExportFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportFormat") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MailExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod MailExportOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MailOptions: Mail search advanced options
type MailOptions struct {
	// ExcludeDrafts: Set to true to exclude drafts.
	ExcludeDrafts bool `json:"excludeDrafts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExcludeDrafts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExcludeDrafts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MailOptions) MarshalJSON() ([]byte, error) {
	type NoMethod MailOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Matter: Represents a matter.
type Matter struct {
	// Description: The description of the matter.
	Description string `json:"description,omitempty"`

	// MatterId: The matter ID which is generated by the server. Should be
	// blank when creating a new matter.
	MatterId string `json:"matterId,omitempty"`

	// MatterPermissions: List of users and access to the matter. Currently
	// there is no programmer defined limit on the number of permissions a
	// matter can have.
	MatterPermissions []*MatterPermission `json:"matterPermissions,omitempty"`

	// Name: The name of the matter.
	Name string `json:"name,omitempty"`

	// State: The state of the matter.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The matter has no specified state.
	//   "OPEN" - This matter is open.
	//   "CLOSED" - This matter is closed.
	//   "DELETED" - This matter is deleted.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Matter) MarshalJSON() ([]byte, error) {
	type NoMethod Matter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MatterPermission: Currently each matter only has one owner, and all
// others are collaborators. When an account is purged, its
// corresponding MatterPermission resources cease to exist.
type MatterPermission struct {
	// AccountId: The account ID, as provided by Admin SDK.
	AccountId string `json:"accountId,omitempty"`

	// Role: The user's role in this matter.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - No role assigned.
	//   "COLLABORATOR" - A collaborator to the matter.
	//   "OWNER" - The owner of the matter.
	Role string `json:"role,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MatterPermission) MarshalJSON() ([]byte, error) {
	type NoMethod MatterPermission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OrgUnitInfo: Org Unit to search
type OrgUnitInfo struct {
	// OrgUnitId: Org unit to search, as provided by the Admin SDK Directory
	// API.
	OrgUnitId string `json:"orgUnitId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OrgUnitId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OrgUnitId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OrgUnitInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrgUnitInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Query: A query definition relevant for search & export.
type Query struct {
	// AccountInfo: When 'ACCOUNT' is chosen as search method, account_info
	// needs to be specified.
	AccountInfo *AccountInfo `json:"accountInfo,omitempty"`

	// Corpus: The corpus to search.
	//
	// Possible values:
	//   "CORPUS_TYPE_UNSPECIFIED" - No corpus specified.
	//   "DRIVE" - Drive.
	//   "MAIL" - Mail.
	//   "GROUPS" - Groups.
	//   "HANGOUTS_CHAT" - Hangouts Chat.
	//   "VOICE" - Google Voice.
	Corpus string `json:"corpus,omitempty"`

	// DataScope: The data source to search from.
	//
	// Possible values:
	//   "DATA_SCOPE_UNSPECIFIED" - No data scope specified.
	//   "ALL_DATA" - All available data.
	//   "HELD_DATA" - Data on hold.
	//   "UNPROCESSED_DATA" - Data not processed.
	DataScope string `json:"dataScope,omitempty"`

	// DriveOptions: For Drive search, specify more options in this field.
	DriveOptions *DriveOptions `json:"driveOptions,omitempty"`

	// EndTime: The end time range for the search query. These timestamps
	// are in GMT and rounded down to the start of the given date.
	EndTime string `json:"endTime,omitempty"`

	// HangoutsChatInfo: When 'ROOM' is chosen as search method,
	// hangout_chats_info needs to be specified. (read-only)
	HangoutsChatInfo *HangoutsChatInfo `json:"hangoutsChatInfo,omitempty"`

	// HangoutsChatOptions: For hangouts chat search, specify more options
	// in this field. (read-only)
	HangoutsChatOptions *HangoutsChatOptions `json:"hangoutsChatOptions,omitempty"`

	// MailOptions: For mail search, specify more options in this field.
	MailOptions *MailOptions `json:"mailOptions,omitempty"`

	// Method: The search method to use. This field is similar to the
	// search_method field but is introduced to support shared drives. It
	// supports all search method types. In case the search_method is
	// TEAM_DRIVE the response of this field will be SHARED_DRIVE only.
	//
	// Possible values:
	//   "SEARCH_METHOD_UNSPECIFIED" - A search method must be specified. If
	// a request does not specify a search method, it will be rejected.
	//   "ACCOUNT" - Will search all accounts provided in account_info.
	//   "ORG_UNIT" - Will search all accounts in the OU specified in
	// org_unit_info.
	//   "TEAM_DRIVE" - Will search for all accounts in the Team Drive
	// specified in team_drive_info.
	//   "ENTIRE_ORG" - Will search for all accounts in the organization. No
	// need to set account_info or org_unit_info. Not all CORPUS_TYPE
	// support this scope. Supported by MAIL.
	//   "ROOM" - Will search in the Room specified in hangout_chats_info.
	// (read-only)
	//   "SHARED_DRIVE" - Will search for all accounts in the shared drive
	// specified in shared_drive_info.
	Method string `json:"method,omitempty"`

	// OrgUnitInfo: When 'ORG_UNIT' is chosen as as search method,
	// org_unit_info needs to be specified.
	OrgUnitInfo *OrgUnitInfo `json:"orgUnitInfo,omitempty"`

	// SearchMethod: The search method to use.
	//
	// Possible values:
	//   "SEARCH_METHOD_UNSPECIFIED" - A search method must be specified. If
	// a request does not specify a search method, it will be rejected.
	//   "ACCOUNT" - Will search all accounts provided in account_info.
	//   "ORG_UNIT" - Will search all accounts in the OU specified in
	// org_unit_info.
	//   "TEAM_DRIVE" - Will search for all accounts in the Team Drive
	// specified in team_drive_info.
	//   "ENTIRE_ORG" - Will search for all accounts in the organization. No
	// need to set account_info or org_unit_info. Not all CORPUS_TYPE
	// support this scope. Supported by MAIL.
	//   "ROOM" - Will search in the Room specified in hangout_chats_info.
	// (read-only)
	//   "SHARED_DRIVE" - Will search for all accounts in the shared drive
	// specified in shared_drive_info.
	SearchMethod string `json:"searchMethod,omitempty"`

	// SharedDriveInfo: When 'SHARED_DRIVE' is chosen as search method,
	// shared_drive_info needs to be specified.
	SharedDriveInfo *SharedDriveInfo `json:"sharedDriveInfo,omitempty"`

	// StartTime: The start time range for the search query. These
	// timestamps are in GMT and rounded down to the start of the given
	// date.
	StartTime string `json:"startTime,omitempty"`

	// TeamDriveInfo: When 'TEAM_DRIVE' is chosen as search method,
	// team_drive_info needs to be specified.
	TeamDriveInfo *TeamDriveInfo `json:"teamDriveInfo,omitempty"`

	// Terms: The corpus-specific search operators used to generate search
	// results.
	Terms string `json:"terms,omitempty"`

	// TimeZone: The time zone name. It should be an IANA TZ name, such as
	// "America/Los_Angeles". For more information, see Time Zone.
	TimeZone string `json:"timeZone,omitempty"`

	// VoiceOptions: For voice search, specify more options in this field.
	VoiceOptions *VoiceOptions `json:"voiceOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Query) MarshalJSON() ([]byte, error) {
	type NoMethod Query
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RemoveHeldAccountsRequest: Remove a list of accounts from a hold.
type RemoveHeldAccountsRequest struct {
	// AccountIds: Account IDs to identify HeldAccounts to remove.
	AccountIds []string `json:"accountIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountIds") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RemoveHeldAccountsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveHeldAccountsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RemoveHeldAccountsResponse: Response for batch delete held accounts.
type RemoveHeldAccountsResponse struct {
	// Statuses: A list of statuses for deleted accounts. Results have the
	// same order as the request.
	Statuses []*Status `json:"statuses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Statuses") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Statuses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RemoveHeldAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveHeldAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RemoveMatterPermissionsRequest: Remove an account as a matter
// collaborator.
type RemoveMatterPermissionsRequest struct {
	// AccountId: The account ID.
	AccountId string `json:"accountId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RemoveMatterPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveMatterPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReopenMatterRequest: Reopen a matter by ID.
type ReopenMatterRequest struct {
}

// ReopenMatterResponse: Response to a ReopenMatterRequest.
type ReopenMatterResponse struct {
	// Matter: The updated matter, with state OPEN.
	Matter *Matter `json:"matter,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Matter") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Matter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReopenMatterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReopenMatterResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SavedQuery: Definition of the saved query.
type SavedQuery struct {
	// CreateTime: Output only. The server generated timestamp at which
	// saved query was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Name of the saved query.
	DisplayName string `json:"displayName,omitempty"`

	// MatterId: Output only. The matter ID of the associated matter. The
	// server does not look at this field during create and always uses
	// matter id in the URL.
	MatterId string `json:"matterId,omitempty"`

	// Query: The underlying Query object which contains all the information
	// of the saved query.
	Query *Query `json:"query,omitempty"`

	// SavedQueryId: A unique identifier for the saved query.
	SavedQueryId string `json:"savedQueryId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SavedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod SavedQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SharedDriveInfo: Shared drives to search
type SharedDriveInfo struct {
	// SharedDriveIds: List of Shared drive IDs, as provided by Drive API.
	SharedDriveIds []string `json:"sharedDriveIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SharedDriveIds") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SharedDriveIds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SharedDriveInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SharedDriveInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TeamDriveInfo: Team Drives to search
type TeamDriveInfo struct {
	// TeamDriveIds: List of Team Drive IDs, as provided by Drive API.
	TeamDriveIds []string `json:"teamDriveIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TeamDriveIds") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TeamDriveIds") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TeamDriveInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TeamDriveInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UndeleteMatterRequest: Undelete a matter by ID.
type UndeleteMatterRequest struct {
}

// UserInfo: User's information.
type UserInfo struct {
	// DisplayName: The displayed name of the user.
	DisplayName string `json:"displayName,omitempty"`

	// Email: The email address of the user.
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod UserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VoiceExportOptions: The options for voice export.
type VoiceExportOptions struct {
	// ExportFormat: The export format for voice export.
	//
	// Possible values:
	//   "EXPORT_FORMAT_UNSPECIFIED" - No export format specified.
	//   "MBOX" - MBOX as export format.
	//   "PST" - PST as export format
	ExportFormat string `json:"exportFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExportFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExportFormat") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VoiceExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod VoiceExportOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VoiceOptions: Voice search options
type VoiceOptions struct {
	// CoveredData: Datatypes to search
	//
	// Possible values:
	//   "COVERED_DATA_UNSPECIFIED" - Covered data unspecified.
	//   "TEXT_MESSAGES" - Voice text message will be covered.
	//   "VOICEMAILS" - Voicemail will be covered.
	//   "CALL_LOGS" - Call logs will be covered.
	CoveredData []string `json:"coveredData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoveredData") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoveredData") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VoiceOptions) MarshalJSON() ([]byte, error) {
	type NoMethod VoiceOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "vault.matters.addPermissions":

type MattersAddPermissionsCall struct {
	s                           *Service
	matterId                    string
	addmatterpermissionsrequest *AddMatterPermissionsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// AddPermissions: Adds an account as a matter collaborator.
//
// - matterId: The matter ID.
func (r *MattersService) AddPermissions(matterId string, addmatterpermissionsrequest *AddMatterPermissionsRequest) *MattersAddPermissionsCall {
	c := &MattersAddPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.addmatterpermissionsrequest = addmatterpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersAddPermissionsCall) Fields(s ...googleapi.Field) *MattersAddPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersAddPermissionsCall) Context(ctx context.Context) *MattersAddPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersAddPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersAddPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmatterpermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}:addPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.addPermissions" call.
// Exactly one of *MatterPermission or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *MatterPermission.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersAddPermissionsCall) Do(opts ...googleapi.CallOption) (*MatterPermission, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &MatterPermission{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds an account as a matter collaborator.",
	//   "flatPath": "v1/matters/{matterId}:addPermissions",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.addPermissions",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}:addPermissions",
	//   "request": {
	//     "$ref": "AddMatterPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "MatterPermission"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.close":

type MattersCloseCall struct {
	s                  *Service
	matterId           string
	closematterrequest *CloseMatterRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Close: Closes the specified matter. Returns matter with updated
// state.
//
// - matterId: The matter ID.
func (r *MattersService) Close(matterId string, closematterrequest *CloseMatterRequest) *MattersCloseCall {
	c := &MattersCloseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.closematterrequest = closematterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersCloseCall) Fields(s ...googleapi.Field) *MattersCloseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersCloseCall) Context(ctx context.Context) *MattersCloseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersCloseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersCloseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.closematterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}:close")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.close" call.
// Exactly one of *CloseMatterResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *CloseMatterResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersCloseCall) Do(opts ...googleapi.CallOption) (*CloseMatterResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &CloseMatterResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Closes the specified matter. Returns matter with updated state.",
	//   "flatPath": "v1/matters/{matterId}:close",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.close",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}:close",
	//   "request": {
	//     "$ref": "CloseMatterRequest"
	//   },
	//   "response": {
	//     "$ref": "CloseMatterResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.count":

type MattersCountCall struct {
	s                     *Service
	matterId              string
	countartifactsrequest *CountArtifactsRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Count: Counts the artifacts within the context of a matter and
// returns a detailed breakdown of metrics.
//
// - matterId: The matter ID.
func (r *MattersService) Count(matterId string, countartifactsrequest *CountArtifactsRequest) *MattersCountCall {
	c := &MattersCountCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.countartifactsrequest = countartifactsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersCountCall) Fields(s ...googleapi.Field) *MattersCountCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersCountCall) Context(ctx context.Context) *MattersCountCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersCountCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersCountCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.countartifactsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}:count")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.count" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MattersCountCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Counts the artifacts within the context of a matter and returns a detailed breakdown of metrics.",
	//   "flatPath": "v1/matters/{matterId}:count",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.count",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}:count",
	//   "request": {
	//     "$ref": "CountArtifactsRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.create":

type MattersCreateCall struct {
	s          *Service
	matter     *Matter
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new matter with the given name and description. The
// initial state is open, and the owner is the method caller. Returns
// the created matter with default view.
func (r *MattersService) Create(matter *Matter) *MattersCreateCall {
	c := &MattersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matter = matter
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersCreateCall) Fields(s ...googleapi.Field) *MattersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersCreateCall) Context(ctx context.Context) *MattersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.matter)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.create" call.
// Exactly one of *Matter or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Matter.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersCreateCall) Do(opts ...googleapi.CallOption) (*Matter, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Matter{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new matter with the given name and description. The initial state is open, and the owner is the method caller. Returns the created matter with default view.",
	//   "flatPath": "v1/matters",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.create",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1/matters",
	//   "request": {
	//     "$ref": "Matter"
	//   },
	//   "response": {
	//     "$ref": "Matter"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.delete":

type MattersDeleteCall struct {
	s          *Service
	matterId   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified matter. Returns matter with updated
// state.
//
// - matterId: The matter ID.
func (r *MattersService) Delete(matterId string) *MattersDeleteCall {
	c := &MattersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersDeleteCall) Fields(s ...googleapi.Field) *MattersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersDeleteCall) Context(ctx context.Context) *MattersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.delete" call.
// Exactly one of *Matter or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Matter.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersDeleteCall) Do(opts ...googleapi.CallOption) (*Matter, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Matter{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified matter. Returns matter with updated state.",
	//   "flatPath": "v1/matters/{matterId}",
	//   "httpMethod": "DELETE",
	//   "id": "vault.matters.delete",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}",
	//   "response": {
	//     "$ref": "Matter"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.get":

type MattersGetCall struct {
	s            *Service
	matterId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified matter.
//
// - matterId: The matter ID.
func (r *MattersService) Get(matterId string) *MattersGetCall {
	c := &MattersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	return c
}

// View sets the optional parameter "view": Specifies which parts of the
// Matter to return in the response.
//
// Possible values:
//   "VIEW_UNSPECIFIED" - There is no specified view.
//   "BASIC" - Response includes the matter_id, name, description, and
// state. Default choice.
//   "FULL" - Full representation of matter is returned. Everything
// above and including MatterPermissions list.
func (c *MattersGetCall) View(view string) *MattersGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersGetCall) Fields(s ...googleapi.Field) *MattersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersGetCall) IfNoneMatch(entityTag string) *MattersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersGetCall) Context(ctx context.Context) *MattersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.get" call.
// Exactly one of *Matter or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Matter.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersGetCall) Do(opts ...googleapi.CallOption) (*Matter, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Matter{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the specified matter.",
	//   "flatPath": "v1/matters/{matterId}",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.get",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies which parts of the Matter to return in the response.",
	//       "enum": [
	//         "VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "There is no specified view.",
	//         "Response includes the matter_id, name, description, and state. Default choice.",
	//         "Full representation of matter is returned. Everything above and including MatterPermissions list."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}",
	//   "response": {
	//     "$ref": "Matter"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// method id "vault.matters.list":

type MattersListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists matters the user has access to.
func (r *MattersService) List() *MattersListCall {
	c := &MattersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The number of
// matters to return in the response. Default and maximum are 100.
func (c *MattersListCall) PageSize(pageSize int64) *MattersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The pagination
// token as returned in the response.
func (c *MattersListCall) PageToken(pageToken string) *MattersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// State sets the optional parameter "state": If set, list only matters
// with that specific state. The default is listing matters of all
// states.
//
// Possible values:
//   "STATE_UNSPECIFIED" - The matter has no specified state.
//   "OPEN" - This matter is open.
//   "CLOSED" - This matter is closed.
//   "DELETED" - This matter is deleted.
func (c *MattersListCall) State(state string) *MattersListCall {
	c.urlParams_.Set("state", state)
	return c
}

// View sets the optional parameter "view": Specifies which parts of the
// matter to return in response.
//
// Possible values:
//   "VIEW_UNSPECIFIED" - There is no specified view.
//   "BASIC" - Response includes the matter_id, name, description, and
// state. Default choice.
//   "FULL" - Full representation of matter is returned. Everything
// above and including MatterPermissions list.
func (c *MattersListCall) View(view string) *MattersListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersListCall) Fields(s ...googleapi.Field) *MattersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersListCall) IfNoneMatch(entityTag string) *MattersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersListCall) Context(ctx context.Context) *MattersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.list" call.
// Exactly one of *ListMattersResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListMattersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersListCall) Do(opts ...googleapi.CallOption) (*ListMattersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListMattersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists matters the user has access to.",
	//   "flatPath": "v1/matters",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The number of matters to return in the response. Default and maximum are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The pagination token as returned in the response.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "state": {
	//       "description": "If set, list only matters with that specific state. The default is listing matters of all states.",
	//       "enum": [
	//         "STATE_UNSPECIFIED",
	//         "OPEN",
	//         "CLOSED",
	//         "DELETED"
	//       ],
	//       "enumDescriptions": [
	//         "The matter has no specified state.",
	//         "This matter is open.",
	//         "This matter is closed.",
	//         "This matter is deleted."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies which parts of the matter to return in response.",
	//       "enum": [
	//         "VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "There is no specified view.",
	//         "Response includes the matter_id, name, description, and state. Default choice.",
	//         "Full representation of matter is returned. Everything above and including MatterPermissions list."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters",
	//   "response": {
	//     "$ref": "ListMattersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MattersListCall) Pages(ctx context.Context, f func(*ListMattersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vault.matters.removePermissions":

type MattersRemovePermissionsCall struct {
	s                              *Service
	matterId                       string
	removematterpermissionsrequest *RemoveMatterPermissionsRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// RemovePermissions: Removes an account as a matter collaborator.
//
// - matterId: The matter ID.
func (r *MattersService) RemovePermissions(matterId string, removematterpermissionsrequest *RemoveMatterPermissionsRequest) *MattersRemovePermissionsCall {
	c := &MattersRemovePermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.removematterpermissionsrequest = removematterpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersRemovePermissionsCall) Fields(s ...googleapi.Field) *MattersRemovePermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersRemovePermissionsCall) Context(ctx context.Context) *MattersRemovePermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersRemovePermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersRemovePermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.removematterpermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}:removePermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.removePermissions" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersRemovePermissionsCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Removes an account as a matter collaborator.",
	//   "flatPath": "v1/matters/{matterId}:removePermissions",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.removePermissions",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}:removePermissions",
	//   "request": {
	//     "$ref": "RemoveMatterPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.reopen":

type MattersReopenCall struct {
	s                   *Service
	matterId            string
	reopenmatterrequest *ReopenMatterRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Reopen: Reopens the specified matter. Returns matter with updated
// state.
//
// - matterId: The matter ID.
func (r *MattersService) Reopen(matterId string, reopenmatterrequest *ReopenMatterRequest) *MattersReopenCall {
	c := &MattersReopenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.reopenmatterrequest = reopenmatterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersReopenCall) Fields(s ...googleapi.Field) *MattersReopenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersReopenCall) Context(ctx context.Context) *MattersReopenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersReopenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersReopenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.reopenmatterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}:reopen")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.reopen" call.
// Exactly one of *ReopenMatterResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ReopenMatterResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersReopenCall) Do(opts ...googleapi.CallOption) (*ReopenMatterResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ReopenMatterResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Reopens the specified matter. Returns matter with updated state.",
	//   "flatPath": "v1/matters/{matterId}:reopen",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.reopen",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}:reopen",
	//   "request": {
	//     "$ref": "ReopenMatterRequest"
	//   },
	//   "response": {
	//     "$ref": "ReopenMatterResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.undelete":

type MattersUndeleteCall struct {
	s                     *Service
	matterId              string
	undeletematterrequest *UndeleteMatterRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Undeletes the specified matter. Returns matter with updated
// state.
//
// - matterId: The matter ID.
func (r *MattersService) Undelete(matterId string, undeletematterrequest *UndeleteMatterRequest) *MattersUndeleteCall {
	c := &MattersUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.undeletematterrequest = undeletematterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersUndeleteCall) Fields(s ...googleapi.Field) *MattersUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersUndeleteCall) Context(ctx context.Context) *MattersUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.undeletematterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.undelete" call.
// Exactly one of *Matter or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Matter.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersUndeleteCall) Do(opts ...googleapi.CallOption) (*Matter, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Matter{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Undeletes the specified matter. Returns matter with updated state.",
	//   "flatPath": "v1/matters/{matterId}:undelete",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.undelete",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}:undelete",
	//   "request": {
	//     "$ref": "UndeleteMatterRequest"
	//   },
	//   "response": {
	//     "$ref": "Matter"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.update":

type MattersUpdateCall struct {
	s          *Service
	matterId   string
	matter     *Matter
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the specified matter. This updates only the name and
// description of the matter, identified by matter ID. Changes to any
// other fields are ignored. Returns the default view of the matter.
//
// - matterId: The matter ID.
func (r *MattersService) Update(matterId string, matter *Matter) *MattersUpdateCall {
	c := &MattersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.matter = matter
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersUpdateCall) Fields(s ...googleapi.Field) *MattersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersUpdateCall) Context(ctx context.Context) *MattersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.matter)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.update" call.
// Exactly one of *Matter or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Matter.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersUpdateCall) Do(opts ...googleapi.CallOption) (*Matter, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Matter{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified matter. This updates only the name and description of the matter, identified by matter ID. Changes to any other fields are ignored. Returns the default view of the matter.",
	//   "flatPath": "v1/matters/{matterId}",
	//   "httpMethod": "PUT",
	//   "id": "vault.matters.update",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}",
	//   "request": {
	//     "$ref": "Matter"
	//   },
	//   "response": {
	//     "$ref": "Matter"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.exports.create":

type MattersExportsCreateCall struct {
	s          *Service
	matterId   string
	export     *Export
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an Export.
//
// - matterId: The matter ID.
func (r *MattersExportsService) Create(matterId string, export *Export) *MattersExportsCreateCall {
	c := &MattersExportsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.export = export
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersExportsCreateCall) Fields(s ...googleapi.Field) *MattersExportsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersExportsCreateCall) Context(ctx context.Context) *MattersExportsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersExportsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersExportsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.export)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/exports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.exports.create" call.
// Exactly one of *Export or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Export.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersExportsCreateCall) Do(opts ...googleapi.CallOption) (*Export, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Export{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Export.",
	//   "flatPath": "v1/matters/{matterId}/exports",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.exports.create",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/exports",
	//   "request": {
	//     "$ref": "Export"
	//   },
	//   "response": {
	//     "$ref": "Export"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.exports.delete":

type MattersExportsDeleteCall struct {
	s          *Service
	matterId   string
	exportId   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an Export.
//
// - exportId: The export ID.
// - matterId: The matter ID.
func (r *MattersExportsService) Delete(matterId string, exportId string) *MattersExportsDeleteCall {
	c := &MattersExportsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.exportId = exportId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersExportsDeleteCall) Fields(s ...googleapi.Field) *MattersExportsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersExportsDeleteCall) Context(ctx context.Context) *MattersExportsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersExportsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersExportsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/exports/{exportId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"exportId": c.exportId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.exports.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersExportsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an Export.",
	//   "flatPath": "v1/matters/{matterId}/exports/{exportId}",
	//   "httpMethod": "DELETE",
	//   "id": "vault.matters.exports.delete",
	//   "parameterOrder": [
	//     "matterId",
	//     "exportId"
	//   ],
	//   "parameters": {
	//     "exportId": {
	//       "description": "The export ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/exports/{exportId}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.exports.get":

type MattersExportsGetCall struct {
	s            *Service
	matterId     string
	exportId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an Export.
//
// - exportId: The export ID.
// - matterId: The matter ID.
func (r *MattersExportsService) Get(matterId string, exportId string) *MattersExportsGetCall {
	c := &MattersExportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.exportId = exportId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersExportsGetCall) Fields(s ...googleapi.Field) *MattersExportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersExportsGetCall) IfNoneMatch(entityTag string) *MattersExportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersExportsGetCall) Context(ctx context.Context) *MattersExportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersExportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersExportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/exports/{exportId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"exportId": c.exportId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.exports.get" call.
// Exactly one of *Export or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Export.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersExportsGetCall) Do(opts ...googleapi.CallOption) (*Export, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Export{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an Export.",
	//   "flatPath": "v1/matters/{matterId}/exports/{exportId}",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.exports.get",
	//   "parameterOrder": [
	//     "matterId",
	//     "exportId"
	//   ],
	//   "parameters": {
	//     "exportId": {
	//       "description": "The export ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/exports/{exportId}",
	//   "response": {
	//     "$ref": "Export"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// method id "vault.matters.exports.list":

type MattersExportsListCall struct {
	s            *Service
	matterId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Exports.
//
// - matterId: The matter ID.
func (r *MattersExportsService) List(matterId string) *MattersExportsListCall {
	c := &MattersExportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	return c
}

// PageSize sets the optional parameter "pageSize": The number of
// exports to return in the response.
func (c *MattersExportsListCall) PageSize(pageSize int64) *MattersExportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The pagination
// token as returned in the response.
func (c *MattersExportsListCall) PageToken(pageToken string) *MattersExportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersExportsListCall) Fields(s ...googleapi.Field) *MattersExportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersExportsListCall) IfNoneMatch(entityTag string) *MattersExportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersExportsListCall) Context(ctx context.Context) *MattersExportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersExportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersExportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/exports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.exports.list" call.
// Exactly one of *ListExportsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListExportsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersExportsListCall) Do(opts ...googleapi.CallOption) (*ListExportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListExportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists Exports.",
	//   "flatPath": "v1/matters/{matterId}/exports",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.exports.list",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The number of exports to return in the response.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The pagination token as returned in the response.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/exports",
	//   "response": {
	//     "$ref": "ListExportsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MattersExportsListCall) Pages(ctx context.Context, f func(*ListExportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vault.matters.holds.addHeldAccounts":

type MattersHoldsAddHeldAccountsCall struct {
	s                      *Service
	matterId               string
	holdId                 string
	addheldaccountsrequest *AddHeldAccountsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// AddHeldAccounts: Adds HeldAccounts to a hold. Returns a list of
// accounts that have been successfully added. Accounts can only be
// added to an existing account-based hold.
//
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsService) AddHeldAccounts(matterId string, holdId string, addheldaccountsrequest *AddHeldAccountsRequest) *MattersHoldsAddHeldAccountsCall {
	c := &MattersHoldsAddHeldAccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	c.addheldaccountsrequest = addheldaccountsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsAddHeldAccountsCall) Fields(s ...googleapi.Field) *MattersHoldsAddHeldAccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsAddHeldAccountsCall) Context(ctx context.Context) *MattersHoldsAddHeldAccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsAddHeldAccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsAddHeldAccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addheldaccountsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}:addHeldAccounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.addHeldAccounts" call.
// Exactly one of *AddHeldAccountsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AddHeldAccountsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersHoldsAddHeldAccountsCall) Do(opts ...googleapi.CallOption) (*AddHeldAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AddHeldAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds HeldAccounts to a hold. Returns a list of accounts that have been successfully added. Accounts can only be added to an existing account-based hold.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}:addHeldAccounts",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.holds.addHeldAccounts",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}:addHeldAccounts",
	//   "request": {
	//     "$ref": "AddHeldAccountsRequest"
	//   },
	//   "response": {
	//     "$ref": "AddHeldAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.create":

type MattersHoldsCreateCall struct {
	s          *Service
	matterId   string
	hold       *Hold
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a hold in the given matter.
//
// - matterId: The matter ID.
func (r *MattersHoldsService) Create(matterId string, hold *Hold) *MattersHoldsCreateCall {
	c := &MattersHoldsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.hold = hold
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsCreateCall) Fields(s ...googleapi.Field) *MattersHoldsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsCreateCall) Context(ctx context.Context) *MattersHoldsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.hold)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.create" call.
// Exactly one of *Hold or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Hold.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MattersHoldsCreateCall) Do(opts ...googleapi.CallOption) (*Hold, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Hold{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a hold in the given matter.",
	//   "flatPath": "v1/matters/{matterId}/holds",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.holds.create",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds",
	//   "request": {
	//     "$ref": "Hold"
	//   },
	//   "response": {
	//     "$ref": "Hold"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.delete":

type MattersHoldsDeleteCall struct {
	s          *Service
	matterId   string
	holdId     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a hold by ID. This will release any HeldAccounts on
// this Hold.
//
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsService) Delete(matterId string, holdId string) *MattersHoldsDeleteCall {
	c := &MattersHoldsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsDeleteCall) Fields(s ...googleapi.Field) *MattersHoldsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsDeleteCall) Context(ctx context.Context) *MattersHoldsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersHoldsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Removes a hold by ID. This will release any HeldAccounts on this Hold.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}",
	//   "httpMethod": "DELETE",
	//   "id": "vault.matters.holds.delete",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.get":

type MattersHoldsGetCall struct {
	s            *Service
	matterId     string
	holdId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a hold by ID.
//
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsService) Get(matterId string, holdId string) *MattersHoldsGetCall {
	c := &MattersHoldsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	return c
}

// View sets the optional parameter "view": Specifies which parts of the
// Hold to return.
//
// Possible values:
//   "HOLD_VIEW_UNSPECIFIED" - There is no specified view. Defaults to
// FULL_HOLD.
//   "BASIC_HOLD" - Response includes the id, name, update time, corpus,
// and query.
//   "FULL_HOLD" - Full representation of a Hold. Response includes all
// fields of 'BASIC' and the entities the Hold applies to, such as
// accounts, or OU.
func (c *MattersHoldsGetCall) View(view string) *MattersHoldsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsGetCall) Fields(s ...googleapi.Field) *MattersHoldsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersHoldsGetCall) IfNoneMatch(entityTag string) *MattersHoldsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsGetCall) Context(ctx context.Context) *MattersHoldsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.get" call.
// Exactly one of *Hold or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Hold.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MattersHoldsGetCall) Do(opts ...googleapi.CallOption) (*Hold, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Hold{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a hold by ID.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.holds.get",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies which parts of the Hold to return.",
	//       "enum": [
	//         "HOLD_VIEW_UNSPECIFIED",
	//         "BASIC_HOLD",
	//         "FULL_HOLD"
	//       ],
	//       "enumDescriptions": [
	//         "There is no specified view. Defaults to FULL_HOLD.",
	//         "Response includes the id, name, update time, corpus, and query.",
	//         "Full representation of a Hold. Response includes all fields of 'BASIC' and the entities the Hold applies to, such as accounts, or OU."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}",
	//   "response": {
	//     "$ref": "Hold"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// method id "vault.matters.holds.list":

type MattersHoldsListCall struct {
	s            *Service
	matterId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists holds within a matter. An empty page token in
// ListHoldsResponse denotes no more holds to list.
//
// - matterId: The matter ID.
func (r *MattersHoldsService) List(matterId string) *MattersHoldsListCall {
	c := &MattersHoldsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	return c
}

// PageSize sets the optional parameter "pageSize": The number of holds
// to return in the response, between 0 and 100 inclusive. Leaving this
// empty, or as 0, is the same as page_size = 100.
func (c *MattersHoldsListCall) PageSize(pageSize int64) *MattersHoldsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The pagination
// token as returned in the response. An empty token means start from
// the beginning.
func (c *MattersHoldsListCall) PageToken(pageToken string) *MattersHoldsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Specifies which parts of the
// Hold to return.
//
// Possible values:
//   "HOLD_VIEW_UNSPECIFIED" - There is no specified view. Defaults to
// FULL_HOLD.
//   "BASIC_HOLD" - Response includes the id, name, update time, corpus,
// and query.
//   "FULL_HOLD" - Full representation of a Hold. Response includes all
// fields of 'BASIC' and the entities the Hold applies to, such as
// accounts, or OU.
func (c *MattersHoldsListCall) View(view string) *MattersHoldsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsListCall) Fields(s ...googleapi.Field) *MattersHoldsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersHoldsListCall) IfNoneMatch(entityTag string) *MattersHoldsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsListCall) Context(ctx context.Context) *MattersHoldsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.list" call.
// Exactly one of *ListHoldsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListHoldsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersHoldsListCall) Do(opts ...googleapi.CallOption) (*ListHoldsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListHoldsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists holds within a matter. An empty page token in ListHoldsResponse denotes no more holds to list.",
	//   "flatPath": "v1/matters/{matterId}/holds",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.holds.list",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The number of holds to return in the response, between 0 and 100 inclusive. Leaving this empty, or as 0, is the same as page_size = 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The pagination token as returned in the response. An empty token means start from the beginning.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies which parts of the Hold to return.",
	//       "enum": [
	//         "HOLD_VIEW_UNSPECIFIED",
	//         "BASIC_HOLD",
	//         "FULL_HOLD"
	//       ],
	//       "enumDescriptions": [
	//         "There is no specified view. Defaults to FULL_HOLD.",
	//         "Response includes the id, name, update time, corpus, and query.",
	//         "Full representation of a Hold. Response includes all fields of 'BASIC' and the entities the Hold applies to, such as accounts, or OU."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds",
	//   "response": {
	//     "$ref": "ListHoldsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MattersHoldsListCall) Pages(ctx context.Context, f func(*ListHoldsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vault.matters.holds.removeHeldAccounts":

type MattersHoldsRemoveHeldAccountsCall struct {
	s                         *Service
	matterId                  string
	holdId                    string
	removeheldaccountsrequest *RemoveHeldAccountsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// RemoveHeldAccounts: Removes HeldAccounts from a hold. Returns a list
// of statuses in the same order as the request. If this request leaves
// the hold with no held accounts, the hold will not apply to any
// accounts.
//
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsService) RemoveHeldAccounts(matterId string, holdId string, removeheldaccountsrequest *RemoveHeldAccountsRequest) *MattersHoldsRemoveHeldAccountsCall {
	c := &MattersHoldsRemoveHeldAccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	c.removeheldaccountsrequest = removeheldaccountsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsRemoveHeldAccountsCall) Fields(s ...googleapi.Field) *MattersHoldsRemoveHeldAccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsRemoveHeldAccountsCall) Context(ctx context.Context) *MattersHoldsRemoveHeldAccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsRemoveHeldAccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsRemoveHeldAccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.removeheldaccountsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}:removeHeldAccounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.removeHeldAccounts" call.
// Exactly one of *RemoveHeldAccountsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *RemoveHeldAccountsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersHoldsRemoveHeldAccountsCall) Do(opts ...googleapi.CallOption) (*RemoveHeldAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &RemoveHeldAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Removes HeldAccounts from a hold. Returns a list of statuses in the same order as the request. If this request leaves the hold with no held accounts, the hold will not apply to any accounts.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}:removeHeldAccounts",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.holds.removeHeldAccounts",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}:removeHeldAccounts",
	//   "request": {
	//     "$ref": "RemoveHeldAccountsRequest"
	//   },
	//   "response": {
	//     "$ref": "RemoveHeldAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.update":

type MattersHoldsUpdateCall struct {
	s          *Service
	matterId   string
	holdId     string
	hold       *Hold
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the OU and/or query parameters of a hold. You cannot
// add accounts to a hold that covers an OU, nor can you add OUs to a
// hold that covers individual accounts. Accounts listed in the hold
// will be ignored.
//
// - holdId: The ID of the hold.
// - matterId: The matter ID.
func (r *MattersHoldsService) Update(matterId string, holdId string, hold *Hold) *MattersHoldsUpdateCall {
	c := &MattersHoldsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	c.hold = hold
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsUpdateCall) Fields(s ...googleapi.Field) *MattersHoldsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsUpdateCall) Context(ctx context.Context) *MattersHoldsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.hold)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.update" call.
// Exactly one of *Hold or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Hold.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *MattersHoldsUpdateCall) Do(opts ...googleapi.CallOption) (*Hold, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Hold{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the OU and/or query parameters of a hold. You cannot add accounts to a hold that covers an OU, nor can you add OUs to a hold that covers individual accounts. Accounts listed in the hold will be ignored.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}",
	//   "httpMethod": "PUT",
	//   "id": "vault.matters.holds.update",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The ID of the hold.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}",
	//   "request": {
	//     "$ref": "Hold"
	//   },
	//   "response": {
	//     "$ref": "Hold"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.accounts.create":

type MattersHoldsAccountsCreateCall struct {
	s           *Service
	matterId    string
	holdId      string
	heldaccount *HeldAccount
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Adds a HeldAccount to a hold. Accounts can only be added to a
// hold that has no held_org_unit set. Attempting to add an account to
// an OU-based hold will result in an error.
//
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsAccountsService) Create(matterId string, holdId string, heldaccount *HeldAccount) *MattersHoldsAccountsCreateCall {
	c := &MattersHoldsAccountsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	c.heldaccount = heldaccount
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsAccountsCreateCall) Fields(s ...googleapi.Field) *MattersHoldsAccountsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsAccountsCreateCall) Context(ctx context.Context) *MattersHoldsAccountsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsAccountsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsAccountsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.heldaccount)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.accounts.create" call.
// Exactly one of *HeldAccount or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *HeldAccount.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MattersHoldsAccountsCreateCall) Do(opts ...googleapi.CallOption) (*HeldAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &HeldAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds a HeldAccount to a hold. Accounts can only be added to a hold that has no held_org_unit set. Attempting to add an account to an OU-based hold will result in an error.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}/accounts",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.holds.accounts.create",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}/accounts",
	//   "request": {
	//     "$ref": "HeldAccount"
	//   },
	//   "response": {
	//     "$ref": "HeldAccount"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.accounts.delete":

type MattersHoldsAccountsDeleteCall struct {
	s          *Service
	matterId   string
	holdId     string
	accountId  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a HeldAccount from a hold. If this request leaves the
// hold with no held accounts, the hold will not apply to any accounts.
//
// - accountId: The ID of the account to remove from the hold.
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsAccountsService) Delete(matterId string, holdId string, accountId string) *MattersHoldsAccountsDeleteCall {
	c := &MattersHoldsAccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsAccountsDeleteCall) Fields(s ...googleapi.Field) *MattersHoldsAccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsAccountsDeleteCall) Context(ctx context.Context) *MattersHoldsAccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsAccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsAccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId":  c.matterId,
		"holdId":    c.holdId,
		"accountId": c.accountId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.accounts.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersHoldsAccountsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Removes a HeldAccount from a hold. If this request leaves the hold with no held accounts, the hold will not apply to any accounts.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}/accounts/{accountId}",
	//   "httpMethod": "DELETE",
	//   "id": "vault.matters.holds.accounts.delete",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId",
	//     "accountId"
	//   ],
	//   "parameters": {
	//     "accountId": {
	//       "description": "The ID of the account to remove from the hold.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}/accounts/{accountId}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.holds.accounts.list":

type MattersHoldsAccountsListCall struct {
	s            *Service
	matterId     string
	holdId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists HeldAccounts for a hold. This will only list individually
// specified held accounts. If the hold is on an OU, then use Admin SDK
// to enumerate its members.
//
// - holdId: The hold ID.
// - matterId: The matter ID.
func (r *MattersHoldsAccountsService) List(matterId string, holdId string) *MattersHoldsAccountsListCall {
	c := &MattersHoldsAccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.holdId = holdId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersHoldsAccountsListCall) Fields(s ...googleapi.Field) *MattersHoldsAccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersHoldsAccountsListCall) IfNoneMatch(entityTag string) *MattersHoldsAccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersHoldsAccountsListCall) Context(ctx context.Context) *MattersHoldsAccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersHoldsAccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersHoldsAccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/holds/{holdId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
		"holdId":   c.holdId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.holds.accounts.list" call.
// Exactly one of *ListHeldAccountsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListHeldAccountsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersHoldsAccountsListCall) Do(opts ...googleapi.CallOption) (*ListHeldAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListHeldAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists HeldAccounts for a hold. This will only list individually specified held accounts. If the hold is on an OU, then use Admin SDK to enumerate its members.",
	//   "flatPath": "v1/matters/{matterId}/holds/{holdId}/accounts",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.holds.accounts.list",
	//   "parameterOrder": [
	//     "matterId",
	//     "holdId"
	//   ],
	//   "parameters": {
	//     "holdId": {
	//       "description": "The hold ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "matterId": {
	//       "description": "The matter ID.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/holds/{holdId}/accounts",
	//   "response": {
	//     "$ref": "ListHeldAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// method id "vault.matters.savedQueries.create":

type MattersSavedQueriesCreateCall struct {
	s          *Service
	matterId   string
	savedquery *SavedQuery
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a saved query.
//
// - matterId: The matter ID of the parent matter for which the saved
//   query is to be created.
func (r *MattersSavedQueriesService) Create(matterId string, savedquery *SavedQuery) *MattersSavedQueriesCreateCall {
	c := &MattersSavedQueriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.savedquery = savedquery
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersSavedQueriesCreateCall) Fields(s ...googleapi.Field) *MattersSavedQueriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersSavedQueriesCreateCall) Context(ctx context.Context) *MattersSavedQueriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersSavedQueriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersSavedQueriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.savedquery)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/savedQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.savedQueries.create" call.
// Exactly one of *SavedQuery or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MattersSavedQueriesCreateCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a saved query.",
	//   "flatPath": "v1/matters/{matterId}/savedQueries",
	//   "httpMethod": "POST",
	//   "id": "vault.matters.savedQueries.create",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID of the parent matter for which the saved query is to be created.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/savedQueries",
	//   "request": {
	//     "$ref": "SavedQuery"
	//   },
	//   "response": {
	//     "$ref": "SavedQuery"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.savedQueries.delete":

type MattersSavedQueriesDeleteCall struct {
	s            *Service
	matterId     string
	savedQueryId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes a saved query by Id.
//
// - matterId: The matter ID of the parent matter for which the saved
//   query is to be deleted.
// - savedQueryId: ID of the saved query to be deleted.
func (r *MattersSavedQueriesService) Delete(matterId string, savedQueryId string) *MattersSavedQueriesDeleteCall {
	c := &MattersSavedQueriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.savedQueryId = savedQueryId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersSavedQueriesDeleteCall) Fields(s ...googleapi.Field) *MattersSavedQueriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersSavedQueriesDeleteCall) Context(ctx context.Context) *MattersSavedQueriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersSavedQueriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersSavedQueriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/savedQueries/{savedQueryId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId":     c.matterId,
		"savedQueryId": c.savedQueryId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.savedQueries.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MattersSavedQueriesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a saved query by Id.",
	//   "flatPath": "v1/matters/{matterId}/savedQueries/{savedQueryId}",
	//   "httpMethod": "DELETE",
	//   "id": "vault.matters.savedQueries.delete",
	//   "parameterOrder": [
	//     "matterId",
	//     "savedQueryId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID of the parent matter for which the saved query is to be deleted.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "savedQueryId": {
	//       "description": "ID of the saved query to be deleted.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/savedQueries/{savedQueryId}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery"
	//   ]
	// }

}

// method id "vault.matters.savedQueries.get":

type MattersSavedQueriesGetCall struct {
	s            *Service
	matterId     string
	savedQueryId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a saved query by Id.
//
// - matterId: The matter ID of the parent matter for which the saved
//   query is to be retrieved.
// - savedQueryId: ID of the saved query to be retrieved.
func (r *MattersSavedQueriesService) Get(matterId string, savedQueryId string) *MattersSavedQueriesGetCall {
	c := &MattersSavedQueriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	c.savedQueryId = savedQueryId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersSavedQueriesGetCall) Fields(s ...googleapi.Field) *MattersSavedQueriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersSavedQueriesGetCall) IfNoneMatch(entityTag string) *MattersSavedQueriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersSavedQueriesGetCall) Context(ctx context.Context) *MattersSavedQueriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersSavedQueriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersSavedQueriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/savedQueries/{savedQueryId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId":     c.matterId,
		"savedQueryId": c.savedQueryId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.savedQueries.get" call.
// Exactly one of *SavedQuery or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MattersSavedQueriesGetCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a saved query by Id.",
	//   "flatPath": "v1/matters/{matterId}/savedQueries/{savedQueryId}",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.savedQueries.get",
	//   "parameterOrder": [
	//     "matterId",
	//     "savedQueryId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID of the parent matter for which the saved query is to be retrieved.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "savedQueryId": {
	//       "description": "ID of the saved query to be retrieved.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/savedQueries/{savedQueryId}",
	//   "response": {
	//     "$ref": "SavedQuery"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// method id "vault.matters.savedQueries.list":

type MattersSavedQueriesListCall struct {
	s            *Service
	matterId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists saved queries within a matter. An empty page token in
// ListSavedQueriesResponse denotes no more saved queries to list.
//
// - matterId: The matter ID of the parent matter for which the saved
//   queries are to be retrieved.
func (r *MattersSavedQueriesService) List(matterId string) *MattersSavedQueriesListCall {
	c := &MattersSavedQueriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.matterId = matterId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of saved queries to return.
func (c *MattersSavedQueriesListCall) PageSize(pageSize int64) *MattersSavedQueriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The pagination
// token as returned in the previous response. An empty token means
// start from the beginning.
func (c *MattersSavedQueriesListCall) PageToken(pageToken string) *MattersSavedQueriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MattersSavedQueriesListCall) Fields(s ...googleapi.Field) *MattersSavedQueriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MattersSavedQueriesListCall) IfNoneMatch(entityTag string) *MattersSavedQueriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *MattersSavedQueriesListCall) Context(ctx context.Context) *MattersSavedQueriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MattersSavedQueriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MattersSavedQueriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/matters/{matterId}/savedQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"matterId": c.matterId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.matters.savedQueries.list" call.
// Exactly one of *ListSavedQueriesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListSavedQueriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *MattersSavedQueriesListCall) Do(opts ...googleapi.CallOption) (*ListSavedQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListSavedQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists saved queries within a matter. An empty page token in ListSavedQueriesResponse denotes no more saved queries to list.",
	//   "flatPath": "v1/matters/{matterId}/savedQueries",
	//   "httpMethod": "GET",
	//   "id": "vault.matters.savedQueries.list",
	//   "parameterOrder": [
	//     "matterId"
	//   ],
	//   "parameters": {
	//     "matterId": {
	//       "description": "The matter ID of the parent matter for which the saved queries are to be retrieved.",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of saved queries to return.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The pagination token as returned in the previous response. An empty token means start from the beginning.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/matters/{matterId}/savedQueries",
	//   "response": {
	//     "$ref": "ListSavedQueriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MattersSavedQueriesListCall) Pages(ctx context.Context, f func(*ListSavedQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "vault.operations.cancel":

type OperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation.
// The server makes a best effort to cancel the operation, but success
// is not guaranteed. If the server doesn't support this method, it
// returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use
// Operations.GetOperation or other methods to check whether the
// cancellation succeeded or whether the operation completed despite
// cancellation. On successful cancellation, the operation is not
// deleted; instead, it becomes an operation with an Operation.error
// value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *OperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *OperationsCancelCall {
	c := &OperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsCancelCall) Fields(s ...googleapi.Field) *OperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsCancelCall) Context(ctx context.Context) *OperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.operations.cancel" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *OperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.",
	//   "flatPath": "v1/operations/{operationsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "vault.operations.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be cancelled.",
	//       "location": "path",
	//       "pattern": "^operations/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:cancel",
	//   "request": {
	//     "$ref": "CancelOperationRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   }
	// }

}

// method id "vault.operations.delete":

type OperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that
// the client is no longer interested in the operation result. It does
// not cancel the operation. If the server doesn't support this method,
// it returns `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *OperationsService) Delete(name string) *OperationsDeleteCall {
	c := &OperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsDeleteCall) Fields(s ...googleapi.Field) *OperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsDeleteCall) Context(ctx context.Context) *OperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.operations.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *OperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.",
	//   "flatPath": "v1/operations/{operationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "vault.operations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be deleted.",
	//       "location": "path",
	//       "pattern": "^operations/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   }
	// }

}

// method id "vault.operations.get":

type OperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *OperationsService) Get(name string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "vault.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^operations/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/ediscovery",
	//     "https://www.googleapis.com/auth/ediscovery.readonly"
	//   ]
	// }

}

// method id "vault.operations.list":

type OperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
// override the binding to use different resource name schemes, such as
// `users/*/operations`. To override the binding, API services can add a
// binding such as "/v1/{name=users/*}/operations" to their service
// configuration. For backwards compatibility, the default name includes
// the operations collection id, however overriding users must ensure
// the name binding is the parent resource, without the operations
// collection id.
//
// - name: The name of the operation's parent resource.
func (r *OperationsService) List(name string) *OperationsListCall {
	c := &OperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *OperationsListCall) Filter(filter string) *OperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *OperationsListCall) PageSize(pageSize int64) *OperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *OperationsListCall) PageToken(pageToken string) *OperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsListCall) Fields(s ...googleapi.Field) *OperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OperationsListCall) IfNoneMatch(entityTag string) *OperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsListCall) Context(ctx context.Context) *OperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210406")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "vault.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `\"/v1/{name=users/*}/operations\"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.",
	//   "flatPath": "v1/operations",
	//   "httpMethod": "GET",
	//   "id": "vault.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^operations$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
