/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.languagetool.DetectedLanguage;
import org.languagetool.Language;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignLanguageChecker {
    private static final Logger log = LoggerFactory.getLogger(ForeignLanguageChecker.class);
    private static final float ERROR_THRESHOLD = 0.45f;
    private static final int MIN_SENTENCE_THRESHOLD = 3;
    public static final String NO_FOREIGN_LANG_DETECTED = "NO_FOREIGN_LANG_DETECTED";
    private final String languageShortCode;
    private final String sentence;
    private final long sentenceLength;
    private final List<String> preferredLanguages;

    public ForeignLanguageChecker(String languageShortCode, String sentence, Long sentenceLength, List<String> preferredLanguages) {
        this.languageShortCode = languageShortCode;
        this.sentence = sentence;
        this.sentenceLength = sentenceLength;
        this.preferredLanguages = Collections.unmodifiableList(preferredLanguages);
    }

    public String check(int matchesSoFar) throws IOException {
        DetectedLanguage langDetectResults;
        LanguageIdentifier langIdent;
        float errorRatio = (float)matchesSoFar / (float)this.sentenceLength;
        if (this.sentenceLength >= 3L && errorRatio >= 0.45f && (langIdent = LanguageIdentifierService.INSTANCE.getInitialized()) != null && (langDetectResults = langIdent.detectLanguage(this.sentence, Collections.emptyList(), this.preferredLanguages)) != null) {
            Language detectedLanguage = langDetectResults.getDetectedLanguage();
            if (detectedLanguage != null && !detectedLanguage.getShortCode().equals(this.languageShortCode) && this.preferredLanguages.contains(detectedLanguage.getShortCode())) {
                log.trace("Found '{}' sentence in '{}' text: '{}' with confidence {} from source '{}'", new Object[]{detectedLanguage.getShortCode(), this.languageShortCode, this.sentence, Float.valueOf(langDetectResults.getDetectionConfidence()), langDetectResults.getDetectionSource()});
                return detectedLanguage.getShortCode();
            }
            if (detectedLanguage != null && detectedLanguage.getShortCode().equals(this.languageShortCode)) {
                return NO_FOREIGN_LANG_DETECTED;
            }
        }
        return null;
    }
}

