/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTable;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AltibasePrivTable
extends AltibaseObject<AltibaseTable>
implements DBAPrivilege {
    private String grantee;
    private String grantor;
    private String granteeType;
    private boolean grantable;

    public AltibasePrivTable(AltibaseTable table, ResultSet resultSet) {
        super(table, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIV_NAME"), true);
        this.grantee = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTEE_NAME");
        this.grantor = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTOR_NAME");
        this.granteeType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTEE_TYPE");
        this.grantable = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"WITH_GRANT_OPTION", (String)"1");
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=10)
    public Object getGrantor(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null) {
            return this.grantor;
        }
        return this.getDataSource().getGrantee(monitor, this.grantor);
    }

    @Property(viewable=true, order=11)
    public Object getGrantee(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null) {
            return this.grantee;
        }
        return this.getDataSource().getGrantee(monitor, this.grantee);
    }

    @Property(viewable=true, order=12)
    public String getGranteeType() throws DBException {
        return this.granteeType;
    }

    @Property(viewable=true, order=13)
    public boolean isGrantable() {
        return this.grantable;
    }
}

