Object.assign(window.search, {"doc_urls":["introduction.html#introduction","editions/index.html#what-are-editions","editions/index.html#editions-do-not-split-the-ecosystem","editions/index.html#edition-migration-is-easy-and-largely-automated","editions/index.html#what-this-guide-covers","editions/creating-a-new-project.html#creating-a-new-project","editions/transitioning-an-existing-project-to-a-new-edition.html#transitioning-an-existing-project-to-a-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#starting-the-migration","editions/transitioning-an-existing-project-to-a-new-edition.html#updating-your-code-to-be-compatible-with-the-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#enabling-the-new-edition-to-use-new-features","editions/transitioning-an-existing-project-to-a-new-edition.html#migrating-to-an-unstable-edition","editions/advanced-migrations.html#advanced-migration-strategies","editions/advanced-migrations.html#how-migrations-work","editions/advanced-migrations.html#migrating-multiple-configurations","editions/advanced-migrations.html#migrating-a-large-project-or-workspace","editions/advanced-migrations.html#partial-migration-with-broken-code","editions/advanced-migrations.html#migrating-macros","editions/advanced-migrations.html#macro-hygiene","editions/advanced-migrations.html#documentation-tests","editions/advanced-migrations.html#generated-code","editions/advanced-migrations.html#migrating-non-cargo-projects","editions/advanced-migrations.html#writing-idiomatic-code-in-a-new-edition","rust-2015/index.html#rust-2015","rust-2018/index.html#rust-2018","rust-2018/path-changes.html#path-and-module-system-changes","rust-2018/path-changes.html#summary","rust-2018/path-changes.html#motivation","rust-2018/path-changes.html#more-details","rust-2018/path-changes.html#no-more-extern-crate","rust-2018/path-changes.html#the-crate-keyword-refers-to-the-current-crate","rust-2018/path-changes.html#extern-crate-paths","rust-2018/path-changes.html#no-more-modrs","rust-2018/path-changes.html#use-paths","rust-2018/trait-fn-parameters.html#anonymous-trait-function-parameters-deprecated","rust-2018/trait-fn-parameters.html#summary","rust-2018/trait-fn-parameters.html#details","rust-2018/new-keywords.html#new-keywords","rust-2018/new-keywords.html#summary","rust-2018/new-keywords.html#motivation","rust-2018/new-keywords.html#dyn-trait-for-trait-objects","rust-2018/new-keywords.html#async-and-await","rust-2018/new-keywords.html#try-keyword","rust-2018/tyvar-behind-raw-pointer.html#method-dispatch-for-raw-pointers-to-inference-variables","rust-2018/tyvar-behind-raw-pointer.html#summary","rust-2018/tyvar-behind-raw-pointer.html#details","rust-2018/cargo.html#cargo-changes","rust-2018/cargo.html#summary","rust-2021/index.html#rust-2021","rust-2021/prelude.html#additions-to-the-prelude","rust-2021/prelude.html#summary","rust-2021/prelude.html#details","rust-2021/prelude.html#migration","rust-2021/prelude.html#migration-needed","rust-2021/prelude.html#no-migration-needed","rust-2021/prelude.html#implementation-reference","rust-2021/default-cargo-resolver.html#default-cargo-feature-resolver","rust-2021/default-cargo-resolver.html#summary","rust-2021/default-cargo-resolver.html#details","rust-2021/default-cargo-resolver.html#migration","rust-2021/default-cargo-resolver.html#build-failures","rust-2021/default-cargo-resolver.html#exploring-features","rust-2021/IntoIterator-for-arrays.html#intoiterator-for-arrays","rust-2021/IntoIterator-for-arrays.html#summary","rust-2021/IntoIterator-for-arrays.html#details","rust-2021/IntoIterator-for-arrays.html#migration","rust-2021/IntoIterator-for-arrays.html#optional-migration","rust-2021/disjoint-capture-in-closures.html#disjoint-capture-in-closures","rust-2021/disjoint-capture-in-closures.html#summary","rust-2021/disjoint-capture-in-closures.html#details","rust-2021/disjoint-capture-in-closures.html#migration","rust-2021/disjoint-capture-in-closures.html#wild-card-patterns","rust-2021/disjoint-capture-in-closures.html#drop-order","rust-2021/disjoint-capture-in-closures.html#trait-implementations","rust-2021/panic-macro-consistency.html#panic-macro-consistency","rust-2021/panic-macro-consistency.html#summary","rust-2021/panic-macro-consistency.html#details","rust-2021/panic-macro-consistency.html#migration","rust-2021/reserving-syntax.html#reserving-syntax","rust-2021/reserving-syntax.html#summary","rust-2021/reserving-syntax.html#details","rust-2021/reserving-syntax.html#migration","rust-2021/warnings-promoted-to-error.html#warnings-promoted-to-errors","rust-2021/warnings-promoted-to-error.html#summary","rust-2021/warnings-promoted-to-error.html#details","rust-2021/warnings-promoted-to-error.html#bare_trait_objects","rust-2021/warnings-promoted-to-error.html#ellipsis_inclusive_range_patterns","rust-2021/warnings-promoted-to-error.html#migrations","rust-2021/or-patterns-macro-rules.html#or-patterns-in-macro-rules","rust-2021/or-patterns-macro-rules.html#summary","rust-2021/or-patterns-macro-rules.html#details","rust-2021/or-patterns-macro-rules.html#migration","rust-2021/c-string-literals.html#c-string-literals","rust-2021/c-string-literals.html#summary","rust-2021/c-string-literals.html#details","rust-2021/c-string-literals.html#migration","rust-2024/index.html#rust-2024","rust-2024/prelude.html#additions-to-the-prelude","rust-2024/prelude.html#summary","rust-2024/prelude.html#details","rust-2024/prelude.html#rustcencodable-and-rustcdecodable-removal","rust-2024/prelude.html#migration","rust-2024/prelude.html#conflicting-trait-methods","rust-2024/prelude.html#rustcencodable-and-rustcdecodable","rust-2024/intoiterator-box-slice.html#add-intoiterator-for-box","rust-2024/intoiterator-box-slice.html#summary","rust-2024/intoiterator-box-slice.html#details","rust-2024/intoiterator-box-slice.html#migration","rust-2024/newly-unsafe-functions.html#unsafe-functions","rust-2024/newly-unsafe-functions.html#summary","rust-2024/newly-unsafe-functions.html#details","rust-2024/newly-unsafe-functions.html#stdenvset_var-remove_var","rust-2024/newly-unsafe-functions.html#stdosunixprocesscommandextbefore_exec","rust-2024/newly-unsafe-functions.html#migration","rust-2024/unsafe-op-in-unsafe-fn.html#unsafe_op_in_unsafe_fn-warning","rust-2024/unsafe-op-in-unsafe-fn.html#summary","rust-2024/unsafe-op-in-unsafe-fn.html#details","rust-2024/unsafe-op-in-unsafe-fn.html#migration","rust-2024/rpit-lifetime-capture.html#rpit-lifetime-capture-rules","rust-2024/rpit-lifetime-capture.html#summary","rust-2024/rpit-lifetime-capture.html#details","rust-2024/rpit-lifetime-capture.html#capturing","rust-2024/rpit-lifetime-capture.html#edition-specific-rules-when-no-use-bound-is-present","rust-2024/rpit-lifetime-capture.html#outer-generic-parameters","rust-2024/rpit-lifetime-capture.html#lifetimes-from-higher-ranked-binders","rust-2024/rpit-lifetime-capture.html#argument-position-impl-trait-apit","rust-2024/rpit-lifetime-capture.html#migration","rust-2024/rpit-lifetime-capture.html#migrating-while-avoiding-overcapturing","rust-2024/rpit-lifetime-capture.html#migrating-cases-involving-apit","rust-2024/rpit-lifetime-capture.html#migrating-away-from-the-captures-trick","rust-2024/rpit-lifetime-capture.html#migrating-away-from-the-outlives-trick","rust-2024/static-mut-references.html#disallow-references-to-static-mut","rust-2024/static-mut-references.html#summary","rust-2024/static-mut-references.html#details","rust-2024/static-mut-references.html#alternatives","rust-2024/static-mut-references.html#migration","rust-2024/cargo-remove-implicit-features.html#cargo-remove-implicit-features","rust-2024/cargo-remove-implicit-features.html#summary","rust-2024/cargo-remove-implicit-features.html#details","rust-2024/cargo-remove-implicit-features.html#motivation","rust-2024/cargo-remove-implicit-features.html#migration","rust-2024/cargo-table-key-names.html#cargo-table-and-key-name-consistency","rust-2024/cargo-table-key-names.html#summary","rust-2024/cargo-table-key-names.html#details","rust-2024/cargo-table-key-names.html#migration","rust-2024/cargo-inherited-default-features.html#cargo-reject-unused-inherited-default-features","rust-2024/cargo-inherited-default-features.html#summary","rust-2024/cargo-inherited-default-features.html#details","rust-2024/cargo-inherited-default-features.html#migration","rust-2024/rustfmt-overflow-delimited-expr.html#rustfmt-combine-all-delimited-exprs-as-last-argument","rust-2024/rustfmt-overflow-delimited-expr.html#summary","rust-2024/rustfmt-overflow-delimited-expr.html#details","rust-2024/rustfmt-overflow-delimited-expr.html#migration","rust-2024/gen-keyword.html#gen-keyword","rust-2024/gen-keyword.html#summary","rust-2024/gen-keyword.html#details","rust-2024/gen-keyword.html#migration","rust-2024/macro-fragment-specifiers.html#macro-fragment-specifiers","rust-2024/macro-fragment-specifiers.html#summary","rust-2024/macro-fragment-specifiers.html#details","rust-2024/macro-fragment-specifiers.html#migration","rust-2024/missing-macro-fragment-specifiers.html#missing-macro-fragment-specifiers","rust-2024/missing-macro-fragment-specifiers.html#summary","rust-2024/missing-macro-fragment-specifiers.html#details","rust-2024/missing-macro-fragment-specifiers.html#migration","rust-2024/never-type-fallback.html#never-type-fallback-change","rust-2024/never-type-fallback.html#summary","rust-2024/never-type-fallback.html#details","rust-2024/never-type-fallback.html#never_type_fallback_flowing_into_unsafe","rust-2024/never-type-fallback.html#migration","rust-2024/unsafe-extern.html#unsafe-extern-blocks","rust-2024/unsafe-extern.html#summary","rust-2024/unsafe-extern.html#details","rust-2024/unsafe-extern.html#migration","rust-2024/unsafe-attributes.html#unsafe-attributes","rust-2024/unsafe-attributes.html#summary","rust-2024/unsafe-attributes.html#details","rust-2024/unsafe-attributes.html#safety-requirements","rust-2024/unsafe-attributes.html#migration","rust-2024/rustdoc-doctests.html#rustdoc-combined-tests","rust-2024/rustdoc-doctests.html#summary","rust-2024/rustdoc-doctests.html#details","rust-2024/rustdoc-doctests.html#standalone-tag","rust-2024/rustdoc-doctests.html#migration"],"index":{"documentStore":{"docInfo":{"0":{"body":26,"breadcrumbs":2,"title":1},"1":{"body":111,"breadcrumbs":2,"title":1},"10":{"body":109,"breadcrumbs":9,"title":3},"100":{"body":0,"breadcrumbs":5,"title":1},"101":{"body":113,"breadcrumbs":7,"title":3},"102":{"body":30,"breadcrumbs":6,"title":2},"103":{"body":15,"breadcrumbs":8,"title":3},"104":{"body":29,"breadcrumbs":6,"title":1},"105":{"body":163,"breadcrumbs":6,"title":1},"106":{"body":78,"breadcrumbs":6,"title":1},"107":{"body":15,"breadcrumbs":7,"title":2},"108":{"body":8,"breadcrumbs":6,"title":1},"109":{"body":34,"breadcrumbs":6,"title":1},"11":{"body":0,"breadcrumbs":6,"title":3},"110":{"body":37,"breadcrumbs":7,"title":2},"111":{"body":55,"breadcrumbs":6,"title":1},"112":{"body":126,"breadcrumbs":6,"title":1},"113":{"body":8,"breadcrumbs":6,"title":2},"114":{"body":16,"breadcrumbs":5,"title":1},"115":{"body":88,"breadcrumbs":5,"title":1},"116":{"body":40,"breadcrumbs":5,"title":1},"117":{"body":30,"breadcrumbs":10,"title":4},"118":{"body":31,"breadcrumbs":7,"title":1},"119":{"body":0,"breadcrumbs":7,"title":1},"12":{"body":134,"breadcrumbs":5,"title":2},"120":{"body":118,"breadcrumbs":7,"title":1},"121":{"body":147,"breadcrumbs":12,"title":6},"122":{"body":46,"breadcrumbs":9,"title":3},"123":{"body":66,"breadcrumbs":10,"title":4},"124":{"body":60,"breadcrumbs":11,"title":5},"125":{"body":0,"breadcrumbs":7,"title":1},"126":{"body":77,"breadcrumbs":9,"title":3},"127":{"body":143,"breadcrumbs":10,"title":4},"128":{"body":126,"breadcrumbs":10,"title":4},"129":{"body":139,"breadcrumbs":10,"title":4},"13":{"body":78,"breadcrumbs":6,"title":3},"130":{"body":15,"breadcrumbs":10,"title":4},"131":{"body":13,"breadcrumbs":7,"title":1},"132":{"body":123,"breadcrumbs":7,"title":1},"133":{"body":72,"breadcrumbs":7,"title":1},"134":{"body":17,"breadcrumbs":7,"title":1},"135":{"body":8,"breadcrumbs":10,"title":4},"136":{"body":7,"breadcrumbs":7,"title":1},"137":{"body":88,"breadcrumbs":7,"title":1},"138":{"body":40,"breadcrumbs":7,"title":1},"139":{"body":32,"breadcrumbs":7,"title":1},"14":{"body":80,"breadcrumbs":7,"title":4},"140":{"body":8,"breadcrumbs":12,"title":5},"141":{"body":47,"breadcrumbs":8,"title":1},"142":{"body":61,"breadcrumbs":8,"title":1},"143":{"body":28,"breadcrumbs":8,"title":1},"144":{"body":8,"breadcrumbs":14,"title":6},"145":{"body":17,"breadcrumbs":9,"title":1},"146":{"body":115,"breadcrumbs":9,"title":1},"147":{"body":43,"breadcrumbs":9,"title":1},"148":{"body":15,"breadcrumbs":14,"title":6},"149":{"body":0,"breadcrumbs":9,"title":1},"15":{"body":121,"breadcrumbs":7,"title":4},"150":{"body":0,"breadcrumbs":9,"title":1},"151":{"body":0,"breadcrumbs":9,"title":1},"152":{"body":15,"breadcrumbs":6,"title":2},"153":{"body":3,"breadcrumbs":5,"title":1},"154":{"body":33,"breadcrumbs":5,"title":1},"155":{"body":96,"breadcrumbs":5,"title":1},"156":{"body":15,"breadcrumbs":8,"title":3},"157":{"body":14,"breadcrumbs":6,"title":1},"158":{"body":105,"breadcrumbs":6,"title":1},"159":{"body":78,"breadcrumbs":6,"title":1},"16":{"body":136,"breadcrumbs":5,"title":2},"160":{"body":15,"breadcrumbs":10,"title":4},"161":{"body":5,"breadcrumbs":7,"title":1},"162":{"body":89,"breadcrumbs":7,"title":1},"163":{"body":41,"breadcrumbs":7,"title":1},"164":{"body":8,"breadcrumbs":10,"title":4},"165":{"body":16,"breadcrumbs":7,"title":1},"166":{"body":136,"breadcrumbs":7,"title":1},"167":{"body":24,"breadcrumbs":7,"title":1},"168":{"body":183,"breadcrumbs":7,"title":1},"169":{"body":15,"breadcrumbs":8,"title":3},"17":{"body":100,"breadcrumbs":5,"title":2},"170":{"body":6,"breadcrumbs":6,"title":1},"171":{"body":123,"breadcrumbs":6,"title":1},"172":{"body":59,"breadcrumbs":6,"title":1},"173":{"body":15,"breadcrumbs":6,"title":2},"174":{"body":8,"breadcrumbs":5,"title":1},"175":{"body":54,"breadcrumbs":5,"title":1},"176":{"body":88,"breadcrumbs":6,"title":2},"177":{"body":57,"breadcrumbs":5,"title":1},"178":{"body":15,"breadcrumbs":8,"title":3},"179":{"body":9,"breadcrumbs":6,"title":1},"18":{"body":43,"breadcrumbs":5,"title":2},"180":{"body":125,"breadcrumbs":6,"title":1},"181":{"body":123,"breadcrumbs":7,"title":2},"182":{"body":41,"breadcrumbs":6,"title":1},"19":{"body":32,"breadcrumbs":5,"title":2},"2":{"body":57,"breadcrumbs":4,"title":3},"20":{"body":103,"breadcrumbs":7,"title":4},"21":{"body":127,"breadcrumbs":8,"title":5},"22":{"body":89,"breadcrumbs":4,"title":2},"23":{"body":43,"breadcrumbs":4,"title":2},"24":{"body":4,"breadcrumbs":10,"title":4},"25":{"body":23,"breadcrumbs":7,"title":1},"26":{"body":107,"breadcrumbs":7,"title":1},"27":{"body":6,"breadcrumbs":8,"title":2},"28":{"body":255,"breadcrumbs":9,"title":3},"29":{"body":43,"breadcrumbs":11,"title":5},"3":{"body":62,"breadcrumbs":6,"title":5},"30":{"body":85,"breadcrumbs":9,"title":3},"31":{"body":66,"breadcrumbs":8,"title":2},"32":{"body":198,"breadcrumbs":8,"title":2},"33":{"body":4,"breadcrumbs":12,"title":5},"34":{"body":8,"breadcrumbs":8,"title":1},"35":{"body":34,"breadcrumbs":8,"title":1},"36":{"body":4,"breadcrumbs":6,"title":2},"37":{"body":13,"breadcrumbs":5,"title":1},"38":{"body":0,"breadcrumbs":5,"title":1},"39":{"body":98,"breadcrumbs":8,"title":4},"4":{"body":41,"breadcrumbs":3,"title":2},"40":{"body":11,"breadcrumbs":6,"title":2},"41":{"body":10,"breadcrumbs":6,"title":2},"42":{"body":0,"breadcrumbs":14,"title":6},"43":{"body":5,"breadcrumbs":9,"title":1},"44":{"body":5,"breadcrumbs":9,"title":1},"45":{"body":0,"breadcrumbs":6,"title":2},"46":{"body":33,"breadcrumbs":5,"title":1},"47":{"body":34,"breadcrumbs":4,"title":2},"48":{"body":0,"breadcrumbs":6,"title":2},"49":{"body":16,"breadcrumbs":5,"title":1},"5":{"body":146,"breadcrumbs":7,"title":3},"50":{"body":109,"breadcrumbs":5,"title":1},"51":{"body":72,"breadcrumbs":5,"title":1},"52":{"body":182,"breadcrumbs":6,"title":2},"53":{"body":68,"breadcrumbs":6,"title":2},"54":{"body":134,"breadcrumbs":6,"title":2},"55":{"body":0,"breadcrumbs":10,"title":4},"56":{"body":6,"breadcrumbs":7,"title":1},"57":{"body":67,"breadcrumbs":7,"title":1},"58":{"body":84,"breadcrumbs":7,"title":1},"59":{"body":294,"breadcrumbs":8,"title":2},"6":{"body":74,"breadcrumbs":11,"title":5},"60":{"body":207,"breadcrumbs":8,"title":2},"61":{"body":0,"breadcrumbs":6,"title":2},"62":{"body":29,"breadcrumbs":5,"title":1},"63":{"body":157,"breadcrumbs":5,"title":1},"64":{"body":116,"breadcrumbs":5,"title":1},"65":{"body":15,"breadcrumbs":6,"title":2},"66":{"body":0,"breadcrumbs":8,"title":3},"67":{"body":31,"breadcrumbs":6,"title":1},"68":{"body":99,"breadcrumbs":6,"title":1},"69":{"body":110,"breadcrumbs":6,"title":1},"7":{"body":38,"breadcrumbs":8,"title":2},"70":{"body":77,"breadcrumbs":8,"title":3},"71":{"body":133,"breadcrumbs":7,"title":2},"72":{"body":132,"breadcrumbs":7,"title":2},"73":{"body":0,"breadcrumbs":8,"title":3},"74":{"body":33,"breadcrumbs":6,"title":1},"75":{"body":166,"breadcrumbs":6,"title":1},"76":{"body":108,"breadcrumbs":6,"title":1},"77":{"body":0,"breadcrumbs":6,"title":2},"78":{"body":38,"breadcrumbs":5,"title":1},"79":{"body":151,"breadcrumbs":5,"title":1},"8":{"body":103,"breadcrumbs":11,"title":5},"80":{"body":71,"breadcrumbs":5,"title":1},"81":{"body":0,"breadcrumbs":8,"title":3},"82":{"body":8,"breadcrumbs":6,"title":1},"83":{"body":13,"breadcrumbs":6,"title":1},"84":{"body":32,"breadcrumbs":6,"title":1},"85":{"body":37,"breadcrumbs":6,"title":1},"86":{"body":31,"breadcrumbs":6,"title":1},"87":{"body":0,"breadcrumbs":8,"title":3},"88":{"body":24,"breadcrumbs":6,"title":1},"89":{"body":116,"breadcrumbs":6,"title":1},"9":{"body":84,"breadcrumbs":12,"title":6},"90":{"body":81,"breadcrumbs":6,"title":1},"91":{"body":0,"breadcrumbs":8,"title":3},"92":{"body":8,"breadcrumbs":6,"title":1},"93":{"body":166,"breadcrumbs":6,"title":1},"94":{"body":39,"breadcrumbs":6,"title":1},"95":{"body":135,"breadcrumbs":4,"title":2},"96":{"body":15,"breadcrumbs":6,"title":2},"97":{"body":19,"breadcrumbs":5,"title":1},"98":{"body":98,"breadcrumbs":5,"title":1},"99":{"body":36,"breadcrumbs":7,"title":3}},"docs":{"0":{"body":"Welcome to The Rust Edition Guide! \"Editions\" are Rust's way of introducing changes into the language that would not otherwise be backwards compatible. In this guide, we'll discuss: What editions are Which changes are contained in each edition How to migrate your code from one edition to another","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"In May 2015, the release of Rust 1.0 established \" stability without stagnation \" as a core Rust axiom. Since then, Rust has committed to a pivotal rule: once a feature is released through stable , contributors will continue to support that feature for all future releases. However, there are times when it's useful to make backwards-incompatible changes to the language. A common example is the introduction of a new keyword. For instance, early versions of Rust didn't feature the async and await keywords. If Rust had suddenly introduced these new keywords, some code would have broken: let async = 1; would no longer work. Rust uses editions to solve this problem. When there are backwards-incompatible changes, they are pushed into the next edition. Since editions are opt-in, existing crates won't use the changes unless they explicitly migrate into the new edition. For example, the latest version of Rust doesn't treat async as a keyword unless edition 2018 or later is chosen. Each crate chooses its edition within its Cargo.toml file . When creating a new crate with Cargo, it will automatically select the newest stable edition.","breadcrumbs":"What are editions? » What are Editions?","id":"1","title":"What are Editions?"},"10":{"body":"After an edition is released, there is roughly a three year window before the next edition. During that window, new features may be added to the next edition, which will only be available on the nightly channel . If you want to help test those new features before they are stabilized, you can use the nightly channel to try them out. The steps are roughly similar to the stable channel: Install the most recent nightly: rustup update nightly. Run cargo +nightly fix --edition. Edit Cargo.toml and place cargo-features = [\"edition2024\"] at the top (above [package]), and change the edition field to say edition = \"2024\". Run cargo +nightly check to verify it now works in the new edition. ⚠ Caution : Features implemented in the next edition may not have automatic migrations implemented with cargo fix, and the features themselves may not be finished. When possible, this guide should contain information about which features are implemented on nightly along with more information about their status. A few months before the edition is stabilized, all of the new features should be fully implemented, and the Rust Blog will announce a call for testing.","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Migrating to an unstable edition","id":"10","title":"Migrating to an unstable edition"},"100":{"body":"","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » Migration","id":"100","title":"Migration"},"101":{"body":"When two traits that are in scope have the same method name, it is ambiguous which trait method should be used. For example: trait MyPoller { // This name is the same as the `poll` method on the `Future` trait from `std`. fn poll(&self) { println!(\"polling\"); }\n} impl<T> MyPoller for T {} fn main() { // Pin<&mut async {}> implements both `std::future::Future` and `MyPoller`. // If both traits are in scope (as would be the case in Rust 2024), // then it becomes ambiguous which `poll` method to call core::pin::pin!(async {}).poll();\n} We can fix this so that it works on all editions by using fully qualified syntax: fn main() { // Now it is clear which trait method we're referring to <_ as MyPoller>::poll(&core::pin::pin!(async {}));\n} The rust_2024_prelude_collisions lint will automatically modify any ambiguous method calls to use fully qualified syntax. This lint is part of the rust-2024-compatibility lint group, which will automatically be applied when running cargo fix --edition. To migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition Alternatively, you can manually enable the lint to find places where these qualifications need to be added: // Add this to the root of your crate to do a manual migration.\n#![warn(rust_2024_prelude_collisions)]","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » Conflicting trait methods","id":"101","title":"Conflicting trait methods"},"102":{"body":"It is strongly recommended that you migrate to a different serialization library if you are still using these. However, these derive macros are still available in the standard library, they are just required to be imported from the older prelude now: #[allow(soft_unstable)]\nuse core::prelude::v1::{RustcDecodable, RustcEncodable}; There is no automatic migration for this change; you will need to make the update manually.","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » RustcEncodable and RustcDecodable","id":"102","title":"RustcEncodable and RustcDecodable"},"103":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/123759 .","breadcrumbs":"Rust 2024 🚧 » Add IntoIterator for Box<[T]> » Add IntoIterator for Box<[T]>","id":"103","title":"Add IntoIterator for Box<[T]>"},"104":{"body":"Boxed slices implement IntoIterator in all editions. Calls to IntoIterator::into_iter are hidden in editions prior to 2024 when using method call syntax (i.e., boxed_slice.into_iter()). So, boxed_slice.into_iter() still resolves to (&(*boxed_slice)).into_iter() as it has before. boxed_slice.into_iter() changes meaning to call IntoIterator::into_iter in Rust 2024.","breadcrumbs":"Rust 2024 🚧 » Add IntoIterator for Box<[T]> » Summary","id":"104","title":"Summary"},"105":{"body":"Until Rust 1.80, IntoIterator was not implemented for boxed slices. In prior versions, if you called .into_iter() on a boxed slice, the method call would automatically dereference from Box<[T]> to &[T], and return an iterator that yielded references of &T. For example, the following worked in prior versions: // Example of behavior in previous editions.\nlet my_boxed_slice: Box<[u32]> = vec![1, 2, 3].into_boxed_slice();\n// Note: .into_iter() was required in versions older than 1.80\nfor x in my_boxed_slice.into_iter() { // x is of type &u32 in editions prior to 2024\n} In Rust 1.80, implementations of IntoIterator were added for boxed slices. This allows iterating over elements of the slice by-value instead of by-reference: // NEW as of 1.80, all editions\nlet my_boxed_slice: Box<[u32]> = vec![1, 2, 3].into_boxed_slice();\nfor x in my_boxed_slice { // notice no need for calling .into_iter() // x is of type u32\n} This example is allowed on all editions because previously this was an error since for loops do not automatically dereference like the .into_iter() method call does. However, this would normally be a breaking change because existing code that manually called .into_iter() on a boxed slice would change from having an iterator over references to an iterator over values. To resolve this problem, method calls of .into_iter() on boxed slices have edition-dependent behavior. In editions before 2024, it continues to return an iterator over references, and starting in Edition 2024 it returns an iterator over values. // Example of changed behavior in Edition 2024\nlet my_boxed_slice: Box<[u32]> = vec![1, 2, 3].into_boxed_slice();\n// Example of old code that still manually calls .into_iter()\nfor x in my_boxed_slice.into_iter() { // x is now type u32 in Edition 2024\n}","breadcrumbs":"Rust 2024 🚧 » Add IntoIterator for Box<[T]> » Details","id":"105","title":"Details"},"106":{"body":"The boxed_slice_into_iter lint will automatically modify any calls to .into_iter() on boxed slices to call .iter() instead to retain the old behavior of yielding references. This lint is part of the rust-2024-compatibility lint group, which will automatically be applied when running cargo fix --edition. To migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition For example, this will change: fn main() { let my_boxed_slice: Box<[u32]> = vec![1, 2, 3].into_boxed_slice(); for x in my_boxed_slice.into_iter() { // x is of type &u32 }\n} to be: fn main() { let my_boxed_slice: Box<[u32]> = vec![1, 2, 3].into_boxed_slice(); for x in my_boxed_slice.iter() { // x is of type &u32 }\n} The boxed_slice_into_iter lint is defaulted to warn on all editions, so unless you have manually silenced the lint, you should already see it before you migrate.","breadcrumbs":"Rust 2024 🚧 » Add IntoIterator for Box<[T]> » Migration","id":"106","title":"Migration"},"107":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/124866 .","breadcrumbs":"Rust 2024 🚧 » Newly unsafe functions » Unsafe functions","id":"107","title":"Unsafe functions"},"108":{"body":"The following functions are now marked unsafe : std::env::set_var std::env::remove_var std::os::unix::process::CommandExt::before_exec","breadcrumbs":"Rust 2024 🚧 » Newly unsafe functions » Summary","id":"108","title":"Summary"},"109":{"body":"Over time it has become evident that certain functions in the standard library should have been marked as unsafe. However, adding unsafe to a function can be a breaking change since it requires existing code to be placed in an unsafe block. To avoid the breaking change, these functions are marked as unsafe starting in the 2024 Edition, while not requiring unsafe in previous editions.","breadcrumbs":"Rust 2024 🚧 » Newly unsafe functions » Details","id":"109","title":"Details"},"11":{"body":"","breadcrumbs":"What are editions? » Advanced migrations » Advanced migration strategies","id":"11","title":"Advanced migration strategies"},"110":{"body":"It can be unsound to call std::env::set_var or std::env::remove_var in a multi-threaded program due to safety limitations of the way the process environment is handled on some platforms. The standard library originally defined these as safe functions, but it was later determined that was not correct. It is important to ensure that these functions are not called when any other thread might be running. See the Safety section of the function documentation for more details.","breadcrumbs":"Rust 2024 🚧 » Newly unsafe functions » std::env::{set_var, remove_var}","id":"110","title":"std::env::{set_var, remove_var}"},"111":{"body":"The std::os::unix::process::CommandExt::before_exec function is a unix-specific function which provides a way to run a closure before calling exec. This function was deprecated in the 1.37 release, and replaced with pre_exec which does the same thing, but is marked as unsafe. Even though before_exec is deprecated, it is now correctly marked as unsafe starting in the 2024 Edition. This should help ensure that any legacy code which has not already migrated to pre_exec to require an unsafe block. There are very strict safety requirements for the before_exec closure to satisfy. See the Safety section for more details.","breadcrumbs":"Rust 2024 🚧 » Newly unsafe functions » std::os::unix::process::CommandExt::before_exec","id":"111","title":"std::os::unix::process::CommandExt::before_exec"},"112":{"body":"To make your code compile in both the 2021 and 2024 editions, you will need to make sure that these functions are called only from within unsafe blocks. ⚠ Caution : It is important that you manually inspect the calls to these functions and possibly rewrite your code to satisfy the preconditions of those functions. In particular, set_var and remove_var should not be called if there might be multiple threads running. You may need to elect to use a different mechanism other than environment variables to manage your use case. The deprecated_safe_2024 lint will automatically modify any use of these functions to be wrapped in an unsafe block so that it can compile on both editions. This lint is part of the rust-2024-compatibility lint group, which will automatically be applied when running cargo fix --edition. To migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition For example, this will change: fn main() { std::env::set_var(\"FOO\", \"123\");\n} to be: fn main() { // TODO: Audit that the environment access only happens in single-threaded code. unsafe { std::env::set_var(\"FOO\", \"123\") };\n} Just beware that this automatic migration will not be able to verify that these functions are being used correctly. It is still your responsibility to manually review their usage. Alternatively, you can manually enable the lint to find places these functions are called: // Add this to the root of your crate to do a manual migration.\n#![warn(deprecated_safe_2024)]","breadcrumbs":"Rust 2024 🚧 » Newly unsafe functions » Migration","id":"112","title":"Migration"},"113":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\".","breadcrumbs":"Rust 2024 🚧 » unsafe_op_in_unsafe_fn warning » unsafe_op_in_unsafe_fn warning","id":"113","title":"unsafe_op_in_unsafe_fn warning"},"114":{"body":"The unsafe_op_in_unsafe_fn lint now warns by default. This warning detects calls to unsafe operations in unsafe functions without an explicit unsafe block.","breadcrumbs":"Rust 2024 🚧 » unsafe_op_in_unsafe_fn warning » Summary","id":"114","title":"Summary"},"115":{"body":"The unsafe_op_in_unsafe_fn lint will fire if there are unsafe operations in an unsafe function without an explicit unsafe {} block . # #![warn(unsafe_op_in_unsafe_fn)]\nunsafe fn get_unchecked<T>(x: &[T], i: usize) -> &T { x.get_unchecked(i) // WARNING: requires unsafe block\n} The solution is to wrap any unsafe operations in an unsafe block: # #![deny(unsafe_op_in_unsafe_fn)]\nunsafe fn get_unchecked<T>(x: &[T], i: usize) -> &T { unsafe { x.get_unchecked(i) }\n} This change is intended to help protect against accidental use of unsafe operations in an unsafe function. The unsafe function keyword was performing two roles. One was to declare that calling the function requires unsafe, and that the caller is responsible to uphold additional safety requirements. The other role was to allow the use of unsafe operations inside of the function. This second role was determined to be too risky without explicit unsafe blocks. More information and motivation may be found in RFC #2585 .","breadcrumbs":"Rust 2024 🚧 » unsafe_op_in_unsafe_fn warning » Details","id":"115","title":"Details"},"116":{"body":"The unsafe_op_in_unsafe_fn lint is part of the rust-2024-compatibility lint group. In order to migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition Alternatively, you can manually enable the lint to find places where unsafe blocks need to be added, or switch it to allow to silence the lint completely. // Add this to the root of your crate to do a manual migration.\n#![warn(unsafe_op_in_unsafe_fn)]","breadcrumbs":"Rust 2024 🚧 » unsafe_op_in_unsafe_fn warning » Migration","id":"116","title":"Migration"},"117":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". This chapter describes changes related to the Lifetime Capture Rules 2024 introduced in RFC 3498 , including how to use opaque type precise capturing (introduced in RFC 3617 ) to migrate your code.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » RPIT lifetime capture rules","id":"117","title":"RPIT lifetime capture rules"},"118":{"body":"In Rust 2024, all in-scope generic parameters, including lifetime parameters, are implicitly captured when the use<..> bound is not present. Uses of the Captures trick (Captures<..> bounds) and of the outlives trick (e.g. '_ bounds) can be replaced by use<..> bounds (in all editions) or removed entirely (in Rust 2024).","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Summary","id":"118","title":"Summary"},"119":{"body":"","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Details","id":"119","title":"Details"},"12":{"body":"cargo fix --edition works by running the equivalent of cargo check on your project with special lints enabled which will detect code that may not compile in the next edition. These lints include instructions on how to modify the code to make it compatible on both the current and the next edition. cargo fix applies these changes to the source code, and then runs cargo check again to verify that the fixes work. If the fixes fail, then it will back out the changes and display a warning. Changing the code to be simultaneously compatible with both the current and next edition makes it easier to incrementally migrate the code. If the automated migration does not completely succeed, or requires manual help, you can iterate while staying on the original edition before changing Cargo.toml to use the next edition. The lints that cargo fix --edition apply are part of a lint group . For example, when migrating from 2018 to 2021, Cargo uses the rust-2021-compatibility group of lints to fix the code. Check the Partial migration section below for tips on using individual lints to help with migration. cargo fix may run cargo check multiple times. For example, after applying one set of fixes, this may trigger new warnings which require further fixes. Cargo repeats this until no new warnings are generated.","breadcrumbs":"What are editions? » Advanced migrations » How migrations work","id":"12","title":"How migrations work"},"120":{"body":"Capturing a generic parameter in an RPIT (return-position impl Trait) opaque type allows for that parameter to be used in the corresponding hidden type. In Rust 1.82, we added use<..> bounds that allow specifying explicitly which generic parameters to capture. Those will be helpful for migrating your code to Rust 2024, and will be helpful in this chapter for explaining how the edition-specific implicit capturing rules work. These use<..> bounds look like this: # #![feature(precise_capturing)]\nfn capture<'a, T>(x: &'a (), y: T) -> impl Sized + use<'a, T> { // ~~~~~~~~~~~~~~~~~~~~~~~ // This is the RPIT opaque type. // // It captures `'a` and `T`. (x, y) //~~~~~~ // The hidden type is: `(&'a (), T)`. // // This type can use `'a` and `T` because they were captured.\n} The generic parameters that are captured affect how the opaque type can be used. E.g., this is an error because the lifetime is captured despite the fact that the hidden type does not use the lifetime: # #![feature(precise_capturing)]\nfn capture<'a>(_: &'a ()) -> impl Sized + use<'a> {} fn test<'a>(x: &'a ()) -> impl Sized + 'static { capture(x) //~^ ERROR lifetime may not live long enough\n} Conversely, this is OK: # #![feature(precise_capturing)]\nfn capture<'a>(_: &'a ()) -> impl Sized + use<> {} fn test<'a>(x: &'a ()) -> impl Sized + 'static { capture(x) //~ OK\n}","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Capturing","id":"120","title":"Capturing"},"121":{"body":"If the use<..> bound is not present, then the compiler uses edition-specific rules to decide which in-scope generic parameters to capture implicitly. In all editions, all in-scope type and const generic parameters are captured implicitly when the use<..> bound is not present. E.g.: # #![feature(precise_capturing)]\nfn f_implicit<T, const C: usize>() -> impl Sized {}\n// ~~~~~~~~~~\n// No `use<..>` bound is present here.\n//\n// In all editions, the above is equivalent to:\nfn f_explicit<T, const C: usize>() -> impl Sized + use<T, C> {} In Rust 2021 and earlier editions, when the use<..> bound is not present, generic lifetime parameters are only captured when they appear syntactically within a bound in RPIT opaque types in the signature of bare functions and associated functions and methods within inherent impls. However, starting in Rust 2024, these in-scope generic lifetime parameters are unconditionally captured. E.g.: # #![feature(precise_capturing)]\nfn f_implicit(_: &()) -> impl Sized {}\n// In Rust 2021 and earlier, the above is equivalent to:\nfn f_2021(_: &()) -> impl Sized + use<> {}\n// In Rust 2024 and later, it's equivalent to:\nfn f_2024(_: &()) -> impl Sized + use<'_> {} This makes the behavior consistent with RPIT opaque types in the signature of associated functions and methods within trait impls, uses of RPIT within trait definitions (RPITIT), and opaque Future types created by async fn, all of which implicitly capture all in-scope generic lifetime parameters in all editions when the use<..> bound is not present.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Edition-specific rules when no use<..> bound is present","id":"121","title":"Edition-specific rules when no use<..> bound is present"},"122":{"body":"Generic parameters from an outer impl are considered to be in scope when deciding what is implicitly captured. E.g.: # #![feature(precise_capturing)]\nstruct S<T, const C: usize>((T, [(); C]));\nimpl<T, const C: usize> S<T, C> {\n// ~~~~~~~~~~~~~~~~~\n// These generic parameters are in scope. fn f_implicit<U>() -> impl Sized {} // ~ ~~~~~~~~~~ // ^ This generic is in scope too. // ^ // | // No `use<..>` bound is present here. // // In all editions, it's equivalent to: fn f_explicit<U>() -> impl Sized + use<T, U, C> {}\n}","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Outer generic parameters","id":"122","title":"Outer generic parameters"},"123":{"body":"Similarly, generic lifetime parameters introduced into scope by a higher-ranked for<..> binder are considered to be in scope. E.g.: # #![feature(precise_capturing)]\ntrait Tr<'a> { type Ty; }\nimpl Tr<'_> for () { type Ty = (); } fn f_implicit() -> impl for<'a> Tr<'a, Ty = impl Copy> {}\n// In Rust 2021 and earlier, the above is equivalent to:\nfn f_2021() -> impl for<'a> Tr<'a, Ty = impl Copy + use<>> {}\n// In Rust 2024 and later, it's equivalent to:\n//fn f_2024() -> impl for<'a> Tr<'a, Ty = impl Copy + use<'a>> {}\n// ~~~~~~~~~~~~~~~~~~~~\n// However, note that the capturing of higher-ranked lifetimes in\n// nested opaque types is not yet supported.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Lifetimes from higher-ranked binders","id":"123","title":"Lifetimes from higher-ranked binders"},"124":{"body":"Anonymous (i.e. unnamed) generic parameters created by the use of APIT (argument position impl Trait) are considered to be in scope. E.g.: # #![feature(precise_capturing)]\nfn f_implicit(_: impl Sized) -> impl Sized {}\n// ~~~~~~~~~~\n// This is called APIT.\n//\n// The above is *roughly* equivalent to:\nfn f_explicit<_0: Sized>(_: _0) -> impl Sized + use<_0> {} Note that the former is not exactly equivalent to the latter because, by naming the generic parameter, turbofish syntax can now be used to provide an argument for it. There is no way to explicitly include an anonymous generic parameter in a use<..> bound other than by converting it to a named generic parameter.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Argument position impl Trait (APIT)","id":"124","title":"Argument position impl Trait (APIT)"},"125":{"body":"","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Migration","id":"125","title":"Migration"},"126":{"body":"The impl_trait_overcaptures lint flags RPIT opaque types that will capture additional lifetimes in Rust 2024. This lint is part of the rust-2024-compatibility lint group which is automatically applied when running cargo fix --edition. In most cases, the lint can automatically insert use<..> bounds where needed such that no additional lifetimes are captured in Rust 2024. To migrate your code to be compatible with Rust 2024, run: cargo fix --edition For example, this will change: fn f<'a>(x: &'a ()) -> impl Sized { *x } ...into: # #![feature(precise_capturing)]\nfn f<'a>(x: &'a ()) -> impl Sized + use<> { *x } Without this use<> bound, in Rust 2024, the opaque type would capture the 'a lifetime parameter. By adding this bound, the migration lint preserves the existing semantics.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Migrating while avoiding overcapturing","id":"126","title":"Migrating while avoiding overcapturing"},"127":{"body":"In some cases, the lint cannot make the change automatically because a generic parameter needs to be given a name so that it can appear within a use<..> bound. In these cases, the lint will alert you that a change may need to be made manually. E.g., given: fn f<'a>(x: &'a (), y: impl Sized) -> impl Sized { (*x, y) }\n// ^^ ~~~~~~~~~~\n// This is a use of APIT.\n//\n//~^ WARN `impl Sized` will capture more lifetimes than possibly intended in edition 2024\n//~| NOTE specifically, this lifetime is in scope but not mentioned in the type's bounds\n#\n# fn test<'a>(x: &'a (), y: ()) -> impl Sized + 'static {\n# f(x, y)\n# } The code cannot be converted automatically because of the use of APIT and the fact that the generic type parameter must be named in the use<..> bound. To convert this code to Rust 2024 without capturing the lifetime, you must name that type parameter. E.g.: # #![feature(precise_capturing)]\n# #![deny(impl_trait_overcaptures)]\nfn f<'a, T: Sized>(x: &'a (), y: T) -> impl Sized + use<T> { (*x, y) }\n// ~~~~~~~~\n// The type parameter has been named here.\n#\n# fn test<'a>(x: &'a (), y: ()) -> impl Sized + use<> {\n# f(x, y)\n# } Note that this changes the API of the function slightly as a type argument can now be explicitly provided for this parameter using turbofish syntax. If this is undesired, you might consider instead whether you can simply continue to omit the use<..> bound and allow the lifetime to be captured. This might be particularly desirable if you might in the future want to use that lifetime in the hidden type and would like to save space for that.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Migrating cases involving APIT","id":"127","title":"Migrating cases involving APIT"},"128":{"body":"Prior to the introduction of precise capturing use<..> bounds in Rust 1.82, correctly capturing a lifetime in an RPIT opaque type often required using the Captures trick. E.g.: #[doc(hidden)]\npub trait Captures<T: ?Sized> {}\nimpl<T: ?Sized, U: ?Sized> Captures<T> for U {} fn f<'a, T>(x: &'a (), y: T) -> impl Sized + Captures<(&'a (), T)> {\n// ~~~~~~~~~~~~~~~~~~~~~\n// This is called the `Captures` trick. (x, y)\n}\n#\n# fn test<'t, 'x>(t: &'t (), x: &'x ()) {\n# f(t, x);\n# } With the use<..> bound syntax, the Captures trick is no longer needed and can be replaced with the following in all editions: # #![feature(precise_capturing)]\nfn f<'a, T>(x: &'a (), y: T) -> impl Sized + use<'a, T> { (x, y)\n}\n#\n# fn test<'t, 'x>(t: &'t (), x: &'x ()) {\n# f(t, x);\n# } In Rust 2024, the use<..> bound can often be omitted entirely, and the above can be written simply as: # #![feature(lifetime_capture_rules_2024)]\nfn f<'a, T>(x: &'a (), y: T) -> impl Sized { (x, y)\n}\n#\n# fn test<'t, 'x>(t: &'t (), x: &'x ()) {\n# f(t, x);\n# } There is no automatic migration for this, and the Captures trick still works in Rust 2024, but you might want to consider migrating code manually away from using this old trick.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Migrating away from the Captures trick","id":"128","title":"Migrating away from the Captures trick"},"129":{"body":"Prior to the introduction of precise capturing use<..> bounds in Rust 1.82, it was common to use the \"outlives trick\" when a lifetime needed to be used in the hidden type of some opaque. E.g.: fn f<'a, T: 'a>(x: &'a (), y: T) -> impl Sized + 'a { // ~~~~ ~~~~ // ^ This is the outlives trick. // | // This bound is needed only for the trick. (x, y)\n// ~~~~~~\n// The hidden type is `(&'a (), T)`.\n} This trick was less baroque than the Captures trick, but also less correct. As we can see in the example above, even though any lifetime components within T are independent from the lifetime 'a, we're required to add a T: 'a bound in order to make the trick work. This created undue and surprising restrictions on callers. Using precise capturing, you can write the above instead, in all editions, as: # #![feature(precise_capturing)]\nfn f<T>(x: &(), y: T) -> impl Sized + use<'_, T> { (x, y)\n}\n#\n# fn test<'t, 'x>(t: &'t (), x: &'x ()) {\n# f(t, x);\n# } In Rust 2024, the use<..> bound can often be omitted entirely, and the above can be written simply as: # #![feature(precise_capturing)]\n# #![feature(lifetime_capture_rules_2024)]\nfn f<T>(x: &(), y: T) -> impl Sized { (x, y)\n}\n#\n# fn test<'t, 'x>(t: &'t (), x: &'x ()) {\n# f(t, x);\n# } There is no automatic migration for this, and the outlives trick still works in Rust 2024, but you might want to consider migrating code manually away from using this old trick.","breadcrumbs":"Rust 2024 🚧 » RPIT lifetime capture rules » Migrating away from the outlives trick","id":"129","title":"Migrating away from the outlives trick"},"13":{"body":"cargo fix can only work with a single configuration at a time. If you use Cargo features or conditional compilation , then you may need to run cargo fix multiple times with different flags. For example, if you have code that uses #[cfg] attributes to include different code for different platforms, you may need to run cargo fix with the --target option to fix for different targets. This may require moving your code between machines if you don't have cross-compiling available. Similarly, if you have conditions on Cargo features, like #[cfg(feature = \"my-optional-thing\")], it is recommended to use the --all-features flag to allow cargo fix to migrate all the code behind those feature gates. If you want to migrate feature code individually, you can use the --features flag to migrate one at a time.","breadcrumbs":"What are editions? » Advanced migrations » Migrating multiple configurations","id":"13","title":"Migrating multiple configurations"},"130":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/123758 .","breadcrumbs":"Rust 2024 🚧 » Disallow references to static mut » Disallow references to static mut","id":"130","title":"Disallow references to static mut"},"131":{"body":"The static_mut_refs lint level is now deny by default. This checks for taking a shared or mutable reference to a static mut.","breadcrumbs":"Rust 2024 🚧 » Disallow references to static mut » Summary","id":"131","title":"Summary"},"132":{"body":"The static_mut_refs lint detects taking a reference to a static mut . In the 2024 Edition, this lint is now deny by default to emphasize that you should avoid making these references. static mut X: i32 = 23;\nstatic mut Y: i32 = 24; unsafe { let y = &X; // ERROR: shared reference to mutable static let ref x = X; // ERROR: shared reference to mutable static let (x, y) = (&X, &Y); // ERROR: shared reference to mutable static\n} Merely taking such a reference in violation of Rust's mutability XOR aliasing requirement has always been instantaneous undefined behavior , even if the reference is never read from or written to . Furthermore, upholding mutability XOR aliasing for a static mut requires reasoning about your code globally , which can be particularly difficult in the face of reentrancy and/or multithreading. Note that there are some cases where implicit references are automatically created without a visible & operator. For example, these situations will also trigger the lint: static mut NUMS: &[u8; 3] = &[0, 1, 2]; unsafe { println!(\"{NUMS:?}\"); // ERROR: shared reference to mutable static let n = NUMS.len(); // ERROR: shared reference to mutable static\n}","breadcrumbs":"Rust 2024 🚧 » Disallow references to static mut » Details","id":"132","title":"Details"},"133":{"body":"Wherever possible, it is strongly recommended to use instead an immutable static of a type that provides interior mutability behind some locally-reasoned abstraction (which greatly reduces the complexity of ensuring that Rust's mutability XOR aliasing requirement is upheld). In situations where no locally-reasoned abstraction is possible and you are therefore compelled still to reason globally about accesses to your static variable, you must now use raw pointers such as can be obtained via the &raw const or &raw mut operators . By first obtaining a raw pointer rather than directly taking a reference, (the safety requirements of) accesses through that pointer will be more familiar to unsafe developers and can be deferred until/limited to smaller regions of code.","breadcrumbs":"Rust 2024 🚧 » Disallow references to static mut » Alternatives","id":"133","title":"Alternatives"},"134":{"body":"There is no automatic migration to fix these references to static mut. To avoid undefined behavior you must rewrite your code to use a different approach as recommended in the Alternatives section.","breadcrumbs":"Rust 2024 🚧 » Disallow references to static mut » Migration","id":"134","title":"Migration"},"135":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\".","breadcrumbs":"Rust 2024 🚧 » Cargo: Remove implicit features » Cargo: Remove implicit features","id":"135","title":"Cargo: Remove implicit features"},"136":{"body":"Optional dependencies must now be explicitly specified in the [features] table.","breadcrumbs":"Rust 2024 🚧 » Cargo: Remove implicit features » Summary","id":"136","title":"Summary"},"137":{"body":"In previous editions, when an optional dependency is specified, Cargo would automatically add an implicit feature of the same name as the dependency. For example: [dependencies]\njpeg-decoder = { version = \"0.3.1\", optional = true } This would automatically add a feature jpeg-decoder = [\"dep:jpeg-decoder\"] to provide a way to enable the dependency. The dep: entries are specific syntax for referring to optional dependencies. This implicit feature is only added if \"dep:jpeg-decoder\" is not specified in any other feature. In the 2024 Edition, this implicit feature is no longer added, and you are required to explicitly specify the dependency in the [features] table. For example, instead of exposing the particular internal name of some dependency, you may consider using a more general term for the feature name: [features]\ngraphics = [\"dep:jpeg-decoder\"] cargo add --optional <NAME> automatically adds a feature for the dependency to the [features] table if it isn't already there.","breadcrumbs":"Rust 2024 🚧 » Cargo: Remove implicit features » Details","id":"137","title":"Details"},"138":{"body":"One reason for requiring this to be explicit is that it encourages a conscious decision about the public exposure of the feature name, and makes it clearer when reading the [features] table which features exist. This can help avoid tying the implementation details (the dependency names) to the public set of feature names. Also, removing features is a SemVer incompatible change , which may not be obvious when removing an optional dependency that you thought was private.","breadcrumbs":"Rust 2024 🚧 » Cargo: Remove implicit features » Motivation","id":"138","title":"Motivation"},"139":{"body":"When using cargo fix --edition, Cargo will automatically update your Cargo.toml file to include the implicit features if necessary. If you would prefer to update your Cargo.toml manually, add a foo = [\"dep:foo\"] entry for each optional dependency named foo if dep:foo is not already specified anywhere in the [features] table.","breadcrumbs":"Rust 2024 🚧 » Cargo: Remove implicit features » Migration","id":"139","title":"Migration"},"14":{"body":"You can migrate a large project incrementally to make the process easier if you run into problems. In a Cargo workspace , each package defines its own edition, so the process naturally involves migrating one package at a time. Within a Cargo package , you can either migrate the entire package at once, or migrate individual Cargo targets one at a time. For example, if you have multiple binaries, tests, and examples, you can use specific target selection flags with cargo fix --edition to migrate just that one target. By default, cargo fix uses --all-targets. For even more advanced cases, you can specify the edition for each individual target in Cargo.toml like this: [[bin]]\nname = \"my-binary\"\nedition = \"2018\" This usually should not be required, but is an option if you have a lot of targets and are having difficulty migrating them all together.","breadcrumbs":"What are editions? » Advanced migrations » Migrating a large project or workspace","id":"14","title":"Migrating a large project or workspace"},"140":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\".","breadcrumbs":"Rust 2024 🚧 » Cargo: Table and key name consistency » Cargo: Table and key name consistency","id":"140","title":"Cargo: Table and key name consistency"},"141":{"body":"Several table and key names in Cargo.toml have been removed where there were previously two ways to specify the same thing. Removed [project]; use [package] instead. Removed default_features; use default-features instead. Removed crate_type; use crate-type instead. Removed proc_macro; use proc-macro instead. Removed dev_dependencies; use dev-dependencies instead. Removed build_dependencies; use build-dependencies instead.","breadcrumbs":"Rust 2024 🚧 » Cargo: Table and key name consistency » Summary","id":"141","title":"Summary"},"142":{"body":"Several table and keys names are no longer allowed in the 2024 Edition. There were two ways to specify these tables or keys, and this helps ensure there is only one way to specify them. Some were due to a change in decisions over time, and some were inadvertent implementation artifacts. In order to avoid confusion, and to enforce a single style for specifying these tables and keys, only one variant is now allowed. For example: [dev_dependencies]\nrand = { version = \"0.8.5\", default_features = false } Should be changed to: [dev-dependencies]\nrand = { version = \"0.8.5\", default-features = false } Notice that the underscores were changed to dashes for dev_dependencies and default_features.","breadcrumbs":"Rust 2024 🚧 » Cargo: Table and key name consistency » Details","id":"142","title":"Details"},"143":{"body":"When using cargo fix --edition, Cargo will automatically update your Cargo.toml file to use the preferred table and key names. If you would prefer to update your Cargo.toml manually, be sure to go through the list above and make sure only the new forms are used.","breadcrumbs":"Rust 2024 🚧 » Cargo: Table and key name consistency » Migration","id":"143","title":"Migration"},"144":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\".","breadcrumbs":"Rust 2024 🚧 » Cargo: Reject unused inherited default-features » Cargo: Reject unused inherited default-features","id":"144","title":"Cargo: Reject unused inherited default-features"},"145":{"body":"default-features = false is no longer allowed in an inherited workspace dependency if the workspace dependency specifies default-features = true (or does not specify default-features).","breadcrumbs":"Rust 2024 🚧 » Cargo: Reject unused inherited default-features » Summary","id":"145","title":"Summary"},"146":{"body":"Workspace inheritance allows you to specify dependencies in one place (the workspace), and then to refer to those workspace dependencies from within a package. There was an inadvertent interaction with how default-features is specified that is no longer allowed in the 2024 Edition. Unless the workspace specifies default-features = false, it is no longer allowed to specify default-features = false in an inherited package dependency. For example, with a workspace that specifies: [workspace.dependencies]\nregex = \"1.10.4\" The following is now an error: [package]\nname = \"foo\"\nversion = \"1.0.0\"\nedition = \"2024\" [dependencies]\nregex = { workspace = true, default-features = false } # ERROR The reason for this change is to avoid confusion when specifying default-features = false when the default feature is already enabled, since it has no effect. If you want the flexibility of deciding whether or not a dependency enables the default-features of a dependency, be sure to set default-features = false in the workspace definition. Just beware that if you build multiple workspace members at the same time, the features will be unified so that if one member sets default-features = true (which is the default if not explicitly set), the default-features will be enabled for all members using that dependency.","breadcrumbs":"Rust 2024 🚧 » Cargo: Reject unused inherited default-features » Details","id":"146","title":"Details"},"147":{"body":"When using cargo fix --edition, Cargo will automatically update your Cargo.toml file to remove default-features = false in this situation. If you would prefer to update your Cargo.toml manually, check for any warnings when running a build and remove the corresponding entries. Previous editions should display something like: warning: /home/project/Cargo.toml: `default-features` is ignored for regex,\nsince `default-features` was not specified for `workspace.dependencies.regex`,\nthis could become a hard error in the future","breadcrumbs":"Rust 2024 🚧 » Cargo: Reject unused inherited default-features » Migration","id":"147","title":"Migration"},"148":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". This feature is not yet implemented. More information may be found in https://github.com/rust-lang/rust/pull/114764 .","breadcrumbs":"Rust 2024 🚧 » Rustfmt: Combine all delimited exprs as last argument » Rustfmt: Combine all delimited exprs as last argument","id":"148","title":"Rustfmt: Combine all delimited exprs as last argument"},"149":{"body":"","breadcrumbs":"Rust 2024 🚧 » Rustfmt: Combine all delimited exprs as last argument » Summary","id":"149","title":"Summary"},"15":{"body":"Sometimes the fixes suggested by the compiler may fail to work. When this happens, Cargo will report a warning indicating what happened and what the error was. However, by default it will automatically back out the changes it made. It can be helpful to keep the code in the broken state and manually resolve the issue. Some of the fixes may have been correct, and the broken fix may be mostly correct, but just need minor tweaking. In this situation, use the --broken-code option with cargo fix to tell Cargo not to back out the changes. Then, you can go manually inspect the error and investigate what is needed to fix it. Another option to incrementally migrate a project is to apply individual fixes separately, one at a time. You can do this by adding the individual lints as warnings, and then either running cargo fix (without the --edition flag) or using your editor or IDE to apply its suggestions if it supports \"Quick Fixes\". For example, the 2018 edition uses the keyword-idents lint to fix any conflicting keywords. You can add #![warn(keyword_idents)] to the top of each crate (like at the top of src/lib.rs or src/main.rs). Then, running cargo fix will apply just the suggestions for that lint. You can see the list of lints enabled for each edition in the lint group page, or run the rustc -Whelp command.","breadcrumbs":"What are editions? » Advanced migrations » Partial migration with broken code","id":"15","title":"Partial migration with broken code"},"150":{"body":"","breadcrumbs":"Rust 2024 🚧 » Rustfmt: Combine all delimited exprs as last argument » Details","id":"150","title":"Details"},"151":{"body":"","breadcrumbs":"Rust 2024 🚧 » Rustfmt: Combine all delimited exprs as last argument » Migration","id":"151","title":"Migration"},"152":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/123904 .","breadcrumbs":"Rust 2024 🚧 » gen keyword » gen keyword","id":"152","title":"gen keyword"},"153":{"body":"gen is a reserved keyword .","breadcrumbs":"Rust 2024 🚧 » gen keyword » Summary","id":"153","title":"Summary"},"154":{"body":"The gen keyword has been reserved as part of RFC #3513 to introduce \"gen blocks\" in a future release of Rust. gen blocks will provide a way to make it easier to write certain kinds of iterators. Reserving the keyword now will make it easier to stabilize gen blocks before the next edition.","breadcrumbs":"Rust 2024 🚧 » gen keyword » Details","id":"154","title":"Details"},"155":{"body":"Introducing the gen keyword can cause a problem for any identifiers that are already called gen. For example, any variable or function name called gen would clash with the new keyword. To overcome this, Rust supports the r# prefix for a raw identifier , which allows identifiers to overlap with keywords. The keyword_idents_2024 lint will automatically modify any identifier named gen to be r#gen so that code continues to work on both editions. This lint is part of the rust-2024-compatibility lint group, which will automatically be applied when running cargo fix --edition. To migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition For example, this will change: fn gen() { println!(\"generating!\");\n} fn main() { gen();\n} to be: fn r#gen() { println!(\"generating!\");\n} fn main() { r#gen();\n} Alternatively, you can manually enable the lint to find places where gen identifiers need to be modified to r#gen: // Add this to the root of your crate to do a manual migration.\n#![warn(keyword_idents_2024)]","breadcrumbs":"Rust 2024 🚧 » gen keyword » Migration","id":"155","title":"Migration"},"156":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/123742 .","breadcrumbs":"Rust 2024 🚧 » Macro fragment specifiers » Macro Fragment Specifiers","id":"156","title":"Macro Fragment Specifiers"},"157":{"body":"The expr fragment specifier now also supports const and _ expressions. The expr_2021 fragment specifier has been added for backwards compatibility.","breadcrumbs":"Rust 2024 🚧 » Macro fragment specifiers » Summary","id":"157","title":"Summary"},"158":{"body":"As new syntax is added to Rust, existing macro_rules fragment specifiers are sometimes not allowed to match on the new syntax in order to retain backwards compatibility. Supporting the new syntax in the old fragment specifiers is sometimes deferred until the next edition, which provides an opportunity to update them. Indeed this happened with const expressions added in 1.79 and _ expressions added in 1.59. In the 2021 Edition and earlier, the expr fragment specifier does not match those expressions. This is because you may have a scenario like: macro_rules! example { ($e:expr) => { println!(\"first rule\"); }; (const $e:expr) => { println!(\"second rule\"); };\n} fn main() { example!(const { 1 + 1 });\n} Here, in the 2021 Edition, the macro will match the second rule. If earlier editions had changed expr to match the newly introduced const expressions, then it would match the first rule, which would be a breaking change. In the 2024 Edition, expr specifiers now also match const and _ expressions. To support the old behavior, the expr_2021 fragment specifier has been added which does not match the new expressions.","breadcrumbs":"Rust 2024 🚧 » Macro fragment specifiers » Details","id":"158","title":"Details"},"159":{"body":"The edition_2024_expr_fragment_specifier lint will change all uses of the expr specifier to expr_2021 to ensure that the behavior of existing macros does not change. The lint is part of the rust-2024-compatibility lint group which is included in the automatic edition migration. In order to migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition In most cases, you will likely want to keep the expr specifier instead, in order to support the new expressions. You will need to review your macro to determine if there are other rules that would otherwise match with const or _ and determine if there is a conflict. If you want the new behavior, just revert any changes made by the lint. Alternatively, you can manually enable the lint to find macros where you may need to update the expr specifier. // Add this to the root of your crate to do a manual migration.\n#![warn(edition_2024_expr_fragment_specifier)]","breadcrumbs":"Rust 2024 🚧 » Macro fragment specifiers » Migration","id":"159","title":"Migration"},"16":{"body":"Some macros may require manual work to fix them for the next edition. For example, cargo fix --edition may not be able to automatically fix a macro that generates syntax that does not work in the next edition. This may be a problem for both proc macros and macro_rules-style macros. macro_rules macros can sometimes be automatically updated if the macro is used within the same crate, but there are several situations where it cannot. Proc macros in general cannot be automatically fixed at all. For example, if we migrate a crate containing this (contrived) macro foo from 2015 to 2018, foo would not be automatically fixed. #[macro_export]\nmacro_rules! foo { () => { let dyn = 1; println!(\"it is {}\", dyn); };\n} When this macro is defined in a 2015 crate, it can be used from a crate of any other edition due to macro hygiene (discussed below). In 2015, dyn is a normal identifier and can be used without restriction. However, in 2018, dyn is no longer a valid identifier. When using cargo fix --edition to migrate to 2018, Cargo won't display any warnings or errors at all. However, foo won't work when called from any crate. If you have macros, you are encouraged to make sure you have tests that fully cover the macro's syntax. You may also want to test the macros by importing and using them in crates from multiple editions, just to ensure it works correctly everywhere. If you run into issues, you'll need to read through the chapters of this guide to understand how the code can be changed to work across all editions.","breadcrumbs":"What are editions? » Advanced migrations » Migrating macros","id":"16","title":"Migrating macros"},"160":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/128143 .","breadcrumbs":"Rust 2024 🚧 » Missing macro fragment specifiers » Missing macro fragment specifiers","id":"160","title":"Missing macro fragment specifiers"},"161":{"body":"The missing_fragment_specifier lint is now a hard error.","breadcrumbs":"Rust 2024 🚧 » Missing macro fragment specifiers » Summary","id":"161","title":"Summary"},"162":{"body":"The missing_fragment_specifier lint detects a situation when an unused pattern in a macro_rules! macro definition has a meta-variable (e.g. $e) that is not followed by a fragment specifier (e.g. :expr). This is now a hard error in the 2024 Edition. macro_rules! foo { () => {}; ($name) => { }; // ERROR: missing fragment specifier\n} fn main() { foo!();\n} Calling the macro with arguments that would match a rule with a missing specifier (e.g., foo!($name)) is a hard error in all editions. However, simply defining a macro with missing fragment specifiers is not, though we did add a lint in Rust 1.17. We'd like to make this a hard error in all editions, but there would be too much breakage right now. So we're starting by making this a hard error in Rust 2024. [1] The lint is marked as a \"future-incompatible\" warning to indicate that it may become a hard error in all editions in a future release. See #40107 for more information.","breadcrumbs":"Rust 2024 🚧 » Missing macro fragment specifiers » Details","id":"162","title":"Details"},"163":{"body":"To migrate your code to the 2024 Edition, remove the unused matcher rule from the macro. The missing_fragment_specifier lint is on by default in all editions, and should alert you to macros with this issue. There is no automatic migration for this change. We expect that this style of macro is extremely rare. The lint has been a future-incompatibility lint since Rust 1.17, a deny-by-default lint since Rust 1.20, and since Rust 1.82, it has warned about dependencies that are using this pattern.","breadcrumbs":"Rust 2024 🚧 » Missing macro fragment specifiers » Migration","id":"163","title":"Migration"},"164":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\".","breadcrumbs":"Rust 2024 🚧 » Never type fallback change » Never type fallback change","id":"164","title":"Never type fallback change"},"165":{"body":"Never type (!) to any type (\"never-to-any\") coercions fall back to never type (!) rather than to unit type (()). The never_type_fallback_flowing_into_unsafe lint is now deny by default.","breadcrumbs":"Rust 2024 🚧 » Never type fallback change » Summary","id":"165","title":"Summary"},"166":{"body":"When the compiler sees a value of type ! (never) in a coercion site , it implicitly inserts a coercion to allow the type checker to infer any type: # #![feature(never_type)]\n// This:\nlet x: u8 = panic!(); // ...is (essentially) turned by the compiler into:\nlet x: u8 = absurd(panic!()); // ...where `absurd` is the following function\n// (it's sound because `!` always marks unreachable code):\nfn absurd<T>(x: !) -> T { x } This can lead to compilation errors if the type cannot be inferred: # #![feature(never_type)]\n# fn absurd<T>(x: !) -> T { x }\n// This:\n{ panic!() }; // ...gets turned into this:\n{ absurd(panic!()) }; //~ ERROR can't infer the type of `absurd` To prevent such errors, the compiler remembers where it inserted absurd calls, and if it can't infer the type, it uses the fallback type instead: # #![feature(never_type)]\n# fn absurd<T>(x: !) -> T { x }\ntype Fallback = /* An arbitrarily selected type! */ !;\n{ absurd::<Fallback>(panic!()) } This is what is known as \"never type fallback\". Historically, the fallback type has been () (unit). This caused ! to spontaneously coerce to () even when the compiler would not infer () without the fallback. That was confusing and has prevented the stabilization of the ! type. In the 2024 edition, the fallback type is now !. (We plan to make this change across all editions at a later date.) This makes things work more intuitively. Now when you pass ! and there is no reason to coerce it to something else, it is kept as !. In some cases your code might depend on the fallback type being (), so this can cause compilation errors or changes in behavior.","breadcrumbs":"Rust 2024 🚧 » Never type fallback change » Details","id":"166","title":"Details"},"167":{"body":"The default level of the never_type_fallback_flowing_into_unsafe lint has been raised from warn to deny in the 2024 Edition. This lint helps detect a particular interaction with the fallback to ! and unsafe code which may lead to undefined behavior. See the link for a complete description.","breadcrumbs":"Rust 2024 🚧 » Never type fallback change » never_type_fallback_flowing_into_unsafe","id":"167","title":"never_type_fallback_flowing_into_unsafe"},"168":{"body":"There is no automatic fix, but there is automatic detection of code that will be broken by the edition change. While still on a previous edition you will see warnings if your code will be broken. The fix is to specify the type explicitly so that the fallback type is not used. Unfortunately, it might not be trivial to see which type needs to be specified. One of the most common patterns broken by this change is using f()?; where f is generic over the Ok-part of the return type: # #![allow(dependency_on_unit_never_type_fallback)]\n# fn outer<T>(x: T) -> Result<T, ()> {\nfn f<T: Default>() -> Result<T, ()> { Ok(T::default())\n} f()?;\n# Ok(x)\n# } You might think that, in this example, type T can't be inferred. However, due to the current desugaring of the ? operator, it was inferred as (), and it will now be inferred as !. To fix the issue you need to specify the T type explicitly: # #![deny(dependency_on_unit_never_type_fallback)]\n# fn outer<T>(x: T) -> Result<T, ()> {\n# fn f<T: Default>() -> Result<T, ()> {\n# Ok(T::default())\n# }\nf::<()>()?;\n// ...or:\n() = f()?;\n# Ok(x)\n# } Another relatively common case is panicking in a closure: # #![allow(dependency_on_unit_never_type_fallback)]\ntrait Unit {}\nimpl Unit for () {} fn run<R: Unit>(f: impl FnOnce() -> R) { f();\n} run(|| panic!()); Previously ! from the panic! coerced to () which implements Unit. However now the ! is kept as ! so this code fails because ! doesn't implement Unit. To fix this you can specify the return type of the closure: # #![deny(dependency_on_unit_never_type_fallback)]\n# trait Unit {}\n# impl Unit for () {}\n#\n# fn run<R: Unit>(f: impl FnOnce() -> R) {\n# f();\n# }\nrun(|| -> () { panic!() }); A similar case to that of f()? can be seen when using a !-typed expression in one branch and a function with an unconstrained return type in the other: # #![allow(dependency_on_unit_never_type_fallback)]\nif true { Default::default()\n} else { return\n}; Previously () was inferred as the return type of Default::default() because ! from return was spuriously coerced to (). Now, ! will be inferred instead causing this code to not compile because ! does not implement Default. Again, this can be fixed by specifying the type explicitly: # #![deny(dependency_on_unit_never_type_fallback)]\n() = if true { Default::default()\n} else { return\n}; // ...or: if true { <() as Default>::default()\n} else { return\n};","breadcrumbs":"Rust 2024 🚧 » Never type fallback change » Migration","id":"168","title":"Migration"},"169":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/123743 .","breadcrumbs":"Rust 2024 🚧 » Unsafe extern blocks » Unsafe extern blocks","id":"169","title":"Unsafe extern blocks"},"17":{"body":"Macros use a system called \"edition hygiene\" where the tokens within a macro are marked with which edition they come from. This allows external macros to be called from crates of varying editions without needing to worry about which edition it is called from. Let's take a closer look at the example above that defines a macro_rules macro using dyn as an identifier. If that macro was defined in a crate using the 2015 edition, then that macro works fine, even if it were called from a 2018 crate where dyn is a keyword and that would normally be a syntax error. The let dyn = 1; tokens are marked as being from 2015, and the compiler will remember that wherever that code gets expanded. The parser looks at the edition of the tokens to know how to interpret it. The problem arises when changing the edition to 2018 in the crate where it is defined. Now, those tokens are tagged with the 2018 edition, and those will fail to parse. However, since we never called the macro from our crate, cargo fix --edition never had a chance to inspect the macro and fix it.","breadcrumbs":"What are editions? » Advanced migrations » Macro hygiene","id":"17","title":"Macro hygiene"},"170":{"body":"extern blocks must now be marked with the unsafe keyword.","breadcrumbs":"Rust 2024 🚧 » Unsafe extern blocks » Summary","id":"170","title":"Summary"},"171":{"body":"Rust 1.82 added the ability in all editions to mark extern blocks with the unsafe keyword. [1] Adding the unsafe keyword helps to emphasize that it is the responsibility of the author of the extern block to ensure that the signatures are correct. If the signatures are not correct, then it may result in undefined behavior. The syntax for an unsafe extern block looks like this: unsafe extern \"C\" { // sqrt (from libm) may be called with any `f64` pub safe fn sqrt(x: f64) -> f64; // strlen (from libc) requires a valid pointer, // so we mark it as being an unsafe fn pub unsafe fn strlen(p: *const std::ffi::c_char) -> usize; // this function doesn't say safe or unsafe, so it defaults to unsafe pub fn free(p: *mut core::ffi::c_void); pub safe static IMPORTANT_BYTES: [u8; 256];\n} In addition to being able to mark an extern block as unsafe, you can also specify if individual items in the extern block are safe or unsafe. Items marked as safe can be used without an unsafe block. Starting with the 2024 Edition, it is now required to include the unsafe keyword on an extern block. This is intended to make it very clear that there are safety requirements that must be upheld by the extern definitions. See RFC 3484 for the original proposal.","breadcrumbs":"Rust 2024 🚧 » Unsafe extern blocks » Details","id":"171","title":"Details"},"172":{"body":"The missing_unsafe_on_extern lint can update extern blocks to add the unsafe keyword. The lint is part of the rust-2024-compatibility lint group which is included in the automatic edition migration. In order to migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition Just beware that this automatic migration will not be able to verify that the signatures in the extern block are correct. It is still your responsibility to manually review their definition. Alternatively, you can manually enable the lint to find places where there are unsafe blocks that need to be updated. // Add this to the root of your crate to do a manual migration.\n#![warn(missing_unsafe_on_extern)]","breadcrumbs":"Rust 2024 🚧 » Unsafe extern blocks » Migration","id":"172","title":"Migration"},"173":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/123757 .","breadcrumbs":"Rust 2024 🚧 » Unsafe attributes » Unsafe attributes","id":"173","title":"Unsafe attributes"},"174":{"body":"The following attributes must now be marked as unsafe: export_name link_section no_mangle","breadcrumbs":"Rust 2024 🚧 » Unsafe attributes » Summary","id":"174","title":"Summary"},"175":{"body":"Rust 1.82 added the ability in all editions to mark certain attributes as unsafe to indicate that they have soundness requirements that must be upheld. [1] The syntax for an unsafe attribute looks like this: // SAFETY: there is no other global function of this name\n#[unsafe(no_mangle)]\npub fn example() {} Marking the attribute with unsafe highlights that there are safety requirements that must be upheld that the compiler cannot verify on its own. Starting with the 2024 Edition, it is now required to mark these attributes as unsafe. The following section describes the safety requirements for these attributes. See RFC 3325 for the original proposal.","breadcrumbs":"Rust 2024 🚧 » Unsafe attributes » Details","id":"175","title":"Details"},"176":{"body":"The no_mangle , export_name , and link_section attributes influence the symbol names and linking behavior of items. Care must be taken to ensure that these attributes are used correctly. Because the set of symbols across all linked libraries is a global namespace, there can be issues if there is a symbol name collision between libraries. Typically this isn't an issue for normally defined functions because symbol mangling helps ensure that the symbol name is unique. However, attributes like export_name can upset that assumption of uniqueness. For example, in previous editions the following crashes on most Unix-like platforms despite containing only safe code: fn main() { println!(\"Hello, world!\");\n} #[export_name = \"malloc\"]\nfn foo() -> usize { 1 } In the 2024 Edition, it is now required to mark these attributes as unsafe to emphasize that it is required to ensure that the symbol is defined correctly: // SAFETY: There should only be a single definition of the loop symbol.\n#[unsafe(export_name=\"loop\")]\nfn arduino_loop() { // ...\n}","breadcrumbs":"Rust 2024 🚧 » Unsafe attributes » Safety requirements","id":"176","title":"Safety requirements"},"177":{"body":"The unsafe_attr_outside_unsafe lint can update these attributes to use the unsafe(...) format. The lint is part of the rust-2024-compatibility lint group which is included in the automatic edition migration. In order to migrate your code to be Rust 2024 Edition compatible, run: cargo fix --edition Just beware that this automatic migration will not be able to verify that these attributes are being used correctly. It is still your responsibility to manually review their usage. Alternatively, you can manually enable the lint to find places where these attributes need to be updated. // Add this to the root of your crate to do a manual migration.\n#![warn(unsafe_attr_outside_unsafe)]","breadcrumbs":"Rust 2024 🚧 » Unsafe attributes » Migration","id":"177","title":"Migration"},"178":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/124853 .","breadcrumbs":"Rust 2024 🚧 » Rustdoc combined tests » Rustdoc combined tests","id":"178","title":"Rustdoc combined tests"},"179":{"body":"Doctests are now combined into a single binary which should result in a significant performance improvement.","breadcrumbs":"Rust 2024 🚧 » Rustdoc combined tests » Summary","id":"179","title":"Summary"},"18":{"body":"At this time, cargo fix is not able to update documentation tests . After updating the edition in Cargo.toml, you should run cargo test to ensure everything still passes. If your documentation tests use syntax that is not supported in the new edition, you will need to update them manually. In rare cases, you can manually set the edition for each test. For example, you can use the edition2018 annotation on the triple backticks to tell rustdoc which edition to use.","breadcrumbs":"What are editions? » Advanced migrations » Documentation tests","id":"18","title":"Documentation tests"},"180":{"body":"Prior the the 2024 Edition, rustdoc's \"test\" mode would compile each code block in your documentation as a separate executable. Although this was relatively simple to implement, it resulted in a significant performance burden when there were a large number of documentation tests. Starting with the 2024 Edition, rustdoc will attempt to combine documentation tests into a single binary, significantly reducing the overhead for compiling doctests. /// Adds two numbers\n///\n/// ```\n/// assert_eq!(add(1, 1), 2);\n/// ```\npub fn add(left: u64, right: u64) -> u64 { left + right\n} /// Subtracts two numbers\n///\n/// ```\n/// assert_eq!(subtract(2, 1), 1);\n/// ```\npub fn subtract(left: u64, right: u64) -> u64 { left - right\n} In this example, the two doctests will now be compiled into a single executable. Rustdoc will essentially place each example in a separate function within a single binary. The tests still run in independent processes as they did before, so any global state (like global statics) should still continue to work correctly. [1] This change is only available in the 2024 Edition to avoid potential incompatibilities with existing doctests which may not work in a combined executable. However, these incompatibilities are expected to be extremely rare. For more information on the details of how this work, see \"Doctests - How were they improved?\" .","breadcrumbs":"Rust 2024 🚧 » Rustdoc combined tests » Details","id":"180","title":"Details"},"181":{"body":"In some situations it is not possible for rustdoc to combine examples into a single executable. Rustdoc will attempt to automatically detect if this is not possible. For example, a test will not be combined with others if it: Uses the compile_fail tag, which indicates that the example should fail to compile. Uses an edition tag, which indicates the edition of the example. [2] Uses global attributes, like the global_allocator attribute, which could potentially interfere with other tests. Defines any crate-wide attributes (like #![feature(...)]). Defines a macro that uses $crate, because the $crate path will not work correctly. However, rustdoc is not able to automatically determine all situations where an example cannot be combined with other examples. In these situations, you can add the standalone language tag to indicate that the example should be built as a separate executable. For example: //! ```\n//! let location = std::panic::Location::caller();\n//! assert_eq!(location.line(), 5);\n//! ``` This is sensitive to the code structure of how the example is compiled and won't work with the \"combined\" approach because the line numbers will shift depending on how the doctests are combined. In these situations, you can add the standalone tag to force the example to be built separately just as it was in previous editions. E.g.: //! ```standalone\n//! let location = std::panic::Location::caller();\n//! assert_eq!(location.line(), 5);\n//! ``` Note that rustdoc will only combine tests if the entire crate is Edition 2024 or greater. Using the edition2024 tag in older editions will not result in those tests being combined.","breadcrumbs":"Rust 2024 🚧 » Rustdoc combined tests » Standalone tag","id":"181","title":"Standalone tag"},"182":{"body":"There is no automatic migration to determine which doctests need to be annotated with the standalone tag. It's very unlikely that any given doctest will not work correctly when migrated. We suggest that you update your crate to the 2024 Edition and then run your documentation tests and see if any fail. If one does, you will need to analyze whether it can be rewritten to be compatible with the combined approach, or alternatively, add the standalone tag to retain the previous behavior.","breadcrumbs":"Rust 2024 🚧 » Rustdoc combined tests » Migration","id":"182","title":"Migration"},"19":{"body":"Another area where the automated fixes cannot apply is if you have a build script which generates Rust code at compile time (see Code generation for an example). In this situation, if you end up with code that doesn't work in the next edition, you will need to manually change the build script to generate code that is compatible.","breadcrumbs":"What are editions? » Advanced migrations » Generated code","id":"19","title":"Generated code"},"2":{"body":"When creating editions, there is one most consequential rule: crates in one edition must seamlessly interoperate with those compiled with other editions. In other words, each crate can decide when to migrate to a new edition independently. This decision is 'private' - it won't affect other crates in the ecosystem. For Rust, this required compatibility implies some limits on the kinds of changes that can be featured in an edition. As a result, changes found in new Rust editions tend to be 'skin deep'. All Rust code - regardless of edition - will ultimately compile down to the same internal representation within the compiler.","breadcrumbs":"What are editions? » Editions do not split the ecosystem","id":"2","title":"Editions do not split the ecosystem"},"20":{"body":"If your project is not using Cargo as a build system, it may still be possible to make use of the automated lints to assist migrating to the next edition. You can enable the migration lints as described above by enabling the appropriate lint group . For example, you can use the #![warn(rust_2021_compatibility)] attribute or the -Wrust-2021-compatibility or --force-warns=rust-2021-compatibility CLI flag . The next step is to apply those lints to your code. There are several options here: Manually read the warnings and apply the suggestions recommended by the compiler. Use an editor or IDE that supports automatically applying suggestions. For example, Visual Studio Code with the Rust Analyzer extension has the ability to use the \"Quick Fix\" links to automatically apply suggestions. Many other editors and IDEs have similar functionality. Write a migration tool using the rustfix library. This is the library that Cargo uses internally to take the JSON messages from the compiler and modify the source code. Check the examples directory for examples of how to use the library.","breadcrumbs":"What are editions? » Advanced migrations » Migrating non-Cargo projects","id":"20","title":"Migrating non-Cargo projects"},"21":{"body":"Editions are not only about new features and removing old ones. In any programming language, idioms change over time, and Rust is no exception. While old code will continue to compile, it might be written with different idioms today. For example, in Rust 2015, external crates must be listed with extern crate like this: // src/lib.rs\nextern crate rand; In Rust 2018, it is no longer necessary to include these items. cargo fix has the --edition-idioms option to automatically transition some of these idioms to the new syntax. Warning : The current \"idiom lints\" are known to have some problems. They may make incorrect suggestions which may fail to compile. The current lints are: Edition 2018: unused-extern-crates explicit-outlives-requirements Edition 2021 does not have any idiom lints. The following instructions are recommended only for the intrepid who are willing to work through a few compiler/Cargo bugs! If you run into problems, you can try the --broken-code option described above to make as much progress as possible, and then resolve the remaining issues manually. With that out of the way, we can instruct Cargo to fix our code snippet with: cargo fix --edition-idioms Afterwards, the line with extern crate rand; in src/lib.rs will be removed. We're now more idiomatic, and we didn't have to fix our code manually!","breadcrumbs":"What are editions? » Advanced migrations » Writing idiomatic code in a new edition","id":"21","title":"Writing idiomatic code in a new edition"},"22":{"body":"Rust 2015 has a theme of \"stability\". It commenced with the release of 1.0, and is the \"default edition\". The edition system was conceived in late 2017, but Rust 1.0 was released in May of 2015. As such, 2015 is the edition that you get when you don't specify any particular edition, for backwards compatibility reasons. \"Stability\" is the theme of Rust 2015 because 1.0 marked a huge change in Rust development. Previous to Rust 1.0, Rust was changing on a daily basis. This made it very difficult to write large software in Rust, and made it difficult to learn. With the release of Rust 1.0 and Rust 2015, we committed to backwards compatibility, ensuring a solid foundation for people to build projects on top of. Since it's the default edition, there's no way to port your code to Rust 2015; it just is . You'll be transitioning away from 2015, but never really to 2015. As such, there's not much else to say about it!","breadcrumbs":"Rust 2015 » Rust 2015","id":"22","title":"Rust 2015"},"23":{"body":"Info RFC #2052 , which also proposed the Edition system Release version 1.31.0 The edition system was created for the release of Rust 2018. The release of the Rust 2018 edition coincided with a number of other features all coordinated around the theme of productivity . The majority of those features were backwards compatible and are now available on all editions; however, some of those changes required the edition mechanism (most notably the module system changes ).","breadcrumbs":"Rust 2018 » Rust 2018","id":"23","title":"Rust 2018"},"24":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Path and module system changes » Path and module system changes","id":"24","title":"Path and module system changes"},"25":{"body":"Paths in use declarations now work the same as other paths. Paths starting with :: must now be followed with an external crate. Paths in pub(in path) visibility modifiers must now start with crate, self, or super.","breadcrumbs":"Rust 2018 » Path and module system changes » Summary","id":"25","title":"Summary"},"26":{"body":"The module system is often one of the hardest things for people new to Rust. Everyone has their own things that take time to master, of course, but there's a root cause for why it's so confusing to many: while there are simple and consistent rules defining the module system, their consequences can feel inconsistent, counterintuitive and mysterious. As such, the 2018 edition of Rust introduces a few new module system features, but they end up simplifying the module system, to make it more clear as to what is going on. Here's a brief summary: extern crate is no longer needed in 99% of circumstances. The crate keyword refers to the current crate. Paths may start with a crate name, even within submodules. Paths starting with :: must reference an external crate. A foo.rs and foo/ subdirectory may coexist; mod.rs is no longer needed when placing submodules in a subdirectory. Paths in use declarations work the same as other paths. These may seem like arbitrary new rules when put this way, but the mental model is now significantly simplified overall. Read on for more details!","breadcrumbs":"Rust 2018 » Path and module system changes » Motivation","id":"26","title":"Motivation"},"27":{"body":"Let's talk about each new feature in turn.","breadcrumbs":"Rust 2018 » Path and module system changes » More details","id":"27","title":"More details"},"28":{"body":"This one is quite straightforward: you no longer need to write extern crate to import a crate into your project. Before: // Rust 2015 extern crate futures; mod submodule { use futures::Future;\n} After: // Rust 2018 mod submodule { use futures::Future;\n} Now, to add a new crate to your project, you can add it to your Cargo.toml, and then there is no step two. If you're not using Cargo, you already had to pass --extern flags to give rustc the location of external crates, so you'd just keep doing what you were doing there as well. An exception There's one exception to this rule, and that's the \"sysroot\" crates. These are the crates distributed with Rust itself. Usually these are only needed in very specialized situations. Starting in 1.41, rustc accepts the --extern=CRATE_NAME flag which automatically adds the given crate name in a way similar to extern crate. Build tools may use this to inject sysroot crates into the crate's prelude. Cargo does not have a general way to express this, though it uses it for proc_macro crates. Some examples of needing to explicitly import sysroot crates are: std : Usually this is not necessary, because std is automatically imported unless the crate is marked with #![no_std] . core : Usually this is not necessary, because core is automatically imported, unless the crate is marked with #![no_core] . For example, some of the internal crates used by the standard library itself need this. proc_macro : This is automatically imported by Cargo if it is a proc-macro crate starting in 1.42. extern crate proc_macro; would be needed if you want to support older releases, or if using another build tool that does not pass the appropriate --extern flags to rustc. alloc : Items in the alloc crate are usually accessed via re-exports in the std crate. If you are working with a no_std crate that supports allocation, then you may need to explicitly import alloc. test : This is only available on the nightly channel , and is usually only used for the unstable benchmark support. Macros One other use for extern crate was to import macros; that's no longer needed. Macros may be imported with use like any other item. For example, the following use of extern crate: #[macro_use]\nextern crate bar; fn main() { baz!();\n} Can be changed to something like the following: use bar::baz; fn main() { baz!();\n} Renaming crates If you've been using as to rename your crate like this: extern crate futures as f; use f::Future; then removing the extern crate line on its own won't work. You'll need to do this: use futures as f; use self::f::Future; This change will need to happen in any module that uses f.","breadcrumbs":"Rust 2018 » Path and module system changes » No more extern crate","id":"28","title":"No more extern crate"},"29":{"body":"In use declarations and in other code, you can refer to the root of the current crate with the crate:: prefix. For instance, crate::foo::bar will always refer to the name bar inside the module foo, from anywhere else in the same crate. The prefix :: previously referred to either the crate root or an external crate; it now unambiguously refers to an external crate. For instance, ::foo::bar always refers to the name bar inside the external crate foo.","breadcrumbs":"Rust 2018 » Path and module system changes » The crate keyword refers to the current crate","id":"29","title":"The crate keyword refers to the current crate"},"3":{"body":"Rust aims to make upgrading to a new edition an easy process. When a new edition releases, crate authors may use automatic migration tooling within cargo to migrate. Cargo will then make minor changes to the code to make it compatible with the new version. For example, when migrating to Rust 2018, anything named async will now use the equivalent raw identifier syntax : r#async. Cargo's automatic migrations aren't perfect: there may still be corner cases where manual changes are required. It aims to avoid changes to semantics that could affect the correctness or performance of the code.","breadcrumbs":"What are editions? » Edition migration is easy and largely automated","id":"3","title":"Edition migration is easy and largely automated"},"30":{"body":"Previously, using an external crate in a module without a use import required a leading :: on the path. // Rust 2015 extern crate chrono; fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // but in a submodule it requires a leading :: if not imported with `use` let x = ::chrono::Utc::now(); }\n} Now, extern crate names are in scope in the entire crate, including submodules. // Rust 2018 fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // crates may be referenced directly, even in submodules let x = chrono::Utc::now(); }\n} If you have a local module or item with the same name as an external crate, a path beginning with that name will be taken to refer to the local module or item. To explicitly refer to the external crate, use the ::name form.","breadcrumbs":"Rust 2018 » Path and module system changes » Extern crate paths","id":"30","title":"Extern crate paths"},"31":{"body":"In Rust 2015, if you have a submodule: // This `mod` declaration looks for the `foo` module in\n// `foo.rs` or `foo/mod.rs`.\nmod foo; It can live in foo.rs or foo/mod.rs. If it has submodules of its own, it must be foo/mod.rs. So a bar submodule of foo would live at foo/bar.rs. In Rust 2018 the restriction that a module with submodules must be named mod.rs is lifted. foo.rs can just be foo.rs, and the submodule is still foo/bar.rs. This eliminates the special name, and if you have a bunch of files open in your editor, you can clearly see their names, instead of having a bunch of tabs named mod.rs. Rust 2015 Rust 2018 .\n├── lib.rs\n└── foo/ &nbsp;&nbsp; ├── mod.rs &nbsp;&nbsp; └── bar.rs .\n├── lib.rs\n├── foo.rs\n└── foo/ &nbsp;&nbsp; └── bar.rs","breadcrumbs":"Rust 2018 » Path and module system changes » No more mod.rs","id":"31","title":"No more mod.rs"},"32":{"body":"Minimum Rust version: 1.32 Rust 2018 simplifies and unifies path handling compared to Rust 2015. In Rust 2015, paths work differently in use declarations than they do elsewhere. In particular, paths in use declarations would always start from the crate root, while paths in other code implicitly started from the current scope. Those differences didn't have any effect in the top-level module, which meant that everything would seem straightforward until working on a project large enough to have submodules. In Rust 2018, paths in use declarations and in other code work the same way, both in the top-level module and in any submodule. You can use a relative path from the current scope, a path starting from an external crate name, or a path starting with ::, crate, super, or self. Code that looked like this: // Rust 2015 extern crate futures; use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} will look exactly the same in Rust 2018, except that you can delete the extern crate line: // Rust 2018 use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} The same code will also work completely unmodified in a submodule: // Rust 2018 mod submodule { use futures::Future; mod foo { pub struct Bar; } use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String), } fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } } }\n} This makes it easy to move code around in a project, and avoids introducing additional complexity to multi-module projects.","breadcrumbs":"Rust 2018 » Path and module system changes » use paths","id":"32","title":"use paths"},"33":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Anonymous trait function parameters deprecated","id":"33","title":"Anonymous trait function parameters deprecated"},"34":{"body":"Trait function parameters may use any irrefutable pattern when the function has a body.","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Summary","id":"34","title":"Summary"},"35":{"body":"In accordance with RFC #1685 , parameters in trait method declarations are no longer allowed to be anonymous. For example, in the 2015 edition, this was allowed: trait Foo { fn foo(&self, u8);\n} In the 2018 edition, all parameters must be given an argument name (even if it's just _): trait Foo { fn foo(&self, baz: u8);\n}","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Details","id":"35","title":"Details"},"36":{"body":"Minimum Rust version: 1.27","breadcrumbs":"Rust 2018 » New keywords » New keywords","id":"36","title":"New keywords"},"37":{"body":"dyn is a strict keyword , in 2015 it is a weak keyword . async and await are strict keywords . try is a reserved keyword .","breadcrumbs":"Rust 2018 » New keywords » Summary","id":"37","title":"Summary"},"38":{"body":"","breadcrumbs":"Rust 2018 » New keywords » Motivation","id":"38","title":"Motivation"},"39":{"body":"The dyn Trait feature is the new syntax for using trait objects. In short: Box<Trait> becomes Box<dyn Trait> &Trait and &mut Trait become &dyn Trait and &mut dyn Trait And so on. In code: trait Trait {} impl Trait for i32 {} // old\nfn function1() -> Box<Trait> {\n# unimplemented!()\n} // new\nfn function2() -> Box<dyn Trait> {\n# unimplemented!()\n} That's it! Why? Using just the trait name for trait objects turned out to be a bad decision. The current syntax is often ambiguous and confusing, even to veterans, and favors a feature that is not more frequently used than its alternatives, is sometimes slower, and often cannot be used at all when its alternatives can. Furthermore, with impl Trait arriving, \"impl Trait vs dyn Trait\" is much more symmetric, and therefore a bit nicer, than \"impl Trait vs Trait\". impl Trait is explained here . In the new edition, you should therefore prefer dyn Trait to just Trait where you need a trait object.","breadcrumbs":"Rust 2018 » New keywords » dyn Trait for trait objects","id":"39","title":"dyn Trait for trait objects"},"4":{"body":"In addition to tooling, this Rust Edition Guide also covers the changes that are part of each edition. It describes each change and links to additional details, if available. It also covers corner cases or tricky details crate authors should be aware of. Crate authors should find: An overview of editions A migration guide for specific editions A quick troubleshooting reference when automated tooling isn't working.","breadcrumbs":"What are editions? » What this guide covers","id":"4","title":"What this guide covers"},"40":{"body":"These keywords are reserved to implement the async-await feature of Rust, which was ultimately released to stable in 1.39.0 .","breadcrumbs":"Rust 2018 » New keywords » async and await","id":"40","title":"async and await"},"41":{"body":"The try keyword is reserved for use in try blocks, which have not (as of this writing) been stabilized ( tracking issue )","breadcrumbs":"Rust 2018 » New keywords » try keyword","id":"41","title":"try keyword"},"42":{"body":"","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Method dispatch for raw pointers to inference variables","id":"42","title":"Method dispatch for raw pointers to inference variables"},"43":{"body":"The tyvar_behind_raw_pointer lint is now a hard error.","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Summary","id":"43","title":"Summary"},"44":{"body":"See Rust issue #46906 for details.","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Details","id":"44","title":"Details"},"45":{"body":"","breadcrumbs":"Rust 2018 » Cargo changes » Cargo changes","id":"45","title":"Cargo changes"},"46":{"body":"If there is a target definition in a Cargo.toml manifest, it no longer automatically disables automatic discovery of other targets. Target paths of the form src/{target_name}.rs are no longer inferred for targets where the path field is not set. cargo install for the current directory is no longer allowed, you must specify cargo install --path . to install the current package.","breadcrumbs":"Rust 2018 » Cargo changes » Summary","id":"46","title":"Summary"},"47":{"body":"Info RFC #3085 Release version 1.56.0 The Rust 2021 Edition contains several changes that bring new capabilities and more consistency to the language, and opens up room for expansion in the future. The following chapters dive into the details of each change, and they include guidance on migrating your existing code.","breadcrumbs":"Rust 2021 » Rust 2021","id":"47","title":"Rust 2021"},"48":{"body":"","breadcrumbs":"Rust 2021 » Additions to the prelude » Additions to the prelude","id":"48","title":"Additions to the prelude"},"49":{"body":"The TryInto, TryFrom and FromIterator traits are now part of the prelude. This might make calls to trait methods ambiguous which could make some code fail to compile.","breadcrumbs":"Rust 2021 » Additions to the prelude » Summary","id":"49","title":"Summary"},"5":{"body":"A new project created with Cargo is configured to use the latest edition by default: $ cargo new foo Created binary (application) `foo` project\n$ cat foo/Cargo.toml\n[package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2021\" [dependencies] That edition = \"2021\" setting configures your package to be built using the Rust 2021 edition. No further configuration needed! You can use the --edition <YEAR> option of cargo new to create the project using some specific edition. For example, creating a new project to use the Rust 2018 edition could be done like this: $ cargo new --edition 2018 foo Created binary (application) `foo` project\n$ cat foo/Cargo.toml\n[package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2018\" [dependencies] Don't worry about accidentally using an invalid year for the edition; the cargo new invocation will not accept an invalid edition year value: $ cargo new --edition 2019 foo\nerror: \"2019\" isn't a valid value for '--edition <YEAR>' [possible values: 2015, 2018, 2021] Did you mean \"2018\"? For more information try --help You can change the value of the edition key by simply editing the Cargo.toml file. For example, to cause your package to be built using the Rust 2015 edition, you would set the key as in the following example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2015\" [dependencies]","breadcrumbs":"What are editions? » Creating a new project » Creating a new project","id":"5","title":"Creating a new project"},"50":{"body":"The prelude of the standard library is the module containing everything that is automatically imported in every module. It contains commonly used items such as Option, Vec, drop, and Clone. The Rust compiler prioritizes any manually imported items over those from the prelude, to make sure additions to the prelude will not break any existing code. For example, if you have a crate or module called example containing a pub struct Option;, then use example::*; will make Option unambiguously refer to the one from example; not the one from the standard library. However, adding a trait to the prelude can break existing code in a subtle way. For example, a call to x.try_into() which comes from a MyTryInto trait might fail to compile if std's TryInto is also imported, because the call to try_into is now ambiguous and could come from either trait. This is the reason we haven't added TryInto to the prelude yet, since there is a lot of code that would break this way. As a solution, Rust 2021 will use a new prelude. It's identical to the current one, except for three new additions: std::convert::TryInto std::convert::TryFrom std::iter::FromIterator The tracking issue can be found here .","breadcrumbs":"Rust 2021 » Additions to the prelude » Details","id":"50","title":"Details"},"51":{"body":"As a part of the 2021 edition a migration lint, rust_2021_prelude_collisions, has been added in order to aid in automatic migration of Rust 2018 codebases to Rust 2021. In order to migrate your code to be Rust 2021 Edition compatible, run: cargo fix --edition The lint detects cases where functions or methods are called that have the same name as the methods defined in one of the new prelude traits. In some cases, it may rewrite your calls in various ways to ensure that you continue to call the same function you did before. If you'd like to migrate your code manually or better understand what cargo fix is doing, below we've outlined the situations where a migration is needed along with a counter example of when it's not needed.","breadcrumbs":"Rust 2021 » Additions to the prelude » Migration","id":"51","title":"Migration"},"52":{"body":"Conflicting trait methods When two traits that are in scope have the same method name, it is ambiguous which trait method should be used. For example: trait MyTrait<A> { // This name is the same as the `from_iter` method on the `FromIterator` trait from `std`. fn from_iter(x: Option<A>);\n} impl<T> MyTrait<()> for Vec<T> { fn from_iter(_: Option<()>) {}\n} fn main() { // Vec<T> implements both `std::iter::FromIterator` and `MyTrait` // If both traits are in scope (as would be the case in Rust 2021), // then it becomes ambiguous which `from_iter` method to call <Vec<i32>>::from_iter(None);\n} We can fix this by using fully qualified syntax: fn main() { // Now it is clear which trait method we're referring to <Vec<i32> as MyTrait<()>>::from_iter(None);\n} Inherent methods on dyn Trait objects Some users invoke methods on a dyn Trait value where the method name overlaps with a new prelude trait: mod submodule { pub trait MyTrait { // This has the same name as `TryInto::try_into` fn try_into(&self) -> Result<u32, ()>; }\n} // `MyTrait` isn't in scope here and can only be referred to through the path `submodule::MyTrait`\nfn bar(f: Box<dyn submodule::MyTrait>) { // If `std::convert::TryInto` is in scope (as would be the case in Rust 2021), // then it becomes ambiguous which `try_into` method to call f.try_into();\n} Unlike with static dispatch methods, calling a trait method on a trait object does not require that the trait be in scope. The code above works as long as there is no trait in scope with a conflicting method name. When the TryInto trait is in scope (which is the case in Rust 2021), this causes an ambiguity. Should the call be to MyTrait::try_into or std::convert::TryInto::try_into? In these cases, we can fix this by adding an additional dereferences or otherwise clarify the type of the method receiver. This ensures that the dyn Trait method is chosen, versus the methods from the prelude trait. For example, turning f.try_into() above into (&*f).try_into() ensures that we're calling try_into on the dyn MyTrait which can only refer to the MyTrait::try_into method.","breadcrumbs":"Rust 2021 » Additions to the prelude » Migration needed","id":"52","title":"Migration needed"},"53":{"body":"Inherent methods Many types define their own inherent methods with the same name as a trait method. For instance, below the struct MyStruct implements from_iter which shares the same name with the method from the trait FromIterator found in the standard library: use std::iter::IntoIterator; struct MyStruct { data: Vec<u32>\n} impl MyStruct { // This has the same name as `std::iter::FromIterator::from_iter` fn from_iter(iter: impl IntoIterator<Item = u32>) -> Self { Self { data: iter.into_iter().collect() } }\n} impl std::iter::FromIterator<u32> for MyStruct { fn from_iter<I: IntoIterator<Item = u32>>(iter: I) -> Self { Self { data: iter.into_iter().collect() } }\n} Inherent methods always take precedent over trait methods so there's no need for any migration.","breadcrumbs":"Rust 2021 » Additions to the prelude » No migration needed","id":"53","title":"No migration needed"},"54":{"body":"The lint needs to take a couple of factors into account when determining whether or not introducing 2021 Edition to a codebase will cause a name resolution collision (thus breaking the code after changing edition). These factors include: Is the call a fully-qualified call or does it use dot-call method syntax ? This will affect how the name is resolved due to auto-reference and auto-dereferencing on method call syntax. Manually dereferencing/referencing will allow specifying priority in the case of dot-call method syntax, while fully-qualified call requires specification of the type and the trait name in the method path (e.g. <Type as Trait>::method) Is this an inherent method or a trait method ? Inherent methods that take self will take priority over TryInto::try_into as inherent methods take priority over trait methods, but inherent methods that take &self or &mut self won't take priority due to requiring a auto-reference (while TryInto::try_into does not, as it takes self) Is the origin of this method from core/std? (As the traits can't have a collision with themselves) Does the given type implement the trait it could have a collision against? Is the method being called via dynamic dispatch? (i.e. is the self type dyn Trait) If so, trait imports don't affect resolution, and no migration lint needs to occur","breadcrumbs":"Rust 2021 » Additions to the prelude » Implementation Reference","id":"54","title":"Implementation Reference"},"55":{"body":"","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Default Cargo feature resolver","id":"55","title":"Default Cargo feature resolver"},"56":{"body":"edition = \"2021\" implies resolver = \"2\" in Cargo.toml.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Summary","id":"56","title":"Summary"},"57":{"body":"Since Rust 1.51.0, Cargo has opt-in support for a new feature resolver which can be activated with resolver = \"2\" in Cargo.toml. Starting in Rust 2021, this will be the default. That is, writing edition = \"2021\" in Cargo.toml will imply resolver = \"2\". The resolver is a global setting for a workspace , and the setting is ignored in dependencies. The setting is only honored for the top-level package of the workspace. If you are using a virtual workspace , you will still need to explicitly set the resolver field in the [workspace] definition if you want to opt-in to the new resolver. The new feature resolver no longer merges all requested features for crates that are depended on in multiple ways. See the announcement of Rust 1.51 for details.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Details","id":"57","title":"Details"},"58":{"body":"There are no automated migration tools for updating for the new resolver. For most projects, there are usually few or no changes as a result of updating. When updating with cargo fix --edition, Cargo will display a report if the new resolver will build dependencies with different features. It may look something like this: note: Switching to Edition 2021 will enable the use of the version 2 feature resolver in Cargo. This may cause some dependencies to be built with fewer features enabled than previously. More information about the resolver changes may be found at https://doc.rust-lang.org/nightly/edition-guide/rust-2021/default-cargo-resolver.html When building the following dependencies, the given features will no longer be used: bstr v0.2.16: default, lazy_static, regex-automata, unicode libz-sys v1.1.3 (as host dependency): libc This lets you know that certain dependencies will no longer be built with the given features.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Migration","id":"58","title":"Migration"},"59":{"body":"There may be some circumstances where your project may not build correctly after the change. If a dependency declaration in one package assumes that certain features are enabled in another, and those features are now disabled, it may fail to compile. For example, let's say we have a dependency like this: # Cargo.toml [dependencies]\nbstr = { version = \"0.2.16\", default-features = false }\n# ... And somewhere in our dependency tree, another package has this: # Another package's Cargo.toml [build-dependencies]\nbstr = \"0.2.16\" In our package, we've been using the words_with_breaks method from bstr, which requires bstr's \"unicode\" feature to be enabled. This has historically worked because Cargo unified the features of bstr between the two packages. However, after updating to Rust 2021, the new resolver will build bstr twice, once with the default features (as a build dependency), and once with no features (as our normal dependency). Since bstr is now being built without the \"unicode\" feature, the words_with_breaks method doesn't exist, and the build will fail with an error that the method is missing. The solution here is to ensure that the dependency is declared with the features you are actually using. For example: [dependencies]\nbstr = { version = \"0.2.16\", default-features = false, features = [\"unicode\"] } In some cases, this may be a problem with a third-party dependency that you don't have direct control over. You can consider submitting a patch to that project to try to declare the correct set of features for the problematic dependency. Alternatively, you can add features to any dependency from within your own Cargo.toml file. For example, if the bstr example given above was declared in some third-party dependency, you can just copy the correct dependency declaration into your own project. The features will be unified, as long as they match the unification rules of the new resolver. Those are: Features enabled on platform-specific dependencies for targets not currently being built are ignored. Build-dependencies and proc-macros do not share features with normal dependencies. Dev-dependencies do not activate features unless building a target that needs them (like tests or examples). A real-world example is using diesel and diesel_migrations . These packages provide database support, and the database is selected using a feature, like this: [dependencies]\ndiesel = { version = \"1.4.7\", features = [\"postgres\"] }\ndiesel_migrations = \"1.4.0\" The problem is that diesel_migrations has an internal proc-macro which itself depends on diesel, and the proc-macro assumes its own copy of diesel has the same features enabled as the rest of the dependency graph. After updating to the new resolver, it fails to build because now there are two copies of diesel, and the one built for the proc-macro is missing the \"postgres\" feature. A solution here is to add diesel as a build-dependency with the required features, for example: [build-dependencies]\ndiesel = { version = \"1.4.7\", features = [\"postgres\"] } This causes Cargo to add \"postgres\" as a feature for host dependencies (proc-macros and build-dependencies). Now, the diesel_migrations proc-macro will get the \"postgres\" feature enabled, and it will build correctly. The 2.0 release of diesel (currently in development) does not have this problem as it has been restructured to not have this dependency requirement.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Build failures","id":"59","title":"Build failures"},"6":{"body":"Rust includes tooling to automatically transition a project from one edition to the next. It will update your source code so that it is compatible with the next edition. Briefly, the steps to update to the next edition are: Run cargo fix --edition Edit Cargo.toml and set the edition field to the next edition, for example edition = \"2021\" Run cargo build or cargo test to verify the fixes worked. The following sections dig into the details of these steps, and some of the issues you may encounter along the way. It's our intention that the migration to new editions is as smooth an experience as possible. If it's difficult for you to upgrade to the latest edition, we consider that a bug. If you run into problems with this process, please file a bug report . Thank you!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Transitioning an existing project to a new edition","id":"6","title":"Transitioning an existing project to a new edition"},"60":{"body":"The cargo tree command has had substantial improvements to help with the migration to the new resolver. cargo tree can be used to explore the dependency graph, and to see which features are being enabled, and importantly why they are being enabled. One option is to use the --duplicates flag (-d for short), which will tell you when a package is being built multiple times. Taking the bstr example from earlier, we might see: > cargo tree -d\nbstr v0.2.16\n└── foo v0.1.0 (/MyProjects/foo) bstr v0.2.16\n[build-dependencies]\n└── bar v0.1.0 └── foo v0.1.0 (/MyProjects/foo) This output tells us that bstr is built twice, and shows the chain of dependencies that led to its inclusion in both cases. You can print which features each package is using with the -f flag, like this: cargo tree -f '{p} {f}' This tells Cargo to change the \"format\" of the output, where it will print both the package and the enabled features. You can also use the -e flag to tell it which \"edges\" to display. For example, cargo tree -e features will show in-between each dependency which features are being added by each dependency. This option becomes more useful with the -i flag which can be used to \"invert\" the tree. This allows you to see how features flow into a given dependency. For example, let's say the dependency graph is large, and we're not quite sure who is depending on bstr, the following command will show that: > cargo tree -e features -i bstr\nbstr v0.2.16\n├── bstr feature \"default\"\n│ [build-dependencies]\n│ └── bar v0.1.0\n│ └── bar feature \"default\"\n│ └── foo v0.1.0 (/MyProjects/foo)\n├── bstr feature \"lazy_static\"\n│ └── bstr feature \"unicode\"\n│ └── bstr feature \"default\" (*)\n├── bstr feature \"regex-automata\"\n│ └── bstr feature \"unicode\" (*)\n├── bstr feature \"std\"\n│ └── bstr feature \"default\" (*)\n└── bstr feature \"unicode\" (*) This snippet of output shows that the project foo depends on bar with the \"default\" feature. Then, bar depends on bstr as a build-dependency with the \"default\" feature. We can further see that bstr's \"default\" feature enables \"unicode\" (among other features).","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Exploring features","id":"60","title":"Exploring features"},"61":{"body":"","breadcrumbs":"Rust 2021 » IntoIterator for arrays » IntoIterator for arrays","id":"61","title":"IntoIterator for arrays"},"62":{"body":"Arrays implement IntoIterator in all editions. Calls to IntoIterator::into_iter are hidden in Rust 2015 and Rust 2018 when using method call syntax (i.e., array.into_iter()). So, array.into_iter() still resolves to (&array).into_iter() as it has before. array.into_iter() changes meaning to be the call to IntoIterator::into_iter in Rust 2021.","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Summary","id":"62","title":"Summary"},"63":{"body":"Until Rust 1.53, only references to arrays implement IntoIterator. This means you can iterate over &[1, 2, 3] and &mut [1, 2, 3], but not over [1, 2, 3] directly. for &e in &[1, 2, 3] {} // Ok :) for e in [1, 2, 3] {} // Error :( This has been a long-standing issue , but the solution is not as simple as it seems. Just adding the trait implementation would break existing code. array.into_iter() already compiles today because that implicitly calls (&array).into_iter() due to how method call syntax works . Adding the trait implementation would change the meaning. Usually this type of breakage (adding a trait implementation) is categorized as 'minor' and acceptable. But in this case there is too much code that would be broken by it. It has been suggested many times to \"only implement IntoIterator for arrays in Rust 2021\". However, this is simply not possible. You can't have a trait implementation exist in one edition and not in another, since editions can be mixed. Instead, the trait implementation was added in all editions (starting in Rust 1.53.0) but with a small hack to avoid breakage until Rust 2021. In Rust 2015 and 2018 code, the compiler will still resolve array.into_iter() to (&array).into_iter() like before, as if the trait implementation does not exist. This only applies to the .into_iter() method call syntax. It does not affect any other syntax such as for e in [1, 2, 3], iter.zip([1, 2, 3]) or IntoIterator::into_iter([1, 2, 3]). Those will start to work in all editions. While it's a shame that this required a small hack to avoid breakage, this solution keeps the difference between the editions to an absolute minimum.","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Details","id":"63","title":"Details"},"64":{"body":"A lint, array_into_iter, gets triggered whenever there is some call to into_iter() that will change meaning in Rust 2021. The array_into_iter lint has already been a warning by default on all editions since the 1.41 release (with several enhancements made in 1.55). If your code is already warning free, then it should already be ready to go for Rust 2021! You can automatically migrate your code to be Rust 2021 Edition compatible or ensure it is already compatible by running: cargo fix --edition Because the difference between editions is small, the migration to Rust 2021 is fairly straight-forward. For method calls of into_iter on arrays, the elements being implemented will change from references to owned values. For example: fn main() { let array = [1u8, 2, 3]; for x in array.into_iter() { // x is a `&u8` in Rust 2015 and Rust 2018 // x is a `u8` in Rust 2021 }\n} The most straightforward way to migrate in Rust 2021, is by keeping the exact behavior from previous editions by calling iter() which also iterates over owned arrays by reference: fn main() { let array = [1u8, 2, 3]; for x in array.iter() { // <- This line changed // x is a `&u8` in all editions }\n}","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Migration","id":"64","title":"Migration"},"65":{"body":"If you are using fully qualified method syntax (i.e., IntoIterator::into_iter(array)) in a previous edition, this can be upgraded to method call syntax (i.e., array.into_iter()).","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Optional migration","id":"65","title":"Optional migration"},"66":{"body":"","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Disjoint capture in closures","id":"66","title":"Disjoint capture in closures"},"67":{"body":"|| a.x + 1 now captures only a.x instead of a. This can cause things to be dropped at different times or affect whether closures implement traits like Send or Clone. If possible changes are detected, cargo fix will insert statements like let _ = &a to force a closure to capture the entire variable.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Summary","id":"67","title":"Summary"},"68":{"body":"Closures automatically capture anything that you refer to from within their body. For example, || a + 1 automatically captures a reference to a from the surrounding context. In Rust 2018 and before, closures capture entire variables, even if the closure only uses one field. For example, || a.x + 1 captures a reference to a and not just a.x. Capturing a in its entirety prevents mutation or moves from other fields of a, so that code like this does not compile: let a = SomeStruct::new();\ndrop(a.x); // Move out of one field of the struct\nprintln!(\"{}\", a.y); // Ok: Still use another field of the struct\nlet c = || println!(\"{}\", a.y); // Error: Tries to capture all of `a`\nc(); Starting in Rust 2021, closures captures are more precise. Typically they will only capture the fields they use (in some cases, they might capture more than just what they use, see the Rust reference for full details). Therefore, the above example will compile fine in Rust 2021. Disjoint capture was proposed as part of RFC 2229 and the RFC contains details about the motivation.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Details","id":"68","title":"Details"},"69":{"body":"As a part of the 2021 edition a migration lint, rust_2021_incompatible_closure_captures, has been added in order to aid in automatic migration of Rust 2018 codebases to Rust 2021. In order to migrate your code to be Rust 2021 Edition compatible, run: cargo fix --edition Below is an examination of how to manually migrate code to use closure captures that are compatible with Rust 2021 should the automatic migration fail or you would like to better understand how the migration works. Changing the variables captured by a closure can cause programs to change behavior or to stop compiling in two cases: changes to drop order, or when destructors run ( details ); changes to which traits a closure implements ( details ). Whenever any of the scenarios below are detected, cargo fix will insert a \"dummy let\" into your closure to force it to capture the entire variable: let x = (vec![22], vec![23]);\nlet c = move || { // \"Dummy let\" that forces `x` to be captured in its entirety let _ = &x; // Otherwise, only `x.0` would be captured here println!(\"{:?}\", x.0);\n}; This is a conservative analysis: in many cases, these dummy lets can be safely removed and your program will work fine.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Migration","id":"69","title":"Migration"},"7":{"body":"As an example, let's take a look at transitioning from the 2015 edition to the 2018 edition. The steps are essentially the same when transitioning to other editions like 2021. Imagine we have a crate that has this code in src/lib.rs: trait Foo { fn foo(&self, i32);\n} This code uses an anonymous parameter, that i32. This is not supported in Rust 2018 , and so this would fail to compile. Let's get this code up to date!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Starting the migration","id":"7","title":"Starting the migration"},"70":{"body":"Closures now only capture data that needs to be read, which means the following closures will not capture x: let x = 10;\nlet c = || { let _ = x; // no-op\n}; let c = || match x { _ => println!(\"Hello World!\")\n}; The let _ = x statement here is a no-op, since the _ pattern completely ignores the right-hand side, and x is a reference to a place in memory (in this case, a variable). This change by itself (capturing fewer values) doesn't trigger any suggestions, but it may do so in conjunction with the \"drop order\" change below. Subtle: There are other similar expressions, such as the \"dummy lets\" let _ = &x that we insert, which are not no-ops. This is because the right-hand side (&x) is not a reference to a place in memory, but rather an expression that must first be evaluated (and whose result is then discarded).","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Wild Card Patterns","id":"70","title":"Wild Card Patterns"},"71":{"body":"When a closure takes ownership of a value from a variable t, that value is then dropped when the closure is dropped, and not when the variable t goes out of scope: # fn move_value<T>(_: T){}\n{ let t = (vec![0], vec![0]); { let c = || move_value(t); // t is moved here } // c is dropped, which drops the tuple `t` as well\n} // t goes out of scope here The above code will run the same in both Rust 2018 and Rust 2021. However, in cases where the closure only takes ownership of part of a variable, there can be differences: # fn move_value<T>(_: T){}\n{ let t = (vec![0], vec![0]); { let c = || { // In Rust 2018, captures all of `t`. // In Rust 2021, captures only `t.0` move_value(t.0); }; // In Rust 2018, `c` (and `t`) are both dropped when we // exit this block. // // In Rust 2021, `c` and `t.0` are both dropped when we // exit this block. } // In Rust 2018, the value from `t` has been moved and is\n// not dropped.\n//\n// In Rust 2021, the value from `t.0` has been moved, but `t.1`\n// remains, so it will be dropped here.\n} In most cases, dropping values at different times just affects when memory is freed and is not important. However, some Drop impls (aka, destructors) have side-effects, and changing the drop order in those cases can alter the semantics of your program. In such cases, the compiler will suggest inserting a dummy let to force the entire variable to be captured.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Drop Order","id":"71","title":"Drop Order"},"72":{"body":"Closures automatically implement the following traits based on what values they capture: Clone : if all captured values are Clone. Auto traits like Send , Sync , and UnwindSafe : if all captured values implement the given trait. In Rust 2021, since different values are being captured, this can affect what traits a closure will implement. The migration lints test each closure to see whether it would have implemented a given trait before and whether it still implements it now; if they find that a trait used to be implemented but no longer is, then \"dummy lets\" are inserted. For instance, a common way to allow passing around raw pointers between threads is to wrap them in a struct and then implement Send/Sync auto trait for the wrapper. The closure that is passed to thread::spawn uses the specific fields within the wrapper but the entire wrapper is captured regardless. Since the wrapper is Send/Sync, the code is considered safe and therefore compiles successfully. With disjoint captures, only the specific field mentioned in the closure gets captured, which wasn't originally Send/Sync defeating the purpose of the wrapper. use std::thread; struct Ptr(*mut i32);\nunsafe impl Send for Ptr {} let mut x = 5;\nlet px = Ptr(&mut x as *mut i32); let c = thread::spawn(move || { unsafe { *(px.0) += 10; }\n}); // Closure captured px.0 which is not Send","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Trait implementations","id":"72","title":"Trait implementations"},"73":{"body":"","breadcrumbs":"Rust 2021 » Panic macro consistency » Panic macro consistency","id":"73","title":"Panic macro consistency"},"74":{"body":"panic!(..) now always uses format_args!(..), just like println!(). panic!(\"{\") is no longer accepted, without escaping the { as {{. panic!(x) is no longer accepted if x is not a string literal. Use std::panic::panic_any(x) to panic with a non-string payload. Or use panic!(\"{}\", x) to use x's Display implementation. The same applies to assert!(expr, ..).","breadcrumbs":"Rust 2021 » Panic macro consistency » Summary","id":"74","title":"Summary"},"75":{"body":"The panic!() macro is one of Rust's most well known macros. However, it has some subtle surprises that we can't just change due to backwards compatibility. // Rust 2018\npanic!(\"{}\", 1); // Ok, panics with the message \"1\"\npanic!(\"{}\"); // Ok, panics with the message \"{}\" The panic!() macro only uses string formatting when it's invoked with more than one argument. When invoked with a single argument, it doesn't even look at that argument. // Rust 2018\nlet a = \"{\";\nprintln!(a); // Error: First argument must be a format string literal\npanic!(a); // Ok: The panic macro doesn't care It even accepts non-strings such as panic!(123), which is uncommon and rarely useful since it produces a surprisingly unhelpful message: panicked at 'Box<Any>'. This will especially be a problem once implicit format arguments are stabilized. That feature will make println!(\"hello {name}\") a short-hand for println!(\"hello {}\", name). However, panic!(\"hello {name}\") would not work as expected, since panic!() doesn't process a single argument as format string. To avoid that confusing situation, Rust 2021 features a more consistent panic!() macro. The new panic!() macro will no longer accept arbitrary expressions as the only argument. It will, just like println!(), always process the first argument as format string. Since panic!() will no longer accept arbitrary payloads, panic_any() will be the only way to panic with something other than a formatted string. // Rust 2021\npanic!(\"{}\", 1); // Ok, panics with the message \"1\"\npanic!(\"{}\"); // Error, missing argument\npanic!(a); // Error, must be a string literal In addition, core::panic!() and std::panic!() will be identical in Rust 2021. Currently, there are some historical differences between those two, which can be noticeable when switching #![no_std] on or off.","breadcrumbs":"Rust 2021 » Panic macro consistency » Details","id":"75","title":"Details"},"76":{"body":"A lint, non_fmt_panics, gets triggered whenever there is some call to panic that uses some deprecated behavior that will error in Rust 2021. The non_fmt_panics lint has already been a warning by default on all editions since the 1.50 release (with several enhancements made in later releases). If your code is already warning free, then it should already be ready to go for Rust 2021! You can automatically migrate your code to be Rust 2021 Edition compatible or ensure it is already compatible by running: cargo fix --edition Should you choose or need to manually migrate, you'll need to update all panic invocations to either use the same formatting as println or use std::panic::panic_any to panic with non-string data. For example, in the case of panic!(MyStruct), you'll need to convert to using std::panic::panic_any (note that this is a function not a macro): std::panic::panic_any(MyStruct). In the case of panic messages that include curly braces but the wrong number of arguments (e.g., panic!(\"Some curlies: {}\")), you can panic with the string literal by either using the same syntax as println! (i.e., panic!(\"{}\", \"Some curlies: {}\")) or by escaping the curly braces (i.e., panic!(\"Some curlies: {{}}\")).","breadcrumbs":"Rust 2021 » Panic macro consistency » Migration","id":"76","title":"Migration"},"77":{"body":"","breadcrumbs":"Rust 2021 » Reserving syntax » Reserving syntax","id":"77","title":"Reserving syntax"},"78":{"body":"any_identifier#, any_identifier\"...\", and any_identifier'...' are now reserved syntax, and no longer tokenize. This is mostly relevant to macros. E.g. quote!{ #a#b } is no longer accepted. It doesn't treat keywords specially, so e.g. match\"...\" {} is no longer accepted. Insert whitespace between the identifier and the subsequent #, \", or ' to avoid errors. Edition migrations will help you insert whitespace in such cases.","breadcrumbs":"Rust 2021 » Reserving syntax » Summary","id":"78","title":"Summary"},"79":{"body":"To make space for new syntax in the future, we've decided to reserve syntax for prefixed identifiers and literals: prefix#identifier, prefix\"string\", prefix'c', and prefix#123, where prefix can be any identifier. (Except those prefixes that already have a meaning, such as b'...' (byte chars) and r\"...\" (raw strings).) This provides syntax we can expand into in the future without requiring an edition boundary. We may use this for temporary syntax until the next edition, or for permanent syntax if appropriate. Without an edition, this would be a breaking change, since macros can currently accept syntax such as hello\"world\", which they will see as two separate tokens: hello and \"world\". The (automatic) fix is simple though: just insert a space: hello \"world\". Likewise, prefix#ident should become prefix #ident. Edition migrations will help with this fix. Other than turning these into a tokenization error, the RFC does not attach a meaning to any prefix yet. Assigning meaning to specific prefixes is left to future proposals, which will now—thanks to reserving these prefixes—not be breaking changes. Some new prefixes you might potentially see in the future (though we haven't committed to any of them yet): k#keyword to allow writing keywords that don't exist yet in the current edition. For example, while async is not a keyword in edition 2015, this prefix would've allowed us to accept k#async in edition 2015 without having to wait for edition 2018 to reserve async as a keyword. f\"\" as a short-hand for a format string. For example, f\"hello {name}\" as a short-hand for the equivalent format!() invocation. s\"\" for String literals.","breadcrumbs":"Rust 2021 » Reserving syntax » Details","id":"79","title":"Details"},"8":{"body":"Your code may or may not use features that are incompatible with the new edition. In order to help transition to the next edition, Cargo includes the cargo fix subcommand to automatically update your source code. To start, let's run it: cargo fix --edition This will check your code, and automatically fix any issues that it can. Let's look at src/lib.rs again: trait Foo { fn foo(&self, _: i32);\n} It's re-written our code to introduce a parameter name for that i32 value. In this case, since it had no name, cargo fix will replace it with _, which is conventional for unused variables. cargo fix can't always fix your code automatically. If cargo fix can't fix something, it will print the warning that it cannot fix to the console. If you see one of these warnings, you'll have to update your code manually. See the Advanced migration strategies chapter for more on working with the migration process, and read the chapters in this guide which explain which changes are needed. If you have problems, please seek help at the user's forums .","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Updating your code to be compatible with the new edition","id":"8","title":"Updating your code to be compatible with the new edition"},"80":{"body":"As a part of the 2021 edition a migration lint, rust_2021_prefixes_incompatible_syntax, has been added in order to aid in automatic migration of Rust 2018 codebases to Rust 2021. In order to migrate your code to be Rust 2021 Edition compatible, run: cargo fix --edition Should you want or need to manually migrate your code, migration is fairly straight-forward. Let's say you have a macro that is defined like so: macro_rules! my_macro { ($a:tt $b:tt) => {};\n} In Rust 2015 and 2018 it's legal for this macro to be called like so with no space between the first token tree and the second: my_macro!(z\"hey\"); This z prefix is no longer allowed in Rust 2021, so in order to call this macro, you must add a space after the prefix like so: my_macro!(z \"hey\");","breadcrumbs":"Rust 2021 » Reserving syntax » Migration","id":"80","title":"Migration"},"81":{"body":"","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Warnings promoted to errors","id":"81","title":"Warnings promoted to errors"},"82":{"body":"Code that triggered the bare_trait_objects and ellipsis_inclusive_range_patterns lints will error in Rust 2021.","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Summary","id":"82","title":"Summary"},"83":{"body":"Two existing lints are becoming hard errors in Rust 2021, but these lints will remain warnings in older editions.","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Details","id":"83","title":"Details"},"84":{"body":"The use of the dyn keyword to identify trait objects will be mandatory in Rust 2021. For example, the following code which does not include the dyn keyword in &MyTrait will produce an error instead of just a lint in Rust 2021: pub trait MyTrait {} pub fn my_function(_trait_object: &MyTrait) { // should be `&dyn MyTrait` unimplemented!()\n}","breadcrumbs":"Rust 2021 » Warnings promoted to errors » bare_trait_objects:","id":"84","title":"bare_trait_objects:"},"85":{"body":"The deprecated ... syntax for inclusive range patterns (i.e., ranges where the end value is included in the range) is no longer accepted in Rust 2021. It has been superseded by ..=, which is consistent with expressions. For example, the following code which uses ... in a pattern will produce an error instead of just a lint in Rust 2021: pub fn less_or_eq_to_100(n: u8) -> bool { matches!(n, 0...100) // should be `0..=100`\n}","breadcrumbs":"Rust 2021 » Warnings promoted to errors » ellipsis_inclusive_range_patterns:","id":"85","title":"ellipsis_inclusive_range_patterns:"},"86":{"body":"If your Rust 2015 or 2018 code does not produce any warnings for bare_trait_objects or ellipsis_inclusive_range_patterns and you've not allowed these lints through the use of #![allow()] or some other mechanism, then there's no need to migrate. To automatically migrate any crate that uses ... in patterns or does not use dyn with trait objects, you can run cargo fix --edition.","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Migrations","id":"86","title":"Migrations"},"87":{"body":"","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Or patterns in macro-rules","id":"87","title":"Or patterns in macro-rules"},"88":{"body":"How patterns work in macro_rules macros changes slightly: $_:pat in macro_rules now matches usage of | too: e.g. A | B. The new $_:pat_param behaves like $_:pat did before; it does not match (top level) |. $_:pat_param is available in all editions.","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Summary","id":"88","title":"Summary"},"89":{"body":"Starting in Rust 1.53.0, patterns are extended to support | nested anywhere in the pattern. This enables you to write Some(1 | 2) instead of Some(1) | Some(2). Since this was simply not allowed before, this is not a breaking change. However, this change also affects macro_rules macros . Such macros can accept patterns using the :pat fragment specifier. Currently, :pat does not match top level |, since before Rust 1.53, not all patterns (at all nested levels) could contain a |. Macros that accept patterns like A | B, such as matches!() use something like $($_:pat)|+. Because this would potentially break existing macros, the meaning of :pat did not change in Rust 1.53.0 to include |. Instead, that change happens in Rust 2021. In the new edition, the :pat fragment specifier will match A | B. $_:pat fragments in Rust 2021 cannot be followed by an explicit |. Since there are times that one still wishes to match pattern fragments followed by a |, the fragment specified :pat_param has been added to retain the older behavior. It's important to remember that editions are per crate , so the only relevant edition is the edition of the crate where the macro is defined. The edition of the crate where the macro is used does not change how the macro works.","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Details","id":"89","title":"Details"},"9":{"body":"In order to use some new features, you must explicitly opt in to the new edition. Once you're ready to continue, change your Cargo.toml to add the new edition key/value pair. For example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2018\" If there's no edition key, Cargo will default to Rust 2015. But in this case, we've chosen 2018, and so our code will compile with Rust 2018! The next step is to test your project on the new edition. Run your project tests to verify that everything still works, such as running cargo test . If new warnings are issued, you may want to consider running cargo fix again (without the --edition flag) to apply any suggestions given by the compiler. Congrats! Your code is now valid in both Rust 2015 and Rust 2018!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Enabling the new edition to use new features","id":"9","title":"Enabling the new edition to use new features"},"90":{"body":"A lint, rust_2021_incompatible_or_patterns, gets triggered whenever there is a use $_:pat which will change meaning in Rust 2021. You can automatically migrate your code to be Rust 2021 Edition compatible or ensure it is already compatible by running: cargo fix --edition If you have a macro which relies on $_:pat not matching the top level use of | in patterns, you'll need to change each occurrence of $_:pat to $_:pat_param. For example: macro_rules! my_macro { ($x:pat | $y:pat) => { // TODO: implementation } } // This macro works in Rust 2018 since `$x:pat` does not match against `|`:\nmy_macro!(1 | 2); // In Rust 2021 however, the `$_:pat` fragment matches `|` and is not allowed\n// to be followed by a `|`. To make sure this macro still works in Rust 2021\n// change the macro to the following:\nmacro_rules! my_macro { ($x:pat_param | $y:pat) => { // <- this line is different // TODO: implementation } }","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Migration","id":"90","title":"Migration"},"91":{"body":"","breadcrumbs":"Rust 2021 » C-string literals » C-string literals","id":"91","title":"C-string literals"},"92":{"body":"Literals of the form c\"foo\" or cr\"foo\" represent a string of type &core::ffi::CStr .","breadcrumbs":"Rust 2021 » C-string literals » Summary","id":"92","title":"Summary"},"93":{"body":"Starting with Rust 1.77, C-strings can be written using C-string literal syntax with the c or cr prefix. Previously, it was challenging to properly produce a valid string literal that could interoperate with C APIs which terminate with a NUL byte. The cstr crate was a popular solution, but that required compiling a proc-macro which was quite expensive. Now, C-strings can be written directly using literal syntax notation, which will generate a value of type &core::ffi::CStr which is automatically terminated with a NUL byte. # use core::ffi::CStr; assert_eq!(c\"hello\", CStr::from_bytes_with_nul(b\"hello\\0\").unwrap());\nassert_eq!( c\"byte escapes \\xff work\", CStr::from_bytes_with_nul(b\"byte escapes \\xff work\\0\").unwrap()\n);\nassert_eq!( c\"unicode escapes \\u{00E6} work\", CStr::from_bytes_with_nul(b\"unicode escapes \\xc3\\xa6 work\\0\").unwrap()\n);\nassert_eq!( c\"unicode characters αβγ encoded as UTF-8\", CStr::from_bytes_with_nul( b\"unicode characters \\xce\\xb1\\xce\\xb2\\xce\\xb3 encoded as UTF-8\\0\" ) .unwrap()\n);\nassert_eq!( c\"strings can continue \\ on multiple lines\", CStr::from_bytes_with_nul(b\"strings can continue on multiple lines\\0\").unwrap()\n); C-strings do not allow interior NUL bytes (such as with a \\0 escape). Similar to regular strings, C-strings also support \"raw\" syntax with the cr prefix. These raw C-strings do not process backslash escapes which can make it easier to write strings that contain backslashes. Double-quotes can be included by surrounding the quotes with the # character. Multiple # characters can be used to avoid ambiguity with internal \"# sequences. assert_eq!(cr\"foo\", c\"foo\");\n// Number signs can be used to embed interior double quotes.\nassert_eq!(cr#\"\"foo\"\"#, c\"\\\"foo\\\"\");\n// This requires two #.\nassert_eq!(cr##\"\"foo\"#\"##, c\"\\\"foo\\\"#\");\n// Escapes are not processed.\nassert_eq!(cr\"C:\\foo\", c\"C:\\\\foo\"); See The Reference for more details.","breadcrumbs":"Rust 2021 » C-string literals » Details","id":"93","title":"Details"},"94":{"body":"Migration is only necessary for macros which may have been assuming a sequence of tokens that looks similar to c\"…\" or cr\"…\", which previous to the 2021 edition would tokenize as two separate tokens, but in 2021 appears as a single token. As part of the syntax reservation for the 2021 edition, any macro input which may run into this issue should issue a warning from the rust_2021_prefixes_incompatible_syntax migration lint. See that chapter for more detail.","breadcrumbs":"Rust 2021 » C-string literals » Migration","id":"94","title":"Migration"},"95":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". Info RFC #3501 Release version 1.85.0 (anticipated) The Rust 2024 Edition is scheduled to be frozen on 2024-10-17, stabilized on nightly on 2024-11-28, and released as stable with Rust 1.85.0 on 2025-02-20. In more detail, the currently anticipated release schedule is: Date Version Edition stage 2024-10-11 Branch v1.83 Go / no go on all items 2024-10-17 Release v1.82 Rust 2024 nightly beta 2024-11-22 Branch v1.84 Prepare to stabilize... 2024-11-28 Release v1.83 Stabilize Rust 2024 on master 2025-01-03 Branch v1.85 Cut Rust 2024 to beta 2025-01-09 Release v1.84 Announce Rust 2024 is pending! 2025-02-20 Release v1.85 Release Rust 2024 Our motivating priorities for this edition are to: Make this edition a success. Do so without requiring heroics from anyone. ...or stressing anyone or everyone out. Consequently, it's possible that things could change if needed so as to better adhere to those guiding priorities. This is a project run by volunteers. However, at the moment, the edition is on track .","breadcrumbs":"Rust 2024 🚧 » Rust 2024","id":"95","title":"Rust 2024"},"96":{"body":"🚧 The 2024 Edition has not yet been released and hence this section is still \"under construction\". More information may be found in the tracking issue at https://github.com/rust-lang/rust/issues/121042 .","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » Additions to the prelude","id":"96","title":"Additions to the prelude"},"97":{"body":"The Future and IntoFuture traits are now part of the prelude. This might make calls to trait methods ambiguous which could make some code fail to compile. RustcEncodable and RustcDecodable have been removed from the prelude.","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » Summary","id":"97","title":"Summary"},"98":{"body":"The prelude of the standard library is the module containing everything that is automatically imported in every module. It contains commonly used items such as Option, Vec, drop, and Clone. The Rust compiler prioritizes any manually imported items over those from the prelude, to make sure additions to the prelude will not break any existing code. For example, if you have a crate or module called example containing a pub struct Option;, then use example::*; will make Option unambiguously refer to the one from example; not the one from the standard library. However, adding a trait to the prelude can break existing code in a subtle way. For example, a call to x.poll() which comes from a MyPoller trait might fail to compile if std's Future is also imported, because the call to poll is now ambiguous and could come from either trait. As a solution, Rust 2024 will use a new prelude. It's identical to the current one, except for the following changes: Added: std::future::Future std::future::IntoFuture Removed: RustcEncodable RustcDecodable","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » Details","id":"98","title":"Details"},"99":{"body":"RustcEncodable and RustcDecodable are two undocumented derive macros that have been removed from the prelude. These were deprecated before Rust 1.0, but remained within the standard library prelude. The 2024 Edition has removed these from the prelude since they are not expected to be used. If in the unlikely case there is a project still using these, it is recommended to switch to a serialization library, such as those found on crates.io .","breadcrumbs":"Rust 2024 🚧 » Additions to the prelude » RustcEncodable and RustcDecodable removal","id":"99","title":"RustcEncodable and RustcDecodable removal"}},"length":183,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"1":{"0":{"0":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"5":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"1":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"5":{"df":1,"docs":{"142":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"95":{"tf":1.0}}},"9":{"df":1,"docs":{"95":{"tf":1.0}}},"df":2,"docs":{"132":{"tf":1.0},"93":{"tf":1.0}}},"1":{".":{"0":{".":{"0":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"1":{"tf":1.0},"22":{"tf":2.23606797749979},"99":{"tf":1.0}}},"1":{"0":{".":{"4":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":2,"docs":{"162":{"tf":1.0},"163":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":1,"docs":{"163":{"tf":1.0}}},"7":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"3":{"1":{".":{"0":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.0},"33":{"tf":1.0}}},"2":{"df":1,"docs":{"32":{"tf":1.0}}},"7":{"df":1,"docs":{"111":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"59":{"tf":1.0}}},"7":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"1":{"df":2,"docs":{"28":{"tf":1.0},"64":{"tf":1.0}}},"2":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"5":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"57":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"63":{"tf":1.0},"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"63":{"tf":1.0},"89":{"tf":1.0}}},"5":{"df":1,"docs":{"64":{"tf":1.0}}},"6":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"7":{"7":{"df":1,"docs":{"93":{"tf":1.0}}},"9":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"8":{"0":{"df":1,"docs":{"105":{"tf":2.0}}},"2":{"df":6,"docs":{"120":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"163":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":3,"docs":{"70":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"95":{"tf":2.0}}},"2":{"3":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"8":{"5":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":14,"docs":{"1":{"tf":1.0},"132":{"tf":1.0},"158":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":2.0},"63":{"tf":2.449489742783178},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":2.0}},"u":{"8":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"2":{".":{"0":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":20,"docs":{"1":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":3.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"22":{"tf":1.0}}},"8":{"df":30,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"35":{"tf":1.0},"5":{"tf":2.23606797749979},"51":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":2.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"86":{"tf":1.0},"9":{"tf":2.0},"90":{"tf":1.0}}},"9":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"1":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":36,"docs":{"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"158":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":2.449489742783178},"68":{"tf":1.4142135623730951},"69":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"80":{"tf":2.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":2.0},"94":{"tf":1.7320508075688772}}},"4":{"df":56,"docs":{"10":{"tf":1.0},"101":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":2.23606797749979},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"126":{"tf":2.23606797749979},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"148":{"tf":1.0},"152":{"tf":1.0},"155":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"178":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.0},"182":{"tf":1.0},"95":{"tf":3.7416573867739413},"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"5":{"df":1,"docs":{"95":{"tf":2.0}}},"df":0,"docs":{}},"5":{"2":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"2":{"2":{"9":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.0}}},"3":{"df":1,"docs":{"132":{"tf":1.0}}},"4":{"df":1,"docs":{"132":{"tf":1.0}}},"5":{"6":{"df":1,"docs":{"171":{"tf":1.0}}},"8":{"5":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":12,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"132":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"63":{"tf":2.8284271247461903},"64":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0}}},"3":{"0":{"8":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"5":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"4":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"9":{"8":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"1":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"1":{"3":{"df":1,"docs":{"154":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"7":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"132":{"tf":1.0},"63":{"tf":2.8284271247461903},"64":{"tf":1.4142135623730951}}},"4":{"0":{"1":{"0":{"7":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"0":{"6":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":2,"docs":{"181":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"8":{"\\":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}},"9":{"9":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"_":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"88":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":2.0}}}},"df":0,"docs":{}}},"df":10,"docs":{"101":{"tf":1.0},"118":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951}}},"a":{"#":{"b":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"x":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"171":{"tf":1.0},"175":{"tf":1.0},"20":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":14,"docs":{"10":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.7320508075688772},"143":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"d":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},":":{":":{"<":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{">":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"166":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"28":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"112":{"tf":1.0},"133":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"57":{"tf":1.0},"59":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"180":{"tf":1.0}}}}}}},"df":20,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"129":{"tf":1.0},"137":{"tf":2.0},"139":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"172":{"tf":1.4142135623730951},"177":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"28":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"115":{"tf":1.0},"126":{"tf":1.4142135623730951},"171":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}}}},"df":22,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"126":{"tf":1.0},"137":{"tf":1.4142135623730951},"15":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.0},"171":{"tf":1.4142135623730951},"175":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":2.0},"69":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"120":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"12":{"tf":1.0},"168":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"115":{"tf":1.0},"54":{"tf":1.0},"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":3,"docs":{"51":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"k":{"a":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"127":{"tf":1.0},"163":{"tf":1.0}}}}},"i":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"133":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"28":{"tf":2.0}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":24,"docs":{"105":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"155":{"tf":1.0},"158":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"35":{"tf":1.4142135623730951},"46":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":12,"docs":{"106":{"tf":1.0},"111":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"146":{"tf":1.0},"155":{"tf":1.0},"28":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.0},"76":{"tf":2.0},"79":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}},"n":{"df":12,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"182":{"tf":1.0},"39":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"180":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"132":{"tf":1.0},"166":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"53":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":8,"docs":{"101":{"tf":1.7320508075688772},"39":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":2.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"z":{"df":2,"docs":{"182":{"tf":1.0},"20":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"132":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"182":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"10":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":4,"docs":{"124":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"168":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.7320508075688772},"63":{"tf":1.0},"68":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"68":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"139":{"tf":1.0},"29":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":2,"docs":{"124":{"tf":1.7320508075688772},"127":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"121":{"tf":1.0},"127":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":12,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.7320508075688772},"126":{"tf":1.0},"15":{"tf":1.7320508075688772},"155":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":2.0},"63":{"tf":1.0},"74":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"134":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"75":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"166":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"124":{"tf":1.7320508075688772},"127":{"tf":1.0},"148":{"tf":1.0},"162":{"tf":1.0},"35":{"tf":1.0},"75":{"tf":3.0},"76":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"23":{"tf":1.0},"32":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":2.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"a":{"d":{"d":{"(":{"1":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"\"":{"c":{":":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"#":{"\"":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"#":{"\"":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"(":{"2":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":2.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"94":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":7,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"121":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.0},"181":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"13":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":2.23606797749979},"176":{"tf":2.0},"177":{"tf":1.7320508075688772},"181":{"tf":1.7320508075688772},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"171":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}},"o":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}}},"df":47,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.7320508075688772},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":2.0},"163":{"tf":1.0},"168":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"28":{"tf":2.0},"3":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}}}},"df":6,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"58":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"13":{"tf":1.0},"180":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"4":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":14,"docs":{"109":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"180":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"4":{"tf":1.0}}},"y":{"df":3,"docs":{"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"22":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"b":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"165":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"82":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"121":{"tf":1.0}}},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"z":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":3,"docs":{"79":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":9,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"147":{"tf":1.0},"162":{"tf":1.0},"39":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}},"df":11,"docs":{"112":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.4142135623730951},"177":{"tf":1.0},"181":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"64":{"tf":1.0},"72":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":17,"docs":{"10":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"12":{"tf":1.0},"154":{"tf":1.0},"180":{"tf":1.0},"28":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":16,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"121":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"182":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"133":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"51":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"13":{"tf":1.0},"176":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"112":{"tf":1.0},"146":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"179":{"tf":1.0},"180":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"14":{"tf":1.0}}},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":14,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.0},"154":{"tf":1.7320508075688772},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":2.6457513110645907},"172":{"tf":1.7320508075688772},"180":{"tf":1.0},"41":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"34":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"155":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":9,"docs":{"118":{"tf":2.0},"120":{"tf":1.4142135623730951},"121":{"tf":2.6457513110645907},"122":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.7320508075688772},"127":{"tf":2.0},"128":{"tf":1.7320508075688772},"129":{"tf":2.0}}},"df":0,"docs":{}}},"x":{"<":{"[":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"105":{"tf":1.0}}},"u":{"3":{"2":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{")":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"168":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"162":{"tf":1.0},"63":{"tf":1.7320508075688772}}}},"df":9,"docs":{"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"158":{"tf":1.0},"50":{"tf":1.7320508075688772},"54":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"47":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":2.0},"168":{"tf":1.7320508075688772},"21":{"tf":1.0},"63":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}},"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":2.8284271247461903},"60":{"tf":4.123105625617661}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"d":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"141":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":11,"docs":{"141":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":3.605551275463989},"6":{"tf":1.0},"60":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":5,"docs":{"181":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"180":{"tf":1.0}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"79":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"c":{"\"":{"\\":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"c":{":":{"\\":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":31,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":2.6457513110645907},"106":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":2.0},"114":{"tf":1.0},"115":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"155":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":2.23606797749979},"171":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":2.23606797749979},"54":{"tf":2.6457513110645907},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"129":{"tf":1.0}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"166":{"tf":1.4142135623730951},"168":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":17,"docs":{"117":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"120":{"tf":2.8284271247461903},"121":{"tf":2.23606797749979},"122":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.7320508075688772},"127":{"tf":1.7320508075688772},"128":{"tf":2.6457513110645907},"129":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":3.1622776601683795},"69":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772},"72":{"tf":2.8284271247461903}},"e":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},"<":{"'":{"a":{">":{"(":{"_":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"<":{"(":{"&":{"'":{"a":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"176":{"tf":1.0},"75":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"3":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":17,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"139":{"tf":1.4142135623730951},"14":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"18":{"tf":1.0},"28":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":48,"docs":{"1":{"tf":1.0},"10":{"tf":2.0},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":3.0},"126":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"135":{"tf":1.0},"137":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"14":{"tf":2.23606797749979},"140":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"147":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":2.6457513110645907},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":2.449489742783178},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":27,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"132":{"tf":1.0},"14":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.4142135623730951},"18":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":11,"docs":{"155":{"tf":1.0},"166":{"tf":1.4142135623730951},"168":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"112":{"tf":1.0}}}}}}}},"df":11,"docs":{"121":{"tf":1.7320508075688772},"122":{"tf":2.23606797749979},"171":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"72":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.8284271247461903},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"109":{"tf":1.0},"154":{"tf":1.0},"175":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"13":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":60,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"109":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":2.0},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"138":{"tf":1.0},"142":{"tf":1.7320508075688772},"146":{"tf":1.0},"15":{"tf":1.4142135623730951},"155":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"16":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"180":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"67":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.23606797749979},"9":{"tf":1.0},"90":{"tf":1.7320508075688772},"95":{"tf":1.0},"98":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"28":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"117":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"47":{"tf":1.0},"8":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":2.0}}}},"df":0,"docs":{}},"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":2.0},"131":{"tf":1.0},"147":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"76":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"30":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"155":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"171":{"tf":1.0},"26":{"tf":1.0},"52":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"20":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"50":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"111":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":2.0},"69":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":2.449489742783178}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"51":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":68,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":2.449489742783178},"120":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":2.23606797749979},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"15":{"tf":1.7320508075688772},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":2.0},"17":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"19":{"tf":2.23606797749979},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"39":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"8":{"tf":2.6457513110645907},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"166":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"165":{"tf":1.0},"166":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"176":{"tf":1.0},"54":{"tf":1.7320508075688772}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"148":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":2.6457513110645907},"182":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"50":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"15":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"79":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"129":{"tf":1.0},"168":{"tf":1.4142135623730951},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}},"t":{"df":29,"docs":{"0":{"tf":1.0},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"182":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"133":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":28,"docs":{"112":{"tf":1.4142135623730951},"12":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"166":{"tf":2.449489742783178},"168":{"tf":1.0},"17":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.0},"12":{"tf":1.0},"167":{"tf":1.0},"32":{"tf":1.0},"70":{"tf":1.0}}},"x":{"df":2,"docs":{"133":{"tf":1.0},"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"15":{"tf":1.0},"159":{"tf":1.0},"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":6,"docs":{"142":{"tf":1.0},"146":{"tf":1.0},"166":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.0},"75":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"26":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"69":{"tf":1.0}}}}},"i":{"d":{"df":11,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"137":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"121":{"tf":1.0},"140":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"t":{"df":7,"docs":{"121":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"133":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.0},"171":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":18,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.7320508075688772},"68":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":9,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"127":{"tf":1.0},"155":{"tf":1.0},"180":{"tf":1.0},"21":{"tf":1.0},"51":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.0}}},"t":{"df":3,"docs":{"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"!":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"1":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"110":{"tf":1.0},"129":{"tf":1.0},"15":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"3":{"tf":1.0},"59":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":10,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"128":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"59":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"120":{"tf":1.0},"147":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"r":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"176":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"141":{"tf":1.0}}}}}},"df":31,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"141":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":2.23606797749979},"172":{"tf":1.0},"177":{"tf":1.0},"181":{"tf":2.0},"182":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"25":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"28":{"tf":5.291502622129181},"29":{"tf":3.0},"3":{"tf":1.0},"30":{"tf":3.1622776601683795},"32":{"tf":2.23606797749979},"4":{"tf":1.4142135623730951},"50":{"tf":1.0},"57":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.7320508075688772},"93":{"tf":1.0},"98":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"93":{"tf":1.4142135623730951},"94":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":2.449489742783178}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"(":{"b":{"\"":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\\":{"0":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"12":{"tf":1.4142135623730951},"168":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"39":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"142":{"tf":1.0}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"53":{"tf":1.7320508075688772},"70":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"166":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"146":{"tf":1.0},"2":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":4,"docs":{"138":{"tf":1.0},"142":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"115":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"59":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"o":{"d":{"df":1,"docs":{"137":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"141":{"tf":1.0},"142":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":27,"docs":{"106":{"tf":1.0},"114":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.7320508075688772},"146":{"tf":3.3166247903554},"147":{"tf":1.7320508075688772},"15":{"tf":1.0},"163":{"tf":1.4142135623730951},"165":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"171":{"tf":1.0},"22":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":2.6457513110645907},"64":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"133":{"tf":1.0},"158":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"110":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.0},"17":{"tf":1.7320508075688772},"176":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"26":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"162":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0}}},"y":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}}},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"137":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":17,"docs":{"105":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":2.8284271247461903},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.4142135623730951},"142":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":2.6457513110645907},"163":{"tf":1.0},"166":{"tf":1.0},"181":{"tf":1.0},"5":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"58":{"tf":2.23606797749979},"59":{"tf":5.0990195135927845},"60":{"tf":3.4641016151377544}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":5,"docs":{"111":{"tf":1.4142135623730951},"33":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"52":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"54":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":1.0},"99":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"117":{"tf":1.0},"175":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"176":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"168":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":39,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"150":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"114":{"tf":1.0},"12":{"tf":1.0},"132":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"181":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"110":{"tf":1.0},"115":{"tf":1.0},"159":{"tf":1.4142135623730951},"181":{"tf":1.0},"182":{"tf":1.0},"54":{"tf":1.0}}}}}}}},"v":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"141":{"tf":1.0},"142":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"141":{"tf":1.0},"142":{"tf":1.0},"59":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"133":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":2.0}}}}}}},"df":1,"docs":{"59":{"tf":2.8284271247461903}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"102":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":2.0},"134":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.4142135623730951},"58":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"90":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"132":{"tf":1.0},"22":{"tf":1.4142135623730951},"6":{"tf":1.0}},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"133":{"tf":1.0},"30":{"tf":1.0},"63":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"20":{"tf":1.0},"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"130":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"16":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"66":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"12":{"tf":1.0},"147":{"tf":1.0},"16":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}}},"o":{"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"128":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"179":{"tf":1.0},"180":{"tf":2.0},"181":{"tf":1.0},"182":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"110":{"tf":1.0},"18":{"tf":1.7320508075688772},"180":{"tf":1.7320508075688772},"182":{"tf":1.0}}}}}}}},"df":2,"docs":{"28":{"tf":1.4142135623730951},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.7320508075688772},"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}},"t":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"a":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"50":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":3.4641016151377544},"98":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"110":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.0},"168":{"tf":1.0},"54":{"tf":1.4142135623730951},"63":{"tf":1.0},"75":{"tf":1.0}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":4,"docs":{"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":8,"docs":{"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"37":{"tf":1.0},"39":{"tf":2.449489742783178},"52":{"tf":2.0},"54":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":15,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.7320508075688772},"181":{"tf":1.0},"54":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"2":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"60":{"tf":1.7320508075688772},"72":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"158":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"32":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"154":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":105,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.8284271247461903},"10":{"tf":3.3166247903554},"101":{"tf":2.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":3.0},"106":{"tf":2.0},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":2.23606797749979},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":2.6457513110645907},"120":{"tf":1.0},"121":{"tf":2.449489742783178},"122":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.4142135623730951},"139":{"tf":1.0},"14":{"tf":2.0},"140":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"15":{"tf":1.7320508075688772},"152":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":2.0},"156":{"tf":1.0},"158":{"tf":2.23606797749979},"159":{"tf":1.7320508075688772},"16":{"tf":2.6457513110645907},"160":{"tf":1.0},"162":{"tf":2.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"17":{"tf":3.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.7320508075688772},"173":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"177":{"tf":1.7320508075688772},"178":{"tf":1.0},"18":{"tf":2.0},"180":{"tf":1.7320508075688772},"181":{"tf":2.23606797749979},"182":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.8284271247461903},"20":{"tf":1.0},"21":{"tf":2.449489742783178},"22":{"tf":2.23606797749979},"23":{"tf":2.23606797749979},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":2.0},"47":{"tf":1.0},"5":{"tf":4.123105625617661},"51":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":3.3166247903554},"62":{"tf":1.0},"63":{"tf":2.23606797749979},"64":{"tf":2.449489742783178},"65":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":2.8284271247461903},"8":{"tf":2.0},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.23606797749979},"9":{"tf":2.6457513110645907},"90":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":2.449489742783178},"96":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"8":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"2":{"4":{"df":2,"docs":{"10":{"tf":1.0},"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"2":{"0":{"2":{"4":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"159":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.4142135623730951},"31":{"tf":1.0}}}}}}},"df":3,"docs":{"162":{"tf":1.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"146":{"tf":1.0},"32":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"64":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"82":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}},"m":{"b":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"132":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":17,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.7320508075688772},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"20":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"60":{"tf":2.0},"89":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"138":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":3,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"142":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"64":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"120":{"tf":1.0},"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":16,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"133":{"tf":1.0},"142":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.7320508075688772},"18":{"tf":1.0},"22":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":11,"docs":{"118":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"181":{"tf":1.0},"30":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"137":{"tf":1.0},"139":{"tf":1.0},"147":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"110":{"tf":1.0},"112":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"12":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"3":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":25,"docs":{"105":{"tf":1.0},"120":{"tf":1.4142135623730951},"132":{"tf":2.23606797749979},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":2.449489742783178},"166":{"tf":2.0},"17":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"74":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"166":{"tf":1.0},"180":{"tf":1.0},"7":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"111":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"18":{"tf":1.0},"32":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"i":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"124":{"tf":1.0},"32":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":48,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"126":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"142":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.4142135623730951},"158":{"tf":1.0},"16":{"tf":1.4142135623730951},"168":{"tf":1.0},"17":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":3.1622776601683795},"19":{"tf":1.0},"20":{"tf":2.0},"21":{"tf":1.0},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":2.6457513110645907},"6":{"tf":1.0},"60":{"tf":1.7320508075688772},"64":{"tf":1.0},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"98":{"tf":2.23606797749979}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"50":{"tf":1.0},"79":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"126":{"tf":1.0},"138":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"180":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"17":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"163":{"tf":1.0},"180":{"tf":1.0},"75":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"120":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"138":{"tf":1.0},"21":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":12,"docs":{"1":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.0},"168":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"57":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"174":{"tf":1.0},"176":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":1,"docs":{"28":{"tf":1.0}}}},"s":{"df":1,"docs":{"137":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"r":{"_":{"2":{"0":{"2":{"1":{"df":3,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"148":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.7320508075688772},"162":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"157":{"tf":1.0},"158":{"tf":2.449489742783178},"159":{"tf":1.0},"168":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"85":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":12,"docs":{"169":{"tf":1.0},"17":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":2.8284271247461903},"172":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.605551275463989},"29":{"tf":1.7320508075688772},"30":{"tf":2.449489742783178},"32":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"163":{"tf":1.0},"180":{"tf":1.0}}}}}}}},"f":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}},")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"6":{"4":{"df":1,"docs":{"171":{"tf":1.7320508075688772}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"126":{"tf":1.4142135623730951},"127":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"_":{"2":{"0":{"2":{"1":{"(":{"_":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}},"4":{"(":{"_":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"_":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}},"u":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"_":{"df":2,"docs":{"121":{"tf":1.0},"124":{"tf":1.0}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}},"u":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"132":{"tf":1.0}}},"t":{"df":2,"docs":{"120":{"tf":1.0},"127":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"21":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"64":{"tf":1.0},"80":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"164":{"tf":1.0},"166":{"tf":2.6457513110645907},"167":{"tf":1.0},"168":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"165":{"tf":1.0}}},"s":{"df":5,"docs":{"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":2.23606797749979},"147":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":4,"docs":{"168":{"tf":2.8284271247461903},"28":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"79":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":31,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":2.6457513110645907},"13":{"tf":2.449489742783178},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":3.1622776601683795},"138":{"tf":2.23606797749979},"139":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.7320508075688772},"146":{"tf":3.3166247903554},"147":{"tf":1.7320508075688772},"148":{"tf":1.0},"181":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.23606797749979},"59":{"tf":5.0},"60":{"tf":4.69041575982343},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"2":{"0":{"2":{"4":{"df":2,"docs":{"128":{"tf":1.0},"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"120":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":4,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"58":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"70":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"10":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}},"n":{"d":{"df":9,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"4":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"133":{"tf":1.0},"158":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"x":{"df":39,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":3.0},"126":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"134":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":3.1622776601683795},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":2.449489742783178},"168":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":3.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"126":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.7320508075688772},"60":{"tf":2.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}},"n":{"df":35,"docs":{"101":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"120":{"tf":2.23606797749979},"121":{"tf":2.449489742783178},"122":{"tf":1.4142135623730951},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"127":{"tf":2.0},"128":{"tf":2.449489742783178},"129":{"tf":2.23606797749979},"155":{"tf":2.0},"158":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.7320508075688772},"168":{"tf":2.449489742783178},"171":{"tf":2.0},"175":{"tf":1.0},"176":{"tf":1.7320508075688772},"180":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.0},"32":{"tf":2.449489742783178},"35":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"53":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":24,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"128":{"tf":1.0},"146":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}},"o":{"!":{"(":{"$":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"162":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"35":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"31":{"tf":2.23606797749979}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"29":{"tf":1.0},"32":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"139":{"tf":1.4142135623730951},"146":{"tf":1.0},"16":{"tf":2.0},"162":{"tf":1.4142135623730951},"176":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"5":{"tf":2.8284271247461903},"60":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"r":{"<":{"'":{"a":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":5,"docs":{"181":{"tf":1.0},"20":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"177":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":4,"docs":{"143":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"64":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":17,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"2":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":2.0},"160":{"tf":1.0},"162":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979},"90":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":1,"docs":{"171":{"tf":1.0}}}},"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":2,"docs":{"64":{"tf":1.0},"76":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"x":{"df":1,"docs":{"52":{"tf":1.0}}}},"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"16":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"32":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":23,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.7320508075688772},"110":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"112":{"tf":2.449489742783178},"114":{"tf":1.0},"115":{"tf":2.23606797749979},"121":{"tf":1.7320508075688772},"127":{"tf":1.0},"155":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.0},"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"132":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.0},"147":{"tf":1.0},"154":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":1.0},"47":{"tf":1.0},"79":{"tf":2.0},"97":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":2.0},"155":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"118":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.23606797749979},"122":{"tf":2.0},"123":{"tf":1.0},"124":{"tf":2.0},"127":{"tf":1.4142135623730951},"137":{"tf":1.0},"16":{"tf":1.4142135623730951},"168":{"tf":1.0},"19":{"tf":2.0},"28":{"tf":1.0},"93":{"tf":1.0}}}}},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"166":{"tf":1.0},"17":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}},"n":{"df":10,"docs":{"127":{"tf":1.4142135623730951},"182":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":7,"docs":{"132":{"tf":1.0},"133":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":6,"docs":{"143":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.4142135623730951}},"i":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"133":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":12,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.4142135623730951},"126":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"20":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0},"95":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}},"l":{"df":2,"docs":{"110":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"112":{"tf":1.0},"15":{"tf":1.4142135623730951},"158":{"tf":1.0},"28":{"tf":1.0},"89":{"tf":1.0}}}}}},"r":{"d":{"df":5,"docs":{"147":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":2.23606797749979},"43":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"105":{"tf":1.0},"14":{"tf":1.0},"31":{"tf":1.0},"79":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"p":{"df":16,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"15":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"n":{"c":{"df":18,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":12,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"127":{"tf":1.0},"158":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"80":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"104":{"tf":1.0},"120":{"tf":1.7320508075688772},"127":{"tf":1.0},"129":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"166":{"tf":1.0},"59":{"tf":1.0},"75":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"147":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}}},"i":{".":{"df":7,"docs":{"104":{"tf":1.0},"124":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"3":{"2":{"df":5,"docs":{"132":{"tf":1.4142135623730951},"39":{"tf":1.0},"7":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"15":{"tf":1.0},"20":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"15":{"tf":1.0},"50":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":7,"docs":{"155":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"3":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}},"df":1,"docs":{"21":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"147":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.0},"52":{"tf":1.0}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":14,"docs":{"120":{"tf":2.449489742783178},"121":{"tf":2.6457513110645907},"122":{"tf":1.7320508075688772},"123":{"tf":2.6457513110645907},"124":{"tf":2.23606797749979},"126":{"tf":1.4142135623730951},"127":{"tf":2.449489742783178},"128":{"tf":1.7320508075688772},"129":{"tf":1.7320508075688772},"168":{"tf":2.0},"39":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":21,"docs":{"10":{"tf":2.0},"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"168":{"tf":1.7320508075688772},"180":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":2.8284271247461903},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":2.8284271247461903},"74":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"120":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.7320508075688772},"139":{"tf":1.0},"75":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"118":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"166":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.0}}}}}}},"df":3,"docs":{"2":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":11,"docs":{"102":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":2.8284271247461903},"30":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"54":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"179":{"tf":1.0},"180":{"tf":1.0},"60":{"tf":1.0}}}}}}},"n":{"a":{"d":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"142":{"tf":1.0},"146":{"tf":1.0}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":21,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"139":{"tf":1.0},"159":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"60":{"tf":1.0},"85":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"138":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"180":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"158":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"129":{"tf":1.0},"180":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":4,"docs":{"15":{"tf":1.0},"162":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.7320508075688772}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"171":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"166":{"tf":2.23606797749979},"168":{"tf":2.23606797749979},"42":{"tf":1.0},"46":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":3,"docs":{"23":{"tf":1.0},"47":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"96":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"121":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":2.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"126":{"tf":1.0},"166":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"115":{"tf":1.0},"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"46":{"tf":1.7320508075688772}}},"n":{"c":{"df":4,"docs":{"1":{"tf":1.0},"29":{"tf":1.4142135623730951},"53":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":16,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":2.449489742783178},"159":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.0},"31":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"115":{"tf":1.0},"127":{"tf":1.0},"171":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"146":{"tf":1.0},"167":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"133":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"n":{"df":6,"docs":{"137":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"93":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"93":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":2.6457513110645907},"106":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"[":{"1":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":11,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"117":{"tf":1.4142135623730951},"123":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"54":{"tf":1.0},"8":{"tf":1.0}},"t":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"o":{"c":{"df":3,"docs":{"5":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"52":{"tf":1.0},"75":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"127":{"tf":1.0},"14":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"137":{"tf":1.0},"176":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":24,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"15":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":1.0},"21":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"t":{"'":{"df":19,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"166":{"tf":1.0},"182":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"63":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":8,"docs":{"171":{"tf":1.4142135623730951},"176":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"95":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"[":{"1":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":6,"docs":{"105":{"tf":2.449489742783178},"106":{"tf":1.0},"12":{"tf":1.0},"154":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"59":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"k":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"15":{"tf":1.0},"159":{"tf":1.0},"28":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"166":{"tf":1.0},"168":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":6,"docs":{"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.7320508075688772},"143":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":20,"docs":{"1":{"tf":2.0},"115":{"tf":1.0},"15":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"155":{"tf":1.7320508075688772},"17":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.7320508075688772},"172":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"154":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}},"n":{"df":3,"docs":{"166":{"tf":1.0},"21":{"tf":1.0},"75":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"1":{"2":{"1":{"0":{"4":{"2":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"7":{"4":{"2":{"df":1,"docs":{"156":{"tf":1.0}}},"3":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}},"5":{"7":{"df":1,"docs":{"173":{"tf":1.0}}},"8":{"df":1,"docs":{"130":{"tf":1.0}}},"9":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"4":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"5":{"3":{"df":1,"docs":{"178":{"tf":1.0}}},"df":0,"docs":{}},"6":{"6":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"4":{"3":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"1":{"1":{"4":{"7":{"6":{"4":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"181":{"tf":1.0},"21":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"180":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"60":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}},"r":{"df":6,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"166":{"tf":1.0},"76":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"166":{"tf":1.0},"167":{"tf":1.0},"30":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"1":{"0":{"0":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"t":{"'":{"df":7,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":4,"docs":{"58":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"131":{"tf":1.0},"167":{"tf":1.0},"32":{"tf":1.4142135623730951},"57":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"c":{"df":2,"docs":{"171":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"171":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"102":{"tf":1.4142135623730951},"109":{"tf":1.0},"110":{"tf":1.0},"176":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"28":{"tf":1.0},"50":{"tf":1.4142135623730951},"53":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"z":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":9,"docs":{"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":1.7320508075688772},"123":{"tf":1.7320508075688772},"126":{"tf":1.7320508075688772},"127":{"tf":2.23606797749979},"128":{"tf":1.0},"129":{"tf":1.7320508075688772}}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"181":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"64":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"s":{"\\":{"0":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"174":{"tf":1.0},"176":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":4,"docs":{"167":{"tf":1.0},"176":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.0}}},"t":{"df":38,"docs":{"101":{"tf":2.0},"106":{"tf":2.23606797749979},"112":{"tf":2.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"12":{"tf":2.449489742783178},"126":{"tf":2.23606797749979},"127":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.7320508075688772},"15":{"tf":2.23606797749979},"155":{"tf":2.0},"159":{"tf":2.23606797749979},"161":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":2.0},"165":{"tf":1.0},"167":{"tf":1.4142135623730951},"172":{"tf":2.0},"177":{"tf":2.0},"20":{"tf":2.0},"21":{"tf":1.7320508075688772},"43":{"tf":1.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"143":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"133":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"181":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"120":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"1":{"tf":1.0},"128":{"tf":1.0},"137":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"16":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"46":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"80":{"tf":1.0},"85":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":11,"docs":{"120":{"tf":1.0},"17":{"tf":1.4142135623730951},"171":{"tf":1.0},"175":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}},"p":{"df":2,"docs":{"105":{"tf":1.0},"176":{"tf":1.0}}}},"t":{"df":2,"docs":{"14":{"tf":1.0},"50":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"16":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":8,"docs":{"158":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"17":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":26,"docs":{"102":{"tf":1.0},"141":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"16":{"tf":3.605551275463989},"160":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"17":{"tf":3.0},"181":{"tf":1.0},"28":{"tf":2.0},"59":{"tf":2.449489742783178},"73":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.6457513110645907},"90":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"127":{"tf":1.0},"15":{"tf":1.0},"159":{"tf":1.0},"22":{"tf":1.4142135623730951},"64":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"158":{"tf":1.0},"162":{"tf":1.0},"176":{"tf":1.0},"28":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":30,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"112":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"121":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"143":{"tf":1.0},"154":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"171":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"32":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"112":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"176":{"tf":1.0}}}},"i":{"df":5,"docs":{"20":{"tf":1.0},"26":{"tf":1.0},"53":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":32,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"112":{"tf":2.0},"116":{"tf":1.4142135623730951},"12":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"172":{"tf":1.7320508075688772},"177":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"3":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":13,"docs":{"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"162":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":2.0},"174":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"95":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"158":{"tf":2.6457513110645907},"159":{"tf":1.0},"162":{"tf":1.0},"32":{"tf":1.7320508075688772},"59":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":2.0},"90":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}},"s":{"!":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":9,"docs":{"104":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.0}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"112":{"tf":1.0},"23":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"146":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"127":{"tf":1.0},"72":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"132":{"tf":1.0}}},"g":{"df":1,"docs":{"57":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"20":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":17,"docs":{"101":{"tf":2.6457513110645907},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"35":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":4.123105625617661},"53":{"tf":2.449489742783178},"54":{"tf":3.4641016151377544},"59":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":60,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"12":{"tf":2.449489742783178},"120":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.7320508075688772},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":1.7320508075688772},"13":{"tf":2.0},"134":{"tf":1.4142135623730951},"139":{"tf":1.0},"14":{"tf":2.6457513110645907},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.4142135623730951},"151":{"tf":1.0},"155":{"tf":1.7320508075688772},"159":{"tf":2.0},"16":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"168":{"tf":1.0},"172":{"tf":2.23606797749979},"177":{"tf":2.23606797749979},"182":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":2.0},"3":{"tf":2.23606797749979},"4":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.449489742783178},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":1.0},"69":{"tf":2.6457513110645907},"7":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"86":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"63":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"160":{"tf":1.0},"162":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"75":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"31":{"tf":2.0}}}},"df":5,"docs":{"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":2.0},"52":{"tf":1.0}},"e":{"df":1,"docs":{"180":{"tf":1.0}},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":7,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.0},"155":{"tf":1.4142135623730951},"20":{"tf":1.0},"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":10,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":38,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"78":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":6,"docs":{"115":{"tf":1.0},"138":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.0}}}},"<":{"df":0,"docs":{},"t":{">":{"(":{"_":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":5,"docs":{"13":{"tf":1.0},"32":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"162":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"110":{"tf":1.0},"32":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"146":{"tf":1.0},"16":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"131":{"tf":1.0},"132":{"tf":2.6457513110645907},"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":10,"docs":{"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":2.23606797749979},"133":{"tf":1.0},"134":{"tf":1.0},"171":{"tf":1.0},"39":{"tf":1.4142135623730951},"54":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"105":{"tf":2.0},"106":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"!":{"(":{"1":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{},"z":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"80":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"101":{"tf":1.7320508075688772},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"!":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":2.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"(":{")":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"52":{"tf":2.23606797749979},"84":{"tf":2.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":34,"docs":{"101":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"127":{"tf":2.0},"137":{"tf":2.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.0},"155":{"tf":1.4142135623730951},"162":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"132":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"139":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":38,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"155":{"tf":1.0},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"182":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.0},"39":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"123":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":2,"docs":{"165":{"tf":1.0},"167":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"132":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}},"w":{"df":34,"docs":{"1":{"tf":2.0},"10":{"tf":2.0},"105":{"tf":1.0},"12":{"tf":1.4142135623730951},"143":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"36":{"tf":1.0},"39":{"tf":1.7320508075688772},"47":{"tf":1.0},"5":{"tf":2.8284271247461903},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":2.6457513110645907},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"158":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"12":{"tf":2.0},"154":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"6":{"tf":2.0},"79":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":2.6457513110645907},"28":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"174":{"tf":1.0},"176":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":4,"docs":{"20":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"105":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"176":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"105":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"132":{"tf":1.0},"181":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"105":{"tf":1.0},"142":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":54,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"136":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"17":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":2.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"180":{"tf":1.7320508075688772},"181":{"tf":1.0},"23":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0}}}}},"df":1,"docs":{"132":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"132":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"39":{"tf":2.0},"52":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":5,"docs":{"120":{"tf":1.4142135623730951},"168":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":2.0}}},"l":{"d":{"df":7,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"158":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"181":{"tf":1.0},"28":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0}}}}},"n":{"c":{"df":5,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"9":{"tf":1.0}}},"df":26,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.7320508075688772},"142":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"15":{"tf":1.0},"168":{"tf":1.4142135623730951},"182":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.7320508075688772}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":7,"docs":{"117":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":1.7320508075688772},"123":{"tf":1.0},"126":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0}}}}},"df":1,"docs":{"70":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"31":{"tf":1.0},"47":{"tf":1.0}}},"r":{"df":5,"docs":{"114":{"tf":1.0},"115":{"tf":2.0},"132":{"tf":1.0},"133":{"tf":1.0},"168":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}},"t":{"df":3,"docs":{"1":{"tf":1.0},"57":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"a":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":15,"docs":{"13":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":2.0},"138":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"116":{"tf":1.0},"129":{"tf":1.0},"142":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"172":{"tf":1.0},"177":{"tf":1.0},"51":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"110":{"tf":1.0},"12":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"54":{"tf":1.0},"72":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"159":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"21":{"tf":1.0},"39":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"122":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}},"v":{"df":3,"docs":{"118":{"tf":1.0},"129":{"tf":2.0},"21":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"155":{"tf":1.0}}}}},"df":12,"docs":{"105":{"tf":2.23606797749979},"109":{"tf":1.0},"142":{"tf":1.0},"168":{"tf":1.0},"21":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"98":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"155":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":2.0},"141":{"tf":1.0},"146":{"tf":1.7320508075688772},"46":{"tf":1.0},"5":{"tf":2.23606797749979},"57":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"9":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}},"1":{"2":{"3":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}},"df":6,"docs":{"166":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":3.872983346207417},"76":{"tf":2.449489742783178}},"k":{"df":2,"docs":{"168":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"118":{"tf":1.4142135623730951},"120":{"tf":2.0},"121":{"tf":2.23606797749979},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"124":{"tf":2.0},"126":{"tf":1.0},"127":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"t":{"df":21,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"126":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"15":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"112":{"tf":1.0},"137":{"tf":1.0},"167":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":1.0},"132":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"166":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":1,"docs":{"89":{"tf":2.0}},"h":{"df":9,"docs":{"181":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":2.23606797749979},"26":{"tf":2.0},"30":{"tf":1.7320508075688772},"32":{"tf":3.0},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"162":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.449489742783178},"90":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"60":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"26":{"tf":1.0}}}}},"r":{"df":1,"docs":{"89":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"115":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"3":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"<":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":12,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"146":{"tf":1.0},"155":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"180":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"110":{"tf":1.0},"13":{"tf":1.0},"176":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"133":{"tf":1.7320508075688772},"171":{"tf":1.0},"42":{"tf":1.0},"72":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"101":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"101":{"tf":1.7320508075688772},"98":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"124":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"127":{"tf":1.0},"133":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"180":{"tf":1.0},"181":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"117":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"139":{"tf":1.0},"143":{"tf":1.4142135623730951},"147":{"tf":1.0},"39":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"#":{"1":{"2":{"3":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"79":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"'":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"155":{"tf":1.0},"29":{"tf":1.4142135623730951},"79":{"tf":2.8284271247461903},"80":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":11,"docs":{"102":{"tf":1.0},"28":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.449489742783178},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":2.23606797749979},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"121":{"tf":2.449489742783178},"122":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"126":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"166":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":12,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"137":{"tf":1.0},"147":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"22":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0}},"s":{"df":7,"docs":{"105":{"tf":1.0},"141":{"tf":1.0},"168":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"58":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"176":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"a":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"128":{"tf":1.0},"129":{"tf":1.0},"180":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":2,"docs":{"54":{"tf":2.0},"95":{"tf":1.4142135623730951}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":11,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"14":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"6":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"141":{"tf":1.0},"28":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"141":{"tf":1.0},"16":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":2.449489742783178},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"110":{"tf":1.0},"14":{"tf":1.4142135623730951},"180":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"75":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"110":{"tf":1.0},"21":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":16,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"141":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"9":{"tf":1.4142135623730951},"95":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":5,"docs":{"171":{"tf":1.0},"175":{"tf":1.0},"23":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"111":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}},"u":{"b":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":10,"docs":{"128":{"tf":1.0},"171":{"tf":2.0},"175":{"tf":1.0},"180":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"x":{".":{"0":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"101":{"tf":1.0}},"i":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"r":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":2.0}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"167":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"142":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.7320508075688772}}},"k":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"163":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"75":{"tf":1.0}}}},"w":{"df":7,"docs":{"133":{"tf":2.0},"155":{"tf":1.0},"3":{"tf":1.0},"42":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"df":3,"docs":{"155":{"tf":1.0},"168":{"tf":1.4142135623730951},"79":{"tf":1.0}},"e":{"a":{"d":{"df":7,"docs":{"132":{"tf":1.0},"138":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":3,"docs":{"64":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"132":{"tf":1.0},"133":{"tf":1.7320508075688772},"138":{"tf":1.0},"146":{"tf":1.0},"166":{"tf":1.0},"22":{"tf":1.0},"50":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"102":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"133":{"tf":1.0},"180":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"28":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"f":{"df":1,"docs":{"132":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":23,"docs":{"101":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":3.1622776601683795},"133":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951},"4":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"68":{"tf":2.0},"70":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"72":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":4,"docs":{"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"133":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":3,"docs":{"168":{"tf":1.0},"180":{"tf":1.0},"32":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":32,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"28":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.4142135623730951},"95":{"tf":3.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"78":{"tf":1.0},"89":{"tf":1.0}}}},"i":{"df":1,"docs":{"90":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"21":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"166":{"tf":1.0},"17":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":12,"docs":{"118":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.4142135623730951},"141":{"tf":2.6457513110645907},"147":{"tf":1.4142135623730951},"163":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"69":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.0},"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"111":{"tf":1.0},"118":{"tf":1.0},"128":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":30,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"171":{"tf":1.7320508075688772},"175":{"tf":2.0},"176":{"tf":1.7320508075688772},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"63":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":9,"docs":{"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"94":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"v":{"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.6457513110645907},"58":{"tf":2.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":5,"docs":{"112":{"tf":1.0},"115":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"59":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"129":{"tf":1.0},"16":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":2.0}}},"u":{"3":{"2":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":7,"docs":{"171":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"2":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"106":{"tf":1.0},"158":{"tf":1.0},"182":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"105":{"tf":1.7320508075688772},"120":{"tf":1.0},"168":{"tf":2.8284271247461903}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"112":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"51":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"182":{"tf":1.0}}}}}}}}}},"f":{"c":{"df":11,"docs":{"115":{"tf":1.0},"117":{"tf":1.4142135623730951},"154":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.0},"47":{"tf":1.0},"68":{"tf":1.4142135623730951},"79":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"162":{"tf":1.0},"180":{"tf":2.0},"70":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.0}}},"t":{"df":11,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"124":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"117":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"126":{"tf":1.0},"128":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":1.0},"117":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"158":{"tf":2.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":1.0},"87":{"tf":1.0}}}},"n":{"<":{"df":0,"docs":{},"r":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":36,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"116":{"tf":1.0},"12":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.7320508075688772},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.0},"168":{"tf":1.4142135623730951},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"21":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":4,"docs":{"0":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"75":{"tf":1.0}}},"_":{"2":{"0":{"2":{"1":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"80":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"4":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"102":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.0},"28":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":1,"docs":{"180":{"tf":1.0}}},"df":4,"docs":{"178":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":2.0}}},"df":0,"docs":{}}},"df":77,"docs":{"0":{"tf":1.0},"1":{"tf":2.6457513110645907},"10":{"tf":1.0},"101":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":2.0},"123":{"tf":1.4142135623730951},"126":{"tf":2.23606797749979},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":1.7320508075688772},"154":{"tf":1.0},"155":{"tf":1.7320508075688772},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"175":{"tf":1.0},"177":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":3.3166247903554},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":3.0},"33":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":2.23606797749979},"64":{"tf":2.8284271247461903},"68":{"tf":2.0},"69":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":2.8284271247461903},"72":{"tf":1.0},"75":{"tf":2.23606797749979},"76":{"tf":1.7320508075688772},"80":{"tf":2.23606797749979},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"89":{"tf":2.23606797749979},"9":{"tf":2.0},"90":{"tf":2.23606797749979},"93":{"tf":1.0},"95":{"tf":2.8284271247461903},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"20":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"s":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":5,"docs":{"110":{"tf":1.0},"171":{"tf":2.23606797749979},"176":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":7,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"133":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"e":{"df":20,"docs":{"101":{"tf":1.4142135623730951},"111":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":1.0},"146":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"59":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"111":{"tf":1.0},"112":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"127":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"158":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":11,"docs":{"101":{"tf":1.4142135623730951},"118":{"tf":1.0},"121":{"tf":2.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"52":{"tf":2.6457513110645907},"71":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"79":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"115":{"tf":1.0},"158":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":24,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"6":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":24,"docs":{"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"129":{"tf":1.0},"15":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"171":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":2.0},"68":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0}},"k":{"df":1,"docs":{"8":{"tf":1.0}}},"m":{"df":3,"docs":{"26":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.0}}},"n":{"df":1,"docs":{"168":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"166":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"25":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":2.23606797749979}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"126":{"tf":1.0},"3":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"n":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"72":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":2,"docs":{"67":{"tf":1.0},"72":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"15":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"79":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"93":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":10,"docs":{"12":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.7320508075688772},"176":{"tf":1.0},"18":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"141":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"131":{"tf":1.0},"132":{"tf":2.23606797749979},"53":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"181":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"39":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"w":{"df":1,"docs":{"60":{"tf":2.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"121":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"172":{"tf":1.0}}}}}},"df":1,"docs":{"93":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"180":{"tf":1.0},"26":{"tf":1.0}}}}}}},"df":2,"docs":{"179":{"tf":1.0},"180":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"106":{"tf":1.0},"116":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.0},"13":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"180":{"tf":1.0},"26":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":7,"docs":{"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":9,"docs":{"112":{"tf":1.0},"13":{"tf":1.0},"142":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.0},"75":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"166":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"132":{"tf":1.0},"133":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.0},"181":{"tf":2.0},"19":{"tf":1.0},"28":{"tf":1.0},"51":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"d":{">":{"(":{"_":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"120":{"tf":2.23606797749979},"121":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":2.449489742783178},"128":{"tf":2.449489742783178},"129":{"tf":1.7320508075688772}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":2.449489742783178},"106":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"115":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":1.0}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"147":{"tf":1.0},"166":{"tf":1.0},"28":{"tf":1.0},"58":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":4,"docs":{"15":{"tf":1.0},"158":{"tf":1.4142135623730951},"16":{"tf":1.0},"39":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"166":{"tf":1.0},"175":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":4,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"127":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":12,"docs":{"111":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"127":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.4142135623730951},"79":{"tf":1.0}},"i":{"df":22,"docs":{"120":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"146":{"tf":2.449489742783178},"147":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":2.23606797749979},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"162":{"tf":2.0},"168":{"tf":2.23606797749979},"171":{"tf":1.0},"22":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"168":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":1,"docs":{"171":{"tf":1.0}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"154":{"tf":1.0},"166":{"tf":1.0},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"l":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"40":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"181":{"tf":2.0},"182":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":8,"docs":{"102":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"28":{"tf":1.0},"50":{"tf":1.4142135623730951},"53":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":19,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"121":{"tf":1.0},"162":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":2.0},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"180":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"70":{"tf":1.0}}}}}}},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"131":{"tf":1.0},"132":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":10,"docs":{"120":{"tf":1.4142135623730951},"127":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":3.1622776601683795},"133":{"tf":1.4142135623730951},"134":{"tf":1.0},"171":{"tf":1.0},"180":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"10":{"tf":1.0}}}},"y":{"df":1,"docs":{"12":{"tf":1.0}}}},"d":{"'":{"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"108":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"108":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.0},"98":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"108":{"tf":1.0},"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"101":{"tf":1.0},"28":{"tf":1.7320508075688772},"52":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":42,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"111":{"tf":1.0},"37":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"74":{"tf":1.4142135623730951},"75":{"tf":2.6457513110645907},"76":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":3.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"p":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":1,"docs":{"171":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"102":{"tf":1.0},"133":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"122":{"tf":1.0},"32":{"tf":1.7320508075688772},"50":{"tf":1.0},"53":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"98":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"142":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":2.23606797749979},"32":{"tf":2.0},"52":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"78":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":4,"docs":{"50":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"180":{"tf":1.0}}}}}}},"df":1,"docs":{"180":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":18,"docs":{"126":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"166":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"15":{"tf":1.7320508075688772},"182":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":32,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"141":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"153":{"tf":1.0},"157":{"tf":1.0},"161":{"tf":1.0},"165":{"tf":1.0},"170":{"tf":1.0},"174":{"tf":1.0},"179":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"32":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":15,"docs":{"1":{"tf":1.0},"123":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.7320508075688772},"57":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"112":{"tf":1.0},"143":{"tf":1.4142135623730951},"146":{"tf":1.0},"16":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"90":{"tf":1.0},"98":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"129":{"tf":1.0},"75":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"68":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"116":{"tf":1.0},"58":{"tf":1.0},"75":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"58":{"tf":1.0}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"176":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":27,"docs":{"101":{"tf":1.4142135623730951},"104":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"137":{"tf":1.0},"158":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.449489742783178},"85":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":2.0}}}}}}}},"t":{".":{"0":{"df":1,"docs":{"71":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"120":{"tf":1.0},"128":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"31":{"tf":1.0}},"l":{"df":8,"docs":{"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.7320508075688772},"143":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"17":{"tf":1.0},"181":{"tf":2.449489742783178},"182":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.6457513110645907},"60":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951}},"n":{"df":2,"docs":{"176":{"tf":1.0},"30":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":2.449489742783178},"46":{"tf":2.0},"59":{"tf":1.4142135623730951}}}}}}},"df":10,"docs":{"101":{"tf":1.0},"105":{"tf":1.4142135623730951},"115":{"tf":2.0},"120":{"tf":2.23606797749979},"127":{"tf":1.4142135623730951},"128":{"tf":2.8284271247461903},"129":{"tf":3.1622776601683795},"166":{"tf":1.7320508075688772},"168":{"tf":2.0},"71":{"tf":3.4641016151377544}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"60":{"tf":2.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"137":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":13,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"178":{"tf":1.0},"18":{"tf":2.23606797749979},"180":{"tf":2.0},"181":{"tf":2.0},"182":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"t":{"'":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"54":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"53":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"133":{"tf":1.0},"39":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"111":{"tf":1.0},"13":{"tf":1.0},"141":{"tf":1.0},"166":{"tf":1.0},"26":{"tf":1.4142135623730951},"67":{"tf":1.0},"95":{"tf":1.0}}},"k":{"df":1,"docs":{"168":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":21,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"146":{"tf":1.0},"158":{"tf":1.0},"17":{"tf":1.4142135623730951},"181":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"32":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"111":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"110":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"50":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"1":{"tf":1.0},"133":{"tf":1.0},"143":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"52":{"tf":1.0},"86":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"54":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"142":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}},"p":{"df":1,"docs":{"12":{"tf":1.0}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"21":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":2,"docs":{"112":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"94":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0}}}},"p":{"df":8,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951},"22":{"tf":1.0},"32":{"tf":1.4142135623730951},"57":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"r":{"<":{"'":{"_":{"df":1,"docs":{"123":{"tf":1.0}}},"a":{"df":1,"docs":{"123":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"41":{"tf":1.0},"50":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":27,"docs":{"101":{"tf":2.6457513110645907},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"128":{"tf":1.0},"168":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"39":{"tf":4.898979485566356},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":4.242640687119285},"53":{"tf":1.7320508075688772},"54":{"tf":2.6457513110645907},"63":{"tf":2.449489742783178},"67":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":2.8284271247461903},"8":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"59":{"tf":1.0},"60":{"tf":2.6457513110645907},"80":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"128":{"tf":2.449489742783178},"129":{"tf":3.0}},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":7,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.7320508075688772},"5":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"12":{"tf":1.0},"132":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"168":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"137":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772}}}},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"52":{"tf":1.0},"54":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"124":{"tf":1.0},"127":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":5,"docs":{"166":{"tf":1.4142135623730951},"27":{"tf":1.0},"39":{"tf":1.0},"52":{"tf":1.0},"79":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":15,"docs":{"101":{"tf":1.0},"115":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"180":{"tf":1.7320508075688772},"28":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"69":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}},"y":{"df":2,"docs":{"123":{"tf":2.23606797749979},"138":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"127":{"tf":1.0}}},"df":22,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"117":{"tf":1.0},"120":{"tf":2.6457513110645907},"121":{"tf":2.0},"123":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":2.23606797749979},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"133":{"tf":1.0},"141":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":2.0},"166":{"tf":3.7416573867739413},"168":{"tf":3.3166247903554},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.0},"63":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"176":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"3":{"2":{">":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"180":{"tf":2.449489742783178}}},"df":0,"docs":{}},"8":{"df":6,"docs":{"132":{"tf":1.0},"166":{"tf":1.4142135623730951},"171":{"tf":1.0},"35":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"85":{"tf":1.0}}},"df":2,"docs":{"122":{"tf":1.0},"128":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"40":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"29":{"tf":1.0},"50":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"168":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"132":{"tf":1.0},"134":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0}}}}},"r":{"df":18,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"142":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"16":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"168":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"59":{"tf":1.0}},"i":{"df":3,"docs":{"146":{"tf":1.0},"32":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"176":{"tf":1.4142135623730951}}}},"t":{">":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"165":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":2.449489742783178}}},"x":{"df":2,"docs":{"111":{"tf":1.0},"176":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.0},"146":{"tf":1.0},"28":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"182":{"tf":1.0},"52":{"tf":1.0},"99":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"166":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":21,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":2.23606797749979},"111":{"tf":1.7320508075688772},"112":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"115":{"tf":3.872983346207417},"116":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":3.4641016151377544},"172":{"tf":1.4142135623730951},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":2.0},"176":{"tf":1.0},"177":{"tf":1.0},"72":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.0}}}}}}}},"df":6,"docs":{"105":{"tf":1.0},"12":{"tf":1.0},"158":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":5,"docs":{"144":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":17,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"139":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"172":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"182":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":4,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"3":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"133":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"115":{"tf":1.0},"132":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"112":{"tf":1.0},"177":{"tf":1.0},"88":{"tf":1.0}}}},"df":81,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"104":{"tf":1.0},"112":{"tf":2.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"120":{"tf":2.6457513110645907},"121":{"tf":3.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"126":{"tf":1.7320508075688772},"127":{"tf":2.8284271247461903},"128":{"tf":2.23606797749979},"129":{"tf":2.449489742783178},"13":{"tf":2.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"141":{"tf":2.449489742783178},"143":{"tf":1.7320508075688772},"146":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.7320508075688772},"159":{"tf":1.0},"16":{"tf":2.23606797749979},"163":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"171":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"181":{"tf":2.23606797749979},"20":{"tf":2.8284271247461903},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":4.123105625617661},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.0},"32":{"tf":3.7416573867739413},"34":{"tf":1.0},"39":{"tf":2.0},"41":{"tf":1.0},"5":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":2.449489742783178},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.7320508075688772},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":2.23606797749979},"79":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":2.23606797749979},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}},"e":{"<":{"'":{"_":{"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}}},"a":{"df":3,"docs":{"120":{"tf":1.4142135623730951},"123":{"tf":1.0},"128":{"tf":1.0}}},"df":0,"docs":{}},"_":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":3,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"127":{"tf":1.0}}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":1,"docs":{"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0}},"e":{">":{"(":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"28":{"tf":2.23606797749979},"58":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"{":{"0":{"0":{"df":0,"docs":{},"e":{"6":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"60":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}}},".":{"1":{".":{"3":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"2":{"df":1,"docs":{"95":{"tf":1.0}}},"3":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"32":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"16":{"tf":1.0},"171":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":11,"docs":{"105":{"tf":1.7320508075688772},"166":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":2.0},"8":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"155":{"tf":1.0},"162":{"tf":1.0},"42":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}}},"df":1,"docs":{"17":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"71":{"tf":2.0}}},"1":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951}}},"2":{"2":{"df":1,"docs":{"69":{"tf":1.0}}},"3":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"111":{"tf":1.0},"171":{"tf":1.0},"182":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":8,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"137":{"tf":1.0},"142":{"tf":1.4142135623730951},"146":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":2.0},"9":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"u":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":3,"docs":{"133":{"tf":1.0},"28":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"132":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"28":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"2":{"0":{"2":{"4":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"159":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"2":{"0":{"2":{"1":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":2,"docs":{"115":{"tf":1.0},"116":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":23,"docs":{"106":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"12":{"tf":1.7320508075688772},"127":{"tf":1.0},"147":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"64":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":21,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"124":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.4142135623730951},"154":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":6,"docs":{"101":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.0},"21":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"v":{"df":4,"docs":{"51":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"28":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"64":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"133":{"tf":1.0},"17":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"127":{"tf":1.0},"146":{"tf":1.0},"182":{"tf":1.0},"54":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"181":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"121":{"tf":2.0},"127":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"180":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"99":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"132":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.0},"30":{"tf":1.0},"59":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.7320508075688772},"9":{"tf":1.0},"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"181":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"2":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"\\":{"0":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":37,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.0},"12":{"tf":1.7320508075688772},"120":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":2.23606797749979},"166":{"tf":1.0},"17":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.0},"4":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":2.8284271247461903},"57":{"tf":2.0}},"e":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"146":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"147":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":4,"docs":{"176":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"112":{"tf":1.0},"115":{"tf":1.0},"72":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":11,"docs":{"129":{"tf":1.0},"154":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"74":{"tf":1.0}}},".":{"0":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},">":{"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"3":{"\\":{"df":0,"docs":{},"x":{"a":{"6":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"\\":{"df":0,"docs":{},"x":{"b":{"1":{"\\":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"\\":{"df":0,"docs":{},"x":{"b":{"2":{"\\":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"\\":{"df":0,"docs":{},"x":{"b":{"3":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":15,"docs":{"105":{"tf":2.449489742783178},"106":{"tf":2.0},"120":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":3.4641016151377544},"129":{"tf":3.0},"132":{"tf":2.449489742783178},"166":{"tf":2.23606797749979},"30":{"tf":2.0},"64":{"tf":2.23606797749979},"69":{"tf":1.7320508075688772},"70":{"tf":2.8284271247461903},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"133":{"tf":1.0}}}}},"y":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"120":{"tf":1.4142135623730951},"127":{"tf":2.8284271247461903},"128":{"tf":2.449489742783178},"129":{"tf":2.449489742783178},"132":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"105":{"tf":1.0},"106":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":2,"docs":{"28":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"76":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.0}}}},"r":{"df":2,"docs":{"28":{"tf":1.0},"9":{"tf":1.0}}},"v":{"df":2,"docs":{"28":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"df":1,"docs":{"80":{"tf":1.0}}}}},"breadcrumbs":{"root":{"0":{".":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"1":{"0":{"0":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"5":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"1":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{".":{"5":{"df":1,"docs":{"142":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"95":{"tf":1.0}}},"9":{"df":1,"docs":{"95":{"tf":1.0}}},"df":2,"docs":{"132":{"tf":1.0},"93":{"tf":1.0}}},"1":{".":{"0":{".":{"0":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"1":{"tf":1.0},"22":{"tf":2.23606797749979},"99":{"tf":1.0}}},"1":{"0":{".":{"4":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":2,"docs":{"162":{"tf":1.0},"163":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":1,"docs":{"163":{"tf":1.0}}},"7":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"3":{"1":{".":{"0":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.0},"33":{"tf":1.0}}},"2":{"df":1,"docs":{"32":{"tf":1.0}}},"7":{"df":1,"docs":{"111":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"59":{"tf":1.0}}},"7":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"1":{"df":2,"docs":{"28":{"tf":1.0},"64":{"tf":1.0}}},"2":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"5":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"57":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"63":{"tf":1.0},"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"63":{"tf":1.0},"89":{"tf":1.0}}},"5":{"df":1,"docs":{"64":{"tf":1.0}}},"6":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"7":{"7":{"df":1,"docs":{"93":{"tf":1.0}}},"9":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}},"8":{"0":{"df":1,"docs":{"105":{"tf":2.0}}},"2":{"df":6,"docs":{"120":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"163":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":3,"docs":{"70":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"95":{"tf":2.0}}},"2":{"3":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"8":{"5":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":14,"docs":{"1":{"tf":1.0},"132":{"tf":1.0},"158":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":2.0},"63":{"tf":2.449489742783178},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":2.0}},"u":{"8":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"2":{".":{"0":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":20,"docs":{"1":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":3.3166247903554},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"22":{"tf":1.0}}},"8":{"df":47,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":2.449489742783178},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":2.23606797749979},"51":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":2.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"86":{"tf":1.0},"9":{"tf":2.0},"90":{"tf":1.0}}},"9":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"1":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":58,"docs":{"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"158":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.4142135623730951},"51":{"tf":2.0},"52":{"tf":2.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"64":{"tf":2.6457513110645907},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":2.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.23606797749979},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":2.23606797749979},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.0}}},"4":{"df":89,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":2.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":2.449489742783178},"106":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":2.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.449489742783178},"127":{"tf":1.7320508075688772},"128":{"tf":1.7320508075688772},"129":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.7320508075688772},"156":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"160":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"177":{"tf":1.7320508075688772},"178":{"tf":1.4142135623730951},"179":{"tf":1.0},"180":{"tf":2.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"95":{"tf":4.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"95":{"tf":2.0}}},"df":0,"docs":{}},"5":{"2":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"2":{"2":{"9":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.0}}},"3":{"df":1,"docs":{"132":{"tf":1.0}}},"4":{"df":1,"docs":{"132":{"tf":1.0}}},"5":{"6":{"df":1,"docs":{"171":{"tf":1.0}}},"8":{"5":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":12,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"132":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"63":{"tf":2.8284271247461903},"64":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0}}},"3":{"0":{"8":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"5":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"4":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"9":{"8":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"1":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"1":{"3":{"df":1,"docs":{"154":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"7":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"132":{"tf":1.0},"63":{"tf":2.8284271247461903},"64":{"tf":1.4142135623730951}}},"4":{"0":{"1":{"0":{"7":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"0":{"6":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":2,"docs":{"181":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"8":{"\\":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}},"9":{"9":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"_":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"88":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":2.0}}}},"df":0,"docs":{}}},"df":10,"docs":{"101":{"tf":1.0},"118":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951}}},"a":{"#":{"b":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"x":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"171":{"tf":1.0},"175":{"tf":1.0},"20":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":14,"docs":{"10":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.7320508075688772},"143":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"d":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},":":{":":{"<":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{">":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"166":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"28":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"112":{"tf":1.0},"133":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"57":{"tf":1.0},"59":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"180":{"tf":1.0}}}}}}},"df":23,"docs":{"101":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"129":{"tf":1.0},"137":{"tf":2.0},"139":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"172":{"tf":1.4142135623730951},"177":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"28":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":20,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"115":{"tf":1.0},"126":{"tf":1.4142135623730951},"171":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":22,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"126":{"tf":1.0},"137":{"tf":1.4142135623730951},"15":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.0},"171":{"tf":1.4142135623730951},"175":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":2.0},"69":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":12,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"120":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"12":{"tf":1.0},"168":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"115":{"tf":1.0},"54":{"tf":1.0},"90":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":3,"docs":{"51":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"k":{"a":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"127":{"tf":1.0},"163":{"tf":1.0}}}}},"i":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"133":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"28":{"tf":2.0}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":24,"docs":{"105":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"155":{"tf":1.0},"158":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"35":{"tf":1.4142135623730951},"46":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":12,"docs":{"106":{"tf":1.0},"111":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"146":{"tf":1.0},"155":{"tf":1.0},"28":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.0},"76":{"tf":2.0},"79":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}},"n":{"df":12,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"182":{"tf":1.0},"39":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"180":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"132":{"tf":1.0},"166":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"53":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":8,"docs":{"101":{"tf":1.7320508075688772},"39":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":2.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"z":{"df":2,"docs":{"182":{"tf":1.0},"20":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"132":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"182":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"10":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":5,"docs":{"124":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"168":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.7320508075688772},"63":{"tf":1.0},"68":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"68":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"139":{"tf":1.0},"29":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":2,"docs":{"124":{"tf":2.0},"127":{"tf":2.0}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"121":{"tf":1.0},"127":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":12,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.7320508075688772},"126":{"tf":1.0},"15":{"tf":1.7320508075688772},"155":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":2.0},"63":{"tf":1.0},"74":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"134":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"75":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"166":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"124":{"tf":2.0},"127":{"tf":1.0},"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"35":{"tf":1.0},"75":{"tf":3.0},"76":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"23":{"tf":1.0},"32":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"64":{"tf":2.23606797749979},"65":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"a":{"d":{"d":{"(":{"1":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"\"":{"c":{":":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"#":{"\"":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"#":{"\"":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"(":{"2":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":2.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"94":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":7,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"121":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.0},"181":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"13":{"tf":1.0},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":2.449489742783178},"176":{"tf":2.23606797749979},"177":{"tf":2.0},"181":{"tf":1.7320508075688772},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"171":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}},"o":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}}},"df":47,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.7320508075688772},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":2.0},"163":{"tf":1.0},"168":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"28":{"tf":2.0},"3":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}}}},"df":6,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"58":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"13":{"tf":1.0},"180":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"4":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":14,"docs":{"109":{"tf":1.0},"126":{"tf":1.4142135623730951},"132":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"180":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.7320508075688772}}}},"r":{"df":1,"docs":{"4":{"tf":1.0}}},"y":{"df":3,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.7320508075688772},"22":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"b":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"165":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"121":{"tf":1.0}}},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"z":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":3,"docs":{"79":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":9,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"147":{"tf":1.0},"162":{"tf":1.0},"39":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"60":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}},"df":11,"docs":{"112":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.4142135623730951},"177":{"tf":1.0},"181":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"64":{"tf":1.0},"72":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":17,"docs":{"10":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"111":{"tf":1.0},"12":{"tf":1.0},"154":{"tf":1.0},"180":{"tf":1.0},"28":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":16,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"121":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"182":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"133":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"51":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"13":{"tf":1.0},"176":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"112":{"tf":1.0},"146":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"179":{"tf":1.0},"180":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"14":{"tf":1.0}}},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":14,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.0},"154":{"tf":1.7320508075688772},"169":{"tf":1.7320508075688772},"170":{"tf":1.4142135623730951},"171":{"tf":2.8284271247461903},"172":{"tf":2.0},"180":{"tf":1.0},"41":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"34":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"155":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":9,"docs":{"118":{"tf":2.0},"120":{"tf":1.4142135623730951},"121":{"tf":2.8284271247461903},"122":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.7320508075688772},"127":{"tf":2.0},"128":{"tf":1.7320508075688772},"129":{"tf":2.0}}},"df":0,"docs":{}}},"x":{"<":{"[":{"df":0,"docs":{},"t":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0}}},"u":{"3":{"2":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{")":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"168":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"162":{"tf":1.0},"63":{"tf":1.7320508075688772}}}},"df":9,"docs":{"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"158":{"tf":1.0},"50":{"tf":1.7320508075688772},"54":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"47":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":2.23606797749979},"168":{"tf":1.7320508075688772},"21":{"tf":1.0},"63":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}},"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":2.8284271247461903},"60":{"tf":4.123105625617661}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"d":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"141":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":11,"docs":{"141":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":3.7416573867739413},"6":{"tf":1.0},"60":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":5,"docs":{"181":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"180":{"tf":1.0}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"79":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"c":{"\"":{"\\":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"c":{":":{"\\":{"\\":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":31,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":2.6457513110645907},"106":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":2.0},"114":{"tf":1.0},"115":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"155":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":2.23606797749979},"171":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":2.23606797749979},"54":{"tf":2.6457513110645907},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"129":{"tf":1.0}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"166":{"tf":1.4142135623730951},"168":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":20,"docs":{"117":{"tf":2.23606797749979},"118":{"tf":2.0},"119":{"tf":1.0},"120":{"tf":3.1622776601683795},"121":{"tf":2.449489742783178},"122":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.0},"127":{"tf":2.0},"128":{"tf":3.0},"129":{"tf":2.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"68":{"tf":3.3166247903554},"69":{"tf":2.449489742783178},"70":{"tf":2.0},"71":{"tf":2.0},"72":{"tf":3.0}},"e":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},"<":{"'":{"a":{">":{"(":{"_":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"<":{"(":{"&":{"'":{"a":{"df":1,"docs":{"128":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"r":{"d":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":2,"docs":{"176":{"tf":1.0},"75":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"3":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":17,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"139":{"tf":1.4142135623730951},"14":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"18":{"tf":1.0},"28":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":55,"docs":{"1":{"tf":1.0},"10":{"tf":2.0},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":3.0},"126":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"135":{"tf":1.7320508075688772},"136":{"tf":1.0},"137":{"tf":1.7320508075688772},"138":{"tf":1.0},"139":{"tf":1.7320508075688772},"14":{"tf":2.23606797749979},"140":{"tf":1.7320508075688772},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.7320508075688772},"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.7320508075688772},"15":{"tf":2.23606797749979},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.23606797749979},"59":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"60":{"tf":2.8284271247461903},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":2.449489742783178},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":27,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":2.0},"132":{"tf":1.0},"14":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.4142135623730951},"18":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":11,"docs":{"155":{"tf":1.0},"166":{"tf":1.4142135623730951},"168":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"112":{"tf":1.0}}}}}}}},"df":12,"docs":{"121":{"tf":1.7320508075688772},"122":{"tf":2.23606797749979},"171":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"72":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"109":{"tf":1.0},"154":{"tf":1.0},"175":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"13":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":70,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"109":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":2.0},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"138":{"tf":1.0},"142":{"tf":1.7320508075688772},"146":{"tf":1.0},"15":{"tf":1.4142135623730951},"155":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"16":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.0},"166":{"tf":1.7320508075688772},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"17":{"tf":1.0},"180":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"67":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.23606797749979},"9":{"tf":1.0},"90":{"tf":1.7320508075688772},"95":{"tf":1.0},"98":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"28":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"117":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"47":{"tf":1.0},"8":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":2.0}}}},"df":0,"docs":{}},"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":2.0},"131":{"tf":1.0},"147":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"76":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"30":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"155":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"171":{"tf":1.0},"26":{"tf":1.0},"52":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"20":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"50":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"111":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"68":{"tf":2.23606797749979},"69":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"71":{"tf":2.0},"72":{"tf":2.6457513110645907}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"51":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":68,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":2.449489742783178},"120":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":2.23606797749979},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"15":{"tf":2.0},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":2.0},"17":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"19":{"tf":2.449489742783178},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":2.449489742783178},"22":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":2.23606797749979},"39":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"8":{"tf":2.8284271247461903},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"166":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"165":{"tf":1.0},"166":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"176":{"tf":1.0},"54":{"tf":1.7320508075688772}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"178":{"tf":1.7320508075688772},"179":{"tf":1.4142135623730951},"180":{"tf":1.7320508075688772},"181":{"tf":2.8284271247461903},"182":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"50":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"15":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"79":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"129":{"tf":1.0},"168":{"tf":1.4142135623730951},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}},"t":{"df":29,"docs":{"0":{"tf":1.0},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"182":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"133":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":28,"docs":{"112":{"tf":1.4142135623730951},"12":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"166":{"tf":2.449489742783178},"168":{"tf":1.0},"17":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.0},"12":{"tf":1.0},"167":{"tf":1.0},"32":{"tf":1.0},"70":{"tf":1.0}}},"x":{"df":2,"docs":{"133":{"tf":1.0},"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"15":{"tf":1.0},"159":{"tf":1.0},"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":6,"docs":{"142":{"tf":1.0},"146":{"tf":1.0},"166":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.0},"75":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"26":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"69":{"tf":1.0}}}}},"i":{"d":{"df":11,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"137":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"121":{"tf":1.0},"140":{"tf":1.7320508075688772},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"85":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"t":{"df":7,"docs":{"121":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"133":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.0},"171":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":18,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.7320508075688772},"68":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":9,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"127":{"tf":1.0},"155":{"tf":1.0},"180":{"tf":1.0},"21":{"tf":1.0},"51":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.0}}},"t":{"df":3,"docs":{"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"!":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"v":{"1":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"110":{"tf":1.0},"129":{"tf":1.0},"15":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"3":{"tf":1.0},"59":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":10,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"128":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"59":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"120":{"tf":1.0},"147":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"4":{"tf":2.0}}}}}},"r":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"176":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"141":{"tf":1.0}}}}}},"df":31,"docs":{"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"141":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":2.23606797749979},"172":{"tf":1.0},"177":{"tf":1.0},"181":{"tf":2.0},"182":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"25":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"28":{"tf":5.385164807134504},"29":{"tf":3.3166247903554},"3":{"tf":1.0},"30":{"tf":3.3166247903554},"32":{"tf":2.23606797749979},"4":{"tf":1.4142135623730951},"50":{"tf":1.0},"57":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.7320508075688772},"93":{"tf":1.0},"98":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"93":{"tf":1.4142135623730951},"94":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"(":{"b":{"\"":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\\":{"0":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"12":{"tf":1.4142135623730951},"168":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"39":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"142":{"tf":1.0}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"53":{"tf":1.7320508075688772},"70":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"166":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}}},"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"146":{"tf":1.0},"2":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":4,"docs":{"138":{"tf":1.0},"142":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"115":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"59":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"o":{"d":{"df":1,"docs":{"137":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"141":{"tf":1.0},"142":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":28,"docs":{"106":{"tf":1.0},"114":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.7320508075688772},"145":{"tf":2.0},"146":{"tf":3.4641016151377544},"147":{"tf":2.0},"15":{"tf":1.0},"163":{"tf":1.4142135623730951},"165":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"171":{"tf":1.0},"22":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":2.8284271247461903},"64":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"133":{"tf":1.0},"158":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"110":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.0},"17":{"tf":1.7320508075688772},"176":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"26":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"162":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0}}},"y":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}}},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"137":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":17,"docs":{"105":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":2.8284271247461903},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.4142135623730951},"142":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":2.6457513110645907},"163":{"tf":1.0},"166":{"tf":1.0},"181":{"tf":1.0},"5":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"58":{"tf":2.23606797749979},"59":{"tf":5.0990195135927845},"60":{"tf":3.4641016151377544}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":7,"docs":{"111":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"52":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"54":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"102":{"tf":1.0},"99":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"117":{"tf":1.0},"175":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"176":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"168":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":39,"docs":{"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"150":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"180":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"6":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":2.0},"69":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"114":{"tf":1.0},"12":{"tf":1.0},"132":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"181":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"110":{"tf":1.0},"115":{"tf":1.0},"159":{"tf":1.4142135623730951},"181":{"tf":1.0},"182":{"tf":1.0},"54":{"tf":1.0}}}}}}}},"v":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"141":{"tf":1.0},"142":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"141":{"tf":1.0},"142":{"tf":1.0},"59":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"133":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":2.0}}}}}}},"df":1,"docs":{"59":{"tf":2.8284271247461903}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"102":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":2.0},"134":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.4142135623730951},"58":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"90":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"132":{"tf":1.0},"22":{"tf":1.4142135623730951},"6":{"tf":1.0}},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"6":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"133":{"tf":1.0},"30":{"tf":1.0},"63":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"20":{"tf":1.0},"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"16":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"12":{"tf":1.0},"147":{"tf":1.0},"16":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}}},"o":{"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"128":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"179":{"tf":1.0},"180":{"tf":2.0},"181":{"tf":1.0},"182":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"110":{"tf":1.0},"18":{"tf":2.0},"180":{"tf":1.7320508075688772},"182":{"tf":1.0}}}}}}}},"df":2,"docs":{"28":{"tf":1.4142135623730951},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.7320508075688772},"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}},"t":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"a":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"50":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":3.605551275463989},"98":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"110":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.0},"168":{"tf":1.0},"54":{"tf":1.4142135623730951},"63":{"tf":1.0},"75":{"tf":1.0}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":4,"docs":{"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":8,"docs":{"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"37":{"tf":1.0},"39":{"tf":2.6457513110645907},"52":{"tf":2.0},"54":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":15,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.7320508075688772},"181":{"tf":1.0},"54":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"2":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"60":{"tf":1.7320508075688772},"72":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"158":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"32":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"154":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":107,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":3.1622776601683795},"10":{"tf":3.7416573867739413},"101":{"tf":2.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":3.0},"106":{"tf":2.0},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.23606797749979},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":2.8284271247461903},"120":{"tf":1.0},"121":{"tf":2.6457513110645907},"122":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.4142135623730951},"139":{"tf":1.0},"14":{"tf":2.23606797749979},"140":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"15":{"tf":2.0},"152":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":2.0},"156":{"tf":1.0},"158":{"tf":2.23606797749979},"159":{"tf":1.7320508075688772},"16":{"tf":2.8284271247461903},"160":{"tf":1.0},"162":{"tf":2.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"17":{"tf":3.1622776601683795},"171":{"tf":1.4142135623730951},"172":{"tf":1.7320508075688772},"173":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"177":{"tf":1.7320508075688772},"178":{"tf":1.0},"18":{"tf":2.23606797749979},"180":{"tf":1.7320508075688772},"181":{"tf":2.23606797749979},"182":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":3.1622776601683795},"20":{"tf":1.4142135623730951},"21":{"tf":2.8284271247461903},"22":{"tf":2.23606797749979},"23":{"tf":2.23606797749979},"26":{"tf":1.0},"3":{"tf":2.23606797749979},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":2.23606797749979},"47":{"tf":1.0},"5":{"tf":4.242640687119285},"51":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":3.7416573867739413},"62":{"tf":1.0},"63":{"tf":2.23606797749979},"64":{"tf":2.449489742783178},"65":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":2.8284271247461903},"8":{"tf":2.6457513110645907},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.23606797749979},"9":{"tf":3.1622776601683795},"90":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":2.449489742783178},"96":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"8":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"2":{"4":{"df":2,"docs":{"10":{"tf":1.0},"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"2":{"0":{"2":{"4":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"159":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.4142135623730951},"31":{"tf":1.0}}}}}}},"df":3,"docs":{"162":{"tf":1.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"146":{"tf":1.0},"32":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"64":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"82":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}},"m":{"b":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"132":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":17,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.7320508075688772},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"20":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":2.23606797749979},"60":{"tf":2.0},"89":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"138":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":3,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"142":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"64":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"120":{"tf":1.0},"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":16,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"133":{"tf":1.0},"142":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.7320508075688772},"18":{"tf":1.0},"22":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":11,"docs":{"118":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"181":{"tf":1.0},"30":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"137":{"tf":1.0},"139":{"tf":1.0},"147":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"110":{"tf":1.0},"112":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"12":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"3":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":26,"docs":{"105":{"tf":1.0},"120":{"tf":1.4142135623730951},"132":{"tf":2.23606797749979},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":2.449489742783178},"166":{"tf":2.0},"17":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"74":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"166":{"tf":1.0},"180":{"tf":1.0},"7":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"111":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"18":{"tf":1.0},"32":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"i":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"124":{"tf":1.0},"32":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":48,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"105":{"tf":2.23606797749979},"106":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.4142135623730951},"126":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"142":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.4142135623730951},"158":{"tf":1.0},"16":{"tf":1.4142135623730951},"168":{"tf":1.0},"17":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":3.1622776601683795},"19":{"tf":1.0},"20":{"tf":2.0},"21":{"tf":1.0},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":2.6457513110645907},"6":{"tf":1.0},"60":{"tf":1.7320508075688772},"64":{"tf":1.0},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"98":{"tf":2.23606797749979}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"50":{"tf":1.0},"79":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.0}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":21,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"126":{"tf":1.0},"138":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"180":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"7":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"17":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"163":{"tf":1.0},"180":{"tf":1.0},"75":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"120":{"tf":1.0},"39":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"138":{"tf":1.0},"21":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":12,"docs":{"1":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":1.0},"168":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"57":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"174":{"tf":1.0},"176":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":1,"docs":{"28":{"tf":1.0}}}},"s":{"df":1,"docs":{"137":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"r":{"_":{"2":{"0":{"2":{"1":{"df":3,"docs":{"157":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.7320508075688772},"162":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"157":{"tf":1.0},"158":{"tf":2.449489742783178},"159":{"tf":1.0},"168":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"85":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":12,"docs":{"169":{"tf":1.7320508075688772},"17":{"tf":1.0},"170":{"tf":1.4142135623730951},"171":{"tf":3.0},"172":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.7416573867739413},"29":{"tf":1.7320508075688772},"30":{"tf":2.6457513110645907},"32":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"163":{"tf":1.0},"180":{"tf":1.0}}}}}}}},"f":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}},")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"6":{"4":{"df":1,"docs":{"171":{"tf":1.7320508075688772}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"126":{"tf":1.4142135623730951},"127":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"_":{"2":{"0":{"2":{"1":{"(":{"_":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}},"4":{"(":{"_":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"_":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}},"u":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"_":{"df":2,"docs":{"121":{"tf":1.0},"124":{"tf":1.0}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}},"u":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"132":{"tf":1.0}}},"t":{"df":2,"docs":{"120":{"tf":1.0},"127":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"21":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"64":{"tf":1.0},"80":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"164":{"tf":1.7320508075688772},"165":{"tf":1.0},"166":{"tf":2.8284271247461903},"167":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"165":{"tf":1.0}}},"s":{"df":5,"docs":{"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":2.23606797749979},"147":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":4,"docs":{"168":{"tf":2.8284271247461903},"28":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"79":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":32,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":2.6457513110645907},"13":{"tf":2.449489742783178},"135":{"tf":1.7320508075688772},"136":{"tf":1.4142135623730951},"137":{"tf":3.3166247903554},"138":{"tf":2.449489742783178},"139":{"tf":1.7320508075688772},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.7320508075688772},"145":{"tf":2.0},"146":{"tf":3.4641016151377544},"147":{"tf":2.0},"148":{"tf":1.0},"181":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":2.449489742783178},"59":{"tf":5.0990195135927845},"60":{"tf":4.898979485566356},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"2":{"0":{"2":{"4":{"df":2,"docs":{"128":{"tf":1.0},"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"166":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"120":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":4,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"58":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"70":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"10":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}},"n":{"d":{"df":9,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"4":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"133":{"tf":1.0},"158":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"x":{"df":39,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":3.0},"126":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"134":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":3.1622776601683795},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":2.449489742783178},"168":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":3.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"126":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.7320508075688772},"60":{"tf":2.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.0}}}}},"n":{"df":35,"docs":{"101":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"120":{"tf":2.23606797749979},"121":{"tf":2.449489742783178},"122":{"tf":1.4142135623730951},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"127":{"tf":2.0},"128":{"tf":2.449489742783178},"129":{"tf":2.23606797749979},"155":{"tf":2.0},"158":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.7320508075688772},"168":{"tf":2.449489742783178},"171":{"tf":2.0},"175":{"tf":1.0},"176":{"tf":1.7320508075688772},"180":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.0},"32":{"tf":2.449489742783178},"35":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"53":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":24,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"128":{"tf":1.0},"146":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}},"o":{"!":{"(":{"$":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"162":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"35":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"31":{"tf":2.23606797749979}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"29":{"tf":1.0},"32":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"139":{"tf":1.4142135623730951},"146":{"tf":1.0},"16":{"tf":2.0},"162":{"tf":1.4142135623730951},"176":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"5":{"tf":2.8284271247461903},"60":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"r":{"<":{"'":{"a":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":5,"docs":{"181":{"tf":1.0},"20":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"177":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":4,"docs":{"143":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"64":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":17,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"2":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"156":{"tf":1.7320508075688772},"157":{"tf":1.7320508075688772},"158":{"tf":2.23606797749979},"159":{"tf":1.0},"160":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":2.0},"163":{"tf":1.0},"89":{"tf":2.23606797749979},"90":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":1,"docs":{"171":{"tf":1.0}}}},"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":2,"docs":{"64":{"tf":1.0},"76":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"x":{"df":1,"docs":{"52":{"tf":1.0}}}},"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"16":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"32":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":24,"docs":{"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"109":{"tf":2.0},"110":{"tf":2.0},"111":{"tf":2.0},"112":{"tf":2.6457513110645907},"114":{"tf":1.0},"115":{"tf":2.23606797749979},"121":{"tf":1.7320508075688772},"127":{"tf":1.0},"155":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.0},"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"51":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"132":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.0},"147":{"tf":1.0},"154":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"28":{"tf":1.7320508075688772},"32":{"tf":1.0},"47":{"tf":1.0},"79":{"tf":2.0},"97":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"152":{"tf":1.7320508075688772},"153":{"tf":1.4142135623730951},"154":{"tf":2.23606797749979},"155":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"118":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.23606797749979},"122":{"tf":2.23606797749979},"123":{"tf":1.0},"124":{"tf":2.0},"127":{"tf":1.4142135623730951},"137":{"tf":1.0},"16":{"tf":1.4142135623730951},"168":{"tf":1.0},"19":{"tf":2.23606797749979},"28":{"tf":1.0},"93":{"tf":1.0}}}}},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"166":{"tf":1.0},"17":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}},"n":{"df":10,"docs":{"127":{"tf":1.4142135623730951},"182":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":7,"docs":{"132":{"tf":1.0},"133":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":6,"docs":{"143":{"tf":1.0},"15":{"tf":1.0},"26":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.0},"95":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.4142135623730951}},"i":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"133":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":12,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.4142135623730951},"126":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"20":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":2.0},"8":{"tf":1.0},"95":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"70":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}},"l":{"df":2,"docs":{"110":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"112":{"tf":1.0},"15":{"tf":1.4142135623730951},"158":{"tf":1.0},"28":{"tf":1.0},"89":{"tf":1.0}}}}}},"r":{"d":{"df":5,"docs":{"147":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":2.23606797749979},"43":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"105":{"tf":1.0},"14":{"tf":1.0},"31":{"tf":1.0},"79":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"p":{"df":16,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"15":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"n":{"c":{"df":18,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":12,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"127":{"tf":1.0},"158":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"80":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"104":{"tf":1.0},"120":{"tf":1.7320508075688772},"127":{"tf":1.0},"129":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":2.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"166":{"tf":1.0},"59":{"tf":1.0},"75":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"147":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}}}}},"i":{".":{"df":7,"docs":{"104":{"tf":1.0},"124":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"3":{"2":{"df":5,"docs":{"132":{"tf":1.4142135623730951},"39":{"tf":1.0},"7":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"15":{"tf":1.0},"20":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"15":{"tf":1.0},"50":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":7,"docs":{"155":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"3":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":1,"docs":{"21":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"147":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.0},"52":{"tf":1.0}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":14,"docs":{"120":{"tf":2.449489742783178},"121":{"tf":2.6457513110645907},"122":{"tf":1.7320508075688772},"123":{"tf":2.6457513110645907},"124":{"tf":2.449489742783178},"126":{"tf":1.4142135623730951},"127":{"tf":2.449489742783178},"128":{"tf":1.7320508075688772},"129":{"tf":1.7320508075688772},"168":{"tf":2.0},"39":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":21,"docs":{"10":{"tf":2.0},"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"168":{"tf":1.7320508075688772},"180":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":2.8284271247461903},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":3.0},"74":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"120":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.7320508075688772},"136":{"tf":1.0},"137":{"tf":2.0},"138":{"tf":1.0},"139":{"tf":1.4142135623730951},"75":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"118":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"166":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.0}}}}}}},"df":3,"docs":{"2":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":11,"docs":{"102":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":2.8284271247461903},"30":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"54":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"179":{"tf":1.0},"180":{"tf":1.0},"60":{"tf":1.0}}}}}}},"n":{"a":{"d":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"142":{"tf":1.0},"146":{"tf":1.0}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":21,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"139":{"tf":1.0},"159":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"60":{"tf":1.0},"85":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"138":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"180":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"158":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"129":{"tf":1.0},"180":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":4,"docs":{"15":{"tf":1.0},"162":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.7320508075688772}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"171":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"166":{"tf":2.23606797749979},"168":{"tf":2.23606797749979},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":3,"docs":{"23":{"tf":1.0},"47":{"tf":1.0},"95":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.0},"107":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"96":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"121":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":2.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"144":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772},"147":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"126":{"tf":1.0},"166":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"115":{"tf":1.0},"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"46":{"tf":1.7320508075688772}}},"n":{"c":{"df":4,"docs":{"1":{"tf":1.0},"29":{"tf":1.4142135623730951},"53":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":16,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":2.449489742783178},"159":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.0},"31":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"115":{"tf":1.0},"127":{"tf":1.0},"171":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"146":{"tf":1.0},"167":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"133":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"n":{"df":6,"docs":{"137":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"93":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"93":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":2.6457513110645907},"106":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"[":{"1":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":9,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":11,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"117":{"tf":1.4142135623730951},"123":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"54":{"tf":1.0},"8":{"tf":1.0}},"t":{"df":4,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"o":{"c":{"df":3,"docs":{"5":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"52":{"tf":1.0},"75":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"127":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"137":{"tf":1.0},"176":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":24,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"15":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":1.0},"21":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"t":{"'":{"df":19,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"166":{"tf":1.0},"182":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"63":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":8,"docs":{"171":{"tf":1.4142135623730951},"176":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"95":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"[":{"1":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":6,"docs":{"105":{"tf":2.449489742783178},"106":{"tf":1.0},"12":{"tf":1.0},"154":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"59":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"k":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"15":{"tf":1.0},"159":{"tf":1.0},"28":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"166":{"tf":1.0},"168":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":6,"docs":{"140":{"tf":1.7320508075688772},"141":{"tf":1.4142135623730951},"142":{"tf":2.0},"143":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":22,"docs":{"1":{"tf":2.0},"115":{"tf":1.0},"15":{"tf":1.4142135623730951},"152":{"tf":1.7320508075688772},"153":{"tf":1.4142135623730951},"154":{"tf":1.7320508075688772},"155":{"tf":2.0},"17":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.7320508075688772},"172":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":2.23606797749979},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"154":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}},"n":{"df":3,"docs":{"166":{"tf":1.0},"21":{"tf":1.0},"75":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"1":{"2":{"1":{"0":{"4":{"2":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"7":{"4":{"2":{"df":1,"docs":{"156":{"tf":1.0}}},"3":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}},"5":{"7":{"df":1,"docs":{"173":{"tf":1.0}}},"8":{"df":1,"docs":{"130":{"tf":1.0}}},"9":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"4":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"8":{"5":{"3":{"df":1,"docs":{"178":{"tf":1.0}}},"df":0,"docs":{}},"6":{"6":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"4":{"3":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"1":{"1":{"4":{"7":{"6":{"4":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"181":{"tf":1.0},"21":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":6,"docs":{"14":{"tf":1.7320508075688772},"180":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":1.0},"60":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}},"r":{"df":6,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"166":{"tf":1.0},"76":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"166":{"tf":1.0},"167":{"tf":1.0},"30":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"180":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"1":{"0":{"0":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"t":{"'":{"df":7,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":4,"docs":{"58":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"131":{"tf":1.0},"167":{"tf":1.0},"32":{"tf":1.4142135623730951},"57":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"c":{"df":2,"docs":{"171":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"171":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"102":{"tf":1.4142135623730951},"109":{"tf":1.0},"110":{"tf":1.0},"176":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"28":{"tf":1.0},"50":{"tf":1.4142135623730951},"53":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"z":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":13,"docs":{"117":{"tf":2.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":2.23606797749979},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.0},"127":{"tf":2.449489742783178},"128":{"tf":1.4142135623730951},"129":{"tf":2.0}}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"181":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"64":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"s":{"\\":{"0":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"174":{"tf":1.0},"176":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":4,"docs":{"167":{"tf":1.0},"176":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.0}}},"t":{"df":38,"docs":{"101":{"tf":2.0},"106":{"tf":2.23606797749979},"112":{"tf":2.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"12":{"tf":2.449489742783178},"126":{"tf":2.23606797749979},"127":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.7320508075688772},"15":{"tf":2.23606797749979},"155":{"tf":2.0},"159":{"tf":2.23606797749979},"161":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":2.0},"165":{"tf":1.0},"167":{"tf":1.4142135623730951},"172":{"tf":2.0},"177":{"tf":2.0},"20":{"tf":2.0},"21":{"tf":1.7320508075688772},"43":{"tf":1.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"143":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"79":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":2.0},"94":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"133":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"181":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"120":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"1":{"tf":1.0},"128":{"tf":1.0},"137":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"16":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"46":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"80":{"tf":1.0},"85":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":11,"docs":{"120":{"tf":1.0},"17":{"tf":1.4142135623730951},"171":{"tf":1.0},"175":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}},"p":{"df":2,"docs":{"105":{"tf":1.0},"176":{"tf":1.0}}}},"t":{"df":2,"docs":{"14":{"tf":1.0},"50":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"16":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":8,"docs":{"158":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"17":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":29,"docs":{"102":{"tf":1.0},"141":{"tf":1.0},"156":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":2.0},"16":{"tf":3.7416573867739413},"160":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":2.0},"163":{"tf":2.0},"17":{"tf":3.1622776601683795},"181":{"tf":1.0},"28":{"tf":2.0},"59":{"tf":2.449489742783178},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":2.6457513110645907},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":2.8284271247461903},"90":{"tf":2.23606797749979},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"127":{"tf":1.0},"15":{"tf":1.0},"159":{"tf":1.0},"22":{"tf":1.4142135623730951},"64":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"158":{"tf":1.0},"162":{"tf":1.0},"176":{"tf":1.0},"28":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":30,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"112":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"121":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"143":{"tf":1.0},"154":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"171":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"32":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"112":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"176":{"tf":1.0}}}},"i":{"df":5,"docs":{"20":{"tf":1.0},"26":{"tf":1.0},"53":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":32,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"112":{"tf":2.0},"116":{"tf":1.4142135623730951},"12":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"172":{"tf":1.7320508075688772},"177":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"3":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":13,"docs":{"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"162":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":2.0},"174":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"95":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"158":{"tf":2.6457513110645907},"159":{"tf":1.0},"162":{"tf":1.0},"32":{"tf":1.7320508075688772},"59":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":2.0},"90":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}},"s":{"!":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":9,"docs":{"104":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.7320508075688772},"89":{"tf":1.0},"90":{"tf":1.0}},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"112":{"tf":1.0},"23":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"146":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"127":{"tf":1.0},"72":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"132":{"tf":1.0}}},"g":{"df":1,"docs":{"57":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"20":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":19,"docs":{"101":{"tf":2.8284271247461903},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"35":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":4.123105625617661},"53":{"tf":2.449489742783178},"54":{"tf":3.4641016151377544},"59":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":64,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"106":{"tf":2.0},"11":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":2.23606797749979},"116":{"tf":2.0},"117":{"tf":1.0},"12":{"tf":2.8284271247461903},"120":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":2.0},"127":{"tf":1.4142135623730951},"128":{"tf":2.0},"129":{"tf":2.0},"13":{"tf":2.449489742783178},"134":{"tf":1.7320508075688772},"139":{"tf":1.4142135623730951},"14":{"tf":3.0},"143":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"15":{"tf":2.0},"151":{"tf":1.4142135623730951},"155":{"tf":2.0},"159":{"tf":2.23606797749979},"16":{"tf":2.23606797749979},"163":{"tf":2.0},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"172":{"tf":2.449489742783178},"177":{"tf":2.449489742783178},"18":{"tf":1.0},"182":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.449489742783178},"21":{"tf":1.0},"3":{"tf":2.449489742783178},"4":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.6457513110645907},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"69":{"tf":2.8284271247461903},"7":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":2.6457513110645907},"86":{"tf":2.0},"90":{"tf":1.7320508075688772},"94":{"tf":2.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"63":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"160":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":2.0},"163":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"31":{"tf":2.23606797749979}}}},"df":5,"docs":{"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":2.0},"52":{"tf":1.0}},"e":{"df":1,"docs":{"180":{"tf":1.0}},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":7,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.0},"155":{"tf":1.4142135623730951},"20":{"tf":1.0},"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":12,"docs":{"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":2.23606797749979},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":2.0},"31":{"tf":1.7320508075688772},"32":{"tf":2.0},"50":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":38,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"78":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":6,"docs":{"115":{"tf":1.0},"138":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"68":{"tf":1.0},"95":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.0}}}},"<":{"df":0,"docs":{},"t":{">":{"(":{"_":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":5,"docs":{"13":{"tf":1.0},"32":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"162":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"110":{"tf":1.0},"32":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"146":{"tf":1.0},"16":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"131":{"tf":1.0},"132":{"tf":2.6457513110645907},"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":10,"docs":{"130":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"132":{"tf":2.449489742783178},"133":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"171":{"tf":1.0},"39":{"tf":1.4142135623730951},"54":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"105":{"tf":2.0},"106":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"!":{"(":{"1":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{},"z":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"80":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"101":{"tf":1.7320508075688772},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"!":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":2.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"(":{")":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"52":{"tf":2.23606797749979},"84":{"tf":2.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":34,"docs":{"101":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"127":{"tf":2.0},"137":{"tf":2.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.7320508075688772},"141":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"146":{"tf":1.0},"155":{"tf":1.4142135623730951},"162":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"132":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"139":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":38,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.4142135623730951},"116":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"155":{"tf":1.0},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"182":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":3.0},"39":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"123":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":2,"docs":{"165":{"tf":1.0},"167":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"132":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":2.0},"166":{"tf":1.7320508075688772},"167":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}},"w":{"df":39,"docs":{"1":{"tf":2.0},"10":{"tf":2.23606797749979},"105":{"tf":1.0},"12":{"tf":1.4142135623730951},"143":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":2.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":3.1622776601683795},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"6":{"tf":2.0},"60":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":3.1622776601683795},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"158":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"12":{"tf":2.0},"154":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"6":{"tf":2.0},"79":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":2.6457513110645907},"28":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"174":{"tf":1.0},"176":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":4,"docs":{"20":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"105":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"176":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"105":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"132":{"tf":1.0},"181":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"105":{"tf":1.0},"142":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":54,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"136":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"154":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"17":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":2.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"180":{"tf":1.7320508075688772},"181":{"tf":1.0},"23":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.0}}}}},"df":1,"docs":{"132":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"132":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"39":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":5,"docs":{"120":{"tf":1.4142135623730951},"168":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":2.0}}},"l":{"d":{"df":7,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"158":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"181":{"tf":1.0},"28":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0}}}}},"n":{"c":{"df":5,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0},"9":{"tf":1.0}}},"df":26,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.7320508075688772},"142":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"15":{"tf":1.0},"168":{"tf":1.4142135623730951},"182":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.7320508075688772}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":7,"docs":{"117":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":1.7320508075688772},"123":{"tf":1.0},"126":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0}}}}},"df":1,"docs":{"70":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"31":{"tf":1.0},"47":{"tf":1.0}}},"r":{"df":5,"docs":{"114":{"tf":1.0},"115":{"tf":2.0},"132":{"tf":1.0},"133":{"tf":1.0},"168":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}},"t":{"df":3,"docs":{"1":{"tf":1.0},"57":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"a":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":15,"docs":{"13":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":2.0},"138":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"116":{"tf":1.0},"129":{"tf":1.0},"142":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"172":{"tf":1.0},"177":{"tf":1.0},"51":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"110":{"tf":1.0},"12":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"54":{"tf":1.0},"72":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"159":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"21":{"tf":1.0},"39":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"122":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}},"v":{"df":3,"docs":{"118":{"tf":1.0},"129":{"tf":2.23606797749979},"21":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"155":{"tf":1.0}}}}},"df":12,"docs":{"105":{"tf":2.23606797749979},"109":{"tf":1.0},"142":{"tf":1.0},"168":{"tf":1.0},"21":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"98":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"180":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"155":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":2.0},"141":{"tf":1.0},"146":{"tf":1.7320508075688772},"46":{"tf":1.0},"5":{"tf":2.23606797749979},"57":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"9":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}},"1":{"2":{"3":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}},"df":6,"docs":{"166":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979},"75":{"tf":4.0},"76":{"tf":2.6457513110645907}},"k":{"df":2,"docs":{"168":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":13,"docs":{"118":{"tf":1.4142135623730951},"120":{"tf":2.0},"121":{"tf":2.23606797749979},"122":{"tf":2.0},"123":{"tf":1.0},"124":{"tf":2.0},"126":{"tf":1.0},"127":{"tf":2.23606797749979},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"t":{"df":21,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"126":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"15":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"112":{"tf":1.0},"137":{"tf":1.0},"167":{"tf":1.0},"22":{"tf":1.0},"32":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":1.0},"132":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"166":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":1,"docs":{"89":{"tf":2.0}},"h":{"df":13,"docs":{"181":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":2.449489742783178},"26":{"tf":2.23606797749979},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"32":{"tf":3.3166247903554},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"162":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":2.6457513110645907},"90":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"60":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"26":{"tf":1.0}}}}},"r":{"df":1,"docs":{"89":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"115":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"3":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"<":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":12,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"146":{"tf":1.0},"155":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"180":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"110":{"tf":1.0},"13":{"tf":1.0},"176":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"133":{"tf":1.7320508075688772},"171":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"72":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"101":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"101":{"tf":1.7320508075688772},"98":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"124":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"127":{"tf":1.0},"133":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"180":{"tf":1.0},"181":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"117":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"139":{"tf":1.0},"143":{"tf":1.4142135623730951},"147":{"tf":1.0},"39":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"#":{"1":{"2":{"3":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"79":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"'":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"155":{"tf":1.0},"29":{"tf":1.4142135623730951},"79":{"tf":2.8284271247461903},"80":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":15,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"28":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772},"98":{"tf":2.449489742783178},"99":{"tf":2.0}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"121":{"tf":2.6457513110645907},"122":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"126":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"166":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":12,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"137":{"tf":1.0},"147":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"22":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0}},"s":{"df":7,"docs":{"105":{"tf":1.0},"141":{"tf":1.0},"168":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"58":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"176":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"158":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"a":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"128":{"tf":1.0},"129":{"tf":1.0},"180":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":2,"docs":{"54":{"tf":2.0},"95":{"tf":1.4142135623730951}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":11,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"14":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"6":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"141":{"tf":1.0},"28":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"141":{"tf":1.0},"16":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":2.449489742783178},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"110":{"tf":1.0},"14":{"tf":1.4142135623730951},"180":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"75":{"tf":1.4142135623730951},"8":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"75":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"110":{"tf":1.0},"21":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":19,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.7320508075688772},"141":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"5":{"tf":2.8284271247461903},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":2.0},"60":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772},"95":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":5,"docs":{"171":{"tf":1.0},"175":{"tf":1.0},"23":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"111":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}},"u":{"b":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":10,"docs":{"128":{"tf":1.0},"171":{"tf":2.0},"175":{"tf":1.0},"180":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"x":{".":{"0":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"101":{"tf":1.0}},"i":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.0},"60":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"r":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"155":{"tf":2.0}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"167":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"142":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.7320508075688772}}},"k":{"df":1,"docs":{"123":{"tf":2.0}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"163":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"75":{"tf":1.0}}}},"w":{"df":9,"docs":{"133":{"tf":2.0},"155":{"tf":1.0},"3":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"df":3,"docs":{"155":{"tf":1.0},"168":{"tf":1.4142135623730951},"79":{"tf":1.0}},"e":{"a":{"d":{"df":7,"docs":{"132":{"tf":1.0},"138":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":3,"docs":{"64":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"132":{"tf":1.0},"133":{"tf":1.7320508075688772},"138":{"tf":1.0},"146":{"tf":1.0},"166":{"tf":1.0},"22":{"tf":1.0},"50":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"102":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"133":{"tf":1.0},"180":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"28":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"f":{"df":1,"docs":{"132":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":23,"docs":{"101":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"132":{"tf":3.3166247903554},"133":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"137":{"tf":1.0},"146":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":2.6457513110645907},"30":{"tf":1.4142135623730951},"4":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"54":{"tf":2.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"68":{"tf":2.0},"70":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"72":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":4,"docs":{"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"133":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":3,"docs":{"168":{"tf":1.0},"180":{"tf":1.0},"32":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":32,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"28":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.4142135623730951},"95":{"tf":3.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"78":{"tf":1.0},"89":{"tf":1.0}}}},"i":{"df":1,"docs":{"90":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"21":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"166":{"tf":1.0},"17":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":15,"docs":{"118":{"tf":1.0},"135":{"tf":1.7320508075688772},"136":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"141":{"tf":2.6457513110645907},"147":{"tf":1.4142135623730951},"163":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"69":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"111":{"tf":1.0},"118":{"tf":1.0},"128":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":30,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"171":{"tf":1.7320508075688772},"175":{"tf":2.0},"176":{"tf":2.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"63":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":10,"docs":{"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":2.0},"80":{"tf":1.0},"94":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"v":{"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":2.8284271247461903},"58":{"tf":2.23606797749979},"59":{"tf":2.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":5,"docs":{"112":{"tf":1.0},"115":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"59":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"129":{"tf":1.0},"16":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"168":{"tf":2.0}}},"u":{"3":{"2":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":7,"docs":{"171":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"2":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"106":{"tf":1.0},"158":{"tf":1.0},"182":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"105":{"tf":1.7320508075688772},"120":{"tf":1.0},"168":{"tf":2.8284271247461903}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"112":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"51":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"182":{"tf":1.0}}}}}}}}}},"f":{"c":{"df":11,"docs":{"115":{"tf":1.0},"117":{"tf":1.4142135623730951},"154":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.0},"47":{"tf":1.0},"68":{"tf":1.4142135623730951},"79":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"162":{"tf":1.0},"180":{"tf":2.0},"70":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.0}}},"t":{"df":11,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"124":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":13,"docs":{"117":{"tf":1.7320508075688772},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":26,"docs":{"1":{"tf":1.0},"117":{"tf":2.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"158":{"tf":2.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"n":{"<":{"df":0,"docs":{},"r":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":36,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"116":{"tf":1.0},"12":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.7320508075688772},"155":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.0},"168":{"tf":1.4142135623730951},"172":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"21":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":4,"docs":{"0":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"75":{"tf":1.0}}},"_":{"2":{"0":{"2":{"1":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"80":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"4":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.0},"28":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"102":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":1,"docs":{"180":{"tf":1.0}}},"df":6,"docs":{"178":{"tf":1.7320508075688772},"179":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":2.23606797749979},"182":{"tf":1.0}}},"df":0,"docs":{}}},"df":175,"docs":{"0":{"tf":1.0},"1":{"tf":2.6457513110645907},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":2.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"106":{"tf":1.7320508075688772},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.23606797749979},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.449489742783178},"127":{"tf":1.4142135623730951},"128":{"tf":2.0},"129":{"tf":2.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"155":{"tf":2.0},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.7320508075688772},"163":{"tf":2.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.7320508075688772},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":1.0},"177":{"tf":1.7320508075688772},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":3.605551275463989},"23":{"tf":2.23606797749979},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":2.23606797749979},"32":{"tf":3.1622776601683795},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"51":{"tf":2.0},"52":{"tf":2.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":2.449489742783178},"64":{"tf":3.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.23606797749979},"69":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":3.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":2.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.449489742783178},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.449489742783178},"9":{"tf":2.0},"90":{"tf":2.449489742783178},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":3.1622776601683795},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"20":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"df":4,"docs":{"148":{"tf":1.7320508075688772},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"s":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":5,"docs":{"110":{"tf":1.0},"171":{"tf":2.23606797749979},"176":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":7,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"133":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.7320508075688772}}}}}},"m":{"df":0,"docs":{},"e":{"df":20,"docs":{"101":{"tf":1.4142135623730951},"111":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":1.0},"146":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"59":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"111":{"tf":1.0},"112":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"127":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"158":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":11,"docs":{"101":{"tf":1.4142135623730951},"118":{"tf":1.0},"121":{"tf":2.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"52":{"tf":2.6457513110645907},"71":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"79":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"115":{"tf":1.0},"158":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":24,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"6":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":24,"docs":{"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"129":{"tf":1.0},"15":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"171":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":2.0},"68":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0}},"k":{"df":1,"docs":{"8":{"tf":1.0}}},"m":{"df":3,"docs":{"26":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.0}}},"n":{"df":1,"docs":{"168":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"166":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"25":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":2.23606797749979}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"126":{"tf":1.0},"3":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"n":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"72":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":2,"docs":{"67":{"tf":1.0},"72":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"15":{"tf":1.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"79":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"93":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"102":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"df":10,"docs":{"12":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.7320508075688772},"176":{"tf":1.0},"18":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"141":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0},"64":{"tf":1.0},"76":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"63":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"131":{"tf":1.0},"132":{"tf":2.23606797749979},"53":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"181":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"39":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"w":{"df":1,"docs":{"60":{"tf":2.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"121":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"172":{"tf":1.0}}}}}},"df":1,"docs":{"93":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"180":{"tf":1.0},"26":{"tf":1.0}}}}}}},"df":2,"docs":{"179":{"tf":1.0},"180":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"106":{"tf":1.0},"116":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.0},"13":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"180":{"tf":1.0},"26":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":7,"docs":{"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":9,"docs":{"112":{"tf":1.0},"13":{"tf":1.0},"142":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.0},"75":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"166":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"132":{"tf":1.0},"133":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.0},"181":{"tf":2.0},"19":{"tf":1.0},"28":{"tf":1.0},"51":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"d":{">":{"(":{"_":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"120":{"tf":2.23606797749979},"121":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":2.449489742783178},"128":{"tf":2.449489742783178},"129":{"tf":1.7320508075688772}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"104":{"tf":1.0},"105":{"tf":2.449489742783178},"106":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"115":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":1.0}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"147":{"tf":1.0},"166":{"tf":1.0},"28":{"tf":1.0},"58":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":4,"docs":{"15":{"tf":1.0},"158":{"tf":1.4142135623730951},"16":{"tf":1.0},"39":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"166":{"tf":1.0},"175":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":4,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"127":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":12,"docs":{"111":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"127":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.4142135623730951},"79":{"tf":1.0}},"i":{"df":24,"docs":{"120":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"146":{"tf":2.449489742783178},"147":{"tf":1.0},"156":{"tf":1.7320508075688772},"157":{"tf":1.7320508075688772},"158":{"tf":2.449489742783178},"159":{"tf":2.0},"160":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":2.23606797749979},"163":{"tf":1.0},"168":{"tf":2.23606797749979},"171":{"tf":1.0},"22":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"168":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":1,"docs":{"171":{"tf":1.0}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"154":{"tf":1.0},"166":{"tf":1.0},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"l":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"40":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"181":{"tf":2.23606797749979},"182":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":8,"docs":{"102":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"28":{"tf":1.0},"50":{"tf":1.4142135623730951},"53":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":19,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"121":{"tf":1.0},"162":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":2.0},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"180":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"70":{"tf":1.0}}}}}}},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"131":{"tf":1.0},"132":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":10,"docs":{"120":{"tf":1.4142135623730951},"127":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"132":{"tf":3.3166247903554},"133":{"tf":1.7320508075688772},"134":{"tf":1.4142135623730951},"171":{"tf":1.0},"180":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"10":{"tf":1.0}}}},"y":{"df":1,"docs":{"12":{"tf":1.0}}}},"d":{"'":{"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"108":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"108":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.0},"98":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"108":{"tf":1.0},"111":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"101":{"tf":1.0},"28":{"tf":1.7320508075688772},"52":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":6,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":42,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"111":{"tf":1.0},"37":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":8,"docs":{"74":{"tf":1.4142135623730951},"75":{"tf":2.6457513110645907},"76":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":3.1622776601683795},"94":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"p":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":1,"docs":{"171":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"102":{"tf":1.0},"133":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"122":{"tf":1.0},"32":{"tf":1.7320508075688772},"50":{"tf":1.0},"53":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"98":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"142":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":2.23606797749979},"32":{"tf":2.0},"52":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"78":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":4,"docs":{"50":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"180":{"tf":1.0}}}}}}},"df":1,"docs":{"180":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":18,"docs":{"126":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"166":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"15":{"tf":1.7320508075688772},"182":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":32,"docs":{"104":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"149":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"32":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":15,"docs":{"1":{"tf":1.0},"123":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.7320508075688772},"57":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"112":{"tf":1.0},"143":{"tf":1.4142135623730951},"146":{"tf":1.0},"16":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"90":{"tf":1.0},"98":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"129":{"tf":1.0},"75":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"68":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"116":{"tf":1.0},"58":{"tf":1.0},"75":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"58":{"tf":1.0}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"176":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":28,"docs":{"101":{"tf":1.4142135623730951},"104":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"137":{"tf":1.0},"158":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"80":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":13,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":2.23606797749979},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"t":{".":{"0":{"df":1,"docs":{"71":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"120":{"tf":1.0},"128":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"31":{"tf":1.0}},"l":{"df":8,"docs":{"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.7320508075688772},"141":{"tf":1.4142135623730951},"142":{"tf":2.0},"143":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"17":{"tf":1.0},"181":{"tf":2.6457513110645907},"182":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.6457513110645907},"60":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951}},"n":{"df":2,"docs":{"176":{"tf":1.0},"30":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":2.449489742783178},"46":{"tf":2.0},"59":{"tf":1.4142135623730951}}}}}}},"df":10,"docs":{"101":{"tf":1.0},"105":{"tf":1.4142135623730951},"115":{"tf":2.0},"120":{"tf":2.23606797749979},"127":{"tf":1.4142135623730951},"128":{"tf":2.8284271247461903},"129":{"tf":3.1622776601683795},"166":{"tf":1.7320508075688772},"168":{"tf":2.0},"71":{"tf":3.4641016151377544}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"60":{"tf":2.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"137":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":14,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"178":{"tf":1.7320508075688772},"179":{"tf":1.0},"18":{"tf":2.449489742783178},"180":{"tf":2.23606797749979},"181":{"tf":2.23606797749979},"182":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"t":{"'":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"54":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"53":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"133":{"tf":1.0},"39":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"111":{"tf":1.0},"13":{"tf":1.0},"141":{"tf":1.0},"166":{"tf":1.0},"26":{"tf":1.4142135623730951},"67":{"tf":1.0},"95":{"tf":1.0}}},"k":{"df":1,"docs":{"168":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":21,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"146":{"tf":1.0},"158":{"tf":1.0},"17":{"tf":1.4142135623730951},"181":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"32":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"111":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"110":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"50":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"1":{"tf":1.0},"133":{"tf":1.0},"143":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"52":{"tf":1.0},"86":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"54":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"142":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}},"p":{"df":1,"docs":{"12":{"tf":1.0}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"21":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":2,"docs":{"112":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"94":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0}}}},"p":{"df":8,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951},"22":{"tf":1.0},"32":{"tf":1.4142135623730951},"57":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"r":{"<":{"'":{"_":{"df":1,"docs":{"123":{"tf":1.0}}},"a":{"df":1,"docs":{"123":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"41":{"tf":1.0},"50":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":27,"docs":{"101":{"tf":2.8284271247461903},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"128":{"tf":1.0},"168":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"39":{"tf":5.0990195135927845},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":4.242640687119285},"53":{"tf":1.7320508075688772},"54":{"tf":2.6457513110645907},"63":{"tf":2.449489742783178},"67":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":3.0},"8":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"59":{"tf":1.0},"60":{"tf":2.6457513110645907},"80":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"128":{"tf":2.6457513110645907},"129":{"tf":3.1622776601683795}},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":7,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":2.0},"5":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"12":{"tf":1.0},"132":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"168":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"137":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772}}}},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"52":{"tf":1.0},"54":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"124":{"tf":1.0},"127":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":5,"docs":{"166":{"tf":1.4142135623730951},"27":{"tf":1.0},"39":{"tf":1.0},"52":{"tf":1.0},"79":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":15,"docs":{"101":{"tf":1.0},"115":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"180":{"tf":1.7320508075688772},"28":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"69":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}},"y":{"df":2,"docs":{"123":{"tf":2.23606797749979},"138":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"127":{"tf":1.0}}},"df":23,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"117":{"tf":1.0},"120":{"tf":2.6457513110645907},"121":{"tf":2.0},"123":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":2.23606797749979},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"133":{"tf":1.0},"141":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":2.23606797749979},"166":{"tf":3.872983346207417},"167":{"tf":1.0},"168":{"tf":3.4641016151377544},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.0},"63":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"176":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"3":{"2":{">":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"180":{"tf":2.449489742783178}}},"df":0,"docs":{}},"8":{"df":6,"docs":{"132":{"tf":1.0},"166":{"tf":1.4142135623730951},"171":{"tf":1.0},"35":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"85":{"tf":1.0}}},"df":2,"docs":{"122":{"tf":1.0},"128":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"40":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"29":{"tf":1.0},"50":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"168":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"132":{"tf":1.0},"134":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0}}}}},"r":{"df":18,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"142":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"16":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"168":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"59":{"tf":1.0}},"i":{"df":3,"docs":{"146":{"tf":1.0},"32":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"176":{"tf":1.4142135623730951}}}},"t":{">":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"165":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":2.449489742783178}}},"x":{"df":2,"docs":{"111":{"tf":1.0},"176":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.0},"146":{"tf":1.0},"28":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"182":{"tf":1.0},"52":{"tf":1.0},"99":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"166":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":22,"docs":{"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"109":{"tf":2.449489742783178},"110":{"tf":1.0},"111":{"tf":2.0},"112":{"tf":2.0},"114":{"tf":1.7320508075688772},"115":{"tf":3.872983346207417},"116":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.7320508075688772},"170":{"tf":1.4142135623730951},"171":{"tf":3.605551275463989},"172":{"tf":1.7320508075688772},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":2.23606797749979},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.0}}}}}}}},"df":6,"docs":{"105":{"tf":1.0},"12":{"tf":1.0},"158":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":8,"docs":{"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":17,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"139":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"172":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"182":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":2.0}}}},"df":0,"docs":{}},"df":4,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"3":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"133":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"115":{"tf":1.0},"132":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"112":{"tf":1.0},"177":{"tf":1.0},"88":{"tf":1.0}}}},"df":81,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.4142135623730951},"104":{"tf":1.0},"112":{"tf":2.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"120":{"tf":2.6457513110645907},"121":{"tf":3.1622776601683795},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"126":{"tf":1.7320508075688772},"127":{"tf":2.8284271247461903},"128":{"tf":2.23606797749979},"129":{"tf":2.449489742783178},"13":{"tf":2.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"141":{"tf":2.449489742783178},"143":{"tf":1.7320508075688772},"146":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.7320508075688772},"159":{"tf":1.0},"16":{"tf":2.23606797749979},"163":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"171":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"181":{"tf":2.23606797749979},"20":{"tf":2.8284271247461903},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":4.123105625617661},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.0},"32":{"tf":3.872983346207417},"34":{"tf":1.0},"39":{"tf":2.0},"41":{"tf":1.0},"5":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":2.0},"60":{"tf":2.449489742783178},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.7320508075688772},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":2.23606797749979},"79":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"93":{"tf":2.23606797749979},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}},"e":{"<":{"'":{"_":{"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}}},"a":{"df":3,"docs":{"120":{"tf":1.4142135623730951},"123":{"tf":1.0},"128":{"tf":1.0}}},"df":0,"docs":{}},"_":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":3,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"127":{"tf":1.0}}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":1,"docs":{"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0}},"e":{">":{"(":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"28":{"tf":2.23606797749979},"58":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"{":{"0":{"0":{"df":0,"docs":{},"e":{"6":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"60":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}}},".":{"1":{".":{"3":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"2":{"df":1,"docs":{"95":{"tf":1.0}}},"3":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"32":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"16":{"tf":1.0},"171":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":11,"docs":{"105":{"tf":1.7320508075688772},"166":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":2.0},"8":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":13,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"155":{"tf":1.0},"162":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}}},"df":1,"docs":{"17":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"71":{"tf":2.0}}},"1":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951}}},"2":{"2":{"df":1,"docs":{"69":{"tf":1.0}}},"3":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"50":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"111":{"tf":1.0},"171":{"tf":1.0},"182":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":8,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"12":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"137":{"tf":1.0},"142":{"tf":1.4142135623730951},"146":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":2.0},"9":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"u":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":3,"docs":{"133":{"tf":1.0},"28":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"132":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.4142135623730951},"16":{"tf":1.0},"28":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"2":{"0":{"2":{"4":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"159":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"2":{"0":{"2":{"4":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"172":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"2":{"0":{"2":{"1":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":2,"docs":{"115":{"tf":1.0},"116":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":27,"docs":{"106":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":1.7320508075688772},"127":{"tf":1.0},"147":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"64":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"9":{"tf":1.0},"94":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":21,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"124":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.4142135623730951},"154":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":1,"docs":{"162":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":6,"docs":{"101":{"tf":1.0},"129":{"tf":1.0},"162":{"tf":1.0},"21":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.0}}},"v":{"df":4,"docs":{"51":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"28":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"64":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"133":{"tf":1.0},"17":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"127":{"tf":1.0},"146":{"tf":1.0},"182":{"tf":1.0},"54":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"181":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"121":{"tf":2.0},"127":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"180":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"99":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"132":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.0},"30":{"tf":1.0},"59":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.7320508075688772},"9":{"tf":1.0},"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"181":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"2":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"\\":{"0":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":37,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.0},"12":{"tf":2.0},"120":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":2.23606797749979},"166":{"tf":1.0},"17":{"tf":1.0},"180":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.0},"4":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":4,"docs":{"14":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"146":{"tf":2.8284271247461903},"57":{"tf":2.0}},"e":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"146":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"147":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":4,"docs":{"176":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"112":{"tf":1.0},"115":{"tf":1.0},"72":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":11,"docs":{"129":{"tf":1.0},"154":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"74":{"tf":1.0}}},".":{"0":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},">":{"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"3":{"\\":{"df":0,"docs":{},"x":{"a":{"6":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"\\":{"df":0,"docs":{},"x":{"b":{"1":{"\\":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"\\":{"df":0,"docs":{},"x":{"b":{"2":{"\\":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"\\":{"df":0,"docs":{},"x":{"b":{"3":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":15,"docs":{"105":{"tf":2.449489742783178},"106":{"tf":2.0},"120":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":3.4641016151377544},"129":{"tf":3.0},"132":{"tf":2.449489742783178},"166":{"tf":2.23606797749979},"30":{"tf":2.0},"64":{"tf":2.23606797749979},"69":{"tf":1.7320508075688772},"70":{"tf":2.8284271247461903},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"133":{"tf":1.0}}}}},"y":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"120":{"tf":1.4142135623730951},"127":{"tf":2.8284271247461903},"128":{"tf":2.449489742783178},"129":{"tf":2.449489742783178},"132":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":2.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"105":{"tf":1.0},"106":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":2,"docs":{"28":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"76":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.0}}}},"r":{"df":2,"docs":{"28":{"tf":1.0},"9":{"tf":1.0}}},"v":{"df":2,"docs":{"28":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"df":1,"docs":{"80":{"tf":1.0}}}}},"title":{"root":{"2":{"0":{"1":{"5":{"df":1,"docs":{"22":{"tf":1.0}}},"8":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"47":{"tf":1.0}}},"4":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"d":{"df":1,"docs":{"103":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"133":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"124":{"tf":1.0},"127":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"124":{"tf":1.0},"148":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"173":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"126":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"y":{"df":2,"docs":{"128":{"tf":1.0},"129":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"169":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"<":{"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"117":{"tf":1.0},"120":{"tf":1.0},"128":{"tf":1.0},"66":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":6,"docs":{"135":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"20":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":1,"docs":{"91":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"164":{"tf":1.0},"24":{"tf":1.0},"45":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"148":{"tf":1.0},"178":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"140":{"tf":1.0},"73":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":29,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"150":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"166":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"130":{"tf":1.0}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"121":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":1,"docs":{"148":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"169":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"135":{"tf":1.0},"144":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"156":{"tf":1.0},"160":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"107":{"tf":1.0},"33":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"152":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"19":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"72":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"61":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"140":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"152":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"14":{"tf":1.0},"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"117":{"tf":1.0},"123":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":6,"docs":{"156":{"tf":1.0},"16":{"tf":1.0},"160":{"tf":1.0},"17":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"101":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":43,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"134":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"182":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"160":{"tf":1.0}}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"138":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"130":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"140":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"167":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"164":{"tf":1.0}}}}},"w":{"df":6,"docs":{"21":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"122":{"tf":1.0},"33":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"24":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"48":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"123":{"tf":1.0}}}},"w":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"130":{"tf":1.0},"29":{"tf":1.0},"54":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"135":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"117":{"tf":1.0},"121":{"tf":1.0},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"c":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"102":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"102":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"178":{"tf":1.0}}},"df":0,"docs":{}}},"df":4,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"47":{"tf":1.0},"95":{"tf":1.0}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"121":{"tf":1.0}},"i":{"df":2,"docs":{"156":{"tf":1.0},"160":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":31,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"141":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"153":{"tf":1.0},"157":{"tf":1.0},"161":{"tf":1.0},"165":{"tf":1.0},"170":{"tf":1.0},"174":{"tf":1.0},"179":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"181":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"178":{"tf":1.0},"18":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.0},"124":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"128":{"tf":1.0},"129":{"tf":1.0}}}},"df":1,"docs":{"41":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":3,"docs":{"107":{"tf":1.0},"169":{"tf":1.0},"173":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"144":{"tf":1.0}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":3,"docs":{"121":{"tf":1.0},"32":{"tf":1.0},"9":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"113":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"AND","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});