package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetGWSInstanceName invokes the ehpc.SetGWSInstanceName API synchronously
func (client *Client) SetGWSInstanceName(request *SetGWSInstanceNameRequest) (response *SetGWSInstanceNameResponse, err error) {
	response = CreateSetGWSInstanceNameResponse()
	err = client.DoAction(request, response)
	return
}

// SetGWSInstanceNameWithChan invokes the ehpc.SetGWSInstanceName API asynchronously
func (client *Client) SetGWSInstanceNameWithChan(request *SetGWSInstanceNameRequest) (<-chan *SetGWSInstanceNameResponse, <-chan error) {
	responseChan := make(chan *SetGWSInstanceNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetGWSInstanceName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetGWSInstanceNameWithCallback invokes the ehpc.SetGWSInstanceName API asynchronously
func (client *Client) SetGWSInstanceNameWithCallback(request *SetGWSInstanceNameRequest, callback func(response *SetGWSInstanceNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetGWSInstanceNameResponse
		var err error
		defer close(result)
		response, err = client.SetGWSInstanceName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetGWSInstanceNameRequest is the request struct for api SetGWSInstanceName
type SetGWSInstanceNameRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	Name       string `position:"Query" name:"Name"`
}

// SetGWSInstanceNameResponse is the response struct for api SetGWSInstanceName
type SetGWSInstanceNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetGWSInstanceNameRequest creates a request to invoke SetGWSInstanceName API
func CreateSetGWSInstanceNameRequest() (request *SetGWSInstanceNameRequest) {
	request = &SetGWSInstanceNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "SetGWSInstanceName", "", "")
	request.Method = requests.GET
	return
}

// CreateSetGWSInstanceNameResponse creates a response to parse from SetGWSInstanceName response
func CreateSetGWSInstanceNameResponse() (response *SetGWSInstanceNameResponse) {
	response = &SetGWSInstanceNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
