package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResourceLog invokes the eas.DescribeResourceLog API synchronously
func (client *Client) DescribeResourceLog(request *DescribeResourceLogRequest) (response *DescribeResourceLogResponse, err error) {
	response = CreateDescribeResourceLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourceLogWithChan invokes the eas.DescribeResourceLog API asynchronously
func (client *Client) DescribeResourceLogWithChan(request *DescribeResourceLogRequest) (<-chan *DescribeResourceLogResponse, <-chan error) {
	responseChan := make(chan *DescribeResourceLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResourceLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourceLogWithCallback invokes the eas.DescribeResourceLog API asynchronously
func (client *Client) DescribeResourceLogWithCallback(request *DescribeResourceLogRequest, callback func(response *DescribeResourceLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourceLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeResourceLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourceLogRequest is the request struct for api DescribeResourceLog
type DescribeResourceLogRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	ClusterId  string `position:"Path" name:"ClusterId"`
}

// DescribeResourceLogResponse is the response struct for api DescribeResourceLog
type DescribeResourceLogResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ProjectName string `json:"ProjectName" xml:"ProjectName"`
	LogStore    string `json:"LogStore" xml:"LogStore"`
	Message     string `json:"Message" xml:"Message"`
	Status      string `json:"Status" xml:"Status"`
}

// CreateDescribeResourceLogRequest creates a request to invoke DescribeResourceLog API
func CreateDescribeResourceLogRequest() (request *DescribeResourceLogRequest) {
	request = &DescribeResourceLogRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DescribeResourceLog", "/api/v2/resources/[ClusterId]/[ResourceId]/log", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeResourceLogResponse creates a response to parse from DescribeResourceLog response
func CreateDescribeResourceLogResponse() (response *DescribeResourceLogResponse) {
	response = &DescribeResourceLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
