package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckFileDeployment invokes the dataworks_public.CheckFileDeployment API synchronously
func (client *Client) CheckFileDeployment(request *CheckFileDeploymentRequest) (response *CheckFileDeploymentResponse, err error) {
	response = CreateCheckFileDeploymentResponse()
	err = client.DoAction(request, response)
	return
}

// CheckFileDeploymentWithChan invokes the dataworks_public.CheckFileDeployment API asynchronously
func (client *Client) CheckFileDeploymentWithChan(request *CheckFileDeploymentRequest) (<-chan *CheckFileDeploymentResponse, <-chan error) {
	responseChan := make(chan *CheckFileDeploymentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckFileDeployment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckFileDeploymentWithCallback invokes the dataworks_public.CheckFileDeployment API asynchronously
func (client *Client) CheckFileDeploymentWithCallback(request *CheckFileDeploymentRequest, callback func(response *CheckFileDeploymentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckFileDeploymentResponse
		var err error
		defer close(result)
		response, err = client.CheckFileDeployment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckFileDeploymentRequest is the request struct for api CheckFileDeployment
type CheckFileDeploymentRequest struct {
	*requests.RpcRequest
	CheckDetailUrl    string `position:"Body" name:"CheckDetailUrl"`
	CheckerInstanceId string `position:"Body" name:"CheckerInstanceId"`
	Status            string `position:"Body" name:"Status"`
}

// CheckFileDeploymentResponse is the response struct for api CheckFileDeployment
type CheckFileDeploymentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckFileDeploymentRequest creates a request to invoke CheckFileDeployment API
func CreateCheckFileDeploymentRequest() (request *CheckFileDeploymentRequest) {
	request = &CheckFileDeploymentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CheckFileDeployment", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckFileDeploymentResponse creates a response to parse from CheckFileDeployment response
func CreateCheckFileDeploymentResponse() (response *CheckFileDeploymentResponse) {
	response = &CheckFileDeploymentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
