/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RefreshAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAction.$$$reportNull$$$0(0);
        }
        boolean isEnabled = (project = e.getProject()) != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RefreshAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        RefreshAction.doRefresh(project);
    }

    public static void doRefresh(@NotNull Project project) {
        if (project == null) {
            RefreshAction.$$$reportNull$$$0(3);
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
        Collection changesBeforeUpdate = changeListManager.getAllChanges();
        List unversionedBefore = changeListManager.getUnversionedFilesPaths();
        boolean wasUpdatingBefore = changeListManager.isInUpdate();
        FileDocumentManager.getInstance().saveAllDocuments();
        RefreshAction.invokeCustomRefreshes(project);
        VirtualFileManager.getInstance().asyncRefresh(() -> RefreshAction.performRefreshAndTrackChanges(project, changesBeforeUpdate, unversionedBefore, wasUpdatingBefore));
    }

    private static void invokeCustomRefreshes(@NotNull Project project) {
        if (project == null) {
            RefreshAction.$$$reportNull$$$0(4);
        }
        for (ChangesViewRefresher refresher : ChangesViewRefresher.EP_NAME.getExtensionList((AreaInstance)project)) {
            refresher.refresh(project);
        }
    }

    private static void performRefreshAndTrackChanges(Project project, Collection<? extends Change> changesBeforeUpdate, Collection<? extends FilePath> unversionedBefore, boolean wasUpdatingBefore) {
        if (project.isDisposed()) {
            return;
        }
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
        VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
        changeListManager.invokeAfterUpdate(false, () -> {
            Collection changesAfterUpdate = changeListManager.getAllChanges();
            List unversionedAfter = changeListManager.getUnversionedFilesPaths();
            VcsStatisticsCollector.logRefreshActionPerformed(project, changesBeforeUpdate, changesAfterUpdate, unversionedBefore, unversionedAfter, wasUpdatingBefore);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/RefreshAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RefreshAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRefresh";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeCustomRefreshes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

