/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedQuotesRule;
import org.languagetool.tools.Tools;

public class EnglishUnpairedQuotesRule
extends GenericUnpairedQuotesRule {
    private static final List<String> EN_START_SYMBOLS = Arrays.asList("\u201c", "\"", "'", "\u2018");
    private static final List<String> EN_END_SYMBOLS = Arrays.asList("\u201d", "\"", "'", "\u2019");

    public EnglishUnpairedQuotesRule(ResourceBundle messages, Language language) {
        super(messages, EN_START_SYMBOLS, EN_END_SYMBOLS);
        this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/punctuation-guide/#what-are-parentheses"));
        this.addExamplePair(Example.wrong("\"I'm over here,<marker></marker> she said."), Example.fixed("\"I'm over here,<marker>\"</marker> she said."));
    }

    @Override
    public String getId() {
        return "EN_UNPAIRED_QUOTES";
    }

    @Override
    protected boolean isNotBeginningApostrophe(AnalyzedTokenReadings[] tokens, int i) {
        return !tokens[i].hasPosTag("_apostrophe_contraction_") && !tokens[i].hasPosTag("POS") && !tokens[i].hasPosTag("NNP");
    }

    @Override
    protected boolean isNotEndingApostrophe(AnalyzedTokenReadings[] tokens, int i) {
        return !tokens[i].hasPosTag("_apostrophe_contraction_") && !tokens[i].hasPosTag("POS") && !tokens[i].hasPosTag("NNP");
    }
}

