/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.debugger.common.DebugConnectionNotifier;
import com.intellij.jupyter.core.jupyter.debugger.common.NotebookDebugRunner;
import com.intellij.jupyter.core.jupyter.debugger.common.OutputConsumer;
import com.intellij.jupyter.py.debugger.JupyterConsoleExecuteActionHandler;
import com.intellij.jupyter.py.debugger.JupyterDebugAction;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.debugger.JupyterDebugProcessHandler;
import com.intellij.jupyter.py.debugger.JupyterLineBreakpointType;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.run.PythonCommandLineState;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JH\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J/\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010!R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "Lcom/jetbrains/python/debugger/PyDebugRunner;", "Lcom/intellij/jupyter/core/jupyter/debugger/common/NotebookDebugRunner;", "<init>", "()V", "createDebugSession", "Lcom/intellij/xdebugger/XDebugSession;", "project", "Lcom/intellij/openapi/project/Project;", "jupyterPsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "connectionNotifier", "Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "output", "Lcom/intellij/jupyter/core/jupyter/debugger/common/OutputConsumer;", "afterCellExecuted", "Lkotlin/Function0;", "", "isBreakpointInCell", "", "manager", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl;", "cellLines", "Lkotlin/ranges/IntRange;", "addBreakpointToCell", "getFirstValidLineForBreakpoint", "", "jupyterLineBreakpointType", "Lcom/intellij/jupyter/py/debugger/JupyterLineBreakpointType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/jupyter/py/debugger/JupyterLineBreakpointType;Lkotlin/ranges/IntRange;)Ljava/lang/Integer;", "getConnectionNotifier", "()Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugRunner.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1755#2,3:178\n295#2,2:181\n*S KotlinDebug\n*F\n+ 1 JupyterDebugRunner.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugRunner\n*L\n102#1:178,3\n127#1:181,2\n*E\n"})
public final class JupyterDebugRunner
extends PyDebugRunner
implements NotebookDebugRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JupyterDebugRunner instance = new JupyterDebugRunner();
    @NotNull
    private static final Logger LOG;

    @NotNull
    public XDebugSession createDebugSession(@NotNull Project project, @NotNull JupyterPsiCell jupyterPsiCell, @NotNull NotebookIntervalPointer cellPointer, @NotNull VirtualFile virtualFile, @NotNull DebugConnectionNotifier connectionNotifier2, @Nullable OutputConsumer output, @NotNull Function0<Unit> afterCellExecuted) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jupyterPsiCell, (String)"jupyterPsiCell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)connectionNotifier2, (String)"connectionNotifier");
        Intrinsics.checkNotNullParameter(afterCellExecuted, (String)"afterCellExecuted");
        ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval != null && (interval = interval.getLines()) != null) {
            NotebookCellLines.Interval cellLines = interval;
            boolean bl = false;
            XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
            Intrinsics.checkNotNull((Object)xBreakpointManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
            XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)xBreakpointManager;
            if (!this.isBreakpointInCell(breakpointManager, (IntRange)cellLines, virtualFile)) {
                this.addBreakpointToCell(breakpointManager, project, virtualFile, (IntRange)cellLines);
            }
        }
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(JupyterDebugRunner.Companion.getFileName(jupyterPsiCell), JupyterCoreIcons.JupyterNotebook, null, false, new XDebugProcessStarter(project, serverSocket, jupyterPsiCell, cellPointer, connectionNotifier2, output, afterCellExecuted){
            final /* synthetic */ Project $project;
            final /* synthetic */ ServerSocket $serverSocket;
            final /* synthetic */ JupyterPsiCell $jupyterPsiCell;
            final /* synthetic */ NotebookIntervalPointer $cellPointer;
            final /* synthetic */ DebugConnectionNotifier $connectionNotifier;
            final /* synthetic */ OutputConsumer $output;
            final /* synthetic */ Function0<Unit> $afterCellExecuted;
            {
                this.$project = $project;
                this.$serverSocket = $serverSocket;
                this.$jupyterPsiCell = $jupyterPsiCell;
                this.$cellPointer = $cellPointer;
                this.$connectionNotifier = $connectionNotifier;
                this.$output = $output;
                this.$afterCellExecuted = $afterCellExecuted;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                ConsoleView consoleView = new PyDebugConsoleBuilder(this.$project, null).getConsole();
                Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
                ConsoleView debugConsoleView = consoleView;
                JupyterDebugProcessHandler jupyterDebugProcessHandler = new JupyterDebugProcessHandler(this.$project, session);
                ServerSocket serverSocket = this.$serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket);
                JupyterDebugProcess jupyterDebugProcess = new JupyterDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, jupyterDebugProcessHandler, this.$jupyterPsiCell, this.$cellPointer, this.$connectionNotifier, this.$output, this.$afterCellExecuted);
                debugConsoleView.attachToProcess((ProcessHandler)jupyterDebugProcessHandler);
                com.intellij.jupyter.py.debugger.JupyterDebugRunner$Companion.access$initDebugConsoleView(JupyterDebugRunner.Companion, this.$project, jupyterDebugProcess, (PythonDebugLanguageConsoleView)debugConsoleView, jupyterDebugProcessHandler, session);
                jupyterDebugProcess.connect(this.$jupyterPsiCell, this.$cellPointer);
                PyConsoleUtil.markIPython((VirtualFile)((PythonDebugLanguageConsoleView)debugConsoleView).getPydevConsoleView().getVirtualFile());
                return (XDebugProcess)jupyterDebugProcess;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSessionAndShowTab(...)");
        return xDebugSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBreakpointInCell(XBreakpointManagerImpl manager, IntRange cellLines, VirtualFile virtualFile) {
        boolean bl;
        Collection collection = manager.getBreakpoints(JupyterLineBreakpointType.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBreakpoints(...)");
        Collection breakpoints = collection;
        Iterable $this$any$iv = breakpoints;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            XLineBreakpoint breakpoint = (XLineBreakpoint)element$iv;
            boolean bl2 = false;
            XLineBreakpoint xLineBreakpoint = breakpoint;
            if (xLineBreakpoint != null && (xLineBreakpoint = xLineBreakpoint.getSourcePosition()) != null) {
                XLineBreakpoint position = xLineBreakpoint;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)position.getFile(), (Object)virtualFile)) {
                    boolean bl4;
                    int n = cellLines.getFirst();
                    int n2 = cellLines.getLast();
                    int n3 = position.getLine();
                    if (n <= n3) {
                        if (n3 <= n2) {
                            return true;
                        }
                        bl4 = false;
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void addBreakpointToCell(XBreakpointManagerImpl manager, Project project, VirtualFile virtualFile, IntRange cellLines) {
        JupyterLineBreakpointType breakpointType = (JupyterLineBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JupyterLineBreakpointType.class);
        Intrinsics.checkNotNull((Object)((Object)breakpointType));
        Integer n = this.getFirstValidLineForBreakpoint(project, virtualFile, breakpointType, cellLines);
        if (n == null) {
            return;
        }
        int firstValidLine = n;
        manager.addLineBreakpoint((XLineBreakpointType)breakpointType, virtualFile.getUrl(), firstValidLine, null);
    }

    private final Integer getFirstValidLineForBreakpoint(Project project, VirtualFile virtualFile, JupyterLineBreakpointType jupyterLineBreakpointType, IntRange cellLines) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)cellLines;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int line = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!jupyterLineBreakpointType.canPutAt(virtualFile, line, project)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public DebugConnectionNotifier getConnectionNotifier() {
        return new DebugConnectionNotifier(){

            public void executeAfterConnection(Project project, JupyterPsiCell jupyterCell, NotebookIntervalPointer cellPointer, XDebugSession debugSession, OutputConsumer consumer) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)jupyterCell, (String)"jupyterCell");
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
                JupyterDebugAction.Companion.executeCell(project, jupyterCell, cellPointer, debugSession, consumer);
            }
        };
    }

    public static final /* synthetic */ PythonDebugConsoleCommunication access$initDebugConsoleView$s821162362(PythonConsoleView p0, PydevDebugConsoleExecuteActionHandler p1, PyDebugProcess p2, ProcessHandler p3, PythonDebugConsoleCommunication p4, XDebugSession p5) {
        return PyDebugRunner.initDebugConsoleView((PythonConsoleView)p0, (PydevDebugConsoleExecuteActionHandler)p1, (PyDebugProcess)p2, (ProcessHandler)p3, (PythonDebugConsoleCommunication)p4, (XDebugSession)p5);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "getInstance", "()Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "initDebugConsoleView", "Lcom/jetbrains/python/console/PythonDebugConsoleCommunication;", "project", "Lcom/intellij/openapi/project/Project;", "debugProcess", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "console", "Lcom/jetbrains/python/console/PythonDebugLanguageConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getFileName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDebugRunner getInstance() {
            return instance;
        }

        private final PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
            PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
            Intrinsics.checkNotNullExpressionValue((Object)pythonConsoleView, (String)"getPydevConsoleView(...)");
            PythonConsoleView pythonConsoleView2 = pythonConsoleView;
            PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess, pythonConsoleView2);
            pythonConsoleView2.setConsoleCommunication((ConsoleCommunication)debugConsoleCommunication);
            JupyterConsoleExecuteActionHandler consoleExecuteActionHandler = new JupyterConsoleExecuteActionHandler(console, processHandler, (ConsoleCommunication)debugConsoleCommunication, debugProcess);
            PythonDebugConsoleCommunication pythonDebugConsoleCommunication = JupyterDebugRunner.access$initDebugConsoleView$s821162362(pythonConsoleView2, consoleExecuteActionHandler, debugProcess, processHandler, debugConsoleCommunication, session);
            Intrinsics.checkNotNullExpressionValue((Object)pythonDebugConsoleCommunication, (String)"access$initDebugConsoleView$s821162362(...)");
            return pythonDebugConsoleCommunication;
        }

        @Nls
        private final String getFileName(JupyterPsiCell cell) {
            String string;
            if (cell.getContainingFile() != null) {
                string = FileUtil.getNameWithoutExtension((String)cell.getContainingFile().getName());
            } else {
                this.getLOG().error("Containing file for cell is null: " + cell);
                string = JupyterBundle.message((String)"Jupyter.debugger.session.default.file.name", (Object[])new Object[0]);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public static final /* synthetic */ PythonDebugConsoleCommunication access$initDebugConsoleView(Companion $this, Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
            return $this.initDebugConsoleView(project, debugProcess, console, processHandler, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

