/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.ast.PyAstAssignmentStatement;
import com.jetbrains.python.ast.PyAstBreakStatement;
import com.jetbrains.python.ast.PyAstContinueStatement;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionStatement;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstListLiteralExpression;
import com.jetbrains.python.ast.PyAstLoopStatement;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstSequenceExpression;
import com.jetbrains.python.ast.PyAstStarExpression;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstStatementWithElse;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.PyAstTupleExpression;
import com.jetbrains.python.ast.controlFlow.AstScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PyUtilCore {
    private static final Pattern TYPE_COMMENT_PATTERN = Pattern.compile("# *type: *([^#]+) *(#.*)?");

    private PyUtilCore() {
    }

    private static List<PyAstExpression> unfoldParentheses(PyAstExpression[] targets, List<PyAstExpression> receiver, boolean unfoldListLiterals, boolean unfoldStarExpressions) {
        for (PyAstExpression exp : targets) {
            if (exp instanceof PyAstParenthesizedExpression) {
                PyAstParenthesizedExpression parenExpr = (PyAstParenthesizedExpression)exp;
                PyUtilCore.unfoldParentheses(new PyAstExpression[]{parenExpr.getContainedExpression()}, receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyAstTupleExpression) {
                PyAstTupleExpression tupleExpr = (PyAstTupleExpression)exp;
                PyUtilCore.unfoldParentheses(tupleExpr.getElements(), receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyAstListLiteralExpression) {
                PyAstListLiteralExpression listLiteral = (PyAstListLiteralExpression)exp;
                if (unfoldListLiterals) {
                    PyUtilCore.unfoldParentheses(listLiteral.getElements(), receiver, true, unfoldStarExpressions);
                    continue;
                }
            }
            if (exp instanceof PyAstStarExpression && unfoldStarExpressions) {
                PyUtilCore.unfoldParentheses(new PyAstExpression[]{((PyAstStarExpression)exp).getExpression()}, receiver, unfoldListLiterals, true);
                continue;
            }
            if (exp == null) continue;
            receiver.add(exp);
        }
        return receiver;
    }

    @NotNull
    public static List<PyAstExpression> flattenedParensAndTuples(PyAstExpression ... targets) {
        List<PyAstExpression> list = PyUtilCore.unfoldParentheses(targets, new ArrayList<PyAstExpression>(targets.length), false, false);
        if (list == null) {
            PyUtilCore.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<PyAstExpression> flattenedParensAndLists(PyAstExpression ... targets) {
        List<PyAstExpression> list = PyUtilCore.unfoldParentheses(targets, new ArrayList<PyAstExpression>(targets.length), true, true);
        if (list == null) {
            PyUtilCore.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<PyAstExpression> flattenedParensAndStars(PyAstExpression ... targets) {
        List<PyAstExpression> list = PyUtilCore.unfoldParentheses(targets, new ArrayList<PyAstExpression>(targets.length), false, true);
        if (list == null) {
            PyUtilCore.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static boolean onSameLine(@NotNull PsiElement e1, @NotNull PsiElement e2) {
        if (e1 == null) {
            PyUtilCore.$$$reportNull$$$0(3);
        }
        if (e2 == null) {
            PyUtilCore.$$$reportNull$$$0(4);
        }
        PsiFile firstFile = e1.getContainingFile();
        PsiFile secondFile = e2.getContainingFile();
        if (firstFile == null || secondFile == null) {
            return false;
        }
        Document document = firstFile.getFileDocument();
        if (document != secondFile.getFileDocument()) {
            return false;
        }
        return document.getLineNumber(e1.getTextOffset()) == document.getLineNumber(e2.getTextOffset());
    }

    public static boolean isTopLevel(@NotNull PsiElement element) {
        StubElement parentStub;
        StubElement stub;
        if (element == null) {
            PyUtilCore.$$$reportNull$$$0(5);
        }
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null && (parentStub = stub.getParentStub()) != null) {
            return parentStub.getPsi() instanceof PsiFile;
        }
        return ScopeUtilCore.getScopeOwner(element) instanceof PsiFile;
    }

    public static void updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Consumer<? super Document> consumer) {
        if (anchor == null) {
            PyUtilCore.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            PyUtilCore.$$$reportNull$$$0(7);
        }
        PyUtilCore.updateDocumentUnblockedAndCommitted(anchor, document -> {
            consumer.consume(document);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Function<? super Document, ? extends T> func) {
        if (anchor == null) {
            PyUtilCore.$$$reportNull$$$0(8);
        }
        if (func == null) {
            PyUtilCore.$$$reportNull$$$0(9);
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)anchor.getProject());
        Document document = anchor.getContainingFile().getViewProvider().getDocument();
        if (document != null) {
            manager.doPostponedOperationsAndUnblockDocument(document);
            try {
                Object object = func.fun((Object)document);
                return (T)object;
            }
            finally {
                manager.commitDocument(document);
            }
        }
        return null;
    }

    public static boolean isSpecialName(@NotNull String name) {
        if (name == null) {
            PyUtilCore.$$$reportNull$$$0(10);
        }
        return name.length() > 4 && name.startsWith("__") && name.endsWith("__");
    }

    @Nullable
    public static PyAstLoopStatement getCorrespondingLoop(@NotNull PsiElement breakOrContinue) {
        if (breakOrContinue == null) {
            PyUtilCore.$$$reportNull$$$0(11);
        }
        return breakOrContinue instanceof PyAstContinueStatement || breakOrContinue instanceof PyAstBreakStatement ? PyUtilCore.getCorrespondingLoopImpl(breakOrContinue) : null;
    }

    @Nullable
    private static PyAstLoopStatement getCorrespondingLoopImpl(@NotNull PsiElement element) {
        PyAstLoopStatement loop;
        if (element == null) {
            PyUtilCore.$$$reportNull$$$0(12);
        }
        if ((loop = (PyAstLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstLoopStatement.class, (boolean)true, (Class[])new Class[]{AstScopeOwner.class})) instanceof PyAstStatementWithElse && PsiTreeUtil.isAncestor((PsiElement)((PyAstStatementWithElse)((Object)loop)).getElsePart(), (PsiElement)element, (boolean)true)) {
            return PyUtilCore.getCorrespondingLoopImpl((PsiElement)loop);
        }
        return loop;
    }

    @Contract(value="null -> false")
    public static boolean isNewMethod(@Nullable PsiElement element) {
        PyAstFunction function = (PyAstFunction)ObjectUtils.tryCast((Object)element, PyAstFunction.class);
        return function != null && "__new__".equals(function.getName()) && function.getContainingClass() != null;
    }

    @Contract(value="null -> false")
    public static boolean isInitOrNewMethod(@Nullable PsiElement element) {
        PyAstFunction function = (PyAstFunction)ObjectUtils.tryCast((Object)element, PyAstFunction.class);
        if (function == null) {
            return false;
        }
        String name = function.getName();
        return ("__init__".equals(name) || "__new__".equals(name)) && function.getContainingClass() != null;
    }

    @Contract(value="null -> false")
    public static boolean isConstructorLikeMethod(@Nullable PsiElement element) {
        PyAstFunction function = (PyAstFunction)ObjectUtils.tryCast((Object)element, PyAstFunction.class);
        if (function == null) {
            return false;
        }
        String name = function.getName();
        return ("__init_subclass__".equals(name) || "__init__".equals(name) || "__new__".equals(name)) && function.getContainingClass() != null;
    }

    public static boolean isStringLiteral(@Nullable PyAstStatement stmt) {
        PyAstExpression expr;
        return stmt instanceof PyAstExpressionStatement && (expr = ((PyAstExpressionStatement)stmt).getExpression()) instanceof PyAstStringLiteralExpression;
    }

    public static int getInitialUnderscores(@Nullable String name) {
        return name == null ? 0 : (name.startsWith("__") ? 2 : (name.startsWith("_") ? 1 : 0));
    }

    @Nullable
    public static List<String> strListValue(PyAstExpression value) {
        while (value instanceof PyAstParenthesizedExpression) {
            value = ((PyAstParenthesizedExpression)value).getContainedExpression();
        }
        if (value instanceof PyAstSequenceExpression) {
            PyAstExpression[] elements = ((PyAstSequenceExpression)value).getElements();
            ArrayList<String> result = new ArrayList<String>(elements.length);
            for (PyAstExpression element : elements) {
                if (!(element instanceof PyAstStringLiteralExpression)) {
                    return null;
                }
                result.add(((PyAstStringLiteralExpression)element).getStringValue());
            }
            return result;
        }
        return null;
    }

    public static boolean isAssignmentToModuleLevelDunderName(@Nullable PsiElement element) {
        if (element instanceof PyAstAssignmentStatement) {
            PyAstExpression[] targets;
            PyAstAssignmentStatement statement = (PyAstAssignmentStatement)element;
            if (PyUtilCore.isTopLevel(element) && (targets = statement.getTargets()).length == 1) {
                String name = targets[0].getName();
                return name != null && PyUtilCore.isSpecialName(name);
            }
        }
        return false;
    }

    @Nullable
    public static PsiComment getCommentOnHeaderLine(@NotNull PyAstStatementListContainer container) {
        if (container == null) {
            PyUtilCore.$$$reportNull$$$0(13);
        }
        return (PsiComment)ObjectUtils.tryCast((Object)PyUtilCore.getHeaderEndAnchor(container), PsiComment.class);
    }

    @NotNull
    public static PsiElement getHeaderEndAnchor(@NotNull PyAstStatementListContainer container) {
        if (container == null) {
            PyUtilCore.$$$reportNull$$$0(14);
        }
        PyAstStatementList statementList = container.getStatementList();
        PsiElement psiElement = Objects.requireNonNull(PsiTreeUtil.skipWhitespacesBackward((PsiElement)statementList));
        if (psiElement == null) {
            PyUtilCore.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @Nullable
    public static String getTypeCommentValue(@NotNull String text) {
        Matcher m;
        if (text == null) {
            PyUtilCore.$$$reportNull$$$0(16);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text)).matches()) {
            return StringUtil.nullize((String)m.group(1).trim());
        }
        return null;
    }

    @Nullable
    public static TextRange getTypeCommentValueRange(@NotNull String text) {
        String hint;
        Matcher m;
        if (text == null) {
            PyUtilCore.$$$reportNull$$$0(17);
        }
        if ((m = TYPE_COMMENT_PATTERN.matcher(text)).matches() && (hint = PyUtilCore.getTypeCommentValue(text)) != null) {
            return TextRange.from((int)m.start(1), (int)hint.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/impl/PyUtilCore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakOrContinue";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndTuples";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndLists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndStars";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/impl/PyUtilCore";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderEndAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onSameLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentUnblockedAndCommitted";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingLoop";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingLoopImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommentOnHeaderLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderEndAnchor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValueRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

