/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/debugger/PydevDebugConsoleExecuteActionHandler;", "Lcom/jetbrains/python/console/PydevConsoleExecuteActionHandler;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "myConsole", "Lcom/jetbrains/python/console/PythonDebugLanguageConsoleView;", "myProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "consoleCommunication", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "<init>", "(Lcom/jetbrains/python/console/PythonDebugLanguageConsoleView;Lcom/intellij/execution/process/ProcessHandler;Lcom/jetbrains/python/console/pydev/ConsoleCommunication;)V", "consoleIsNotEnabledMessage", "", "Lorg/jetbrains/annotations/Nls;", "getConsoleIsNotEnabledMessage", "()Ljava/lang/String;", "sessionPaused", "", "sessionResumed", "sessionStopped", "stackFrameChanged", "beforeSessionResume", "beforeExecution", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "intellij.python.community.impl"})
public class PydevDebugConsoleExecuteActionHandler
extends PydevConsoleExecuteActionHandler
implements XDebugSessionListener {
    @NotNull
    private final PythonDebugLanguageConsoleView myConsole;

    public PydevDebugConsoleExecuteActionHandler(@NotNull PythonDebugLanguageConsoleView myConsole, @NotNull ProcessHandler myProcessHandler, @NotNull ConsoleCommunication consoleCommunication) {
        Intrinsics.checkNotNullParameter((Object)myConsole, (String)"myConsole");
        Intrinsics.checkNotNullParameter((Object)myProcessHandler, (String)"myProcessHandler");
        Intrinsics.checkNotNullParameter((Object)consoleCommunication, (String)"consoleCommunication");
        PythonConsoleView pythonConsoleView = myConsole.getPydevConsoleView();
        Intrinsics.checkNotNullExpressionValue((Object)pythonConsoleView, (String)"getPydevConsoleView(...)");
        super((LanguageConsoleView)pythonConsoleView, myProcessHandler, consoleCommunication);
        this.myConsole = myConsole;
    }

    @Override
    @NotNull
    protected String getConsoleIsNotEnabledMessage() {
        String string = PyBundle.message("debugger.pydev.console.pause.the.process.to.use.command.line", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void sessionPaused() {
        this.setEnabled(true);
    }

    public void sessionResumed() {
        this.setEnabled(false);
    }

    public void sessionStopped() {
        this.setEnabled(false);
    }

    public void stackFrameChanged() {
    }

    public void beforeSessionResume() {
    }

    protected void beforeExecution(@NotNull LanguageConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        super.beforeExecution(consoleView);
        String string = ((LanguageConsoleImpl)consoleView).getCurrentEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        this.myConsole.getPrimaryConsoleView().print(text + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }
}

