/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0014J\u0014\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleChangesGroupingPolicy;", "Lcom/intellij/dvcs/repo/Repository;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "getGroupRootValueFor", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "createGroupRootNode", "value", "getRepositoryFor", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Factory", "intellij.platform.vcs.dvcs.impl"})
public final class RepositoryChangesGroupingPolicy
extends SimpleChangesGroupingPolicy<Repository> {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsRepositoryManager repositoryManager;
    @NotNull
    private final VcsLogColorManager colorManager;

    public RepositoryChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.project = project;
        this.repositoryManager = VcsRepositoryManager.Companion.getInstance(this.project);
        this.colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    protected Repository getGroupRootValueFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (!this.colorManager.hasMultiplePaths()) {
            return null;
        }
        FilePath filePath = nodePath.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        Repository repository = this.getRepositoryFor(filePath2);
        if (repository == null) {
            return null;
        }
        Repository repository2 = repository;
        if (this.repositoryManager.isExternal(repository2)) {
            return null;
        }
        return repository2;
    }

    @NotNull
    protected ChangesBrowserNode<?> createGroupRootNode(@NotNull Repository value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        RepositoryChangesBrowserNode repoNode = new RepositoryChangesBrowserNode(value, this.colorManager);
        repoNode.markAsHelperNode();
        return repoNode;
    }

    private final Repository getRepositoryFor(FilePath filePath) {
        Repository parentRepo;
        Repository repository = this.repositoryManager.getRepositoryForFile(filePath, true);
        if (repository != null && !repository.getVcs().areDirectoriesVersionedItems() && Intrinsics.areEqual((Object)this.repositoryManager.getRepositoryForRootQuick(filePath), (Object)repository) && (parentRepo = this.repositoryManager.getRepositoryForFile(repository.getRoot().getParent(), true)) != null) {
            return parentRepo;
        }
        return repository;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "<init>", "()V", "createGroupingPolicy", "Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @NotNull
        public RepositoryChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new RepositoryChangesGroupingPolicy(project, model);
        }
    }
}

