/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization.credentials;

import java.time.DateTimeException;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.authorization.credentials.QodanaCloudCredentialsSingleUseRefreshToken;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaCloudCredentialsImpl;", "Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaCloudCredentialsSingleUseRefreshToken;", "accessToken", "", "Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaAccessToken;", "expirationMoment", "Ljava/time/Instant;", "refreshToken", "Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaRefreshToken;", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "safeExpirationMoment", "isAccessTokenExpired", "", "acquireAccessTokenForRequest", "computeExpirationMomentWithDelay", "baseMoment", "delaySeconds", "", "intellij.qodana"})
public final class QodanaCloudCredentialsImpl
extends QodanaCloudCredentialsSingleUseRefreshToken {
    @NotNull
    private final String accessToken;
    @NotNull
    private final Instant safeExpirationMoment;

    public QodanaCloudCredentialsImpl(@NotNull String accessToken, @NotNull Instant expirationMoment, @NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)expirationMoment, (String)"expirationMoment");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        super(refreshToken);
        this.accessToken = accessToken;
        this.safeExpirationMoment = this.computeExpirationMomentWithDelay(expirationMoment, 60L);
    }

    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    private final boolean isAccessTokenExpired() {
        return Instant.now().isAfter(this.safeExpirationMoment);
    }

    @Override
    @Nullable
    public String acquireAccessTokenForRequest() {
        return this.isAccessTokenExpired() ? null : this.getAccessToken();
    }

    private final Instant computeExpirationMomentWithDelay(Instant baseMoment, long delaySeconds) {
        Instant instant;
        try {
            instant = baseMoment.minusSeconds(delaySeconds);
            Intrinsics.checkNotNull((Object)instant);
        }
        catch (DateTimeException e) {
            instant = baseMoment;
        }
        return instant;
    }
}

