/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeStamp
implements Serializable,
Comparable {
    protected static final long msb0baseTime = 2085978496000L;
    protected static final long msb1baseTime = -2208988800000L;
    public static final String NTP_DATE_FORMAT = "EEE, MMM dd yyyy HH:mm:ss.SSS";
    private static SoftReference simpleFormatter = null;
    private static SoftReference utcFormatter = null;
    private long ntpTime;
    private static final long serialVersionUID = 8139806907588338737L;

    public TimeStamp(long l) {
        this.ntpTime = l;
    }

    public TimeStamp(String string) throws NumberFormatException {
        this.ntpTime = TimeStamp.decodeNtpHexString(string);
    }

    public TimeStamp(Date date) {
        this.ntpTime = date == null ? 0L : TimeStamp.toNtpTime(date.getTime());
    }

    private static void appendHexString(StringBuffer stringBuffer, long l) {
        String string = Long.toHexString(l);
        int n = string.length();
        while (n < 8) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
    }

    public int compareTo(Object object) {
        return this.compareTo((TimeStamp)object);
    }

    public int compareTo(TimeStamp timeStamp) {
        long l = this.ntpTime;
        long l2 = timeStamp.ntpTime;
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    protected static long decodeNtpHexString(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n = string.indexOf(46);
        if (n == -1) {
            if (string.length() == 0) {
                return 0L;
            }
            return Long.parseLong(string, 16) << 32;
        }
        return Long.parseLong(string.substring(0, n), 16) << 32 | Long.parseLong(string.substring(n + 1), 16);
    }

    public boolean equals(Object object) {
        if (object instanceof TimeStamp) {
            return this.ntpTime == ((TimeStamp)object).ntpValue();
        }
        return false;
    }

    public static TimeStamp getCurrentTime() {
        return TimeStamp.getNtpTime(System.currentTimeMillis());
    }

    public Date getDate() {
        long l = TimeStamp.getTime(this.ntpTime);
        return new Date(l);
    }

    public long getFraction() {
        return this.ntpTime & 0xFFFFFFFFL;
    }

    public static TimeStamp getNtpTime(long l) {
        return new TimeStamp(TimeStamp.toNtpTime(l));
    }

    public long getSeconds() {
        return this.ntpTime >>> 32 & 0xFFFFFFFFL;
    }

    public long getTime() {
        return TimeStamp.getTime(this.ntpTime);
    }

    public static long getTime(long l) {
        long l2 = l >>> 32 & 0xFFFFFFFFL;
        long l3 = l & 0xFFFFFFFFL;
        l3 = Math.round(1000.0 * (double)l3 / 4.294967296E9);
        long l4 = l2 & 0x80000000L;
        if (l4 == 0L) {
            return 2085978496000L + l2 * 1000L + l3;
        }
        return -2208988800000L + l2 * 1000L + l3;
    }

    public int hashCode() {
        return (int)(this.ntpTime ^ this.ntpTime >>> 32);
    }

    public long ntpValue() {
        return this.ntpTime;
    }

    public static TimeStamp parseNtpString(String string) throws NumberFormatException {
        return new TimeStamp(TimeStamp.decodeNtpHexString(string));
    }

    public String toDateString() {
        DateFormat dateFormat = null;
        if (simpleFormatter != null) {
            dateFormat = (DateFormat)simpleFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(NTP_DATE_FORMAT, Locale.US);
            dateFormat.setTimeZone(TimeZone.getDefault());
            simpleFormatter = new SoftReference<DateFormat>(dateFormat);
        }
        Date date = this.getDate();
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            String string = dateFormat.format(date);
            Object var5_5 = null;
            return string;
        }
    }

    protected static long toNtpTime(long l) {
        boolean bl = l < 2085978496000L;
        long l2 = bl ? l - -2208988800000L : l - 2085978496000L;
        long l3 = l2 / 1000L;
        long l4 = l2 % 1000L * 0x100000000L / 1000L;
        if (bl) {
            l3 |= 0x80000000L;
        }
        long l5 = l3 << 32 | l4;
        return l5;
    }

    public String toString() {
        return TimeStamp.toString(this.ntpTime);
    }

    public static String toString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        TimeStamp.appendHexString(stringBuffer, l >>> 32 & 0xFFFFFFFFL);
        stringBuffer.append('.');
        TimeStamp.appendHexString(stringBuffer, l & 0xFFFFFFFFL);
        return stringBuffer.toString();
    }

    public String toUTCString() {
        DateFormat dateFormat = null;
        if (utcFormatter != null) {
            dateFormat = (DateFormat)utcFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("EEE, MMM dd yyyy HH:mm:ss.SSS 'UTC'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            utcFormatter = new SoftReference<DateFormat>(dateFormat);
        }
        Date date = this.getDate();
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            String string = dateFormat.format(date);
            Object var5_5 = null;
            return string;
        }
    }
}

