/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.whatsNew;

import com.intellij.ide.actions.WhatsNewUtil;
import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.whatsNew.WhatsNewAction;
import com.intellij.platform.whatsNew.WhatsNewContent;
import com.intellij.platform.whatsNew.WhatsNewEnvironmentAccessor;
import com.intellij.platform.whatsNew.WhatsNewShowOnStartCheckServiceKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewEnvironmentAccessorImpl;", "Lcom/intellij/platform/whatsNew/WhatsNewEnvironmentAccessor;", "<init>", "()V", "isPlaybackMode", "", "isForceDisabled", "()Z", "getWhatsNewContent", "Lcom/intellij/platform/whatsNew/WhatsNewContent;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAction", "Lcom/intellij/platform/whatsNew/WhatsNewAction;", "showWhatsNew", "", "project", "Lcom/intellij/openapi/project/Project;", "action", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/whatsNew/WhatsNewAction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDefaultWhatsNewEnabledAndReadyToShow", "intellij.platform.whatsNew"})
final class WhatsNewEnvironmentAccessorImpl
implements WhatsNewEnvironmentAccessor {
    private final boolean isPlaybackMode = SystemProperties.getBooleanProperty((String)"idea.is.playback", (boolean)false);

    @Override
    public boolean isForceDisabled() {
        return ApplicationKt.getApplication().isHeadlessEnvironment() || ApplicationKt.getApplication().isUnitTestMode() || this.isPlaybackMode || AppMode.isRemoteDevHost() || Registry.Companion.is("expose.ui.hierarchy.url", false);
    }

    @Override
    @Nullable
    public Object getWhatsNewContent(@NotNull Continuation<? super WhatsNewContent> $completion) {
        return WhatsNewContent.Companion.getWhatsNewContent($completion);
    }

    @Override
    @Nullable
    public WhatsNewAction findAction() {
        AnAction anAction = ActionManager.getInstance().getAction("WhatsNewAction");
        return anAction instanceof WhatsNewAction ? (WhatsNewAction)anAction : null;
    }

    @Override
    @Nullable
    public Object showWhatsNew(@NotNull Project project, @NotNull WhatsNewAction action, @NotNull Continuation<? super Unit> $completion) {
        Object object = action.openWhatsNew(project, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean isDefaultWhatsNewEnabledAndReadyToShow() {
        UpdateStrategyCustomization updateStrategyCustomization = UpdateStrategyCustomization.Companion.getInstance();
        boolean enabledModernWay = updateStrategyCustomization.getShowWhatIsNewPageAfterUpdate();
        boolean enabledLegacyWay = ApplicationInfoEx.getInstanceEx().isShowWhatsNewOnUpdate();
        if (enabledModernWay || enabledLegacyWay) {
            String problem = "This could lead to issues with the Vision-based What's New. Mixing of web-based and Vision-based What's New is not supported.";
            if (enabledModernWay) {
                WhatsNewShowOnStartCheckServiceKt.access$getLogger$p().error(updateStrategyCustomization.getClass() + "'s showWhatIsNewPageAfterUpdate is overridden to true. " + problem);
            }
            if (enabledLegacyWay) {
                WhatsNewShowOnStartCheckServiceKt.access$getLogger$p().error("show-on-update attribute on the <whatsnew> element in the application info XML is set. " + problem);
            }
            if (WhatsNewUtil.isWhatsNewAvailable()) {
                return true;
            }
        }
        return false;
    }
}

