/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.terminal.backend.TerminalContentChangesTrackerKt;
import com.intellij.terminal.backend.TerminalDiscardedHistoryTracker;
import com.intellij.terminal.session.StyleRange;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import com.intellij.terminal.session.dto.StyleRangeDtoKt;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.TextBufferChangesListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImplKt;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.scraper.SimpleStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StylesCollectingTerminalLinesCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/terminal/backend/TerminalContentChangesTracker;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "discardedHistoryTracker", "Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;)V", "lastChangedVisualLine", "", "anyLineChanged", "", "listeners", "", "Lkotlin/Function1;", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "", "addHistoryOverflowListener", "listener", "getContentUpdate", "flushChanges", "additionalLines", "", "Lcom/jediterm/terminal/model/TerminalLine;", "collectOutput", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "startLine", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nTerminalContentChangesTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalContentChangesTracker.kt\ncom/intellij/terminal/backend/TerminalContentChangesTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1863#2,2:134\n1557#2:137\n1628#2,3:138\n1#3:136\n*S KotlinDebug\n*F\n+ 1 TerminalContentChangesTracker.kt\ncom/intellij/terminal/backend/TerminalContentChangesTracker\n*L\n71#1:134,2\n101#1:137\n101#1:138,3\n*E\n"})
public final class TerminalContentChangesTracker {
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final TerminalDiscardedHistoryTracker discardedHistoryTracker;
    private int lastChangedVisualLine;
    private boolean anyLineChanged;
    @NotNull
    private final List<Function1<TerminalContentUpdatedEvent, Unit>> listeners;

    public TerminalContentChangesTracker(@NotNull TerminalTextBuffer textBuffer, @NotNull TerminalDiscardedHistoryTracker discardedHistoryTracker) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)discardedHistoryTracker, (String)"discardedHistoryTracker");
        this.textBuffer = textBuffer;
        this.discardedHistoryTracker = discardedHistoryTracker;
        this.listeners = new CopyOnWriteArrayList();
        this.textBuffer.addChangesListener(new TextBufferChangesListener(){

            public void linesChanged(int fromIndex) {
                int line = TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(textBuffer) + fromIndex;
                lastChangedVisualLine = Math.min(lastChangedVisualLine, line);
                anyLineChanged = true;
            }

            public void linesDiscardedFromHistory(List<TerminalLine> lines) {
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                if (textBuffer.isUsingAlternateBuffer()) {
                    return;
                }
                if (lastChangedVisualLine >= lines.size()) {
                    lastChangedVisualLine = lastChangedVisualLine - lines.size();
                } else {
                    List<TerminalLine> additionalLines = lines.subList(lastChangedVisualLine, lines.size());
                    lastChangedVisualLine = 0;
                    this.flushChanges(additionalLines);
                }
            }

            public void widthResized() {
                lastChangedVisualLine = 0;
            }

            public void historyCleared() {
                TextBufferChangesListener.DefaultImpls.historyCleared((TextBufferChangesListener)this);
            }
        });
    }

    public final void addHistoryOverflowListener(@NotNull Function1<? super TerminalContentUpdatedEvent, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Nullable
    public final TerminalContentUpdatedEvent getContentUpdate() {
        return this.getContentUpdate(CollectionsKt.emptyList());
    }

    private final void flushChanges(List<TerminalLine> additionalLines) {
        TerminalContentUpdatedEvent terminalContentUpdatedEvent = this.getContentUpdate(additionalLines);
        Intrinsics.checkNotNull((Object)terminalContentUpdatedEvent);
        TerminalContentUpdatedEvent update = terminalContentUpdatedEvent;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)update);
        }
    }

    private final TerminalContentUpdatedEvent getContentUpdate(List<TerminalLine> additionalLines) {
        return this.anyLineChanged ? this.collectOutput(additionalLines) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final TerminalContentUpdatedEvent collectOutput(List<TerminalLine> additionalLines) {
        void $this$mapTo$iv$iv;
        if (!this.anyLineChanged) {
            boolean $i$a$-check-TerminalContentChangesTracker$collectOutput$22 = false;
            String $i$a$-check-TerminalContentChangesTracker$collectOutput$22 = "It is expected that this method is called only if something is changed";
            throw new IllegalStateException($i$a$-check-TerminalContentChangesTracker$collectOutput$22.toString());
        }
        int startLine = this.lastChangedVisualLine - TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer);
        while (startLine - 1 >= -TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer) && this.textBuffer.getLine(startLine - 1).isWrapped()) {
            --startLine;
        }
        StyledCommandOutput output = this.scrapeOutput(startLine, additionalLines);
        int logicalLineIndex = TerminalContentChangesTrackerKt.getLogicalLineIndex(this.textBuffer, startLine) + this.discardedHistoryTracker.getDiscardedLogicalLinesCount() - additionalLines.size();
        this.lastChangedVisualLine = TerminalContentChangesTrackerKt.access$getEffectiveHistoryLinesCount(this.textBuffer) + this.textBuffer.getScreenLinesCount();
        this.anyLineChanged = false;
        Iterable $this$map$iv = output.getStyleRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRange styleRange = (StyleRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StyleRangeDtoKt.toDto((StyleRange)it));
        }
        List styles = (List)destination$iv$iv;
        return new TerminalContentUpdatedEvent(output.getText(), styles, logicalLineIndex);
    }

    private final StyledCommandOutput scrapeOutput(int startLine, List<TerminalLine> additionalLines) {
        List styles = new ArrayList();
        SimpleStringCollector stringCollector = new SimpleStringCollector();
        StylesCollectingTerminalLinesCollector terminalLinesCollector2 = new StylesCollectingTerminalLinesCollector(stringCollector, (Function1<? super StyleRange, Unit>)((Function1)new Function1<StyleRange, Unit>((Object)styles){

            public final void invoke(StyleRange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((List)this.receiver).add(p0);
            }
        }));
        for (TerminalLine line : additionalLines) {
            terminalLinesCollector2.addLine(line);
        }
        ShellCommandOutputScraperImplKt.collectLines(this.textBuffer, terminalLinesCollector2, startLine);
        return new StyledCommandOutput(stringCollector.buildText(), false, styles);
    }
}

