/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.EnabledInspectionsProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.qodana.sarif.model.Notification;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;
import org.jetbrains.qodana.staticAnalysis.profile.Thresholds;
import org.jetbrains.qodana.staticAnalysis.sarif.notifications.RuntimeNotificationCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00060\tR\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "name", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;)V", "createState", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup$State;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "applyConfig", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "project", "Lcom/intellij/openapi/project/Project;", "addDefaultExclude", "", "Companion", "State", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1863#2,2:189\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup\n*L\n65#1:189,2\n*E\n"})
public final class SanityInspectionGroup
extends NamedInspectionGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SANITY_FAILURE_NOTIFICATION = "sanityFailure";

    public SanityInspectionGroup(@NotNull String name, @NotNull QodanaInspectionProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)profile2), (String)"profile");
        super(name, profile2);
    }

    @Override
    @NotNull
    public NamedInspectionGroup.State createState(@NotNull QodanaGlobalInspectionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new State(context);
    }

    @Override
    @NotNull
    public SanityInspectionGroup applyConfig(@NotNull QodanaConfig config, @NotNull Project project, boolean addDefaultExclude) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.applyConfig(config, project, addDefaultExclude);
        List<QodanaScopeModifier> excludeModifiers = config.getExcludeModifiers(addDefaultExclude, project);
        if (excludeModifiers.isEmpty()) {
            return this;
        }
        QodanaInspectionProfileManager profileManager = QodanaInspectionProfileManager.Companion.getInstance(project);
        QodanaInspectionProfile newProfile = QodanaInspectionProfile.Companion.clone(this.getProfile(), "qodana.sanity.profile(base:" + this.getProfile().getName() + ")", profileManager);
        Iterable $this$forEach$iv = excludeModifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QodanaScopeModifier it = (QodanaScopeModifier)element$iv;
            boolean bl = false;
            it.updateProfileScopes(newProfile, project, config.getProjectPath());
        }
        return new SanityInspectionGroup(this.getName(), newProfile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup$Companion;", "", "<init>", "()V", "SANITY_FAILURE_NOTIFICATION", "", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;)V", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "thresholds", "Lorg/jetbrains/qodana/staticAnalysis/profile/Thresholds;", "shouldSkip", "", "inspectionId", "", "file", "Lcom/intellij/psi/PsiFile;", "wrappers", "Lcom/intellij/codeInspection/ex/EnabledInspectionsProvider$ToolWrappers;", "onConsumeProblem", "relativePath", "module", "onFinish", "", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup$State\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,188:1\n2163#2,2:189\n31#3,2:191\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/SanityInspectionGroup$State\n*L\n38#1:189,2\n53#1:191,2\n*E\n"})
    private final class State
    extends NamedInspectionGroup.State {
        @NotNull
        private final PathMacroManager macroManager;
        @NotNull
        private final Thresholds thresholds;

        public State(QodanaGlobalInspectionContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            super(context);
            PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)context.getProject()));
            Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
            this.macroManager = pathMacroManager;
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.thresholds = new Thresholds(project, context.getConfig());
        }

        @Override
        public boolean shouldSkip(@NotNull String inspectionId, @NotNull PsiFile file, @NotNull EnabledInspectionsProvider.ToolWrappers wrappers) {
            boolean bl;
            block2: {
                Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)wrappers, (String)"wrappers");
                QodanaProfile profile2 = this.getContext().getProfile();
                Sequence $this$none$iv = wrappers.getAllWrappers();
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    InspectionToolWrapper it = (InspectionToolWrapper)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)profile2.getIdToEffectiveGroup().get(it.getShortName()), (Object)profile2.getMainGroup())) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (bl) {
                return true;
            }
            String path = this.macroManager.collapsePath(file.getVirtualFile().getUrl());
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            String module2 = module != null ? module.getName() : null;
            return this.thresholds.isReached(inspectionId, path, module2);
        }

        @Override
        public boolean onConsumeProblem(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            boolean isThresholdReached = this.thresholds.addProblem(inspectionId, relativePath, module);
            if (isThresholdReached) {
                return false;
            }
            return super.onConsumeProblem(inspectionId, relativePath, module);
        }

        @Override
        public void onFinish() {
            Notification notification = this.thresholds.constructNotification();
            if (notification == null) {
                return;
            }
            Notification sanityNotification = notification;
            Project project = this.getContext().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RuntimeNotificationCollector> serviceClass$iv = RuntimeNotificationCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((RuntimeNotificationCollector)object).add(sanityNotification);
        }
    }
}

