/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.kotlin;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.qodana.inspectionKts.templates.InspectionKtsTemplateKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0003"}, d2={"templateKotlinInspectionKts", "", "filename", "intellij.qodana.inspectionKts.kotlin"})
public final class KotlinInspectionKtsTemplateProviderKt {
    private static final String templateKotlinInspectionKts(String filename) {
        String inspectionName = InspectionKtsTemplateKt.templateInspectionKtsFilenameToInspectionName(filename);
        String imports = "import org.jetbrains.kotlin.psi.KtClass\nimport org.jetbrains.kotlin.psi.KtNamedFunction\nimport org.jetbrains.kotlin.psi.KtProperty";
        String topComment = "/**\n * This is an auto-generated template Kotlin custom inspection\n * Reports all local variables inside all functions\n * Ignores methods of classes inheriting from class with some FQN\n *\n * The inspection is applied automatically and executed on-fly: to see the inspection results, open the Kotlin file in the editor\n */";
        String inspectionVisitorContent = StringsKt.trimIndent((String)("\n    val variableInFunctionInspection = localInspection { psiFile, inspection ->\n        // skip kts files\n        val isKts = psiFile.name.endsWith(\".kts\")\n        if (isKts) return@localInspection\n    \n        // get all functions in not ignored classes\n        val functions = psiFile.descendantsOfType<KtNamedFunction>()\n            .filter { function -> !isInIgnoredClass(function) }\n    \n        functions.forEach { function: KtNamedFunction ->\n            // get all variables declared in function\n            val variables = function.descendantsOfType<KtProperty>()\n            variables.forEach { variable: KtProperty ->\n                // get variable's type FQN\n                val variableTypeFqn = analyze(variable) {\n                    variable.returnType.expandedSymbol?.getFQN() ?: return@forEach\n                }\n                val declarationText = if (variable.isVar) \"var\" else \"val\"\n                val message = \"This is a variable ${variable.name} in function ${function.name} of type $variableTypeFqn declared as $declarationText. " + inspectionName + "\"\n                inspection.registerProblem(variable, message)\n            }\n        }\n    }\n    \n    // skip function in classes which inherit from class with some FQN\n    fun isInIgnoredClass(function: KtNamedFunction): Boolean {\n        if (function.isTopLevel) return false\n    \n        val fqnToIgnore = \"ignored.fully.qualified.name\"\n        val containingClass = function.parent?.parent as? KtClass ?: return false\n        analyze(containingClass) {\n            // check this class\n            val classSymbol = containingClass.classSymbol ?: return false\n            if (classSymbol.getFQN() == fqnToIgnore) {\n                return true\n            }\n    \n            // check supers\n            return classSymbol.superTypes.any { superType ->\n                val superClassSymbol = superType.expandedSymbol ?: return@any false\n                superClassSymbol.getFQN() == fqnToIgnore\n            }\n        }\n    }\n  "));
        return InspectionKtsTemplateKt.standardLocalInspectionKtsTemplateContent$default(filename, imports, topComment, null, inspectionVisitorContent, "variableInFunctionInspection", null, 72, null);
    }

    public static final /* synthetic */ String access$templateKotlinInspectionKts(String filename) {
        return KotlinInspectionKtsTemplateProviderKt.templateKotlinInspectionKts(filename);
    }
}

