/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.html.HtmlEnumeratedValueReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.xml.sax.Locator;

public final class RngXmlAttributeDescriptor
extends BasicXmlAttributeDescriptor {
    @NonNls
    private static final QName UNKNOWN = new QName("", "#unknown");
    private static final HashingStrategy<Locator> HASHING_STRATEGY = new HashingStrategy<Locator>(){

        public int hashCode(@Nullable Locator o) {
            if (o == null) {
                return 0;
            }
            String s = o.getSystemId();
            return o.getLineNumber() * 31 + o.getColumnNumber() * 23 + (s != null ? s.hashCode() * 11 : 0);
        }

        public boolean equals(@Nullable Locator o, @Nullable Locator o1) {
            if (o == o1) {
                return true;
            }
            if (o == null || o1 == null) {
                return false;
            }
            return o.getLineNumber() == o1.getLineNumber() && o.getColumnNumber() == o1.getColumnNumber() && Objects.equals(o.getSystemId(), o1.getSystemId());
        }
    };
    private final Map<String, String> myValues;
    private final boolean myOptional;
    private final RngElementDescriptor myElementDescriptor;
    private final Set<Locator> myDeclarations = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
    private final QName myName;

    RngXmlAttributeDescriptor(RngElementDescriptor elementDescriptor, DAttributePattern pattern, Map<String, String> values, boolean optional) {
        this(elementDescriptor, RngXmlAttributeDescriptor.getName(pattern), values, optional, pattern.getLocation());
    }

    private static QName getName(DAttributePattern pattern) {
        Iterator<QName> iterator = pattern.getName().listNames().iterator();
        return iterator.hasNext() ? iterator.next() : UNKNOWN;
    }

    private RngXmlAttributeDescriptor(RngElementDescriptor elementDescriptor, QName name, Map<String, String> values, boolean optional, Locator ... locations) {
        this.myElementDescriptor = elementDescriptor;
        this.myValues = values;
        this.myOptional = optional;
        this.myName = name;
        this.myDeclarations.addAll(Arrays.asList(locations));
    }

    public RngXmlAttributeDescriptor mergeWith(RngXmlAttributeDescriptor d) {
        QName name = d.myName.equals(UNKNOWN) ? this.myName : d.myName;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>(this.myValues);
        values.putAll(d.myValues);
        Set locations = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
        locations.addAll(this.myDeclarations);
        locations.addAll(d.myDeclarations);
        return new RngXmlAttributeDescriptor(this.myElementDescriptor, name, values, this.myOptional || d.myOptional, locations.toArray(new Locator[0]));
    }

    public boolean isRequired() {
        return !this.myOptional;
    }

    @Override
    public boolean isFixed() {
        return this.isEnumerated() && this.myValues.size() == 1;
    }

    public boolean hasIdType() {
        return this.myValues.containsValue("ID");
    }

    public boolean hasIdRefType() {
        return this.myValues.containsValue("IDREF");
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.isFixed() ? this.myValues.keySet().iterator().next() : null;
    }

    public boolean isEnumerated() {
        return !this.myValues.isEmpty() && this.myValues.get(null) == null;
    }

    @Override
    public String[] getEnumeratedValues() {
        if (!this.myValues.isEmpty()) {
            Map<String, String> copy;
            if (this.myValues.get(null) != null) {
                copy = new HashMap<String, String>(this.myValues);
                copy.remove(null);
            } else {
                copy = this.myValues;
            }
            return ArrayUtilRt.toStringArray(copy.keySet());
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public PsiElement getDeclaration() {
        Iterator<Locator> it = this.myDeclarations.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return this.myElementDescriptor.getDeclaration(it.next());
    }

    @NotNull
    public Collection<PsiElement> getDeclarations() {
        List list2 = ContainerUtil.map(this.myDeclarations, locator -> this.myElementDescriptor.getDeclaration((Locator)locator));
        if (list2 == null) {
            RngXmlAttributeDescriptor.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public String getName(PsiElement context) {
        String prefix2;
        String uri;
        String prefix;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false, (Class[])new Class[]{PsiFile.class});
        if (tag != null && (prefix = tag.getPrefixByNamespace(uri = this.myName.getNamespaceURI())) != null) {
            if (prefix.isEmpty()) {
                return this.myName.getLocalPart();
            }
            return prefix + ":" + this.myName.getLocalPart();
        }
        if (!this.myName.getNamespaceURI().isEmpty() && (prefix2 = this.myName.getPrefix()) != null && !prefix2.isEmpty()) {
            return prefix2 + ":" + this.myName.getLocalPart();
        }
        return this.myName.getLocalPart();
    }

    @NonNls
    public String getName() {
        return this.myName.getLocalPart();
    }

    public void init(PsiElement element) {
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myElementDescriptor.getDependencies();
        if (objectArray == null) {
            RngXmlAttributeDescriptor.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @Override
    public String validateValue(XmlElement context, String value) {
        if (this.isTokenDatatype(value)) {
            value = RngXmlAttributeDescriptor.normalizeSpace(value);
        }
        return super.validateValue(context, value);
    }

    private boolean isTokenDatatype(String value) {
        if (this.myValues.containsKey(value)) {
            return "token".equals(this.myValues.get(value));
        }
        return this.myValues.containsKey(value = RngXmlAttributeDescriptor.normalizeSpace(value)) && "token".equals(this.myValues.get(value));
    }

    private static String normalizeSpace(String value) {
        return value.replaceAll("\\s+", " ").trim();
    }

    public PsiReference[] getValueReferences(XmlElement element, @NotNull String text) {
        if (text == null) {
            RngXmlAttributeDescriptor.$$$reportNull$$$0(2);
        }
        if (element.getContainingFile() instanceof HtmlCompatibleFile) {
            return new PsiReference[]{new HtmlEnumeratedValueReference(element, this, null){

                @Override
                @Nullable
                public PsiElement resolve() {
                    if (RngXmlAttributeDescriptor.this.isTokenDatatype(this.getValue())) {
                        return this.getElement();
                    }
                    return super.resolve();
                }
            }};
        }
        return new PsiReference[]{new XmlEnumeratedValueReference(element, this){

            @Override
            @Nullable
            public PsiElement resolve() {
                if (RngXmlAttributeDescriptor.this.isTokenDatatype(this.getValue())) {
                    return this.getElement();
                }
                return super.resolve();
            }
        }};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngXmlAttributeDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/descriptors/RngXmlAttributeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValueReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

