/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.poetry.PoetryFilesUtilsKt;
import com.jetbrains.python.sdk.poetry.PoetryVersionValue;
import com.jetbrains.python.sdk.poetry.VersionType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0010\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\u000b\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\n0\t2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R9\u0010\b\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\u000b\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPythonVersion;", "", "stringVersion", "", "<init>", "(Ljava/lang/String;)V", "getStringVersion", "()Ljava/lang/String;", "descriptions", "", "Lkotlin/Pair;", "Lcom/jetbrains/python/sdk/poetry/VersionType;", "Lkotlin/Triple;", "", "getDescriptions", "()Ljava/util/List;", "parseVersion", "versionString", "isValid", "", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "component1", "copy", "equals", "other", "hashCode", "toString", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPoetryFilesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoetryFilesUtils.kt\ncom/jetbrains/python/sdk/poetry/PoetryPythonVersion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n158#2,6:282\n1#3:288\n*S KotlinDebug\n*F\n+ 1 PoetryFilesUtils.kt\ncom/jetbrains/python/sdk/poetry/PoetryPythonVersion\n*L\n229#1:282,6\n*E\n"})
public final class PoetryPythonVersion {
    @NotNull
    private final String stringVersion;
    @NotNull
    private final List<Pair<VersionType, Triple<Integer, Integer, Integer>>> descriptions;

    public PoetryPythonVersion(@NotNull String stringVersion) {
        Intrinsics.checkNotNullParameter((Object)stringVersion, (String)"stringVersion");
        this.stringVersion = stringVersion;
        this.descriptions = this.parseVersion(this.stringVersion);
    }

    @NotNull
    public final String getStringVersion() {
        return this.stringVersion;
    }

    @NotNull
    public final List<Pair<VersionType, Triple<Integer, Integer, Integer>>> getDescriptions() {
        return this.descriptions;
    }

    private final List<Pair<VersionType, Triple<Integer, Integer, Integer>>> parseVersion(String versionString) {
        if (((CharSequence)versionString).length() == 0) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{","};
        List versionParts = StringsKt.split$default((CharSequence)versionString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        List result2 = new ArrayList();
        for (String part : versionParts) {
            VersionType type2;
            Triple versionTriple;
            int firstDigit;
            int n;
            block4: {
                CharSequence $this$indexOfFirst$iv = part;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!Character.isDigit(it)) continue;
                    n = index$iv;
                    break block4;
                }
                n = -1;
            }
            if ((firstDigit = n) == -1) continue;
            String string = part.substring(0, firstDigit);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (VersionType.Companion.getVersionType(((Object)StringsKt.trim((CharSequence)string)).toString()) == null) continue;
            String string2 = part.substring(firstDigit);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String version2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Object it = PoetryVersionValue.Companion.create-IoAF18A(version2);
            PoetryVersionValue poetryVersionValue = (PoetryVersionValue)(Result.isFailure-impl((Object)it) ? null : it);
            Object object = poetryVersionValue != null ? poetryVersionValue.unbox-impl() : null;
            if (object == null) {
                object = null;
            }
            Triple triple = versionTriple = object;
            if (triple == null) continue;
            it = triple;
            boolean bl = false;
            result2.add(new Pair((Object)type2, (Object)versionTriple));
        }
        return result2;
    }

    public final boolean isValid(@Nullable String versionString) {
        Triple baseInterpreterVersion;
        block16: {
            block15: {
                boolean bl;
                CharSequence charSequence = versionString;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return false;
                }
                Object object = PoetryVersionValue.Companion.create-IoAF18A(versionString);
                PoetryVersionValue poetryVersionValue = (PoetryVersionValue)(Result.isFailure-impl((Object)object) ? null : object);
                Object object2 = poetryVersionValue != null ? poetryVersionValue.unbox-impl() : null;
                if (object2 == null) {
                    return false;
                }
                baseInterpreterVersion = object2;
                if (((Number)baseInterpreterVersion.getFirst()).intValue() < 3) break block15;
                if (((Number)baseInterpreterVersion.getFirst()).intValue() != 3) break block16;
                Integer n = (Integer)baseInterpreterVersion.getSecond();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    bl = it < 6;
                } else {
                    bl = false;
                }
                if (!bl) break block16;
            }
            return false;
        }
        block7: for (Pair<VersionType, Triple<Integer, Integer, Integer>> description : this.descriptions) {
            VersionType type2 = (VersionType)((Object)description.getFirst());
            int compareResult = PoetryFilesUtilsKt.access$compare(baseInterpreterVersion, description);
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    if (compareResult < 0) continue block7;
                    return false;
                }
                case 2: {
                    if (compareResult <= 0) continue block7;
                    return false;
                }
                case 3: {
                    if (compareResult == 0) continue block7;
                    return false;
                }
                case 4: {
                    if (compareResult >= 0) continue block7;
                    return false;
                }
                case 5: {
                    if (compareResult > 0) continue block7;
                    return false;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    public final boolean isValid(@NotNull LanguageLevel languageLevel) {
        Intrinsics.checkNotNullParameter((Object)languageLevel, (String)"languageLevel");
        String string = languageLevel.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String languageLevelString = string;
        return this.isValid(languageLevelString);
    }

    @NotNull
    public final String component1() {
        return this.stringVersion;
    }

    @NotNull
    public final PoetryPythonVersion copy(@NotNull String stringVersion) {
        Intrinsics.checkNotNullParameter((Object)stringVersion, (String)"stringVersion");
        return new PoetryPythonVersion(stringVersion);
    }

    public static /* synthetic */ PoetryPythonVersion copy$default(PoetryPythonVersion poetryPythonVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = poetryPythonVersion.stringVersion;
        }
        return poetryPythonVersion.copy(string);
    }

    @NotNull
    public String toString() {
        return "PoetryPythonVersion(stringVersion=" + this.stringVersion + ")";
    }

    public int hashCode() {
        return this.stringVersion.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PoetryPythonVersion)) {
            return false;
        }
        PoetryPythonVersion poetryPythonVersion = (PoetryPythonVersion)other;
        return Intrinsics.areEqual((Object)this.stringVersion, (Object)poetryPythonVersion.stringVersion);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VersionType.values().length];
            try {
                nArray[VersionType.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionType.LESS_OR_EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionType.EQUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionType.MORE_OR_EQUAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionType.MORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

