/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.terraform.correctness;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricherBase;
import com.intellij.ml.inline.completion.terraform.correctness.TfInspectionBasedChecker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.config.inspection.TfDuplicatedBlockPropertyInspection;
import org.intellij.terraform.config.inspection.TfDuplicatedOutputInspection;
import org.intellij.terraform.config.inspection.TfIncorrectVariableTypeInspection;
import org.intellij.terraform.config.inspection.TfUnknownPropertyInspection;
import org.intellij.terraform.hil.inspection.HILUnresolvedReferenceInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/terraform/correctness/TfSuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricherBase;", "<init>", "()V", "inspectInjectedPsi", "", "getInspectInjectedPsi", "()Z", "buildFileWithSuggestion", "Lcom/intellij/psi/PsiFile;", "originalFile", "suggestionOffset", "", "suggestion", "", "suffix", "matchedEnclosuresIndices", "", "intellij.fullLine.terraform"})
@SourceDebugExtension(value={"SMAP\nTfSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/terraform/correctness/TfSuggestionEnricher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class TfSuggestionEnricher
extends SuggestionEnricherBase {
    private final boolean inspectInjectedPsi;

    public TfSuggestionEnricher() {
        Object[] objectArray = new TfInspectionBasedChecker[]{new TfInspectionBasedChecker((LocalInspectionTool)new TfDuplicatedBlockPropertyInspection()), new TfInspectionBasedChecker((LocalInspectionTool)new TfDuplicatedOutputInspection()), new TfInspectionBasedChecker((LocalInspectionTool)new TfIncorrectVariableTypeInspection()), new TfInspectionBasedChecker((LocalInspectionTool)new TfUnknownPropertyInspection()), new TfInspectionBasedChecker((LocalInspectionTool)new HILUnresolvedReferenceInspection())};
        super(CollectionsKt.listOf((Object[])objectArray));
        this.inspectInjectedPsi = true;
    }

    @Override
    protected boolean getInspectInjectedPsi() {
        return this.inspectInjectedPsi;
    }

    @Override
    @NotNull
    protected PsiFile buildFileWithSuggestion(@NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull String suffix, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Set<Integer> set = matchedEnclosuresIndices;
        int matchedSize = set != null ? set.size() : 0;
        String it = originalFile.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String text2 = StringsKt.take((String)it, (int)suggestionOffset) + suggestion2 + " " + StringsKt.drop((String)it, (int)(suggestionOffset + matchedSize));
        PsiFileFactory psiFileFactory = PsiFileFactoryImpl.getInstance((Project)originalFile.getProject());
        Intrinsics.checkNotNull((Object)psiFileFactory, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        PsiFile psiFile2 = ((PsiFileFactoryImpl)psiFileFactory).createFileFromText(originalFile.getName(), (FileType)TerraformFileType.INSTANCE, (Language)TerraformLanguage.INSTANCE, (Language)TerraformLanguage.INSTANCE, (CharSequence)text2, System.currentTimeMillis(), true, true);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"createFileFromText(...)");
        return psiFile2;
    }
}

