/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEventListener;
import com.intellij.ml.inline.completion.impl.diagnostic.TextMessage;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "errorIfNotMessage", "", "throwable", "", "error", "text", "", "debug", "info", "warn", "sendTextMessage", "intellij.fullLine.core.completion"})
public final class MLCompletionLogger {
    @NotNull
    private final Logger log;

    public MLCompletionLogger(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
    }

    public final void errorIfNotMessage(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (Promises.errorIfNotMessage((Logger)this.log, (Throwable)throwable)) {
            this.sendTextMessage(throwable.toString());
        }
    }

    public final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.error(throwable);
        this.sendTextMessage(throwable.toString());
    }

    public final void error(@NotNull String text2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.error(text2, throwable);
        this.sendTextMessage(text2);
    }

    public final void debug(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.debug(text2);
        this.sendTextMessage(text2);
    }

    public final void info(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.info(text2);
        this.sendTextMessage(text2);
    }

    public final void warn(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.log.warn(text2);
        this.sendTextMessage(text2);
    }

    public final void warn(@NotNull String text2, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.log.warn(text2, throwable);
        this.sendTextMessage(text2);
    }

    private final void sendTextMessage(String text2) {
        if (!DiagnosticLoggersKt.access$getDispatcher$p().hasListeners()) {
            return;
        }
        TextMessage message = new TextMessage(text2, System.currentTimeMillis());
        ((MLCompletionEventListener)DiagnosticLoggersKt.access$getDispatcher$p().getMulticaster()).onEvent(message);
    }
}

