pub const ext = @import("ext.zig");
const gtk = @This();

const std = @import("std");
const compat = @import("compat");
const gsk = @import("gsk4");
const graphene = @import("graphene1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gdk = @import("gdk4");
const cairo = @import("cairo1");
const pangocairo = @import("pangocairo1");
const pango = @import("pango1");
const harfbuzz = @import("harfbuzz0");
const freetype2 = @import("freetype22");
const gio = @import("gio2");
const gmodule = @import("gmodule2");
const gdkpixbuf = @import("gdkpixbuf2");
/// The rectangle representing the area allocated for a widget by its parent.
pub const Allocation = gdk.Rectangle;

/// `GtkATContext` is an abstract class provided by GTK to communicate to
/// platform-specific assistive technologies API.
///
/// Each platform supported by GTK implements a `GtkATContext` subclass, and
/// is responsible for updating the accessible state in response to state
/// changes in `GtkAccessible`.
pub const ATContext = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.ATContextClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GtkAccessible` that created the `GtkATContext` instance.
        pub const accessible = struct {
            pub const name = "accessible";

            pub const Type = ?*gtk.Accessible;
        };

        /// The accessible role used by the AT context.
        ///
        /// Depending on the given role, different states and properties can be
        /// set or retrieved.
        pub const accessible_role = struct {
            pub const name = "accessible-role";

            pub const Type = gtk.AccessibleRole;
        };

        /// The `GdkDisplay` for the `GtkATContext`.
        pub const display = struct {
            pub const name = "display";

            pub const Type = ?*gdk.Display;
        };
    };

    pub const signals = struct {
        /// Emitted when the attributes of the accessible for the
        /// `GtkATContext` instance change.
        pub const state_change = struct {
            pub const name = "state-change";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ATContext, p_instance))),
                    gobject.signalLookup("state-change", ATContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkATContext` instance for the given accessible role,
    /// accessible instance, and display connection.
    ///
    /// The `GtkATContext` implementation being instantiated will depend on the
    /// platform.
    extern fn gtk_at_context_create(p_accessible_role: gtk.AccessibleRole, p_accessible: *gtk.Accessible, p_display: *gdk.Display) ?*gtk.ATContext;
    pub const create = gtk_at_context_create;

    /// Retrieves the `GtkAccessible` using this context.
    extern fn gtk_at_context_get_accessible(p_self: *ATContext) *gtk.Accessible;
    pub const getAccessible = gtk_at_context_get_accessible;

    /// Retrieves the accessible role of this context.
    extern fn gtk_at_context_get_accessible_role(p_self: *ATContext) gtk.AccessibleRole;
    pub const getAccessibleRole = gtk_at_context_get_accessible_role;

    extern fn gtk_at_context_get_type() usize;
    pub const getGObjectType = gtk_at_context_get_type;

    extern fn g_object_ref(p_self: *gtk.ATContext) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ATContext) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ATContext, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkAboutDialog` offers a simple way to display information about
/// a program.
///
/// The shown information includes the programs' logo, name, copyright,
/// website and license. It is also possible to give credits to the authors,
/// documenters, translators and artists who have worked on the program.
///
/// An about dialog is typically opened when the user selects the `About`
/// option from the `Help` menu. All parts of the dialog are optional.
///
/// ![An example GtkAboutDialog](aboutdialog.png)
///
/// About dialogs often contain links and email addresses. `GtkAboutDialog`
/// displays these as clickable links. By default, it calls `gtk.FileLauncher.launch`
/// when a user clicks one. The behaviour can be overridden with the
/// `gtk.AboutDialog.signals.activate_link` signal.
///
/// To specify a person with an email address, use a string like
/// `Edgar Allan Poe <edgar`poe`.com>`. To specify a website with a title,
/// use a string like `GTK team https://www.gtk.org`.
///
/// To make constructing a `GtkAboutDialog` as convenient as possible, you can
/// use the function `gtk.showAboutDialog` which constructs and shows
/// a dialog and keeps it around so that it can be shown again.
///
/// Note that GTK sets a default title of `_("About `s`")` on the dialog
/// window (where ``s`` is replaced by the name of the application, but in
/// order to ensure proper translation of the title, applications should
/// set the title property explicitly when constructing a `GtkAboutDialog`,
/// as shown in the following example:
///
/// ```c
/// GFile *logo_file = g_file_new_for_path ("./logo.png");
/// GdkTexture *example_logo = gdk_texture_new_from_file (logo_file, NULL);
/// g_object_unref (logo_file);
///
/// gtk_show_about_dialog (NULL,
///                        "program-name", "ExampleCode",
///                        "logo", example_logo,
///                        "title", _("About ExampleCode"),
///                        NULL);
/// ```
///
/// ## Shortcuts and Gestures
///
/// `GtkAboutDialog` supports the following keyboard shortcuts:
///
/// - <kbd>Escape</kbd> closes the window.
///
/// ## CSS nodes
///
/// `GtkAboutDialog` has a single CSS node with the name `window` and style
/// class `.aboutdialog`.
pub const AboutDialog = opaque {
    pub const Parent = gtk.Window;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = opaque {
        pub const Instance = AboutDialog;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The people who contributed artwork to the program, as a `NULL`-terminated
        /// array of strings.
        ///
        /// Each string may contain email addresses and URLs, which will be displayed
        /// as links.
        pub const artists = struct {
            pub const name = "artists";

            pub const Type = ?[*][*:0]u8;
        };

        /// The authors of the program, as a `NULL`-terminated array of strings.
        ///
        /// Each string may contain email addresses and URLs, which will be displayed
        /// as links, see the introduction for more details.
        pub const authors = struct {
            pub const name = "authors";

            pub const Type = ?[*][*:0]u8;
        };

        /// Comments about the program.
        ///
        /// This string is displayed in a label in the main dialog, thus it
        /// should be a short explanation of the main purpose of the program,
        /// not a detailed list of features.
        pub const comments = struct {
            pub const name = "comments";

            pub const Type = ?[*:0]u8;
        };

        /// Copyright information for the program.
        pub const copyright = struct {
            pub const name = "copyright";

            pub const Type = ?[*:0]u8;
        };

        /// The people documenting the program, as a `NULL`-terminated array of strings.
        ///
        /// Each string may contain email addresses and URLs, which will be displayed
        /// as links, see the introduction for more details.
        pub const documenters = struct {
            pub const name = "documenters";

            pub const Type = ?[*][*:0]u8;
        };

        /// The license of the program, as free-form text.
        ///
        /// This string is displayed in a text view in a secondary dialog, therefore
        /// it is fine to use a long multi-paragraph text. Note that the text is only
        /// wrapped in the text view if the "wrap-license" property is set to `TRUE`;
        /// otherwise the text itself must contain the intended linebreaks.
        ///
        /// When setting this property to a non-`NULL` value, the
        /// `gtk.AboutDialog.properties.license_type` property is set to
        /// `GTK_LICENSE_CUSTOM` as a side effect.
        ///
        /// The text may contain links in this format `<http://www.some.place/>`
        /// and email references in the form `<mail-to`some`.body>`, and these will
        /// be converted into clickable links.
        pub const license = struct {
            pub const name = "license";

            pub const Type = ?[*:0]u8;
        };

        /// The license of the program.
        ///
        /// The `GtkAboutDialog` will automatically fill out a standard disclaimer
        /// and link the user to the appropriate online resource for the license
        /// text.
        ///
        /// If `GTK_LICENSE_UNKNOWN` is used, the link used will be the same
        /// specified in the `gtk.AboutDialog.properties.website` property.
        ///
        /// If `GTK_LICENSE_CUSTOM` is used, the current contents of the
        /// `gtk.AboutDialog.properties.license` property are used.
        ///
        /// For any other `gtk.License` value, the contents of the
        /// `gtk.AboutDialog.properties.license` property are also set by this property as
        /// a side effect.
        pub const license_type = struct {
            pub const name = "license-type";

            pub const Type = gtk.License;
        };

        /// A logo for the about box.
        ///
        /// If it is `NULL`, the default window icon set with
        /// `gtk.Window.setDefaultIconName` will be used.
        pub const logo = struct {
            pub const name = "logo";

            pub const Type = ?*gdk.Paintable;
        };

        /// A named icon to use as the logo for the about box.
        ///
        /// This property overrides the `gtk.AboutDialog.properties.logo` property.
        pub const logo_icon_name = struct {
            pub const name = "logo-icon-name";

            pub const Type = ?[*:0]u8;
        };

        /// The name of the program.
        ///
        /// If this is not set, it defaults to the value returned by
        /// ``glib.getApplicationName``.
        pub const program_name = struct {
            pub const name = "program-name";

            pub const Type = ?[*:0]u8;
        };

        /// Information about the system on which the program is running.
        ///
        /// This information is displayed in a separate page, therefore it is fine
        /// to use a long multi-paragraph text. Note that the text should contain
        /// the intended linebreaks.
        ///
        /// The text may contain links in this format `<http://www.some.place/>`
        /// and email references in the form `<mail-to`some`.body>`, and these will
        /// be converted into clickable links.
        pub const system_information = struct {
            pub const name = "system-information";

            pub const Type = ?[*:0]u8;
        };

        /// Credits to the translators.
        ///
        /// This string should be marked as translatable.
        ///
        /// The string may contain email addresses and URLs, which will be displayed
        /// as links, see the introduction for more details.
        pub const translator_credits = struct {
            pub const name = "translator-credits";

            pub const Type = ?[*:0]u8;
        };

        /// The version of the program.
        pub const version = struct {
            pub const name = "version";

            pub const Type = ?[*:0]u8;
        };

        /// The URL for the link to the website of the program.
        ///
        /// This should be a string starting with `http://` or `https://`.
        pub const website = struct {
            pub const name = "website";

            pub const Type = ?[*:0]u8;
        };

        /// The label for the link to the website of the program.
        pub const website_label = struct {
            pub const name = "website-label";

            pub const Type = ?[*:0]u8;
        };

        /// Whether to wrap the text in the license dialog.
        pub const wrap_license = struct {
            pub const name = "wrap-license";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted every time a URL is activated.
        ///
        /// Applications may connect to it to override the default behaviour,
        /// which is to call `gtk.FileLauncher.launch`.
        pub const activate_link = struct {
            pub const name = "activate-link";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_uri: [*:0]u8, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AboutDialog, p_instance))),
                    gobject.signalLookup("activate-link", AboutDialog.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkAboutDialog`.
    extern fn gtk_about_dialog_new() *gtk.AboutDialog;
    pub const new = gtk_about_dialog_new;

    /// Creates a new section in the "Credits" page.
    extern fn gtk_about_dialog_add_credit_section(p_about: *AboutDialog, p_section_name: [*:0]const u8, p_people: [*][*:0]const u8) void;
    pub const addCreditSection = gtk_about_dialog_add_credit_section;

    /// Returns the names of the artists which are displayed
    /// in the credits page.
    extern fn gtk_about_dialog_get_artists(p_about: *AboutDialog) [*]const [*:0]const u8;
    pub const getArtists = gtk_about_dialog_get_artists;

    /// Returns the names of the authors which are displayed
    /// in the credits page.
    extern fn gtk_about_dialog_get_authors(p_about: *AboutDialog) [*]const [*:0]const u8;
    pub const getAuthors = gtk_about_dialog_get_authors;

    /// Returns the comments string.
    extern fn gtk_about_dialog_get_comments(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getComments = gtk_about_dialog_get_comments;

    /// Returns the copyright string.
    extern fn gtk_about_dialog_get_copyright(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getCopyright = gtk_about_dialog_get_copyright;

    /// Returns the name of the documenters which are displayed
    /// in the credits page.
    extern fn gtk_about_dialog_get_documenters(p_about: *AboutDialog) [*]const [*:0]const u8;
    pub const getDocumenters = gtk_about_dialog_get_documenters;

    /// Returns the license information.
    extern fn gtk_about_dialog_get_license(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getLicense = gtk_about_dialog_get_license;

    /// Retrieves the license type.
    extern fn gtk_about_dialog_get_license_type(p_about: *AboutDialog) gtk.License;
    pub const getLicenseType = gtk_about_dialog_get_license_type;

    /// Returns the paintable displayed as logo in the about dialog.
    extern fn gtk_about_dialog_get_logo(p_about: *AboutDialog) ?*gdk.Paintable;
    pub const getLogo = gtk_about_dialog_get_logo;

    /// Returns the icon name displayed as logo in the about dialog.
    extern fn gtk_about_dialog_get_logo_icon_name(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getLogoIconName = gtk_about_dialog_get_logo_icon_name;

    /// Returns the program name displayed in the about dialog.
    extern fn gtk_about_dialog_get_program_name(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getProgramName = gtk_about_dialog_get_program_name;

    /// Returns the system information that is shown in the about dialog.
    extern fn gtk_about_dialog_get_system_information(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getSystemInformation = gtk_about_dialog_get_system_information;

    /// Returns the translator credits string which is displayed
    /// in the credits page.
    extern fn gtk_about_dialog_get_translator_credits(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getTranslatorCredits = gtk_about_dialog_get_translator_credits;

    /// Returns the version string.
    extern fn gtk_about_dialog_get_version(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getVersion = gtk_about_dialog_get_version;

    /// Returns the website URL.
    extern fn gtk_about_dialog_get_website(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getWebsite = gtk_about_dialog_get_website;

    /// Returns the label used for the website link.
    extern fn gtk_about_dialog_get_website_label(p_about: *AboutDialog) ?[*:0]const u8;
    pub const getWebsiteLabel = gtk_about_dialog_get_website_label;

    /// Returns whether the license text in the about dialog is
    /// automatically wrapped.
    extern fn gtk_about_dialog_get_wrap_license(p_about: *AboutDialog) c_int;
    pub const getWrapLicense = gtk_about_dialog_get_wrap_license;

    /// Sets the names of the artists to be displayed
    /// in the "Credits" page.
    extern fn gtk_about_dialog_set_artists(p_about: *AboutDialog, p_artists: [*][*:0]const u8) void;
    pub const setArtists = gtk_about_dialog_set_artists;

    /// Sets the names of the authors which are displayed
    /// in the "Credits" page of the about dialog.
    extern fn gtk_about_dialog_set_authors(p_about: *AboutDialog, p_authors: [*][*:0]const u8) void;
    pub const setAuthors = gtk_about_dialog_set_authors;

    /// Sets the comments string to display in the about dialog.
    ///
    /// This should be a short string of one or two lines.
    extern fn gtk_about_dialog_set_comments(p_about: *AboutDialog, p_comments: ?[*:0]const u8) void;
    pub const setComments = gtk_about_dialog_set_comments;

    /// Sets the copyright string to display in the about dialog.
    ///
    /// This should be a short string of one or two lines.
    extern fn gtk_about_dialog_set_copyright(p_about: *AboutDialog, p_copyright: ?[*:0]const u8) void;
    pub const setCopyright = gtk_about_dialog_set_copyright;

    /// Sets the names of the documenters which are displayed
    /// in the "Credits" page.
    extern fn gtk_about_dialog_set_documenters(p_about: *AboutDialog, p_documenters: [*][*:0]const u8) void;
    pub const setDocumenters = gtk_about_dialog_set_documenters;

    /// Sets the license information to be displayed in the
    /// about dialog.
    ///
    /// If `license` is `NULL`, the license page is hidden.
    extern fn gtk_about_dialog_set_license(p_about: *AboutDialog, p_license: ?[*:0]const u8) void;
    pub const setLicense = gtk_about_dialog_set_license;

    /// Sets the license of the application showing the about dialog from a
    /// list of known licenses.
    ///
    /// This function overrides the license set using
    /// `gtk.AboutDialog.setLicense`.
    extern fn gtk_about_dialog_set_license_type(p_about: *AboutDialog, p_license_type: gtk.License) void;
    pub const setLicenseType = gtk_about_dialog_set_license_type;

    /// Sets the logo in the about dialog.
    extern fn gtk_about_dialog_set_logo(p_about: *AboutDialog, p_logo: ?*gdk.Paintable) void;
    pub const setLogo = gtk_about_dialog_set_logo;

    /// Sets the icon name to be displayed as logo in the about dialog.
    extern fn gtk_about_dialog_set_logo_icon_name(p_about: *AboutDialog, p_icon_name: ?[*:0]const u8) void;
    pub const setLogoIconName = gtk_about_dialog_set_logo_icon_name;

    /// Sets the name to display in the about dialog.
    ///
    /// If `name` is not set, the string returned
    /// by ``glib.getApplicationName`` is used.
    extern fn gtk_about_dialog_set_program_name(p_about: *AboutDialog, p_name: ?[*:0]const u8) void;
    pub const setProgramName = gtk_about_dialog_set_program_name;

    /// Sets the system information to be displayed in the about
    /// dialog.
    ///
    /// If `system_information` is `NULL`, the system information
    /// page is hidden.
    ///
    /// See `gtk.AboutDialog.properties.system_information`.
    extern fn gtk_about_dialog_set_system_information(p_about: *AboutDialog, p_system_information: ?[*:0]const u8) void;
    pub const setSystemInformation = gtk_about_dialog_set_system_information;

    /// Sets the translator credits string which is displayed in
    /// the credits page.
    ///
    /// The intended use for this string is to display the translator
    /// of the language which is currently used in the user interface.
    /// Using ``gettext``, a simple way to achieve that is to mark the
    /// string for translation:
    ///
    /// ```c
    /// GtkWidget *about = gtk_about_dialog_new ();
    ///  gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG (about),
    ///                                           _("translator-credits"));
    /// ```
    ///
    /// It is a good idea to use the customary `msgid` “translator-credits”
    /// for this purpose, since translators will already know the purpose of
    /// that `msgid`, and since `GtkAboutDialog` will detect if “translator-credits”
    /// is untranslated and omit translator credits.
    extern fn gtk_about_dialog_set_translator_credits(p_about: *AboutDialog, p_translator_credits: ?[*:0]const u8) void;
    pub const setTranslatorCredits = gtk_about_dialog_set_translator_credits;

    /// Sets the version string to display in the about dialog.
    extern fn gtk_about_dialog_set_version(p_about: *AboutDialog, p_version: ?[*:0]const u8) void;
    pub const setVersion = gtk_about_dialog_set_version;

    /// Sets the URL to use for the website link.
    extern fn gtk_about_dialog_set_website(p_about: *AboutDialog, p_website: ?[*:0]const u8) void;
    pub const setWebsite = gtk_about_dialog_set_website;

    /// Sets the label to be used for the website link.
    extern fn gtk_about_dialog_set_website_label(p_about: *AboutDialog, p_website_label: [*:0]const u8) void;
    pub const setWebsiteLabel = gtk_about_dialog_set_website_label;

    /// Sets whether the license text in the about dialog should be
    /// automatically wrapped.
    extern fn gtk_about_dialog_set_wrap_license(p_about: *AboutDialog, p_wrap_license: c_int) void;
    pub const setWrapLicense = gtk_about_dialog_set_wrap_license;

    extern fn gtk_about_dialog_get_type() usize;
    pub const getGObjectType = gtk_about_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.AboutDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AboutDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AboutDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkActionBar` is designed to present contextual actions.
///
/// ![An example GtkActionBar](action-bar.png)
///
/// It is expected to be displayed below the content and expand
/// horizontally to fill the area.
///
/// It allows placing children at the start or the end. In addition, it
/// contains an internal centered box which is centered with respect to
/// the full width of the box, even if the children at either side take
/// up different amounts of space.
///
/// # GtkActionBar as GtkBuildable
///
/// The `GtkActionBar` implementation of the `GtkBuildable` interface supports
/// adding children at the start or end sides by specifying “start” or “end” as
/// the “type” attribute of a `<child>` element, or setting the center widget
/// by specifying “center” value.
///
/// # CSS nodes
///
/// ```
/// actionbar
/// ╰── revealer
///     ╰── box
///         ├── box.start
///         │   ╰── [start children]
///         ├── [center widget]
///         ╰── box.end
///             ╰── [end children]
/// ```
///
/// A `GtkActionBar`'s CSS node is called `actionbar`. It contains a `revealer`
/// subnode, which contains a `box` subnode, which contains two `box` subnodes at
/// the start and end of the action bar, with `start` and `end style classes
/// respectively, as well as a center node that represents the center child.
///
/// Each of the boxes contains children packed for that side.
pub const ActionBar = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = ActionBar;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Controls whether the action bar shows its contents.
        pub const revealed = struct {
            pub const name = "revealed";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkActionBar` widget.
    extern fn gtk_action_bar_new() *gtk.ActionBar;
    pub const new = gtk_action_bar_new;

    /// Retrieves the center bar widget of the bar.
    extern fn gtk_action_bar_get_center_widget(p_action_bar: *ActionBar) ?*gtk.Widget;
    pub const getCenterWidget = gtk_action_bar_get_center_widget;

    /// Gets whether the contents of the action bar are revealed.
    extern fn gtk_action_bar_get_revealed(p_action_bar: *ActionBar) c_int;
    pub const getRevealed = gtk_action_bar_get_revealed;

    /// Adds `child` to `action_bar`, packed with reference to the
    /// end of the `action_bar`.
    extern fn gtk_action_bar_pack_end(p_action_bar: *ActionBar, p_child: *gtk.Widget) void;
    pub const packEnd = gtk_action_bar_pack_end;

    /// Adds `child` to `action_bar`, packed with reference to the
    /// start of the `action_bar`.
    extern fn gtk_action_bar_pack_start(p_action_bar: *ActionBar, p_child: *gtk.Widget) void;
    pub const packStart = gtk_action_bar_pack_start;

    /// Removes a child from `action_bar`.
    extern fn gtk_action_bar_remove(p_action_bar: *ActionBar, p_child: *gtk.Widget) void;
    pub const remove = gtk_action_bar_remove;

    /// Sets the center widget for the `GtkActionBar`.
    extern fn gtk_action_bar_set_center_widget(p_action_bar: *ActionBar, p_center_widget: ?*gtk.Widget) void;
    pub const setCenterWidget = gtk_action_bar_set_center_widget;

    /// Reveals or conceals the content of the action bar.
    ///
    /// Note: this does not show or hide `action_bar` in the
    /// `gtk.Widget.properties.visible` sense, so revealing has
    /// no effect if the action bar is hidden.
    extern fn gtk_action_bar_set_revealed(p_action_bar: *ActionBar, p_revealed: c_int) void;
    pub const setRevealed = gtk_action_bar_set_revealed;

    extern fn gtk_action_bar_get_type() usize;
    pub const getGObjectType = gtk_action_bar_get_type;

    extern fn g_object_ref(p_self: *gtk.ActionBar) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ActionBar) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ActionBar, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkShortcutAction` that calls `gtk.Widget.activate`.
pub const ActivateAction = opaque {
    pub const Parent = gtk.ShortcutAction;
    pub const Implements = [_]type{};
    pub const Class = gtk.ActivateActionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Gets the activate action.
    ///
    /// This is an action that calls `gtk.Widget.activate`
    /// on the given widget upon activation.
    extern fn gtk_activate_action_get() *gtk.ActivateAction;
    pub const get = gtk_activate_action_get;

    extern fn gtk_activate_action_get_type() usize;
    pub const getGObjectType = gtk_activate_action_get_type;

    extern fn g_object_ref(p_self: *gtk.ActivateAction) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ActivateAction) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ActivateAction, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAdjustment` is a model for a numeric value.
///
/// The `GtkAdjustment` has an associated lower and upper bound.
/// It also contains step and page increments, and a page size.
///
/// Adjustments are used within several GTK widgets, including
/// `gtk.SpinButton`, `gtk.Viewport`, `gtk.Scrollbar`
/// and `gtk.Scale`.
///
/// The `GtkAdjustment` object does not update the value itself. Instead
/// it is left up to the owner of the `GtkAdjustment` to control the value.
pub const Adjustment = extern struct {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = gtk.AdjustmentClass;
    f_parent_instance: gobject.InitiallyUnowned,

    pub const virtual_methods = struct {
        pub const changed = struct {
            pub fn call(p_class: anytype, p_adjustment: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Adjustment.Class, p_class).f_changed.?(gobject.ext.as(Adjustment, p_adjustment));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_adjustment: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Adjustment.Class, p_class).f_changed = @ptrCast(p_implementation);
            }
        };

        pub const value_changed = struct {
            pub fn call(p_class: anytype, p_adjustment: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Adjustment.Class, p_class).f_value_changed.?(gobject.ext.as(Adjustment, p_adjustment));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_adjustment: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Adjustment.Class, p_class).f_value_changed = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The minimum value of the adjustment.
        pub const lower = struct {
            pub const name = "lower";

            pub const Type = f64;
        };

        /// The page increment of the adjustment.
        pub const page_increment = struct {
            pub const name = "page-increment";

            pub const Type = f64;
        };

        /// The page size of the adjustment.
        ///
        /// Note that the page-size is irrelevant and should be set to zero
        /// if the adjustment is used for a simple scalar value, e.g. in a
        /// `GtkSpinButton`.
        pub const page_size = struct {
            pub const name = "page-size";

            pub const Type = f64;
        };

        /// The step increment of the adjustment.
        pub const step_increment = struct {
            pub const name = "step-increment";

            pub const Type = f64;
        };

        /// The maximum value of the adjustment.
        ///
        /// Note that values will be restricted by `upper - page-size` if the page-size
        /// property is nonzero.
        pub const upper = struct {
            pub const name = "upper";

            pub const Type = f64;
        };

        /// The value of the adjustment.
        pub const value = struct {
            pub const name = "value";

            pub const Type = f64;
        };
    };

    pub const signals = struct {
        /// Emitted when one or more of the `GtkAdjustment` properties have been
        /// changed.
        ///
        /// Note that the `gtk.Adjustment.properties.value` property is
        /// covered by the `gtk.Adjustment.signals.value_changed` signal.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Adjustment, p_instance))),
                    gobject.signalLookup("changed", Adjustment.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the value has been changed.
        pub const value_changed = struct {
            pub const name = "value-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Adjustment, p_instance))),
                    gobject.signalLookup("value-changed", Adjustment.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkAdjustment`.
    extern fn gtk_adjustment_new(p_value: f64, p_lower: f64, p_upper: f64, p_step_increment: f64, p_page_increment: f64, p_page_size: f64) *gtk.Adjustment;
    pub const new = gtk_adjustment_new;

    /// Updates the value property to ensure that the range
    /// between `lower` and `upper` is in the current page.
    ///
    /// The current page goes from `value` to `value` + `page-size`.
    /// If the range is larger than the page size, then only the
    /// start of it will be in the current page.
    ///
    /// A `gtk.Adjustment.signals.value_changed` signal will be emitted
    /// if the value is changed.
    extern fn gtk_adjustment_clamp_page(p_adjustment: *Adjustment, p_lower: f64, p_upper: f64) void;
    pub const clampPage = gtk_adjustment_clamp_page;

    /// Sets all properties of the adjustment at once.
    ///
    /// Use this function to avoid multiple emissions of the
    /// `gtk.Adjustment.signals.changed` signal. See
    /// `gtk.Adjustment.setLower` for an alternative
    /// way of compressing multiple emissions of
    /// `gtk.Adjustment.signals.changed` into one.
    extern fn gtk_adjustment_configure(p_adjustment: *Adjustment, p_value: f64, p_lower: f64, p_upper: f64, p_step_increment: f64, p_page_increment: f64, p_page_size: f64) void;
    pub const configure = gtk_adjustment_configure;

    /// Retrieves the minimum value of the adjustment.
    extern fn gtk_adjustment_get_lower(p_adjustment: *Adjustment) f64;
    pub const getLower = gtk_adjustment_get_lower;

    /// Gets the smaller of step increment and page increment.
    extern fn gtk_adjustment_get_minimum_increment(p_adjustment: *Adjustment) f64;
    pub const getMinimumIncrement = gtk_adjustment_get_minimum_increment;

    /// Retrieves the page increment of the adjustment.
    extern fn gtk_adjustment_get_page_increment(p_adjustment: *Adjustment) f64;
    pub const getPageIncrement = gtk_adjustment_get_page_increment;

    /// Retrieves the page size of the adjustment.
    extern fn gtk_adjustment_get_page_size(p_adjustment: *Adjustment) f64;
    pub const getPageSize = gtk_adjustment_get_page_size;

    /// Retrieves the step increment of the adjustment.
    extern fn gtk_adjustment_get_step_increment(p_adjustment: *Adjustment) f64;
    pub const getStepIncrement = gtk_adjustment_get_step_increment;

    /// Retrieves the maximum value of the adjustment.
    extern fn gtk_adjustment_get_upper(p_adjustment: *Adjustment) f64;
    pub const getUpper = gtk_adjustment_get_upper;

    /// Gets the current value of the adjustment.
    extern fn gtk_adjustment_get_value(p_adjustment: *Adjustment) f64;
    pub const getValue = gtk_adjustment_get_value;

    /// Sets the minimum value of the adjustment.
    ///
    /// When setting multiple adjustment properties via their individual
    /// setters, multiple `gtk.Adjustment.signals.changed` signals will
    /// be emitted. However, since the emission of the
    /// `gtk.Adjustment.signals.changed` signal is tied to the emission
    /// of the ::notify signals of the changed properties, it’s possible
    /// to compress the `gtk.Adjustment.signals.changed` signals into one
    /// by calling `gobject.Object.freezeNotify` and `gobject.Object.thawNotify`
    /// around the calls to the individual setters.
    ///
    /// Alternatively, using a single `gobject.Object.set` for all the properties
    /// to change, or using `gtk.Adjustment.configure` has the same effect.
    extern fn gtk_adjustment_set_lower(p_adjustment: *Adjustment, p_lower: f64) void;
    pub const setLower = gtk_adjustment_set_lower;

    /// Sets the page increment of the adjustment.
    ///
    /// See `gtk.Adjustment.setLower` about how to compress
    /// multiple emissions of the `gtk.Adjustment.signals.changed`
    /// signal when setting multiple adjustment properties.
    extern fn gtk_adjustment_set_page_increment(p_adjustment: *Adjustment, p_page_increment: f64) void;
    pub const setPageIncrement = gtk_adjustment_set_page_increment;

    /// Sets the page size of the adjustment.
    ///
    /// See `gtk.Adjustment.setLower` about how to compress
    /// multiple emissions of the `gtk.Adjustment.signals.changed`
    /// signal when setting multiple adjustment properties.
    extern fn gtk_adjustment_set_page_size(p_adjustment: *Adjustment, p_page_size: f64) void;
    pub const setPageSize = gtk_adjustment_set_page_size;

    /// Sets the step increment of the adjustment.
    ///
    /// See `gtk.Adjustment.setLower` about how to compress
    /// multiple emissions of the `gtk.Adjustment.signals.changed`
    /// signal when setting multiple adjustment properties.
    extern fn gtk_adjustment_set_step_increment(p_adjustment: *Adjustment, p_step_increment: f64) void;
    pub const setStepIncrement = gtk_adjustment_set_step_increment;

    /// Sets the maximum value of the adjustment.
    ///
    /// Note that values will be restricted by `upper - page-size`
    /// if the page-size property is nonzero.
    ///
    /// See `gtk.Adjustment.setLower` about how to compress
    /// multiple emissions of the `gtk.Adjustment.signals.changed`
    /// signal when setting multiple adjustment properties.
    extern fn gtk_adjustment_set_upper(p_adjustment: *Adjustment, p_upper: f64) void;
    pub const setUpper = gtk_adjustment_set_upper;

    /// Sets the `GtkAdjustment` value.
    ///
    /// The value is clamped to lie between `gtk.Adjustment.properties.lower`
    /// and `gtk.Adjustment.properties.upper`.
    ///
    /// Note that for adjustments which are used in a `GtkScrollbar`,
    /// the effective range of allowed values goes from
    /// `gtk.Adjustment.properties.lower` to
    /// `gtk.Adjustment.properties.upper` - `gtk.Adjustment.properties.page_size`.
    extern fn gtk_adjustment_set_value(p_adjustment: *Adjustment, p_value: f64) void;
    pub const setValue = gtk_adjustment_set_value;

    extern fn gtk_adjustment_get_type() usize;
    pub const getGObjectType = gtk_adjustment_get_type;

    extern fn g_object_ref(p_self: *gtk.Adjustment) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Adjustment) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Adjustment, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkAlertDialog` object collects the arguments that
/// are needed to present a message to the user.
///
/// The message is shown with the `gtk.AlertDialog.choose`
/// function.
///
/// If you don't need to wait for a button to be clicked, you can use
/// `gtk.AlertDialog.show`.
pub const AlertDialog = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.AlertDialogClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Labels for buttons to show in the alert.
        ///
        /// The labels should be translated and may contain
        /// a _ to indicate the mnemonic character.
        ///
        /// If this property is not set, then a 'Close' button is
        /// automatically created.
        pub const buttons = struct {
            pub const name = "buttons";

            pub const Type = ?[*][*:0]u8;
        };

        /// This property determines what happens when the Escape key is
        /// pressed while the alert is shown.
        ///
        /// If this property holds the index of a button in `gtk.AlertDialog.properties.buttons`,
        /// then pressing Escape is treated as if that button was pressed. If it is -1
        /// or not a valid index for the `buttons` array, then an error is returned.
        ///
        /// If `buttons` is `NULL`, then the automatically created 'Close' button
        /// is treated as both cancel and default button, so 0 is returned.
        pub const cancel_button = struct {
            pub const name = "cancel-button";

            pub const Type = c_int;
        };

        /// This property determines what happens when the Return key is
        /// pressed while the alert is shown.
        ///
        /// If this property holds the index of a button in `gtk.AlertDialog.properties.buttons`,
        /// then pressing Return is treated as if that button was pressed. If it is -1
        /// or not a valid index for the `buttons` array, then nothing happens.
        ///
        /// If `buttons` is `NULL`, then the automatically created 'Close' button
        /// is treated as both cancel and default button, so 0 is returned.
        pub const default_button = struct {
            pub const name = "default-button";

            pub const Type = c_int;
        };

        /// The detail text for the alert.
        pub const detail = struct {
            pub const name = "detail";

            pub const Type = ?[*:0]u8;
        };

        /// The message for the alert.
        pub const message = struct {
            pub const name = "message";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the alert is modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkAlertDialog` object.
    ///
    /// The message will be set to the formatted string
    /// resulting from the arguments.
    extern fn gtk_alert_dialog_new(p_format: [*:0]const u8, ...) *gtk.AlertDialog;
    pub const new = gtk_alert_dialog_new;

    /// This function shows the alert to the user.
    ///
    /// It is ok to pass `NULL` for the callback if the alert
    /// does not have more than one button. A simpler API for
    /// this case is `gtk.AlertDialog.show`.
    extern fn gtk_alert_dialog_choose(p_self: *AlertDialog, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const choose = gtk_alert_dialog_choose;

    /// Finishes the `gtk.AlertDialog.choose` call
    /// and returns the index of the button that was clicked.
    extern fn gtk_alert_dialog_choose_finish(p_self: *AlertDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const chooseFinish = gtk_alert_dialog_choose_finish;

    /// Returns the button labels for the alert.
    extern fn gtk_alert_dialog_get_buttons(p_self: *AlertDialog) ?[*]const [*:0]const u8;
    pub const getButtons = gtk_alert_dialog_get_buttons;

    /// Returns the index of the cancel button.
    extern fn gtk_alert_dialog_get_cancel_button(p_self: *AlertDialog) c_int;
    pub const getCancelButton = gtk_alert_dialog_get_cancel_button;

    /// Returns the index of the default button.
    extern fn gtk_alert_dialog_get_default_button(p_self: *AlertDialog) c_int;
    pub const getDefaultButton = gtk_alert_dialog_get_default_button;

    /// Returns the detail text that will be shown in the alert.
    extern fn gtk_alert_dialog_get_detail(p_self: *AlertDialog) [*:0]const u8;
    pub const getDetail = gtk_alert_dialog_get_detail;

    /// Returns the message that will be shown in the alert.
    extern fn gtk_alert_dialog_get_message(p_self: *AlertDialog) [*:0]const u8;
    pub const getMessage = gtk_alert_dialog_get_message;

    /// Returns whether the alert blocks interaction
    /// with the parent window while it is presented.
    extern fn gtk_alert_dialog_get_modal(p_self: *AlertDialog) c_int;
    pub const getModal = gtk_alert_dialog_get_modal;

    /// Sets the button labels for the alert.
    extern fn gtk_alert_dialog_set_buttons(p_self: *AlertDialog, p_labels: [*]const [*:0]const u8) void;
    pub const setButtons = gtk_alert_dialog_set_buttons;

    /// Sets the index of the cancel button.
    ///
    /// See `gtk.AlertDialog.properties.cancel_button` for
    /// details of how this value is used.
    extern fn gtk_alert_dialog_set_cancel_button(p_self: *AlertDialog, p_button: c_int) void;
    pub const setCancelButton = gtk_alert_dialog_set_cancel_button;

    /// Sets the index of the default button.
    ///
    /// See `gtk.AlertDialog.properties.default_button` for
    /// details of how this value is used.
    extern fn gtk_alert_dialog_set_default_button(p_self: *AlertDialog, p_button: c_int) void;
    pub const setDefaultButton = gtk_alert_dialog_set_default_button;

    /// Sets the detail text that will be shown in the alert.
    extern fn gtk_alert_dialog_set_detail(p_self: *AlertDialog, p_detail: [*:0]const u8) void;
    pub const setDetail = gtk_alert_dialog_set_detail;

    /// Sets the message that will be shown in the alert.
    extern fn gtk_alert_dialog_set_message(p_self: *AlertDialog, p_message: [*:0]const u8) void;
    pub const setMessage = gtk_alert_dialog_set_message;

    /// Sets whether the alert blocks interaction
    /// with the parent window while it is presented.
    extern fn gtk_alert_dialog_set_modal(p_self: *AlertDialog, p_modal: c_int) void;
    pub const setModal = gtk_alert_dialog_set_modal;

    /// Show the alert to the user.
    ///
    /// This function is a simple version of `gtk.AlertDialog.choose`
    /// intended for dialogs with a single button.
    /// If you want to cancel the dialog or if the alert has more than one button,
    /// you should use that function instead and provide it with a `gio.Cancellable` or
    /// callback respectively.
    extern fn gtk_alert_dialog_show(p_self: *AlertDialog, p_parent: ?*gtk.Window) void;
    pub const show = gtk_alert_dialog_show;

    extern fn gtk_alert_dialog_get_type() usize;
    pub const getGObjectType = gtk_alert_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.AlertDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AlertDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AlertDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkShortcutTrigger` that combines two triggers.
///
/// The `GtkAlternativeTrigger` triggers when either of two trigger.
///
/// This can be cascaded to combine more than two triggers.
pub const AlternativeTrigger = opaque {
    pub const Parent = gtk.ShortcutTrigger;
    pub const Implements = [_]type{};
    pub const Class = gtk.AlternativeTriggerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The first `GtkShortcutTrigger` to check.
        pub const first = struct {
            pub const name = "first";

            pub const Type = ?*gtk.ShortcutTrigger;
        };

        /// The second `GtkShortcutTrigger` to check.
        pub const second = struct {
            pub const name = "second";

            pub const Type = ?*gtk.ShortcutTrigger;
        };
    };

    pub const signals = struct {};

    /// Creates a `GtkShortcutTrigger` that will trigger whenever
    /// either of the two given triggers gets triggered.
    ///
    /// Note that nesting is allowed, so if you want more than two
    /// alternative, create a new alternative trigger for each option.
    extern fn gtk_alternative_trigger_new(p_first: *gtk.ShortcutTrigger, p_second: *gtk.ShortcutTrigger) *gtk.AlternativeTrigger;
    pub const new = gtk_alternative_trigger_new;

    /// Gets the first of the two alternative triggers that may
    /// trigger `self`.
    ///
    /// `gtk.AlternativeTrigger.getSecond` will return
    /// the other one.
    extern fn gtk_alternative_trigger_get_first(p_self: *AlternativeTrigger) *gtk.ShortcutTrigger;
    pub const getFirst = gtk_alternative_trigger_get_first;

    /// Gets the second of the two alternative triggers that may
    /// trigger `self`.
    ///
    /// `gtk.AlternativeTrigger.getFirst` will return
    /// the other one.
    extern fn gtk_alternative_trigger_get_second(p_self: *AlternativeTrigger) *gtk.ShortcutTrigger;
    pub const getSecond = gtk_alternative_trigger_get_second;

    extern fn gtk_alternative_trigger_get_type() usize;
    pub const getGObjectType = gtk_alternative_trigger_get_type;

    extern fn g_object_ref(p_self: *gtk.AlternativeTrigger) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AlternativeTrigger) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AlternativeTrigger, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAnyFilter` matches an item when at least one of its filters matches.
///
/// To add filters to a `GtkAnyFilter`, use `gtk.MultiFilter.append`.
pub const AnyFilter = opaque {
    pub const Parent = gtk.MultiFilter;
    pub const Implements = [_]type{ gio.ListModel, gtk.Buildable };
    pub const Class = gtk.AnyFilterClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new empty "any" filter.
    ///
    /// Use `gtk.MultiFilter.append` to add filters to it.
    ///
    /// This filter matches an item if any of the filters added to it
    /// matches the item. In particular, this means that if no filter
    /// has been added to it, the filter matches no item.
    extern fn gtk_any_filter_new() *gtk.AnyFilter;
    pub const new = gtk_any_filter_new;

    extern fn gtk_any_filter_get_type() usize;
    pub const getGObjectType = gtk_any_filter_get_type;

    extern fn g_object_ref(p_self: *gtk.AnyFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AnyFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AnyFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkAppChooserButton` lets the user select an application.
///
/// ![An example GtkAppChooserButton](appchooserbutton.png)
///
/// Initially, a `GtkAppChooserButton` selects the first application
/// in its list, which will either be the most-recently used application
/// or, if `gtk.AppChooserButton.properties.show_default_item` is `TRUE`, the
/// default application.
///
/// The list of applications shown in a `GtkAppChooserButton` includes
/// the recommended applications for the given content type. When
/// `gtk.AppChooserButton.properties.show_default_item` is set, the default
/// application is also included. To let the user chooser other applications,
/// you can set the `gtk.AppChooserButton.properties.show_dialog_item` property,
/// which allows to open a full `gtk.AppChooserDialog`.
///
/// It is possible to add custom items to the list, using
/// `gtk.AppChooserButton.appendCustomItem`. These items cause
/// the `gtk.AppChooserButton.signals.custom_item_activated` signal to be
/// emitted when they are selected.
///
/// To track changes in the selected application, use the
/// `gtk.AppChooserButton.signals.changed` signal.
///
/// ## CSS nodes
///
/// `GtkAppChooserButton` has a single CSS node with the name “appchooserbutton”.
pub const AppChooserButton = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.AppChooser, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = AppChooserButton;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The text to show at the top of the dialog that can be
        /// opened from the button.
        ///
        /// The string may contain Pango markup.
        pub const heading = struct {
            pub const name = "heading";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the app chooser dialog should be modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };

        /// Determines whether the dropdown menu shows the default application
        /// on top for the provided content type.
        pub const show_default_item = struct {
            pub const name = "show-default-item";

            pub const Type = c_int;
        };

        /// Determines whether the dropdown menu shows an item to open
        /// a `GtkAppChooserDialog`.
        pub const show_dialog_item = struct {
            pub const name = "show-dialog-item";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted to when the button is activated.
        ///
        /// The `::activate` signal on `GtkAppChooserButton` is an action signal and
        /// emitting it causes the button to pop up its dialog.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AppChooserButton, p_instance))),
                    gobject.signalLookup("activate", AppChooserButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the active application changes.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AppChooserButton, p_instance))),
                    gobject.signalLookup("changed", AppChooserButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a custom item is activated.
        ///
        /// Use `gtk.AppChooserButton.appendCustomItem`,
        /// to add custom items.
        pub const custom_item_activated = struct {
            pub const name = "custom-item-activated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_item_name: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AppChooserButton, p_instance))),
                    gobject.signalLookup("custom-item-activated", AppChooserButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkAppChooserButton` for applications
    /// that can handle content of the given type.
    extern fn gtk_app_chooser_button_new(p_content_type: [*:0]const u8) *gtk.AppChooserButton;
    pub const new = gtk_app_chooser_button_new;

    /// Appends a custom item to the list of applications that is shown
    /// in the popup.
    ///
    /// The item name must be unique per-widget. Clients can use the
    /// provided name as a detail for the
    /// `gtk.AppChooserButton.signals.custom_item_activated` signal, to add a
    /// callback for the activation of a particular custom item in the list.
    ///
    /// See also `gtk.AppChooserButton.appendSeparator`.
    extern fn gtk_app_chooser_button_append_custom_item(p_self: *AppChooserButton, p_name: [*:0]const u8, p_label: [*:0]const u8, p_icon: *gio.Icon) void;
    pub const appendCustomItem = gtk_app_chooser_button_append_custom_item;

    /// Appends a separator to the list of applications that is shown
    /// in the popup.
    extern fn gtk_app_chooser_button_append_separator(p_self: *AppChooserButton) void;
    pub const appendSeparator = gtk_app_chooser_button_append_separator;

    /// Returns the text to display at the top of the dialog.
    extern fn gtk_app_chooser_button_get_heading(p_self: *AppChooserButton) ?[*:0]const u8;
    pub const getHeading = gtk_app_chooser_button_get_heading;

    /// Gets whether the dialog is modal.
    extern fn gtk_app_chooser_button_get_modal(p_self: *AppChooserButton) c_int;
    pub const getModal = gtk_app_chooser_button_get_modal;

    /// Returns whether the dropdown menu should show the default
    /// application at the top.
    extern fn gtk_app_chooser_button_get_show_default_item(p_self: *AppChooserButton) c_int;
    pub const getShowDefaultItem = gtk_app_chooser_button_get_show_default_item;

    /// Returns whether the dropdown menu shows an item
    /// for a `GtkAppChooserDialog`.
    extern fn gtk_app_chooser_button_get_show_dialog_item(p_self: *AppChooserButton) c_int;
    pub const getShowDialogItem = gtk_app_chooser_button_get_show_dialog_item;

    /// Selects a custom item.
    ///
    /// See `gtk.AppChooserButton.appendCustomItem`.
    ///
    /// Use `gtk.AppChooser.refresh` to bring the selection
    /// to its initial state.
    extern fn gtk_app_chooser_button_set_active_custom_item(p_self: *AppChooserButton, p_name: [*:0]const u8) void;
    pub const setActiveCustomItem = gtk_app_chooser_button_set_active_custom_item;

    /// Sets the text to display at the top of the dialog.
    ///
    /// If the heading is not set, the dialog displays a default text.
    extern fn gtk_app_chooser_button_set_heading(p_self: *AppChooserButton, p_heading: [*:0]const u8) void;
    pub const setHeading = gtk_app_chooser_button_set_heading;

    /// Sets whether the dialog should be modal.
    extern fn gtk_app_chooser_button_set_modal(p_self: *AppChooserButton, p_modal: c_int) void;
    pub const setModal = gtk_app_chooser_button_set_modal;

    /// Sets whether the dropdown menu of this button should show the
    /// default application for the given content type at top.
    extern fn gtk_app_chooser_button_set_show_default_item(p_self: *AppChooserButton, p_setting: c_int) void;
    pub const setShowDefaultItem = gtk_app_chooser_button_set_show_default_item;

    /// Sets whether the dropdown menu of this button should show an
    /// entry to trigger a `GtkAppChooserDialog`.
    extern fn gtk_app_chooser_button_set_show_dialog_item(p_self: *AppChooserButton, p_setting: c_int) void;
    pub const setShowDialogItem = gtk_app_chooser_button_set_show_dialog_item;

    extern fn gtk_app_chooser_button_get_type() usize;
    pub const getGObjectType = gtk_app_chooser_button_get_type;

    extern fn g_object_ref(p_self: *gtk.AppChooserButton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AppChooserButton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AppChooserButton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAppChooserDialog` shows a `GtkAppChooserWidget` inside a `GtkDialog`.
///
/// ![An example GtkAppChooserDialog](appchooserdialog.png)
///
/// Note that `GtkAppChooserDialog` does not have any interesting methods
/// of its own. Instead, you should get the embedded `GtkAppChooserWidget`
/// using `gtk.AppChooserDialog.getWidget` and call its methods if
/// the generic `gtk.AppChooser` interface is not sufficient for
/// your needs.
///
/// To set the heading that is shown above the `GtkAppChooserWidget`,
/// use `gtk.AppChooserDialog.setHeading`.
///
/// ## CSS nodes
///
/// `GtkAppChooserDialog` has a single CSS node with the name `window` and style
/// class `.appchooser`.
pub const AppChooserDialog = opaque {
    pub const Parent = gtk.Dialog;
    pub const Implements = [_]type{ gtk.Accessible, gtk.AppChooser, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = opaque {
        pub const Instance = AppChooserDialog;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The GFile used by the `GtkAppChooserDialog`.
        ///
        /// The dialog's `GtkAppChooserWidget` content type will
        /// be guessed from the file, if present.
        pub const gfile = struct {
            pub const name = "gfile";

            pub const Type = ?*gio.File;
        };

        /// The text to show at the top of the dialog.
        ///
        /// The string may contain Pango markup.
        pub const heading = struct {
            pub const name = "heading";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkAppChooserDialog` for the provided `GFile`.
    ///
    /// The dialog will show applications that can open the file.
    extern fn gtk_app_chooser_dialog_new(p_parent: ?*gtk.Window, p_flags: gtk.DialogFlags, p_file: *gio.File) *gtk.AppChooserDialog;
    pub const new = gtk_app_chooser_dialog_new;

    /// Creates a new `GtkAppChooserDialog` for the provided content type.
    ///
    /// The dialog will show applications that can open the content type.
    extern fn gtk_app_chooser_dialog_new_for_content_type(p_parent: ?*gtk.Window, p_flags: gtk.DialogFlags, p_content_type: [*:0]const u8) *gtk.AppChooserDialog;
    pub const newForContentType = gtk_app_chooser_dialog_new_for_content_type;

    /// Returns the text to display at the top of the dialog.
    extern fn gtk_app_chooser_dialog_get_heading(p_self: *AppChooserDialog) ?[*:0]const u8;
    pub const getHeading = gtk_app_chooser_dialog_get_heading;

    /// Returns the `GtkAppChooserWidget` of this dialog.
    extern fn gtk_app_chooser_dialog_get_widget(p_self: *AppChooserDialog) *gtk.Widget;
    pub const getWidget = gtk_app_chooser_dialog_get_widget;

    /// Sets the text to display at the top of the dialog.
    ///
    /// If the heading is not set, the dialog displays a default text.
    extern fn gtk_app_chooser_dialog_set_heading(p_self: *AppChooserDialog, p_heading: [*:0]const u8) void;
    pub const setHeading = gtk_app_chooser_dialog_set_heading;

    extern fn gtk_app_chooser_dialog_get_type() usize;
    pub const getGObjectType = gtk_app_chooser_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.AppChooserDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AppChooserDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AppChooserDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAppChooserWidget` is a widget for selecting applications.
///
/// It is the main building block for `gtk.AppChooserDialog`.
/// Most applications only need to use the latter; but you can use
/// this widget as part of a larger widget if you have special needs.
///
/// `GtkAppChooserWidget` offers detailed control over what applications
/// are shown, using the
/// `gtk.AppChooserWidget.properties.show_default`,
/// `gtk.AppChooserWidget.properties.show_recommended`,
/// `gtk.AppChooserWidget.properties.show_fallback`,
/// `gtk.AppChooserWidget.properties.show_other` and
/// `gtk.AppChooserWidget.properties.show_all` properties. See the
/// `gtk.AppChooser` documentation for more information about these
/// groups of applications.
///
/// To keep track of the selected application, use the
/// `gtk.AppChooserWidget.signals.application_selected` and
/// `gtk.AppChooserWidget.signals.application_activated` signals.
///
/// ## CSS nodes
///
/// `GtkAppChooserWidget` has a single CSS node with name appchooser.
pub const AppChooserWidget = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.AppChooser, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = AppChooserWidget;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The text that appears in the widget when there are no applications
        /// for the given content type.
        pub const default_text = struct {
            pub const name = "default-text";

            pub const Type = ?[*:0]u8;
        };

        /// If `TRUE`, the app chooser presents all applications
        /// in a single list, without subsections for default,
        /// recommended or related applications.
        pub const show_all = struct {
            pub const name = "show-all";

            pub const Type = c_int;
        };

        /// Determines whether the app chooser should show the default
        /// handler for the content type in a separate section.
        ///
        /// If `FALSE`, the default handler is listed among the recommended
        /// applications.
        pub const show_default = struct {
            pub const name = "show-default";

            pub const Type = c_int;
        };

        /// Determines whether the app chooser should show a section
        /// for fallback applications.
        ///
        /// If `FALSE`, the fallback applications are listed among the
        /// other applications.
        pub const show_fallback = struct {
            pub const name = "show-fallback";

            pub const Type = c_int;
        };

        /// Determines whether the app chooser should show a section
        /// for other applications.
        pub const show_other = struct {
            pub const name = "show-other";

            pub const Type = c_int;
        };

        /// Determines whether the app chooser should show a section
        /// for recommended applications.
        ///
        /// If `FALSE`, the recommended applications are listed
        /// among the other applications.
        pub const show_recommended = struct {
            pub const name = "show-recommended";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when an application item is activated from the widget's list.
        ///
        /// This usually happens when the user double clicks an item, or an item
        /// is selected and the user presses one of the keys Space, Shift+Space,
        /// Return or Enter.
        pub const application_activated = struct {
            pub const name = "application-activated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_application: *gio.AppInfo, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AppChooserWidget, p_instance))),
                    gobject.signalLookup("application-activated", AppChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when an application item is selected from the widget's list.
        pub const application_selected = struct {
            pub const name = "application-selected";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_application: *gio.AppInfo, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AppChooserWidget, p_instance))),
                    gobject.signalLookup("application-selected", AppChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkAppChooserWidget` for applications
    /// that can handle content of the given type.
    extern fn gtk_app_chooser_widget_new(p_content_type: [*:0]const u8) *gtk.AppChooserWidget;
    pub const new = gtk_app_chooser_widget_new;

    /// Returns the text that is shown if there are not applications
    /// that can handle the content type.
    extern fn gtk_app_chooser_widget_get_default_text(p_self: *AppChooserWidget) ?[*:0]const u8;
    pub const getDefaultText = gtk_app_chooser_widget_get_default_text;

    /// Gets whether the app chooser should show all applications
    /// in a flat list.
    extern fn gtk_app_chooser_widget_get_show_all(p_self: *AppChooserWidget) c_int;
    pub const getShowAll = gtk_app_chooser_widget_get_show_all;

    /// Gets whether the app chooser should show the default handler
    /// for the content type in a separate section.
    extern fn gtk_app_chooser_widget_get_show_default(p_self: *AppChooserWidget) c_int;
    pub const getShowDefault = gtk_app_chooser_widget_get_show_default;

    /// Gets whether the app chooser should show related applications
    /// for the content type in a separate section.
    extern fn gtk_app_chooser_widget_get_show_fallback(p_self: *AppChooserWidget) c_int;
    pub const getShowFallback = gtk_app_chooser_widget_get_show_fallback;

    /// Gets whether the app chooser should show applications
    /// which are unrelated to the content type.
    extern fn gtk_app_chooser_widget_get_show_other(p_self: *AppChooserWidget) c_int;
    pub const getShowOther = gtk_app_chooser_widget_get_show_other;

    /// Gets whether the app chooser should show recommended applications
    /// for the content type in a separate section.
    extern fn gtk_app_chooser_widget_get_show_recommended(p_self: *AppChooserWidget) c_int;
    pub const getShowRecommended = gtk_app_chooser_widget_get_show_recommended;

    /// Sets the text that is shown if there are not applications
    /// that can handle the content type.
    extern fn gtk_app_chooser_widget_set_default_text(p_self: *AppChooserWidget, p_text: [*:0]const u8) void;
    pub const setDefaultText = gtk_app_chooser_widget_set_default_text;

    /// Sets whether the app chooser should show all applications
    /// in a flat list.
    extern fn gtk_app_chooser_widget_set_show_all(p_self: *AppChooserWidget, p_setting: c_int) void;
    pub const setShowAll = gtk_app_chooser_widget_set_show_all;

    /// Sets whether the app chooser should show the default handler
    /// for the content type in a separate section.
    extern fn gtk_app_chooser_widget_set_show_default(p_self: *AppChooserWidget, p_setting: c_int) void;
    pub const setShowDefault = gtk_app_chooser_widget_set_show_default;

    /// Sets whether the app chooser should show related applications
    /// for the content type in a separate section.
    extern fn gtk_app_chooser_widget_set_show_fallback(p_self: *AppChooserWidget, p_setting: c_int) void;
    pub const setShowFallback = gtk_app_chooser_widget_set_show_fallback;

    /// Sets whether the app chooser should show applications
    /// which are unrelated to the content type.
    extern fn gtk_app_chooser_widget_set_show_other(p_self: *AppChooserWidget, p_setting: c_int) void;
    pub const setShowOther = gtk_app_chooser_widget_set_show_other;

    /// Sets whether the app chooser should show recommended applications
    /// for the content type in a separate section.
    extern fn gtk_app_chooser_widget_set_show_recommended(p_self: *AppChooserWidget, p_setting: c_int) void;
    pub const setShowRecommended = gtk_app_chooser_widget_set_show_recommended;

    extern fn gtk_app_chooser_widget_get_type() usize;
    pub const getGObjectType = gtk_app_chooser_widget_get_type;

    extern fn g_object_ref(p_self: *gtk.AppChooserWidget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AppChooserWidget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AppChooserWidget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkApplication` is a high-level API for writing applications.
///
/// It supports many aspects of writing a GTK application in a convenient
/// fashion, without enforcing a one-size-fits-all model.
///
/// Currently, `GtkApplication` handles GTK initialization, application
/// uniqueness, session management, provides some basic scriptability and
/// desktop shell integration by exporting actions and menus and manages a
/// list of toplevel windows whose life-cycle is automatically tied to the
/// life-cycle of your application.
///
/// While `GtkApplication` works fine with plain `gtk.Window`s, it is
/// recommended to use it together with `gtk.ApplicationWindow`.
///
/// ## Automatic resources
///
/// `GtkApplication` will automatically load menus from the `GtkBuilder`
/// resource located at "gtk/menus.ui", relative to the application's
/// resource base path (see `gio.Application.setResourceBasePath`).
/// The menu with the ID "menubar" is taken as the application's
/// menubar. Additional menus (most interesting submenus) can be named
/// and accessed via `gtk.Application.getMenuById` which allows for
/// dynamic population of a part of the menu structure.
///
/// Note that automatic resource loading uses the resource base path
/// that is set at construction time and will not work if the resource
/// base path is changed at a later time.
///
/// It is also possible to provide the menubar manually using
/// `gtk.Application.setMenubar`.
///
/// `GtkApplication` will also automatically setup an icon search path for
/// the default icon theme by appending "icons" to the resource base
/// path. This allows your application to easily store its icons as
/// resources. See `gtk.IconTheme.addResourcePath` for more
/// information.
///
/// If there is a resource located at `gtk/help-overlay.ui` which
/// defines a `gtk.ShortcutsWindow` with ID `help_overlay` then
/// `GtkApplication` associates an instance of this shortcuts window with
/// each `gtk.ApplicationWindow` and sets up the keyboard accelerator
/// <kbd>Control</kbd>+<kbd>?</kbd> to open it. To create a menu item that
/// displays the shortcuts window, associate the item with the action
/// `win.show-help-overlay`.
///
/// ## A simple application
///
/// [A simple example](https://gitlab.gnome.org/GNOME/gtk/tree/main/examples/bp/bloatpad.c)
/// is available in the GTK source code repository
///
/// `GtkApplication` optionally registers with a session manager of the
/// users session (if you set the `gtk.Application.properties.register_session`
/// property) and offers various functionality related to the session
/// life-cycle.
///
/// An application can block various ways to end the session with
/// the `gtk.Application.inhibit` function. Typical use cases for
/// this kind of inhibiting are long-running, uninterruptible operations,
/// such as burning a CD or performing a disk backup. The session
/// manager may not honor the inhibitor, but it can be expected to
/// inform the user about the negative consequences of ending the
/// session while inhibitors are present.
///
/// ## See Also
///
/// - [Using GtkApplication](https://developer.gnome.org/documentation/tutorials/application.html)
/// - [Getting Started with GTK: Basics](getting_started.html`basics`)
pub const Application = extern struct {
    pub const Parent = gio.Application;
    pub const Implements = [_]type{ gio.ActionGroup, gio.ActionMap };
    pub const Class = gtk.ApplicationClass;
    f_parent_instance: gio.Application,

    pub const virtual_methods = struct {
        /// Signal emitted when a `GtkWindow` is added to
        ///    application through `gtk.Application.addWindow`.
        pub const window_added = struct {
            pub fn call(p_class: anytype, p_application: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_window: *gtk.Window) void {
                return gobject.ext.as(Application.Class, p_class).f_window_added.?(gobject.ext.as(Application, p_application), p_window);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_application: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_window: *gtk.Window) callconv(.C) void) void {
                gobject.ext.as(Application.Class, p_class).f_window_added = @ptrCast(p_implementation);
            }
        };

        /// Signal emitted when a `GtkWindow` is removed from
        ///    application, either as a side-effect of being destroyed or
        ///    explicitly through `gtk.Application.removeWindow`.
        pub const window_removed = struct {
            pub fn call(p_class: anytype, p_application: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_window: *gtk.Window) void {
                return gobject.ext.as(Application.Class, p_class).f_window_removed.?(gobject.ext.as(Application, p_application), p_window);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_application: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_window: *gtk.Window) callconv(.C) void) void {
                gobject.ext.as(Application.Class, p_class).f_window_removed = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The currently focused window of the application.
        pub const active_window = struct {
            pub const name = "active-window";

            pub const Type = ?*gtk.Window;
        };

        /// The `GMenuModel` to be used for the application's menu bar.
        pub const menubar = struct {
            pub const name = "menubar";

            pub const Type = ?*gio.MenuModel;
        };

        /// Set this property to `TRUE` to register with the session manager.
        ///
        /// This will make GTK track the session state (such as the
        /// `gtk.Application.properties.screensaver_active` property).
        pub const register_session = struct {
            pub const name = "register-session";

            pub const Type = c_int;
        };

        /// This property is `TRUE` if GTK believes that the screensaver is
        /// currently active.
        ///
        /// GTK only tracks session state (including this) when
        /// `gtk.Application.properties.register_session` is set to `TRUE`.
        ///
        /// Tracking the screensaver state is currently only supported on
        /// Linux.
        pub const screensaver_active = struct {
            pub const name = "screensaver-active";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the session manager is about to end the session.
        ///
        /// This signal is only emitted if `gtk.Application.properties.register_session`
        /// is `TRUE`. Applications can connect to this signal and call
        /// `gtk.Application.inhibit` with `GTK_APPLICATION_INHIBIT_LOGOUT`
        /// to delay the end of the session until state has been saved.
        pub const query_end = struct {
            pub const name = "query-end";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Application, p_instance))),
                    gobject.signalLookup("query-end", Application.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a `gtk.Window` is added to `application` through
        /// `gtk.Application.addWindow`.
        pub const window_added = struct {
            pub const name = "window-added";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_window: *gtk.Window, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Application, p_instance))),
                    gobject.signalLookup("window-added", Application.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a `gtk.Window` is removed from `application`.
        ///
        /// This can happen as a side-effect of the window being destroyed
        /// or explicitly through `gtk.Application.removeWindow`.
        pub const window_removed = struct {
            pub const name = "window-removed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_window: *gtk.Window, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Application, p_instance))),
                    gobject.signalLookup("window-removed", Application.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkApplication` instance.
    ///
    /// When using `GtkApplication`, it is not necessary to call `gtk.init`
    /// manually. It is called as soon as the application gets registered as
    /// the primary instance.
    ///
    /// Concretely, `gtk.init` is called in the default handler for the
    /// `GApplication::startup` signal. Therefore, `GtkApplication` subclasses should
    /// always chain up in their `GApplication::startup` handler before using any GTK
    /// API.
    ///
    /// Note that commandline arguments are not passed to `gtk.init`.
    ///
    /// If `application_id` is not `NULL`, then it must be valid. See
    /// ``gio.Application.idIsValid``.
    ///
    /// If no application ID is given then some features (most notably application
    /// uniqueness) will be disabled.
    extern fn gtk_application_new(p_application_id: ?[*:0]const u8, p_flags: gio.ApplicationFlags) *gtk.Application;
    pub const new = gtk_application_new;

    /// Adds a window to `application`.
    ///
    /// This call can only happen after the `application` has started;
    /// typically, you should add new application windows in response
    /// to the emission of the `GApplication::activate` signal.
    ///
    /// This call is equivalent to setting the `gtk.Window.properties.application`
    /// property of `window` to `application`.
    ///
    /// Normally, the connection between the application and the window
    /// will remain until the window is destroyed, but you can explicitly
    /// remove it with `gtk.Application.removeWindow`.
    ///
    /// GTK will keep the `application` running as long as it has
    /// any windows.
    extern fn gtk_application_add_window(p_application: *Application, p_window: *gtk.Window) void;
    pub const addWindow = gtk_application_add_window;

    /// Gets the accelerators that are currently associated with
    /// the given action.
    extern fn gtk_application_get_accels_for_action(p_application: *Application, p_detailed_action_name: [*:0]const u8) [*][*:0]u8;
    pub const getAccelsForAction = gtk_application_get_accels_for_action;

    /// Returns the list of actions (possibly empty) that `accel` maps to.
    ///
    /// Each item in the list is a detailed action name in the usual form.
    ///
    /// This might be useful to discover if an accel already exists in
    /// order to prevent installation of a conflicting accelerator (from
    /// an accelerator editor or a plugin system, for example). Note that
    /// having more than one action per accelerator may not be a bad thing
    /// and might make sense in cases where the actions never appear in the
    /// same context.
    ///
    /// In case there are no actions for a given accelerator, an empty array
    /// is returned. `NULL` is never returned.
    ///
    /// It is a programmer error to pass an invalid accelerator string.
    ///
    /// If you are unsure, check it with `gtk.acceleratorParse` first.
    extern fn gtk_application_get_actions_for_accel(p_application: *Application, p_accel: [*:0]const u8) [*][*:0]u8;
    pub const getActionsForAccel = gtk_application_get_actions_for_accel;

    /// Gets the “active” window for the application.
    ///
    /// The active window is the one that was most recently focused (within
    /// the application).  This window may not have the focus at the moment
    /// if another application has it — this is just the most
    /// recently-focused window within this application.
    extern fn gtk_application_get_active_window(p_application: *Application) ?*gtk.Window;
    pub const getActiveWindow = gtk_application_get_active_window;

    /// Gets a menu from automatically loaded resources.
    ///
    /// See [the section on Automatic resources](class.Application.html`automatic`-resources)
    /// for more information.
    extern fn gtk_application_get_menu_by_id(p_application: *Application, p_id: [*:0]const u8) ?*gio.Menu;
    pub const getMenuById = gtk_application_get_menu_by_id;

    /// Returns the menu model that has been set with
    /// `gtk.Application.setMenubar`.
    extern fn gtk_application_get_menubar(p_application: *Application) ?*gio.MenuModel;
    pub const getMenubar = gtk_application_get_menubar;

    /// Returns the `gtk.ApplicationWindow` with the given ID.
    ///
    /// The ID of a `GtkApplicationWindow` can be retrieved with
    /// `gtk.ApplicationWindow.getId`.
    extern fn gtk_application_get_window_by_id(p_application: *Application, p_id: c_uint) ?*gtk.Window;
    pub const getWindowById = gtk_application_get_window_by_id;

    /// Gets a list of the `gtk.Window` instances associated with `application`.
    ///
    /// The list is sorted by most recently focused window, such that the first
    /// element is the currently focused window. (Useful for choosing a parent
    /// for a transient window.)
    ///
    /// The list that is returned should not be modified in any way. It will
    /// only remain valid until the next focus change or window creation or
    /// deletion.
    extern fn gtk_application_get_windows(p_application: *Application) *glib.List;
    pub const getWindows = gtk_application_get_windows;

    /// Inform the session manager that certain types of actions should be
    /// inhibited.
    ///
    /// This is not guaranteed to work on all platforms and for all types of
    /// actions.
    ///
    /// Applications should invoke this method when they begin an operation
    /// that should not be interrupted, such as creating a CD or DVD. The
    /// types of actions that may be blocked are specified by the `flags`
    /// parameter. When the application completes the operation it should
    /// call `gtk.Application.uninhibit` to remove the inhibitor. Note
    /// that an application can have multiple inhibitors, and all of them must
    /// be individually removed. Inhibitors are also cleared when the
    /// application exits.
    ///
    /// Applications should not expect that they will always be able to block
    /// the action. In most cases, users will be given the option to force
    /// the action to take place.
    ///
    /// The `reason` message should be short and to the point.
    ///
    /// If `window` is given, the session manager may point the user to
    /// this window to find out more about why the action is inhibited.
    extern fn gtk_application_inhibit(p_application: *Application, p_window: ?*gtk.Window, p_flags: gtk.ApplicationInhibitFlags, p_reason: ?[*:0]const u8) c_uint;
    pub const inhibit = gtk_application_inhibit;

    /// Lists the detailed action names which have associated accelerators.
    ///
    /// See `gtk.Application.setAccelsForAction`.
    extern fn gtk_application_list_action_descriptions(p_application: *Application) [*][*:0]u8;
    pub const listActionDescriptions = gtk_application_list_action_descriptions;

    /// Remove a window from `application`.
    ///
    /// If `window` belongs to `application` then this call is equivalent to
    /// setting the `gtk.Window.properties.application` property of `window` to
    /// `NULL`.
    ///
    /// The application may stop running as a result of a call to this
    /// function, if `window` was the last window of the `application`.
    extern fn gtk_application_remove_window(p_application: *Application, p_window: *gtk.Window) void;
    pub const removeWindow = gtk_application_remove_window;

    /// Sets zero or more keyboard accelerators that will trigger the
    /// given action.
    ///
    /// The first item in `accels` will be the primary accelerator, which may be
    /// displayed in the UI.
    ///
    /// To remove all accelerators for an action, use an empty, zero-terminated
    /// array for `accels`.
    ///
    /// For the `detailed_action_name`, see ``gio.actionParseDetailedName`` and
    /// ``gio.actionPrintDetailedName``.
    extern fn gtk_application_set_accels_for_action(p_application: *Application, p_detailed_action_name: [*:0]const u8, p_accels: [*]const [*:0]const u8) void;
    pub const setAccelsForAction = gtk_application_set_accels_for_action;

    /// Sets or unsets the menubar for windows of `application`.
    ///
    /// This is a menubar in the traditional sense.
    ///
    /// This can only be done in the primary instance of the application,
    /// after it has been registered. `GApplication::startup` is a good place
    /// to call this.
    ///
    /// Depending on the desktop environment, this may appear at the top of
    /// each window, or at the top of the screen.  In some environments, if
    /// both the application menu and the menubar are set, the application
    /// menu will be presented as if it were the first item of the menubar.
    /// Other environments treat the two as completely separate — for example,
    /// the application menu may be rendered by the desktop shell while the
    /// menubar (if set) remains in each individual window.
    ///
    /// Use the base `GActionMap` interface to add actions, to respond to the
    /// user selecting these menu items.
    extern fn gtk_application_set_menubar(p_application: *Application, p_menubar: ?*gio.MenuModel) void;
    pub const setMenubar = gtk_application_set_menubar;

    /// Removes an inhibitor that has been previously established.
    ///
    /// See `gtk.Application.inhibit`.
    ///
    /// Inhibitors are also cleared when the application exits.
    extern fn gtk_application_uninhibit(p_application: *Application, p_cookie: c_uint) void;
    pub const uninhibit = gtk_application_uninhibit;

    extern fn gtk_application_get_type() usize;
    pub const getGObjectType = gtk_application_get_type;

    extern fn g_object_ref(p_self: *gtk.Application) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Application) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Application, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkApplicationWindow` is a `GtkWindow` subclass that integrates with
/// `GtkApplication`.
///
/// Notably, `GtkApplicationWindow` can handle an application menubar.
///
/// This class implements the `GActionGroup` and `GActionMap` interfaces,
/// to let you add window-specific actions that will be exported by the
/// associated `gtk.Application`, together with its application-wide
/// actions. Window-specific actions are prefixed with the “win.”
/// prefix and application-wide actions are prefixed with the “app.”
/// prefix. Actions must be addressed with the prefixed name when
/// referring to them from a `GMenuModel`.
///
/// Note that widgets that are placed inside a `GtkApplicationWindow`
/// can also activate these actions, if they implement the
/// `gtk.Actionable` interface.
///
/// The settings `gtk.Settings.properties.gtk_shell_shows_app_menu` and
/// `gtk.Settings.properties.gtk_shell_shows_menubar` tell GTK whether the
/// desktop environment is showing the application menu and menubar
/// models outside the application as part of the desktop shell.
/// For instance, on OS X, both menus will be displayed remotely;
/// on Windows neither will be.
///
/// If the desktop environment does not display the menubar, then
/// `GtkApplicationWindow` will automatically show a menubar for it.
/// This behaviour can be overridden with the
/// `gtk.ApplicationWindow.properties.show_menubar` property. If the
/// desktop environment does not display the application menu, then
/// it will automatically be included in the menubar or in the windows
/// client-side decorations.
///
/// See `gtk.PopoverMenu` for information about the XML language
/// used by `GtkBuilder` for menu models.
///
/// See also: `gtk.Application.setMenubar`.
///
/// ## A GtkApplicationWindow with a menubar
///
/// The code sample below shows how to set up a `GtkApplicationWindow`
/// with a menu bar defined on the `gtk.Application`:
///
/// ```c
/// GtkApplication *app = gtk_application_new ("org.gtk.test", 0);
///
/// GtkBuilder *builder = gtk_builder_new_from_string (
///     "<interface>"
///     "  <menu id='menubar'>"
///     "    <submenu>"
///     "      <attribute name='label' translatable='yes'>_Edit</attribute>"
///     "      <item>"
///     "        <attribute name='label' translatable='yes'>_Copy</attribute>"
///     "        <attribute name='action'>win.copy</attribute>"
///     "      </item>"
///     "      <item>"
///     "        <attribute name='label' translatable='yes'>_Paste</attribute>"
///     "        <attribute name='action'>win.paste</attribute>"
///     "      </item>"
///     "    </submenu>"
///     "  </menu>"
///     "</interface>",
///     -1);
///
/// GMenuModel *menubar = G_MENU_MODEL (gtk_builder_get_object (builder, "menubar"));
/// gtk_application_set_menubar (GTK_APPLICATION (app), menubar);
/// g_object_unref (builder);
///
/// // ...
///
/// GtkWidget *window = gtk_application_window_new (app);
/// ```
pub const ApplicationWindow = extern struct {
    pub const Parent = gtk.Window;
    pub const Implements = [_]type{ gio.ActionGroup, gio.ActionMap, gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = gtk.ApplicationWindowClass;
    f_parent_instance: gtk.Window,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// If this property is `TRUE`, the window will display a menubar
        /// unless it is shown by the desktop shell.
        ///
        /// See `gtk.Application.setMenubar`.
        ///
        /// If `FALSE`, the window will not display a menubar, regardless
        /// of whether the desktop shell is showing it or not.
        pub const show_menubar = struct {
            pub const name = "show-menubar";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkApplicationWindow`.
    extern fn gtk_application_window_new(p_application: *gtk.Application) *gtk.ApplicationWindow;
    pub const new = gtk_application_window_new;

    /// Gets the `GtkShortcutsWindow` that is associated with `window`.
    ///
    /// See `gtk.ApplicationWindow.setHelpOverlay`.
    extern fn gtk_application_window_get_help_overlay(p_window: *ApplicationWindow) ?*gtk.ShortcutsWindow;
    pub const getHelpOverlay = gtk_application_window_get_help_overlay;

    /// Returns the unique ID of the window.
    ///
    ///  If the window has not yet been added to a `GtkApplication`, returns `0`.
    extern fn gtk_application_window_get_id(p_window: *ApplicationWindow) c_uint;
    pub const getId = gtk_application_window_get_id;

    /// Returns whether the window will display a menubar for the app menu
    /// and menubar as needed.
    extern fn gtk_application_window_get_show_menubar(p_window: *ApplicationWindow) c_int;
    pub const getShowMenubar = gtk_application_window_get_show_menubar;

    /// Associates a shortcuts window with the application window.
    ///
    /// Additionally, sets up an action with the name
    /// `win.show-help-overlay` to present it.
    ///
    /// `window` takes responsibility for destroying `help_overlay`.
    extern fn gtk_application_window_set_help_overlay(p_window: *ApplicationWindow, p_help_overlay: ?*gtk.ShortcutsWindow) void;
    pub const setHelpOverlay = gtk_application_window_set_help_overlay;

    /// Sets whether the window will display a menubar for the app menu
    /// and menubar as needed.
    extern fn gtk_application_window_set_show_menubar(p_window: *ApplicationWindow, p_show_menubar: c_int) void;
    pub const setShowMenubar = gtk_application_window_set_show_menubar;

    extern fn gtk_application_window_get_type() usize;
    pub const getGObjectType = gtk_application_window_get_type;

    extern fn g_object_ref(p_self: *gtk.ApplicationWindow) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ApplicationWindow) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ApplicationWindow, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAspectFrame` preserves the aspect ratio of its child.
///
/// The frame can respect the aspect ratio of the child widget,
/// or use its own aspect ratio.
///
/// # CSS nodes
///
/// `GtkAspectFrame` uses a CSS node with name `aspectframe`.
///
/// # Accessibility
///
/// Until GTK 4.10, `GtkAspectFrame` used the `GTK_ACCESSIBLE_ROLE_GROUP` role.
///
/// Starting from GTK 4.12, `GtkAspectFrame` uses the `GTK_ACCESSIBLE_ROLE_GENERIC` role.
pub const AspectFrame = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = AspectFrame;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// Whether the `GtkAspectFrame` should use the aspect ratio of its child.
        pub const obey_child = struct {
            pub const name = "obey-child";

            pub const Type = c_int;
        };

        /// The aspect ratio to be used by the `GtkAspectFrame`.
        ///
        /// This property is only used if
        /// `gtk.AspectFrame.properties.obey_child` is set to `FALSE`.
        pub const ratio = struct {
            pub const name = "ratio";

            pub const Type = f32;
        };

        /// The horizontal alignment of the child.
        pub const xalign = struct {
            pub const name = "xalign";

            pub const Type = f32;
        };

        /// The vertical alignment of the child.
        pub const yalign = struct {
            pub const name = "yalign";

            pub const Type = f32;
        };
    };

    pub const signals = struct {};

    /// Create a new `GtkAspectFrame`.
    extern fn gtk_aspect_frame_new(p_xalign: f32, p_yalign: f32, p_ratio: f32, p_obey_child: c_int) *gtk.AspectFrame;
    pub const new = gtk_aspect_frame_new;

    /// Gets the child widget of `self`.
    extern fn gtk_aspect_frame_get_child(p_self: *AspectFrame) ?*gtk.Widget;
    pub const getChild = gtk_aspect_frame_get_child;

    /// Returns whether the child's size request should override
    /// the set aspect ratio of the `GtkAspectFrame`.
    extern fn gtk_aspect_frame_get_obey_child(p_self: *AspectFrame) c_int;
    pub const getObeyChild = gtk_aspect_frame_get_obey_child;

    /// Returns the desired aspect ratio of the child.
    extern fn gtk_aspect_frame_get_ratio(p_self: *AspectFrame) f32;
    pub const getRatio = gtk_aspect_frame_get_ratio;

    /// Returns the horizontal alignment of the child within the
    /// allocation of the `GtkAspectFrame`.
    extern fn gtk_aspect_frame_get_xalign(p_self: *AspectFrame) f32;
    pub const getXalign = gtk_aspect_frame_get_xalign;

    /// Returns the vertical alignment of the child within the
    /// allocation of the `GtkAspectFrame`.
    extern fn gtk_aspect_frame_get_yalign(p_self: *AspectFrame) f32;
    pub const getYalign = gtk_aspect_frame_get_yalign;

    /// Sets the child widget of `self`.
    extern fn gtk_aspect_frame_set_child(p_self: *AspectFrame, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_aspect_frame_set_child;

    /// Sets whether the aspect ratio of the child's size
    /// request should override the set aspect ratio of
    /// the `GtkAspectFrame`.
    extern fn gtk_aspect_frame_set_obey_child(p_self: *AspectFrame, p_obey_child: c_int) void;
    pub const setObeyChild = gtk_aspect_frame_set_obey_child;

    /// Sets the desired aspect ratio of the child.
    extern fn gtk_aspect_frame_set_ratio(p_self: *AspectFrame, p_ratio: f32) void;
    pub const setRatio = gtk_aspect_frame_set_ratio;

    /// Sets the horizontal alignment of the child within the allocation
    /// of the `GtkAspectFrame`.
    extern fn gtk_aspect_frame_set_xalign(p_self: *AspectFrame, p_xalign: f32) void;
    pub const setXalign = gtk_aspect_frame_set_xalign;

    /// Sets the vertical alignment of the child within the allocation
    /// of the `GtkAspectFrame`.
    extern fn gtk_aspect_frame_set_yalign(p_self: *AspectFrame, p_yalign: f32) void;
    pub const setYalign = gtk_aspect_frame_set_yalign;

    extern fn gtk_aspect_frame_get_type() usize;
    pub const getGObjectType = gtk_aspect_frame_get_type;

    extern fn g_object_ref(p_self: *gtk.AspectFrame) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AspectFrame) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AspectFrame, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAssistant` is used to represent a complex as a series of steps.
///
/// ![An example GtkAssistant](assistant.png)
///
/// Each step consists of one or more pages. `GtkAssistant` guides the user
/// through the pages, and controls the page flow to collect the data needed
/// for the operation.
///
/// `GtkAssistant` handles which buttons to show and to make sensitive based
/// on page sequence knowledge and the `gtk.AssistantPageType` of each
/// page in addition to state information like the *completed* and *committed*
/// page statuses.
///
/// If you have a case that doesn’t quite fit in `GtkAssistant`s way of
/// handling buttons, you can use the `GTK_ASSISTANT_PAGE_CUSTOM` page
/// type and handle buttons yourself.
///
/// `GtkAssistant` maintains a `GtkAssistantPage` object for each added
/// child, which holds additional per-child properties. You
/// obtain the `GtkAssistantPage` for a child with `gtk.Assistant.getPage`.
///
/// # GtkAssistant as GtkBuildable
///
/// The `GtkAssistant` implementation of the `GtkBuildable` interface
/// exposes the `action_area` as internal children with the name
/// “action_area”.
///
/// To add pages to an assistant in `GtkBuilder`, simply add it as a
/// child to the `GtkAssistant` object. If you need to set per-object
/// properties, create a `GtkAssistantPage` object explicitly, and
/// set the child widget as a property on it.
///
/// # CSS nodes
///
/// `GtkAssistant` has a single CSS node with the name window and style
/// class .assistant.
pub const Assistant = opaque {
    pub const Parent = gtk.Window;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = opaque {
        pub const Instance = Assistant;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// `GListModel` containing the pages.
        pub const pages = struct {
            pub const name = "pages";

            pub const Type = ?*gio.ListModel;
        };

        /// `TRUE` if the assistant uses a `GtkHeaderBar` for action buttons
        /// instead of the action-area.
        ///
        /// For technical reasons, this property is declared as an integer
        /// property, but you should only set it to `TRUE` or `FALSE`.
        pub const use_header_bar = struct {
            pub const name = "use-header-bar";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the apply button is clicked.
        ///
        /// The default behavior of the `GtkAssistant` is to switch to the page
        /// after the current page, unless the current page is the last one.
        ///
        /// A handler for the ::apply signal should carry out the actions for
        /// which the wizard has collected data. If the action takes a long time
        /// to complete, you might consider putting a page of type
        /// `GTK_ASSISTANT_PAGE_PROGRESS` after the confirmation page and handle
        /// this operation within the `gtk.Assistant.signals.prepare` signal of
        /// the progress page.
        pub const apply = struct {
            pub const name = "apply";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Assistant, p_instance))),
                    gobject.signalLookup("apply", Assistant.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when then the cancel button is clicked.
        pub const cancel = struct {
            pub const name = "cancel";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Assistant, p_instance))),
                    gobject.signalLookup("cancel", Assistant.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted either when the close button of a summary page is clicked,
        /// or when the apply button in the last page in the flow (of type
        /// `GTK_ASSISTANT_PAGE_CONFIRM`) is clicked.
        pub const close = struct {
            pub const name = "close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Assistant, p_instance))),
                    gobject.signalLookup("close", Assistant.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// The action signal for the Escape binding.
        pub const escape = struct {
            pub const name = "escape";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Assistant, p_instance))),
                    gobject.signalLookup("escape", Assistant.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a new page is set as the assistant's current page,
        /// before making the new page visible.
        ///
        /// A handler for this signal can do any preparations which are
        /// necessary before showing `page`.
        pub const prepare = struct {
            pub const name = "prepare";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_page: *gtk.Widget, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Assistant, p_instance))),
                    gobject.signalLookup("prepare", Assistant.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkAssistant`.
    extern fn gtk_assistant_new() *gtk.Assistant;
    pub const new = gtk_assistant_new;

    /// Adds a widget to the action area of a `GtkAssistant`.
    extern fn gtk_assistant_add_action_widget(p_assistant: *Assistant, p_child: *gtk.Widget) void;
    pub const addActionWidget = gtk_assistant_add_action_widget;

    /// Appends a page to the `assistant`.
    extern fn gtk_assistant_append_page(p_assistant: *Assistant, p_page: *gtk.Widget) c_int;
    pub const appendPage = gtk_assistant_append_page;

    /// Erases the visited page history.
    ///
    /// GTK will then hide the back button on the current page,
    /// and removes the cancel button from subsequent pages.
    ///
    /// Use this when the information provided up to the current
    /// page is hereafter deemed permanent and cannot be modified
    /// or undone. For example, showing a progress page to track
    /// a long-running, unreversible operation after the user has
    /// clicked apply on a confirmation page.
    extern fn gtk_assistant_commit(p_assistant: *Assistant) void;
    pub const commit = gtk_assistant_commit;

    /// Returns the page number of the current page.
    extern fn gtk_assistant_get_current_page(p_assistant: *Assistant) c_int;
    pub const getCurrentPage = gtk_assistant_get_current_page;

    /// Returns the number of pages in the `assistant`
    extern fn gtk_assistant_get_n_pages(p_assistant: *Assistant) c_int;
    pub const getNPages = gtk_assistant_get_n_pages;

    /// Returns the child widget contained in page number `page_num`.
    extern fn gtk_assistant_get_nth_page(p_assistant: *Assistant, p_page_num: c_int) ?*gtk.Widget;
    pub const getNthPage = gtk_assistant_get_nth_page;

    /// Returns the `GtkAssistantPage` object for `child`.
    extern fn gtk_assistant_get_page(p_assistant: *Assistant, p_child: *gtk.Widget) *gtk.AssistantPage;
    pub const getPage = gtk_assistant_get_page;

    /// Gets whether `page` is complete.
    extern fn gtk_assistant_get_page_complete(p_assistant: *Assistant, p_page: *gtk.Widget) c_int;
    pub const getPageComplete = gtk_assistant_get_page_complete;

    /// Gets the title for `page`.
    extern fn gtk_assistant_get_page_title(p_assistant: *Assistant, p_page: *gtk.Widget) [*:0]const u8;
    pub const getPageTitle = gtk_assistant_get_page_title;

    /// Gets the page type of `page`.
    extern fn gtk_assistant_get_page_type(p_assistant: *Assistant, p_page: *gtk.Widget) gtk.AssistantPageType;
    pub const getPageType = gtk_assistant_get_page_type;

    /// Gets a list model of the assistant pages.
    extern fn gtk_assistant_get_pages(p_assistant: *Assistant) *gio.ListModel;
    pub const getPages = gtk_assistant_get_pages;

    /// Inserts a page in the `assistant` at a given position.
    extern fn gtk_assistant_insert_page(p_assistant: *Assistant, p_page: *gtk.Widget, p_position: c_int) c_int;
    pub const insertPage = gtk_assistant_insert_page;

    /// Navigate to the next page.
    ///
    /// It is a programming error to call this function when
    /// there is no next page.
    ///
    /// This function is for use when creating pages of the
    /// `GTK_ASSISTANT_PAGE_CUSTOM` type.
    extern fn gtk_assistant_next_page(p_assistant: *Assistant) void;
    pub const nextPage = gtk_assistant_next_page;

    /// Prepends a page to the `assistant`.
    extern fn gtk_assistant_prepend_page(p_assistant: *Assistant, p_page: *gtk.Widget) c_int;
    pub const prependPage = gtk_assistant_prepend_page;

    /// Navigate to the previous visited page.
    ///
    /// It is a programming error to call this function when
    /// no previous page is available.
    ///
    /// This function is for use when creating pages of the
    /// `GTK_ASSISTANT_PAGE_CUSTOM` type.
    extern fn gtk_assistant_previous_page(p_assistant: *Assistant) void;
    pub const previousPage = gtk_assistant_previous_page;

    /// Removes a widget from the action area of a `GtkAssistant`.
    extern fn gtk_assistant_remove_action_widget(p_assistant: *Assistant, p_child: *gtk.Widget) void;
    pub const removeActionWidget = gtk_assistant_remove_action_widget;

    /// Removes the `page_num`’s page from `assistant`.
    extern fn gtk_assistant_remove_page(p_assistant: *Assistant, p_page_num: c_int) void;
    pub const removePage = gtk_assistant_remove_page;

    /// Switches the page to `page_num`.
    ///
    /// Note that this will only be necessary in custom buttons,
    /// as the `assistant` flow can be set with
    /// `gtk.Assistant.setForwardPageFunc`.
    extern fn gtk_assistant_set_current_page(p_assistant: *Assistant, p_page_num: c_int) void;
    pub const setCurrentPage = gtk_assistant_set_current_page;

    /// Sets the page forwarding function to be `page_func`.
    ///
    /// This function will be used to determine what will be
    /// the next page when the user presses the forward button.
    /// Setting `page_func` to `NULL` will make the assistant to
    /// use the default forward function, which just goes to the
    /// next visible page.
    extern fn gtk_assistant_set_forward_page_func(p_assistant: *Assistant, p_page_func: ?gtk.AssistantPageFunc, p_data: ?*anyopaque, p_destroy: ?glib.DestroyNotify) void;
    pub const setForwardPageFunc = gtk_assistant_set_forward_page_func;

    /// Sets whether `page` contents are complete.
    ///
    /// This will make `assistant` update the buttons state
    /// to be able to continue the task.
    extern fn gtk_assistant_set_page_complete(p_assistant: *Assistant, p_page: *gtk.Widget, p_complete: c_int) void;
    pub const setPageComplete = gtk_assistant_set_page_complete;

    /// Sets a title for `page`.
    ///
    /// The title is displayed in the header area of the assistant
    /// when `page` is the current page.
    extern fn gtk_assistant_set_page_title(p_assistant: *Assistant, p_page: *gtk.Widget, p_title: [*:0]const u8) void;
    pub const setPageTitle = gtk_assistant_set_page_title;

    /// Sets the page type for `page`.
    ///
    /// The page type determines the page behavior in the `assistant`.
    extern fn gtk_assistant_set_page_type(p_assistant: *Assistant, p_page: *gtk.Widget, p_type: gtk.AssistantPageType) void;
    pub const setPageType = gtk_assistant_set_page_type;

    /// Forces `assistant` to recompute the buttons state.
    ///
    /// GTK automatically takes care of this in most situations,
    /// e.g. when the user goes to a different page, or when the
    /// visibility or completeness of a page changes.
    ///
    /// One situation where it can be necessary to call this
    /// function is when changing a value on the current page
    /// affects the future page flow of the assistant.
    extern fn gtk_assistant_update_buttons_state(p_assistant: *Assistant) void;
    pub const updateButtonsState = gtk_assistant_update_buttons_state;

    extern fn gtk_assistant_get_type() usize;
    pub const getGObjectType = gtk_assistant_get_type;

    extern fn g_object_ref(p_self: *gtk.Assistant) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Assistant) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Assistant, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkAssistantPage` is an auxiliary object used by `GtkAssistant.
pub const AssistantPage = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = AssistantPage;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// Whether all required fields are filled in.
        ///
        /// GTK uses this information to control the sensitivity
        /// of the navigation buttons.
        pub const complete = struct {
            pub const name = "complete";

            pub const Type = c_int;
        };

        /// The type of the assistant page.
        pub const page_type = struct {
            pub const name = "page-type";

            pub const Type = gtk.AssistantPageType;
        };

        /// The title of the page.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Returns the child to which `page` belongs.
    extern fn gtk_assistant_page_get_child(p_page: *AssistantPage) *gtk.Widget;
    pub const getChild = gtk_assistant_page_get_child;

    extern fn gtk_assistant_page_get_type() usize;
    pub const getGObjectType = gtk_assistant_page_get_type;

    extern fn g_object_ref(p_self: *gtk.AssistantPage) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.AssistantPage) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AssistantPage, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkBinLayout` is a `GtkLayoutManager` subclass useful for create "bins" of
/// widgets.
///
/// `GtkBinLayout` will stack each child of a widget on top of each other,
/// using the `gtk.Widget.properties.hexpand`, `gtk.Widget.properties.vexpand`,
/// `gtk.Widget.properties.halign`, and `gtk.Widget.properties.valign` properties
/// of each child to determine where they should be positioned.
pub const BinLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{};
    pub const Class = gtk.BinLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkBinLayout` instance.
    extern fn gtk_bin_layout_new() *gtk.BinLayout;
    pub const new = gtk_bin_layout_new;

    extern fn gtk_bin_layout_get_type() usize;
    pub const getGObjectType = gtk_bin_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.BinLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.BinLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BinLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkBookmarkList` is a list model that wraps `GBookmarkFile`.
///
/// It presents a `GListModel` and fills it asynchronously with the
/// `GFileInfo`s returned from that function.
///
/// The `GFileInfo`s in the list have some attributes in the recent
/// namespace added: `recent::private` (boolean) and `recent:applications`
/// (stringv).
pub const BookmarkList = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{gio.ListModel};
    pub const Class = gtk.BookmarkListClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The attributes to query.
        pub const attributes = struct {
            pub const name = "attributes";

            pub const Type = ?[*:0]u8;
        };

        /// The bookmark file to load.
        pub const filename = struct {
            pub const name = "filename";

            pub const Type = ?[*:0]u8;
        };

        /// Priority used when loading.
        pub const io_priority = struct {
            pub const name = "io-priority";

            pub const Type = c_int;
        };

        /// The type of items. See `gio.ListModel.getItemType`.
        pub const item_type = struct {
            pub const name = "item-type";

            pub const Type = usize;
        };

        /// `TRUE` if files are being loaded.
        pub const loading = struct {
            pub const name = "loading";

            pub const Type = c_int;
        };

        /// The number of items. See `gio.ListModel.getNItems`.
        pub const n_items = struct {
            pub const name = "n-items";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkBookmarkList` with the given `attributes`.
    extern fn gtk_bookmark_list_new(p_filename: ?[*:0]const u8, p_attributes: ?[*:0]const u8) *gtk.BookmarkList;
    pub const new = gtk_bookmark_list_new;

    /// Gets the attributes queried on the children.
    extern fn gtk_bookmark_list_get_attributes(p_self: *BookmarkList) ?[*:0]const u8;
    pub const getAttributes = gtk_bookmark_list_get_attributes;

    /// Returns the filename of the bookmark file that
    /// this list is loading.
    extern fn gtk_bookmark_list_get_filename(p_self: *BookmarkList) [*:0]const u8;
    pub const getFilename = gtk_bookmark_list_get_filename;

    /// Gets the IO priority to use while loading file.
    extern fn gtk_bookmark_list_get_io_priority(p_self: *BookmarkList) c_int;
    pub const getIoPriority = gtk_bookmark_list_get_io_priority;

    /// Returns `TRUE` if the files are currently being loaded.
    ///
    /// Files will be added to `self` from time to time while loading is
    /// going on. The order in which are added is undefined and may change
    /// in between runs.
    extern fn gtk_bookmark_list_is_loading(p_self: *BookmarkList) c_int;
    pub const isLoading = gtk_bookmark_list_is_loading;

    /// Sets the `attributes` to be enumerated and starts the enumeration.
    ///
    /// If `attributes` is `NULL`, no attributes will be queried, but a list
    /// of `GFileInfo`s will still be created.
    extern fn gtk_bookmark_list_set_attributes(p_self: *BookmarkList, p_attributes: ?[*:0]const u8) void;
    pub const setAttributes = gtk_bookmark_list_set_attributes;

    /// Sets the IO priority to use while loading files.
    ///
    /// The default IO priority is `G_PRIORITY_DEFAULT`.
    extern fn gtk_bookmark_list_set_io_priority(p_self: *BookmarkList, p_io_priority: c_int) void;
    pub const setIoPriority = gtk_bookmark_list_set_io_priority;

    extern fn gtk_bookmark_list_get_type() usize;
    pub const getGObjectType = gtk_bookmark_list_get_type;

    extern fn g_object_ref(p_self: *gtk.BookmarkList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.BookmarkList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BookmarkList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkBoolFilter` evaluates a boolean `GtkExpression`
/// to determine whether to include items.
pub const BoolFilter = opaque {
    pub const Parent = gtk.Filter;
    pub const Implements = [_]type{};
    pub const Class = gtk.BoolFilterClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The boolean expression to evaluate on item.
        pub const expression = struct {
            pub const name = "expression";

            pub const Type = ?*gtk.Expression;
        };

        /// If the expression result should be inverted.
        pub const invert = struct {
            pub const name = "invert";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new bool filter.
    extern fn gtk_bool_filter_new(p_expression: ?*gtk.Expression) *gtk.BoolFilter;
    pub const new = gtk_bool_filter_new;

    /// Gets the expression that the filter uses to evaluate if
    /// an item should be filtered.
    extern fn gtk_bool_filter_get_expression(p_self: *BoolFilter) ?*gtk.Expression;
    pub const getExpression = gtk_bool_filter_get_expression;

    /// Returns whether the filter inverts the expression.
    extern fn gtk_bool_filter_get_invert(p_self: *BoolFilter) c_int;
    pub const getInvert = gtk_bool_filter_get_invert;

    /// Sets the expression that the filter uses to check if items
    /// should be filtered.
    ///
    /// The expression must have a value type of `G_TYPE_BOOLEAN`.
    extern fn gtk_bool_filter_set_expression(p_self: *BoolFilter, p_expression: ?*gtk.Expression) void;
    pub const setExpression = gtk_bool_filter_set_expression;

    /// Sets whether the filter should invert the expression.
    extern fn gtk_bool_filter_set_invert(p_self: *BoolFilter, p_invert: c_int) void;
    pub const setInvert = gtk_bool_filter_set_invert;

    extern fn gtk_bool_filter_get_type() usize;
    pub const getGObjectType = gtk_bool_filter_get_type;

    extern fn g_object_ref(p_self: *gtk.BoolFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.BoolFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BoolFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkBox` widget arranges child widgets into a single row or column.
///
/// ![An example GtkBox](box.png)
///
/// Whether it is a row or column depends on the value of its
/// `gtk.Orientable.properties.orientation` property. Within the other
/// dimension, all children are allocated the same size. Of course, the
/// `gtk.Widget.properties.halign` and `gtk.Widget.properties.valign` properties
/// can be used on the children to influence their allocation.
///
/// Use repeated calls to `gtk.Box.append` to pack widgets into a
/// `GtkBox` from start to end. Use `gtk.Box.remove` to remove widgets
/// from the `GtkBox`. `gtk.Box.insertChildAfter` can be used to add
/// a child at a particular position.
///
/// Use `gtk.Box.setHomogeneous` to specify whether or not all children
/// of the `GtkBox` are forced to get the same amount of space.
///
/// Use `gtk.Box.setSpacing` to determine how much space will be minimally
/// placed between all children in the `GtkBox`. Note that spacing is added
/// *between* the children.
///
/// Use `gtk.Box.reorderChildAfter` to move a child to a different
/// place in the box.
///
/// # CSS nodes
///
/// `GtkBox` uses a single CSS node with name box.
///
/// # Accessibility
///
/// Until GTK 4.10, `GtkBox` used the `GTK_ACCESSIBLE_ROLE_GROUP` role.
///
/// Starting from GTK 4.12, `GtkBox` uses the `GTK_ACCESSIBLE_ROLE_GENERIC` role.
pub const Box = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Orientable };
    pub const Class = gtk.BoxClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The child that determines the baseline, in vertical orientation.
        pub const baseline_child = struct {
            pub const name = "baseline-child";

            pub const Type = c_int;
        };

        /// The position of the baseline aligned widgets if extra space is available.
        pub const baseline_position = struct {
            pub const name = "baseline-position";

            pub const Type = gtk.BaselinePosition;
        };

        /// Whether the children should all be the same size.
        pub const homogeneous = struct {
            pub const name = "homogeneous";

            pub const Type = c_int;
        };

        /// The amount of space between children.
        pub const spacing = struct {
            pub const name = "spacing";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkBox`.
    extern fn gtk_box_new(p_orientation: gtk.Orientation, p_spacing: c_int) *gtk.Box;
    pub const new = gtk_box_new;

    /// Adds `child` as the last child to `box`.
    extern fn gtk_box_append(p_box: *Box, p_child: *gtk.Widget) void;
    pub const append = gtk_box_append;

    /// Gets the value set by `gtk.Box.setBaselineChild`.
    extern fn gtk_box_get_baseline_child(p_box: *Box) c_int;
    pub const getBaselineChild = gtk_box_get_baseline_child;

    /// Gets the value set by `gtk.Box.setBaselinePosition`.
    extern fn gtk_box_get_baseline_position(p_box: *Box) gtk.BaselinePosition;
    pub const getBaselinePosition = gtk_box_get_baseline_position;

    /// Returns whether the box is homogeneous (all children are the
    /// same size).
    extern fn gtk_box_get_homogeneous(p_box: *Box) c_int;
    pub const getHomogeneous = gtk_box_get_homogeneous;

    /// Gets the value set by `gtk.Box.setSpacing`.
    extern fn gtk_box_get_spacing(p_box: *Box) c_int;
    pub const getSpacing = gtk_box_get_spacing;

    /// Inserts `child` in the position after `sibling` in the list
    /// of `box` children.
    ///
    /// If `sibling` is `NULL`, insert `child` at the first position.
    extern fn gtk_box_insert_child_after(p_box: *Box, p_child: *gtk.Widget, p_sibling: ?*gtk.Widget) void;
    pub const insertChildAfter = gtk_box_insert_child_after;

    /// Adds `child` as the first child to `box`.
    extern fn gtk_box_prepend(p_box: *Box, p_child: *gtk.Widget) void;
    pub const prepend = gtk_box_prepend;

    /// Removes a child widget from `box`.
    ///
    /// The child must have been added before with
    /// `gtk.Box.append`, `gtk.Box.prepend`, or
    /// `gtk.Box.insertChildAfter`.
    extern fn gtk_box_remove(p_box: *Box, p_child: *gtk.Widget) void;
    pub const remove = gtk_box_remove;

    /// Moves `child` to the position after `sibling` in the list
    /// of `box` children.
    ///
    /// If `sibling` is `NULL`, move `child` to the first position.
    extern fn gtk_box_reorder_child_after(p_box: *Box, p_child: *gtk.Widget, p_sibling: ?*gtk.Widget) void;
    pub const reorderChildAfter = gtk_box_reorder_child_after;

    /// Sets the baseline child of a box.
    ///
    /// This affects only vertical boxes.
    extern fn gtk_box_set_baseline_child(p_box: *Box, p_child: c_int) void;
    pub const setBaselineChild = gtk_box_set_baseline_child;

    /// Sets the baseline position of a box.
    ///
    /// This affects only horizontal boxes with at least one baseline
    /// aligned child. If there is more vertical space available than
    /// requested, and the baseline is not allocated by the parent then
    /// `position` is used to allocate the baseline with respect to the
    /// extra space available.
    extern fn gtk_box_set_baseline_position(p_box: *Box, p_position: gtk.BaselinePosition) void;
    pub const setBaselinePosition = gtk_box_set_baseline_position;

    /// Sets whether or not all children of `box` are given equal space
    /// in the box.
    extern fn gtk_box_set_homogeneous(p_box: *Box, p_homogeneous: c_int) void;
    pub const setHomogeneous = gtk_box_set_homogeneous;

    /// Sets the number of pixels to place between children of `box`.
    extern fn gtk_box_set_spacing(p_box: *Box, p_spacing: c_int) void;
    pub const setSpacing = gtk_box_set_spacing;

    extern fn gtk_box_get_type() usize;
    pub const getGObjectType = gtk_box_get_type;

    extern fn g_object_ref(p_self: *gtk.Box) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Box) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Box, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkBoxLayout` is a layout manager that arranges children in a single
/// row or column.
///
/// Whether it is a row or column depends on the value of its
/// `gtk.Orientable.properties.orientation` property. Within the other dimension
/// all children all allocated the same size. The `GtkBoxLayout` will respect
/// the `gtk.Widget.properties.halign` and `gtk.Widget.properties.valign`
/// properties of each child widget.
///
/// If you want all children to be assigned the same size, you can use
/// the `gtk.BoxLayout.properties.homogeneous` property.
///
/// If you want to specify the amount of space placed between each child,
/// you can use the `gtk.BoxLayout.properties.spacing` property.
pub const BoxLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{gtk.Orientable};
    pub const Class = gtk.BoxLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The child that determines the baseline of the box
        /// in vertical layout.
        ///
        /// If the child does baseline positioning, then its baseline
        /// is lined up with the baseline of the box. If it doesn't, then
        /// the bottom edge of the child is used.
        pub const baseline_child = struct {
            pub const name = "baseline-child";

            pub const Type = c_int;
        };

        /// The position of the allocated baseline within the extra space
        /// allocated to each child.
        ///
        /// This property is only relevant for horizontal layouts containing
        /// at least one child with a baseline alignment.
        pub const baseline_position = struct {
            pub const name = "baseline-position";

            pub const Type = gtk.BaselinePosition;
        };

        /// Whether the box layout should distribute the available space
        /// equally among the children.
        pub const homogeneous = struct {
            pub const name = "homogeneous";

            pub const Type = c_int;
        };

        /// The space to put between the children.
        pub const spacing = struct {
            pub const name = "spacing";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkBoxLayout`.
    extern fn gtk_box_layout_new(p_orientation: gtk.Orientation) *gtk.BoxLayout;
    pub const new = gtk_box_layout_new;

    /// Gets the value set by `gtk.BoxLayout.setBaselineChild`.
    extern fn gtk_box_layout_get_baseline_child(p_box_layout: *BoxLayout) c_int;
    pub const getBaselineChild = gtk_box_layout_get_baseline_child;

    /// Gets the value set by `gtk.BoxLayout.setBaselinePosition`.
    extern fn gtk_box_layout_get_baseline_position(p_box_layout: *BoxLayout) gtk.BaselinePosition;
    pub const getBaselinePosition = gtk_box_layout_get_baseline_position;

    /// Returns whether the layout is set to be homogeneous.
    extern fn gtk_box_layout_get_homogeneous(p_box_layout: *BoxLayout) c_int;
    pub const getHomogeneous = gtk_box_layout_get_homogeneous;

    /// Returns the space that `box_layout` puts between children.
    extern fn gtk_box_layout_get_spacing(p_box_layout: *BoxLayout) c_uint;
    pub const getSpacing = gtk_box_layout_get_spacing;

    /// Sets the index of the child that determines the baseline
    /// in vertical layout.
    extern fn gtk_box_layout_set_baseline_child(p_box_layout: *BoxLayout, p_child: c_int) void;
    pub const setBaselineChild = gtk_box_layout_set_baseline_child;

    /// Sets the baseline position of a box layout.
    ///
    /// The baseline position affects only horizontal boxes with at least one
    /// baseline aligned child. If there is more vertical space available than
    /// requested, and the baseline is not allocated by the parent then the
    /// given `position` is used to allocate the baseline within the extra
    /// space available.
    extern fn gtk_box_layout_set_baseline_position(p_box_layout: *BoxLayout, p_position: gtk.BaselinePosition) void;
    pub const setBaselinePosition = gtk_box_layout_set_baseline_position;

    /// Sets whether the box layout will allocate the same
    /// size to all children.
    extern fn gtk_box_layout_set_homogeneous(p_box_layout: *BoxLayout, p_homogeneous: c_int) void;
    pub const setHomogeneous = gtk_box_layout_set_homogeneous;

    /// Sets how much spacing to put between children.
    extern fn gtk_box_layout_set_spacing(p_box_layout: *BoxLayout, p_spacing: c_uint) void;
    pub const setSpacing = gtk_box_layout_set_spacing;

    extern fn gtk_box_layout_get_type() usize;
    pub const getGObjectType = gtk_box_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.BoxLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.BoxLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BoxLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkBuilder` reads XML descriptions of a user interface and
/// instantiates the described objects.
///
/// To create a `GtkBuilder` from a user interface description, call
/// `gtk.Builder.newFromFile`, `gtk.Builder.newFromResource`
/// or `gtk.Builder.newFromString`.
///
/// In the (unusual) case that you want to add user interface
/// descriptions from multiple sources to the same `GtkBuilder` you can
/// call `gtk.Builder.new` to get an empty builder and populate it by
/// (multiple) calls to `gtk.Builder.addFromFile`,
/// `gtk.Builder.addFromResource` or
/// `gtk.Builder.addFromString`.
///
/// A `GtkBuilder` holds a reference to all objects that it has constructed
/// and drops these references when it is finalized. This finalization can
/// cause the destruction of non-widget objects or widgets which are not
/// contained in a toplevel window. For toplevel windows constructed by a
/// builder, it is the responsibility of the user to call
/// `gtk.Window.destroy` to get rid of them and all the widgets
/// they contain.
///
/// The functions `gtk.Builder.getObject` and
/// `gtk.Builder.getObjects` can be used to access the widgets in
/// the interface by the names assigned to them inside the UI description.
/// Toplevel windows returned by these functions will stay around until the
/// user explicitly destroys them with `gtk.Window.destroy`. Other
/// widgets will either be part of a larger hierarchy constructed by the
/// builder (in which case you should not have to worry about their lifecycle),
/// or without a parent, in which case they have to be added to some container
/// to make use of them. Non-widget objects need to be reffed with
/// `gobject.Object.ref` to keep them beyond the lifespan of the builder.
///
/// ## GtkBuilder UI Definitions
///
/// `GtkBuilder` parses textual descriptions of user interfaces which are
/// specified in XML format. We refer to these descriptions as “GtkBuilder
/// UI definitions” or just “UI definitions” if the context is clear.
///
/// ### Structure of UI definitions
///
/// UI definition files are always encoded in UTF-8.
///
/// The toplevel element is `<interface>`. It optionally takes a “domain”
/// attribute, which will make the builder look for translated strings
/// using ``dgettext`` in the domain specified. This can also be done by
/// calling `gtk.Builder.setTranslationDomain` on the builder.
/// For example:
///
/// ```xml
/// <?xml version="1.0" encoding="UTF-8">
/// <interface domain="your-app">
///   ...
/// </interface>
/// ```
///
/// ### Requirements
///
/// The target toolkit version(s) are described by `<requires>` elements,
/// the “lib” attribute specifies the widget library in question (currently
/// the only supported value is “gtk”) and the “version” attribute specifies
/// the target version in the form “`<major>`.`<minor>`”. `GtkBuilder` will
/// error out if the version requirements are not met. For example:
///
/// ```xml
/// <?xml version="1.0" encoding="UTF-8">
/// <interface domain="your-app">
///   <requires lib="gtk" version="4.0" />
/// </interface>
/// ```
///
/// ### Objects
///
/// Objects are defined as children of the `<interface>` element.
///
/// Objects are described by `<object>` elements, which can contain
/// `<property>` elements to set properties, `<signal>` elements which
/// connect signals to handlers, and `<child>` elements, which describe
/// child objects.
///
/// Typically, the specific kind of object represented by an `<object>`
/// element is specified by the “class” attribute. If the type has not
/// been loaded yet, GTK tries to find the ``get_type`` function from the
/// class name by applying heuristics. This works in most cases, but if
/// necessary, it is possible to specify the name of the ``get_type``
/// function explicitly with the "type-func" attribute. If your UI definition
/// is referencing internal types, you should make sure to call
/// ``gobject.typeEnsure`` for each object type before parsing the UI definition.
///
/// Objects may be given a name with the “id” attribute, which allows the
/// application to retrieve them from the builder with
/// `gtk.Builder.getObject`. An id is also necessary to use the
/// object as property value in other parts of the UI definition. GTK
/// reserves ids starting and ending with `___` (three consecutive
/// underscores) for its own purposes.
///
/// ### Properties
///
/// Setting properties of objects is pretty straightforward with the
/// `<property>` element: the “name” attribute specifies the name of the
/// property, and the content of the element specifies the value:
///
/// ```xml
/// <object class="GtkButton">
///   <property name="label">Hello, world</property>
/// </object>
/// ```
///
/// If the “translatable” attribute is set to a true value, GTK uses
/// ``gettext`` (or ``dgettext`` if the builder has a translation domain set)
/// to find a translation for the value. This happens before the value
/// is parsed, so it can be used for properties of any type, but it is
/// probably most useful for string properties. It is also possible to
/// specify a context to disambiguate short strings, and comments which
/// may help the translators:
///
/// ```xml
/// <object class="GtkButton">
///   <property name="label" translatable="yes" context="button">Hello, world</property>
/// </object>
/// ```
///
/// `GtkBuilder` can parse textual representations for the most common
/// property types:
///
/// - characters
/// - strings
/// - integers
/// - floating-point numbers
/// - booleans (strings like “TRUE”, “t”, “yes”, “y”, “1” are interpreted
///   as true values, strings like “FALSE”, “f”, “no”, “n”, “0” are interpreted
///   as false values)
/// - enumeration types (can be specified by their full C identifier their short
///   name used when registering the enumeration type, or their integer value)
/// - flag types (can be specified by their C identifier, short name, integer
///   value, and optionally combined with “|” for bitwise OR, e.g.
///   “GTK_INPUT_HINT_EMOJI|GTK_INPUT_HINT_LOWERCASE”, or “emoji|lowercase”)
/// - colors (in a format understood by `gdk.RGBA.parse`)
/// - `GVariant` (can be specified in the format understood by
///    `glib.Variant.parse`)
/// - pixbufs (can be specified as an object id, a resource path or a filename of an image file to load relative to the Builder file or the CWD if `gtk.Builder.addFromString` was used)
/// - GFile (like pixbufs, can be specified as an object id, a URI or a filename of a file to load relative to the Builder file or the CWD if `gtk.Builder.addFromString` was used)
///
/// Objects can be referred to by their name and by default refer to
/// objects declared in the local XML fragment and objects exposed via
/// `gtk.Builder.exposeObject`. In general, `GtkBuilder` allows
/// forward references to objects declared in the local XML; an object
/// doesn’t have to be constructed before it can be referred to. The
/// exception to this rule is that an object has to be constructed before
/// it can be used as the value of a construct-only property.
///
/// ### Child objects
///
/// Many widgets have properties for child widgets, such as
/// `gtk.Expander.properties.child`. In this case, the preferred way to
/// specify the child widget in a ui file is to simply set the property:
///
/// ```xml
/// <object class="GtkExpander">
///   <property name="child">
///     <object class="GtkLabel">
///     ...
///     </object>
///   </property>
/// </object>
/// ```
///
/// Generic containers that can contain an arbitrary number of children,
/// such as `gtk.Box` instead use the `<child>` element. A `<child>`
/// element contains an `<object>` element which describes the child object.
/// Most often, child objects are widgets inside a container, but they can
/// also be, e.g., actions in an action group, or columns in a tree model.
///
/// Any object type that implements the `gtk.Buildable` interface can
/// specify how children may be added to it. Since many objects and widgets that
/// are included with GTK already implement the `GtkBuildable` interface,
/// typically child objects can be added using the `<child>` element without
/// having to be concerned about the underlying implementation.
///
/// See the [`GtkWidget` documentation](class.Widget.html`gtkwidget`-as-gtkbuildable)
/// for many examples of using `GtkBuilder` with widgets, including setting
/// child objects using the `<child>` element.
///
/// A noteworthy special case to the general rule that only objects implementing
/// `GtkBuildable` may specify how to handle the `<child>` element is that
/// `GtkBuilder` provides special support for adding objects to a
/// `gio.ListStore` by using the `<child>` element. For instance:
///
/// ```xml
/// <object class="GListStore">
///   <property name="item-type">MyObject</property>
///   <child>
///     <object class="MyObject" />
///   </child>
///   ...
/// </object>
/// ```
///
/// ### Property bindings
///
/// It is also possible to bind a property value to another object's
/// property value using the attributes "bind-source" to specify the
/// source object of the binding, and optionally, "bind-property" and
/// "bind-flags" to specify the source property and source binding flags
/// respectively. Internally, `GtkBuilder` implements this using
/// `gobject.Binding` objects.
///
/// For instance, in the example below the “label” property of the
/// `bottom_label` widget is bound to the “label” property of the
/// `top_button` widget:
///
/// ```xml
/// <object class="GtkBox">
///   <property name="orientation">vertical</property>
///   <child>
///     <object class="GtkButton" id="top_button">
///       <property name="label">Hello, world</property>
///     </object>
///   </child>
///   <child>
///     <object class="GtkLabel" id="bottom_label">
///       <property name="label"
///                 bind-source="top_button"
///                 bind-property="label"
///                 bind-flags="sync-create" />
///     </object>
///   </child>
/// </object>
/// ```
///
/// For more information, see the documentation of the
/// `gobject.Object.bindProperty` method.
///
/// Please note that another way to set up bindings between objects in .ui files
/// is to use the `GtkExpression` methodology. See the
/// [`GtkExpression` documentation](class.Expression.html`gtkexpression`-in-ui-files)
/// for more information.
///
/// ### Internal children
///
/// Sometimes it is necessary to refer to widgets which have implicitly
/// been constructed by GTK as part of a composite widget, to set
/// properties on them or to add further children (e.g. the content area
/// of a `GtkDialog`). This can be achieved by setting the “internal-child”
/// property of the `<child>` element to a true value. Note that `GtkBuilder`
/// still requires an `<object>` element for the internal child, even if it
/// has already been constructed.
///
/// ### Specialized children
///
/// A number of widgets have different places where a child can be added
/// (e.g. tabs vs. page content in notebooks). This can be reflected in
/// a UI definition by specifying the “type” attribute on a `<child>`
/// The possible values for the “type” attribute are described in the
/// sections describing the widget-specific portions of UI definitions.
///
/// ### Signal handlers and function pointers
///
/// Signal handlers are set up with the `<signal>` element. The “name”
/// attribute specifies the name of the signal, and the “handler” attribute
/// specifies the function to connect to the signal.
///
/// ```xml
/// <object class="GtkButton" id="hello_button">
///   <signal name="clicked" handler="hello_button__clicked" />
/// </object>
/// ```
///
/// The remaining attributes, “after”, “swapped” and “object”, have the
/// same meaning as the corresponding parameters of the
/// `gobject.signalConnectObject` or `gobject.signalConnectData`
/// functions:
///
/// - “after” matches the `G_CONNECT_AFTER` flag, and will ensure that the
///   handler is called after the default class closure for the signal
/// - “swapped” matches the `G_CONNECT_SWAPPED` flag, and will swap the
///   instance and closure arguments when invoking the signal handler
/// - “object” will bind the signal handler to the lifetime of the object
///   referenced by the attribute
///
/// By default "swapped" will be set to "yes" if not specified otherwise, in
/// the case where "object" is set, for convenience. A “last_modification_time”
/// attribute is also allowed, but it does not have a meaning to the builder.
///
/// When compiling applications for Windows, you must declare signal callbacks
/// with the `G_MODULE_EXPORT` decorator, or they will not be put in the symbol
/// table:
///
/// ```c
/// G_MODULE_EXPORT void
/// hello_button__clicked (GtkButton *button,
///                        gpointer data)
/// {
///   // ...
/// }
/// ```
///
/// On Linux and Unix, this is not necessary; applications should instead
/// be compiled with the `-Wl,--export-dynamic` argument inside their compiler
/// flags, and linked against `gmodule-export-2.0`.
///
/// ## Example UI Definition
///
/// ```xml
/// <interface>
///   <object class="GtkDialog" id="dialog1">
///     <child internal-child="content_area">
///       <object class="GtkBox">
///         <child internal-child="action_area">
///           <object class="GtkBox">
///             <child>
///               <object class="GtkButton" id="ok_button">
///                 <property name="label" translatable="yes">_Ok</property>
///                 <property name="use-underline">True</property>
///                 <signal name="clicked" handler="ok_button_clicked"/>
///               </object>
///             </child>
///           </object>
///         </child>
///       </object>
///     </child>
///   </object>
/// </interface>
/// ```
///
/// ## Using GtkBuildable for extending UI definitions
///
/// Objects can implement the `gtk.Buildable` interface to add custom
/// elements and attributes to the XML. Typically, any extension will be
/// documented in each type that implements the interface.
///
/// ## Templates
///
/// When describing a `gtk.Widget`, you can use the `<template>` tag to
/// describe a UI bound to a specific widget type. GTK will automatically load
/// the UI definition when instantiating the type, and bind children and
/// signal handlers to instance fields and function symbols.
///
/// For more information, see the [`GtkWidget` documentation](class.Widget.html`building`-composite-widgets-from-template-xml)
/// for details.
pub const Builder = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.BuilderClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The object the builder is evaluating for.
        pub const current_object = struct {
            pub const name = "current-object";

            pub const Type = ?*gobject.Object;
        };

        /// The scope the builder is operating in
        pub const scope = struct {
            pub const name = "scope";

            pub const Type = ?*gtk.BuilderScope;
        };

        /// The translation domain used when translating property values that
        /// have been marked as translatable.
        ///
        /// If the translation domain is `NULL`, `GtkBuilder` uses `gettext`,
        /// otherwise `glib.dgettext`.
        pub const translation_domain = struct {
            pub const name = "translation-domain";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new empty builder object.
    ///
    /// This function is only useful if you intend to make multiple calls
    /// to `gtk.Builder.addFromFile`, `gtk.Builder.addFromResource`
    /// or `gtk.Builder.addFromString` in order to merge multiple UI
    /// descriptions into a single builder.
    extern fn gtk_builder_new() *gtk.Builder;
    pub const new = gtk_builder_new;

    /// Parses the UI definition in the file `filename`.
    ///
    /// If there is an error opening the file or parsing the description then
    /// the program will be aborted. You should only ever attempt to parse
    /// user interface descriptions that are shipped as part of your program.
    extern fn gtk_builder_new_from_file(p_filename: [*:0]const u8) *gtk.Builder;
    pub const newFromFile = gtk_builder_new_from_file;

    /// Parses the UI definition at `resource_path`.
    ///
    /// If there is an error locating the resource or parsing the
    /// description, then the program will be aborted.
    extern fn gtk_builder_new_from_resource(p_resource_path: [*:0]const u8) *gtk.Builder;
    pub const newFromResource = gtk_builder_new_from_resource;

    /// Parses the UI definition in `string`.
    ///
    /// If `string` is `NULL`-terminated, then `length` should be -1.
    /// If `length` is not -1, then it is the length of `string`.
    ///
    /// If there is an error parsing `string` then the program will be
    /// aborted. You should not attempt to parse user interface description
    /// from untrusted sources.
    extern fn gtk_builder_new_from_string(p_string: [*:0]const u8, p_length: isize) *gtk.Builder;
    pub const newFromString = gtk_builder_new_from_string;

    /// Parses a file containing a UI definition and merges it with
    /// the current contents of `builder`.
    ///
    /// This function is useful if you need to call
    /// `gtk.Builder.setCurrentObject`) to add user data to
    /// callbacks before loading GtkBuilder UI. Otherwise, you probably
    /// want `gtk.Builder.newFromFile` instead.
    ///
    /// If an error occurs, 0 will be returned and `error` will be assigned a
    /// `GError` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_FILE_ERROR`
    /// domains.
    ///
    /// It’s not really reasonable to attempt to handle failures of this
    /// call. You should not use this function with untrusted files (ie:
    /// files that are not part of your application). Broken `GtkBuilder`
    /// files can easily crash your program, and it’s possible that memory
    /// was leaked leading up to the reported failure. The only reasonable
    /// thing to do when an error is detected is to call ``g_error``.
    extern fn gtk_builder_add_from_file(p_builder: *Builder, p_filename: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const addFromFile = gtk_builder_add_from_file;

    /// Parses a resource file containing a UI definition
    /// and merges it with the current contents of `builder`.
    ///
    /// This function is useful if you need to call
    /// `gtk.Builder.setCurrentObject` to add user data to
    /// callbacks before loading GtkBuilder UI. Otherwise, you probably
    /// want `gtk.Builder.newFromResource` instead.
    ///
    /// If an error occurs, 0 will be returned and `error` will be assigned a
    /// `GError` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_RESOURCE_ERROR`
    /// domain.
    ///
    /// It’s not really reasonable to attempt to handle failures of this
    /// call.  The only reasonable thing to do when an error is detected is
    /// to call `g_error`.
    extern fn gtk_builder_add_from_resource(p_builder: *Builder, p_resource_path: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const addFromResource = gtk_builder_add_from_resource;

    /// Parses a string containing a UI definition and merges it
    /// with the current contents of `builder`.
    ///
    /// This function is useful if you need to call
    /// `gtk.Builder.setCurrentObject` to add user data to
    /// callbacks before loading `GtkBuilder` UI. Otherwise, you probably
    /// want `gtk.Builder.newFromString` instead.
    ///
    /// Upon errors `FALSE` will be returned and `error` will be assigned a
    /// `GError` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or
    /// `G_VARIANT_PARSE_ERROR` domain.
    ///
    /// It’s not really reasonable to attempt to handle failures of this
    /// call.  The only reasonable thing to do when an error is detected is
    /// to call `g_error`.
    extern fn gtk_builder_add_from_string(p_builder: *Builder, p_buffer: [*:0]const u8, p_length: isize, p_error: ?*?*glib.Error) c_int;
    pub const addFromString = gtk_builder_add_from_string;

    /// Parses a file containing a UI definition building only the
    /// requested objects and merges them with the current contents
    /// of `builder`.
    ///
    /// Upon errors, 0 will be returned and `error` will be assigned a
    /// `GError` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_FILE_ERROR`
    /// domain.
    ///
    /// If you are adding an object that depends on an object that is not
    /// its child (for instance a `GtkTreeView` that depends on its
    /// `GtkTreeModel`), you have to explicitly list all of them in `object_ids`.
    extern fn gtk_builder_add_objects_from_file(p_builder: *Builder, p_filename: [*:0]const u8, p_object_ids: [*][*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const addObjectsFromFile = gtk_builder_add_objects_from_file;

    /// Parses a resource file containing a UI definition, building
    /// only the requested objects and merges them with the current
    /// contents of `builder`.
    ///
    /// Upon errors, 0 will be returned and `error` will be assigned a
    /// `GError` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_RESOURCE_ERROR`
    /// domain.
    ///
    /// If you are adding an object that depends on an object that is not
    /// its child (for instance a `GtkTreeView` that depends on its
    /// `GtkTreeModel`), you have to explicitly list all of them in `object_ids`.
    extern fn gtk_builder_add_objects_from_resource(p_builder: *Builder, p_resource_path: [*:0]const u8, p_object_ids: [*][*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const addObjectsFromResource = gtk_builder_add_objects_from_resource;

    /// Parses a string containing a UI definition, building only the
    /// requested objects and merges them with the current contents of
    /// `builder`.
    ///
    /// Upon errors `FALSE` will be returned and `error` will be assigned a
    /// `GError` from the `GTK_BUILDER_ERROR` or `G_MARKUP_ERROR` domain.
    ///
    /// If you are adding an object that depends on an object that is not
    /// its child (for instance a `GtkTreeView` that depends on its
    /// `GtkTreeModel`), you have to explicitly list all of them in `object_ids`.
    extern fn gtk_builder_add_objects_from_string(p_builder: *Builder, p_buffer: [*:0]const u8, p_length: isize, p_object_ids: [*][*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const addObjectsFromString = gtk_builder_add_objects_from_string;

    /// Creates a closure to invoke the function called `function_name`.
    ///
    /// This is using the `create_closure` implementation of `builder`'s
    /// `gtk.BuilderScope`.
    ///
    /// If no closure could be created, `NULL` will be returned and `error`
    /// will be set.
    extern fn gtk_builder_create_closure(p_builder: *Builder, p_function_name: [*:0]const u8, p_flags: gtk.BuilderClosureFlags, p_object: ?*gobject.Object, p_error: ?*?*glib.Error) ?*gobject.Closure;
    pub const createClosure = gtk_builder_create_closure;

    /// Add `object` to the `builder` object pool so it can be
    /// referenced just like any other object built by builder.
    ///
    /// Only a single object may be added using `name`. However,
    /// it is not an error to expose the same object under multiple
    /// names. ``gtk.Builder.getObject`` may be used to determine
    /// if an object has already been added with `name`.
    extern fn gtk_builder_expose_object(p_builder: *Builder, p_name: [*:0]const u8, p_object: *gobject.Object) void;
    pub const exposeObject = gtk_builder_expose_object;

    /// Main private entry point for building composite components
    /// from template XML.
    ///
    /// Most likely you do not need to call this function in applications as
    /// templates are handled by `GtkWidget`.
    extern fn gtk_builder_extend_with_template(p_builder: *Builder, p_object: *gobject.Object, p_template_type: usize, p_buffer: [*:0]const u8, p_length: isize, p_error: ?*?*glib.Error) c_int;
    pub const extendWithTemplate = gtk_builder_extend_with_template;

    /// Gets the current object set via `gtk.Builder.setCurrentObject`.
    extern fn gtk_builder_get_current_object(p_builder: *Builder) ?*gobject.Object;
    pub const getCurrentObject = gtk_builder_get_current_object;

    /// Gets the object named `name`.
    ///
    /// Note that this function does not increment the reference count
    /// of the returned object.
    extern fn gtk_builder_get_object(p_builder: *Builder, p_name: [*:0]const u8) ?*gobject.Object;
    pub const getObject = gtk_builder_get_object;

    /// Gets all objects that have been constructed by `builder`.
    ///
    /// Note that this function does not increment the reference
    /// counts of the returned objects.
    extern fn gtk_builder_get_objects(p_builder: *Builder) *glib.SList;
    pub const getObjects = gtk_builder_get_objects;

    /// Gets the scope in use that was set via `gtk.Builder.setScope`.
    extern fn gtk_builder_get_scope(p_builder: *Builder) *gtk.BuilderScope;
    pub const getScope = gtk_builder_get_scope;

    /// Gets the translation domain of `builder`.
    extern fn gtk_builder_get_translation_domain(p_builder: *Builder) ?[*:0]const u8;
    pub const getTranslationDomain = gtk_builder_get_translation_domain;

    /// Looks up a type by name.
    ///
    /// This is using the virtual function that `GtkBuilder` has
    /// for that purpose. This is mainly used when implementing
    /// the `GtkBuildable` interface on a type.
    extern fn gtk_builder_get_type_from_name(p_builder: *Builder, p_type_name: [*:0]const u8) usize;
    pub const getTypeFromName = gtk_builder_get_type_from_name;

    /// Sets the current object for the `builder`.
    ///
    /// The current object can be thought of as the `this` object that the
    /// builder is working for and will often be used as the default object
    /// when an object is optional.
    ///
    /// `gtk.Widget.initTemplate` for example will set the current
    /// object to the widget the template is inited for. For functions like
    /// `gtk.Builder.newFromResource`, the current object will be `NULL`.
    extern fn gtk_builder_set_current_object(p_builder: *Builder, p_current_object: ?*gobject.Object) void;
    pub const setCurrentObject = gtk_builder_set_current_object;

    /// Sets the scope the builder should operate in.
    ///
    /// If `scope` is `NULL`, a new `gtk.BuilderCScope` will be created.
    extern fn gtk_builder_set_scope(p_builder: *Builder, p_scope: ?*gtk.BuilderScope) void;
    pub const setScope = gtk_builder_set_scope;

    /// Sets the translation domain of `builder`.
    extern fn gtk_builder_set_translation_domain(p_builder: *Builder, p_domain: ?[*:0]const u8) void;
    pub const setTranslationDomain = gtk_builder_set_translation_domain;

    /// Demarshals a value from a string.
    ///
    /// This function calls `gobject.Value.init` on the `value` argument,
    /// so it need not be initialised beforehand.
    ///
    /// Can handle char, uchar, boolean, int, uint, long,
    /// ulong, enum, flags, float, double, string, `GdkRGBA` and
    /// `GtkAdjustment` type values.
    ///
    /// Upon errors `FALSE` will be returned and `error` will be
    /// assigned a `GError` from the `GTK_BUILDER_ERROR` domain.
    extern fn gtk_builder_value_from_string(p_builder: *Builder, p_pspec: *gobject.ParamSpec, p_string: [*:0]const u8, p_value: *gobject.Value, p_error: ?*?*glib.Error) c_int;
    pub const valueFromString = gtk_builder_value_from_string;

    /// Demarshals a value from a string.
    ///
    /// Unlike `gtk.Builder.valueFromString`, this function
    /// takes a `GType` instead of `GParamSpec`.
    ///
    /// Calls `gobject.Value.init` on the `value` argument, so it
    /// need not be initialised beforehand.
    ///
    /// Upon errors `FALSE` will be returned and `error` will be
    /// assigned a `GError` from the `GTK_BUILDER_ERROR` domain.
    extern fn gtk_builder_value_from_string_type(p_builder: *Builder, p_type: usize, p_string: [*:0]const u8, p_value: *gobject.Value, p_error: ?*?*glib.Error) c_int;
    pub const valueFromStringType = gtk_builder_value_from_string_type;

    extern fn gtk_builder_get_type() usize;
    pub const getGObjectType = gtk_builder_get_type;

    extern fn g_object_ref(p_self: *gtk.Builder) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Builder) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Builder, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkBuilderScope` implementation for the C language.
///
/// `GtkBuilderCScope` instances use symbols explicitly added to `builder`
/// with prior calls to `gtk.BuilderCScope.addCallbackSymbol`.
/// If developers want to do that, they are encouraged to create their
/// own scopes for that purpose.
///
/// In the case that symbols are not explicitly added; GTK will uses
/// `GModule`’s introspective features (by opening the module `NULL`) to
/// look at the application’s symbol table. From here it tries to match
/// the signal function names given in the interface description with
/// symbols in the application.
///
/// Note that unless `gtk.BuilderCScope.addCallbackSymbol` is
/// called for all signal callbacks which are referenced by the loaded XML,
/// this functionality will require that `GModule` be supported on the platform.
pub const BuilderCScope = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{gtk.BuilderScope};
    pub const Class = gtk.BuilderCScopeClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkBuilderCScope` object to use with future
    /// `GtkBuilder` instances.
    ///
    /// Calling this function is only necessary if you want to add
    /// custom callbacks via `gtk.BuilderCScope.addCallbackSymbol`.
    extern fn gtk_builder_cscope_new() *gtk.BuilderCScope;
    pub const new = gtk_builder_cscope_new;

    /// Adds the `callback_symbol` to the scope of `builder` under the
    /// given `callback_name`.
    ///
    /// Using this function overrides the behavior of
    /// `gtk.Builder.createClosure` for any callback symbols that
    /// are added. Using this method allows for better encapsulation as it
    /// does not require that callback symbols be declared in the global
    /// namespace.
    extern fn gtk_builder_cscope_add_callback_symbol(p_self: *BuilderCScope, p_callback_name: [*:0]const u8, p_callback_symbol: gobject.Callback) void;
    pub const addCallbackSymbol = gtk_builder_cscope_add_callback_symbol;

    /// A convenience function to add many callbacks.
    ///
    /// This is equivalent to calling `gtk.BuilderCScope.addCallbackSymbol`
    /// for each symbol.
    extern fn gtk_builder_cscope_add_callback_symbols(p_self: *BuilderCScope, p_first_callback_name: [*:0]const u8, p_first_callback_symbol: gobject.Callback, ...) void;
    pub const addCallbackSymbols = gtk_builder_cscope_add_callback_symbols;

    /// Fetches a symbol previously added with
    /// `gtk.BuilderCScope.addCallbackSymbol`.
    extern fn gtk_builder_cscope_lookup_callback_symbol(p_self: *BuilderCScope, p_callback_name: [*:0]const u8) ?gobject.Callback;
    pub const lookupCallbackSymbol = gtk_builder_cscope_lookup_callback_symbol;

    extern fn gtk_builder_cscope_get_type() usize;
    pub const getGObjectType = gtk_builder_cscope_get_type;

    extern fn g_object_ref(p_self: *gtk.BuilderCScope) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.BuilderCScope) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BuilderCScope, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkBuilderListItemFactory` is a `GtkListItemFactory` that creates
/// widgets by instantiating `GtkBuilder` UI templates.
///
/// The templates must extend the class that the parent widget expects.
/// For example, a factory provided to `gtk.ListView.properties.factory` must have
/// a template that extends `gtk.ListItem`.
///
/// Templates typically use `GtkExpression`s to obtain data from the items
/// in the model.
///
/// Example:
/// ```xml
///   <interface>
///     <template class="GtkListItem">
///       <property name="child">
///         <object class="GtkLabel">
///           <property name="xalign">0</property>
///           <binding name="label">
///             <lookup name="name" type="SettingsKey">
///               <lookup name="item">GtkListItem</lookup>
///             </lookup>
///           </binding>
///         </object>
///       </property>
///     </template>
///   </interface>
/// ```
pub const BuilderListItemFactory = opaque {
    pub const Parent = gtk.ListItemFactory;
    pub const Implements = [_]type{};
    pub const Class = gtk.BuilderListItemFactoryClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// `GBytes` containing the UI definition.
        pub const bytes = struct {
            pub const name = "bytes";

            pub const Type = ?*glib.Bytes;
        };

        /// Path of the resource containing the UI definition.
        pub const resource = struct {
            pub const name = "resource";

            pub const Type = ?[*:0]u8;
        };

        /// `GtkBuilderScope` to use when instantiating listitems
        pub const scope = struct {
            pub const name = "scope";

            pub const Type = ?*gtk.BuilderScope;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkBuilderListItemFactory` that instantiates widgets
    /// using `bytes` as the data to pass to `GtkBuilder`.
    extern fn gtk_builder_list_item_factory_new_from_bytes(p_scope: ?*gtk.BuilderScope, p_bytes: *glib.Bytes) *gtk.BuilderListItemFactory;
    pub const newFromBytes = gtk_builder_list_item_factory_new_from_bytes;

    /// Creates a new `GtkBuilderListItemFactory` that instantiates widgets
    /// using data read from the given `resource_path` to pass to `GtkBuilder`.
    extern fn gtk_builder_list_item_factory_new_from_resource(p_scope: ?*gtk.BuilderScope, p_resource_path: [*:0]const u8) *gtk.BuilderListItemFactory;
    pub const newFromResource = gtk_builder_list_item_factory_new_from_resource;

    /// Gets the data used as the `GtkBuilder` UI template for constructing
    /// listitems.
    extern fn gtk_builder_list_item_factory_get_bytes(p_self: *BuilderListItemFactory) *glib.Bytes;
    pub const getBytes = gtk_builder_list_item_factory_get_bytes;

    /// If the data references a resource, gets the path of that resource.
    extern fn gtk_builder_list_item_factory_get_resource(p_self: *BuilderListItemFactory) ?[*:0]const u8;
    pub const getResource = gtk_builder_list_item_factory_get_resource;

    /// Gets the scope used when constructing listitems.
    extern fn gtk_builder_list_item_factory_get_scope(p_self: *BuilderListItemFactory) ?*gtk.BuilderScope;
    pub const getScope = gtk_builder_list_item_factory_get_scope;

    extern fn gtk_builder_list_item_factory_get_type() usize;
    pub const getGObjectType = gtk_builder_list_item_factory_get_type;

    extern fn g_object_ref(p_self: *gtk.BuilderListItemFactory) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.BuilderListItemFactory) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BuilderListItemFactory, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkButton` widget is generally used to trigger a callback function that is
/// called when the button is pressed.
///
/// ![An example GtkButton](button.png)
///
/// The `GtkButton` widget can hold any valid child widget. That is, it can hold
/// almost any other standard `GtkWidget`. The most commonly used child is the
/// `GtkLabel`.
///
/// # Shortcuts and Gestures
///
/// The following signals have default keybindings:
///
/// - `gtk.Button.signals.activate`
///
/// # CSS nodes
///
/// `GtkButton` has a single CSS node with name button. The node will get the
/// style classes .image-button or .text-button, if the content is just an
/// image or label, respectively. It may also receive the .flat style class.
/// When activating a button via the keyboard, the button will temporarily
/// gain the .keyboard-activating style class.
///
/// Other style classes that are commonly used with `GtkButton` include
/// .suggested-action and .destructive-action. In special cases, buttons
/// can be made round by adding the .circular style class.
///
/// Button-like widgets like `gtk.ToggleButton`, `gtk.MenuButton`,
/// `gtk.VolumeButton`, `gtk.LockButton`, `gtk.ColorButton`
/// or `gtk.FontButton` use style classes such as .toggle, .popup, .scale,
/// .lock, .color on the button node to differentiate themselves from a plain
/// `GtkButton`.
///
/// # Accessibility
///
/// `GtkButton` uses the `GTK_ACCESSIBLE_ROLE_BUTTON` role.
pub const Button = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Actionable, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.ButtonClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        /// Signal that causes the button to animate press then
        ///    release. Applications should never connect to this signal, but use
        ///    the `clicked` signal.
        pub const activate = struct {
            pub fn call(p_class: anytype, p_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Button.Class, p_class).f_activate.?(gobject.ext.as(Button, p_button));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Button.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };

        /// Signal emitted when the button has been activated (pressed and released).
        pub const clicked = struct {
            pub fn call(p_class: anytype, p_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Button.Class, p_class).f_clicked.?(gobject.ext.as(Button, p_button));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Button.Class, p_class).f_clicked = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// Whether the size of the button can be made smaller than the natural
        /// size of its contents.
        ///
        /// For text buttons, setting this property will allow ellipsizing the label.
        ///
        /// If the contents of a button are an icon or a custom widget, setting this
        /// property has no effect.
        pub const can_shrink = struct {
            pub const name = "can-shrink";

            pub const Type = c_int;
        };

        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// Whether the button has a frame.
        pub const has_frame = struct {
            pub const name = "has-frame";

            pub const Type = c_int;
        };

        /// The name of the icon used to automatically populate the button.
        pub const icon_name = struct {
            pub const name = "icon-name";

            pub const Type = ?[*:0]u8;
        };

        /// Text of the label inside the button, if the button contains a label widget.
        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };

        /// If set, an underline in the text indicates that the following character is
        /// to be used as mnemonic.
        pub const use_underline = struct {
            pub const name = "use-underline";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted to animate press then release.
        ///
        /// This is an action signal. Applications should never connect
        /// to this signal, but use the `gtk.Button.signals.clicked` signal.
        ///
        /// The default bindings for this signal are all forms of the
        /// <kbd>␣</kbd> and <kbd>Enter</kbd> keys.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Button, p_instance))),
                    gobject.signalLookup("activate", Button.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the button has been activated (pressed and released).
        pub const clicked = struct {
            pub const name = "clicked";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Button, p_instance))),
                    gobject.signalLookup("clicked", Button.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkButton` widget.
    ///
    /// To add a child widget to the button, use `gtk.Button.setChild`.
    extern fn gtk_button_new() *gtk.Button;
    pub const new = gtk_button_new;

    /// Creates a new button containing an icon from the current icon theme.
    ///
    /// If the icon name isn’t known, a “broken image” icon will be
    /// displayed instead. If the current icon theme is changed, the icon
    /// will be updated appropriately.
    extern fn gtk_button_new_from_icon_name(p_icon_name: [*:0]const u8) *gtk.Button;
    pub const newFromIconName = gtk_button_new_from_icon_name;

    /// Creates a `GtkButton` widget with a `GtkLabel` child.
    extern fn gtk_button_new_with_label(p_label: [*:0]const u8) *gtk.Button;
    pub const newWithLabel = gtk_button_new_with_label;

    /// Creates a new `GtkButton` containing a label.
    ///
    /// If characters in `label` are preceded by an underscore, they are underlined.
    /// If you need a literal underscore character in a label, use “__” (two
    /// underscores). The first underlined character represents a keyboard
    /// accelerator called a mnemonic. Pressing <kbd>Alt</kbd> and that key
    /// activates the button.
    extern fn gtk_button_new_with_mnemonic(p_label: [*:0]const u8) *gtk.Button;
    pub const newWithMnemonic = gtk_button_new_with_mnemonic;

    /// Retrieves whether the button can be smaller than the natural
    /// size of its contents.
    extern fn gtk_button_get_can_shrink(p_button: *Button) c_int;
    pub const getCanShrink = gtk_button_get_can_shrink;

    /// Gets the child widget of `button`.
    extern fn gtk_button_get_child(p_button: *Button) ?*gtk.Widget;
    pub const getChild = gtk_button_get_child;

    /// Returns whether the button has a frame.
    extern fn gtk_button_get_has_frame(p_button: *Button) c_int;
    pub const getHasFrame = gtk_button_get_has_frame;

    /// Returns the icon name of the button.
    ///
    /// If the icon name has not been set with `gtk.Button.setIconName`
    /// the return value will be `NULL`. This will be the case if you create
    /// an empty button with `gtk.Button.new` to use as a container.
    extern fn gtk_button_get_icon_name(p_button: *Button) ?[*:0]const u8;
    pub const getIconName = gtk_button_get_icon_name;

    /// Fetches the text from the label of the button.
    ///
    /// If the label text has not been set with `gtk.Button.setLabel`
    /// the return value will be `NULL`. This will be the case if you create
    /// an empty button with `gtk.Button.new` to use as a container.
    extern fn gtk_button_get_label(p_button: *Button) ?[*:0]const u8;
    pub const getLabel = gtk_button_get_label;

    /// gets whether underlines are interpreted as mnemonics.
    ///
    /// See `gtk.Button.setUseUnderline`.
    extern fn gtk_button_get_use_underline(p_button: *Button) c_int;
    pub const getUseUnderline = gtk_button_get_use_underline;

    /// Sets whether the button size can be smaller than the natural size of
    /// its contents.
    ///
    /// For text buttons, setting `can_shrink` to true will ellipsize the label.
    ///
    /// For icons and custom children, this function has no effect.
    extern fn gtk_button_set_can_shrink(p_button: *Button, p_can_shrink: c_int) void;
    pub const setCanShrink = gtk_button_set_can_shrink;

    /// Sets the child widget of `button`.
    ///
    /// Note that by using this API, you take full responsibility for setting
    /// up the proper accessibility label and description information for `button`.
    /// Most likely, you'll either set the accessibility label or description
    /// for `button` explicitly, or you'll set a labelled-by or described-by
    /// relations from `child` to `button`.
    extern fn gtk_button_set_child(p_button: *Button, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_button_set_child;

    /// Sets the style of the button.
    ///
    /// Buttons can have a flat appearance or have a frame drawn around them.
    extern fn gtk_button_set_has_frame(p_button: *Button, p_has_frame: c_int) void;
    pub const setHasFrame = gtk_button_set_has_frame;

    /// Adds a `GtkImage` with the given icon name as a child.
    ///
    /// If `button` already contains a child widget, that child widget will
    /// be removed and replaced with the image.
    extern fn gtk_button_set_icon_name(p_button: *Button, p_icon_name: [*:0]const u8) void;
    pub const setIconName = gtk_button_set_icon_name;

    /// Sets the text of the label of the button to `label`.
    ///
    /// This will also clear any previously set labels.
    extern fn gtk_button_set_label(p_button: *Button, p_label: [*:0]const u8) void;
    pub const setLabel = gtk_button_set_label;

    /// Sets whether to use underlines as mnemonics.
    ///
    /// If true, an underline in the text of the button label indicates
    /// the next character should be used for the mnemonic accelerator key.
    extern fn gtk_button_set_use_underline(p_button: *Button, p_use_underline: c_int) void;
    pub const setUseUnderline = gtk_button_set_use_underline;

    extern fn gtk_button_get_type() usize;
    pub const getGObjectType = gtk_button_get_type;

    extern fn g_object_ref(p_self: *gtk.Button) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Button) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Button, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A variant of `GtkClosureExpression` using a C closure.
pub const CClosureExpression = opaque {
    pub const Parent = gtk.Expression;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CClosureExpression;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a `GtkExpression` that calls `callback_func` when it is evaluated.
    ///
    /// This function is a variant of `gtk.ClosureExpression.new` that
    /// creates a `GClosure` by calling `gobject.cclosureNew` with the given
    /// `callback_func`, `user_data` and `user_destroy`.
    extern fn gtk_cclosure_expression_new(p_value_type: usize, p_marshal: ?gobject.ClosureMarshal, p_n_params: c_uint, p_params: [*]*gtk.Expression, p_callback_func: gobject.Callback, p_user_data: ?*anyopaque, p_user_destroy: ?gobject.ClosureNotify) *gtk.CClosureExpression;
    pub const new = gtk_cclosure_expression_new;

    extern fn gtk_cclosure_expression_get_type() usize;
    pub const getGObjectType = gtk_cclosure_expression_get_type;

    pub fn as(p_instance: *CClosureExpression, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCalendar` is a widget that displays a Gregorian calendar, one month
/// at a time.
///
/// ![An example GtkCalendar](calendar.png)
///
/// A `GtkCalendar` can be created with `gtk.Calendar.new`.
///
/// The date that is currently displayed can be altered with
/// `gtk.Calendar.selectDay`.
///
/// To place a visual marker on a particular day, use
/// `gtk.Calendar.markDay` and to remove the marker,
/// `gtk.Calendar.unmarkDay`. Alternative, all
/// marks can be cleared with `gtk.Calendar.clearMarks`.
///
/// The selected date can be retrieved from a `GtkCalendar` using
/// `gtk.Calendar.getDate`.
///
/// Users should be aware that, although the Gregorian calendar is the
/// legal calendar in most countries, it was adopted progressively
/// between 1582 and 1929. Display before these dates is likely to be
/// historically incorrect.
///
/// # Shortcuts and Gestures
///
/// `GtkCalendar` supports the following gestures:
///
/// - Scrolling up or down will switch to the previous or next month.
/// - Date strings can be dropped for setting the current day.
///
/// # CSS nodes
///
/// ```
/// calendar.view
/// ├── header
/// │   ├── button
/// │   ├── stack.month
/// │   ├── button
/// │   ├── button
/// │   ├── label.year
/// │   ╰── button
/// ╰── grid
///     ╰── label[.day-name][.week-number][.day-number][.other-month][.today]
/// ```
///
/// `GtkCalendar` has a main node with name calendar. It contains a subnode
/// called header containing the widgets for switching between years and months.
///
/// The grid subnode contains all day labels, including week numbers on the left
/// (marked with the .week-number css class) and day names on top (marked with the
/// .day-name css class).
///
/// Day labels that belong to the previous or next month get the .other-month
/// style class. The label of the current day get the .today style class.
///
/// Marked day labels get the :selected state assigned.
pub const Calendar = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = Calendar;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The selected day (as a number between 1 and 31).
        pub const day = struct {
            pub const name = "day";

            pub const Type = c_int;
        };

        /// The selected month (as a number between 0 and 11).
        ///
        /// This property gets initially set to the current month.
        pub const month = struct {
            pub const name = "month";

            pub const Type = c_int;
        };

        /// Determines whether day names are displayed.
        pub const show_day_names = struct {
            pub const name = "show-day-names";

            pub const Type = c_int;
        };

        /// Determines whether a heading is displayed.
        pub const show_heading = struct {
            pub const name = "show-heading";

            pub const Type = c_int;
        };

        /// Determines whether week numbers are displayed.
        pub const show_week_numbers = struct {
            pub const name = "show-week-numbers";

            pub const Type = c_int;
        };

        /// The selected year.
        ///
        /// This property gets initially set to the current year.
        pub const year = struct {
            pub const name = "year";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the user selects a day.
        pub const day_selected = struct {
            pub const name = "day-selected";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Calendar, p_instance))),
                    gobject.signalLookup("day-selected", Calendar.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user switched to the next month.
        pub const next_month = struct {
            pub const name = "next-month";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Calendar, p_instance))),
                    gobject.signalLookup("next-month", Calendar.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when user switched to the next year.
        pub const next_year = struct {
            pub const name = "next-year";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Calendar, p_instance))),
                    gobject.signalLookup("next-year", Calendar.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user switched to the previous month.
        pub const prev_month = struct {
            pub const name = "prev-month";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Calendar, p_instance))),
                    gobject.signalLookup("prev-month", Calendar.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when user switched to the previous year.
        pub const prev_year = struct {
            pub const name = "prev-year";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Calendar, p_instance))),
                    gobject.signalLookup("prev-year", Calendar.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new calendar, with the current date being selected.
    extern fn gtk_calendar_new() *gtk.Calendar;
    pub const new = gtk_calendar_new;

    /// Remove all visual markers.
    extern fn gtk_calendar_clear_marks(p_calendar: *Calendar) void;
    pub const clearMarks = gtk_calendar_clear_marks;

    /// Returns a `GDateTime` representing the shown
    /// year, month and the selected day.
    ///
    /// The returned date is in the local time zone.
    extern fn gtk_calendar_get_date(p_self: *Calendar) *glib.DateTime;
    pub const getDate = gtk_calendar_get_date;

    /// Gets the day of the selected date.
    extern fn gtk_calendar_get_day(p_self: *Calendar) c_int;
    pub const getDay = gtk_calendar_get_day;

    /// Returns if the `day` of the `calendar` is already marked.
    extern fn gtk_calendar_get_day_is_marked(p_calendar: *Calendar, p_day: c_uint) c_int;
    pub const getDayIsMarked = gtk_calendar_get_day_is_marked;

    /// Gets the month of the selected date.
    extern fn gtk_calendar_get_month(p_self: *Calendar) c_int;
    pub const getMonth = gtk_calendar_get_month;

    /// Returns whether `self` is currently showing the names
    /// of the week days.
    ///
    /// This is the value of the `gtk.Calendar.properties.show_day_names`
    /// property.
    extern fn gtk_calendar_get_show_day_names(p_self: *Calendar) c_int;
    pub const getShowDayNames = gtk_calendar_get_show_day_names;

    /// Returns whether `self` is currently showing the heading.
    ///
    /// This is the value of the `gtk.Calendar.properties.show_heading`
    /// property.
    extern fn gtk_calendar_get_show_heading(p_self: *Calendar) c_int;
    pub const getShowHeading = gtk_calendar_get_show_heading;

    /// Returns whether `self` is showing week numbers right
    /// now.
    ///
    /// This is the value of the `gtk.Calendar.properties.show_week_numbers`
    /// property.
    extern fn gtk_calendar_get_show_week_numbers(p_self: *Calendar) c_int;
    pub const getShowWeekNumbers = gtk_calendar_get_show_week_numbers;

    /// Gets the year of the selected date.
    extern fn gtk_calendar_get_year(p_self: *Calendar) c_int;
    pub const getYear = gtk_calendar_get_year;

    /// Places a visual marker on a particular day of the current month.
    extern fn gtk_calendar_mark_day(p_calendar: *Calendar, p_day: c_uint) void;
    pub const markDay = gtk_calendar_mark_day;

    /// Switches to `date`'s year and month and select its day.
    extern fn gtk_calendar_select_day(p_self: *Calendar, p_date: *glib.DateTime) void;
    pub const selectDay = gtk_calendar_select_day;

    /// Sets the day for the selected date.
    ///
    /// The new date must be valid. For example, setting 31 for the day when the
    /// month is February, fails.
    extern fn gtk_calendar_set_day(p_self: *Calendar, p_day: c_int) void;
    pub const setDay = gtk_calendar_set_day;

    /// Sets the month for the selected date.
    ///
    /// The new date must be valid. For example, setting 1 (February) for the month
    /// when the day is 31, fails.
    extern fn gtk_calendar_set_month(p_self: *Calendar, p_month: c_int) void;
    pub const setMonth = gtk_calendar_set_month;

    /// Sets whether the calendar shows day names.
    extern fn gtk_calendar_set_show_day_names(p_self: *Calendar, p_value: c_int) void;
    pub const setShowDayNames = gtk_calendar_set_show_day_names;

    /// Sets whether the calendar should show a heading.
    ///
    /// The heading contains the current year and month as well as
    /// buttons for changing both.
    extern fn gtk_calendar_set_show_heading(p_self: *Calendar, p_value: c_int) void;
    pub const setShowHeading = gtk_calendar_set_show_heading;

    /// Sets whether week numbers are shown in the calendar.
    extern fn gtk_calendar_set_show_week_numbers(p_self: *Calendar, p_value: c_int) void;
    pub const setShowWeekNumbers = gtk_calendar_set_show_week_numbers;

    /// Sets the year for the selected date.
    ///
    /// The new date must be valid. For example, setting 2023 for the year when then
    /// the date is 2024-02-29, fails.
    extern fn gtk_calendar_set_year(p_self: *Calendar, p_year: c_int) void;
    pub const setYear = gtk_calendar_set_year;

    /// Removes the visual marker from a particular day.
    extern fn gtk_calendar_unmark_day(p_calendar: *Calendar, p_day: c_uint) void;
    pub const unmarkDay = gtk_calendar_unmark_day;

    extern fn gtk_calendar_get_type() usize;
    pub const getGObjectType = gtk_calendar_get_type;

    extern fn g_object_ref(p_self: *gtk.Calendar) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Calendar) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Calendar, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkShortcutAction` that invokes a callback.
pub const CallbackAction = opaque {
    pub const Parent = gtk.ShortcutAction;
    pub const Implements = [_]type{};
    pub const Class = gtk.CallbackActionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Create a custom action that calls the given `callback` when
    /// activated.
    extern fn gtk_callback_action_new(p_callback: gtk.ShortcutFunc, p_data: ?*anyopaque, p_destroy: ?glib.DestroyNotify) *gtk.CallbackAction;
    pub const new = gtk_callback_action_new;

    extern fn gtk_callback_action_get_type() usize;
    pub const getGObjectType = gtk_callback_action_get_type;

    extern fn g_object_ref(p_self: *gtk.CallbackAction) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CallbackAction) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CallbackAction, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An abstract class for laying out `GtkCellRenderer`s
///
/// The `GtkCellArea` is an abstract class for `gtk.CellLayout`
/// widgets (also referred to as "layouting widgets") to interface with
/// an arbitrary number of `gtk.CellRenderer`s and interact with the user
/// for a given `gtk.TreeModel` row.
///
/// The cell area handles events, focus navigation, drawing and
/// size requests and allocations for a given row of data.
///
/// Usually users dont have to interact with the `GtkCellArea` directly
/// unless they are implementing a cell-layouting widget themselves.
///
/// ## Requesting area sizes
///
/// As outlined in
/// [GtkWidget’s geometry management section](class.Widget.html`height`-for-width-geometry-management),
/// GTK uses a height-for-width
/// geometry management system to compute the sizes of widgets and user
/// interfaces. `GtkCellArea` uses the same semantics to calculate the
/// size of an area for an arbitrary number of `GtkTreeModel` rows.
///
/// When requesting the size of a cell area one needs to calculate
/// the size for a handful of rows, and this will be done differently by
/// different layouting widgets. For instance a `gtk.TreeViewColumn`
/// always lines up the areas from top to bottom while a `gtk.IconView`
/// on the other hand might enforce that all areas received the same
/// width and wrap the areas around, requesting height for more cell
/// areas when allocated less width.
///
/// It’s also important for areas to maintain some cell
/// alignments with areas rendered for adjacent rows (cells can
/// appear “columnized” inside an area even when the size of
/// cells are different in each row). For this reason the `GtkCellArea`
/// uses a `gtk.CellAreaContext` object to store the alignments
/// and sizes along the way (as well as the overall largest minimum
/// and natural size for all the rows which have been calculated
/// with the said context).
///
/// The `gtk.CellAreaContext` is an opaque object specific to the
/// `GtkCellArea` which created it (see `gtk.CellArea.createContext`).
///
/// The owning cell-layouting widget can create as many contexts as
/// it wishes to calculate sizes of rows which should receive the
/// same size in at least one orientation (horizontally or vertically),
/// However, it’s important that the same `gtk.CellAreaContext` which
/// was used to request the sizes for a given `GtkTreeModel` row be
/// used when rendering or processing events for that row.
///
/// In order to request the width of all the rows at the root level
/// of a `GtkTreeModel` one would do the following:
///
/// ```c
/// GtkTreeIter iter;
/// int minimum_width;
/// int natural_width;
///
/// valid = gtk_tree_model_get_iter_first (model, &iter);
/// while (valid)
///   {
///     gtk_cell_area_apply_attributes (area, model, &iter, FALSE, FALSE);
///     gtk_cell_area_get_preferred_width (area, context, widget, NULL, NULL);
///
///     valid = gtk_tree_model_iter_next (model, &iter);
///   }
///
/// gtk_cell_area_context_get_preferred_width (context, &minimum_width, &natural_width);
/// ```
///
/// Note that in this example it’s not important to observe the
/// returned minimum and natural width of the area for each row
/// unless the cell-layouting object is actually interested in the
/// widths of individual rows. The overall width is however stored
/// in the accompanying `GtkCellAreaContext` object and can be consulted
/// at any time.
///
/// This can be useful since `GtkCellLayout` widgets usually have to
/// support requesting and rendering rows in treemodels with an
/// exceedingly large amount of rows. The `GtkCellLayout` widget in
/// that case would calculate the required width of the rows in an
/// idle or timeout source (see `glib.timeoutAdd`) and when the widget
/// is requested its actual width in `gtk.Widget.virtual_methods.measure`
/// it can simply consult the width accumulated so far in the
/// `GtkCellAreaContext` object.
///
/// A simple example where rows are rendered from top to bottom and
/// take up the full width of the layouting widget would look like:
///
/// ```c
/// static void
/// foo_get_preferred_width (GtkWidget *widget,
///                          int       *minimum_size,
///                          int       *natural_size)
/// {
///   Foo *self = FOO (widget);
///   FooPrivate *priv = foo_get_instance_private (self);
///
///   foo_ensure_at_least_one_handfull_of_rows_have_been_requested (self);
///
///   gtk_cell_area_context_get_preferred_width (priv->context, minimum_size, natural_size);
/// }
/// ```
///
/// In the above example the `Foo` widget has to make sure that some
/// row sizes have been calculated (the amount of rows that `Foo` judged
/// was appropriate to request space for in a single timeout iteration)
/// before simply returning the amount of space required by the area via
/// the `GtkCellAreaContext`.
///
/// Requesting the height for width (or width for height) of an area is
/// a similar task except in this case the `GtkCellAreaContext` does not
/// store the data (actually, it does not know how much space the layouting
/// widget plans to allocate it for every row. It’s up to the layouting
/// widget to render each row of data with the appropriate height and
/// width which was requested by the `GtkCellArea`).
///
/// In order to request the height for width of all the rows at the
/// root level of a `GtkTreeModel` one would do the following:
///
/// ```c
/// GtkTreeIter iter;
/// int minimum_height;
/// int natural_height;
/// int full_minimum_height = 0;
/// int full_natural_height = 0;
///
/// valid = gtk_tree_model_get_iter_first (model, &iter);
/// while (valid)
///   {
///     gtk_cell_area_apply_attributes (area, model, &iter, FALSE, FALSE);
///     gtk_cell_area_get_preferred_height_for_width (area, context, widget,
///                                                   width, &minimum_height, &natural_height);
///
///     if (width_is_for_allocation)
///        cache_row_height (&iter, minimum_height, natural_height);
///
///     full_minimum_height += minimum_height;
///     full_natural_height += natural_height;
///
///     valid = gtk_tree_model_iter_next (model, &iter);
///   }
/// ```
///
/// Note that in the above example we would need to cache the heights
/// returned for each row so that we would know what sizes to render the
/// areas for each row. However we would only want to really cache the
/// heights if the request is intended for the layouting widgets real
/// allocation.
///
/// In some cases the layouting widget is requested the height for an
/// arbitrary for_width, this is a special case for layouting widgets
/// who need to request size for tens of thousands  of rows. For this
/// case it’s only important that the layouting widget calculate
/// one reasonably sized chunk of rows and return that height
/// synchronously. The reasoning here is that any layouting widget is
/// at least capable of synchronously calculating enough height to fill
/// the screen height (or scrolled window height) in response to a single
/// call to `gtk.Widget.virtual_methods.measure`. Returning
/// a perfect height for width that is larger than the screen area is
/// inconsequential since after the layouting receives an allocation
/// from a scrolled window it simply continues to drive the scrollbar
/// values while more and more height is required for the row heights
/// that are calculated in the background.
///
/// ## Rendering Areas
///
/// Once area sizes have been acquired at least for the rows in the
/// visible area of the layouting widget they can be rendered at
/// `gtk.Widget.virtual_methods.snapshot` time.
///
/// A crude example of how to render all the rows at the root level
/// runs as follows:
///
/// ```c
/// GtkAllocation allocation;
/// GdkRectangle cell_area = { 0, };
/// GtkTreeIter iter;
/// int minimum_width;
/// int natural_width;
///
/// gtk_widget_get_allocation (widget, &allocation);
/// cell_area.width = allocation.width;
///
/// valid = gtk_tree_model_get_iter_first (model, &iter);
/// while (valid)
///   {
///     cell_area.height = get_cached_height_for_row (&iter);
///
///     gtk_cell_area_apply_attributes (area, model, &iter, FALSE, FALSE);
///     gtk_cell_area_render (area, context, widget, cr,
///                           &cell_area, &cell_area, state_flags, FALSE);
///
///     cell_area.y += cell_area.height;
///
///     valid = gtk_tree_model_iter_next (model, &iter);
///   }
/// ```
///
/// Note that the cached height in this example really depends on how
/// the layouting widget works. The layouting widget might decide to
/// give every row its minimum or natural height or, if the model content
/// is expected to fit inside the layouting widget without scrolling, it
/// would make sense to calculate the allocation for each row at
/// the time the widget is allocated using `gtk.distributeNaturalAllocation`.
///
/// ## Handling Events and Driving Keyboard Focus
///
/// Passing events to the area is as simple as handling events on any
/// normal widget and then passing them to the `gtk.CellArea.event`
/// API as they come in. Usually `GtkCellArea` is only interested in
/// button events, however some customized derived areas can be implemented
/// who are interested in handling other events. Handling an event can
/// trigger the `gtk.CellArea.signals.focus_changed` signal to fire; as well
/// as `gtk.CellArea.signals.add_editable` in the case that an editable cell
/// was clicked and needs to start editing. You can call
/// `gtk.CellArea.stopEditing` at any time to cancel any cell editing
/// that is currently in progress.
///
/// The `GtkCellArea` drives keyboard focus from cell to cell in a way
/// similar to `GtkWidget`. For layouting widgets that support giving
/// focus to cells it’s important to remember to pass `GTK_CELL_RENDERER_FOCUSED`
/// to the area functions for the row that has focus and to tell the
/// area to paint the focus at render time.
///
/// Layouting widgets that accept focus on cells should implement the
/// `gtk.Widget.virtual_methods.focus` virtual method. The layouting widget is always
/// responsible for knowing where `GtkTreeModel` rows are rendered inside
/// the widget, so at `gtk.Widget.virtual_methods.focus` time the layouting widget
/// should use the `GtkCellArea` methods to navigate focus inside the area
/// and then observe the `gtk.DirectionType` to pass the focus to adjacent
/// rows and areas.
///
/// A basic example of how the `gtk.Widget.virtual_methods.focus` virtual method
/// should be implemented:
///
/// ```
/// static gboolean
/// foo_focus (GtkWidget       *widget,
///            GtkDirectionType direction)
/// {
///   Foo *self = FOO (widget);
///   FooPrivate *priv = foo_get_instance_private (self);
///   int focus_row = priv->focus_row;
///   gboolean have_focus = FALSE;
///
///   if (!gtk_widget_has_focus (widget))
///     gtk_widget_grab_focus (widget);
///
///   valid = gtk_tree_model_iter_nth_child (priv->model, &iter, NULL, priv->focus_row);
///   while (valid)
///     {
///       gtk_cell_area_apply_attributes (priv->area, priv->model, &iter, FALSE, FALSE);
///
///       if (gtk_cell_area_focus (priv->area, direction))
///         {
///            priv->focus_row = focus_row;
///            have_focus = TRUE;
///            break;
///         }
///       else
///         {
///           if (direction == GTK_DIR_RIGHT ||
///               direction == GTK_DIR_LEFT)
///             break;
///           else if (direction == GTK_DIR_UP ||
///                    direction == GTK_DIR_TAB_BACKWARD)
///            {
///               if (focus_row == 0)
///                 break;
///               else
///                {
///                   focus_row--;
///                   valid = gtk_tree_model_iter_nth_child (priv->model, &iter, NULL, focus_row);
///                }
///             }
///           else
///             {
///               if (focus_row == last_row)
///                 break;
///               else
///                 {
///                   focus_row++;
///                   valid = gtk_tree_model_iter_next (priv->model, &iter);
///                 }
///             }
///         }
///     }
///     return have_focus;
/// }
/// ```
///
/// Note that the layouting widget is responsible for matching the
/// `GtkDirectionType` values to the way it lays out its cells.
///
/// ## Cell Properties
///
/// The `GtkCellArea` introduces cell properties for `GtkCellRenderer`s.
/// This provides some general interfaces for defining the relationship
/// cell areas have with their cells. For instance in a `gtk.CellAreaBox`
/// a cell might “expand” and receive extra space when the area is allocated
/// more than its full natural request, or a cell might be configured to “align”
/// with adjacent rows which were requested and rendered with the same
/// `GtkCellAreaContext`.
///
/// Use `gtk.CellAreaClass.installCellProperty` to install cell
/// properties for a cell area class and `gtk.CellAreaClass.findCellProperty`
/// or `gtk.CellAreaClass.listCellProperties` to get information about
/// existing cell properties.
///
/// To set the value of a cell property, use `gtk.CellArea.cellSetProperty`,
/// `gtk.CellArea.cellSet` or `gtk.CellArea.cellSetValist`. To obtain
/// the value of a cell property, use `gtk.CellArea.cellGetProperty`
/// `gtk.CellArea.cellGet` or `gtk.CellArea.cellGetValist`.
pub const CellArea = extern struct {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{ gtk.Buildable, gtk.CellLayout };
    pub const Class = gtk.CellAreaClass;
    f_parent_instance: gobject.InitiallyUnowned,

    pub const virtual_methods = struct {
        /// Activates `area`, usually by activating the currently focused
        /// cell, however some subclasses which embed widgets in the area
        /// can also activate a widget if it currently has the focus.
        pub const activate = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState, p_edit_only: c_int) c_int {
                return gobject.ext.as(CellArea.Class, p_class).f_activate.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_cell_area, p_flags, p_edit_only);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState, p_edit_only: c_int) callconv(.C) c_int) void {
                gobject.ext.as(CellArea.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };

        /// Adds `renderer` to `area` with the default child cell properties.
        pub const add = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer) void {
                return gobject.ext.as(CellArea.Class, p_class).f_add.?(gobject.ext.as(CellArea, p_area), p_renderer);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_add = @ptrCast(p_implementation);
            }
        };

        /// Applies any connected attributes to the renderers in
        /// `area` by pulling the values from `tree_model`.
        pub const apply_attributes = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_tree_model: *gtk.TreeModel, p_iter: *gtk.TreeIter, p_is_expander: c_int, p_is_expanded: c_int) void {
                return gobject.ext.as(CellArea.Class, p_class).f_apply_attributes.?(gobject.ext.as(CellArea, p_area), p_tree_model, p_iter, p_is_expander, p_is_expanded);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_tree_model: *gtk.TreeModel, p_iter: *gtk.TreeIter, p_is_expander: c_int, p_is_expanded: c_int) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_apply_attributes = @ptrCast(p_implementation);
            }
        };

        /// This is sometimes needed for cases where rows need to share
        /// alignments in one orientation but may be separately grouped
        /// in the opposing orientation.
        ///
        /// For instance, `GtkIconView` creates all icons (rows) to have
        /// the same width and the cells theirin to have the same
        /// horizontal alignments. However each row of icons may have
        /// a separate collective height. `GtkIconView` uses this to
        /// request the heights of each row based on a context which
        /// was already used to request all the row widths that are
        /// to be displayed.
        pub const copy_context = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext) *gtk.CellAreaContext {
                return gobject.ext.as(CellArea.Class, p_class).f_copy_context.?(gobject.ext.as(CellArea, p_area), p_context);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext) callconv(.C) *gtk.CellAreaContext) void {
                gobject.ext.as(CellArea.Class, p_class).f_copy_context = @ptrCast(p_implementation);
            }
        };

        /// Creates a `GtkCellArea`Context to be used with `area` for
        /// all purposes. `GtkCellArea`Context stores geometry information
        /// for rows for which it was operated on, it is important to use
        /// the same context for the same row of data at all times (i.e.
        /// one should render and handle events with the same `GtkCellArea`Context
        /// which was used to request the size of those rows of data).
        pub const create_context = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) *gtk.CellAreaContext {
                return gobject.ext.as(CellArea.Class, p_class).f_create_context.?(gobject.ext.as(CellArea, p_area));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) *gtk.CellAreaContext) void {
                gobject.ext.as(CellArea.Class, p_class).f_create_context = @ptrCast(p_implementation);
            }
        };

        /// Delegates event handling to a `GtkCellArea`.
        pub const event = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_event: *gdk.Event, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) c_int {
                return gobject.ext.as(CellArea.Class, p_class).f_event.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_event, p_cell_area, p_flags);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_event: *gdk.Event, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) callconv(.C) c_int) void {
                gobject.ext.as(CellArea.Class, p_class).f_event = @ptrCast(p_implementation);
            }
        };

        /// This should be called by the `area`’s owning layout widget
        /// when focus is to be passed to `area`, or moved within `area`
        /// for a given `direction` and row data.
        ///
        /// Implementing `GtkCellArea` classes should implement this
        /// method to receive and navigate focus in its own way particular
        /// to how it lays out cells.
        pub const focus = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_direction: gtk.DirectionType) c_int {
                return gobject.ext.as(CellArea.Class, p_class).f_focus.?(gobject.ext.as(CellArea, p_area), p_direction);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_direction: gtk.DirectionType) callconv(.C) c_int) void {
                gobject.ext.as(CellArea.Class, p_class).f_focus = @ptrCast(p_implementation);
            }
        };

        /// Calls `callback` for every `GtkCellRenderer` in `area`.
        pub const foreach = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_callback: gtk.CellCallback, p_callback_data: ?*anyopaque) void {
                return gobject.ext.as(CellArea.Class, p_class).f_foreach.?(gobject.ext.as(CellArea, p_area), p_callback, p_callback_data);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_callback: gtk.CellCallback, p_callback_data: ?*anyopaque) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_foreach = @ptrCast(p_implementation);
            }
        };

        /// Calls `callback` for every `GtkCellRenderer` in `area` with the
        /// allocated rectangle inside `cell_area`.
        pub const foreach_alloc = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_background_area: *const gdk.Rectangle, p_callback: gtk.CellAllocCallback, p_callback_data: ?*anyopaque) void {
                return gobject.ext.as(CellArea.Class, p_class).f_foreach_alloc.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_cell_area, p_background_area, p_callback, p_callback_data);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_background_area: *const gdk.Rectangle, p_callback: gtk.CellAllocCallback, p_callback_data: ?*anyopaque) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_foreach_alloc = @ptrCast(p_implementation);
            }
        };

        /// This should be implemented to report the values of
        ///   child cell properties for a given child `GtkCellRenderer`.
        pub const get_cell_property = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer, p_property_id: c_uint, p_value: *gobject.Value, p_pspec: *gobject.ParamSpec) void {
                return gobject.ext.as(CellArea.Class, p_class).f_get_cell_property.?(gobject.ext.as(CellArea, p_area), p_renderer, p_property_id, p_value, p_pspec);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer, p_property_id: c_uint, p_value: *gobject.Value, p_pspec: *gobject.ParamSpec) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_get_cell_property = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a cell area’s initial minimum and natural height.
        ///
        /// `area` will store some geometrical information in `context` along the way;
        /// when requesting sizes over an arbitrary number of rows, it’s not important
        /// to check the `minimum_height` and `natural_height` of this call but rather to
        /// consult `gtk.CellAreaContext.getPreferredHeight` after a series of
        /// requests.
        pub const get_preferred_height = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void {
                return gobject.ext.as(CellArea.Class, p_class).f_get_preferred_height.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_minimum_height, p_natural_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_get_preferred_height = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a cell area’s minimum and natural height if it would be given
        /// the specified `width`.
        ///
        /// `area` stores some geometrical information in `context` along the way
        /// while calling `gtk.CellArea.getPreferredWidth`. It’s important to
        /// perform a series of `gtk.CellArea.getPreferredWidth` requests with
        /// `context` first and then call `gtk.CellArea.getPreferredHeightForWidth`
        /// on each cell area individually to get the height for width of each
        /// fully requested row.
        ///
        /// If at some point, the width of a single row changes, it should be
        /// requested with `gtk.CellArea.getPreferredWidth` again and then
        /// the full width of the requested rows checked again with
        /// `gtk.CellAreaContext.getPreferredWidth`.
        pub const get_preferred_height_for_width = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void {
                return gobject.ext.as(CellArea.Class, p_class).f_get_preferred_height_for_width.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_width, p_minimum_height, p_natural_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_get_preferred_height_for_width = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a cell area’s initial minimum and natural width.
        ///
        /// `area` will store some geometrical information in `context` along the way;
        /// when requesting sizes over an arbitrary number of rows, it’s not important
        /// to check the `minimum_width` and `natural_width` of this call but rather to
        /// consult `gtk.CellAreaContext.getPreferredWidth` after a series of
        /// requests.
        pub const get_preferred_width = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void {
                return gobject.ext.as(CellArea.Class, p_class).f_get_preferred_width.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_minimum_width, p_natural_width);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_get_preferred_width = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a cell area’s minimum and natural width if it would be given
        /// the specified `height`.
        ///
        /// `area` stores some geometrical information in `context` along the way
        /// while calling `gtk.CellArea.getPreferredHeight`. It’s important to
        /// perform a series of `gtk.CellArea.getPreferredHeight` requests with
        /// `context` first and then call `gtk.CellArea.getPreferredWidthForHeight`
        /// on each cell area individually to get the height for width of each
        /// fully requested row.
        ///
        /// If at some point, the height of a single row changes, it should be
        /// requested with `gtk.CellArea.getPreferredHeight` again and then
        /// the full height of the requested rows checked again with
        /// `gtk.CellAreaContext.getPreferredHeight`.
        pub const get_preferred_width_for_height = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void {
                return gobject.ext.as(CellArea.Class, p_class).f_get_preferred_width_for_height.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_height, p_minimum_width, p_natural_width);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_get_preferred_width_for_height = @ptrCast(p_implementation);
            }
        };

        /// Gets whether the area prefers a height-for-width layout
        /// or a width-for-height layout.
        pub const get_request_mode = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) gtk.SizeRequestMode {
                return gobject.ext.as(CellArea.Class, p_class).f_get_request_mode.?(gobject.ext.as(CellArea, p_area));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) gtk.SizeRequestMode) void {
                gobject.ext.as(CellArea.Class, p_class).f_get_request_mode = @ptrCast(p_implementation);
            }
        };

        /// Returns whether the area can do anything when activated,
        /// after applying new attributes to `area`.
        pub const is_activatable = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(CellArea.Class, p_class).f_is_activatable.?(gobject.ext.as(CellArea, p_area));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(CellArea.Class, p_class).f_is_activatable = @ptrCast(p_implementation);
            }
        };

        /// Removes `renderer` from `area`.
        pub const remove = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer) void {
                return gobject.ext.as(CellArea.Class, p_class).f_remove.?(gobject.ext.as(CellArea, p_area), p_renderer);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_remove = @ptrCast(p_implementation);
            }
        };

        /// This should be implemented to handle changes in child
        ///   cell properties for a given `GtkCellRenderer` that were previously
        ///   installed on the `GtkCellAreaClass` with `gtk.CellAreaClass.installCellProperty`.
        pub const set_cell_property = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer, p_property_id: c_uint, p_value: *const gobject.Value, p_pspec: *gobject.ParamSpec) void {
                return gobject.ext.as(CellArea.Class, p_class).f_set_cell_property.?(gobject.ext.as(CellArea, p_area), p_renderer, p_property_id, p_value, p_pspec);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_renderer: *gtk.CellRenderer, p_property_id: c_uint, p_value: *const gobject.Value, p_pspec: *gobject.ParamSpec) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_set_cell_property = @ptrCast(p_implementation);
            }
        };

        /// Snapshots `area`’s cells according to `area`’s layout onto at
        /// the given coordinates.
        pub const snapshot = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_snapshot: *gtk.Snapshot, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState, p_paint_focus: c_int) void {
                return gobject.ext.as(CellArea.Class, p_class).f_snapshot.?(gobject.ext.as(CellArea, p_area), p_context, p_widget, p_snapshot, p_background_area, p_cell_area, p_flags, p_paint_focus);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_snapshot: *gtk.Snapshot, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState, p_paint_focus: c_int) callconv(.C) void) void {
                gobject.ext.as(CellArea.Class, p_class).f_snapshot = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The widget currently editing the edited cell
        ///
        /// This property is read-only and only changes as
        /// a result of a call `gtk.CellArea.activateCell`.
        pub const edit_widget = struct {
            pub const name = "edit-widget";

            pub const Type = ?*gtk.CellEditable;
        };

        /// The cell in the area that is currently edited
        ///
        /// This property is read-only and only changes as
        /// a result of a call `gtk.CellArea.activateCell`.
        pub const edited_cell = struct {
            pub const name = "edited-cell";

            pub const Type = ?*gtk.CellRenderer;
        };

        /// The cell in the area that currently has focus
        pub const focus_cell = struct {
            pub const name = "focus-cell";

            pub const Type = ?*gtk.CellRenderer;
        };
    };

    pub const signals = struct {
        /// Indicates that editing has started on `renderer` and that `editable`
        /// should be added to the owning cell-layouting widget at `cell_area`.
        pub const add_editable = struct {
            pub const name = "add-editable";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_renderer: *gtk.CellRenderer, p_editable: *gtk.CellEditable, p_cell_area: *gdk.Rectangle, p_path: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellArea, p_instance))),
                    gobject.signalLookup("add-editable", CellArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted whenever applying attributes to `area` from `model`
        pub const apply_attributes = struct {
            pub const name = "apply-attributes";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_model: *gtk.TreeModel, p_iter: *gtk.TreeIter, p_is_expander: c_int, p_is_expanded: c_int, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellArea, p_instance))),
                    gobject.signalLookup("apply-attributes", CellArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Indicates that focus changed on this `area`. This signal
        /// is emitted either as a result of focus handling or event
        /// handling.
        ///
        /// It's possible that the signal is emitted even if the
        /// currently focused renderer did not change, this is
        /// because focus may change to the same renderer in the
        /// same cell area for a different row of data.
        pub const focus_changed = struct {
            pub const name = "focus-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_renderer: *gtk.CellRenderer, p_path: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellArea, p_instance))),
                    gobject.signalLookup("focus-changed", CellArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Indicates that editing finished on `renderer` and that `editable`
        /// should be removed from the owning cell-layouting widget.
        pub const remove_editable = struct {
            pub const name = "remove-editable";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_renderer: *gtk.CellRenderer, p_editable: *gtk.CellEditable, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellArea, p_instance))),
                    gobject.signalLookup("remove-editable", CellArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Activates `area`, usually by activating the currently focused
    /// cell, however some subclasses which embed widgets in the area
    /// can also activate a widget if it currently has the focus.
    extern fn gtk_cell_area_activate(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState, p_edit_only: c_int) c_int;
    pub const activate = gtk_cell_area_activate;

    /// This is used by `GtkCellArea` subclasses when handling events
    /// to activate cells, the base `GtkCellArea` class activates cells
    /// for keyboard events for free in its own GtkCellArea->`activate`
    /// implementation.
    extern fn gtk_cell_area_activate_cell(p_area: *CellArea, p_widget: *gtk.Widget, p_renderer: *gtk.CellRenderer, p_event: *gdk.Event, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) c_int;
    pub const activateCell = gtk_cell_area_activate_cell;

    /// Adds `renderer` to `area` with the default child cell properties.
    extern fn gtk_cell_area_add(p_area: *CellArea, p_renderer: *gtk.CellRenderer) void;
    pub const add = gtk_cell_area_add;

    /// Adds `sibling` to `renderer`’s focusable area, focus will be drawn
    /// around `renderer` and all of its siblings if `renderer` can
    /// focus for a given row.
    ///
    /// Events handled by focus siblings can also activate the given
    /// focusable `renderer`.
    extern fn gtk_cell_area_add_focus_sibling(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_sibling: *gtk.CellRenderer) void;
    pub const addFocusSibling = gtk_cell_area_add_focus_sibling;

    /// Adds `renderer` to `area`, setting cell properties at the same time.
    /// See `gtk.CellArea.add` and `gtk.CellArea.cellSet` for more details.
    extern fn gtk_cell_area_add_with_properties(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_first_prop_name: [*:0]const u8, ...) void;
    pub const addWithProperties = gtk_cell_area_add_with_properties;

    /// Applies any connected attributes to the renderers in
    /// `area` by pulling the values from `tree_model`.
    extern fn gtk_cell_area_apply_attributes(p_area: *CellArea, p_tree_model: *gtk.TreeModel, p_iter: *gtk.TreeIter, p_is_expander: c_int, p_is_expanded: c_int) void;
    pub const applyAttributes = gtk_cell_area_apply_attributes;

    /// Connects an `attribute` to apply values from `column` for the
    /// `GtkTreeModel` in use.
    extern fn gtk_cell_area_attribute_connect(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_attribute: [*:0]const u8, p_column: c_int) void;
    pub const attributeConnect = gtk_cell_area_attribute_connect;

    /// Disconnects `attribute` for the `renderer` in `area` so that
    /// attribute will no longer be updated with values from the
    /// model.
    extern fn gtk_cell_area_attribute_disconnect(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_attribute: [*:0]const u8) void;
    pub const attributeDisconnect = gtk_cell_area_attribute_disconnect;

    /// Returns the model column that an attribute has been mapped to,
    /// or -1 if the attribute is not mapped.
    extern fn gtk_cell_area_attribute_get_column(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_attribute: [*:0]const u8) c_int;
    pub const attributeGetColumn = gtk_cell_area_attribute_get_column;

    /// Gets the values of one or more cell properties for `renderer` in `area`.
    extern fn gtk_cell_area_cell_get(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_first_prop_name: [*:0]const u8, ...) void;
    pub const cellGet = gtk_cell_area_cell_get;

    /// Gets the value of a cell property for `renderer` in `area`.
    extern fn gtk_cell_area_cell_get_property(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_property_name: [*:0]const u8, p_value: *gobject.Value) void;
    pub const cellGetProperty = gtk_cell_area_cell_get_property;

    /// Gets the values of one or more cell properties for `renderer` in `area`.
    extern fn gtk_cell_area_cell_get_valist(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_first_property_name: [*:0]const u8, p_var_args: std.builtin.VaList) void;
    pub const cellGetValist = gtk_cell_area_cell_get_valist;

    /// Sets one or more cell properties for `cell` in `area`.
    extern fn gtk_cell_area_cell_set(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_first_prop_name: [*:0]const u8, ...) void;
    pub const cellSet = gtk_cell_area_cell_set;

    /// Sets a cell property for `renderer` in `area`.
    extern fn gtk_cell_area_cell_set_property(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_property_name: [*:0]const u8, p_value: *const gobject.Value) void;
    pub const cellSetProperty = gtk_cell_area_cell_set_property;

    /// Sets one or more cell properties for `renderer` in `area`.
    extern fn gtk_cell_area_cell_set_valist(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_first_property_name: [*:0]const u8, p_var_args: std.builtin.VaList) void;
    pub const cellSetValist = gtk_cell_area_cell_set_valist;

    /// This is sometimes needed for cases where rows need to share
    /// alignments in one orientation but may be separately grouped
    /// in the opposing orientation.
    ///
    /// For instance, `GtkIconView` creates all icons (rows) to have
    /// the same width and the cells theirin to have the same
    /// horizontal alignments. However each row of icons may have
    /// a separate collective height. `GtkIconView` uses this to
    /// request the heights of each row based on a context which
    /// was already used to request all the row widths that are
    /// to be displayed.
    extern fn gtk_cell_area_copy_context(p_area: *CellArea, p_context: *gtk.CellAreaContext) *gtk.CellAreaContext;
    pub const copyContext = gtk_cell_area_copy_context;

    /// Creates a `GtkCellArea`Context to be used with `area` for
    /// all purposes. `GtkCellArea`Context stores geometry information
    /// for rows for which it was operated on, it is important to use
    /// the same context for the same row of data at all times (i.e.
    /// one should render and handle events with the same `GtkCellArea`Context
    /// which was used to request the size of those rows of data).
    extern fn gtk_cell_area_create_context(p_area: *CellArea) *gtk.CellAreaContext;
    pub const createContext = gtk_cell_area_create_context;

    /// Delegates event handling to a `GtkCellArea`.
    extern fn gtk_cell_area_event(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_event: *gdk.Event, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) c_int;
    pub const event = gtk_cell_area_event;

    /// This should be called by the `area`’s owning layout widget
    /// when focus is to be passed to `area`, or moved within `area`
    /// for a given `direction` and row data.
    ///
    /// Implementing `GtkCellArea` classes should implement this
    /// method to receive and navigate focus in its own way particular
    /// to how it lays out cells.
    extern fn gtk_cell_area_focus(p_area: *CellArea, p_direction: gtk.DirectionType) c_int;
    pub const focus = gtk_cell_area_focus;

    /// Calls `callback` for every `GtkCellRenderer` in `area`.
    extern fn gtk_cell_area_foreach(p_area: *CellArea, p_callback: gtk.CellCallback, p_callback_data: ?*anyopaque) void;
    pub const foreach = gtk_cell_area_foreach;

    /// Calls `callback` for every `GtkCellRenderer` in `area` with the
    /// allocated rectangle inside `cell_area`.
    extern fn gtk_cell_area_foreach_alloc(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_background_area: *const gdk.Rectangle, p_callback: gtk.CellAllocCallback, p_callback_data: ?*anyopaque) void;
    pub const foreachAlloc = gtk_cell_area_foreach_alloc;

    /// Derives the allocation of `renderer` inside `area` if `area`
    /// were to be rendered in `cell_area`.
    extern fn gtk_cell_area_get_cell_allocation(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_renderer: *gtk.CellRenderer, p_cell_area: *const gdk.Rectangle, p_allocation: *gdk.Rectangle) void;
    pub const getCellAllocation = gtk_cell_area_get_cell_allocation;

    /// Gets the `GtkCellRenderer` at `x` and `y` coordinates inside `area` and optionally
    /// returns the full cell allocation for it inside `cell_area`.
    extern fn gtk_cell_area_get_cell_at_position(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_x: c_int, p_y: c_int, p_alloc_area: ?*gdk.Rectangle) *gtk.CellRenderer;
    pub const getCellAtPosition = gtk_cell_area_get_cell_at_position;

    /// Gets the current `GtkTreePath` string for the currently
    /// applied `GtkTreeIter`, this is implicitly updated when
    /// `gtk.CellArea.applyAttributes` is called and can be
    /// used to interact with renderers from `GtkCellArea`
    /// subclasses.
    extern fn gtk_cell_area_get_current_path_string(p_area: *CellArea) [*:0]const u8;
    pub const getCurrentPathString = gtk_cell_area_get_current_path_string;

    /// Gets the `GtkCellEditable` widget currently used
    /// to edit the currently edited cell.
    extern fn gtk_cell_area_get_edit_widget(p_area: *CellArea) ?*gtk.CellEditable;
    pub const getEditWidget = gtk_cell_area_get_edit_widget;

    /// Gets the `GtkCellRenderer` in `area` that is currently
    /// being edited.
    extern fn gtk_cell_area_get_edited_cell(p_area: *CellArea) ?*gtk.CellRenderer;
    pub const getEditedCell = gtk_cell_area_get_edited_cell;

    /// Retrieves the currently focused cell for `area`
    extern fn gtk_cell_area_get_focus_cell(p_area: *CellArea) ?*gtk.CellRenderer;
    pub const getFocusCell = gtk_cell_area_get_focus_cell;

    /// Gets the `GtkCellRenderer` which is expected to be focusable
    /// for which `renderer` is, or may be a sibling.
    ///
    /// This is handy for `GtkCellArea` subclasses when handling events,
    /// after determining the renderer at the event location it can
    /// then chose to activate the focus cell for which the event
    /// cell may have been a sibling.
    extern fn gtk_cell_area_get_focus_from_sibling(p_area: *CellArea, p_renderer: *gtk.CellRenderer) ?*gtk.CellRenderer;
    pub const getFocusFromSibling = gtk_cell_area_get_focus_from_sibling;

    /// Gets the focus sibling cell renderers for `renderer`.
    extern fn gtk_cell_area_get_focus_siblings(p_area: *CellArea, p_renderer: *gtk.CellRenderer) *const glib.List;
    pub const getFocusSiblings = gtk_cell_area_get_focus_siblings;

    /// Retrieves a cell area’s initial minimum and natural height.
    ///
    /// `area` will store some geometrical information in `context` along the way;
    /// when requesting sizes over an arbitrary number of rows, it’s not important
    /// to check the `minimum_height` and `natural_height` of this call but rather to
    /// consult `gtk.CellAreaContext.getPreferredHeight` after a series of
    /// requests.
    extern fn gtk_cell_area_get_preferred_height(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void;
    pub const getPreferredHeight = gtk_cell_area_get_preferred_height;

    /// Retrieves a cell area’s minimum and natural height if it would be given
    /// the specified `width`.
    ///
    /// `area` stores some geometrical information in `context` along the way
    /// while calling `gtk.CellArea.getPreferredWidth`. It’s important to
    /// perform a series of `gtk.CellArea.getPreferredWidth` requests with
    /// `context` first and then call `gtk.CellArea.getPreferredHeightForWidth`
    /// on each cell area individually to get the height for width of each
    /// fully requested row.
    ///
    /// If at some point, the width of a single row changes, it should be
    /// requested with `gtk.CellArea.getPreferredWidth` again and then
    /// the full width of the requested rows checked again with
    /// `gtk.CellAreaContext.getPreferredWidth`.
    extern fn gtk_cell_area_get_preferred_height_for_width(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void;
    pub const getPreferredHeightForWidth = gtk_cell_area_get_preferred_height_for_width;

    /// Retrieves a cell area’s initial minimum and natural width.
    ///
    /// `area` will store some geometrical information in `context` along the way;
    /// when requesting sizes over an arbitrary number of rows, it’s not important
    /// to check the `minimum_width` and `natural_width` of this call but rather to
    /// consult `gtk.CellAreaContext.getPreferredWidth` after a series of
    /// requests.
    extern fn gtk_cell_area_get_preferred_width(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void;
    pub const getPreferredWidth = gtk_cell_area_get_preferred_width;

    /// Retrieves a cell area’s minimum and natural width if it would be given
    /// the specified `height`.
    ///
    /// `area` stores some geometrical information in `context` along the way
    /// while calling `gtk.CellArea.getPreferredHeight`. It’s important to
    /// perform a series of `gtk.CellArea.getPreferredHeight` requests with
    /// `context` first and then call `gtk.CellArea.getPreferredWidthForHeight`
    /// on each cell area individually to get the height for width of each
    /// fully requested row.
    ///
    /// If at some point, the height of a single row changes, it should be
    /// requested with `gtk.CellArea.getPreferredHeight` again and then
    /// the full height of the requested rows checked again with
    /// `gtk.CellAreaContext.getPreferredHeight`.
    extern fn gtk_cell_area_get_preferred_width_for_height(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void;
    pub const getPreferredWidthForHeight = gtk_cell_area_get_preferred_width_for_height;

    /// Gets whether the area prefers a height-for-width layout
    /// or a width-for-height layout.
    extern fn gtk_cell_area_get_request_mode(p_area: *CellArea) gtk.SizeRequestMode;
    pub const getRequestMode = gtk_cell_area_get_request_mode;

    /// Checks if `area` contains `renderer`.
    extern fn gtk_cell_area_has_renderer(p_area: *CellArea, p_renderer: *gtk.CellRenderer) c_int;
    pub const hasRenderer = gtk_cell_area_has_renderer;

    /// This is a convenience function for `GtkCellArea` implementations
    /// to get the inner area where a given `GtkCellRenderer` will be
    /// rendered. It removes any padding previously added by `gtk.CellArea.requestRenderer`.
    extern fn gtk_cell_area_inner_cell_area(p_area: *CellArea, p_widget: *gtk.Widget, p_cell_area: *const gdk.Rectangle, p_inner_area: *gdk.Rectangle) void;
    pub const innerCellArea = gtk_cell_area_inner_cell_area;

    /// Returns whether the area can do anything when activated,
    /// after applying new attributes to `area`.
    extern fn gtk_cell_area_is_activatable(p_area: *CellArea) c_int;
    pub const isActivatable = gtk_cell_area_is_activatable;

    /// Returns whether `sibling` is one of `renderer`’s focus siblings
    /// (see `gtk.CellArea.addFocusSibling`).
    extern fn gtk_cell_area_is_focus_sibling(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_sibling: *gtk.CellRenderer) c_int;
    pub const isFocusSibling = gtk_cell_area_is_focus_sibling;

    /// Removes `renderer` from `area`.
    extern fn gtk_cell_area_remove(p_area: *CellArea, p_renderer: *gtk.CellRenderer) void;
    pub const remove = gtk_cell_area_remove;

    /// Removes `sibling` from `renderer`’s focus sibling list
    /// (see `gtk.CellArea.addFocusSibling`).
    extern fn gtk_cell_area_remove_focus_sibling(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_sibling: *gtk.CellRenderer) void;
    pub const removeFocusSibling = gtk_cell_area_remove_focus_sibling;

    /// This is a convenience function for `GtkCellArea` implementations
    /// to request size for cell renderers. It’s important to use this
    /// function to request size and then use `gtk.CellArea.innerCellArea`
    /// at render and event time since this function will add padding
    /// around the cell for focus painting.
    extern fn gtk_cell_area_request_renderer(p_area: *CellArea, p_renderer: *gtk.CellRenderer, p_orientation: gtk.Orientation, p_widget: *gtk.Widget, p_for_size: c_int, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) void;
    pub const requestRenderer = gtk_cell_area_request_renderer;

    /// Explicitly sets the currently focused cell to `renderer`.
    ///
    /// This is generally called by implementations of
    /// `GtkCellAreaClass.`focus`` or `GtkCellAreaClass.`event``,
    /// however it can also be used to implement functions such
    /// as `gtk.TreeView.setCursorOnCell`.
    extern fn gtk_cell_area_set_focus_cell(p_area: *CellArea, p_renderer: ?*gtk.CellRenderer) void;
    pub const setFocusCell = gtk_cell_area_set_focus_cell;

    /// Snapshots `area`’s cells according to `area`’s layout onto at
    /// the given coordinates.
    extern fn gtk_cell_area_snapshot(p_area: *CellArea, p_context: *gtk.CellAreaContext, p_widget: *gtk.Widget, p_snapshot: *gtk.Snapshot, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState, p_paint_focus: c_int) void;
    pub const snapshot = gtk_cell_area_snapshot;

    /// Explicitly stops the editing of the currently edited cell.
    ///
    /// If `canceled` is `TRUE`, the currently edited cell renderer
    /// will emit the ::editing-canceled signal, otherwise the
    /// the ::editing-done signal will be emitted on the current
    /// edit widget.
    ///
    /// See `gtk.CellArea.getEditedCell` and `gtk.CellArea.getEditWidget`.
    extern fn gtk_cell_area_stop_editing(p_area: *CellArea, p_canceled: c_int) void;
    pub const stopEditing = gtk_cell_area_stop_editing;

    extern fn gtk_cell_area_get_type() usize;
    pub const getGObjectType = gtk_cell_area_get_type;

    extern fn g_object_ref(p_self: *gtk.CellArea) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellArea) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellArea, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A cell area that renders GtkCellRenderers into a row or a column
///
/// The `GtkCellAreaBox` renders cell renderers into a row or a column
/// depending on its `GtkOrientation`.
///
/// GtkCellAreaBox uses a notion of packing. Packing
/// refers to adding cell renderers with reference to a particular position
/// in a `GtkCellAreaBox`. There are two reference positions: the
/// start and the end of the box.
/// When the `GtkCellAreaBox` is oriented in the `GTK_ORIENTATION_VERTICAL`
/// orientation, the start is defined as the top of the box and the end is
/// defined as the bottom. In the `GTK_ORIENTATION_HORIZONTAL` orientation
/// start is defined as the left side and the end is defined as the right
/// side.
///
/// Alignments of `GtkCellRenderer`s rendered in adjacent rows can be
/// configured by configuring the `GtkCellAreaBox` align child cell property
/// with `gtk.CellArea.cellSetProperty` or by specifying the "align"
/// argument to `gtk.CellAreaBox.packStart` and `gtk.CellAreaBox.packEnd`.
pub const CellAreaBox = opaque {
    pub const Parent = gtk.CellArea;
    pub const Implements = [_]type{ gtk.Buildable, gtk.CellLayout, gtk.Orientable };
    pub const Class = opaque {
        pub const Instance = CellAreaBox;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The amount of space to reserve between cells.
        pub const spacing = struct {
            pub const name = "spacing";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCellAreaBox`.
    extern fn gtk_cell_area_box_new() *gtk.CellAreaBox;
    pub const new = gtk_cell_area_box_new;

    /// Gets the spacing added between cell renderers.
    extern fn gtk_cell_area_box_get_spacing(p_box: *CellAreaBox) c_int;
    pub const getSpacing = gtk_cell_area_box_get_spacing;

    /// Adds `renderer` to `box`, packed with reference to the end of `box`.
    ///
    /// The `renderer` is packed after (away from end of) any other
    /// `GtkCellRenderer` packed with reference to the end of `box`.
    extern fn gtk_cell_area_box_pack_end(p_box: *CellAreaBox, p_renderer: *gtk.CellRenderer, p_expand: c_int, p_align: c_int, p_fixed: c_int) void;
    pub const packEnd = gtk_cell_area_box_pack_end;

    /// Adds `renderer` to `box`, packed with reference to the start of `box`.
    ///
    /// The `renderer` is packed after any other `GtkCellRenderer` packed
    /// with reference to the start of `box`.
    extern fn gtk_cell_area_box_pack_start(p_box: *CellAreaBox, p_renderer: *gtk.CellRenderer, p_expand: c_int, p_align: c_int, p_fixed: c_int) void;
    pub const packStart = gtk_cell_area_box_pack_start;

    /// Sets the spacing to add between cell renderers in `box`.
    extern fn gtk_cell_area_box_set_spacing(p_box: *CellAreaBox, p_spacing: c_int) void;
    pub const setSpacing = gtk_cell_area_box_set_spacing;

    extern fn gtk_cell_area_box_get_type() usize;
    pub const getGObjectType = gtk_cell_area_box_get_type;

    extern fn g_object_ref(p_self: *gtk.CellAreaBox) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellAreaBox) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellAreaBox, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Stores geometrical information for a series of rows in a GtkCellArea
///
/// The `GtkCellAreaContext` object is created by a given `GtkCellArea`
/// implementation via its `GtkCellAreaClass.`create_context`` virtual
/// method and is used to store cell sizes and alignments for a series of
/// `GtkTreeModel` rows that are requested and rendered in the same context.
///
/// `GtkCellLayout` widgets can create any number of contexts in which to
/// request and render groups of data rows. However, it’s important that the
/// same context which was used to request sizes for a given `GtkTreeModel`
/// row also be used for the same row when calling other `GtkCellArea` APIs
/// such as `gtk_cell_area_render` and `gtk.CellArea.event`.
pub const CellAreaContext = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.CellAreaContextClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {
        /// Allocates a width and/or a height for all rows which are to be
        /// rendered with `context`.
        ///
        /// Usually allocation is performed only horizontally or sometimes
        /// vertically since a group of rows are usually rendered side by
        /// side vertically or horizontally and share either the same width
        /// or the same height. Sometimes they are allocated in both horizontal
        /// and vertical orientations producing a homogeneous effect of the
        /// rows. This is generally the case for `GtkTreeView` when
        /// `GtkTreeView:fixed-height-mode` is enabled.
        pub const allocate = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_height: c_int) void {
                return gobject.ext.as(CellAreaContext.Class, p_class).f_allocate.?(gobject.ext.as(CellAreaContext, p_context), p_width, p_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_height: c_int) callconv(.C) void) void {
                gobject.ext.as(CellAreaContext.Class, p_class).f_allocate = @ptrCast(p_implementation);
            }
        };

        /// Gets the accumulative preferred height for `width` for all rows
        /// which have been requested for the same said `width` with this context.
        ///
        /// After `gtk.CellAreaContext.reset` is called and/or before ever
        /// requesting the size of a `GtkCellArea`, the returned values are -1.
        pub const get_preferred_height_for_width = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void {
                return gobject.ext.as(CellAreaContext.Class, p_class).f_get_preferred_height_for_width.?(gobject.ext.as(CellAreaContext, p_context), p_width, p_minimum_height, p_natural_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellAreaContext.Class, p_class).f_get_preferred_height_for_width = @ptrCast(p_implementation);
            }
        };

        /// Gets the accumulative preferred width for `height` for all rows which
        /// have been requested for the same said `height` with this context.
        ///
        /// After `gtk.CellAreaContext.reset` is called and/or before ever
        /// requesting the size of a `GtkCellArea`, the returned values are -1.
        pub const get_preferred_width_for_height = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void {
                return gobject.ext.as(CellAreaContext.Class, p_class).f_get_preferred_width_for_height.?(gobject.ext.as(CellAreaContext, p_context), p_height, p_minimum_width, p_natural_width);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellAreaContext.Class, p_class).f_get_preferred_width_for_height = @ptrCast(p_implementation);
            }
        };

        /// Resets any previously cached request and allocation
        /// data.
        ///
        /// When underlying `GtkTreeModel` data changes its
        /// important to reset the context if the content
        /// size is allowed to shrink. If the content size
        /// is only allowed to grow (this is usually an option
        /// for views rendering large data stores as a measure
        /// of optimization), then only the row that changed
        /// or was inserted needs to be (re)requested with
        /// `gtk.CellArea.getPreferredWidth`.
        ///
        /// When the new overall size of the context requires
        /// that the allocated size changes (or whenever this
        /// allocation changes at all), the variable row
        /// sizes need to be re-requested for every row.
        ///
        /// For instance, if the rows are displayed all with
        /// the same width from top to bottom then a change
        /// in the allocated width necessitates a recalculation
        /// of all the displayed row heights using
        /// `gtk.CellArea.getPreferredHeightForWidth`.
        pub const reset = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(CellAreaContext.Class, p_class).f_reset.?(gobject.ext.as(CellAreaContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(CellAreaContext.Class, p_class).f_reset = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The `GtkCellArea` this context was created by
        pub const area = struct {
            pub const name = "area";

            pub const Type = ?*gtk.CellArea;
        };

        /// The minimum height for the `GtkCellArea` in this context
        /// for all `GtkTreeModel` rows that this context was requested
        /// for using `gtk.CellArea.getPreferredHeight`.
        pub const minimum_height = struct {
            pub const name = "minimum-height";

            pub const Type = c_int;
        };

        /// The minimum width for the `GtkCellArea` in this context
        /// for all `GtkTreeModel` rows that this context was requested
        /// for using `gtk.CellArea.getPreferredWidth`.
        pub const minimum_width = struct {
            pub const name = "minimum-width";

            pub const Type = c_int;
        };

        /// The natural height for the `GtkCellArea` in this context
        /// for all `GtkTreeModel` rows that this context was requested
        /// for using `gtk.CellArea.getPreferredHeight`.
        pub const natural_height = struct {
            pub const name = "natural-height";

            pub const Type = c_int;
        };

        /// The natural width for the `GtkCellArea` in this context
        /// for all `GtkTreeModel` rows that this context was requested
        /// for using `gtk.CellArea.getPreferredWidth`.
        pub const natural_width = struct {
            pub const name = "natural-width";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Allocates a width and/or a height for all rows which are to be
    /// rendered with `context`.
    ///
    /// Usually allocation is performed only horizontally or sometimes
    /// vertically since a group of rows are usually rendered side by
    /// side vertically or horizontally and share either the same width
    /// or the same height. Sometimes they are allocated in both horizontal
    /// and vertical orientations producing a homogeneous effect of the
    /// rows. This is generally the case for `GtkTreeView` when
    /// `GtkTreeView:fixed-height-mode` is enabled.
    extern fn gtk_cell_area_context_allocate(p_context: *CellAreaContext, p_width: c_int, p_height: c_int) void;
    pub const allocate = gtk_cell_area_context_allocate;

    /// Fetches the current allocation size for `context`.
    ///
    /// If the context was not allocated in width or height, or if the
    /// context was recently reset with `gtk.CellAreaContext.reset`,
    /// the returned value will be -1.
    extern fn gtk_cell_area_context_get_allocation(p_context: *CellAreaContext, p_width: ?*c_int, p_height: ?*c_int) void;
    pub const getAllocation = gtk_cell_area_context_get_allocation;

    /// Fetches the `GtkCellArea` this `context` was created by.
    ///
    /// This is generally unneeded by layouting widgets; however,
    /// it is important for the context implementation itself to
    /// fetch information about the area it is being used for.
    ///
    /// For instance at `GtkCellAreaContextClass.`allocate`` time
    /// it’s important to know details about any cell spacing
    /// that the `GtkCellArea` is configured with in order to
    /// compute a proper allocation.
    extern fn gtk_cell_area_context_get_area(p_context: *CellAreaContext) *gtk.CellArea;
    pub const getArea = gtk_cell_area_context_get_area;

    /// Gets the accumulative preferred height for all rows which have been
    /// requested with this context.
    ///
    /// After `gtk.CellAreaContext.reset` is called and/or before ever
    /// requesting the size of a `GtkCellArea`, the returned values are 0.
    extern fn gtk_cell_area_context_get_preferred_height(p_context: *CellAreaContext, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void;
    pub const getPreferredHeight = gtk_cell_area_context_get_preferred_height;

    /// Gets the accumulative preferred height for `width` for all rows
    /// which have been requested for the same said `width` with this context.
    ///
    /// After `gtk.CellAreaContext.reset` is called and/or before ever
    /// requesting the size of a `GtkCellArea`, the returned values are -1.
    extern fn gtk_cell_area_context_get_preferred_height_for_width(p_context: *CellAreaContext, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void;
    pub const getPreferredHeightForWidth = gtk_cell_area_context_get_preferred_height_for_width;

    /// Gets the accumulative preferred width for all rows which have been
    /// requested with this context.
    ///
    /// After `gtk.CellAreaContext.reset` is called and/or before ever
    /// requesting the size of a `GtkCellArea`, the returned values are 0.
    extern fn gtk_cell_area_context_get_preferred_width(p_context: *CellAreaContext, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void;
    pub const getPreferredWidth = gtk_cell_area_context_get_preferred_width;

    /// Gets the accumulative preferred width for `height` for all rows which
    /// have been requested for the same said `height` with this context.
    ///
    /// After `gtk.CellAreaContext.reset` is called and/or before ever
    /// requesting the size of a `GtkCellArea`, the returned values are -1.
    extern fn gtk_cell_area_context_get_preferred_width_for_height(p_context: *CellAreaContext, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void;
    pub const getPreferredWidthForHeight = gtk_cell_area_context_get_preferred_width_for_height;

    /// Causes the minimum and/or natural height to grow if the new
    /// proposed sizes exceed the current minimum and natural height.
    ///
    /// This is used by `GtkCellAreaContext` implementations during
    /// the request process over a series of `GtkTreeModel` rows to
    /// progressively push the requested height over a series of
    /// `gtk.CellArea.getPreferredHeight` requests.
    extern fn gtk_cell_area_context_push_preferred_height(p_context: *CellAreaContext, p_minimum_height: c_int, p_natural_height: c_int) void;
    pub const pushPreferredHeight = gtk_cell_area_context_push_preferred_height;

    /// Causes the minimum and/or natural width to grow if the new
    /// proposed sizes exceed the current minimum and natural width.
    ///
    /// This is used by `GtkCellAreaContext` implementations during
    /// the request process over a series of `GtkTreeModel` rows to
    /// progressively push the requested width over a series of
    /// `gtk.CellArea.getPreferredWidth` requests.
    extern fn gtk_cell_area_context_push_preferred_width(p_context: *CellAreaContext, p_minimum_width: c_int, p_natural_width: c_int) void;
    pub const pushPreferredWidth = gtk_cell_area_context_push_preferred_width;

    /// Resets any previously cached request and allocation
    /// data.
    ///
    /// When underlying `GtkTreeModel` data changes its
    /// important to reset the context if the content
    /// size is allowed to shrink. If the content size
    /// is only allowed to grow (this is usually an option
    /// for views rendering large data stores as a measure
    /// of optimization), then only the row that changed
    /// or was inserted needs to be (re)requested with
    /// `gtk.CellArea.getPreferredWidth`.
    ///
    /// When the new overall size of the context requires
    /// that the allocated size changes (or whenever this
    /// allocation changes at all), the variable row
    /// sizes need to be re-requested for every row.
    ///
    /// For instance, if the rows are displayed all with
    /// the same width from top to bottom then a change
    /// in the allocated width necessitates a recalculation
    /// of all the displayed row heights using
    /// `gtk.CellArea.getPreferredHeightForWidth`.
    extern fn gtk_cell_area_context_reset(p_context: *CellAreaContext) void;
    pub const reset = gtk_cell_area_context_reset;

    extern fn gtk_cell_area_context_get_type() usize;
    pub const getGObjectType = gtk_cell_area_context_get_type;

    extern fn g_object_ref(p_self: *gtk.CellAreaContext) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellAreaContext) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellAreaContext, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An object for rendering a single cell
///
/// The `GtkCellRenderer` is a base class of a set of objects used for
/// rendering a cell to a `cairo_t`.  These objects are used primarily by
/// the `GtkTreeView` widget, though they aren’t tied to them in any
/// specific way.  It is worth noting that `GtkCellRenderer` is not a
/// `GtkWidget` and cannot be treated as such.
///
/// The primary use of a `GtkCellRenderer` is for drawing a certain graphical
/// elements on a `cairo_t`. Typically, one cell renderer is used to
/// draw many cells on the screen.  To this extent, it isn’t expected that a
/// CellRenderer keep any permanent state around.  Instead, any state is set
/// just prior to use using `GObject`s property system.  Then, the
/// cell is measured using `gtk.CellRenderer.getPreferredSize`. Finally, the cell
/// is rendered in the correct location using `gtk.CellRenderer.snapshot`.
///
/// There are a number of rules that must be followed when writing a new
/// `GtkCellRenderer`.  First and foremost, it’s important that a certain set
/// of properties will always yield a cell renderer of the same size,
/// barring a style change. The `GtkCellRenderer` also has a number of
/// generic properties that are expected to be honored by all children.
///
/// Beyond merely rendering a cell, cell renderers can optionally
/// provide active user interface elements. A cell renderer can be
/// “activatable” like `GtkCellRenderer`Toggle,
/// which toggles when it gets activated by a mouse click, or it can be
/// “editable” like `GtkCellRenderer`Text, which
/// allows the user to edit the text using a widget implementing the
/// `GtkCellEditable` interface, e.g. `GtkEntry`.
/// To make a cell renderer activatable or editable, you have to
/// implement the `GtkCellRenderer`Class.activate or
/// `GtkCellRenderer`Class.start_editing virtual functions, respectively.
///
/// Many properties of `GtkCellRenderer` and its subclasses have a
/// corresponding “set” property, e.g. “cell-background-set” corresponds
/// to “cell-background”. These “set” properties reflect whether a property
/// has been set or not. You should not set them independently.
pub const CellRenderer = extern struct {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = gtk.CellRendererClass;
    f_parent_instance: gobject.InitiallyUnowned,
    f_priv: ?*gtk.CellRendererPrivate,

    pub const virtual_methods = struct {
        /// Passes an activate event to the cell renderer for possible processing.
        /// Some cell renderers may use events; for example, `GtkCellRendererToggle`
        /// toggles when it gets a mouse click.
        pub const activate = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: *gdk.Event, p_widget: *gtk.Widget, p_path: [*:0]const u8, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) c_int {
                return gobject.ext.as(CellRenderer.Class, p_class).f_activate.?(gobject.ext.as(CellRenderer, p_cell), p_event, p_widget, p_path, p_background_area, p_cell_area, p_flags);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: *gdk.Event, p_widget: *gtk.Widget, p_path: [*:0]const u8, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) callconv(.C) c_int) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };

        /// Signal gets emitted when the user cancels the process of editing a cell.
        pub const editing_canceled = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_editing_canceled.?(gobject.ext.as(CellRenderer, p_cell));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_editing_canceled = @ptrCast(p_implementation);
            }
        };

        /// Signal gets emitted when a cell starts to be edited.
        pub const editing_started = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_editable: *gtk.CellEditable, p_path: [*:0]const u8) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_editing_started.?(gobject.ext.as(CellRenderer, p_cell), p_editable, p_path);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_editable: *gtk.CellEditable, p_path: [*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_editing_started = @ptrCast(p_implementation);
            }
        };

        /// Gets the aligned area used by `cell` inside `cell_area`. Used for finding
        /// the appropriate edit and focus rectangle.
        pub const get_aligned_area = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_flags: gtk.CellRendererState, p_cell_area: *const gdk.Rectangle, p_aligned_area: *gdk.Rectangle) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_get_aligned_area.?(gobject.ext.as(CellRenderer, p_cell), p_widget, p_flags, p_cell_area, p_aligned_area);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_flags: gtk.CellRendererState, p_cell_area: *const gdk.Rectangle, p_aligned_area: *gdk.Rectangle) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_get_aligned_area = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a renderer’s natural size when rendered to `widget`.
        pub const get_preferred_height = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_height.?(gobject.ext.as(CellRenderer, p_cell), p_widget, p_minimum_size, p_natural_size);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_height = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a cell renderers’s minimum and natural height if it were rendered to
        /// `widget` with the specified `width`.
        pub const get_preferred_height_for_width = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_height_for_width.?(gobject.ext.as(CellRenderer, p_cell), p_widget, p_width, p_minimum_height, p_natural_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_height_for_width = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a renderer’s natural size when rendered to `widget`.
        pub const get_preferred_width = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_width.?(gobject.ext.as(CellRenderer, p_cell), p_widget, p_minimum_size, p_natural_size);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_width = @ptrCast(p_implementation);
            }
        };

        /// Retrieves a cell renderers’s minimum and natural width if it were rendered to
        /// `widget` with the specified `height`.
        pub const get_preferred_width_for_height = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_width_for_height.?(gobject.ext.as(CellRenderer, p_cell), p_widget, p_height, p_minimum_width, p_natural_width);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_widget: *gtk.Widget, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_get_preferred_width_for_height = @ptrCast(p_implementation);
            }
        };

        /// Gets whether the cell renderer prefers a height-for-width layout
        /// or a width-for-height layout.
        pub const get_request_mode = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) gtk.SizeRequestMode {
                return gobject.ext.as(CellRenderer.Class, p_class).f_get_request_mode.?(gobject.ext.as(CellRenderer, p_cell));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) gtk.SizeRequestMode) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_get_request_mode = @ptrCast(p_implementation);
            }
        };

        /// Invokes the virtual render function of the `GtkCellRenderer`. The three
        /// passed-in rectangles are areas in `cr`. Most renderers will draw within
        /// `cell_area`; the xalign, yalign, xpad, and ypad fields of the `GtkCellRenderer`
        /// should be honored with respect to `cell_area`. `background_area` includes the
        /// blank space around the cell, and also the area containing the tree expander;
        /// so the `background_area` rectangles for all cells tile to cover the entire
        /// `window`.
        pub const snapshot = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_snapshot: *gtk.Snapshot, p_widget: *gtk.Widget, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) void {
                return gobject.ext.as(CellRenderer.Class, p_class).f_snapshot.?(gobject.ext.as(CellRenderer, p_cell), p_snapshot, p_widget, p_background_area, p_cell_area, p_flags);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_snapshot: *gtk.Snapshot, p_widget: *gtk.Widget, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) callconv(.C) void) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_snapshot = @ptrCast(p_implementation);
            }
        };

        /// Starts editing the contents of this `cell`, through a new `GtkCellEditable`
        /// widget created by the `GtkCellRenderer`Class.start_editing virtual function.
        pub const start_editing = struct {
            pub fn call(p_class: anytype, p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: ?*gdk.Event, p_widget: *gtk.Widget, p_path: [*:0]const u8, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) ?*gtk.CellEditable {
                return gobject.ext.as(CellRenderer.Class, p_class).f_start_editing.?(gobject.ext.as(CellRenderer, p_cell), p_event, p_widget, p_path, p_background_area, p_cell_area, p_flags);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: ?*gdk.Event, p_widget: *gtk.Widget, p_path: [*:0]const u8, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) callconv(.C) ?*gtk.CellEditable) void {
                gobject.ext.as(CellRenderer.Class, p_class).f_start_editing = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        pub const cell_background = struct {
            pub const name = "cell-background";

            pub const Type = ?[*:0]u8;
        };

        /// Cell background as a `GdkRGBA`
        pub const cell_background_rgba = struct {
            pub const name = "cell-background-rgba";

            pub const Type = ?*gdk.RGBA;
        };

        pub const cell_background_set = struct {
            pub const name = "cell-background-set";

            pub const Type = c_int;
        };

        pub const editing = struct {
            pub const name = "editing";

            pub const Type = c_int;
        };

        pub const height = struct {
            pub const name = "height";

            pub const Type = c_int;
        };

        pub const is_expanded = struct {
            pub const name = "is-expanded";

            pub const Type = c_int;
        };

        pub const is_expander = struct {
            pub const name = "is-expander";

            pub const Type = c_int;
        };

        pub const mode = struct {
            pub const name = "mode";

            pub const Type = gtk.CellRendererMode;
        };

        pub const sensitive = struct {
            pub const name = "sensitive";

            pub const Type = c_int;
        };

        pub const visible = struct {
            pub const name = "visible";

            pub const Type = c_int;
        };

        pub const width = struct {
            pub const name = "width";

            pub const Type = c_int;
        };

        pub const xalign = struct {
            pub const name = "xalign";

            pub const Type = f32;
        };

        pub const xpad = struct {
            pub const name = "xpad";

            pub const Type = c_uint;
        };

        pub const yalign = struct {
            pub const name = "yalign";

            pub const Type = f32;
        };

        pub const ypad = struct {
            pub const name = "ypad";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// This signal gets emitted when the user cancels the process of editing a
        /// cell.  For example, an editable cell renderer could be written to cancel
        /// editing when the user presses Escape.
        ///
        /// See also: `gtk.CellRenderer.stopEditing`.
        pub const editing_canceled = struct {
            pub const name = "editing-canceled";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRenderer, p_instance))),
                    gobject.signalLookup("editing-canceled", CellRenderer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal gets emitted when a cell starts to be edited.
        /// The intended use of this signal is to do special setup
        /// on `editable`, e.g. adding a `GtkEntryCompletion` or setting
        /// up additional columns in a `GtkComboBox`.
        ///
        /// See `gtk.CellEditable.startEditing` for information on the lifecycle of
        /// the `editable` and a way to do setup that doesn’t depend on the `renderer`.
        ///
        /// Note that GTK doesn't guarantee that cell renderers will
        /// continue to use the same kind of widget for editing in future
        /// releases, therefore you should check the type of `editable`
        /// before doing any specific setup, as in the following example:
        /// ```
        /// static void
        /// text_editing_started (GtkCellRenderer *cell,
        ///                       GtkCellEditable *editable,
        ///                       const char      *path,
        ///                       gpointer         data)
        /// {
        ///   if (GTK_IS_ENTRY (editable))
        ///     {
        ///       GtkEntry *entry = GTK_ENTRY (editable);
        ///
        ///       // ... create a GtkEntryCompletion
        ///
        ///       gtk_entry_set_completion (entry, completion);
        ///     }
        /// }
        /// ```
        pub const editing_started = struct {
            pub const name = "editing-started";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_editable: *gtk.CellEditable, p_path: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRenderer, p_instance))),
                    gobject.signalLookup("editing-started", CellRenderer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Passes an activate event to the cell renderer for possible processing.
    /// Some cell renderers may use events; for example, `GtkCellRendererToggle`
    /// toggles when it gets a mouse click.
    extern fn gtk_cell_renderer_activate(p_cell: *CellRenderer, p_event: *gdk.Event, p_widget: *gtk.Widget, p_path: [*:0]const u8, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) c_int;
    pub const activate = gtk_cell_renderer_activate;

    /// Gets the aligned area used by `cell` inside `cell_area`. Used for finding
    /// the appropriate edit and focus rectangle.
    extern fn gtk_cell_renderer_get_aligned_area(p_cell: *CellRenderer, p_widget: *gtk.Widget, p_flags: gtk.CellRendererState, p_cell_area: *const gdk.Rectangle, p_aligned_area: *gdk.Rectangle) void;
    pub const getAlignedArea = gtk_cell_renderer_get_aligned_area;

    /// Fills in `xalign` and `yalign` with the appropriate values of `cell`.
    extern fn gtk_cell_renderer_get_alignment(p_cell: *CellRenderer, p_xalign: ?*f32, p_yalign: ?*f32) void;
    pub const getAlignment = gtk_cell_renderer_get_alignment;

    /// Fills in `width` and `height` with the appropriate size of `cell`.
    extern fn gtk_cell_renderer_get_fixed_size(p_cell: *CellRenderer, p_width: ?*c_int, p_height: ?*c_int) void;
    pub const getFixedSize = gtk_cell_renderer_get_fixed_size;

    /// Checks whether the given `GtkCellRenderer` is expanded.
    extern fn gtk_cell_renderer_get_is_expanded(p_cell: *CellRenderer) c_int;
    pub const getIsExpanded = gtk_cell_renderer_get_is_expanded;

    /// Checks whether the given `GtkCellRenderer` is an expander.
    extern fn gtk_cell_renderer_get_is_expander(p_cell: *CellRenderer) c_int;
    pub const getIsExpander = gtk_cell_renderer_get_is_expander;

    /// Fills in `xpad` and `ypad` with the appropriate values of `cell`.
    extern fn gtk_cell_renderer_get_padding(p_cell: *CellRenderer, p_xpad: ?*c_int, p_ypad: ?*c_int) void;
    pub const getPadding = gtk_cell_renderer_get_padding;

    /// Retrieves a renderer’s natural size when rendered to `widget`.
    extern fn gtk_cell_renderer_get_preferred_height(p_cell: *CellRenderer, p_widget: *gtk.Widget, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) void;
    pub const getPreferredHeight = gtk_cell_renderer_get_preferred_height;

    /// Retrieves a cell renderers’s minimum and natural height if it were rendered to
    /// `widget` with the specified `width`.
    extern fn gtk_cell_renderer_get_preferred_height_for_width(p_cell: *CellRenderer, p_widget: *gtk.Widget, p_width: c_int, p_minimum_height: ?*c_int, p_natural_height: ?*c_int) void;
    pub const getPreferredHeightForWidth = gtk_cell_renderer_get_preferred_height_for_width;

    /// Retrieves the minimum and natural size of a cell taking
    /// into account the widget’s preference for height-for-width management.
    extern fn gtk_cell_renderer_get_preferred_size(p_cell: *CellRenderer, p_widget: *gtk.Widget, p_minimum_size: ?*gtk.Requisition, p_natural_size: ?*gtk.Requisition) void;
    pub const getPreferredSize = gtk_cell_renderer_get_preferred_size;

    /// Retrieves a renderer’s natural size when rendered to `widget`.
    extern fn gtk_cell_renderer_get_preferred_width(p_cell: *CellRenderer, p_widget: *gtk.Widget, p_minimum_size: ?*c_int, p_natural_size: ?*c_int) void;
    pub const getPreferredWidth = gtk_cell_renderer_get_preferred_width;

    /// Retrieves a cell renderers’s minimum and natural width if it were rendered to
    /// `widget` with the specified `height`.
    extern fn gtk_cell_renderer_get_preferred_width_for_height(p_cell: *CellRenderer, p_widget: *gtk.Widget, p_height: c_int, p_minimum_width: ?*c_int, p_natural_width: ?*c_int) void;
    pub const getPreferredWidthForHeight = gtk_cell_renderer_get_preferred_width_for_height;

    /// Gets whether the cell renderer prefers a height-for-width layout
    /// or a width-for-height layout.
    extern fn gtk_cell_renderer_get_request_mode(p_cell: *CellRenderer) gtk.SizeRequestMode;
    pub const getRequestMode = gtk_cell_renderer_get_request_mode;

    /// Returns the cell renderer’s sensitivity.
    extern fn gtk_cell_renderer_get_sensitive(p_cell: *CellRenderer) c_int;
    pub const getSensitive = gtk_cell_renderer_get_sensitive;

    /// Translates the cell renderer state to `GtkStateFlags`,
    /// based on the cell renderer and widget sensitivity, and
    /// the given `GtkCellRenderer`State.
    extern fn gtk_cell_renderer_get_state(p_cell: ?*CellRenderer, p_widget: ?*gtk.Widget, p_cell_state: gtk.CellRendererState) gtk.StateFlags;
    pub const getState = gtk_cell_renderer_get_state;

    /// Returns the cell renderer’s visibility.
    extern fn gtk_cell_renderer_get_visible(p_cell: *CellRenderer) c_int;
    pub const getVisible = gtk_cell_renderer_get_visible;

    /// Checks whether the cell renderer can do something when activated.
    extern fn gtk_cell_renderer_is_activatable(p_cell: *CellRenderer) c_int;
    pub const isActivatable = gtk_cell_renderer_is_activatable;

    /// Sets the renderer’s alignment within its available space.
    extern fn gtk_cell_renderer_set_alignment(p_cell: *CellRenderer, p_xalign: f32, p_yalign: f32) void;
    pub const setAlignment = gtk_cell_renderer_set_alignment;

    /// Sets the renderer size to be explicit, independent of the properties set.
    extern fn gtk_cell_renderer_set_fixed_size(p_cell: *CellRenderer, p_width: c_int, p_height: c_int) void;
    pub const setFixedSize = gtk_cell_renderer_set_fixed_size;

    /// Sets whether the given `GtkCellRenderer` is expanded.
    extern fn gtk_cell_renderer_set_is_expanded(p_cell: *CellRenderer, p_is_expanded: c_int) void;
    pub const setIsExpanded = gtk_cell_renderer_set_is_expanded;

    /// Sets whether the given `GtkCellRenderer` is an expander.
    extern fn gtk_cell_renderer_set_is_expander(p_cell: *CellRenderer, p_is_expander: c_int) void;
    pub const setIsExpander = gtk_cell_renderer_set_is_expander;

    /// Sets the renderer’s padding.
    extern fn gtk_cell_renderer_set_padding(p_cell: *CellRenderer, p_xpad: c_int, p_ypad: c_int) void;
    pub const setPadding = gtk_cell_renderer_set_padding;

    /// Sets the cell renderer’s sensitivity.
    extern fn gtk_cell_renderer_set_sensitive(p_cell: *CellRenderer, p_sensitive: c_int) void;
    pub const setSensitive = gtk_cell_renderer_set_sensitive;

    /// Sets the cell renderer’s visibility.
    extern fn gtk_cell_renderer_set_visible(p_cell: *CellRenderer, p_visible: c_int) void;
    pub const setVisible = gtk_cell_renderer_set_visible;

    /// Invokes the virtual render function of the `GtkCellRenderer`. The three
    /// passed-in rectangles are areas in `cr`. Most renderers will draw within
    /// `cell_area`; the xalign, yalign, xpad, and ypad fields of the `GtkCellRenderer`
    /// should be honored with respect to `cell_area`. `background_area` includes the
    /// blank space around the cell, and also the area containing the tree expander;
    /// so the `background_area` rectangles for all cells tile to cover the entire
    /// `window`.
    extern fn gtk_cell_renderer_snapshot(p_cell: *CellRenderer, p_snapshot: *gtk.Snapshot, p_widget: *gtk.Widget, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) void;
    pub const snapshot = gtk_cell_renderer_snapshot;

    /// Starts editing the contents of this `cell`, through a new `GtkCellEditable`
    /// widget created by the `GtkCellRenderer`Class.start_editing virtual function.
    extern fn gtk_cell_renderer_start_editing(p_cell: *CellRenderer, p_event: ?*gdk.Event, p_widget: *gtk.Widget, p_path: [*:0]const u8, p_background_area: *const gdk.Rectangle, p_cell_area: *const gdk.Rectangle, p_flags: gtk.CellRendererState) ?*gtk.CellEditable;
    pub const startEditing = gtk_cell_renderer_start_editing;

    /// Informs the cell renderer that the editing is stopped.
    /// If `canceled` is `TRUE`, the cell renderer will emit the
    /// `GtkCellRenderer`::editing-canceled signal.
    ///
    /// This function should be called by cell renderer implementations
    /// in response to the `GtkCellEditable::editing-done` signal of
    /// `GtkCellEditable`.
    extern fn gtk_cell_renderer_stop_editing(p_cell: *CellRenderer, p_canceled: c_int) void;
    pub const stopEditing = gtk_cell_renderer_stop_editing;

    extern fn gtk_cell_renderer_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRenderer) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRenderer) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRenderer, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders a keyboard accelerator in a cell
///
/// `GtkCellRendererAccel` displays a keyboard accelerator (i.e. a key
/// combination like `Control + a`). If the cell renderer is editable,
/// the accelerator can be changed by simply typing the new combination.
pub const CellRendererAccel = opaque {
    pub const Parent = gtk.CellRendererText;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CellRendererAccel;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The keyval of the accelerator.
        pub const accel_key = struct {
            pub const name = "accel-key";

            pub const Type = c_uint;
        };

        /// Determines if the edited accelerators are GTK accelerators. If
        /// they are, consumed modifiers are suppressed, only accelerators
        /// accepted by GTK are allowed, and the accelerators are rendered
        /// in the same way as they are in menus.
        pub const accel_mode = struct {
            pub const name = "accel-mode";

            pub const Type = gtk.CellRendererAccelMode;
        };

        /// The modifier mask of the accelerator.
        pub const accel_mods = struct {
            pub const name = "accel-mods";

            pub const Type = gdk.ModifierType;
        };

        /// The hardware keycode of the accelerator. Note that the hardware keycode is
        /// only relevant if the key does not have a keyval. Normally, the keyboard
        /// configuration should assign keyvals to all keys.
        pub const keycode = struct {
            pub const name = "keycode";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// Gets emitted when the user has removed the accelerator.
        pub const accel_cleared = struct {
            pub const name = "accel-cleared";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path_string: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRendererAccel, p_instance))),
                    gobject.signalLookup("accel-cleared", CellRendererAccel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Gets emitted when the user has selected a new accelerator.
        pub const accel_edited = struct {
            pub const name = "accel-edited";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path_string: [*:0]u8, p_accel_key: c_uint, p_accel_mods: gdk.ModifierType, p_hardware_keycode: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRendererAccel, p_instance))),
                    gobject.signalLookup("accel-edited", CellRendererAccel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkCellRendererAccel`.
    extern fn gtk_cell_renderer_accel_new() *gtk.CellRendererAccel;
    pub const new = gtk_cell_renderer_accel_new;

    extern fn gtk_cell_renderer_accel_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_accel_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererAccel) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererAccel) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererAccel, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders a combobox in a cell
///
/// `GtkCellRendererCombo` renders text in a cell like `GtkCellRendererText` from
/// which it is derived. But while `GtkCellRendererText` offers a simple entry to
/// edit the text, `GtkCellRendererCombo` offers a `GtkComboBox`
/// widget to edit the text. The values to display in the combo box are taken from
/// the tree model specified in the `GtkCellRendererCombo`:model property.
///
/// The combo cell renderer takes care of adding a text cell renderer to the combo
/// box and sets it to display the column specified by its
/// `GtkCellRendererCombo`:text-column property. Further properties of the combo box
/// can be set in a handler for the `GtkCellRenderer::editing-started` signal.
pub const CellRendererCombo = opaque {
    pub const Parent = gtk.CellRendererText;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CellRendererCombo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// If `TRUE`, the cell renderer will include an entry and allow to enter
        /// values other than the ones in the popup list.
        pub const has_entry = struct {
            pub const name = "has-entry";

            pub const Type = c_int;
        };

        /// Holds a tree model containing the possible values for the combo box.
        /// Use the text_column property to specify the column holding the values.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gtk.TreeModel;
        };

        /// Specifies the model column which holds the possible values for the
        /// combo box.
        ///
        /// Note that this refers to the model specified in the model property,
        /// not the model backing the tree view to which
        /// this cell renderer is attached.
        ///
        /// `GtkCellRendererCombo` automatically adds a text cell renderer for
        /// this column to its combo box.
        pub const text_column = struct {
            pub const name = "text-column";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// This signal is emitted each time after the user selected an item in
        /// the combo box, either by using the mouse or the arrow keys.  Contrary
        /// to GtkComboBox, GtkCellRendererCombo::changed is not emitted for
        /// changes made to a selected item in the entry.  The argument `new_iter`
        /// corresponds to the newly selected item in the combo box and it is relative
        /// to the GtkTreeModel set via the model property on GtkCellRendererCombo.
        ///
        /// Note that as soon as you change the model displayed in the tree view,
        /// the tree view will immediately cease the editing operating.  This
        /// means that you most probably want to refrain from changing the model
        /// until the combo cell renderer emits the edited or editing_canceled signal.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path_string: [*:0]u8, p_new_iter: *gtk.TreeIter, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRendererCombo, p_instance))),
                    gobject.signalLookup("changed", CellRendererCombo.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkCellRendererCombo`.
    /// Adjust how text is drawn using object properties.
    /// Object properties can be set globally (with `gobject.Object.set`).
    /// Also, with `GtkTreeViewColumn`, you can bind a property to a value
    /// in a `GtkTreeModel`. For example, you can bind the “text” property
    /// on the cell renderer to a string value in the model, thus rendering
    /// a different string in each row of the `GtkTreeView`.
    extern fn gtk_cell_renderer_combo_new() *gtk.CellRendererCombo;
    pub const new = gtk_cell_renderer_combo_new;

    extern fn gtk_cell_renderer_combo_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_combo_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererCombo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererCombo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererCombo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders a pixbuf in a cell
///
/// A `GtkCellRendererPixbuf` can be used to render an image in a cell. It allows
/// to render either a given `GdkPixbuf` (set via the
/// `GtkCellRendererPixbuf:pixbuf` property) or a named icon (set via the
/// `GtkCellRendererPixbuf:icon-name` property).
///
/// To support the tree view, `GtkCellRendererPixbuf` also supports rendering two
/// alternative pixbufs, when the `GtkCellRenderer:is-expander` property is `TRUE`.
/// If the `GtkCellRenderer:is-expanded property` is `TRUE` and the
/// `GtkCellRendererPixbuf:pixbuf-expander-open` property is set to a pixbuf, it
/// renders that pixbuf, if the `GtkCellRenderer:is-expanded` property is `FALSE`
/// and the `GtkCellRendererPixbuf:pixbuf-expander-closed` property is set to a
/// pixbuf, it renders that one.
pub const CellRendererPixbuf = opaque {
    pub const Parent = gtk.CellRenderer;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CellRendererPixbuf;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The GIcon representing the icon to display.
        /// If the icon theme is changed, the image will be updated
        /// automatically.
        pub const gicon = struct {
            pub const name = "gicon";

            pub const Type = ?*gio.Icon;
        };

        /// The name of the themed icon to display.
        /// This property only has an effect if not overridden by the "pixbuf" property.
        pub const icon_name = struct {
            pub const name = "icon-name";

            pub const Type = ?[*:0]u8;
        };

        /// The `GtkIconSize` value that specifies the size of the rendered icon.
        pub const icon_size = struct {
            pub const name = "icon-size";

            pub const Type = gtk.IconSize;
        };

        pub const pixbuf = struct {
            pub const name = "pixbuf";

            pub const Type = ?*gdkpixbuf.Pixbuf;
        };

        pub const pixbuf_expander_closed = struct {
            pub const name = "pixbuf-expander-closed";

            pub const Type = ?*gdkpixbuf.Pixbuf;
        };

        pub const pixbuf_expander_open = struct {
            pub const name = "pixbuf-expander-open";

            pub const Type = ?*gdkpixbuf.Pixbuf;
        };

        pub const texture = struct {
            pub const name = "texture";

            pub const Type = ?*gdk.Texture;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCellRendererPixbuf`. Adjust rendering
    /// parameters using object properties. Object properties can be set
    /// globally (with `gobject.Object.set`). Also, with `GtkTreeViewColumn`, you
    /// can bind a property to a value in a `GtkTreeModel`. For example, you
    /// can bind the “pixbuf” property on the cell renderer to a pixbuf value
    /// in the model, thus rendering a different image in each row of the
    /// `GtkTreeView`.
    extern fn gtk_cell_renderer_pixbuf_new() *gtk.CellRendererPixbuf;
    pub const new = gtk_cell_renderer_pixbuf_new;

    extern fn gtk_cell_renderer_pixbuf_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_pixbuf_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererPixbuf) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererPixbuf) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererPixbuf, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders numbers as progress bars
///
/// `GtkCellRendererProgress` renders a numeric value as a progress par in a cell.
/// Additionally, it can display a text on top of the progress bar.
pub const CellRendererProgress = opaque {
    pub const Parent = gtk.CellRenderer;
    pub const Implements = [_]type{gtk.Orientable};
    pub const Class = opaque {
        pub const Instance = CellRendererProgress;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether progess is inverted.
        pub const inverted = struct {
            pub const name = "inverted";

            pub const Type = c_int;
        };

        /// Setting this to a non-negative value causes the cell renderer to
        /// enter "activity mode", where a block bounces back and forth to
        /// indicate that some progress is made, without specifying exactly how
        /// much.
        ///
        /// Each increment of the property causes the block to move by a little
        /// bit.
        ///
        /// To indicate that the activity has not started yet, set the property
        /// to zero. To indicate completion, set the property to `G_MAXINT`.
        pub const pulse = struct {
            pub const name = "pulse";

            pub const Type = c_int;
        };

        /// The "text" property determines the label which will be drawn
        /// over the progress bar. Setting this property to `NULL` causes the default
        /// label to be displayed. Setting this property to an empty string causes
        /// no label to be displayed.
        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        /// The "text-xalign" property controls the horizontal alignment of the
        /// text in the progress bar.  Valid values range from 0 (left) to 1
        /// (right).  Reserved for RTL layouts.
        pub const text_xalign = struct {
            pub const name = "text-xalign";

            pub const Type = f32;
        };

        /// The "text-yalign" property controls the vertical alignment of the
        /// text in the progress bar.  Valid values range from 0 (top) to 1
        /// (bottom).
        pub const text_yalign = struct {
            pub const name = "text-yalign";

            pub const Type = f32;
        };

        /// The "value" property determines the percentage to which the
        /// progress bar will be "filled in".
        pub const value = struct {
            pub const name = "value";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCellRendererProgress`.
    extern fn gtk_cell_renderer_progress_new() *gtk.CellRendererProgress;
    pub const new = gtk_cell_renderer_progress_new;

    extern fn gtk_cell_renderer_progress_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_progress_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererProgress) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererProgress) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererProgress, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders a spin button in a cell
///
/// `GtkCellRendererSpin` renders text in a cell like `GtkCellRendererText` from
/// which it is derived. But while `GtkCellRendererText` offers a simple entry to
/// edit the text, `GtkCellRendererSpin` offers a `GtkSpinButton` widget. Of course,
/// that means that the text has to be parseable as a floating point number.
///
/// The range of the spinbutton is taken from the adjustment property of the
/// cell renderer, which can be set explicitly or mapped to a column in the
/// tree model, like all properties of cell renders. `GtkCellRendererSpin`
/// also has properties for the `GtkCellRendererSpin:climb-rate` and the number
/// of `GtkCellRendererSpin:digits` to display. Other `GtkSpinButton` properties
/// can be set in a handler for the `GtkCellRenderer::editing-started` signal.
pub const CellRendererSpin = opaque {
    pub const Parent = gtk.CellRendererText;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CellRendererSpin;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The adjustment that holds the value of the spinbutton.
        /// This must be non-`NULL` for the cell renderer to be editable.
        pub const adjustment = struct {
            pub const name = "adjustment";

            pub const Type = ?*gtk.Adjustment;
        };

        /// The acceleration rate when you hold down a button.
        pub const climb_rate = struct {
            pub const name = "climb-rate";

            pub const Type = f64;
        };

        /// The number of decimal places to display.
        pub const digits = struct {
            pub const name = "digits";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCellRendererSpin`.
    extern fn gtk_cell_renderer_spin_new() *gtk.CellRendererSpin;
    pub const new = gtk_cell_renderer_spin_new;

    extern fn gtk_cell_renderer_spin_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_spin_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererSpin) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererSpin) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererSpin, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders a spinning animation in a cell
///
/// `GtkCellRendererSpinner` renders a spinning animation in a cell, very
/// similar to `GtkSpinner`. It can often be used as an alternative
/// to a `GtkCellRendererProgress` for displaying indefinite activity,
/// instead of actual progress.
///
/// To start the animation in a cell, set the `GtkCellRendererSpinner:active`
/// property to `TRUE` and increment the `GtkCellRendererSpinner:pulse` property
/// at regular intervals. The usual way to set the cell renderer properties
/// for each cell is to bind them to columns in your tree model using e.g.
/// `gtk.TreeViewColumn.addAttribute`.
pub const CellRendererSpinner = opaque {
    pub const Parent = gtk.CellRenderer;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CellRendererSpinner;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the spinner is active (ie. shown) in the cell
        pub const active = struct {
            pub const name = "active";

            pub const Type = c_int;
        };

        /// Pulse of the spinner. Increment this value to draw the next frame of the
        /// spinner animation. Usually, you would update this value in a timeout.
        ///
        /// By default, the `GtkSpinner` widget draws one full cycle of the animation,
        /// consisting of 12 frames, in 750 milliseconds.
        pub const pulse = struct {
            pub const name = "pulse";

            pub const Type = c_uint;
        };

        /// The `GtkIconSize` value that specifies the size of the rendered spinner.
        pub const size = struct {
            pub const name = "size";

            pub const Type = gtk.IconSize;
        };
    };

    pub const signals = struct {};

    /// Returns a new cell renderer which will show a spinner to indicate
    /// activity.
    extern fn gtk_cell_renderer_spinner_new() *gtk.CellRendererSpinner;
    pub const new = gtk_cell_renderer_spinner_new;

    extern fn gtk_cell_renderer_spinner_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_spinner_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererSpinner) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererSpinner) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererSpinner, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders text in a cell
///
/// A `GtkCellRendererText` renders a given text in its cell, using the font, color and
/// style information provided by its properties. The text will be ellipsized if it is
/// too long and the `GtkCellRendererText:ellipsize` property allows it.
///
/// If the `GtkCellRenderer:mode` is `GTK_CELL_RENDERER_MODE_EDITABLE`,
/// the `GtkCellRendererText` allows to edit its text using an entry.
pub const CellRendererText = extern struct {
    pub const Parent = gtk.CellRenderer;
    pub const Implements = [_]type{};
    pub const Class = gtk.CellRendererTextClass;
    f_parent: gtk.CellRenderer,

    pub const virtual_methods = struct {
        pub const edited = struct {
            pub fn call(p_class: anytype, p_cell_renderer_text: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_path: [*:0]const u8, p_new_text: [*:0]const u8) void {
                return gobject.ext.as(CellRendererText.Class, p_class).f_edited.?(gobject.ext.as(CellRendererText, p_cell_renderer_text), p_path, p_new_text);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_cell_renderer_text: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_path: [*:0]const u8, p_new_text: [*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(CellRendererText.Class, p_class).f_edited = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        pub const align_set = struct {
            pub const name = "align-set";

            pub const Type = c_int;
        };

        /// Specifies how to align the lines of text with respect to each other.
        ///
        /// Note that this property describes how to align the lines of text in
        /// case there are several of them. The "xalign" property of `GtkCellRenderer`,
        /// on the other hand, sets the horizontal alignment of the whole text.
        pub const alignment = struct {
            pub const name = "alignment";

            pub const Type = pango.Alignment;
        };

        pub const attributes = struct {
            pub const name = "attributes";

            pub const Type = ?*pango.AttrList;
        };

        pub const background = struct {
            pub const name = "background";

            pub const Type = ?[*:0]u8;
        };

        /// Background color as a `GdkRGBA`
        pub const background_rgba = struct {
            pub const name = "background-rgba";

            pub const Type = ?*gdk.RGBA;
        };

        pub const background_set = struct {
            pub const name = "background-set";

            pub const Type = c_int;
        };

        pub const editable = struct {
            pub const name = "editable";

            pub const Type = c_int;
        };

        pub const editable_set = struct {
            pub const name = "editable-set";

            pub const Type = c_int;
        };

        /// Specifies the preferred place to ellipsize the string, if the cell renderer
        /// does not have enough room to display the entire string. Setting it to
        /// `PANGO_ELLIPSIZE_NONE` turns off ellipsizing. See the wrap-width property
        /// for another way of making the text fit into a given width.
        pub const ellipsize = struct {
            pub const name = "ellipsize";

            pub const Type = pango.EllipsizeMode;
        };

        pub const ellipsize_set = struct {
            pub const name = "ellipsize-set";

            pub const Type = c_int;
        };

        pub const family = struct {
            pub const name = "family";

            pub const Type = ?[*:0]u8;
        };

        pub const family_set = struct {
            pub const name = "family-set";

            pub const Type = c_int;
        };

        pub const font = struct {
            pub const name = "font";

            pub const Type = ?[*:0]u8;
        };

        pub const font_desc = struct {
            pub const name = "font-desc";

            pub const Type = ?*pango.FontDescription;
        };

        pub const foreground = struct {
            pub const name = "foreground";

            pub const Type = ?[*:0]u8;
        };

        /// Foreground color as a `GdkRGBA`
        pub const foreground_rgba = struct {
            pub const name = "foreground-rgba";

            pub const Type = ?*gdk.RGBA;
        };

        pub const foreground_set = struct {
            pub const name = "foreground-set";

            pub const Type = c_int;
        };

        pub const language = struct {
            pub const name = "language";

            pub const Type = ?[*:0]u8;
        };

        pub const language_set = struct {
            pub const name = "language-set";

            pub const Type = c_int;
        };

        pub const markup = struct {
            pub const name = "markup";

            pub const Type = ?[*:0]u8;
        };

        /// The desired maximum width of the cell, in characters. If this property
        /// is set to -1, the width will be calculated automatically.
        ///
        /// For cell renderers that ellipsize or wrap text; this property
        /// controls the maximum reported width of the cell. The
        /// cell should not receive any greater allocation unless it is
        /// set to expand in its `GtkCellLayout` and all of the cell's siblings
        /// have received their natural width.
        pub const max_width_chars = struct {
            pub const name = "max-width-chars";

            pub const Type = c_int;
        };

        /// The text that will be displayed in the `GtkCellRenderer` if
        /// `GtkCellRendererText:editable` is `TRUE` and the cell is empty.
        pub const placeholder_text = struct {
            pub const name = "placeholder-text";

            pub const Type = ?[*:0]u8;
        };

        pub const rise = struct {
            pub const name = "rise";

            pub const Type = c_int;
        };

        pub const rise_set = struct {
            pub const name = "rise-set";

            pub const Type = c_int;
        };

        pub const scale = struct {
            pub const name = "scale";

            pub const Type = f64;
        };

        pub const scale_set = struct {
            pub const name = "scale-set";

            pub const Type = c_int;
        };

        pub const single_paragraph_mode = struct {
            pub const name = "single-paragraph-mode";

            pub const Type = c_int;
        };

        pub const size = struct {
            pub const name = "size";

            pub const Type = c_int;
        };

        pub const size_points = struct {
            pub const name = "size-points";

            pub const Type = f64;
        };

        pub const size_set = struct {
            pub const name = "size-set";

            pub const Type = c_int;
        };

        pub const stretch = struct {
            pub const name = "stretch";

            pub const Type = pango.Stretch;
        };

        pub const stretch_set = struct {
            pub const name = "stretch-set";

            pub const Type = c_int;
        };

        pub const strikethrough = struct {
            pub const name = "strikethrough";

            pub const Type = c_int;
        };

        pub const strikethrough_set = struct {
            pub const name = "strikethrough-set";

            pub const Type = c_int;
        };

        pub const style = struct {
            pub const name = "style";

            pub const Type = pango.Style;
        };

        pub const style_set = struct {
            pub const name = "style-set";

            pub const Type = c_int;
        };

        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        pub const underline = struct {
            pub const name = "underline";

            pub const Type = pango.Underline;
        };

        pub const underline_set = struct {
            pub const name = "underline-set";

            pub const Type = c_int;
        };

        pub const variant = struct {
            pub const name = "variant";

            pub const Type = pango.Variant;
        };

        pub const variant_set = struct {
            pub const name = "variant-set";

            pub const Type = c_int;
        };

        pub const weight = struct {
            pub const name = "weight";

            pub const Type = c_int;
        };

        pub const weight_set = struct {
            pub const name = "weight-set";

            pub const Type = c_int;
        };

        /// The desired width of the cell, in characters. If this property is set to
        /// -1, the width will be calculated automatically, otherwise the cell will
        /// request either 3 characters or the property value, whichever is greater.
        pub const width_chars = struct {
            pub const name = "width-chars";

            pub const Type = c_int;
        };

        /// Specifies how to break the string into multiple lines, if the cell
        /// renderer does not have enough room to display the entire string.
        /// This property has no effect unless the wrap-width property is set.
        pub const wrap_mode = struct {
            pub const name = "wrap-mode";

            pub const Type = pango.WrapMode;
        };

        /// Specifies the minimum width at which the text is wrapped. The wrap-mode property can
        /// be used to influence at what character positions the line breaks can be placed.
        /// Setting wrap-width to -1 turns wrapping off.
        pub const wrap_width = struct {
            pub const name = "wrap-width";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// This signal is emitted after `renderer` has been edited.
        ///
        /// It is the responsibility of the application to update the model
        /// and store `new_text` at the position indicated by `path`.
        pub const edited = struct {
            pub const name = "edited";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path: [*:0]u8, p_new_text: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRendererText, p_instance))),
                    gobject.signalLookup("edited", CellRendererText.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkCellRendererText`. Adjust how text is drawn using
    /// object properties. Object properties can be
    /// set globally (with `gobject.Object.set`). Also, with `GtkTreeViewColumn`,
    /// you can bind a property to a value in a `GtkTreeModel`. For example,
    /// you can bind the “text” property on the cell renderer to a string
    /// value in the model, thus rendering a different string in each row
    /// of the `GtkTreeView`.
    extern fn gtk_cell_renderer_text_new() *gtk.CellRendererText;
    pub const new = gtk_cell_renderer_text_new;

    /// Sets the height of a renderer to explicitly be determined by the “font” and
    /// “y_pad” property set on it.  Further changes in these properties do not
    /// affect the height, so they must be accompanied by a subsequent call to this
    /// function.  Using this function is inflexible, and should really only be used
    /// if calculating the size of a cell is too slow (ie, a massive number of cells
    /// displayed).  If `number_of_rows` is -1, then the fixed height is unset, and
    /// the height is determined by the properties again.
    extern fn gtk_cell_renderer_text_set_fixed_height_from_font(p_renderer: *CellRendererText, p_number_of_rows: c_int) void;
    pub const setFixedHeightFromFont = gtk_cell_renderer_text_set_fixed_height_from_font;

    extern fn gtk_cell_renderer_text_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_text_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererText) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererText) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererText, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Renders a toggle button in a cell
///
/// `GtkCellRendererToggle` renders a toggle button in a cell. The
/// button is drawn as a radio or a checkbutton, depending on the
/// `GtkCellRendererToggle:radio` property.
/// When activated, it emits the `GtkCellRendererToggle::toggled` signal.
pub const CellRendererToggle = opaque {
    pub const Parent = gtk.CellRenderer;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = CellRendererToggle;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const activatable = struct {
            pub const name = "activatable";

            pub const Type = c_int;
        };

        pub const active = struct {
            pub const name = "active";

            pub const Type = c_int;
        };

        pub const inconsistent = struct {
            pub const name = "inconsistent";

            pub const Type = c_int;
        };

        pub const radio = struct {
            pub const name = "radio";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// The ::toggled signal is emitted when the cell is toggled.
        ///
        /// It is the responsibility of the application to update the model
        /// with the correct value to store at `path`.  Often this is simply the
        /// opposite of the value currently stored at `path`.
        pub const toggled = struct {
            pub const name = "toggled";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CellRendererToggle, p_instance))),
                    gobject.signalLookup("toggled", CellRendererToggle.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkCellRendererToggle`. Adjust rendering
    /// parameters using object properties. Object properties can be set
    /// globally (with `gobject.Object.set`). Also, with `GtkTreeViewColumn`, you
    /// can bind a property to a value in a `GtkTreeModel`. For example, you
    /// can bind the “active” property on the cell renderer to a boolean value
    /// in the model, thus causing the check button to reflect the state of
    /// the model.
    extern fn gtk_cell_renderer_toggle_new() *gtk.CellRendererToggle;
    pub const new = gtk_cell_renderer_toggle_new;

    /// Returns whether the cell renderer is activatable. See
    /// `gtk.CellRendererToggle.setActivatable`.
    extern fn gtk_cell_renderer_toggle_get_activatable(p_toggle: *CellRendererToggle) c_int;
    pub const getActivatable = gtk_cell_renderer_toggle_get_activatable;

    /// Returns whether the cell renderer is active. See
    /// `gtk.CellRendererToggle.setActive`.
    extern fn gtk_cell_renderer_toggle_get_active(p_toggle: *CellRendererToggle) c_int;
    pub const getActive = gtk_cell_renderer_toggle_get_active;

    /// Returns whether we’re rendering radio toggles rather than checkboxes.
    extern fn gtk_cell_renderer_toggle_get_radio(p_toggle: *CellRendererToggle) c_int;
    pub const getRadio = gtk_cell_renderer_toggle_get_radio;

    /// Makes the cell renderer activatable.
    extern fn gtk_cell_renderer_toggle_set_activatable(p_toggle: *CellRendererToggle, p_setting: c_int) void;
    pub const setActivatable = gtk_cell_renderer_toggle_set_activatable;

    /// Activates or deactivates a cell renderer.
    extern fn gtk_cell_renderer_toggle_set_active(p_toggle: *CellRendererToggle, p_setting: c_int) void;
    pub const setActive = gtk_cell_renderer_toggle_set_active;

    /// If `radio` is `TRUE`, the cell renderer renders a radio toggle
    /// (i.e. a toggle in a group of mutually-exclusive toggles).
    /// If `FALSE`, it renders a check toggle (a standalone boolean option).
    /// This can be set globally for the cell renderer, or changed just
    /// before rendering each cell in the model (for `GtkTreeView`, you set
    /// up a per-row setting using `GtkTreeViewColumn` to associate model
    /// columns with cell renderer properties).
    extern fn gtk_cell_renderer_toggle_set_radio(p_toggle: *CellRendererToggle, p_radio: c_int) void;
    pub const setRadio = gtk_cell_renderer_toggle_set_radio;

    extern fn gtk_cell_renderer_toggle_get_type() usize;
    pub const getGObjectType = gtk_cell_renderer_toggle_get_type;

    extern fn g_object_ref(p_self: *gtk.CellRendererToggle) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellRendererToggle) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellRendererToggle, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A widget displaying a single row of a GtkTreeModel
///
/// A `GtkCellView` displays a single row of a `GtkTreeModel` using a `GtkCellArea`
/// and `GtkCellAreaContext`. A `GtkCellAreaContext` can be provided to the
/// `GtkCellView` at construction time in order to keep the cellview in context
/// of a group of cell views, this ensures that the renderers displayed will
/// be properly aligned with each other (like the aligned cells in the menus
/// of `GtkComboBox`).
///
/// `GtkCellView` is `GtkOrientable` in order to decide in which orientation
/// the underlying `GtkCellAreaContext` should be allocated. Taking the `GtkComboBox`
/// menu as an example, cellviews should be oriented horizontally if the menus are
/// listed top-to-bottom and thus all share the same width but may have separate
/// individual heights (left-to-right menus should be allocated vertically since
/// they all share the same height but may have variable widths).
///
/// ## CSS nodes
///
/// GtkCellView has a single CSS node with name cellview.
pub const CellView = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.CellLayout, gtk.ConstraintTarget, gtk.Orientable };
    pub const Class = opaque {
        pub const Instance = CellView;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GtkCellArea` rendering cells
        ///
        /// If no area is specified when creating the cell view with `gtk.CellView.newWithContext`
        /// a horizontally oriented `GtkCellArea`Box will be used.
        ///
        /// since 3.0
        pub const cell_area = struct {
            pub const name = "cell-area";

            pub const Type = ?*gtk.CellArea;
        };

        /// The `GtkCellAreaContext` used to compute the geometry of the cell view.
        ///
        /// A group of cell views can be assigned the same context in order to
        /// ensure the sizes and cell alignments match across all the views with
        /// the same context.
        ///
        /// `GtkComboBox` menus uses this to assign the same context to all cell views
        /// in the menu items for a single menu (each submenu creates its own
        /// context since the size of each submenu does not depend on parent
        /// or sibling menus).
        ///
        /// since 3.0
        pub const cell_area_context = struct {
            pub const name = "cell-area-context";

            pub const Type = ?*gtk.CellAreaContext;
        };

        /// Whether all cells should be draw as sensitive for this view regardless
        /// of the actual cell properties (used to make menus with submenus appear
        /// sensitive when the items in submenus might be insensitive).
        ///
        /// since 3.0
        pub const draw_sensitive = struct {
            pub const name = "draw-sensitive";

            pub const Type = c_int;
        };

        /// Whether the view should request enough space to always fit
        /// the size of every row in the model (used by the combo box to
        /// ensure the combo box size doesn't change when different items
        /// are selected).
        ///
        /// since 3.0
        pub const fit_model = struct {
            pub const name = "fit-model";

            pub const Type = c_int;
        };

        /// The model for cell view
        ///
        /// since 2.10
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gtk.TreeModel;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCellView` widget.
    extern fn gtk_cell_view_new() *gtk.CellView;
    pub const new = gtk_cell_view_new;

    /// Creates a new `GtkCellView` widget with a specific `GtkCellArea`
    /// to layout cells and a specific `GtkCellAreaContext`.
    ///
    /// Specifying the same context for a handful of cells lets
    /// the underlying area synchronize the geometry for those cells,
    /// in this way alignments with cellviews for other rows are
    /// possible.
    extern fn gtk_cell_view_new_with_context(p_area: *gtk.CellArea, p_context: *gtk.CellAreaContext) *gtk.CellView;
    pub const newWithContext = gtk_cell_view_new_with_context;

    /// Creates a new `GtkCellView` widget, adds a `GtkCellRendererText`
    /// to it, and makes it show `markup`. The text can be marked up with
    /// the [Pango text markup language](https://docs.gtk.org/Pango/pango_markup.html).
    extern fn gtk_cell_view_new_with_markup(p_markup: [*:0]const u8) *gtk.CellView;
    pub const newWithMarkup = gtk_cell_view_new_with_markup;

    /// Creates a new `GtkCellView` widget, adds a `GtkCellRendererText`
    /// to it, and makes it show `text`.
    extern fn gtk_cell_view_new_with_text(p_text: [*:0]const u8) *gtk.CellView;
    pub const newWithText = gtk_cell_view_new_with_text;

    /// Creates a new `GtkCellView` widget, adds a `GtkCellRendererPixbuf`
    /// to it, and makes it show `texture`.
    extern fn gtk_cell_view_new_with_texture(p_texture: *gdk.Texture) *gtk.CellView;
    pub const newWithTexture = gtk_cell_view_new_with_texture;

    /// Returns a `GtkTreePath` referring to the currently
    /// displayed row. If no row is currently displayed,
    /// `NULL` is returned.
    extern fn gtk_cell_view_get_displayed_row(p_cell_view: *CellView) ?*gtk.TreePath;
    pub const getDisplayedRow = gtk_cell_view_get_displayed_row;

    /// Gets whether `cell_view` is configured to draw all of its
    /// cells in a sensitive state.
    extern fn gtk_cell_view_get_draw_sensitive(p_cell_view: *CellView) c_int;
    pub const getDrawSensitive = gtk_cell_view_get_draw_sensitive;

    /// Gets whether `cell_view` is configured to request space
    /// to fit the entire `GtkTreeModel`.
    extern fn gtk_cell_view_get_fit_model(p_cell_view: *CellView) c_int;
    pub const getFitModel = gtk_cell_view_get_fit_model;

    /// Returns the model for `cell_view`. If no model is used `NULL` is
    /// returned.
    extern fn gtk_cell_view_get_model(p_cell_view: *CellView) ?*gtk.TreeModel;
    pub const getModel = gtk_cell_view_get_model;

    /// Sets the row of the model that is currently displayed
    /// by the `GtkCellView`. If the path is unset, then the
    /// contents of the cellview “stick” at their last value;
    /// this is not normally a desired result, but may be
    /// a needed intermediate state if say, the model for
    /// the `GtkCellView` becomes temporarily empty.
    extern fn gtk_cell_view_set_displayed_row(p_cell_view: *CellView, p_path: ?*gtk.TreePath) void;
    pub const setDisplayedRow = gtk_cell_view_set_displayed_row;

    /// Sets whether `cell_view` should draw all of its
    /// cells in a sensitive state, this is used by `GtkComboBox` menus
    /// to ensure that rows with insensitive cells that contain
    /// children appear sensitive in the parent menu item.
    extern fn gtk_cell_view_set_draw_sensitive(p_cell_view: *CellView, p_draw_sensitive: c_int) void;
    pub const setDrawSensitive = gtk_cell_view_set_draw_sensitive;

    /// Sets whether `cell_view` should request space to fit the entire `GtkTreeModel`.
    ///
    /// This is used by `GtkComboBox` to ensure that the cell view displayed on
    /// the combo box’s button always gets enough space and does not resize
    /// when selection changes.
    extern fn gtk_cell_view_set_fit_model(p_cell_view: *CellView, p_fit_model: c_int) void;
    pub const setFitModel = gtk_cell_view_set_fit_model;

    /// Sets the model for `cell_view`.  If `cell_view` already has a model
    /// set, it will remove it before setting the new model.  If `model` is
    /// `NULL`, then it will unset the old model.
    extern fn gtk_cell_view_set_model(p_cell_view: *CellView, p_model: ?*gtk.TreeModel) void;
    pub const setModel = gtk_cell_view_set_model;

    extern fn gtk_cell_view_get_type() usize;
    pub const getGObjectType = gtk_cell_view_get_type;

    extern fn g_object_ref(p_self: *gtk.CellView) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CellView) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CellView, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCenterBox` arranges three children in a row, keeping the middle child
/// centered as well as possible.
///
/// ![An example GtkCenterBox](centerbox.png)
///
/// To add children to `GtkCenterBox`, use `gtk.CenterBox.setStartWidget`,
/// `gtk.CenterBox.setCenterWidget` and
/// `gtk.CenterBox.setEndWidget`.
///
/// The sizing and positioning of children can be influenced with the
/// align and expand properties of the children.
///
/// # GtkCenterBox as GtkBuildable
///
/// The `GtkCenterBox` implementation of the `GtkBuildable` interface
/// supports placing children in the 3 positions by specifying “start”, “center”
/// or “end” as the “type” attribute of a `<child>` element.
///
/// # CSS nodes
///
/// `GtkCenterBox` uses a single CSS node with the name “box”,
///
/// The first child of the `GtkCenterBox` will be allocated depending on the
/// text direction, i.e. in left-to-right layouts it will be allocated on the
/// left and in right-to-left layouts on the right.
///
/// In vertical orientation, the nodes of the children are arranged from top to
/// bottom.
///
/// # Accessibility
///
/// Until GTK 4.10, `GtkCenterBox` used the `GTK_ACCESSIBLE_ROLE_GROUP` role.
///
/// Starting from GTK 4.12, `GtkCenterBox` uses the `GTK_ACCESSIBLE_ROLE_GENERIC` role.
pub const CenterBox = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Orientable };
    pub const Class = gtk.CenterBoxClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The position of the baseline aligned widget if extra space is available.
        pub const baseline_position = struct {
            pub const name = "baseline-position";

            pub const Type = gtk.BaselinePosition;
        };

        /// The widget that is placed at the center position.
        pub const center_widget = struct {
            pub const name = "center-widget";

            pub const Type = ?*gtk.Widget;
        };

        /// The widget that is placed at the end position.
        ///
        /// In vertical orientation, the end position is at the bottom.
        /// In horizontal orientation, the end position is at the trailing
        /// edge wrt. to the text direction.
        pub const end_widget = struct {
            pub const name = "end-widget";

            pub const Type = ?*gtk.Widget;
        };

        /// Whether to shrink the center widget after other children.
        ///
        /// By default, when there's no space to give all three children their
        /// natural widths, the start and end widgets start shrinking and the
        /// center child keeps natural width until they reach minimum width.
        ///
        /// If set to `FALSE`, start and end widgets keep natural width and the
        /// center widget starts shrinking instead.
        pub const shrink_center_last = struct {
            pub const name = "shrink-center-last";

            pub const Type = c_int;
        };

        /// The widget that is placed at the start position.
        ///
        /// In vertical orientation, the start position is at the top.
        /// In horizontal orientation, the start position is at the leading
        /// edge wrt. to the text direction.
        pub const start_widget = struct {
            pub const name = "start-widget";

            pub const Type = ?*gtk.Widget;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCenterBox`.
    extern fn gtk_center_box_new() *gtk.CenterBox;
    pub const new = gtk_center_box_new;

    /// Gets the value set by `gtk.CenterBox.setBaselinePosition`.
    extern fn gtk_center_box_get_baseline_position(p_self: *CenterBox) gtk.BaselinePosition;
    pub const getBaselinePosition = gtk_center_box_get_baseline_position;

    /// Gets the center widget, or `NULL` if there is none.
    extern fn gtk_center_box_get_center_widget(p_self: *CenterBox) ?*gtk.Widget;
    pub const getCenterWidget = gtk_center_box_get_center_widget;

    /// Gets the end widget, or `NULL` if there is none.
    extern fn gtk_center_box_get_end_widget(p_self: *CenterBox) ?*gtk.Widget;
    pub const getEndWidget = gtk_center_box_get_end_widget;

    /// Gets whether `self` shrinks the center widget after other children.
    extern fn gtk_center_box_get_shrink_center_last(p_self: *CenterBox) c_int;
    pub const getShrinkCenterLast = gtk_center_box_get_shrink_center_last;

    /// Gets the start widget, or `NULL` if there is none.
    extern fn gtk_center_box_get_start_widget(p_self: *CenterBox) ?*gtk.Widget;
    pub const getStartWidget = gtk_center_box_get_start_widget;

    /// Sets the baseline position of a center box.
    ///
    /// This affects only horizontal boxes with at least one baseline
    /// aligned child. If there is more vertical space available than
    /// requested, and the baseline is not allocated by the parent then
    /// `position` is used to allocate the baseline wrt. the extra space
    /// available.
    extern fn gtk_center_box_set_baseline_position(p_self: *CenterBox, p_position: gtk.BaselinePosition) void;
    pub const setBaselinePosition = gtk_center_box_set_baseline_position;

    /// Sets the center widget.
    ///
    /// To remove the existing center widget, pass `NULL`.
    extern fn gtk_center_box_set_center_widget(p_self: *CenterBox, p_child: ?*gtk.Widget) void;
    pub const setCenterWidget = gtk_center_box_set_center_widget;

    /// Sets the end widget.
    ///
    /// To remove the existing end widget, pass `NULL`.
    extern fn gtk_center_box_set_end_widget(p_self: *CenterBox, p_child: ?*gtk.Widget) void;
    pub const setEndWidget = gtk_center_box_set_end_widget;

    /// Sets whether to shrink the center widget after other children.
    ///
    /// By default, when there's no space to give all three children their
    /// natural widths, the start and end widgets start shrinking and the
    /// center child keeps natural width until they reach minimum width.
    ///
    /// If set to `FALSE`, start and end widgets keep natural width and the
    /// center widget starts shrinking instead.
    extern fn gtk_center_box_set_shrink_center_last(p_self: *CenterBox, p_shrink_center_last: c_int) void;
    pub const setShrinkCenterLast = gtk_center_box_set_shrink_center_last;

    /// Sets the start widget.
    ///
    /// To remove the existing start widget, pass `NULL`.
    extern fn gtk_center_box_set_start_widget(p_self: *CenterBox, p_child: ?*gtk.Widget) void;
    pub const setStartWidget = gtk_center_box_set_start_widget;

    extern fn gtk_center_box_get_type() usize;
    pub const getGObjectType = gtk_center_box_get_type;

    extern fn g_object_ref(p_self: *gtk.CenterBox) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CenterBox) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CenterBox, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCenterLayout` is a layout manager that manages up to three children.
///
/// The start widget is allocated at the start of the layout (left in
/// left-to-right locales and right in right-to-left ones), and the end
/// widget at the end.
///
/// The center widget is centered regarding the full width of the layout's.
pub const CenterLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{};
    pub const Class = gtk.CenterLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether to shrink the center widget after other children.
        ///
        /// By default, when there's no space to give all three children their
        /// natural widths, the start and end widgets start shrinking and the
        /// center child keeps natural width until they reach minimum width.
        ///
        /// If set to `FALSE`, start and end widgets keep natural width and the
        /// center widget starts shrinking instead.
        pub const shrink_center_last = struct {
            pub const name = "shrink-center-last";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkCenterLayout`.
    extern fn gtk_center_layout_new() *gtk.CenterLayout;
    pub const new = gtk_center_layout_new;

    /// Returns the baseline position of the layout.
    extern fn gtk_center_layout_get_baseline_position(p_self: *CenterLayout) gtk.BaselinePosition;
    pub const getBaselinePosition = gtk_center_layout_get_baseline_position;

    /// Returns the center widget of the layout.
    extern fn gtk_center_layout_get_center_widget(p_self: *CenterLayout) ?*gtk.Widget;
    pub const getCenterWidget = gtk_center_layout_get_center_widget;

    /// Returns the end widget of the layout.
    extern fn gtk_center_layout_get_end_widget(p_self: *CenterLayout) ?*gtk.Widget;
    pub const getEndWidget = gtk_center_layout_get_end_widget;

    /// Gets the current orienration of the layout manager.
    extern fn gtk_center_layout_get_orientation(p_self: *CenterLayout) gtk.Orientation;
    pub const getOrientation = gtk_center_layout_get_orientation;

    /// Gets whether `self` shrinks the center widget after other children.
    extern fn gtk_center_layout_get_shrink_center_last(p_self: *CenterLayout) c_int;
    pub const getShrinkCenterLast = gtk_center_layout_get_shrink_center_last;

    /// Returns the start widget of the layout.
    extern fn gtk_center_layout_get_start_widget(p_self: *CenterLayout) ?*gtk.Widget;
    pub const getStartWidget = gtk_center_layout_get_start_widget;

    /// Sets the new baseline position of `self`
    extern fn gtk_center_layout_set_baseline_position(p_self: *CenterLayout, p_baseline_position: gtk.BaselinePosition) void;
    pub const setBaselinePosition = gtk_center_layout_set_baseline_position;

    /// Sets the new center widget of `self`.
    ///
    /// To remove the existing center widget, pass `NULL`.
    extern fn gtk_center_layout_set_center_widget(p_self: *CenterLayout, p_widget: ?*gtk.Widget) void;
    pub const setCenterWidget = gtk_center_layout_set_center_widget;

    /// Sets the new end widget of `self`.
    ///
    /// To remove the existing center widget, pass `NULL`.
    extern fn gtk_center_layout_set_end_widget(p_self: *CenterLayout, p_widget: ?*gtk.Widget) void;
    pub const setEndWidget = gtk_center_layout_set_end_widget;

    /// Sets the orientation of `self`.
    extern fn gtk_center_layout_set_orientation(p_self: *CenterLayout, p_orientation: gtk.Orientation) void;
    pub const setOrientation = gtk_center_layout_set_orientation;

    /// Sets whether to shrink the center widget after other children.
    ///
    /// By default, when there's no space to give all three children their
    /// natural widths, the start and end widgets start shrinking and the
    /// center child keeps natural width until they reach minimum width.
    ///
    /// If set to `FALSE`, start and end widgets keep natural width and the
    /// center widget starts shrinking instead.
    extern fn gtk_center_layout_set_shrink_center_last(p_self: *CenterLayout, p_shrink_center_last: c_int) void;
    pub const setShrinkCenterLast = gtk_center_layout_set_shrink_center_last;

    /// Sets the new start widget of `self`.
    ///
    /// To remove the existing start widget, pass `NULL`.
    extern fn gtk_center_layout_set_start_widget(p_self: *CenterLayout, p_widget: ?*gtk.Widget) void;
    pub const setStartWidget = gtk_center_layout_set_start_widget;

    extern fn gtk_center_layout_get_type() usize;
    pub const getGObjectType = gtk_center_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.CenterLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CenterLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CenterLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkCheckButton` places a label next to an indicator.
///
/// ![Example GtkCheckButtons](check-button.png)
///
/// A `GtkCheckButton` is created by calling either `gtk.CheckButton.new`
/// or `gtk.CheckButton.newWithLabel`.
///
/// The state of a `GtkCheckButton` can be set specifically using
/// `gtk.CheckButton.setActive`, and retrieved using
/// `gtk.CheckButton.getActive`.
///
/// # Inconsistent state
///
/// In addition to "on" and "off", check buttons can be an
/// "in between" state that is neither on nor off. This can be used
/// e.g. when the user has selected a range of elements (such as some
/// text or spreadsheet cells) that are affected by a check button,
/// and the current values in that range are inconsistent.
///
/// To set a `GtkCheckButton` to inconsistent state, use
/// `gtk.CheckButton.setInconsistent`.
///
/// # Grouping
///
/// Check buttons can be grouped together, to form mutually exclusive
/// groups - only one of the buttons can be toggled at a time, and toggling
/// another one will switch the currently toggled one off.
///
/// Grouped check buttons use a different indicator, and are commonly referred
/// to as *radio buttons*.
///
/// ![Example GtkCheckButtons](radio-button.png)
///
/// To add a `GtkCheckButton` to a group, use `gtk.CheckButton.setGroup`.
///
/// When the code must keep track of the state of a group of radio buttons, it
/// is recommended to keep track of such state through a stateful
/// `GAction` with a target for each button. Using the `toggled` signals to keep
/// track of the group changes and state is discouraged.
///
/// # Shortcuts and Gestures
///
/// `GtkCheckButton` supports the following keyboard shortcuts:
///
/// - <kbd>␣</kbd> or <kbd>Enter</kbd> activates the button.
///
/// # CSS nodes
///
/// ```
/// checkbutton[.text-button][.grouped]
/// ├── check
/// ╰── [label]
/// ```
///
/// A `GtkCheckButton` has a main node with name checkbutton. If the
/// `gtk.CheckButton.properties.label` or `gtk.CheckButton.properties.child`
/// properties are set, it contains a child widget. The indicator node
/// is named check when no group is set, and radio if the checkbutton
/// is grouped together with other checkbuttons.
///
/// # Accessibility
///
/// `GtkCheckButton` uses the `GTK_ACCESSIBLE_ROLE_CHECKBOX` role.
pub const CheckButton = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Actionable, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.CheckButtonClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        pub const activate = struct {
            pub fn call(p_class: anytype, p_check_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(CheckButton.Class, p_class).f_activate.?(gobject.ext.as(CheckButton, p_check_button));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_check_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(CheckButton.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };

        pub const toggled = struct {
            pub fn call(p_class: anytype, p_check_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(CheckButton.Class, p_class).f_toggled.?(gobject.ext.as(CheckButton, p_check_button));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_check_button: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(CheckButton.Class, p_class).f_toggled = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// If the check button is active.
        ///
        /// Setting `active` to `TRUE` will add the `:checked:` state to both
        /// the check button and the indicator CSS node.
        pub const active = struct {
            pub const name = "active";

            pub const Type = c_int;
        };

        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// The check button whose group this widget belongs to.
        pub const group = struct {
            pub const name = "group";

            pub const Type = ?*gtk.CheckButton;
        };

        /// If the check button is in an “in between” state.
        ///
        /// The inconsistent state only affects visual appearance,
        /// not the semantics of the button.
        pub const inconsistent = struct {
            pub const name = "inconsistent";

            pub const Type = c_int;
        };

        /// Text of the label inside the check button, if it contains a label widget.
        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };

        /// If set, an underline in the text indicates that the following
        /// character is to be used as mnemonic.
        pub const use_underline = struct {
            pub const name = "use-underline";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted to when the check button is activated.
        ///
        /// The `::activate` signal on `GtkCheckButton` is an action signal and
        /// emitting it causes the button to animate press then release.
        ///
        /// Applications should never connect to this signal, but use the
        /// `gtk.CheckButton.signals.toggled` signal.
        ///
        /// The default bindings for this signal are all forms of the
        /// <kbd>␣</kbd> and <kbd>Enter</kbd> keys.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CheckButton, p_instance))),
                    gobject.signalLookup("activate", CheckButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the buttons's `gtk.CheckButton.properties.active`
        /// property changes.
        pub const toggled = struct {
            pub const name = "toggled";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CheckButton, p_instance))),
                    gobject.signalLookup("toggled", CheckButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkCheckButton`.
    extern fn gtk_check_button_new() *gtk.CheckButton;
    pub const new = gtk_check_button_new;

    /// Creates a new `GtkCheckButton` with the given text.
    extern fn gtk_check_button_new_with_label(p_label: ?[*:0]const u8) *gtk.CheckButton;
    pub const newWithLabel = gtk_check_button_new_with_label;

    /// Creates a new `GtkCheckButton` with the given text and a mnemonic.
    extern fn gtk_check_button_new_with_mnemonic(p_label: ?[*:0]const u8) *gtk.CheckButton;
    pub const newWithMnemonic = gtk_check_button_new_with_mnemonic;

    /// Returns whether the check button is active.
    extern fn gtk_check_button_get_active(p_self: *CheckButton) c_int;
    pub const getActive = gtk_check_button_get_active;

    /// Gets the child widget of `button` or `NULL` if `CheckButton.properties.label` is set.
    extern fn gtk_check_button_get_child(p_button: *CheckButton) ?*gtk.Widget;
    pub const getChild = gtk_check_button_get_child;

    /// Returns whether the check button is in an inconsistent state.
    extern fn gtk_check_button_get_inconsistent(p_check_button: *CheckButton) c_int;
    pub const getInconsistent = gtk_check_button_get_inconsistent;

    /// Returns the label of the check button or `NULL` if `CheckButton.properties.child` is set.
    extern fn gtk_check_button_get_label(p_self: *CheckButton) ?[*:0]const u8;
    pub const getLabel = gtk_check_button_get_label;

    /// Returns whether underlines in the label indicate mnemonics.
    extern fn gtk_check_button_get_use_underline(p_self: *CheckButton) c_int;
    pub const getUseUnderline = gtk_check_button_get_use_underline;

    /// Changes the check buttons active state.
    extern fn gtk_check_button_set_active(p_self: *CheckButton, p_setting: c_int) void;
    pub const setActive = gtk_check_button_set_active;

    /// Sets the child widget of `button`.
    ///
    /// Note that by using this API, you take full responsibility for setting
    /// up the proper accessibility label and description information for `button`.
    /// Most likely, you'll either set the accessibility label or description
    /// for `button` explicitly, or you'll set a labelled-by or described-by
    /// relations from `child` to `button`.
    extern fn gtk_check_button_set_child(p_button: *CheckButton, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_check_button_set_child;

    /// Adds `self` to the group of `group`.
    ///
    /// In a group of multiple check buttons, only one button can be active
    /// at a time. The behavior of a checkbutton in a group is also commonly
    /// known as a *radio button*.
    ///
    /// Setting the group of a check button also changes the css name of the
    /// indicator widget's CSS node to 'radio'.
    ///
    /// Setting up groups in a cycle leads to undefined behavior.
    ///
    /// Note that the same effect can be achieved via the `gtk.Actionable`
    /// API, by using the same action with parameter type and state type 's'
    /// for all buttons in the group, and giving each button its own target
    /// value.
    extern fn gtk_check_button_set_group(p_self: *CheckButton, p_group: ?*gtk.CheckButton) void;
    pub const setGroup = gtk_check_button_set_group;

    /// Sets the `GtkCheckButton` to inconsistent state.
    ///
    /// You should turn off the inconsistent state again if the user checks
    /// the check button. This has to be done manually.
    extern fn gtk_check_button_set_inconsistent(p_check_button: *CheckButton, p_inconsistent: c_int) void;
    pub const setInconsistent = gtk_check_button_set_inconsistent;

    /// Sets the text of `self`.
    ///
    /// If `gtk.CheckButton.properties.use_underline` is `TRUE`, an underscore
    /// in `label` is interpreted as mnemonic indicator, see
    /// `gtk.CheckButton.setUseUnderline` for details on this behavior.
    extern fn gtk_check_button_set_label(p_self: *CheckButton, p_label: ?[*:0]const u8) void;
    pub const setLabel = gtk_check_button_set_label;

    /// Sets whether underlines in the label indicate mnemonics.
    ///
    /// If `setting` is `TRUE`, an underscore character in `self`'s label
    /// indicates a mnemonic accelerator key. This behavior is similar
    /// to `gtk.Label.properties.use_underline`.
    extern fn gtk_check_button_set_use_underline(p_self: *CheckButton, p_setting: c_int) void;
    pub const setUseUnderline = gtk_check_button_set_use_underline;

    extern fn gtk_check_button_get_type() usize;
    pub const getGObjectType = gtk_check_button_get_type;

    extern fn g_object_ref(p_self: *gtk.CheckButton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CheckButton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CheckButton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An expression using a custom `GClosure` to compute the value from
/// its parameters.
pub const ClosureExpression = opaque {
    pub const Parent = gtk.Expression;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = ClosureExpression;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a `GtkExpression` that calls `closure` when it is evaluated.
    ///
    /// `closure` is called with the `this` object and the results of evaluating
    /// the `params` expressions.
    extern fn gtk_closure_expression_new(p_value_type: usize, p_closure: *gobject.Closure, p_n_params: c_uint, p_params: ?[*]*gtk.Expression) *gtk.ClosureExpression;
    pub const new = gtk_closure_expression_new;

    extern fn gtk_closure_expression_get_type() usize;
    pub const getGObjectType = gtk_closure_expression_get_type;

    pub fn as(p_instance: *ClosureExpression, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkColorButton` allows to open a color chooser dialog to change
/// the color.
///
/// ![An example GtkColorButton](color-button.png)
///
/// It is suitable widget for selecting a color in a preference dialog.
///
/// # CSS nodes
///
/// ```
/// colorbutton
/// ╰── button.color
///     ╰── [content]
/// ```
///
/// `GtkColorButton` has a single CSS node with name colorbutton which
/// contains a button node. To differentiate it from a plain `GtkButton`,
/// it gets the .color style class.
pub const ColorButton = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ColorChooser, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = ColorButton;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the color chooser dialog should be modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };

        /// Whether the color chooser should open in editor mode.
        ///
        /// This property should be used in cases where the palette
        /// in the editor would be redundant, such as when the color
        /// button is already part of a palette.
        pub const show_editor = struct {
            pub const name = "show-editor";

            pub const Type = c_int;
        };

        /// The title of the color chooser dialog
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// Emitted to when the color button is activated.
        ///
        /// The `::activate` signal on `GtkMenuButton` is an action signal and
        /// emitting it causes the button to pop up its dialog.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ColorButton, p_instance))),
                    gobject.signalLookup("activate", ColorButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user selects a color.
        ///
        /// When handling this signal, use `gtk.ColorChooser.getRgba`
        /// to find out which color was just selected.
        ///
        /// Note that this signal is only emitted when the user changes the color.
        /// If you need to react to programmatic color changes as well, use
        /// the notify::rgba signal.
        pub const color_set = struct {
            pub const name = "color-set";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ColorButton, p_instance))),
                    gobject.signalLookup("color-set", ColorButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new color button.
    ///
    /// This returns a widget in the form of a small button containing
    /// a swatch representing the current selected color. When the button
    /// is clicked, a color chooser dialog will open, allowing the user
    /// to select a color. The swatch will be updated to reflect the new
    /// color when the user finishes.
    extern fn gtk_color_button_new() *gtk.ColorButton;
    pub const new = gtk_color_button_new;

    /// Creates a new color button showing the given color.
    extern fn gtk_color_button_new_with_rgba(p_rgba: *const gdk.RGBA) *gtk.ColorButton;
    pub const newWithRgba = gtk_color_button_new_with_rgba;

    /// Gets whether the dialog is modal.
    extern fn gtk_color_button_get_modal(p_button: *ColorButton) c_int;
    pub const getModal = gtk_color_button_get_modal;

    /// Gets the title of the color chooser dialog.
    extern fn gtk_color_button_get_title(p_button: *ColorButton) [*:0]const u8;
    pub const getTitle = gtk_color_button_get_title;

    /// Sets whether the dialog should be modal.
    extern fn gtk_color_button_set_modal(p_button: *ColorButton, p_modal: c_int) void;
    pub const setModal = gtk_color_button_set_modal;

    /// Sets the title for the color chooser dialog.
    extern fn gtk_color_button_set_title(p_button: *ColorButton, p_title: [*:0]const u8) void;
    pub const setTitle = gtk_color_button_set_title;

    extern fn gtk_color_button_get_type() usize;
    pub const getGObjectType = gtk_color_button_get_type;

    extern fn g_object_ref(p_self: *gtk.ColorButton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColorButton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColorButton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A dialog for choosing a color.
///
/// ![An example GtkColorChooserDialog](colorchooser.png)
///
/// `GtkColorChooserDialog` implements the `gtk.ColorChooser` interface
/// and does not provide much API of its own.
///
/// To create a `GtkColorChooserDialog`, use `gtk.ColorChooserDialog.new`.
///
/// To change the initially selected color, use
/// `gtk.ColorChooser.setRgba`. To get the selected color use
/// `gtk.ColorChooser.getRgba`.
///
/// `GtkColorChooserDialog` has been deprecated in favor of `gtk.ColorDialog`.
///
/// ## CSS nodes
///
/// `GtkColorChooserDialog` has a single CSS node with the name `window` and style
/// class `.colorchooser`.
pub const ColorChooserDialog = opaque {
    pub const Parent = gtk.Dialog;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ColorChooser, gtk.ConstraintTarget, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = opaque {
        pub const Instance = ColorChooserDialog;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the color chooser dialog is showing the single-color editor.
        ///
        /// It can be set to switch the color chooser into single-color editing mode.
        pub const show_editor = struct {
            pub const name = "show-editor";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkColorChooserDialog`.
    extern fn gtk_color_chooser_dialog_new(p_title: ?[*:0]const u8, p_parent: ?*gtk.Window) *gtk.ColorChooserDialog;
    pub const new = gtk_color_chooser_dialog_new;

    extern fn gtk_color_chooser_dialog_get_type() usize;
    pub const getGObjectType = gtk_color_chooser_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.ColorChooserDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColorChooserDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColorChooserDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkColorChooserWidget` widget lets the user select a color.
///
/// By default, the chooser presents a predefined palette of colors,
/// plus a small number of settable custom colors. It is also possible
/// to select a different color with the single-color editor.
///
/// To enter the single-color editing mode, use the context menu of any
/// color of the palette, or use the '+' button to add a new custom color.
///
/// The chooser automatically remembers the last selection, as well
/// as custom colors.
///
/// To create a `GtkColorChooserWidget`, use `gtk.ColorChooserWidget.new`.
///
/// To change the initially selected color, use
/// `gtk.ColorChooser.setRgba`. To get the selected color use
/// `gtk.ColorChooser.getRgba`.
///
/// The `GtkColorChooserWidget` is used in the `gtk.ColorChooserDialog`
/// to provide a dialog for selecting colors.
///
/// # Actions
///
/// `GtkColorChooserWidget` defines a set of built-in actions:
///
/// - `color.customize` activates the color editor for the given color.
/// - `color.select` emits the `gtk.ColorChooser.signals.color_activated` signal
///   for the given color.
///
/// # CSS names
///
/// `GtkColorChooserWidget` has a single CSS node with name colorchooser.
pub const ColorChooserWidget = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ColorChooser, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = ColorChooserWidget;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// `TRUE` when the color chooser is showing the single-color editor.
        ///
        /// It can be set to switch the color chooser into single-color editing mode.
        pub const show_editor = struct {
            pub const name = "show-editor";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkColorChooserWidget`.
    extern fn gtk_color_chooser_widget_new() *gtk.ColorChooserWidget;
    pub const new = gtk_color_chooser_widget_new;

    extern fn gtk_color_chooser_widget_get_type() usize;
    pub const getGObjectType = gtk_color_chooser_widget_get_type;

    extern fn g_object_ref(p_self: *gtk.ColorChooserWidget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColorChooserWidget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColorChooserWidget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkColorDialog` object collects the arguments that
/// are needed to present a color chooser dialog to the
/// user, such as a title for the dialog and whether it
/// should be modal.
///
/// The dialog is shown with the `gtk.ColorDialog.chooseRgba`
/// function.
///
/// See `gtk.ColorDialogButton` for a convenient control
/// that uses `GtkColorDialog` and presents the results.
pub const ColorDialog = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.ColorDialogClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the color chooser dialog is modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };

        /// A title that may be shown on the color chooser
        /// dialog that is presented by `gtk.ColorDialog.chooseRgba`.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        /// Whether colors may have alpha (translucency).
        ///
        /// When with-alpha is `FALSE`, the color that is selected
        /// will be forced to have alpha == 1.
        pub const with_alpha = struct {
            pub const name = "with-alpha";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkColorDialog` object.
    extern fn gtk_color_dialog_new() *gtk.ColorDialog;
    pub const new = gtk_color_dialog_new;

    /// This function initiates a color choice operation by
    /// presenting a color chooser dialog to the user.
    extern fn gtk_color_dialog_choose_rgba(p_self: *ColorDialog, p_parent: ?*gtk.Window, p_initial_color: ?*const gdk.RGBA, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const chooseRgba = gtk_color_dialog_choose_rgba;

    /// Finishes the `gtk.ColorDialog.chooseRgba` call and
    /// returns the resulting color.
    extern fn gtk_color_dialog_choose_rgba_finish(p_self: *ColorDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gdk.RGBA;
    pub const chooseRgbaFinish = gtk_color_dialog_choose_rgba_finish;

    /// Returns whether the color chooser dialog
    /// blocks interaction with the parent window
    /// while it is presented.
    extern fn gtk_color_dialog_get_modal(p_self: *ColorDialog) c_int;
    pub const getModal = gtk_color_dialog_get_modal;

    /// Returns the title that will be shown on the
    /// color chooser dialog.
    extern fn gtk_color_dialog_get_title(p_self: *ColorDialog) [*:0]const u8;
    pub const getTitle = gtk_color_dialog_get_title;

    /// Returns whether colors may have alpha.
    extern fn gtk_color_dialog_get_with_alpha(p_self: *ColorDialog) c_int;
    pub const getWithAlpha = gtk_color_dialog_get_with_alpha;

    /// Sets whether the color chooser dialog
    /// blocks interaction with the parent window
    /// while it is presented.
    extern fn gtk_color_dialog_set_modal(p_self: *ColorDialog, p_modal: c_int) void;
    pub const setModal = gtk_color_dialog_set_modal;

    /// Sets the title that will be shown on the
    /// color chooser dialog.
    extern fn gtk_color_dialog_set_title(p_self: *ColorDialog, p_title: [*:0]const u8) void;
    pub const setTitle = gtk_color_dialog_set_title;

    /// Sets whether colors may have alpha.
    extern fn gtk_color_dialog_set_with_alpha(p_self: *ColorDialog, p_with_alpha: c_int) void;
    pub const setWithAlpha = gtk_color_dialog_set_with_alpha;

    extern fn gtk_color_dialog_get_type() usize;
    pub const getGObjectType = gtk_color_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.ColorDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColorDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColorDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkColorDialogButton` is a wrapped around a `gtk.ColorDialog`
/// and allows to open a color chooser dialog to change the color.
///
/// ![An example GtkColorDialogButton](color-button.png)
///
/// It is suitable widget for selecting a color in a preference dialog.
///
/// # CSS nodes
///
/// ```
/// colorbutton
/// ╰── button.color
///     ╰── [content]
/// ```
///
/// `GtkColorDialogButton` has a single CSS node with name colorbutton which
/// contains a button node. To differentiate it from a plain `GtkButton`,
/// it gets the .color style class.
pub const ColorDialogButton = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.ColorDialogButtonClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GtkColorDialog` that contains parameters for
        /// the color chooser dialog.
        pub const dialog = struct {
            pub const name = "dialog";

            pub const Type = ?*gtk.ColorDialog;
        };

        /// The selected color.
        ///
        /// This property can be set to give the button its initial
        /// color, and it will be updated to reflect the users choice
        /// in the color chooser dialog.
        ///
        /// Listen to `notify::rgba` to get informed about changes
        /// to the buttons color.
        pub const rgba = struct {
            pub const name = "rgba";

            pub const Type = ?*gdk.RGBA;
        };
    };

    pub const signals = struct {
        /// Emitted when the color dialog button is activated.
        ///
        /// The `::activate` signal on `GtkColorDialogButton` is an action signal
        /// and emitting it causes the button to pop up its dialog.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ColorDialogButton, p_instance))),
                    gobject.signalLookup("activate", ColorDialogButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkColorDialogButton` with the
    /// given `GtkColorDialog`.
    ///
    /// You can pass `NULL` to this function and set a `GtkColorDialog`
    /// later. The button will be insensitive until that happens.
    extern fn gtk_color_dialog_button_new(p_dialog: ?*gtk.ColorDialog) *gtk.ColorDialogButton;
    pub const new = gtk_color_dialog_button_new;

    /// Returns the `GtkColorDialog` of `self`.
    extern fn gtk_color_dialog_button_get_dialog(p_self: *ColorDialogButton) ?*gtk.ColorDialog;
    pub const getDialog = gtk_color_dialog_button_get_dialog;

    /// Returns the color of the button.
    ///
    /// This function is what should be used to obtain
    /// the color that was chosen by the user. To get
    /// informed about changes, listen to "notify::rgba".
    extern fn gtk_color_dialog_button_get_rgba(p_self: *ColorDialogButton) *const gdk.RGBA;
    pub const getRgba = gtk_color_dialog_button_get_rgba;

    /// Sets a `GtkColorDialog` object to use for
    /// creating the color chooser dialog that is
    /// presented when the user clicks the button.
    extern fn gtk_color_dialog_button_set_dialog(p_self: *ColorDialogButton, p_dialog: *gtk.ColorDialog) void;
    pub const setDialog = gtk_color_dialog_button_set_dialog;

    /// Sets the color of the button.
    extern fn gtk_color_dialog_button_set_rgba(p_self: *ColorDialogButton, p_color: *const gdk.RGBA) void;
    pub const setRgba = gtk_color_dialog_button_set_rgba;

    extern fn gtk_color_dialog_button_get_type() usize;
    pub const getGObjectType = gtk_color_dialog_button_get_type;

    extern fn g_object_ref(p_self: *gtk.ColorDialogButton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColorDialogButton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColorDialogButton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkColumnView` presents a large dynamic list of items using multiple columns
/// with headers.
///
/// `GtkColumnView` uses the factories of its columns to generate a cell widget for
/// each column, for each visible item and displays them together as the row for
/// this item.
///
/// The `gtk.ColumnView.properties.show_row_separators` and
/// `gtk.ColumnView.properties.show_column_separators` properties offer a simple way
/// to display separators between the rows or columns.
///
/// `GtkColumnView` allows the user to select items according to the selection
/// characteristics of the model. For models that allow multiple selected items,
/// it is possible to turn on *rubberband selection*, using
/// `gtk.ColumnView.properties.enable_rubberband`.
///
/// The column view supports sorting that can be customized by the user by
/// clicking on column headers. To set this up, the `GtkSorter` returned by
/// `gtk.ColumnView.getSorter` must be attached to a sort model for the
/// data that the view is showing, and the columns must have sorters attached to
/// them by calling `gtk.ColumnViewColumn.setSorter`. The initial sort
/// order can be set with `gtk.ColumnView.sortByColumn`.
///
/// The column view also supports interactive resizing and reordering of
/// columns, via Drag-and-Drop of the column headers. This can be enabled or
/// disabled with the `gtk.ColumnView.properties.reorderable` and
/// `gtk.ColumnViewColumn.properties.resizable` properties.
///
/// To learn more about the list widget framework, see the
/// [overview](section-list-widget.html).
///
/// # CSS nodes
///
/// ```
/// columnview[.column-separators][.rich-list][.navigation-sidebar][.data-table]
/// ├── header
/// │   ├── <column header>
/// ┊   ┊
/// │   ╰── <column header>
/// │
/// ├── listview
/// │
/// ┊
/// ╰── [rubberband]
/// ```
///
/// `GtkColumnView` uses a single CSS node named columnview. It may carry the
/// .column-separators style class, when `gtk.ColumnView.properties.show_column_separators`
/// property is set. Header widgets appear below a node with name header.
/// The rows are contained in a `GtkListView` widget, so there is a listview
/// node with the same structure as for a standalone `GtkListView` widget.
/// If `gtk.ColumnView.properties.show_row_separators` is set, it will be passed
/// on to the list view, causing its CSS node to carry the .separators style class.
/// For rubberband selection, a node with name rubberband is used.
///
/// The main columnview node may also carry style classes to select
/// the style of [list presentation](section-list-widget.html`list`-styles):
/// .rich-list, .navigation-sidebar or .data-table.
///
/// # Accessibility
///
/// `GtkColumnView` uses the `GTK_ACCESSIBLE_ROLE_TREE_GRID` role, header title
/// widgets are using the `GTK_ACCESSIBLE_ROLE_COLUMN_HEADER` role. The row widgets
/// are using the `GTK_ACCESSIBLE_ROLE_ROW` role, and individual cells are using
/// the `GTK_ACCESSIBLE_ROLE_GRID_CELL` role
pub const ColumnView = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Scrollable };
    pub const Class = gtk.ColumnViewClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The list of columns.
        pub const columns = struct {
            pub const name = "columns";

            pub const Type = ?*gio.ListModel;
        };

        /// Allow rubberband selection.
        pub const enable_rubberband = struct {
            pub const name = "enable-rubberband";

            pub const Type = c_int;
        };

        /// Factory for creating header widgets.
        ///
        /// The factory must be for configuring `gtk.ListHeader` objects.
        pub const header_factory = struct {
            pub const name = "header-factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// Model for the items displayed.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gtk.SelectionModel;
        };

        /// Whether columns are reorderable.
        pub const reorderable = struct {
            pub const name = "reorderable";

            pub const Type = c_int;
        };

        /// The factory used for configuring rows.
        ///
        /// The factory must be for configuring `gtk.ColumnViewRow` objects.
        pub const row_factory = struct {
            pub const name = "row-factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// Show separators between columns.
        pub const show_column_separators = struct {
            pub const name = "show-column-separators";

            pub const Type = c_int;
        };

        /// Show separators between rows.
        pub const show_row_separators = struct {
            pub const name = "show-row-separators";

            pub const Type = c_int;
        };

        /// Activate rows on single click and select them on hover.
        pub const single_click_activate = struct {
            pub const name = "single-click-activate";

            pub const Type = c_int;
        };

        /// Sorter with the sorting choices of the user.
        pub const sorter = struct {
            pub const name = "sorter";

            pub const Type = ?*gtk.Sorter;
        };

        /// Behavior of the <kbd>Tab</kbd> key
        pub const tab_behavior = struct {
            pub const name = "tab-behavior";

            pub const Type = gtk.ListTabBehavior;
        };
    };

    pub const signals = struct {
        /// Emitted when a row has been activated by the user, usually via activating
        /// the GtkListBase|list.activate-item action.
        ///
        /// This allows for a convenient way to handle activation in a columnview.
        /// See `gtk.ListItem.setActivatable` for details on how to use this
        /// signal.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_position: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ColumnView, p_instance))),
                    gobject.signalLookup("activate", ColumnView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkColumnView`.
    ///
    /// You most likely want to call `gtk.ColumnView.appendColumn`
    /// to add columns next.
    extern fn gtk_column_view_new(p_model: ?*gtk.SelectionModel) *gtk.ColumnView;
    pub const new = gtk_column_view_new;

    /// Appends the `column` to the end of the columns in `self`.
    extern fn gtk_column_view_append_column(p_self: *ColumnView, p_column: *gtk.ColumnViewColumn) void;
    pub const appendColumn = gtk_column_view_append_column;

    /// Gets the list of columns in this column view.
    ///
    /// This list is constant over the lifetime of `self` and can be used to
    /// monitor changes to the columns of `self` by connecting to the
    /// ::items-changed signal.
    extern fn gtk_column_view_get_columns(p_self: *ColumnView) *gio.ListModel;
    pub const getColumns = gtk_column_view_get_columns;

    /// Returns whether rows can be selected by dragging with the mouse.
    extern fn gtk_column_view_get_enable_rubberband(p_self: *ColumnView) c_int;
    pub const getEnableRubberband = gtk_column_view_get_enable_rubberband;

    /// Gets the factory that's currently used to populate section headers.
    extern fn gtk_column_view_get_header_factory(p_self: *ColumnView) ?*gtk.ListItemFactory;
    pub const getHeaderFactory = gtk_column_view_get_header_factory;

    /// Gets the model that's currently used to read the items displayed.
    extern fn gtk_column_view_get_model(p_self: *ColumnView) ?*gtk.SelectionModel;
    pub const getModel = gtk_column_view_get_model;

    /// Returns whether columns are reorderable.
    extern fn gtk_column_view_get_reorderable(p_self: *ColumnView) c_int;
    pub const getReorderable = gtk_column_view_get_reorderable;

    /// Gets the factory set via `gtk.ColumnView.setRowFactory`.
    extern fn gtk_column_view_get_row_factory(p_self: *ColumnView) ?*gtk.ListItemFactory;
    pub const getRowFactory = gtk_column_view_get_row_factory;

    /// Returns whether the list should show separators
    /// between columns.
    extern fn gtk_column_view_get_show_column_separators(p_self: *ColumnView) c_int;
    pub const getShowColumnSeparators = gtk_column_view_get_show_column_separators;

    /// Returns whether the list should show separators
    /// between rows.
    extern fn gtk_column_view_get_show_row_separators(p_self: *ColumnView) c_int;
    pub const getShowRowSeparators = gtk_column_view_get_show_row_separators;

    /// Returns whether rows will be activated on single click and
    /// selected on hover.
    extern fn gtk_column_view_get_single_click_activate(p_self: *ColumnView) c_int;
    pub const getSingleClickActivate = gtk_column_view_get_single_click_activate;

    /// Returns a special sorter that reflects the users sorting
    /// choices in the column view.
    ///
    /// To allow users to customizable sorting by clicking on column
    /// headers, this sorter needs to be set on the sort model underneath
    /// the model that is displayed by the view.
    ///
    /// See `gtk.ColumnViewColumn.setSorter` for setting up
    /// per-column sorting.
    ///
    /// Here is an example:
    /// ```c
    /// gtk_column_view_column_set_sorter (column, sorter);
    /// gtk_column_view_append_column (view, column);
    /// sorter = g_object_ref (gtk_column_view_get_sorter (view)));
    /// model = gtk_sort_list_model_new (store, sorter);
    /// selection = gtk_no_selection_new (model);
    /// gtk_column_view_set_model (view, selection);
    /// ```
    extern fn gtk_column_view_get_sorter(p_self: *ColumnView) ?*gtk.Sorter;
    pub const getSorter = gtk_column_view_get_sorter;

    /// Gets the behavior set for the <kbd>Tab</kbd> key.
    extern fn gtk_column_view_get_tab_behavior(p_self: *ColumnView) gtk.ListTabBehavior;
    pub const getTabBehavior = gtk_column_view_get_tab_behavior;

    /// Inserts a column at the given position in the columns of `self`.
    ///
    /// If `column` is already a column of `self`, it will be repositioned.
    extern fn gtk_column_view_insert_column(p_self: *ColumnView, p_position: c_uint, p_column: *gtk.ColumnViewColumn) void;
    pub const insertColumn = gtk_column_view_insert_column;

    /// Removes the `column` from the list of columns of `self`.
    extern fn gtk_column_view_remove_column(p_self: *ColumnView, p_column: *gtk.ColumnViewColumn) void;
    pub const removeColumn = gtk_column_view_remove_column;

    /// Scroll to the row at the given position - or cell if a column is
    /// given - and performs the actions specified in `flags`.
    ///
    /// This function works no matter if the listview is shown or focused.
    /// If it isn't, then the changes will take effect once that happens.
    extern fn gtk_column_view_scroll_to(p_self: *ColumnView, p_pos: c_uint, p_column: ?*gtk.ColumnViewColumn, p_flags: gtk.ListScrollFlags, p_scroll: ?*gtk.ScrollInfo) void;
    pub const scrollTo = gtk_column_view_scroll_to;

    /// Sets whether selections can be changed by dragging with the mouse.
    extern fn gtk_column_view_set_enable_rubberband(p_self: *ColumnView, p_enable_rubberband: c_int) void;
    pub const setEnableRubberband = gtk_column_view_set_enable_rubberband;

    /// Sets the `GtkListItemFactory` to use for populating the
    /// `gtk.ListHeader` objects used in section headers.
    ///
    /// If this factory is set to `NULL`, the list will not show
    /// section headers.
    extern fn gtk_column_view_set_header_factory(p_self: *ColumnView, p_factory: ?*gtk.ListItemFactory) void;
    pub const setHeaderFactory = gtk_column_view_set_header_factory;

    /// Sets the model to use.
    ///
    /// This must be a `gtk.SelectionModel`.
    extern fn gtk_column_view_set_model(p_self: *ColumnView, p_model: ?*gtk.SelectionModel) void;
    pub const setModel = gtk_column_view_set_model;

    /// Sets whether columns should be reorderable by dragging.
    extern fn gtk_column_view_set_reorderable(p_self: *ColumnView, p_reorderable: c_int) void;
    pub const setReorderable = gtk_column_view_set_reorderable;

    /// Sets the factory used for configuring rows. The factory must be for configuring
    /// `gtk.ColumnViewRow` objects.
    ///
    /// If this factory is not set - which is the default - then the defaults will be used.
    ///
    /// This factory is not used to set the widgets displayed in the individual cells. For
    /// that see `GtkColumnViewColumn.setFactory` and `GtkColumnViewCell`.
    extern fn gtk_column_view_set_row_factory(p_self: *ColumnView, p_factory: ?*gtk.ListItemFactory) void;
    pub const setRowFactory = gtk_column_view_set_row_factory;

    /// Sets whether the list should show separators
    /// between columns.
    extern fn gtk_column_view_set_show_column_separators(p_self: *ColumnView, p_show_column_separators: c_int) void;
    pub const setShowColumnSeparators = gtk_column_view_set_show_column_separators;

    /// Sets whether the list should show separators
    /// between rows.
    extern fn gtk_column_view_set_show_row_separators(p_self: *ColumnView, p_show_row_separators: c_int) void;
    pub const setShowRowSeparators = gtk_column_view_set_show_row_separators;

    /// Sets whether rows should be activated on single click and
    /// selected on hover.
    extern fn gtk_column_view_set_single_click_activate(p_self: *ColumnView, p_single_click_activate: c_int) void;
    pub const setSingleClickActivate = gtk_column_view_set_single_click_activate;

    /// Sets the behavior of the <kbd>Tab</kbd> and <kbd>Shift</kbd>+<kbd>Tab</kbd> keys.
    extern fn gtk_column_view_set_tab_behavior(p_self: *ColumnView, p_tab_behavior: gtk.ListTabBehavior) void;
    pub const setTabBehavior = gtk_column_view_set_tab_behavior;

    /// Sets the sorting of the view.
    ///
    /// This function should be used to set up the initial sorting.
    /// At runtime, users can change the sorting of a column view
    /// by clicking on the list headers.
    ///
    /// This call only has an effect if the sorter returned by
    /// `gtk.ColumnView.getSorter` is set on a sort model,
    /// and `gtk.ColumnViewColumn.setSorter` has been called
    /// on `column` to associate a sorter with the column.
    ///
    /// If `column` is `NULL`, the view will be unsorted.
    extern fn gtk_column_view_sort_by_column(p_self: *ColumnView, p_column: ?*gtk.ColumnViewColumn, p_direction: gtk.SortType) void;
    pub const sortByColumn = gtk_column_view_sort_by_column;

    extern fn gtk_column_view_get_type() usize;
    pub const getGObjectType = gtk_column_view_get_type;

    extern fn g_object_ref(p_self: *gtk.ColumnView) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColumnView) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColumnView, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkColumnViewCell` is used by `gtk.ColumnViewColumn` to represent items
/// in a cell in `gtk.ColumnView`.
///
/// The `GtkColumnViewCell`s are managed by the columnview widget (with its factory)
/// and cannot be created by applications, but they need to be populated
/// by application code. This is done by calling `gtk.ColumnViewCell.setChild`.
///
/// `GtkColumnViewCell`s exist in 2 stages:
///
/// 1. The unbound stage where the listitem is not currently connected to
///    an item in the list. In that case, the `gtk.ColumnViewCell.properties.item`
///    property is set to `NULL`.
///
/// 2. The bound stage where the listitem references an item from the list.
///    The `gtk.ColumnViewCell.properties.item` property is not `NULL`.
pub const ColumnViewCell = opaque {
    pub const Parent = gtk.ListItem;
    pub const Implements = [_]type{};
    pub const Class = gtk.ColumnViewCellClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Widget used for display.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// If the item can be focused with the keyboard.
        pub const focusable = struct {
            pub const name = "focusable";

            pub const Type = c_int;
        };

        /// Displayed item.
        pub const item = struct {
            pub const name = "item";

            pub const Type = ?*gobject.Object;
        };

        /// Position of the item.
        pub const position = struct {
            pub const name = "position";

            pub const Type = c_uint;
        };

        /// If the item is currently selected.
        pub const selected = struct {
            pub const name = "selected";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Gets the child previously set via `gtk.ColumnViewCell.setChild` or
    /// `NULL` if none was set.
    extern fn gtk_column_view_cell_get_child(p_self: *ColumnViewCell) ?*gtk.Widget;
    pub const getChild = gtk_column_view_cell_get_child;

    /// Checks if a list item has been set to be focusable via
    /// `gtk.ColumnViewCell.setFocusable`.
    extern fn gtk_column_view_cell_get_focusable(p_self: *ColumnViewCell) c_int;
    pub const getFocusable = gtk_column_view_cell_get_focusable;

    /// Gets the model item that associated with `self`.
    ///
    /// If `self` is unbound, this function returns `NULL`.
    extern fn gtk_column_view_cell_get_item(p_self: *ColumnViewCell) ?*gobject.Object;
    pub const getItem = gtk_column_view_cell_get_item;

    /// Gets the position in the model that `self` currently displays.
    ///
    /// If `self` is unbound, `GTK_INVALID_LIST_POSITION` is returned.
    extern fn gtk_column_view_cell_get_position(p_self: *ColumnViewCell) c_uint;
    pub const getPosition = gtk_column_view_cell_get_position;

    /// Checks if the item is displayed as selected.
    ///
    /// The selected state is maintained by the list widget and its model
    /// and cannot be set otherwise.
    extern fn gtk_column_view_cell_get_selected(p_self: *ColumnViewCell) c_int;
    pub const getSelected = gtk_column_view_cell_get_selected;

    /// Sets the child to be used for this listitem.
    ///
    /// This function is typically called by applications when
    /// setting up a listitem so that the widget can be reused when
    /// binding it multiple times.
    extern fn gtk_column_view_cell_set_child(p_self: *ColumnViewCell, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_column_view_cell_set_child;

    /// Sets `self` to be focusable.
    ///
    /// If an item is focusable, it can be focused using the keyboard.
    /// This works similar to `gtk.Widget.setFocusable`.
    ///
    /// Note that if items are not focusable, the keyboard cannot be used to activate
    /// them and selecting only works if one of the listitem's children is focusable.
    ///
    /// By default, list items are focusable.
    extern fn gtk_column_view_cell_set_focusable(p_self: *ColumnViewCell, p_focusable: c_int) void;
    pub const setFocusable = gtk_column_view_cell_set_focusable;

    extern fn gtk_column_view_cell_get_type() usize;
    pub const getGObjectType = gtk_column_view_cell_get_type;

    extern fn g_object_ref(p_self: *gtk.ColumnViewCell) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColumnViewCell) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColumnViewCell, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkColumnViewColumn` represents the columns being added to a `GtkColumnView`.
///
/// The main ingredient for a `GtkColumnViewColumn` is the `GtkListItemFactory`
/// that tells the columnview how to create cells for this column from items in
/// the model.
///
/// Columns have a title, and can optionally have a header menu set
/// with `gtk.ColumnViewColumn.setHeaderMenu`.
///
/// A sorter can be associated with a column using
/// `gtk.ColumnViewColumn.setSorter`, to let users influence sorting
/// by clicking on the column header.
pub const ColumnViewColumn = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.ColumnViewColumnClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GtkColumnView` this column is a part of.
        pub const column_view = struct {
            pub const name = "column-view";

            pub const Type = ?*gtk.ColumnView;
        };

        /// Column gets share of extra width allocated to the view.
        pub const expand = struct {
            pub const name = "expand";

            pub const Type = c_int;
        };

        /// Factory for populating list items.
        ///
        /// The factory must be for configuring `gtk.ColumnViewCell` objects.
        pub const factory = struct {
            pub const name = "factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// If not -1, this is the width that the column is allocated,
        /// regardless of the size of its content.
        pub const fixed_width = struct {
            pub const name = "fixed-width";

            pub const Type = c_int;
        };

        /// Menu model used to create the context menu for the column header.
        pub const header_menu = struct {
            pub const name = "header-menu";

            pub const Type = ?*gio.MenuModel;
        };

        /// An ID for the column.
        ///
        /// GTK is not currently using the ID for anything, but
        /// it can be used by applications when saving column view
        /// configurations.
        ///
        /// It is up to applications to ensure uniqueness of IDs.
        pub const id = struct {
            pub const name = "id";

            pub const Type = ?[*:0]u8;
        };

        /// Whether this column is resizable.
        pub const resizable = struct {
            pub const name = "resizable";

            pub const Type = c_int;
        };

        /// Sorter for sorting items according to this column.
        pub const sorter = struct {
            pub const name = "sorter";

            pub const Type = ?*gtk.Sorter;
        };

        /// Title displayed in the header.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        /// Whether this column is visible.
        pub const visible = struct {
            pub const name = "visible";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkColumnViewColumn` that uses the given `factory` for
    /// mapping items to widgets.
    ///
    /// You most likely want to call `gtk.ColumnView.appendColumn` next.
    ///
    /// The function takes ownership of the argument, so you can write code like:
    ///
    /// ```c
    /// column = gtk_column_view_column_new (_("Name"),
    ///   gtk_builder_list_item_factory_new_from_resource ("/name.ui"));
    /// ```
    extern fn gtk_column_view_column_new(p_title: ?[*:0]const u8, p_factory: ?*gtk.ListItemFactory) *gtk.ColumnViewColumn;
    pub const new = gtk_column_view_column_new;

    /// Gets the column view that's currently displaying this column.
    ///
    /// If `self` has not been added to a column view yet, `NULL` is returned.
    extern fn gtk_column_view_column_get_column_view(p_self: *ColumnViewColumn) ?*gtk.ColumnView;
    pub const getColumnView = gtk_column_view_column_get_column_view;

    /// Returns whether this column should expand.
    extern fn gtk_column_view_column_get_expand(p_self: *ColumnViewColumn) c_int;
    pub const getExpand = gtk_column_view_column_get_expand;

    /// Gets the factory that's currently used to populate list items for
    /// this column.
    extern fn gtk_column_view_column_get_factory(p_self: *ColumnViewColumn) ?*gtk.ListItemFactory;
    pub const getFactory = gtk_column_view_column_get_factory;

    /// Gets the fixed width of the column.
    extern fn gtk_column_view_column_get_fixed_width(p_self: *ColumnViewColumn) c_int;
    pub const getFixedWidth = gtk_column_view_column_get_fixed_width;

    /// Gets the menu model that is used to create the context menu
    /// for the column header.
    extern fn gtk_column_view_column_get_header_menu(p_self: *ColumnViewColumn) ?*gio.MenuModel;
    pub const getHeaderMenu = gtk_column_view_column_get_header_menu;

    /// Returns the ID set with `gtk.ColumnViewColumn.setId`.
    extern fn gtk_column_view_column_get_id(p_self: *ColumnViewColumn) ?[*:0]const u8;
    pub const getId = gtk_column_view_column_get_id;

    /// Returns whether this column is resizable.
    extern fn gtk_column_view_column_get_resizable(p_self: *ColumnViewColumn) c_int;
    pub const getResizable = gtk_column_view_column_get_resizable;

    /// Returns the sorter that is associated with the column.
    extern fn gtk_column_view_column_get_sorter(p_self: *ColumnViewColumn) ?*gtk.Sorter;
    pub const getSorter = gtk_column_view_column_get_sorter;

    /// Returns the title set with `gtk.ColumnViewColumn.setTitle`.
    extern fn gtk_column_view_column_get_title(p_self: *ColumnViewColumn) ?[*:0]const u8;
    pub const getTitle = gtk_column_view_column_get_title;

    /// Returns whether this column is visible.
    extern fn gtk_column_view_column_get_visible(p_self: *ColumnViewColumn) c_int;
    pub const getVisible = gtk_column_view_column_get_visible;

    /// Sets the column to take available extra space.
    ///
    /// The extra space is shared equally amongst all columns that
    /// have the expand set to `TRUE`.
    extern fn gtk_column_view_column_set_expand(p_self: *ColumnViewColumn, p_expand: c_int) void;
    pub const setExpand = gtk_column_view_column_set_expand;

    /// Sets the `GtkListItemFactory` to use for populating list items for this
    /// column.
    extern fn gtk_column_view_column_set_factory(p_self: *ColumnViewColumn, p_factory: ?*gtk.ListItemFactory) void;
    pub const setFactory = gtk_column_view_column_set_factory;

    /// If `fixed_width` is not -1, sets the fixed width of `column`;
    /// otherwise unsets it.
    ///
    /// Setting a fixed width overrides the automatically calculated
    /// width. Interactive resizing also sets the “fixed-width” property.
    extern fn gtk_column_view_column_set_fixed_width(p_self: *ColumnViewColumn, p_fixed_width: c_int) void;
    pub const setFixedWidth = gtk_column_view_column_set_fixed_width;

    /// Sets the menu model that is used to create the context menu
    /// for the column header.
    extern fn gtk_column_view_column_set_header_menu(p_self: *ColumnViewColumn, p_menu: ?*gio.MenuModel) void;
    pub const setHeaderMenu = gtk_column_view_column_set_header_menu;

    /// Sets the id of this column.
    ///
    /// GTK makes no use of this, but applications can use it when
    /// storing column view configuration.
    ///
    /// It is up to callers to ensure uniqueness of IDs.
    extern fn gtk_column_view_column_set_id(p_self: *ColumnViewColumn, p_id: ?[*:0]const u8) void;
    pub const setId = gtk_column_view_column_set_id;

    /// Sets whether this column should be resizable by dragging.
    extern fn gtk_column_view_column_set_resizable(p_self: *ColumnViewColumn, p_resizable: c_int) void;
    pub const setResizable = gtk_column_view_column_set_resizable;

    /// Associates a sorter with the column.
    ///
    /// If `sorter` is `NULL`, the column will not let users change
    /// the sorting by clicking on its header.
    ///
    /// This sorter can be made active by clicking on the column
    /// header, or by calling `gtk.ColumnView.sortByColumn`.
    ///
    /// See `gtk.ColumnView.getSorter` for the necessary steps
    /// for setting up customizable sorting for `gtk.ColumnView`.
    extern fn gtk_column_view_column_set_sorter(p_self: *ColumnViewColumn, p_sorter: ?*gtk.Sorter) void;
    pub const setSorter = gtk_column_view_column_set_sorter;

    /// Sets the title of this column.
    ///
    /// The title is displayed in the header of a `GtkColumnView`
    /// for this column and is therefore user-facing text that should
    /// be translated.
    extern fn gtk_column_view_column_set_title(p_self: *ColumnViewColumn, p_title: ?[*:0]const u8) void;
    pub const setTitle = gtk_column_view_column_set_title;

    /// Sets whether this column should be visible in views.
    extern fn gtk_column_view_column_set_visible(p_self: *ColumnViewColumn, p_visible: c_int) void;
    pub const setVisible = gtk_column_view_column_set_visible;

    extern fn gtk_column_view_column_get_type() usize;
    pub const getGObjectType = gtk_column_view_column_get_type;

    extern fn g_object_ref(p_self: *gtk.ColumnViewColumn) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColumnViewColumn) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColumnViewColumn, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkColumnViewRow` is used by `gtk.ColumnView` to allow configuring
/// how rows are displayed.
///
/// It is not used to set the widgets displayed in the individual cells. For that
/// see `GtkColumnViewColumn.setFactory` and `GtkColumnViewCell`.
pub const ColumnViewRow = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.ColumnViewRowClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The accessible description to set on the row.
        pub const accessible_description = struct {
            pub const name = "accessible-description";

            pub const Type = ?[*:0]u8;
        };

        /// The accessible label to set on the row.
        pub const accessible_label = struct {
            pub const name = "accessible-label";

            pub const Type = ?[*:0]u8;
        };

        /// If the row can be activated by the user.
        pub const activatable = struct {
            pub const name = "activatable";

            pub const Type = c_int;
        };

        /// If the row can be focused with the keyboard.
        pub const focusable = struct {
            pub const name = "focusable";

            pub const Type = c_int;
        };

        /// The item for this row.
        pub const item = struct {
            pub const name = "item";

            pub const Type = ?*gobject.Object;
        };

        /// Position of the row.
        pub const position = struct {
            pub const name = "position";

            pub const Type = c_uint;
        };

        /// If the row can be selected by the user.
        pub const selectable = struct {
            pub const name = "selectable";

            pub const Type = c_int;
        };

        /// If the item in the row is currently selected.
        pub const selected = struct {
            pub const name = "selected";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Gets the accessible description of `self`.
    extern fn gtk_column_view_row_get_accessible_description(p_self: *ColumnViewRow) [*:0]const u8;
    pub const getAccessibleDescription = gtk_column_view_row_get_accessible_description;

    /// Gets the accessible label of `self`.
    extern fn gtk_column_view_row_get_accessible_label(p_self: *ColumnViewRow) [*:0]const u8;
    pub const getAccessibleLabel = gtk_column_view_row_get_accessible_label;

    /// Checks if the row has been set to be activatable via
    /// `gtk.ColumnViewRow.setActivatable`.
    extern fn gtk_column_view_row_get_activatable(p_self: *ColumnViewRow) c_int;
    pub const getActivatable = gtk_column_view_row_get_activatable;

    /// Checks if a row item has been set to be focusable via
    /// `gtk.ColumnViewRow.setFocusable`.
    extern fn gtk_column_view_row_get_focusable(p_self: *ColumnViewRow) c_int;
    pub const getFocusable = gtk_column_view_row_get_focusable;

    /// Gets the model item that associated with `self`.
    ///
    /// If `self` is unbound, this function returns `NULL`.
    extern fn gtk_column_view_row_get_item(p_self: *ColumnViewRow) ?*gobject.Object;
    pub const getItem = gtk_column_view_row_get_item;

    /// Gets the position in the model that `self` currently displays.
    ///
    /// If `self` is unbound, `GTK_INVALID_LIST_POSITION` is returned.
    extern fn gtk_column_view_row_get_position(p_self: *ColumnViewRow) c_uint;
    pub const getPosition = gtk_column_view_row_get_position;

    /// Checks if the row has been set to be selectable via
    /// `gtk.ColumnViewRow.setSelectable`.
    ///
    /// Do not confuse this function with `gtk.ColumnViewRow.getSelected`.
    extern fn gtk_column_view_row_get_selectable(p_self: *ColumnViewRow) c_int;
    pub const getSelectable = gtk_column_view_row_get_selectable;

    /// Checks if the item is selected that this row corresponds to.
    ///
    /// The selected state is maintained by the list widget and its model
    /// and cannot be set otherwise.
    extern fn gtk_column_view_row_get_selected(p_self: *ColumnViewRow) c_int;
    pub const getSelected = gtk_column_view_row_get_selected;

    /// Sets the accessible description for the row,
    /// which may be used by e.g. screen readers.
    extern fn gtk_column_view_row_set_accessible_description(p_self: *ColumnViewRow, p_description: [*:0]const u8) void;
    pub const setAccessibleDescription = gtk_column_view_row_set_accessible_description;

    /// Sets the accessible label for the row,
    /// which may be used by e.g. screen readers.
    extern fn gtk_column_view_row_set_accessible_label(p_self: *ColumnViewRow, p_label: [*:0]const u8) void;
    pub const setAccessibleLabel = gtk_column_view_row_set_accessible_label;

    /// Sets `self` to be activatable.
    ///
    /// If a row is activatable, double-clicking on the row, using
    /// the Return key or calling `gtk.Widget.activate` will activate
    /// the row. Activating instructs the containing columnview to
    /// emit the `gtk.ColumnView.signals.activate` signal.
    ///
    /// By default, row are activatable.
    extern fn gtk_column_view_row_set_activatable(p_self: *ColumnViewRow, p_activatable: c_int) void;
    pub const setActivatable = gtk_column_view_row_set_activatable;

    /// Sets `self` to be focusable.
    ///
    /// If a row is focusable, it can be focused using the keyboard.
    /// This works similar to `gtk.Widget.setFocusable`.
    ///
    /// Note that if row are not focusable, the contents of cells can still be focused if
    /// they are focusable.
    ///
    /// By default, rows are focusable.
    extern fn gtk_column_view_row_set_focusable(p_self: *ColumnViewRow, p_focusable: c_int) void;
    pub const setFocusable = gtk_column_view_row_set_focusable;

    /// Sets `self` to be selectable.
    ///
    /// If a row is selectable, clicking on the row or using the keyboard
    /// will try to select or unselect the row. Whether this succeeds is up to
    /// the model to determine, as it is managing the selected state.
    ///
    /// Note that this means that making a row non-selectable has no
    /// influence on the selected state at all. A non-selectable row
    /// may still be selected.
    ///
    /// By default, rows are selectable.
    extern fn gtk_column_view_row_set_selectable(p_self: *ColumnViewRow, p_selectable: c_int) void;
    pub const setSelectable = gtk_column_view_row_set_selectable;

    extern fn gtk_column_view_row_get_type() usize;
    pub const getGObjectType = gtk_column_view_row_get_type;

    extern fn g_object_ref(p_self: *gtk.ColumnViewRow) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColumnViewRow) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColumnViewRow, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkColumnViewSorter` is a sorter implementation that
/// is geared towards the needs of `GtkColumnView`.
///
/// The sorter returned by `gtk.ColumnView.getSorter` is
/// a `GtkColumnViewSorter`.
///
/// In column views, sorting can be configured by associating
/// sorters with columns, and users can invert sort order by clicking
/// on column headers. The API of `GtkColumnViewSorter` is designed
/// to allow saving and restoring this configuration.
///
/// If you are only interested in the primary sort column (i.e. the
/// column where a sort indicator is shown in the header), then
/// you can just look at `gtk.ColumnViewSorter.properties.primary_sort_column`
/// and `gtk.ColumnViewSorter.properties.primary_sort_order`.
///
/// If you want to store the full sort configuration, including
/// secondary sort columns that are used for tie breaking, then
/// you can use `gtk.ColumnViewSorter.getNthSortColumn`.
/// To get notified about changes, use `gtk.Sorter.signals.changed`.
///
/// To restore a saved sort configuration on a `GtkColumnView`,
/// use code like:
///
/// ```
/// sorter = gtk_column_view_get_sorter (view);
/// for (i = gtk_column_view_sorter_get_n_sort_columns (sorter) - 1; i >= 0; i--)
///   {
///     column = gtk_column_view_sorter_get_nth_sort_column (sorter, i, &order);
///     gtk_column_view_sort_by_column (view, column, order);
///   }
/// ```
pub const ColumnViewSorter = opaque {
    pub const Parent = gtk.Sorter;
    pub const Implements = [_]type{};
    pub const Class = gtk.ColumnViewSorterClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The primary sort column.
        ///
        /// The primary sort column is the one that displays the triangle
        /// in a column view header.
        pub const primary_sort_column = struct {
            pub const name = "primary-sort-column";

            pub const Type = ?*gtk.ColumnViewColumn;
        };

        /// The primary sort order.
        ///
        /// The primary sort order determines whether the triangle displayed
        /// in the column view header of the primary sort column points upwards
        /// or downwards.
        pub const primary_sort_order = struct {
            pub const name = "primary-sort-order";

            pub const Type = gtk.SortType;
        };
    };

    pub const signals = struct {};

    /// Returns the number of columns by which the sorter sorts.
    ///
    /// If the sorter of the primary sort column does not determine
    /// a total order, then the secondary sorters are consulted to
    /// break the ties.
    ///
    /// Use the `gtk.Sorter.signals.changed` signal to get notified
    /// when the number of sort columns changes.
    extern fn gtk_column_view_sorter_get_n_sort_columns(p_self: *ColumnViewSorter) c_uint;
    pub const getNSortColumns = gtk_column_view_sorter_get_n_sort_columns;

    /// Gets the `position`'th sort column and its associated sort order.
    ///
    /// Use the `gtk.Sorter.signals.changed` signal to get notified
    /// when sort columns change.
    extern fn gtk_column_view_sorter_get_nth_sort_column(p_self: *ColumnViewSorter, p_position: c_uint, p_sort_order: *gtk.SortType) ?*gtk.ColumnViewColumn;
    pub const getNthSortColumn = gtk_column_view_sorter_get_nth_sort_column;

    /// Returns the primary sort column.
    ///
    /// The primary sort column is the one that displays the triangle
    /// in a column view header.
    extern fn gtk_column_view_sorter_get_primary_sort_column(p_self: *ColumnViewSorter) ?*gtk.ColumnViewColumn;
    pub const getPrimarySortColumn = gtk_column_view_sorter_get_primary_sort_column;

    /// Returns the primary sort order.
    ///
    /// The primary sort order determines whether the triangle displayed
    /// in the column view header of the primary sort column points upwards
    /// or downwards.
    ///
    /// If there is no primary sort column, then this function returns
    /// `GTK_SORT_ASCENDING`.
    extern fn gtk_column_view_sorter_get_primary_sort_order(p_self: *ColumnViewSorter) gtk.SortType;
    pub const getPrimarySortOrder = gtk_column_view_sorter_get_primary_sort_order;

    extern fn gtk_column_view_sorter_get_type() usize;
    pub const getGObjectType = gtk_column_view_sorter_get_type;

    extern fn g_object_ref(p_self: *gtk.ColumnViewSorter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ColumnViewSorter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColumnViewSorter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkComboBox` is a widget that allows the user to choose from a list of
/// valid choices.
///
/// ![An example GtkComboBox](combo-box.png)
///
/// The `GtkComboBox` displays the selected choice; when activated, the
/// `GtkComboBox` displays a popup which allows the user to make a new choice.
///
/// The `GtkComboBox` uses the model-view pattern; the list of valid choices
/// is specified in the form of a tree model, and the display of the choices
/// can be adapted to the data in the model by using cell renderers, as you
/// would in a tree view. This is possible since `GtkComboBox` implements the
/// `gtk.CellLayout` interface. The tree model holding the valid
/// choices is not restricted to a flat list, it can be a real tree, and the
/// popup will reflect the tree structure.
///
/// To allow the user to enter values not in the model, the
/// `gtk.ComboBox.properties.has_entry` property allows the `GtkComboBox` to
/// contain a `gtk.Entry`. This entry can be accessed by calling
/// `gtk.ComboBox.getChild` on the combo box.
///
/// For a simple list of textual choices, the model-view API of `GtkComboBox`
/// can be a bit overwhelming. In this case, `gtk.ComboBoxText` offers
/// a simple alternative. Both `GtkComboBox` and `GtkComboBoxText` can contain
/// an entry.
///
/// ## CSS nodes
///
/// ```
/// combobox
/// ├── box.linked
/// │   ╰── button.combo
/// │       ╰── box
/// │           ├── cellview
/// │           ╰── arrow
/// ╰── window.popup
/// ```
///
/// A normal combobox contains a box with the .linked class, a button
/// with the .combo class and inside those buttons, there are a cellview and
/// an arrow.
///
/// ```
/// combobox
/// ├── box.linked
/// │   ├── entry.combo
/// │   ╰── button.combo
/// │       ╰── box
/// │           ╰── arrow
/// ╰── window.popup
/// ```
///
/// A `GtkComboBox` with an entry has a single CSS node with name combobox.
/// It contains a box with the .linked class. That box contains an entry and
/// a button, both with the .combo class added. The button also contains another
/// node with name arrow.
///
/// ## Accessibility
///
/// `GtkComboBox` uses the `GTK_ACCESSIBLE_ROLE_COMBO_BOX` role.
pub const ComboBox = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.CellEditable, gtk.CellLayout, gtk.ConstraintTarget };
    pub const Class = gtk.ComboBoxClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        pub const activate = struct {
            pub fn call(p_class: anytype, p_combo_box: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(ComboBox.Class, p_class).f_activate.?(gobject.ext.as(ComboBox, p_combo_box));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_combo_box: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(ComboBox.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };

        /// Signal is emitted when the active item is changed.
        pub const changed = struct {
            pub fn call(p_class: anytype, p_combo_box: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(ComboBox.Class, p_class).f_changed.?(gobject.ext.as(ComboBox, p_combo_box));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_combo_box: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(ComboBox.Class, p_class).f_changed = @ptrCast(p_implementation);
            }
        };

        /// Signal which allows you to change how the text
        ///    displayed in a combo box’s entry is displayed.
        pub const format_entry_text = struct {
            pub fn call(p_class: anytype, p_combo_box: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_path: [*:0]const u8) [*:0]u8 {
                return gobject.ext.as(ComboBox.Class, p_class).f_format_entry_text.?(gobject.ext.as(ComboBox, p_combo_box), p_path);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_combo_box: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_path: [*:0]const u8) callconv(.C) [*:0]u8) void {
                gobject.ext.as(ComboBox.Class, p_class).f_format_entry_text = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The item which is currently active.
        ///
        /// If the model is a non-flat treemodel, and the active item is not an
        /// immediate child of the root of the tree, this property has the value
        /// `gtk_tree_path_get_indices (path)[0]`, where `path` is the
        /// `gtk.TreePath` of the active item.
        pub const active = struct {
            pub const name = "active";

            pub const Type = c_int;
        };

        /// The value of the ID column of the active row.
        pub const active_id = struct {
            pub const name = "active-id";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the dropdown button is sensitive when
        /// the model is empty.
        pub const button_sensitivity = struct {
            pub const name = "button-sensitivity";

            pub const Type = gtk.SensitivityType;
        };

        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// The model column to associate with strings from the entry.
        ///
        /// This is property only relevant if the combo was created with
        /// `gtk.ComboBox.properties.has_entry` is `TRUE`.
        pub const entry_text_column = struct {
            pub const name = "entry-text-column";

            pub const Type = c_int;
        };

        /// Whether the combo box has an entry.
        pub const has_entry = struct {
            pub const name = "has-entry";

            pub const Type = c_int;
        };

        /// The `has-frame` property controls whether a frame is drawn around the entry.
        pub const has_frame = struct {
            pub const name = "has-frame";

            pub const Type = c_int;
        };

        /// The model column that provides string IDs for the values
        /// in the model, if != -1.
        pub const id_column = struct {
            pub const name = "id-column";

            pub const Type = c_int;
        };

        /// The model from which the combo box takes its values.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gtk.TreeModel;
        };

        /// Whether the popup's width should be a fixed width matching the
        /// allocated width of the combo box.
        pub const popup_fixed_width = struct {
            pub const name = "popup-fixed-width";

            pub const Type = c_int;
        };

        /// Whether the combo boxes dropdown is popped up.
        ///
        /// Note that this property is mainly useful, because
        /// it allows you to connect to notify::popup-shown.
        pub const popup_shown = struct {
            pub const name = "popup-shown";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted to when the combo box is activated.
        ///
        /// The `::activate` signal on `GtkComboBox` is an action signal and
        /// emitting it causes the combo box to pop up its dropdown.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ComboBox, p_instance))),
                    gobject.signalLookup("activate", ComboBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the active item is changed.
        ///
        /// The can be due to the user selecting a different item from the list,
        /// or due to a call to `gtk.ComboBox.setActiveIter`. It will
        /// also be emitted while typing into the entry of a combo box with an entry.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ComboBox, p_instance))),
                    gobject.signalLookup("changed", ComboBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to allow changing how the text in a combo box's entry is displayed.
        ///
        /// See `gtk.ComboBox.properties.has_entry`.
        ///
        /// Connect a signal handler which returns an allocated string representing
        /// `path`. That string will then be used to set the text in the combo box's
        /// entry. The default signal handler uses the text from the
        /// `gtk.ComboBox.properties.entry_text_column` model column.
        ///
        /// Here's an example signal handler which fetches data from the model and
        /// displays it in the entry.
        /// ```c
        /// static char *
        /// format_entry_text_callback (GtkComboBox *combo,
        ///                             const char *path,
        ///                             gpointer     user_data)
        /// {
        ///   GtkTreeIter iter;
        ///   GtkTreeModel model;
        ///   double       value;
        ///
        ///   model = gtk_combo_box_get_model (combo);
        ///
        ///   gtk_tree_model_get_iter_from_string (model, &iter, path);
        ///   gtk_tree_model_get (model, &iter,
        ///                       THE_DOUBLE_VALUE_COLUMN, &value,
        ///                       -1);
        ///
        ///   return g_strdup_printf ("`g`", value);
        /// }
        /// ```
        pub const format_entry_text = struct {
            pub const name = "format-entry-text";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path: [*:0]u8, P_Data) callconv(.C) [*:0]u8, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ComboBox, p_instance))),
                    gobject.signalLookup("format-entry-text", ComboBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to move the active selection.
        ///
        /// This is an [keybinding signal](class.SignalAction.html).
        pub const move_active = struct {
            pub const name = "move-active";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_scroll_type: gtk.ScrollType, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ComboBox, p_instance))),
                    gobject.signalLookup("move-active", ComboBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to popdown the combo box list.
        ///
        /// This is an [keybinding signal](class.SignalAction.html).
        ///
        /// The default bindings for this signal are Alt+Up and Escape.
        pub const popdown = struct {
            pub const name = "popdown";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ComboBox, p_instance))),
                    gobject.signalLookup("popdown", ComboBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to popup the combo box list.
        ///
        /// This is an [keybinding signal](class.SignalAction.html).
        ///
        /// The default binding for this signal is Alt+Down.
        pub const popup = struct {
            pub const name = "popup";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ComboBox, p_instance))),
                    gobject.signalLookup("popup", ComboBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new empty `GtkComboBox`.
    extern fn gtk_combo_box_new() *gtk.ComboBox;
    pub const new = gtk_combo_box_new;

    /// Creates a new empty `GtkComboBox` with an entry.
    ///
    /// In order to use a combo box with entry, you need to tell it
    /// which column of the model contains the text for the entry
    /// by calling `gtk.ComboBox.setEntryTextColumn`.
    extern fn gtk_combo_box_new_with_entry() *gtk.ComboBox;
    pub const newWithEntry = gtk_combo_box_new_with_entry;

    /// Creates a new `GtkComboBox` with a model.
    extern fn gtk_combo_box_new_with_model(p_model: *gtk.TreeModel) *gtk.ComboBox;
    pub const newWithModel = gtk_combo_box_new_with_model;

    /// Creates a new empty `GtkComboBox` with an entry and a model.
    ///
    /// See also `gtk.ComboBox.newWithEntry`.
    extern fn gtk_combo_box_new_with_model_and_entry(p_model: *gtk.TreeModel) *gtk.ComboBox;
    pub const newWithModelAndEntry = gtk_combo_box_new_with_model_and_entry;

    /// Returns the index of the currently active item.
    ///
    /// If the model is a non-flat treemodel, and the active item is not
    /// an immediate child of the root of the tree, this function returns
    /// `gtk_tree_path_get_indices (path)[0]`, where `path` is the
    /// `gtk.TreePath` of the active item.
    extern fn gtk_combo_box_get_active(p_combo_box: *ComboBox) c_int;
    pub const getActive = gtk_combo_box_get_active;

    /// Returns the ID of the active row of `combo_box`.
    ///
    /// This value is taken from the active row and the column specified
    /// by the `gtk.ComboBox.properties.id_column` property of `combo_box`
    /// (see `gtk.ComboBox.setIdColumn`).
    ///
    /// The returned value is an interned string which means that you can
    /// compare the pointer by value to other interned strings and that you
    /// must not free it.
    ///
    /// If the `gtk.ComboBox.properties.id_column` property of `combo_box` is
    /// not set, or if no row is active, or if the active row has a `NULL`
    /// ID value, then `NULL` is returned.
    extern fn gtk_combo_box_get_active_id(p_combo_box: *ComboBox) ?[*:0]const u8;
    pub const getActiveId = gtk_combo_box_get_active_id;

    /// Sets `iter` to point to the currently active item.
    ///
    /// If no item is active, `iter` is left unchanged.
    extern fn gtk_combo_box_get_active_iter(p_combo_box: *ComboBox, p_iter: *gtk.TreeIter) c_int;
    pub const getActiveIter = gtk_combo_box_get_active_iter;

    /// Returns whether the combo box sets the dropdown button
    /// sensitive or not when there are no items in the model.
    extern fn gtk_combo_box_get_button_sensitivity(p_combo_box: *ComboBox) gtk.SensitivityType;
    pub const getButtonSensitivity = gtk_combo_box_get_button_sensitivity;

    /// Gets the child widget of `combo_box`.
    extern fn gtk_combo_box_get_child(p_combo_box: *ComboBox) ?*gtk.Widget;
    pub const getChild = gtk_combo_box_get_child;

    /// Returns the column which `combo_box` is using to get the strings
    /// from to display in the internal entry.
    extern fn gtk_combo_box_get_entry_text_column(p_combo_box: *ComboBox) c_int;
    pub const getEntryTextColumn = gtk_combo_box_get_entry_text_column;

    /// Returns whether the combo box has an entry.
    extern fn gtk_combo_box_get_has_entry(p_combo_box: *ComboBox) c_int;
    pub const getHasEntry = gtk_combo_box_get_has_entry;

    /// Returns the column which `combo_box` is using to get string IDs
    /// for values from.
    extern fn gtk_combo_box_get_id_column(p_combo_box: *ComboBox) c_int;
    pub const getIdColumn = gtk_combo_box_get_id_column;

    /// Returns the `GtkTreeModel` of `combo_box`.
    extern fn gtk_combo_box_get_model(p_combo_box: *ComboBox) ?*gtk.TreeModel;
    pub const getModel = gtk_combo_box_get_model;

    /// Gets whether the popup uses a fixed width.
    extern fn gtk_combo_box_get_popup_fixed_width(p_combo_box: *ComboBox) c_int;
    pub const getPopupFixedWidth = gtk_combo_box_get_popup_fixed_width;

    /// Returns the current row separator function.
    extern fn gtk_combo_box_get_row_separator_func(p_combo_box: *ComboBox) ?gtk.TreeViewRowSeparatorFunc;
    pub const getRowSeparatorFunc = gtk_combo_box_get_row_separator_func;

    /// Hides the menu or dropdown list of `combo_box`.
    ///
    /// This function is mostly intended for use by accessibility technologies;
    /// applications should have little use for it.
    extern fn gtk_combo_box_popdown(p_combo_box: *ComboBox) void;
    pub const popdown = gtk_combo_box_popdown;

    /// Pops up the menu or dropdown list of `combo_box`.
    ///
    /// This function is mostly intended for use by accessibility technologies;
    /// applications should have little use for it.
    ///
    /// Before calling this, `combo_box` must be mapped, or nothing will happen.
    extern fn gtk_combo_box_popup(p_combo_box: *ComboBox) void;
    pub const popup = gtk_combo_box_popup;

    /// Pops up the menu of `combo_box`.
    ///
    /// Note that currently this does not do anything with the device, as it was
    /// previously only used for list-mode combo boxes, and those were removed
    /// in GTK 4. However, it is retained in case similar functionality is added
    /// back later.
    extern fn gtk_combo_box_popup_for_device(p_combo_box: *ComboBox, p_device: *gdk.Device) void;
    pub const popupForDevice = gtk_combo_box_popup_for_device;

    /// Sets the active item of `combo_box` to be the item at `index`.
    extern fn gtk_combo_box_set_active(p_combo_box: *ComboBox, p_index_: c_int) void;
    pub const setActive = gtk_combo_box_set_active;

    /// Changes the active row of `combo_box` to the one that has an ID equal to
    /// `active_id`.
    ///
    /// If `active_id` is `NULL`, the active row is unset. Rows having
    /// a `NULL` ID string cannot be made active by this function.
    ///
    /// If the `gtk.ComboBox.properties.id_column` property of `combo_box` is
    /// unset or if no row has the given ID then the function does nothing
    /// and returns `FALSE`.
    extern fn gtk_combo_box_set_active_id(p_combo_box: *ComboBox, p_active_id: ?[*:0]const u8) c_int;
    pub const setActiveId = gtk_combo_box_set_active_id;

    /// Sets the current active item to be the one referenced by `iter`.
    ///
    /// If `iter` is `NULL`, the active item is unset.
    extern fn gtk_combo_box_set_active_iter(p_combo_box: *ComboBox, p_iter: ?*gtk.TreeIter) void;
    pub const setActiveIter = gtk_combo_box_set_active_iter;

    /// Sets whether the dropdown button of the combo box should update
    /// its sensitivity depending on the model contents.
    extern fn gtk_combo_box_set_button_sensitivity(p_combo_box: *ComboBox, p_sensitivity: gtk.SensitivityType) void;
    pub const setButtonSensitivity = gtk_combo_box_set_button_sensitivity;

    /// Sets the child widget of `combo_box`.
    extern fn gtk_combo_box_set_child(p_combo_box: *ComboBox, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_combo_box_set_child;

    /// Sets the model column which `combo_box` should use to get strings
    /// from to be `text_column`.
    ///
    /// For this column no separate
    /// `gtk.CellRenderer` is needed.
    ///
    /// The column `text_column` in the model of `combo_box` must be of
    /// type `G_TYPE_STRING`.
    ///
    /// This is only relevant if `combo_box` has been created with
    /// `gtk.ComboBox.properties.has_entry` as `TRUE`.
    extern fn gtk_combo_box_set_entry_text_column(p_combo_box: *ComboBox, p_text_column: c_int) void;
    pub const setEntryTextColumn = gtk_combo_box_set_entry_text_column;

    /// Sets the model column which `combo_box` should use to get string IDs
    /// for values from.
    ///
    /// The column `id_column` in the model of `combo_box` must be of type
    /// `G_TYPE_STRING`.
    extern fn gtk_combo_box_set_id_column(p_combo_box: *ComboBox, p_id_column: c_int) void;
    pub const setIdColumn = gtk_combo_box_set_id_column;

    /// Sets the model used by `combo_box` to be `model`.
    ///
    /// Will unset a previously set model (if applicable). If model is `NULL`,
    /// then it will unset the model.
    ///
    /// Note that this function does not clear the cell renderers, you have to
    /// call `gtk.CellLayout.clear` yourself if you need to set up different
    /// cell renderers for the new model.
    extern fn gtk_combo_box_set_model(p_combo_box: *ComboBox, p_model: ?*gtk.TreeModel) void;
    pub const setModel = gtk_combo_box_set_model;

    /// Specifies whether the popup’s width should be a fixed width.
    ///
    /// If `fixed` is `TRUE`, the popup's width is set to match the
    /// allocated width of the combo box.
    extern fn gtk_combo_box_set_popup_fixed_width(p_combo_box: *ComboBox, p_fixed: c_int) void;
    pub const setPopupFixedWidth = gtk_combo_box_set_popup_fixed_width;

    /// Sets the row separator function, which is used to determine
    /// whether a row should be drawn as a separator.
    ///
    /// If the row separator function is `NULL`, no separators are drawn.
    /// This is the default value.
    extern fn gtk_combo_box_set_row_separator_func(p_combo_box: *ComboBox, p_func: ?gtk.TreeViewRowSeparatorFunc, p_data: ?*anyopaque, p_destroy: ?glib.DestroyNotify) void;
    pub const setRowSeparatorFunc = gtk_combo_box_set_row_separator_func;

    extern fn gtk_combo_box_get_type() usize;
    pub const getGObjectType = gtk_combo_box_get_type;

    extern fn g_object_ref(p_self: *gtk.ComboBox) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ComboBox) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ComboBox, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkComboBoxText` is a simple variant of `GtkComboBox` for text-only
/// use cases.
///
/// ![An example GtkComboBoxText](combo-box-text.png)
///
/// `GtkComboBoxText` hides the model-view complexity of `GtkComboBox`.
///
/// To create a `GtkComboBoxText`, use `gtk.ComboBoxText.new` or
/// `gtk.ComboBoxText.newWithEntry`.
///
/// You can add items to a `GtkComboBoxText` with
/// `gtk.ComboBoxText.appendText`,
/// `gtk.ComboBoxText.insertText` or
/// `gtk.ComboBoxText.prependText` and remove options with
/// `gtk.ComboBoxText.remove`.
///
/// If the `GtkComboBoxText` contains an entry (via the
/// `gtk.ComboBox.properties.has_entry` property), its contents can be retrieved
/// using `gtk.ComboBoxText.getActiveText`.
///
/// You should not call `gtk.ComboBox.setModel` or attempt to pack more
/// cells into this combo box via its `gtk.CellLayout` interface.
///
/// ## GtkComboBoxText as GtkBuildable
///
/// The `GtkComboBoxText` implementation of the `GtkBuildable` interface supports
/// adding items directly using the `<items>` element and specifying `<item>`
/// elements for each item. Each `<item>` element can specify the “id”
/// corresponding to the appended text and also supports the regular
/// translation attributes “translatable”, “context” and “comments”.
///
/// Here is a UI definition fragment specifying `GtkComboBoxText` items:
/// ```xml
/// <object class="GtkComboBoxText">
///   <items>
///     <item translatable="yes" id="factory">Factory</item>
///     <item translatable="yes" id="home">Home</item>
///     <item translatable="yes" id="subway">Subway</item>
///   </items>
/// </object>
/// ```
///
/// ## CSS nodes
///
/// ```
/// combobox
/// ╰── box.linked
///     ├── entry.combo
///     ├── button.combo
///     ╰── window.popup
/// ```
///
/// `GtkComboBoxText` has a single CSS node with name combobox. It adds
/// the style class .combo to the main CSS nodes of its entry and button
/// children, and the .linked class to the node of its internal box.
pub const ComboBoxText = opaque {
    pub const Parent = gtk.ComboBox;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.CellEditable, gtk.CellLayout, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = ComboBoxText;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkComboBoxText`.
    extern fn gtk_combo_box_text_new() *gtk.ComboBoxText;
    pub const new = gtk_combo_box_text_new;

    /// Creates a new `GtkComboBoxText` with an entry.
    extern fn gtk_combo_box_text_new_with_entry() *gtk.ComboBoxText;
    pub const newWithEntry = gtk_combo_box_text_new_with_entry;

    /// Appends `text` to the list of strings stored in `combo_box`.
    ///
    /// If `id` is non-`NULL` then it is used as the ID of the row.
    ///
    /// This is the same as calling `gtk.ComboBoxText.insert`
    /// with a position of -1.
    extern fn gtk_combo_box_text_append(p_combo_box: *ComboBoxText, p_id: ?[*:0]const u8, p_text: [*:0]const u8) void;
    pub const append = gtk_combo_box_text_append;

    /// Appends `text` to the list of strings stored in `combo_box`.
    ///
    /// This is the same as calling `gtk.ComboBoxText.insertText`
    /// with a position of -1.
    extern fn gtk_combo_box_text_append_text(p_combo_box: *ComboBoxText, p_text: [*:0]const u8) void;
    pub const appendText = gtk_combo_box_text_append_text;

    /// Returns the currently active string in `combo_box`.
    ///
    /// If no row is currently selected, `NULL` is returned.
    /// If `combo_box` contains an entry, this function will
    /// return its contents (which will not necessarily
    /// be an item from the list).
    extern fn gtk_combo_box_text_get_active_text(p_combo_box: *ComboBoxText) ?[*:0]u8;
    pub const getActiveText = gtk_combo_box_text_get_active_text;

    /// Inserts `text` at `position` in the list of strings stored in `combo_box`.
    ///
    /// If `id` is non-`NULL` then it is used as the ID of the row.
    /// See `gtk.ComboBox.properties.id_column`.
    ///
    /// If `position` is negative then `text` is appended.
    extern fn gtk_combo_box_text_insert(p_combo_box: *ComboBoxText, p_position: c_int, p_id: ?[*:0]const u8, p_text: [*:0]const u8) void;
    pub const insert = gtk_combo_box_text_insert;

    /// Inserts `text` at `position` in the list of strings stored in `combo_box`.
    ///
    /// If `position` is negative then `text` is appended.
    ///
    /// This is the same as calling `gtk.ComboBoxText.insert`
    /// with a `NULL` ID string.
    extern fn gtk_combo_box_text_insert_text(p_combo_box: *ComboBoxText, p_position: c_int, p_text: [*:0]const u8) void;
    pub const insertText = gtk_combo_box_text_insert_text;

    /// Prepends `text` to the list of strings stored in `combo_box`.
    ///
    /// If `id` is non-`NULL` then it is used as the ID of the row.
    ///
    /// This is the same as calling `gtk.ComboBoxText.insert`
    /// with a position of 0.
    extern fn gtk_combo_box_text_prepend(p_combo_box: *ComboBoxText, p_id: ?[*:0]const u8, p_text: [*:0]const u8) void;
    pub const prepend = gtk_combo_box_text_prepend;

    /// Prepends `text` to the list of strings stored in `combo_box`.
    ///
    /// This is the same as calling `gtk.ComboBoxText.insertText`
    /// with a position of 0.
    extern fn gtk_combo_box_text_prepend_text(p_combo_box: *ComboBoxText, p_text: [*:0]const u8) void;
    pub const prependText = gtk_combo_box_text_prepend_text;

    /// Removes the string at `position` from `combo_box`.
    extern fn gtk_combo_box_text_remove(p_combo_box: *ComboBoxText, p_position: c_int) void;
    pub const remove = gtk_combo_box_text_remove;

    /// Removes all the text entries from the combo box.
    extern fn gtk_combo_box_text_remove_all(p_combo_box: *ComboBoxText) void;
    pub const removeAll = gtk_combo_box_text_remove_all;

    extern fn gtk_combo_box_text_get_type() usize;
    pub const getGObjectType = gtk_combo_box_text_get_type;

    extern fn g_object_ref(p_self: *gtk.ComboBoxText) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ComboBoxText) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ComboBoxText, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A constant value in a `GtkExpression`.
pub const ConstantExpression = opaque {
    pub const Parent = gtk.Expression;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = ConstantExpression;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a `GtkExpression` that evaluates to the
    /// object given by the arguments.
    extern fn gtk_constant_expression_new(p_value_type: usize, ...) *gtk.ConstantExpression;
    pub const new = gtk_constant_expression_new;

    /// Creates an expression that always evaluates to the given `value`.
    extern fn gtk_constant_expression_new_for_value(p_value: *const gobject.Value) *gtk.ConstantExpression;
    pub const newForValue = gtk_constant_expression_new_for_value;

    /// Gets the value that a constant expression evaluates to.
    extern fn gtk_constant_expression_get_value(p_expression: *ConstantExpression) *const gobject.Value;
    pub const getValue = gtk_constant_expression_get_value;

    extern fn gtk_constant_expression_get_type() usize;
    pub const getGObjectType = gtk_constant_expression_get_type;

    pub fn as(p_instance: *ConstantExpression, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkConstraint` describes a constraint between attributes of two widgets,
///  expressed as a linear equation.
///
/// The typical equation for a constraint is:
///
/// ```
///   target.target_attr = source.source_attr × multiplier + constant
/// ```
///
/// Each `GtkConstraint` is part of a system that will be solved by a
/// `gtk.ConstraintLayout` in order to allocate and position each
/// child widget or guide.
///
/// The source and target, as well as their attributes, of a `GtkConstraint`
/// instance are immutable after creation.
pub const Constraint = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.ConstraintClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The constant value to be added to the `gtk.Constraint.properties.source_attribute`.
        pub const constant = struct {
            pub const name = "constant";

            pub const Type = f64;
        };

        /// The multiplication factor to be applied to
        /// the `gtk.Constraint.properties.source_attribute`.
        pub const multiplier = struct {
            pub const name = "multiplier";

            pub const Type = f64;
        };

        /// The order relation between the terms of the constraint.
        pub const relation = struct {
            pub const name = "relation";

            pub const Type = gtk.ConstraintRelation;
        };

        /// The source of the constraint.
        ///
        /// The constraint will set the `gtk.Constraint.properties.target_attribute`
        /// property of the target using the `gtk.Constraint.properties.source_attribute`
        /// property of the source.
        pub const source = struct {
            pub const name = "source";

            pub const Type = ?*gtk.ConstraintTarget;
        };

        /// The attribute of the `gtk.Constraint.properties.source` read by the
        /// constraint.
        pub const source_attribute = struct {
            pub const name = "source-attribute";

            pub const Type = gtk.ConstraintAttribute;
        };

        /// The strength of the constraint.
        ///
        /// The strength can be expressed either using one of the symbolic values
        /// of the `gtk.ConstraintStrength` enumeration, or any positive integer
        /// value.
        pub const strength = struct {
            pub const name = "strength";

            pub const Type = c_int;
        };

        /// The target of the constraint.
        ///
        /// The constraint will set the `gtk.Constraint.properties.target_attribute`
        /// property of the target using the `gtk.Constraint.properties.source_attribute`
        /// property of the source widget.
        pub const target = struct {
            pub const name = "target";

            pub const Type = ?*gtk.ConstraintTarget;
        };

        /// The attribute of the `gtk.Constraint.properties.target` set by the constraint.
        pub const target_attribute = struct {
            pub const name = "target-attribute";

            pub const Type = gtk.ConstraintAttribute;
        };
    };

    pub const signals = struct {};

    /// Creates a new constraint representing a relation between a layout
    /// attribute on a source and a layout attribute on a target.
    extern fn gtk_constraint_new(p_target: ?*gtk.ConstraintTarget, p_target_attribute: gtk.ConstraintAttribute, p_relation: gtk.ConstraintRelation, p_source: ?*gtk.ConstraintTarget, p_source_attribute: gtk.ConstraintAttribute, p_multiplier: f64, p_constant: f64, p_strength: c_int) *gtk.Constraint;
    pub const new = gtk_constraint_new;

    /// Creates a new constraint representing a relation between a layout
    /// attribute on a target and a constant value.
    extern fn gtk_constraint_new_constant(p_target: ?*gtk.ConstraintTarget, p_target_attribute: gtk.ConstraintAttribute, p_relation: gtk.ConstraintRelation, p_constant: f64, p_strength: c_int) *gtk.Constraint;
    pub const newConstant = gtk_constraint_new_constant;

    /// Retrieves the constant factor added to the source attributes' value.
    extern fn gtk_constraint_get_constant(p_constraint: *Constraint) f64;
    pub const getConstant = gtk_constraint_get_constant;

    /// Retrieves the multiplication factor applied to the source
    /// attribute's value.
    extern fn gtk_constraint_get_multiplier(p_constraint: *Constraint) f64;
    pub const getMultiplier = gtk_constraint_get_multiplier;

    /// The order relation between the terms of the constraint.
    extern fn gtk_constraint_get_relation(p_constraint: *Constraint) gtk.ConstraintRelation;
    pub const getRelation = gtk_constraint_get_relation;

    /// Retrieves the `gtk.ConstraintTarget` used as the source for the
    /// constraint.
    ///
    /// If the source is set to `NULL` at creation, the constraint will use
    /// the widget using the `gtk.ConstraintLayout` as the source.
    extern fn gtk_constraint_get_source(p_constraint: *Constraint) ?*gtk.ConstraintTarget;
    pub const getSource = gtk_constraint_get_source;

    /// Retrieves the attribute of the source to be read by the constraint.
    extern fn gtk_constraint_get_source_attribute(p_constraint: *Constraint) gtk.ConstraintAttribute;
    pub const getSourceAttribute = gtk_constraint_get_source_attribute;

    /// Retrieves the strength of the constraint.
    extern fn gtk_constraint_get_strength(p_constraint: *Constraint) c_int;
    pub const getStrength = gtk_constraint_get_strength;

    /// Retrieves the `gtk.ConstraintTarget` used as the target for
    /// the constraint.
    ///
    /// If the targe is set to `NULL` at creation, the constraint will use
    /// the widget using the `gtk.ConstraintLayout` as the target.
    extern fn gtk_constraint_get_target(p_constraint: *Constraint) ?*gtk.ConstraintTarget;
    pub const getTarget = gtk_constraint_get_target;

    /// Retrieves the attribute of the target to be set by the constraint.
    extern fn gtk_constraint_get_target_attribute(p_constraint: *Constraint) gtk.ConstraintAttribute;
    pub const getTargetAttribute = gtk_constraint_get_target_attribute;

    /// Checks whether the constraint is attached to a `gtk.ConstraintLayout`,
    /// and it is contributing to the layout.
    extern fn gtk_constraint_is_attached(p_constraint: *Constraint) c_int;
    pub const isAttached = gtk_constraint_is_attached;

    /// Checks whether the constraint describes a relation between an attribute
    /// on the `gtk.Constraint.properties.target` and a constant value.
    extern fn gtk_constraint_is_constant(p_constraint: *Constraint) c_int;
    pub const isConstant = gtk_constraint_is_constant;

    /// Checks whether the constraint is a required relation for solving the
    /// constraint layout.
    extern fn gtk_constraint_is_required(p_constraint: *Constraint) c_int;
    pub const isRequired = gtk_constraint_is_required;

    extern fn gtk_constraint_get_type() usize;
    pub const getGObjectType = gtk_constraint_get_type;

    extern fn g_object_ref(p_self: *gtk.Constraint) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Constraint) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Constraint, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkConstraintGuide` is an invisible layout element in a
/// `GtkConstraintLayout`.
///
/// The `GtkConstraintLayout` treats guides like widgets. They
/// can be used as the source or target of a `GtkConstraint`.
///
/// Guides have a minimum, maximum and natural size. Depending
/// on the constraints that are applied, they can act like a
/// guideline that widgets can be aligned to, or like *flexible
/// space*.
///
/// Unlike a `GtkWidget`, a `GtkConstraintGuide` will not be drawn.
pub const ConstraintGuide = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{gtk.ConstraintTarget};
    pub const Class = gtk.ConstraintGuideClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The maximum height of the guide.
        pub const max_height = struct {
            pub const name = "max-height";

            pub const Type = c_int;
        };

        /// The maximum width of the guide.
        pub const max_width = struct {
            pub const name = "max-width";

            pub const Type = c_int;
        };

        /// The minimum height of the guide.
        pub const min_height = struct {
            pub const name = "min-height";

            pub const Type = c_int;
        };

        /// The minimum width of the guide.
        pub const min_width = struct {
            pub const name = "min-width";

            pub const Type = c_int;
        };

        /// A name that identifies the `GtkConstraintGuide`, for debugging.
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// The preferred, or natural, height of the guide.
        pub const nat_height = struct {
            pub const name = "nat-height";

            pub const Type = c_int;
        };

        /// The preferred, or natural, width of the guide.
        pub const nat_width = struct {
            pub const name = "nat-width";

            pub const Type = c_int;
        };

        /// The `GtkConstraintStrength` to be used for the constraint on
        /// the natural size of the guide.
        pub const strength = struct {
            pub const name = "strength";

            pub const Type = gtk.ConstraintStrength;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkConstraintGuide` object.
    extern fn gtk_constraint_guide_new() *gtk.ConstraintGuide;
    pub const new = gtk_constraint_guide_new;

    /// Gets the maximum size of `guide`.
    extern fn gtk_constraint_guide_get_max_size(p_guide: *ConstraintGuide, p_width: ?*c_int, p_height: ?*c_int) void;
    pub const getMaxSize = gtk_constraint_guide_get_max_size;

    /// Gets the minimum size of `guide`.
    extern fn gtk_constraint_guide_get_min_size(p_guide: *ConstraintGuide, p_width: ?*c_int, p_height: ?*c_int) void;
    pub const getMinSize = gtk_constraint_guide_get_min_size;

    /// Retrieves the name set using `gtk.ConstraintGuide.setName`.
    extern fn gtk_constraint_guide_get_name(p_guide: *ConstraintGuide) ?[*:0]const u8;
    pub const getName = gtk_constraint_guide_get_name;

    /// Gets the natural size of `guide`.
    extern fn gtk_constraint_guide_get_nat_size(p_guide: *ConstraintGuide, p_width: ?*c_int, p_height: ?*c_int) void;
    pub const getNatSize = gtk_constraint_guide_get_nat_size;

    /// Retrieves the strength set using `gtk.ConstraintGuide.setStrength`.
    extern fn gtk_constraint_guide_get_strength(p_guide: *ConstraintGuide) gtk.ConstraintStrength;
    pub const getStrength = gtk_constraint_guide_get_strength;

    /// Sets the maximum size of `guide`.
    ///
    /// If `guide` is attached to a `GtkConstraintLayout`,
    /// the constraints will be updated to reflect the new size.
    extern fn gtk_constraint_guide_set_max_size(p_guide: *ConstraintGuide, p_width: c_int, p_height: c_int) void;
    pub const setMaxSize = gtk_constraint_guide_set_max_size;

    /// Sets the minimum size of `guide`.
    ///
    /// If `guide` is attached to a `GtkConstraintLayout`,
    /// the constraints will be updated to reflect the new size.
    extern fn gtk_constraint_guide_set_min_size(p_guide: *ConstraintGuide, p_width: c_int, p_height: c_int) void;
    pub const setMinSize = gtk_constraint_guide_set_min_size;

    /// Sets a name for the given `GtkConstraintGuide`.
    ///
    /// The name is useful for debugging purposes.
    extern fn gtk_constraint_guide_set_name(p_guide: *ConstraintGuide, p_name: ?[*:0]const u8) void;
    pub const setName = gtk_constraint_guide_set_name;

    /// Sets the natural size of `guide`.
    ///
    /// If `guide` is attached to a `GtkConstraintLayout`,
    /// the constraints will be updated to reflect the new size.
    extern fn gtk_constraint_guide_set_nat_size(p_guide: *ConstraintGuide, p_width: c_int, p_height: c_int) void;
    pub const setNatSize = gtk_constraint_guide_set_nat_size;

    /// Sets the strength of the constraint on the natural size of the
    /// given `GtkConstraintGuide`.
    extern fn gtk_constraint_guide_set_strength(p_guide: *ConstraintGuide, p_strength: gtk.ConstraintStrength) void;
    pub const setStrength = gtk_constraint_guide_set_strength;

    extern fn gtk_constraint_guide_get_type() usize;
    pub const getGObjectType = gtk_constraint_guide_get_type;

    extern fn g_object_ref(p_self: *gtk.ConstraintGuide) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ConstraintGuide) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ConstraintGuide, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A layout manager using constraints to describe relations between widgets.
///
/// `GtkConstraintLayout` is a layout manager that uses relations between
/// widget attributes, expressed via `gtk.Constraint` instances, to
/// measure and allocate widgets.
///
/// ### How do constraints work
///
/// Constraints are objects defining the relationship between attributes
/// of a widget; you can read the description of the `gtk.Constraint`
/// class to have a more in depth definition.
///
/// By taking multiple constraints and applying them to the children of
/// a widget using `GtkConstraintLayout`, it's possible to describe
/// complex layout policies; each constraint applied to a child or to the parent
/// widgets contributes to the full description of the layout, in terms of
/// parameters for resolving the value of each attribute.
///
/// It is important to note that a layout is defined by the totality of
/// constraints; removing a child, or a constraint, from an existing layout
/// without changing the remaining constraints may result in an unstable
/// or unsolvable layout.
///
/// Constraints have an implicit "reading order"; you should start describing
/// each edge of each child, as well as their relationship with the parent
/// container, from the top left (or top right, in RTL languages), horizontally
/// first, and then vertically.
///
/// A constraint-based layout with too few constraints can become "unstable",
/// that is: have more than one solution. The behavior of an unstable layout
/// is undefined.
///
/// A constraint-based layout with conflicting constraints may be unsolvable,
/// and lead to an unstable layout. You can use the `gtk.Constraint.properties.strength`
/// property of `gtk.Constraint` to "nudge" the layout towards a solution.
///
/// ### GtkConstraintLayout as GtkBuildable
///
/// `GtkConstraintLayout` implements the `gtk.Buildable` interface and
/// has a custom "constraints" element which allows describing constraints in
/// a `gtk.Builder` UI file.
///
/// An example of a UI definition fragment specifying a constraint:
///
/// ```xml
///   <object class="GtkConstraintLayout">
///     <constraints>
///       <constraint target="button" target-attribute="start"
///                   relation="eq"
///                   source="super" source-attribute="start"
///                   constant="12"
///                   strength="required" />
///       <constraint target="button" target-attribute="width"
///                   relation="ge"
///                   constant="250"
///                   strength="strong" />
///     </constraints>
///   </object>
/// ```
///
/// The definition above will add two constraints to the GtkConstraintLayout:
///
///  - a required constraint between the leading edge of "button" and
///    the leading edge of the widget using the constraint layout, plus
///    12 pixels
///  - a strong, constant constraint making the width of "button" greater
///    than, or equal to 250 pixels
///
/// The "target" and "target-attribute" attributes are required.
///
/// The "source" and "source-attribute" attributes of the "constraint"
/// element are optional; if they are not specified, the constraint is
/// assumed to be a constant.
///
/// The "relation" attribute is optional; if not specified, the constraint
/// is assumed to be an equality.
///
/// The "strength" attribute is optional; if not specified, the constraint
/// is assumed to be required.
///
/// The "source" and "target" attributes can be set to "super" to indicate
/// that the constraint target is the widget using the GtkConstraintLayout.
///
/// There can be "constant" and "multiplier" attributes.
///
/// Additionally, the "constraints" element can also contain a description
/// of the `GtkConstraintGuides` used by the layout:
///
/// ```xml
///   <constraints>
///     <guide min-width="100" max-width="500" name="hspace"/>
///     <guide min-height="64" nat-height="128" name="vspace" strength="strong"/>
///   </constraints>
/// ```
///
/// The "guide" element has the following optional attributes:
///
///   - "min-width", "nat-width", and "max-width", describe the minimum,
///     natural, and maximum width of the guide, respectively
///   - "min-height", "nat-height", and "max-height", describe the minimum,
///     natural, and maximum height of the guide, respectively
///   - "strength" describes the strength of the constraint on the natural
///     size of the guide; if not specified, the constraint is assumed to
///     have a medium strength
///   - "name" describes a name for the guide, useful when debugging
///
/// ### Using the Visual Format Language
///
/// Complex constraints can be described using a compact syntax called VFL,
/// or *Visual Format Language*.
///
/// The Visual Format Language describes all the constraints on a row or
/// column, typically starting from the leading edge towards the trailing
/// one. Each element of the layout is composed by "views", which identify
/// a `gtk.ConstraintTarget`.
///
/// For instance:
///
/// ```
///   [button]-[textField]
/// ```
///
/// Describes a constraint that binds the trailing edge of "button" to the
/// leading edge of "textField", leaving a default space between the two.
///
/// Using VFL is also possible to specify predicates that describe constraints
/// on attributes like width and height:
///
/// ```
///   // Width must be greater than, or equal to 50
///   [button(>=50)]
///
///   // Width of button1 must be equal to width of button2
///   [button1(==button2)]
/// ```
///
/// The default orientation for a VFL description is horizontal, unless
/// otherwise specified:
///
/// ```
///   // horizontal orientation, default attribute: width
///   H:[button(>=150)]
///
///   // vertical orientation, default attribute: height
///   V:[button1(==button2)]
/// ```
///
/// It's also possible to specify multiple predicates, as well as their
/// strength:
///
/// ```
///   // minimum width of button must be 150
///   // natural width of button can be 250
///   [button(>=150`required`, ==250`medium`)]
/// ```
///
/// Finally, it's also possible to use simple arithmetic operators:
///
/// ```
///   // width of button1 must be equal to width of button2
///   // divided by 2 plus 12
///   [button1(button2 / 2 + 12)]
/// ```
pub const ConstraintLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{gtk.Buildable};
    pub const Class = gtk.ConstraintLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkConstraintLayout` layout manager.
    extern fn gtk_constraint_layout_new() *gtk.ConstraintLayout;
    pub const new = gtk_constraint_layout_new;

    /// Adds a constraint to the layout manager.
    ///
    /// The `gtk.Constraint.properties.source` and `gtk.Constraint.properties.target`
    /// properties of `constraint` can be:
    ///
    ///  - set to `NULL` to indicate that the constraint refers to the
    ///    widget using `layout`
    ///  - set to the `gtk.Widget` using `layout`
    ///  - set to a child of the `gtk.Widget` using `layout`
    ///  - set to a `gtk.ConstraintGuide` that is part of `layout`
    ///
    /// The `layout` acquires the ownership of `constraint` after calling
    /// this function.
    extern fn gtk_constraint_layout_add_constraint(p_layout: *ConstraintLayout, p_constraint: *gtk.Constraint) void;
    pub const addConstraint = gtk_constraint_layout_add_constraint;

    /// Creates a list of constraints from a VFL description.
    ///
    /// This function is a convenience wrapper around
    /// `gtk.ConstraintLayout.addConstraintsFromDescriptionv`, using
    /// variadic arguments to populate the view/target map.
    extern fn gtk_constraint_layout_add_constraints_from_description(p_layout: *ConstraintLayout, p_lines: [*]const [*:0]const u8, p_n_lines: usize, p_hspacing: c_int, p_vspacing: c_int, p_error: **glib.Error, p_first_view: [*:0]const u8, ...) *glib.List;
    pub const addConstraintsFromDescription = gtk_constraint_layout_add_constraints_from_description;

    /// Creates a list of constraints from a VFL description.
    ///
    /// The Visual Format Language, VFL, is based on Apple's AutoLayout [VFL](https://developer.apple.com/library/content/documentation/UserExperience/Conceptual/AutolayoutPG/VisualFormatLanguage.html).
    ///
    /// The `views` dictionary is used to match `gtk.ConstraintTarget`
    /// instances to the symbolic view name inside the VFL.
    ///
    /// The VFL grammar is:
    ///
    /// ```
    ///        <visualFormatString> = (<orientation>)?
    ///                               (<superview><connection>)?
    ///                               <view>(<connection><view>)*
    ///                               (<connection><superview>)?
    ///               <orientation> = 'H' | 'V'
    ///                 <superview> = '|'
    ///                <connection> = '' | '-' <predicateList> '-' | '-'
    ///             <predicateList> = <simplePredicate> | <predicateListWithParens>
    ///           <simplePredicate> = <metricName> | <positiveNumber>
    ///   <predicateListWithParens> = '(' <predicate> (',' <predicate>)* ')'
    ///                 <predicate> = (<relation>)? <objectOfPredicate> (<operatorList>)? ('@' <priority>)?
    ///                  <relation> = '==' | '<=' | '>='
    ///         <objectOfPredicate> = <constant> | <viewName> | ('.' <attributeName>)?
    ///                  <priority> = <positiveNumber> | 'required' | 'strong' | 'medium' | 'weak'
    ///                  <constant> = <number>
    ///              <operatorList> = (<multiplyOperator>)? (<addOperator>)?
    ///          <multiplyOperator> = [ '*' | '/' ] <positiveNumber>
    ///               <addOperator> = [ '+' | '-' ] <positiveNumber>
    ///                  <viewName> = [A-Za-z_]([A-Za-z0-9_]*) // A C identifier
    ///                <metricName> = [A-Za-z_]([A-Za-z0-9_]*) // A C identifier
    ///             <attributeName> = 'top' | 'bottom' | 'left' | 'right' | 'width' | 'height' |
    ///                               'start' | 'end' | 'centerX' | 'centerY' | 'baseline'
    ///            <positiveNumber> // A positive real number parseable by `glib.asciiStrtod`
    ///                    <number> // A real number parseable by `glib.asciiStrtod`
    /// ```
    ///
    /// **Note**: The VFL grammar used by GTK is slightly different than the one
    /// defined by Apple, as it can use symbolic values for the constraint's
    /// strength instead of numeric values; additionally, GTK allows adding
    /// simple arithmetic operations inside predicates.
    ///
    /// Examples of VFL descriptions are:
    ///
    /// ```
    ///   // Default spacing
    ///   [button]-[textField]
    ///
    ///   // Width constraint
    ///   [button(>=50)]
    ///
    ///   // Connection to super view
    ///   |-50-[purpleBox]-50-|
    ///
    ///   // Vertical layout
    ///   V:[topField]-10-[bottomField]
    ///
    ///   // Flush views
    ///   [maroonView][blueView]
    ///
    ///   // Priority
    ///   [button(100`strong`)]
    ///
    ///   // Equal widths
    ///   [button1(==button2)]
    ///
    ///   // Multiple predicates
    ///   [flexibleButton(>=70,<=100)]
    ///
    ///   // A complete line of layout
    ///   |-[find]-[findNext]-[findField(>=20)]-|
    ///
    ///   // Operators
    ///   [button1(button2 / 3 + 50)]
    ///
    ///   // Named attributes
    ///   [button1(==button2.height)]
    /// ```
    extern fn gtk_constraint_layout_add_constraints_from_descriptionv(p_layout: *ConstraintLayout, p_lines: [*]const [*:0]const u8, p_n_lines: usize, p_hspacing: c_int, p_vspacing: c_int, p_views: *glib.HashTable, p_error: ?*?*glib.Error) ?*glib.List;
    pub const addConstraintsFromDescriptionv = gtk_constraint_layout_add_constraints_from_descriptionv;

    /// Adds a guide to `layout`.
    ///
    /// A guide can be used as the source or target of constraints,
    /// like a widget, but it is not visible.
    ///
    /// The `layout` acquires the ownership of `guide` after calling
    /// this function.
    extern fn gtk_constraint_layout_add_guide(p_layout: *ConstraintLayout, p_guide: *gtk.ConstraintGuide) void;
    pub const addGuide = gtk_constraint_layout_add_guide;

    /// Returns a `GListModel` to track the constraints that are
    /// part of the layout.
    ///
    /// Calling this function will enable extra internal bookkeeping
    /// to track constraints and emit signals on the returned listmodel.
    /// It may slow down operations a lot.
    ///
    /// Applications should try hard to avoid calling this function
    /// because of the slowdowns.
    extern fn gtk_constraint_layout_observe_constraints(p_layout: *ConstraintLayout) *gio.ListModel;
    pub const observeConstraints = gtk_constraint_layout_observe_constraints;

    /// Returns a `GListModel` to track the guides that are
    /// part of the layout.
    ///
    /// Calling this function will enable extra internal bookkeeping
    /// to track guides and emit signals on the returned listmodel.
    /// It may slow down operations a lot.
    ///
    /// Applications should try hard to avoid calling this function
    /// because of the slowdowns.
    extern fn gtk_constraint_layout_observe_guides(p_layout: *ConstraintLayout) *gio.ListModel;
    pub const observeGuides = gtk_constraint_layout_observe_guides;

    /// Removes all constraints from the layout manager.
    extern fn gtk_constraint_layout_remove_all_constraints(p_layout: *ConstraintLayout) void;
    pub const removeAllConstraints = gtk_constraint_layout_remove_all_constraints;

    /// Removes `constraint` from the layout manager,
    /// so that it no longer influences the layout.
    extern fn gtk_constraint_layout_remove_constraint(p_layout: *ConstraintLayout, p_constraint: *gtk.Constraint) void;
    pub const removeConstraint = gtk_constraint_layout_remove_constraint;

    /// Removes `guide` from the layout manager,
    /// so that it no longer influences the layout.
    extern fn gtk_constraint_layout_remove_guide(p_layout: *ConstraintLayout, p_guide: *gtk.ConstraintGuide) void;
    pub const removeGuide = gtk_constraint_layout_remove_guide;

    extern fn gtk_constraint_layout_get_type() usize;
    pub const getGObjectType = gtk_constraint_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.ConstraintLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ConstraintLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ConstraintLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkLayoutChild` subclass for children in a `GtkConstraintLayout`.
pub const ConstraintLayoutChild = opaque {
    pub const Parent = gtk.LayoutChild;
    pub const Implements = [_]type{};
    pub const Class = gtk.ConstraintLayoutChildClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gtk_constraint_layout_child_get_type() usize;
    pub const getGObjectType = gtk_constraint_layout_child_get_type;

    extern fn g_object_ref(p_self: *gtk.ConstraintLayoutChild) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.ConstraintLayoutChild) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ConstraintLayoutChild, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCssProvider` is an object implementing the `GtkStyleProvider` interface
/// for CSS.
///
/// It is able to parse CSS-like input in order to style widgets.
///
/// An application can make GTK parse a specific CSS style sheet by calling
/// `gtk.CssProvider.loadFromFile` or
/// `gtk.CssProvider.loadFromResource`
/// and adding the provider with `gtk.StyleContext.addProvider` or
/// `gtk.StyleContext.addProviderForDisplay`.
///
/// In addition, certain files will be read when GTK is initialized.
/// First, the file `$XDG_CONFIG_HOME/gtk-4.0/gtk.css` is loaded if it
/// exists. Then, GTK loads the first existing file among
/// `XDG_DATA_HOME/themes/THEME/gtk-VERSION/gtk-VARIANT.css`,
/// `$HOME/.themes/THEME/gtk-VERSION/gtk-VARIANT.css`,
/// `$XDG_DATA_DIRS/themes/THEME/gtk-VERSION/gtk-VARIANT.css` and
/// `DATADIR/share/themes/THEME/gtk-VERSION/gtk-VARIANT.css`,
/// where `THEME` is the name of the current theme (see the
/// `gtk.Settings.properties.gtk_theme_name` setting), `VARIANT` is the
/// variant to load (see the
/// `gtk.Settings.properties.gtk_application_prefer_dark_theme` setting),
/// `DATADIR` is the prefix configured when GTK was compiled (unless
/// overridden by the `GTK_DATA_PREFIX` environment variable), and
/// `VERSION` is the GTK version number. If no file is found for the
/// current version, GTK tries older versions all the way back to 4.0.
///
/// To track errors while loading CSS, connect to the
/// `gtk.CssProvider.signals.parsing_error` signal.
pub const CssProvider = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{gtk.StyleProvider};
    pub const Class = gtk.CssProviderClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Signals that a parsing error occurred.
        ///
        /// The expected error values are in the `gtk.CssParserError`
        /// and `gtk.CssParserWarning` enumerations.
        ///
        /// The `path`, `line` and `position` describe the actual location of
        /// the error as accurately as possible.
        ///
        /// Parsing errors are never fatal, so the parsing will resume after
        /// the error. Errors may however cause parts of the given data or
        /// even all of it to not be parsed at all. So it is a useful idea
        /// to check that the parsing succeeds by connecting to this signal.
        ///
        /// Errors in the `gtk.CssParserWarning` enumeration should not
        /// be treated as fatal errors.
        ///
        /// Note that this signal may be emitted at any time as the css provider
        /// may opt to defer parsing parts or all of the input to a later time
        /// than when a loading function was called.
        pub const parsing_error = struct {
            pub const name = "parsing-error";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_section: *gtk.CssSection, p_error: *glib.Error, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CssProvider, p_instance))),
                    gobject.signalLookup("parsing-error", CssProvider.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkCssProvider`.
    extern fn gtk_css_provider_new() *gtk.CssProvider;
    pub const new = gtk_css_provider_new;

    /// Loads `data` into `css_provider`.
    ///
    /// This clears any previously loaded information.
    extern fn gtk_css_provider_load_from_bytes(p_css_provider: *CssProvider, p_data: *glib.Bytes) void;
    pub const loadFromBytes = gtk_css_provider_load_from_bytes;

    /// Loads `data` into `css_provider`.
    ///
    /// This clears any previously loaded information.
    extern fn gtk_css_provider_load_from_data(p_css_provider: *CssProvider, p_data: [*:0]const u8, p_length: isize) void;
    pub const loadFromData = gtk_css_provider_load_from_data;

    /// Loads the data contained in `file` into `css_provider`.
    ///
    /// This clears any previously loaded information.
    extern fn gtk_css_provider_load_from_file(p_css_provider: *CssProvider, p_file: *gio.File) void;
    pub const loadFromFile = gtk_css_provider_load_from_file;

    /// Loads the data contained in `path` into `css_provider`.
    ///
    /// This clears any previously loaded information.
    extern fn gtk_css_provider_load_from_path(p_css_provider: *CssProvider, p_path: [*:0]const u8) void;
    pub const loadFromPath = gtk_css_provider_load_from_path;

    /// Loads the data contained in the resource at `resource_path` into
    /// the `css_provider`.
    ///
    /// This clears any previously loaded information.
    extern fn gtk_css_provider_load_from_resource(p_css_provider: *CssProvider, p_resource_path: [*:0]const u8) void;
    pub const loadFromResource = gtk_css_provider_load_from_resource;

    /// Loads `string` into `css_provider`.
    ///
    /// This clears any previously loaded information.
    extern fn gtk_css_provider_load_from_string(p_css_provider: *CssProvider, p_string: [*:0]const u8) void;
    pub const loadFromString = gtk_css_provider_load_from_string;

    /// Loads a theme from the usual theme paths.
    ///
    /// The actual process of finding the theme might change between
    /// releases, but it is guaranteed that this function uses the same
    /// mechanism to load the theme that GTK uses for loading its own theme.
    extern fn gtk_css_provider_load_named(p_provider: *CssProvider, p_name: [*:0]const u8, p_variant: ?[*:0]const u8) void;
    pub const loadNamed = gtk_css_provider_load_named;

    /// Converts the `provider` into a string representation in CSS
    /// format.
    ///
    /// Using `gtk.CssProvider.loadFromString` with the return
    /// value from this function on a new provider created with
    /// `gtk.CssProvider.new` will basically create a duplicate
    /// of this `provider`.
    extern fn gtk_css_provider_to_string(p_provider: *CssProvider) [*:0]u8;
    pub const toString = gtk_css_provider_to_string;

    extern fn gtk_css_provider_get_type() usize;
    pub const getGObjectType = gtk_css_provider_get_type;

    extern fn g_object_ref(p_self: *gtk.CssProvider) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CssProvider) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CssProvider, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCustomFilter` determines whether to include items with a callback.
pub const CustomFilter = opaque {
    pub const Parent = gtk.Filter;
    pub const Implements = [_]type{};
    pub const Class = gtk.CustomFilterClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new filter using the given `match_func` to filter
    /// items.
    ///
    /// If `match_func` is `NULL`, the filter matches all items.
    ///
    /// If the filter func changes its filtering behavior,
    /// `gtk.Filter.changed` needs to be called.
    extern fn gtk_custom_filter_new(p_match_func: ?gtk.CustomFilterFunc, p_user_data: ?*anyopaque, p_user_destroy: ?glib.DestroyNotify) *gtk.CustomFilter;
    pub const new = gtk_custom_filter_new;

    /// Sets the function used for filtering items.
    ///
    /// If `match_func` is `NULL`, the filter matches all items.
    ///
    /// If the filter func changes its filtering behavior,
    /// `gtk.Filter.changed` needs to be called.
    ///
    /// If a previous function was set, its `user_destroy` will be
    /// called now.
    extern fn gtk_custom_filter_set_filter_func(p_self: *CustomFilter, p_match_func: ?gtk.CustomFilterFunc, p_user_data: ?*anyopaque, p_user_destroy: ?glib.DestroyNotify) void;
    pub const setFilterFunc = gtk_custom_filter_set_filter_func;

    extern fn gtk_custom_filter_get_type() usize;
    pub const getGObjectType = gtk_custom_filter_get_type;

    extern fn g_object_ref(p_self: *gtk.CustomFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CustomFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CustomFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCustomLayout` uses closures for size negotiation.
///
/// A `GtkCustomLayout `uses closures matching to the old `GtkWidget`
/// virtual functions for size negotiation, as a convenience API to
/// ease the porting towards the corresponding `GtkLayoutManager
/// virtual functions.
pub const CustomLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{};
    pub const Class = gtk.CustomLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new legacy layout manager.
    ///
    /// Legacy layout managers map to the old `GtkWidget` size negotiation
    /// virtual functions, and are meant to be used during the transition
    /// from layout containers to layout manager delegates.
    extern fn gtk_custom_layout_new(p_request_mode: ?gtk.CustomRequestModeFunc, p_measure: gtk.CustomMeasureFunc, p_allocate: gtk.CustomAllocateFunc) *gtk.CustomLayout;
    pub const new = gtk_custom_layout_new;

    extern fn gtk_custom_layout_get_type() usize;
    pub const getGObjectType = gtk_custom_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.CustomLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CustomLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CustomLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkCustomSorter` is a `GtkSorter` implementation that sorts via a callback
/// function.
pub const CustomSorter = opaque {
    pub const Parent = gtk.Sorter;
    pub const Implements = [_]type{};
    pub const Class = gtk.CustomSorterClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkSorter` that works by calling
    /// `sort_func` to compare items.
    ///
    /// If `sort_func` is `NULL`, all items are considered equal.
    extern fn gtk_custom_sorter_new(p_sort_func: ?glib.CompareDataFunc, p_user_data: ?*anyopaque, p_user_destroy: ?glib.DestroyNotify) *gtk.CustomSorter;
    pub const new = gtk_custom_sorter_new;

    /// Sets (or unsets) the function used for sorting items.
    ///
    /// If `sort_func` is `NULL`, all items are considered equal.
    ///
    /// If the sort func changes its sorting behavior,
    /// `gtk.Sorter.changed` needs to be called.
    ///
    /// If a previous function was set, its `user_destroy` will be
    /// called now.
    extern fn gtk_custom_sorter_set_sort_func(p_self: *CustomSorter, p_sort_func: ?glib.CompareDataFunc, p_user_data: ?*anyopaque, p_user_destroy: ?glib.DestroyNotify) void;
    pub const setSortFunc = gtk_custom_sorter_set_sort_func;

    extern fn gtk_custom_sorter_get_type() usize;
    pub const getGObjectType = gtk_custom_sorter_get_type;

    extern fn g_object_ref(p_self: *gtk.CustomSorter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.CustomSorter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CustomSorter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Dialogs are a convenient way to prompt the user for a small amount
/// of input.
///
/// ![An example GtkDialog](dialog.png)
///
/// Typical uses are to display a message, ask a question, or anything else
/// that does not require extensive effort on the user’s part.
///
/// The main area of a `GtkDialog` is called the "content area", and is yours
/// to populate with widgets such a `GtkLabel` or `GtkEntry`, to present
/// your information, questions, or tasks to the user.
///
/// In addition, dialogs allow you to add "action widgets". Most commonly,
/// action widgets are buttons. Depending on the platform, action widgets may
/// be presented in the header bar at the top of the window, or at the bottom
/// of the window. To add action widgets, create your `GtkDialog` using
/// `gtk.Dialog.newWithButtons`, or use
/// `gtk.Dialog.addButton`, `gtk.Dialog.addButtons`,
/// or `gtk.Dialog.addActionWidget`.
///
/// `GtkDialogs` uses some heuristics to decide whether to add a close
/// button to the window decorations. If any of the action buttons use
/// the response ID `GTK_RESPONSE_CLOSE` or `GTK_RESPONSE_CANCEL`, the
/// close button is omitted.
///
/// Clicking a button that was added as an action widget will emit the
/// `gtk.Dialog.signals.response` signal with a response ID that you specified.
/// GTK will never assign a meaning to positive response IDs; these are
/// entirely user-defined. But for convenience, you can use the response
/// IDs in the `gtk.ResponseType` enumeration (these all have values
/// less than zero). If a dialog receives a delete event, the
/// `gtk.Dialog.signals.response` signal will be emitted with the
/// `GTK_RESPONSE_DELETE_EVENT` response ID.
///
/// Dialogs are created with a call to `gtk.Dialog.new` or
/// `gtk.Dialog.newWithButtons`. The latter is recommended; it allows
/// you to set the dialog title, some convenient flags, and add buttons.
///
/// A “modal” dialog (that is, one which freezes the rest of the application
/// from user input), can be created by calling `gtk.Window.setModal`
/// on the dialog. When using `gtk.Dialog.newWithButtons`, you can also
/// pass the `GTK_DIALOG_MODAL` flag to make a dialog modal.
///
/// For the simple dialog in the following example, a `gtk.MessageDialog`
/// would save some effort. But you’d need to create the dialog contents manually
/// if you had more than a simple message in the dialog.
///
/// An example for simple `GtkDialog` usage:
///
/// ```c
/// // Function to open a dialog box with a message
/// void
/// quick_message (GtkWindow *parent, char *message)
/// {
///  GtkWidget *dialog, *label, *content_area;
///  GtkDialogFlags flags;
///
///  // Create the widgets
///  flags = GTK_DIALOG_DESTROY_WITH_PARENT;
///  dialog = gtk_dialog_new_with_buttons ("Message",
///                                        parent,
///                                        flags,
///                                        _("_OK"),
///                                        GTK_RESPONSE_NONE,
///                                        NULL);
///  content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
///  label = gtk_label_new (message);
///
///  // Ensure that the dialog box is destroyed when the user responds
///
///  g_signal_connect_swapped (dialog,
///                            "response",
///                            G_CALLBACK (gtk_window_destroy),
///                            dialog);
///
///  // Add the label, and show everything we’ve added
///
///  gtk_box_append (GTK_BOX (content_area), label);
///  gtk_widget_show (dialog);
/// }
/// ```
///
/// # GtkDialog as GtkBuildable
///
/// The `GtkDialog` implementation of the `GtkBuildable` interface exposes the
/// `content_area` as an internal child with the name “content_area”.
///
/// `GtkDialog` supports a custom `<action-widgets>` element, which can contain
/// multiple `<action-widget>` elements. The “response” attribute specifies a
/// numeric response, and the content of the element is the id of widget
/// (which should be a child of the dialogs `action_area`). To mark a response
/// as default, set the “default” attribute of the `<action-widget>` element
/// to true.
///
/// `GtkDialog` supports adding action widgets by specifying “action” as
/// the “type” attribute of a `<child>` element. The widget will be added
/// either to the action area or the headerbar of the dialog, depending
/// on the “use-header-bar” property. The response id has to be associated
/// with the action widget using the `<action-widgets>` element.
///
/// An example of a `GtkDialog` UI definition fragment:
///
/// ```xml
/// <object class="GtkDialog" id="dialog1">
///   <child type="action">
///     <object class="GtkButton" id="button_cancel"/>
///   </child>
///   <child type="action">
///     <object class="GtkButton" id="button_ok">
///     </object>
///   </child>
///   <action-widgets>
///     <action-widget response="cancel">button_cancel</action-widget>
///     <action-widget response="ok" default="true">button_ok</action-widget>
///   </action-widgets>
/// </object>
/// ```
///
/// # Accessibility
///
/// `GtkDialog` uses the `GTK_ACCESSIBLE_ROLE_DIALOG` role.
pub const Dialog = extern struct {
    pub const Parent = gtk.Window;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = gtk.DialogClass;
    f_parent_instance: gtk.Window,

    pub const virtual_methods = struct {
        /// Signal emitted when the user uses a keybinding to close the dialog.
        pub const close = struct {
            pub fn call(p_class: anytype, p_dialog: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Dialog.Class, p_class).f_close.?(gobject.ext.as(Dialog, p_dialog));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_dialog: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Dialog.Class, p_class).f_close = @ptrCast(p_implementation);
            }
        };

        /// Emits the ::response signal with the given response ID.
        ///
        /// Used to indicate that the user has responded to the dialog in some way.
        pub const response = struct {
            pub fn call(p_class: anytype, p_dialog: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_response_id: c_int) void {
                return gobject.ext.as(Dialog.Class, p_class).f_response.?(gobject.ext.as(Dialog, p_dialog), p_response_id);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_dialog: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_response_id: c_int) callconv(.C) void) void {
                gobject.ext.as(Dialog.Class, p_class).f_response = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// `TRUE` if the dialog uses a headerbar for action buttons
        /// instead of the action-area.
        ///
        /// For technical reasons, this property is declared as an integer
        /// property, but you should only set it to `TRUE` or `FALSE`.
        ///
        /// ## Creating a dialog with headerbar
        ///
        /// Builtin `GtkDialog` subclasses such as `gtk.ColorChooserDialog`
        /// set this property according to platform conventions (using the
        /// `gtk.Settings.properties.gtk_dialogs_use_header` setting).
        ///
        /// Here is how you can achieve the same:
        ///
        /// ```c
        /// g_object_get (settings, "gtk-dialogs-use-header", &header, NULL);
        /// dialog = g_object_new (GTK_TYPE_DIALOG, header, TRUE, NULL);
        /// ```
        pub const use_header_bar = struct {
            pub const name = "use-header-bar";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the user uses a keybinding to close the dialog.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// The default binding for this signal is the Escape key.
        pub const close = struct {
            pub const name = "close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Dialog, p_instance))),
                    gobject.signalLookup("close", Dialog.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when an action widget is clicked.
        ///
        /// The signal is also emitted when the dialog receives a
        /// delete event, and when `gtk.Dialog.response` is called.
        /// On a delete event, the response ID is `GTK_RESPONSE_DELETE_EVENT`.
        /// Otherwise, it depends on which action widget was clicked.
        pub const response = struct {
            pub const name = "response";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_response_id: c_int, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Dialog, p_instance))),
                    gobject.signalLookup("response", Dialog.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new dialog box.
    ///
    /// Widgets should not be packed into the `GtkWindow`
    /// directly, but into the `content_area` and `action_area`,
    /// as described above.
    extern fn gtk_dialog_new() *gtk.Dialog;
    pub const new = gtk_dialog_new;

    /// Creates a new `GtkDialog` with the given title and transient parent.
    ///
    /// The `flags` argument can be used to make the dialog modal, have it
    /// destroyed along with its transient parent, or make it use a headerbar.
    ///
    /// Button text/response ID pairs should be listed in pairs, with a `NULL`
    /// pointer ending the list. Button text can be arbitrary text. A response
    /// ID can be any positive number, or one of the values in the
    /// `gtk.ResponseType` enumeration. If the user clicks one of these
    /// buttons, `GtkDialog` will emit the `gtk.Dialog.signals.response` signal
    /// with the corresponding response ID.
    ///
    /// If a `GtkDialog` receives a delete event, it will emit ::response with a
    /// response ID of `GTK_RESPONSE_DELETE_EVENT`.
    ///
    /// However, destroying a dialog does not emit the ::response signal;
    /// so be careful relying on ::response when using the
    /// `GTK_DIALOG_DESTROY_WITH_PARENT` flag.
    ///
    /// Here’s a simple example:
    /// ```c
    /// GtkWindow *main_app_window; // Window the dialog should show up on
    /// GtkWidget *dialog;
    /// GtkDialogFlags flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
    /// dialog = gtk_dialog_new_with_buttons ("My dialog",
    ///                                       main_app_window,
    ///                                       flags,
    ///                                       _("_OK"),
    ///                                       GTK_RESPONSE_ACCEPT,
    ///                                       _("_Cancel"),
    ///                                       GTK_RESPONSE_REJECT,
    ///                                       NULL);
    /// ```
    extern fn gtk_dialog_new_with_buttons(p_title: ?[*:0]const u8, p_parent: ?*gtk.Window, p_flags: gtk.DialogFlags, p_first_button_text: ?[*:0]const u8, ...) *gtk.Dialog;
    pub const newWithButtons = gtk_dialog_new_with_buttons;

    /// Adds an activatable widget to the action area of a `GtkDialog`.
    ///
    /// GTK connects a signal handler that will emit the
    /// `gtk.Dialog.signals.response` signal on the dialog when the widget
    /// is activated. The widget is appended to the end of the dialog’s action
    /// area.
    ///
    /// If you want to add a non-activatable widget, simply pack it into
    /// the `action_area` field of the `GtkDialog` struct.
    extern fn gtk_dialog_add_action_widget(p_dialog: *Dialog, p_child: *gtk.Widget, p_response_id: c_int) void;
    pub const addActionWidget = gtk_dialog_add_action_widget;

    /// Adds a button with the given text.
    ///
    /// GTK arranges things so that clicking the button will emit the
    /// `gtk.Dialog.signals.response` signal with the given `response_id`.
    /// The button is appended to the end of the dialog’s action area.
    /// The button widget is returned, but usually you don’t need it.
    extern fn gtk_dialog_add_button(p_dialog: *Dialog, p_button_text: [*:0]const u8, p_response_id: c_int) *gtk.Widget;
    pub const addButton = gtk_dialog_add_button;

    /// Adds multiple buttons.
    ///
    /// This is the same as calling `gtk.Dialog.addButton`
    /// repeatedly. The variable argument list should be `NULL`-terminated
    /// as with `gtk.Dialog.newWithButtons`. Each button must have both
    /// text and response ID.
    extern fn gtk_dialog_add_buttons(p_dialog: *Dialog, p_first_button_text: [*:0]const u8, ...) void;
    pub const addButtons = gtk_dialog_add_buttons;

    /// Returns the content area of `dialog`.
    extern fn gtk_dialog_get_content_area(p_dialog: *Dialog) *gtk.Box;
    pub const getContentArea = gtk_dialog_get_content_area;

    /// Returns the header bar of `dialog`.
    ///
    /// Note that the headerbar is only used by the dialog if the
    /// `gtk.Dialog.properties.use_header_bar` property is `TRUE`.
    extern fn gtk_dialog_get_header_bar(p_dialog: *Dialog) *gtk.HeaderBar;
    pub const getHeaderBar = gtk_dialog_get_header_bar;

    /// Gets the response id of a widget in the action area
    /// of a dialog.
    extern fn gtk_dialog_get_response_for_widget(p_dialog: *Dialog, p_widget: *gtk.Widget) c_int;
    pub const getResponseForWidget = gtk_dialog_get_response_for_widget;

    /// Gets the widget button that uses the given response ID in the action area
    /// of a dialog.
    extern fn gtk_dialog_get_widget_for_response(p_dialog: *Dialog, p_response_id: c_int) ?*gtk.Widget;
    pub const getWidgetForResponse = gtk_dialog_get_widget_for_response;

    /// Emits the ::response signal with the given response ID.
    ///
    /// Used to indicate that the user has responded to the dialog in some way.
    extern fn gtk_dialog_response(p_dialog: *Dialog, p_response_id: c_int) void;
    pub const response = gtk_dialog_response;

    /// Sets the default widget for the dialog based on the response ID.
    ///
    /// Pressing “Enter” normally activates the default widget.
    extern fn gtk_dialog_set_default_response(p_dialog: *Dialog, p_response_id: c_int) void;
    pub const setDefaultResponse = gtk_dialog_set_default_response;

    /// A convenient way to sensitize/desensitize dialog buttons.
    ///
    /// Calls `gtk_widget_set_sensitive (widget, `setting`)`
    /// for each widget in the dialog’s action area with the given `response_id`.
    extern fn gtk_dialog_set_response_sensitive(p_dialog: *Dialog, p_response_id: c_int, p_setting: c_int) void;
    pub const setResponseSensitive = gtk_dialog_set_response_sensitive;

    extern fn gtk_dialog_get_type() usize;
    pub const getGObjectType = gtk_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.Dialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Dialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Dialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDirectoryList` is a list model that wraps `gio.File.enumerateChildrenAsync`.
///
/// It presents a `GListModel` and fills it asynchronously with the `GFileInfo`s
/// returned from that function.
///
/// Enumeration will start automatically when the
/// `gtk.DirectoryList.properties.file` property is set.
///
/// While the `GtkDirectoryList` is being filled, the
/// `gtk.DirectoryList.properties.loading` property will be set to `TRUE`. You can
/// listen to that property if you want to show information like a `GtkSpinner`
/// or a "Loading..." text.
///
/// If loading fails at any point, the `gtk.DirectoryList.properties.@"error"`
/// property will be set to give more indication about the failure.
///
/// The `GFileInfo`s returned from a `GtkDirectoryList` have the "standard::file"
/// attribute set to the `GFile` they refer to. This way you can get at the file
/// that is referred to in the same way you would via `gio.FileEnumerator.getChild`.
/// This means you do not need access to the `GtkDirectoryList`, but can access
/// the `GFile` directly from the `GFileInfo` when operating with a `GtkListView`
/// or similar.
pub const DirectoryList = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{gio.ListModel};
    pub const Class = gtk.DirectoryListClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The attributes to query.
        pub const attributes = struct {
            pub const name = "attributes";

            pub const Type = ?[*:0]u8;
        };

        /// Error encountered while loading files.
        pub const @"error" = struct {
            pub const name = "error";

            pub const Type = ?*glib.Error;
        };

        /// File to query.
        pub const file = struct {
            pub const name = "file";

            pub const Type = ?*gio.File;
        };

        /// Priority used when loading.
        pub const io_priority = struct {
            pub const name = "io-priority";

            pub const Type = c_int;
        };

        /// The type of items. See `gio.ListModel.getItemType`.
        pub const item_type = struct {
            pub const name = "item-type";

            pub const Type = usize;
        };

        /// `TRUE` if files are being loaded.
        pub const loading = struct {
            pub const name = "loading";

            pub const Type = c_int;
        };

        /// `TRUE` if the directory is monitored for changed.
        pub const monitored = struct {
            pub const name = "monitored";

            pub const Type = c_int;
        };

        /// The number of items. See `gio.ListModel.getNItems`.
        pub const n_items = struct {
            pub const name = "n-items";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkDirectoryList`.
    ///
    /// The `GtkDirectoryList` is querying the given `file`
    /// with the given `attributes`.
    extern fn gtk_directory_list_new(p_attributes: ?[*:0]const u8, p_file: ?*gio.File) *gtk.DirectoryList;
    pub const new = gtk_directory_list_new;

    /// Gets the attributes queried on the children.
    extern fn gtk_directory_list_get_attributes(p_self: *DirectoryList) ?[*:0]const u8;
    pub const getAttributes = gtk_directory_list_get_attributes;

    /// Gets the loading error, if any.
    ///
    /// If an error occurs during the loading process, the loading process
    /// will finish and this property allows querying the error that happened.
    /// This error will persist until a file is loaded again.
    ///
    /// An error being set does not mean that no files were loaded, and all
    /// successfully queried files will remain in the list.
    extern fn gtk_directory_list_get_error(p_self: *DirectoryList) ?*const glib.Error;
    pub const getError = gtk_directory_list_get_error;

    /// Gets the file whose children are currently enumerated.
    extern fn gtk_directory_list_get_file(p_self: *DirectoryList) ?*gio.File;
    pub const getFile = gtk_directory_list_get_file;

    /// Gets the IO priority set via `gtk.DirectoryList.setIoPriority`.
    extern fn gtk_directory_list_get_io_priority(p_self: *DirectoryList) c_int;
    pub const getIoPriority = gtk_directory_list_get_io_priority;

    /// Returns whether the directory list is monitoring
    /// the directory for changes.
    extern fn gtk_directory_list_get_monitored(p_self: *DirectoryList) c_int;
    pub const getMonitored = gtk_directory_list_get_monitored;

    /// Returns `TRUE` if the children enumeration is currently in
    /// progress.
    ///
    /// Files will be added to `self` from time to time while loading is
    /// going on. The order in which are added is undefined and may change
    /// in between runs.
    extern fn gtk_directory_list_is_loading(p_self: *DirectoryList) c_int;
    pub const isLoading = gtk_directory_list_is_loading;

    /// Sets the `attributes` to be enumerated and starts the enumeration.
    ///
    /// If `attributes` is `NULL`, the list of file infos will still be created, it will just
    /// not contain any extra attributes.
    extern fn gtk_directory_list_set_attributes(p_self: *DirectoryList, p_attributes: ?[*:0]const u8) void;
    pub const setAttributes = gtk_directory_list_set_attributes;

    /// Sets the `file` to be enumerated and starts the enumeration.
    ///
    /// If `file` is `NULL`, the result will be an empty list.
    extern fn gtk_directory_list_set_file(p_self: *DirectoryList, p_file: ?*gio.File) void;
    pub const setFile = gtk_directory_list_set_file;

    /// Sets the IO priority to use while loading directories.
    ///
    /// Setting the priority while `self` is loading will reprioritize the
    /// ongoing load as soon as possible.
    ///
    /// The default IO priority is `G_PRIORITY_DEFAULT`, which is higher than
    /// the GTK redraw priority. If you are loading a lot of directories in
    /// parallel, lowering it to something like `G_PRIORITY_DEFAULT_IDLE`
    /// may increase responsiveness.
    extern fn gtk_directory_list_set_io_priority(p_self: *DirectoryList, p_io_priority: c_int) void;
    pub const setIoPriority = gtk_directory_list_set_io_priority;

    /// Sets whether the directory list will monitor the directory
    /// for changes.
    ///
    /// If monitoring is enabled, the ::items-changed signal will
    /// be emitted when the directory contents change.
    ///
    ///
    /// When monitoring is turned on after the initial creation
    /// of the directory list, the directory is reloaded to avoid
    /// missing files that appeared between the initial loading
    /// and when monitoring was turned on.
    extern fn gtk_directory_list_set_monitored(p_self: *DirectoryList, p_monitored: c_int) void;
    pub const setMonitored = gtk_directory_list_set_monitored;

    extern fn gtk_directory_list_get_type() usize;
    pub const getGObjectType = gtk_directory_list_get_type;

    extern fn g_object_ref(p_self: *gtk.DirectoryList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DirectoryList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DirectoryList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDragIcon` is a `GtkRoot` implementation for drag icons.
///
/// A drag icon moves with the pointer during a Drag-and-Drop operation
/// and is destroyed when the drag ends.
///
/// To set up a drag icon and associate it with an ongoing drag operation,
/// use `gtk.DragIcon.getForDrag` to get the icon for a drag. You can
/// then use it like any other widget and use `gtk.DragIcon.setChild`
/// to set whatever widget should be used for the drag icon.
///
/// Keep in mind that drag icons do not allow user input.
pub const DragIcon = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.Root };
    pub const Class = gtk.DragIconClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The widget to display as drag icon.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };
    };

    pub const signals = struct {};

    /// Creates a widget that can be used as a drag icon for the given
    /// `value`.
    ///
    /// Supported types include strings, `GdkRGBA` and `GtkTextBuffer`.
    /// If GTK does not know how to create a widget for a given value,
    /// it will return `NULL`.
    ///
    /// This method is used to set the default drag icon on drag-and-drop
    /// operations started by `GtkDragSource`, so you don't need to set
    /// a drag icon using this function there.
    extern fn gtk_drag_icon_create_widget_for_value(p_value: *const gobject.Value) ?*gtk.Widget;
    pub const createWidgetForValue = gtk_drag_icon_create_widget_for_value;

    /// Creates a `GtkDragIcon` that shows `paintable`, and associates
    /// it with the drag operation.
    ///
    /// The hotspot position on the paintable is aligned with the
    /// hotspot of the cursor.
    extern fn gtk_drag_icon_set_from_paintable(p_drag: *gdk.Drag, p_paintable: *gdk.Paintable, p_hot_x: c_int, p_hot_y: c_int) void;
    pub const setFromPaintable = gtk_drag_icon_set_from_paintable;

    /// Gets the `GtkDragIcon` in use with `drag`.
    ///
    /// If no drag icon exists yet, a new one will be created
    /// and shown.
    extern fn gtk_drag_icon_get_for_drag(p_drag: *gdk.Drag) *gtk.DragIcon;
    pub const getForDrag = gtk_drag_icon_get_for_drag;

    /// Gets the widget currently used as drag icon.
    extern fn gtk_drag_icon_get_child(p_self: *DragIcon) ?*gtk.Widget;
    pub const getChild = gtk_drag_icon_get_child;

    /// Sets the widget to display as the drag icon.
    extern fn gtk_drag_icon_set_child(p_self: *DragIcon, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_drag_icon_set_child;

    extern fn gtk_drag_icon_get_type() usize;
    pub const getGObjectType = gtk_drag_icon_get_type;

    extern fn g_object_ref(p_self: *gtk.DragIcon) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DragIcon) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DragIcon, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDragSource` is an event controller to initiate Drag-And-Drop operations.
///
/// `GtkDragSource` can be set up with the necessary
/// ingredients for a DND operation ahead of time. This includes
/// the source for the data that is being transferred, in the form
/// of a `gdk.ContentProvider`, the desired action, and the icon to
/// use during the drag operation. After setting it up, the drag
/// source must be added to a widget as an event controller, using
/// `gtk.Widget.addController`.
///
/// ```c
/// static void
/// my_widget_init (MyWidget *self)
/// {
///   GtkDragSource *drag_source = gtk_drag_source_new ();
///
///   g_signal_connect (drag_source, "prepare", G_CALLBACK (on_drag_prepare), self);
///   g_signal_connect (drag_source, "drag-begin", G_CALLBACK (on_drag_begin), self);
///
///   gtk_widget_add_controller (GTK_WIDGET (self), GTK_EVENT_CONTROLLER (drag_source));
/// }
/// ```
///
/// Setting up the content provider and icon ahead of time only makes
/// sense when the data does not change. More commonly, you will want
/// to set them up just in time. To do so, `GtkDragSource` has
/// `gtk.DragSource.signals.prepare` and `gtk.DragSource.signals.drag_begin`
/// signals.
///
/// The ::prepare signal is emitted before a drag is started, and
/// can be used to set the content provider and actions that the
/// drag should be started with.
///
/// ```c
/// static GdkContentProvider *
/// on_drag_prepare (GtkDragSource *source,
///                  double         x,
///                  double         y,
///                  MyWidget      *self)
/// {
///   // This widget supports two types of content: GFile objects
///   // and GdkPixbuf objects; GTK will handle the serialization
///   // of these types automatically
///   GFile *file = my_widget_get_file (self);
///   GdkPixbuf *pixbuf = my_widget_get_pixbuf (self);
///
///   return gdk_content_provider_new_union ((GdkContentProvider *[2]) {
///       gdk_content_provider_new_typed (G_TYPE_FILE, file),
///       gdk_content_provider_new_typed (GDK_TYPE_PIXBUF, pixbuf),
///     }, 2);
/// }
/// ```
///
/// The ::drag-begin signal is emitted after the `GdkDrag` object has
/// been created, and can be used to set up the drag icon.
///
/// ```c
/// static void
/// on_drag_begin (GtkDragSource *source,
///                GdkDrag       *drag,
///                MyWidget      *self)
/// {
///   // Set the widget as the drag icon
///   GdkPaintable *paintable = gtk_widget_paintable_new (GTK_WIDGET (self));
///   gtk_drag_source_set_icon (source, paintable, 0, 0);
///   g_object_unref (paintable);
/// }
/// ```
///
/// During the DND operation, `GtkDragSource` emits signals that
/// can be used to obtain updates about the status of the operation,
/// but it is not normally necessary to connect to any signals,
/// except for one case: when the supported actions include
/// `GDK_ACTION_MOVE`, you need to listen for the
/// `gtk.DragSource.signals.drag_end` signal and delete the
/// data after it has been transferred.
pub const DragSource = opaque {
    pub const Parent = gtk.GestureSingle;
    pub const Implements = [_]type{};
    pub const Class = gtk.DragSourceClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The actions that are supported by drag operations from the source.
        ///
        /// Note that you must handle the `gtk.DragSource.signals.drag_end` signal
        /// if the actions include `GDK_ACTION_MOVE`.
        pub const actions = struct {
            pub const name = "actions";

            pub const Type = gdk.DragAction;
        };

        /// The data that is offered by drag operations from this source.
        pub const content = struct {
            pub const name = "content";

            pub const Type = ?*gdk.ContentProvider;
        };
    };

    pub const signals = struct {
        /// Emitted on the drag source when a drag is started.
        ///
        /// It can be used to e.g. set a custom drag icon with
        /// `gtk.DragSource.setIcon`.
        pub const drag_begin = struct {
            pub const name = "drag-begin";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drag: *gdk.Drag, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DragSource, p_instance))),
                    gobject.signalLookup("drag-begin", DragSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drag source when a drag has failed.
        ///
        /// The signal handler may handle a failed drag operation based on
        /// the type of error. It should return `TRUE` if the failure has been handled
        /// and the default "drag operation failed" animation should not be shown.
        pub const drag_cancel = struct {
            pub const name = "drag-cancel";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drag: *gdk.Drag, p_reason: gdk.DragCancelReason, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DragSource, p_instance))),
                    gobject.signalLookup("drag-cancel", DragSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drag source when a drag is finished.
        ///
        /// A typical reason to connect to this signal is to undo
        /// things done in `gtk.DragSource.signals.prepare` or
        /// `gtk.DragSource.signals.drag_begin` handlers.
        pub const drag_end = struct {
            pub const name = "drag-end";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drag: *gdk.Drag, p_delete_data: c_int, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DragSource, p_instance))),
                    gobject.signalLookup("drag-end", DragSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a drag is about to be initiated.
        ///
        /// It returns the `GdkContentProvider` to use for the drag that is about
        /// to start. The default handler for this signal returns the value of
        /// the `gtk.DragSource.properties.content` property, so if you set up that
        /// property ahead of time, you don't need to connect to this signal.
        pub const prepare = struct {
            pub const name = "prepare";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) ?*gdk.ContentProvider, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DragSource, p_instance))),
                    gobject.signalLookup("prepare", DragSource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkDragSource` object.
    extern fn gtk_drag_source_new() *gtk.DragSource;
    pub const new = gtk_drag_source_new;

    /// Cancels a currently ongoing drag operation.
    extern fn gtk_drag_source_drag_cancel(p_source: *DragSource) void;
    pub const dragCancel = gtk_drag_source_drag_cancel;

    /// Gets the actions that are currently set on the `GtkDragSource`.
    extern fn gtk_drag_source_get_actions(p_source: *DragSource) gdk.DragAction;
    pub const getActions = gtk_drag_source_get_actions;

    /// Gets the current content provider of a `GtkDragSource`.
    extern fn gtk_drag_source_get_content(p_source: *DragSource) ?*gdk.ContentProvider;
    pub const getContent = gtk_drag_source_get_content;

    /// Returns the underlying `GdkDrag` object for an ongoing drag.
    extern fn gtk_drag_source_get_drag(p_source: *DragSource) ?*gdk.Drag;
    pub const getDrag = gtk_drag_source_get_drag;

    /// Sets the actions on the `GtkDragSource`.
    ///
    /// During a DND operation, the actions are offered to potential
    /// drop targets. If `actions` include `GDK_ACTION_MOVE`, you need
    /// to listen to the `gtk.DragSource.signals.drag_end` signal and
    /// handle `delete_data` being `TRUE`.
    ///
    /// This function can be called before a drag is started,
    /// or in a handler for the `gtk.DragSource.signals.prepare` signal.
    extern fn gtk_drag_source_set_actions(p_source: *DragSource, p_actions: gdk.DragAction) void;
    pub const setActions = gtk_drag_source_set_actions;

    /// Sets a content provider on a `GtkDragSource`.
    ///
    /// When the data is requested in the cause of a DND operation,
    /// it will be obtained from the content provider.
    ///
    /// This function can be called before a drag is started,
    /// or in a handler for the `gtk.DragSource.signals.prepare` signal.
    ///
    /// You may consider setting the content provider back to
    /// `NULL` in a `gtk.DragSource.signals.drag_end` signal handler.
    extern fn gtk_drag_source_set_content(p_source: *DragSource, p_content: ?*gdk.ContentProvider) void;
    pub const setContent = gtk_drag_source_set_content;

    /// Sets a paintable to use as icon during DND operations.
    ///
    /// The hotspot coordinates determine the point on the icon
    /// that gets aligned with the hotspot of the cursor.
    ///
    /// If `paintable` is `NULL`, a default icon is used.
    ///
    /// This function can be called before a drag is started, or in
    /// a `gtk.DragSource.signals.prepare` or
    /// `gtk.DragSource.signals.drag_begin` signal handler.
    extern fn gtk_drag_source_set_icon(p_source: *DragSource, p_paintable: ?*gdk.Paintable, p_hot_x: c_int, p_hot_y: c_int) void;
    pub const setIcon = gtk_drag_source_set_icon;

    extern fn gtk_drag_source_get_type() usize;
    pub const getGObjectType = gtk_drag_source_get_type;

    extern fn g_object_ref(p_self: *gtk.DragSource) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DragSource) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DragSource, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDrawingArea` is a widget that allows drawing with cairo.
///
/// ![An example GtkDrawingArea](drawingarea.png)
///
/// It’s essentially a blank widget; you can draw on it. After
/// creating a drawing area, the application may want to connect to:
///
/// - The `gtk.Widget.signals.realize` signal to take any necessary actions
///   when the widget is instantiated on a particular display.
///   (Create GDK resources in response to this signal.)
///
/// - The `gtk.DrawingArea.signals.resize` signal to take any necessary
///   actions when the widget changes size.
///
/// - Call `gtk.DrawingArea.setDrawFunc` to handle redrawing the
///   contents of the widget.
///
/// The following code portion demonstrates using a drawing
/// area to display a circle in the normal widget foreground
/// color.
///
/// ## Simple GtkDrawingArea usage
///
/// ```c
/// static void
/// draw_function (GtkDrawingArea *area,
///                cairo_t        *cr,
///                int             width,
///                int             height,
///                gpointer        data)
/// {
///   GdkRGBA color;
///
///   cairo_arc (cr,
///              width / 2.0, height / 2.0,
///              MIN (width, height) / 2.0,
///              0, 2 * G_PI);
///
///   gtk_widget_get_color (GTK_WIDGET (area),
///                         &color);
///   gdk_cairo_set_source_rgba (cr, &color);
///
///   cairo_fill (cr);
/// }
///
/// int
/// main (int argc, char **argv)
/// {
///   gtk_init ();
///
///   GtkWidget *area = gtk_drawing_area_new ();
///   gtk_drawing_area_set_content_width (GTK_DRAWING_AREA (area), 100);
///   gtk_drawing_area_set_content_height (GTK_DRAWING_AREA (area), 100);
///   gtk_drawing_area_set_draw_func (GTK_DRAWING_AREA (area),
///                                   draw_function,
///                                   NULL, NULL);
///   return 0;
/// }
/// ```
///
/// The draw function is normally called when a drawing area first comes
/// onscreen, or when it’s covered by another window and then uncovered.
/// You can also force a redraw by adding to the “damage region” of the
/// drawing area’s window using `gtk.Widget.queueDraw`.
/// This will cause the drawing area to call the draw function again.
///
/// The available routines for drawing are documented in the
/// [Cairo documentation](https://www.cairographics.org/manual/); GDK
/// offers additional API to integrate with Cairo, like `gdk.cairoSetSourceRgba`
/// or `gdk.cairoSetSourcePixbuf`.
///
/// To receive mouse events on a drawing area, you will need to use
/// event controllers. To receive keyboard events, you will need to set
/// the “can-focus” property on the drawing area, and you should probably
/// draw some user-visible indication that the drawing area is focused.
///
/// If you need more complex control over your widget, you should consider
/// creating your own `GtkWidget` subclass.
pub const DrawingArea = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.DrawingAreaClass;
    f_widget: gtk.Widget,

    pub const virtual_methods = struct {
        pub const resize = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_height: c_int) void {
                return gobject.ext.as(DrawingArea.Class, p_class).f_resize.?(gobject.ext.as(DrawingArea, p_area), p_width, p_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_height: c_int) callconv(.C) void) void {
                gobject.ext.as(DrawingArea.Class, p_class).f_resize = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The content height.
        pub const content_height = struct {
            pub const name = "content-height";

            pub const Type = c_int;
        };

        /// The content width.
        pub const content_width = struct {
            pub const name = "content-width";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted once when the widget is realized, and then each time the widget
        /// is changed while realized.
        ///
        /// This is useful in order to keep state up to date with the widget size,
        /// like for instance a backing surface.
        pub const resize = struct {
            pub const name = "resize";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_width: c_int, p_height: c_int, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DrawingArea, p_instance))),
                    gobject.signalLookup("resize", DrawingArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new drawing area.
    extern fn gtk_drawing_area_new() *gtk.DrawingArea;
    pub const new = gtk_drawing_area_new;

    /// Retrieves the content height of the `GtkDrawingArea`.
    extern fn gtk_drawing_area_get_content_height(p_self: *DrawingArea) c_int;
    pub const getContentHeight = gtk_drawing_area_get_content_height;

    /// Retrieves the content width of the `GtkDrawingArea`.
    extern fn gtk_drawing_area_get_content_width(p_self: *DrawingArea) c_int;
    pub const getContentWidth = gtk_drawing_area_get_content_width;

    /// Sets the desired height of the contents of the drawing area.
    ///
    /// Note that because widgets may be allocated larger sizes than they
    /// requested, it is possible that the actual height passed to your draw
    /// function is larger than the height set here. You can use
    /// `gtk.Widget.setValign` to avoid that.
    ///
    /// If the height is set to 0 (the default), the drawing area may disappear.
    extern fn gtk_drawing_area_set_content_height(p_self: *DrawingArea, p_height: c_int) void;
    pub const setContentHeight = gtk_drawing_area_set_content_height;

    /// Sets the desired width of the contents of the drawing area.
    ///
    /// Note that because widgets may be allocated larger sizes than they
    /// requested, it is possible that the actual width passed to your draw
    /// function is larger than the width set here. You can use
    /// `gtk.Widget.setHalign` to avoid that.
    ///
    /// If the width is set to 0 (the default), the drawing area may disappear.
    extern fn gtk_drawing_area_set_content_width(p_self: *DrawingArea, p_width: c_int) void;
    pub const setContentWidth = gtk_drawing_area_set_content_width;

    /// Setting a draw function is the main thing you want to do when using
    /// a drawing area.
    ///
    /// The draw function is called whenever GTK needs to draw the contents
    /// of the drawing area to the screen.
    ///
    /// The draw function will be called during the drawing stage of GTK.
    /// In the drawing stage it is not allowed to change properties of any
    /// GTK widgets or call any functions that would cause any properties
    /// to be changed. You should restrict yourself exclusively to drawing
    /// your contents in the draw function.
    ///
    /// If what you are drawing does change, call `gtk.Widget.queueDraw`
    /// on the drawing area. This will cause a redraw and will call `draw_func` again.
    extern fn gtk_drawing_area_set_draw_func(p_self: *DrawingArea, p_draw_func: ?gtk.DrawingAreaDrawFunc, p_user_data: ?*anyopaque, p_destroy: ?glib.DestroyNotify) void;
    pub const setDrawFunc = gtk_drawing_area_set_draw_func;

    extern fn gtk_drawing_area_get_type() usize;
    pub const getGObjectType = gtk_drawing_area_get_type;

    extern fn g_object_ref(p_self: *gtk.DrawingArea) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DrawingArea) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DrawingArea, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDropControllerMotion` is an event controller tracking
/// the pointer during Drag-and-Drop operations.
///
/// It is modeled after `gtk.EventControllerMotion` so if you
/// have used that, this should feel really familiar.
///
/// This controller is not able to accept drops, use `gtk.DropTarget`
/// for that purpose.
pub const DropControllerMotion = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.DropControllerMotionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the pointer of a Drag-and-Drop operation is in
        /// the controller's widget or a descendant.
        ///
        /// See also `gtk.DropControllerMotion.properties.is_pointer`.
        ///
        /// When handling crossing events, this property is updated
        /// before `gtk.DropControllerMotion.signals.enter`, but after
        /// `gtk.DropControllerMotion.signals.leave` is emitted.
        pub const contains_pointer = struct {
            pub const name = "contains-pointer";

            pub const Type = c_int;
        };

        /// The ongoing drop operation over the controller's widget or
        /// its descendant.
        ///
        /// If no drop operation is going on, this property returns `NULL`.
        ///
        /// The event controller should not modify the `drop`, but it might
        /// want to query its properties.
        ///
        /// When handling crossing events, this property is updated
        /// before `gtk.DropControllerMotion.signals.enter`, but after
        /// `gtk.DropControllerMotion.signals.leave` is emitted.
        pub const drop = struct {
            pub const name = "drop";

            pub const Type = ?*gdk.Drop;
        };

        /// Whether the pointer is in the controllers widget itself,
        /// as opposed to in a descendent widget.
        ///
        /// See also `gtk.DropControllerMotion.properties.contains_pointer`.
        ///
        /// When handling crossing events, this property is updated
        /// before `gtk.DropControllerMotion.signals.enter`, but after
        /// `gtk.DropControllerMotion.signals.leave` is emitted.
        pub const is_pointer = struct {
            pub const name = "is-pointer";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Signals that the pointer has entered the widget.
        pub const enter = struct {
            pub const name = "enter";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropControllerMotion, p_instance))),
                    gobject.signalLookup("enter", DropControllerMotion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signals that the pointer has left the widget.
        pub const leave = struct {
            pub const name = "leave";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropControllerMotion, p_instance))),
                    gobject.signalLookup("leave", DropControllerMotion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the pointer moves inside the widget.
        pub const motion = struct {
            pub const name = "motion";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropControllerMotion, p_instance))),
                    gobject.signalLookup("motion", DropControllerMotion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new event controller that will handle pointer motion
    /// events during drag and drop.
    extern fn gtk_drop_controller_motion_new() *gtk.DropControllerMotion;
    pub const new = gtk_drop_controller_motion_new;

    /// Returns if a Drag-and-Drop operation is within the widget
    /// `self` or one of its children.
    extern fn gtk_drop_controller_motion_contains_pointer(p_self: *DropControllerMotion) c_int;
    pub const containsPointer = gtk_drop_controller_motion_contains_pointer;

    /// Returns the `GdkDrop` of a current Drag-and-Drop operation
    /// over the widget of `self`.
    extern fn gtk_drop_controller_motion_get_drop(p_self: *DropControllerMotion) ?*gdk.Drop;
    pub const getDrop = gtk_drop_controller_motion_get_drop;

    /// Returns if a Drag-and-Drop operation is within the widget
    /// `self`, not one of its children.
    extern fn gtk_drop_controller_motion_is_pointer(p_self: *DropControllerMotion) c_int;
    pub const isPointer = gtk_drop_controller_motion_is_pointer;

    extern fn gtk_drop_controller_motion_get_type() usize;
    pub const getGObjectType = gtk_drop_controller_motion_get_type;

    extern fn g_object_ref(p_self: *gtk.DropControllerMotion) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DropControllerMotion) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DropControllerMotion, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDropDown` is a widget that allows the user to choose an item
/// from a list of options.
///
/// ![An example GtkDropDown](drop-down.png)
///
/// The `GtkDropDown` displays the [selected]`gtk.DropDown.properties.selected`
/// choice.
///
/// The options are given to `GtkDropDown` in the form of `GListModel`
/// and how the individual options are represented is determined by
/// a `gtk.ListItemFactory`. The default factory displays simple strings,
/// and adds a checkmark to the selected item in the popup.
///
/// To set your own factory, use `gtk.DropDown.setFactory`. It is
/// possible to use a separate factory for the items in the popup, with
/// `gtk.DropDown.setListFactory`.
///
/// `GtkDropDown` knows how to obtain strings from the items in a
/// `gtk.StringList`; for other models, you have to provide an expression
/// to find the strings via `gtk.DropDown.setExpression`.
///
/// `GtkDropDown` can optionally allow search in the popup, which is
/// useful if the list of options is long. To enable the search entry,
/// use `gtk.DropDown.setEnableSearch`.
///
/// Here is a UI definition example for `GtkDropDown` with a simple model:
///
/// ```xml
/// <object class="GtkDropDown">
///   <property name="model">
///     <object class="GtkStringList">
///       <items>
///         <item translatable="yes">Factory</item>
///         <item translatable="yes">Home</item>
///         <item translatable="yes">Subway</item>
///       </items>
///     </object>
///   </property>
/// </object>
/// ```
///
/// If a `GtkDropDown` is created in this manner, or with
/// `gtk.DropDown.newFromStrings`, for instance, the object returned from
/// `gtk.DropDown.getSelectedItem` will be a `gtk.StringObject`.
///
/// To learn more about the list widget framework, see the
/// [overview](section-list-widget.html).
///
/// ## CSS nodes
///
/// `GtkDropDown` has a single CSS node with name dropdown,
/// with the button and popover nodes as children.
///
/// ## Accessibility
///
/// `GtkDropDown` uses the `GTK_ACCESSIBLE_ROLE_COMBO_BOX` role.
pub const DropDown = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.DropDownClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether to show a search entry in the popup.
        ///
        /// Note that search requires `gtk.DropDown.properties.expression`
        /// to be set.
        pub const enable_search = struct {
            pub const name = "enable-search";

            pub const Type = c_int;
        };

        /// An expression to evaluate to obtain strings to match against the search
        /// term.
        ///
        /// See `gtk.DropDown.properties.enable_search` for how to enable search.
        /// If `gtk.DropDown.properties.factory` is not set, the expression is also
        /// used to bind strings to labels produced by a default factory.
        pub const expression = struct {
            pub const name = "expression";

            pub const Type = ?*gtk.Expression;
        };

        /// Factory for populating list items.
        pub const factory = struct {
            pub const name = "factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// The factory for creating header widgets for the popup.
        pub const header_factory = struct {
            pub const name = "header-factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// The factory for populating list items in the popup.
        ///
        /// If this is not set, `gtk.DropDown.properties.factory` is used.
        pub const list_factory = struct {
            pub const name = "list-factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// Model for the displayed items.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gio.ListModel;
        };

        /// The match mode for the search filter.
        pub const search_match_mode = struct {
            pub const name = "search-match-mode";

            pub const Type = gtk.StringFilterMatchMode;
        };

        /// The position of the selected item.
        ///
        /// If no item is selected, the property has the value
        /// `GTK_INVALID_LIST_POSITION`.
        pub const selected = struct {
            pub const name = "selected";

            pub const Type = c_uint;
        };

        /// The selected item.
        pub const selected_item = struct {
            pub const name = "selected-item";

            pub const Type = ?*gobject.Object;
        };

        /// Whether to show an arrow within the GtkDropDown widget.
        pub const show_arrow = struct {
            pub const name = "show-arrow";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted to when the drop down is activated.
        ///
        /// The `::activate` signal on `GtkDropDown` is an action signal and
        /// emitting it causes the drop down to pop up its dropdown.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropDown, p_instance))),
                    gobject.signalLookup("activate", DropDown.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkDropDown`.
    ///
    /// You may want to call `gtk.DropDown.setFactory`
    /// to set up a way to map its items to widgets.
    extern fn gtk_drop_down_new(p_model: ?*gio.ListModel, p_expression: ?*gtk.Expression) *gtk.DropDown;
    pub const new = gtk_drop_down_new;

    /// Creates a new `GtkDropDown` that is populated with
    /// the strings.
    extern fn gtk_drop_down_new_from_strings(p_strings: [*]const [*:0]const u8) *gtk.DropDown;
    pub const newFromStrings = gtk_drop_down_new_from_strings;

    /// Returns whether search is enabled.
    extern fn gtk_drop_down_get_enable_search(p_self: *DropDown) c_int;
    pub const getEnableSearch = gtk_drop_down_get_enable_search;

    /// Gets the expression set that is used to obtain strings from items.
    ///
    /// See `gtk.DropDown.setExpression`.
    extern fn gtk_drop_down_get_expression(p_self: *DropDown) ?*gtk.Expression;
    pub const getExpression = gtk_drop_down_get_expression;

    /// Gets the factory that's currently used to populate list items.
    ///
    /// The factory returned by this function is always used for the
    /// item in the button. It is also used for items in the popup
    /// if `gtk.DropDown.properties.list_factory` is not set.
    extern fn gtk_drop_down_get_factory(p_self: *DropDown) ?*gtk.ListItemFactory;
    pub const getFactory = gtk_drop_down_get_factory;

    /// Gets the factory that's currently used to create header widgets for the popup.
    extern fn gtk_drop_down_get_header_factory(p_self: *DropDown) ?*gtk.ListItemFactory;
    pub const getHeaderFactory = gtk_drop_down_get_header_factory;

    /// Gets the factory that's currently used to populate list items in the popup.
    extern fn gtk_drop_down_get_list_factory(p_self: *DropDown) ?*gtk.ListItemFactory;
    pub const getListFactory = gtk_drop_down_get_list_factory;

    /// Gets the model that provides the displayed items.
    extern fn gtk_drop_down_get_model(p_self: *DropDown) ?*gio.ListModel;
    pub const getModel = gtk_drop_down_get_model;

    /// Returns the match mode that the search filter is using.
    extern fn gtk_drop_down_get_search_match_mode(p_self: *DropDown) gtk.StringFilterMatchMode;
    pub const getSearchMatchMode = gtk_drop_down_get_search_match_mode;

    /// Gets the position of the selected item.
    extern fn gtk_drop_down_get_selected(p_self: *DropDown) c_uint;
    pub const getSelected = gtk_drop_down_get_selected;

    /// Gets the selected item. If no item is selected, `NULL` is returned.
    extern fn gtk_drop_down_get_selected_item(p_self: *DropDown) ?*gobject.Object;
    pub const getSelectedItem = gtk_drop_down_get_selected_item;

    /// Returns whether to show an arrow within the widget.
    extern fn gtk_drop_down_get_show_arrow(p_self: *DropDown) c_int;
    pub const getShowArrow = gtk_drop_down_get_show_arrow;

    /// Sets whether a search entry will be shown in the popup that
    /// allows to search for items in the list.
    ///
    /// Note that `gtk.DropDown.properties.expression` must be set for
    /// search to work.
    extern fn gtk_drop_down_set_enable_search(p_self: *DropDown, p_enable_search: c_int) void;
    pub const setEnableSearch = gtk_drop_down_set_enable_search;

    /// Sets the expression that gets evaluated to obtain strings from items.
    ///
    /// This is used for search in the popup. The expression must have
    /// a value type of `G_TYPE_STRING`.
    extern fn gtk_drop_down_set_expression(p_self: *DropDown, p_expression: ?*gtk.Expression) void;
    pub const setExpression = gtk_drop_down_set_expression;

    /// Sets the `GtkListItemFactory` to use for populating list items.
    extern fn gtk_drop_down_set_factory(p_self: *DropDown, p_factory: ?*gtk.ListItemFactory) void;
    pub const setFactory = gtk_drop_down_set_factory;

    /// Sets the `GtkListItemFactory` to use for creating header widgets for the popup.
    extern fn gtk_drop_down_set_header_factory(p_self: *DropDown, p_factory: ?*gtk.ListItemFactory) void;
    pub const setHeaderFactory = gtk_drop_down_set_header_factory;

    /// Sets the `GtkListItemFactory` to use for populating list items in the popup.
    extern fn gtk_drop_down_set_list_factory(p_self: *DropDown, p_factory: ?*gtk.ListItemFactory) void;
    pub const setListFactory = gtk_drop_down_set_list_factory;

    /// Sets the `GListModel` to use.
    extern fn gtk_drop_down_set_model(p_self: *DropDown, p_model: ?*gio.ListModel) void;
    pub const setModel = gtk_drop_down_set_model;

    /// Sets the match mode for the search filter.
    extern fn gtk_drop_down_set_search_match_mode(p_self: *DropDown, p_search_match_mode: gtk.StringFilterMatchMode) void;
    pub const setSearchMatchMode = gtk_drop_down_set_search_match_mode;

    /// Selects the item at the given position.
    extern fn gtk_drop_down_set_selected(p_self: *DropDown, p_position: c_uint) void;
    pub const setSelected = gtk_drop_down_set_selected;

    /// Sets whether an arrow will be displayed within the widget.
    extern fn gtk_drop_down_set_show_arrow(p_self: *DropDown, p_show_arrow: c_int) void;
    pub const setShowArrow = gtk_drop_down_set_show_arrow;

    extern fn gtk_drop_down_get_type() usize;
    pub const getGObjectType = gtk_drop_down_get_type;

    extern fn g_object_ref(p_self: *gtk.DropDown) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DropDown) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DropDown, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDropTarget` is an event controller to receive Drag-and-Drop operations.
///
/// The most basic way to use a `GtkDropTarget` to receive drops on a
/// widget is to create it via `gtk.DropTarget.new`, passing in the
/// `GType` of the data you want to receive and connect to the
/// `gtk.DropTarget.signals.drop` signal to receive the data:
///
/// ```c
/// static gboolean
/// on_drop (GtkDropTarget *target,
///          const GValue  *value,
///          double         x,
///          double         y,
///          gpointer       data)
/// {
///   MyWidget *self = data;
///
///   // Call the appropriate setter depending on the type of data
///   // that we received
///   if (G_VALUE_HOLDS (value, G_TYPE_FILE))
///     my_widget_set_file (self, g_value_get_object (value));
///   else if (G_VALUE_HOLDS (value, GDK_TYPE_PIXBUF))
///     my_widget_set_pixbuf (self, g_value_get_object (value));
///   else
///     return FALSE;
///
///   return TRUE;
/// }
///
/// static void
/// my_widget_init (MyWidget *self)
/// {
///   GtkDropTarget *target =
///     gtk_drop_target_new (G_TYPE_INVALID, GDK_ACTION_COPY);
///
///   // This widget accepts two types of drop types: GFile objects
///   // and GdkPixbuf objects
///   gtk_drop_target_set_gtypes (target, (GType [2]) {
///     G_TYPE_FILE,
///     GDK_TYPE_PIXBUF,
///   }, 2);
///
///   g_signal_connect (target, "drop", G_CALLBACK (on_drop), self);
///   gtk_widget_add_controller (GTK_WIDGET (self), GTK_EVENT_CONTROLLER (target));
/// }
/// ```
///
/// `GtkDropTarget` supports more options, such as:
///
///  * rejecting potential drops via the `gtk.DropTarget.signals.accept` signal
///    and the `gtk.DropTarget.reject` function to let other drop
///    targets handle the drop
///  * tracking an ongoing drag operation before the drop via the
///    `gtk.DropTarget.signals.enter`, `gtk.DropTarget.signals.motion` and
///    `gtk.DropTarget.signals.leave` signals
///  * configuring how to receive data by setting the
///    `gtk.DropTarget.properties.preload` property and listening for its
///    availability via the `gtk.DropTarget.properties.value` property
///
/// However, `GtkDropTarget` is ultimately modeled in a synchronous way
/// and only supports data transferred via `GType`. If you want full control
/// over an ongoing drop, the `gtk.DropTargetAsync` object gives you
/// this ability.
///
/// While a pointer is dragged over the drop target's widget and the drop
/// has not been rejected, that widget will receive the
/// `GTK_STATE_FLAG_DROP_ACTIVE` state, which can be used to style the widget.
///
/// If you are not interested in receiving the drop, but just want to update
/// UI state during a Drag-and-Drop operation (e.g. switching tabs), you can
/// use `gtk.DropControllerMotion`.
pub const DropTarget = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.DropTargetClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GdkDragActions` that this drop target supports.
        pub const actions = struct {
            pub const name = "actions";

            pub const Type = gdk.DragAction;
        };

        /// The `GdkDrop` that is currently being performed.
        pub const current_drop = struct {
            pub const name = "current-drop";

            pub const Type = ?*gdk.Drop;
        };

        /// The `GdkDrop` that is currently being performed.
        pub const drop = struct {
            pub const name = "drop";

            pub const Type = ?*gdk.Drop;
        };

        /// The `GdkContentFormats` that determine the supported data formats.
        pub const formats = struct {
            pub const name = "formats";

            pub const Type = ?*gdk.ContentFormats;
        };

        /// Whether the drop data should be preloaded when the pointer is only
        /// hovering over the widget but has not been released.
        ///
        /// Setting this property allows finer grained reaction to an ongoing
        /// drop at the cost of loading more data.
        ///
        /// The default value for this property is `FALSE` to avoid downloading
        /// huge amounts of data by accident.
        ///
        /// For example, if somebody drags a full document of gigabytes of text
        /// from a text editor across a widget with a preloading drop target,
        /// this data will be downloaded, even if the data is ultimately dropped
        /// elsewhere.
        ///
        /// For a lot of data formats, the amount of data is very small (like
        /// `GDK_TYPE_RGBA`), so enabling this property does not hurt at all.
        /// And for local-only Drag-and-Drop operations, no data transfer is done,
        /// so enabling it there is free.
        pub const preload = struct {
            pub const name = "preload";

            pub const Type = c_int;
        };

        /// The value for this drop operation.
        ///
        /// This is `NULL` if the data has not been loaded yet or no drop
        /// operation is going on.
        ///
        /// Data may be available before the `gtk.DropTarget.signals.drop`
        /// signal gets emitted - for example when the `gtk.DropTarget.properties.preload`
        /// property is set. You can use the ::notify signal to be notified
        /// of available data.
        pub const value = struct {
            pub const name = "value";

            pub const Type = ?*gobject.Value;
        };
    };

    pub const signals = struct {
        /// Emitted on the drop site when a drop operation is about to begin.
        ///
        /// If the drop is not accepted, `FALSE` will be returned and the drop target
        /// will ignore the drop. If `TRUE` is returned, the drop is accepted for now
        /// but may be rejected later via a call to `gtk.DropTarget.reject`
        /// or ultimately by returning `FALSE` from a `gtk.DropTarget.signals.drop`
        /// handler.
        ///
        /// The default handler for this signal decides whether to accept the drop
        /// based on the formats provided by the `drop`.
        ///
        /// If the decision whether the drop will be accepted or rejected depends
        /// on the data, this function should return `TRUE`, the
        /// `gtk.DropTarget.properties.preload` property should be set and the value
        /// should be inspected via the ::notify:value signal, calling
        /// `gtk.DropTarget.reject` if required.
        pub const accept = struct {
            pub const name = "accept";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drop: *gdk.Drop, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTarget, p_instance))),
                    gobject.signalLookup("accept", DropTarget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drop site when the user drops the data onto the widget.
        ///
        /// The signal handler must determine whether the pointer position is in
        /// a drop zone or not. If it is not in a drop zone, it returns `FALSE`
        /// and no further processing is necessary.
        ///
        /// Otherwise, the handler returns `TRUE`. In this case, this handler will
        /// accept the drop. The handler is responsible for using the given `value`
        /// and performing the drop operation.
        pub const drop = struct {
            pub const name = "drop";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_value: *gobject.Value, p_x: f64, p_y: f64, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTarget, p_instance))),
                    gobject.signalLookup("drop", DropTarget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drop site when the pointer enters the widget.
        ///
        /// It can be used to set up custom highlighting.
        pub const enter = struct {
            pub const name = "enter";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) gdk.DragAction, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTarget, p_instance))),
                    gobject.signalLookup("enter", DropTarget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drop site when the pointer leaves the widget.
        ///
        /// Its main purpose it to undo things done in
        /// `gtk.DropTarget.signals.enter`.
        pub const leave = struct {
            pub const name = "leave";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTarget, p_instance))),
                    gobject.signalLookup("leave", DropTarget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted while the pointer is moving over the drop target.
        pub const motion = struct {
            pub const name = "motion";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) gdk.DragAction, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTarget, p_instance))),
                    gobject.signalLookup("motion", DropTarget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkDropTarget` object.
    ///
    /// If the drop target should support more than 1 type, pass
    /// `G_TYPE_INVALID` for `type` and then call
    /// `gtk.DropTarget.setGtypes`.
    extern fn gtk_drop_target_new(p_type: usize, p_actions: gdk.DragAction) *gtk.DropTarget;
    pub const new = gtk_drop_target_new;

    /// Gets the actions that this drop target supports.
    extern fn gtk_drop_target_get_actions(p_self: *DropTarget) gdk.DragAction;
    pub const getActions = gtk_drop_target_get_actions;

    /// Gets the currently handled drop operation.
    ///
    /// If no drop operation is going on, `NULL` is returned.
    extern fn gtk_drop_target_get_current_drop(p_self: *DropTarget) ?*gdk.Drop;
    pub const getCurrentDrop = gtk_drop_target_get_current_drop;

    /// Gets the currently handled drop operation.
    ///
    /// If no drop operation is going on, `NULL` is returned.
    extern fn gtk_drop_target_get_drop(p_self: *DropTarget) ?*gdk.Drop;
    pub const getDrop = gtk_drop_target_get_drop;

    /// Gets the data formats that this drop target accepts.
    ///
    /// If the result is `NULL`, all formats are expected to be supported.
    extern fn gtk_drop_target_get_formats(p_self: *DropTarget) ?*gdk.ContentFormats;
    pub const getFormats = gtk_drop_target_get_formats;

    /// Gets the list of supported `GType`s that can be dropped on the target.
    ///
    /// If no types have been set, `NULL` will be returned.
    extern fn gtk_drop_target_get_gtypes(p_self: *DropTarget, p_n_types: ?*usize) ?[*]const usize;
    pub const getGtypes = gtk_drop_target_get_gtypes;

    /// Gets whether data should be preloaded on hover.
    extern fn gtk_drop_target_get_preload(p_self: *DropTarget) c_int;
    pub const getPreload = gtk_drop_target_get_preload;

    /// Gets the current drop data, as a `GValue`.
    extern fn gtk_drop_target_get_value(p_self: *DropTarget) ?*const gobject.Value;
    pub const getValue = gtk_drop_target_get_value;

    /// Rejects the ongoing drop operation.
    ///
    /// If no drop operation is ongoing, i.e when `gtk.DropTarget.properties.current_drop`
    /// is `NULL`, this function does nothing.
    ///
    /// This function should be used when delaying the decision
    /// on whether to accept a drag or not until after reading
    /// the data.
    extern fn gtk_drop_target_reject(p_self: *DropTarget) void;
    pub const reject = gtk_drop_target_reject;

    /// Sets the actions that this drop target supports.
    extern fn gtk_drop_target_set_actions(p_self: *DropTarget, p_actions: gdk.DragAction) void;
    pub const setActions = gtk_drop_target_set_actions;

    /// Sets the supported `GType`s for this drop target.
    extern fn gtk_drop_target_set_gtypes(p_self: *DropTarget, p_types: ?[*]usize, p_n_types: usize) void;
    pub const setGtypes = gtk_drop_target_set_gtypes;

    /// Sets whether data should be preloaded on hover.
    extern fn gtk_drop_target_set_preload(p_self: *DropTarget, p_preload: c_int) void;
    pub const setPreload = gtk_drop_target_set_preload;

    extern fn gtk_drop_target_get_type() usize;
    pub const getGObjectType = gtk_drop_target_get_type;

    extern fn g_object_ref(p_self: *gtk.DropTarget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DropTarget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DropTarget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkDropTargetAsync` is an event controller to receive Drag-and-Drop
/// operations, asynchronously.
///
/// It is the more complete but also more complex method of handling drop
/// operations compared to `gtk.DropTarget`, and you should only use
/// it if `GtkDropTarget` doesn't provide all the features you need.
///
/// To use a `GtkDropTargetAsync` to receive drops on a widget, you create
/// a `GtkDropTargetAsync` object, configure which data formats and actions
/// you support, connect to its signals, and then attach it to the widget
/// with `gtk.Widget.addController`.
///
/// During a drag operation, the first signal that a `GtkDropTargetAsync`
/// emits is `gtk.DropTargetAsync.signals.accept`, which is meant to determine
/// whether the target is a possible drop site for the ongoing drop. The
/// default handler for the ::accept signal accepts the drop if it finds
/// a compatible data format and an action that is supported on both sides.
///
/// If it is, and the widget becomes a target, you will receive a
/// `gtk.DropTargetAsync.signals.drag_enter` signal, followed by
/// `gtk.DropTargetAsync.signals.drag_motion` signals as the pointer moves,
/// optionally a `gtk.DropTargetAsync.signals.drop` signal when a drop happens,
/// and finally a `gtk.DropTargetAsync.signals.drag_leave` signal when the
/// pointer moves off the widget.
///
/// The ::drag-enter and ::drag-motion handler return a `GdkDragAction`
/// to update the status of the ongoing operation. The ::drop handler
/// should decide if it ultimately accepts the drop and if it does, it
/// should initiate the data transfer and finish the operation by calling
/// `gdk.Drop.finish`.
///
/// Between the ::drag-enter and ::drag-leave signals the widget is a
/// current drop target, and will receive the `GTK_STATE_FLAG_DROP_ACTIVE`
/// state, which can be used by themes to style the widget as a drop target.
pub const DropTargetAsync = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.DropTargetAsyncClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GdkDragActions` that this drop target supports.
        pub const actions = struct {
            pub const name = "actions";

            pub const Type = gdk.DragAction;
        };

        /// The `GdkContentFormats` that determines the supported data formats.
        pub const formats = struct {
            pub const name = "formats";

            pub const Type = ?*gdk.ContentFormats;
        };
    };

    pub const signals = struct {
        /// Emitted on the drop site when a drop operation is about to begin.
        ///
        /// If the drop is not accepted, `FALSE` will be returned and the drop target
        /// will ignore the drop. If `TRUE` is returned, the drop is accepted for now
        /// but may be rejected later via a call to `gtk.DropTargetAsync.rejectDrop`
        /// or ultimately by returning `FALSE` from a `gtk.DropTargetAsync.signals.drop`
        /// handler.
        ///
        /// The default handler for this signal decides whether to accept the drop
        /// based on the formats provided by the `drop`.
        ///
        /// If the decision whether the drop will be accepted or rejected needs
        /// further processing, such as inspecting the data, this function should
        /// return `TRUE` and proceed as is `drop` was accepted and if it decides to
        /// reject the drop later, it should call `gtk.DropTargetAsync.rejectDrop`.
        pub const accept = struct {
            pub const name = "accept";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drop: *gdk.Drop, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTargetAsync, p_instance))),
                    gobject.signalLookup("accept", DropTargetAsync.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drop site when the pointer enters the widget.
        ///
        /// It can be used to set up custom highlighting.
        pub const drag_enter = struct {
            pub const name = "drag-enter";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drop: *gdk.Drop, p_x: f64, p_y: f64, P_Data) callconv(.C) gdk.DragAction, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTargetAsync, p_instance))),
                    gobject.signalLookup("drag-enter", DropTargetAsync.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drop site when the pointer leaves the widget.
        ///
        /// Its main purpose it to undo things done in
        /// `GtkDropTargetAsync`::drag-enter.
        pub const drag_leave = struct {
            pub const name = "drag-leave";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drop: *gdk.Drop, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTargetAsync, p_instance))),
                    gobject.signalLookup("drag-leave", DropTargetAsync.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted while the pointer is moving over the drop target.
        pub const drag_motion = struct {
            pub const name = "drag-motion";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drop: *gdk.Drop, p_x: f64, p_y: f64, P_Data) callconv(.C) gdk.DragAction, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTargetAsync, p_instance))),
                    gobject.signalLookup("drag-motion", DropTargetAsync.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the drop site when the user drops the data onto the widget.
        ///
        /// The signal handler must determine whether the pointer position is in a
        /// drop zone or not. If it is not in a drop zone, it returns `FALSE` and no
        /// further processing is necessary.
        ///
        /// Otherwise, the handler returns `TRUE`. In this case, this handler will
        /// accept the drop. The handler must ensure that `gdk.Drop.finish`
        /// is called to let the source know that the drop is done. The call to
        /// `gdk.Drop.finish` must only be done when all data has been received.
        ///
        /// To receive the data, use one of the read functions provided by
        /// `gdk.Drop` such as `gdk.Drop.readAsync` or
        /// `gdk.Drop.readValueAsync`.
        pub const drop = struct {
            pub const name = "drop";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_drop: *gdk.Drop, p_x: f64, p_y: f64, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(DropTargetAsync, p_instance))),
                    gobject.signalLookup("drop", DropTargetAsync.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkDropTargetAsync` object.
    extern fn gtk_drop_target_async_new(p_formats: ?*gdk.ContentFormats, p_actions: gdk.DragAction) *gtk.DropTargetAsync;
    pub const new = gtk_drop_target_async_new;

    /// Gets the actions that this drop target supports.
    extern fn gtk_drop_target_async_get_actions(p_self: *DropTargetAsync) gdk.DragAction;
    pub const getActions = gtk_drop_target_async_get_actions;

    /// Gets the data formats that this drop target accepts.
    ///
    /// If the result is `NULL`, all formats are expected to be supported.
    extern fn gtk_drop_target_async_get_formats(p_self: *DropTargetAsync) ?*gdk.ContentFormats;
    pub const getFormats = gtk_drop_target_async_get_formats;

    /// Sets the `drop` as not accepted on this drag site.
    ///
    /// This function should be used when delaying the decision
    /// on whether to accept a drag or not until after reading
    /// the data.
    extern fn gtk_drop_target_async_reject_drop(p_self: *DropTargetAsync, p_drop: *gdk.Drop) void;
    pub const rejectDrop = gtk_drop_target_async_reject_drop;

    /// Sets the actions that this drop target supports.
    extern fn gtk_drop_target_async_set_actions(p_self: *DropTargetAsync, p_actions: gdk.DragAction) void;
    pub const setActions = gtk_drop_target_async_set_actions;

    /// Sets the data formats that this drop target will accept.
    extern fn gtk_drop_target_async_set_formats(p_self: *DropTargetAsync, p_formats: ?*gdk.ContentFormats) void;
    pub const setFormats = gtk_drop_target_async_set_formats;

    extern fn gtk_drop_target_async_get_type() usize;
    pub const getGObjectType = gtk_drop_target_async_get_type;

    extern fn g_object_ref(p_self: *gtk.DropTargetAsync) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.DropTargetAsync) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DropTargetAsync, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkEditableLabel` is a label that allows users to
/// edit the text by switching to an “edit mode”.
///
/// ![An example GtkEditableLabel](editable-label.png)
///
/// `GtkEditableLabel` does not have API of its own, but it
/// implements the `gtk.Editable` interface.
///
/// The default bindings for activating the edit mode is
/// to click or press the Enter key. The default bindings
/// for leaving the edit mode are the Enter key (to save
/// the results) or the Escape key (to cancel the editing).
///
/// # Shortcuts and Gestures
///
/// `GtkEditableLabel` supports the following keyboard shortcuts:
///
/// - <kbd>Enter</kbd> starts editing.
/// - <kbd>Escape</kbd> stops editing.
///
/// # Actions
///
/// `GtkEditableLabel` defines a set of built-in actions:
///
/// - `editing.starts` switches the widget into editing mode.
/// - `editing.stop` switches the widget out of editing mode.
///
/// # CSS nodes
///
/// ```
/// editablelabel[.editing]
/// ╰── stack
///     ├── label
///     ╰── text
/// ```
///
/// `GtkEditableLabel` has a main node with the name editablelabel.
/// When the entry is in editing mode, it gets the .editing style
/// class.
///
/// For all the subnodes added to the text node in various situations,
/// see `gtk.Text`.
pub const EditableLabel = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Editable };
    pub const Class = gtk.EditableLabelClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// This property is `TRUE` while the widget is in edit mode.
        pub const editing = struct {
            pub const name = "editing";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkEditableLabel` widget.
    extern fn gtk_editable_label_new(p_str: [*:0]const u8) *gtk.EditableLabel;
    pub const new = gtk_editable_label_new;

    /// Returns whether the label is currently in “editing mode”.
    extern fn gtk_editable_label_get_editing(p_self: *EditableLabel) c_int;
    pub const getEditing = gtk_editable_label_get_editing;

    /// Switches the label into “editing mode”.
    extern fn gtk_editable_label_start_editing(p_self: *EditableLabel) void;
    pub const startEditing = gtk_editable_label_start_editing;

    /// Switches the label out of “editing mode”.
    ///
    /// If `commit` is `TRUE`, the resulting text is kept as the
    /// `gtk.Editable.properties.text` property value, otherwise the
    /// resulting text is discarded and the label will keep its
    /// previous `gtk.Editable.properties.text` property value.
    extern fn gtk_editable_label_stop_editing(p_self: *EditableLabel, p_commit: c_int) void;
    pub const stopEditing = gtk_editable_label_stop_editing;

    extern fn gtk_editable_label_get_type() usize;
    pub const getGObjectType = gtk_editable_label_get_type;

    extern fn g_object_ref(p_self: *gtk.EditableLabel) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EditableLabel) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EditableLabel, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkEmojiChooser` is used by text widgets such as `GtkEntry` or
/// `GtkTextView` to let users insert Emoji characters.
///
/// ![An example GtkEmojiChooser](emojichooser.png)
///
/// `GtkEmojiChooser` emits the `gtk.EmojiChooser.signals.emoji_picked`
/// signal when an Emoji is selected.
///
/// # Shortcuts and Gestures
///
/// `GtkEmojiChooser` supports the following keyboard shortcuts:
///
/// - <kbd>Ctrl</kbd>+<kbd>N</kbd> scrolls th the next section.
/// - <kbd>Ctrl</kbd>+<kbd>P</kbd> scrolls th the previous section.
///
/// # Actions
///
/// `GtkEmojiChooser` defines a set of built-in actions:
///
/// - `scroll.section` scrolls to the next or previous section.
///
/// # CSS nodes
///
/// ```
/// popover
/// ├── box.emoji-searchbar
/// │   ╰── entry.search
/// ╰── box.emoji-toolbar
///     ├── button.image-button.emoji-section
///     ├── ...
///     ╰── button.image-button.emoji-section
/// ```
///
/// Every `GtkEmojiChooser` consists of a main node called popover.
/// The contents of the popover are largely implementation defined
/// and supposed to inherit general styles.
/// The top searchbar used to search emoji and gets the .emoji-searchbar
/// style class itself.
/// The bottom toolbar used to switch between different emoji categories
/// consists of buttons with the .emoji-section style class and gets the
/// .emoji-toolbar style class itself.
pub const EmojiChooser = opaque {
    pub const Parent = gtk.Popover;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Native, gtk.ShortcutManager };
    pub const Class = gtk.EmojiChooserClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted when the user selects an Emoji.
        pub const emoji_picked = struct {
            pub const name = "emoji-picked";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_text: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EmojiChooser, p_instance))),
                    gobject.signalLookup("emoji-picked", EmojiChooser.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkEmojiChooser`.
    extern fn gtk_emoji_chooser_new() *gtk.EmojiChooser;
    pub const new = gtk_emoji_chooser_new;

    extern fn gtk_emoji_chooser_get_type() usize;
    pub const getGObjectType = gtk_emoji_chooser_get_type;

    extern fn g_object_ref(p_self: *gtk.EmojiChooser) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EmojiChooser) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EmojiChooser, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEntry` is a single line text entry widget.
///
/// ![An example GtkEntry](entry.png)
///
/// A fairly large set of key bindings are supported by default. If the
/// entered text is longer than the allocation of the widget, the widget
/// will scroll so that the cursor position is visible.
///
/// When using an entry for passwords and other sensitive information, it
/// can be put into “password mode” using `gtk.Entry.setVisibility`.
/// In this mode, entered text is displayed using a “invisible” character.
/// By default, GTK picks the best invisible character that is available
/// in the current font, but it can be changed with
/// `gtk.Entry.setInvisibleChar`.
///
/// `GtkEntry` has the ability to display progress or activity
/// information behind the text. To make an entry display such information,
/// use `gtk.Entry.setProgressFraction` or
/// `gtk.Entry.setProgressPulseStep`.
///
/// Additionally, `GtkEntry` can show icons at either side of the entry.
/// These icons can be activatable by clicking, can be set up as drag source
/// and can have tooltips. To add an icon, use
/// `gtk.Entry.setIconFromGicon` or one of the various other functions
/// that set an icon from an icon name or a paintable. To trigger an action when
/// the user clicks an icon, connect to the `gtk.Entry.signals.icon_press` signal.
/// To allow DND operations from an icon, use
/// `gtk.Entry.setIconDragSource`. To set a tooltip on an icon, use
/// `gtk.Entry.setIconTooltipText` or the corresponding function
/// for markup.
///
/// Note that functionality or information that is only available by clicking
/// on an icon in an entry may not be accessible at all to users which are not
/// able to use a mouse or other pointing device. It is therefore recommended
/// that any such functionality should also be available by other means, e.g.
/// via the context menu of the entry.
///
/// # CSS nodes
///
/// ```
/// entry[.flat][.warning][.error]
/// ├── text[.readonly]
/// ├── image.left
/// ├── image.right
/// ╰── [progress[.pulse]]
/// ```
///
/// `GtkEntry` has a main node with the name entry. Depending on the properties
/// of the entry, the style classes .read-only and .flat may appear. The style
/// classes .warning and .error may also be used with entries.
///
/// When the entry shows icons, it adds subnodes with the name image and the
/// style class .left or .right, depending on where the icon appears.
///
/// When the entry shows progress, it adds a subnode with the name progress.
/// The node has the style class .pulse when the shown progress is pulsing.
///
/// For all the subnodes added to the text node in various situations,
/// see `gtk.Text`.
///
/// # GtkEntry as GtkBuildable
///
/// The `GtkEntry` implementation of the `GtkBuildable` interface supports a
/// custom `<attributes>` element, which supports any number of `<attribute>`
/// elements. The `<attribute>` element has attributes named “name“, “value“,
/// “start“ and “end“ and allows you to specify `PangoAttribute` values for
/// this label.
///
/// An example of a UI definition fragment specifying Pango attributes:
/// ```xml
/// <object class="GtkEntry">
///   <attributes>
///     <attribute name="weight" value="PANGO_WEIGHT_BOLD"/>
///     <attribute name="background" value="red" start="5" end="10"/>
///   </attributes>
/// </object>
/// ```
///
/// The start and end attributes specify the range of characters to which the
/// Pango attribute applies. If start and end are not specified, the attribute
/// is applied to the whole text. Note that specifying ranges does not make much
/// sense with translatable attributes. Use markup embedded in the translatable
/// content instead.
///
/// # Accessibility
///
/// `GtkEntry` uses the `GTK_ACCESSIBLE_ROLE_TEXT_BOX` role.
pub const Entry = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.CellEditable, gtk.ConstraintTarget, gtk.Editable };
    pub const Class = gtk.EntryClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        /// Class handler for the `GtkEntry::activate` signal. The default
        ///   implementation activates the gtk.activate-default action.
        pub const activate = struct {
            pub fn call(p_class: anytype, p_entry: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Entry.Class, p_class).f_activate.?(gobject.ext.as(Entry, p_entry));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_entry: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Entry.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// Whether to activate the default widget when Enter is pressed.
        pub const activates_default = struct {
            pub const name = "activates-default";

            pub const Type = c_int;
        };

        /// A list of Pango attributes to apply to the text of the entry.
        ///
        /// This is mainly useful to change the size or weight of the text.
        ///
        /// The `PangoAttribute`'s `start_index` and `end_index` must refer to the
        /// `gtk.EntryBuffer` text, i.e. without the preedit string.
        pub const attributes = struct {
            pub const name = "attributes";

            pub const Type = ?*pango.AttrList;
        };

        /// The buffer object which actually stores the text.
        pub const buffer = struct {
            pub const name = "buffer";

            pub const Type = ?*gtk.EntryBuffer;
        };

        /// The auxiliary completion object to use with the entry.
        pub const completion = struct {
            pub const name = "completion";

            pub const Type = ?*gtk.EntryCompletion;
        };

        /// Whether to suggest Emoji replacements for :-delimited names
        /// like `:heart:`.
        pub const enable_emoji_completion = struct {
            pub const name = "enable-emoji-completion";

            pub const Type = c_int;
        };

        /// A menu model whose contents will be appended to the context menu.
        pub const extra_menu = struct {
            pub const name = "extra-menu";

            pub const Type = ?*gio.MenuModel;
        };

        /// Whether the entry should draw a frame.
        pub const has_frame = struct {
            pub const name = "has-frame";

            pub const Type = c_int;
        };

        /// Which IM (input method) module should be used for this entry.
        ///
        /// See `gtk.IMContext`.
        ///
        /// Setting this to a non-`NULL` value overrides the system-wide IM
        /// module setting. See the GtkSettings `gtk.Settings.properties.gtk_im_module`
        /// property.
        pub const im_module = struct {
            pub const name = "im-module";

            pub const Type = ?[*:0]u8;
        };

        /// Additional hints that allow input methods to fine-tune their behavior.
        ///
        /// Also see `gtk.Entry.properties.input_purpose`
        pub const input_hints = struct {
            pub const name = "input-hints";

            pub const Type = gtk.InputHints;
        };

        /// The purpose of this text field.
        ///
        /// This property can be used by on-screen keyboards and other input
        /// methods to adjust their behaviour.
        ///
        /// Note that setting the purpose to `GTK_INPUT_PURPOSE_PASSWORD` or
        /// `GTK_INPUT_PURPOSE_PIN` is independent from setting
        /// `gtk.Entry.properties.visibility`.
        pub const input_purpose = struct {
            pub const name = "input-purpose";

            pub const Type = gtk.InputPurpose;
        };

        /// The character to use when masking entry contents (“password mode”).
        pub const invisible_char = struct {
            pub const name = "invisible-char";

            pub const Type = c_uint;
        };

        /// Whether the invisible char has been set for the `GtkEntry`.
        pub const invisible_char_set = struct {
            pub const name = "invisible-char-set";

            pub const Type = c_int;
        };

        /// Maximum number of characters for this entry.
        pub const max_length = struct {
            pub const name = "max-length";

            pub const Type = c_int;
        };

        /// If text is overwritten when typing in the `GtkEntry`.
        pub const overwrite_mode = struct {
            pub const name = "overwrite-mode";

            pub const Type = c_int;
        };

        /// The text that will be displayed in the `GtkEntry` when it is empty
        /// and unfocused.
        pub const placeholder_text = struct {
            pub const name = "placeholder-text";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the primary icon is activatable.
        ///
        /// GTK emits the `gtk.Entry.signals.icon_press` and
        /// `gtk.Entry.signals.icon_release` signals only on sensitive,
        /// activatable icons.
        ///
        /// Sensitive, but non-activatable icons can be used for purely
        /// informational purposes.
        pub const primary_icon_activatable = struct {
            pub const name = "primary-icon-activatable";

            pub const Type = c_int;
        };

        /// The `GIcon` to use for the primary icon for the entry.
        pub const primary_icon_gicon = struct {
            pub const name = "primary-icon-gicon";

            pub const Type = ?*gio.Icon;
        };

        /// The icon name to use for the primary icon for the entry.
        pub const primary_icon_name = struct {
            pub const name = "primary-icon-name";

            pub const Type = ?[*:0]u8;
        };

        /// A `GdkPaintable` to use as the primary icon for the entry.
        pub const primary_icon_paintable = struct {
            pub const name = "primary-icon-paintable";

            pub const Type = ?*gdk.Paintable;
        };

        /// Whether the primary icon is sensitive.
        ///
        /// An insensitive icon appears grayed out. GTK does not emit the
        /// `gtk.Entry.signals.icon_press` and `gtk.Entry.signals.icon_release`
        /// signals and does not allow DND from insensitive icons.
        ///
        /// An icon should be set insensitive if the action that would trigger
        /// when clicked is currently not available.
        pub const primary_icon_sensitive = struct {
            pub const name = "primary-icon-sensitive";

            pub const Type = c_int;
        };

        /// The representation which is used for the primary icon of the entry.
        pub const primary_icon_storage_type = struct {
            pub const name = "primary-icon-storage-type";

            pub const Type = gtk.ImageType;
        };

        /// The contents of the tooltip on the primary icon, with markup.
        ///
        /// Also see `gtk.Entry.setIconTooltipMarkup`.
        pub const primary_icon_tooltip_markup = struct {
            pub const name = "primary-icon-tooltip-markup";

            pub const Type = ?[*:0]u8;
        };

        /// The contents of the tooltip on the primary icon.
        ///
        /// Also see `gtk.Entry.setIconTooltipText`.
        pub const primary_icon_tooltip_text = struct {
            pub const name = "primary-icon-tooltip-text";

            pub const Type = ?[*:0]u8;
        };

        /// The current fraction of the task that's been completed.
        pub const progress_fraction = struct {
            pub const name = "progress-fraction";

            pub const Type = f64;
        };

        /// The fraction of total entry width to move the progress
        /// bouncing block for each pulse.
        ///
        /// See `gtk.Entry.progressPulse`.
        pub const progress_pulse_step = struct {
            pub const name = "progress-pulse-step";

            pub const Type = f64;
        };

        /// Number of pixels of the entry scrolled off the screen to the left.
        pub const scroll_offset = struct {
            pub const name = "scroll-offset";

            pub const Type = c_int;
        };

        /// Whether the secondary icon is activatable.
        ///
        /// GTK emits the `gtk.Entry.signals.icon_press` and
        /// `gtk.Entry.signals.icon_release` signals only on sensitive,
        /// activatable icons.
        ///
        /// Sensitive, but non-activatable icons can be used for purely
        /// informational purposes.
        pub const secondary_icon_activatable = struct {
            pub const name = "secondary-icon-activatable";

            pub const Type = c_int;
        };

        /// The `GIcon` to use for the secondary icon for the entry.
        pub const secondary_icon_gicon = struct {
            pub const name = "secondary-icon-gicon";

            pub const Type = ?*gio.Icon;
        };

        /// The icon name to use for the secondary icon for the entry.
        pub const secondary_icon_name = struct {
            pub const name = "secondary-icon-name";

            pub const Type = ?[*:0]u8;
        };

        /// A `GdkPaintable` to use as the secondary icon for the entry.
        pub const secondary_icon_paintable = struct {
            pub const name = "secondary-icon-paintable";

            pub const Type = ?*gdk.Paintable;
        };

        /// Whether the secondary icon is sensitive.
        ///
        /// An insensitive icon appears grayed out. GTK does not emit the
        /// `gtk.Entry.signals.@"icon_press[ and [signal@Gtk.Entry::icon_release"`
        /// signals and does not allow DND from insensitive icons.
        ///
        /// An icon should be set insensitive if the action that would trigger
        /// when clicked is currently not available.
        pub const secondary_icon_sensitive = struct {
            pub const name = "secondary-icon-sensitive";

            pub const Type = c_int;
        };

        /// The representation which is used for the secondary icon of the entry.
        pub const secondary_icon_storage_type = struct {
            pub const name = "secondary-icon-storage-type";

            pub const Type = gtk.ImageType;
        };

        /// The contents of the tooltip on the secondary icon, with markup.
        ///
        /// Also see `gtk.Entry.setIconTooltipMarkup`.
        pub const secondary_icon_tooltip_markup = struct {
            pub const name = "secondary-icon-tooltip-markup";

            pub const Type = ?[*:0]u8;
        };

        /// The contents of the tooltip on the secondary icon.
        ///
        /// Also see `gtk.Entry.setIconTooltipText`.
        pub const secondary_icon_tooltip_text = struct {
            pub const name = "secondary-icon-tooltip-text";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the entry will show an Emoji icon in the secondary icon position
        /// to open the Emoji chooser.
        pub const show_emoji_icon = struct {
            pub const name = "show-emoji-icon";

            pub const Type = c_int;
        };

        /// A list of tabstops to apply to the text of the entry.
        pub const tabs = struct {
            pub const name = "tabs";

            pub const Type = ?*pango.TabArray;
        };

        /// The length of the text in the `GtkEntry`.
        pub const text_length = struct {
            pub const name = "text-length";

            pub const Type = c_uint;
        };

        /// When `TRUE`, pasted multi-line text is truncated to the first line.
        pub const truncate_multiline = struct {
            pub const name = "truncate-multiline";

            pub const Type = c_int;
        };

        /// Whether the entry should show the “invisible char” instead of the
        /// actual text (“password mode”).
        pub const visibility = struct {
            pub const name = "visibility";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the entry is activated.
        ///
        /// The keybindings for this signal are all forms of the Enter key.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Entry, p_instance))),
                    gobject.signalLookup("activate", Entry.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when an activatable icon is clicked.
        pub const icon_press = struct {
            pub const name = "icon-press";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_icon_pos: gtk.EntryIconPosition, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Entry, p_instance))),
                    gobject.signalLookup("icon-press", Entry.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted on the button release from a mouse click
        /// over an activatable icon.
        pub const icon_release = struct {
            pub const name = "icon-release";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_icon_pos: gtk.EntryIconPosition, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Entry, p_instance))),
                    gobject.signalLookup("icon-release", Entry.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new entry.
    extern fn gtk_entry_new() *gtk.Entry;
    pub const new = gtk_entry_new;

    /// Creates a new entry with the specified text buffer.
    extern fn gtk_entry_new_with_buffer(p_buffer: *gtk.EntryBuffer) *gtk.Entry;
    pub const newWithBuffer = gtk_entry_new_with_buffer;

    /// Retrieves the value set by `gtk.Entry.setActivatesDefault`.
    extern fn gtk_entry_get_activates_default(p_entry: *Entry) c_int;
    pub const getActivatesDefault = gtk_entry_get_activates_default;

    /// Gets the value set by `gtk.Entry.setAlignment`.
    ///
    /// See also: `gtk.Editable.properties.xalign`
    extern fn gtk_entry_get_alignment(p_entry: *Entry) f32;
    pub const getAlignment = gtk_entry_get_alignment;

    /// Gets the attribute list of the `GtkEntry`.
    ///
    /// See `gtk.Entry.setAttributes`.
    extern fn gtk_entry_get_attributes(p_entry: *Entry) ?*pango.AttrList;
    pub const getAttributes = gtk_entry_get_attributes;

    /// Get the `GtkEntryBuffer` object which holds the text for
    /// this widget.
    extern fn gtk_entry_get_buffer(p_entry: *Entry) *gtk.EntryBuffer;
    pub const getBuffer = gtk_entry_get_buffer;

    /// Returns the auxiliary completion object currently
    /// in use by `entry`.
    extern fn gtk_entry_get_completion(p_entry: *Entry) ?*gtk.EntryCompletion;
    pub const getCompletion = gtk_entry_get_completion;

    /// Returns the index of the icon which is the source of the
    /// current  DND operation, or -1.
    extern fn gtk_entry_get_current_icon_drag_source(p_entry: *Entry) c_int;
    pub const getCurrentIconDragSource = gtk_entry_get_current_icon_drag_source;

    /// Gets the menu model set with `gtk.Entry.setExtraMenu`.
    extern fn gtk_entry_get_extra_menu(p_entry: *Entry) ?*gio.MenuModel;
    pub const getExtraMenu = gtk_entry_get_extra_menu;

    /// Gets the value set by `gtk.Entry.setHasFrame`.
    extern fn gtk_entry_get_has_frame(p_entry: *Entry) c_int;
    pub const getHasFrame = gtk_entry_get_has_frame;

    /// Returns whether the icon is activatable.
    extern fn gtk_entry_get_icon_activatable(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) c_int;
    pub const getIconActivatable = gtk_entry_get_icon_activatable;

    /// Gets the area where entry’s icon at `icon_pos` is drawn.
    ///
    /// This function is useful when drawing something to the
    /// entry in a draw callback.
    ///
    /// If the entry is not realized or has no icon at the given
    /// position, `icon_area` is filled with zeros. Otherwise,
    /// `icon_area` will be filled with the icon's allocation,
    /// relative to `entry`'s allocation.
    extern fn gtk_entry_get_icon_area(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_icon_area: *gdk.Rectangle) void;
    pub const getIconArea = gtk_entry_get_icon_area;

    /// Finds the icon at the given position and return its index.
    ///
    /// The position’s coordinates are relative to the `entry`’s
    /// top left corner. If `x`, `y` doesn’t lie inside an icon,
    /// -1 is returned. This function is intended for use in a
    ///  `gtk.Widget.signals.query_tooltip` signal handler.
    extern fn gtk_entry_get_icon_at_pos(p_entry: *Entry, p_x: c_int, p_y: c_int) c_int;
    pub const getIconAtPos = gtk_entry_get_icon_at_pos;

    /// Retrieves the `GIcon` used for the icon.
    ///
    /// `NULL` will be returned if there is no icon or if the icon was
    /// set by some other method (e.g., by `GdkPaintable` or icon name).
    extern fn gtk_entry_get_icon_gicon(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) ?*gio.Icon;
    pub const getIconGicon = gtk_entry_get_icon_gicon;

    /// Retrieves the icon name used for the icon.
    ///
    /// `NULL` is returned if there is no icon or if the icon was set
    /// by some other method (e.g., by `GdkPaintable` or gicon).
    extern fn gtk_entry_get_icon_name(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) ?[*:0]const u8;
    pub const getIconName = gtk_entry_get_icon_name;

    /// Retrieves the `GdkPaintable` used for the icon.
    ///
    /// If no `GdkPaintable` was used for the icon, `NULL` is returned.
    extern fn gtk_entry_get_icon_paintable(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) ?*gdk.Paintable;
    pub const getIconPaintable = gtk_entry_get_icon_paintable;

    /// Returns whether the icon appears sensitive or insensitive.
    extern fn gtk_entry_get_icon_sensitive(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) c_int;
    pub const getIconSensitive = gtk_entry_get_icon_sensitive;

    /// Gets the type of representation being used by the icon
    /// to store image data.
    ///
    /// If the icon has no image data, the return value will
    /// be `GTK_IMAGE_EMPTY`.
    extern fn gtk_entry_get_icon_storage_type(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) gtk.ImageType;
    pub const getIconStorageType = gtk_entry_get_icon_storage_type;

    /// Gets the contents of the tooltip on the icon at the specified
    /// position in `entry`.
    extern fn gtk_entry_get_icon_tooltip_markup(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) ?[*:0]u8;
    pub const getIconTooltipMarkup = gtk_entry_get_icon_tooltip_markup;

    /// Gets the contents of the tooltip on the icon at the specified
    /// position in `entry`.
    extern fn gtk_entry_get_icon_tooltip_text(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition) ?[*:0]u8;
    pub const getIconTooltipText = gtk_entry_get_icon_tooltip_text;

    /// Gets the input hints of this `GtkEntry`.
    extern fn gtk_entry_get_input_hints(p_entry: *Entry) gtk.InputHints;
    pub const getInputHints = gtk_entry_get_input_hints;

    /// Gets the input purpose of the `GtkEntry`.
    extern fn gtk_entry_get_input_purpose(p_entry: *Entry) gtk.InputPurpose;
    pub const getInputPurpose = gtk_entry_get_input_purpose;

    /// Retrieves the character displayed in place of the actual text
    /// in “password mode”.
    extern fn gtk_entry_get_invisible_char(p_entry: *Entry) u32;
    pub const getInvisibleChar = gtk_entry_get_invisible_char;

    /// Retrieves the maximum allowed length of the text in `entry`.
    ///
    /// See `gtk.Entry.setMaxLength`.
    extern fn gtk_entry_get_max_length(p_entry: *Entry) c_int;
    pub const getMaxLength = gtk_entry_get_max_length;

    /// Gets whether the `GtkEntry` is in overwrite mode.
    extern fn gtk_entry_get_overwrite_mode(p_entry: *Entry) c_int;
    pub const getOverwriteMode = gtk_entry_get_overwrite_mode;

    /// Retrieves the text that will be displayed when `entry`
    /// is empty and unfocused
    extern fn gtk_entry_get_placeholder_text(p_entry: *Entry) ?[*:0]const u8;
    pub const getPlaceholderText = gtk_entry_get_placeholder_text;

    /// Returns the current fraction of the task that’s been completed.
    ///
    /// See `gtk.Entry.setProgressFraction`.
    extern fn gtk_entry_get_progress_fraction(p_entry: *Entry) f64;
    pub const getProgressFraction = gtk_entry_get_progress_fraction;

    /// Retrieves the pulse step set with
    /// `gtk.Entry.setProgressPulseStep`.
    extern fn gtk_entry_get_progress_pulse_step(p_entry: *Entry) f64;
    pub const getProgressPulseStep = gtk_entry_get_progress_pulse_step;

    /// Gets the tabstops of the `GtkEntry`.
    ///
    /// See `gtk.Entry.setTabs`.
    extern fn gtk_entry_get_tabs(p_entry: *Entry) ?*pango.TabArray;
    pub const getTabs = gtk_entry_get_tabs;

    /// Retrieves the current length of the text in `entry`.
    ///
    /// This is equivalent to getting `entry`'s `GtkEntryBuffer`
    /// and calling `gtk.EntryBuffer.getLength` on it.
    extern fn gtk_entry_get_text_length(p_entry: *Entry) u16;
    pub const getTextLength = gtk_entry_get_text_length;

    /// Retrieves whether the text in `entry` is visible.
    ///
    /// See `gtk.Entry.setVisibility`.
    extern fn gtk_entry_get_visibility(p_entry: *Entry) c_int;
    pub const getVisibility = gtk_entry_get_visibility;

    /// Causes `entry` to have keyboard focus.
    ///
    /// It behaves like `gtk.Widget.grabFocus`, except that it doesn't
    /// select the contents of the entry. You only want to call this on some
    /// special entries which the user usually doesn't want to replace all text
    /// in, such as search-as-you-type entries.
    extern fn gtk_entry_grab_focus_without_selecting(p_entry: *Entry) c_int;
    pub const grabFocusWithoutSelecting = gtk_entry_grab_focus_without_selecting;

    /// Indicates that some progress is made, but you don’t
    /// know how much.
    ///
    /// Causes the entry’s progress indicator to enter “activity
    /// mode”, where a block bounces back and forth. Each call to
    /// `gtk.Entry.progressPulse` causes the block to move by a
    /// little bit (the amount of movement per pulse is determined
    /// by `gtk.Entry.setProgressPulseStep`).
    extern fn gtk_entry_progress_pulse(p_entry: *Entry) void;
    pub const progressPulse = gtk_entry_progress_pulse;

    /// Reset the input method context of the entry if needed.
    ///
    /// This can be necessary in the case where modifying the buffer
    /// would confuse on-going input method behavior.
    extern fn gtk_entry_reset_im_context(p_entry: *Entry) void;
    pub const resetImContext = gtk_entry_reset_im_context;

    /// Sets whether pressing Enter in the `entry` will activate the default
    /// widget for the window containing the entry.
    ///
    /// This usually means that the dialog containing the entry will be closed,
    /// since the default widget is usually one of the dialog buttons.
    extern fn gtk_entry_set_activates_default(p_entry: *Entry, p_setting: c_int) void;
    pub const setActivatesDefault = gtk_entry_set_activates_default;

    /// Sets the alignment for the contents of the entry.
    ///
    /// This controls the horizontal positioning of the contents when
    /// the displayed text is shorter than the width of the entry.
    ///
    /// See also: `gtk.Editable.properties.xalign`
    extern fn gtk_entry_set_alignment(p_entry: *Entry, p_xalign: f32) void;
    pub const setAlignment = gtk_entry_set_alignment;

    /// Sets a `PangoAttrList`.
    ///
    /// The attributes in the list are applied to the entry text.
    ///
    /// Since the attributes will be applied to text that changes
    /// as the user types, it makes most sense to use attributes
    /// with unlimited extent.
    extern fn gtk_entry_set_attributes(p_entry: *Entry, p_attrs: *pango.AttrList) void;
    pub const setAttributes = gtk_entry_set_attributes;

    /// Set the `GtkEntryBuffer` object which holds the text for
    /// this widget.
    extern fn gtk_entry_set_buffer(p_entry: *Entry, p_buffer: *gtk.EntryBuffer) void;
    pub const setBuffer = gtk_entry_set_buffer;

    /// Sets `completion` to be the auxiliary completion object
    /// to use with `entry`.
    ///
    /// All further configuration of the completion mechanism is
    /// done on `completion` using the `GtkEntryCompletion` API.
    /// Completion is disabled if `completion` is set to `NULL`.
    extern fn gtk_entry_set_completion(p_entry: *Entry, p_completion: ?*gtk.EntryCompletion) void;
    pub const setCompletion = gtk_entry_set_completion;

    /// Sets a menu model to add when constructing
    /// the context menu for `entry`.
    extern fn gtk_entry_set_extra_menu(p_entry: *Entry, p_model: ?*gio.MenuModel) void;
    pub const setExtraMenu = gtk_entry_set_extra_menu;

    /// Sets whether the entry has a beveled frame around it.
    extern fn gtk_entry_set_has_frame(p_entry: *Entry, p_setting: c_int) void;
    pub const setHasFrame = gtk_entry_set_has_frame;

    /// Sets whether the icon is activatable.
    extern fn gtk_entry_set_icon_activatable(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_activatable: c_int) void;
    pub const setIconActivatable = gtk_entry_set_icon_activatable;

    /// Sets up the icon at the given position as drag source.
    ///
    /// This makes it so that GTK will start a drag
    /// operation when the user clicks and drags the icon.
    extern fn gtk_entry_set_icon_drag_source(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_provider: *gdk.ContentProvider, p_actions: gdk.DragAction) void;
    pub const setIconDragSource = gtk_entry_set_icon_drag_source;

    /// Sets the icon shown in the entry at the specified position
    /// from the current icon theme.
    ///
    /// If the icon isn’t known, a “broken image” icon will be
    /// displayed instead.
    ///
    /// If `icon` is `NULL`, no icon will be shown in the
    /// specified position.
    extern fn gtk_entry_set_icon_from_gicon(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_icon: ?*gio.Icon) void;
    pub const setIconFromGicon = gtk_entry_set_icon_from_gicon;

    /// Sets the icon shown in the entry at the specified position
    /// from the current icon theme.
    ///
    /// If the icon name isn’t known, a “broken image” icon will be
    /// displayed instead.
    ///
    /// If `icon_name` is `NULL`, no icon will be shown in the
    /// specified position.
    extern fn gtk_entry_set_icon_from_icon_name(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_icon_name: ?[*:0]const u8) void;
    pub const setIconFromIconName = gtk_entry_set_icon_from_icon_name;

    /// Sets the icon shown in the specified position using a `GdkPaintable`.
    ///
    /// If `paintable` is `NULL`, no icon will be shown in the specified position.
    extern fn gtk_entry_set_icon_from_paintable(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_paintable: ?*gdk.Paintable) void;
    pub const setIconFromPaintable = gtk_entry_set_icon_from_paintable;

    /// Sets the sensitivity for the specified icon.
    extern fn gtk_entry_set_icon_sensitive(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_sensitive: c_int) void;
    pub const setIconSensitive = gtk_entry_set_icon_sensitive;

    /// Sets `tooltip` as the contents of the tooltip for the icon at
    /// the specified position.
    ///
    /// `tooltip` is assumed to be marked up with Pango Markup.
    ///
    /// Use `NULL` for `tooltip` to remove an existing tooltip.
    ///
    /// See also `gtk.Widget.setTooltipMarkup` and
    /// `gtk.Entry.setIconTooltipText`.
    extern fn gtk_entry_set_icon_tooltip_markup(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_tooltip: ?[*:0]const u8) void;
    pub const setIconTooltipMarkup = gtk_entry_set_icon_tooltip_markup;

    /// Sets `tooltip` as the contents of the tooltip for the icon
    /// at the specified position.
    ///
    /// Use `NULL` for `tooltip` to remove an existing tooltip.
    ///
    /// See also `gtk.Widget.setTooltipText` and
    /// `gtk.Entry.setIconTooltipMarkup`.
    ///
    /// If you unset the widget tooltip via
    /// `gtk.Widget.setTooltipText` or
    /// `gtk.Widget.setTooltipMarkup`, this sets
    /// `gtk.Widget.properties.has_tooltip` to `FALSE`, which suppresses
    /// icon tooltips too. You can resolve this by then calling
    /// `gtk.Widget.setHasTooltip` to set
    /// `gtk.Widget.properties.has_tooltip` back to `TRUE`, or
    /// setting at least one non-empty tooltip on any icon
    /// achieves the same result.
    extern fn gtk_entry_set_icon_tooltip_text(p_entry: *Entry, p_icon_pos: gtk.EntryIconPosition, p_tooltip: ?[*:0]const u8) void;
    pub const setIconTooltipText = gtk_entry_set_icon_tooltip_text;

    /// Set additional hints which allow input methods to
    /// fine-tune their behavior.
    extern fn gtk_entry_set_input_hints(p_entry: *Entry, p_hints: gtk.InputHints) void;
    pub const setInputHints = gtk_entry_set_input_hints;

    /// Sets the input purpose which can be used by input methods
    /// to adjust their behavior.
    extern fn gtk_entry_set_input_purpose(p_entry: *Entry, p_purpose: gtk.InputPurpose) void;
    pub const setInputPurpose = gtk_entry_set_input_purpose;

    /// Sets the character to use in place of the actual text
    /// in “password mode”.
    ///
    /// See `gtk.Entry.setVisibility` for how to enable
    /// “password mode”.
    ///
    /// By default, GTK picks the best invisible char available in
    /// the current font. If you set the invisible char to 0, then
    /// the user will get no feedback at all; there will be no text
    /// on the screen as they type.
    extern fn gtk_entry_set_invisible_char(p_entry: *Entry, p_ch: u32) void;
    pub const setInvisibleChar = gtk_entry_set_invisible_char;

    /// Sets the maximum allowed length of the contents of the widget.
    ///
    /// If the current contents are longer than the given length, then
    /// they will be truncated to fit. The length is in characters.
    ///
    /// This is equivalent to getting `entry`'s `GtkEntryBuffer` and
    /// calling `gtk.EntryBuffer.setMaxLength` on it.
    extern fn gtk_entry_set_max_length(p_entry: *Entry, p_max: c_int) void;
    pub const setMaxLength = gtk_entry_set_max_length;

    /// Sets whether the text is overwritten when typing in the `GtkEntry`.
    extern fn gtk_entry_set_overwrite_mode(p_entry: *Entry, p_overwrite: c_int) void;
    pub const setOverwriteMode = gtk_entry_set_overwrite_mode;

    /// Sets text to be displayed in `entry` when it is empty.
    ///
    /// This can be used to give a visual hint of the expected
    /// contents of the `GtkEntry`.
    extern fn gtk_entry_set_placeholder_text(p_entry: *Entry, p_text: ?[*:0]const u8) void;
    pub const setPlaceholderText = gtk_entry_set_placeholder_text;

    /// Causes the entry’s progress indicator to “fill in” the given
    /// fraction of the bar.
    ///
    /// The fraction should be between 0.0 and 1.0, inclusive.
    extern fn gtk_entry_set_progress_fraction(p_entry: *Entry, p_fraction: f64) void;
    pub const setProgressFraction = gtk_entry_set_progress_fraction;

    /// Sets the fraction of total entry width to move the progress
    /// bouncing block for each pulse.
    ///
    /// Use `gtk.Entry.progressPulse` to pulse
    /// the progress.
    extern fn gtk_entry_set_progress_pulse_step(p_entry: *Entry, p_fraction: f64) void;
    pub const setProgressPulseStep = gtk_entry_set_progress_pulse_step;

    /// Sets a `PangoTabArray`.
    ///
    /// The tabstops in the array are applied to the entry text.
    extern fn gtk_entry_set_tabs(p_entry: *Entry, p_tabs: ?*pango.TabArray) void;
    pub const setTabs = gtk_entry_set_tabs;

    /// Sets whether the contents of the entry are visible or not.
    ///
    /// When visibility is set to `FALSE`, characters are displayed
    /// as the invisible char, and will also appear that way when
    /// the text in the entry widget is copied elsewhere.
    ///
    /// By default, GTK picks the best invisible character available
    /// in the current font, but it can be changed with
    /// `gtk.Entry.setInvisibleChar`.
    ///
    /// Note that you probably want to set `gtk.Entry.properties.input_purpose`
    /// to `GTK_INPUT_PURPOSE_PASSWORD` or `GTK_INPUT_PURPOSE_PIN` to
    /// inform input methods about the purpose of this entry,
    /// in addition to setting visibility to `FALSE`.
    extern fn gtk_entry_set_visibility(p_entry: *Entry, p_visible: c_int) void;
    pub const setVisibility = gtk_entry_set_visibility;

    /// Unsets the invisible char, so that the default invisible char
    /// is used again. See `gtk.Entry.setInvisibleChar`.
    extern fn gtk_entry_unset_invisible_char(p_entry: *Entry) void;
    pub const unsetInvisibleChar = gtk_entry_unset_invisible_char;

    extern fn gtk_entry_get_type() usize;
    pub const getGObjectType = gtk_entry_get_type;

    extern fn g_object_ref(p_self: *gtk.Entry) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Entry) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Entry, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkEntryBuffer` hold the text displayed in a `GtkText` widget.
///
/// A single `GtkEntryBuffer` object can be shared by multiple widgets
/// which will then share the same text content, but not the cursor
/// position, visibility attributes, icon etc.
///
/// `GtkEntryBuffer` may be derived from. Such a derived class might allow
/// text to be stored in an alternate location, such as non-pageable memory,
/// useful in the case of important passwords. Or a derived class could
/// integrate with an application’s concept of undo/redo.
pub const EntryBuffer = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.EntryBufferClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {
        /// Deletes a sequence of characters from the buffer.
        ///
        /// `n_chars` characters are deleted starting at `position`.
        /// If `n_chars` is negative, then all characters until the
        /// end of the text are deleted.
        ///
        /// If `position` or `n_chars` are out of bounds, then they
        /// are coerced to sane values.
        ///
        /// Note that the positions are specified in characters,
        /// not bytes.
        pub const delete_text = struct {
            pub fn call(p_class: anytype, p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_n_chars: c_uint) c_uint {
                return gobject.ext.as(EntryBuffer.Class, p_class).f_delete_text.?(gobject.ext.as(EntryBuffer, p_buffer), p_position, p_n_chars);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_n_chars: c_uint) callconv(.C) c_uint) void {
                gobject.ext.as(EntryBuffer.Class, p_class).f_delete_text = @ptrCast(p_implementation);
            }
        };

        pub const deleted_text = struct {
            pub fn call(p_class: anytype, p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_n_chars: c_uint) void {
                return gobject.ext.as(EntryBuffer.Class, p_class).f_deleted_text.?(gobject.ext.as(EntryBuffer, p_buffer), p_position, p_n_chars);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_n_chars: c_uint) callconv(.C) void) void {
                gobject.ext.as(EntryBuffer.Class, p_class).f_deleted_text = @ptrCast(p_implementation);
            }
        };

        /// Retrieves the length in characters of the buffer.
        pub const get_length = struct {
            pub fn call(p_class: anytype, p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_uint {
                return gobject.ext.as(EntryBuffer.Class, p_class).f_get_length.?(gobject.ext.as(EntryBuffer, p_buffer));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_uint) void {
                gobject.ext.as(EntryBuffer.Class, p_class).f_get_length = @ptrCast(p_implementation);
            }
        };

        pub const get_text = struct {
            pub fn call(p_class: anytype, p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_n_bytes: *usize) [*:0]const u8 {
                return gobject.ext.as(EntryBuffer.Class, p_class).f_get_text.?(gobject.ext.as(EntryBuffer, p_buffer), p_n_bytes);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_n_bytes: *usize) callconv(.C) [*:0]const u8) void {
                gobject.ext.as(EntryBuffer.Class, p_class).f_get_text = @ptrCast(p_implementation);
            }
        };

        /// Inserts `n_chars` characters of `chars` into the contents of the
        /// buffer, at position `position`.
        ///
        /// If `n_chars` is negative, then characters from chars will be inserted
        /// until a null-terminator is found. If `position` or `n_chars` are out of
        /// bounds, or the maximum buffer text length is exceeded, then they are
        /// coerced to sane values.
        ///
        /// Note that the position and length are in characters, not in bytes.
        pub const insert_text = struct {
            pub fn call(p_class: anytype, p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_chars: [*:0]const u8, p_n_chars: c_uint) c_uint {
                return gobject.ext.as(EntryBuffer.Class, p_class).f_insert_text.?(gobject.ext.as(EntryBuffer, p_buffer), p_position, p_chars, p_n_chars);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_chars: [*:0]const u8, p_n_chars: c_uint) callconv(.C) c_uint) void {
                gobject.ext.as(EntryBuffer.Class, p_class).f_insert_text = @ptrCast(p_implementation);
            }
        };

        pub const inserted_text = struct {
            pub fn call(p_class: anytype, p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_chars: [*:0]const u8, p_n_chars: c_uint) void {
                return gobject.ext.as(EntryBuffer.Class, p_class).f_inserted_text.?(gobject.ext.as(EntryBuffer, p_buffer), p_position, p_chars, p_n_chars);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_buffer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_position: c_uint, p_chars: [*:0]const u8, p_n_chars: c_uint) callconv(.C) void) void {
                gobject.ext.as(EntryBuffer.Class, p_class).f_inserted_text = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The length (in characters) of the text in buffer.
        pub const length = struct {
            pub const name = "length";

            pub const Type = c_uint;
        };

        /// The maximum length (in characters) of the text in the buffer.
        pub const max_length = struct {
            pub const name = "max-length";

            pub const Type = c_int;
        };

        /// The contents of the buffer.
        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// The text is altered in the default handler for this signal.
        ///
        /// If you want access to the text after the text has been modified,
        /// use `G_CONNECT_AFTER`.
        pub const deleted_text = struct {
            pub const name = "deleted-text";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_position: c_uint, p_n_chars: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EntryBuffer, p_instance))),
                    gobject.signalLookup("deleted-text", EntryBuffer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted after text is inserted into the buffer.
        pub const inserted_text = struct {
            pub const name = "inserted-text";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_position: c_uint, p_chars: [*:0]u8, p_n_chars: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EntryBuffer, p_instance))),
                    gobject.signalLookup("inserted-text", EntryBuffer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Create a new `GtkEntryBuffer` object.
    ///
    /// Optionally, specify initial text to set in the buffer.
    extern fn gtk_entry_buffer_new(p_initial_chars: ?[*:0]const u8, p_n_initial_chars: c_int) *gtk.EntryBuffer;
    pub const new = gtk_entry_buffer_new;

    /// Deletes a sequence of characters from the buffer.
    ///
    /// `n_chars` characters are deleted starting at `position`.
    /// If `n_chars` is negative, then all characters until the
    /// end of the text are deleted.
    ///
    /// If `position` or `n_chars` are out of bounds, then they
    /// are coerced to sane values.
    ///
    /// Note that the positions are specified in characters,
    /// not bytes.
    extern fn gtk_entry_buffer_delete_text(p_buffer: *EntryBuffer, p_position: c_uint, p_n_chars: c_int) c_uint;
    pub const deleteText = gtk_entry_buffer_delete_text;

    /// Used when subclassing `GtkEntryBuffer`.
    extern fn gtk_entry_buffer_emit_deleted_text(p_buffer: *EntryBuffer, p_position: c_uint, p_n_chars: c_uint) void;
    pub const emitDeletedText = gtk_entry_buffer_emit_deleted_text;

    /// Used when subclassing `GtkEntryBuffer`.
    extern fn gtk_entry_buffer_emit_inserted_text(p_buffer: *EntryBuffer, p_position: c_uint, p_chars: [*:0]const u8, p_n_chars: c_uint) void;
    pub const emitInsertedText = gtk_entry_buffer_emit_inserted_text;

    /// Retrieves the length in bytes of the buffer.
    ///
    /// See `gtk.EntryBuffer.getLength`.
    extern fn gtk_entry_buffer_get_bytes(p_buffer: *EntryBuffer) usize;
    pub const getBytes = gtk_entry_buffer_get_bytes;

    /// Retrieves the length in characters of the buffer.
    extern fn gtk_entry_buffer_get_length(p_buffer: *EntryBuffer) c_uint;
    pub const getLength = gtk_entry_buffer_get_length;

    /// Retrieves the maximum allowed length of the text in `buffer`.
    extern fn gtk_entry_buffer_get_max_length(p_buffer: *EntryBuffer) c_int;
    pub const getMaxLength = gtk_entry_buffer_get_max_length;

    /// Retrieves the contents of the buffer.
    ///
    /// The memory pointer returned by this call will not change
    /// unless this object emits a signal, or is finalized.
    extern fn gtk_entry_buffer_get_text(p_buffer: *EntryBuffer) [*:0]const u8;
    pub const getText = gtk_entry_buffer_get_text;

    /// Inserts `n_chars` characters of `chars` into the contents of the
    /// buffer, at position `position`.
    ///
    /// If `n_chars` is negative, then characters from chars will be inserted
    /// until a null-terminator is found. If `position` or `n_chars` are out of
    /// bounds, or the maximum buffer text length is exceeded, then they are
    /// coerced to sane values.
    ///
    /// Note that the position and length are in characters, not in bytes.
    extern fn gtk_entry_buffer_insert_text(p_buffer: *EntryBuffer, p_position: c_uint, p_chars: [*:0]const u8, p_n_chars: c_int) c_uint;
    pub const insertText = gtk_entry_buffer_insert_text;

    /// Sets the maximum allowed length of the contents of the buffer.
    ///
    /// If the current contents are longer than the given length, then
    /// they will be truncated to fit.
    extern fn gtk_entry_buffer_set_max_length(p_buffer: *EntryBuffer, p_max_length: c_int) void;
    pub const setMaxLength = gtk_entry_buffer_set_max_length;

    /// Sets the text in the buffer.
    ///
    /// This is roughly equivalent to calling
    /// `gtk.EntryBuffer.deleteText` and
    /// `gtk.EntryBuffer.insertText`.
    ///
    /// Note that `n_chars` is in characters, not in bytes.
    extern fn gtk_entry_buffer_set_text(p_buffer: *EntryBuffer, p_chars: [*:0]const u8, p_n_chars: c_int) void;
    pub const setText = gtk_entry_buffer_set_text;

    extern fn gtk_entry_buffer_get_type() usize;
    pub const getGObjectType = gtk_entry_buffer_get_type;

    extern fn g_object_ref(p_self: *gtk.EntryBuffer) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EntryBuffer) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EntryBuffer, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEntryCompletion` is an auxiliary object to provide completion functionality
/// for `GtkEntry`.
///
/// It implements the `gtk.CellLayout` interface, to allow the user
/// to add extra cells to the `GtkTreeView` with completion matches.
///
/// “Completion functionality” means that when the user modifies the text
/// in the entry, `GtkEntryCompletion` checks which rows in the model match
/// the current content of the entry, and displays a list of matches.
/// By default, the matching is done by comparing the entry text
/// case-insensitively against the text column of the model (see
/// `gtk.EntryCompletion.setTextColumn`), but this can be overridden
/// with a custom match function (see `gtk.EntryCompletion.setMatchFunc`).
///
/// When the user selects a completion, the content of the entry is
/// updated. By default, the content of the entry is replaced by the
/// text column of the model, but this can be overridden by connecting
/// to the `gtk.EntryCompletion.signals.match_selected` signal and updating the
/// entry in the signal handler. Note that you should return `TRUE` from
/// the signal handler to suppress the default behaviour.
///
/// To add completion functionality to an entry, use
/// `gtk.Entry.setCompletion`.
///
/// `GtkEntryCompletion` uses a `gtk.TreeModelFilter` model to
/// represent the subset of the entire model that is currently matching.
/// While the `GtkEntryCompletion` signals
/// `gtk.EntryCompletion.signals.match_selected` and
/// `gtk.EntryCompletion.signals.cursor_on_match` take the original model
/// and an iter pointing to that model as arguments, other callbacks and
/// signals (such as `GtkCellLayoutDataFunc` or
/// `gtk.CellArea.signals.@"apply_attributes)"`
/// will generally take the filter model as argument. As long as you are
/// only calling `gtk.TreeModel.get`, this will make no difference to
/// you. If for some reason, you need the original model, use
/// `gtk.TreeModelFilter.getModel`. Don’t forget to use
/// `gtk.TreeModelFilter.convertIterToChildIter` to obtain a
/// matching iter.
pub const EntryCompletion = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{ gtk.Buildable, gtk.CellLayout };
    pub const Class = opaque {
        pub const Instance = EntryCompletion;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GtkCellArea` used to layout cell renderers in the treeview column.
        ///
        /// If no area is specified when creating the entry completion with
        /// `gtk.EntryCompletion.newWithArea`, a horizontally oriented
        /// `gtk.CellAreaBox` will be used.
        pub const cell_area = struct {
            pub const name = "cell-area";

            pub const Type = ?*gtk.CellArea;
        };

        /// Determines whether the common prefix of the possible completions
        /// should be inserted automatically in the entry.
        ///
        /// Note that this requires text-column to be set, even if you are
        /// using a custom match function.
        pub const inline_completion = struct {
            pub const name = "inline-completion";

            pub const Type = c_int;
        };

        /// Determines whether the possible completions on the popup
        /// will appear in the entry as you navigate through them.
        pub const inline_selection = struct {
            pub const name = "inline-selection";

            pub const Type = c_int;
        };

        /// The minimum key length as set for completion.
        pub const minimum_key_length = struct {
            pub const name = "minimum-key-length";

            pub const Type = c_int;
        };

        /// The model used as data source.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gtk.TreeModel;
        };

        /// Determines whether the possible completions should be
        /// shown in a popup window.
        pub const popup_completion = struct {
            pub const name = "popup-completion";

            pub const Type = c_int;
        };

        /// Determines whether the completions popup window will be
        /// resized to the width of the entry.
        pub const popup_set_width = struct {
            pub const name = "popup-set-width";

            pub const Type = c_int;
        };

        /// Determines whether the completions popup window will shown
        /// for a single possible completion.
        ///
        /// You probably want to set this to `FALSE` if you are using
        /// `gtk.EntryCompletion.properties.inline_completion`.
        pub const popup_single_match = struct {
            pub const name = "popup-single-match";

            pub const Type = c_int;
        };

        /// The column of the model containing the strings.
        ///
        /// Note that the strings must be UTF-8.
        pub const text_column = struct {
            pub const name = "text-column";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when a match from the cursor is on a match of the list.
        ///
        /// The default behaviour is to replace the contents
        /// of the entry with the contents of the text column in the row
        /// pointed to by `iter`.
        ///
        /// Note that `model` is the model that was passed to
        /// `gtk.EntryCompletion.setModel`.
        pub const cursor_on_match = struct {
            pub const name = "cursor-on-match";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_model: *gtk.TreeModel, p_iter: *gtk.TreeIter, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EntryCompletion, p_instance))),
                    gobject.signalLookup("cursor-on-match", EntryCompletion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the inline autocompletion is triggered.
        ///
        /// The default behaviour is to make the entry display the
        /// whole prefix and select the newly inserted part.
        ///
        /// Applications may connect to this signal in order to insert only a
        /// smaller part of the `prefix` into the entry - e.g. the entry used in
        /// the `GtkFileChooser` inserts only the part of the prefix up to the
        /// next '/'.
        pub const insert_prefix = struct {
            pub const name = "insert-prefix";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_prefix: [*:0]u8, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EntryCompletion, p_instance))),
                    gobject.signalLookup("insert-prefix", EntryCompletion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a match from the list is selected.
        ///
        /// The default behaviour is to replace the contents of the
        /// entry with the contents of the text column in the row
        /// pointed to by `iter`.
        ///
        /// Note that `model` is the model that was passed to
        /// `gtk.EntryCompletion.setModel`.
        pub const match_selected = struct {
            pub const name = "match-selected";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_model: *gtk.TreeModel, p_iter: *gtk.TreeIter, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EntryCompletion, p_instance))),
                    gobject.signalLookup("match-selected", EntryCompletion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the filter model has zero
        /// number of rows in completion_complete method.
        ///
        /// In other words when `GtkEntryCompletion` is out of suggestions.
        pub const no_matches = struct {
            pub const name = "no-matches";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EntryCompletion, p_instance))),
                    gobject.signalLookup("no-matches", EntryCompletion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkEntryCompletion` object.
    extern fn gtk_entry_completion_new() *gtk.EntryCompletion;
    pub const new = gtk_entry_completion_new;

    /// Creates a new `GtkEntryCompletion` object using the
    /// specified `area`.
    ///
    /// The `GtkCellArea` is used to layout cells in the underlying
    /// `GtkTreeViewColumn` for the drop-down menu.
    extern fn gtk_entry_completion_new_with_area(p_area: *gtk.CellArea) *gtk.EntryCompletion;
    pub const newWithArea = gtk_entry_completion_new_with_area;

    /// Requests a completion operation, or in other words a refiltering of the
    /// current list with completions, using the current key.
    ///
    /// The completion list view will be updated accordingly.
    extern fn gtk_entry_completion_complete(p_completion: *EntryCompletion) void;
    pub const complete = gtk_entry_completion_complete;

    /// Computes the common prefix that is shared by all rows in `completion`
    /// that start with `key`.
    ///
    /// If no row matches `key`, `NULL` will be returned.
    /// Note that a text column must have been set for this function to work,
    /// see `gtk.EntryCompletion.setTextColumn` for details.
    extern fn gtk_entry_completion_compute_prefix(p_completion: *EntryCompletion, p_key: [*:0]const u8) ?[*:0]u8;
    pub const computePrefix = gtk_entry_completion_compute_prefix;

    /// Get the original text entered by the user that triggered
    /// the completion or `NULL` if there’s no completion ongoing.
    extern fn gtk_entry_completion_get_completion_prefix(p_completion: *EntryCompletion) ?[*:0]const u8;
    pub const getCompletionPrefix = gtk_entry_completion_get_completion_prefix;

    /// Gets the entry `completion` has been attached to.
    extern fn gtk_entry_completion_get_entry(p_completion: *EntryCompletion) *gtk.Widget;
    pub const getEntry = gtk_entry_completion_get_entry;

    /// Returns whether the common prefix of the possible completions should
    /// be automatically inserted in the entry.
    extern fn gtk_entry_completion_get_inline_completion(p_completion: *EntryCompletion) c_int;
    pub const getInlineCompletion = gtk_entry_completion_get_inline_completion;

    /// Returns `TRUE` if inline-selection mode is turned on.
    extern fn gtk_entry_completion_get_inline_selection(p_completion: *EntryCompletion) c_int;
    pub const getInlineSelection = gtk_entry_completion_get_inline_selection;

    /// Returns the minimum key length as set for `completion`.
    extern fn gtk_entry_completion_get_minimum_key_length(p_completion: *EntryCompletion) c_int;
    pub const getMinimumKeyLength = gtk_entry_completion_get_minimum_key_length;

    /// Returns the model the `GtkEntryCompletion` is using as data source.
    ///
    /// Returns `NULL` if the model is unset.
    extern fn gtk_entry_completion_get_model(p_completion: *EntryCompletion) ?*gtk.TreeModel;
    pub const getModel = gtk_entry_completion_get_model;

    /// Returns whether the completions should be presented in a popup window.
    extern fn gtk_entry_completion_get_popup_completion(p_completion: *EntryCompletion) c_int;
    pub const getPopupCompletion = gtk_entry_completion_get_popup_completion;

    /// Returns whether the completion popup window will be resized to the
    /// width of the entry.
    extern fn gtk_entry_completion_get_popup_set_width(p_completion: *EntryCompletion) c_int;
    pub const getPopupSetWidth = gtk_entry_completion_get_popup_set_width;

    /// Returns whether the completion popup window will appear even if there is
    /// only a single match.
    extern fn gtk_entry_completion_get_popup_single_match(p_completion: *EntryCompletion) c_int;
    pub const getPopupSingleMatch = gtk_entry_completion_get_popup_single_match;

    /// Returns the column in the model of `completion` to get strings from.
    extern fn gtk_entry_completion_get_text_column(p_completion: *EntryCompletion) c_int;
    pub const getTextColumn = gtk_entry_completion_get_text_column;

    /// Requests a prefix insertion.
    extern fn gtk_entry_completion_insert_prefix(p_completion: *EntryCompletion) void;
    pub const insertPrefix = gtk_entry_completion_insert_prefix;

    /// Sets whether the common prefix of the possible completions should
    /// be automatically inserted in the entry.
    extern fn gtk_entry_completion_set_inline_completion(p_completion: *EntryCompletion, p_inline_completion: c_int) void;
    pub const setInlineCompletion = gtk_entry_completion_set_inline_completion;

    /// Sets whether it is possible to cycle through the possible completions
    /// inside the entry.
    extern fn gtk_entry_completion_set_inline_selection(p_completion: *EntryCompletion, p_inline_selection: c_int) void;
    pub const setInlineSelection = gtk_entry_completion_set_inline_selection;

    /// Sets the match function for `completion` to be `func`.
    ///
    /// The match function is used to determine if a row should or
    /// should not be in the completion list.
    extern fn gtk_entry_completion_set_match_func(p_completion: *EntryCompletion, p_func: gtk.EntryCompletionMatchFunc, p_func_data: ?*anyopaque, p_func_notify: ?glib.DestroyNotify) void;
    pub const setMatchFunc = gtk_entry_completion_set_match_func;

    /// Requires the length of the search key for `completion` to be at least
    /// `length`.
    ///
    /// This is useful for long lists, where completing using a small
    /// key takes a lot of time and will come up with meaningless results anyway
    /// (ie, a too large dataset).
    extern fn gtk_entry_completion_set_minimum_key_length(p_completion: *EntryCompletion, p_length: c_int) void;
    pub const setMinimumKeyLength = gtk_entry_completion_set_minimum_key_length;

    /// Sets the model for a `GtkEntryCompletion`.
    ///
    /// If `completion` already has a model set, it will remove it
    /// before setting the new model. If model is `NULL`, then it
    /// will unset the model.
    extern fn gtk_entry_completion_set_model(p_completion: *EntryCompletion, p_model: ?*gtk.TreeModel) void;
    pub const setModel = gtk_entry_completion_set_model;

    /// Sets whether the completions should be presented in a popup window.
    extern fn gtk_entry_completion_set_popup_completion(p_completion: *EntryCompletion, p_popup_completion: c_int) void;
    pub const setPopupCompletion = gtk_entry_completion_set_popup_completion;

    /// Sets whether the completion popup window will be resized to be the same
    /// width as the entry.
    extern fn gtk_entry_completion_set_popup_set_width(p_completion: *EntryCompletion, p_popup_set_width: c_int) void;
    pub const setPopupSetWidth = gtk_entry_completion_set_popup_set_width;

    /// Sets whether the completion popup window will appear even if there is
    /// only a single match.
    ///
    /// You may want to set this to `FALSE` if you
    /// are using `gtk.EntryCompletion.properties.inline_completion`.
    extern fn gtk_entry_completion_set_popup_single_match(p_completion: *EntryCompletion, p_popup_single_match: c_int) void;
    pub const setPopupSingleMatch = gtk_entry_completion_set_popup_single_match;

    /// Convenience function for setting up the most used case of this code: a
    /// completion list with just strings.
    ///
    /// This function will set up `completion`
    /// to have a list displaying all (and just) strings in the completion list,
    /// and to get those strings from `column` in the model of `completion`.
    ///
    /// This functions creates and adds a `GtkCellRendererText` for the selected
    /// column. If you need to set the text column, but don't want the cell
    /// renderer, use `gobject.Object.set` to set the
    /// `gtk.EntryCompletion.properties.text_column` property directly.
    extern fn gtk_entry_completion_set_text_column(p_completion: *EntryCompletion, p_column: c_int) void;
    pub const setTextColumn = gtk_entry_completion_set_text_column;

    extern fn gtk_entry_completion_get_type() usize;
    pub const getGObjectType = gtk_entry_completion_get_type;

    extern fn g_object_ref(p_self: *gtk.EntryCompletion) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EntryCompletion) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EntryCompletion, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEventController` is the base class for event controllers.
///
/// These are ancillary objects associated to widgets, which react
/// to `GdkEvents`, and possibly trigger actions as a consequence.
///
/// Event controllers are added to a widget with
/// `gtk.Widget.addController`. It is rarely necessary to
/// explicitly remove a controller with `gtk.Widget.removeController`.
///
/// See the chapter on [input handling](input-handling.html) for
/// an overview of the basic concepts, such as the capture and bubble
/// phases of event propagation.
pub const EventController = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.EventControllerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The name for this controller, typically used for debugging purposes.
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// The limit for which events this controller will handle.
        pub const propagation_limit = struct {
            pub const name = "propagation-limit";

            pub const Type = gtk.PropagationLimit;
        };

        /// The propagation phase at which this controller will handle events.
        pub const propagation_phase = struct {
            pub const name = "propagation-phase";

            pub const Type = gtk.PropagationPhase;
        };

        /// The widget receiving the `GdkEvents` that the controller will handle.
        pub const widget = struct {
            pub const name = "widget";

            pub const Type = ?*gtk.Widget;
        };
    };

    pub const signals = struct {};

    /// Returns the event that is currently being handled by the controller.
    ///
    /// At other times, `NULL` is returned.
    extern fn gtk_event_controller_get_current_event(p_controller: *EventController) ?*gdk.Event;
    pub const getCurrentEvent = gtk_event_controller_get_current_event;

    /// Returns the device of the event that is currently being
    /// handled by the controller.
    ///
    /// At other times, `NULL` is returned.
    extern fn gtk_event_controller_get_current_event_device(p_controller: *EventController) ?*gdk.Device;
    pub const getCurrentEventDevice = gtk_event_controller_get_current_event_device;

    /// Returns the modifier state of the event that is currently being
    /// handled by the controller.
    ///
    /// At other times, 0 is returned.
    extern fn gtk_event_controller_get_current_event_state(p_controller: *EventController) gdk.ModifierType;
    pub const getCurrentEventState = gtk_event_controller_get_current_event_state;

    /// Returns the timestamp of the event that is currently being
    /// handled by the controller.
    ///
    /// At other times, 0 is returned.
    extern fn gtk_event_controller_get_current_event_time(p_controller: *EventController) u32;
    pub const getCurrentEventTime = gtk_event_controller_get_current_event_time;

    /// Gets the name of `controller`.
    extern fn gtk_event_controller_get_name(p_controller: *EventController) ?[*:0]const u8;
    pub const getName = gtk_event_controller_get_name;

    /// Gets the propagation limit of the event controller.
    extern fn gtk_event_controller_get_propagation_limit(p_controller: *EventController) gtk.PropagationLimit;
    pub const getPropagationLimit = gtk_event_controller_get_propagation_limit;

    /// Gets the propagation phase at which `controller` handles events.
    extern fn gtk_event_controller_get_propagation_phase(p_controller: *EventController) gtk.PropagationPhase;
    pub const getPropagationPhase = gtk_event_controller_get_propagation_phase;

    /// Returns the `GtkWidget` this controller relates to.
    extern fn gtk_event_controller_get_widget(p_controller: *EventController) ?*gtk.Widget;
    pub const getWidget = gtk_event_controller_get_widget;

    /// Resets the `controller` to a clean state.
    extern fn gtk_event_controller_reset(p_controller: *EventController) void;
    pub const reset = gtk_event_controller_reset;

    /// Sets a name on the controller that can be used for debugging.
    extern fn gtk_event_controller_set_name(p_controller: *EventController, p_name: ?[*:0]const u8) void;
    pub const setName = gtk_event_controller_set_name;

    /// Sets the event propagation limit on the event controller.
    ///
    /// If the limit is set to `GTK_LIMIT_SAME_NATIVE`, the controller
    /// won't handle events that are targeted at widgets on a different
    /// surface, such as popovers.
    extern fn gtk_event_controller_set_propagation_limit(p_controller: *EventController, p_limit: gtk.PropagationLimit) void;
    pub const setPropagationLimit = gtk_event_controller_set_propagation_limit;

    /// Sets the propagation phase at which a controller handles events.
    ///
    /// If `phase` is `GTK_PHASE_NONE`, no automatic event handling will be
    /// performed, but other additional gesture maintenance will.
    extern fn gtk_event_controller_set_propagation_phase(p_controller: *EventController, p_phase: gtk.PropagationPhase) void;
    pub const setPropagationPhase = gtk_event_controller_set_propagation_phase;

    /// Sets a name on the controller that can be used for debugging.
    extern fn gtk_event_controller_set_static_name(p_controller: *EventController, p_name: ?[*:0]const u8) void;
    pub const setStaticName = gtk_event_controller_set_static_name;

    extern fn gtk_event_controller_get_type() usize;
    pub const getGObjectType = gtk_event_controller_get_type;

    extern fn g_object_ref(p_self: *gtk.EventController) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EventController) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EventController, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEventControllerFocus` is an event controller to keep track of
/// keyboard focus.
///
/// The event controller offers `gtk.EventControllerFocus.signals.enter`
/// and `gtk.EventControllerFocus.signals.leave` signals, as well as
/// `gtk.EventControllerFocus.properties.is_focus` and
/// `gtk.EventControllerFocus.properties.contains_focus` properties
/// which are updated to reflect focus changes inside the widget hierarchy
/// that is rooted at the controllers widget.
pub const EventControllerFocus = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.EventControllerFocusClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// `TRUE` if focus is contained in the controllers widget.
        ///
        /// See `gtk.EventControllerFocus.properties.is_focus` for whether
        /// the focus is in the widget itself or inside a descendent.
        ///
        /// When handling focus events, this property is updated
        /// before `gtk.EventControllerFocus.signals.enter` or
        /// `gtk.EventControllerFocus.signals.leave` are emitted.
        pub const contains_focus = struct {
            pub const name = "contains-focus";

            pub const Type = c_int;
        };

        /// `TRUE` if focus is in the controllers widget itself,
        /// as opposed to in a descendent widget.
        ///
        /// See also `gtk.EventControllerFocus.properties.contains_focus`.
        ///
        /// When handling focus events, this property is updated
        /// before `gtk.EventControllerFocus.signals.enter` or
        /// `gtk.EventControllerFocus.signals.leave` are emitted.
        pub const is_focus = struct {
            pub const name = "is-focus";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted whenever the focus enters into the widget or one
        /// of its descendents.
        ///
        /// Note that this means you may not get an ::enter signal
        /// even though the widget becomes the focus location, in
        /// certain cases (such as when the focus moves from a descendent
        /// of the widget to the widget itself). If you are interested
        /// in these cases, you can monitor the
        /// `gtk.EventControllerFocus.properties.is_focus`
        /// property for changes.
        pub const enter = struct {
            pub const name = "enter";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerFocus, p_instance))),
                    gobject.signalLookup("enter", EventControllerFocus.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever the focus leaves the widget hierarchy
        /// that is rooted at the widget that the controller is attached to.
        ///
        /// Note that this means you may not get a ::leave signal
        /// even though the focus moves away from the widget, in
        /// certain cases (such as when the focus moves from the widget
        /// to a descendent). If you are interested in these cases, you
        /// can monitor the `gtk.EventControllerFocus.properties.is_focus`
        /// property for changes.
        pub const leave = struct {
            pub const name = "leave";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerFocus, p_instance))),
                    gobject.signalLookup("leave", EventControllerFocus.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new event controller that will handle focus events.
    extern fn gtk_event_controller_focus_new() *gtk.EventControllerFocus;
    pub const new = gtk_event_controller_focus_new;

    /// Returns `TRUE` if focus is within `self` or one of its children.
    extern fn gtk_event_controller_focus_contains_focus(p_self: *EventControllerFocus) c_int;
    pub const containsFocus = gtk_event_controller_focus_contains_focus;

    /// Returns `TRUE` if focus is within `self`, but not one of its children.
    extern fn gtk_event_controller_focus_is_focus(p_self: *EventControllerFocus) c_int;
    pub const isFocus = gtk_event_controller_focus_is_focus;

    extern fn gtk_event_controller_focus_get_type() usize;
    pub const getGObjectType = gtk_event_controller_focus_get_type;

    extern fn g_object_ref(p_self: *gtk.EventControllerFocus) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EventControllerFocus) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EventControllerFocus, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEventControllerKey` is an event controller that provides access
/// to key events.
pub const EventControllerKey = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.EventControllerKeyClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted whenever the input method context filters away
        /// a keypress and prevents the `controller` receiving it.
        ///
        /// See `gtk.EventControllerKey.setImContext` and
        /// `gtk.IMContext.filterKeypress`.
        pub const im_update = struct {
            pub const name = "im-update";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerKey, p_instance))),
                    gobject.signalLookup("im-update", EventControllerKey.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever a key is pressed.
        pub const key_pressed = struct {
            pub const name = "key-pressed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_keyval: c_uint, p_keycode: c_uint, p_state: gdk.ModifierType, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerKey, p_instance))),
                    gobject.signalLookup("key-pressed", EventControllerKey.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever a key is released.
        pub const key_released = struct {
            pub const name = "key-released";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_keyval: c_uint, p_keycode: c_uint, p_state: gdk.ModifierType, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerKey, p_instance))),
                    gobject.signalLookup("key-released", EventControllerKey.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever the state of modifier keys and pointer buttons change.
        pub const modifiers = struct {
            pub const name = "modifiers";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_state: gdk.ModifierType, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerKey, p_instance))),
                    gobject.signalLookup("modifiers", EventControllerKey.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new event controller that will handle key events.
    extern fn gtk_event_controller_key_new() *gtk.EventControllerKey;
    pub const new = gtk_event_controller_key_new;

    /// Forwards the current event of this `controller` to a `widget`.
    ///
    /// This function can only be used in handlers for the
    /// `gtk.EventControllerKey.signals.key_pressed`,
    /// `gtk.EventControllerKey.signals.key_released`
    /// or `gtk.EventControllerKey.signals.modifiers` signals.
    extern fn gtk_event_controller_key_forward(p_controller: *EventControllerKey, p_widget: *gtk.Widget) c_int;
    pub const forward = gtk_event_controller_key_forward;

    /// Gets the key group of the current event of this `controller`.
    ///
    /// See `gdk.KeyEvent.getLayout`.
    extern fn gtk_event_controller_key_get_group(p_controller: *EventControllerKey) c_uint;
    pub const getGroup = gtk_event_controller_key_get_group;

    /// Gets the input method context of the key `controller`.
    extern fn gtk_event_controller_key_get_im_context(p_controller: *EventControllerKey) ?*gtk.IMContext;
    pub const getImContext = gtk_event_controller_key_get_im_context;

    /// Sets the input method context of the key `controller`.
    extern fn gtk_event_controller_key_set_im_context(p_controller: *EventControllerKey, p_im_context: ?*gtk.IMContext) void;
    pub const setImContext = gtk_event_controller_key_set_im_context;

    extern fn gtk_event_controller_key_get_type() usize;
    pub const getGObjectType = gtk_event_controller_key_get_type;

    extern fn g_object_ref(p_self: *gtk.EventControllerKey) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EventControllerKey) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EventControllerKey, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEventControllerLegacy` is an event controller that provides raw
/// access to the event stream.
///
/// It should only be used as a last resort if none of the other event
/// controllers or gestures do the job.
pub const EventControllerLegacy = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.EventControllerLegacyClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted for each GDK event delivered to `controller`.
        pub const event = struct {
            pub const name = "event";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_event: *gdk.Event, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerLegacy, p_instance))),
                    gobject.signalLookup("event", EventControllerLegacy.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new legacy event controller.
    extern fn gtk_event_controller_legacy_new() *gtk.EventControllerLegacy;
    pub const new = gtk_event_controller_legacy_new;

    extern fn gtk_event_controller_legacy_get_type() usize;
    pub const getGObjectType = gtk_event_controller_legacy_get_type;

    extern fn g_object_ref(p_self: *gtk.EventControllerLegacy) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EventControllerLegacy) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EventControllerLegacy, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEventControllerMotion` is an event controller tracking the pointer
/// position.
///
/// The event controller offers `gtk.EventControllerMotion.signals.enter`
/// and `gtk.EventControllerMotion.signals.leave` signals, as well as
/// `gtk.EventControllerMotion.properties.is_pointer` and
/// `gtk.EventControllerMotion.properties.contains_pointer` properties
/// which are updated to reflect changes in the pointer position as it
/// moves over the widget.
pub const EventControllerMotion = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.EventControllerMotionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the pointer is in the controllers widget or a descendant.
        ///
        /// See also `gtk.EventControllerMotion.properties.is_pointer`.
        ///
        /// When handling crossing events, this property is updated
        /// before `gtk.EventControllerMotion.signals.enter`, but after
        /// `gtk.EventControllerMotion.signals.leave` is emitted.
        pub const contains_pointer = struct {
            pub const name = "contains-pointer";

            pub const Type = c_int;
        };

        /// Whether the pointer is in the controllers widget itself,
        /// as opposed to in a descendent widget.
        ///
        /// See also `gtk.EventControllerMotion.properties.contains_pointer`.
        ///
        /// When handling crossing events, this property is updated
        /// before `gtk.EventControllerMotion.signals.enter`, but after
        /// `gtk.EventControllerMotion.signals.leave` is emitted.
        pub const is_pointer = struct {
            pub const name = "is-pointer";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Signals that the pointer has entered the widget.
        pub const enter = struct {
            pub const name = "enter";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerMotion, p_instance))),
                    gobject.signalLookup("enter", EventControllerMotion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signals that the pointer has left the widget.
        pub const leave = struct {
            pub const name = "leave";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerMotion, p_instance))),
                    gobject.signalLookup("leave", EventControllerMotion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the pointer moves inside the widget.
        pub const motion = struct {
            pub const name = "motion";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerMotion, p_instance))),
                    gobject.signalLookup("motion", EventControllerMotion.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new event controller that will handle motion events.
    extern fn gtk_event_controller_motion_new() *gtk.EventControllerMotion;
    pub const new = gtk_event_controller_motion_new;

    /// Returns if a pointer is within `self` or one of its children.
    extern fn gtk_event_controller_motion_contains_pointer(p_self: *EventControllerMotion) c_int;
    pub const containsPointer = gtk_event_controller_motion_contains_pointer;

    /// Returns if a pointer is within `self`, but not one of its children.
    extern fn gtk_event_controller_motion_is_pointer(p_self: *EventControllerMotion) c_int;
    pub const isPointer = gtk_event_controller_motion_is_pointer;

    extern fn gtk_event_controller_motion_get_type() usize;
    pub const getGObjectType = gtk_event_controller_motion_get_type;

    extern fn g_object_ref(p_self: *gtk.EventControllerMotion) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EventControllerMotion) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EventControllerMotion, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEventControllerScroll` is an event controller that handles scroll
/// events.
///
/// It is capable of handling both discrete and continuous scroll
/// events from mice or touchpads, abstracting them both with the
/// `gtk.EventControllerScroll.signals.scroll` signal. Deltas in
/// the discrete case are multiples of 1.
///
/// In the case of continuous scroll events, `GtkEventControllerScroll`
/// encloses all `gtk.EventControllerScroll.signals.scroll` emissions
/// between two `gtk.EventControllerScroll.signals.scroll_begin` and
/// `gtk.EventControllerScroll.signals.scroll_end` signals.
///
/// The behavior of the event controller can be modified by the flags
/// given at creation time, or modified at a later point through
/// `gtk.EventControllerScroll.setFlags` (e.g. because the scrolling
/// conditions of the widget changed).
///
/// The controller can be set up to emit motion for either/both vertical
/// and horizontal scroll events through `GTK_EVENT_CONTROLLER_SCROLL_VERTICAL`,
/// `GTK_EVENT_CONTROLLER_SCROLL_HORIZONTAL` and `GTK_EVENT_CONTROLLER_SCROLL_BOTH_AXES`.
/// If any axis is disabled, the respective `gtk.EventControllerScroll.signals.scroll`
/// delta will be 0. Vertical scroll events will be translated to horizontal
/// motion for the devices incapable of horizontal scrolling.
///
/// The event controller can also be forced to emit discrete events on all
/// devices through `GTK_EVENT_CONTROLLER_SCROLL_DISCRETE`. This can be used
/// to implement discrete actions triggered through scroll events (e.g.
/// switching across combobox options).
///
/// The `GTK_EVENT_CONTROLLER_SCROLL_KINETIC` flag toggles the emission of the
/// `gtk.EventControllerScroll.signals.decelerate` signal, emitted at the end
/// of scrolling with two X/Y velocity arguments that are consistent with the
/// motion that was received.
pub const EventControllerScroll = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.EventControllerScrollClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The flags affecting event controller behavior.
        pub const flags = struct {
            pub const name = "flags";

            pub const Type = gtk.EventControllerScrollFlags;
        };
    };

    pub const signals = struct {
        /// Emitted after scroll is finished if the
        /// `GTK_EVENT_CONTROLLER_SCROLL_KINETIC` flag is set.
        ///
        /// `vel_x` and `vel_y` express the initial velocity that was
        /// imprinted by the scroll events. `vel_x` and `vel_y` are expressed in
        /// pixels/ms.
        pub const decelerate = struct {
            pub const name = "decelerate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_vel_x: f64, p_vel_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerScroll, p_instance))),
                    gobject.signalLookup("decelerate", EventControllerScroll.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signals that the widget should scroll by the
        /// amount specified by `dx` and `dy`.
        ///
        /// For the representation unit of the deltas, see
        /// `gtk.EventControllerScroll.getUnit`.
        pub const scroll = struct {
            pub const name = "scroll";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_dx: f64, p_dy: f64, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerScroll, p_instance))),
                    gobject.signalLookup("scroll", EventControllerScroll.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signals that a new scrolling operation has begun.
        ///
        /// It will only be emitted on devices capable of it.
        pub const scroll_begin = struct {
            pub const name = "scroll-begin";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerScroll, p_instance))),
                    gobject.signalLookup("scroll-begin", EventControllerScroll.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Signals that a scrolling operation has finished.
        ///
        /// It will only be emitted on devices capable of it.
        pub const scroll_end = struct {
            pub const name = "scroll-end";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EventControllerScroll, p_instance))),
                    gobject.signalLookup("scroll-end", EventControllerScroll.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new event controller that will handle scroll events.
    extern fn gtk_event_controller_scroll_new(p_flags: gtk.EventControllerScrollFlags) *gtk.EventControllerScroll;
    pub const new = gtk_event_controller_scroll_new;

    /// Gets the flags conditioning the scroll controller behavior.
    extern fn gtk_event_controller_scroll_get_flags(p_scroll: *EventControllerScroll) gtk.EventControllerScrollFlags;
    pub const getFlags = gtk_event_controller_scroll_get_flags;

    /// Gets the scroll unit of the last
    /// `gtk.EventControllerScroll.signals.scroll` signal received.
    ///
    /// Always returns `GDK_SCROLL_UNIT_WHEEL` if the
    /// `GTK_EVENT_CONTROLLER_SCROLL_DISCRETE` flag is set.
    extern fn gtk_event_controller_scroll_get_unit(p_scroll: *EventControllerScroll) gdk.ScrollUnit;
    pub const getUnit = gtk_event_controller_scroll_get_unit;

    /// Sets the flags conditioning scroll controller behavior.
    extern fn gtk_event_controller_scroll_set_flags(p_scroll: *EventControllerScroll, p_flags: gtk.EventControllerScrollFlags) void;
    pub const setFlags = gtk_event_controller_scroll_set_flags;

    extern fn gtk_event_controller_scroll_get_type() usize;
    pub const getGObjectType = gtk_event_controller_scroll_get_type;

    extern fn g_object_ref(p_self: *gtk.EventControllerScroll) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EventControllerScroll) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EventControllerScroll, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkEveryFilter` matches an item when each of its filters matches.
///
/// To add filters to a `GtkEveryFilter`, use `gtk.MultiFilter.append`.
pub const EveryFilter = opaque {
    pub const Parent = gtk.MultiFilter;
    pub const Implements = [_]type{ gio.ListModel, gtk.Buildable };
    pub const Class = gtk.EveryFilterClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new empty "every" filter.
    ///
    /// Use `gtk.MultiFilter.append` to add filters to it.
    ///
    /// This filter matches an item if each of the filters added to it
    /// matches the item. In particular, this means that if no filter
    /// has been added to it, the filter matches every item.
    extern fn gtk_every_filter_new() *gtk.EveryFilter;
    pub const new = gtk_every_filter_new;

    extern fn gtk_every_filter_get_type() usize;
    pub const getGObjectType = gtk_every_filter_get_type;

    extern fn g_object_ref(p_self: *gtk.EveryFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.EveryFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EveryFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkExpander` allows the user to reveal its child by clicking
/// on an expander triangle.
///
/// ![An example GtkExpander](expander.png)
///
/// This is similar to the triangles used in a `GtkTreeView`.
///
/// Normally you use an expander as you would use a frame; you create
/// the child widget and use `gtk.Expander.setChild` to add it
/// to the expander. When the expander is toggled, it will take care of
/// showing and hiding the child automatically.
///
/// # Special Usage
///
/// There are situations in which you may prefer to show and hide the
/// expanded widget yourself, such as when you want to actually create
/// the widget at expansion time. In this case, create a `GtkExpander`
/// but do not add a child to it. The expander widget has an
/// `gtk.Expander.properties.expanded` property which can be used to
/// monitor its expansion state. You should watch this property with
/// a signal connection as follows:
///
/// ```c
/// static void
/// expander_callback (GObject    *object,
///                    GParamSpec *param_spec,
///                    gpointer    user_data)
/// {
///   GtkExpander *expander;
///
///   expander = GTK_EXPANDER (object);
///
///   if (gtk_expander_get_expanded (expander))
///     {
///       // Show or create widgets
///     }
///   else
///     {
///       // Hide or destroy widgets
///     }
/// }
///
/// static void
/// create_expander (void)
/// {
///   GtkWidget *expander = gtk_expander_new_with_mnemonic ("_More Options");
///   g_signal_connect (expander, "notify::expanded",
///                     G_CALLBACK (expander_callback), NULL);
///
///   // ...
/// }
/// ```
///
/// # GtkExpander as GtkBuildable
///
/// The `GtkExpander` implementation of the `GtkBuildable` interface supports
/// placing a child in the label position by specifying “label” as the
/// “type” attribute of a `<child>` element. A normal content child can be
/// specified without specifying a `<child>` type attribute.
///
/// An example of a UI definition fragment with GtkExpander:
///
/// ```xml
/// <object class="GtkExpander">
///   <child type="label">
///     <object class="GtkLabel" id="expander-label"/>
///   </child>
///   <child>
///     <object class="GtkEntry" id="expander-content"/>
///   </child>
/// </object>
/// ```
///
/// # CSS nodes
///
/// ```
/// expander-widget
/// ╰── box
///     ├── title
///     │   ├── expander
///     │   ╰── <label widget>
///     ╰── <child>
/// ```
///
/// `GtkExpander` has a main node `expander-widget`, and subnode `box` containing
/// the title and child widget. The box subnode `title` contains node `expander`,
/// i.e. the expand/collapse arrow; then the label widget if any. The arrow of an
/// expander that is showing its child gets the `:checked` pseudoclass set on it.
///
/// # Accessibility
///
/// `GtkExpander` uses the `GTK_ACCESSIBLE_ROLE_BUTTON` role.
pub const Expander = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = Expander;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// Whether the expander has been opened to reveal the child.
        pub const expanded = struct {
            pub const name = "expanded";

            pub const Type = c_int;
        };

        /// The text of the expanders label.
        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };

        /// A widget to display instead of the usual expander label.
        pub const label_widget = struct {
            pub const name = "label-widget";

            pub const Type = ?*gtk.Widget;
        };

        /// When this property is `TRUE`, the expander will resize the toplevel
        /// widget containing the expander upon expanding and collapsing.
        pub const resize_toplevel = struct {
            pub const name = "resize-toplevel";

            pub const Type = c_int;
        };

        /// Whether the text in the label is Pango markup.
        pub const use_markup = struct {
            pub const name = "use-markup";

            pub const Type = c_int;
        };

        /// Whether an underline in the text indicates a mnemonic.
        pub const use_underline = struct {
            pub const name = "use-underline";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Activates the `GtkExpander`.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Expander, p_instance))),
                    gobject.signalLookup("activate", Expander.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new expander using `label` as the text of the label.
    extern fn gtk_expander_new(p_label: ?[*:0]const u8) *gtk.Expander;
    pub const new = gtk_expander_new;

    /// Creates a new expander using `label` as the text of the label.
    ///
    /// If characters in `label` are preceded by an underscore, they are
    /// underlined. If you need a literal underscore character in a label,
    /// use “__” (two underscores). The first underlined character represents
    /// a keyboard accelerator called a mnemonic.
    ///
    /// Pressing Alt and that key activates the button.
    extern fn gtk_expander_new_with_mnemonic(p_label: ?[*:0]const u8) *gtk.Expander;
    pub const newWithMnemonic = gtk_expander_new_with_mnemonic;

    /// Gets the child widget of `expander`.
    extern fn gtk_expander_get_child(p_expander: *Expander) ?*gtk.Widget;
    pub const getChild = gtk_expander_get_child;

    /// Queries a `GtkExpander` and returns its current state.
    ///
    /// Returns `TRUE` if the child widget is revealed.
    extern fn gtk_expander_get_expanded(p_expander: *Expander) c_int;
    pub const getExpanded = gtk_expander_get_expanded;

    /// Fetches the text from a label widget.
    ///
    /// This is including any embedded underlines indicating mnemonics and
    /// Pango markup, as set by `gtk.Expander.setLabel`. If the label
    /// text has not been set the return value will be `NULL`. This will be the
    /// case if you create an empty button with `gtk.Button.new` to use as a
    /// container.
    extern fn gtk_expander_get_label(p_expander: *Expander) ?[*:0]const u8;
    pub const getLabel = gtk_expander_get_label;

    /// Retrieves the label widget for the frame.
    extern fn gtk_expander_get_label_widget(p_expander: *Expander) ?*gtk.Widget;
    pub const getLabelWidget = gtk_expander_get_label_widget;

    /// Returns whether the expander will resize the toplevel widget
    /// containing the expander upon resizing and collapsing.
    extern fn gtk_expander_get_resize_toplevel(p_expander: *Expander) c_int;
    pub const getResizeToplevel = gtk_expander_get_resize_toplevel;

    /// Returns whether the label’s text is interpreted as Pango markup.
    extern fn gtk_expander_get_use_markup(p_expander: *Expander) c_int;
    pub const getUseMarkup = gtk_expander_get_use_markup;

    /// Returns whether an underline in the text indicates a mnemonic.
    extern fn gtk_expander_get_use_underline(p_expander: *Expander) c_int;
    pub const getUseUnderline = gtk_expander_get_use_underline;

    /// Sets the child widget of `expander`.
    extern fn gtk_expander_set_child(p_expander: *Expander, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_expander_set_child;

    /// Sets the state of the expander.
    ///
    /// Set to `TRUE`, if you want the child widget to be revealed,
    /// and `FALSE` if you want the child widget to be hidden.
    extern fn gtk_expander_set_expanded(p_expander: *Expander, p_expanded: c_int) void;
    pub const setExpanded = gtk_expander_set_expanded;

    /// Sets the text of the label of the expander to `label`.
    ///
    /// This will also clear any previously set labels.
    extern fn gtk_expander_set_label(p_expander: *Expander, p_label: ?[*:0]const u8) void;
    pub const setLabel = gtk_expander_set_label;

    /// Set the label widget for the expander.
    ///
    /// This is the widget that will appear embedded alongside
    /// the expander arrow.
    extern fn gtk_expander_set_label_widget(p_expander: *Expander, p_label_widget: ?*gtk.Widget) void;
    pub const setLabelWidget = gtk_expander_set_label_widget;

    /// Sets whether the expander will resize the toplevel widget
    /// containing the expander upon resizing and collapsing.
    extern fn gtk_expander_set_resize_toplevel(p_expander: *Expander, p_resize_toplevel: c_int) void;
    pub const setResizeToplevel = gtk_expander_set_resize_toplevel;

    /// Sets whether the text of the label contains Pango markup.
    extern fn gtk_expander_set_use_markup(p_expander: *Expander, p_use_markup: c_int) void;
    pub const setUseMarkup = gtk_expander_set_use_markup;

    /// If true, an underline in the text indicates a mnemonic.
    extern fn gtk_expander_set_use_underline(p_expander: *Expander, p_use_underline: c_int) void;
    pub const setUseUnderline = gtk_expander_set_use_underline;

    extern fn gtk_expander_get_type() usize;
    pub const getGObjectType = gtk_expander_get_type;

    extern fn g_object_ref(p_self: *gtk.Expander) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Expander) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Expander, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkExpression` provides a way to describe references to values.
///
/// An important aspect of expressions is that the value can be obtained
/// from a source that is several steps away. For example, an expression
/// may describe ‘the value of property A of `object1`, which is itself the
/// value of a property of `object2`’. And `object1` may not even exist yet
/// at the time that the expression is created. This is contrast to `GObject`
/// property bindings, which can only create direct connections between
/// the properties of two objects that must both exist for the duration
/// of the binding.
///
/// An expression needs to be "evaluated" to obtain the value that it currently
/// refers to. An evaluation always happens in the context of a current object
/// called `this` (it mirrors the behavior of object-oriented languages),
/// which may or may not influence the result of the evaluation. Use
/// `gtk.Expression.evaluate` for evaluating an expression.
///
/// Various methods for defining expressions exist, from simple constants via
/// `gtk.ConstantExpression.new` to looking up properties in a `GObject`
/// (even recursively) via `gtk.PropertyExpression.new` or providing
/// custom functions to transform and combine expressions via
/// `gtk.ClosureExpression.new`.
///
/// Here is an example of a complex expression:
///
/// ```c
///   color_expr = gtk_property_expression_new (GTK_TYPE_LIST_ITEM,
///                                             NULL, "item");
///   expression = gtk_property_expression_new (GTK_TYPE_COLOR,
///                                             color_expr, "name");
/// ```
///
/// when evaluated with `this` being a `GtkListItem`, it will obtain the
/// "item" property from the `GtkListItem`, and then obtain the "name" property
/// from the resulting object (which is assumed to be of type `GTK_TYPE_COLOR`).
///
/// A more concise way to describe this would be
///
/// ```
///   this->item->name
/// ```
///
/// The most likely place where you will encounter expressions is in the context
/// of list models and list widgets using them. For example, `GtkDropDown` is
/// evaluating a `GtkExpression` to obtain strings from the items in its model
/// that it can then use to match against the contents of its search entry.
/// `GtkStringFilter` is using a `GtkExpression` for similar reasons.
///
/// By default, expressions are not paying attention to changes and evaluation is
/// just a snapshot of the current state at a given time. To get informed about
/// changes, an expression needs to be "watched" via a `gtk.ExpressionWatch`,
/// which will cause a callback to be called whenever the value of the expression may
/// have changed; `gtk.Expression.watch` starts watching an expression, and
/// `gtk.ExpressionWatch.unwatch` stops.
///
/// Watches can be created for automatically updating the property of an object,
/// similar to GObject's `GBinding` mechanism, by using `gtk.Expression.bind`.
///
/// ## GtkExpression in GObject properties
///
/// In order to use a `GtkExpression` as a `GObject` property, you must use the
/// `gtk.paramSpecExpression` when creating a `GParamSpec` to install in the
/// `GObject` class being defined; for instance:
///
/// ```c
/// obj_props[PROP_EXPRESSION] =
///   gtk_param_spec_expression ("expression",
///                              "Expression",
///                              "The expression used by the widget",
///                              G_PARAM_READWRITE |
///                              G_PARAM_STATIC_STRINGS |
///                              G_PARAM_EXPLICIT_NOTIFY);
/// ```
///
/// When implementing the `GObjectClass.set_property` and `GObjectClass.get_property`
/// virtual functions, you must use `gtk.valueGetExpression`, to retrieve the
/// stored `GtkExpression` from the `GValue` container, and `gtk.valueSetExpression`,
/// to store the `GtkExpression` into the `GValue`; for instance:
///
/// ```c
///   // in `set_property`...
///   case PROP_EXPRESSION:
///     foo_widget_set_expression (foo, gtk_value_get_expression (value));
///     break;
///
///   // in `get_property`...
///   case PROP_EXPRESSION:
///     gtk_value_set_expression (value, foo->expression);
///     break;
/// ```
///
/// ## GtkExpression in .ui files
///
/// `GtkBuilder` has support for creating expressions. The syntax here can be used where
/// a `GtkExpression` object is needed like in a `<property>` tag for an expression
/// property, or in a `<binding name="property">` tag to bind a property to an expression.
///
/// To create a property expression, use the `<lookup>` element. It can have a `type`
/// attribute to specify the object type, and a `name` attribute to specify the property
/// to look up. The content of `<lookup>` can either be an element specifying the expression
/// to use the object, or a string that specifies the name of the object to use.
///
/// Example:
///
/// ```xml
///   <lookup name='search'>string_filter</lookup>
/// ```
///
/// Since the `<lookup>` element creates an expression and its element content can
/// itself be an expression, this means that `<lookup>` tags can also be nested.
/// This is a common idiom when dealing with `GtkListItem`s. See
/// `gtk.BuilderListItemFactory` for an example of this technique.
///
/// To create a constant expression, use the `<constant>` element. If the type attribute
/// is specified, the element content is interpreted as a value of that type. Otherwise,
/// it is assumed to be an object. For instance:
///
/// ```xml
///   <constant>string_filter</constant>
///   <constant type='gchararray'>Hello, world</constant>
/// ```
///
/// To create a closure expression, use the `<closure>` element. The `function`
/// attribute specifies what function to use for the closure, and the `type`
/// attribute specifies its return type. The content of the element contains the
/// expressions for the parameters. For instance:
///
/// ```xml
///   <closure type='gchararray' function='combine_args_somehow'>
///     <constant type='gchararray'>File size:</constant>
///     <lookup type='GFile' name='size'>myfile</lookup>
///   </closure>
/// ```
///
/// To create a property binding, use the `<binding>` element in place of where a
/// `<property>` tag would ordinarily be used. The `name` and `object` attributes are
/// supported. The `name` attribute is required, and pertains to the applicable property
/// name. The `object` attribute is optional. If provided, it will use the specified object
/// as the `this` object when the expression is evaluated. Here is an example in which the
/// `label` property of a `GtkLabel` is bound to the `string` property of another arbitrary
/// object:
///
/// ```xml
///   <object class='GtkLabel'>
///     <binding name='label'>
///       <lookup name='string'>some_other_object</lookup>
///     </binding>
///   </object>
/// ```
pub const Expression = opaque {
    pub const Parent = gobject.TypeInstance;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = Expression;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Bind `target`'s property named `property` to `self`.
    ///
    /// The value that `self` evaluates to is set via ``gobject.Object.set`` on
    /// `target`. This is repeated whenever `self` changes to ensure that
    /// the object's property stays synchronized with `self`.
    ///
    /// If `self`'s evaluation fails, `target`'s `property` is not updated.
    /// You can ensure that this doesn't happen by using a fallback
    /// expression.
    ///
    /// Note that this function takes ownership of `self`. If you want
    /// to keep it around, you should `gtk.Expression.ref` it beforehand.
    extern fn gtk_expression_bind(p_self: *Expression, p_target: *gobject.Object, p_property: [*:0]const u8, p_this_: ?*gobject.Object) *gtk.ExpressionWatch;
    pub const bind = gtk_expression_bind;

    /// Evaluates the given expression and on success stores the result
    /// in `value`.
    ///
    /// The `GType` of `value` will be the type given by
    /// `gtk.Expression.getValueType`.
    ///
    /// It is possible that expressions cannot be evaluated - for example
    /// when the expression references objects that have been destroyed or
    /// set to `NULL`. In that case `value` will remain empty and `FALSE`
    /// will be returned.
    extern fn gtk_expression_evaluate(p_self: *Expression, p_this_: ?*gobject.Object, p_value: *gobject.Value) c_int;
    pub const evaluate = gtk_expression_evaluate;

    /// Gets the `GType` that this expression evaluates to.
    ///
    /// This type is constant and will not change over the lifetime
    /// of this expression.
    extern fn gtk_expression_get_value_type(p_self: *Expression) usize;
    pub const getValueType = gtk_expression_get_value_type;

    /// Checks if the expression is static.
    ///
    /// A static expression will never change its result when
    /// `gtk.Expression.evaluate` is called on it with the same arguments.
    ///
    /// That means a call to `gtk.Expression.watch` is not necessary because
    /// it will never trigger a notify.
    extern fn gtk_expression_is_static(p_self: *Expression) c_int;
    pub const isStatic = gtk_expression_is_static;

    /// Acquires a reference on the given `GtkExpression`.
    extern fn gtk_expression_ref(p_self: *Expression) *gtk.Expression;
    pub const ref = gtk_expression_ref;

    /// Releases a reference on the given `GtkExpression`.
    ///
    /// If the reference was the last, the resources associated to the `self` are
    /// freed.
    extern fn gtk_expression_unref(p_self: *Expression) void;
    pub const unref = gtk_expression_unref;

    /// Watch the given `expression` for changes.
    ///
    /// The `notify` function will be called whenever the evaluation of `self`
    /// may have changed.
    ///
    /// GTK cannot guarantee that the evaluation did indeed change when the `notify`
    /// gets invoked, but it guarantees the opposite: When it did in fact change,
    /// the `notify` will be invoked.
    extern fn gtk_expression_watch(p_self: *Expression, p_this_: ?*gobject.Object, p_notify: gtk.ExpressionNotify, p_user_data: ?*anyopaque, p_user_destroy: ?glib.DestroyNotify) *gtk.ExpressionWatch;
    pub const watch = gtk_expression_watch;

    extern fn gtk_expression_get_type() usize;
    pub const getGObjectType = gtk_expression_get_type;

    pub fn as(p_instance: *Expression, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFileChooserDialog` is a dialog suitable for use with
/// “File Open” or “File Save” commands.
///
/// ![An example GtkFileChooserDialog](filechooser.png)
///
/// This widget works by putting a `gtk.FileChooserWidget`
/// inside a `gtk.Dialog`. It exposes the `gtk.FileChooser`
/// interface, so you can use all of the `gtk.FileChooser` functions
/// on the file chooser dialog as well as those for `gtk.Dialog`.
///
/// Note that `GtkFileChooserDialog` does not have any methods of its
/// own. Instead, you should use the functions that work on a
/// `gtk.FileChooser`.
///
/// If you want to integrate well with the platform you should use the
/// `gtk.FileChooserNative` API, which will use a platform-specific
/// dialog if available and fall back to `GtkFileChooserDialog`
/// otherwise.
///
/// ## Typical usage
///
/// In the simplest of cases, you can the following code to use
/// `GtkFileChooserDialog` to select a file for opening:
///
/// ```c
/// static void
/// on_open_response (GtkDialog *dialog,
///                   int        response)
/// {
///   if (response == GTK_RESPONSE_ACCEPT)
///     {
///       GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);
///
///       g_autoptr(GFile) file = gtk_file_chooser_get_file (chooser);
///
///       open_file (file);
///     }
///
///   gtk_window_destroy (GTK_WINDOW (dialog));
/// }
///
///   // ...
///   GtkWidget *dialog;
///   GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;
///
///   dialog = gtk_file_chooser_dialog_new ("Open File",
///                                         parent_window,
///                                         action,
///                                         _("_Cancel"),
///                                         GTK_RESPONSE_CANCEL,
///                                         _("_Open"),
///                                         GTK_RESPONSE_ACCEPT,
///                                         NULL);
///
///   gtk_window_present (GTK_WINDOW (dialog));
///
///   g_signal_connect (dialog, "response",
///                     G_CALLBACK (on_open_response),
///                     NULL);
/// ```
///
/// To use a dialog for saving, you can use this:
///
/// ```c
/// static void
/// on_save_response (GtkDialog *dialog,
///                   int        response)
/// {
///   if (response == GTK_RESPONSE_ACCEPT)
///     {
///       GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);
///
///       g_autoptr(GFile) file = gtk_file_chooser_get_file (chooser);
///
///       save_to_file (file);
///     }
///
///   gtk_window_destroy (GTK_WINDOW (dialog));
/// }
///
///   // ...
///   GtkWidget *dialog;
///   GtkFileChooser *chooser;
///   GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SAVE;
///
///   dialog = gtk_file_chooser_dialog_new ("Save File",
///                                         parent_window,
///                                         action,
///                                         _("_Cancel"),
///                                         GTK_RESPONSE_CANCEL,
///                                         _("_Save"),
///                                         GTK_RESPONSE_ACCEPT,
///                                         NULL);
///   chooser = GTK_FILE_CHOOSER (dialog);
///
///   if (user_edited_a_new_document)
///     gtk_file_chooser_set_current_name (chooser, _("Untitled document"));
///   else
///     gtk_file_chooser_set_file (chooser, existing_filename);
///
///   gtk_window_present (GTK_WINDOW (dialog));
///
///   g_signal_connect (dialog, "response",
///                     G_CALLBACK (on_save_response),
///                     NULL);
/// ```
///
/// ## Setting up a file chooser dialog
///
/// There are various cases in which you may need to use a `GtkFileChooserDialog`:
///
/// - To select a file for opening, use `GTK_FILE_CHOOSER_ACTION_OPEN`.
///
/// - To save a file for the first time, use `GTK_FILE_CHOOSER_ACTION_SAVE`,
///   and suggest a name such as “Untitled” with
///   `gtk.FileChooser.setCurrentName`.
///
/// - To save a file under a different name, use `GTK_FILE_CHOOSER_ACTION_SAVE`,
///   and set the existing file with `gtk.FileChooser.setFile`.
///
/// - To choose a folder instead of a filem use `GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER`.
///
/// In general, you should only cause the file chooser to show a specific
/// folder when it is appropriate to use `gtk.FileChooser.setFile`,
/// i.e. when you are doing a “Save As” command and you already have a file
/// saved somewhere.
///
/// ## Response Codes
///
/// `GtkFileChooserDialog` inherits from `gtk.Dialog`, so buttons that
/// go in its action area have response codes such as `GTK_RESPONSE_ACCEPT` and
/// `GTK_RESPONSE_CANCEL`. For example, you could call
/// `gtk.FileChooserDialog.new` as follows:
///
/// ```c
/// GtkWidget *dialog;
/// GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;
///
/// dialog = gtk_file_chooser_dialog_new ("Open File",
///                                       parent_window,
///                                       action,
///                                       _("_Cancel"),
///                                       GTK_RESPONSE_CANCEL,
///                                       _("_Open"),
///                                       GTK_RESPONSE_ACCEPT,
///                                       NULL);
/// ```
///
/// This will create buttons for “Cancel” and “Open” that use predefined
/// response identifiers from `gtk.ResponseType`.  For most dialog
/// boxes you can use your own custom response codes rather than the
/// ones in `gtk.ResponseType`, but `GtkFileChooserDialog` assumes that
/// its “accept”-type action, e.g. an “Open” or “Save” button,
/// will have one of the following response codes:
///
/// - `GTK_RESPONSE_ACCEPT`
/// - `GTK_RESPONSE_OK`
/// - `GTK_RESPONSE_YES`
/// - `GTK_RESPONSE_APPLY`
///
/// This is because `GtkFileChooserDialog` must intercept responses and switch
/// to folders if appropriate, rather than letting the dialog terminate — the
/// implementation uses these known response codes to know which responses can
/// be blocked if appropriate.
///
/// To summarize, make sure you use a predefined response code
/// when you use `GtkFileChooserDialog` to ensure proper operation.
///
/// ## CSS nodes
///
/// `GtkFileChooserDialog` has a single CSS node with the name `window` and style
/// class `.filechooser`.
pub const FileChooserDialog = opaque {
    pub const Parent = gtk.Dialog;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.FileChooser, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = opaque {
        pub const Instance = FileChooserDialog;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkFileChooserDialog`.
    ///
    /// This function is analogous to `gtk.Dialog.newWithButtons`.
    extern fn gtk_file_chooser_dialog_new(p_title: ?[*:0]const u8, p_parent: ?*gtk.Window, p_action: gtk.FileChooserAction, p_first_button_text: ?[*:0]const u8, ...) *gtk.FileChooserDialog;
    pub const new = gtk_file_chooser_dialog_new;

    extern fn gtk_file_chooser_dialog_get_type() usize;
    pub const getGObjectType = gtk_file_chooser_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.FileChooserDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FileChooserDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileChooserDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFileChooserNative` is an abstraction of a dialog suitable
/// for use with “File Open” or “File Save as” commands.
///
/// By default, this just uses a `GtkFileChooserDialog` to implement
/// the actual dialog. However, on some platforms, such as Windows and
/// macOS, the native platform file chooser is used instead. When the
/// application is running in a sandboxed environment without direct
/// filesystem access (such as Flatpak), `GtkFileChooserNative` may call
/// the proper APIs (portals) to let the user choose a file and make it
/// available to the application.
///
/// While the API of `GtkFileChooserNative` closely mirrors `GtkFileChooserDialog`,
/// the main difference is that there is no access to any `GtkWindow` or `GtkWidget`
/// for the dialog. This is required, as there may not be one in the case of a
/// platform native dialog.
///
/// Showing, hiding and running the dialog is handled by the
/// `gtk.NativeDialog` functions.
///
/// Note that unlike `GtkFileChooserDialog`, `GtkFileChooserNative` objects
/// are not toplevel widgets, and GTK does not keep them alive. It is your
/// responsibility to keep a reference until you are done with the
/// object.
///
/// ## Typical usage
///
/// In the simplest of cases, you can the following code to use
/// `GtkFileChooserNative` to select a file for opening:
///
/// ```c
/// static void
/// on_response (GtkNativeDialog *native,
///              int              response)
/// {
///   if (response == GTK_RESPONSE_ACCEPT)
///     {
///       GtkFileChooser *chooser = GTK_FILE_CHOOSER (native);
///       GFile *file = gtk_file_chooser_get_file (chooser);
///
///       open_file (file);
///
///       g_object_unref (file);
///     }
///
///   g_object_unref (native);
/// }
///
///   // ...
///   GtkFileChooserNative *native;
///   GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;
///
///   native = gtk_file_chooser_native_new ("Open File",
///                                         parent_window,
///                                         action,
///                                         "_Open",
///                                         "_Cancel");
///
///   g_signal_connect (native, "response", G_CALLBACK (on_response), NULL);
///   gtk_native_dialog_show (GTK_NATIVE_DIALOG (native));
/// ```
///
/// To use a `GtkFileChooserNative` for saving, you can use this:
///
/// ```c
/// static void
/// on_response (GtkNativeDialog *native,
///              int              response)
/// {
///   if (response == GTK_RESPONSE_ACCEPT)
///     {
///       GtkFileChooser *chooser = GTK_FILE_CHOOSER (native);
///       GFile *file = gtk_file_chooser_get_file (chooser);
///
///       save_to_file (file);
///
///       g_object_unref (file);
///     }
///
///   g_object_unref (native);
/// }
///
///   // ...
///   GtkFileChooserNative *native;
///   GtkFileChooser *chooser;
///   GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SAVE;
///
///   native = gtk_file_chooser_native_new ("Save File",
///                                         parent_window,
///                                         action,
///                                         "_Save",
///                                         "_Cancel");
///   chooser = GTK_FILE_CHOOSER (native);
///
///   if (user_edited_a_new_document)
///     gtk_file_chooser_set_current_name (chooser, _("Untitled document"));
///   else
///     gtk_file_chooser_set_file (chooser, existing_file, NULL);
///
///   g_signal_connect (native, "response", G_CALLBACK (on_response), NULL);
///   gtk_native_dialog_show (GTK_NATIVE_DIALOG (native));
/// ```
///
/// For more information on how to best set up a file dialog,
/// see the `gtk.FileChooserDialog` documentation.
///
/// ## Response Codes
///
/// `GtkFileChooserNative` inherits from `gtk.NativeDialog`,
/// which means it will return `GTK_RESPONSE_ACCEPT` if the user accepted,
/// and `GTK_RESPONSE_CANCEL` if he pressed cancel. It can also return
/// `GTK_RESPONSE_DELETE_EVENT` if the window was unexpectedly closed.
///
/// ## Differences from `GtkFileChooserDialog`
///
/// There are a few things in the `gtk.FileChooser` interface that
/// are not possible to use with `GtkFileChooserNative`, as such use would
/// prohibit the use of a native dialog.
///
/// No operations that change the dialog work while the dialog is visible.
/// Set all the properties that are required before showing the dialog.
///
/// ## Win32 details
///
/// On windows the `IFileDialog` implementation (added in Windows Vista) is
/// used. It supports many of the features that `GtkFileChooser` has, but
/// there are some things it does not handle:
///
/// * Any `gtk.FileFilter` added using a mimetype
///
/// If any of these features are used the regular `GtkFileChooserDialog`
/// will be used in place of the native one.
///
/// ## Portal details
///
/// When the `org.freedesktop.portal.FileChooser` portal is available on
/// the session bus, it is used to bring up an out-of-process file chooser.
/// Depending on the kind of session the application is running in, this may
/// or may not be a GTK file chooser.
///
/// ## macOS details
///
/// On macOS the `NSSavePanel` and `NSOpenPanel` classes are used to provide
/// native file chooser dialogs. Some features provided by `GtkFileChooser`
/// are not supported:
///
/// * Shortcut folders.
pub const FileChooserNative = opaque {
    pub const Parent = gtk.NativeDialog;
    pub const Implements = [_]type{gtk.FileChooser};
    pub const Class = gtk.FileChooserNativeClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The text used for the label on the accept button in the dialog, or
        /// `NULL` to use the default text.
        pub const accept_label = struct {
            pub const name = "accept-label";

            pub const Type = ?[*:0]u8;
        };

        /// The text used for the label on the cancel button in the dialog, or
        /// `NULL` to use the default text.
        pub const cancel_label = struct {
            pub const name = "cancel-label";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFileChooserNative`.
    extern fn gtk_file_chooser_native_new(p_title: ?[*:0]const u8, p_parent: ?*gtk.Window, p_action: gtk.FileChooserAction, p_accept_label: ?[*:0]const u8, p_cancel_label: ?[*:0]const u8) *gtk.FileChooserNative;
    pub const new = gtk_file_chooser_native_new;

    /// Retrieves the custom label text for the accept button.
    extern fn gtk_file_chooser_native_get_accept_label(p_self: *FileChooserNative) ?[*:0]const u8;
    pub const getAcceptLabel = gtk_file_chooser_native_get_accept_label;

    /// Retrieves the custom label text for the cancel button.
    extern fn gtk_file_chooser_native_get_cancel_label(p_self: *FileChooserNative) ?[*:0]const u8;
    pub const getCancelLabel = gtk_file_chooser_native_get_cancel_label;

    /// Sets the custom label text for the accept button.
    ///
    /// If characters in `label` are preceded by an underscore, they are
    /// underlined. If you need a literal underscore character in a label,
    /// use “__” (two underscores). The first underlined character represents
    /// a keyboard accelerator called a mnemonic.
    ///
    /// Pressing Alt and that key should activate the button.
    extern fn gtk_file_chooser_native_set_accept_label(p_self: *FileChooserNative, p_accept_label: ?[*:0]const u8) void;
    pub const setAcceptLabel = gtk_file_chooser_native_set_accept_label;

    /// Sets the custom label text for the cancel button.
    ///
    /// If characters in `label` are preceded by an underscore, they are
    /// underlined. If you need a literal underscore character in a label,
    /// use “__” (two underscores). The first underlined character represents
    /// a keyboard accelerator called a mnemonic.
    ///
    /// Pressing Alt and that key should activate the button.
    extern fn gtk_file_chooser_native_set_cancel_label(p_self: *FileChooserNative, p_cancel_label: ?[*:0]const u8) void;
    pub const setCancelLabel = gtk_file_chooser_native_set_cancel_label;

    extern fn gtk_file_chooser_native_get_type() usize;
    pub const getGObjectType = gtk_file_chooser_native_get_type;

    extern fn g_object_ref(p_self: *gtk.FileChooserNative) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FileChooserNative) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileChooserNative, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFileChooserWidget` is a widget for choosing files.
///
/// It exposes the `gtk.FileChooser` interface, and you should
/// use the methods of this interface to interact with the
/// widget.
///
/// # Shortcuts and Gestures
///
/// `GtkFileChooserWidget` supports the following keyboard shortcuts:
///
/// - <kbd>Shift</kbd>+<kbd>F10</kbd> or <kbd>Menu</kbd> opens the context menu.
///
/// The following signals have default keybindings:
///
/// - `gtk.FileChooserWidget.signals.desktop_folder`
/// - `gtk.FileChooserWidget.signals.down_folder`
/// - `gtk.FileChooserWidget.signals.home_folder`
/// - `gtk.FileChooserWidget.signals.location_popup`
/// - `gtk.FileChooserWidget.signals.location_popup_on_paste`
/// - `gtk.FileChooserWidget.signals.location_toggle_popup`
/// - `gtk.FileChooserWidget.signals.places_shortcut`
/// - `gtk.FileChooserWidget.signals.quick_bookmark`
/// - `gtk.FileChooserWidget.signals.recent_shortcut`
/// - `gtk.FileChooserWidget.signals.search_shortcut`
/// - `gtk.FileChooserWidget.signals.show_hidden`
/// - `gtk.FileChooserWidget.signals.up_folder`
///
/// # CSS nodes
///
/// `GtkFileChooserWidget` has a single CSS node with name filechooser.
pub const FileChooserWidget = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.FileChooser };
    pub const Class = opaque {
        pub const Instance = FileChooserWidget;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether search mode is enabled.
        pub const search_mode = struct {
            pub const name = "search-mode";

            pub const Type = c_int;
        };

        /// Whether to show the time.
        pub const show_time = struct {
            pub const name = "show-time";

            pub const Type = c_int;
        };

        /// The subtitle of the file chooser widget.
        pub const subtitle = struct {
            pub const name = "subtitle";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser show the user's Desktop
        /// folder in the file list.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>D</kbd>.
        pub const desktop_folder = struct {
            pub const name = "desktop-folder";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("desktop-folder", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser go to a child of the
        /// current folder in the file hierarchy. The subfolder that will
        /// be used is displayed in the path bar widget of the file chooser.
        /// For example, if the path bar is showing "/foo/bar/baz", with bar
        /// currently displayed, then this will cause the file chooser to
        /// switch to the "baz" subfolder.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>Down</kbd>.
        pub const down_folder = struct {
            pub const name = "down-folder";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("down-folder", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser show the user's home
        /// folder in the file list.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>Home</kbd>.
        pub const home_folder = struct {
            pub const name = "home-folder";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("home-folder", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser show a "Location" prompt which
        /// the user can use to manually type the name of the file he wishes to select.
        ///
        /// The default bindings for this signal are <kbd>Control</kbd>-<kbd>L</kbd>
        /// with a `path` string of "" (the empty string). It is also bound to
        /// <kbd>/</kbd> with a `path` string of "`/`" (a slash):  this lets you
        /// type `/` and immediately type a path name. On Unix systems, this is
        /// bound to <kbd>~</kbd> (tilde) with a `path` string of "~" itself for
        /// access to home directories.
        pub const location_popup = struct {
            pub const name = "location-popup";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_path: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("location-popup", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser show a "Location" prompt
        /// when the user pastes into a `GtkFileChooserWidget`.
        ///
        /// The default binding for this signal is <kbd>Control</kbd>-<kbd>V</kbd>.
        pub const location_popup_on_paste = struct {
            pub const name = "location-popup-on-paste";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("location-popup-on-paste", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to toggle the visibility of a "Location" prompt
        /// which the user can use to manually type the name of the file
        /// he wishes to select.
        ///
        /// The default binding for this signal is <kbd>Control</kbd>-<kbd>L</kbd>.
        pub const location_toggle_popup = struct {
            pub const name = "location-toggle-popup";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("location-toggle-popup", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to move the focus to the places sidebar.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>P</kbd>.
        pub const places_shortcut = struct {
            pub const name = "places-shortcut";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("places-shortcut", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser switch to the bookmark
        /// specified in the `bookmark_index` parameter. For example, if
        /// you have three bookmarks, you can pass 0, 1, 2 to this signal
        /// to switch to each of them, respectively.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>1</kbd>,
        /// <kbd>Alt</kbd>-<kbd>2</kbd>, etc. until <kbd>Alt</kbd>-<kbd>0</kbd>.
        /// Note that in the default binding, that <kbd>Alt</kbd>-<kbd>1</kbd> is
        /// actually defined to switch to the bookmark at index 0, and so on
        /// successively.
        pub const quick_bookmark = struct {
            pub const name = "quick-bookmark";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_bookmark_index: c_int, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("quick-bookmark", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser show the Recent location.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>R</kbd>.
        pub const recent_shortcut = struct {
            pub const name = "recent-shortcut";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("recent-shortcut", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser show the search entry.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>S</kbd>.
        pub const search_shortcut = struct {
            pub const name = "search-shortcut";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("search-shortcut", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser display hidden files.
        ///
        /// The default binding for this signal is <kbd>Control</kbd>-<kbd>H</kbd>.
        pub const show_hidden = struct {
            pub const name = "show-hidden";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("show-hidden", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user asks for it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// This is used to make the file chooser go to the parent
        /// of the current folder in the file hierarchy.
        ///
        /// The default binding for this signal is <kbd>Alt</kbd>-<kbd>Up</kbd>.
        pub const up_folder = struct {
            pub const name = "up-folder";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FileChooserWidget, p_instance))),
                    gobject.signalLookup("up-folder", FileChooserWidget.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkFileChooserWidget`.
    ///
    /// This is a file chooser widget that can be embedded in custom
    /// windows, and it is the same widget that is used by
    /// `GtkFileChooserDialog`.
    extern fn gtk_file_chooser_widget_new(p_action: gtk.FileChooserAction) *gtk.FileChooserWidget;
    pub const new = gtk_file_chooser_widget_new;

    extern fn gtk_file_chooser_widget_get_type() usize;
    pub const getGObjectType = gtk_file_chooser_widget_get_type;

    extern fn g_object_ref(p_self: *gtk.FileChooserWidget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FileChooserWidget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileChooserWidget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkFileDialog` object collects the arguments that
/// are needed to present a file chooser dialog to the
/// user, such as a title for the dialog and whether it
/// should be modal.
///
/// The dialog is shown with `gtk.FileDialog.open`,
/// `gtk.FileDialog.save`, etc.
pub const FileDialog = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.FileDialogClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Label for the file chooser's accept button.
        pub const accept_label = struct {
            pub const name = "accept-label";

            pub const Type = ?[*:0]u8;
        };

        /// The default filter, that is, the filter that is initially
        /// active in the file chooser dialog.
        ///
        /// If the default filter is `NULL`, the first filter of `gtk.FileDialog.properties.filters`
        /// is used as the default filter. If that property contains no filter, the dialog will
        /// be unfiltered.
        ///
        /// If `gtk.FileDialog.properties.filters` is not `NULL`, the default filter should be part
        /// of the list. If it is not, the dialog may choose to not make it available.
        pub const default_filter = struct {
            pub const name = "default-filter";

            pub const Type = ?*gtk.FileFilter;
        };

        /// The list of filters.
        ///
        /// See `gtk.FileDialog.properties.default_filter` about how those two properties interact.
        pub const filters = struct {
            pub const name = "filters";

            pub const Type = ?*gio.ListModel;
        };

        /// The initial file, that is, the file that is initially selected
        /// in the file chooser dialog
        ///
        /// This is a utility property that sets both `gtk.FileDialog.properties.initial_folder` and
        /// `gtk.FileDialog.properties.initial_name`.
        pub const initial_file = struct {
            pub const name = "initial-file";

            pub const Type = ?*gio.File;
        };

        /// The initial folder, that is, the directory that is initially
        /// opened in the file chooser dialog
        pub const initial_folder = struct {
            pub const name = "initial-folder";

            pub const Type = ?*gio.File;
        };

        /// The initial name, that is, the filename that is initially
        /// selected in the file chooser dialog.
        pub const initial_name = struct {
            pub const name = "initial-name";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the file chooser dialog is modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };

        /// A title that may be shown on the file chooser dialog.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFileDialog` object.
    extern fn gtk_file_dialog_new() *gtk.FileDialog;
    pub const new = gtk_file_dialog_new;

    /// Retrieves the text used by the dialog on its accept button.
    extern fn gtk_file_dialog_get_accept_label(p_self: *FileDialog) ?[*:0]const u8;
    pub const getAcceptLabel = gtk_file_dialog_get_accept_label;

    /// Gets the filter that will be selected by default
    /// in the file chooser dialog.
    extern fn gtk_file_dialog_get_default_filter(p_self: *FileDialog) ?*gtk.FileFilter;
    pub const getDefaultFilter = gtk_file_dialog_get_default_filter;

    /// Gets the filters that will be offered to the user
    /// in the file chooser dialog.
    extern fn gtk_file_dialog_get_filters(p_self: *FileDialog) ?*gio.ListModel;
    pub const getFilters = gtk_file_dialog_get_filters;

    /// Gets the file that will be initially selected in
    /// the file chooser dialog.
    extern fn gtk_file_dialog_get_initial_file(p_self: *FileDialog) ?*gio.File;
    pub const getInitialFile = gtk_file_dialog_get_initial_file;

    /// Gets the folder that will be set as the
    /// initial folder in the file chooser dialog.
    extern fn gtk_file_dialog_get_initial_folder(p_self: *FileDialog) ?*gio.File;
    pub const getInitialFolder = gtk_file_dialog_get_initial_folder;

    /// Gets the name for the file that should be initially set.
    extern fn gtk_file_dialog_get_initial_name(p_self: *FileDialog) ?[*:0]const u8;
    pub const getInitialName = gtk_file_dialog_get_initial_name;

    /// Returns whether the file chooser dialog
    /// blocks interaction with the parent window
    /// while it is presented.
    extern fn gtk_file_dialog_get_modal(p_self: *FileDialog) c_int;
    pub const getModal = gtk_file_dialog_get_modal;

    /// Returns the title that will be shown on the
    /// file chooser dialog.
    extern fn gtk_file_dialog_get_title(p_self: *FileDialog) [*:0]const u8;
    pub const getTitle = gtk_file_dialog_get_title;

    /// This function initiates a file selection operation by
    /// presenting a file chooser dialog to the user.
    ///
    /// The `callback` will be called when the dialog is dismissed.
    extern fn gtk_file_dialog_open(p_self: *FileDialog, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const open = gtk_file_dialog_open;

    /// Finishes the `gtk.FileDialog.open` call and
    /// returns the resulting file.
    extern fn gtk_file_dialog_open_finish(p_self: *FileDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gio.File;
    pub const openFinish = gtk_file_dialog_open_finish;

    /// This function initiates a multi-file selection operation by
    /// presenting a file chooser dialog to the user.
    ///
    /// The file chooser will initially be opened in the directory
    /// `gtk.FileDialog.properties.initial_folder`.
    ///
    /// The `callback` will be called when the dialog is dismissed.
    extern fn gtk_file_dialog_open_multiple(p_self: *FileDialog, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const openMultiple = gtk_file_dialog_open_multiple;

    /// Finishes the `gtk.FileDialog.open` call and
    /// returns the resulting files in a `GListModel`.
    extern fn gtk_file_dialog_open_multiple_finish(p_self: *FileDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gio.ListModel;
    pub const openMultipleFinish = gtk_file_dialog_open_multiple_finish;

    /// This function initiates a file save operation by
    /// presenting a file chooser dialog to the user.
    ///
    /// The `callback` will be called when the dialog is dismissed.
    extern fn gtk_file_dialog_save(p_self: *FileDialog, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const save = gtk_file_dialog_save;

    /// Finishes the `gtk.FileDialog.save` call and
    /// returns the resulting file.
    extern fn gtk_file_dialog_save_finish(p_self: *FileDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gio.File;
    pub const saveFinish = gtk_file_dialog_save_finish;

    /// This function initiates a directory selection operation by
    /// presenting a file chooser dialog to the user.
    ///
    /// If you pass `initial_folder`, the file chooser will initially be
    /// opened in the parent directory of that folder, otherwise, it
    /// will be in the directory `gtk.FileDialog.properties.initial_folder`.
    ///
    /// The `callback` will be called when the dialog is dismissed.
    extern fn gtk_file_dialog_select_folder(p_self: *FileDialog, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const selectFolder = gtk_file_dialog_select_folder;

    /// Finishes the `gtk.FileDialog.selectFolder` call and
    /// returns the resulting file.
    extern fn gtk_file_dialog_select_folder_finish(p_self: *FileDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gio.File;
    pub const selectFolderFinish = gtk_file_dialog_select_folder_finish;

    /// This function initiates a multi-directory selection operation by
    /// presenting a file chooser dialog to the user.
    ///
    /// The file chooser will initially be opened in the directory
    /// `gtk.FileDialog.properties.initial_folder`.
    ///
    /// The `callback` will be called when the dialog is dismissed.
    extern fn gtk_file_dialog_select_multiple_folders(p_self: *FileDialog, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const selectMultipleFolders = gtk_file_dialog_select_multiple_folders;

    /// Finishes the `gtk.FileDialog.selectMultipleFolders`
    /// call and returns the resulting files in a `GListModel`.
    extern fn gtk_file_dialog_select_multiple_folders_finish(p_self: *FileDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gio.ListModel;
    pub const selectMultipleFoldersFinish = gtk_file_dialog_select_multiple_folders_finish;

    /// Sets the label shown on the file chooser's accept button.
    ///
    /// Leaving the accept label unset or setting it as `NULL` will fall back to
    /// a default label, depending on what API is used to launch the file dialog.
    extern fn gtk_file_dialog_set_accept_label(p_self: *FileDialog, p_accept_label: ?[*:0]const u8) void;
    pub const setAcceptLabel = gtk_file_dialog_set_accept_label;

    /// Sets the filter that will be selected by default
    /// in the file chooser dialog.
    ///
    /// If set to `NULL`, the first item in `gtk.FileDialog.properties.filters`
    /// will be used as the default filter. If that list is empty, the dialog
    /// will be unfiltered.
    extern fn gtk_file_dialog_set_default_filter(p_self: *FileDialog, p_filter: ?*gtk.FileFilter) void;
    pub const setDefaultFilter = gtk_file_dialog_set_default_filter;

    /// Sets the filters that will be offered to the user
    /// in the file chooser dialog.
    extern fn gtk_file_dialog_set_filters(p_self: *FileDialog, p_filters: ?*gio.ListModel) void;
    pub const setFilters = gtk_file_dialog_set_filters;

    /// Sets the file that will be initially selected in
    /// the file chooser dialog.
    ///
    /// This function is a shortcut for calling both
    /// `gtk.FileDialog.setInitialFolder` and
    /// `gtk.FileDialog.setInitialName` with the directory and
    /// name of `file` respectively.
    extern fn gtk_file_dialog_set_initial_file(p_self: *FileDialog, p_file: ?*gio.File) void;
    pub const setInitialFile = gtk_file_dialog_set_initial_file;

    /// Sets the folder that will be set as the
    /// initial folder in the file chooser dialog.
    extern fn gtk_file_dialog_set_initial_folder(p_self: *FileDialog, p_folder: ?*gio.File) void;
    pub const setInitialFolder = gtk_file_dialog_set_initial_folder;

    /// Sets the name for the file that should be initially set.
    /// For saving dialogs, this will usually be pre-entered into the name field.
    ///
    /// If a file with this name already exists in the directory set via
    /// `gtk.FileDialog.properties.initial_folder`, the dialog should preselect it.
    extern fn gtk_file_dialog_set_initial_name(p_self: *FileDialog, p_name: ?[*:0]const u8) void;
    pub const setInitialName = gtk_file_dialog_set_initial_name;

    /// Sets whether the file chooser dialog
    /// blocks interaction with the parent window
    /// while it is presented.
    extern fn gtk_file_dialog_set_modal(p_self: *FileDialog, p_modal: c_int) void;
    pub const setModal = gtk_file_dialog_set_modal;

    /// Sets the title that will be shown on the
    /// file chooser dialog.
    extern fn gtk_file_dialog_set_title(p_self: *FileDialog, p_title: [*:0]const u8) void;
    pub const setTitle = gtk_file_dialog_set_title;

    extern fn gtk_file_dialog_get_type() usize;
    pub const getGObjectType = gtk_file_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.FileDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FileDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFileFilter` filters files by name or mime type.
///
/// `GtkFileFilter` can be used to restrict the files being shown in a
/// `GtkFileChooser`. Files can be filtered based on their name (with
/// `gtk.FileFilter.addPattern` or `gtk.FileFilter.addSuffix`)
/// or on their mime type (with `gtk.FileFilter.addMimeType`).
///
/// Filtering by mime types handles aliasing and subclassing of mime
/// types; e.g. a filter for text/plain also matches a file with mime
/// type application/rtf, since application/rtf is a subclass of
/// text/plain. Note that `GtkFileFilter` allows wildcards for the
/// subtype of a mime type, so you can e.g. filter for image/\*.
///
/// Normally, file filters are used by adding them to a `GtkFileChooser`
/// (see `gtk.FileChooser.addFilter`), but it is also possible to
/// manually use a file filter on any `gtk.FilterListModel` containing
/// `GFileInfo` objects.
///
/// # GtkFileFilter as GtkBuildable
///
/// The `GtkFileFilter` implementation of the `GtkBuildable` interface
/// supports adding rules using the `<mime-types>` and `<patterns>` and
/// `<suffixes>` elements and listing the rules within. Specifying a
/// `<mime-type>` or `<pattern>` or `<suffix>` has the same effect as
/// as calling
/// `gtk.FileFilter.addMimeType` or
/// `gtk.FileFilter.addPattern` or
/// `gtk.FileFilter.addSuffix`.
///
/// An example of a UI definition fragment specifying `GtkFileFilter`
/// rules:
/// ```xml
/// <object class="GtkFileFilter">
///   <property name="name" translatable="yes">Text and Images</property>
///   <mime-types>
///     <mime-type>text/plain</mime-type>
///     <mime-type>image/ *</mime-type>
///   </mime-types>
///   <patterns>
///     <pattern>*.txt</pattern>
///   </patterns>
///   <suffixes>
///     <suffix>png</suffix>
///   </suffixes>
/// </object>
/// ```
pub const FileFilter = opaque {
    pub const Parent = gtk.Filter;
    pub const Implements = [_]type{gtk.Buildable};
    pub const Class = opaque {
        pub const Instance = FileFilter;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The MIME types that this filter matches.
        pub const mime_types = struct {
            pub const name = "mime-types";

            pub const Type = ?[*][*:0]u8;
        };

        /// The human-readable name of the filter.
        ///
        /// This is the string that will be displayed in the file chooser
        /// user interface if there is a selectable list of filters.
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// The patterns that this filter matches.
        pub const patterns = struct {
            pub const name = "patterns";

            pub const Type = ?[*][*:0]u8;
        };

        /// The suffixes that this filter matches.
        pub const suffixes = struct {
            pub const name = "suffixes";

            pub const Type = ?[*][*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFileFilter` with no rules added to it.
    ///
    /// Such a filter doesn’t accept any files, so is not
    /// particularly useful until you add rules with
    /// `gtk.FileFilter.addMimeType`,
    /// `gtk.FileFilter.addPattern`,
    /// `gtk.FileFilter.addSuffix` or
    /// `gtk.FileFilter.addPixbufFormats`.
    ///
    /// To create a filter that accepts any file, use:
    /// ```c
    /// GtkFileFilter *filter = gtk_file_filter_new ();
    /// gtk_file_filter_add_pattern (filter, "*");
    /// ```
    extern fn gtk_file_filter_new() *gtk.FileFilter;
    pub const new = gtk_file_filter_new;

    /// Deserialize a file filter from a `GVariant`.
    ///
    /// The variant must be in the format produced by
    /// `gtk.FileFilter.toGvariant`.
    extern fn gtk_file_filter_new_from_gvariant(p_variant: *glib.Variant) *gtk.FileFilter;
    pub const newFromGvariant = gtk_file_filter_new_from_gvariant;

    /// Adds a rule allowing a given mime type to `filter`.
    extern fn gtk_file_filter_add_mime_type(p_filter: *FileFilter, p_mime_type: [*:0]const u8) void;
    pub const addMimeType = gtk_file_filter_add_mime_type;

    /// Adds a rule allowing a shell style glob to a filter.
    ///
    /// Note that it depends on the platform whether pattern
    /// matching ignores case or not. On Windows, it does, on
    /// other platforms, it doesn't.
    extern fn gtk_file_filter_add_pattern(p_filter: *FileFilter, p_pattern: [*:0]const u8) void;
    pub const addPattern = gtk_file_filter_add_pattern;

    /// Adds a rule allowing image files in the formats supported
    /// by GdkPixbuf.
    ///
    /// This is equivalent to calling `gtk.FileFilter.addMimeType`
    /// for all the supported mime types.
    extern fn gtk_file_filter_add_pixbuf_formats(p_filter: *FileFilter) void;
    pub const addPixbufFormats = gtk_file_filter_add_pixbuf_formats;

    /// Adds a suffix match rule to a filter.
    ///
    /// This is similar to adding a match for the pattern
    /// "*.`suffix`".
    ///
    /// In contrast to pattern matches, suffix matches
    /// are *always* case-insensitive.
    extern fn gtk_file_filter_add_suffix(p_filter: *FileFilter, p_suffix: [*:0]const u8) void;
    pub const addSuffix = gtk_file_filter_add_suffix;

    /// Gets the attributes that need to be filled in for the `GFileInfo`
    /// passed to this filter.
    ///
    /// This function will not typically be used by applications;
    /// it is intended principally for use in the implementation
    /// of `GtkFileChooser`.
    extern fn gtk_file_filter_get_attributes(p_filter: *FileFilter) [*][*:0]const u8;
    pub const getAttributes = gtk_file_filter_get_attributes;

    /// Gets the human-readable name for the filter.
    ///
    /// See `gtk.FileFilter.setName`.
    extern fn gtk_file_filter_get_name(p_filter: *FileFilter) ?[*:0]const u8;
    pub const getName = gtk_file_filter_get_name;

    /// Sets a human-readable name of the filter.
    ///
    /// This is the string that will be displayed in the file chooser
    /// if there is a selectable list of filters.
    extern fn gtk_file_filter_set_name(p_filter: *FileFilter, p_name: ?[*:0]const u8) void;
    pub const setName = gtk_file_filter_set_name;

    /// Serialize a file filter to an `a{sv}` variant.
    extern fn gtk_file_filter_to_gvariant(p_filter: *FileFilter) *glib.Variant;
    pub const toGvariant = gtk_file_filter_to_gvariant;

    extern fn gtk_file_filter_get_type() usize;
    pub const getGObjectType = gtk_file_filter_get_type;

    extern fn g_object_ref(p_self: *gtk.FileFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FileFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkFileLauncher` object collects the arguments that are needed to open a
/// file with an application.
///
/// Depending on system configuration, user preferences and available APIs, this
/// may or may not show an app chooser dialog or launch the default application
/// right away.
///
/// The operation is started with the `gtk.FileLauncher.launch` function.
///
/// To launch uris that don't represent files, use `gtk.UriLauncher`.
pub const FileLauncher = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.FileLauncherClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether to ask the user to choose an app for opening the file. If `FALSE`,
        /// the file might be opened with a default app or the previous choice.
        pub const always_ask = struct {
            pub const name = "always-ask";

            pub const Type = c_int;
        };

        /// The file to launch.
        pub const file = struct {
            pub const name = "file";

            pub const Type = ?*gio.File;
        };

        /// Whether to make the file writable for the handler.
        pub const writable = struct {
            pub const name = "writable";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFileLauncher` object.
    extern fn gtk_file_launcher_new(p_file: ?*gio.File) *gtk.FileLauncher;
    pub const new = gtk_file_launcher_new;

    /// Returns whether to ask the user to choose an app for opening the file.
    extern fn gtk_file_launcher_get_always_ask(p_self: *FileLauncher) c_int;
    pub const getAlwaysAsk = gtk_file_launcher_get_always_ask;

    /// Gets the file that will be opened.
    extern fn gtk_file_launcher_get_file(p_self: *FileLauncher) ?*gio.File;
    pub const getFile = gtk_file_launcher_get_file;

    /// Returns whether to make the file writable for the handler.
    extern fn gtk_file_launcher_get_writable(p_self: *FileLauncher) c_int;
    pub const getWritable = gtk_file_launcher_get_writable;

    /// Launch an application to open the file.
    ///
    /// This may present an app chooser dialog to the user.
    extern fn gtk_file_launcher_launch(p_self: *FileLauncher, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const launch = gtk_file_launcher_launch;

    /// Finishes the `gtk.FileLauncher.launch` call and
    /// returns the result.
    extern fn gtk_file_launcher_launch_finish(p_self: *FileLauncher, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const launchFinish = gtk_file_launcher_launch_finish;

    /// Launch a file manager to show the file in its parent directory.
    ///
    /// This is only supported native files. It will fail if `file`
    /// is e.g. a http:// uri.
    extern fn gtk_file_launcher_open_containing_folder(p_self: *FileLauncher, p_parent: ?*gtk.Window, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const openContainingFolder = gtk_file_launcher_open_containing_folder;

    /// Finishes the `gtk.FileLauncher.openContainingFolder`
    /// call and returns the result.
    extern fn gtk_file_launcher_open_containing_folder_finish(p_self: *FileLauncher, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const openContainingFolderFinish = gtk_file_launcher_open_containing_folder_finish;

    /// Sets whether to awlays ask the user to choose an app for opening the file.
    /// If `FALSE`, the file might be opened with a default app or the previous choice.
    extern fn gtk_file_launcher_set_always_ask(p_self: *FileLauncher, p_always_ask: c_int) void;
    pub const setAlwaysAsk = gtk_file_launcher_set_always_ask;

    /// Sets the file that will be opened.
    extern fn gtk_file_launcher_set_file(p_self: *FileLauncher, p_file: ?*gio.File) void;
    pub const setFile = gtk_file_launcher_set_file;

    /// Sets whether to make the file writable for the handler.
    extern fn gtk_file_launcher_set_writable(p_self: *FileLauncher, p_writable: c_int) void;
    pub const setWritable = gtk_file_launcher_set_writable;

    extern fn gtk_file_launcher_get_type() usize;
    pub const getGObjectType = gtk_file_launcher_get_type;

    extern fn g_object_ref(p_self: *gtk.FileLauncher) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FileLauncher) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileLauncher, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkFilter` object describes the filtering to be performed by a
/// `gtk.FilterListModel`.
///
/// The model will use the filter to determine if it should include items
/// or not by calling `gtk.Filter.match` for each item and only
/// keeping the ones that the function returns `TRUE` for.
///
/// Filters may change what items they match through their lifetime. In that
/// case, they will emit the `gtk.Filter.signals.changed` signal to notify
/// that previous filter results are no longer valid and that items should
/// be checked again via `gtk.Filter.match`.
///
/// GTK provides various pre-made filter implementations for common filtering
/// operations. These filters often include properties that can be linked to
/// various widgets to easily allow searches.
///
/// However, in particular for large lists or complex search methods, it is
/// also possible to subclass `GtkFilter` and provide one's own filter.
pub const Filter = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.FilterClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {
        /// Gets the known strictness of `filters`.
        ///
        /// If the strictness is not known, `GTK_FILTER_MATCH_SOME` is returned.
        ///
        /// This value may change after emission of the `gtk.Filter.signals.changed`
        /// signal.
        ///
        /// This function is meant purely for optimization purposes, filters can
        /// choose to omit implementing it, but `GtkFilterListModel` uses it.
        pub const get_strictness = struct {
            pub fn call(p_class: anytype, p_self: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) gtk.FilterMatch {
                return gobject.ext.as(Filter.Class, p_class).f_get_strictness.?(gobject.ext.as(Filter, p_self));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_self: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) gtk.FilterMatch) void {
                gobject.ext.as(Filter.Class, p_class).f_get_strictness = @ptrCast(p_implementation);
            }
        };

        /// Checks if the given `item` is matched by the filter or not.
        pub const match = struct {
            pub fn call(p_class: anytype, p_self: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_item: ?*gobject.Object) c_int {
                return gobject.ext.as(Filter.Class, p_class).f_match.?(gobject.ext.as(Filter, p_self), p_item);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_self: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_item: ?*gobject.Object) callconv(.C) c_int) void {
                gobject.ext.as(Filter.Class, p_class).f_match = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted whenever the filter changed.
        ///
        /// Users of the filter should then check items again via
        /// `gtk.Filter.match`.
        ///
        /// `GtkFilterListModel` handles this signal automatically.
        ///
        /// Depending on the `change` parameter, not all items need
        /// to be checked, but only some. Refer to the `gtk.FilterChange`
        /// documentation for details.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_change: gtk.FilterChange, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Filter, p_instance))),
                    gobject.signalLookup("changed", Filter.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Notifies all users of the filter that it has changed.
    ///
    /// This emits the `gtk.Filter.signals.changed` signal. Users
    /// of the filter should then check items again via
    /// `gtk.Filter.match`.
    ///
    /// Depending on the `change` parameter, not all items need to
    /// be changed, but only some. Refer to the `gtk.FilterChange`
    /// documentation for details.
    ///
    /// This function is intended for implementers of `GtkFilter`
    /// subclasses and should not be called from other functions.
    extern fn gtk_filter_changed(p_self: *Filter, p_change: gtk.FilterChange) void;
    pub const changed = gtk_filter_changed;

    /// Gets the known strictness of `filters`.
    ///
    /// If the strictness is not known, `GTK_FILTER_MATCH_SOME` is returned.
    ///
    /// This value may change after emission of the `gtk.Filter.signals.changed`
    /// signal.
    ///
    /// This function is meant purely for optimization purposes, filters can
    /// choose to omit implementing it, but `GtkFilterListModel` uses it.
    extern fn gtk_filter_get_strictness(p_self: *Filter) gtk.FilterMatch;
    pub const getStrictness = gtk_filter_get_strictness;

    /// Checks if the given `item` is matched by the filter or not.
    extern fn gtk_filter_match(p_self: *Filter, p_item: *gobject.Object) c_int;
    pub const match = gtk_filter_match;

    extern fn gtk_filter_get_type() usize;
    pub const getGObjectType = gtk_filter_get_type;

    extern fn g_object_ref(p_self: *gtk.Filter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Filter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Filter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFilterListModel` is a list model that filters the elements of
/// the underlying model according to a `GtkFilter`.
///
/// It hides some elements from the other model according to
/// criteria given by a `GtkFilter`.
///
/// The model can be set up to do incremental filtering, so that
/// filtering long lists doesn't block the UI. See
/// `gtk.FilterListModel.setIncremental` for details.
///
/// `GtkFilterListModel` passes through sections from the underlying model.
pub const FilterListModel = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{ gio.ListModel, gtk.SectionModel };
    pub const Class = gtk.FilterListModelClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The filter for this model.
        pub const filter = struct {
            pub const name = "filter";

            pub const Type = ?*gtk.Filter;
        };

        /// If the model should filter items incrementally.
        pub const incremental = struct {
            pub const name = "incremental";

            pub const Type = c_int;
        };

        /// The type of items. See `gio.ListModel.getItemType`.
        pub const item_type = struct {
            pub const name = "item-type";

            pub const Type = usize;
        };

        /// The model being filtered.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gio.ListModel;
        };

        /// The number of items. See `gio.ListModel.getNItems`.
        pub const n_items = struct {
            pub const name = "n-items";

            pub const Type = c_uint;
        };

        /// Number of items not yet filtered.
        pub const pending = struct {
            pub const name = "pending";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFilterListModel` that will filter `model` using the given
    /// `filter`.
    extern fn gtk_filter_list_model_new(p_model: ?*gio.ListModel, p_filter: ?*gtk.Filter) *gtk.FilterListModel;
    pub const new = gtk_filter_list_model_new;

    /// Gets the `GtkFilter` currently set on `self`.
    extern fn gtk_filter_list_model_get_filter(p_self: *FilterListModel) ?*gtk.Filter;
    pub const getFilter = gtk_filter_list_model_get_filter;

    /// Returns whether incremental filtering is enabled.
    ///
    /// See `gtk.FilterListModel.setIncremental`.
    extern fn gtk_filter_list_model_get_incremental(p_self: *FilterListModel) c_int;
    pub const getIncremental = gtk_filter_list_model_get_incremental;

    /// Gets the model currently filtered or `NULL` if none.
    extern fn gtk_filter_list_model_get_model(p_self: *FilterListModel) ?*gio.ListModel;
    pub const getModel = gtk_filter_list_model_get_model;

    /// Returns the number of items that have not been filtered yet.
    ///
    /// You can use this value to check if `self` is busy filtering by
    /// comparing the return value to 0 or you can compute the percentage
    /// of the filter remaining by dividing the return value by the total
    /// number of items in the underlying model:
    ///
    /// ```c
    /// pending = gtk_filter_list_model_get_pending (self);
    /// model = gtk_filter_list_model_get_model (self);
    /// percentage = pending / (double) g_list_model_get_n_items (model);
    /// ```
    ///
    /// If no filter operation is ongoing - in particular when
    /// `gtk.FilterListModel.properties.incremental` is `FALSE` - this
    /// function returns 0.
    extern fn gtk_filter_list_model_get_pending(p_self: *FilterListModel) c_uint;
    pub const getPending = gtk_filter_list_model_get_pending;

    /// Sets the filter used to filter items.
    extern fn gtk_filter_list_model_set_filter(p_self: *FilterListModel, p_filter: ?*gtk.Filter) void;
    pub const setFilter = gtk_filter_list_model_set_filter;

    /// Sets the filter model to do an incremental sort.
    ///
    /// When incremental filtering is enabled, the `GtkFilterListModel` will not
    /// run filters immediately, but will instead queue an idle handler that
    /// incrementally filters the items and adds them to the list. This of course
    /// means that items are not instantly added to the list, but only appear
    /// incrementally.
    ///
    /// When your filter blocks the UI while filtering, you might consider
    /// turning this on. Depending on your model and filters, this may become
    /// interesting around 10,000 to 100,000 items.
    ///
    /// By default, incremental filtering is disabled.
    ///
    /// See `gtk.FilterListModel.getPending` for progress information
    /// about an ongoing incremental filtering operation.
    extern fn gtk_filter_list_model_set_incremental(p_self: *FilterListModel, p_incremental: c_int) void;
    pub const setIncremental = gtk_filter_list_model_set_incremental;

    /// Sets the model to be filtered.
    ///
    /// Note that GTK makes no effort to ensure that `model` conforms to
    /// the item type of `self`. It assumes that the caller knows what they
    /// are doing and have set up an appropriate filter to ensure that item
    /// types match.
    extern fn gtk_filter_list_model_set_model(p_self: *FilterListModel, p_model: ?*gio.ListModel) void;
    pub const setModel = gtk_filter_list_model_set_model;

    extern fn gtk_filter_list_model_get_type() usize;
    pub const getGObjectType = gtk_filter_list_model_get_type;

    extern fn g_object_ref(p_self: *gtk.FilterListModel) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FilterListModel) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FilterListModel, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFixed` places its child widgets at fixed positions and with fixed sizes.
///
/// `GtkFixed` performs no automatic layout management.
///
/// For most applications, you should not use this container! It keeps
/// you from having to learn about the other GTK containers, but it
/// results in broken applications.  With `GtkFixed`, the following
/// things will result in truncated text, overlapping widgets, and
/// other display bugs:
///
/// - Themes, which may change widget sizes.
///
/// - Fonts other than the one you used to write the app will of course
///   change the size of widgets containing text; keep in mind that
///   users may use a larger font because of difficulty reading the
///   default, or they may be using a different OS that provides different fonts.
///
/// - Translation of text into other languages changes its size. Also,
///   display of non-English text will use a different font in many
///   cases.
///
/// In addition, `GtkFixed` does not pay attention to text direction and
/// thus may produce unwanted results if your app is run under right-to-left
/// languages such as Hebrew or Arabic. That is: normally GTK will order
/// containers appropriately for the text direction, e.g. to put labels to
/// the right of the thing they label when using an RTL language, but it can’t
/// do that with `GtkFixed`. So if you need to reorder widgets depending on
/// the text direction, you would need to manually detect it and adjust child
/// positions accordingly.
///
/// Finally, fixed positioning makes it kind of annoying to add/remove
/// UI elements, since you have to reposition all the other elements. This
/// is a long-term maintenance problem for your application.
///
/// If you know none of these things are an issue for your application,
/// and prefer the simplicity of `GtkFixed`, by all means use the
/// widget. But you should be aware of the tradeoffs.
pub const Fixed = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.FixedClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkFixed`.
    extern fn gtk_fixed_new() *gtk.Fixed;
    pub const new = gtk_fixed_new;

    /// Retrieves the translation transformation of the
    /// given child `GtkWidget` in the `GtkFixed`.
    ///
    /// See also: `gtk.Fixed.getChildTransform`.
    extern fn gtk_fixed_get_child_position(p_fixed: *Fixed, p_widget: *gtk.Widget, p_x: *f64, p_y: *f64) void;
    pub const getChildPosition = gtk_fixed_get_child_position;

    /// Retrieves the transformation for `widget` set using
    /// `gtk.Fixed.setChildTransform`.
    extern fn gtk_fixed_get_child_transform(p_fixed: *Fixed, p_widget: *gtk.Widget) ?*gsk.Transform;
    pub const getChildTransform = gtk_fixed_get_child_transform;

    /// Sets a translation transformation to the given `x` and `y`
    /// coordinates to the child `widget` of the `GtkFixed`.
    extern fn gtk_fixed_move(p_fixed: *Fixed, p_widget: *gtk.Widget, p_x: f64, p_y: f64) void;
    pub const move = gtk_fixed_move;

    /// Adds a widget to a `GtkFixed` at the given position.
    extern fn gtk_fixed_put(p_fixed: *Fixed, p_widget: *gtk.Widget, p_x: f64, p_y: f64) void;
    pub const put = gtk_fixed_put;

    /// Removes a child from `fixed`.
    extern fn gtk_fixed_remove(p_fixed: *Fixed, p_widget: *gtk.Widget) void;
    pub const remove = gtk_fixed_remove;

    /// Sets the transformation for `widget`.
    ///
    /// This is a convenience function that retrieves the
    /// `gtk.FixedLayoutChild` instance associated to
    /// `widget` and calls `gtk.FixedLayoutChild.setTransform`.
    extern fn gtk_fixed_set_child_transform(p_fixed: *Fixed, p_widget: *gtk.Widget, p_transform: ?*gsk.Transform) void;
    pub const setChildTransform = gtk_fixed_set_child_transform;

    extern fn gtk_fixed_get_type() usize;
    pub const getGObjectType = gtk_fixed_get_type;

    extern fn g_object_ref(p_self: *gtk.Fixed) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Fixed) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Fixed, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFixedLayout` is a layout manager which can place child widgets
/// at fixed positions.
///
/// Most applications should never use this layout manager; fixed positioning
/// and sizing requires constant recalculations on where children need to be
/// positioned and sized. Other layout managers perform this kind of work
/// internally so that application developers don't need to do it. Specifically,
/// widgets positioned in a fixed layout manager will need to take into account:
///
/// - Themes, which may change widget sizes.
///
/// - Fonts other than the one you used to write the app will of course
///   change the size of widgets containing text; keep in mind that
///   users may use a larger font because of difficulty reading the
///   default, or they may be using a different OS that provides different
///   fonts.
///
/// - Translation of text into other languages changes its size. Also,
///   display of non-English text will use a different font in many
///   cases.
///
/// In addition, `GtkFixedLayout` does not pay attention to text direction and
/// thus may produce unwanted results if your app is run under right-to-left
/// languages such as Hebrew or Arabic. That is: normally GTK will order
/// containers appropriately depending on the text direction, e.g. to put labels
/// to the right of the thing they label when using an RTL language;
/// `GtkFixedLayout` won't be able to do that for you.
///
/// Finally, fixed positioning makes it kind of annoying to add/remove UI
/// elements, since you have to reposition all the other  elements. This is a
/// long-term maintenance problem for your application.
pub const FixedLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{};
    pub const Class = gtk.FixedLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkFixedLayout`.
    extern fn gtk_fixed_layout_new() *gtk.FixedLayout;
    pub const new = gtk_fixed_layout_new;

    extern fn gtk_fixed_layout_get_type() usize;
    pub const getGObjectType = gtk_fixed_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.FixedLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FixedLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FixedLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkLayoutChild` subclass for children in a `GtkFixedLayout`.
pub const FixedLayoutChild = opaque {
    pub const Parent = gtk.LayoutChild;
    pub const Implements = [_]type{};
    pub const Class = gtk.FixedLayoutChildClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The transform of the child.
        pub const transform = struct {
            pub const name = "transform";

            pub const Type = ?*gsk.Transform;
        };
    };

    pub const signals = struct {};

    /// Retrieves the transformation of the child.
    extern fn gtk_fixed_layout_child_get_transform(p_child: *FixedLayoutChild) ?*gsk.Transform;
    pub const getTransform = gtk_fixed_layout_child_get_transform;

    /// Sets the transformation of the child of a `GtkFixedLayout`.
    extern fn gtk_fixed_layout_child_set_transform(p_child: *FixedLayoutChild, p_transform: *gsk.Transform) void;
    pub const setTransform = gtk_fixed_layout_child_set_transform;

    extern fn gtk_fixed_layout_child_get_type() usize;
    pub const getGObjectType = gtk_fixed_layout_child_get_type;

    extern fn g_object_ref(p_self: *gtk.FixedLayoutChild) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FixedLayoutChild) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FixedLayoutChild, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFlattenListModel` is a list model that concatenates other list models.
///
/// `GtkFlattenListModel` takes a list model containing list models, and flattens
/// it into a single model. Each list model becomes a section in the single model.
pub const FlattenListModel = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{ gio.ListModel, gtk.SectionModel };
    pub const Class = gtk.FlattenListModelClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The type of items. See `gio.ListModel.getItemType`.
        pub const item_type = struct {
            pub const name = "item-type";

            pub const Type = usize;
        };

        /// The model being flattened.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gio.ListModel;
        };

        /// The number of items. See `gio.ListModel.getNItems`.
        pub const n_items = struct {
            pub const name = "n-items";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFlattenListModel` that flattens `list`.
    extern fn gtk_flatten_list_model_new(p_model: ?*gio.ListModel) *gtk.FlattenListModel;
    pub const new = gtk_flatten_list_model_new;

    /// Gets the model set via `gtk.FlattenListModel.setModel`.
    extern fn gtk_flatten_list_model_get_model(p_self: *FlattenListModel) ?*gio.ListModel;
    pub const getModel = gtk_flatten_list_model_get_model;

    /// Returns the model containing the item at the given position.
    extern fn gtk_flatten_list_model_get_model_for_item(p_self: *FlattenListModel, p_position: c_uint) ?*gio.ListModel;
    pub const getModelForItem = gtk_flatten_list_model_get_model_for_item;

    /// Sets a new model to be flattened.
    extern fn gtk_flatten_list_model_set_model(p_self: *FlattenListModel, p_model: ?*gio.ListModel) void;
    pub const setModel = gtk_flatten_list_model_set_model;

    extern fn gtk_flatten_list_model_get_type() usize;
    pub const getGObjectType = gtk_flatten_list_model_get_type;

    extern fn g_object_ref(p_self: *gtk.FlattenListModel) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FlattenListModel) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FlattenListModel, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkFlowBox` puts child widgets in reflowing grid.
///
/// For instance, with the horizontal orientation, the widgets will be
/// arranged from left to right, starting a new row under the previous
/// row when necessary. Reducing the width in this case will require more
/// rows, so a larger height will be requested.
///
/// Likewise, with the vertical orientation, the widgets will be arranged
/// from top to bottom, starting a new column to the right when necessary.
/// Reducing the height will require more columns, so a larger width will
/// be requested.
///
/// The size request of a `GtkFlowBox` alone may not be what you expect;
/// if you need to be able to shrink it along both axes and dynamically
/// reflow its children, you may have to wrap it in a `GtkScrolledWindow`
/// to enable that.
///
/// The children of a `GtkFlowBox` can be dynamically sorted and filtered.
///
/// Although a `GtkFlowBox` must have only `GtkFlowBoxChild` children, you
/// can add any kind of widget to it via `gtk.FlowBox.insert`, and a
/// `GtkFlowBoxChild` widget will automatically be inserted between the box
/// and the widget.
///
/// Also see `gtk.ListBox`.
///
/// # Shortcuts and Gestures
///
/// The following signals have default keybindings:
///
/// - `gtk.FlowBox.signals.move_cursor`
/// - `gtk.FlowBox.signals.select_all`
/// - `gtk.FlowBox.signals.toggle_cursor_child`
/// - `gtk.FlowBox.signals.unselect_all`
///
/// # CSS nodes
///
/// ```
/// flowbox
/// ├── flowboxchild
/// │   ╰── <child>
/// ├── flowboxchild
/// │   ╰── <child>
/// ┊
/// ╰── [rubberband]
/// ```
///
/// `GtkFlowBox` uses a single CSS node with name flowbox. `GtkFlowBoxChild`
/// uses a single CSS node with name flowboxchild. For rubberband selection,
/// a subnode with name rubberband is used.
///
/// # Accessibility
///
/// `GtkFlowBox` uses the `GTK_ACCESSIBLE_ROLE_GRID` role, and `GtkFlowBoxChild`
/// uses the `GTK_ACCESSIBLE_ROLE_GRID_CELL` role.
pub const FlowBox = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Orientable };
    pub const Class = opaque {
        pub const Instance = FlowBox;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether to accept unpaired release events.
        pub const accept_unpaired_release = struct {
            pub const name = "accept-unpaired-release";

            pub const Type = c_int;
        };

        /// Determines whether children can be activated with a single
        /// click, or require a double-click.
        pub const activate_on_single_click = struct {
            pub const name = "activate-on-single-click";

            pub const Type = c_int;
        };

        /// The amount of horizontal space between two children.
        pub const column_spacing = struct {
            pub const name = "column-spacing";

            pub const Type = c_uint;
        };

        /// Determines whether all children should be allocated the
        /// same size.
        pub const homogeneous = struct {
            pub const name = "homogeneous";

            pub const Type = c_int;
        };

        /// The maximum amount of children to request space for consecutively
        /// in the given orientation.
        pub const max_children_per_line = struct {
            pub const name = "max-children-per-line";

            pub const Type = c_uint;
        };

        /// The minimum number of children to allocate consecutively
        /// in the given orientation.
        ///
        /// Setting the minimum children per line ensures
        /// that a reasonably small height will be requested
        /// for the overall minimum width of the box.
        pub const min_children_per_line = struct {
            pub const name = "min-children-per-line";

            pub const Type = c_uint;
        };

        /// The amount of vertical space between two children.
        pub const row_spacing = struct {
            pub const name = "row-spacing";

            pub const Type = c_uint;
        };

        /// The selection mode used by the flow box.
        pub const selection_mode = struct {
            pub const name = "selection-mode";

            pub const Type = gtk.SelectionMode;
        };
    };

    pub const signals = struct {
        /// Emitted when the user activates the `box`.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        pub const activate_cursor_child = struct {
            pub const name = "activate-cursor-child";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("activate-cursor-child", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a child has been activated by the user.
        pub const child_activated = struct {
            pub const name = "child-activated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_child: *gtk.FlowBoxChild, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("child-activated", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user initiates a cursor movement.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        /// Applications should not connect to it, but may emit it with
        /// `gobject.signalEmitByName` if they need to control the cursor
        /// programmatically.
        ///
        /// The default bindings for this signal come in two variants,
        /// the variant with the Shift modifier extends the selection,
        /// the variant without the Shift modifier does not.
        /// There are too many key combinations to list them all here.
        ///
        /// - <kbd>←</kbd>, <kbd>→</kbd>, <kbd>↑</kbd>, <kbd>↓</kbd>
        ///   move by individual children
        /// - <kbd>Home</kbd>, <kbd>End</kbd> move to the ends of the box
        /// - <kbd>PgUp</kbd>, <kbd>PgDn</kbd> move vertically by pages
        pub const move_cursor = struct {
            pub const name = "move-cursor";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_step: gtk.MovementStep, p_count: c_int, p_extend: c_int, p_modify: c_int, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("move-cursor", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to select all children of the box,
        /// if the selection mode permits it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// The default bindings for this signal is <kbd>Ctrl</kbd>-<kbd>a</kbd>.
        pub const select_all = struct {
            pub const name = "select-all";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("select-all", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the set of selected children changes.
        ///
        /// Use `gtk.FlowBox.selectedForeach` or
        /// `gtk.FlowBox.getSelectedChildren` to obtain the
        /// selected children.
        pub const selected_children_changed = struct {
            pub const name = "selected-children-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("selected-children-changed", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to toggle the selection of the child that has the focus.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// The default binding for this signal is <kbd>Ctrl</kbd>-<kbd>Space</kbd>.
        pub const toggle_cursor_child = struct {
            pub const name = "toggle-cursor-child";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("toggle-cursor-child", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted to unselect all children of the box,
        /// if the selection mode permits it.
        ///
        /// This is a [keybinding signal](class.SignalAction.html).
        ///
        /// The default bindings for this signal is <kbd>Ctrl</kbd>-<kbd>Shift</kbd>-<kbd>a</kbd>.
        pub const unselect_all = struct {
            pub const name = "unselect-all";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBox, p_instance))),
                    gobject.signalLookup("unselect-all", FlowBox.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a `GtkFlowBox`.
    extern fn gtk_flow_box_new() *gtk.FlowBox;
    pub const new = gtk_flow_box_new;

    /// Adds `child` to the end of `self`.
    ///
    /// If a sort function is set, the widget will
    /// actually be inserted at the calculated position.
    ///
    /// See also: `gtk.FlowBox.insert`.
    extern fn gtk_flow_box_append(p_self: *FlowBox, p_child: *gtk.Widget) void;
    pub const append = gtk_flow_box_append;

    /// Binds `model` to `box`.
    ///
    /// If `box` was already bound to a model, that previous binding is
    /// destroyed.
    ///
    /// The contents of `box` are cleared and then filled with widgets that
    /// represent items from `model`. `box` is updated whenever `model` changes.
    /// If `model` is `NULL`, `box` is left empty.
    ///
    /// It is undefined to add or remove widgets directly (for example, with
    /// `gtk.FlowBox.insert`) while `box` is bound to a model.
    ///
    /// Note that using a model is incompatible with the filtering and sorting
    /// functionality in `GtkFlowBox`. When using a model, filtering and sorting
    /// should be implemented by the model.
    extern fn gtk_flow_box_bind_model(p_box: *FlowBox, p_model: ?*gio.ListModel, p_create_widget_func: gtk.FlowBoxCreateWidgetFunc, p_user_data: ?*anyopaque, p_user_data_free_func: ?glib.DestroyNotify) void;
    pub const bindModel = gtk_flow_box_bind_model;

    /// Returns whether children activate on single clicks.
    extern fn gtk_flow_box_get_activate_on_single_click(p_box: *FlowBox) c_int;
    pub const getActivateOnSingleClick = gtk_flow_box_get_activate_on_single_click;

    /// Gets the nth child in the `box`.
    extern fn gtk_flow_box_get_child_at_index(p_box: *FlowBox, p_idx: c_int) ?*gtk.FlowBoxChild;
    pub const getChildAtIndex = gtk_flow_box_get_child_at_index;

    /// Gets the child in the (`x`, `y`) position.
    ///
    /// Both `x` and `y` are assumed to be relative to the origin of `box`.
    extern fn gtk_flow_box_get_child_at_pos(p_box: *FlowBox, p_x: c_int, p_y: c_int) ?*gtk.FlowBoxChild;
    pub const getChildAtPos = gtk_flow_box_get_child_at_pos;

    /// Gets the horizontal spacing.
    extern fn gtk_flow_box_get_column_spacing(p_box: *FlowBox) c_uint;
    pub const getColumnSpacing = gtk_flow_box_get_column_spacing;

    /// Returns whether the box is homogeneous.
    extern fn gtk_flow_box_get_homogeneous(p_box: *FlowBox) c_int;
    pub const getHomogeneous = gtk_flow_box_get_homogeneous;

    /// Gets the maximum number of children per line.
    extern fn gtk_flow_box_get_max_children_per_line(p_box: *FlowBox) c_uint;
    pub const getMaxChildrenPerLine = gtk_flow_box_get_max_children_per_line;

    /// Gets the minimum number of children per line.
    extern fn gtk_flow_box_get_min_children_per_line(p_box: *FlowBox) c_uint;
    pub const getMinChildrenPerLine = gtk_flow_box_get_min_children_per_line;

    /// Gets the vertical spacing.
    extern fn gtk_flow_box_get_row_spacing(p_box: *FlowBox) c_uint;
    pub const getRowSpacing = gtk_flow_box_get_row_spacing;

    /// Creates a list of all selected children.
    extern fn gtk_flow_box_get_selected_children(p_box: *FlowBox) *glib.List;
    pub const getSelectedChildren = gtk_flow_box_get_selected_children;

    /// Gets the selection mode of `box`.
    extern fn gtk_flow_box_get_selection_mode(p_box: *FlowBox) gtk.SelectionMode;
    pub const getSelectionMode = gtk_flow_box_get_selection_mode;

    /// Inserts the `widget` into `box` at `position`.
    ///
    /// If a sort function is set, the widget will actually be inserted
    /// at the calculated position.
    ///
    /// If `position` is -1, or larger than the total number of children
    /// in the `box`, then the `widget` will be appended to the end.
    extern fn gtk_flow_box_insert(p_box: *FlowBox, p_widget: *gtk.Widget, p_position: c_int) void;
    pub const insert = gtk_flow_box_insert;

    /// Updates the filtering for all children.
    ///
    /// Call this function when the result of the filter
    /// function on the `box` is changed due to an external
    /// factor. For instance, this would be used if the
    /// filter function just looked for a specific search
    /// term, and the entry with the string has changed.
    extern fn gtk_flow_box_invalidate_filter(p_box: *FlowBox) void;
    pub const invalidateFilter = gtk_flow_box_invalidate_filter;

    /// Updates the sorting for all children.
    ///
    /// Call this when the result of the sort function on
    /// `box` is changed due to an external factor.
    extern fn gtk_flow_box_invalidate_sort(p_box: *FlowBox) void;
    pub const invalidateSort = gtk_flow_box_invalidate_sort;

    /// Adds `child` to the start of `self`.
    ///
    /// If a sort function is set, the widget will
    /// actually be inserted at the calculated position.
    ///
    /// See also: `gtk.FlowBox.insert`.
    extern fn gtk_flow_box_prepend(p_self: *FlowBox, p_child: *gtk.Widget) void;
    pub const prepend = gtk_flow_box_prepend;

    /// Removes a child from `box`.
    extern fn gtk_flow_box_remove(p_box: *FlowBox, p_widget: *gtk.Widget) void;
    pub const remove = gtk_flow_box_remove;

    /// Removes all children from `box`.
    ///
    /// This function does nothing if `box` is backed by a model.
    extern fn gtk_flow_box_remove_all(p_box: *FlowBox) void;
    pub const removeAll = gtk_flow_box_remove_all;

    /// Select all children of `box`, if the selection
    /// mode allows it.
    extern fn gtk_flow_box_select_all(p_box: *FlowBox) void;
    pub const selectAll = gtk_flow_box_select_all;

    /// Selects a single child of `box`, if the selection
    /// mode allows it.
    extern fn gtk_flow_box_select_child(p_box: *FlowBox, p_child: *gtk.FlowBoxChild) void;
    pub const selectChild = gtk_flow_box_select_child;

    /// Calls a function for each selected child.
    ///
    /// Note that the selection cannot be modified from within
    /// this function.
    extern fn gtk_flow_box_selected_foreach(p_box: *FlowBox, p_func: gtk.FlowBoxForeachFunc, p_data: ?*anyopaque) void;
    pub const selectedForeach = gtk_flow_box_selected_foreach;

    /// If `single` is `TRUE`, children will be activated when you click
    /// on them, otherwise you need to double-click.
    extern fn gtk_flow_box_set_activate_on_single_click(p_box: *FlowBox, p_single: c_int) void;
    pub const setActivateOnSingleClick = gtk_flow_box_set_activate_on_single_click;

    /// Sets the horizontal space to add between children.
    extern fn gtk_flow_box_set_column_spacing(p_box: *FlowBox, p_spacing: c_uint) void;
    pub const setColumnSpacing = gtk_flow_box_set_column_spacing;

    /// By setting a filter function on the `box` one can decide dynamically
    /// which of the children to show.
    ///
    /// For instance, to implement a search function that only shows the
    /// children matching the search terms.
    ///
    /// The `filter_func` will be called for each child after the call, and
    /// it will continue to be called each time a child changes (via
    /// `gtk.FlowBoxChild.changed`) or when
    /// `gtk.FlowBox.invalidateFilter` is called.
    ///
    /// Note that using a filter function is incompatible with using a model
    /// (see `gtk.FlowBox.bindModel`).
    extern fn gtk_flow_box_set_filter_func(p_box: *FlowBox, p_filter_func: ?gtk.FlowBoxFilterFunc, p_user_data: ?*anyopaque, p_destroy: ?glib.DestroyNotify) void;
    pub const setFilterFunc = gtk_flow_box_set_filter_func;

    /// Hooks up an adjustment to focus handling in `box`.
    ///
    /// The adjustment is also used for autoscrolling during
    /// rubberband selection. See `gtk.ScrolledWindow.getHadjustment`
    /// for a typical way of obtaining the adjustment, and
    /// `gtk.FlowBox.setVadjustment` for setting the vertical
    /// adjustment.
    ///
    /// The adjustments have to be in pixel units and in the same
    /// coordinate system as the allocation for immediate children
    /// of the box.
    extern fn gtk_flow_box_set_hadjustment(p_box: *FlowBox, p_adjustment: *gtk.Adjustment) void;
    pub const setHadjustment = gtk_flow_box_set_hadjustment;

    /// Sets whether or not all children of `box` are given
    /// equal space in the box.
    extern fn gtk_flow_box_set_homogeneous(p_box: *FlowBox, p_homogeneous: c_int) void;
    pub const setHomogeneous = gtk_flow_box_set_homogeneous;

    /// Sets the maximum number of children to request and
    /// allocate space for in `box`’s orientation.
    ///
    /// Setting the maximum number of children per line
    /// limits the overall natural size request to be no more
    /// than `n_children` children long in the given orientation.
    extern fn gtk_flow_box_set_max_children_per_line(p_box: *FlowBox, p_n_children: c_uint) void;
    pub const setMaxChildrenPerLine = gtk_flow_box_set_max_children_per_line;

    /// Sets the minimum number of children to line up
    /// in `box`’s orientation before flowing.
    extern fn gtk_flow_box_set_min_children_per_line(p_box: *FlowBox, p_n_children: c_uint) void;
    pub const setMinChildrenPerLine = gtk_flow_box_set_min_children_per_line;

    /// Sets the vertical space to add between children.
    extern fn gtk_flow_box_set_row_spacing(p_box: *FlowBox, p_spacing: c_uint) void;
    pub const setRowSpacing = gtk_flow_box_set_row_spacing;

    /// Sets how selection works in `box`.
    extern fn gtk_flow_box_set_selection_mode(p_box: *FlowBox, p_mode: gtk.SelectionMode) void;
    pub const setSelectionMode = gtk_flow_box_set_selection_mode;

    /// By setting a sort function on the `box`, one can dynamically
    /// reorder the children of the box, based on the contents of
    /// the children.
    ///
    /// The `sort_func` will be called for each child after the call,
    /// and will continue to be called each time a child changes (via
    /// `gtk.FlowBoxChild.changed`) and when
    /// `gtk.FlowBox.invalidateSort` is called.
    ///
    /// Note that using a sort function is incompatible with using a model
    /// (see `gtk.FlowBox.bindModel`).
    extern fn gtk_flow_box_set_sort_func(p_box: *FlowBox, p_sort_func: ?gtk.FlowBoxSortFunc, p_user_data: ?*anyopaque, p_destroy: ?glib.DestroyNotify) void;
    pub const setSortFunc = gtk_flow_box_set_sort_func;

    /// Hooks up an adjustment to focus handling in `box`.
    ///
    /// The adjustment is also used for autoscrolling during
    /// rubberband selection. See `gtk.ScrolledWindow.getVadjustment`
    /// for a typical way of obtaining the adjustment, and
    /// `gtk.FlowBox.setHadjustment` for setting the horizontal
    /// adjustment.
    ///
    /// The adjustments have to be in pixel units and in the same
    /// coordinate system as the allocation for immediate children
    /// of the box.
    extern fn gtk_flow_box_set_vadjustment(p_box: *FlowBox, p_adjustment: *gtk.Adjustment) void;
    pub const setVadjustment = gtk_flow_box_set_vadjustment;

    /// Unselect all children of `box`, if the selection
    /// mode allows it.
    extern fn gtk_flow_box_unselect_all(p_box: *FlowBox) void;
    pub const unselectAll = gtk_flow_box_unselect_all;

    /// Unselects a single child of `box`, if the selection
    /// mode allows it.
    extern fn gtk_flow_box_unselect_child(p_box: *FlowBox, p_child: *gtk.FlowBoxChild) void;
    pub const unselectChild = gtk_flow_box_unselect_child;

    extern fn gtk_flow_box_get_type() usize;
    pub const getGObjectType = gtk_flow_box_get_type;

    extern fn g_object_ref(p_self: *gtk.FlowBox) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FlowBox) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FlowBox, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFlowBoxChild` is the kind of widget that can be added to a `GtkFlowBox`.
pub const FlowBoxChild = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.FlowBoxChildClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        pub const activate = struct {
            pub fn call(p_class: anytype, p_child: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(FlowBoxChild.Class, p_class).f_activate.?(gobject.ext.as(FlowBoxChild, p_child));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_child: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(FlowBoxChild.Class, p_class).f_activate = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };
    };

    pub const signals = struct {
        /// Emitted when the user activates a child widget in a `GtkFlowBox`.
        ///
        /// This can happen either by clicking or double-clicking,
        /// or via a keybinding.
        ///
        /// This is a [keybinding signal](class.SignalAction.html),
        /// but it can be used by applications for their own purposes.
        ///
        /// The default bindings are <kbd>Space</kbd> and <kbd>Enter</kbd>.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FlowBoxChild, p_instance))),
                    gobject.signalLookup("activate", FlowBoxChild.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkFlowBoxChild`.
    ///
    /// This should only be used as a child of a `GtkFlowBox`.
    extern fn gtk_flow_box_child_new() *gtk.FlowBoxChild;
    pub const new = gtk_flow_box_child_new;

    /// Marks `child` as changed, causing any state that depends on this
    /// to be updated.
    ///
    /// This affects sorting and filtering.
    ///
    /// Note that calls to this method must be in sync with the data
    /// used for the sorting and filtering functions. For instance, if
    /// the list is mirroring some external data set, and *two* children
    /// changed in the external data set when you call
    /// `gtk.FlowBoxChild.changed` on the first child, the sort function
    /// must only read the new data for the first of the two changed
    /// children, otherwise the resorting of the children will be wrong.
    ///
    /// This generally means that if you don’t fully control the data
    /// model, you have to duplicate the data that affects the sorting
    /// and filtering functions into the widgets themselves.
    ///
    /// Another alternative is to call `gtk.FlowBox.invalidateSort`
    /// on any model change, but that is more expensive.
    extern fn gtk_flow_box_child_changed(p_child: *FlowBoxChild) void;
    pub const changed = gtk_flow_box_child_changed;

    /// Gets the child widget of `self`.
    extern fn gtk_flow_box_child_get_child(p_self: *FlowBoxChild) ?*gtk.Widget;
    pub const getChild = gtk_flow_box_child_get_child;

    /// Gets the current index of the `child` in its `GtkFlowBox` container.
    extern fn gtk_flow_box_child_get_index(p_child: *FlowBoxChild) c_int;
    pub const getIndex = gtk_flow_box_child_get_index;

    /// Returns whether the `child` is currently selected in its
    /// `GtkFlowBox` container.
    extern fn gtk_flow_box_child_is_selected(p_child: *FlowBoxChild) c_int;
    pub const isSelected = gtk_flow_box_child_is_selected;

    /// Sets the child widget of `self`.
    extern fn gtk_flow_box_child_set_child(p_self: *FlowBoxChild, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_flow_box_child_set_child;

    extern fn gtk_flow_box_child_get_type() usize;
    pub const getGObjectType = gtk_flow_box_child_get_type;

    extern fn g_object_ref(p_self: *gtk.FlowBoxChild) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FlowBoxChild) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FlowBoxChild, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkFontButton` allows to open a font chooser dialog to change
/// the font.
///
/// ![An example GtkFontButton](font-button.png)
///
/// It is suitable widget for selecting a font in a preference dialog.
///
/// # CSS nodes
///
/// ```
/// fontbutton
/// ╰── button.font
///     ╰── [content]
/// ```
///
/// `GtkFontButton` has a single CSS node with name fontbutton which
/// contains a button node with the .font style class.
pub const FontButton = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.FontChooser };
    pub const Class = opaque {
        pub const Instance = FontButton;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the font chooser dialog should be modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };

        /// The title of the font chooser dialog.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the buttons label will be drawn in the selected font.
        pub const use_font = struct {
            pub const name = "use-font";

            pub const Type = c_int;
        };

        /// Whether the buttons label will use the selected font size.
        pub const use_size = struct {
            pub const name = "use-size";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted to when the font button is activated.
        ///
        /// The `::activate` signal on `GtkFontButton` is an action signal and
        /// emitting it causes the button to present its dialog.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FontButton, p_instance))),
                    gobject.signalLookup("activate", FontButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the user selects a font.
        ///
        /// When handling this signal, use `gtk.FontChooser.getFont`
        /// to find out which font was just selected.
        ///
        /// Note that this signal is only emitted when the user changes the font.
        /// If you need to react to programmatic font changes as well, use
        /// the notify::font signal.
        pub const font_set = struct {
            pub const name = "font-set";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FontButton, p_instance))),
                    gobject.signalLookup("font-set", FontButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new font picker widget.
    extern fn gtk_font_button_new() *gtk.FontButton;
    pub const new = gtk_font_button_new;

    /// Creates a new font picker widget showing the given font.
    extern fn gtk_font_button_new_with_font(p_fontname: [*:0]const u8) *gtk.FontButton;
    pub const newWithFont = gtk_font_button_new_with_font;

    /// Gets whether the dialog is modal.
    extern fn gtk_font_button_get_modal(p_font_button: *FontButton) c_int;
    pub const getModal = gtk_font_button_get_modal;

    /// Retrieves the title of the font chooser dialog.
    extern fn gtk_font_button_get_title(p_font_button: *FontButton) [*:0]const u8;
    pub const getTitle = gtk_font_button_get_title;

    /// Returns whether the selected font is used in the label.
    extern fn gtk_font_button_get_use_font(p_font_button: *FontButton) c_int;
    pub const getUseFont = gtk_font_button_get_use_font;

    /// Returns whether the selected size is used in the label.
    extern fn gtk_font_button_get_use_size(p_font_button: *FontButton) c_int;
    pub const getUseSize = gtk_font_button_get_use_size;

    /// Sets whether the dialog should be modal.
    extern fn gtk_font_button_set_modal(p_font_button: *FontButton, p_modal: c_int) void;
    pub const setModal = gtk_font_button_set_modal;

    /// Sets the title for the font chooser dialog.
    extern fn gtk_font_button_set_title(p_font_button: *FontButton, p_title: [*:0]const u8) void;
    pub const setTitle = gtk_font_button_set_title;

    /// If `use_font` is `TRUE`, the font name will be written
    /// using the selected font.
    extern fn gtk_font_button_set_use_font(p_font_button: *FontButton, p_use_font: c_int) void;
    pub const setUseFont = gtk_font_button_set_use_font;

    /// If `use_size` is `TRUE`, the font name will be written using
    /// the selected size.
    extern fn gtk_font_button_set_use_size(p_font_button: *FontButton, p_use_size: c_int) void;
    pub const setUseSize = gtk_font_button_set_use_size;

    extern fn gtk_font_button_get_type() usize;
    pub const getGObjectType = gtk_font_button_get_type;

    extern fn g_object_ref(p_self: *gtk.FontButton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FontButton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FontButton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkFontChooserDialog` widget is a dialog for selecting a font.
///
/// ![An example GtkFontChooserDialog](fontchooser.png)
///
/// `GtkFontChooserDialog` implements the `gtk.FontChooser` interface
/// and does not provide much API of its own.
///
/// To create a `GtkFontChooserDialog`, use `gtk.FontChooserDialog.new`.
///
/// # GtkFontChooserDialog as GtkBuildable
///
/// The `GtkFontChooserDialog` implementation of the `GtkBuildable`
/// interface exposes the buttons with the names “select_button”
/// and “cancel_button”.
///
/// ## CSS nodes
///
/// `GtkFontChooserDialog` has a single CSS node with the name `window` and style
/// class `.fontchooser`.
pub const FontChooserDialog = opaque {
    pub const Parent = gtk.Dialog;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.FontChooser, gtk.Native, gtk.Root, gtk.ShortcutManager };
    pub const Class = opaque {
        pub const Instance = FontChooserDialog;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `GtkFontChooserDialog`.
    extern fn gtk_font_chooser_dialog_new(p_title: ?[*:0]const u8, p_parent: ?*gtk.Window) *gtk.FontChooserDialog;
    pub const new = gtk_font_chooser_dialog_new;

    extern fn gtk_font_chooser_dialog_get_type() usize;
    pub const getGObjectType = gtk_font_chooser_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.FontChooserDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FontChooserDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FontChooserDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkFontChooserWidget` widget lets the user select a font.
///
/// It is used in the `GtkFontChooserDialog` widget to provide a
/// dialog for selecting fonts.
///
/// To set the font which is initially selected, use
/// `gtk.FontChooser.setFont` or `gtk.FontChooser.setFontDesc`.
///
/// To get the selected font use `gtk.FontChooser.getFont` or
/// `gtk.FontChooser.getFontDesc`.
///
/// To change the text which is shown in the preview area, use
/// `gtk.FontChooser.setPreviewText`.
///
/// # CSS nodes
///
/// `GtkFontChooserWidget` has a single CSS node with name fontchooser.
pub const FontChooserWidget = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.FontChooser };
    pub const Class = opaque {
        pub const Instance = FontChooserWidget;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// A toggle action that can be used to switch to the tweak page
        /// of the font chooser widget, which lets the user tweak the
        /// OpenType features and variation axes of the selected font.
        ///
        /// The action will be enabled or disabled depending on whether
        /// the selected font has any features or axes.
        pub const tweak_action = struct {
            pub const name = "tweak-action";

            pub const Type = ?*gio.Action;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFontChooserWidget`.
    extern fn gtk_font_chooser_widget_new() *gtk.FontChooserWidget;
    pub const new = gtk_font_chooser_widget_new;

    extern fn gtk_font_chooser_widget_get_type() usize;
    pub const getGObjectType = gtk_font_chooser_widget_get_type;

    extern fn g_object_ref(p_self: *gtk.FontChooserWidget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FontChooserWidget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FontChooserWidget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `GtkFontDialog` object collects the arguments that
/// are needed to present a font chooser dialog to the
/// user, such as a title for the dialog and whether it
/// should be modal.
///
/// The dialog is shown with the `gtk.FontDialog.chooseFont`
/// function or its variants.
///
/// See `gtk.FontDialogButton` for a convenient control
/// that uses `GtkFontDialog` and presents the results.
pub const FontDialog = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gtk.FontDialogClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Sets a filter to restrict what fonts are shown
        /// in the font chooser dialog.
        pub const filter = struct {
            pub const name = "filter";

            pub const Type = ?*gtk.Filter;
        };

        /// Sets a custom font map to select fonts from.
        ///
        /// A custom font map can be used to present application-specific
        /// fonts instead of or in addition to the normal system fonts.
        pub const font_map = struct {
            pub const name = "font-map";

            pub const Type = ?*pango.FontMap;
        };

        /// The language for which the font features are selected.
        pub const language = struct {
            pub const name = "language";

            pub const Type = ?*pango.Language;
        };

        /// Whether the font chooser dialog is modal.
        pub const modal = struct {
            pub const name = "modal";

            pub const Type = c_int;
        };

        /// A title that may be shown on the font chooser
        /// dialog that is presented by `gtk.FontDialog.chooseFont`.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFontDialog` object.
    extern fn gtk_font_dialog_new() *gtk.FontDialog;
    pub const new = gtk_font_dialog_new;

    /// This function initiates a font selection operation by
    /// presenting a dialog to the user for selecting a font face
    /// (i.e. a font family and style, but not a specific font size).
    extern fn gtk_font_dialog_choose_face(p_self: *FontDialog, p_parent: ?*gtk.Window, p_initial_value: ?*pango.FontFace, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const chooseFace = gtk_font_dialog_choose_face;

    /// Finishes the `gtk.FontDialog.chooseFace` call
    /// and returns the resulting font face.
    extern fn gtk_font_dialog_choose_face_finish(p_self: *FontDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*pango.FontFace;
    pub const chooseFaceFinish = gtk_font_dialog_choose_face_finish;

    /// This function initiates a font selection operation by
    /// presenting a dialog to the user for selecting a font family.
    extern fn gtk_font_dialog_choose_family(p_self: *FontDialog, p_parent: ?*gtk.Window, p_initial_value: ?*pango.FontFamily, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const chooseFamily = gtk_font_dialog_choose_family;

    /// Finishes the `gtk.FontDialog.chooseFamily` call
    /// and returns the resulting family.
    ///
    /// This function never returns an error. If the operation is
    /// not finished successfully, the value passed as `initial_value`
    /// to `gtk.FontDialog.chooseFamily` is returned.
    extern fn gtk_font_dialog_choose_family_finish(p_self: *FontDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*pango.FontFamily;
    pub const chooseFamilyFinish = gtk_font_dialog_choose_family_finish;

    /// This function initiates a font selection operation by
    /// presenting a dialog to the user for selecting a font.
    ///
    /// If you want to let the user select font features as well,
    /// use `gtk.FontDialog.chooseFontAndFeatures` instead.
    extern fn gtk_font_dialog_choose_font(p_self: *FontDialog, p_parent: ?*gtk.Window, p_initial_value: ?*pango.FontDescription, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const chooseFont = gtk_font_dialog_choose_font;

    /// This function initiates a font selection operation by
    /// presenting a dialog to the user for selecting a font and
    /// font features.
    ///
    /// Font features affect how the font is rendered, for example
    /// enabling glyph variants or ligatures.
    extern fn gtk_font_dialog_choose_font_and_features(p_self: *FontDialog, p_parent: ?*gtk.Window, p_initial_value: ?*pango.FontDescription, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const chooseFontAndFeatures = gtk_font_dialog_choose_font_and_features;

    /// Finishes the `gtk.FontDialog.chooseFontAndFeatures`
    /// call and returns the resulting font description and font features.
    extern fn gtk_font_dialog_choose_font_and_features_finish(p_self: *FontDialog, p_result: *gio.AsyncResult, p_font_desc: **pango.FontDescription, p_font_features: *[*:0]u8, p_language: **pango.Language, p_error: ?*?*glib.Error) c_int;
    pub const chooseFontAndFeaturesFinish = gtk_font_dialog_choose_font_and_features_finish;

    /// Finishes the `gtk.FontDialog.chooseFont` call
    /// and returns the resulting font description.
    extern fn gtk_font_dialog_choose_font_finish(p_self: *FontDialog, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*pango.FontDescription;
    pub const chooseFontFinish = gtk_font_dialog_choose_font_finish;

    /// Returns the filter that decides which fonts to display
    /// in the font chooser dialog.
    extern fn gtk_font_dialog_get_filter(p_self: *FontDialog) ?*gtk.Filter;
    pub const getFilter = gtk_font_dialog_get_filter;

    /// Returns the fontmap from which fonts are selected,
    /// or `NULL` for the default fontmap.
    extern fn gtk_font_dialog_get_font_map(p_self: *FontDialog) ?*pango.FontMap;
    pub const getFontMap = gtk_font_dialog_get_font_map;

    /// Returns the language for which font features are applied.
    extern fn gtk_font_dialog_get_language(p_self: *FontDialog) ?*pango.Language;
    pub const getLanguage = gtk_font_dialog_get_language;

    /// Returns whether the font chooser dialog
    /// blocks interaction with the parent window
    /// while it is presented.
    extern fn gtk_font_dialog_get_modal(p_self: *FontDialog) c_int;
    pub const getModal = gtk_font_dialog_get_modal;

    /// Returns the title that will be shown on the
    /// font chooser dialog.
    extern fn gtk_font_dialog_get_title(p_self: *FontDialog) [*:0]const u8;
    pub const getTitle = gtk_font_dialog_get_title;

    /// Adds a filter that decides which fonts to display
    /// in the font chooser dialog.
    ///
    /// The `GtkFilter` must be able to handle both `PangoFontFamily`
    /// and `PangoFontFace` objects.
    extern fn gtk_font_dialog_set_filter(p_self: *FontDialog, p_filter: ?*gtk.Filter) void;
    pub const setFilter = gtk_font_dialog_set_filter;

    /// Sets the fontmap from which fonts are selected.
    ///
    /// If `fontmap` is `NULL`, the default fontmap is used.
    extern fn gtk_font_dialog_set_font_map(p_self: *FontDialog, p_fontmap: ?*pango.FontMap) void;
    pub const setFontMap = gtk_font_dialog_set_font_map;

    /// Sets the language for which font features are applied.
    extern fn gtk_font_dialog_set_language(p_self: *FontDialog, p_language: *pango.Language) void;
    pub const setLanguage = gtk_font_dialog_set_language;

    /// Sets whether the font chooser dialog
    /// blocks interaction with the parent window
    /// while it is presented.
    extern fn gtk_font_dialog_set_modal(p_self: *FontDialog, p_modal: c_int) void;
    pub const setModal = gtk_font_dialog_set_modal;

    /// Sets the title that will be shown on the
    /// font chooser dialog.
    extern fn gtk_font_dialog_set_title(p_self: *FontDialog, p_title: [*:0]const u8) void;
    pub const setTitle = gtk_font_dialog_set_title;

    extern fn gtk_font_dialog_get_type() usize;
    pub const getGObjectType = gtk_font_dialog_get_type;

    extern fn g_object_ref(p_self: *gtk.FontDialog) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FontDialog) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FontDialog, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `GtkFontDialogButton` is wrapped around a `gtk.FontDialog`
/// and allows to open a font chooser dialog to change the font.
///
/// ![An example GtkFontDialogButton](font-button.png)
///
/// It is suitable widget for selecting a font in a preference dialog.
///
/// # CSS nodes
///
/// ```
/// fontbutton
/// ╰── button.font
///     ╰── [content]
/// ```
///
/// `GtkFontDialogButton` has a single CSS node with name fontbutton which
/// contains a button node with the .font style class.
pub const FontDialogButton = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.FontDialogButtonClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `GtkFontDialog` that contains parameters for
        /// the font chooser dialog.
        pub const dialog = struct {
            pub const name = "dialog";

            pub const Type = ?*gtk.FontDialog;
        };

        /// The selected font.
        ///
        /// This property can be set to give the button its initial
        /// font, and it will be updated to reflect the users choice
        /// in the font chooser dialog.
        ///
        /// Listen to `notify::font-desc` to get informed about changes
        /// to the buttons font.
        pub const font_desc = struct {
            pub const name = "font-desc";

            pub const Type = ?*pango.FontDescription;
        };

        /// The selected font features.
        ///
        /// This property will be updated to reflect the users choice
        /// in the font chooser dialog.
        ///
        /// Listen to `notify::font-features` to get informed about changes
        /// to the buttons font features.
        pub const font_features = struct {
            pub const name = "font-features";

            pub const Type = ?[*:0]u8;
        };

        /// The selected language for font features.
        ///
        /// This property will be updated to reflect the users choice
        /// in the font chooser dialog.
        ///
        /// Listen to `notify::language` to get informed about changes
        /// to the buttons language.
        pub const language = struct {
            pub const name = "language";

            pub const Type = ?*pango.Language;
        };

        /// The level of detail for the font chooser dialog.
        pub const level = struct {
            pub const name = "level";

            pub const Type = gtk.FontLevel;
        };

        /// Whether the buttons label will be drawn in the selected font.
        pub const use_font = struct {
            pub const name = "use-font";

            pub const Type = c_int;
        };

        /// Whether the buttons label will use the selected font size.
        pub const use_size = struct {
            pub const name = "use-size";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the font dialog button is activated.
        ///
        /// The `::activate` signal on `GtkFontDialogButton` is an action signal
        /// and emitting it causes the button to pop up its dialog.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FontDialogButton, p_instance))),
                    gobject.signalLookup("activate", FontDialogButton.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkFontDialogButton` with the
    /// given `GtkFontDialog`.
    ///
    /// You can pass `NULL` to this function and set a `GtkFontDialog`
    /// later. The button will be insensitive until that happens.
    extern fn gtk_font_dialog_button_new(p_dialog: ?*gtk.FontDialog) *gtk.FontDialogButton;
    pub const new = gtk_font_dialog_button_new;

    /// Returns the `GtkFontDialog` of `self`.
    extern fn gtk_font_dialog_button_get_dialog(p_self: *FontDialogButton) ?*gtk.FontDialog;
    pub const getDialog = gtk_font_dialog_button_get_dialog;

    /// Returns the font of the button.
    ///
    /// This function is what should be used to obtain
    /// the font that was chosen by the user. To get
    /// informed about changes, listen to "notify::font-desc".
    extern fn gtk_font_dialog_button_get_font_desc(p_self: *FontDialogButton) ?*pango.FontDescription;
    pub const getFontDesc = gtk_font_dialog_button_get_font_desc;

    /// Returns the font features of the button.
    ///
    /// This function is what should be used to obtain the font features
    /// that were chosen by the user. To get informed about changes, listen
    /// to "notify::font-features".
    ///
    /// Note that the button will only let users choose font features
    /// if `gtk.FontDialogButton.properties.level` is set to
    /// `GTK_FONT_LEVEL_FEATURES`.
    extern fn gtk_font_dialog_button_get_font_features(p_self: *FontDialogButton) ?[*:0]const u8;
    pub const getFontFeatures = gtk_font_dialog_button_get_font_features;

    /// Returns the language that is used for font features.
    extern fn gtk_font_dialog_button_get_language(p_self: *FontDialogButton) ?*pango.Language;
    pub const getLanguage = gtk_font_dialog_button_get_language;

    /// Returns the level of detail at which this dialog
    /// lets the user select fonts.
    extern fn gtk_font_dialog_button_get_level(p_self: *FontDialogButton) gtk.FontLevel;
    pub const getLevel = gtk_font_dialog_button_get_level;

    /// Returns whether the selected font is used in the label.
    extern fn gtk_font_dialog_button_get_use_font(p_self: *FontDialogButton) c_int;
    pub const getUseFont = gtk_font_dialog_button_get_use_font;

    /// Returns whether the selected font size is used in the label.
    extern fn gtk_font_dialog_button_get_use_size(p_self: *FontDialogButton) c_int;
    pub const getUseSize = gtk_font_dialog_button_get_use_size;

    /// Sets a `GtkFontDialog` object to use for
    /// creating the font chooser dialog that is
    /// presented when the user clicks the button.
    extern fn gtk_font_dialog_button_set_dialog(p_self: *FontDialogButton, p_dialog: *gtk.FontDialog) void;
    pub const setDialog = gtk_font_dialog_button_set_dialog;

    /// Sets the font of the button.
    extern fn gtk_font_dialog_button_set_font_desc(p_self: *FontDialogButton, p_font_desc: *const pango.FontDescription) void;
    pub const setFontDesc = gtk_font_dialog_button_set_font_desc;

    /// Sets the font features of the button.
    extern fn gtk_font_dialog_button_set_font_features(p_self: *FontDialogButton, p_font_features: ?[*:0]const u8) void;
    pub const setFontFeatures = gtk_font_dialog_button_set_font_features;

    /// Sets the language to use for font features.
    extern fn gtk_font_dialog_button_set_language(p_self: *FontDialogButton, p_language: ?*pango.Language) void;
    pub const setLanguage = gtk_font_dialog_button_set_language;

    /// Sets the level of detail at which this dialog
    /// lets the user select fonts.
    extern fn gtk_font_dialog_button_set_level(p_self: *FontDialogButton, p_level: gtk.FontLevel) void;
    pub const setLevel = gtk_font_dialog_button_set_level;

    /// If `use_font` is `TRUE`, the font name will be written
    /// using the selected font.
    extern fn gtk_font_dialog_button_set_use_font(p_self: *FontDialogButton, p_use_font: c_int) void;
    pub const setUseFont = gtk_font_dialog_button_set_use_font;

    /// If `use_size` is `TRUE`, the font name will be written
    /// using the selected font size.
    extern fn gtk_font_dialog_button_set_use_size(p_self: *FontDialogButton, p_use_size: c_int) void;
    pub const setUseSize = gtk_font_dialog_button_set_use_size;

    extern fn gtk_font_dialog_button_get_type() usize;
    pub const getGObjectType = gtk_font_dialog_button_get_type;

    extern fn g_object_ref(p_self: *gtk.FontDialogButton) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.FontDialogButton) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FontDialogButton, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkFrame` is a widget that surrounds its child with a decorative
/// frame and an optional label.
///
/// ![An example GtkFrame](frame.png)
///
/// If present, the label is drawn inside the top edge of the frame.
/// The horizontal position of the label can be controlled with
/// `gtk.Frame.setLabelAlign`.
///
/// `GtkFrame` clips its child. You can use this to add rounded corners
/// to widgets, but be aware that it also cuts off shadows.
///
/// # GtkFrame as GtkBuildable
///
/// The `GtkFrame` implementation of the `GtkBuildable` interface supports
/// placing a child in the label position by specifying “label” as the
/// “type” attribute of a `<child>` element. A normal content child can
/// be specified without specifying a `<child>` type attribute.
///
/// An example of a UI definition fragment with GtkFrame:
/// ```xml
/// <object class="GtkFrame">
///   <child type="label">
///     <object class="GtkLabel" id="frame_label"/>
///   </child>
///   <child>
///     <object class="GtkEntry" id="frame_content"/>
///   </child>
/// </object>
/// ```
///
/// # CSS nodes
///
/// ```
/// frame
/// ├── <label widget>
/// ╰── <child>
/// ```
///
/// `GtkFrame` has a main CSS node with name “frame”, which is used to draw the
/// visible border. You can set the appearance of the border using CSS properties
/// like “border-style” on this node.
///
/// # Accessibility
///
/// `GtkFrame` uses the `GTK_ACCESSIBLE_ROLE_GROUP` role.
pub const Frame = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.FrameClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        pub const compute_child_allocation = struct {
            pub fn call(p_class: anytype, p_frame: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_allocation: *gtk.Allocation) void {
                return gobject.ext.as(Frame.Class, p_class).f_compute_child_allocation.?(gobject.ext.as(Frame, p_frame), p_allocation);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_frame: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_allocation: *gtk.Allocation) callconv(.C) void) void {
                gobject.ext.as(Frame.Class, p_class).f_compute_child_allocation = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// Text of the frame's label.
        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };

        /// Widget to display in place of the usual frame label.
        pub const label_widget = struct {
            pub const name = "label-widget";

            pub const Type = ?*gtk.Widget;
        };

        /// The horizontal alignment of the label.
        pub const label_xalign = struct {
            pub const name = "label-xalign";

            pub const Type = f32;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkFrame`, with optional label `label`.
    ///
    /// If `label` is `NULL`, the label is omitted.
    extern fn gtk_frame_new(p_label: ?[*:0]const u8) *gtk.Frame;
    pub const new = gtk_frame_new;

    /// Gets the child widget of `frame`.
    extern fn gtk_frame_get_child(p_frame: *Frame) ?*gtk.Widget;
    pub const getChild = gtk_frame_get_child;

    /// Returns the frame labels text.
    ///
    /// If the frame's label widget is not a `GtkLabel`, `NULL`
    /// is returned.
    extern fn gtk_frame_get_label(p_frame: *Frame) ?[*:0]const u8;
    pub const getLabel = gtk_frame_get_label;

    /// Retrieves the X alignment of the frame’s label.
    extern fn gtk_frame_get_label_align(p_frame: *Frame) f32;
    pub const getLabelAlign = gtk_frame_get_label_align;

    /// Retrieves the label widget for the frame.
    extern fn gtk_frame_get_label_widget(p_frame: *Frame) ?*gtk.Widget;
    pub const getLabelWidget = gtk_frame_get_label_widget;

    /// Sets the child widget of `frame`.
    extern fn gtk_frame_set_child(p_frame: *Frame, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_frame_set_child;

    /// Creates a new `GtkLabel` with the `label` and sets it as the frame's
    /// label widget.
    extern fn gtk_frame_set_label(p_frame: *Frame, p_label: ?[*:0]const u8) void;
    pub const setLabel = gtk_frame_set_label;

    /// Sets the X alignment of the frame widget’s label.
    ///
    /// The default value for a newly created frame is 0.0.
    extern fn gtk_frame_set_label_align(p_frame: *Frame, p_xalign: f32) void;
    pub const setLabelAlign = gtk_frame_set_label_align;

    /// Sets the label widget for the frame.
    ///
    /// This is the widget that will appear embedded in the top edge
    /// of the frame as a title.
    extern fn gtk_frame_set_label_widget(p_frame: *Frame, p_label_widget: ?*gtk.Widget) void;
    pub const setLabelWidget = gtk_frame_set_label_widget;

    extern fn gtk_frame_get_type() usize;
    pub const getGObjectType = gtk_frame_get_type;

    extern fn g_object_ref(p_self: *gtk.Frame) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Frame) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Frame, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGLArea` is a widget that allows drawing with OpenGL.
///
/// ![An example GtkGLArea](glarea.png)
///
/// `GtkGLArea` sets up its own `gdk.GLContext`, and creates a custom
/// GL framebuffer that the widget will do GL rendering onto. It also ensures
/// that this framebuffer is the default GL rendering target when rendering.
/// The completed rendering is integrated into the larger GTK scene graph as
/// a texture.
///
/// In order to draw, you have to connect to the `gtk.GLArea.signals.render`
/// signal, or subclass `GtkGLArea` and override the GtkGLAreaClass.render
/// virtual function.
///
/// The `GtkGLArea` widget ensures that the `GdkGLContext` is associated with
/// the widget's drawing area, and it is kept updated when the size and
/// position of the drawing area changes.
///
/// ## Drawing with GtkGLArea
///
/// The simplest way to draw using OpenGL commands in a `GtkGLArea` is to
/// create a widget instance and connect to the `gtk.GLArea.signals.render` signal:
///
/// The ``render`` function will be called when the `GtkGLArea` is ready
/// for you to draw its content:
///
/// The initial contents of the framebuffer are transparent.
///
/// ```c
/// static gboolean
/// render (GtkGLArea *area, GdkGLContext *context)
/// {
///   // inside this function it's safe to use GL; the given
///   // GdkGLContext has been made current to the drawable
///   // surface used by the `GtkGLArea` and the viewport has
///   // already been set to be the size of the allocation
///
///   // we can start by clearing the buffer
///   glClearColor (0, 0, 0, 0);
///   glClear (GL_COLOR_BUFFER_BIT);
///
///   // draw your object
///   // draw_an_object ();
///
///   // we completed our drawing; the draw commands will be
///   // flushed at the end of the signal emission chain, and
///   // the buffers will be drawn on the window
///   return TRUE;
/// }
///
/// void setup_glarea (void)
/// {
///   // create a GtkGLArea instance
///   GtkWidget *gl_area = gtk_gl_area_new ();
///
///   // connect to the "render" signal
///   g_signal_connect (gl_area, "render", G_CALLBACK (render), NULL);
/// }
/// ```
///
/// If you need to initialize OpenGL state, e.g. buffer objects or
/// shaders, you should use the `gtk.Widget.signals.realize` signal;
/// you can use the `gtk.Widget.signals.unrealize` signal to clean up.
/// Since the `GdkGLContext` creation and initialization may fail, you
/// will need to check for errors, using `gtk.GLArea.getError`.
///
/// An example of how to safely initialize the GL state is:
///
/// ```c
/// static void
/// on_realize (GtkGLarea *area)
/// {
///   // We need to make the context current if we want to
///   // call GL API
///   gtk_gl_area_make_current (area);
///
///   // If there were errors during the initialization or
///   // when trying to make the context current, this
///   // function will return a GError for you to catch
///   if (gtk_gl_area_get_error (area) != NULL)
///     return;
///
///   // You can also use `gtk.GLArea.setError` in order
///   // to show eventual initialization errors on the
///   // GtkGLArea widget itself
///   GError *internal_error = NULL;
///   init_buffer_objects (&error);
///   if (error != NULL)
///     {
///       gtk_gl_area_set_error (area, error);
///       g_error_free (error);
///       return;
///     }
///
///   init_shaders (&error);
///   if (error != NULL)
///     {
///       gtk_gl_area_set_error (area, error);
///       g_error_free (error);
///       return;
///     }
/// }
/// ```
///
/// If you need to change the options for creating the `GdkGLContext`
/// you should use the `gtk.GLArea.signals.create_context` signal.
pub const GLArea = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.GLAreaClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {
        /// class closure for the `GtkGLArea::create-context` signal
        pub const create_context = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) *gdk.GLContext {
                return gobject.ext.as(GLArea.Class, p_class).f_create_context.?(gobject.ext.as(GLArea, p_area));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) *gdk.GLContext) void {
                gobject.ext.as(GLArea.Class, p_class).f_create_context = @ptrCast(p_implementation);
            }
        };

        /// class closure for the `GtkGLArea::render` signal
        pub const render = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gdk.GLContext) c_int {
                return gobject.ext.as(GLArea.Class, p_class).f_render.?(gobject.ext.as(GLArea, p_area), p_context);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context: *gdk.GLContext) callconv(.C) c_int) void {
                gobject.ext.as(GLArea.Class, p_class).f_render = @ptrCast(p_implementation);
            }
        };

        /// class closeure for the `GtkGLArea::resize` signal
        pub const resize = struct {
            pub fn call(p_class: anytype, p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_height: c_int) void {
                return gobject.ext.as(GLArea.Class, p_class).f_resize.?(gobject.ext.as(GLArea, p_area), p_width, p_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_area: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: c_int, p_height: c_int) callconv(.C) void) void {
                gobject.ext.as(GLArea.Class, p_class).f_resize = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The allowed APIs.
        pub const allowed_apis = struct {
            pub const name = "allowed-apis";

            pub const Type = gdk.GLAPI;
        };

        /// The API currently in use.
        pub const api = struct {
            pub const name = "api";

            pub const Type = gdk.GLAPI;
        };

        /// If set to `TRUE` the ::render signal will be emitted every time
        /// the widget draws.
        ///
        /// This is the default and is useful if drawing the widget is faster.
        ///
        /// If set to `FALSE` the data from previous rendering is kept around and will
        /// be used for drawing the widget the next time, unless the window is resized.
        /// In order to force a rendering `gtk.GLArea.queueRender` must be called.
        /// This mode is useful when the scene changes seldom, but takes a long time
        /// to redraw.
        pub const auto_render = struct {
            pub const name = "auto-render";

            pub const Type = c_int;
        };

        /// The `GdkGLContext` used by the `GtkGLArea` widget.
        ///
        /// The `GtkGLArea` widget is responsible for creating the `GdkGLContext`
        /// instance. If you need to render with other kinds of buffers (stencil,
        /// depth, etc), use render buffers.
        pub const context = struct {
            pub const name = "context";

            pub const Type = ?*gdk.GLContext;
        };

        /// If set to `TRUE` the widget will allocate and enable a depth buffer for the
        /// target framebuffer.
        ///
        /// Setting this property will enable GL's depth testing as a side effect. If
        /// you don't need depth testing, you should call `glDisable(GL_DEPTH_TEST)`
        /// in your `GtkGLArea::render` handler.
        pub const has_depth_buffer = struct {
            pub const name = "has-depth-buffer";

            pub const Type = c_int;
        };

        /// If set to `TRUE` the widget will allocate and enable a stencil buffer for the
        /// target framebuffer.
        pub const has_stencil_buffer = struct {
            pub const name = "has-stencil-buffer";

            pub const Type = c_int;
        };

        /// If set to `TRUE` the widget will try to create a `GdkGLContext` using
        /// OpenGL ES instead of OpenGL.
        pub const use_es = struct {
            pub const name = "use-es";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the widget is being realized.
        ///
        /// This allows you to override how the GL context is created.
        /// This is useful when you want to reuse an existing GL context,
        /// or if you want to try creating different kinds of GL options.
        ///
        /// If context creation fails then the signal handler can use
        /// `gtk.GLArea.setError` to register a more detailed error
        /// of how the construction failed.
        pub const create_context = struct {
            pub const name = "create-context";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) *gdk.GLContext, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GLArea, p_instance))),
                    gobject.signalLookup("create-context", GLArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted every time the contents of the `GtkGLArea` should be redrawn.
        ///
        /// The `context` is bound to the `area` prior to emitting this function,
        /// and the buffers are painted to the window once the emission terminates.
        pub const render = struct {
            pub const name = "render";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_context: *gdk.GLContext, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GLArea, p_instance))),
                    gobject.signalLookup("render", GLArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted once when the widget is realized, and then each time the widget
        /// is changed while realized.
        ///
        /// This is useful in order to keep GL state up to date with the widget size,
        /// like for instance camera properties which may depend on the width/height
        /// ratio.
        ///
        /// The GL context for the area is guaranteed to be current when this signal
        /// is emitted.
        ///
        /// The default handler sets up the GL viewport.
        pub const resize = struct {
            pub const name = "resize";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_width: c_int, p_height: c_int, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GLArea, p_instance))),
                    gobject.signalLookup("resize", GLArea.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkGLArea` widget.
    extern fn gtk_gl_area_new() *gtk.GLArea;
    pub const new = gtk_gl_area_new;

    /// Binds buffers to the framebuffer.
    ///
    /// Ensures that the `area` framebuffer object is made the current draw
    /// and read target, and that all the required buffers for the `area`
    /// are created and bound to the framebuffer.
    ///
    /// This function is automatically called before emitting the
    /// `gtk.GLArea.signals.render` signal, and doesn't normally need to be
    /// called by application code.
    extern fn gtk_gl_area_attach_buffers(p_area: *GLArea) void;
    pub const attachBuffers = gtk_gl_area_attach_buffers;

    /// Gets the allowed APIs.
    ///
    /// See `gtk.GLArea.setAllowedApis`.
    extern fn gtk_gl_area_get_allowed_apis(p_area: *GLArea) gdk.GLAPI;
    pub const getAllowedApis = gtk_gl_area_get_allowed_apis;

    /// Gets the API that is currently in use.
    ///
    /// If the GL area has not been realized yet, 0 is returned.
    extern fn gtk_gl_area_get_api(p_area: *GLArea) gdk.GLAPI;
    pub const getApi = gtk_gl_area_get_api;

    /// Returns whether the area is in auto render mode or not.
    extern fn gtk_gl_area_get_auto_render(p_area: *GLArea) c_int;
    pub const getAutoRender = gtk_gl_area_get_auto_render;

    /// Retrieves the `GdkGLContext` used by `area`.
    extern fn gtk_gl_area_get_context(p_area: *GLArea) ?*gdk.GLContext;
    pub const getContext = gtk_gl_area_get_context;

    /// Gets the current error set on the `area`.
    extern fn gtk_gl_area_get_error(p_area: *GLArea) ?*glib.Error;
    pub const getError = gtk_gl_area_get_error;

    /// Returns whether the area has a depth buffer.
    extern fn gtk_gl_area_get_has_depth_buffer(p_area: *GLArea) c_int;
    pub const getHasDepthBuffer = gtk_gl_area_get_has_depth_buffer;

    /// Returns whether the area has a stencil buffer.
    extern fn gtk_gl_area_get_has_stencil_buffer(p_area: *GLArea) c_int;
    pub const getHasStencilBuffer = gtk_gl_area_get_has_stencil_buffer;

    /// Retrieves the required version of OpenGL.
    ///
    /// See `gtk.GLArea.setRequiredVersion`.
    extern fn gtk_gl_area_get_required_version(p_area: *GLArea, p_major: *c_int, p_minor: *c_int) void;
    pub const getRequiredVersion = gtk_gl_area_get_required_version;

    /// Returns whether the `GtkGLArea` should use OpenGL ES.
    ///
    /// See `gtk.GLArea.setUseEs`.
    extern fn gtk_gl_area_get_use_es(p_area: *GLArea) c_int;
    pub const getUseEs = gtk_gl_area_get_use_es;

    /// Ensures that the `GdkGLContext` used by `area` is associated with
    /// the `GtkGLArea`.
    ///
    /// This function is automatically called before emitting the
    /// `gtk.GLArea.signals.render` signal, and doesn't normally need
    /// to be called by application code.
    extern fn gtk_gl_area_make_current(p_area: *GLArea) void;
    pub const makeCurrent = gtk_gl_area_make_current;

    /// Marks the currently rendered data (if any) as invalid, and queues
    /// a redraw of the widget.
    ///
    /// This ensures that the `gtk.GLArea.signals.render` signal
    /// is emitted during the draw.
    ///
    /// This is only needed when `gtk.GLArea.setAutoRender` has
    /// been called with a `FALSE` value. The default behaviour is to
    /// emit `gtk.GLArea.signals.render` on each draw.
    extern fn gtk_gl_area_queue_render(p_area: *GLArea) void;
    pub const queueRender = gtk_gl_area_queue_render;

    /// Sets the allowed APIs to create a context with.
    ///
    /// You should check `gtk.GLArea.properties.api` before drawing
    /// with either API.
    ///
    /// By default, all APIs are allowed.
    extern fn gtk_gl_area_set_allowed_apis(p_area: *GLArea, p_apis: gdk.GLAPI) void;
    pub const setAllowedApis = gtk_gl_area_set_allowed_apis;

    /// Sets whether the `GtkGLArea` is in auto render mode.
    ///
    /// If `auto_render` is `TRUE` the `gtk.GLArea.signals.render` signal will
    /// be emitted every time the widget draws. This is the default and is
    /// useful if drawing the widget is faster.
    ///
    /// If `auto_render` is `FALSE` the data from previous rendering is kept
    /// around and will be used for drawing the widget the next time,
    /// unless the window is resized. In order to force a rendering
    /// `gtk.GLArea.queueRender` must be called. This mode is
    /// useful when the scene changes seldom, but takes a long time to redraw.
    extern fn gtk_gl_area_set_auto_render(p_area: *GLArea, p_auto_render: c_int) void;
    pub const setAutoRender = gtk_gl_area_set_auto_render;

    /// Sets an error on the area which will be shown instead of the
    /// GL rendering.
    ///
    /// This is useful in the `gtk.GLArea.signals.create_context`
    /// signal if GL context creation fails.
    extern fn gtk_gl_area_set_error(p_area: *GLArea, p_error: ?*const glib.Error) void;
    pub const setError = gtk_gl_area_set_error;

    /// Sets whether the `GtkGLArea` should use a depth buffer.
    ///
    /// If `has_depth_buffer` is `TRUE` the widget will allocate and
    /// enable a depth buffer for the target framebuffer. Otherwise
    /// there will be none.
    extern fn gtk_gl_area_set_has_depth_buffer(p_area: *GLArea, p_has_depth_buffer: c_int) void;
    pub const setHasDepthBuffer = gtk_gl_area_set_has_depth_buffer;

    /// Sets whether the `GtkGLArea` should use a stencil buffer.
    ///
    /// If `has_stencil_buffer` is `TRUE` the widget will allocate and
    /// enable a stencil buffer for the target framebuffer. Otherwise
    /// there will be none.
    extern fn gtk_gl_area_set_has_stencil_buffer(p_area: *GLArea, p_has_stencil_buffer: c_int) void;
    pub const setHasStencilBuffer = gtk_gl_area_set_has_stencil_buffer;

    /// Sets the required version of OpenGL to be used when creating
    /// the context for the widget.
    ///
    /// This function must be called before the area has been realized.
    extern fn gtk_gl_area_set_required_version(p_area: *GLArea, p_major: c_int, p_minor: c_int) void;
    pub const setRequiredVersion = gtk_gl_area_set_required_version;

    /// Sets whether the `area` should create an OpenGL or an OpenGL ES context.
    ///
    /// You should check the capabilities of the `GdkGLContext` before drawing
    /// with either API.
    extern fn gtk_gl_area_set_use_es(p_area: *GLArea, p_use_es: c_int) void;
    pub const setUseEs = gtk_gl_area_set_use_es;

    extern fn gtk_gl_area_get_type() usize;
    pub const getGObjectType = gtk_gl_area_get_type;

    extern fn g_object_ref(p_self: *gtk.GLArea) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GLArea) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GLArea, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGesture` is the base class for gesture recognition.
///
/// Although `GtkGesture` is quite generalized to serve as a base for
/// multi-touch gestures, it is suitable to implement single-touch and
/// pointer-based gestures (using the special `NULL` `GdkEventSequence`
/// value for these).
///
/// The number of touches that a `GtkGesture` need to be recognized is
/// controlled by the `gtk.Gesture.properties.n_points` property, if a
/// gesture is keeping track of less or more than that number of sequences,
/// it won't check whether the gesture is recognized.
///
/// As soon as the gesture has the expected number of touches, it will check
/// regularly if it is recognized, the criteria to consider a gesture as
/// "recognized" is left to `GtkGesture` subclasses.
///
/// A recognized gesture will then emit the following signals:
///
/// - `gtk.Gesture.signals.begin` when the gesture is recognized.
/// - `gtk.Gesture.signals.update`, whenever an input event is processed.
/// - `gtk.Gesture.signals.end` when the gesture is no longer recognized.
///
/// ## Event propagation
///
/// In order to receive events, a gesture needs to set a propagation phase
/// through `gtk.EventController.setPropagationPhase`.
///
/// In the capture phase, events are propagated from the toplevel down
/// to the target widget, and gestures that are attached to containers
/// above the widget get a chance to interact with the event before it
/// reaches the target.
///
/// In the bubble phase, events are propagated up from the target widget
/// to the toplevel, and gestures that are attached to containers above
/// the widget get a chance to interact with events that have not been
/// handled yet.
///
/// ## States of a sequence
///
/// Whenever input interaction happens, a single event may trigger a cascade
/// of `GtkGesture`s, both across the parents of the widget receiving the
/// event and in parallel within an individual widget. It is a responsibility
/// of the widgets using those gestures to set the state of touch sequences
/// accordingly in order to enable cooperation of gestures around the
/// `GdkEventSequence`s triggering those.
///
/// Within a widget, gestures can be grouped through `gtk.Gesture.group`.
/// Grouped gestures synchronize the state of sequences, so calling
/// `gtk.Gesture.setState` on one will effectively propagate
/// the state throughout the group.
///
/// By default, all sequences start out in the `GTK_EVENT_SEQUENCE_NONE` state,
/// sequences in this state trigger the gesture event handler, but event
/// propagation will continue unstopped by gestures.
///
/// If a sequence enters into the `GTK_EVENT_SEQUENCE_DENIED` state, the gesture
/// group will effectively ignore the sequence, letting events go unstopped
/// through the gesture, but the "slot" will still remain occupied while
/// the touch is active.
///
/// If a sequence enters in the `GTK_EVENT_SEQUENCE_CLAIMED` state, the gesture
/// group will grab all interaction on the sequence, by:
///
/// - Setting the same sequence to `GTK_EVENT_SEQUENCE_DENIED` on every other
///   gesture group within the widget, and every gesture on parent widgets
///   in the propagation chain.
/// - Emitting `gtk.Gesture.signals.cancel` on every gesture in widgets
///   underneath in the propagation chain.
/// - Stopping event propagation after the gesture group handles the event.
///
/// Note: if a sequence is set early to `GTK_EVENT_SEQUENCE_CLAIMED` on
/// `GDK_TOUCH_BEGIN`/`GDK_BUTTON_PRESS` (so those events are captured before
/// reaching the event widget, this implies `GTK_PHASE_CAPTURE`), one similar
/// event will be emulated if the sequence changes to `GTK_EVENT_SEQUENCE_DENIED`.
/// This way event coherence is preserved before event propagation is unstopped
/// again.
///
/// Sequence states can't be changed freely.
/// See `gtk.Gesture.setState` to know about the possible
/// lifetimes of a `GdkEventSequence`.
///
/// ## Touchpad gestures
///
/// On the platforms that support it, `GtkGesture` will handle transparently
/// touchpad gesture events. The only precautions users of `GtkGesture` should
/// do to enable this support are:
///
/// - If the gesture has `GTK_PHASE_NONE`, ensuring events of type
///   `GDK_TOUCHPAD_SWIPE` and `GDK_TOUCHPAD_PINCH` are handled by the `GtkGesture`
pub const Gesture = opaque {
    pub const Parent = gtk.EventController;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The number of touch points that trigger
        /// recognition on this gesture.
        pub const n_points = struct {
            pub const name = "n-points";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// Emitted when the gesture is recognized.
        ///
        /// This means the number of touch sequences matches
        /// `gtk.Gesture.properties.n_points`.
        ///
        /// Note: These conditions may also happen when an extra touch
        /// (eg. a third touch on a 2-touches gesture) is lifted, in that
        /// situation `sequence` won't pertain to the current set of active
        /// touches, so don't rely on this being true.
        pub const begin = struct {
            pub const name = "begin";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_sequence: ?*gdk.EventSequence, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Gesture, p_instance))),
                    gobject.signalLookup("begin", Gesture.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever a sequence is cancelled.
        ///
        /// This usually happens on active touches when
        /// `gtk.EventController.reset` is called on `gesture`
        /// (manually, due to grabs...), or the individual `sequence`
        /// was claimed by parent widgets' controllers (see
        /// `gtk.Gesture.setSequenceState`).
        ///
        /// `gesture` must forget everything about `sequence` as in
        /// response to this signal.
        pub const cancel = struct {
            pub const name = "cancel";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_sequence: ?*gdk.EventSequence, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Gesture, p_instance))),
                    gobject.signalLookup("cancel", Gesture.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when `gesture` either stopped recognizing the event
        /// sequences as something to be handled, or the number of touch
        /// sequences became higher or lower than `gtk.Gesture.properties.n_points`.
        ///
        /// Note: `sequence` might not pertain to the group of sequences that
        /// were previously triggering recognition on `gesture` (ie. a just
        /// pressed touch sequence that exceeds `gtk.Gesture.properties.n_points`).
        /// This situation may be detected by checking through
        /// `gtk.Gesture.handlesSequence`.
        pub const end = struct {
            pub const name = "end";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_sequence: ?*gdk.EventSequence, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Gesture, p_instance))),
                    gobject.signalLookup("end", Gesture.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever a sequence state changes.
        ///
        /// See `gtk.Gesture.setSequenceState` to know
        /// more about the expectable sequence lifetimes.
        pub const sequence_state_changed = struct {
            pub const name = "sequence-state-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_sequence: ?*gdk.EventSequence, p_state: gtk.EventSequenceState, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Gesture, p_instance))),
                    gobject.signalLookup("sequence-state-changed", Gesture.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever an event is handled while the gesture is recognized.
        ///
        /// `sequence` is guaranteed to pertain to the set of active touches.
        pub const update = struct {
            pub const name = "update";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_sequence: ?*gdk.EventSequence, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Gesture, p_instance))),
                    gobject.signalLookup("update", Gesture.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// If there are touch sequences being currently handled by `gesture`,
    /// returns `TRUE` and fills in `rect` with the bounding box containing
    /// all active touches.
    ///
    /// Otherwise, `FALSE` will be returned.
    ///
    /// Note: This function will yield unexpected results on touchpad
    /// gestures. Since there is no correlation between physical and
    /// pixel distances, these will look as if constrained in an
    /// infinitely small area, `rect` width and height will thus be 0
    /// regardless of the number of touchpoints.
    extern fn gtk_gesture_get_bounding_box(p_gesture: *Gesture, p_rect: *gdk.Rectangle) c_int;
    pub const getBoundingBox = gtk_gesture_get_bounding_box;

    /// If there are touch sequences being currently handled by `gesture`,
    /// returns `TRUE` and fills in `x` and `y` with the center of the bounding
    /// box containing all active touches.
    ///
    /// Otherwise, `FALSE` will be returned.
    extern fn gtk_gesture_get_bounding_box_center(p_gesture: *Gesture, p_x: *f64, p_y: *f64) c_int;
    pub const getBoundingBoxCenter = gtk_gesture_get_bounding_box_center;

    /// Returns the logical `GdkDevice` that is currently operating
    /// on `gesture`.
    ///
    /// This returns `NULL` if the gesture is not being interacted.
    extern fn gtk_gesture_get_device(p_gesture: *Gesture) ?*gdk.Device;
    pub const getDevice = gtk_gesture_get_device;

    /// Returns all gestures in the group of `gesture`
    extern fn gtk_gesture_get_group(p_gesture: *Gesture) *glib.List;
    pub const getGroup = gtk_gesture_get_group;

    /// Returns the last event that was processed for `sequence`.
    ///
    /// Note that the returned pointer is only valid as long as the
    /// `sequence` is still interpreted by the `gesture`. If in doubt,
    /// you should make a copy of the event.
    extern fn gtk_gesture_get_last_event(p_gesture: *Gesture, p_sequence: ?*gdk.EventSequence) ?*gdk.Event;
    pub const getLastEvent = gtk_gesture_get_last_event;

    /// Returns the `GdkEventSequence` that was last updated on `gesture`.
    extern fn gtk_gesture_get_last_updated_sequence(p_gesture: *Gesture) ?*gdk.EventSequence;
    pub const getLastUpdatedSequence = gtk_gesture_get_last_updated_sequence;

    /// If `sequence` is currently being interpreted by `gesture`,
    /// returns `TRUE` and fills in `x` and `y` with the last coordinates
    /// stored for that event sequence.
    ///
    /// The coordinates are always relative to the widget allocation.
    extern fn gtk_gesture_get_point(p_gesture: *Gesture, p_sequence: ?*gdk.EventSequence, p_x: ?*f64, p_y: ?*f64) c_int;
    pub const getPoint = gtk_gesture_get_point;

    /// Returns the `sequence` state, as seen by `gesture`.
    extern fn gtk_gesture_get_sequence_state(p_gesture: *Gesture, p_sequence: *gdk.EventSequence) gtk.EventSequenceState;
    pub const getSequenceState = gtk_gesture_get_sequence_state;

    /// Returns the list of `GdkEventSequences` currently being interpreted
    /// by `gesture`.
    extern fn gtk_gesture_get_sequences(p_gesture: *Gesture) *glib.List;
    pub const getSequences = gtk_gesture_get_sequences;

    /// Adds `gesture` to the same group than `group_gesture`.
    ///
    /// Gestures are by default isolated in their own groups.
    ///
    /// Both gestures must have been added to the same widget before
    /// they can be grouped.
    ///
    /// When gestures are grouped, the state of `GdkEventSequences`
    /// is kept in sync for all of those, so calling
    /// `gtk.Gesture.setSequenceState`, on one will transfer
    /// the same value to the others.
    ///
    /// Groups also perform an "implicit grabbing" of sequences, if a
    /// `GdkEventSequence` state is set to `GTK_EVENT_SEQUENCE_CLAIMED`
    /// on one group, every other gesture group attached to the same
    /// `GtkWidget` will switch the state for that sequence to
    /// `GTK_EVENT_SEQUENCE_DENIED`.
    extern fn gtk_gesture_group(p_group_gesture: *Gesture, p_gesture: *gtk.Gesture) void;
    pub const group = gtk_gesture_group;

    /// Returns `TRUE` if `gesture` is currently handling events
    /// corresponding to `sequence`.
    extern fn gtk_gesture_handles_sequence(p_gesture: *Gesture, p_sequence: ?*gdk.EventSequence) c_int;
    pub const handlesSequence = gtk_gesture_handles_sequence;

    /// Returns `TRUE` if the gesture is currently active.
    ///
    /// A gesture is active while there are touch sequences
    /// interacting with it.
    extern fn gtk_gesture_is_active(p_gesture: *Gesture) c_int;
    pub const isActive = gtk_gesture_is_active;

    /// Returns `TRUE` if both gestures pertain to the same group.
    extern fn gtk_gesture_is_grouped_with(p_gesture: *Gesture, p_other: *gtk.Gesture) c_int;
    pub const isGroupedWith = gtk_gesture_is_grouped_with;

    /// Returns `TRUE` if the gesture is currently recognized.
    ///
    /// A gesture is recognized if there are as many interacting
    /// touch sequences as required by `gesture`.
    extern fn gtk_gesture_is_recognized(p_gesture: *Gesture) c_int;
    pub const isRecognized = gtk_gesture_is_recognized;

    /// Sets the state of `sequence` in `gesture`.
    ///
    /// Sequences start in state `GTK_EVENT_SEQUENCE_NONE`, and whenever
    /// they change state, they can never go back to that state. Likewise,
    /// sequences in state `GTK_EVENT_SEQUENCE_DENIED` cannot turn back to
    /// a not denied state. With these rules, the lifetime of an event
    /// sequence is constrained to the next four:
    ///
    /// * None
    /// * None → Denied
    /// * None → Claimed
    /// * None → Claimed → Denied
    ///
    /// Note: Due to event handling ordering, it may be unsafe to set the
    /// state on another gesture within a `gtk.Gesture.signals.begin` signal
    /// handler, as the callback might be executed before the other gesture
    /// knows about the sequence. A safe way to perform this could be:
    ///
    /// ```c
    /// static void
    /// first_gesture_begin_cb (GtkGesture       *first_gesture,
    ///                         GdkEventSequence *sequence,
    ///                         gpointer          user_data)
    /// {
    ///   gtk_gesture_set_sequence_state (first_gesture, sequence, GTK_EVENT_SEQUENCE_CLAIMED);
    ///   gtk_gesture_set_sequence_state (second_gesture, sequence, GTK_EVENT_SEQUENCE_DENIED);
    /// }
    ///
    /// static void
    /// second_gesture_begin_cb (GtkGesture       *second_gesture,
    ///                          GdkEventSequence *sequence,
    ///                          gpointer          user_data)
    /// {
    ///   if (gtk_gesture_get_sequence_state (first_gesture, sequence) == GTK_EVENT_SEQUENCE_CLAIMED)
    ///     gtk_gesture_set_sequence_state (second_gesture, sequence, GTK_EVENT_SEQUENCE_DENIED);
    /// }
    /// ```
    ///
    /// If both gestures are in the same group, just set the state on
    /// the gesture emitting the event, the sequence will be already
    /// be initialized to the group's global state when the second
    /// gesture processes the event.
    extern fn gtk_gesture_set_sequence_state(p_gesture: *Gesture, p_sequence: *gdk.EventSequence, p_state: gtk.EventSequenceState) c_int;
    pub const setSequenceState = gtk_gesture_set_sequence_state;

    /// Sets the state of all sequences that `gesture` is currently
    /// interacting with.
    ///
    /// Sequences start in state `GTK_EVENT_SEQUENCE_NONE`, and whenever
    /// they change state, they can never go back to that state. Likewise,
    /// sequences in state `GTK_EVENT_SEQUENCE_DENIED` cannot turn back to
    /// a not denied state. With these rules, the lifetime of an event
    /// sequence is constrained to the next four:
    ///
    /// * None
    /// * None → Denied
    /// * None → Claimed
    /// * None → Claimed → Denied
    ///
    /// Note: Due to event handling ordering, it may be unsafe to set the
    /// state on another gesture within a `gtk.Gesture.signals.begin` signal
    /// handler, as the callback might be executed before the other gesture
    /// knows about the sequence. A safe way to perform this could be:
    ///
    /// ```c
    /// static void
    /// first_gesture_begin_cb (GtkGesture       *first_gesture,
    ///                         GdkEventSequence *sequence,
    ///                         gpointer          user_data)
    /// {
    ///   gtk_gesture_set_state (first_gesture, GTK_EVENT_SEQUENCE_CLAIMED);
    ///   gtk_gesture_set_state (second_gesture, GTK_EVENT_SEQUENCE_DENIED);
    /// }
    ///
    /// static void
    /// second_gesture_begin_cb (GtkGesture       *second_gesture,
    ///                          GdkEventSequence *sequence,
    ///                          gpointer          user_data)
    /// {
    ///   if (gtk_gesture_get_sequence_state (first_gesture, sequence) == GTK_EVENT_SEQUENCE_CLAIMED)
    ///     gtk_gesture_set_state (second_gesture, GTK_EVENT_SEQUENCE_DENIED);
    /// }
    /// ```
    ///
    /// If both gestures are in the same group, just set the state on
    /// the gesture emitting the event, the sequence will be already
    /// be initialized to the group's global state when the second
    /// gesture processes the event.
    extern fn gtk_gesture_set_state(p_gesture: *Gesture, p_state: gtk.EventSequenceState) c_int;
    pub const setState = gtk_gesture_set_state;

    /// Separates `gesture` into an isolated group.
    extern fn gtk_gesture_ungroup(p_gesture: *Gesture) void;
    pub const ungroup = gtk_gesture_ungroup;

    extern fn gtk_gesture_get_type() usize;
    pub const getGObjectType = gtk_gesture_get_type;

    extern fn g_object_ref(p_self: *gtk.Gesture) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Gesture) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Gesture, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureClick` is a `GtkGesture` implementation for clicks.
///
/// It is able to recognize multiple clicks on a nearby zone, which
/// can be listened for through the `gtk.GestureClick.signals.pressed`
/// signal. Whenever time or distance between clicks exceed the GTK
/// defaults, `gtk.GestureClick.signals.stopped` is emitted, and the
/// click counter is reset.
pub const GestureClick = opaque {
    pub const Parent = gtk.GestureSingle;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureClickClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted whenever a button or touch press happens.
        pub const pressed = struct {
            pub const name = "pressed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_n_press: c_int, p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureClick, p_instance))),
                    gobject.signalLookup("pressed", GestureClick.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a button or touch is released.
        ///
        /// `n_press` will report the number of press that is paired to
        /// this event, note that `gtk.GestureClick.signals.stopped` may
        /// have been emitted between the press and its release, `n_press`
        /// will only start over at the next press.
        pub const released = struct {
            pub const name = "released";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_n_press: c_int, p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureClick, p_instance))),
                    gobject.signalLookup("released", GestureClick.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever any time/distance threshold has been exceeded.
        pub const stopped = struct {
            pub const name = "stopped";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureClick, p_instance))),
                    gobject.signalLookup("stopped", GestureClick.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever the gesture receives a release
        /// event that had no previous corresponding press.
        ///
        /// Due to implicit grabs, this can only happen on situations
        /// where input is grabbed elsewhere mid-press or the pressed
        /// widget voluntarily relinquishes its implicit grab.
        pub const unpaired_release = struct {
            pub const name = "unpaired-release";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, p_button: c_uint, p_sequence: ?*gdk.EventSequence, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureClick, p_instance))),
                    gobject.signalLookup("unpaired-release", GestureClick.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes
    /// single and multiple presses.
    extern fn gtk_gesture_click_new() *gtk.GestureClick;
    pub const new = gtk_gesture_click_new;

    extern fn gtk_gesture_click_get_type() usize;
    pub const getGObjectType = gtk_gesture_click_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureClick) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureClick) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureClick, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureDrag` is a `GtkGesture` implementation for drags.
///
/// The drag operation itself can be tracked throughout the
/// `gtk.GestureDrag.signals.drag_begin`,
/// `gtk.GestureDrag.signals.drag_update` and
/// `gtk.GestureDrag.signals.drag_end` signals, and the relevant
/// coordinates can be extracted through
/// `gtk.GestureDrag.getOffset` and
/// `gtk.GestureDrag.getStartPoint`.
pub const GestureDrag = opaque {
    pub const Parent = gtk.GestureSingle;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureDragClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted whenever dragging starts.
        pub const drag_begin = struct {
            pub const name = "drag-begin";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_start_x: f64, p_start_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureDrag, p_instance))),
                    gobject.signalLookup("drag-begin", GestureDrag.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever the dragging is finished.
        pub const drag_end = struct {
            pub const name = "drag-end";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_offset_x: f64, p_offset_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureDrag, p_instance))),
                    gobject.signalLookup("drag-end", GestureDrag.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever the dragging point moves.
        pub const drag_update = struct {
            pub const name = "drag-update";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_offset_x: f64, p_offset_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureDrag, p_instance))),
                    gobject.signalLookup("drag-update", GestureDrag.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes drags.
    extern fn gtk_gesture_drag_new() *gtk.GestureDrag;
    pub const new = gtk_gesture_drag_new;

    /// Gets the offset from the start point.
    ///
    /// If the `gesture` is active, this function returns `TRUE` and
    /// fills in `x` and `y` with the coordinates of the current point,
    /// as an offset to the starting drag point.
    extern fn gtk_gesture_drag_get_offset(p_gesture: *GestureDrag, p_x: ?*f64, p_y: ?*f64) c_int;
    pub const getOffset = gtk_gesture_drag_get_offset;

    /// Gets the point where the drag started.
    ///
    /// If the `gesture` is active, this function returns `TRUE`
    /// and fills in `x` and `y` with the drag start coordinates,
    /// in widget-relative coordinates.
    extern fn gtk_gesture_drag_get_start_point(p_gesture: *GestureDrag, p_x: ?*f64, p_y: ?*f64) c_int;
    pub const getStartPoint = gtk_gesture_drag_get_start_point;

    extern fn gtk_gesture_drag_get_type() usize;
    pub const getGObjectType = gtk_gesture_drag_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureDrag) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureDrag) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureDrag, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureLongPress` is a `GtkGesture` for long presses.
///
/// This gesture is also known as “Press and Hold”.
///
/// When the timeout is exceeded, the gesture is triggering the
/// `gtk.GestureLongPress.signals.pressed` signal.
///
/// If the touchpoint is lifted before the timeout passes, or if
/// it drifts too far of the initial press point, the
/// `gtk.GestureLongPress.signals.cancelled` signal will be emitted.
///
/// How long the timeout is before the ::pressed signal gets emitted is
/// determined by the `gtk.Settings.properties.gtk_long_press_time` setting.
/// It can be modified by the `gtk.GestureLongPress.properties.delay_factor`
/// property.
pub const GestureLongPress = opaque {
    pub const Parent = gtk.GestureSingle;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureLongPressClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Factor by which to modify the default timeout.
        pub const delay_factor = struct {
            pub const name = "delay-factor";

            pub const Type = f64;
        };
    };

    pub const signals = struct {
        /// Emitted whenever a press moved too far, or was released
        /// before `gtk.GestureLongPress.signals.pressed` happened.
        pub const cancelled = struct {
            pub const name = "cancelled";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureLongPress, p_instance))),
                    gobject.signalLookup("cancelled", GestureLongPress.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever a press goes unmoved/unreleased longer than
        /// what the GTK defaults tell.
        pub const pressed = struct {
            pub const name = "pressed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureLongPress, p_instance))),
                    gobject.signalLookup("pressed", GestureLongPress.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes long presses.
    extern fn gtk_gesture_long_press_new() *gtk.GestureLongPress;
    pub const new = gtk_gesture_long_press_new;

    /// Returns the delay factor.
    extern fn gtk_gesture_long_press_get_delay_factor(p_gesture: *GestureLongPress) f64;
    pub const getDelayFactor = gtk_gesture_long_press_get_delay_factor;

    /// Applies the given delay factor.
    ///
    /// The default long press time will be multiplied by this value.
    /// Valid values are in the range [0.5..2.0].
    extern fn gtk_gesture_long_press_set_delay_factor(p_gesture: *GestureLongPress, p_delay_factor: f64) void;
    pub const setDelayFactor = gtk_gesture_long_press_set_delay_factor;

    extern fn gtk_gesture_long_press_get_type() usize;
    pub const getGObjectType = gtk_gesture_long_press_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureLongPress) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureLongPress) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureLongPress, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGesturePan` is a `GtkGesture` for pan gestures.
///
/// These are drags that are locked to happen along one axis. The axis
/// that a `GtkGesturePan` handles is defined at construct time, and
/// can be changed through `gtk.GesturePan.setOrientation`.
///
/// When the gesture starts to be recognized, `GtkGesturePan` will
/// attempt to determine as early as possible whether the sequence
/// is moving in the expected direction, and denying the sequence if
/// this does not happen.
///
/// Once a panning gesture along the expected axis is recognized,
/// the `gtk.GesturePan.signals.pan` signal will be emitted as input
/// events are received, containing the offset in the given axis.
pub const GesturePan = opaque {
    pub const Parent = gtk.GestureDrag;
    pub const Implements = [_]type{};
    pub const Class = gtk.GesturePanClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The expected orientation of pan gestures.
        pub const orientation = struct {
            pub const name = "orientation";

            pub const Type = gtk.Orientation;
        };
    };

    pub const signals = struct {
        /// Emitted once a panning gesture along the expected axis is detected.
        pub const pan = struct {
            pub const name = "pan";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_direction: gtk.PanDirection, p_offset: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GesturePan, p_instance))),
                    gobject.signalLookup("pan", GesturePan.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes pan gestures.
    extern fn gtk_gesture_pan_new(p_orientation: gtk.Orientation) *gtk.GesturePan;
    pub const new = gtk_gesture_pan_new;

    /// Returns the orientation of the pan gestures that this `gesture` expects.
    extern fn gtk_gesture_pan_get_orientation(p_gesture: *GesturePan) gtk.Orientation;
    pub const getOrientation = gtk_gesture_pan_get_orientation;

    /// Sets the orientation to be expected on pan gestures.
    extern fn gtk_gesture_pan_set_orientation(p_gesture: *GesturePan, p_orientation: gtk.Orientation) void;
    pub const setOrientation = gtk_gesture_pan_set_orientation;

    extern fn gtk_gesture_pan_get_type() usize;
    pub const getGObjectType = gtk_gesture_pan_get_type;

    extern fn g_object_ref(p_self: *gtk.GesturePan) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GesturePan) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GesturePan, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureRotate` is a `GtkGesture` for 2-finger rotations.
///
/// Whenever the angle between both handled sequences changes, the
/// `gtk.GestureRotate.signals.angle_changed` signal is emitted.
pub const GestureRotate = opaque {
    pub const Parent = gtk.Gesture;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureRotateClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted when the angle between both tracked points changes.
        pub const angle_changed = struct {
            pub const name = "angle-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_angle: f64, p_angle_delta: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureRotate, p_instance))),
                    gobject.signalLookup("angle-changed", GestureRotate.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes 2-touch
    /// rotation gestures.
    extern fn gtk_gesture_rotate_new() *gtk.GestureRotate;
    pub const new = gtk_gesture_rotate_new;

    /// Gets the angle delta in radians.
    ///
    /// If `gesture` is active, this function returns the angle difference
    /// in radians since the gesture was first recognized. If `gesture` is
    /// not active, 0 is returned.
    extern fn gtk_gesture_rotate_get_angle_delta(p_gesture: *GestureRotate) f64;
    pub const getAngleDelta = gtk_gesture_rotate_get_angle_delta;

    extern fn gtk_gesture_rotate_get_type() usize;
    pub const getGObjectType = gtk_gesture_rotate_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureRotate) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureRotate) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureRotate, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureSingle` is a `GtkGestures` subclass optimized for singe-touch
/// and mouse gestures.
///
/// Under interaction, these gestures stick to the first interacting sequence,
/// which is accessible through `gtk.GestureSingle.getCurrentSequence`
/// while the gesture is being interacted with.
///
/// By default gestures react to both `GDK_BUTTON_PRIMARY` and touch events.
/// `gtk.GestureSingle.setTouchOnly` can be used to change the
/// touch behavior. Callers may also specify a different mouse button number
/// to interact with through `gtk.GestureSingle.setButton`, or react
/// to any mouse button by setting it to 0. While the gesture is active, the
/// button being currently pressed can be known through
/// `gtk.GestureSingle.getCurrentButton`.
pub const GestureSingle = opaque {
    pub const Parent = gtk.Gesture;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureSingleClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Mouse button number to listen to, or 0 to listen for any button.
        pub const button = struct {
            pub const name = "button";

            pub const Type = c_uint;
        };

        /// Whether the gesture is exclusive.
        ///
        /// Exclusive gestures only listen to pointer and pointer emulated events.
        pub const exclusive = struct {
            pub const name = "exclusive";

            pub const Type = c_int;
        };

        /// Whether the gesture handles only touch events.
        pub const touch_only = struct {
            pub const name = "touch-only";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Returns the button number `gesture` listens for.
    ///
    /// If this is 0, the gesture reacts to any button press.
    extern fn gtk_gesture_single_get_button(p_gesture: *GestureSingle) c_uint;
    pub const getButton = gtk_gesture_single_get_button;

    /// Returns the button number currently interacting
    /// with `gesture`, or 0 if there is none.
    extern fn gtk_gesture_single_get_current_button(p_gesture: *GestureSingle) c_uint;
    pub const getCurrentButton = gtk_gesture_single_get_current_button;

    /// Returns the event sequence currently interacting with `gesture`.
    ///
    /// This is only meaningful if `gtk.Gesture.isActive`
    /// returns `TRUE`.
    extern fn gtk_gesture_single_get_current_sequence(p_gesture: *GestureSingle) ?*gdk.EventSequence;
    pub const getCurrentSequence = gtk_gesture_single_get_current_sequence;

    /// Gets whether a gesture is exclusive.
    ///
    /// For more information, see `gtk.GestureSingle.setExclusive`.
    extern fn gtk_gesture_single_get_exclusive(p_gesture: *GestureSingle) c_int;
    pub const getExclusive = gtk_gesture_single_get_exclusive;

    /// Returns `TRUE` if the gesture is only triggered by touch events.
    extern fn gtk_gesture_single_get_touch_only(p_gesture: *GestureSingle) c_int;
    pub const getTouchOnly = gtk_gesture_single_get_touch_only;

    /// Sets the button number `gesture` listens to.
    ///
    /// If non-0, every button press from a different button
    /// number will be ignored. Touch events implicitly match
    /// with button 1.
    extern fn gtk_gesture_single_set_button(p_gesture: *GestureSingle, p_button: c_uint) void;
    pub const setButton = gtk_gesture_single_set_button;

    /// Sets whether `gesture` is exclusive.
    ///
    /// An exclusive gesture will only handle pointer and "pointer emulated"
    /// touch events, so at any given time, there is only one sequence able
    /// to interact with those.
    extern fn gtk_gesture_single_set_exclusive(p_gesture: *GestureSingle, p_exclusive: c_int) void;
    pub const setExclusive = gtk_gesture_single_set_exclusive;

    /// Sets whether to handle only touch events.
    ///
    /// If `touch_only` is `TRUE`, `gesture` will only handle events of type
    /// `GDK_TOUCH_BEGIN`, `GDK_TOUCH_UPDATE` or `GDK_TOUCH_END`. If `FALSE`,
    /// mouse events will be handled too.
    extern fn gtk_gesture_single_set_touch_only(p_gesture: *GestureSingle, p_touch_only: c_int) void;
    pub const setTouchOnly = gtk_gesture_single_set_touch_only;

    extern fn gtk_gesture_single_get_type() usize;
    pub const getGObjectType = gtk_gesture_single_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureSingle) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureSingle) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureSingle, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureStylus` is a `GtkGesture` specific to stylus input.
///
/// The provided signals just relay the basic information of the
/// stylus events.
pub const GestureStylus = opaque {
    pub const Parent = gtk.GestureSingle;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureStylusClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// If this gesture should exclusively react to stylus input devices.
        pub const stylus_only = struct {
            pub const name = "stylus-only";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Emitted when the stylus touches the device.
        pub const down = struct {
            pub const name = "down";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureStylus, p_instance))),
                    gobject.signalLookup("down", GestureStylus.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the stylus moves while touching the device.
        pub const motion = struct {
            pub const name = "motion";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureStylus, p_instance))),
                    gobject.signalLookup("motion", GestureStylus.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the stylus is in proximity of the device.
        pub const proximity = struct {
            pub const name = "proximity";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureStylus, p_instance))),
                    gobject.signalLookup("proximity", GestureStylus.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the stylus no longer touches the device.
        pub const up = struct {
            pub const name = "up";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureStylus, p_instance))),
                    gobject.signalLookup("up", GestureStylus.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkGestureStylus`.
    extern fn gtk_gesture_stylus_new() *gtk.GestureStylus;
    pub const new = gtk_gesture_stylus_new;

    /// Returns the current values for the requested `axes`.
    ///
    /// This function must be called from the handler of one of the
    /// `gtk.GestureStylus.signals.down`, `gtk.GestureStylus.signals.motion`,
    /// `gtk.GestureStylus.signals.up` or `gtk.GestureStylus.signals.proximity`
    /// signals.
    extern fn gtk_gesture_stylus_get_axes(p_gesture: *GestureStylus, p_axes: [*]gdk.AxisUse, p_values: [*]*f64) c_int;
    pub const getAxes = gtk_gesture_stylus_get_axes;

    /// Returns the current value for the requested `axis`.
    ///
    /// This function must be called from the handler of one of the
    /// `gtk.GestureStylus.signals.down`, `gtk.GestureStylus.signals.motion`,
    /// `gtk.GestureStylus.signals.up` or `gtk.GestureStylus.signals.proximity`
    /// signals.
    extern fn gtk_gesture_stylus_get_axis(p_gesture: *GestureStylus, p_axis: gdk.AxisUse, p_value: *f64) c_int;
    pub const getAxis = gtk_gesture_stylus_get_axis;

    /// Returns the accumulated backlog of tracking information.
    ///
    /// By default, GTK will limit rate of input events. On stylus input
    /// where accuracy of strokes is paramount, this function returns the
    /// accumulated coordinate/timing state before the emission of the
    /// current [Gtk.GestureStylus::motion] signal.
    ///
    /// This function may only be called within a `gtk.GestureStylus.signals.motion`
    /// signal handler, the state given in this signal and obtainable through
    /// `gtk.GestureStylus.getAxis` express the latest (most up-to-date)
    /// state in motion history.
    ///
    /// The `backlog` is provided in chronological order.
    extern fn gtk_gesture_stylus_get_backlog(p_gesture: *GestureStylus, p_backlog: [*]*gdk.TimeCoord, p_n_elems: *c_uint) c_int;
    pub const getBacklog = gtk_gesture_stylus_get_backlog;

    /// Returns the `GdkDeviceTool` currently driving input through this gesture.
    ///
    /// This function must be called from the handler of one of the
    /// `gtk.GestureStylus.signals.down`, `gtk.GestureStylus.signals.motion`,
    /// `gtk.GestureStylus.signals.up` or `gtk.GestureStylus.signals.proximity`
    /// signals.
    extern fn gtk_gesture_stylus_get_device_tool(p_gesture: *GestureStylus) ?*gdk.DeviceTool;
    pub const getDeviceTool = gtk_gesture_stylus_get_device_tool;

    /// Checks whether the gesture is for styluses only.
    ///
    /// Stylus-only gestures will signal events exclusively from stylus
    /// input devices.
    extern fn gtk_gesture_stylus_get_stylus_only(p_gesture: *GestureStylus) c_int;
    pub const getStylusOnly = gtk_gesture_stylus_get_stylus_only;

    /// Sets the state of stylus-only
    ///
    /// If true, the gesture will exclusively handle events from stylus input devices,
    /// otherwise it'll handle events from any pointing device.
    extern fn gtk_gesture_stylus_set_stylus_only(p_gesture: *GestureStylus, p_stylus_only: c_int) void;
    pub const setStylusOnly = gtk_gesture_stylus_set_stylus_only;

    extern fn gtk_gesture_stylus_get_type() usize;
    pub const getGObjectType = gtk_gesture_stylus_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureStylus) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureStylus) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureStylus, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureSwipe` is a `GtkGesture` for swipe gestures.
///
/// After a press/move/.../move/release sequence happens, the
/// `gtk.GestureSwipe.signals.swipe` signal will be emitted,
/// providing the velocity and directionality of the sequence
/// at the time it was lifted.
///
/// If the velocity is desired in intermediate points,
/// `gtk.GestureSwipe.getVelocity` can be called in a
/// `gtk.Gesture.signals.update` handler.
///
/// All velocities are reported in pixels/sec units.
pub const GestureSwipe = opaque {
    pub const Parent = gtk.GestureSingle;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureSwipeClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted when the recognized gesture is finished.
        ///
        /// Velocity and direction are a product of previously recorded events.
        pub const swipe = struct {
            pub const name = "swipe";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_velocity_x: f64, p_velocity_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureSwipe, p_instance))),
                    gobject.signalLookup("swipe", GestureSwipe.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes swipes.
    extern fn gtk_gesture_swipe_new() *gtk.GestureSwipe;
    pub const new = gtk_gesture_swipe_new;

    /// Gets the current velocity.
    ///
    /// If the gesture is recognized, this function returns `TRUE` and fills
    /// in `velocity_x` and `velocity_y` with the recorded velocity, as per the
    /// last events processed.
    extern fn gtk_gesture_swipe_get_velocity(p_gesture: *GestureSwipe, p_velocity_x: *f64, p_velocity_y: *f64) c_int;
    pub const getVelocity = gtk_gesture_swipe_get_velocity;

    extern fn gtk_gesture_swipe_get_type() usize;
    pub const getGObjectType = gtk_gesture_swipe_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureSwipe) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureSwipe) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureSwipe, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGestureZoom` is a `GtkGesture` for 2-finger pinch/zoom gestures.
///
/// Whenever the distance between both tracked sequences changes, the
/// `gtk.GestureZoom.signals.scale_changed` signal is emitted to report
/// the scale factor.
pub const GestureZoom = opaque {
    pub const Parent = gtk.Gesture;
    pub const Implements = [_]type{};
    pub const Class = gtk.GestureZoomClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted whenever the distance between both tracked sequences changes.
        pub const scale_changed = struct {
            pub const name = "scale-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_scale: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GestureZoom, p_instance))),
                    gobject.signalLookup("scale-changed", GestureZoom.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns a newly created `GtkGesture` that recognizes
    /// pinch/zoom gestures.
    extern fn gtk_gesture_zoom_new() *gtk.GestureZoom;
    pub const new = gtk_gesture_zoom_new;

    /// Gets the scale delta.
    ///
    /// If `gesture` is active, this function returns the zooming
    /// difference since the gesture was recognized (hence the
    /// starting point is considered 1:1). If `gesture` is not
    /// active, 1 is returned.
    extern fn gtk_gesture_zoom_get_scale_delta(p_gesture: *GestureZoom) f64;
    pub const getScaleDelta = gtk_gesture_zoom_get_scale_delta;

    extern fn gtk_gesture_zoom_get_type() usize;
    pub const getGObjectType = gtk_gesture_zoom_get_type;

    extern fn g_object_ref(p_self: *gtk.GestureZoom) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GestureZoom) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GestureZoom, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A widget that allows to bypass gsk rendering for its child by passing the content
/// directly to the compositor.
///
/// Graphics offload is an optimization to reduce overhead and battery use that is
/// most useful for video content. It only works on some platforms and in certain
/// situations. GTK will automatically fall back to normal rendering if it doesn't.
///
/// Graphics offload is most efficient if there are no controls drawn on top of the
/// video content.
///
/// You should consider using graphics offload for your main widget if it shows
/// frequently changing content (such as a video, or a VM display) and you provide
/// the content in the form of dmabuf textures (see `gdk.DmabufTextureBuilder`),
/// in particular if it may be fullscreen.
///
/// Numerous factors can prohibit graphics offload:
///
/// - Unsupported platforms. Currently, graphics offload only works on Linux with Wayland.
///
/// - Clipping, such as rounded corners that cause the video content to not be rectangular
///
/// - Unsupported dmabuf formats (see `gdk.Display.getDmabufFormats`)
///
/// - Translucent video content (content with an alpha channel, even if it isn't used)
///
/// - Transforms that are more complex than translations and scales
///
/// - Filters such as opacity, grayscale or similar
///
/// To investigate problems related graphics offload, GTK offers debug flags to print
/// out information about graphics offload and dmabuf use:
///
///     GDK_DEBUG=offload
///     GDK_DEBUG=dmabuf
///
/// The GTK inspector provides a visual debugging tool for graphics offload.
pub const GraphicsOffload = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = gtk.GraphicsOffloadClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether to draw a black background.
        pub const black_background = struct {
            pub const name = "black-background";

            pub const Type = c_int;
        };

        /// The child widget.
        pub const child = struct {
            pub const name = "child";

            pub const Type = ?*gtk.Widget;
        };

        /// Whether graphics offload is enabled.
        pub const enabled = struct {
            pub const name = "enabled";

            pub const Type = gtk.GraphicsOffloadEnabled;
        };
    };

    pub const signals = struct {};

    /// Creates a new GtkGraphicsOffload widget.
    extern fn gtk_graphics_offload_new(p_child: ?*gtk.Widget) *gtk.GraphicsOffload;
    pub const new = gtk_graphics_offload_new;

    /// Returns whether the widget draws a black background.
    ///
    /// See `gtk.GraphicsOffload.setBlackBackground`.
    extern fn gtk_graphics_offload_get_black_background(p_self: *GraphicsOffload) c_int;
    pub const getBlackBackground = gtk_graphics_offload_get_black_background;

    /// Gets the child of `self`.
    extern fn gtk_graphics_offload_get_child(p_self: *GraphicsOffload) ?*gtk.Widget;
    pub const getChild = gtk_graphics_offload_get_child;

    /// Returns whether offload is enabled for `self`.
    extern fn gtk_graphics_offload_get_enabled(p_self: *GraphicsOffload) gtk.GraphicsOffloadEnabled;
    pub const getEnabled = gtk_graphics_offload_get_enabled;

    /// Sets whether this GtkGraphicsOffload widget will draw a black
    /// background.
    ///
    /// A main use case for this is **_letterboxing_** where black bars are
    /// visible next to the content if the aspect ratio of the content does
    /// not match the dimensions of the monitor.
    ///
    /// Using this property for letterboxing instead of CSS allows compositors
    /// to show content with maximum efficiency, using direct scanout to avoid
    /// extra copies in the compositor.
    ///
    /// On Wayland, this is implemented using the
    /// [single-pixel buffer](https://wayland.app/protocols/single-pixel-buffer-v1)
    /// protocol.
    extern fn gtk_graphics_offload_set_black_background(p_self: *GraphicsOffload, p_value: c_int) void;
    pub const setBlackBackground = gtk_graphics_offload_set_black_background;

    /// Sets the child of `self`.
    extern fn gtk_graphics_offload_set_child(p_self: *GraphicsOffload, p_child: ?*gtk.Widget) void;
    pub const setChild = gtk_graphics_offload_set_child;

    /// Sets whether this GtkGraphicsOffload widget will attempt
    /// to offload the content of its child widget.
    extern fn gtk_graphics_offload_set_enabled(p_self: *GraphicsOffload, p_enabled: gtk.GraphicsOffloadEnabled) void;
    pub const setEnabled = gtk_graphics_offload_set_enabled;

    extern fn gtk_graphics_offload_get_type() usize;
    pub const getGObjectType = gtk_graphics_offload_get_type;

    extern fn g_object_ref(p_self: *gtk.GraphicsOffload) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GraphicsOffload) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GraphicsOffload, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGrid` is a container which arranges its child widgets in
/// rows and columns.
///
/// ![An example GtkGrid](grid.png)
///
/// It supports arbitrary positions and horizontal/vertical spans.
///
/// Children are added using `gtk.Grid.attach`. They can span multiple
/// rows or columns. It is also possible to add a child next to an existing
/// child, using `gtk.Grid.attachNextTo`. To remove a child from the
/// grid, use `gtk.Grid.remove`.
///
/// The behaviour of `GtkGrid` when several children occupy the same grid
/// cell is undefined.
///
/// # GtkGrid as GtkBuildable
///
/// Every child in a `GtkGrid` has access to a custom `gtk.Buildable`
/// element, called `<layout>`. It can by used to specify a position in the
/// grid and optionally spans. All properties that can be used in the `<layout>`
/// element are implemented by `gtk.GridLayoutChild`.
///
/// It is implemented by `GtkWidget` using `gtk.LayoutManager`.
///
/// To showcase it, here is a simple example:
///
/// ```xml
/// <object class="GtkGrid" id="my_grid">
///   <child>
///     <object class="GtkButton" id="button1">
///       <property name="label">Button 1</property>
///       <layout>
///         <property name="column">0</property>
///         <property name="row">0</property>
///       </layout>
///     </object>
///   </child>
///   <child>
///     <object class="GtkButton" id="button2">
///       <property name="label">Button 2</property>
///       <layout>
///         <property name="column">1</property>
///         <property name="row">0</property>
///       </layout>
///     </object>
///   </child>
///   <child>
///     <object class="GtkButton" id="button3">
///       <property name="label">Button 3</property>
///       <layout>
///         <property name="column">2</property>
///         <property name="row">0</property>
///         <property name="row-span">2</property>
///       </layout>
///     </object>
///   </child>
///   <child>
///     <object class="GtkButton" id="button4">
///       <property name="label">Button 4</property>
///       <layout>
///         <property name="column">0</property>
///         <property name="row">1</property>
///         <property name="column-span">2</property>
///       </layout>
///     </object>
///   </child>
/// </object>
/// ```
///
/// It organizes the first two buttons side-by-side in one cell each.
/// The third button is in the last column but spans across two rows.
/// This is defined by the `row-span` property. The last button is
/// located in the second row and spans across two columns, which is
/// defined by the `column-span` property.
///
/// # CSS nodes
///
/// `GtkGrid` uses a single CSS node with name `grid`.
///
/// # Accessibility
///
/// Until GTK 4.10, `GtkGrid` used the `GTK_ACCESSIBLE_ROLE_GROUP` role.
///
/// Starting from GTK 4.12, `GtkGrid` uses the `GTK_ACCESSIBLE_ROLE_GENERIC` role.
pub const Grid = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Orientable };
    pub const Class = gtk.GridClass;
    f_parent_instance: gtk.Widget,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The row to align to the baseline when valign is using baseline alignment.
        pub const baseline_row = struct {
            pub const name = "baseline-row";

            pub const Type = c_int;
        };

        /// If `TRUE`, the columns are all the same width.
        pub const column_homogeneous = struct {
            pub const name = "column-homogeneous";

            pub const Type = c_int;
        };

        /// The amount of space between two consecutive columns.
        pub const column_spacing = struct {
            pub const name = "column-spacing";

            pub const Type = c_int;
        };

        /// If `TRUE`, the rows are all the same height.
        pub const row_homogeneous = struct {
            pub const name = "row-homogeneous";

            pub const Type = c_int;
        };

        /// The amount of space between two consecutive rows.
        pub const row_spacing = struct {
            pub const name = "row-spacing";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new grid widget.
    extern fn gtk_grid_new() *gtk.Grid;
    pub const new = gtk_grid_new;

    /// Adds a widget to the grid.
    ///
    /// The position of `child` is determined by `column` and `row`.
    /// The number of “cells” that `child` will occupy is determined
    /// by `width` and `height`.
    extern fn gtk_grid_attach(p_grid: *Grid, p_child: *gtk.Widget, p_column: c_int, p_row: c_int, p_width: c_int, p_height: c_int) void;
    pub const attach = gtk_grid_attach;

    /// Adds a widget to the grid.
    ///
    /// The widget is placed next to `sibling`, on the side determined by
    /// `side`. When `sibling` is `NULL`, the widget is placed in row (for
    /// left or right placement) or column 0 (for top or bottom placement),
    /// at the end indicated by `side`.
    ///
    /// Attaching widgets labeled `[1]`, `[2]`, `[3]` with ``sibling` == `NULL`` and
    /// ``side` == `GTK_POS_LEFT`` yields a layout of `[3][2][1]`.
    extern fn gtk_grid_attach_next_to(p_grid: *Grid, p_child: *gtk.Widget, p_sibling: ?*gtk.Widget, p_side: gtk.PositionType, p_width: c_int, p_height: c_int) void;
    pub const attachNextTo = gtk_grid_attach_next_to;

    /// Returns which row defines the global baseline of `grid`.
    extern fn gtk_grid_get_baseline_row(p_grid: *Grid) c_int;
    pub const getBaselineRow = gtk_grid_get_baseline_row;

    /// Gets the child of `grid` whose area covers the grid
    /// cell at `column`, `row`.
    extern fn gtk_grid_get_child_at(p_grid: *Grid, p_column: c_int, p_row: c_int) ?*gtk.Widget;
    pub const getChildAt = gtk_grid_get_child_at;

    /// Returns whether all columns of `grid` have the same width.
    extern fn gtk_grid_get_column_homogeneous(p_grid: *Grid) c_int;
    pub const getColumnHomogeneous = gtk_grid_get_column_homogeneous;

    /// Returns the amount of space between the columns of `grid`.
    extern fn gtk_grid_get_column_spacing(p_grid: *Grid) c_uint;
    pub const getColumnSpacing = gtk_grid_get_column_spacing;

    /// Returns the baseline position of `row`.
    ///
    /// See `gtk.Grid.setRowBaselinePosition`.
    extern fn gtk_grid_get_row_baseline_position(p_grid: *Grid, p_row: c_int) gtk.BaselinePosition;
    pub const getRowBaselinePosition = gtk_grid_get_row_baseline_position;

    /// Returns whether all rows of `grid` have the same height.
    extern fn gtk_grid_get_row_homogeneous(p_grid: *Grid) c_int;
    pub const getRowHomogeneous = gtk_grid_get_row_homogeneous;

    /// Returns the amount of space between the rows of `grid`.
    extern fn gtk_grid_get_row_spacing(p_grid: *Grid) c_uint;
    pub const getRowSpacing = gtk_grid_get_row_spacing;

    /// Inserts a column at the specified position.
    ///
    /// Children which are attached at or to the right of this position
    /// are moved one column to the right. Children which span across this
    /// position are grown to span the new column.
    extern fn gtk_grid_insert_column(p_grid: *Grid, p_position: c_int) void;
    pub const insertColumn = gtk_grid_insert_column;

    /// Inserts a row or column at the specified position.
    ///
    /// The new row or column is placed next to `sibling`, on the side
    /// determined by `side`. If `side` is `GTK_POS_TOP` or `GTK_POS_BOTTOM`,
    /// a row is inserted. If `side` is `GTK_POS_LEFT` of `GTK_POS_RIGHT`,
    /// a column is inserted.
    extern fn gtk_grid_insert_next_to(p_grid: *Grid, p_sibling: *gtk.Widget, p_side: gtk.PositionType) void;
    pub const insertNextTo = gtk_grid_insert_next_to;

    /// Inserts a row at the specified position.
    ///
    /// Children which are attached at or below this position
    /// are moved one row down. Children which span across this
    /// position are grown to span the new row.
    extern fn gtk_grid_insert_row(p_grid: *Grid, p_position: c_int) void;
    pub const insertRow = gtk_grid_insert_row;

    /// Queries the attach points and spans of `child` inside the given `GtkGrid`.
    extern fn gtk_grid_query_child(p_grid: *Grid, p_child: *gtk.Widget, p_column: ?*c_int, p_row: ?*c_int, p_width: ?*c_int, p_height: ?*c_int) void;
    pub const queryChild = gtk_grid_query_child;

    /// Removes a child from `grid`.
    ///
    /// The child must have been added with
    /// `gtk.Grid.attach` or `gtk.Grid.attachNextTo`.
    extern fn gtk_grid_remove(p_grid: *Grid, p_child: *gtk.Widget) void;
    pub const remove = gtk_grid_remove;

    /// Removes a column from the grid.
    ///
    /// Children that are placed in this column are removed,
    /// spanning children that overlap this column have their
    /// width reduced by one, and children after the column
    /// are moved to the left.
    extern fn gtk_grid_remove_column(p_grid: *Grid, p_position: c_int) void;
    pub const removeColumn = gtk_grid_remove_column;

    /// Removes a row from the grid.
    ///
    /// Children that are placed in this row are removed,
    /// spanning children that overlap this row have their
    /// height reduced by one, and children below the row
    /// are moved up.
    extern fn gtk_grid_remove_row(p_grid: *Grid, p_position: c_int) void;
    pub const removeRow = gtk_grid_remove_row;

    /// Sets which row defines the global baseline for the entire grid.
    ///
    /// Each row in the grid can have its own local baseline, but only
    /// one of those is global, meaning it will be the baseline in the
    /// parent of the `grid`.
    extern fn gtk_grid_set_baseline_row(p_grid: *Grid, p_row: c_int) void;
    pub const setBaselineRow = gtk_grid_set_baseline_row;

    /// Sets whether all columns of `grid` will have the same width.
    extern fn gtk_grid_set_column_homogeneous(p_grid: *Grid, p_homogeneous: c_int) void;
    pub const setColumnHomogeneous = gtk_grid_set_column_homogeneous;

    /// Sets the amount of space between columns of `grid`.
    extern fn gtk_grid_set_column_spacing(p_grid: *Grid, p_spacing: c_uint) void;
    pub const setColumnSpacing = gtk_grid_set_column_spacing;

    /// Sets how the baseline should be positioned on `row` of the
    /// grid, in case that row is assigned more space than is requested.
    ///
    /// The default baseline position is `GTK_BASELINE_POSITION_CENTER`.
    extern fn gtk_grid_set_row_baseline_position(p_grid: *Grid, p_row: c_int, p_pos: gtk.BaselinePosition) void;
    pub const setRowBaselinePosition = gtk_grid_set_row_baseline_position;

    /// Sets whether all rows of `grid` will have the same height.
    extern fn gtk_grid_set_row_homogeneous(p_grid: *Grid, p_homogeneous: c_int) void;
    pub const setRowHomogeneous = gtk_grid_set_row_homogeneous;

    /// Sets the amount of space between rows of `grid`.
    extern fn gtk_grid_set_row_spacing(p_grid: *Grid, p_spacing: c_uint) void;
    pub const setRowSpacing = gtk_grid_set_row_spacing;

    extern fn gtk_grid_get_type() usize;
    pub const getGObjectType = gtk_grid_get_type;

    extern fn g_object_ref(p_self: *gtk.Grid) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.Grid) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Grid, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGridLayout` is a layout manager which arranges child widgets in
/// rows and columns.
///
/// Children have an "attach point" defined by the horizontal and vertical
/// index of the cell they occupy; children can span multiple rows or columns.
/// The layout properties for setting the attach points and spans are set
/// using the `gtk.GridLayoutChild` associated to each child widget.
///
/// The behaviour of `GtkGridLayout` when several children occupy the same
/// grid cell is undefined.
///
/// `GtkGridLayout` can be used like a `GtkBoxLayout` if all children are
/// attached to the same row or column; however, if you only ever need a
/// single row or column, you should consider using `GtkBoxLayout`.
pub const GridLayout = opaque {
    pub const Parent = gtk.LayoutManager;
    pub const Implements = [_]type{};
    pub const Class = gtk.GridLayoutClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The row to align to the baseline, when `GtkWidget:valign` is set
        /// to `GTK_ALIGN_BASELINE`.
        pub const baseline_row = struct {
            pub const name = "baseline-row";

            pub const Type = c_int;
        };

        /// Whether all the columns in the grid have the same width.
        pub const column_homogeneous = struct {
            pub const name = "column-homogeneous";

            pub const Type = c_int;
        };

        /// The amount of space between to consecutive columns.
        pub const column_spacing = struct {
            pub const name = "column-spacing";

            pub const Type = c_int;
        };

        /// Whether all the rows in the grid have the same height.
        pub const row_homogeneous = struct {
            pub const name = "row-homogeneous";

            pub const Type = c_int;
        };

        /// The amount of space between to consecutive rows.
        pub const row_spacing = struct {
            pub const name = "row-spacing";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkGridLayout`.
    extern fn gtk_grid_layout_new() *gtk.GridLayout;
    pub const new = gtk_grid_layout_new;

    /// Retrieves the row set with `gtk.GridLayout.setBaselineRow`.
    extern fn gtk_grid_layout_get_baseline_row(p_grid: *GridLayout) c_int;
    pub const getBaselineRow = gtk_grid_layout_get_baseline_row;

    /// Checks whether all columns of `grid` should have the same width.
    extern fn gtk_grid_layout_get_column_homogeneous(p_grid: *GridLayout) c_int;
    pub const getColumnHomogeneous = gtk_grid_layout_get_column_homogeneous;

    /// Retrieves the spacing set with `gtk.GridLayout.setColumnSpacing`.
    extern fn gtk_grid_layout_get_column_spacing(p_grid: *GridLayout) c_uint;
    pub const getColumnSpacing = gtk_grid_layout_get_column_spacing;

    /// Returns the baseline position of `row`.
    ///
    /// If no value has been set with
    /// `gtk.GridLayout.setRowBaselinePosition`,
    /// the default value of `GTK_BASELINE_POSITION_CENTER`
    /// is returned.
    extern fn gtk_grid_layout_get_row_baseline_position(p_grid: *GridLayout, p_row: c_int) gtk.BaselinePosition;
    pub const getRowBaselinePosition = gtk_grid_layout_get_row_baseline_position;

    /// Checks whether all rows of `grid` should have the same height.
    extern fn gtk_grid_layout_get_row_homogeneous(p_grid: *GridLayout) c_int;
    pub const getRowHomogeneous = gtk_grid_layout_get_row_homogeneous;

    /// Retrieves the spacing set with `gtk.GridLayout.setRowSpacing`.
    extern fn gtk_grid_layout_get_row_spacing(p_grid: *GridLayout) c_uint;
    pub const getRowSpacing = gtk_grid_layout_get_row_spacing;

    /// Sets which row defines the global baseline for the entire grid.
    ///
    /// Each row in the grid can have its own local baseline, but only
    /// one of those is global, meaning it will be the baseline in the
    /// parent of the `grid`.
    extern fn gtk_grid_layout_set_baseline_row(p_grid: *GridLayout, p_row: c_int) void;
    pub const setBaselineRow = gtk_grid_layout_set_baseline_row;

    /// Sets whether all columns of `grid` should have the same width.
    extern fn gtk_grid_layout_set_column_homogeneous(p_grid: *GridLayout, p_homogeneous: c_int) void;
    pub const setColumnHomogeneous = gtk_grid_layout_set_column_homogeneous;

    /// Sets the amount of space to insert between consecutive columns.
    extern fn gtk_grid_layout_set_column_spacing(p_grid: *GridLayout, p_spacing: c_uint) void;
    pub const setColumnSpacing = gtk_grid_layout_set_column_spacing;

    /// Sets how the baseline should be positioned on `row` of the
    /// grid, in case that row is assigned more space than is requested.
    extern fn gtk_grid_layout_set_row_baseline_position(p_grid: *GridLayout, p_row: c_int, p_pos: gtk.BaselinePosition) void;
    pub const setRowBaselinePosition = gtk_grid_layout_set_row_baseline_position;

    /// Sets whether all rows of `grid` should have the same height.
    extern fn gtk_grid_layout_set_row_homogeneous(p_grid: *GridLayout, p_homogeneous: c_int) void;
    pub const setRowHomogeneous = gtk_grid_layout_set_row_homogeneous;

    /// Sets the amount of space to insert between consecutive rows.
    extern fn gtk_grid_layout_set_row_spacing(p_grid: *GridLayout, p_spacing: c_uint) void;
    pub const setRowSpacing = gtk_grid_layout_set_row_spacing;

    extern fn gtk_grid_layout_get_type() usize;
    pub const getGObjectType = gtk_grid_layout_get_type;

    extern fn g_object_ref(p_self: *gtk.GridLayout) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GridLayout) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GridLayout, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkLayoutChild` subclass for children in a `GtkGridLayout`.
pub const GridLayoutChild = opaque {
    pub const Parent = gtk.LayoutChild;
    pub const Implements = [_]type{};
    pub const Class = gtk.GridLayoutChildClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The column to place the child in.
        pub const column = struct {
            pub const name = "column";

            pub const Type = c_int;
        };

        /// The number of columns the child spans to.
        pub const column_span = struct {
            pub const name = "column-span";

            pub const Type = c_int;
        };

        /// The row to place the child in.
        pub const row = struct {
            pub const name = "row";

            pub const Type = c_int;
        };

        /// The number of rows the child spans to.
        pub const row_span = struct {
            pub const name = "row-span";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Retrieves the column number to which `child` attaches its left side.
    extern fn gtk_grid_layout_child_get_column(p_child: *GridLayoutChild) c_int;
    pub const getColumn = gtk_grid_layout_child_get_column;

    /// Retrieves the number of columns that `child` spans to.
    extern fn gtk_grid_layout_child_get_column_span(p_child: *GridLayoutChild) c_int;
    pub const getColumnSpan = gtk_grid_layout_child_get_column_span;

    /// Retrieves the row number to which `child` attaches its top side.
    extern fn gtk_grid_layout_child_get_row(p_child: *GridLayoutChild) c_int;
    pub const getRow = gtk_grid_layout_child_get_row;

    /// Retrieves the number of rows that `child` spans to.
    extern fn gtk_grid_layout_child_get_row_span(p_child: *GridLayoutChild) c_int;
    pub const getRowSpan = gtk_grid_layout_child_get_row_span;

    /// Sets the column number to attach the left side of `child`.
    extern fn gtk_grid_layout_child_set_column(p_child: *GridLayoutChild, p_column: c_int) void;
    pub const setColumn = gtk_grid_layout_child_set_column;

    /// Sets the number of columns `child` spans to.
    extern fn gtk_grid_layout_child_set_column_span(p_child: *GridLayoutChild, p_span: c_int) void;
    pub const setColumnSpan = gtk_grid_layout_child_set_column_span;

    /// Sets the row to place `child` in.
    extern fn gtk_grid_layout_child_set_row(p_child: *GridLayoutChild, p_row: c_int) void;
    pub const setRow = gtk_grid_layout_child_set_row;

    /// Sets the number of rows `child` spans to.
    extern fn gtk_grid_layout_child_set_row_span(p_child: *GridLayoutChild, p_span: c_int) void;
    pub const setRowSpan = gtk_grid_layout_child_set_row_span;

    extern fn gtk_grid_layout_child_get_type() usize;
    pub const getGObjectType = gtk_grid_layout_child_get_type;

    extern fn g_object_ref(p_self: *gtk.GridLayoutChild) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GridLayoutChild) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GridLayoutChild, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkGridView` presents a large dynamic grid of items.
///
/// `GtkGridView` uses its factory to generate one child widget for each
/// visible item and shows them in a grid. The orientation of the grid view
/// determines if the grid reflows vertically or horizontally.
///
/// `GtkGridView` allows the user to select items according to the selection
/// characteristics of the model. For models that allow multiple selected items,
/// it is possible to turn on _rubberband selection_, using
/// `gtk.GridView.properties.enable_rubberband`.
///
/// To learn more about the list widget framework, see the
/// [overview](section-list-widget.html).
///
/// # Actions
///
/// `GtkGridView` defines a set of built-in actions:
///
/// - `list.activate-item` activates the item at given position by emitting the
///   the `gtk.GridView.signals.activate` signal.
///
/// # CSS nodes
///
/// ```
/// gridview
/// ├── child[.activatable]
/// │
/// ├── child[.activatable]
/// │
/// ┊
/// ╰── [rubberband]
/// ```
///
/// `GtkGridView` uses a single CSS node with name `gridview`. Each child uses
/// a single CSS node with name `child`. If the `gtk.ListItem.properties.activatable`
/// property is set, the corresponding row will have the `.activatable` style
/// class. For rubberband selection, a subnode with name `rubberband` is used.
///
/// # Accessibility
///
/// `GtkGridView` uses the `GTK_ACCESSIBLE_ROLE_GRID` role, and the items
/// use the `GTK_ACCESSIBLE_ROLE_GRID_CELL` role.
pub const GridView = opaque {
    pub const Parent = gtk.ListBase;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget, gtk.Orientable, gtk.Scrollable };
    pub const Class = gtk.GridViewClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Allow rubberband selection.
        pub const enable_rubberband = struct {
            pub const name = "enable-rubberband";

            pub const Type = c_int;
        };

        /// Factory for populating list items.
        ///
        /// The factory must be for configuring `gtk.ListItem` objects.
        pub const factory = struct {
            pub const name = "factory";

            pub const Type = ?*gtk.ListItemFactory;
        };

        /// Maximum number of columns per row.
        ///
        /// If this number is smaller than `gtk.GridView.properties.min_columns`,
        /// that value is used instead.
        pub const max_columns = struct {
            pub const name = "max-columns";

            pub const Type = c_uint;
        };

        /// Minimum number of columns per row.
        pub const min_columns = struct {
            pub const name = "min-columns";

            pub const Type = c_uint;
        };

        /// Model for the items displayed.
        pub const model = struct {
            pub const name = "model";

            pub const Type = ?*gtk.SelectionModel;
        };

        /// Activate rows on single click and select them on hover.
        pub const single_click_activate = struct {
            pub const name = "single-click-activate";

            pub const Type = c_int;
        };

        /// Behavior of the <kbd>Tab</kbd> key
        pub const tab_behavior = struct {
            pub const name = "tab-behavior";

            pub const Type = gtk.ListTabBehavior;
        };
    };

    pub const signals = struct {
        /// Emitted when a cell has been activated by the user,
        /// usually via activating the GtkGridView|list.activate-item action.
        ///
        /// This allows for a convenient way to handle activation in a gridview.
        /// See `gtk.ListItem.properties.activatable` for details on how to use
        /// this signal.
        pub const activate = struct {
            pub const name = "activate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_position: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GridView, p_instance))),
                    gobject.signalLookup("activate", GridView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `GtkGridView` that uses the given `factory` for
    /// mapping items to widgets.
    ///
    /// The function takes ownership of the
    /// arguments, so you can write code like
    /// ```c
    /// grid_view = gtk_grid_view_new (create_model (),
    ///   gtk_builder_list_item_factory_new_from_resource ("/resource.ui"));
    /// ```
    extern fn gtk_grid_view_new(p_model: ?*gtk.SelectionModel, p_factory: ?*gtk.ListItemFactory) *gtk.GridView;
    pub const new = gtk_grid_view_new;

    /// Returns whether rows can be selected by dragging with the mouse.
    extern fn gtk_grid_view_get_enable_rubberband(p_self: *GridView) c_int;
    pub const getEnableRubberband = gtk_grid_view_get_enable_rubberband;

    /// Gets the factory that's currently used to populate list items.
    extern fn gtk_grid_view_get_factory(p_self: *GridView) ?*gtk.ListItemFactory;
    pub const getFactory = gtk_grid_view_get_factory;

    /// Gets the maximum number of columns that the grid will use.
    extern fn gtk_grid_view_get_max_columns(p_self: *GridView) c_uint;
    pub const getMaxColumns = gtk_grid_view_get_max_columns;

    /// Gets the minimum number of columns that the grid will use.
    extern fn gtk_grid_view_get_min_columns(p_self: *GridView) c_uint;
    pub const getMinColumns = gtk_grid_view_get_min_columns;

    /// Gets the model that's currently used to read the items displayed.
    extern fn gtk_grid_view_get_model(p_self: *GridView) ?*gtk.SelectionModel;
    pub const getModel = gtk_grid_view_get_model;

    /// Returns whether items will be activated on single click and
    /// selected on hover.
    extern fn gtk_grid_view_get_single_click_activate(p_self: *GridView) c_int;
    pub const getSingleClickActivate = gtk_grid_view_get_single_click_activate;

    /// Gets the behavior set for the <kbd>Tab</kbd> key.
    extern fn gtk_grid_view_get_tab_behavior(p_self: *GridView) gtk.ListTabBehavior;
    pub const getTabBehavior = gtk_grid_view_get_tab_behavior;

    /// Scrolls to the item at the given position and performs the actions
    /// specified in `flags`.
    ///
    /// This function works no matter if the gridview is shown or focused.
    /// If it isn't, then the changes will take effect once that happens.
    extern fn gtk_grid_view_scroll_to(p_self: *GridView, p_pos: c_uint, p_flags: gtk.ListScrollFlags, p_scroll: ?*gtk.ScrollInfo) void;
    pub const scrollTo = gtk_grid_view_scroll_to;

    /// Sets whether selections can be changed by dragging with the mouse.
    extern fn gtk_grid_view_set_enable_rubberband(p_self: *GridView, p_enable_rubberband: c_int) void;
    pub const setEnableRubberband = gtk_grid_view_set_enable_rubberband;

    /// Sets the `GtkListItemFactory` to use for populating list items.
    extern fn gtk_grid_view_set_factory(p_self: *GridView, p_factory: ?*gtk.ListItemFactory) void;
    pub const setFactory = gtk_grid_view_set_factory;

    /// Sets the maximum number of columns to use.
    ///
    /// This number must be at least 1.
    ///
    /// If `max_columns` is smaller than the minimum set via
    /// `gtk.GridView.setMinColumns`, that value is used instead.
    extern fn gtk_grid_view_set_max_columns(p_self: *GridView, p_max_columns: c_uint) void;
    pub const setMaxColumns = gtk_grid_view_set_max_columns;

    /// Sets the minimum number of columns to use.
    ///
    /// This number must be at least 1.
    ///
    /// If `min_columns` is smaller than the minimum set via
    /// `gtk.GridView.setMaxColumns`, that value is ignored.
    extern fn gtk_grid_view_set_min_columns(p_self: *GridView, p_min_columns: c_uint) void;
    pub const setMinColumns = gtk_grid_view_set_min_columns;

    /// Sets the model to use.
    ///
    /// This must be a `gtk.SelectionModel`.
    extern fn gtk_grid_view_set_model(p_self: *GridView, p_model: ?*gtk.SelectionModel) void;
    pub const setModel = gtk_grid_view_set_model;

    /// Sets whether items should be activated on single click and
    /// selected on hover.
    extern fn gtk_grid_view_set_single_click_activate(p_self: *GridView, p_single_click_activate: c_int) void;
    pub const setSingleClickActivate = gtk_grid_view_set_single_click_activate;

    /// Sets the behavior of the <kbd>Tab</kbd> and <kbd>Shift</kbd>+<kbd>Tab</kbd> keys.
    extern fn gtk_grid_view_set_tab_behavior(p_self: *GridView, p_tab_behavior: gtk.ListTabBehavior) void;
    pub const setTabBehavior = gtk_grid_view_set_tab_behavior;

    extern fn gtk_grid_view_get_type() usize;
    pub const getGObjectType = gtk_grid_view_get_type;

    extern fn g_object_ref(p_self: *gtk.GridView) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gtk.GridView) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GridView, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `GtkHeaderBar` is a widget for creating custom title bars for windows.
///
/// ![An example GtkHeaderBar](headerbar.png)
///
/// `GtkHeaderBar` is similar to a horizontal `GtkCenterBox`. It allows
/// children to be placed at the start or the end. In addition, it allows
/// the window title to be displayed. The title will be centered with respect
/// to the width of the box, even if the children at either side take up
/// different amounts of space.
///
/// `GtkHeaderBar` can add typical window frame controls, such as minimize,
/// maximize and close buttons, or the window icon.
///
/// For these reasons, `GtkHeaderBar` is the natural choice for use as the
/// custom titlebar widget of a `GtkWindow` (see `gtk.Window.setTitlebar`),
/// as it gives features typical of titlebars while allowing the addition of
/// child widgets.
///
/// ## GtkHeaderBar as GtkBuildable
///
/// The `GtkHeaderBar` implementation of the `GtkBuildable` interface supports
/// adding children at the start or end sides by specifying “start” or “end” as
/// the “type” attribute of a `<child>` element, or setting the title widget by
/// specifying “title” value.
///
/// By default the `GtkHeaderBar` uses a `GtkLabel` displaying the title of the
/// window it is contained in as the title widget, equivalent to the following
/// UI definition:
///
/// ```xml
/// <object class="GtkHeaderBar">
///   <property name="title-widget">
///     <object class="GtkLabel">
///       <property name="label" translatable="yes">Label</property>
///       <property name="single-line-mode">True</property>
///       <property name="ellipsize">end</property>
///       <property name="width-chars">5</property>
///       <style>
///         <class name="title"/>
///       </style>
///     </object>
///   </property>
/// </object>
/// ```
///
/// # CSS nodes
///
/// ```
/// headerbar
/// ╰── windowhandle
///     ╰── box
///         ├── box.start
///         │   ├── windowcontrols.start
///         │   ╰── [other children]
///         ├── [Title Widget]
///         ╰── box.end
///             ├── [other children]
///             ╰── windowcontrols.end
/// ```
///
/// A `GtkHeaderBar`'s CSS node is called `headerbar`. It contains a `windowhandle`
/// subnode, which contains a `box` subnode, which contains two `box` subnodes at
/// the start and end of the header bar, as well as a center node that represents
/// the title.
///
/// Each of the boxes contains a `windowcontrols` subnode, see
/// `gtk.WindowControls` for details, as well as other children.
///
/// # Accessibility
///
/// `GtkHeaderBar` uses the `GTK_ACCESSIBLE_ROLE_GROUP` role.
pub const HeaderBar = opaque {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = opaque {
        pub const Instance = HeaderBar;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The decoration layout for buttons.
        ///
        /// If this property is not set, the
        /// `gtk.Settings.properties.gtk_decoration_layout` setting is used.
        pub const decoration_layout = struct {
            pub const name = "decoration-layout";

            pub const Type = ?[*:0]u8;
        };

        /// Whether to show title buttons like close, minimize, maximize.
        ///
        /// Which buttons are actually shown and where is determined
        /// by the `gtk.HeaderBar.properties.decoration_layout` property,
        /// and by the state of the window (e.g. a close button will not
        /// be shown if the window can't be closed).
        pub const show_title_buttons = struct {
            pub const name = "show-title-buttons";

            pub const Type = c_int;
        };

        /// The title widget to display.
        pub const title_widget = struct {
            pub const name = "title-widget";

            pub const Type = ?*gtk.Widget;
        };
    };

    pub const signals = struct {};

    /// Creates a new `GtkHeaderBar` widget.
    extern fn gtk_header_bar_new() *gtk.HeaderBar;
    pub const new = gtk_header_bar_new;

    /// Gets the decoration layout of the `GtkHeaderBar`.
    extern fn gtk_header_bar_get_decoration_layout(p_bar: *HeaderBar) ?[*:0]const u8;
    pub const getDecorationLayout = gtk_header_bar_get_decoration_layout;

    /// Returns whether this header bar shows the standard window
    /// title buttons.
    extern fn gtk_header_bar_get_show_title_buttons(p_bar: *HeaderBar) c_int;
    pub const getShowTitleButtons = gtk_header_bar_get_show_title_buttons;

    /// Retrieves the title widget of the header.
    ///
    /// See `gtk.HeaderBar.setTitleWidget`.
    extern fn gt