#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2634
#define LARGE_STATE_COUNT 431
#define SYMBOL_COUNT 322
#define ALIAS_COUNT 16
#define TOKEN_COUNT 145
#define EXTERNAL_TOKEN_COUNT 83
#define FIELD_COUNT 21
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 60

enum ts_symbol_identifiers {
  anon_sym_LBRACK = 1,
  anon_sym_x = 2,
  anon_sym_X = 3,
  anon_sym_RBRACK = 4,
  anon_sym_SPACE = 5,
  aux_sym__table_cell_alignment_token1 = 6,
  anon_sym_NULL = 7,
  anon_sym_RBRACK_COLON = 8,
  anon_sym_EQ = 9,
  sym_language = 10,
  aux_sym__line_token1 = 11,
  anon_sym_COLON = 12,
  sym_link_destination = 13,
  anon_sym_RBRACE = 14,
  anon_sym_DOT = 15,
  sym_identifier = 16,
  anon_sym_DQUOTE = 17,
  aux_sym_value_token1 = 18,
  aux_sym_value_token2 = 19,
  sym__whitespace = 20,
  sym__whitespace1 = 21,
  sym_quotation_marks = 22,
  sym_ellipsis = 23,
  sym_em_dash = 24,
  sym_en_dash = 25,
  sym_backslash_escape = 26,
  anon_sym_LT = 27,
  aux_sym_autolink_token1 = 28,
  anon_sym_GT = 29,
  sym_symbol = 30,
  anon_sym_LBRACE_ = 31,
  anon_sym__ = 32,
  anon_sym_LBRACE_STAR = 33,
  anon_sym_STAR = 34,
  anon_sym_LBRACE_CARET = 35,
  anon_sym_CARET = 36,
  anon_sym_LBRACE_TILDE = 37,
  anon_sym_TILDE = 38,
  anon_sym_LBRACE_EQ = 39,
  anon_sym_LBRACE_PLUS = 40,
  anon_sym_LBRACE_DASH = 41,
  anon_sym_LBRACK_CARET = 42,
  sym__id = 43,
  anon_sym_LBRACK_RBRACK = 44,
  anon_sym_BANG_LBRACK = 45,
  anon_sym_LBRACK_RBRACK2 = 46,
  anon_sym_LBRACE = 47,
  anon_sym_RBRACK2 = 48,
  aux_sym__inline_link_url_token1 = 49,
  anon_sym_LPAREN = 50,
  anon_sym_PERCENT = 51,
  aux_sym__comment_token1 = 52,
  anon_sym_LBRACE_EQ2 = 53,
  anon_sym_DOLLAR = 54,
  anon_sym_TODO = 55,
  anon_sym_WIP = 56,
  anon_sym_NOTE = 57,
  anon_sym_INFO = 58,
  anon_sym_XXX = 59,
  sym_fixme = 60,
  aux_sym__text_token1 = 61,
  sym__ignored = 62,
  sym__block_close = 63,
  sym__eof_or_newline = 64,
  sym__newline = 65,
  sym__newline_inline = 66,
  sym__non_whitespace_check = 67,
  sym_hard_line_break = 68,
  sym_frontmatter_marker = 69,
  sym__heading_begin = 70,
  sym__heading_continuation = 71,
  sym__div_begin = 72,
  sym__div_end = 73,
  sym__code_block_begin = 74,
  sym__code_block_end = 75,
  sym_list_marker_dash = 76,
  sym_list_marker_star = 77,
  sym_list_marker_plus = 78,
  sym__list_marker_task_begin = 79,
  sym_list_marker_definition = 80,
  sym_list_marker_decimal_period = 81,
  sym_list_marker_lower_alpha_period = 82,
  sym_list_marker_upper_alpha_period = 83,
  sym_list_marker_lower_roman_period = 84,
  sym_list_marker_upper_roman_period = 85,
  sym_list_marker_decimal_paren = 86,
  sym_list_marker_lower_alpha_paren = 87,
  sym_list_marker_upper_alpha_paren = 88,
  sym_list_marker_lower_roman_paren = 89,
  sym_list_marker_upper_roman_paren = 90,
  sym_list_marker_decimal_parens = 91,
  sym_list_marker_lower_alpha_parens = 92,
  sym_list_marker_upper_alpha_parens = 93,
  sym_list_marker_lower_roman_parens = 94,
  sym_list_marker_upper_roman_parens = 95,
  sym__list_item_continuation = 96,
  sym__list_item_end = 97,
  sym__indented_content_spacer = 98,
  sym__close_paragraph = 99,
  sym__block_quote_begin = 100,
  sym__block_quote_continuation = 101,
  sym__thematic_break_dash = 102,
  sym__thematic_break_star = 103,
  sym__footnote_mark_begin = 104,
  sym__footnote_continuation = 105,
  sym__footnote_end = 106,
  sym__link_ref_def_mark_begin = 107,
  sym__link_ref_def_label_end = 108,
  sym__table_header_begin = 109,
  sym__table_separator_begin = 110,
  sym__table_row_begin = 111,
  sym__table_row_end_newline = 112,
  sym__table_cell_end = 113,
  sym__table_caption_begin = 114,
  sym__table_caption_end = 115,
  sym__block_attribute_begin = 116,
  sym__comment_end_marker = 117,
  sym__comment_close = 118,
  sym__inline_comment_begin = 119,
  sym__verbatim_begin = 120,
  sym__verbatim_end = 121,
  sym__verbatim_content = 122,
  sym__emphasis_mark_begin = 123,
  sym_emphasis_end = 124,
  sym__strong_mark_begin = 125,
  sym_strong_end = 126,
  sym__superscript_mark_begin = 127,
  sym_superscript_end = 128,
  sym__subscript_mark_begin = 129,
  sym_subscript_end = 130,
  sym__highlighted_mark_begin = 131,
  sym_highlighted_end = 132,
  sym__insert_mark_begin = 133,
  sym_insert_end = 134,
  sym__delete_mark_begin = 135,
  sym_delete_end = 136,
  sym__parens_span_mark_begin = 137,
  sym__parens_span_end = 138,
  sym__curly_bracket_span_mark_begin = 139,
  sym__curly_bracket_span_end = 140,
  sym__square_bracket_span_mark_begin = 141,
  sym__square_bracket_span_end = 142,
  sym__in_fallback = 143,
  sym__error = 144,
  sym_document = 145,
  sym_frontmatter = 146,
  sym_frontmatter_content = 147,
  sym__block_with_section = 148,
  sym__block_with_heading = 149,
  sym__block_element = 150,
  sym_section = 151,
  sym_heading = 152,
  sym__heading_content = 153,
  sym_list = 154,
  sym__list_dash = 155,
  sym__list_item_dash = 156,
  sym__list_plus = 157,
  sym__list_item_plus = 158,
  sym__list_star = 159,
  sym__list_item_star = 160,
  sym__list_task = 161,
  sym__list_item_task = 162,
  sym_list_marker_task = 163,
  sym_checked = 164,
  sym_unchecked = 165,
  sym__list_definition = 166,
  sym__list_item_definition = 167,
  sym__list_decimal_period = 168,
  sym__list_item_decimal_period = 169,
  sym__list_decimal_paren = 170,
  sym__list_item_decimal_paren = 171,
  sym__list_decimal_parens = 172,
  sym__list_item_decimal_parens = 173,
  sym__list_lower_alpha_period = 174,
  sym__list_item_lower_alpha_period = 175,
  sym__list_lower_alpha_paren = 176,
  sym__list_item_lower_alpha_paren = 177,
  sym__list_lower_alpha_parens = 178,
  sym__list_item_lower_alpha_parens = 179,
  sym__list_upper_alpha_period = 180,
  sym__list_item_upper_alpha_period = 181,
  sym__list_upper_alpha_paren = 182,
  sym__list_item_upper_alpha_paren = 183,
  sym__list_upper_alpha_parens = 184,
  sym__list_item_upper_alpha_parens = 185,
  sym__list_lower_roman_period = 186,
  sym__list_item_lower_roman_period = 187,
  sym__list_lower_roman_paren = 188,
  sym__list_item_lower_roman_paren = 189,
  sym__list_lower_roman_parens = 190,
  sym__list_item_lower_roman_parens = 191,
  sym__list_upper_roman_period = 192,
  sym__list_item_upper_roman_period = 193,
  sym__list_upper_roman_paren = 194,
  sym__list_item_upper_roman_paren = 195,
  sym__list_upper_roman_parens = 196,
  sym__list_item_upper_roman_parens = 197,
  sym_list_item_content = 198,
  sym_table = 199,
  sym__table_row = 200,
  sym_table_header = 201,
  sym_table_separator = 202,
  sym_table_row = 203,
  sym__table_cell = 204,
  sym__table_cell_alignment = 205,
  sym_table_caption = 206,
  sym_footnote = 207,
  sym_footnote_content = 208,
  sym_div = 209,
  sym__div_marker_begin = 210,
  sym_class_name = 211,
  sym_code_block = 212,
  sym_raw_block = 213,
  sym_raw_block_info = 214,
  sym_code = 215,
  sym__line = 216,
  sym_thematic_break = 217,
  sym_block_quote = 218,
  sym__block_quote_content = 219,
  sym__block_quote_prefix = 220,
  sym_link_reference_definition = 221,
  sym_block_attribute = 222,
  sym_class = 223,
  sym_key_value = 224,
  sym_key = 225,
  sym_value = 226,
  sym__paragraph = 227,
  sym__paragraph_content = 228,
  sym__inline = 229,
  sym__inline_without_trailing_space = 230,
  sym__inline_element = 231,
  sym__inline_line = 232,
  sym__smart_punctuation = 233,
  sym_autolink = 234,
  sym_emphasis = 235,
  sym_emphasis_begin = 236,
  sym_strong = 237,
  sym_strong_begin = 238,
  sym_superscript = 239,
  sym_superscript_begin = 240,
  sym_subscript = 241,
  sym_subscript_begin = 242,
  sym_highlighted = 243,
  sym_highlighted_begin = 244,
  sym_insert = 245,
  sym_insert_begin = 246,
  sym_delete = 247,
  sym_delete_begin = 248,
  sym_footnote_reference = 249,
  sym_footnote_marker_begin = 250,
  sym_reference_label = 251,
  sym__image = 252,
  sym_full_reference_image = 253,
  sym_collapsed_reference_image = 254,
  sym_inline_image = 255,
  sym_image_description = 256,
  sym__image_description_begin = 257,
  sym__link = 258,
  sym_full_reference_link = 259,
  sym_collapsed_reference_link = 260,
  sym_inline_link = 261,
  sym_link_text = 262,
  sym_span = 263,
  sym__bracketed_text_begin = 264,
  sym_inline_attribute = 265,
  sym__curly_bracket_span_begin = 266,
  sym__link_label = 267,
  sym_inline_link_destination = 268,
  aux_sym__inline_link_url = 269,
  sym__parens_span_begin = 270,
  sym__comment = 271,
  sym_inline_comment = 272,
  sym_raw_inline = 273,
  sym_raw_inline_attribute = 274,
  sym_math = 275,
  sym_verbatim = 276,
  sym__todo_highlights = 277,
  sym_todo = 278,
  sym_note = 279,
  sym__symbol_fallback = 280,
  sym__curly_bracket_span_fallback = 281,
  aux_sym__text = 282,
  aux_sym_document_repeat1 = 283,
  aux_sym_frontmatter_content_repeat1 = 284,
  aux_sym__heading_content_repeat1 = 285,
  aux_sym__list_dash_repeat1 = 286,
  aux_sym__list_plus_repeat1 = 287,
  aux_sym__list_star_repeat1 = 288,
  aux_sym__list_task_repeat1 = 289,
  aux_sym__list_definition_repeat1 = 290,
  aux_sym__list_item_definition_repeat1 = 291,
  aux_sym__list_decimal_period_repeat1 = 292,
  aux_sym__list_decimal_paren_repeat1 = 293,
  aux_sym__list_decimal_parens_repeat1 = 294,
  aux_sym__list_lower_alpha_period_repeat1 = 295,
  aux_sym__list_lower_alpha_paren_repeat1 = 296,
  aux_sym__list_lower_alpha_parens_repeat1 = 297,
  aux_sym__list_upper_alpha_period_repeat1 = 298,
  aux_sym__list_upper_alpha_paren_repeat1 = 299,
  aux_sym__list_upper_alpha_parens_repeat1 = 300,
  aux_sym__list_lower_roman_period_repeat1 = 301,
  aux_sym__list_lower_roman_paren_repeat1 = 302,
  aux_sym__list_lower_roman_parens_repeat1 = 303,
  aux_sym__list_upper_roman_period_repeat1 = 304,
  aux_sym__list_upper_roman_paren_repeat1 = 305,
  aux_sym__list_upper_roman_parens_repeat1 = 306,
  aux_sym_list_item_content_repeat1 = 307,
  aux_sym_table_repeat1 = 308,
  aux_sym_table_header_repeat1 = 309,
  aux_sym_table_separator_repeat1 = 310,
  aux_sym_table_caption_repeat1 = 311,
  aux_sym_footnote_content_repeat1 = 312,
  aux_sym_div_repeat1 = 313,
  aux_sym_code_repeat1 = 314,
  aux_sym__block_quote_content_repeat1 = 315,
  aux_sym__block_quote_prefix_repeat1 = 316,
  aux_sym_block_attribute_repeat1 = 317,
  aux_sym__paragraph_content_repeat1 = 318,
  aux_sym__inline_repeat1 = 319,
  aux_sym_inline_attribute_repeat1 = 320,
  aux_sym__comment_repeat1 = 321,
  alias_sym_args = 322,
  anon_alias_sym_class = 323,
  alias_sym_comment = 324,
  alias_sym_definition = 325,
  alias_sym_language_marker = 326,
  alias_sym_link_label = 327,
  alias_sym_math_marker = 328,
  alias_sym_math_marker_begin = 329,
  alias_sym_math_marker_end = 330,
  alias_sym_paragraph = 331,
  alias_sym_raw_block_marker_begin = 332,
  alias_sym_raw_block_marker_end = 333,
  alias_sym_section_content = 334,
  alias_sym_table_cell = 335,
  alias_sym_verbatim_marker_begin = 336,
  alias_sym_verbatim_marker_end = 337,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LBRACK] = "[",
  [anon_sym_x] = "x",
  [anon_sym_X] = "X",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SPACE] = " ",
  [aux_sym__table_cell_alignment_token1] = "table_cell_alignment",
  [anon_sym_NULL] = "\0",
  [anon_sym_RBRACK_COLON] = "footnote_marker_end",
  [anon_sym_EQ] = "=",
  [sym_language] = "language",
  [aux_sym__line_token1] = "_line_token1",
  [anon_sym_COLON] = ":",
  [sym_link_destination] = "link_destination",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [sym_identifier] = "identifier",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_value_token1] = "value_token1",
  [aux_sym_value_token2] = "value_token2",
  [sym__whitespace] = "_whitespace",
  [sym__whitespace1] = "_whitespace1",
  [sym_quotation_marks] = "quotation_marks",
  [sym_ellipsis] = "ellipsis",
  [sym_em_dash] = "em_dash",
  [sym_en_dash] = "en_dash",
  [sym_backslash_escape] = "backslash_escape",
  [anon_sym_LT] = "<",
  [aux_sym_autolink_token1] = "autolink_token1",
  [anon_sym_GT] = ">",
  [sym_symbol] = "symbol",
  [anon_sym_LBRACE_] = "{_",
  [anon_sym__] = "_",
  [anon_sym_LBRACE_STAR] = "{*",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACE_CARET] = "{^",
  [anon_sym_CARET] = "^",
  [anon_sym_LBRACE_TILDE] = "{~",
  [anon_sym_TILDE] = "~",
  [anon_sym_LBRACE_EQ] = "{=",
  [anon_sym_LBRACE_PLUS] = "{+",
  [anon_sym_LBRACE_DASH] = "{-",
  [anon_sym_LBRACK_CARET] = "[^",
  [sym__id] = "_id",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_BANG_LBRACK] = "![",
  [anon_sym_LBRACK_RBRACK2] = "[]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACK2] = "]",
  [aux_sym__inline_link_url_token1] = "_inline_link_url_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_PERCENT] = "%",
  [aux_sym__comment_token1] = "_comment_token1",
  [anon_sym_LBRACE_EQ2] = "{=",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_TODO] = "TODO",
  [anon_sym_WIP] = "WIP",
  [anon_sym_NOTE] = "NOTE",
  [anon_sym_INFO] = "INFO",
  [anon_sym_XXX] = "XXX",
  [sym_fixme] = "fixme",
  [aux_sym__text_token1] = "_text_token1",
  [sym__ignored] = "_ignored",
  [sym__block_close] = "_block_close",
  [sym__eof_or_newline] = "_eof_or_newline",
  [sym__newline] = "_newline",
  [sym__newline_inline] = "_newline_inline",
  [sym__non_whitespace_check] = "_non_whitespace_check",
  [sym_hard_line_break] = "hard_line_break",
  [sym_frontmatter_marker] = "frontmatter_marker",
  [sym__heading_begin] = "marker",
  [sym__heading_continuation] = "marker",
  [sym__div_begin] = "div_marker_begin",
  [sym__div_end] = "div_marker_end",
  [sym__code_block_begin] = "code_block_marker_begin",
  [sym__code_block_end] = "code_block_marker_end",
  [sym_list_marker_dash] = "list_marker_dash",
  [sym_list_marker_star] = "list_marker_star",
  [sym_list_marker_plus] = "list_marker_plus",
  [sym__list_marker_task_begin] = "_list_marker_task_begin",
  [sym_list_marker_definition] = "list_marker_definition",
  [sym_list_marker_decimal_period] = "list_marker_decimal_period",
  [sym_list_marker_lower_alpha_period] = "list_marker_lower_alpha_period",
  [sym_list_marker_upper_alpha_period] = "list_marker_upper_alpha_period",
  [sym_list_marker_lower_roman_period] = "list_marker_lower_roman_period",
  [sym_list_marker_upper_roman_period] = "list_marker_upper_roman_period",
  [sym_list_marker_decimal_paren] = "list_marker_decimal_paren",
  [sym_list_marker_lower_alpha_paren] = "list_marker_lower_alpha_paren",
  [sym_list_marker_upper_alpha_paren] = "list_marker_upper_alpha_paren",
  [sym_list_marker_lower_roman_paren] = "list_marker_lower_roman_paren",
  [sym_list_marker_upper_roman_paren] = "list_marker_upper_roman_paren",
  [sym_list_marker_decimal_parens] = "list_marker_decimal_parens",
  [sym_list_marker_lower_alpha_parens] = "list_marker_lower_alpha_parens",
  [sym_list_marker_upper_alpha_parens] = "list_marker_upper_alpha_parens",
  [sym_list_marker_lower_roman_parens] = "list_marker_lower_roman_parens",
  [sym_list_marker_upper_roman_parens] = "list_marker_upper_roman_parens",
  [sym__list_item_continuation] = "_list_item_continuation",
  [sym__list_item_end] = "_list_item_end",
  [sym__indented_content_spacer] = "_indented_content_spacer",
  [sym__close_paragraph] = "_close_paragraph",
  [sym__block_quote_begin] = "block_quote_marker",
  [sym__block_quote_continuation] = "_block_quote_continuation",
  [sym__thematic_break_dash] = "_thematic_break_dash",
  [sym__thematic_break_star] = "_thematic_break_star",
  [sym__footnote_mark_begin] = "_footnote_mark_begin",
  [sym__footnote_continuation] = "_footnote_continuation",
  [sym__footnote_end] = "_footnote_end",
  [sym__link_ref_def_mark_begin] = "_link_ref_def_mark_begin",
  [sym__link_ref_def_label_end] = "_link_ref_def_label_end",
  [sym__table_header_begin] = "|",
  [sym__table_separator_begin] = "|",
  [sym__table_row_begin] = "|",
  [sym__table_row_end_newline] = "_table_row_end_newline",
  [sym__table_cell_end] = "|",
  [sym__table_caption_begin] = "marker",
  [sym__table_caption_end] = "_table_caption_end",
  [sym__block_attribute_begin] = "{",
  [sym__comment_end_marker] = "%",
  [sym__comment_close] = "_comment_close",
  [sym__inline_comment_begin] = "_inline_comment_begin",
  [sym__verbatim_begin] = "raw_inline_marker_begin",
  [sym__verbatim_end] = "raw_inline_marker_end",
  [sym__verbatim_content] = "content",
  [sym__emphasis_mark_begin] = "_emphasis_mark_begin",
  [sym_emphasis_end] = "emphasis_end",
  [sym__strong_mark_begin] = "_strong_mark_begin",
  [sym_strong_end] = "strong_end",
  [sym__superscript_mark_begin] = "_superscript_mark_begin",
  [sym_superscript_end] = "superscript_end",
  [sym__subscript_mark_begin] = "_subscript_mark_begin",
  [sym_subscript_end] = "subscript_end",
  [sym__highlighted_mark_begin] = "_highlighted_mark_begin",
  [sym_highlighted_end] = "highlighted_end",
  [sym__insert_mark_begin] = "_insert_mark_begin",
  [sym_insert_end] = "insert_end",
  [sym__delete_mark_begin] = "_delete_mark_begin",
  [sym_delete_end] = "delete_end",
  [sym__parens_span_mark_begin] = "_parens_span_mark_begin",
  [sym__parens_span_end] = ")",
  [sym__curly_bracket_span_mark_begin] = "_curly_bracket_span_mark_begin",
  [sym__curly_bracket_span_end] = "}",
  [sym__square_bracket_span_mark_begin] = "_square_bracket_span_mark_begin",
  [sym__square_bracket_span_end] = "]",
  [sym__in_fallback] = "_in_fallback",
  [sym__error] = "_error",
  [sym_document] = "document",
  [sym_frontmatter] = "frontmatter",
  [sym_frontmatter_content] = "frontmatter_content",
  [sym__block_with_section] = "_block_with_section",
  [sym__block_with_heading] = "_block_with_heading",
  [sym__block_element] = "_block_element",
  [sym_section] = "section",
  [sym_heading] = "heading",
  [sym__heading_content] = "content",
  [sym_list] = "list",
  [sym__list_dash] = "_list_dash",
  [sym__list_item_dash] = "list_item",
  [sym__list_plus] = "_list_plus",
  [sym__list_item_plus] = "list_item",
  [sym__list_star] = "_list_star",
  [sym__list_item_star] = "list_item",
  [sym__list_task] = "_list_task",
  [sym__list_item_task] = "list_item",
  [sym_list_marker_task] = "list_marker_task",
  [sym_checked] = "checked",
  [sym_unchecked] = "unchecked",
  [sym__list_definition] = "_list_definition",
  [sym__list_item_definition] = "list_item",
  [sym__list_decimal_period] = "_list_decimal_period",
  [sym__list_item_decimal_period] = "list_item",
  [sym__list_decimal_paren] = "_list_decimal_paren",
  [sym__list_item_decimal_paren] = "list_item",
  [sym__list_decimal_parens] = "_list_decimal_parens",
  [sym__list_item_decimal_parens] = "list_item",
  [sym__list_lower_alpha_period] = "_list_lower_alpha_period",
  [sym__list_item_lower_alpha_period] = "list_item",
  [sym__list_lower_alpha_paren] = "_list_lower_alpha_paren",
  [sym__list_item_lower_alpha_paren] = "list_item",
  [sym__list_lower_alpha_parens] = "_list_lower_alpha_parens",
  [sym__list_item_lower_alpha_parens] = "list_item",
  [sym__list_upper_alpha_period] = "_list_upper_alpha_period",
  [sym__list_item_upper_alpha_period] = "list_item",
  [sym__list_upper_alpha_paren] = "_list_upper_alpha_paren",
  [sym__list_item_upper_alpha_paren] = "list_item",
  [sym__list_upper_alpha_parens] = "_list_upper_alpha_parens",
  [sym__list_item_upper_alpha_parens] = "list_item",
  [sym__list_lower_roman_period] = "_list_lower_roman_period",
  [sym__list_item_lower_roman_period] = "list_item",
  [sym__list_lower_roman_paren] = "_list_lower_roman_paren",
  [sym__list_item_lower_roman_paren] = "list_item",
  [sym__list_lower_roman_parens] = "_list_lower_roman_parens",
  [sym__list_item_lower_roman_parens] = "list_item",
  [sym__list_upper_roman_period] = "_list_upper_roman_period",
  [sym__list_item_upper_roman_period] = "list_item",
  [sym__list_upper_roman_paren] = "_list_upper_roman_paren",
  [sym__list_item_upper_roman_paren] = "list_item",
  [sym__list_upper_roman_parens] = "_list_upper_roman_parens",
  [sym__list_item_upper_roman_parens] = "list_item",
  [sym_list_item_content] = "list_item_content",
  [sym_table] = "table",
  [sym__table_row] = "_table_row",
  [sym_table_header] = "table_header",
  [sym_table_separator] = "table_separator",
  [sym_table_row] = "table_row",
  [sym__table_cell] = "_table_cell",
  [sym__table_cell_alignment] = "_table_cell_alignment",
  [sym_table_caption] = "table_caption",
  [sym_footnote] = "footnote",
  [sym_footnote_content] = "footnote_content",
  [sym_div] = "div",
  [sym__div_marker_begin] = "_div_marker_begin",
  [sym_class_name] = "class_name",
  [sym_code_block] = "code_block",
  [sym_raw_block] = "raw_block",
  [sym_raw_block_info] = "raw_block_info",
  [sym_code] = "code",
  [sym__line] = "_line",
  [sym_thematic_break] = "thematic_break",
  [sym_block_quote] = "block_quote",
  [sym__block_quote_content] = "content",
  [sym__block_quote_prefix] = "_block_quote_prefix",
  [sym_link_reference_definition] = "link_reference_definition",
  [sym_block_attribute] = "block_attribute",
  [sym_class] = "class",
  [sym_key_value] = "key_value",
  [sym_key] = "key",
  [sym_value] = "value",
  [sym__paragraph] = "_paragraph",
  [sym__paragraph_content] = "term",
  [sym__inline] = "_inline",
  [sym__inline_without_trailing_space] = "content",
  [sym__inline_element] = "_inline_element",
  [sym__inline_line] = "_inline_line",
  [sym__smart_punctuation] = "_smart_punctuation",
  [sym_autolink] = "autolink",
  [sym_emphasis] = "emphasis",
  [sym_emphasis_begin] = "emphasis_begin",
  [sym_strong] = "strong",
  [sym_strong_begin] = "strong_begin",
  [sym_superscript] = "superscript",
  [sym_superscript_begin] = "superscript_begin",
  [sym_subscript] = "subscript",
  [sym_subscript_begin] = "subscript_begin",
  [sym_highlighted] = "highlighted",
  [sym_highlighted_begin] = "highlighted_begin",
  [sym_insert] = "insert",
  [sym_insert_begin] = "insert_begin",
  [sym_delete] = "delete",
  [sym_delete_begin] = "delete_begin",
  [sym_footnote_reference] = "footnote_reference",
  [sym_footnote_marker_begin] = "footnote_marker_begin",
  [sym_reference_label] = "reference_label",
  [sym__image] = "_image",
  [sym_full_reference_image] = "full_reference_image",
  [sym_collapsed_reference_image] = "collapsed_reference_image",
  [sym_inline_image] = "inline_image",
  [sym_image_description] = "image_description",
  [sym__image_description_begin] = "_image_description_begin",
  [sym__link] = "_link",
  [sym_full_reference_link] = "full_reference_link",
  [sym_collapsed_reference_link] = "collapsed_reference_link",
  [sym_inline_link] = "inline_link",
  [sym_link_text] = "link_text",
  [sym_span] = "span",
  [sym__bracketed_text_begin] = "_bracketed_text_begin",
  [sym_inline_attribute] = "inline_attribute",
  [sym__curly_bracket_span_begin] = "_curly_bracket_span_begin",
  [sym__link_label] = "_link_label",
  [sym_inline_link_destination] = "inline_link_destination",
  [aux_sym__inline_link_url] = "_inline_link_url",
  [sym__parens_span_begin] = "_parens_span_begin",
  [sym__comment] = "_comment",
  [sym_inline_comment] = "inline_comment",
  [sym_raw_inline] = "raw_inline",
  [sym_raw_inline_attribute] = "raw_inline_attribute",
  [sym_math] = "math",
  [sym_verbatim] = "verbatim",
  [sym__todo_highlights] = "_todo_highlights",
  [sym_todo] = "todo",
  [sym_note] = "note",
  [sym__symbol_fallback] = "_symbol_fallback",
  [sym__curly_bracket_span_fallback] = "_curly_bracket_span_fallback",
  [aux_sym__text] = "_text",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_frontmatter_content_repeat1] = "frontmatter_content_repeat1",
  [aux_sym__heading_content_repeat1] = "_heading_content_repeat1",
  [aux_sym__list_dash_repeat1] = "_list_dash_repeat1",
  [aux_sym__list_plus_repeat1] = "_list_plus_repeat1",
  [aux_sym__list_star_repeat1] = "_list_star_repeat1",
  [aux_sym__list_task_repeat1] = "_list_task_repeat1",
  [aux_sym__list_definition_repeat1] = "_list_definition_repeat1",
  [aux_sym__list_item_definition_repeat1] = "_list_item_definition_repeat1",
  [aux_sym__list_decimal_period_repeat1] = "_list_decimal_period_repeat1",
  [aux_sym__list_decimal_paren_repeat1] = "_list_decimal_paren_repeat1",
  [aux_sym__list_decimal_parens_repeat1] = "_list_decimal_parens_repeat1",
  [aux_sym__list_lower_alpha_period_repeat1] = "_list_lower_alpha_period_repeat1",
  [aux_sym__list_lower_alpha_paren_repeat1] = "_list_lower_alpha_paren_repeat1",
  [aux_sym__list_lower_alpha_parens_repeat1] = "_list_lower_alpha_parens_repeat1",
  [aux_sym__list_upper_alpha_period_repeat1] = "_list_upper_alpha_period_repeat1",
  [aux_sym__list_upper_alpha_paren_repeat1] = "_list_upper_alpha_paren_repeat1",
  [aux_sym__list_upper_alpha_parens_repeat1] = "_list_upper_alpha_parens_repeat1",
  [aux_sym__list_lower_roman_period_repeat1] = "_list_lower_roman_period_repeat1",
  [aux_sym__list_lower_roman_paren_repeat1] = "_list_lower_roman_paren_repeat1",
  [aux_sym__list_lower_roman_parens_repeat1] = "_list_lower_roman_parens_repeat1",
  [aux_sym__list_upper_roman_period_repeat1] = "_list_upper_roman_period_repeat1",
  [aux_sym__list_upper_roman_paren_repeat1] = "_list_upper_roman_paren_repeat1",
  [aux_sym__list_upper_roman_parens_repeat1] = "_list_upper_roman_parens_repeat1",
  [aux_sym_list_item_content_repeat1] = "list_item_content_repeat1",
  [aux_sym_table_repeat1] = "table_repeat1",
  [aux_sym_table_header_repeat1] = "table_header_repeat1",
  [aux_sym_table_separator_repeat1] = "table_separator_repeat1",
  [aux_sym_table_caption_repeat1] = "table_caption_repeat1",
  [aux_sym_footnote_content_repeat1] = "footnote_content_repeat1",
  [aux_sym_div_repeat1] = "div_repeat1",
  [aux_sym_code_repeat1] = "code_repeat1",
  [aux_sym__block_quote_content_repeat1] = "_block_quote_content_repeat1",
  [aux_sym__block_quote_prefix_repeat1] = "_block_quote_prefix_repeat1",
  [aux_sym_block_attribute_repeat1] = "block_attribute_repeat1",
  [aux_sym__paragraph_content_repeat1] = "_paragraph_content_repeat1",
  [aux_sym__inline_repeat1] = "_inline_repeat1",
  [aux_sym_inline_attribute_repeat1] = "inline_attribute_repeat1",
  [aux_sym__comment_repeat1] = "_comment_repeat1",
  [alias_sym_args] = "args",
  [anon_alias_sym_class] = "class",
  [alias_sym_comment] = "comment",
  [alias_sym_definition] = "definition",
  [alias_sym_language_marker] = "language_marker",
  [alias_sym_link_label] = "link_label",
  [alias_sym_math_marker] = "math_marker",
  [alias_sym_math_marker_begin] = "math_marker_begin",
  [alias_sym_math_marker_end] = "math_marker_end",
  [alias_sym_paragraph] = "paragraph",
  [alias_sym_raw_block_marker_begin] = "raw_block_marker_begin",
  [alias_sym_raw_block_marker_end] = "raw_block_marker_end",
  [alias_sym_section_content] = "section_content",
  [alias_sym_table_cell] = "table_cell",
  [alias_sym_verbatim_marker_begin] = "verbatim_marker_begin",
  [alias_sym_verbatim_marker_end] = "verbatim_marker_end",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_x] = anon_sym_x,
  [anon_sym_X] = anon_sym_X,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SPACE] = anon_sym_SPACE,
  [aux_sym__table_cell_alignment_token1] = aux_sym__table_cell_alignment_token1,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_RBRACK_COLON] = anon_sym_RBRACK_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_language] = sym_language,
  [aux_sym__line_token1] = aux_sym__line_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_link_destination] = sym_link_destination,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_identifier] = sym_identifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_value_token1] = aux_sym_value_token1,
  [aux_sym_value_token2] = aux_sym_value_token2,
  [sym__whitespace] = sym__whitespace,
  [sym__whitespace1] = sym__whitespace1,
  [sym_quotation_marks] = sym_quotation_marks,
  [sym_ellipsis] = sym_ellipsis,
  [sym_em_dash] = sym_em_dash,
  [sym_en_dash] = sym_en_dash,
  [sym_backslash_escape] = sym_backslash_escape,
  [anon_sym_LT] = anon_sym_LT,
  [aux_sym_autolink_token1] = aux_sym_autolink_token1,
  [anon_sym_GT] = anon_sym_GT,
  [sym_symbol] = sym_symbol,
  [anon_sym_LBRACE_] = anon_sym_LBRACE_,
  [anon_sym__] = anon_sym__,
  [anon_sym_LBRACE_STAR] = anon_sym_LBRACE_STAR,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACE_CARET] = anon_sym_LBRACE_CARET,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LBRACE_TILDE] = anon_sym_LBRACE_TILDE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LBRACE_EQ] = anon_sym_LBRACE_EQ,
  [anon_sym_LBRACE_PLUS] = anon_sym_LBRACE_PLUS,
  [anon_sym_LBRACE_DASH] = anon_sym_LBRACE_DASH,
  [anon_sym_LBRACK_CARET] = anon_sym_LBRACK_CARET,
  [sym__id] = sym__id,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_BANG_LBRACK] = anon_sym_BANG_LBRACK,
  [anon_sym_LBRACK_RBRACK2] = anon_sym_LBRACK_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACK2] = anon_sym_RBRACK,
  [aux_sym__inline_link_url_token1] = aux_sym__inline_link_url_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym__comment_token1] = aux_sym__comment_token1,
  [anon_sym_LBRACE_EQ2] = anon_sym_LBRACE_EQ,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_TODO] = anon_sym_TODO,
  [anon_sym_WIP] = anon_sym_WIP,
  [anon_sym_NOTE] = anon_sym_NOTE,
  [anon_sym_INFO] = anon_sym_INFO,
  [anon_sym_XXX] = anon_sym_XXX,
  [sym_fixme] = sym_fixme,
  [aux_sym__text_token1] = aux_sym__text_token1,
  [sym__ignored] = sym__ignored,
  [sym__block_close] = sym__block_close,
  [sym__eof_or_newline] = sym__eof_or_newline,
  [sym__newline] = sym__newline,
  [sym__newline_inline] = sym__newline_inline,
  [sym__non_whitespace_check] = sym__non_whitespace_check,
  [sym_hard_line_break] = sym_hard_line_break,
  [sym_frontmatter_marker] = sym_frontmatter_marker,
  [sym__heading_begin] = sym__heading_begin,
  [sym__heading_continuation] = sym__heading_begin,
  [sym__div_begin] = sym__div_begin,
  [sym__div_end] = sym__div_end,
  [sym__code_block_begin] = sym__code_block_begin,
  [sym__code_block_end] = sym__code_block_end,
  [sym_list_marker_dash] = sym_list_marker_dash,
  [sym_list_marker_star] = sym_list_marker_star,
  [sym_list_marker_plus] = sym_list_marker_plus,
  [sym__list_marker_task_begin] = sym__list_marker_task_begin,
  [sym_list_marker_definition] = sym_list_marker_definition,
  [sym_list_marker_decimal_period] = sym_list_marker_decimal_period,
  [sym_list_marker_lower_alpha_period] = sym_list_marker_lower_alpha_period,
  [sym_list_marker_upper_alpha_period] = sym_list_marker_upper_alpha_period,
  [sym_list_marker_lower_roman_period] = sym_list_marker_lower_roman_period,
  [sym_list_marker_upper_roman_period] = sym_list_marker_upper_roman_period,
  [sym_list_marker_decimal_paren] = sym_list_marker_decimal_paren,
  [sym_list_marker_lower_alpha_paren] = sym_list_marker_lower_alpha_paren,
  [sym_list_marker_upper_alpha_paren] = sym_list_marker_upper_alpha_paren,
  [sym_list_marker_lower_roman_paren] = sym_list_marker_lower_roman_paren,
  [sym_list_marker_upper_roman_paren] = sym_list_marker_upper_roman_paren,
  [sym_list_marker_decimal_parens] = sym_list_marker_decimal_parens,
  [sym_list_marker_lower_alpha_parens] = sym_list_marker_lower_alpha_parens,
  [sym_list_marker_upper_alpha_parens] = sym_list_marker_upper_alpha_parens,
  [sym_list_marker_lower_roman_parens] = sym_list_marker_lower_roman_parens,
  [sym_list_marker_upper_roman_parens] = sym_list_marker_upper_roman_parens,
  [sym__list_item_continuation] = sym__list_item_continuation,
  [sym__list_item_end] = sym__list_item_end,
  [sym__indented_content_spacer] = sym__indented_content_spacer,
  [sym__close_paragraph] = sym__close_paragraph,
  [sym__block_quote_begin] = sym__block_quote_begin,
  [sym__block_quote_continuation] = sym__block_quote_continuation,
  [sym__thematic_break_dash] = sym__thematic_break_dash,
  [sym__thematic_break_star] = sym__thematic_break_star,
  [sym__footnote_mark_begin] = sym__footnote_mark_begin,
  [sym__footnote_continuation] = sym__footnote_continuation,
  [sym__footnote_end] = sym__footnote_end,
  [sym__link_ref_def_mark_begin] = sym__link_ref_def_mark_begin,
  [sym__link_ref_def_label_end] = sym__link_ref_def_label_end,
  [sym__table_header_begin] = sym__table_header_begin,
  [sym__table_separator_begin] = sym__table_header_begin,
  [sym__table_row_begin] = sym__table_header_begin,
  [sym__table_row_end_newline] = sym__table_row_end_newline,
  [sym__table_cell_end] = sym__table_header_begin,
  [sym__table_caption_begin] = sym__heading_begin,
  [sym__table_caption_end] = sym__table_caption_end,
  [sym__block_attribute_begin] = anon_sym_LBRACE,
  [sym__comment_end_marker] = anon_sym_PERCENT,
  [sym__comment_close] = sym__comment_close,
  [sym__inline_comment_begin] = sym__inline_comment_begin,
  [sym__verbatim_begin] = sym__verbatim_begin,
  [sym__verbatim_end] = sym__verbatim_end,
  [sym__verbatim_content] = sym__verbatim_content,
  [sym__emphasis_mark_begin] = sym__emphasis_mark_begin,
  [sym_emphasis_end] = sym_emphasis_end,
  [sym__strong_mark_begin] = sym__strong_mark_begin,
  [sym_strong_end] = sym_strong_end,
  [sym__superscript_mark_begin] = sym__superscript_mark_begin,
  [sym_superscript_end] = sym_superscript_end,
  [sym__subscript_mark_begin] = sym__subscript_mark_begin,
  [sym_subscript_end] = sym_subscript_end,
  [sym__highlighted_mark_begin] = sym__highlighted_mark_begin,
  [sym_highlighted_end] = sym_highlighted_end,
  [sym__insert_mark_begin] = sym__insert_mark_begin,
  [sym_insert_end] = sym_insert_end,
  [sym__delete_mark_begin] = sym__delete_mark_begin,
  [sym_delete_end] = sym_delete_end,
  [sym__parens_span_mark_begin] = sym__parens_span_mark_begin,
  [sym__parens_span_end] = sym__parens_span_end,
  [sym__curly_bracket_span_mark_begin] = sym__curly_bracket_span_mark_begin,
  [sym__curly_bracket_span_end] = anon_sym_RBRACE,
  [sym__square_bracket_span_mark_begin] = sym__square_bracket_span_mark_begin,
  [sym__square_bracket_span_end] = anon_sym_RBRACK,
  [sym__in_fallback] = sym__in_fallback,
  [sym__error] = sym__error,
  [sym_document] = sym_document,
  [sym_frontmatter] = sym_frontmatter,
  [sym_frontmatter_content] = sym_frontmatter_content,
  [sym__block_with_section] = sym__block_with_section,
  [sym__block_with_heading] = sym__block_with_heading,
  [sym__block_element] = sym__block_element,
  [sym_section] = sym_section,
  [sym_heading] = sym_heading,
  [sym__heading_content] = sym__verbatim_content,
  [sym_list] = sym_list,
  [sym__list_dash] = sym__list_dash,
  [sym__list_item_dash] = sym__list_item_dash,
  [sym__list_plus] = sym__list_plus,
  [sym__list_item_plus] = sym__list_item_dash,
  [sym__list_star] = sym__list_star,
  [sym__list_item_star] = sym__list_item_dash,
  [sym__list_task] = sym__list_task,
  [sym__list_item_task] = sym__list_item_dash,
  [sym_list_marker_task] = sym_list_marker_task,
  [sym_checked] = sym_checked,
  [sym_unchecked] = sym_unchecked,
  [sym__list_definition] = sym__list_definition,
  [sym__list_item_definition] = sym__list_item_dash,
  [sym__list_decimal_period] = sym__list_decimal_period,
  [sym__list_item_decimal_period] = sym__list_item_dash,
  [sym__list_decimal_paren] = sym__list_decimal_paren,
  [sym__list_item_decimal_paren] = sym__list_item_dash,
  [sym__list_decimal_parens] = sym__list_decimal_parens,
  [sym__list_item_decimal_parens] = sym__list_item_dash,
  [sym__list_lower_alpha_period] = sym__list_lower_alpha_period,
  [sym__list_item_lower_alpha_period] = sym__list_item_dash,
  [sym__list_lower_alpha_paren] = sym__list_lower_alpha_paren,
  [sym__list_item_lower_alpha_paren] = sym__list_item_dash,
  [sym__list_lower_alpha_parens] = sym__list_lower_alpha_parens,
  [sym__list_item_lower_alpha_parens] = sym__list_item_dash,
  [sym__list_upper_alpha_period] = sym__list_upper_alpha_period,
  [sym__list_item_upper_alpha_period] = sym__list_item_dash,
  [sym__list_upper_alpha_paren] = sym__list_upper_alpha_paren,
  [sym__list_item_upper_alpha_paren] = sym__list_item_dash,
  [sym__list_upper_alpha_parens] = sym__list_upper_alpha_parens,
  [sym__list_item_upper_alpha_parens] = sym__list_item_dash,
  [sym__list_lower_roman_period] = sym__list_lower_roman_period,
  [sym__list_item_lower_roman_period] = sym__list_item_dash,
  [sym__list_lower_roman_paren] = sym__list_lower_roman_paren,
  [sym__list_item_lower_roman_paren] = sym__list_item_dash,
  [sym__list_lower_roman_parens] = sym__list_lower_roman_parens,
  [sym__list_item_lower_roman_parens] = sym__list_item_dash,
  [sym__list_upper_roman_period] = sym__list_upper_roman_period,
  [sym__list_item_upper_roman_period] = sym__list_item_dash,
  [sym__list_upper_roman_paren] = sym__list_upper_roman_paren,
  [sym__list_item_upper_roman_paren] = sym__list_item_dash,
  [sym__list_upper_roman_parens] = sym__list_upper_roman_parens,
  [sym__list_item_upper_roman_parens] = sym__list_item_dash,
  [sym_list_item_content] = sym_list_item_content,
  [sym_table] = sym_table,
  [sym__table_row] = sym__table_row,
  [sym_table_header] = sym_table_header,
  [sym_table_separator] = sym_table_separator,
  [sym_table_row] = sym_table_row,
  [sym__table_cell] = sym__table_cell,
  [sym__table_cell_alignment] = sym__table_cell_alignment,
  [sym_table_caption] = sym_table_caption,
  [sym_footnote] = sym_footnote,
  [sym_footnote_content] = sym_footnote_content,
  [sym_div] = sym_div,
  [sym__div_marker_begin] = sym__div_marker_begin,
  [sym_class_name] = sym_class_name,
  [sym_code_block] = sym_code_block,
  [sym_raw_block] = sym_raw_block,
  [sym_raw_block_info] = sym_raw_block_info,
  [sym_code] = sym_code,
  [sym__line] = sym__line,
  [sym_thematic_break] = sym_thematic_break,
  [sym_block_quote] = sym_block_quote,
  [sym__block_quote_content] = sym__verbatim_content,
  [sym__block_quote_prefix] = sym__block_quote_prefix,
  [sym_link_reference_definition] = sym_link_reference_definition,
  [sym_block_attribute] = sym_block_attribute,
  [sym_class] = sym_class,
  [sym_key_value] = sym_key_value,
  [sym_key] = sym_key,
  [sym_value] = sym_value,
  [sym__paragraph] = sym__paragraph,
  [sym__paragraph_content] = sym__paragraph_content,
  [sym__inline] = sym__inline,
  [sym__inline_without_trailing_space] = sym__verbatim_content,
  [sym__inline_element] = sym__inline_element,
  [sym__inline_line] = sym__inline_line,
  [sym__smart_punctuation] = sym__smart_punctuation,
  [sym_autolink] = sym_autolink,
  [sym_emphasis] = sym_emphasis,
  [sym_emphasis_begin] = sym_emphasis_begin,
  [sym_strong] = sym_strong,
  [sym_strong_begin] = sym_strong_begin,
  [sym_superscript] = sym_superscript,
  [sym_superscript_begin] = sym_superscript_begin,
  [sym_subscript] = sym_subscript,
  [sym_subscript_begin] = sym_subscript_begin,
  [sym_highlighted] = sym_highlighted,
  [sym_highlighted_begin] = sym_highlighted_begin,
  [sym_insert] = sym_insert,
  [sym_insert_begin] = sym_insert_begin,
  [sym_delete] = sym_delete,
  [sym_delete_begin] = sym_delete_begin,
  [sym_footnote_reference] = sym_footnote_reference,
  [sym_footnote_marker_begin] = sym_footnote_marker_begin,
  [sym_reference_label] = sym_reference_label,
  [sym__image] = sym__image,
  [sym_full_reference_image] = sym_full_reference_image,
  [sym_collapsed_reference_image] = sym_collapsed_reference_image,
  [sym_inline_image] = sym_inline_image,
  [sym_image_description] = sym_image_description,
  [sym__image_description_begin] = sym__image_description_begin,
  [sym__link] = sym__link,
  [sym_full_reference_link] = sym_full_reference_link,
  [sym_collapsed_reference_link] = sym_collapsed_reference_link,
  [sym_inline_link] = sym_inline_link,
  [sym_link_text] = sym_link_text,
  [sym_span] = sym_span,
  [sym__bracketed_text_begin] = sym__bracketed_text_begin,
  [sym_inline_attribute] = sym_inline_attribute,
  [sym__curly_bracket_span_begin] = sym__curly_bracket_span_begin,
  [sym__link_label] = sym__link_label,
  [sym_inline_link_destination] = sym_inline_link_destination,
  [aux_sym__inline_link_url] = aux_sym__inline_link_url,
  [sym__parens_span_begin] = sym__parens_span_begin,
  [sym__comment] = sym__comment,
  [sym_inline_comment] = sym_inline_comment,
  [sym_raw_inline] = sym_raw_inline,
  [sym_raw_inline_attribute] = sym_raw_inline_attribute,
  [sym_math] = sym_math,
  [sym_verbatim] = sym_verbatim,
  [sym__todo_highlights] = sym__todo_highlights,
  [sym_todo] = sym_todo,
  [sym_note] = sym_note,
  [sym__symbol_fallback] = sym__symbol_fallback,
  [sym__curly_bracket_span_fallback] = sym__curly_bracket_span_fallback,
  [aux_sym__text] = aux_sym__text,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_frontmatter_content_repeat1] = aux_sym_frontmatter_content_repeat1,
  [aux_sym__heading_content_repeat1] = aux_sym__heading_content_repeat1,
  [aux_sym__list_dash_repeat1] = aux_sym__list_dash_repeat1,
  [aux_sym__list_plus_repeat1] = aux_sym__list_plus_repeat1,
  [aux_sym__list_star_repeat1] = aux_sym__list_star_repeat1,
  [aux_sym__list_task_repeat1] = aux_sym__list_task_repeat1,
  [aux_sym__list_definition_repeat1] = aux_sym__list_definition_repeat1,
  [aux_sym__list_item_definition_repeat1] = aux_sym__list_item_definition_repeat1,
  [aux_sym__list_decimal_period_repeat1] = aux_sym__list_decimal_period_repeat1,
  [aux_sym__list_decimal_paren_repeat1] = aux_sym__list_decimal_paren_repeat1,
  [aux_sym__list_decimal_parens_repeat1] = aux_sym__list_decimal_parens_repeat1,
  [aux_sym__list_lower_alpha_period_repeat1] = aux_sym__list_lower_alpha_period_repeat1,
  [aux_sym__list_lower_alpha_paren_repeat1] = aux_sym__list_lower_alpha_paren_repeat1,
  [aux_sym__list_lower_alpha_parens_repeat1] = aux_sym__list_lower_alpha_parens_repeat1,
  [aux_sym__list_upper_alpha_period_repeat1] = aux_sym__list_upper_alpha_period_repeat1,
  [aux_sym__list_upper_alpha_paren_repeat1] = aux_sym__list_upper_alpha_paren_repeat1,
  [aux_sym__list_upper_alpha_parens_repeat1] = aux_sym__list_upper_alpha_parens_repeat1,
  [aux_sym__list_lower_roman_period_repeat1] = aux_sym__list_lower_roman_period_repeat1,
  [aux_sym__list_lower_roman_paren_repeat1] = aux_sym__list_lower_roman_paren_repeat1,
  [aux_sym__list_lower_roman_parens_repeat1] = aux_sym__list_lower_roman_parens_repeat1,
  [aux_sym__list_upper_roman_period_repeat1] = aux_sym__list_upper_roman_period_repeat1,
  [aux_sym__list_upper_roman_paren_repeat1] = aux_sym__list_upper_roman_paren_repeat1,
  [aux_sym__list_upper_roman_parens_repeat1] = aux_sym__list_upper_roman_parens_repeat1,
  [aux_sym_list_item_content_repeat1] = aux_sym_list_item_content_repeat1,
  [aux_sym_table_repeat1] = aux_sym_table_repeat1,
  [aux_sym_table_header_repeat1] = aux_sym_table_header_repeat1,
  [aux_sym_table_separator_repeat1] = aux_sym_table_separator_repeat1,
  [aux_sym_table_caption_repeat1] = aux_sym_table_caption_repeat1,
  [aux_sym_footnote_content_repeat1] = aux_sym_footnote_content_repeat1,
  [aux_sym_div_repeat1] = aux_sym_div_repeat1,
  [aux_sym_code_repeat1] = aux_sym_code_repeat1,
  [aux_sym__block_quote_content_repeat1] = aux_sym__block_quote_content_repeat1,
  [aux_sym__block_quote_prefix_repeat1] = aux_sym__block_quote_prefix_repeat1,
  [aux_sym_block_attribute_repeat1] = aux_sym_block_attribute_repeat1,
  [aux_sym__paragraph_content_repeat1] = aux_sym__paragraph_content_repeat1,
  [aux_sym__inline_repeat1] = aux_sym__inline_repeat1,
  [aux_sym_inline_attribute_repeat1] = aux_sym_inline_attribute_repeat1,
  [aux_sym__comment_repeat1] = aux_sym__comment_repeat1,
  [alias_sym_args] = alias_sym_args,
  [anon_alias_sym_class] = anon_alias_sym_class,
  [alias_sym_comment] = alias_sym_comment,
  [alias_sym_definition] = alias_sym_definition,
  [alias_sym_language_marker] = alias_sym_language_marker,
  [alias_sym_link_label] = alias_sym_link_label,
  [alias_sym_math_marker] = alias_sym_math_marker,
  [alias_sym_math_marker_begin] = alias_sym_math_marker_begin,
  [alias_sym_math_marker_end] = alias_sym_math_marker_end,
  [alias_sym_paragraph] = alias_sym_paragraph,
  [alias_sym_raw_block_marker_begin] = alias_sym_raw_block_marker_begin,
  [alias_sym_raw_block_marker_end] = alias_sym_raw_block_marker_end,
  [alias_sym_section_content] = alias_sym_section_content,
  [alias_sym_table_cell] = alias_sym_table_cell,
  [alias_sym_verbatim_marker_begin] = alias_sym_verbatim_marker_begin,
  [alias_sym_verbatim_marker_end] = alias_sym_verbatim_marker_end,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_X] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SPACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__table_cell_alignment_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_language] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__line_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_link_destination] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__whitespace1] = {
    .visible = false,
    .named = true,
  },
  [sym_quotation_marks] = {
    .visible = true,
    .named = true,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_em_dash] = {
    .visible = true,
    .named = true,
  },
  [sym_en_dash] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash_escape] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_autolink_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_CARET] = {
    .visible = true,
    .named = false,
  },
  [sym__id] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__inline_link_url_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TODO] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WIP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INFO] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_XXX] = {
    .visible = true,
    .named = false,
  },
  [sym_fixme] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__text_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__ignored] = {
    .visible = false,
    .named = true,
  },
  [sym__block_close] = {
    .visible = false,
    .named = true,
  },
  [sym__eof_or_newline] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__newline_inline] = {
    .visible = false,
    .named = true,
  },
  [sym__non_whitespace_check] = {
    .visible = false,
    .named = true,
  },
  [sym_hard_line_break] = {
    .visible = true,
    .named = true,
  },
  [sym_frontmatter_marker] = {
    .visible = true,
    .named = true,
  },
  [sym__heading_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__heading_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__div_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__div_end] = {
    .visible = true,
    .named = true,
  },
  [sym__code_block_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__code_block_end] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_dash] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_star] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_plus] = {
    .visible = true,
    .named = true,
  },
  [sym__list_marker_task_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_list_marker_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_decimal_period] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_lower_alpha_period] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_upper_alpha_period] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_lower_roman_period] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_upper_roman_period] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_decimal_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_lower_alpha_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_upper_alpha_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_lower_roman_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_upper_roman_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_decimal_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_lower_alpha_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_upper_alpha_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_lower_roman_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_upper_roman_parens] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_continuation] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_end] = {
    .visible = false,
    .named = true,
  },
  [sym__indented_content_spacer] = {
    .visible = false,
    .named = true,
  },
  [sym__close_paragraph] = {
    .visible = false,
    .named = true,
  },
  [sym__block_quote_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__block_quote_continuation] = {
    .visible = false,
    .named = true,
  },
  [sym__thematic_break_dash] = {
    .visible = false,
    .named = true,
  },
  [sym__thematic_break_star] = {
    .visible = false,
    .named = true,
  },
  [sym__footnote_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__footnote_continuation] = {
    .visible = false,
    .named = true,
  },
  [sym__footnote_end] = {
    .visible = false,
    .named = true,
  },
  [sym__link_ref_def_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__link_ref_def_label_end] = {
    .visible = false,
    .named = true,
  },
  [sym__table_header_begin] = {
    .visible = true,
    .named = false,
  },
  [sym__table_separator_begin] = {
    .visible = true,
    .named = false,
  },
  [sym__table_row_begin] = {
    .visible = true,
    .named = false,
  },
  [sym__table_row_end_newline] = {
    .visible = false,
    .named = true,
  },
  [sym__table_cell_end] = {
    .visible = true,
    .named = false,
  },
  [sym__table_caption_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__table_caption_end] = {
    .visible = false,
    .named = true,
  },
  [sym__block_attribute_begin] = {
    .visible = true,
    .named = false,
  },
  [sym__comment_end_marker] = {
    .visible = true,
    .named = false,
  },
  [sym__comment_close] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_comment_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__verbatim_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_end] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_content] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_emphasis_end] = {
    .visible = true,
    .named = true,
  },
  [sym__strong_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_strong_end] = {
    .visible = true,
    .named = true,
  },
  [sym__superscript_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_superscript_end] = {
    .visible = true,
    .named = true,
  },
  [sym__subscript_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_subscript_end] = {
    .visible = true,
    .named = true,
  },
  [sym__highlighted_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_highlighted_end] = {
    .visible = true,
    .named = true,
  },
  [sym__insert_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_insert_end] = {
    .visible = true,
    .named = true,
  },
  [sym__delete_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_delete_end] = {
    .visible = true,
    .named = true,
  },
  [sym__parens_span_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__parens_span_end] = {
    .visible = true,
    .named = false,
  },
  [sym__curly_bracket_span_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__curly_bracket_span_end] = {
    .visible = true,
    .named = false,
  },
  [sym__square_bracket_span_mark_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__square_bracket_span_end] = {
    .visible = true,
    .named = false,
  },
  [sym__in_fallback] = {
    .visible = false,
    .named = true,
  },
  [sym__error] = {
    .visible = false,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_frontmatter] = {
    .visible = true,
    .named = true,
  },
  [sym_frontmatter_content] = {
    .visible = true,
    .named = true,
  },
  [sym__block_with_section] = {
    .visible = false,
    .named = true,
  },
  [sym__block_with_heading] = {
    .visible = false,
    .named = true,
  },
  [sym__block_element] = {
    .visible = false,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym_heading] = {
    .visible = true,
    .named = true,
  },
  [sym__heading_content] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_dash] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_dash] = {
    .visible = true,
    .named = true,
  },
  [sym__list_plus] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_plus] = {
    .visible = true,
    .named = true,
  },
  [sym__list_star] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_star] = {
    .visible = true,
    .named = true,
  },
  [sym__list_task] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_task] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_task] = {
    .visible = true,
    .named = true,
  },
  [sym_checked] = {
    .visible = true,
    .named = true,
  },
  [sym_unchecked] = {
    .visible = true,
    .named = true,
  },
  [sym__list_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__list_decimal_period] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_decimal_period] = {
    .visible = true,
    .named = true,
  },
  [sym__list_decimal_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_decimal_paren] = {
    .visible = true,
    .named = true,
  },
  [sym__list_decimal_parens] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_decimal_parens] = {
    .visible = true,
    .named = true,
  },
  [sym__list_lower_alpha_period] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_lower_alpha_period] = {
    .visible = true,
    .named = true,
  },
  [sym__list_lower_alpha_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_lower_alpha_paren] = {
    .visible = true,
    .named = true,
  },
  [sym__list_lower_alpha_parens] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_lower_alpha_parens] = {
    .visible = true,
    .named = true,
  },
  [sym__list_upper_alpha_period] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_upper_alpha_period] = {
    .visible = true,
    .named = true,
  },
  [sym__list_upper_alpha_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_upper_alpha_paren] = {
    .visible = true,
    .named = true,
  },
  [sym__list_upper_alpha_parens] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_upper_alpha_parens] = {
    .visible = true,
    .named = true,
  },
  [sym__list_lower_roman_period] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_lower_roman_period] = {
    .visible = true,
    .named = true,
  },
  [sym__list_lower_roman_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_lower_roman_paren] = {
    .visible = true,
    .named = true,
  },
  [sym__list_lower_roman_parens] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_lower_roman_parens] = {
    .visible = true,
    .named = true,
  },
  [sym__list_upper_roman_period] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_upper_roman_period] = {
    .visible = true,
    .named = true,
  },
  [sym__list_upper_roman_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_upper_roman_paren] = {
    .visible = true,
    .named = true,
  },
  [sym__list_upper_roman_parens] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item_upper_roman_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_list_item_content] = {
    .visible = true,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym__table_row] = {
    .visible = false,
    .named = true,
  },
  [sym_table_header] = {
    .visible = true,
    .named = true,
  },
  [sym_table_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_table_row] = {
    .visible = true,
    .named = true,
  },
  [sym__table_cell] = {
    .visible = false,
    .named = true,
  },
  [sym__table_cell_alignment] = {
    .visible = false,
    .named = true,
  },
  [sym_table_caption] = {
    .visible = true,
    .named = true,
  },
  [sym_footnote] = {
    .visible = true,
    .named = true,
  },
  [sym_footnote_content] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym__div_marker_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_class_name] = {
    .visible = true,
    .named = true,
  },
  [sym_code_block] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_block] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_block_info] = {
    .visible = true,
    .named = true,
  },
  [sym_code] = {
    .visible = true,
    .named = true,
  },
  [sym__line] = {
    .visible = false,
    .named = true,
  },
  [sym_thematic_break] = {
    .visible = true,
    .named = true,
  },
  [sym_block_quote] = {
    .visible = true,
    .named = true,
  },
  [sym__block_quote_content] = {
    .visible = true,
    .named = true,
  },
  [sym__block_quote_prefix] = {
    .visible = false,
    .named = true,
  },
  [sym_link_reference_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_block_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_key] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym__paragraph] = {
    .visible = false,
    .named = true,
  },
  [sym__paragraph_content] = {
    .visible = true,
    .named = true,
  },
  [sym__inline] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_without_trailing_space] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_element] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_line] = {
    .visible = false,
    .named = true,
  },
  [sym__smart_punctuation] = {
    .visible = false,
    .named = true,
  },
  [sym_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym_emphasis] = {
    .visible = true,
    .named = true,
  },
  [sym_emphasis_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_strong] = {
    .visible = true,
    .named = true,
  },
  [sym_strong_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_superscript] = {
    .visible = true,
    .named = true,
  },
  [sym_superscript_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_highlighted] = {
    .visible = true,
    .named = true,
  },
  [sym_highlighted_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_insert] = {
    .visible = true,
    .named = true,
  },
  [sym_insert_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_delete] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_footnote_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_footnote_marker_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_label] = {
    .visible = true,
    .named = true,
  },
  [sym__image] = {
    .visible = false,
    .named = true,
  },
  [sym_full_reference_image] = {
    .visible = true,
    .named = true,
  },
  [sym_collapsed_reference_image] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_image] = {
    .visible = true,
    .named = true,
  },
  [sym_image_description] = {
    .visible = true,
    .named = true,
  },
  [sym__image_description_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__link] = {
    .visible = false,
    .named = true,
  },
  [sym_full_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_collapsed_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_link] = {
    .visible = true,
    .named = true,
  },
  [sym_link_text] = {
    .visible = true,
    .named = true,
  },
  [sym_span] = {
    .visible = true,
    .named = true,
  },
  [sym__bracketed_text_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_inline_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__curly_bracket_span_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__link_label] = {
    .visible = false,
    .named = true,
  },
  [sym_inline_link_destination] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__inline_link_url] = {
    .visible = false,
    .named = false,
  },
  [sym__parens_span_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [sym_inline_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_inline_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_math] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim] = {
    .visible = true,
    .named = true,
  },
  [sym__todo_highlights] = {
    .visible = false,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_note] = {
    .visible = true,
    .named = true,
  },
  [sym__symbol_fallback] = {
    .visible = false,
    .named = true,
  },
  [sym__curly_bracket_span_fallback] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__text] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_frontmatter_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__heading_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_dash_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_plus_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_star_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_task_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_item_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_decimal_period_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_decimal_paren_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_decimal_parens_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_lower_alpha_period_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_lower_alpha_paren_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_lower_alpha_parens_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_upper_alpha_period_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_upper_alpha_paren_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_upper_alpha_parens_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_lower_roman_period_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_lower_roman_paren_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_lower_roman_parens_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_upper_roman_period_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_upper_roman_paren_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_upper_roman_parens_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_item_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_header_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_separator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_caption_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_footnote_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_div_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__block_quote_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__block_quote_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paragraph_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inline_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_args] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_class] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_comment] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_definition] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_language_marker] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_link_label] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_math_marker] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_math_marker_begin] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_math_marker_end] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_raw_block_marker_begin] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_raw_block_marker_end] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_section_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_table_cell] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_verbatim_marker_begin] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_verbatim_marker_end] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_args = 1,
  field_attribute = 2,
  field_begin_marker = 3,
  field_checkmark = 4,
  field_class = 5,
  field_code = 6,
  field_content = 7,
  field_definition = 8,
  field_description = 9,
  field_destination = 10,
  field_end_marker = 11,
  field_heading = 12,
  field_info = 13,
  field_key = 14,
  field_label = 15,
  field_language = 16,
  field_marker = 17,
  field_math_marker = 18,
  field_term = 19,
  field_text = 20,
  field_value = 21,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_args] = "args",
  [field_attribute] = "attribute",
  [field_begin_marker] = "begin_marker",
  [field_checkmark] = "checkmark",
  [field_class] = "class",
  [field_code] = "code",
  [field_content] = "content",
  [field_definition] = "definition",
  [field_description] = "description",
  [field_destination] = "destination",
  [field_end_marker] = "end_marker",
  [field_heading] = "heading",
  [field_info] = "info",
  [field_key] = "key",
  [field_label] = "label",
  [field_language] = "language",
  [field_marker] = "marker",
  [field_math_marker] = "math_marker",
  [field_term] = "term",
  [field_text] = "text",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 3},
  [4] = {.index = 5, .length = 1},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 1},
  [8] = {.index = 10, .length = 1},
  [9] = {.index = 5, .length = 1},
  [10] = {.index = 11, .length = 1},
  [11] = {.index = 12, .length = 2},
  [12] = {.index = 14, .length = 2},
  [13] = {.index = 16, .length = 1},
  [14] = {.index = 17, .length = 2},
  [15] = {.index = 19, .length = 2},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 3},
  [18] = {.index = 26, .length = 1},
  [19] = {.index = 27, .length = 1},
  [20] = {.index = 28, .length = 1},
  [21] = {.index = 5, .length = 1},
  [23] = {.index = 29, .length = 3},
  [24] = {.index = 32, .length = 2},
  [25] = {.index = 34, .length = 1},
  [26] = {.index = 35, .length = 2},
  [27] = {.index = 37, .length = 1},
  [28] = {.index = 38, .length = 2},
  [29] = {.index = 40, .length = 3},
  [30] = {.index = 28, .length = 1},
  [31] = {.index = 43, .length = 2},
  [32] = {.index = 45, .length = 1},
  [33] = {.index = 46, .length = 4},
  [34] = {.index = 50, .length = 4},
  [35] = {.index = 54, .length = 2},
  [36] = {.index = 56, .length = 2},
  [37] = {.index = 58, .length = 1},
  [38] = {.index = 59, .length = 4},
  [39] = {.index = 59, .length = 4},
  [41] = {.index = 63, .length = 2},
  [42] = {.index = 23, .length = 3},
  [44] = {.index = 65, .length = 1},
  [45] = {.index = 66, .length = 1},
  [46] = {.index = 67, .length = 1},
  [47] = {.index = 68, .length = 4},
  [48] = {.index = 72, .length = 1},
  [49] = {.index = 73, .length = 3},
  [50] = {.index = 76, .length = 1},
  [51] = {.index = 77, .length = 2},
  [52] = {.index = 79, .length = 2},
  [53] = {.index = 81, .length = 2},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 2},
  [56] = {.index = 67, .length = 1},
  [57] = {.index = 86, .length = 2},
  [58] = {.index = 79, .length = 2},
  [59] = {.index = 88, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_content, 0, .inherited = true},
    {field_marker, 0, .inherited = true},
  [2] =
    {field_definition, 0, .inherited = true},
    {field_marker, 0, .inherited = true},
    {field_term, 0, .inherited = true},
  [5] =
    {field_attribute, 0, .inherited = true},
  [6] =
    {field_attribute, 1},
  [7] =
    {field_content, 1},
    {field_marker, 0},
  [9] =
    {field_content, 0, .inherited = true},
  [10] =
    {field_heading, 0},
  [11] =
    {field_description, 0},
  [12] =
    {field_description, 0},
    {field_label, 1, .inherited = true},
  [14] =
    {field_description, 0},
    {field_destination, 1},
  [16] =
    {field_text, 0},
  [17] =
    {field_label, 1, .inherited = true},
    {field_text, 0},
  [19] =
    {field_destination, 1},
    {field_text, 0},
  [21] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [23] =
    {field_attribute, 1, .inherited = true},
    {field_content, 1},
    {field_marker, 0},
  [26] =
    {field_class, 2},
  [27] =
    {field_checkmark, 1},
  [28] =
    {field_content, 1},
  [29] =
    {field_begin_marker, 0},
    {field_content, 1},
    {field_end_marker, 2},
  [32] =
    {field_content, 1},
    {field_heading, 0},
  [34] =
    {field_class, 0, .inherited = true},
  [35] =
    {field_content, 2},
    {field_marker, 1},
  [37] =
    {field_attribute, 1, .inherited = true},
  [38] =
    {field_language, 1},
    {field_marker, 0},
  [40] =
    {field_attribute, 1, .inherited = true},
    {field_marker, 0},
    {field_term, 1},
  [43] =
    {field_key, 0},
    {field_value, 2},
  [45] =
    {field_args, 1},
  [46] =
    {field_attribute, 3},
    {field_begin_marker, 0},
    {field_content, 1},
    {field_end_marker, 2},
  [50] =
    {field_begin_marker, 1},
    {field_content, 2},
    {field_end_marker, 3},
    {field_math_marker, 0},
  [54] =
    {field_class, 0, .inherited = true},
    {field_content, 2},
  [56] =
    {field_attribute, 1, .inherited = true},
    {field_attribute, 2, .inherited = true},
  [58] =
    {field_attribute, 2, .inherited = true},
  [59] =
    {field_attribute, 2, .inherited = true},
    {field_begin_marker, 0},
    {field_content, 2},
    {field_end_marker, 3},
  [63] =
    {field_attribute, 1, .inherited = true},
    {field_label, 1},
  [65] =
    {field_code, 3},
  [66] =
    {field_language, 2},
  [67] =
    {field_info, 2},
  [68] =
    {field_attribute, 1, .inherited = true},
    {field_definition, 3},
    {field_marker, 0},
    {field_term, 1},
  [72] =
    {field_content, 3, .inherited = true},
  [73] =
    {field_attribute, 2, .inherited = true},
    {field_attribute, 4},
    {field_content, 2},
  [76] =
    {field_content, 3},
  [77] =
    {field_code, 4},
    {field_language, 2},
  [79] =
    {field_content, 4},
    {field_info, 2},
  [81] =
    {field_content, 5},
    {field_label, 2},
  [83] =
    {field_language, 1},
  [84] =
    {field_content, 4},
    {field_language, 2},
  [86] =
    {field_attribute, 2, .inherited = true},
    {field_label, 2},
  [88] =
    {field_attribute, 2, .inherited = true},
    {field_destination, 7},
    {field_label, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym__block_quote_begin,
  },
  [7] = {
    [0] = alias_sym_comment,
  },
  [9] = {
    [0] = alias_sym_paragraph,
  },
  [21] = {
    [0] = alias_sym_table_cell,
  },
  [22] = {
    [1] = anon_alias_sym_class,
  },
  [23] = {
    [0] = alias_sym_verbatim_marker_begin,
    [2] = alias_sym_verbatim_marker_end,
  },
  [24] = {
    [1] = alias_sym_section_content,
  },
  [28] = {
    [0] = alias_sym_language_marker,
  },
  [30] = {
    [1] = sym__verbatim_content,
  },
  [32] = {
    [1] = alias_sym_args,
  },
  [34] = {
    [0] = alias_sym_math_marker,
    [1] = alias_sym_math_marker_begin,
    [3] = alias_sym_math_marker_end,
  },
  [35] = {
    [2] = sym__verbatim_content,
  },
  [39] = {
    [2] = sym__verbatim_content,
  },
  [40] = {
    [3] = anon_sym_RBRACK_COLON,
  },
  [41] = {
    [1] = alias_sym_link_label,
  },
  [42] = {
    [1] = sym__verbatim_content,
  },
  [43] = {
    [2] = alias_sym_args,
  },
  [46] = {
    [0] = alias_sym_raw_block_marker_begin,
  },
  [47] = {
    [3] = alias_sym_definition,
  },
  [49] = {
    [2] = sym__verbatim_content,
  },
  [52] = {
    [0] = alias_sym_raw_block_marker_begin,
    [4] = sym__verbatim_content,
  },
  [56] = {
    [0] = alias_sym_raw_block_marker_begin,
    [5] = alias_sym_raw_block_marker_end,
  },
  [57] = {
    [2] = alias_sym_link_label,
  },
  [58] = {
    [0] = alias_sym_raw_block_marker_begin,
    [4] = sym__verbatim_content,
    [6] = alias_sym_raw_block_marker_end,
  },
  [59] = {
    [2] = alias_sym_link_label,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_class_name, 2,
    sym_class_name,
    anon_alias_sym_class,
  sym_code, 2,
    sym_code,
    sym__verbatim_content,
  sym__paragraph_content, 2,
    sym__paragraph_content,
    alias_sym_paragraph,
  sym__inline, 4,
    sym__inline,
    alias_sym_link_label,
    alias_sym_table_cell,
    sym__verbatim_content,
  sym__comment, 2,
    sym__comment,
    alias_sym_comment,
  aux_sym_document_repeat1, 2,
    aux_sym_document_repeat1,
    alias_sym_section_content,
  aux_sym__list_item_definition_repeat1, 2,
    aux_sym__list_item_definition_repeat1,
    alias_sym_definition,
  aux_sym_table_caption_repeat1, 2,
    aux_sym_table_caption_repeat1,
    sym__verbatim_content,
  aux_sym_div_repeat1, 2,
    aux_sym_div_repeat1,
    sym__verbatim_content,
  aux_sym_block_attribute_repeat1, 2,
    aux_sym_block_attribute_repeat1,
    alias_sym_args,
  aux_sym_inline_attribute_repeat1, 2,
    aux_sym_inline_attribute_repeat1,
    alias_sym_args,
  aux_sym__comment_repeat1, 2,
    aux_sym__comment_repeat1,
    sym__verbatim_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 7,
  [9] = 4,
  [10] = 5,
  [11] = 11,
  [12] = 12,
  [13] = 11,
  [14] = 14,
  [15] = 12,
  [16] = 11,
  [17] = 12,
  [18] = 11,
  [19] = 12,
  [20] = 11,
  [21] = 12,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 46,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 46,
  [58] = 58,
  [59] = 59,
  [60] = 46,
  [61] = 61,
  [62] = 62,
  [63] = 46,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 70,
  [73] = 73,
  [74] = 73,
  [75] = 70,
  [76] = 70,
  [77] = 73,
  [78] = 73,
  [79] = 73,
  [80] = 80,
  [81] = 81,
  [82] = 81,
  [83] = 83,
  [84] = 83,
  [85] = 81,
  [86] = 81,
  [87] = 83,
  [88] = 83,
  [89] = 81,
  [90] = 83,
  [91] = 91,
  [92] = 91,
  [93] = 91,
  [94] = 91,
  [95] = 91,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 98,
  [100] = 98,
  [101] = 98,
  [102] = 98,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 105,
  [107] = 103,
  [108] = 108,
  [109] = 109,
  [110] = 103,
  [111] = 108,
  [112] = 104,
  [113] = 104,
  [114] = 105,
  [115] = 103,
  [116] = 103,
  [117] = 108,
  [118] = 105,
  [119] = 108,
  [120] = 104,
  [121] = 105,
  [122] = 122,
  [123] = 104,
  [124] = 108,
  [125] = 125,
  [126] = 125,
  [127] = 127,
  [128] = 125,
  [129] = 125,
  [130] = 127,
  [131] = 127,
  [132] = 125,
  [133] = 127,
  [134] = 134,
  [135] = 135,
  [136] = 134,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 140,
  [143] = 141,
  [144] = 140,
  [145] = 145,
  [146] = 140,
  [147] = 141,
  [148] = 140,
  [149] = 141,
  [150] = 140,
  [151] = 141,
  [152] = 140,
  [153] = 141,
  [154] = 154,
  [155] = 140,
  [156] = 141,
  [157] = 140,
  [158] = 141,
  [159] = 140,
  [160] = 141,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 138,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 145,
  [170] = 141,
  [171] = 140,
  [172] = 172,
  [173] = 154,
  [174] = 161,
  [175] = 162,
  [176] = 163,
  [177] = 164,
  [178] = 138,
  [179] = 166,
  [180] = 167,
  [181] = 139,
  [182] = 182,
  [183] = 154,
  [184] = 161,
  [185] = 162,
  [186] = 163,
  [187] = 164,
  [188] = 138,
  [189] = 166,
  [190] = 167,
  [191] = 154,
  [192] = 161,
  [193] = 162,
  [194] = 163,
  [195] = 164,
  [196] = 138,
  [197] = 166,
  [198] = 167,
  [199] = 139,
  [200] = 161,
  [201] = 162,
  [202] = 163,
  [203] = 164,
  [204] = 138,
  [205] = 166,
  [206] = 167,
  [207] = 154,
  [208] = 161,
  [209] = 162,
  [210] = 163,
  [211] = 164,
  [212] = 138,
  [213] = 166,
  [214] = 167,
  [215] = 154,
  [216] = 161,
  [217] = 162,
  [218] = 163,
  [219] = 164,
  [220] = 138,
  [221] = 166,
  [222] = 167,
  [223] = 154,
  [224] = 161,
  [225] = 162,
  [226] = 163,
  [227] = 164,
  [228] = 138,
  [229] = 166,
  [230] = 167,
  [231] = 154,
  [232] = 161,
  [233] = 162,
  [234] = 163,
  [235] = 164,
  [236] = 138,
  [237] = 166,
  [238] = 167,
  [239] = 154,
  [240] = 161,
  [241] = 162,
  [242] = 163,
  [243] = 164,
  [244] = 138,
  [245] = 166,
  [246] = 167,
  [247] = 154,
  [248] = 161,
  [249] = 162,
  [250] = 163,
  [251] = 164,
  [252] = 166,
  [253] = 167,
  [254] = 154,
  [255] = 161,
  [256] = 162,
  [257] = 163,
  [258] = 164,
  [259] = 138,
  [260] = 166,
  [261] = 167,
  [262] = 154,
  [263] = 161,
  [264] = 162,
  [265] = 163,
  [266] = 164,
  [267] = 138,
  [268] = 166,
  [269] = 167,
  [270] = 168,
  [271] = 168,
  [272] = 168,
  [273] = 168,
  [274] = 168,
  [275] = 168,
  [276] = 168,
  [277] = 168,
  [278] = 168,
  [279] = 168,
  [280] = 168,
  [281] = 168,
  [282] = 139,
  [283] = 139,
  [284] = 154,
  [285] = 141,
  [286] = 286,
  [287] = 286,
  [288] = 288,
  [289] = 288,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 292,
  [300] = 294,
  [301] = 291,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 306,
  [310] = 302,
  [311] = 311,
  [312] = 312,
  [313] = 293,
  [314] = 304,
  [315] = 311,
  [316] = 305,
  [317] = 295,
  [318] = 296,
  [319] = 312,
  [320] = 297,
  [321] = 307,
  [322] = 303,
  [323] = 308,
  [324] = 298,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 326,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 325,
  [356] = 356,
  [357] = 357,
  [358] = 332,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 360,
  [365] = 362,
  [366] = 366,
  [367] = 367,
  [368] = 327,
  [369] = 330,
  [370] = 333,
  [371] = 334,
  [372] = 335,
  [373] = 337,
  [374] = 374,
  [375] = 338,
  [376] = 339,
  [377] = 340,
  [378] = 341,
  [379] = 342,
  [380] = 343,
  [381] = 344,
  [382] = 345,
  [383] = 346,
  [384] = 384,
  [385] = 347,
  [386] = 348,
  [387] = 349,
  [388] = 350,
  [389] = 351,
  [390] = 352,
  [391] = 391,
  [392] = 354,
  [393] = 393,
  [394] = 394,
  [395] = 356,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 357,
  [400] = 400,
  [401] = 374,
  [402] = 402,
  [403] = 328,
  [404] = 404,
  [405] = 405,
  [406] = 366,
  [407] = 407,
  [408] = 408,
  [409] = 407,
  [410] = 353,
  [411] = 411,
  [412] = 363,
  [413] = 413,
  [414] = 367,
  [415] = 391,
  [416] = 393,
  [417] = 396,
  [418] = 397,
  [419] = 398,
  [420] = 400,
  [421] = 402,
  [422] = 404,
  [423] = 405,
  [424] = 408,
  [425] = 411,
  [426] = 413,
  [427] = 336,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 429,
  [432] = 432,
  [433] = 429,
  [434] = 432,
  [435] = 430,
  [436] = 430,
  [437] = 437,
  [438] = 437,
  [439] = 437,
  [440] = 437,
  [441] = 437,
  [442] = 437,
  [443] = 437,
  [444] = 437,
  [445] = 437,
  [446] = 437,
  [447] = 437,
  [448] = 437,
  [449] = 449,
  [450] = 449,
  [451] = 451,
  [452] = 451,
  [453] = 449,
  [454] = 451,
  [455] = 449,
  [456] = 451,
  [457] = 449,
  [458] = 451,
  [459] = 449,
  [460] = 451,
  [461] = 451,
  [462] = 449,
  [463] = 449,
  [464] = 451,
  [465] = 449,
  [466] = 437,
  [467] = 451,
  [468] = 451,
  [469] = 449,
  [470] = 451,
  [471] = 449,
  [472] = 449,
  [473] = 451,
  [474] = 474,
  [475] = 474,
  [476] = 474,
  [477] = 474,
  [478] = 474,
  [479] = 474,
  [480] = 474,
  [481] = 474,
  [482] = 474,
  [483] = 451,
  [484] = 449,
  [485] = 474,
  [486] = 474,
  [487] = 474,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 490,
  [492] = 492,
  [493] = 492,
  [494] = 490,
  [495] = 492,
  [496] = 492,
  [497] = 497,
  [498] = 498,
  [499] = 489,
  [500] = 497,
  [501] = 497,
  [502] = 498,
  [503] = 498,
  [504] = 489,
  [505] = 490,
  [506] = 489,
  [507] = 488,
  [508] = 488,
  [509] = 488,
  [510] = 490,
  [511] = 497,
  [512] = 492,
  [513] = 492,
  [514] = 492,
  [515] = 490,
  [516] = 492,
  [517] = 497,
  [518] = 498,
  [519] = 489,
  [520] = 488,
  [521] = 497,
  [522] = 498,
  [523] = 497,
  [524] = 490,
  [525] = 489,
  [526] = 492,
  [527] = 498,
  [528] = 490,
  [529] = 497,
  [530] = 497,
  [531] = 498,
  [532] = 489,
  [533] = 488,
  [534] = 498,
  [535] = 474,
  [536] = 489,
  [537] = 490,
  [538] = 492,
  [539] = 488,
  [540] = 489,
  [541] = 488,
  [542] = 497,
  [543] = 498,
  [544] = 489,
  [545] = 488,
  [546] = 488,
  [547] = 490,
  [548] = 498,
  [549] = 490,
  [550] = 492,
  [551] = 498,
  [552] = 489,
  [553] = 488,
  [554] = 497,
  [555] = 498,
  [556] = 489,
  [557] = 488,
  [558] = 490,
  [559] = 492,
  [560] = 497,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 569,
  [572] = 570,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 561,
  [589] = 568,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 575,
  [594] = 562,
  [595] = 563,
  [596] = 564,
  [597] = 565,
  [598] = 566,
  [599] = 567,
  [600] = 569,
  [601] = 570,
  [602] = 573,
  [603] = 574,
  [604] = 576,
  [605] = 577,
  [606] = 578,
  [607] = 579,
  [608] = 580,
  [609] = 581,
  [610] = 582,
  [611] = 583,
  [612] = 584,
  [613] = 585,
  [614] = 586,
  [615] = 587,
  [616] = 561,
  [617] = 568,
  [618] = 590,
  [619] = 591,
  [620] = 575,
  [621] = 562,
  [622] = 563,
  [623] = 564,
  [624] = 565,
  [625] = 566,
  [626] = 567,
  [627] = 569,
  [628] = 570,
  [629] = 573,
  [630] = 574,
  [631] = 576,
  [632] = 577,
  [633] = 578,
  [634] = 579,
  [635] = 580,
  [636] = 581,
  [637] = 582,
  [638] = 583,
  [639] = 584,
  [640] = 585,
  [641] = 586,
  [642] = 587,
  [643] = 561,
  [644] = 568,
  [645] = 590,
  [646] = 591,
  [647] = 575,
  [648] = 573,
  [649] = 562,
  [650] = 563,
  [651] = 564,
  [652] = 565,
  [653] = 566,
  [654] = 567,
  [655] = 574,
  [656] = 590,
  [657] = 569,
  [658] = 570,
  [659] = 573,
  [660] = 574,
  [661] = 576,
  [662] = 577,
  [663] = 578,
  [664] = 579,
  [665] = 580,
  [666] = 581,
  [667] = 582,
  [668] = 583,
  [669] = 584,
  [670] = 585,
  [671] = 586,
  [672] = 587,
  [673] = 561,
  [674] = 591,
  [675] = 576,
  [676] = 577,
  [677] = 568,
  [678] = 590,
  [679] = 591,
  [680] = 578,
  [681] = 579,
  [682] = 580,
  [683] = 575,
  [684] = 581,
  [685] = 562,
  [686] = 563,
  [687] = 564,
  [688] = 565,
  [689] = 566,
  [690] = 567,
  [691] = 582,
  [692] = 583,
  [693] = 584,
  [694] = 569,
  [695] = 570,
  [696] = 573,
  [697] = 574,
  [698] = 576,
  [699] = 577,
  [700] = 578,
  [701] = 579,
  [702] = 580,
  [703] = 581,
  [704] = 582,
  [705] = 583,
  [706] = 584,
  [707] = 585,
  [708] = 586,
  [709] = 587,
  [710] = 568,
  [711] = 590,
  [712] = 591,
  [713] = 575,
  [714] = 562,
  [715] = 563,
  [716] = 564,
  [717] = 565,
  [718] = 566,
  [719] = 567,
  [720] = 569,
  [721] = 570,
  [722] = 573,
  [723] = 574,
  [724] = 576,
  [725] = 577,
  [726] = 578,
  [727] = 579,
  [728] = 580,
  [729] = 581,
  [730] = 582,
  [731] = 583,
  [732] = 584,
  [733] = 585,
  [734] = 586,
  [735] = 587,
  [736] = 561,
  [737] = 568,
  [738] = 590,
  [739] = 591,
  [740] = 575,
  [741] = 585,
  [742] = 562,
  [743] = 563,
  [744] = 564,
  [745] = 575,
  [746] = 566,
  [747] = 567,
  [748] = 586,
  [749] = 569,
  [750] = 570,
  [751] = 573,
  [752] = 574,
  [753] = 576,
  [754] = 577,
  [755] = 578,
  [756] = 579,
  [757] = 580,
  [758] = 581,
  [759] = 582,
  [760] = 583,
  [761] = 584,
  [762] = 585,
  [763] = 586,
  [764] = 587,
  [765] = 561,
  [766] = 568,
  [767] = 590,
  [768] = 591,
  [769] = 575,
  [770] = 562,
  [771] = 563,
  [772] = 564,
  [773] = 565,
  [774] = 566,
  [775] = 567,
  [776] = 587,
  [777] = 569,
  [778] = 570,
  [779] = 573,
  [780] = 574,
  [781] = 576,
  [782] = 577,
  [783] = 578,
  [784] = 579,
  [785] = 580,
  [786] = 581,
  [787] = 582,
  [788] = 583,
  [789] = 584,
  [790] = 585,
  [791] = 586,
  [792] = 587,
  [793] = 568,
  [794] = 590,
  [795] = 591,
  [796] = 575,
  [797] = 562,
  [798] = 563,
  [799] = 564,
  [800] = 565,
  [801] = 566,
  [802] = 567,
  [803] = 569,
  [804] = 570,
  [805] = 573,
  [806] = 574,
  [807] = 576,
  [808] = 577,
  [809] = 578,
  [810] = 579,
  [811] = 580,
  [812] = 581,
  [813] = 582,
  [814] = 583,
  [815] = 584,
  [816] = 585,
  [817] = 586,
  [818] = 587,
  [819] = 562,
  [820] = 497,
  [821] = 498,
  [822] = 489,
  [823] = 488,
  [824] = 563,
  [825] = 564,
  [826] = 490,
  [827] = 492,
  [828] = 565,
  [829] = 566,
  [830] = 567,
  [831] = 561,
  [832] = 561,
  [833] = 568,
  [834] = 590,
  [835] = 591,
  [836] = 432,
  [837] = 575,
  [838] = 562,
  [839] = 563,
  [840] = 564,
  [841] = 565,
  [842] = 566,
  [843] = 567,
  [844] = 429,
  [845] = 845,
  [846] = 569,
  [847] = 570,
  [848] = 573,
  [849] = 574,
  [850] = 576,
  [851] = 577,
  [852] = 578,
  [853] = 579,
  [854] = 580,
  [855] = 581,
  [856] = 582,
  [857] = 583,
  [858] = 584,
  [859] = 585,
  [860] = 586,
  [861] = 587,
  [862] = 561,
  [863] = 568,
  [864] = 590,
  [865] = 591,
  [866] = 575,
  [867] = 562,
  [868] = 563,
  [869] = 564,
  [870] = 565,
  [871] = 566,
  [872] = 567,
  [873] = 569,
  [874] = 570,
  [875] = 573,
  [876] = 574,
  [877] = 576,
  [878] = 577,
  [879] = 578,
  [880] = 579,
  [881] = 580,
  [882] = 581,
  [883] = 582,
  [884] = 583,
  [885] = 584,
  [886] = 585,
  [887] = 586,
  [888] = 587,
  [889] = 568,
  [890] = 590,
  [891] = 591,
  [892] = 565,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 893,
  [899] = 893,
  [900] = 900,
  [901] = 895,
  [902] = 568,
  [903] = 590,
  [904] = 591,
  [905] = 896,
  [906] = 906,
  [907] = 575,
  [908] = 895,
  [909] = 562,
  [910] = 563,
  [911] = 564,
  [912] = 565,
  [913] = 566,
  [914] = 567,
  [915] = 900,
  [916] = 569,
  [917] = 570,
  [918] = 573,
  [919] = 574,
  [920] = 576,
  [921] = 577,
  [922] = 578,
  [923] = 579,
  [924] = 580,
  [925] = 581,
  [926] = 582,
  [927] = 583,
  [928] = 584,
  [929] = 585,
  [930] = 586,
  [931] = 587,
  [932] = 932,
  [933] = 906,
  [934] = 430,
  [935] = 932,
  [936] = 894,
  [937] = 894,
  [938] = 897,
  [939] = 895,
  [940] = 900,
  [941] = 932,
  [942] = 896,
  [943] = 894,
  [944] = 932,
  [945] = 894,
  [946] = 896,
  [947] = 897,
  [948] = 897,
  [949] = 896,
  [950] = 906,
  [951] = 932,
  [952] = 906,
  [953] = 897,
  [954] = 894,
  [955] = 906,
  [956] = 896,
  [957] = 896,
  [958] = 895,
  [959] = 959,
  [960] = 896,
  [961] = 932,
  [962] = 932,
  [963] = 906,
  [964] = 964,
  [965] = 893,
  [966] = 894,
  [967] = 893,
  [968] = 895,
  [969] = 897,
  [970] = 896,
  [971] = 897,
  [972] = 893,
  [973] = 893,
  [974] = 895,
  [975] = 906,
  [976] = 895,
  [977] = 895,
  [978] = 900,
  [979] = 932,
  [980] = 894,
  [981] = 906,
  [982] = 900,
  [983] = 932,
  [984] = 894,
  [985] = 932,
  [986] = 897,
  [987] = 894,
  [988] = 959,
  [989] = 897,
  [990] = 897,
  [991] = 893,
  [992] = 897,
  [993] = 906,
  [994] = 893,
  [995] = 895,
  [996] = 896,
  [997] = 900,
  [998] = 906,
  [999] = 900,
  [1000] = 906,
  [1001] = 896,
  [1002] = 893,
  [1003] = 932,
  [1004] = 894,
  [1005] = 896,
  [1006] = 895,
  [1007] = 1007,
  [1008] = 894,
  [1009] = 964,
  [1010] = 906,
  [1011] = 895,
  [1012] = 897,
  [1013] = 561,
  [1014] = 900,
  [1015] = 893,
  [1016] = 893,
  [1017] = 900,
  [1018] = 561,
  [1019] = 561,
  [1020] = 932,
  [1021] = 900,
  [1022] = 900,
  [1023] = 893,
  [1024] = 906,
  [1025] = 894,
  [1026] = 895,
  [1027] = 897,
  [1028] = 896,
  [1029] = 932,
  [1030] = 134,
  [1031] = 134,
  [1032] = 145,
  [1033] = 134,
  [1034] = 145,
  [1035] = 145,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1037,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1036,
  [1043] = 1038,
  [1044] = 1036,
  [1045] = 1038,
  [1046] = 1036,
  [1047] = 1038,
  [1048] = 1048,
  [1049] = 1038,
  [1050] = 1036,
  [1051] = 1038,
  [1052] = 1036,
  [1053] = 1038,
  [1054] = 1036,
  [1055] = 1038,
  [1056] = 1036,
  [1057] = 1038,
  [1058] = 1036,
  [1059] = 1038,
  [1060] = 1036,
  [1061] = 1038,
  [1062] = 1036,
  [1063] = 1038,
  [1064] = 1036,
  [1065] = 1038,
  [1066] = 1041,
  [1067] = 1037,
  [1068] = 1041,
  [1069] = 1037,
  [1070] = 1041,
  [1071] = 1037,
  [1072] = 1041,
  [1073] = 1036,
  [1074] = 294,
  [1075] = 1075,
  [1076] = 291,
  [1077] = 1077,
  [1078] = 306,
  [1079] = 1079,
  [1080] = 1077,
  [1081] = 1081,
  [1082] = 1075,
  [1083] = 1083,
  [1084] = 1077,
  [1085] = 307,
  [1086] = 1079,
  [1087] = 308,
  [1088] = 1081,
  [1089] = 1075,
  [1090] = 1079,
  [1091] = 1077,
  [1092] = 298,
  [1093] = 1079,
  [1094] = 1081,
  [1095] = 1075,
  [1096] = 1079,
  [1097] = 1081,
  [1098] = 1075,
  [1099] = 1081,
  [1100] = 1077,
  [1101] = 292,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1102,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1103,
  [1119] = 1105,
  [1120] = 1102,
  [1121] = 1107,
  [1122] = 1109,
  [1123] = 1113,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 298,
  [1131] = 292,
  [1132] = 1124,
  [1133] = 294,
  [1134] = 1125,
  [1135] = 1126,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 291,
  [1139] = 1139,
  [1140] = 1110,
  [1141] = 1111,
  [1142] = 1112,
  [1143] = 1143,
  [1144] = 1114,
  [1145] = 1115,
  [1146] = 1116,
  [1147] = 1117,
  [1148] = 1103,
  [1149] = 1105,
  [1150] = 1102,
  [1151] = 1107,
  [1152] = 1109,
  [1153] = 1113,
  [1154] = 1124,
  [1155] = 1125,
  [1156] = 1126,
  [1157] = 1127,
  [1158] = 1128,
  [1159] = 1110,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1116,
  [1164] = 1164,
  [1165] = 1117,
  [1166] = 1110,
  [1167] = 1111,
  [1168] = 1112,
  [1169] = 1169,
  [1170] = 1114,
  [1171] = 1115,
  [1172] = 1116,
  [1173] = 1117,
  [1174] = 1103,
  [1175] = 1105,
  [1176] = 1176,
  [1177] = 1107,
  [1178] = 1178,
  [1179] = 1113,
  [1180] = 1124,
  [1181] = 1125,
  [1182] = 1126,
  [1183] = 1127,
  [1184] = 1128,
  [1185] = 1169,
  [1186] = 1186,
  [1187] = 307,
  [1188] = 308,
  [1189] = 306,
  [1190] = 1136,
  [1191] = 1162,
  [1192] = 1127,
  [1193] = 1193,
  [1194] = 1110,
  [1195] = 1111,
  [1196] = 1112,
  [1197] = 1197,
  [1198] = 1114,
  [1199] = 1115,
  [1200] = 1116,
  [1201] = 1117,
  [1202] = 1103,
  [1203] = 1105,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1143,
  [1207] = 1160,
  [1208] = 1102,
  [1209] = 1107,
  [1210] = 1210,
  [1211] = 1109,
  [1212] = 1111,
  [1213] = 1113,
  [1214] = 1124,
  [1215] = 1125,
  [1216] = 1112,
  [1217] = 1161,
  [1218] = 1218,
  [1219] = 1126,
  [1220] = 1127,
  [1221] = 1221,
  [1222] = 1128,
  [1223] = 1223,
  [1224] = 1128,
  [1225] = 1225,
  [1226] = 298,
  [1227] = 292,
  [1228] = 294,
  [1229] = 291,
  [1230] = 1230,
  [1231] = 1205,
  [1232] = 307,
  [1233] = 308,
  [1234] = 306,
  [1235] = 1235,
  [1236] = 1114,
  [1237] = 1115,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1109,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1244,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1250,
  [1253] = 1246,
  [1254] = 1251,
  [1255] = 1244,
  [1256] = 1249,
  [1257] = 1250,
  [1258] = 1251,
  [1259] = 1259,
  [1260] = 1246,
  [1261] = 1247,
  [1262] = 1244,
  [1263] = 1249,
  [1264] = 1250,
  [1265] = 1251,
  [1266] = 1246,
  [1267] = 1246,
  [1268] = 1250,
  [1269] = 1244,
  [1270] = 1249,
  [1271] = 1250,
  [1272] = 1251,
  [1273] = 1251,
  [1274] = 1246,
  [1275] = 1275,
  [1276] = 1244,
  [1277] = 1249,
  [1278] = 1250,
  [1279] = 1251,
  [1280] = 1259,
  [1281] = 1246,
  [1282] = 1250,
  [1283] = 1244,
  [1284] = 1249,
  [1285] = 1246,
  [1286] = 1244,
  [1287] = 1246,
  [1288] = 1244,
  [1289] = 1246,
  [1290] = 1244,
  [1291] = 1246,
  [1292] = 1244,
  [1293] = 1246,
  [1294] = 1244,
  [1295] = 1246,
  [1296] = 1275,
  [1297] = 1275,
  [1298] = 1246,
  [1299] = 1251,
  [1300] = 1246,
  [1301] = 1244,
  [1302] = 1249,
  [1303] = 1275,
  [1304] = 1244,
  [1305] = 1249,
  [1306] = 1244,
  [1307] = 1275,
  [1308] = 1308,
  [1309] = 1246,
  [1310] = 1246,
  [1311] = 1259,
  [1312] = 1312,
  [1313] = 1247,
  [1314] = 1250,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1247,
  [1318] = 1244,
  [1319] = 1251,
  [1320] = 1249,
  [1321] = 1259,
  [1322] = 1322,
  [1323] = 1259,
  [1324] = 1247,
  [1325] = 1250,
  [1326] = 1251,
  [1327] = 1249,
  [1328] = 1246,
  [1329] = 1250,
  [1330] = 1330,
  [1331] = 1249,
  [1332] = 1250,
  [1333] = 1244,
  [1334] = 1251,
  [1335] = 1251,
  [1336] = 1246,
  [1337] = 1249,
  [1338] = 1244,
  [1339] = 1249,
  [1340] = 1250,
  [1341] = 1251,
  [1342] = 1244,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 432,
  [1346] = 429,
  [1347] = 1347,
  [1348] = 1344,
  [1349] = 1343,
  [1350] = 288,
  [1351] = 1351,
  [1352] = 1344,
  [1353] = 1353,
  [1354] = 1343,
  [1355] = 1355,
  [1356] = 311,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1359,
  [1360] = 1357,
  [1361] = 1357,
  [1362] = 1362,
  [1363] = 304,
  [1364] = 1357,
  [1365] = 1357,
  [1366] = 305,
  [1367] = 1357,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1357,
  [1371] = 1357,
  [1372] = 1357,
  [1373] = 1359,
  [1374] = 1368,
  [1375] = 1357,
  [1376] = 1376,
  [1377] = 1359,
  [1378] = 1357,
  [1379] = 430,
  [1380] = 303,
  [1381] = 1381,
  [1382] = 1368,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1362,
  [1387] = 1362,
  [1388] = 1383,
  [1389] = 1383,
  [1390] = 290,
  [1391] = 312,
  [1392] = 293,
  [1393] = 1362,
  [1394] = 1383,
  [1395] = 1383,
  [1396] = 1362,
  [1397] = 1357,
  [1398] = 1368,
  [1399] = 1359,
  [1400] = 288,
  [1401] = 1368,
  [1402] = 295,
  [1403] = 1359,
  [1404] = 296,
  [1405] = 297,
  [1406] = 1406,
  [1407] = 1357,
  [1408] = 1408,
  [1409] = 302,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 384,
  [1413] = 405,
  [1414] = 432,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 432,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 333,
  [1421] = 334,
  [1422] = 335,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 432,
  [1427] = 336,
  [1428] = 337,
  [1429] = 338,
  [1430] = 360,
  [1431] = 339,
  [1432] = 1432,
  [1433] = 340,
  [1434] = 341,
  [1435] = 1432,
  [1436] = 342,
  [1437] = 343,
  [1438] = 432,
  [1439] = 429,
  [1440] = 288,
  [1441] = 432,
  [1442] = 1442,
  [1443] = 1424,
  [1444] = 344,
  [1445] = 429,
  [1446] = 429,
  [1447] = 345,
  [1448] = 1432,
  [1449] = 432,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 367,
  [1453] = 429,
  [1454] = 1454,
  [1455] = 346,
  [1456] = 1424,
  [1457] = 347,
  [1458] = 348,
  [1459] = 1424,
  [1460] = 391,
  [1461] = 429,
  [1462] = 349,
  [1463] = 350,
  [1464] = 1464,
  [1465] = 351,
  [1466] = 352,
  [1467] = 408,
  [1468] = 1424,
  [1469] = 393,
  [1470] = 396,
  [1471] = 397,
  [1472] = 1432,
  [1473] = 354,
  [1474] = 432,
  [1475] = 429,
  [1476] = 362,
  [1477] = 432,
  [1478] = 1478,
  [1479] = 429,
  [1480] = 1424,
  [1481] = 356,
  [1482] = 1432,
  [1483] = 432,
  [1484] = 1484,
  [1485] = 1424,
  [1486] = 357,
  [1487] = 1432,
  [1488] = 1424,
  [1489] = 1489,
  [1490] = 353,
  [1491] = 374,
  [1492] = 432,
  [1493] = 429,
  [1494] = 1494,
  [1495] = 413,
  [1496] = 429,
  [1497] = 1424,
  [1498] = 1424,
  [1499] = 1432,
  [1500] = 398,
  [1501] = 1501,
  [1502] = 432,
  [1503] = 1424,
  [1504] = 328,
  [1505] = 429,
  [1506] = 432,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 432,
  [1512] = 429,
  [1513] = 402,
  [1514] = 1514,
  [1515] = 1432,
  [1516] = 1516,
  [1517] = 1432,
  [1518] = 1518,
  [1519] = 404,
  [1520] = 1424,
  [1521] = 432,
  [1522] = 1432,
  [1523] = 1508,
  [1524] = 1424,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1424,
  [1528] = 1528,
  [1529] = 1432,
  [1530] = 1530,
  [1531] = 1432,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 327,
  [1538] = 1432,
  [1539] = 1539,
  [1540] = 330,
  [1541] = 1541,
  [1542] = 429,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 411,
  [1547] = 1547,
  [1548] = 1432,
  [1549] = 1450,
  [1550] = 1550,
  [1551] = 429,
  [1552] = 1508,
  [1553] = 432,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 432,
  [1557] = 429,
  [1558] = 432,
  [1559] = 1559,
  [1560] = 429,
  [1561] = 1508,
  [1562] = 1562,
  [1563] = 400,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1508,
  [1571] = 1571,
  [1572] = 366,
  [1573] = 1573,
  [1574] = 407,
  [1575] = 429,
  [1576] = 1576,
  [1577] = 1424,
  [1578] = 290,
  [1579] = 1508,
  [1580] = 331,
  [1581] = 1424,
  [1582] = 432,
  [1583] = 1432,
  [1584] = 429,
  [1585] = 429,
  [1586] = 432,
  [1587] = 302,
  [1588] = 1508,
  [1589] = 1589,
  [1590] = 311,
  [1591] = 1424,
  [1592] = 429,
  [1593] = 429,
  [1594] = 312,
  [1595] = 293,
  [1596] = 1596,
  [1597] = 1508,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1424,
  [1603] = 1424,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1508,
  [1607] = 1607,
  [1608] = 295,
  [1609] = 296,
  [1610] = 297,
  [1611] = 1432,
  [1612] = 1612,
  [1613] = 303,
  [1614] = 1614,
  [1615] = 1508,
  [1616] = 1616,
  [1617] = 304,
  [1618] = 305,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 432,
  [1622] = 1432,
  [1623] = 1623,
  [1624] = 1508,
  [1625] = 432,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1508,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 432,
  [1636] = 1636,
  [1637] = 1432,
  [1638] = 1432,
  [1639] = 429,
  [1640] = 429,
  [1641] = 1641,
  [1642] = 363,
  [1643] = 1508,
  [1644] = 1644,
  [1645] = 374,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 384,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 328,
  [1653] = 430,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 430,
  [1660] = 366,
  [1661] = 1649,
  [1662] = 407,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1654,
  [1667] = 1656,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1644,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1668,
  [1677] = 1658,
  [1678] = 353,
  [1679] = 1669,
  [1680] = 363,
  [1681] = 367,
  [1682] = 391,
  [1683] = 393,
  [1684] = 396,
  [1685] = 397,
  [1686] = 398,
  [1687] = 400,
  [1688] = 402,
  [1689] = 404,
  [1690] = 405,
  [1691] = 408,
  [1692] = 411,
  [1693] = 413,
  [1694] = 1646,
  [1695] = 430,
  [1696] = 1650,
  [1697] = 1651,
  [1698] = 430,
  [1699] = 1699,
  [1700] = 1644,
  [1701] = 1649,
  [1702] = 1702,
  [1703] = 430,
  [1704] = 1665,
  [1705] = 1654,
  [1706] = 1656,
  [1707] = 1668,
  [1708] = 1669,
  [1709] = 1644,
  [1710] = 1671,
  [1711] = 1672,
  [1712] = 1673,
  [1713] = 1674,
  [1714] = 1675,
  [1715] = 1658,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1646,
  [1720] = 1646,
  [1721] = 1721,
  [1722] = 1650,
  [1723] = 1651,
  [1724] = 430,
  [1725] = 1649,
  [1726] = 1665,
  [1727] = 1654,
  [1728] = 1656,
  [1729] = 1668,
  [1730] = 1669,
  [1731] = 1644,
  [1732] = 1671,
  [1733] = 1672,
  [1734] = 1673,
  [1735] = 1674,
  [1736] = 1675,
  [1737] = 1646,
  [1738] = 1650,
  [1739] = 1651,
  [1740] = 1740,
  [1741] = 845,
  [1742] = 1742,
  [1743] = 290,
  [1744] = 1665,
  [1745] = 1654,
  [1746] = 1656,
  [1747] = 1668,
  [1748] = 1669,
  [1749] = 1644,
  [1750] = 1671,
  [1751] = 1672,
  [1752] = 1673,
  [1753] = 1674,
  [1754] = 1675,
  [1755] = 430,
  [1756] = 1756,
  [1757] = 1646,
  [1758] = 1650,
  [1759] = 1651,
  [1760] = 1665,
  [1761] = 1654,
  [1762] = 1656,
  [1763] = 1668,
  [1764] = 1669,
  [1765] = 1644,
  [1766] = 1671,
  [1767] = 1672,
  [1768] = 1673,
  [1769] = 1674,
  [1770] = 1675,
  [1771] = 1646,
  [1772] = 1650,
  [1773] = 1651,
  [1774] = 1665,
  [1775] = 1654,
  [1776] = 1656,
  [1777] = 1668,
  [1778] = 1669,
  [1779] = 1644,
  [1780] = 1671,
  [1781] = 1672,
  [1782] = 1673,
  [1783] = 1674,
  [1784] = 1675,
  [1785] = 302,
  [1786] = 1646,
  [1787] = 1650,
  [1788] = 1651,
  [1789] = 311,
  [1790] = 1790,
  [1791] = 1665,
  [1792] = 1654,
  [1793] = 1656,
  [1794] = 1668,
  [1795] = 1669,
  [1796] = 1644,
  [1797] = 1671,
  [1798] = 1672,
  [1799] = 1673,
  [1800] = 1674,
  [1801] = 1675,
  [1802] = 1646,
  [1803] = 1650,
  [1804] = 1651,
  [1805] = 430,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 312,
  [1809] = 293,
  [1810] = 1665,
  [1811] = 1654,
  [1812] = 1656,
  [1813] = 1668,
  [1814] = 1669,
  [1815] = 1644,
  [1816] = 1671,
  [1817] = 1672,
  [1818] = 1673,
  [1819] = 1674,
  [1820] = 1675,
  [1821] = 430,
  [1822] = 1646,
  [1823] = 1650,
  [1824] = 1651,
  [1825] = 430,
  [1826] = 1665,
  [1827] = 1654,
  [1828] = 357,
  [1829] = 1668,
  [1830] = 1669,
  [1831] = 1644,
  [1832] = 1671,
  [1833] = 1672,
  [1834] = 1673,
  [1835] = 1674,
  [1836] = 1675,
  [1837] = 1646,
  [1838] = 1650,
  [1839] = 1651,
  [1840] = 430,
  [1841] = 430,
  [1842] = 1665,
  [1843] = 1654,
  [1844] = 1656,
  [1845] = 1668,
  [1846] = 1669,
  [1847] = 1644,
  [1848] = 1671,
  [1849] = 1672,
  [1850] = 1673,
  [1851] = 1674,
  [1852] = 1675,
  [1853] = 1650,
  [1854] = 1651,
  [1855] = 1646,
  [1856] = 1650,
  [1857] = 1651,
  [1858] = 295,
  [1859] = 296,
  [1860] = 430,
  [1861] = 297,
  [1862] = 1862,
  [1863] = 430,
  [1864] = 430,
  [1865] = 430,
  [1866] = 430,
  [1867] = 303,
  [1868] = 1868,
  [1869] = 304,
  [1870] = 305,
  [1871] = 430,
  [1872] = 1872,
  [1873] = 1873,
  [1874] = 430,
  [1875] = 430,
  [1876] = 1718,
  [1877] = 1877,
  [1878] = 1665,
  [1879] = 1654,
  [1880] = 1656,
  [1881] = 1668,
  [1882] = 1669,
  [1883] = 1644,
  [1884] = 1671,
  [1885] = 1672,
  [1886] = 1673,
  [1887] = 1674,
  [1888] = 1675,
  [1889] = 1718,
  [1890] = 1877,
  [1891] = 1658,
  [1892] = 1525,
  [1893] = 430,
  [1894] = 1671,
  [1895] = 360,
  [1896] = 1718,
  [1897] = 1877,
  [1898] = 1672,
  [1899] = 1877,
  [1900] = 1673,
  [1901] = 362,
  [1902] = 1902,
  [1903] = 1646,
  [1904] = 1718,
  [1905] = 1905,
  [1906] = 1877,
  [1907] = 1756,
  [1908] = 327,
  [1909] = 1650,
  [1910] = 1651,
  [1911] = 1718,
  [1912] = 330,
  [1913] = 1877,
  [1914] = 430,
  [1915] = 1674,
  [1916] = 1916,
  [1917] = 1718,
  [1918] = 1877,
  [1919] = 333,
  [1920] = 1718,
  [1921] = 1877,
  [1922] = 334,
  [1923] = 335,
  [1924] = 336,
  [1925] = 1718,
  [1926] = 337,
  [1927] = 1877,
  [1928] = 338,
  [1929] = 339,
  [1930] = 340,
  [1931] = 341,
  [1932] = 1718,
  [1933] = 1877,
  [1934] = 342,
  [1935] = 1718,
  [1936] = 1649,
  [1937] = 1877,
  [1938] = 343,
  [1939] = 344,
  [1940] = 345,
  [1941] = 1718,
  [1942] = 346,
  [1943] = 1877,
  [1944] = 347,
  [1945] = 1665,
  [1946] = 1654,
  [1947] = 1656,
  [1948] = 1668,
  [1949] = 1669,
  [1950] = 348,
  [1951] = 1671,
  [1952] = 1718,
  [1953] = 1672,
  [1954] = 1877,
  [1955] = 1673,
  [1956] = 1674,
  [1957] = 1675,
  [1958] = 349,
  [1959] = 1658,
  [1960] = 350,
  [1961] = 351,
  [1962] = 352,
  [1963] = 1675,
  [1964] = 354,
  [1965] = 1665,
  [1966] = 1702,
  [1967] = 1702,
  [1968] = 1702,
  [1969] = 1702,
  [1970] = 1647,
  [1971] = 1647,
  [1972] = 356,
  [1973] = 1647,
  [1974] = 1647,
  [1975] = 1656,
  [1976] = 1976,
  [1977] = 1977,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1981,
  [1982] = 357,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1978,
  [1991] = 1979,
  [1992] = 1980,
  [1993] = 1983,
  [1994] = 1985,
  [1995] = 1986,
  [1996] = 1996,
  [1997] = 1997,
  [1998] = 1977,
  [1999] = 1999,
  [2000] = 2000,
  [2001] = 2001,
  [2002] = 2002,
  [2003] = 2001,
  [2004] = 2004,
  [2005] = 1996,
  [2006] = 1997,
  [2007] = 1977,
  [2008] = 2008,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2001,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 1984,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 374,
  [2023] = 2015,
  [2024] = 1989,
  [2025] = 1978,
  [2026] = 1979,
  [2027] = 1980,
  [2028] = 1983,
  [2029] = 1985,
  [2030] = 1986,
  [2031] = 1996,
  [2032] = 1997,
  [2033] = 1977,
  [2034] = 384,
  [2035] = 2035,
  [2036] = 2001,
  [2037] = 331,
  [2038] = 2038,
  [2039] = 2004,
  [2040] = 360,
  [2041] = 2004,
  [2042] = 2042,
  [2043] = 2009,
  [2044] = 2016,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2045,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2046,
  [2054] = 1984,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 328,
  [2058] = 2058,
  [2059] = 1989,
  [2060] = 1978,
  [2061] = 1979,
  [2062] = 1980,
  [2063] = 1983,
  [2064] = 1985,
  [2065] = 1986,
  [2066] = 1996,
  [2067] = 1997,
  [2068] = 1977,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 2001,
  [2072] = 1162,
  [2073] = 2048,
  [2074] = 2004,
  [2075] = 2049,
  [2076] = 2050,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2056,
  [2080] = 2058,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2008,
  [2087] = 2082,
  [2088] = 2088,
  [2089] = 1984,
  [2090] = 2090,
  [2091] = 2091,
  [2092] = 1984,
  [2093] = 2093,
  [2094] = 1989,
  [2095] = 1978,
  [2096] = 1979,
  [2097] = 1980,
  [2098] = 1983,
  [2099] = 1985,
  [2100] = 1986,
  [2101] = 1996,
  [2102] = 1997,
  [2103] = 1977,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2001,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 2004,
  [2110] = 362,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2010,
  [2114] = 2048,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 327,
  [2119] = 330,
  [2120] = 1989,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 1984,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 1989,
  [2130] = 1978,
  [2131] = 1979,
  [2132] = 1980,
  [2133] = 1983,
  [2134] = 1985,
  [2135] = 1986,
  [2136] = 1996,
  [2137] = 1997,
  [2138] = 1977,
  [2139] = 2139,
  [2140] = 366,
  [2141] = 2001,
  [2142] = 407,
  [2143] = 2143,
  [2144] = 2004,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2008,
  [2149] = 2149,
  [2150] = 333,
  [2151] = 334,
  [2152] = 2127,
  [2153] = 1984,
  [2154] = 1978,
  [2155] = 1979,
  [2156] = 335,
  [2157] = 336,
  [2158] = 337,
  [2159] = 1984,
  [2160] = 338,
  [2161] = 339,
  [2162] = 2117,
  [2163] = 1989,
  [2164] = 1989,
  [2165] = 1978,
  [2166] = 1979,
  [2167] = 1980,
  [2168] = 1983,
  [2169] = 1985,
  [2170] = 1986,
  [2171] = 1996,
  [2172] = 1997,
  [2173] = 1977,
  [2174] = 340,
  [2175] = 1980,
  [2176] = 2001,
  [2177] = 1978,
  [2178] = 1979,
  [2179] = 2004,
  [2180] = 2180,
  [2181] = 1980,
  [2182] = 353,
  [2183] = 1983,
  [2184] = 1985,
  [2185] = 1986,
  [2186] = 2186,
  [2187] = 1996,
  [2188] = 363,
  [2189] = 1997,
  [2190] = 1977,
  [2191] = 367,
  [2192] = 341,
  [2193] = 342,
  [2194] = 2010,
  [2195] = 2195,
  [2196] = 2196,
  [2197] = 2125,
  [2198] = 343,
  [2199] = 2199,
  [2200] = 1988,
  [2201] = 391,
  [2202] = 2186,
  [2203] = 393,
  [2204] = 396,
  [2205] = 397,
  [2206] = 398,
  [2207] = 344,
  [2208] = 400,
  [2209] = 402,
  [2210] = 345,
  [2211] = 2058,
  [2212] = 404,
  [2213] = 2002,
  [2214] = 2017,
  [2215] = 2001,
  [2216] = 405,
  [2217] = 2012,
  [2218] = 2218,
  [2219] = 1981,
  [2220] = 2000,
  [2221] = 2221,
  [2222] = 2149,
  [2223] = 2078,
  [2224] = 408,
  [2225] = 2015,
  [2226] = 346,
  [2227] = 2195,
  [2228] = 2196,
  [2229] = 2125,
  [2230] = 347,
  [2231] = 2199,
  [2232] = 348,
  [2233] = 2186,
  [2234] = 2021,
  [2235] = 2035,
  [2236] = 2038,
  [2237] = 349,
  [2238] = 2004,
  [2239] = 2042,
  [2240] = 2009,
  [2241] = 2016,
  [2242] = 411,
  [2243] = 413,
  [2244] = 2002,
  [2245] = 2017,
  [2246] = 2045,
  [2247] = 2046,
  [2248] = 2012,
  [2249] = 2218,
  [2250] = 2000,
  [2251] = 2221,
  [2252] = 2149,
  [2253] = 2078,
  [2254] = 1983,
  [2255] = 2048,
  [2256] = 2256,
  [2257] = 2195,
  [2258] = 2196,
  [2259] = 2125,
  [2260] = 2260,
  [2261] = 2199,
  [2262] = 2262,
  [2263] = 2186,
  [2264] = 2021,
  [2265] = 2199,
  [2266] = 2049,
  [2267] = 2267,
  [2268] = 2117,
  [2269] = 2050,
  [2270] = 2035,
  [2271] = 350,
  [2272] = 2272,
  [2273] = 2038,
  [2274] = 2002,
  [2275] = 2017,
  [2276] = 351,
  [2277] = 2277,
  [2278] = 2012,
  [2279] = 2218,
  [2280] = 2000,
  [2281] = 2221,
  [2282] = 2149,
  [2283] = 2078,
  [2284] = 2056,
  [2285] = 1985,
  [2286] = 2195,
  [2287] = 2196,
  [2288] = 2125,
  [2289] = 2289,
  [2290] = 2199,
  [2291] = 1978,
  [2292] = 2186,
  [2293] = 1986,
  [2294] = 1989,
  [2295] = 2295,
  [2296] = 1996,
  [2297] = 2082,
  [2298] = 2093,
  [2299] = 2299,
  [2300] = 2056,
  [2301] = 2008,
  [2302] = 1997,
  [2303] = 2002,
  [2304] = 2017,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2012,
  [2308] = 2218,
  [2309] = 2000,
  [2310] = 2221,
  [2311] = 2149,
  [2312] = 2078,
  [2313] = 2195,
  [2314] = 2125,
  [2315] = 2199,
  [2316] = 2186,
  [2317] = 2221,
  [2318] = 2127,
  [2319] = 2319,
  [2320] = 1977,
  [2321] = 1984,
  [2322] = 1979,
  [2323] = 352,
  [2324] = 2324,
  [2325] = 2196,
  [2326] = 1984,
  [2327] = 2327,
  [2328] = 2012,
  [2329] = 2000,
  [2330] = 2195,
  [2331] = 2125,
  [2332] = 2199,
  [2333] = 2186,
  [2334] = 2004,
  [2335] = 2049,
  [2336] = 2010,
  [2337] = 354,
  [2338] = 2042,
  [2339] = 2009,
  [2340] = 2117,
  [2341] = 2341,
  [2342] = 1989,
  [2343] = 1989,
  [2344] = 2344,
  [2345] = 2012,
  [2346] = 2000,
  [2347] = 2195,
  [2348] = 2042,
  [2349] = 2199,
  [2350] = 2186,
  [2351] = 2351,
  [2352] = 1978,
  [2353] = 1978,
  [2354] = 1979,
  [2355] = 1980,
  [2356] = 1983,
  [2357] = 1985,
  [2358] = 1979,
  [2359] = 1986,
  [2360] = 1980,
  [2361] = 1996,
  [2362] = 2012,
  [2363] = 2000,
  [2364] = 2195,
  [2365] = 2125,
  [2366] = 2199,
  [2367] = 2186,
  [2368] = 1997,
  [2369] = 1977,
  [2370] = 1983,
  [2371] = 1985,
  [2372] = 2070,
  [2373] = 2010,
  [2374] = 1986,
  [2375] = 1996,
  [2376] = 1997,
  [2377] = 1977,
  [2378] = 2378,
  [2379] = 2012,
  [2380] = 2000,
  [2381] = 2195,
  [2382] = 2125,
  [2383] = 2199,
  [2384] = 2186,
  [2385] = 2001,
  [2386] = 2015,
  [2387] = 2050,
  [2388] = 2001,
  [2389] = 2389,
  [2390] = 2021,
  [2391] = 2035,
  [2392] = 2001,
  [2393] = 2038,
  [2394] = 2004,
  [2395] = 2015,
  [2396] = 2012,
  [2397] = 2000,
  [2398] = 2195,
  [2399] = 2125,
  [2400] = 2199,
  [2401] = 2186,
  [2402] = 2327,
  [2403] = 2004,
  [2404] = 2042,
  [2405] = 2009,
  [2406] = 2016,
  [2407] = 2045,
  [2408] = 2046,
  [2409] = 2409,
  [2410] = 2127,
  [2411] = 1205,
  [2412] = 2048,
  [2413] = 2012,
  [2414] = 2000,
  [2415] = 2195,
  [2416] = 2125,
  [2417] = 2199,
  [2418] = 2186,
  [2419] = 2049,
  [2420] = 2050,
  [2421] = 2021,
  [2422] = 2035,
  [2423] = 2056,
  [2424] = 2058,
  [2425] = 2082,
  [2426] = 2008,
  [2427] = 1980,
  [2428] = 2038,
  [2429] = 1983,
  [2430] = 2012,
  [2431] = 2000,
  [2432] = 2195,
  [2433] = 2125,
  [2434] = 2199,
  [2435] = 2186,
  [2436] = 2127,
  [2437] = 1984,
  [2438] = 1984,
  [2439] = 1984,
  [2440] = 2004,
  [2441] = 1985,
  [2442] = 2218,
  [2443] = 2443,
  [2444] = 1989,
  [2445] = 1978,
  [2446] = 1979,
  [2447] = 2012,
  [2448] = 2000,
  [2449] = 2199,
  [2450] = 2199,
  [2451] = 2199,
  [2452] = 2199,
  [2453] = 2199,
  [2454] = 2199,
  [2455] = 2389,
  [2456] = 2055,
  [2457] = 2088,
  [2458] = 2091,
  [2459] = 2111,
  [2460] = 2115,
  [2461] = 2123,
  [2462] = 1976,
  [2463] = 2108,
  [2464] = 2107,
  [2465] = 2341,
  [2466] = 1980,
  [2467] = 2122,
  [2468] = 2443,
  [2469] = 2389,
  [2470] = 2055,
  [2471] = 2088,
  [2472] = 2091,
  [2473] = 2111,
  [2474] = 2115,
  [2475] = 2123,
  [2476] = 1976,
  [2477] = 2108,
  [2478] = 2107,
  [2479] = 2341,
  [2480] = 1983,
  [2481] = 2122,
  [2482] = 2443,
  [2483] = 2389,
  [2484] = 2055,
  [2485] = 2088,
  [2486] = 2091,
  [2487] = 2111,
  [2488] = 2115,
  [2489] = 2123,
  [2490] = 1976,
  [2491] = 2108,
  [2492] = 2107,
  [2493] = 2341,
  [2494] = 1985,
  [2495] = 2122,
  [2496] = 2443,
  [2497] = 2389,
  [2498] = 2055,
  [2499] = 2088,
  [2500] = 2091,
  [2501] = 2111,
  [2502] = 2115,
  [2503] = 2123,
  [2504] = 1976,
  [2505] = 2108,
  [2506] = 2107,
  [2507] = 2341,
  [2508] = 1986,
  [2509] = 2122,
  [2510] = 2443,
  [2511] = 2055,
  [2512] = 2088,
  [2513] = 2091,
  [2514] = 2111,
  [2515] = 2115,
  [2516] = 2123,
  [2517] = 1976,
  [2518] = 2108,
  [2519] = 2107,
  [2520] = 2341,
  [2521] = 1996,
  [2522] = 2055,
  [2523] = 2088,
  [2524] = 2091,
  [2525] = 2111,
  [2526] = 2115,
  [2527] = 2123,
  [2528] = 1976,
  [2529] = 2108,
  [2530] = 2107,
  [2531] = 2341,
  [2532] = 1997,
  [2533] = 2055,
  [2534] = 2088,
  [2535] = 2091,
  [2536] = 2111,
  [2537] = 2115,
  [2538] = 2123,
  [2539] = 1976,
  [2540] = 2108,
  [2541] = 2107,
  [2542] = 2341,
  [2543] = 1977,
  [2544] = 2055,
  [2545] = 2088,
  [2546] = 2091,
  [2547] = 2111,
  [2548] = 2115,
  [2549] = 2123,
  [2550] = 1976,
  [2551] = 2108,
  [2552] = 2107,
  [2553] = 2341,
  [2554] = 356,
  [2555] = 2055,
  [2556] = 2088,
  [2557] = 2091,
  [2558] = 2111,
  [2559] = 2115,
  [2560] = 2123,
  [2561] = 1976,
  [2562] = 2108,
  [2563] = 2107,
  [2564] = 2341,
  [2565] = 2121,
  [2566] = 2055,
  [2567] = 2088,
  [2568] = 2091,
  [2569] = 2111,
  [2570] = 2115,
  [2571] = 2123,
  [2572] = 2001,
  [2573] = 2108,
  [2574] = 2107,
  [2575] = 2341,
  [2576] = 2576,
  [2577] = 2055,
  [2578] = 2088,
  [2579] = 2091,
  [2580] = 2111,
  [2581] = 2115,
  [2582] = 2123,
  [2583] = 1976,
  [2584] = 2108,
  [2585] = 2107,
  [2586] = 2341,
  [2587] = 2058,
  [2588] = 2055,
  [2589] = 2088,
  [2590] = 2091,
  [2591] = 2111,
  [2592] = 2115,
  [2593] = 2123,
  [2594] = 1976,
  [2595] = 2108,
  [2596] = 2107,
  [2597] = 2341,
  [2598] = 2598,
  [2599] = 2272,
  [2600] = 2600,
  [2601] = 2128,
  [2602] = 2195,
  [2603] = 2272,
  [2604] = 1976,
  [2605] = 2128,
  [2606] = 2016,
  [2607] = 2272,
  [2608] = 2004,
  [2609] = 2128,
  [2610] = 2272,
  [2611] = 2611,
  [2612] = 2128,
  [2613] = 2272,
  [2614] = 2272,
  [2615] = 2272,
  [2616] = 2272,
  [2617] = 2272,
  [2618] = 2272,
  [2619] = 2272,
  [2620] = 2272,
  [2621] = 1986,
  [2622] = 2045,
  [2623] = 1996,
  [2624] = 1997,
  [2625] = 2117,
  [2626] = 2626,
  [2627] = 1989,
  [2628] = 2046,
  [2629] = 2409,
  [2630] = 2409,
  [2631] = 2409,
  [2632] = 2409,
  [2633] = 2125,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(46);
      if ((!eof && lookahead == 00)) ADVANCE(59);
      if (lookahead == '\t') ADVANCE(78);
      if (lookahead == '\r') SKIP(43);
      if (lookahead == ' ') ADVANCE(57);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(162);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(71);
      if (lookahead == ':') ADVANCE(67);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(54);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(195);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == 'x') ADVANCE(52);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 1:
      if ((!eof && lookahead == 00)) ADVANCE(59);
      if (lookahead == '\r') SKIP(2);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 2:
      if ((!eof && lookahead == 00)) ADVANCE(59);
      if (lookahead == '\r') SKIP(2);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead)) ADVANCE(181);
      END_STATE();
    case 3:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead)) ADVANCE(181);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead)) ADVANCE(181);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == '%') ADVANCE(162);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == ':') ADVANCE(66);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '[') ADVANCE(48);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '{') ADVANCE(149);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == '%') ADVANCE(162);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == ':') ADVANCE(66);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '[') ADVANCE(47);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '{') ADVANCE(149);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 10:
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '%' &&
          lookahead != '}') ADVANCE(163);
      END_STATE();
    case 11:
      if (lookahead == '\r') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != ')') ADVANCE(158);
      END_STATE();
    case 12:
      if (lookahead == '\r') ADVANCE(62);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(63);
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '[') ADVANCE(47);
      if (lookahead == ']') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(14);
      if (lookahead == ' ') ADVANCE(56);
      if (lookahead == 'X') ADVANCE(53);
      if (lookahead == 'x') ADVANCE(52);
      END_STATE();
    case 15:
      if (lookahead == '\r') ADVANCE(74);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(75);
      END_STATE();
    case 16:
      if (lookahead == '\r') SKIP(16);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(68);
      END_STATE();
    case 17:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 18:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 19:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 20:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == ']') ADVANCE(155);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(151);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 21:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 22:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(153);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead)) ADVANCE(181);
      END_STATE();
    case 23:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(151);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 24:
      if (lookahead == '\r') SKIP(26);
      if (lookahead == '!') ADVANCE(112);
      if (lookahead == '"') ADVANCE(113);
      if (lookahead == '$') ADVANCE(168);
      if (lookahead == '\'') ADVANCE(113);
      if (lookahead == '(') ADVANCE(161);
      if (lookahead == '*') ADVANCE(126);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == ':') ADVANCE(115);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '>') ADVANCE(181);
      if (lookahead == 'F') ADVANCE(100);
      if (lookahead == 'I') ADVANCE(102);
      if (lookahead == 'N') ADVANCE(103);
      if (lookahead == 'T') ADVANCE(104);
      if (lookahead == 'W') ADVANCE(99);
      if (lookahead == 'X') ADVANCE(111);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == ']') ADVANCE(156);
      if (lookahead == '^') ADVANCE(130);
      if (lookahead == '_') ADVANCE(122);
      if (lookahead == '{') ADVANCE(154);
      if (lookahead == '~') ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(116);
      END_STATE();
    case 25:
      if (lookahead == '\r') SKIP(26);
      if (lookahead == '!') ADVANCE(112);
      if (lookahead == '"') ADVANCE(113);
      if (lookahead == '$') ADVANCE(168);
      if (lookahead == '\'') ADVANCE(113);
      if (lookahead == '(') ADVANCE(161);
      if (lookahead == '*') ADVANCE(126);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == ':') ADVANCE(115);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '>') ADVANCE(181);
      if (lookahead == 'F') ADVANCE(100);
      if (lookahead == 'I') ADVANCE(102);
      if (lookahead == 'N') ADVANCE(103);
      if (lookahead == 'T') ADVANCE(104);
      if (lookahead == 'W') ADVANCE(99);
      if (lookahead == 'X') ADVANCE(111);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '^') ADVANCE(130);
      if (lookahead == '_') ADVANCE(122);
      if (lookahead == '{') ADVANCE(154);
      if (lookahead == '~') ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(116);
      END_STATE();
    case 26:
      if (lookahead == '\r') SKIP(26);
      if (lookahead == '!') ADVANCE(112);
      if (lookahead == '"') ADVANCE(113);
      if (lookahead == '$') ADVANCE(168);
      if (lookahead == '\'') ADVANCE(113);
      if (lookahead == '(') ADVANCE(161);
      if (lookahead == '*') ADVANCE(126);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == ':') ADVANCE(115);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '>') ADVANCE(181);
      if (lookahead == 'F') ADVANCE(100);
      if (lookahead == 'I') ADVANCE(102);
      if (lookahead == 'N') ADVANCE(103);
      if (lookahead == 'T') ADVANCE(104);
      if (lookahead == 'W') ADVANCE(99);
      if (lookahead == 'X') ADVANCE(111);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '^') ADVANCE(130);
      if (lookahead == '_') ADVANCE(122);
      if (lookahead == '{') ADVANCE(154);
      if (lookahead == '~') ADVANCE(134);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead)) ADVANCE(116);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(81);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(118);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == ':') ADVANCE(60);
      END_STATE();
    case 30:
      if (lookahead == 'D') ADVANCE(36);
      END_STATE();
    case 31:
      if (lookahead == 'E') ADVANCE(173);
      END_STATE();
    case 32:
      if (lookahead == 'E') ADVANCE(179);
      END_STATE();
    case 33:
      if (lookahead == 'F') ADVANCE(35);
      END_STATE();
    case 34:
      if (lookahead == 'M') ADVANCE(32);
      END_STATE();
    case 35:
      if (lookahead == 'O') ADVANCE(175);
      END_STATE();
    case 36:
      if (lookahead == 'O') ADVANCE(169);
      END_STATE();
    case 37:
      if (lookahead == 'P') ADVANCE(171);
      END_STATE();
    case 38:
      if (lookahead == 'T') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'X') ADVANCE(34);
      END_STATE();
    case 40:
      if (lookahead == 'X') ADVANCE(177);
      END_STATE();
    case 41:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '}') ADVANCE(72);
      END_STATE();
    case 42:
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(58);
      END_STATE();
    case 43:
      if (eof) ADVANCE(46);
      if ((!eof && lookahead == 00)) ADVANCE(59);
      if (lookahead == '\r') SKIP(43);
      if (lookahead == ' ') ADVANCE(56);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(162);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(71);
      if (lookahead == ':') ADVANCE(67);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(54);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(195);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == 'x') ADVANCE(52);
      if (lookahead == '{') ADVANCE(152);
      if (lookahead == '}') ADVANCE(69);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 44:
      if (eof) ADVANCE(46);
      if (lookahead == '\r') SKIP(45);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(181);
      END_STATE();
    case 45:
      if (eof) ADVANCE(46);
      if (lookahead == '\r') SKIP(45);
      if (lookahead == '!') ADVANCE(191);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(160);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '.') ADVANCE(184);
      if (lookahead == ':') ADVANCE(194);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == 'F') ADVANCE(185);
      if (lookahead == 'I') ADVANCE(187);
      if (lookahead == 'N') ADVANCE(188);
      if (lookahead == 'T') ADVANCE(189);
      if (lookahead == 'W') ADVANCE(186);
      if (lookahead == 'X') ADVANCE(190);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '~') ADVANCE(133);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead)) ADVANCE(181);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(144);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(144);
      if (lookahead == '^') ADVANCE(141);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(147);
      if (lookahead == '^') ADVANCE(141);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(148);
      if (lookahead == '^') ADVANCE(142);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_x);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_X);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_X);
      if (lookahead == 'X') ADVANCE(40);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SPACE);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_SPACE);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym__table_cell_alignment_token1);
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_RBRACK_COLON);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_language);
      if (lookahead == '\r') ADVANCE(62);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != '=' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(63);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_language);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != ' ' &&
          lookahead != '=' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym__line_token1);
      if (lookahead == '\r') ADVANCE(64);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(65);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(aux_sym__line_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_link_destination);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(27);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '}') ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym_value_token1);
      if (lookahead == '\r') ADVANCE(74);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(75);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym_value_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_value_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym__whitespace1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_quotation_marks);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_quotation_marks);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_ellipsis);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_em_dash);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_em_dash);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_en_dash);
      if (lookahead == '-') ADVANCE(83);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_en_dash);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_backslash_escape);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_backslash_escape);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == ':') ADVANCE(116);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'D') ADVANCE(106);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'E') ADVANCE(174);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'E') ADVANCE(180);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'F') ADVANCE(105);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'I') ADVANCE(107);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'I') ADVANCE(109);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'M') ADVANCE(97);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'N') ADVANCE(98);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'O') ADVANCE(108);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'O') ADVANCE(95);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'O') ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'O') ADVANCE(170);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'P') ADVANCE(172);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'T') ADVANCE(96);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'X') ADVANCE(101);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'X') ADVANCE(178);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == 'X') ADVANCE(110);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '[') ADVANCE(146);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '}') ADVANCE(80);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(80);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == '>') ADVANCE(87);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(88);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_autolink_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_symbol);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LBRACE_);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_LBRACE_);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LBRACE_STAR);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LBRACE_STAR);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LBRACE_CARET);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LBRACE_CARET);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACE_TILDE);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LBRACE_TILDE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LBRACE_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_LBRACE_EQ);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LBRACE_PLUS);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LBRACE_PLUS);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACE_DASH);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LBRACE_DASH);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_LBRACK_CARET);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LBRACK_CARET);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym__id);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_BANG_LBRACK);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_BANG_LBRACK);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK2);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK2);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '=') ADVANCE(166);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '_') ADVANCE(119);
      if (lookahead == '~') ADVANCE(131);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      ADVANCE_MAP(
        '*', 123,
        '+', 137,
        '-', 139,
        '=', 166,
        '^', 127,
        '_', 119,
        '~', 131,
        '"', 79,
        '\'', 79,
      );
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '_') ADVANCE(119);
      if (lookahead == '~') ADVANCE(131);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      ADVANCE_MAP(
        '*', 123,
        '+', 137,
        '-', 139,
        '=', 135,
        '^', 127,
        '_', 119,
        '~', 131,
        '"', 79,
        '\'', 79,
      );
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      ADVANCE_MAP(
        '*', 124,
        '+', 138,
        '-', 140,
        '=', 136,
        '^', 128,
        '_', 120,
        '~', 132,
        '"', 80,
        '\'', 80,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '=' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_RBRACK2);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_RBRACK2);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym__inline_link_url_token1);
      if (lookahead == '\r') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != ')') ADVANCE(158);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym__inline_link_url_token1);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != ')') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym__inline_link_url_token1);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(158);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '%' &&
          lookahead != '}') ADVANCE(163);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(87);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_LBRACE_EQ2);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_TODO);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_TODO);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_WIP);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_WIP);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_NOTE);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_NOTE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_INFO);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_INFO);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_XXX);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_XXX);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_fixme);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_fixme);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '>') ADVANCE(116);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym__text_token1);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym__text_token1);
      ADVANCE_MAP(
        '*', 123,
        '+', 137,
        '-', 139,
        '=', 135,
        '^', 127,
        '_', 119,
        '~', 131,
        '"', 79,
        '\'', 79,
      );
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '-') ADVANCE(85);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '.') ADVANCE(27);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == 'I') ADVANCE(39);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == 'I') ADVANCE(37);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == 'N') ADVANCE(33);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == 'O') ADVANCE(38);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == 'O') ADVANCE(30);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == 'X') ADVANCE(40);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '[') ADVANCE(145);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '}') ADVANCE(79);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(79);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(87);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym__text_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(87);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 44, .external_lex_state = 2},
  [2] = {.lex_state = 44, .external_lex_state = 3},
  [3] = {.lex_state = 44, .external_lex_state = 3},
  [4] = {.lex_state = 44, .external_lex_state = 4},
  [5] = {.lex_state = 44, .external_lex_state = 4},
  [6] = {.lex_state = 44, .external_lex_state = 3},
  [7] = {.lex_state = 44, .external_lex_state = 3},
  [8] = {.lex_state = 44, .external_lex_state = 4},
  [9] = {.lex_state = 44, .external_lex_state = 4},
  [10] = {.lex_state = 44, .external_lex_state = 4},
  [11] = {.lex_state = 44, .external_lex_state = 4},
  [12] = {.lex_state = 44, .external_lex_state = 4},
  [13] = {.lex_state = 44, .external_lex_state = 4},
  [14] = {.lex_state = 44, .external_lex_state = 4},
  [15] = {.lex_state = 44, .external_lex_state = 4},
  [16] = {.lex_state = 44, .external_lex_state = 4},
  [17] = {.lex_state = 44, .external_lex_state = 4},
  [18] = {.lex_state = 44, .external_lex_state = 4},
  [19] = {.lex_state = 44, .external_lex_state = 4},
  [20] = {.lex_state = 44, .external_lex_state = 4},
  [21] = {.lex_state = 44, .external_lex_state = 4},
  [22] = {.lex_state = 44, .external_lex_state = 3},
  [23] = {.lex_state = 44, .external_lex_state = 3},
  [24] = {.lex_state = 44, .external_lex_state = 3},
  [25] = {.lex_state = 44, .external_lex_state = 3},
  [26] = {.lex_state = 44, .external_lex_state = 3},
  [27] = {.lex_state = 44, .external_lex_state = 3},
  [28] = {.lex_state = 44, .external_lex_state = 3},
  [29] = {.lex_state = 44, .external_lex_state = 3},
  [30] = {.lex_state = 44, .external_lex_state = 3},
  [31] = {.lex_state = 44, .external_lex_state = 3},
  [32] = {.lex_state = 44, .external_lex_state = 3},
  [33] = {.lex_state = 44, .external_lex_state = 3},
  [34] = {.lex_state = 44, .external_lex_state = 3},
  [35] = {.lex_state = 44, .external_lex_state = 3},
  [36] = {.lex_state = 44, .external_lex_state = 3},
  [37] = {.lex_state = 44, .external_lex_state = 3},
  [38] = {.lex_state = 44, .external_lex_state = 3},
  [39] = {.lex_state = 44, .external_lex_state = 3},
  [40] = {.lex_state = 44, .external_lex_state = 3},
  [41] = {.lex_state = 44, .external_lex_state = 3},
  [42] = {.lex_state = 44, .external_lex_state = 3},
  [43] = {.lex_state = 44, .external_lex_state = 3},
  [44] = {.lex_state = 44, .external_lex_state = 3},
  [45] = {.lex_state = 44, .external_lex_state = 3},
  [46] = {.lex_state = 44, .external_lex_state = 3},
  [47] = {.lex_state = 44, .external_lex_state = 3},
  [48] = {.lex_state = 44, .external_lex_state = 3},
  [49] = {.lex_state = 44, .external_lex_state = 3},
  [50] = {.lex_state = 44, .external_lex_state = 3},
  [51] = {.lex_state = 44, .external_lex_state = 3},
  [52] = {.lex_state = 44, .external_lex_state = 3},
  [53] = {.lex_state = 44, .external_lex_state = 3},
  [54] = {.lex_state = 44, .external_lex_state = 3},
  [55] = {.lex_state = 44, .external_lex_state = 3},
  [56] = {.lex_state = 44, .external_lex_state = 3},
  [57] = {.lex_state = 44, .external_lex_state = 3},
  [58] = {.lex_state = 44, .external_lex_state = 3},
  [59] = {.lex_state = 44, .external_lex_state = 3},
  [60] = {.lex_state = 44, .external_lex_state = 3},
  [61] = {.lex_state = 44, .external_lex_state = 3},
  [62] = {.lex_state = 44, .external_lex_state = 3},
  [63] = {.lex_state = 44, .external_lex_state = 3},
  [64] = {.lex_state = 44, .external_lex_state = 3},
  [65] = {.lex_state = 44, .external_lex_state = 3},
  [66] = {.lex_state = 44, .external_lex_state = 3},
  [67] = {.lex_state = 44, .external_lex_state = 3},
  [68] = {.lex_state = 44, .external_lex_state = 3},
  [69] = {.lex_state = 44, .external_lex_state = 3},
  [70] = {.lex_state = 44, .external_lex_state = 4},
  [71] = {.lex_state = 44, .external_lex_state = 3},
  [72] = {.lex_state = 44, .external_lex_state = 3},
  [73] = {.lex_state = 44, .external_lex_state = 5},
  [74] = {.lex_state = 44, .external_lex_state = 5},
  [75] = {.lex_state = 44, .external_lex_state = 3},
  [76] = {.lex_state = 44, .external_lex_state = 3},
  [77] = {.lex_state = 44, .external_lex_state = 5},
  [78] = {.lex_state = 44, .external_lex_state = 5},
  [79] = {.lex_state = 44, .external_lex_state = 5},
  [80] = {.lex_state = 44, .external_lex_state = 6},
  [81] = {.lex_state = 44, .external_lex_state = 7},
  [82] = {.lex_state = 44, .external_lex_state = 7},
  [83] = {.lex_state = 44, .external_lex_state = 7},
  [84] = {.lex_state = 44, .external_lex_state = 7},
  [85] = {.lex_state = 44, .external_lex_state = 7},
  [86] = {.lex_state = 44, .external_lex_state = 7},
  [87] = {.lex_state = 44, .external_lex_state = 7},
  [88] = {.lex_state = 44, .external_lex_state = 7},
  [89] = {.lex_state = 44, .external_lex_state = 7},
  [90] = {.lex_state = 44, .external_lex_state = 7},
  [91] = {.lex_state = 44, .external_lex_state = 8},
  [92] = {.lex_state = 44, .external_lex_state = 8},
  [93] = {.lex_state = 44, .external_lex_state = 8},
  [94] = {.lex_state = 44, .external_lex_state = 8},
  [95] = {.lex_state = 44, .external_lex_state = 8},
  [96] = {.lex_state = 1, .external_lex_state = 9},
  [97] = {.lex_state = 44, .external_lex_state = 10},
  [98] = {.lex_state = 1, .external_lex_state = 9},
  [99] = {.lex_state = 1, .external_lex_state = 9},
  [100] = {.lex_state = 1, .external_lex_state = 9},
  [101] = {.lex_state = 1, .external_lex_state = 9},
  [102] = {.lex_state = 1, .external_lex_state = 9},
  [103] = {.lex_state = 44, .external_lex_state = 11},
  [104] = {.lex_state = 44, .external_lex_state = 11},
  [105] = {.lex_state = 44, .external_lex_state = 11},
  [106] = {.lex_state = 44, .external_lex_state = 11},
  [107] = {.lex_state = 44, .external_lex_state = 11},
  [108] = {.lex_state = 44, .external_lex_state = 11},
  [109] = {.lex_state = 44, .external_lex_state = 10},
  [110] = {.lex_state = 44, .external_lex_state = 11},
  [111] = {.lex_state = 44, .external_lex_state = 11},
  [112] = {.lex_state = 44, .external_lex_state = 11},
  [113] = {.lex_state = 44, .external_lex_state = 11},
  [114] = {.lex_state = 44, .external_lex_state = 11},
  [115] = {.lex_state = 44, .external_lex_state = 11},
  [116] = {.lex_state = 44, .external_lex_state = 11},
  [117] = {.lex_state = 44, .external_lex_state = 11},
  [118] = {.lex_state = 44, .external_lex_state = 11},
  [119] = {.lex_state = 44, .external_lex_state = 11},
  [120] = {.lex_state = 44, .external_lex_state = 11},
  [121] = {.lex_state = 44, .external_lex_state = 11},
  [122] = {.lex_state = 44, .external_lex_state = 11},
  [123] = {.lex_state = 44, .external_lex_state = 11},
  [124] = {.lex_state = 44, .external_lex_state = 11},
  [125] = {.lex_state = 44, .external_lex_state = 12},
  [126] = {.lex_state = 44, .external_lex_state = 12},
  [127] = {.lex_state = 44, .external_lex_state = 12},
  [128] = {.lex_state = 44, .external_lex_state = 12},
  [129] = {.lex_state = 44, .external_lex_state = 12},
  [130] = {.lex_state = 44, .external_lex_state = 12},
  [131] = {.lex_state = 44, .external_lex_state = 12},
  [132] = {.lex_state = 44, .external_lex_state = 12},
  [133] = {.lex_state = 44, .external_lex_state = 12},
  [134] = {.lex_state = 44, .external_lex_state = 13},
  [135] = {.lex_state = 44, .external_lex_state = 12},
  [136] = {.lex_state = 44, .external_lex_state = 14},
  [137] = {.lex_state = 44, .external_lex_state = 15},
  [138] = {.lex_state = 44, .external_lex_state = 12},
  [139] = {.lex_state = 44, .external_lex_state = 12},
  [140] = {.lex_state = 44, .external_lex_state = 16},
  [141] = {.lex_state = 44, .external_lex_state = 17},
  [142] = {.lex_state = 44, .external_lex_state = 17},
  [143] = {.lex_state = 44, .external_lex_state = 18},
  [144] = {.lex_state = 44, .external_lex_state = 18},
  [145] = {.lex_state = 44, .external_lex_state = 14},
  [146] = {.lex_state = 44, .external_lex_state = 19},
  [147] = {.lex_state = 44, .external_lex_state = 19},
  [148] = {.lex_state = 44, .external_lex_state = 20},
  [149] = {.lex_state = 44, .external_lex_state = 20},
  [150] = {.lex_state = 44, .external_lex_state = 21},
  [151] = {.lex_state = 44, .external_lex_state = 21},
  [152] = {.lex_state = 44, .external_lex_state = 22},
  [153] = {.lex_state = 44, .external_lex_state = 22},
  [154] = {.lex_state = 44, .external_lex_state = 12},
  [155] = {.lex_state = 44, .external_lex_state = 23},
  [156] = {.lex_state = 44, .external_lex_state = 23},
  [157] = {.lex_state = 3, .external_lex_state = 12},
  [158] = {.lex_state = 3, .external_lex_state = 12},
  [159] = {.lex_state = 44, .external_lex_state = 15},
  [160] = {.lex_state = 44, .external_lex_state = 15},
  [161] = {.lex_state = 44, .external_lex_state = 12},
  [162] = {.lex_state = 44, .external_lex_state = 12},
  [163] = {.lex_state = 44, .external_lex_state = 12},
  [164] = {.lex_state = 44, .external_lex_state = 12},
  [165] = {.lex_state = 44, .external_lex_state = 12},
  [166] = {.lex_state = 44, .external_lex_state = 12},
  [167] = {.lex_state = 44, .external_lex_state = 12},
  [168] = {.lex_state = 44, .external_lex_state = 12},
  [169] = {.lex_state = 44, .external_lex_state = 13},
  [170] = {.lex_state = 44, .external_lex_state = 16},
  [171] = {.lex_state = 44, .external_lex_state = 16},
  [172] = {.lex_state = 44, .external_lex_state = 12},
  [173] = {.lex_state = 44, .external_lex_state = 12},
  [174] = {.lex_state = 44, .external_lex_state = 12},
  [175] = {.lex_state = 44, .external_lex_state = 12},
  [176] = {.lex_state = 44, .external_lex_state = 12},
  [177] = {.lex_state = 44, .external_lex_state = 12},
  [178] = {.lex_state = 44, .external_lex_state = 12},
  [179] = {.lex_state = 44, .external_lex_state = 12},
  [180] = {.lex_state = 44, .external_lex_state = 12},
  [181] = {.lex_state = 44, .external_lex_state = 12},
  [182] = {.lex_state = 44, .external_lex_state = 12},
  [183] = {.lex_state = 44, .external_lex_state = 12},
  [184] = {.lex_state = 44, .external_lex_state = 12},
  [185] = {.lex_state = 44, .external_lex_state = 12},
  [186] = {.lex_state = 44, .external_lex_state = 12},
  [187] = {.lex_state = 44, .external_lex_state = 12},
  [188] = {.lex_state = 44, .external_lex_state = 12},
  [189] = {.lex_state = 44, .external_lex_state = 12},
  [190] = {.lex_state = 44, .external_lex_state = 12},
  [191] = {.lex_state = 44, .external_lex_state = 12},
  [192] = {.lex_state = 44, .external_lex_state = 12},
  [193] = {.lex_state = 44, .external_lex_state = 12},
  [194] = {.lex_state = 44, .external_lex_state = 12},
  [195] = {.lex_state = 44, .external_lex_state = 12},
  [196] = {.lex_state = 44, .external_lex_state = 12},
  [197] = {.lex_state = 44, .external_lex_state = 12},
  [198] = {.lex_state = 44, .external_lex_state = 12},
  [199] = {.lex_state = 44, .external_lex_state = 12},
  [200] = {.lex_state = 44, .external_lex_state = 12},
  [201] = {.lex_state = 44, .external_lex_state = 12},
  [202] = {.lex_state = 44, .external_lex_state = 12},
  [203] = {.lex_state = 44, .external_lex_state = 12},
  [204] = {.lex_state = 44, .external_lex_state = 12},
  [205] = {.lex_state = 44, .external_lex_state = 12},
  [206] = {.lex_state = 44, .external_lex_state = 12},
  [207] = {.lex_state = 44, .external_lex_state = 12},
  [208] = {.lex_state = 44, .external_lex_state = 12},
  [209] = {.lex_state = 44, .external_lex_state = 12},
  [210] = {.lex_state = 44, .external_lex_state = 12},
  [211] = {.lex_state = 44, .external_lex_state = 12},
  [212] = {.lex_state = 44, .external_lex_state = 12},
  [213] = {.lex_state = 44, .external_lex_state = 12},
  [214] = {.lex_state = 44, .external_lex_state = 12},
  [215] = {.lex_state = 44, .external_lex_state = 12},
  [216] = {.lex_state = 44, .external_lex_state = 12},
  [217] = {.lex_state = 44, .external_lex_state = 12},
  [218] = {.lex_state = 44, .external_lex_state = 12},
  [219] = {.lex_state = 44, .external_lex_state = 12},
  [220] = {.lex_state = 44, .external_lex_state = 12},
  [221] = {.lex_state = 44, .external_lex_state = 12},
  [222] = {.lex_state = 44, .external_lex_state = 12},
  [223] = {.lex_state = 44, .external_lex_state = 12},
  [224] = {.lex_state = 44, .external_lex_state = 12},
  [225] = {.lex_state = 44, .external_lex_state = 12},
  [226] = {.lex_state = 44, .external_lex_state = 12},
  [227] = {.lex_state = 44, .external_lex_state = 12},
  [228] = {.lex_state = 44, .external_lex_state = 12},
  [229] = {.lex_state = 44, .external_lex_state = 12},
  [230] = {.lex_state = 44, .external_lex_state = 12},
  [231] = {.lex_state = 44, .external_lex_state = 12},
  [232] = {.lex_state = 44, .external_lex_state = 12},
  [233] = {.lex_state = 44, .external_lex_state = 12},
  [234] = {.lex_state = 44, .external_lex_state = 12},
  [235] = {.lex_state = 44, .external_lex_state = 12},
  [236] = {.lex_state = 44, .external_lex_state = 12},
  [237] = {.lex_state = 44, .external_lex_state = 12},
  [238] = {.lex_state = 44, .external_lex_state = 12},
  [239] = {.lex_state = 44, .external_lex_state = 12},
  [240] = {.lex_state = 44, .external_lex_state = 12},
  [241] = {.lex_state = 44, .external_lex_state = 12},
  [242] = {.lex_state = 44, .external_lex_state = 12},
  [243] = {.lex_state = 44, .external_lex_state = 12},
  [244] = {.lex_state = 44, .external_lex_state = 12},
  [245] = {.lex_state = 44, .external_lex_state = 12},
  [246] = {.lex_state = 44, .external_lex_state = 12},
  [247] = {.lex_state = 44, .external_lex_state = 12},
  [248] = {.lex_state = 44, .external_lex_state = 12},
  [249] = {.lex_state = 44, .external_lex_state = 12},
  [250] = {.lex_state = 44, .external_lex_state = 12},
  [251] = {.lex_state = 44, .external_lex_state = 12},
  [252] = {.lex_state = 44, .external_lex_state = 12},
  [253] = {.lex_state = 44, .external_lex_state = 12},
  [254] = {.lex_state = 44, .external_lex_state = 12},
  [255] = {.lex_state = 44, .external_lex_state = 12},
  [256] = {.lex_state = 44, .external_lex_state = 12},
  [257] = {.lex_state = 44, .external_lex_state = 12},
  [258] = {.lex_state = 44, .external_lex_state = 12},
  [259] = {.lex_state = 44, .external_lex_state = 12},
  [260] = {.lex_state = 44, .external_lex_state = 12},
  [261] = {.lex_state = 44, .external_lex_state = 12},
  [262] = {.lex_state = 44, .external_lex_state = 12},
  [263] = {.lex_state = 44, .external_lex_state = 12},
  [264] = {.lex_state = 44, .external_lex_state = 12},
  [265] = {.lex_state = 44, .external_lex_state = 12},
  [266] = {.lex_state = 44, .external_lex_state = 12},
  [267] = {.lex_state = 44, .external_lex_state = 12},
  [268] = {.lex_state = 44, .external_lex_state = 12},
  [269] = {.lex_state = 44, .external_lex_state = 12},
  [270] = {.lex_state = 44, .external_lex_state = 12},
  [271] = {.lex_state = 44, .external_lex_state = 12},
  [272] = {.lex_state = 44, .external_lex_state = 12},
  [273] = {.lex_state = 44, .external_lex_state = 12},
  [274] = {.lex_state = 44, .external_lex_state = 12},
  [275] = {.lex_state = 44, .external_lex_state = 12},
  [276] = {.lex_state = 44, .external_lex_state = 12},
  [277] = {.lex_state = 44, .external_lex_state = 12},
  [278] = {.lex_state = 44, .external_lex_state = 12},
  [279] = {.lex_state = 44, .external_lex_state = 12},
  [280] = {.lex_state = 44, .external_lex_state = 12},
  [281] = {.lex_state = 44, .external_lex_state = 12},
  [282] = {.lex_state = 44, .external_lex_state = 12},
  [283] = {.lex_state = 44, .external_lex_state = 12},
  [284] = {.lex_state = 44, .external_lex_state = 12},
  [285] = {.lex_state = 44, .external_lex_state = 12},
  [286] = {.lex_state = 44, .external_lex_state = 12},
  [287] = {.lex_state = 44, .external_lex_state = 12},
  [288] = {.lex_state = 44, .external_lex_state = 13},
  [289] = {.lex_state = 44, .external_lex_state = 14},
  [290] = {.lex_state = 44, .external_lex_state = 24},
  [291] = {.lex_state = 44, .external_lex_state = 13},
  [292] = {.lex_state = 44, .external_lex_state = 13},
  [293] = {.lex_state = 44, .external_lex_state = 25},
  [294] = {.lex_state = 44, .external_lex_state = 13},
  [295] = {.lex_state = 44, .external_lex_state = 26},
  [296] = {.lex_state = 44, .external_lex_state = 26},
  [297] = {.lex_state = 44, .external_lex_state = 26},
  [298] = {.lex_state = 44, .external_lex_state = 14},
  [299] = {.lex_state = 44, .external_lex_state = 14},
  [300] = {.lex_state = 44, .external_lex_state = 14},
  [301] = {.lex_state = 44, .external_lex_state = 14},
  [302] = {.lex_state = 44, .external_lex_state = 25},
  [303] = {.lex_state = 44, .external_lex_state = 25},
  [304] = {.lex_state = 44, .external_lex_state = 27},
  [305] = {.lex_state = 44, .external_lex_state = 27},
  [306] = {.lex_state = 44, .external_lex_state = 13},
  [307] = {.lex_state = 44, .external_lex_state = 14},
  [308] = {.lex_state = 44, .external_lex_state = 14},
  [309] = {.lex_state = 44, .external_lex_state = 14},
  [310] = {.lex_state = 44, .external_lex_state = 28},
  [311] = {.lex_state = 44, .external_lex_state = 27},
  [312] = {.lex_state = 44, .external_lex_state = 28},
  [313] = {.lex_state = 44, .external_lex_state = 28},
  [314] = {.lex_state = 44, .external_lex_state = 26},
  [315] = {.lex_state = 44, .external_lex_state = 26},
  [316] = {.lex_state = 44, .external_lex_state = 26},
  [317] = {.lex_state = 44, .external_lex_state = 27},
  [318] = {.lex_state = 44, .external_lex_state = 27},
  [319] = {.lex_state = 44, .external_lex_state = 25},
  [320] = {.lex_state = 44, .external_lex_state = 27},
  [321] = {.lex_state = 44, .external_lex_state = 13},
  [322] = {.lex_state = 44, .external_lex_state = 28},
  [323] = {.lex_state = 44, .external_lex_state = 13},
  [324] = {.lex_state = 44, .external_lex_state = 13},
  [325] = {.lex_state = 44, .external_lex_state = 4},
  [326] = {.lex_state = 44, .external_lex_state = 3},
  [327] = {.lex_state = 44, .external_lex_state = 3},
  [328] = {.lex_state = 44, .external_lex_state = 3},
  [329] = {.lex_state = 44, .external_lex_state = 4},
  [330] = {.lex_state = 44, .external_lex_state = 3},
  [331] = {.lex_state = 44, .external_lex_state = 4},
  [332] = {.lex_state = 44, .external_lex_state = 4},
  [333] = {.lex_state = 44, .external_lex_state = 3},
  [334] = {.lex_state = 44, .external_lex_state = 3},
  [335] = {.lex_state = 44, .external_lex_state = 3},
  [336] = {.lex_state = 44, .external_lex_state = 3},
  [337] = {.lex_state = 44, .external_lex_state = 3},
  [338] = {.lex_state = 44, .external_lex_state = 3},
  [339] = {.lex_state = 44, .external_lex_state = 3},
  [340] = {.lex_state = 44, .external_lex_state = 3},
  [341] = {.lex_state = 44, .external_lex_state = 3},
  [342] = {.lex_state = 44, .external_lex_state = 3},
  [343] = {.lex_state = 44, .external_lex_state = 3},
  [344] = {.lex_state = 44, .external_lex_state = 3},
  [345] = {.lex_state = 44, .external_lex_state = 3},
  [346] = {.lex_state = 44, .external_lex_state = 3},
  [347] = {.lex_state = 44, .external_lex_state = 3},
  [348] = {.lex_state = 44, .external_lex_state = 3},
  [349] = {.lex_state = 44, .external_lex_state = 3},
  [350] = {.lex_state = 44, .external_lex_state = 3},
  [351] = {.lex_state = 44, .external_lex_state = 3},
  [352] = {.lex_state = 44, .external_lex_state = 3},
  [353] = {.lex_state = 44, .external_lex_state = 3},
  [354] = {.lex_state = 44, .external_lex_state = 3},
  [355] = {.lex_state = 44, .external_lex_state = 3},
  [356] = {.lex_state = 44, .external_lex_state = 3},
  [357] = {.lex_state = 44, .external_lex_state = 3},
  [358] = {.lex_state = 44, .external_lex_state = 3},
  [359] = {.lex_state = 44, .external_lex_state = 4},
  [360] = {.lex_state = 44, .external_lex_state = 4},
  [361] = {.lex_state = 44, .external_lex_state = 3},
  [362] = {.lex_state = 44, .external_lex_state = 4},
  [363] = {.lex_state = 44, .external_lex_state = 3},
  [364] = {.lex_state = 44, .external_lex_state = 3},
  [365] = {.lex_state = 44, .external_lex_state = 3},
  [366] = {.lex_state = 44, .external_lex_state = 3},
  [367] = {.lex_state = 44, .external_lex_state = 3},
  [368] = {.lex_state = 44, .external_lex_state = 4},
  [369] = {.lex_state = 44, .external_lex_state = 4},
  [370] = {.lex_state = 44, .external_lex_state = 4},
  [371] = {.lex_state = 44, .external_lex_state = 4},
  [372] = {.lex_state = 44, .external_lex_state = 4},
  [373] = {.lex_state = 44, .external_lex_state = 4},
  [374] = {.lex_state = 44, .external_lex_state = 3},
  [375] = {.lex_state = 44, .external_lex_state = 4},
  [376] = {.lex_state = 44, .external_lex_state = 4},
  [377] = {.lex_state = 44, .external_lex_state = 4},
  [378] = {.lex_state = 44, .external_lex_state = 4},
  [379] = {.lex_state = 44, .external_lex_state = 4},
  [380] = {.lex_state = 44, .external_lex_state = 4},
  [381] = {.lex_state = 44, .external_lex_state = 4},
  [382] = {.lex_state = 44, .external_lex_state = 4},
  [383] = {.lex_state = 44, .external_lex_state = 4},
  [384] = {.lex_state = 44, .external_lex_state = 4},
  [385] = {.lex_state = 44, .external_lex_state = 4},
  [386] = {.lex_state = 44, .external_lex_state = 4},
  [387] = {.lex_state = 44, .external_lex_state = 4},
  [388] = {.lex_state = 44, .external_lex_state = 4},
  [389] = {.lex_state = 44, .external_lex_state = 4},
  [390] = {.lex_state = 44, .external_lex_state = 4},
  [391] = {.lex_state = 44, .external_lex_state = 3},
  [392] = {.lex_state = 44, .external_lex_state = 4},
  [393] = {.lex_state = 44, .external_lex_state = 3},
  [394] = {.lex_state = 44, .external_lex_state = 3},
  [395] = {.lex_state = 44, .external_lex_state = 4},
  [396] = {.lex_state = 44, .external_lex_state = 3},
  [397] = {.lex_state = 44, .external_lex_state = 3},
  [398] = {.lex_state = 44, .external_lex_state = 3},
  [399] = {.lex_state = 44, .external_lex_state = 4},
  [400] = {.lex_state = 44, .external_lex_state = 3},
  [401] = {.lex_state = 44, .external_lex_state = 4},
  [402] = {.lex_state = 44, .external_lex_state = 3},
  [403] = {.lex_state = 44, .external_lex_state = 4},
  [404] = {.lex_state = 44, .external_lex_state = 3},
  [405] = {.lex_state = 44, .external_lex_state = 3},
  [406] = {.lex_state = 44, .external_lex_state = 4},
  [407] = {.lex_state = 44, .external_lex_state = 4},
  [408] = {.lex_state = 44, .external_lex_state = 3},
  [409] = {.lex_state = 44, .external_lex_state = 3},
  [410] = {.lex_state = 44, .external_lex_state = 4},
  [411] = {.lex_state = 44, .external_lex_state = 3},
  [412] = {.lex_state = 44, .external_lex_state = 4},
  [413] = {.lex_state = 44, .external_lex_state = 3},
  [414] = {.lex_state = 44, .external_lex_state = 4},
  [415] = {.lex_state = 44, .external_lex_state = 4},
  [416] = {.lex_state = 44, .external_lex_state = 4},
  [417] = {.lex_state = 44, .external_lex_state = 4},
  [418] = {.lex_state = 44, .external_lex_state = 4},
  [419] = {.lex_state = 44, .external_lex_state = 4},
  [420] = {.lex_state = 44, .external_lex_state = 4},
  [421] = {.lex_state = 44, .external_lex_state = 4},
  [422] = {.lex_state = 44, .external_lex_state = 4},
  [423] = {.lex_state = 44, .external_lex_state = 4},
  [424] = {.lex_state = 44, .external_lex_state = 4},
  [425] = {.lex_state = 44, .external_lex_state = 4},
  [426] = {.lex_state = 44, .external_lex_state = 4},
  [427] = {.lex_state = 44, .external_lex_state = 4},
  [428] = {.lex_state = 44, .external_lex_state = 3},
  [429] = {.lex_state = 44, .external_lex_state = 6},
  [430] = {.lex_state = 44, .external_lex_state = 6},
  [431] = {.lex_state = 44, .external_lex_state = 29},
  [432] = {.lex_state = 44, .external_lex_state = 29},
  [433] = {.lex_state = 44, .external_lex_state = 30},
  [434] = {.lex_state = 44, .external_lex_state = 30},
  [435] = {.lex_state = 44, .external_lex_state = 29},
  [436] = {.lex_state = 44, .external_lex_state = 30},
  [437] = {.lex_state = 21, .external_lex_state = 18},
  [438] = {.lex_state = 21, .external_lex_state = 16},
  [439] = {.lex_state = 21, .external_lex_state = 22},
  [440] = {.lex_state = 19, .external_lex_state = 12},
  [441] = {.lex_state = 21, .external_lex_state = 23},
  [442] = {.lex_state = 21, .external_lex_state = 15},
  [443] = {.lex_state = 21, .external_lex_state = 17},
  [444] = {.lex_state = 21, .external_lex_state = 31},
  [445] = {.lex_state = 21, .external_lex_state = 32},
  [446] = {.lex_state = 21, .external_lex_state = 19},
  [447] = {.lex_state = 21, .external_lex_state = 20},
  [448] = {.lex_state = 21, .external_lex_state = 21},
  [449] = {.lex_state = 21, .external_lex_state = 22},
  [450] = {.lex_state = 21, .external_lex_state = 21},
  [451] = {.lex_state = 21, .external_lex_state = 22},
  [452] = {.lex_state = 21, .external_lex_state = 18},
  [453] = {.lex_state = 21, .external_lex_state = 18},
  [454] = {.lex_state = 21, .external_lex_state = 23},
  [455] = {.lex_state = 21, .external_lex_state = 23},
  [456] = {.lex_state = 19, .external_lex_state = 12},
  [457] = {.lex_state = 19, .external_lex_state = 12},
  [458] = {.lex_state = 21, .external_lex_state = 15},
  [459] = {.lex_state = 21, .external_lex_state = 16},
  [460] = {.lex_state = 21, .external_lex_state = 31},
  [461] = {.lex_state = 21, .external_lex_state = 17},
  [462] = {.lex_state = 21, .external_lex_state = 15},
  [463] = {.lex_state = 21, .external_lex_state = 31},
  [464] = {.lex_state = 21, .external_lex_state = 32},
  [465] = {.lex_state = 21, .external_lex_state = 32},
  [466] = {.lex_state = 21, .external_lex_state = 12},
  [467] = {.lex_state = 21, .external_lex_state = 16},
  [468] = {.lex_state = 21, .external_lex_state = 19},
  [469] = {.lex_state = 21, .external_lex_state = 19},
  [470] = {.lex_state = 21, .external_lex_state = 20},
  [471] = {.lex_state = 21, .external_lex_state = 20},
  [472] = {.lex_state = 21, .external_lex_state = 17},
  [473] = {.lex_state = 21, .external_lex_state = 21},
  [474] = {.lex_state = 23, .external_lex_state = 32},
  [475] = {.lex_state = 23, .external_lex_state = 17},
  [476] = {.lex_state = 20, .external_lex_state = 12},
  [477] = {.lex_state = 23, .external_lex_state = 16},
  [478] = {.lex_state = 23, .external_lex_state = 21},
  [479] = {.lex_state = 23, .external_lex_state = 22},
  [480] = {.lex_state = 23, .external_lex_state = 23},
  [481] = {.lex_state = 23, .external_lex_state = 19},
  [482] = {.lex_state = 23, .external_lex_state = 15},
  [483] = {.lex_state = 21, .external_lex_state = 12},
  [484] = {.lex_state = 21, .external_lex_state = 12},
  [485] = {.lex_state = 23, .external_lex_state = 20},
  [486] = {.lex_state = 23, .external_lex_state = 18},
  [487] = {.lex_state = 23, .external_lex_state = 31},
  [488] = {.lex_state = 18, .external_lex_state = 15},
  [489] = {.lex_state = 21, .external_lex_state = 33},
  [490] = {.lex_state = 6, .external_lex_state = 22},
  [491] = {.lex_state = 6, .external_lex_state = 18},
  [492] = {.lex_state = 21, .external_lex_state = 16},
  [493] = {.lex_state = 21, .external_lex_state = 18},
  [494] = {.lex_state = 6, .external_lex_state = 16},
  [495] = {.lex_state = 21, .external_lex_state = 22},
  [496] = {.lex_state = 21, .external_lex_state = 31},
  [497] = {.lex_state = 25, .external_lex_state = 15},
  [498] = {.lex_state = 21, .external_lex_state = 34},
  [499] = {.lex_state = 21, .external_lex_state = 34},
  [500] = {.lex_state = 25, .external_lex_state = 23},
  [501] = {.lex_state = 25, .external_lex_state = 31},
  [502] = {.lex_state = 21, .external_lex_state = 35},
  [503] = {.lex_state = 21, .external_lex_state = 36},
  [504] = {.lex_state = 21, .external_lex_state = 36},
  [505] = {.lex_state = 6, .external_lex_state = 31},
  [506] = {.lex_state = 21, .external_lex_state = 35},
  [507] = {.lex_state = 18, .external_lex_state = 23},
  [508] = {.lex_state = 18, .external_lex_state = 31},
  [509] = {.lex_state = 18, .external_lex_state = 22},
  [510] = {.lex_state = 6, .external_lex_state = 15},
  [511] = {.lex_state = 25, .external_lex_state = 18},
  [512] = {.lex_state = 21, .external_lex_state = 15},
  [513] = {.lex_state = 21, .external_lex_state = 21},
  [514] = {.lex_state = 21, .external_lex_state = 17},
  [515] = {.lex_state = 6, .external_lex_state = 23},
  [516] = {.lex_state = 21, .external_lex_state = 23},
  [517] = {.lex_state = 25, .external_lex_state = 32},
  [518] = {.lex_state = 21, .external_lex_state = 37},
  [519] = {.lex_state = 21, .external_lex_state = 37},
  [520] = {.lex_state = 18, .external_lex_state = 32},
  [521] = {.lex_state = 25, .external_lex_state = 22},
  [522] = {.lex_state = 21, .external_lex_state = 38},
  [523] = {.lex_state = 25, .external_lex_state = 17},
  [524] = {.lex_state = 6, .external_lex_state = 32},
  [525] = {.lex_state = 21, .external_lex_state = 38},
  [526] = {.lex_state = 21, .external_lex_state = 32},
  [527] = {.lex_state = 21, .external_lex_state = 39},
  [528] = {.lex_state = 6, .external_lex_state = 17},
  [529] = {.lex_state = 25, .external_lex_state = 16},
  [530] = {.lex_state = 25, .external_lex_state = 19},
  [531] = {.lex_state = 21, .external_lex_state = 40},
  [532] = {.lex_state = 21, .external_lex_state = 40},
  [533] = {.lex_state = 18, .external_lex_state = 19},
  [534] = {.lex_state = 19, .external_lex_state = 41},
  [535] = {.lex_state = 23, .external_lex_state = 12},
  [536] = {.lex_state = 21, .external_lex_state = 39},
  [537] = {.lex_state = 6, .external_lex_state = 19},
  [538] = {.lex_state = 21, .external_lex_state = 19},
  [539] = {.lex_state = 18, .external_lex_state = 17},
  [540] = {.lex_state = 19, .external_lex_state = 41},
  [541] = {.lex_state = 17, .external_lex_state = 12},
  [542] = {.lex_state = 25, .external_lex_state = 20},
  [543] = {.lex_state = 21, .external_lex_state = 42},
  [544] = {.lex_state = 21, .external_lex_state = 42},
  [545] = {.lex_state = 18, .external_lex_state = 20},
  [546] = {.lex_state = 18, .external_lex_state = 18},
  [547] = {.lex_state = 6, .external_lex_state = 21},
  [548] = {.lex_state = 21, .external_lex_state = 43},
  [549] = {.lex_state = 6, .external_lex_state = 20},
  [550] = {.lex_state = 21, .external_lex_state = 20},
  [551] = {.lex_state = 21, .external_lex_state = 33},
  [552] = {.lex_state = 21, .external_lex_state = 43},
  [553] = {.lex_state = 18, .external_lex_state = 16},
  [554] = {.lex_state = 25, .external_lex_state = 21},
  [555] = {.lex_state = 21, .external_lex_state = 44},
  [556] = {.lex_state = 21, .external_lex_state = 44},
  [557] = {.lex_state = 18, .external_lex_state = 21},
  [558] = {.lex_state = 5, .external_lex_state = 12},
  [559] = {.lex_state = 19, .external_lex_state = 12},
  [560] = {.lex_state = 24, .external_lex_state = 12},
  [561] = {.lex_state = 44, .external_lex_state = 45},
  [562] = {.lex_state = 21, .external_lex_state = 31},
  [563] = {.lex_state = 21, .external_lex_state = 31},
  [564] = {.lex_state = 21, .external_lex_state = 31},
  [565] = {.lex_state = 21, .external_lex_state = 31},
  [566] = {.lex_state = 21, .external_lex_state = 31},
  [567] = {.lex_state = 21, .external_lex_state = 31},
  [568] = {.lex_state = 21, .external_lex_state = 16},
  [569] = {.lex_state = 21, .external_lex_state = 31},
  [570] = {.lex_state = 21, .external_lex_state = 31},
  [571] = {.lex_state = 21, .external_lex_state = 16},
  [572] = {.lex_state = 21, .external_lex_state = 16},
  [573] = {.lex_state = 21, .external_lex_state = 31},
  [574] = {.lex_state = 21, .external_lex_state = 31},
  [575] = {.lex_state = 21, .external_lex_state = 16},
  [576] = {.lex_state = 21, .external_lex_state = 31},
  [577] = {.lex_state = 21, .external_lex_state = 31},
  [578] = {.lex_state = 21, .external_lex_state = 31},
  [579] = {.lex_state = 21, .external_lex_state = 31},
  [580] = {.lex_state = 21, .external_lex_state = 31},
  [581] = {.lex_state = 21, .external_lex_state = 31},
  [582] = {.lex_state = 21, .external_lex_state = 31},
  [583] = {.lex_state = 21, .external_lex_state = 31},
  [584] = {.lex_state = 21, .external_lex_state = 31},
  [585] = {.lex_state = 21, .external_lex_state = 31},
  [586] = {.lex_state = 21, .external_lex_state = 31},
  [587] = {.lex_state = 21, .external_lex_state = 31},
  [588] = {.lex_state = 44, .external_lex_state = 46},
  [589] = {.lex_state = 21, .external_lex_state = 32},
  [590] = {.lex_state = 21, .external_lex_state = 32},
  [591] = {.lex_state = 21, .external_lex_state = 32},
  [592] = {.lex_state = 1, .external_lex_state = 9},
  [593] = {.lex_state = 21, .external_lex_state = 32},
  [594] = {.lex_state = 21, .external_lex_state = 32},
  [595] = {.lex_state = 21, .external_lex_state = 32},
  [596] = {.lex_state = 21, .external_lex_state = 32},
  [597] = {.lex_state = 21, .external_lex_state = 32},
  [598] = {.lex_state = 21, .external_lex_state = 32},
  [599] = {.lex_state = 21, .external_lex_state = 32},
  [600] = {.lex_state = 21, .external_lex_state = 32},
  [601] = {.lex_state = 21, .external_lex_state = 32},
  [602] = {.lex_state = 21, .external_lex_state = 32},
  [603] = {.lex_state = 21, .external_lex_state = 32},
  [604] = {.lex_state = 21, .external_lex_state = 32},
  [605] = {.lex_state = 21, .external_lex_state = 32},
  [606] = {.lex_state = 21, .external_lex_state = 32},
  [607] = {.lex_state = 21, .external_lex_state = 32},
  [608] = {.lex_state = 21, .external_lex_state = 32},
  [609] = {.lex_state = 21, .external_lex_state = 32},
  [610] = {.lex_state = 21, .external_lex_state = 32},
  [611] = {.lex_state = 21, .external_lex_state = 32},
  [612] = {.lex_state = 21, .external_lex_state = 32},
  [613] = {.lex_state = 21, .external_lex_state = 32},
  [614] = {.lex_state = 21, .external_lex_state = 32},
  [615] = {.lex_state = 21, .external_lex_state = 32},
  [616] = {.lex_state = 44, .external_lex_state = 47},
  [617] = {.lex_state = 21, .external_lex_state = 19},
  [618] = {.lex_state = 21, .external_lex_state = 19},
  [619] = {.lex_state = 21, .external_lex_state = 19},
  [620] = {.lex_state = 21, .external_lex_state = 19},
  [621] = {.lex_state = 21, .external_lex_state = 19},
  [622] = {.lex_state = 21, .external_lex_state = 19},
  [623] = {.lex_state = 21, .external_lex_state = 19},
  [624] = {.lex_state = 21, .external_lex_state = 19},
  [625] = {.lex_state = 21, .external_lex_state = 19},
  [626] = {.lex_state = 21, .external_lex_state = 19},
  [627] = {.lex_state = 21, .external_lex_state = 19},
  [628] = {.lex_state = 21, .external_lex_state = 19},
  [629] = {.lex_state = 21, .external_lex_state = 19},
  [630] = {.lex_state = 21, .external_lex_state = 19},
  [631] = {.lex_state = 21, .external_lex_state = 19},
  [632] = {.lex_state = 21, .external_lex_state = 19},
  [633] = {.lex_state = 21, .external_lex_state = 19},
  [634] = {.lex_state = 21, .external_lex_state = 19},
  [635] = {.lex_state = 21, .external_lex_state = 19},
  [636] = {.lex_state = 21, .external_lex_state = 19},
  [637] = {.lex_state = 21, .external_lex_state = 19},
  [638] = {.lex_state = 21, .external_lex_state = 19},
  [639] = {.lex_state = 21, .external_lex_state = 19},
  [640] = {.lex_state = 21, .external_lex_state = 19},
  [641] = {.lex_state = 21, .external_lex_state = 19},
  [642] = {.lex_state = 21, .external_lex_state = 19},
  [643] = {.lex_state = 44, .external_lex_state = 48},
  [644] = {.lex_state = 21, .external_lex_state = 20},
  [645] = {.lex_state = 21, .external_lex_state = 20},
  [646] = {.lex_state = 21, .external_lex_state = 20},
  [647] = {.lex_state = 21, .external_lex_state = 20},
  [648] = {.lex_state = 21, .external_lex_state = 16},
  [649] = {.lex_state = 21, .external_lex_state = 20},
  [650] = {.lex_state = 21, .external_lex_state = 20},
  [651] = {.lex_state = 21, .external_lex_state = 20},
  [652] = {.lex_state = 21, .external_lex_state = 20},
  [653] = {.lex_state = 21, .external_lex_state = 20},
  [654] = {.lex_state = 21, .external_lex_state = 20},
  [655] = {.lex_state = 21, .external_lex_state = 16},
  [656] = {.lex_state = 21, .external_lex_state = 16},
  [657] = {.lex_state = 21, .external_lex_state = 20},
  [658] = {.lex_state = 21, .external_lex_state = 20},
  [659] = {.lex_state = 21, .external_lex_state = 20},
  [660] = {.lex_state = 21, .external_lex_state = 20},
  [661] = {.lex_state = 21, .external_lex_state = 20},
  [662] = {.lex_state = 21, .external_lex_state = 20},
  [663] = {.lex_state = 21, .external_lex_state = 20},
  [664] = {.lex_state = 21, .external_lex_state = 20},
  [665] = {.lex_state = 21, .external_lex_state = 20},
  [666] = {.lex_state = 21, .external_lex_state = 20},
  [667] = {.lex_state = 21, .external_lex_state = 20},
  [668] = {.lex_state = 21, .external_lex_state = 20},
  [669] = {.lex_state = 21, .external_lex_state = 20},
  [670] = {.lex_state = 21, .external_lex_state = 20},
  [671] = {.lex_state = 21, .external_lex_state = 20},
  [672] = {.lex_state = 21, .external_lex_state = 20},
  [673] = {.lex_state = 44, .external_lex_state = 49},
  [674] = {.lex_state = 21, .external_lex_state = 16},
  [675] = {.lex_state = 21, .external_lex_state = 16},
  [676] = {.lex_state = 21, .external_lex_state = 16},
  [677] = {.lex_state = 21, .external_lex_state = 21},
  [678] = {.lex_state = 21, .external_lex_state = 21},
  [679] = {.lex_state = 21, .external_lex_state = 21},
  [680] = {.lex_state = 21, .external_lex_state = 16},
  [681] = {.lex_state = 21, .external_lex_state = 16},
  [682] = {.lex_state = 21, .external_lex_state = 16},
  [683] = {.lex_state = 21, .external_lex_state = 21},
  [684] = {.lex_state = 21, .external_lex_state = 16},
  [685] = {.lex_state = 21, .external_lex_state = 21},
  [686] = {.lex_state = 21, .external_lex_state = 21},
  [687] = {.lex_state = 21, .external_lex_state = 21},
  [688] = {.lex_state = 21, .external_lex_state = 21},
  [689] = {.lex_state = 21, .external_lex_state = 21},
  [690] = {.lex_state = 21, .external_lex_state = 21},
  [691] = {.lex_state = 21, .external_lex_state = 16},
  [692] = {.lex_state = 21, .external_lex_state = 16},
  [693] = {.lex_state = 21, .external_lex_state = 16},
  [694] = {.lex_state = 21, .external_lex_state = 21},
  [695] = {.lex_state = 21, .external_lex_state = 21},
  [696] = {.lex_state = 21, .external_lex_state = 21},
  [697] = {.lex_state = 21, .external_lex_state = 21},
  [698] = {.lex_state = 21, .external_lex_state = 21},
  [699] = {.lex_state = 21, .external_lex_state = 21},
  [700] = {.lex_state = 21, .external_lex_state = 21},
  [701] = {.lex_state = 21, .external_lex_state = 21},
  [702] = {.lex_state = 21, .external_lex_state = 21},
  [703] = {.lex_state = 21, .external_lex_state = 21},
  [704] = {.lex_state = 21, .external_lex_state = 21},
  [705] = {.lex_state = 21, .external_lex_state = 21},
  [706] = {.lex_state = 21, .external_lex_state = 21},
  [707] = {.lex_state = 21, .external_lex_state = 21},
  [708] = {.lex_state = 21, .external_lex_state = 21},
  [709] = {.lex_state = 21, .external_lex_state = 21},
  [710] = {.lex_state = 21, .external_lex_state = 22},
  [711] = {.lex_state = 21, .external_lex_state = 22},
  [712] = {.lex_state = 21, .external_lex_state = 22},
  [713] = {.lex_state = 21, .external_lex_state = 22},
  [714] = {.lex_state = 21, .external_lex_state = 22},
  [715] = {.lex_state = 21, .external_lex_state = 22},
  [716] = {.lex_state = 21, .external_lex_state = 22},
  [717] = {.lex_state = 21, .external_lex_state = 22},
  [718] = {.lex_state = 21, .external_lex_state = 22},
  [719] = {.lex_state = 21, .external_lex_state = 22},
  [720] = {.lex_state = 21, .external_lex_state = 22},
  [721] = {.lex_state = 21, .external_lex_state = 22},
  [722] = {.lex_state = 21, .external_lex_state = 22},
  [723] = {.lex_state = 21, .external_lex_state = 22},
  [724] = {.lex_state = 21, .external_lex_state = 22},
  [725] = {.lex_state = 21, .external_lex_state = 22},
  [726] = {.lex_state = 21, .external_lex_state = 22},
  [727] = {.lex_state = 21, .external_lex_state = 22},
  [728] = {.lex_state = 21, .external_lex_state = 22},
  [729] = {.lex_state = 21, .external_lex_state = 22},
  [730] = {.lex_state = 21, .external_lex_state = 22},
  [731] = {.lex_state = 21, .external_lex_state = 22},
  [732] = {.lex_state = 21, .external_lex_state = 22},
  [733] = {.lex_state = 21, .external_lex_state = 22},
  [734] = {.lex_state = 21, .external_lex_state = 22},
  [735] = {.lex_state = 21, .external_lex_state = 22},
  [736] = {.lex_state = 3, .external_lex_state = 50},
  [737] = {.lex_state = 21, .external_lex_state = 23},
  [738] = {.lex_state = 21, .external_lex_state = 23},
  [739] = {.lex_state = 21, .external_lex_state = 23},
  [740] = {.lex_state = 21, .external_lex_state = 23},
  [741] = {.lex_state = 21, .external_lex_state = 16},
  [742] = {.lex_state = 21, .external_lex_state = 23},
  [743] = {.lex_state = 21, .external_lex_state = 23},
  [744] = {.lex_state = 21, .external_lex_state = 23},
  [745] = {.lex_state = 21, .external_lex_state = 31},
  [746] = {.lex_state = 21, .external_lex_state = 23},
  [747] = {.lex_state = 21, .external_lex_state = 23},
  [748] = {.lex_state = 21, .external_lex_state = 16},
  [749] = {.lex_state = 21, .external_lex_state = 23},
  [750] = {.lex_state = 21, .external_lex_state = 23},
  [751] = {.lex_state = 21, .external_lex_state = 23},
  [752] = {.lex_state = 21, .external_lex_state = 23},
  [753] = {.lex_state = 21, .external_lex_state = 23},
  [754] = {.lex_state = 21, .external_lex_state = 23},
  [755] = {.lex_state = 21, .external_lex_state = 23},
  [756] = {.lex_state = 21, .external_lex_state = 23},
  [757] = {.lex_state = 21, .external_lex_state = 23},
  [758] = {.lex_state = 21, .external_lex_state = 23},
  [759] = {.lex_state = 21, .external_lex_state = 23},
  [760] = {.lex_state = 21, .external_lex_state = 23},
  [761] = {.lex_state = 21, .external_lex_state = 23},
  [762] = {.lex_state = 21, .external_lex_state = 23},
  [763] = {.lex_state = 21, .external_lex_state = 23},
  [764] = {.lex_state = 21, .external_lex_state = 23},
  [765] = {.lex_state = 44, .external_lex_state = 51},
  [766] = {.lex_state = 19, .external_lex_state = 12},
  [767] = {.lex_state = 19, .external_lex_state = 12},
  [768] = {.lex_state = 19, .external_lex_state = 12},
  [769] = {.lex_state = 19, .external_lex_state = 12},
  [770] = {.lex_state = 19, .external_lex_state = 12},
  [771] = {.lex_state = 19, .external_lex_state = 12},
  [772] = {.lex_state = 19, .external_lex_state = 12},
  [773] = {.lex_state = 19, .external_lex_state = 12},
  [774] = {.lex_state = 19, .external_lex_state = 12},
  [775] = {.lex_state = 19, .external_lex_state = 12},
  [776] = {.lex_state = 21, .external_lex_state = 16},
  [777] = {.lex_state = 19, .external_lex_state = 12},
  [778] = {.lex_state = 19, .external_lex_state = 12},
  [779] = {.lex_state = 19, .external_lex_state = 12},
  [780] = {.lex_state = 19, .external_lex_state = 12},
  [781] = {.lex_state = 19, .external_lex_state = 12},
  [782] = {.lex_state = 19, .external_lex_state = 12},
  [783] = {.lex_state = 19, .external_lex_state = 12},
  [784] = {.lex_state = 19, .external_lex_state = 12},
  [785] = {.lex_state = 19, .external_lex_state = 12},
  [786] = {.lex_state = 19, .external_lex_state = 12},
  [787] = {.lex_state = 19, .external_lex_state = 12},
  [788] = {.lex_state = 19, .external_lex_state = 12},
  [789] = {.lex_state = 19, .external_lex_state = 12},
  [790] = {.lex_state = 19, .external_lex_state = 12},
  [791] = {.lex_state = 19, .external_lex_state = 12},
  [792] = {.lex_state = 19, .external_lex_state = 12},
  [793] = {.lex_state = 21, .external_lex_state = 15},
  [794] = {.lex_state = 21, .external_lex_state = 15},
  [795] = {.lex_state = 21, .external_lex_state = 15},
  [796] = {.lex_state = 21, .external_lex_state = 15},
  [797] = {.lex_state = 21, .external_lex_state = 15},
  [798] = {.lex_state = 21, .external_lex_state = 15},
  [799] = {.lex_state = 21, .external_lex_state = 15},
  [800] = {.lex_state = 21, .external_lex_state = 15},
  [801] = {.lex_state = 21, .external_lex_state = 15},
  [802] = {.lex_state = 21, .external_lex_state = 15},
  [803] = {.lex_state = 21, .external_lex_state = 15},
  [804] = {.lex_state = 21, .external_lex_state = 15},
  [805] = {.lex_state = 21, .external_lex_state = 15},
  [806] = {.lex_state = 21, .external_lex_state = 15},
  [807] = {.lex_state = 21, .external_lex_state = 15},
  [808] = {.lex_state = 21, .external_lex_state = 15},
  [809] = {.lex_state = 21, .external_lex_state = 15},
  [810] = {.lex_state = 21, .external_lex_state = 15},
  [811] = {.lex_state = 21, .external_lex_state = 15},
  [812] = {.lex_state = 21, .external_lex_state = 15},
  [813] = {.lex_state = 21, .external_lex_state = 15},
  [814] = {.lex_state = 21, .external_lex_state = 15},
  [815] = {.lex_state = 21, .external_lex_state = 15},
  [816] = {.lex_state = 21, .external_lex_state = 15},
  [817] = {.lex_state = 21, .external_lex_state = 15},
  [818] = {.lex_state = 21, .external_lex_state = 15},
  [819] = {.lex_state = 21, .external_lex_state = 16},
  [820] = {.lex_state = 25, .external_lex_state = 12},
  [821] = {.lex_state = 21, .external_lex_state = 41},
  [822] = {.lex_state = 21, .external_lex_state = 41},
  [823] = {.lex_state = 18, .external_lex_state = 12},
  [824] = {.lex_state = 21, .external_lex_state = 16},
  [825] = {.lex_state = 21, .external_lex_state = 16},
  [826] = {.lex_state = 6, .external_lex_state = 12},
  [827] = {.lex_state = 21, .external_lex_state = 12},
  [828] = {.lex_state = 21, .external_lex_state = 16},
  [829] = {.lex_state = 21, .external_lex_state = 16},
  [830] = {.lex_state = 21, .external_lex_state = 16},
  [831] = {.lex_state = 44, .external_lex_state = 52},
  [832] = {.lex_state = 44, .external_lex_state = 53},
  [833] = {.lex_state = 21, .external_lex_state = 17},
  [834] = {.lex_state = 21, .external_lex_state = 17},
  [835] = {.lex_state = 21, .external_lex_state = 17},
  [836] = {.lex_state = 44, .external_lex_state = 10},
  [837] = {.lex_state = 21, .external_lex_state = 17},
  [838] = {.lex_state = 21, .external_lex_state = 17},
  [839] = {.lex_state = 21, .external_lex_state = 17},
  [840] = {.lex_state = 21, .external_lex_state = 17},
  [841] = {.lex_state = 21, .external_lex_state = 17},
  [842] = {.lex_state = 21, .external_lex_state = 17},
  [843] = {.lex_state = 21, .external_lex_state = 17},
  [844] = {.lex_state = 44, .external_lex_state = 10},
  [845] = {.lex_state = 1, .external_lex_state = 9},
  [846] = {.lex_state = 21, .external_lex_state = 17},
  [847] = {.lex_state = 21, .external_lex_state = 17},
  [848] = {.lex_state = 21, .external_lex_state = 17},
  [849] = {.lex_state = 21, .external_lex_state = 17},
  [850] = {.lex_state = 21, .external_lex_state = 17},
  [851] = {.lex_state = 21, .external_lex_state = 17},
  [852] = {.lex_state = 21, .external_lex_state = 17},
  [853] = {.lex_state = 21, .external_lex_state = 17},
  [854] = {.lex_state = 21, .external_lex_state = 17},
  [855] = {.lex_state = 21, .external_lex_state = 17},
  [856] = {.lex_state = 21, .external_lex_state = 17},
  [857] = {.lex_state = 21, .external_lex_state = 17},
  [858] = {.lex_state = 21, .external_lex_state = 17},
  [859] = {.lex_state = 21, .external_lex_state = 17},
  [860] = {.lex_state = 21, .external_lex_state = 17},
  [861] = {.lex_state = 21, .external_lex_state = 17},
  [862] = {.lex_state = 44, .external_lex_state = 54},
  [863] = {.lex_state = 21, .external_lex_state = 18},
  [864] = {.lex_state = 21, .external_lex_state = 18},
  [865] = {.lex_state = 21, .external_lex_state = 18},
  [866] = {.lex_state = 21, .external_lex_state = 18},
  [867] = {.lex_state = 21, .external_lex_state = 18},
  [868] = {.lex_state = 21, .external_lex_state = 18},
  [869] = {.lex_state = 21, .external_lex_state = 18},
  [870] = {.lex_state = 21, .external_lex_state = 18},
  [871] = {.lex_state = 21, .external_lex_state = 18},
  [872] = {.lex_state = 21, .external_lex_state = 18},
  [873] = {.lex_state = 21, .external_lex_state = 18},
  [874] = {.lex_state = 21, .external_lex_state = 18},
  [875] = {.lex_state = 21, .external_lex_state = 18},
  [876] = {.lex_state = 21, .external_lex_state = 18},
  [877] = {.lex_state = 21, .external_lex_state = 18},
  [878] = {.lex_state = 21, .external_lex_state = 18},
  [879] = {.lex_state = 21, .external_lex_state = 18},
  [880] = {.lex_state = 21, .external_lex_state = 18},
  [881] = {.lex_state = 21, .external_lex_state = 18},
  [882] = {.lex_state = 21, .external_lex_state = 18},
  [883] = {.lex_state = 21, .external_lex_state = 18},
  [884] = {.lex_state = 21, .external_lex_state = 18},
  [885] = {.lex_state = 21, .external_lex_state = 18},
  [886] = {.lex_state = 21, .external_lex_state = 18},
  [887] = {.lex_state = 21, .external_lex_state = 18},
  [888] = {.lex_state = 21, .external_lex_state = 18},
  [889] = {.lex_state = 21, .external_lex_state = 31},
  [890] = {.lex_state = 21, .external_lex_state = 31},
  [891] = {.lex_state = 21, .external_lex_state = 31},
  [892] = {.lex_state = 21, .external_lex_state = 23},
  [893] = {.lex_state = 44, .external_lex_state = 18},
  [894] = {.lex_state = 44, .external_lex_state = 22},
  [895] = {.lex_state = 44, .external_lex_state = 15},
  [896] = {.lex_state = 44, .external_lex_state = 16},
  [897] = {.lex_state = 44, .external_lex_state = 22},
  [898] = {.lex_state = 44, .external_lex_state = 23},
  [899] = {.lex_state = 44, .external_lex_state = 32},
  [900] = {.lex_state = 44, .external_lex_state = 23},
  [901] = {.lex_state = 44, .external_lex_state = 23},
  [902] = {.lex_state = 21, .external_lex_state = 12},
  [903] = {.lex_state = 21, .external_lex_state = 12},
  [904] = {.lex_state = 21, .external_lex_state = 12},
  [905] = {.lex_state = 44, .external_lex_state = 19},
  [906] = {.lex_state = 44, .external_lex_state = 32},
  [907] = {.lex_state = 21, .external_lex_state = 12},
  [908] = {.lex_state = 44, .external_lex_state = 16},
  [909] = {.lex_state = 21, .external_lex_state = 12},
  [910] = {.lex_state = 21, .external_lex_state = 12},
  [911] = {.lex_state = 21, .external_lex_state = 12},
  [912] = {.lex_state = 21, .external_lex_state = 12},
  [913] = {.lex_state = 21, .external_lex_state = 12},
  [914] = {.lex_state = 21, .external_lex_state = 12},
  [915] = {.lex_state = 44, .external_lex_state = 20},
  [916] = {.lex_state = 21, .external_lex_state = 12},
  [917] = {.lex_state = 21, .external_lex_state = 12},
  [918] = {.lex_state = 21, .external_lex_state = 12},
  [919] = {.lex_state = 21, .external_lex_state = 12},
  [920] = {.lex_state = 21, .external_lex_state = 12},
  [921] = {.lex_state = 21, .external_lex_state = 12},
  [922] = {.lex_state = 21, .external_lex_state = 12},
  [923] = {.lex_state = 21, .external_lex_state = 12},
  [924] = {.lex_state = 21, .external_lex_state = 12},
  [925] = {.lex_state = 21, .external_lex_state = 12},
  [926] = {.lex_state = 21, .external_lex_state = 12},
  [927] = {.lex_state = 21, .external_lex_state = 12},
  [928] = {.lex_state = 21, .external_lex_state = 12},
  [929] = {.lex_state = 21, .external_lex_state = 12},
  [930] = {.lex_state = 21, .external_lex_state = 12},
  [931] = {.lex_state = 21, .external_lex_state = 12},
  [932] = {.lex_state = 44, .external_lex_state = 21},
  [933] = {.lex_state = 44, .external_lex_state = 22},
  [934] = {.lex_state = 44, .external_lex_state = 10},
  [935] = {.lex_state = 3, .external_lex_state = 12},
  [936] = {.lex_state = 3, .external_lex_state = 12},
  [937] = {.lex_state = 44, .external_lex_state = 21},
  [938] = {.lex_state = 3, .external_lex_state = 12},
  [939] = {.lex_state = 44, .external_lex_state = 32},
  [940] = {.lex_state = 44, .external_lex_state = 17},
  [941] = {.lex_state = 44, .external_lex_state = 16},
  [942] = {.lex_state = 44, .external_lex_state = 22},
  [943] = {.lex_state = 44, .external_lex_state = 16},
  [944] = {.lex_state = 44, .external_lex_state = 17},
  [945] = {.lex_state = 44, .external_lex_state = 17},
  [946] = {.lex_state = 44, .external_lex_state = 31},
  [947] = {.lex_state = 44, .external_lex_state = 17},
  [948] = {.lex_state = 44, .external_lex_state = 21},
  [949] = {.lex_state = 44, .external_lex_state = 32},
  [950] = {.lex_state = 44, .external_lex_state = 20},
  [951] = {.lex_state = 44, .external_lex_state = 32},
  [952] = {.lex_state = 3, .external_lex_state = 12},
  [953] = {.lex_state = 44, .external_lex_state = 16},
  [954] = {.lex_state = 44, .external_lex_state = 32},
  [955] = {.lex_state = 44, .external_lex_state = 17},
  [956] = {.lex_state = 44, .external_lex_state = 20},
  [957] = {.lex_state = 3, .external_lex_state = 12},
  [958] = {.lex_state = 44, .external_lex_state = 31},
  [959] = {.lex_state = 44, .external_lex_state = 32},
  [960] = {.lex_state = 44, .external_lex_state = 17},
  [961] = {.lex_state = 44, .external_lex_state = 22},
  [962] = {.lex_state = 44, .external_lex_state = 19},
  [963] = {.lex_state = 44, .external_lex_state = 21},
  [964] = {.lex_state = 44, .external_lex_state = 32},
  [965] = {.lex_state = 44, .external_lex_state = 22},
  [966] = {.lex_state = 44, .external_lex_state = 19},
  [967] = {.lex_state = 44, .external_lex_state = 19},
  [968] = {.lex_state = 44, .external_lex_state = 22},
  [969] = {.lex_state = 44, .external_lex_state = 32},
  [970] = {.lex_state = 44, .external_lex_state = 21},
  [971] = {.lex_state = 44, .external_lex_state = 19},
  [972] = {.lex_state = 3, .external_lex_state = 12},
  [973] = {.lex_state = 44, .external_lex_state = 17},
  [974] = {.lex_state = 44, .external_lex_state = 19},
  [975] = {.lex_state = 44, .external_lex_state = 31},
  [976] = {.lex_state = 44, .external_lex_state = 17},
  [977] = {.lex_state = 3, .external_lex_state = 12},
  [978] = {.lex_state = 44, .external_lex_state = 15},
  [979] = {.lex_state = 44, .external_lex_state = 23},
  [980] = {.lex_state = 44, .external_lex_state = 23},
  [981] = {.lex_state = 44, .external_lex_state = 16},
  [982] = {.lex_state = 44, .external_lex_state = 18},
  [983] = {.lex_state = 44, .external_lex_state = 18},
  [984] = {.lex_state = 44, .external_lex_state = 18},
  [985] = {.lex_state = 44, .external_lex_state = 15},
  [986] = {.lex_state = 44, .external_lex_state = 18},
  [987] = {.lex_state = 44, .external_lex_state = 15},
  [988] = {.lex_state = 44, .external_lex_state = 31},
  [989] = {.lex_state = 44, .external_lex_state = 15},
  [990] = {.lex_state = 44, .external_lex_state = 23},
  [991] = {.lex_state = 44, .external_lex_state = 20},
  [992] = {.lex_state = 44, .external_lex_state = 31},
  [993] = {.lex_state = 44, .external_lex_state = 18},
  [994] = {.lex_state = 44, .external_lex_state = 31},
  [995] = {.lex_state = 44, .external_lex_state = 20},
  [996] = {.lex_state = 44, .external_lex_state = 18},
  [997] = {.lex_state = 44, .external_lex_state = 22},
  [998] = {.lex_state = 44, .external_lex_state = 15},
  [999] = {.lex_state = 44, .external_lex_state = 16},
  [1000] = {.lex_state = 44, .external_lex_state = 23},
  [1001] = {.lex_state = 44, .external_lex_state = 15},
  [1002] = {.lex_state = 44, .external_lex_state = 21},
  [1003] = {.lex_state = 44, .external_lex_state = 20},
  [1004] = {.lex_state = 44, .external_lex_state = 20},
  [1005] = {.lex_state = 44, .external_lex_state = 23},
  [1006] = {.lex_state = 44, .external_lex_state = 21},
  [1007] = {.lex_state = 44, .external_lex_state = 11},
  [1008] = {.lex_state = 44, .external_lex_state = 31},
  [1009] = {.lex_state = 44, .external_lex_state = 31},
  [1010] = {.lex_state = 44, .external_lex_state = 19},
  [1011] = {.lex_state = 44, .external_lex_state = 18},
  [1012] = {.lex_state = 44, .external_lex_state = 20},
  [1013] = {.lex_state = 44, .external_lex_state = 50},
  [1014] = {.lex_state = 3, .external_lex_state = 12},
  [1015] = {.lex_state = 44, .external_lex_state = 16},
  [1016] = {.lex_state = 44, .external_lex_state = 15},
  [1017] = {.lex_state = 44, .external_lex_state = 19},
  [1018] = {.lex_state = 44, .external_lex_state = 50},
  [1019] = {.lex_state = 44, .external_lex_state = 50},
  [1020] = {.lex_state = 44, .external_lex_state = 31},
  [1021] = {.lex_state = 44, .external_lex_state = 21},
  [1022] = {.lex_state = 44, .external_lex_state = 12},
  [1023] = {.lex_state = 44, .external_lex_state = 12},
  [1024] = {.lex_state = 44, .external_lex_state = 12},
  [1025] = {.lex_state = 44, .external_lex_state = 12},
  [1026] = {.lex_state = 44, .external_lex_state = 12},
  [1027] = {.lex_state = 44, .external_lex_state = 12},
  [1028] = {.lex_state = 44, .external_lex_state = 12},
  [1029] = {.lex_state = 44, .external_lex_state = 12},
  [1030] = {.lex_state = 0, .external_lex_state = 55},
  [1031] = {.lex_state = 0, .external_lex_state = 56},
  [1032] = {.lex_state = 0, .external_lex_state = 55},
  [1033] = {.lex_state = 0, .external_lex_state = 57},
  [1034] = {.lex_state = 0, .external_lex_state = 56},
  [1035] = {.lex_state = 0, .external_lex_state = 57},
  [1036] = {.lex_state = 8, .external_lex_state = 58},
  [1037] = {.lex_state = 8, .external_lex_state = 59},
  [1038] = {.lex_state = 8, .external_lex_state = 58},
  [1039] = {.lex_state = 8, .external_lex_state = 59},
  [1040] = {.lex_state = 8, .external_lex_state = 58},
  [1041] = {.lex_state = 8, .external_lex_state = 59},
  [1042] = {.lex_state = 8, .external_lex_state = 58},
  [1043] = {.lex_state = 8, .external_lex_state = 58},
  [1044] = {.lex_state = 8, .external_lex_state = 58},
  [1045] = {.lex_state = 8, .external_lex_state = 58},
  [1046] = {.lex_state = 8, .external_lex_state = 58},
  [1047] = {.lex_state = 8, .external_lex_state = 58},
  [1048] = {.lex_state = 8, .external_lex_state = 59},
  [1049] = {.lex_state = 8, .external_lex_state = 58},
  [1050] = {.lex_state = 8, .external_lex_state = 58},
  [1051] = {.lex_state = 8, .external_lex_state = 58},
  [1052] = {.lex_state = 8, .external_lex_state = 58},
  [1053] = {.lex_state = 8, .external_lex_state = 58},
  [1054] = {.lex_state = 8, .external_lex_state = 58},
  [1055] = {.lex_state = 8, .external_lex_state = 58},
  [1056] = {.lex_state = 8, .external_lex_state = 58},
  [1057] = {.lex_state = 8, .external_lex_state = 58},
  [1058] = {.lex_state = 8, .external_lex_state = 58},
  [1059] = {.lex_state = 8, .external_lex_state = 58},
  [1060] = {.lex_state = 8, .external_lex_state = 58},
  [1061] = {.lex_state = 8, .external_lex_state = 58},
  [1062] = {.lex_state = 8, .external_lex_state = 58},
  [1063] = {.lex_state = 8, .external_lex_state = 58},
  [1064] = {.lex_state = 8, .external_lex_state = 58},
  [1065] = {.lex_state = 8, .external_lex_state = 58},
  [1066] = {.lex_state = 8, .external_lex_state = 59},
  [1067] = {.lex_state = 8, .external_lex_state = 59},
  [1068] = {.lex_state = 8, .external_lex_state = 59},
  [1069] = {.lex_state = 8, .external_lex_state = 59},
  [1070] = {.lex_state = 8, .external_lex_state = 59},
  [1071] = {.lex_state = 8, .external_lex_state = 59},
  [1072] = {.lex_state = 8, .external_lex_state = 59},
  [1073] = {.lex_state = 8, .external_lex_state = 58},
  [1074] = {.lex_state = 0, .external_lex_state = 55},
  [1075] = {.lex_state = 64, .external_lex_state = 60},
  [1076] = {.lex_state = 0, .external_lex_state = 55},
  [1077] = {.lex_state = 0, .external_lex_state = 61},
  [1078] = {.lex_state = 0, .external_lex_state = 55},
  [1079] = {.lex_state = 64, .external_lex_state = 60},
  [1080] = {.lex_state = 0, .external_lex_state = 61},
  [1081] = {.lex_state = 64, .external_lex_state = 60},
  [1082] = {.lex_state = 64, .external_lex_state = 60},
  [1083] = {.lex_state = 0, .external_lex_state = 61},
  [1084] = {.lex_state = 0, .external_lex_state = 61},
  [1085] = {.lex_state = 0, .external_lex_state = 55},
  [1086] = {.lex_state = 64, .external_lex_state = 60},
  [1087] = {.lex_state = 0, .external_lex_state = 55},
  [1088] = {.lex_state = 64, .external_lex_state = 60},
  [1089] = {.lex_state = 64, .external_lex_state = 60},
  [1090] = {.lex_state = 64, .external_lex_state = 60},
  [1091] = {.lex_state = 0, .external_lex_state = 61},
  [1092] = {.lex_state = 0, .external_lex_state = 55},
  [1093] = {.lex_state = 64, .external_lex_state = 60},
  [1094] = {.lex_state = 64, .external_lex_state = 60},
  [1095] = {.lex_state = 64, .external_lex_state = 60},
  [1096] = {.lex_state = 64, .external_lex_state = 60},
  [1097] = {.lex_state = 64, .external_lex_state = 60},
  [1098] = {.lex_state = 64, .external_lex_state = 60},
  [1099] = {.lex_state = 64, .external_lex_state = 60},
  [1100] = {.lex_state = 0, .external_lex_state = 61},
  [1101] = {.lex_state = 0, .external_lex_state = 55},
  [1102] = {.lex_state = 0, .external_lex_state = 62},
  [1103] = {.lex_state = 0, .external_lex_state = 63},
  [1104] = {.lex_state = 0, .external_lex_state = 64},
  [1105] = {.lex_state = 0, .external_lex_state = 65},
  [1106] = {.lex_state = 0, .external_lex_state = 62},
  [1107] = {.lex_state = 0, .external_lex_state = 66},
  [1108] = {.lex_state = 0, .external_lex_state = 67},
  [1109] = {.lex_state = 0, .external_lex_state = 68},
  [1110] = {.lex_state = 0, .external_lex_state = 64},
  [1111] = {.lex_state = 0, .external_lex_state = 67},
  [1112] = {.lex_state = 0, .external_lex_state = 69},
  [1113] = {.lex_state = 0, .external_lex_state = 70},
  [1114] = {.lex_state = 0, .external_lex_state = 71},
  [1115] = {.lex_state = 0, .external_lex_state = 72},
  [1116] = {.lex_state = 0, .external_lex_state = 73},
  [1117] = {.lex_state = 0, .external_lex_state = 74},
  [1118] = {.lex_state = 0, .external_lex_state = 63},
  [1119] = {.lex_state = 0, .external_lex_state = 65},
  [1120] = {.lex_state = 0, .external_lex_state = 62},
  [1121] = {.lex_state = 0, .external_lex_state = 66},
  [1122] = {.lex_state = 0, .external_lex_state = 68},
  [1123] = {.lex_state = 0, .external_lex_state = 70},
  [1124] = {.lex_state = 0, .external_lex_state = 75},
  [1125] = {.lex_state = 0, .external_lex_state = 76},
  [1126] = {.lex_state = 0, .external_lex_state = 77},
  [1127] = {.lex_state = 0, .external_lex_state = 78},
  [1128] = {.lex_state = 0, .external_lex_state = 79},
  [1129] = {.lex_state = 0, .external_lex_state = 69},
  [1130] = {.lex_state = 0, .external_lex_state = 57},
  [1131] = {.lex_state = 0, .external_lex_state = 57},
  [1132] = {.lex_state = 0, .external_lex_state = 75},
  [1133] = {.lex_state = 0, .external_lex_state = 57},
  [1134] = {.lex_state = 0, .external_lex_state = 76},
  [1135] = {.lex_state = 0, .external_lex_state = 77},
  [1136] = {.lex_state = 8, .external_lex_state = 59},
  [1137] = {.lex_state = 8, .external_lex_state = 58},
  [1138] = {.lex_state = 0, .external_lex_state = 57},
  [1139] = {.lex_state = 64, .external_lex_state = 60},
  [1140] = {.lex_state = 0, .external_lex_state = 64},
  [1141] = {.lex_state = 0, .external_lex_state = 67},
  [1142] = {.lex_state = 0, .external_lex_state = 69},
  [1143] = {.lex_state = 8, .external_lex_state = 59},
  [1144] = {.lex_state = 0, .external_lex_state = 71},
  [1145] = {.lex_state = 0, .external_lex_state = 72},
  [1146] = {.lex_state = 0, .external_lex_state = 73},
  [1147] = {.lex_state = 0, .external_lex_state = 74},
  [1148] = {.lex_state = 0, .external_lex_state = 63},
  [1149] = {.lex_state = 0, .external_lex_state = 65},
  [1150] = {.lex_state = 0, .external_lex_state = 62},
  [1151] = {.lex_state = 0, .external_lex_state = 66},
  [1152] = {.lex_state = 0, .external_lex_state = 68},
  [1153] = {.lex_state = 0, .external_lex_state = 70},
  [1154] = {.lex_state = 0, .external_lex_state = 75},
  [1155] = {.lex_state = 0, .external_lex_state = 76},
  [1156] = {.lex_state = 0, .external_lex_state = 77},
  [1157] = {.lex_state = 0, .external_lex_state = 78},
  [1158] = {.lex_state = 0, .external_lex_state = 79},
  [1159] = {.lex_state = 0, .external_lex_state = 64},
  [1160] = {.lex_state = 8, .external_lex_state = 59},
  [1161] = {.lex_state = 8, .external_lex_state = 59},
  [1162] = {.lex_state = 8, .external_lex_state = 59},
  [1163] = {.lex_state = 0, .external_lex_state = 73},
  [1164] = {.lex_state = 8, .external_lex_state = 59},
  [1165] = {.lex_state = 0, .external_lex_state = 74},
  [1166] = {.lex_state = 0, .external_lex_state = 64},
  [1167] = {.lex_state = 0, .external_lex_state = 67},
  [1168] = {.lex_state = 0, .external_lex_state = 69},
  [1169] = {.lex_state = 8, .external_lex_state = 59},
  [1170] = {.lex_state = 0, .external_lex_state = 71},
  [1171] = {.lex_state = 0, .external_lex_state = 72},
  [1172] = {.lex_state = 0, .external_lex_state = 73},
  [1173] = {.lex_state = 0, .external_lex_state = 74},
  [1174] = {.lex_state = 0, .external_lex_state = 63},
  [1175] = {.lex_state = 0, .external_lex_state = 65},
  [1176] = {.lex_state = 0, .external_lex_state = 78},
  [1177] = {.lex_state = 0, .external_lex_state = 66},
  [1178] = {.lex_state = 8, .external_lex_state = 59},
  [1179] = {.lex_state = 0, .external_lex_state = 70},
  [1180] = {.lex_state = 0, .external_lex_state = 75},
  [1181] = {.lex_state = 0, .external_lex_state = 76},
  [1182] = {.lex_state = 0, .external_lex_state = 77},
  [1183] = {.lex_state = 0, .external_lex_state = 78},
  [1184] = {.lex_state = 0, .external_lex_state = 79},
  [1185] = {.lex_state = 8, .external_lex_state = 58},
  [1186] = {.lex_state = 0, .external_lex_state = 71},
  [1187] = {.lex_state = 0, .external_lex_state = 57},
  [1188] = {.lex_state = 0, .external_lex_state = 57},
  [1189] = {.lex_state = 0, .external_lex_state = 57},
  [1190] = {.lex_state = 8, .external_lex_state = 58},
  [1191] = {.lex_state = 8, .external_lex_state = 58},
  [1192] = {.lex_state = 0, .external_lex_state = 78},
  [1193] = {.lex_state = 0, .external_lex_state = 79},
  [1194] = {.lex_state = 0, .external_lex_state = 64},
  [1195] = {.lex_state = 0, .external_lex_state = 67},
  [1196] = {.lex_state = 0, .external_lex_state = 69},
  [1197] = {.lex_state = 8, .external_lex_state = 58},
  [1198] = {.lex_state = 0, .external_lex_state = 71},
  [1199] = {.lex_state = 0, .external_lex_state = 72},
  [1200] = {.lex_state = 0, .external_lex_state = 73},
  [1201] = {.lex_state = 0, .external_lex_state = 74},
  [1202] = {.lex_state = 0, .external_lex_state = 63},
  [1203] = {.lex_state = 0, .external_lex_state = 65},
  [1204] = {.lex_state = 0, .external_lex_state = 72},
  [1205] = {.lex_state = 8, .external_lex_state = 58},
  [1206] = {.lex_state = 8, .external_lex_state = 58},
  [1207] = {.lex_state = 8, .external_lex_state = 58},
  [1208] = {.lex_state = 0, .external_lex_state = 62},
  [1209] = {.lex_state = 0, .external_lex_state = 66},
  [1210] = {.lex_state = 64, .external_lex_state = 60},
  [1211] = {.lex_state = 0, .external_lex_state = 68},
  [1212] = {.lex_state = 0, .external_lex_state = 67},
  [1213] = {.lex_state = 0, .external_lex_state = 70},
  [1214] = {.lex_state = 0, .external_lex_state = 75},
  [1215] = {.lex_state = 0, .external_lex_state = 76},
  [1216] = {.lex_state = 0, .external_lex_state = 69},
  [1217] = {.lex_state = 8, .external_lex_state = 58},
  [1218] = {.lex_state = 0, .external_lex_state = 73},
  [1219] = {.lex_state = 0, .external_lex_state = 77},
  [1220] = {.lex_state = 0, .external_lex_state = 78},
  [1221] = {.lex_state = 0, .external_lex_state = 74},
  [1222] = {.lex_state = 0, .external_lex_state = 79},
  [1223] = {.lex_state = 0, .external_lex_state = 63},
  [1224] = {.lex_state = 0, .external_lex_state = 79},
  [1225] = {.lex_state = 0, .external_lex_state = 65},
  [1226] = {.lex_state = 0, .external_lex_state = 56},
  [1227] = {.lex_state = 0, .external_lex_state = 56},
  [1228] = {.lex_state = 0, .external_lex_state = 56},
  [1229] = {.lex_state = 0, .external_lex_state = 56},
  [1230] = {.lex_state = 0, .external_lex_state = 62},
  [1231] = {.lex_state = 8, .external_lex_state = 59},
  [1232] = {.lex_state = 0, .external_lex_state = 56},
  [1233] = {.lex_state = 0, .external_lex_state = 56},
  [1234] = {.lex_state = 0, .external_lex_state = 56},
  [1235] = {.lex_state = 0, .external_lex_state = 66},
  [1236] = {.lex_state = 0, .external_lex_state = 71},
  [1237] = {.lex_state = 0, .external_lex_state = 72},
  [1238] = {.lex_state = 0, .external_lex_state = 68},
  [1239] = {.lex_state = 0, .external_lex_state = 70},
  [1240] = {.lex_state = 0, .external_lex_state = 75},
  [1241] = {.lex_state = 0, .external_lex_state = 76},
  [1242] = {.lex_state = 0, .external_lex_state = 77},
  [1243] = {.lex_state = 0, .external_lex_state = 68},
  [1244] = {.lex_state = 0, .external_lex_state = 80},
  [1245] = {.lex_state = 0, .external_lex_state = 81},
  [1246] = {.lex_state = 0, .external_lex_state = 80},
  [1247] = {.lex_state = 0, .external_lex_state = 81},
  [1248] = {.lex_state = 0, .external_lex_state = 80},
  [1249] = {.lex_state = 8},
  [1250] = {.lex_state = 8},
  [1251] = {.lex_state = 8},
  [1252] = {.lex_state = 8},
  [1253] = {.lex_state = 0, .external_lex_state = 80},
  [1254] = {.lex_state = 8},
  [1255] = {.lex_state = 0, .external_lex_state = 80},
  [1256] = {.lex_state = 8},
  [1257] = {.lex_state = 8},
  [1258] = {.lex_state = 8},
  [1259] = {.lex_state = 0, .external_lex_state = 81},
  [1260] = {.lex_state = 0, .external_lex_state = 80},
  [1261] = {.lex_state = 0, .external_lex_state = 81},
  [1262] = {.lex_state = 0, .external_lex_state = 80},
  [1263] = {.lex_state = 8},
  [1264] = {.lex_state = 8},
  [1265] = {.lex_state = 8},
  [1266] = {.lex_state = 0, .external_lex_state = 80},
  [1267] = {.lex_state = 0, .external_lex_state = 80},
  [1268] = {.lex_state = 8},
  [1269] = {.lex_state = 0, .external_lex_state = 80},
  [1270] = {.lex_state = 8},
  [1271] = {.lex_state = 8},
  [1272] = {.lex_state = 8},
  [1273] = {.lex_state = 8},
  [1274] = {.lex_state = 0, .external_lex_state = 80},
  [1275] = {.lex_state = 0, .external_lex_state = 82},
  [1276] = {.lex_state = 0, .external_lex_state = 80},
  [1277] = {.lex_state = 8},
  [1278] = {.lex_state = 8},
  [1279] = {.lex_state = 8},
  [1280] = {.lex_state = 0, .external_lex_state = 81},
  [1281] = {.lex_state = 0, .external_lex_state = 80},
  [1282] = {.lex_state = 8},
  [1283] = {.lex_state = 0, .external_lex_state = 80},
  [1284] = {.lex_state = 8},
  [1285] = {.lex_state = 0, .external_lex_state = 80},
  [1286] = {.lex_state = 0, .external_lex_state = 80},
  [1287] = {.lex_state = 0, .external_lex_state = 80},
  [1288] = {.lex_state = 0, .external_lex_state = 80},
  [1289] = {.lex_state = 0, .external_lex_state = 80},
  [1290] = {.lex_state = 0, .external_lex_state = 80},
  [1291] = {.lex_state = 0, .external_lex_state = 80},
  [1292] = {.lex_state = 0, .external_lex_state = 80},
  [1293] = {.lex_state = 0, .external_lex_state = 80},
  [1294] = {.lex_state = 0, .external_lex_state = 80},
  [1295] = {.lex_state = 0, .external_lex_state = 80},
  [1296] = {.lex_state = 0, .external_lex_state = 82},
  [1297] = {.lex_state = 0, .external_lex_state = 82},
  [1298] = {.lex_state = 0, .external_lex_state = 80},
  [1299] = {.lex_state = 8},
  [1300] = {.lex_state = 0, .external_lex_state = 80},
  [1301] = {.lex_state = 0, .external_lex_state = 80},
  [1302] = {.lex_state = 8},
  [1303] = {.lex_state = 0, .external_lex_state = 82},
  [1304] = {.lex_state = 0, .external_lex_state = 80},
  [1305] = {.lex_state = 8},
  [1306] = {.lex_state = 0, .external_lex_state = 80},
  [1307] = {.lex_state = 0, .external_lex_state = 82},
  [1308] = {.lex_state = 0, .external_lex_state = 80},
  [1309] = {.lex_state = 0, .external_lex_state = 80},
  [1310] = {.lex_state = 0, .external_lex_state = 80},
  [1311] = {.lex_state = 0, .external_lex_state = 81},
  [1312] = {.lex_state = 0, .external_lex_state = 80},
  [1313] = {.lex_state = 0, .external_lex_state = 81},
  [1314] = {.lex_state = 8},
  [1315] = {.lex_state = 0, .external_lex_state = 80},
  [1316] = {.lex_state = 0, .external_lex_state = 80},
  [1317] = {.lex_state = 0, .external_lex_state = 81},
  [1318] = {.lex_state = 0, .external_lex_state = 80},
  [1319] = {.lex_state = 8},
  [1320] = {.lex_state = 8},
  [1321] = {.lex_state = 0, .external_lex_state = 81},
  [1322] = {.lex_state = 0, .external_lex_state = 80},
  [1323] = {.lex_state = 0, .external_lex_state = 81},
  [1324] = {.lex_state = 0, .external_lex_state = 81},
  [1325] = {.lex_state = 8},
  [1326] = {.lex_state = 8},
  [1327] = {.lex_state = 8},
  [1328] = {.lex_state = 0, .external_lex_state = 80},
  [1329] = {.lex_state = 8},
  [1330] = {.lex_state = 0, .external_lex_state = 80},
  [1331] = {.lex_state = 8},
  [1332] = {.lex_state = 8},
  [1333] = {.lex_state = 0, .external_lex_state = 80},
  [1334] = {.lex_state = 8},
  [1335] = {.lex_state = 8},
  [1336] = {.lex_state = 0, .external_lex_state = 80},
  [1337] = {.lex_state = 8},
  [1338] = {.lex_state = 0, .external_lex_state = 80},
  [1339] = {.lex_state = 8},
  [1340] = {.lex_state = 8},
  [1341] = {.lex_state = 8},
  [1342] = {.lex_state = 0, .external_lex_state = 80},
  [1343] = {.lex_state = 10, .external_lex_state = 83},
  [1344] = {.lex_state = 10, .external_lex_state = 83},
  [1345] = {.lex_state = 0, .external_lex_state = 84},
  [1346] = {.lex_state = 0, .external_lex_state = 84},
  [1347] = {.lex_state = 0, .external_lex_state = 60},
  [1348] = {.lex_state = 10, .external_lex_state = 83},
  [1349] = {.lex_state = 10, .external_lex_state = 83},
  [1350] = {.lex_state = 0, .external_lex_state = 85},
  [1351] = {.lex_state = 10, .external_lex_state = 83},
  [1352] = {.lex_state = 10, .external_lex_state = 83},
  [1353] = {.lex_state = 0, .external_lex_state = 60},
  [1354] = {.lex_state = 10, .external_lex_state = 83},
  [1355] = {.lex_state = 0, .external_lex_state = 60},
  [1356] = {.lex_state = 0, .external_lex_state = 86},
  [1357] = {.lex_state = 11, .external_lex_state = 87},
  [1358] = {.lex_state = 0, .external_lex_state = 88},
  [1359] = {.lex_state = 0, .external_lex_state = 88},
  [1360] = {.lex_state = 11, .external_lex_state = 87},
  [1361] = {.lex_state = 11, .external_lex_state = 87},
  [1362] = {.lex_state = 42, .external_lex_state = 89},
  [1363] = {.lex_state = 0, .external_lex_state = 86},
  [1364] = {.lex_state = 11, .external_lex_state = 87},
  [1365] = {.lex_state = 11, .external_lex_state = 87},
  [1366] = {.lex_state = 0, .external_lex_state = 86},
  [1367] = {.lex_state = 11, .external_lex_state = 87},
  [1368] = {.lex_state = 42, .external_lex_state = 89},
  [1369] = {.lex_state = 11, .external_lex_state = 87},
  [1370] = {.lex_state = 11, .external_lex_state = 87},
  [1371] = {.lex_state = 11, .external_lex_state = 87},
  [1372] = {.lex_state = 11, .external_lex_state = 87},
  [1373] = {.lex_state = 0, .external_lex_state = 88},
  [1374] = {.lex_state = 42, .external_lex_state = 89},
  [1375] = {.lex_state = 11, .external_lex_state = 87},
  [1376] = {.lex_state = 10, .external_lex_state = 83},
  [1377] = {.lex_state = 0, .external_lex_state = 88},
  [1378] = {.lex_state = 11, .external_lex_state = 87},
  [1379] = {.lex_state = 0, .external_lex_state = 84},
  [1380] = {.lex_state = 0, .external_lex_state = 90},
  [1381] = {.lex_state = 64},
  [1382] = {.lex_state = 42, .external_lex_state = 89},
  [1383] = {.lex_state = 12, .external_lex_state = 59},
  [1384] = {.lex_state = 64, .external_lex_state = 91},
  [1385] = {.lex_state = 64},
  [1386] = {.lex_state = 42, .external_lex_state = 89},
  [1387] = {.lex_state = 42, .external_lex_state = 89},
  [1388] = {.lex_state = 12, .external_lex_state = 59},
  [1389] = {.lex_state = 12, .external_lex_state = 59},
  [1390] = {.lex_state = 0, .external_lex_state = 92},
  [1391] = {.lex_state = 0, .external_lex_state = 90},
  [1392] = {.lex_state = 0, .external_lex_state = 90},
  [1393] = {.lex_state = 42, .external_lex_state = 89},
  [1394] = {.lex_state = 12, .external_lex_state = 59},
  [1395] = {.lex_state = 12, .external_lex_state = 59},
  [1396] = {.lex_state = 42, .external_lex_state = 89},
  [1397] = {.lex_state = 11, .external_lex_state = 87},
  [1398] = {.lex_state = 42, .external_lex_state = 89},
  [1399] = {.lex_state = 0, .external_lex_state = 88},
  [1400] = {.lex_state = 0, .external_lex_state = 93},
  [1401] = {.lex_state = 42, .external_lex_state = 89},
  [1402] = {.lex_state = 0, .external_lex_state = 86},
  [1403] = {.lex_state = 0, .external_lex_state = 88},
  [1404] = {.lex_state = 0, .external_lex_state = 86},
  [1405] = {.lex_state = 0, .external_lex_state = 86},
  [1406] = {.lex_state = 42, .external_lex_state = 89},
  [1407] = {.lex_state = 11, .external_lex_state = 87},
  [1408] = {.lex_state = 64, .external_lex_state = 91},
  [1409] = {.lex_state = 0, .external_lex_state = 90},
  [1410] = {.lex_state = 0, .external_lex_state = 75},
  [1411] = {.lex_state = 0, .external_lex_state = 75},
  [1412] = {.lex_state = 0, .external_lex_state = 80},
  [1413] = {.lex_state = 0, .external_lex_state = 80},
  [1414] = {.lex_state = 0, .external_lex_state = 94},
  [1415] = {.lex_state = 0, .external_lex_state = 95},
  [1416] = {.lex_state = 0, .external_lex_state = 65},
  [1417] = {.lex_state = 0, .external_lex_state = 96},
  [1418] = {.lex_state = 0, .external_lex_state = 62},
  [1419] = {.lex_state = 0, .external_lex_state = 79},
  [1420] = {.lex_state = 0, .external_lex_state = 80},
  [1421] = {.lex_state = 0, .external_lex_state = 80},
  [1422] = {.lex_state = 0, .external_lex_state = 80},
  [1423] = {.lex_state = 0, .external_lex_state = 80},
  [1424] = {.lex_state = 0, .external_lex_state = 65},
  [1425] = {.lex_state = 0, .external_lex_state = 70},
  [1426] = {.lex_state = 0, .external_lex_state = 97},
  [1427] = {.lex_state = 0, .external_lex_state = 80},
  [1428] = {.lex_state = 0, .external_lex_state = 80},
  [1429] = {.lex_state = 0, .external_lex_state = 80},
  [1430] = {.lex_state = 0, .external_lex_state = 80},
  [1431] = {.lex_state = 0, .external_lex_state = 80},
  [1432] = {.lex_state = 0, .external_lex_state = 65},
  [1433] = {.lex_state = 0, .external_lex_state = 80},
  [1434] = {.lex_state = 0, .external_lex_state = 80},
  [1435] = {.lex_state = 0, .external_lex_state = 70},
  [1436] = {.lex_state = 0, .external_lex_state = 80},
  [1437] = {.lex_state = 0, .external_lex_state = 80},
  [1438] = {.lex_state = 0, .external_lex_state = 98},
  [1439] = {.lex_state = 0, .external_lex_state = 98},
  [1440] = {.lex_state = 0, .external_lex_state = 99},
  [1441] = {.lex_state = 0, .external_lex_state = 100},
  [1442] = {.lex_state = 0, .external_lex_state = 64},
  [1443] = {.lex_state = 0, .external_lex_state = 68},
  [1444] = {.lex_state = 0, .external_lex_state = 80},
  [1445] = {.lex_state = 0, .external_lex_state = 101},
  [1446] = {.lex_state = 0, .external_lex_state = 97},
  [1447] = {.lex_state = 0, .external_lex_state = 80},
  [1448] = {.lex_state = 0, .external_lex_state = 68},
  [1449] = {.lex_state = 0, .external_lex_state = 102},
  [1450] = {.lex_state = 13},
  [1451] = {.lex_state = 13},
  [1452] = {.lex_state = 0, .external_lex_state = 80},
  [1453] = {.lex_state = 0, .external_lex_state = 102},
  [1454] = {.lex_state = 0, .external_lex_state = 64},
  [1455] = {.lex_state = 0, .external_lex_state = 80},
  [1456] = {.lex_state = 0, .external_lex_state = 72},
  [1457] = {.lex_state = 0, .external_lex_state = 80},
  [1458] = {.lex_state = 0, .external_lex_state = 80},
  [1459] = {.lex_state = 0, .external_lex_state = 75},
  [1460] = {.lex_state = 0, .external_lex_state = 80},
  [1461] = {.lex_state = 0, .external_lex_state = 100},
  [1462] = {.lex_state = 0, .external_lex_state = 80},
  [1463] = {.lex_state = 0, .external_lex_state = 80},
  [1464] = {.lex_state = 0, .external_lex_state = 67},
  [1465] = {.lex_state = 0, .external_lex_state = 80},
  [1466] = {.lex_state = 0, .external_lex_state = 80},
  [1467] = {.lex_state = 0, .external_lex_state = 80},
  [1468] = {.lex_state = 0, .external_lex_state = 76},
  [1469] = {.lex_state = 0, .external_lex_state = 80},
  [1470] = {.lex_state = 0, .external_lex_state = 80},
  [1471] = {.lex_state = 0, .external_lex_state = 80},
  [1472] = {.lex_state = 0, .external_lex_state = 76},
  [1473] = {.lex_state = 0, .external_lex_state = 80},
  [1474] = {.lex_state = 0, .external_lex_state = 103},
  [1475] = {.lex_state = 0, .external_lex_state = 94},
  [1476] = {.lex_state = 0, .external_lex_state = 80},
  [1477] = {.lex_state = 0, .external_lex_state = 104},
  [1478] = {.lex_state = 0, .external_lex_state = 80},
  [1479] = {.lex_state = 0, .external_lex_state = 103},
  [1480] = {.lex_state = 0, .external_lex_state = 79},
  [1481] = {.lex_state = 0, .external_lex_state = 80},
  [1482] = {.lex_state = 0, .external_lex_state = 75},
  [1483] = {.lex_state = 0, .external_lex_state = 101},
  [1484] = {.lex_state = 0, .external_lex_state = 80},
  [1485] = {.lex_state = 0, .external_lex_state = 66},
  [1486] = {.lex_state = 0, .external_lex_state = 80},
  [1487] = {.lex_state = 0, .external_lex_state = 79},
  [1488] = {.lex_state = 0, .external_lex_state = 71},
  [1489] = {.lex_state = 0, .external_lex_state = 61},
  [1490] = {.lex_state = 0, .external_lex_state = 80},
  [1491] = {.lex_state = 0, .external_lex_state = 80},
  [1492] = {.lex_state = 0, .external_lex_state = 105},
  [1493] = {.lex_state = 0, .external_lex_state = 105},
  [1494] = {.lex_state = 0, .external_lex_state = 64},
  [1495] = {.lex_state = 0, .external_lex_state = 80},
  [1496] = {.lex_state = 0, .external_lex_state = 104},
  [1497] = {.lex_state = 0, .external_lex_state = 61},
  [1498] = {.lex_state = 0, .external_lex_state = 74},
  [1499] = {.lex_state = 0, .external_lex_state = 61},
  [1500] = {.lex_state = 0, .external_lex_state = 80},
  [1501] = {.lex_state = 0, .external_lex_state = 69},
  [1502] = {.lex_state = 0, .external_lex_state = 106},
  [1503] = {.lex_state = 0, .external_lex_state = 69},
  [1504] = {.lex_state = 0, .external_lex_state = 80},
  [1505] = {.lex_state = 0, .external_lex_state = 106},
  [1506] = {.lex_state = 0, .external_lex_state = 107},
  [1507] = {.lex_state = 0, .external_lex_state = 65},
  [1508] = {.lex_state = 11, .external_lex_state = 108},
  [1509] = {.lex_state = 0, .external_lex_state = 109},
  [1510] = {.lex_state = 0, .external_lex_state = 76},
  [1511] = {.lex_state = 0, .external_lex_state = 110},
  [1512] = {.lex_state = 0, .external_lex_state = 110},
  [1513] = {.lex_state = 0, .external_lex_state = 80},
  [1514] = {.lex_state = 0, .external_lex_state = 67},
  [1515] = {.lex_state = 0, .external_lex_state = 71},
  [1516] = {.lex_state = 0, .external_lex_state = 73},
  [1517] = {.lex_state = 0, .external_lex_state = 72},
  [1518] = {.lex_state = 0, .external_lex_state = 71},
  [1519] = {.lex_state = 0, .external_lex_state = 80},
  [1520] = {.lex_state = 0, .external_lex_state = 73},
  [1521] = {.lex_state = 0, .external_lex_state = 111},
  [1522] = {.lex_state = 0, .external_lex_state = 66},
  [1523] = {.lex_state = 11, .external_lex_state = 108},
  [1524] = {.lex_state = 0, .external_lex_state = 77},
  [1525] = {.lex_state = 64, .external_lex_state = 60},
  [1526] = {.lex_state = 0, .external_lex_state = 72},
  [1527] = {.lex_state = 0, .external_lex_state = 70},
  [1528] = {.lex_state = 0, .external_lex_state = 61},
  [1529] = {.lex_state = 0, .external_lex_state = 69},
  [1530] = {.lex_state = 64, .external_lex_state = 60},
  [1531] = {.lex_state = 0, .external_lex_state = 64},
  [1532] = {.lex_state = 0, .external_lex_state = 109},
  [1533] = {.lex_state = 0, .external_lex_state = 109},
  [1534] = {.lex_state = 0, .external_lex_state = 80},
  [1535] = {.lex_state = 0, .external_lex_state = 69},
  [1536] = {.lex_state = 0, .external_lex_state = 74},
  [1537] = {.lex_state = 0, .external_lex_state = 80},
  [1538] = {.lex_state = 0, .external_lex_state = 78},
  [1539] = {.lex_state = 0, .external_lex_state = 67},
  [1540] = {.lex_state = 0, .external_lex_state = 80},
  [1541] = {.lex_state = 0, .external_lex_state = 79},
  [1542] = {.lex_state = 0, .external_lex_state = 96},
  [1543] = {.lex_state = 0, .external_lex_state = 78},
  [1544] = {.lex_state = 14},
  [1545] = {.lex_state = 0, .external_lex_state = 73},
  [1546] = {.lex_state = 0, .external_lex_state = 80},
  [1547] = {.lex_state = 0, .external_lex_state = 77},
  [1548] = {.lex_state = 0, .external_lex_state = 73},
  [1549] = {.lex_state = 13},
  [1550] = {.lex_state = 0, .external_lex_state = 69},
  [1551] = {.lex_state = 0, .external_lex_state = 107},
  [1552] = {.lex_state = 11, .external_lex_state = 108},
  [1553] = {.lex_state = 0, .external_lex_state = 112},
  [1554] = {.lex_state = 0, .external_lex_state = 95},
  [1555] = {.lex_state = 0, .external_lex_state = 95},
  [1556] = {.lex_state = 0, .external_lex_state = 113},
  [1557] = {.lex_state = 0, .external_lex_state = 114},
  [1558] = {.lex_state = 64, .external_lex_state = 115},
  [1559] = {.lex_state = 0, .external_lex_state = 71},
  [1560] = {.lex_state = 64, .external_lex_state = 115},
  [1561] = {.lex_state = 11, .external_lex_state = 108},
  [1562] = {.lex_state = 0, .external_lex_state = 71},
  [1563] = {.lex_state = 0, .external_lex_state = 80},
  [1564] = {.lex_state = 0, .external_lex_state = 62},
  [1565] = {.lex_state = 0, .external_lex_state = 70},
  [1566] = {.lex_state = 0, .external_lex_state = 77},
  [1567] = {.lex_state = 0, .external_lex_state = 72},
  [1568] = {.lex_state = 0, .external_lex_state = 74},
  [1569] = {.lex_state = 0, .external_lex_state = 63},
  [1570] = {.lex_state = 11, .external_lex_state = 108},
  [1571] = {.lex_state = 0, .external_lex_state = 66},
  [1572] = {.lex_state = 0, .external_lex_state = 80},
  [1573] = {.lex_state = 0, .external_lex_state = 81},
  [1574] = {.lex_state = 0, .external_lex_state = 80},
  [1575] = {.lex_state = 0, .external_lex_state = 112},
  [1576] = {.lex_state = 0, .external_lex_state = 74},
  [1577] = {.lex_state = 0, .external_lex_state = 64},
  [1578] = {.lex_state = 0, .external_lex_state = 116},
  [1579] = {.lex_state = 11, .external_lex_state = 108},
  [1580] = {.lex_state = 0, .external_lex_state = 80},
  [1581] = {.lex_state = 0, .external_lex_state = 78},
  [1582] = {.lex_state = 0, .external_lex_state = 117},
  [1583] = {.lex_state = 0, .external_lex_state = 77},
  [1584] = {.lex_state = 0, .external_lex_state = 117},
  [1585] = {.lex_state = 0, .external_lex_state = 111},
  [1586] = {.lex_state = 0, .external_lex_state = 118},
  [1587] = {.lex_state = 0, .external_lex_state = 119},
  [1588] = {.lex_state = 11, .external_lex_state = 108},
  [1589] = {.lex_state = 0, .external_lex_state = 75},
  [1590] = {.lex_state = 0, .external_lex_state = 120},
  [1591] = {.lex_state = 0, .external_lex_state = 67},
  [1592] = {.lex_state = 0, .external_lex_state = 118},
  [1593] = {.lex_state = 0, .external_lex_state = 113},
  [1594] = {.lex_state = 0, .external_lex_state = 119},
  [1595] = {.lex_state = 0, .external_lex_state = 119},
  [1596] = {.lex_state = 0, .external_lex_state = 81},
  [1597] = {.lex_state = 11, .external_lex_state = 108},
  [1598] = {.lex_state = 0, .external_lex_state = 78},
  [1599] = {.lex_state = 0, .external_lex_state = 78},
  [1600] = {.lex_state = 0, .external_lex_state = 73},
  [1601] = {.lex_state = 0, .external_lex_state = 65},
  [1602] = {.lex_state = 0, .external_lex_state = 62},
  [1603] = {.lex_state = 0, .external_lex_state = 63},
  [1604] = {.lex_state = 0, .external_lex_state = 68},
  [1605] = {.lex_state = 0, .external_lex_state = 76},
  [1606] = {.lex_state = 11, .external_lex_state = 108},
  [1607] = {.lex_state = 0, .external_lex_state = 79},
  [1608] = {.lex_state = 0, .external_lex_state = 120},
  [1609] = {.lex_state = 0, .external_lex_state = 120},
  [1610] = {.lex_state = 0, .external_lex_state = 120},
  [1611] = {.lex_state = 0, .external_lex_state = 67},
  [1612] = {.lex_state = 0, .external_lex_state = 61},
  [1613] = {.lex_state = 0, .external_lex_state = 119},
  [1614] = {.lex_state = 0, .external_lex_state = 95},
  [1615] = {.lex_state = 11, .external_lex_state = 108},
  [1616] = {.lex_state = 0, .external_lex_state = 66},
  [1617] = {.lex_state = 0, .external_lex_state = 120},
  [1618] = {.lex_state = 0, .external_lex_state = 120},
  [1619] = {.lex_state = 0, .external_lex_state = 95},
  [1620] = {.lex_state = 0, .external_lex_state = 62},
  [1621] = {.lex_state = 0, .external_lex_state = 121},
  [1622] = {.lex_state = 0, .external_lex_state = 74},
  [1623] = {.lex_state = 0, .external_lex_state = 70},
  [1624] = {.lex_state = 11, .external_lex_state = 108},
  [1625] = {.lex_state = 0, .external_lex_state = 114},
  [1626] = {.lex_state = 0, .external_lex_state = 77},
  [1627] = {.lex_state = 0, .external_lex_state = 63},
  [1628] = {.lex_state = 0, .external_lex_state = 68},
  [1629] = {.lex_state = 11, .external_lex_state = 108},
  [1630] = {.lex_state = 8},
  [1631] = {.lex_state = 8},
  [1632] = {.lex_state = 0, .external_lex_state = 72},
  [1633] = {.lex_state = 0, .external_lex_state = 68},
  [1634] = {.lex_state = 0, .external_lex_state = 63},
  [1635] = {.lex_state = 0, .external_lex_state = 122},
  [1636] = {.lex_state = 0, .external_lex_state = 76},
  [1637] = {.lex_state = 0, .external_lex_state = 63},
  [1638] = {.lex_state = 0, .external_lex_state = 62},
  [1639] = {.lex_state = 0, .external_lex_state = 122},
  [1640] = {.lex_state = 0, .external_lex_state = 121},
  [1641] = {.lex_state = 0, .external_lex_state = 66},
  [1642] = {.lex_state = 0, .external_lex_state = 80},
  [1643] = {.lex_state = 11, .external_lex_state = 108},
  [1644] = {.lex_state = 0, .external_lex_state = 123},
  [1645] = {.lex_state = 0, .external_lex_state = 60},
  [1646] = {.lex_state = 0, .external_lex_state = 124},
  [1647] = {.lex_state = 0},
  [1648] = {.lex_state = 0, .external_lex_state = 60},
  [1649] = {.lex_state = 44, .external_lex_state = 59},
  [1650] = {.lex_state = 0, .external_lex_state = 125},
  [1651] = {.lex_state = 0, .external_lex_state = 126},
  [1652] = {.lex_state = 0, .external_lex_state = 60},
  [1653] = {.lex_state = 0, .external_lex_state = 101},
  [1654] = {.lex_state = 0, .external_lex_state = 125},
  [1655] = {.lex_state = 44, .external_lex_state = 59},
  [1656] = {.lex_state = 0, .external_lex_state = 126},
  [1657] = {.lex_state = 0, .external_lex_state = 127},
  [1658] = {.lex_state = 0, .external_lex_state = 127},
  [1659] = {.lex_state = 0, .external_lex_state = 111},
  [1660] = {.lex_state = 0, .external_lex_state = 60},
  [1661] = {.lex_state = 44, .external_lex_state = 59},
  [1662] = {.lex_state = 0, .external_lex_state = 60},
  [1663] = {.lex_state = 0, .external_lex_state = 95},
  [1664] = {.lex_state = 0, .external_lex_state = 127},
  [1665] = {.lex_state = 0, .external_lex_state = 128},
  [1666] = {.lex_state = 0, .external_lex_state = 125},
  [1667] = {.lex_state = 0, .external_lex_state = 126},
  [1668] = {.lex_state = 0, .external_lex_state = 129},
  [1669] = {.lex_state = 0, .external_lex_state = 130},
  [1670] = {.lex_state = 0, .external_lex_state = 123},
  [1671] = {.lex_state = 0, .external_lex_state = 131},
  [1672] = {.lex_state = 0, .external_lex_state = 132},
  [1673] = {.lex_state = 0, .external_lex_state = 128},
  [1674] = {.lex_state = 0, .external_lex_state = 128},
  [1675] = {.lex_state = 0, .external_lex_state = 133},
  [1676] = {.lex_state = 0, .external_lex_state = 129},
  [1677] = {.lex_state = 0, .external_lex_state = 127},
  [1678] = {.lex_state = 0, .external_lex_state = 60},
  [1679] = {.lex_state = 0, .external_lex_state = 130},
  [1680] = {.lex_state = 0, .external_lex_state = 60},
  [1681] = {.lex_state = 0, .external_lex_state = 60},
  [1682] = {.lex_state = 0, .external_lex_state = 60},
  [1683] = {.lex_state = 0, .external_lex_state = 60},
  [1684] = {.lex_state = 0, .external_lex_state = 60},
  [1685] = {.lex_state = 0, .external_lex_state = 60},
  [1686] = {.lex_state = 0, .external_lex_state = 60},
  [1687] = {.lex_state = 0, .external_lex_state = 60},
  [1688] = {.lex_state = 0, .external_lex_state = 60},
  [1689] = {.lex_state = 0, .external_lex_state = 60},
  [1690] = {.lex_state = 0, .external_lex_state = 60},
  [1691] = {.lex_state = 0, .external_lex_state = 60},
  [1692] = {.lex_state = 0, .external_lex_state = 60},
  [1693] = {.lex_state = 0, .external_lex_state = 60},
  [1694] = {.lex_state = 0, .external_lex_state = 124},
  [1695] = {.lex_state = 0, .external_lex_state = 122},
  [1696] = {.lex_state = 0, .external_lex_state = 125},
  [1697] = {.lex_state = 0, .external_lex_state = 126},
  [1698] = {.lex_state = 0, .external_lex_state = 97},
  [1699] = {.lex_state = 0, .external_lex_state = 127},
  [1700] = {.lex_state = 0, .external_lex_state = 123},
  [1701] = {.lex_state = 44, .external_lex_state = 59},
  [1702] = {.lex_state = 8},
  [1703] = {.lex_state = 0, .external_lex_state = 96},
  [1704] = {.lex_state = 0, .external_lex_state = 128},
  [1705] = {.lex_state = 0, .external_lex_state = 125},
  [1706] = {.lex_state = 0, .external_lex_state = 126},
  [1707] = {.lex_state = 0, .external_lex_state = 129},
  [1708] = {.lex_state = 0, .external_lex_state = 130},
  [1709] = {.lex_state = 0, .external_lex_state = 123},
  [1710] = {.lex_state = 0, .external_lex_state = 131},
  [1711] = {.lex_state = 0, .external_lex_state = 132},
  [1712] = {.lex_state = 0, .external_lex_state = 128},
  [1713] = {.lex_state = 0, .external_lex_state = 128},
  [1714] = {.lex_state = 0, .external_lex_state = 133},
  [1715] = {.lex_state = 0, .external_lex_state = 127},
  [1716] = {.lex_state = 0, .external_lex_state = 109},
  [1717] = {.lex_state = 64},
  [1718] = {.lex_state = 8},
  [1719] = {.lex_state = 0, .external_lex_state = 124},
  [1720] = {.lex_state = 0, .external_lex_state = 124},
  [1721] = {.lex_state = 0, .external_lex_state = 88},
  [1722] = {.lex_state = 0, .external_lex_state = 125},
  [1723] = {.lex_state = 0, .external_lex_state = 126},
  [1724] = {.lex_state = 0, .external_lex_state = 107},
  [1725] = {.lex_state = 44, .external_lex_state = 59},
  [1726] = {.lex_state = 0, .external_lex_state = 128},
  [1727] = {.lex_state = 0, .external_lex_state = 125},
  [1728] = {.lex_state = 0, .external_lex_state = 126},
  [1729] = {.lex_state = 0, .external_lex_state = 129},
  [1730] = {.lex_state = 0, .external_lex_state = 130},
  [1731] = {.lex_state = 0, .external_lex_state = 123},
  [1732] = {.lex_state = 0, .external_lex_state = 131},
  [1733] = {.lex_state = 0, .external_lex_state = 132},
  [1734] = {.lex_state = 0, .external_lex_state = 128},
  [1735] = {.lex_state = 0, .external_lex_state = 128},
  [1736] = {.lex_state = 0, .external_lex_state = 133},
  [1737] = {.lex_state = 0, .external_lex_state = 124},
  [1738] = {.lex_state = 0, .external_lex_state = 125},
  [1739] = {.lex_state = 0, .external_lex_state = 126},
  [1740] = {.lex_state = 0, .external_lex_state = 88},
  [1741] = {.lex_state = 0, .external_lex_state = 109},
  [1742] = {.lex_state = 0, .external_lex_state = 60},
  [1743] = {.lex_state = 0, .external_lex_state = 134},
  [1744] = {.lex_state = 0, .external_lex_state = 128},
  [1745] = {.lex_state = 0, .external_lex_state = 125},
  [1746] = {.lex_state = 0, .external_lex_state = 126},
  [1747] = {.lex_state = 0, .external_lex_state = 129},
  [1748] = {.lex_state = 0, .external_lex_state = 130},
  [1749] = {.lex_state = 0, .external_lex_state = 123},
  [1750] = {.lex_state = 0, .external_lex_state = 131},
  [1751] = {.lex_state = 0, .external_lex_state = 132},
  [1752] = {.lex_state = 0, .external_lex_state = 128},
  [1753] = {.lex_state = 0, .external_lex_state = 128},
  [1754] = {.lex_state = 0, .external_lex_state = 133},
  [1755] = {.lex_state = 0, .external_lex_state = 104},
  [1756] = {.lex_state = 8},
  [1757] = {.lex_state = 0, .external_lex_state = 124},
  [1758] = {.lex_state = 0, .external_lex_state = 125},
  [1759] = {.lex_state = 0, .external_lex_state = 126},
  [1760] = {.lex_state = 0, .external_lex_state = 128},
  [1761] = {.lex_state = 0, .external_lex_state = 125},
  [1762] = {.lex_state = 0, .external_lex_state = 126},
  [1763] = {.lex_state = 0, .external_lex_state = 129},
  [1764] = {.lex_state = 0, .external_lex_state = 130},
  [1765] = {.lex_state = 0, .external_lex_state = 123},
  [1766] = {.lex_state = 0, .external_lex_state = 131},
  [1767] = {.lex_state = 0, .external_lex_state = 132},
  [1768] = {.lex_state = 0, .external_lex_state = 128},
  [1769] = {.lex_state = 0, .external_lex_state = 128},
  [1770] = {.lex_state = 0, .external_lex_state = 133},
  [1771] = {.lex_state = 0, .external_lex_state = 124},
  [1772] = {.lex_state = 0, .external_lex_state = 125},
  [1773] = {.lex_state = 0, .external_lex_state = 126},
  [1774] = {.lex_state = 0, .external_lex_state = 128},
  [1775] = {.lex_state = 0, .external_lex_state = 125},
  [1776] = {.lex_state = 0, .external_lex_state = 126},
  [1777] = {.lex_state = 0, .external_lex_state = 129},
  [1778] = {.lex_state = 0, .external_lex_state = 130},
  [1779] = {.lex_state = 0, .external_lex_state = 123},
  [1780] = {.lex_state = 0, .external_lex_state = 131},
  [1781] = {.lex_state = 0, .external_lex_state = 132},
  [1782] = {.lex_state = 0, .external_lex_state = 128},
  [1783] = {.lex_state = 0, .external_lex_state = 128},
  [1784] = {.lex_state = 0, .external_lex_state = 133},
  [1785] = {.lex_state = 0, .external_lex_state = 135},
  [1786] = {.lex_state = 0, .external_lex_state = 124},
  [1787] = {.lex_state = 0, .external_lex_state = 125},
  [1788] = {.lex_state = 0, .external_lex_state = 126},
  [1789] = {.lex_state = 0, .external_lex_state = 136},
  [1790] = {.lex_state = 12, .external_lex_state = 59},
  [1791] = {.lex_state = 0, .external_lex_state = 128},
  [1792] = {.lex_state = 0, .external_lex_state = 125},
  [1793] = {.lex_state = 0, .external_lex_state = 126},
  [1794] = {.lex_state = 0, .external_lex_state = 129},
  [1795] = {.lex_state = 0, .external_lex_state = 130},
  [1796] = {.lex_state = 0, .external_lex_state = 123},
  [1797] = {.lex_state = 0, .external_lex_state = 131},
  [1798] = {.lex_state = 0, .external_lex_state = 132},
  [1799] = {.lex_state = 0, .external_lex_state = 128},
  [1800] = {.lex_state = 0, .external_lex_state = 128},
  [1801] = {.lex_state = 0, .external_lex_state = 133},
  [1802] = {.lex_state = 0, .external_lex_state = 124},
  [1803] = {.lex_state = 0, .external_lex_state = 125},
  [1804] = {.lex_state = 0, .external_lex_state = 126},
  [1805] = {.lex_state = 0, .external_lex_state = 100},
  [1806] = {.lex_state = 0, .external_lex_state = 127},
  [1807] = {.lex_state = 0, .external_lex_state = 95},
  [1808] = {.lex_state = 0, .external_lex_state = 135},
  [1809] = {.lex_state = 0, .external_lex_state = 135},
  [1810] = {.lex_state = 0, .external_lex_state = 128},
  [1811] = {.lex_state = 0, .external_lex_state = 125},
  [1812] = {.lex_state = 0, .external_lex_state = 126},
  [1813] = {.lex_state = 0, .external_lex_state = 129},
  [1814] = {.lex_state = 0, .external_lex_state = 130},
  [1815] = {.lex_state = 0, .external_lex_state = 123},
  [1816] = {.lex_state = 0, .external_lex_state = 131},
  [1817] = {.lex_state = 0, .external_lex_state = 132},
  [1818] = {.lex_state = 0, .external_lex_state = 128},
  [1819] = {.lex_state = 0, .external_lex_state = 128},
  [1820] = {.lex_state = 0, .external_lex_state = 133},
  [1821] = {.lex_state = 0, .external_lex_state = 121},
  [1822] = {.lex_state = 0, .external_lex_state = 124},
  [1823] = {.lex_state = 0, .external_lex_state = 125},
  [1824] = {.lex_state = 0, .external_lex_state = 126},
  [1825] = {.lex_state = 0, .external_lex_state = 98},
  [1826] = {.lex_state = 0, .external_lex_state = 128},
  [1827] = {.lex_state = 0, .external_lex_state = 125},
  [1828] = {.lex_state = 0, .external_lex_state = 60},
  [1829] = {.lex_state = 0, .external_lex_state = 129},
  [1830] = {.lex_state = 0, .external_lex_state = 130},
  [1831] = {.lex_state = 0, .external_lex_state = 123},
  [1832] = {.lex_state = 0, .external_lex_state = 131},
  [1833] = {.lex_state = 0, .external_lex_state = 132},
  [1834] = {.lex_state = 0, .external_lex_state = 128},
  [1835] = {.lex_state = 0, .external_lex_state = 128},
  [1836] = {.lex_state = 0, .external_lex_state = 133},
  [1837] = {.lex_state = 0, .external_lex_state = 124},
  [1838] = {.lex_state = 0, .external_lex_state = 125},
  [1839] = {.lex_state = 0, .external_lex_state = 126},
  [1840] = {.lex_state = 0, .external_lex_state = 102},
  [1841] = {.lex_state = 0, .external_lex_state = 103},
  [1842] = {.lex_state = 0, .external_lex_state = 128},
  [1843] = {.lex_state = 0, .external_lex_state = 125},
  [1844] = {.lex_state = 0, .external_lex_state = 126},
  [1845] = {.lex_state = 0, .external_lex_state = 129},
  [1846] = {.lex_state = 0, .external_lex_state = 130},
  [1847] = {.lex_state = 0, .external_lex_state = 123},
  [1848] = {.lex_state = 0, .external_lex_state = 131},
  [1849] = {.lex_state = 0, .external_lex_state = 132},
  [1850] = {.lex_state = 0, .external_lex_state = 128},
  [1851] = {.lex_state = 0, .external_lex_state = 128},
  [1852] = {.lex_state = 0, .external_lex_state = 133},
  [1853] = {.lex_state = 0, .external_lex_state = 125},
  [1854] = {.lex_state = 0, .external_lex_state = 126},
  [1855] = {.lex_state = 0, .external_lex_state = 124},
  [1856] = {.lex_state = 0, .external_lex_state = 125},
  [1857] = {.lex_state = 0, .external_lex_state = 126},
  [1858] = {.lex_state = 0, .external_lex_state = 136},
  [1859] = {.lex_state = 0, .external_lex_state = 136},
  [1860] = {.lex_state = 0, .external_lex_state = 105},
  [1861] = {.lex_state = 0, .external_lex_state = 136},
  [1862] = {.lex_state = 42, .external_lex_state = 89},
  [1863] = {.lex_state = 0, .external_lex_state = 94},
  [1864] = {.lex_state = 0, .external_lex_state = 106},
  [1865] = {.lex_state = 0, .external_lex_state = 114},
  [1866] = {.lex_state = 0, .external_lex_state = 110},
  [1867] = {.lex_state = 0, .external_lex_state = 135},
  [1868] = {.lex_state = 8},
  [1869] = {.lex_state = 0, .external_lex_state = 136},
  [1870] = {.lex_state = 0, .external_lex_state = 136},
  [1871] = {.lex_state = 64, .external_lex_state = 115},
  [1872] = {.lex_state = 0, .external_lex_state = 137},
  [1873] = {.lex_state = 0, .external_lex_state = 88},
  [1874] = {.lex_state = 0, .external_lex_state = 117},
  [1875] = {.lex_state = 0, .external_lex_state = 118},
  [1876] = {.lex_state = 8},
  [1877] = {.lex_state = 8},
  [1878] = {.lex_state = 0, .external_lex_state = 128},
  [1879] = {.lex_state = 0, .external_lex_state = 125},
  [1880] = {.lex_state = 0, .external_lex_state = 126},
  [1881] = {.lex_state = 0, .external_lex_state = 129},
  [1882] = {.lex_state = 0, .external_lex_state = 130},
  [1883] = {.lex_state = 0, .external_lex_state = 123},
  [1884] = {.lex_state = 0, .external_lex_state = 131},
  [1885] = {.lex_state = 0, .external_lex_state = 132},
  [1886] = {.lex_state = 0, .external_lex_state = 128},
  [1887] = {.lex_state = 0, .external_lex_state = 128},
  [1888] = {.lex_state = 0, .external_lex_state = 133},
  [1889] = {.lex_state = 8},
  [1890] = {.lex_state = 8},
  [1891] = {.lex_state = 0, .external_lex_state = 127},
  [1892] = {.lex_state = 64, .external_lex_state = 91},
  [1893] = {.lex_state = 0, .external_lex_state = 112},
  [1894] = {.lex_state = 0, .external_lex_state = 131},
  [1895] = {.lex_state = 0, .external_lex_state = 60},
  [1896] = {.lex_state = 8},
  [1897] = {.lex_state = 8},
  [1898] = {.lex_state = 0, .external_lex_state = 132},
  [1899] = {.lex_state = 8},
  [1900] = {.lex_state = 0, .external_lex_state = 128},
  [1901] = {.lex_state = 0, .external_lex_state = 60},
  [1902] = {.lex_state = 0, .external_lex_state = 88},
  [1903] = {.lex_state = 0, .external_lex_state = 124},
  [1904] = {.lex_state = 8},
  [1905] = {.lex_state = 0, .external_lex_state = 88},
  [1906] = {.lex_state = 8},
  [1907] = {.lex_state = 8},
  [1908] = {.lex_state = 0, .external_lex_state = 60},
  [1909] = {.lex_state = 0, .external_lex_state = 125},
  [1910] = {.lex_state = 0, .external_lex_state = 126},
  [1911] = {.lex_state = 8},
  [1912] = {.lex_state = 0, .external_lex_state = 60},
  [1913] = {.lex_state = 8},
  [1914] = {.lex_state = 0, .external_lex_state = 113},
  [1915] = {.lex_state = 0, .external_lex_state = 128},
  [1916] = {.lex_state = 0, .external_lex_state = 127},
  [1917] = {.lex_state = 8},
  [1918] = {.lex_state = 8},
  [1919] = {.lex_state = 0, .external_lex_state = 60},
  [1920] = {.lex_state = 8},
  [1921] = {.lex_state = 8},
  [1922] = {.lex_state = 0, .external_lex_state = 60},
  [1923] = {.lex_state = 0, .external_lex_state = 60},
  [1924] = {.lex_state = 0, .external_lex_state = 60},
  [1925] = {.lex_state = 8},
  [1926] = {.lex_state = 0, .external_lex_state = 60},
  [1927] = {.lex_state = 8},
  [1928] = {.lex_state = 0, .external_lex_state = 60},
  [1929] = {.lex_state = 0, .external_lex_state = 60},
  [1930] = {.lex_state = 0, .external_lex_state = 60},
  [1931] = {.lex_state = 0, .external_lex_state = 60},
  [1932] = {.lex_state = 8},
  [1933] = {.lex_state = 8},
  [1934] = {.lex_state = 0, .external_lex_state = 60},
  [1935] = {.lex_state = 8},
  [1936] = {.lex_state = 44, .external_lex_state = 59},
  [1937] = {.lex_state = 8},
  [1938] = {.lex_state = 0, .external_lex_state = 60},
  [1939] = {.lex_state = 0, .external_lex_state = 60},
  [1940] = {.lex_state = 0, .external_lex_state = 60},
  [1941] = {.lex_state = 8},
  [1942] = {.lex_state = 0, .external_lex_state = 60},
  [1943] = {.lex_state = 8},
  [1944] = {.lex_state = 0, .external_lex_state = 60},
  [1945] = {.lex_state = 0, .external_lex_state = 128},
  [1946] = {.lex_state = 0, .external_lex_state = 125},
  [1947] = {.lex_state = 0, .external_lex_state = 126},
  [1948] = {.lex_state = 0, .external_lex_state = 129},
  [1949] = {.lex_state = 0, .external_lex_state = 130},
  [1950] = {.lex_state = 0, .external_lex_state = 60},
  [1951] = {.lex_state = 0, .external_lex_state = 131},
  [1952] = {.lex_state = 8},
  [1953] = {.lex_state = 0, .external_lex_state = 132},
  [1954] = {.lex_state = 8},
  [1955] = {.lex_state = 0, .external_lex_state = 128},
  [1956] = {.lex_state = 0, .external_lex_state = 128},
  [1957] = {.lex_state = 0, .external_lex_state = 133},
  [1958] = {.lex_state = 0, .external_lex_state = 60},
  [1959] = {.lex_state = 0, .external_lex_state = 127},
  [1960] = {.lex_state = 0, .external_lex_state = 60},
  [1961] = {.lex_state = 0, .external_lex_state = 60},
  [1962] = {.lex_state = 0, .external_lex_state = 60},
  [1963] = {.lex_state = 0, .external_lex_state = 133},
  [1964] = {.lex_state = 0, .external_lex_state = 60},
  [1965] = {.lex_state = 0, .external_lex_state = 128},
  [1966] = {.lex_state = 8},
  [1967] = {.lex_state = 8},
  [1968] = {.lex_state = 8},
  [1969] = {.lex_state = 8},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 0},
  [1972] = {.lex_state = 0, .external_lex_state = 60},
  [1973] = {.lex_state = 0},
  [1974] = {.lex_state = 0},
  [1975] = {.lex_state = 0, .external_lex_state = 126},
  [1976] = {.lex_state = 0, .external_lex_state = 138},
  [1977] = {.lex_state = 3},
  [1978] = {.lex_state = 0, .external_lex_state = 139},
  [1979] = {.lex_state = 0, .external_lex_state = 140},
  [1980] = {.lex_state = 0, .external_lex_state = 141},
  [1981] = {.lex_state = 15},
  [1982] = {.lex_state = 0, .external_lex_state = 142},
  [1983] = {.lex_state = 0, .external_lex_state = 143},
  [1984] = {.lex_state = 0, .external_lex_state = 144},
  [1985] = {.lex_state = 0, .external_lex_state = 145},
  [1986] = {.lex_state = 0, .external_lex_state = 146},
  [1987] = {.lex_state = 0, .external_lex_state = 59},
  [1988] = {.lex_state = 8},
  [1989] = {.lex_state = 0, .external_lex_state = 144},
  [1990] = {.lex_state = 0, .external_lex_state = 139},
  [1991] = {.lex_state = 0, .external_lex_state = 140},
  [1992] = {.lex_state = 0, .external_lex_state = 141},
  [1993] = {.lex_state = 0, .external_lex_state = 143},
  [1994] = {.lex_state = 0, .external_lex_state = 145},
  [1995] = {.lex_state = 0, .external_lex_state = 146},
  [1996] = {.lex_state = 0, .external_lex_state = 147},
  [1997] = {.lex_state = 0, .external_lex_state = 148},
  [1998] = {.lex_state = 3},
  [1999] = {.lex_state = 12},
  [2000] = {.lex_state = 12},
  [2001] = {.lex_state = 0, .external_lex_state = 149},
  [2002] = {.lex_state = 0, .external_lex_state = 59},
  [2003] = {.lex_state = 0, .external_lex_state = 149},
  [2004] = {.lex_state = 8},
  [2005] = {.lex_state = 0, .external_lex_state = 147},
  [2006] = {.lex_state = 0, .external_lex_state = 148},
  [2007] = {.lex_state = 3},
  [2008] = {.lex_state = 0, .external_lex_state = 150},
  [2009] = {.lex_state = 0, .external_lex_state = 59},
  [2010] = {.lex_state = 0, .external_lex_state = 150},
  [2011] = {.lex_state = 0, .external_lex_state = 148},
  [2012] = {.lex_state = 0, .external_lex_state = 148},
  [2013] = {.lex_state = 0, .external_lex_state = 151},
  [2014] = {.lex_state = 0, .external_lex_state = 149},
  [2015] = {.lex_state = 0, .external_lex_state = 59},
  [2016] = {.lex_state = 0, .external_lex_state = 59},
  [2017] = {.lex_state = 0, .external_lex_state = 59},
  [2018] = {.lex_state = 8},
  [2019] = {.lex_state = 0, .external_lex_state = 144},
  [2020] = {.lex_state = 0, .external_lex_state = 152},
  [2021] = {.lex_state = 0, .external_lex_state = 59},
  [2022] = {.lex_state = 0, .external_lex_state = 142},
  [2023] = {.lex_state = 0, .external_lex_state = 59},
  [2024] = {.lex_state = 0, .external_lex_state = 144},
  [2025] = {.lex_state = 0, .external_lex_state = 139},
  [2026] = {.lex_state = 0, .external_lex_state = 140},
  [2027] = {.lex_state = 0, .external_lex_state = 141},
  [2028] = {.lex_state = 0, .external_lex_state = 143},
  [2029] = {.lex_state = 0, .external_lex_state = 145},
  [2030] = {.lex_state = 0, .external_lex_state = 146},
  [2031] = {.lex_state = 0, .external_lex_state = 147},
  [2032] = {.lex_state = 0, .external_lex_state = 148},
  [2033] = {.lex_state = 3},
  [2034] = {.lex_state = 0, .external_lex_state = 142},
  [2035] = {.lex_state = 0, .external_lex_state = 150},
  [2036] = {.lex_state = 0, .external_lex_state = 149},
  [2037] = {.lex_state = 0, .external_lex_state = 142},
  [2038] = {.lex_state = 0, .external_lex_state = 150},
  [2039] = {.lex_state = 8},
  [2040] = {.lex_state = 0, .external_lex_state = 142},
  [2041] = {.lex_state = 8},
  [2042] = {.lex_state = 0, .external_lex_state = 59},
  [2043] = {.lex_state = 0, .external_lex_state = 59},
  [2044] = {.lex_state = 0, .external_lex_state = 59},
  [2045] = {.lex_state = 0, .external_lex_state = 59},
  [2046] = {.lex_state = 0, .external_lex_state = 59},
  [2047] = {.lex_state = 0, .external_lex_state = 59},
  [2048] = {.lex_state = 0, .external_lex_state = 59},
  [2049] = {.lex_state = 0, .external_lex_state = 59},
  [2050] = {.lex_state = 0, .external_lex_state = 59},
  [2051] = {.lex_state = 8},
  [2052] = {.lex_state = 8},
  [2053] = {.lex_state = 0, .external_lex_state = 59},
  [2054] = {.lex_state = 0, .external_lex_state = 144},
  [2055] = {.lex_state = 0, .external_lex_state = 153},
  [2056] = {.lex_state = 0, .external_lex_state = 59},
  [2057] = {.lex_state = 0, .external_lex_state = 142},
  [2058] = {.lex_state = 0, .external_lex_state = 59},
  [2059] = {.lex_state = 0, .external_lex_state = 144},
  [2060] = {.lex_state = 0, .external_lex_state = 139},
  [2061] = {.lex_state = 0, .external_lex_state = 140},
  [2062] = {.lex_state = 0, .external_lex_state = 141},
  [2063] = {.lex_state = 0, .external_lex_state = 143},
  [2064] = {.lex_state = 0, .external_lex_state = 145},
  [2065] = {.lex_state = 0, .external_lex_state = 146},
  [2066] = {.lex_state = 0, .external_lex_state = 147},
  [2067] = {.lex_state = 0, .external_lex_state = 148},
  [2068] = {.lex_state = 3},
  [2069] = {.lex_state = 0, .external_lex_state = 154},
  [2070] = {.lex_state = 0, .external_lex_state = 59},
  [2071] = {.lex_state = 0, .external_lex_state = 149},
  [2072] = {.lex_state = 0, .external_lex_state = 149},
  [2073] = {.lex_state = 0, .external_lex_state = 59},
  [2074] = {.lex_state = 8},
  [2075] = {.lex_state = 0, .external_lex_state = 59},
  [2076] = {.lex_state = 0, .external_lex_state = 59},
  [2077] = {.lex_state = 0},
  [2078] = {.lex_state = 16},
  [2079] = {.lex_state = 0, .external_lex_state = 59},
  [2080] = {.lex_state = 0, .external_lex_state = 59},
  [2081] = {.lex_state = 0, .external_lex_state = 155},
  [2082] = {.lex_state = 0, .external_lex_state = 150},
  [2083] = {.lex_state = 0, .external_lex_state = 142},
  [2084] = {.lex_state = 0, .external_lex_state = 156},
  [2085] = {.lex_state = 0, .external_lex_state = 91},
  [2086] = {.lex_state = 0, .external_lex_state = 150},
  [2087] = {.lex_state = 0, .external_lex_state = 150},
  [2088] = {.lex_state = 0, .external_lex_state = 157},
  [2089] = {.lex_state = 0, .external_lex_state = 144},
  [2090] = {.lex_state = 0, .external_lex_state = 158},
  [2091] = {.lex_state = 0, .external_lex_state = 159},
  [2092] = {.lex_state = 0, .external_lex_state = 144},
  [2093] = {.lex_state = 0, .external_lex_state = 160},
  [2094] = {.lex_state = 0, .external_lex_state = 144},
  [2095] = {.lex_state = 0, .external_lex_state = 139},
  [2096] = {.lex_state = 0, .external_lex_state = 140},
  [2097] = {.lex_state = 0, .external_lex_state = 141},
  [2098] = {.lex_state = 0, .external_lex_state = 143},
  [2099] = {.lex_state = 0, .external_lex_state = 145},
  [2100] = {.lex_state = 0, .external_lex_state = 146},
  [2101] = {.lex_state = 0, .external_lex_state = 147},
  [2102] = {.lex_state = 0, .external_lex_state = 148},
  [2103] = {.lex_state = 3},
  [2104] = {.lex_state = 0, .external_lex_state = 161},
  [2105] = {.lex_state = 0, .external_lex_state = 162},
  [2106] = {.lex_state = 0, .external_lex_state = 149},
  [2107] = {.lex_state = 0, .external_lex_state = 163},
  [2108] = {.lex_state = 0, .external_lex_state = 164},
  [2109] = {.lex_state = 8},
  [2110] = {.lex_state = 0, .external_lex_state = 142},
  [2111] = {.lex_state = 0, .external_lex_state = 165},
  [2112] = {.lex_state = 0, .external_lex_state = 158},
  [2113] = {.lex_state = 0, .external_lex_state = 150},
  [2114] = {.lex_state = 0, .external_lex_state = 59},
  [2115] = {.lex_state = 0, .external_lex_state = 166},
  [2116] = {.lex_state = 0, .external_lex_state = 59},
  [2117] = {.lex_state = 0, .external_lex_state = 59},
  [2118] = {.lex_state = 0, .external_lex_state = 142},
  [2119] = {.lex_state = 0, .external_lex_state = 142},
  [2120] = {.lex_state = 0, .external_lex_state = 144},
  [2121] = {.lex_state = 13},
  [2122] = {.lex_state = 13},
  [2123] = {.lex_state = 0, .external_lex_state = 167},
  [2124] = {.lex_state = 0, .external_lex_state = 144},
  [2125] = {.lex_state = 0, .external_lex_state = 163},
  [2126] = {.lex_state = 0, .external_lex_state = 168},
  [2127] = {.lex_state = 0, .external_lex_state = 59},
  [2128] = {.lex_state = 0, .external_lex_state = 169},
  [2129] = {.lex_state = 0, .external_lex_state = 144},
  [2130] = {.lex_state = 0, .external_lex_state = 139},
  [2131] = {.lex_state = 0, .external_lex_state = 140},
  [2132] = {.lex_state = 0, .external_lex_state = 141},
  [2133] = {.lex_state = 0, .external_lex_state = 143},
  [2134] = {.lex_state = 0, .external_lex_state = 145},
  [2135] = {.lex_state = 0, .external_lex_state = 146},
  [2136] = {.lex_state = 0, .external_lex_state = 147},
  [2137] = {.lex_state = 0, .external_lex_state = 148},
  [2138] = {.lex_state = 3},
  [2139] = {.lex_state = 0, .external_lex_state = 170},
  [2140] = {.lex_state = 0, .external_lex_state = 142},
  [2141] = {.lex_state = 0, .external_lex_state = 149},
  [2142] = {.lex_state = 0, .external_lex_state = 142},
  [2143] = {.lex_state = 44},
  [2144] = {.lex_state = 8},
  [2145] = {.lex_state = 44},
  [2146] = {.lex_state = 0, .external_lex_state = 59},
  [2147] = {.lex_state = 0, .external_lex_state = 171},
  [2148] = {.lex_state = 0, .external_lex_state = 150},
  [2149] = {.lex_state = 0, .external_lex_state = 142},
  [2150] = {.lex_state = 0, .external_lex_state = 142},
  [2151] = {.lex_state = 0, .external_lex_state = 142},
  [2152] = {.lex_state = 0, .external_lex_state = 59},
  [2153] = {.lex_state = 0, .external_lex_state = 144},
  [2154] = {.lex_state = 0, .external_lex_state = 139},
  [2155] = {.lex_state = 0, .external_lex_state = 140},
  [2156] = {.lex_state = 0, .external_lex_state = 142},
  [2157] = {.lex_state = 0, .external_lex_state = 142},
  [2158] = {.lex_state = 0, .external_lex_state = 142},
  [2159] = {.lex_state = 0, .external_lex_state = 144},
  [2160] = {.lex_state = 0, .external_lex_state = 142},
  [2161] = {.lex_state = 0, .external_lex_state = 142},
  [2162] = {.lex_state = 0, .external_lex_state = 59},
  [2163] = {.lex_state = 0, .external_lex_state = 144},
  [2164] = {.lex_state = 0, .external_lex_state = 144},
  [2165] = {.lex_state = 0, .external_lex_state = 139},
  [2166] = {.lex_state = 0, .external_lex_state = 140},
  [2167] = {.lex_state = 0, .external_lex_state = 141},
  [2168] = {.lex_state = 0, .external_lex_state = 143},
  [2169] = {.lex_state = 0, .external_lex_state = 145},
  [2170] = {.lex_state = 0, .external_lex_state = 146},
  [2171] = {.lex_state = 0, .external_lex_state = 147},
  [2172] = {.lex_state = 0, .external_lex_state = 148},
  [2173] = {.lex_state = 3},
  [2174] = {.lex_state = 0, .external_lex_state = 142},
  [2175] = {.lex_state = 0, .external_lex_state = 141},
  [2176] = {.lex_state = 0, .external_lex_state = 149},
  [2177] = {.lex_state = 0, .external_lex_state = 139},
  [2178] = {.lex_state = 0, .external_lex_state = 140},
  [2179] = {.lex_state = 8},
  [2180] = {.lex_state = 0, .external_lex_state = 172},
  [2181] = {.lex_state = 0, .external_lex_state = 141},
  [2182] = {.lex_state = 0, .external_lex_state = 142},
  [2183] = {.lex_state = 0, .external_lex_state = 143},
  [2184] = {.lex_state = 0, .external_lex_state = 145},
  [2185] = {.lex_state = 0, .external_lex_state = 146},
  [2186] = {.lex_state = 0, .external_lex_state = 173},
  [2187] = {.lex_state = 0, .external_lex_state = 147},
  [2188] = {.lex_state = 0, .external_lex_state = 142},
  [2189] = {.lex_state = 0, .external_lex_state = 148},
  [2190] = {.lex_state = 3},
  [2191] = {.lex_state = 0, .external_lex_state = 142},
  [2192] = {.lex_state = 0, .external_lex_state = 142},
  [2193] = {.lex_state = 0, .external_lex_state = 142},
  [2194] = {.lex_state = 0, .external_lex_state = 150},
  [2195] = {.lex_state = 0, .external_lex_state = 173},
  [2196] = {.lex_state = 0, .external_lex_state = 59},
  [2197] = {.lex_state = 0, .external_lex_state = 163},
  [2198] = {.lex_state = 0, .external_lex_state = 142},
  [2199] = {.lex_state = 0, .external_lex_state = 142},
  [2200] = {.lex_state = 8},
  [2201] = {.lex_state = 0, .external_lex_state = 142},
  [2202] = {.lex_state = 0, .external_lex_state = 173},
  [2203] = {.lex_state = 0, .external_lex_state = 142},
  [2204] = {.lex_state = 0, .external_lex_state = 142},
  [2205] = {.lex_state = 0, .external_lex_state = 142},
  [2206] = {.lex_state = 0, .external_lex_state = 142},
  [2207] = {.lex_state = 0, .external_lex_state = 142},
  [2208] = {.lex_state = 0, .external_lex_state = 142},
  [2209] = {.lex_state = 0, .external_lex_state = 142},
  [2210] = {.lex_state = 0, .external_lex_state = 142},
  [2211] = {.lex_state = 0, .external_lex_state = 59},
  [2212] = {.lex_state = 0, .external_lex_state = 142},
  [2213] = {.lex_state = 0, .external_lex_state = 59},
  [2214] = {.lex_state = 0, .external_lex_state = 59},
  [2215] = {.lex_state = 0, .external_lex_state = 149},
  [2216] = {.lex_state = 0, .external_lex_state = 142},
  [2217] = {.lex_state = 0, .external_lex_state = 148},
  [2218] = {.lex_state = 44},
  [2219] = {.lex_state = 15},
  [2220] = {.lex_state = 12},
  [2221] = {.lex_state = 8},
  [2222] = {.lex_state = 0, .external_lex_state = 142},
  [2223] = {.lex_state = 16},
  [2224] = {.lex_state = 0, .external_lex_state = 142},
  [2225] = {.lex_state = 0, .external_lex_state = 59},
  [2226] = {.lex_state = 0, .external_lex_state = 142},
  [2227] = {.lex_state = 0, .external_lex_state = 173},
  [2228] = {.lex_state = 0, .external_lex_state = 59},
  [2229] = {.lex_state = 0, .external_lex_state = 163},
  [2230] = {.lex_state = 0, .external_lex_state = 142},
  [2231] = {.lex_state = 0, .external_lex_state = 142},
  [2232] = {.lex_state = 0, .external_lex_state = 142},
  [2233] = {.lex_state = 0, .external_lex_state = 173},
  [2234] = {.lex_state = 0, .external_lex_state = 59},
  [2235] = {.lex_state = 0, .external_lex_state = 150},
  [2236] = {.lex_state = 0, .external_lex_state = 150},
  [2237] = {.lex_state = 0, .external_lex_state = 142},
  [2238] = {.lex_state = 8},
  [2239] = {.lex_state = 0, .external_lex_state = 59},
  [2240] = {.lex_state = 0, .external_lex_state = 59},
  [2241] = {.lex_state = 0, .external_lex_state = 59},
  [2242] = {.lex_state = 0, .external_lex_state = 142},
  [2243] = {.lex_state = 0, .external_lex_state = 142},
  [2244] = {.lex_state = 0, .external_lex_state = 59},
  [2245] = {.lex_state = 0, .external_lex_state = 59},
  [2246] = {.lex_state = 0, .external_lex_state = 59},
  [2247] = {.lex_state = 0, .external_lex_state = 59},
  [2248] = {.lex_state = 0, .external_lex_state = 148},
  [2249] = {.lex_state = 44},
  [2250] = {.lex_state = 12},
  [2251] = {.lex_state = 8},
  [2252] = {.lex_state = 0, .external_lex_state = 142},
  [2253] = {.lex_state = 16},
  [2254] = {.lex_state = 0, .external_lex_state = 143},
  [2255] = {.lex_state = 0, .external_lex_state = 59},
  [2256] = {.lex_state = 0, .external_lex_state = 59},
  [2257] = {.lex_state = 0, .external_lex_state = 173},
  [2258] = {.lex_state = 0, .external_lex_state = 59},
  [2259] = {.lex_state = 0, .external_lex_state = 163},
  [2260] = {.lex_state = 0, .external_lex_state = 164},
  [2261] = {.lex_state = 0, .external_lex_state = 142},
  [2262] = {.lex_state = 0, .external_lex_state = 91},
  [2263] = {.lex_state = 0, .external_lex_state = 173},
  [2264] = {.lex_state = 0, .external_lex_state = 59},
  [2265] = {.lex_state = 0, .external_lex_state = 142},
  [2266] = {.lex_state = 0, .external_lex_state = 59},
  [2267] = {.lex_state = 0, .external_lex_state = 174},
  [2268] = {.lex_state = 0, .external_lex_state = 59},
  [2269] = {.lex_state = 0, .external_lex_state = 59},
  [2270] = {.lex_state = 0, .external_lex_state = 150},
  [2271] = {.lex_state = 0, .external_lex_state = 142},
  [2272] = {.lex_state = 0, .external_lex_state = 164},
  [2273] = {.lex_state = 0, .external_lex_state = 150},
  [2274] = {.lex_state = 0, .external_lex_state = 59},
  [2275] = {.lex_state = 0, .external_lex_state = 59},
  [2276] = {.lex_state = 0, .external_lex_state = 142},
  [2277] = {.lex_state = 0, .external_lex_state = 142},
  [2278] = {.lex_state = 0, .external_lex_state = 148},
  [2279] = {.lex_state = 44},
  [2280] = {.lex_state = 12},
  [2281] = {.lex_state = 8},
  [2282] = {.lex_state = 0, .external_lex_state = 142},
  [2283] = {.lex_state = 16},
  [2284] = {.lex_state = 0, .external_lex_state = 59},
  [2285] = {.lex_state = 0, .external_lex_state = 145},
  [2286] = {.lex_state = 0, .external_lex_state = 173},
  [2287] = {.lex_state = 0, .external_lex_state = 59},
  [2288] = {.lex_state = 0, .external_lex_state = 163},
  [2289] = {.lex_state = 0, .external_lex_state = 175},
  [2290] = {.lex_state = 0, .external_lex_state = 142},
  [2291] = {.lex_state = 0, .external_lex_state = 139},
  [2292] = {.lex_state = 0, .external_lex_state = 173},
  [2293] = {.lex_state = 0, .external_lex_state = 146},
  [2294] = {.lex_state = 0, .external_lex_state = 144},
  [2295] = {.lex_state = 0, .external_lex_state = 176},
  [2296] = {.lex_state = 0, .external_lex_state = 147},
  [2297] = {.lex_state = 0, .external_lex_state = 150},
  [2298] = {.lex_state = 0, .external_lex_state = 160},
  [2299] = {.lex_state = 44},
  [2300] = {.lex_state = 0, .external_lex_state = 59},
  [2301] = {.lex_state = 0, .external_lex_state = 150},
  [2302] = {.lex_state = 0, .external_lex_state = 148},
  [2303] = {.lex_state = 0, .external_lex_state = 59},
  [2304] = {.lex_state = 0, .external_lex_state = 59},
  [2305] = {.lex_state = 0, .external_lex_state = 142},
  [2306] = {.lex_state = 0, .external_lex_state = 177},
  [2307] = {.lex_state = 0, .external_lex_state = 148},
  [2308] = {.lex_state = 44},
  [2309] = {.lex_state = 12},
  [2310] = {.lex_state = 8},
  [2311] = {.lex_state = 0, .external_lex_state = 142},
  [2312] = {.lex_state = 16},
  [2313] = {.lex_state = 0, .external_lex_state = 173},
  [2314] = {.lex_state = 0, .external_lex_state = 163},
  [2315] = {.lex_state = 0, .external_lex_state = 142},
  [2316] = {.lex_state = 0, .external_lex_state = 173},
  [2317] = {.lex_state = 8},
  [2318] = {.lex_state = 0, .external_lex_state = 59},
  [2319] = {.lex_state = 0, .external_lex_state = 178},
  [2320] = {.lex_state = 3},
  [2321] = {.lex_state = 0, .external_lex_state = 144},
  [2322] = {.lex_state = 0, .external_lex_state = 140},
  [2323] = {.lex_state = 0, .external_lex_state = 142},
  [2324] = {.lex_state = 0, .external_lex_state = 168},
  [2325] = {.lex_state = 0, .external_lex_state = 59},
  [2326] = {.lex_state = 0, .external_lex_state = 144},
  [2327] = {.lex_state = 8},
  [2328] = {.lex_state = 0, .external_lex_state = 148},
  [2329] = {.lex_state = 12},
  [2330] = {.lex_state = 0, .external_lex_state = 173},
  [2331] = {.lex_state = 0, .external_lex_state = 163},
  [2332] = {.lex_state = 0, .external_lex_state = 142},
  [2333] = {.lex_state = 0, .external_lex_state = 173},
  [2334] = {.lex_state = 8},
  [2335] = {.lex_state = 0, .external_lex_state = 59},
  [2336] = {.lex_state = 0, .external_lex_state = 150},
  [2337] = {.lex_state = 0, .external_lex_state = 142},
  [2338] = {.lex_state = 0, .external_lex_state = 59},
  [2339] = {.lex_state = 0, .external_lex_state = 59},
  [2340] = {.lex_state = 0, .external_lex_state = 59},
  [2341] = {.lex_state = 0, .external_lex_state = 179},
  [2342] = {.lex_state = 0, .external_lex_state = 144},
  [2343] = {.lex_state = 0, .external_lex_state = 144},
  [2344] = {.lex_state = 0, .external_lex_state = 180},
  [2345] = {.lex_state = 0, .external_lex_state = 148},
  [2346] = {.lex_state = 12},
  [2347] = {.lex_state = 0, .external_lex_state = 173},
  [2348] = {.lex_state = 0, .external_lex_state = 59},
  [2349] = {.lex_state = 0, .external_lex_state = 142},
  [2350] = {.lex_state = 0, .external_lex_state = 173},
  [2351] = {.lex_state = 77},
  [2352] = {.lex_state = 0, .external_lex_state = 139},
  [2353] = {.lex_state = 0, .external_lex_state = 139},
  [2354] = {.lex_state = 0, .external_lex_state = 140},
  [2355] = {.lex_state = 0, .external_lex_state = 141},
  [2356] = {.lex_state = 0, .external_lex_state = 143},
  [2357] = {.lex_state = 0, .external_lex_state = 145},
  [2358] = {.lex_state = 0, .external_lex_state = 140},
  [2359] = {.lex_state = 0, .external_lex_state = 146},
  [2360] = {.lex_state = 0, .external_lex_state = 141},
  [2361] = {.lex_state = 0, .external_lex_state = 147},
  [2362] = {.lex_state = 0, .external_lex_state = 148},
  [2363] = {.lex_state = 12},
  [2364] = {.lex_state = 0, .external_lex_state = 173},
  [2365] = {.lex_state = 0, .external_lex_state = 163},
  [2366] = {.lex_state = 0, .external_lex_state = 142},
  [2367] = {.lex_state = 0, .external_lex_state = 173},
  [2368] = {.lex_state = 0, .external_lex_state = 148},
  [2369] = {.lex_state = 3},
  [2370] = {.lex_state = 0, .external_lex_state = 143},
  [2371] = {.lex_state = 0, .external_lex_state = 145},
  [2372] = {.lex_state = 0, .external_lex_state = 59},
  [2373] = {.lex_state = 0, .external_lex_state = 150},
  [2374] = {.lex_state = 0, .external_lex_state = 146},
  [2375] = {.lex_state = 0, .external_lex_state = 147},
  [2376] = {.lex_state = 0, .external_lex_state = 148},
  [2377] = {.lex_state = 3},
  [2378] = {.lex_state = 0, .external_lex_state = 181},
  [2379] = {.lex_state = 0, .external_lex_state = 148},
  [2380] = {.lex_state = 12},
  [2381] = {.lex_state = 0, .external_lex_state = 173},
  [2382] = {.lex_state = 0, .external_lex_state = 163},
  [2383] = {.lex_state = 0, .external_lex_state = 142},
  [2384] = {.lex_state = 0, .external_lex_state = 173},
  [2385] = {.lex_state = 0, .external_lex_state = 149},
  [2386] = {.lex_state = 0, .external_lex_state = 59},
  [2387] = {.lex_state = 0, .external_lex_state = 59},
  [2388] = {.lex_state = 0, .external_lex_state = 149},
  [2389] = {.lex_state = 77},
  [2390] = {.lex_state = 0, .external_lex_state = 59},
  [2391] = {.lex_state = 0, .external_lex_state = 150},
  [2392] = {.lex_state = 0, .external_lex_state = 149},
  [2393] = {.lex_state = 0, .external_lex_state = 150},
  [2394] = {.lex_state = 8},
  [2395] = {.lex_state = 0, .external_lex_state = 59},
  [2396] = {.lex_state = 0, .external_lex_state = 148},
  [2397] = {.lex_state = 12},
  [2398] = {.lex_state = 0, .external_lex_state = 173},
  [2399] = {.lex_state = 0, .external_lex_state = 163},
  [2400] = {.lex_state = 0, .external_lex_state = 142},
  [2401] = {.lex_state = 0, .external_lex_state = 173},
  [2402] = {.lex_state = 8},
  [2403] = {.lex_state = 8},
  [2404] = {.lex_state = 0, .external_lex_state = 59},
  [2405] = {.lex_state = 0, .external_lex_state = 59},
  [2406] = {.lex_state = 0, .external_lex_state = 59},
  [2407] = {.lex_state = 0, .external_lex_state = 59},
  [2408] = {.lex_state = 0, .external_lex_state = 59},
  [2409] = {.lex_state = 13},
  [2410] = {.lex_state = 0, .external_lex_state = 59},
  [2411] = {.lex_state = 0, .external_lex_state = 149},
  [2412] = {.lex_state = 0, .external_lex_state = 59},
  [2413] = {.lex_state = 0, .external_lex_state = 148},
  [2414] = {.lex_state = 12},
  [2415] = {.lex_state = 0, .external_lex_state = 173},
  [2416] = {.lex_state = 0, .external_lex_state = 163},
  [2417] = {.lex_state = 0, .external_lex_state = 142},
  [2418] = {.lex_state = 0, .external_lex_state = 173},
  [2419] = {.lex_state = 0, .external_lex_state = 59},
  [2420] = {.lex_state = 0, .external_lex_state = 59},
  [2421] = {.lex_state = 0, .external_lex_state = 59},
  [2422] = {.lex_state = 0, .external_lex_state = 150},
  [2423] = {.lex_state = 0, .external_lex_state = 59},
  [2424] = {.lex_state = 0, .external_lex_state = 59},
  [2425] = {.lex_state = 0, .external_lex_state = 150},
  [2426] = {.lex_state = 0, .external_lex_state = 150},
  [2427] = {.lex_state = 0, .external_lex_state = 141},
  [2428] = {.lex_state = 0, .external_lex_state = 150},
  [2429] = {.lex_state = 0, .external_lex_state = 143},
  [2430] = {.lex_state = 0, .external_lex_state = 148},
  [2431] = {.lex_state = 12},
  [2432] = {.lex_state = 0, .external_lex_state = 173},
  [2433] = {.lex_state = 0, .external_lex_state = 163},
  [2434] = {.lex_state = 0, .external_lex_state = 142},
  [2435] = {.lex_state = 0, .external_lex_state = 173},
  [2436] = {.lex_state = 0, .external_lex_state = 59},
  [2437] = {.lex_state = 0, .external_lex_state = 144},
  [2438] = {.lex_state = 0, .external_lex_state = 144},
  [2439] = {.lex_state = 0, .external_lex_state = 144},
  [2440] = {.lex_state = 8},
  [2441] = {.lex_state = 0, .external_lex_state = 145},
  [2442] = {.lex_state = 44},
  [2443] = {.lex_state = 8},
  [2444] = {.lex_state = 0, .external_lex_state = 144},
  [2445] = {.lex_state = 0, .external_lex_state = 139},
  [2446] = {.lex_state = 0, .external_lex_state = 140},
  [2447] = {.lex_state = 0, .external_lex_state = 148},
  [2448] = {.lex_state = 12},
  [2449] = {.lex_state = 0, .external_lex_state = 142},
  [2450] = {.lex_state = 0, .external_lex_state = 142},
  [2451] = {.lex_state = 0, .external_lex_state = 142},
  [2452] = {.lex_state = 0, .external_lex_state = 142},
  [2453] = {.lex_state = 0, .external_lex_state = 142},
  [2454] = {.lex_state = 0, .external_lex_state = 142},
  [2455] = {.lex_state = 77},
  [2456] = {.lex_state = 0, .external_lex_state = 153},
  [2457] = {.lex_state = 0, .external_lex_state = 157},
  [2458] = {.lex_state = 0, .external_lex_state = 159},
  [2459] = {.lex_state = 0, .external_lex_state = 165},
  [2460] = {.lex_state = 0, .external_lex_state = 166},
  [2461] = {.lex_state = 0, .external_lex_state = 167},
  [2462] = {.lex_state = 0, .external_lex_state = 138},
  [2463] = {.lex_state = 0, .external_lex_state = 164},
  [2464] = {.lex_state = 0, .external_lex_state = 163},
  [2465] = {.lex_state = 0, .external_lex_state = 179},
  [2466] = {.lex_state = 0, .external_lex_state = 141},
  [2467] = {.lex_state = 13},
  [2468] = {.lex_state = 8},
  [2469] = {.lex_state = 77},
  [2470] = {.lex_state = 0, .external_lex_state = 153},
  [2471] = {.lex_state = 0, .external_lex_state = 157},
  [2472] = {.lex_state = 0, .external_lex_state = 159},
  [2473] = {.lex_state = 0, .external_lex_state = 165},
  [2474] = {.lex_state = 0, .external_lex_state = 166},
  [2475] = {.lex_state = 0, .external_lex_state = 167},
  [2476] = {.lex_state = 0, .external_lex_state = 138},
  [2477] = {.lex_state = 0, .external_lex_state = 164},
  [2478] = {.lex_state = 0, .external_lex_state = 163},
  [2479] = {.lex_state = 0, .external_lex_state = 179},
  [2480] = {.lex_state = 0, .external_lex_state = 143},
  [2481] = {.lex_state = 13},
  [2482] = {.lex_state = 8},
  [2483] = {.lex_state = 77},
  [2484] = {.lex_state = 0, .external_lex_state = 153},
  [2485] = {.lex_state = 0, .external_lex_state = 157},
  [2486] = {.lex_state = 0, .external_lex_state = 159},
  [2487] = {.lex_state = 0, .external_lex_state = 165},
  [2488] = {.lex_state = 0, .external_lex_state = 166},
  [2489] = {.lex_state = 0, .external_lex_state = 167},
  [2490] = {.lex_state = 0, .external_lex_state = 138},
  [2491] = {.lex_state = 0, .external_lex_state = 164},
  [2492] = {.lex_state = 0, .external_lex_state = 163},
  [2493] = {.lex_state = 0, .external_lex_state = 179},
  [2494] = {.lex_state = 0, .external_lex_state = 145},
  [2495] = {.lex_state = 13},
  [2496] = {.lex_state = 8},
  [2497] = {.lex_state = 77},
  [2498] = {.lex_state = 0, .external_lex_state = 153},
  [2499] = {.lex_state = 0, .external_lex_state = 157},
  [2500] = {.lex_state = 0, .external_lex_state = 159},
  [2501] = {.lex_state = 0, .external_lex_state = 165},
  [2502] = {.lex_state = 0, .external_lex_state = 166},
  [2503] = {.lex_state = 0, .external_lex_state = 167},
  [2504] = {.lex_state = 0, .external_lex_state = 138},
  [2505] = {.lex_state = 0, .external_lex_state = 164},
  [2506] = {.lex_state = 0, .external_lex_state = 163},
  [2507] = {.lex_state = 0, .external_lex_state = 179},
  [2508] = {.lex_state = 0, .external_lex_state = 146},
  [2509] = {.lex_state = 13},
  [2510] = {.lex_state = 8},
  [2511] = {.lex_state = 0, .external_lex_state = 153},
  [2512] = {.lex_state = 0, .external_lex_state = 157},
  [2513] = {.lex_state = 0, .external_lex_state = 159},
  [2514] = {.lex_state = 0, .external_lex_state = 165},
  [2515] = {.lex_state = 0, .external_lex_state = 166},
  [2516] = {.lex_state = 0, .external_lex_state = 167},
  [2517] = {.lex_state = 0, .external_lex_state = 138},
  [2518] = {.lex_state = 0, .external_lex_state = 164},
  [2519] = {.lex_state = 0, .external_lex_state = 163},
  [2520] = {.lex_state = 0, .external_lex_state = 179},
  [2521] = {.lex_state = 0, .external_lex_state = 147},
  [2522] = {.lex_state = 0, .external_lex_state = 153},
  [2523] = {.lex_state = 0, .external_lex_state = 157},
  [2524] = {.lex_state = 0, .external_lex_state = 159},
  [2525] = {.lex_state = 0, .external_lex_state = 165},
  [2526] = {.lex_state = 0, .external_lex_state = 166},
  [2527] = {.lex_state = 0, .external_lex_state = 167},
  [2528] = {.lex_state = 0, .external_lex_state = 138},
  [2529] = {.lex_state = 0, .external_lex_state = 164},
  [2530] = {.lex_state = 0, .external_lex_state = 163},
  [2531] = {.lex_state = 0, .external_lex_state = 179},
  [2532] = {.lex_state = 0, .external_lex_state = 148},
  [2533] = {.lex_state = 0, .external_lex_state = 153},
  [2534] = {.lex_state = 0, .external_lex_state = 157},
  [2535] = {.lex_state = 0, .external_lex_state = 159},
  [2536] = {.lex_state = 0, .external_lex_state = 165},
  [2537] = {.lex_state = 0, .external_lex_state = 166},
  [2538] = {.lex_state = 0, .external_lex_state = 167},
  [2539] = {.lex_state = 0, .external_lex_state = 138},
  [2540] = {.lex_state = 0, .external_lex_state = 164},
  [2541] = {.lex_state = 0, .external_lex_state = 163},
  [2542] = {.lex_state = 0, .external_lex_state = 179},
  [2543] = {.lex_state = 3},
  [2544] = {.lex_state = 0, .external_lex_state = 153},
  [2545] = {.lex_state = 0, .external_lex_state = 157},
  [2546] = {.lex_state = 0, .external_lex_state = 159},
  [2547] = {.lex_state = 0, .external_lex_state = 165},
  [2548] = {.lex_state = 0, .external_lex_state = 166},
  [2549] = {.lex_state = 0, .external_lex_state = 167},
  [2550] = {.lex_state = 0, .external_lex_state = 138},
  [2551] = {.lex_state = 0, .external_lex_state = 164},
  [2552] = {.lex_state = 0, .external_lex_state = 163},
  [2553] = {.lex_state = 0, .external_lex_state = 179},
  [2554] = {.lex_state = 0, .external_lex_state = 142},
  [2555] = {.lex_state = 0, .external_lex_state = 153},
  [2556] = {.lex_state = 0, .external_lex_state = 157},
  [2557] = {.lex_state = 0, .external_lex_state = 159},
  [2558] = {.lex_state = 0, .external_lex_state = 165},
  [2559] = {.lex_state = 0, .external_lex_state = 166},
  [2560] = {.lex_state = 0, .external_lex_state = 167},
  [2561] = {.lex_state = 0, .external_lex_state = 138},
  [2562] = {.lex_state = 0, .external_lex_state = 164},
  [2563] = {.lex_state = 0, .external_lex_state = 163},
  [2564] = {.lex_state = 0, .external_lex_state = 179},
  [2565] = {.lex_state = 0, .external_lex_state = 148},
  [2566] = {.lex_state = 0, .external_lex_state = 153},
  [2567] = {.lex_state = 0, .external_lex_state = 157},
  [2568] = {.lex_state = 0, .external_lex_state = 159},
  [2569] = {.lex_state = 0, .external_lex_state = 165},
  [2570] = {.lex_state = 0, .external_lex_state = 166},
  [2571] = {.lex_state = 0, .external_lex_state = 167},
  [2572] = {.lex_state = 0, .external_lex_state = 149},
  [2573] = {.lex_state = 0, .external_lex_state = 164},
  [2574] = {.lex_state = 0, .external_lex_state = 163},
  [2575] = {.lex_state = 0, .external_lex_state = 179},
  [2576] = {.lex_state = 0, .external_lex_state = 182},
  [2577] = {.lex_state = 0, .external_lex_state = 153},
  [2578] = {.lex_state = 0, .external_lex_state = 157},
  [2579] = {.lex_state = 0, .external_lex_state = 159},
  [2580] = {.lex_state = 0, .external_lex_state = 165},
  [2581] = {.lex_state = 0, .external_lex_state = 166},
  [2582] = {.lex_state = 0, .external_lex_state = 167},
  [2583] = {.lex_state = 0, .external_lex_state = 138},
  [2584] = {.lex_state = 0, .external_lex_state = 164},
  [2585] = {.lex_state = 0, .external_lex_state = 163},
  [2586] = {.lex_state = 0, .external_lex_state = 179},
  [2587] = {.lex_state = 0, .external_lex_state = 59},
  [2588] = {.lex_state = 0, .external_lex_state = 153},
  [2589] = {.lex_state = 0, .external_lex_state = 157},
  [2590] = {.lex_state = 0, .external_lex_state = 159},
  [2591] = {.lex_state = 0, .external_lex_state = 165},
  [2592] = {.lex_state = 0, .external_lex_state = 166},
  [2593] = {.lex_state = 0, .external_lex_state = 167},
  [2594] = {.lex_state = 0, .external_lex_state = 138},
  [2595] = {.lex_state = 0, .external_lex_state = 164},
  [2596] = {.lex_state = 0, .external_lex_state = 163},
  [2597] = {.lex_state = 0, .external_lex_state = 179},
  [2598] = {.lex_state = 0, .external_lex_state = 59},
  [2599] = {.lex_state = 0, .external_lex_state = 164},
  [2600] = {.lex_state = 8},
  [2601] = {.lex_state = 0, .external_lex_state = 169},
  [2602] = {.lex_state = 0, .external_lex_state = 173},
  [2603] = {.lex_state = 0, .external_lex_state = 164},
  [2604] = {.lex_state = 0, .external_lex_state = 138},
  [2605] = {.lex_state = 0, .external_lex_state = 169},
  [2606] = {.lex_state = 0, .external_lex_state = 59},
  [2607] = {.lex_state = 0, .external_lex_state = 164},
  [2608] = {.lex_state = 8},
  [2609] = {.lex_state = 0, .external_lex_state = 169},
  [2610] = {.lex_state = 0, .external_lex_state = 164},
  [2611] = {.lex_state = 0, .external_lex_state = 142},
  [2612] = {.lex_state = 0, .external_lex_state = 169},
  [2613] = {.lex_state = 0, .external_lex_state = 164},
  [2614] = {.lex_state = 0, .external_lex_state = 164},
  [2615] = {.lex_state = 0, .external_lex_state = 164},
  [2616] = {.lex_state = 0, .external_lex_state = 164},
  [2617] = {.lex_state = 0, .external_lex_state = 164},
  [2618] = {.lex_state = 0, .external_lex_state = 164},
  [2619] = {.lex_state = 0, .external_lex_state = 164},
  [2620] = {.lex_state = 0, .external_lex_state = 164},
  [2621] = {.lex_state = 0, .external_lex_state = 146},
  [2622] = {.lex_state = 0, .external_lex_state = 59},
  [2623] = {.lex_state = 0, .external_lex_state = 147},
  [2624] = {.lex_state = 0, .external_lex_state = 148},
  [2625] = {.lex_state = 0, .external_lex_state = 59},
  [2626] = {.lex_state = 0, .external_lex_state = 183},
  [2627] = {.lex_state = 0, .external_lex_state = 144},
  [2628] = {.lex_state = 0, .external_lex_state = 59},
  [2629] = {.lex_state = 13},
  [2630] = {.lex_state = 13},
  [2631] = {.lex_state = 13},
  [2632] = {.lex_state = 13},
  [2633] = {.lex_state = 0, .external_lex_state = 163},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_x] = ACTIONS(1),
    [anon_sym_X] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_SPACE] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym__whitespace1] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_em_dash] = ACTIONS(1),
    [sym_en_dash] = ACTIONS(1),
    [sym_backslash_escape] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym_symbol] = ACTIONS(1),
    [anon_sym_LBRACE_] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_LBRACE_STAR] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACE_CARET] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LBRACE_TILDE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LBRACE_EQ] = ACTIONS(1),
    [anon_sym_LBRACE_PLUS] = ACTIONS(1),
    [anon_sym_LBRACE_DASH] = ACTIONS(1),
    [anon_sym_LBRACK_CARET] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_BANG_LBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACE_EQ2] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_TODO] = ACTIONS(1),
    [anon_sym_WIP] = ACTIONS(1),
    [anon_sym_NOTE] = ACTIONS(1),
    [anon_sym_INFO] = ACTIONS(1),
    [anon_sym_XXX] = ACTIONS(1),
    [sym_fixme] = ACTIONS(1),
    [aux_sym__text_token1] = ACTIONS(1),
    [sym__ignored] = ACTIONS(1),
    [sym__block_close] = ACTIONS(1),
    [sym__eof_or_newline] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__newline_inline] = ACTIONS(1),
    [sym__non_whitespace_check] = ACTIONS(1),
    [sym_hard_line_break] = ACTIONS(1),
    [sym_frontmatter_marker] = ACTIONS(1),
    [sym__heading_begin] = ACTIONS(1),
    [sym__heading_continuation] = ACTIONS(1),
    [sym__div_begin] = ACTIONS(1),
    [sym__div_end] = ACTIONS(1),
    [sym__code_block_begin] = ACTIONS(1),
    [sym__code_block_end] = ACTIONS(1),
    [sym_list_marker_dash] = ACTIONS(1),
    [sym_list_marker_star] = ACTIONS(1),
    [sym_list_marker_plus] = ACTIONS(1),
    [sym__list_marker_task_begin] = ACTIONS(1),
    [sym_list_marker_definition] = ACTIONS(1),
    [sym_list_marker_decimal_period] = ACTIONS(1),
    [sym_list_marker_lower_alpha_period] = ACTIONS(1),
    [sym_list_marker_upper_alpha_period] = ACTIONS(1),
    [sym_list_marker_lower_roman_period] = ACTIONS(1),
    [sym_list_marker_upper_roman_period] = ACTIONS(1),
    [sym_list_marker_decimal_paren] = ACTIONS(1),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(1),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(1),
    [sym_list_marker_lower_roman_paren] = ACTIONS(1),
    [sym_list_marker_upper_roman_paren] = ACTIONS(1),
    [sym_list_marker_decimal_parens] = ACTIONS(1),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(1),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(1),
    [sym_list_marker_lower_roman_parens] = ACTIONS(1),
    [sym_list_marker_upper_roman_parens] = ACTIONS(1),
    [sym__list_item_continuation] = ACTIONS(1),
    [sym__list_item_end] = ACTIONS(1),
    [sym__indented_content_spacer] = ACTIONS(1),
    [sym__close_paragraph] = ACTIONS(1),
    [sym__block_quote_begin] = ACTIONS(1),
    [sym__block_quote_continuation] = ACTIONS(1),
    [sym__thematic_break_dash] = ACTIONS(1),
    [sym__thematic_break_star] = ACTIONS(1),
    [sym__footnote_mark_begin] = ACTIONS(1),
    [sym__footnote_continuation] = ACTIONS(1),
    [sym__footnote_end] = ACTIONS(1),
    [sym__link_ref_def_mark_begin] = ACTIONS(1),
    [sym__link_ref_def_label_end] = ACTIONS(1),
    [sym__table_header_begin] = ACTIONS(1),
    [sym__table_separator_begin] = ACTIONS(1),
    [sym__table_row_begin] = ACTIONS(1),
    [sym__table_row_end_newline] = ACTIONS(1),
    [sym__table_cell_end] = ACTIONS(1),
    [sym__table_caption_begin] = ACTIONS(1),
    [sym__table_caption_end] = ACTIONS(1),
    [sym__block_attribute_begin] = ACTIONS(1),
    [sym__comment_end_marker] = ACTIONS(1),
    [sym__comment_close] = ACTIONS(1),
    [sym__inline_comment_begin] = ACTIONS(1),
    [sym__verbatim_begin] = ACTIONS(1),
    [sym__verbatim_end] = ACTIONS(1),
    [sym__verbatim_content] = ACTIONS(1),
    [sym__emphasis_mark_begin] = ACTIONS(1),
    [sym_emphasis_end] = ACTIONS(1),
    [sym__strong_mark_begin] = ACTIONS(1),
    [sym_strong_end] = ACTIONS(1),
    [sym__superscript_mark_begin] = ACTIONS(1),
    [sym_superscript_end] = ACTIONS(1),
    [sym__subscript_mark_begin] = ACTIONS(1),
    [sym_subscript_end] = ACTIONS(1),
    [sym__highlighted_mark_begin] = ACTIONS(1),
    [sym_highlighted_end] = ACTIONS(1),
    [sym__insert_mark_begin] = ACTIONS(1),
    [sym_insert_end] = ACTIONS(1),
    [sym__delete_mark_begin] = ACTIONS(1),
    [sym_delete_end] = ACTIONS(1),
    [sym__parens_span_mark_begin] = ACTIONS(1),
    [sym__parens_span_end] = ACTIONS(1),
    [sym__curly_bracket_span_mark_begin] = ACTIONS(1),
    [sym__curly_bracket_span_end] = ACTIONS(1),
    [sym__square_bracket_span_mark_begin] = ACTIONS(1),
    [sym__square_bracket_span_end] = ACTIONS(1),
    [sym__in_fallback] = ACTIONS(1),
    [sym__error] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(2077),
    [sym_frontmatter] = STATE(3),
    [sym__block_with_section] = STATE(355),
    [sym__block_element] = STATE(355),
    [sym_section] = STATE(355),
    [sym_heading] = STATE(4),
    [sym_list] = STATE(355),
    [sym__list_dash] = STATE(364),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(364),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(364),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(364),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(364),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(364),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(364),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(364),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(364),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(364),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(364),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(364),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(364),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(364),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(364),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(364),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(364),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(364),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(364),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(364),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(355),
    [sym__table_row] = STATE(134),
    [sym_table_header] = STATE(134),
    [sym_table_separator] = STATE(134),
    [sym_table_row] = STATE(134),
    [sym_footnote] = STATE(355),
    [sym_div] = STATE(355),
    [sym__div_marker_begin] = STATE(2325),
    [sym_code_block] = STATE(355),
    [sym_raw_block] = STATE(355),
    [sym_thematic_break] = STATE(355),
    [sym_block_quote] = STATE(355),
    [sym__block_quote_prefix] = STATE(92),
    [sym_link_reference_definition] = STATE(355),
    [sym_block_attribute] = STATE(355),
    [sym__paragraph] = STATE(355),
    [sym__paragraph_content] = STATE(1658),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(2),
    [aux_sym__list_dash_repeat1] = STATE(1159),
    [aux_sym__list_plus_repeat1] = STATE(1212),
    [aux_sym__list_star_repeat1] = STATE(1216),
    [aux_sym__list_task_repeat1] = STATE(1100),
    [aux_sym__list_definition_repeat1] = STATE(1399),
    [aux_sym__list_decimal_period_repeat1] = STATE(1236),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1237),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1163),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1165),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1103),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1105),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1106),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1107),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1109),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1113),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1132),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1134),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1135),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1192),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1224),
    [aux_sym_table_repeat1] = STATE(134),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(49),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym_frontmatter_marker] = ACTIONS(53),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(59),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(101),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(105),
    [sym__thematic_break_star] = ACTIONS(105),
    [sym__footnote_mark_begin] = ACTIONS(107),
    [sym__link_ref_def_mark_begin] = ACTIONS(109),
    [sym__table_header_begin] = ACTIONS(111),
    [sym__table_separator_begin] = ACTIONS(113),
    [sym__table_row_begin] = ACTIONS(115),
    [sym__block_attribute_begin] = ACTIONS(117),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [2] = {
    [sym__block_with_section] = STATE(355),
    [sym__block_element] = STATE(355),
    [sym_section] = STATE(355),
    [sym_heading] = STATE(4),
    [sym_list] = STATE(355),
    [sym__list_dash] = STATE(364),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(364),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(364),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(364),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(364),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(364),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(364),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(364),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(364),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(364),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(364),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(364),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(364),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(364),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(364),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(364),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(364),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(364),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(364),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(364),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(355),
    [sym__table_row] = STATE(134),
    [sym_table_header] = STATE(134),
    [sym_table_separator] = STATE(134),
    [sym_table_row] = STATE(134),
    [sym_footnote] = STATE(355),
    [sym_div] = STATE(355),
    [sym__div_marker_begin] = STATE(2325),
    [sym_code_block] = STATE(355),
    [sym_raw_block] = STATE(355),
    [sym_thematic_break] = STATE(355),
    [sym_block_quote] = STATE(355),
    [sym__block_quote_prefix] = STATE(92),
    [sym_link_reference_definition] = STATE(355),
    [sym_block_attribute] = STATE(355),
    [sym__paragraph] = STATE(355),
    [sym__paragraph_content] = STATE(1658),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(7),
    [aux_sym__list_dash_repeat1] = STATE(1159),
    [aux_sym__list_plus_repeat1] = STATE(1212),
    [aux_sym__list_star_repeat1] = STATE(1216),
    [aux_sym__list_task_repeat1] = STATE(1100),
    [aux_sym__list_definition_repeat1] = STATE(1399),
    [aux_sym__list_decimal_period_repeat1] = STATE(1236),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1237),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1163),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1165),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1103),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1105),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1106),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1107),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1109),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1113),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1132),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1134),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1135),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1192),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1224),
    [aux_sym_table_repeat1] = STATE(134),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(49),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(59),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(101),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(105),
    [sym__thematic_break_star] = ACTIONS(105),
    [sym__footnote_mark_begin] = ACTIONS(107),
    [sym__link_ref_def_mark_begin] = ACTIONS(109),
    [sym__table_header_begin] = ACTIONS(111),
    [sym__table_separator_begin] = ACTIONS(113),
    [sym__table_row_begin] = ACTIONS(115),
    [sym__block_attribute_begin] = ACTIONS(117),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [3] = {
    [sym__block_with_section] = STATE(355),
    [sym__block_element] = STATE(355),
    [sym_section] = STATE(355),
    [sym_heading] = STATE(4),
    [sym_list] = STATE(355),
    [sym__list_dash] = STATE(364),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(364),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(364),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(364),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(364),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(364),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(364),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(364),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(364),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(364),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(364),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(364),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(364),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(364),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(364),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(364),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(364),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(364),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(364),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(364),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(355),
    [sym__table_row] = STATE(134),
    [sym_table_header] = STATE(134),
    [sym_table_separator] = STATE(134),
    [sym_table_row] = STATE(134),
    [sym_footnote] = STATE(355),
    [sym_div] = STATE(355),
    [sym__div_marker_begin] = STATE(2325),
    [sym_code_block] = STATE(355),
    [sym_raw_block] = STATE(355),
    [sym_thematic_break] = STATE(355),
    [sym_block_quote] = STATE(355),
    [sym__block_quote_prefix] = STATE(92),
    [sym_link_reference_definition] = STATE(355),
    [sym_block_attribute] = STATE(355),
    [sym__paragraph] = STATE(355),
    [sym__paragraph_content] = STATE(1658),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(6),
    [aux_sym__list_dash_repeat1] = STATE(1159),
    [aux_sym__list_plus_repeat1] = STATE(1212),
    [aux_sym__list_star_repeat1] = STATE(1216),
    [aux_sym__list_task_repeat1] = STATE(1100),
    [aux_sym__list_definition_repeat1] = STATE(1399),
    [aux_sym__list_decimal_period_repeat1] = STATE(1236),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1237),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1163),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1165),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1103),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1105),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1106),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1107),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1109),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1113),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1132),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1134),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1135),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1192),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1224),
    [aux_sym_table_repeat1] = STATE(134),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(49),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(59),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(101),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(105),
    [sym__thematic_break_star] = ACTIONS(105),
    [sym__footnote_mark_begin] = ACTIONS(107),
    [sym__link_ref_def_mark_begin] = ACTIONS(109),
    [sym__table_header_begin] = ACTIONS(111),
    [sym__table_separator_begin] = ACTIONS(113),
    [sym__table_row_begin] = ACTIONS(115),
    [sym__block_attribute_begin] = ACTIONS(117),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [4] = {
    [sym__block_with_section] = STATE(325),
    [sym__block_element] = STATE(325),
    [sym_section] = STATE(325),
    [sym_heading] = STATE(9),
    [sym_list] = STATE(325),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(325),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(325),
    [sym_div] = STATE(325),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(325),
    [sym_raw_block] = STATE(325),
    [sym_thematic_break] = STATE(325),
    [sym_block_quote] = STATE(325),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(325),
    [sym_block_attribute] = STATE(325),
    [sym__paragraph] = STATE(325),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(5),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(123),
    [sym__newline] = ACTIONS(125),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [5] = {
    [sym__block_with_section] = STATE(325),
    [sym__block_element] = STATE(325),
    [sym_section] = STATE(325),
    [sym_heading] = STATE(9),
    [sym_list] = STATE(325),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(325),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(325),
    [sym_div] = STATE(325),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(325),
    [sym_raw_block] = STATE(325),
    [sym_thematic_break] = STATE(325),
    [sym_block_quote] = STATE(325),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(325),
    [sym_block_attribute] = STATE(325),
    [sym__paragraph] = STATE(325),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(8),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(145),
    [sym__newline] = ACTIONS(125),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [6] = {
    [sym__block_with_section] = STATE(355),
    [sym__block_element] = STATE(355),
    [sym_section] = STATE(355),
    [sym_heading] = STATE(4),
    [sym_list] = STATE(355),
    [sym__list_dash] = STATE(364),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(364),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(364),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(364),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(364),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(364),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(364),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(364),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(364),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(364),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(364),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(364),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(364),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(364),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(364),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(364),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(364),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(364),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(364),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(364),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(355),
    [sym__table_row] = STATE(134),
    [sym_table_header] = STATE(134),
    [sym_table_separator] = STATE(134),
    [sym_table_row] = STATE(134),
    [sym_footnote] = STATE(355),
    [sym_div] = STATE(355),
    [sym__div_marker_begin] = STATE(2325),
    [sym_code_block] = STATE(355),
    [sym_raw_block] = STATE(355),
    [sym_thematic_break] = STATE(355),
    [sym_block_quote] = STATE(355),
    [sym__block_quote_prefix] = STATE(92),
    [sym_link_reference_definition] = STATE(355),
    [sym_block_attribute] = STATE(355),
    [sym__paragraph] = STATE(355),
    [sym__paragraph_content] = STATE(1658),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(7),
    [aux_sym__list_dash_repeat1] = STATE(1159),
    [aux_sym__list_plus_repeat1] = STATE(1212),
    [aux_sym__list_star_repeat1] = STATE(1216),
    [aux_sym__list_task_repeat1] = STATE(1100),
    [aux_sym__list_definition_repeat1] = STATE(1399),
    [aux_sym__list_decimal_period_repeat1] = STATE(1236),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1237),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1163),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1165),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1103),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1105),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1106),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1107),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1109),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1113),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1132),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1134),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1135),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1192),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1224),
    [aux_sym_table_repeat1] = STATE(134),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(49),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(59),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(101),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(105),
    [sym__thematic_break_star] = ACTIONS(105),
    [sym__footnote_mark_begin] = ACTIONS(107),
    [sym__link_ref_def_mark_begin] = ACTIONS(109),
    [sym__table_header_begin] = ACTIONS(111),
    [sym__table_separator_begin] = ACTIONS(113),
    [sym__table_row_begin] = ACTIONS(115),
    [sym__block_attribute_begin] = ACTIONS(117),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [7] = {
    [sym__block_with_section] = STATE(355),
    [sym__block_element] = STATE(355),
    [sym_section] = STATE(355),
    [sym_heading] = STATE(4),
    [sym_list] = STATE(355),
    [sym__list_dash] = STATE(364),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(364),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(364),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(364),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(364),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(364),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(364),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(364),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(364),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(364),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(364),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(364),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(364),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(364),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(364),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(364),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(364),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(364),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(364),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(364),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(355),
    [sym__table_row] = STATE(134),
    [sym_table_header] = STATE(134),
    [sym_table_separator] = STATE(134),
    [sym_table_row] = STATE(134),
    [sym_footnote] = STATE(355),
    [sym_div] = STATE(355),
    [sym__div_marker_begin] = STATE(2325),
    [sym_code_block] = STATE(355),
    [sym_raw_block] = STATE(355),
    [sym_thematic_break] = STATE(355),
    [sym_block_quote] = STATE(355),
    [sym__block_quote_prefix] = STATE(92),
    [sym_link_reference_definition] = STATE(355),
    [sym_block_attribute] = STATE(355),
    [sym__paragraph] = STATE(355),
    [sym__paragraph_content] = STATE(1658),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(7),
    [aux_sym__list_dash_repeat1] = STATE(1159),
    [aux_sym__list_plus_repeat1] = STATE(1212),
    [aux_sym__list_star_repeat1] = STATE(1216),
    [aux_sym__list_task_repeat1] = STATE(1100),
    [aux_sym__list_definition_repeat1] = STATE(1399),
    [aux_sym__list_decimal_period_repeat1] = STATE(1236),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1237),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1163),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1165),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1103),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1105),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1106),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1107),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1109),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1113),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1132),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1134),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1135),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1192),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1224),
    [aux_sym_table_repeat1] = STATE(134),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [sym__whitespace1] = ACTIONS(154),
    [sym_quotation_marks] = ACTIONS(157),
    [sym_ellipsis] = ACTIONS(157),
    [sym_em_dash] = ACTIONS(157),
    [sym_en_dash] = ACTIONS(160),
    [sym_backslash_escape] = ACTIONS(160),
    [anon_sym_LT] = ACTIONS(163),
    [sym_symbol] = ACTIONS(157),
    [anon_sym_LBRACE_] = ACTIONS(166),
    [anon_sym__] = ACTIONS(169),
    [anon_sym_LBRACE_STAR] = ACTIONS(172),
    [anon_sym_STAR] = ACTIONS(175),
    [anon_sym_LBRACE_CARET] = ACTIONS(178),
    [anon_sym_CARET] = ACTIONS(178),
    [anon_sym_LBRACE_TILDE] = ACTIONS(181),
    [anon_sym_TILDE] = ACTIONS(181),
    [anon_sym_LBRACE_EQ] = ACTIONS(184),
    [anon_sym_LBRACE_PLUS] = ACTIONS(187),
    [anon_sym_LBRACE_DASH] = ACTIONS(190),
    [anon_sym_LBRACK_CARET] = ACTIONS(193),
    [anon_sym_BANG_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(199),
    [anon_sym_LPAREN] = ACTIONS(202),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [anon_sym_TODO] = ACTIONS(208),
    [anon_sym_WIP] = ACTIONS(208),
    [anon_sym_NOTE] = ACTIONS(211),
    [anon_sym_INFO] = ACTIONS(211),
    [anon_sym_XXX] = ACTIONS(211),
    [sym_fixme] = ACTIONS(157),
    [aux_sym__text_token1] = ACTIONS(214),
    [sym__newline] = ACTIONS(217),
    [sym__newline_inline] = ACTIONS(220),
    [sym_hard_line_break] = ACTIONS(157),
    [sym__heading_begin] = ACTIONS(223),
    [sym__div_begin] = ACTIONS(226),
    [sym__code_block_begin] = ACTIONS(229),
    [sym_list_marker_dash] = ACTIONS(232),
    [sym_list_marker_star] = ACTIONS(235),
    [sym_list_marker_plus] = ACTIONS(238),
    [sym__list_marker_task_begin] = ACTIONS(241),
    [sym_list_marker_definition] = ACTIONS(244),
    [sym_list_marker_decimal_period] = ACTIONS(247),
    [sym_list_marker_lower_alpha_period] = ACTIONS(250),
    [sym_list_marker_upper_alpha_period] = ACTIONS(253),
    [sym_list_marker_lower_roman_period] = ACTIONS(256),
    [sym_list_marker_upper_roman_period] = ACTIONS(259),
    [sym_list_marker_decimal_paren] = ACTIONS(262),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(265),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(268),
    [sym_list_marker_lower_roman_paren] = ACTIONS(271),
    [sym_list_marker_upper_roman_paren] = ACTIONS(274),
    [sym_list_marker_decimal_parens] = ACTIONS(277),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(280),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(283),
    [sym_list_marker_lower_roman_parens] = ACTIONS(286),
    [sym_list_marker_upper_roman_parens] = ACTIONS(289),
    [sym__block_quote_begin] = ACTIONS(292),
    [sym__block_quote_continuation] = ACTIONS(295),
    [sym__thematic_break_dash] = ACTIONS(298),
    [sym__thematic_break_star] = ACTIONS(298),
    [sym__footnote_mark_begin] = ACTIONS(301),
    [sym__link_ref_def_mark_begin] = ACTIONS(304),
    [sym__table_header_begin] = ACTIONS(307),
    [sym__table_separator_begin] = ACTIONS(310),
    [sym__table_row_begin] = ACTIONS(313),
    [sym__block_attribute_begin] = ACTIONS(316),
    [sym__verbatim_begin] = ACTIONS(319),
  },
  [8] = {
    [sym__block_with_section] = STATE(325),
    [sym__block_element] = STATE(325),
    [sym_section] = STATE(325),
    [sym_heading] = STATE(9),
    [sym_list] = STATE(325),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(325),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(325),
    [sym_div] = STATE(325),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(325),
    [sym_raw_block] = STATE(325),
    [sym_thematic_break] = STATE(325),
    [sym_block_quote] = STATE(325),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(325),
    [sym_block_attribute] = STATE(325),
    [sym__paragraph] = STATE(325),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(8),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(151),
    [sym__whitespace1] = ACTIONS(154),
    [sym_quotation_marks] = ACTIONS(157),
    [sym_ellipsis] = ACTIONS(157),
    [sym_em_dash] = ACTIONS(157),
    [sym_en_dash] = ACTIONS(160),
    [sym_backslash_escape] = ACTIONS(160),
    [anon_sym_LT] = ACTIONS(163),
    [sym_symbol] = ACTIONS(157),
    [anon_sym_LBRACE_] = ACTIONS(166),
    [anon_sym__] = ACTIONS(169),
    [anon_sym_LBRACE_STAR] = ACTIONS(172),
    [anon_sym_STAR] = ACTIONS(175),
    [anon_sym_LBRACE_CARET] = ACTIONS(178),
    [anon_sym_CARET] = ACTIONS(178),
    [anon_sym_LBRACE_TILDE] = ACTIONS(181),
    [anon_sym_TILDE] = ACTIONS(181),
    [anon_sym_LBRACE_EQ] = ACTIONS(184),
    [anon_sym_LBRACE_PLUS] = ACTIONS(187),
    [anon_sym_LBRACE_DASH] = ACTIONS(190),
    [anon_sym_LBRACK_CARET] = ACTIONS(193),
    [anon_sym_BANG_LBRACK] = ACTIONS(196),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(199),
    [anon_sym_LPAREN] = ACTIONS(202),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [anon_sym_TODO] = ACTIONS(208),
    [anon_sym_WIP] = ACTIONS(208),
    [anon_sym_NOTE] = ACTIONS(211),
    [anon_sym_INFO] = ACTIONS(211),
    [anon_sym_XXX] = ACTIONS(211),
    [sym_fixme] = ACTIONS(157),
    [aux_sym__text_token1] = ACTIONS(214),
    [sym__block_close] = ACTIONS(149),
    [sym__newline] = ACTIONS(322),
    [sym__newline_inline] = ACTIONS(220),
    [sym_hard_line_break] = ACTIONS(157),
    [sym__heading_begin] = ACTIONS(223),
    [sym__div_begin] = ACTIONS(226),
    [sym__code_block_begin] = ACTIONS(325),
    [sym_list_marker_dash] = ACTIONS(232),
    [sym_list_marker_star] = ACTIONS(235),
    [sym_list_marker_plus] = ACTIONS(238),
    [sym__list_marker_task_begin] = ACTIONS(241),
    [sym_list_marker_definition] = ACTIONS(244),
    [sym_list_marker_decimal_period] = ACTIONS(247),
    [sym_list_marker_lower_alpha_period] = ACTIONS(250),
    [sym_list_marker_upper_alpha_period] = ACTIONS(253),
    [sym_list_marker_lower_roman_period] = ACTIONS(256),
    [sym_list_marker_upper_roman_period] = ACTIONS(259),
    [sym_list_marker_decimal_paren] = ACTIONS(262),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(265),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(268),
    [sym_list_marker_lower_roman_paren] = ACTIONS(271),
    [sym_list_marker_upper_roman_paren] = ACTIONS(274),
    [sym_list_marker_decimal_parens] = ACTIONS(277),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(280),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(283),
    [sym_list_marker_lower_roman_parens] = ACTIONS(286),
    [sym_list_marker_upper_roman_parens] = ACTIONS(289),
    [sym__block_quote_begin] = ACTIONS(328),
    [sym__block_quote_continuation] = ACTIONS(295),
    [sym__thematic_break_dash] = ACTIONS(331),
    [sym__thematic_break_star] = ACTIONS(331),
    [sym__footnote_mark_begin] = ACTIONS(334),
    [sym__link_ref_def_mark_begin] = ACTIONS(337),
    [sym__table_header_begin] = ACTIONS(340),
    [sym__table_separator_begin] = ACTIONS(343),
    [sym__table_row_begin] = ACTIONS(346),
    [sym__block_attribute_begin] = ACTIONS(349),
    [sym__verbatim_begin] = ACTIONS(319),
  },
  [9] = {
    [sym__block_with_section] = STATE(325),
    [sym__block_element] = STATE(325),
    [sym_section] = STATE(325),
    [sym_heading] = STATE(9),
    [sym_list] = STATE(325),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(325),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(325),
    [sym_div] = STATE(325),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(325),
    [sym_raw_block] = STATE(325),
    [sym_thematic_break] = STATE(325),
    [sym_block_quote] = STATE(325),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(325),
    [sym_block_attribute] = STATE(325),
    [sym__paragraph] = STATE(325),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(10),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(352),
    [sym__newline] = ACTIONS(125),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [10] = {
    [sym__block_with_section] = STATE(325),
    [sym__block_element] = STATE(325),
    [sym_section] = STATE(325),
    [sym_heading] = STATE(9),
    [sym_list] = STATE(325),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(325),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(325),
    [sym_div] = STATE(325),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(325),
    [sym_raw_block] = STATE(325),
    [sym_thematic_break] = STATE(325),
    [sym_block_quote] = STATE(325),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(325),
    [sym_block_attribute] = STATE(325),
    [sym__paragraph] = STATE(325),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym_document_repeat1] = STATE(8),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(354),
    [sym__newline] = ACTIONS(125),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [11] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(89),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(14),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(356),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [12] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(87),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(13),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(362),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [13] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(81),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(14),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(364),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [14] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(14),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(366),
    [sym__whitespace1] = ACTIONS(369),
    [sym_quotation_marks] = ACTIONS(372),
    [sym_ellipsis] = ACTIONS(372),
    [sym_em_dash] = ACTIONS(372),
    [sym_en_dash] = ACTIONS(375),
    [sym_backslash_escape] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(378),
    [sym_symbol] = ACTIONS(372),
    [anon_sym_LBRACE_] = ACTIONS(381),
    [anon_sym__] = ACTIONS(384),
    [anon_sym_LBRACE_STAR] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(390),
    [anon_sym_LBRACE_CARET] = ACTIONS(393),
    [anon_sym_CARET] = ACTIONS(393),
    [anon_sym_LBRACE_TILDE] = ACTIONS(396),
    [anon_sym_TILDE] = ACTIONS(396),
    [anon_sym_LBRACE_EQ] = ACTIONS(399),
    [anon_sym_LBRACE_PLUS] = ACTIONS(402),
    [anon_sym_LBRACE_DASH] = ACTIONS(405),
    [anon_sym_LBRACK_CARET] = ACTIONS(408),
    [anon_sym_BANG_LBRACK] = ACTIONS(411),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [anon_sym_TODO] = ACTIONS(423),
    [anon_sym_WIP] = ACTIONS(423),
    [anon_sym_NOTE] = ACTIONS(426),
    [anon_sym_INFO] = ACTIONS(426),
    [anon_sym_XXX] = ACTIONS(426),
    [sym_fixme] = ACTIONS(372),
    [aux_sym__text_token1] = ACTIONS(429),
    [sym__block_close] = ACTIONS(432),
    [sym__newline] = ACTIONS(434),
    [sym__newline_inline] = ACTIONS(437),
    [sym_hard_line_break] = ACTIONS(372),
    [sym__heading_begin] = ACTIONS(440),
    [sym__div_begin] = ACTIONS(443),
    [sym__code_block_begin] = ACTIONS(446),
    [sym_list_marker_dash] = ACTIONS(449),
    [sym_list_marker_star] = ACTIONS(452),
    [sym_list_marker_plus] = ACTIONS(455),
    [sym__list_marker_task_begin] = ACTIONS(458),
    [sym_list_marker_definition] = ACTIONS(461),
    [sym_list_marker_decimal_period] = ACTIONS(464),
    [sym_list_marker_lower_alpha_period] = ACTIONS(467),
    [sym_list_marker_upper_alpha_period] = ACTIONS(470),
    [sym_list_marker_lower_roman_period] = ACTIONS(473),
    [sym_list_marker_upper_roman_period] = ACTIONS(476),
    [sym_list_marker_decimal_paren] = ACTIONS(479),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(482),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(485),
    [sym_list_marker_lower_roman_paren] = ACTIONS(488),
    [sym_list_marker_upper_roman_paren] = ACTIONS(491),
    [sym_list_marker_decimal_parens] = ACTIONS(494),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(497),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(500),
    [sym_list_marker_lower_roman_parens] = ACTIONS(503),
    [sym_list_marker_upper_roman_parens] = ACTIONS(506),
    [sym__block_quote_begin] = ACTIONS(509),
    [sym__block_quote_continuation] = ACTIONS(512),
    [sym__thematic_break_dash] = ACTIONS(515),
    [sym__thematic_break_star] = ACTIONS(515),
    [sym__footnote_mark_begin] = ACTIONS(518),
    [sym__link_ref_def_mark_begin] = ACTIONS(521),
    [sym__table_header_begin] = ACTIONS(524),
    [sym__table_separator_begin] = ACTIONS(527),
    [sym__table_row_begin] = ACTIONS(530),
    [sym__block_attribute_begin] = ACTIONS(533),
    [sym__verbatim_begin] = ACTIONS(536),
  },
  [15] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(83),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(16),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(539),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [16] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(85),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(14),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(541),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [17] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(84),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(18),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(543),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [18] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(82),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(14),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(545),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [19] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(90),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(20),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(547),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [20] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(86),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(14),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(549),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [21] = {
    [sym__block_with_heading] = STATE(359),
    [sym__block_element] = STATE(359),
    [sym_heading] = STATE(359),
    [sym_list] = STATE(359),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(359),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(359),
    [sym_div] = STATE(359),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(359),
    [sym_raw_block] = STATE(359),
    [sym_thematic_break] = STATE(359),
    [sym_block_quote] = STATE(359),
    [sym__block_quote_prefix] = STATE(88),
    [sym_link_reference_definition] = STATE(359),
    [sym_block_attribute] = STATE(359),
    [sym__paragraph] = STATE(359),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym_div_repeat1] = STATE(11),
    [aux_sym__block_quote_prefix_repeat1] = STATE(432),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__block_close] = ACTIONS(551),
    [sym__newline] = ACTIONS(358),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(360),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(137),
    [sym__table_separator_begin] = ACTIONS(139),
    [sym__table_row_begin] = ACTIONS(141),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [22] = {
    [sym__block_with_heading] = STATE(2434),
    [sym__block_element] = STATE(2434),
    [sym_heading] = STATE(2434),
    [sym_list] = STATE(2434),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1599),
    [sym_table] = STATE(2434),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2434),
    [sym_div] = STATE(2434),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2434),
    [sym_raw_block] = STATE(2434),
    [sym_thematic_break] = STATE(2434),
    [sym_block_quote] = STATE(2434),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2434),
    [sym_block_attribute] = STATE(2434),
    [sym__paragraph] = STATE(2434),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(553),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [23] = {
    [sym__block_with_heading] = STATE(2265),
    [sym__block_element] = STATE(2265),
    [sym_heading] = STATE(2265),
    [sym_list] = STATE(2265),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1454),
    [sym_table] = STATE(2265),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2265),
    [sym_div] = STATE(2265),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2265),
    [sym_raw_block] = STATE(2265),
    [sym_thematic_break] = STATE(2265),
    [sym_block_quote] = STATE(2265),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2265),
    [sym_block_attribute] = STATE(2265),
    [sym__paragraph] = STATE(2265),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(577),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [24] = {
    [sym__block_with_heading] = STATE(2199),
    [sym__block_element] = STATE(2199),
    [sym_heading] = STATE(2199),
    [sym_list] = STATE(2199),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1501),
    [sym_table] = STATE(2199),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2199),
    [sym_div] = STATE(2199),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2199),
    [sym_raw_block] = STATE(2199),
    [sym_thematic_break] = STATE(2199),
    [sym_block_quote] = STATE(2199),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2199),
    [sym_block_attribute] = STATE(2199),
    [sym__paragraph] = STATE(2199),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(579),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [25] = {
    [sym__block_with_heading] = STATE(2231),
    [sym__block_element] = STATE(2231),
    [sym_heading] = STATE(2231),
    [sym_list] = STATE(2231),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1514),
    [sym_table] = STATE(2231),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2231),
    [sym_div] = STATE(2231),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2231),
    [sym_raw_block] = STATE(2231),
    [sym_thematic_break] = STATE(2231),
    [sym_block_quote] = STATE(2231),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2231),
    [sym_block_attribute] = STATE(2231),
    [sym__paragraph] = STATE(2231),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(581),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [26] = {
    [sym__block_with_heading] = STATE(2261),
    [sym__block_element] = STATE(2261),
    [sym_heading] = STATE(2261),
    [sym_list] = STATE(2261),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1518),
    [sym_table] = STATE(2261),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2261),
    [sym_div] = STATE(2261),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2261),
    [sym_raw_block] = STATE(2261),
    [sym_thematic_break] = STATE(2261),
    [sym_block_quote] = STATE(2261),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2261),
    [sym_block_attribute] = STATE(2261),
    [sym__paragraph] = STATE(2261),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(583),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [27] = {
    [sym__block_with_heading] = STATE(2290),
    [sym__block_element] = STATE(2290),
    [sym_heading] = STATE(2290),
    [sym_list] = STATE(2290),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1536),
    [sym_table] = STATE(2290),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2290),
    [sym_div] = STATE(2290),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2290),
    [sym_raw_block] = STATE(2290),
    [sym_thematic_break] = STATE(2290),
    [sym_block_quote] = STATE(2290),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2290),
    [sym_block_attribute] = STATE(2290),
    [sym__paragraph] = STATE(2290),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(585),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [28] = {
    [sym__block_with_heading] = STATE(2315),
    [sym__block_element] = STATE(2315),
    [sym_heading] = STATE(2315),
    [sym_list] = STATE(2315),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1564),
    [sym_table] = STATE(2315),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2315),
    [sym_div] = STATE(2315),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2315),
    [sym_raw_block] = STATE(2315),
    [sym_thematic_break] = STATE(2315),
    [sym_block_quote] = STATE(2315),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2315),
    [sym_block_attribute] = STATE(2315),
    [sym__paragraph] = STATE(2315),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(587),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [29] = {
    [sym__block_with_heading] = STATE(2332),
    [sym__block_element] = STATE(2332),
    [sym_heading] = STATE(2332),
    [sym_list] = STATE(2332),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1565),
    [sym_table] = STATE(2332),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2332),
    [sym_div] = STATE(2332),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2332),
    [sym_raw_block] = STATE(2332),
    [sym_thematic_break] = STATE(2332),
    [sym_block_quote] = STATE(2332),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2332),
    [sym_block_attribute] = STATE(2332),
    [sym__paragraph] = STATE(2332),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(589),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [30] = {
    [sym__block_with_heading] = STATE(2349),
    [sym__block_element] = STATE(2349),
    [sym_heading] = STATE(2349),
    [sym_list] = STATE(2349),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1566),
    [sym_table] = STATE(2349),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2349),
    [sym_div] = STATE(2349),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2349),
    [sym_raw_block] = STATE(2349),
    [sym_thematic_break] = STATE(2349),
    [sym_block_quote] = STATE(2349),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2349),
    [sym_block_attribute] = STATE(2349),
    [sym__paragraph] = STATE(2349),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(591),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [31] = {
    [sym__block_with_heading] = STATE(2366),
    [sym__block_element] = STATE(2366),
    [sym_heading] = STATE(2366),
    [sym_list] = STATE(2366),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1567),
    [sym_table] = STATE(2366),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2366),
    [sym_div] = STATE(2366),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2366),
    [sym_raw_block] = STATE(2366),
    [sym_thematic_break] = STATE(2366),
    [sym_block_quote] = STATE(2366),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2366),
    [sym_block_attribute] = STATE(2366),
    [sym__paragraph] = STATE(2366),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(593),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [32] = {
    [sym__block_with_heading] = STATE(2383),
    [sym__block_element] = STATE(2383),
    [sym_heading] = STATE(2383),
    [sym_list] = STATE(2383),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1569),
    [sym_table] = STATE(2383),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2383),
    [sym_div] = STATE(2383),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2383),
    [sym_raw_block] = STATE(2383),
    [sym_thematic_break] = STATE(2383),
    [sym_block_quote] = STATE(2383),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2383),
    [sym_block_attribute] = STATE(2383),
    [sym__paragraph] = STATE(2383),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(595),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [33] = {
    [sym__block_with_heading] = STATE(2400),
    [sym__block_element] = STATE(2400),
    [sym_heading] = STATE(2400),
    [sym_list] = STATE(2400),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1571),
    [sym_table] = STATE(2400),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2400),
    [sym_div] = STATE(2400),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2400),
    [sym_raw_block] = STATE(2400),
    [sym_thematic_break] = STATE(2400),
    [sym_block_quote] = STATE(2400),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2400),
    [sym_block_attribute] = STATE(2400),
    [sym__paragraph] = STATE(2400),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(597),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [34] = {
    [sym__block_with_heading] = STATE(2417),
    [sym__block_element] = STATE(2417),
    [sym_heading] = STATE(2417),
    [sym_list] = STATE(2417),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1589),
    [sym_table] = STATE(2417),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2417),
    [sym_div] = STATE(2417),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2417),
    [sym_raw_block] = STATE(2417),
    [sym_thematic_break] = STATE(2417),
    [sym_block_quote] = STATE(2417),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2417),
    [sym_block_attribute] = STATE(2417),
    [sym__paragraph] = STATE(2417),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(599),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [35] = {
    [sym__block_with_heading] = STATE(2199),
    [sym__block_element] = STATE(2199),
    [sym_heading] = STATE(2199),
    [sym_list] = STATE(2199),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1535),
    [sym_table] = STATE(2199),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2199),
    [sym_div] = STATE(2199),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2199),
    [sym_raw_block] = STATE(2199),
    [sym_thematic_break] = STATE(2199),
    [sym_block_quote] = STATE(2199),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2199),
    [sym_block_attribute] = STATE(2199),
    [sym__paragraph] = STATE(2199),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(579),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [36] = {
    [sym__block_with_heading] = STATE(2449),
    [sym__block_element] = STATE(2449),
    [sym_heading] = STATE(2449),
    [sym_list] = STATE(2449),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1600),
    [sym_table] = STATE(2449),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2449),
    [sym_div] = STATE(2449),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2449),
    [sym_raw_block] = STATE(2449),
    [sym_thematic_break] = STATE(2449),
    [sym_block_quote] = STATE(2449),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2449),
    [sym_block_attribute] = STATE(2449),
    [sym__paragraph] = STATE(2449),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(601),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [37] = {
    [sym__block_with_heading] = STATE(2450),
    [sym__block_element] = STATE(2450),
    [sym_heading] = STATE(2450),
    [sym_list] = STATE(2450),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1601),
    [sym_table] = STATE(2450),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2450),
    [sym_div] = STATE(2450),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2450),
    [sym_raw_block] = STATE(2450),
    [sym_thematic_break] = STATE(2450),
    [sym_block_quote] = STATE(2450),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2450),
    [sym_block_attribute] = STATE(2450),
    [sym__paragraph] = STATE(2450),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(603),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [38] = {
    [sym__block_with_heading] = STATE(2451),
    [sym__block_element] = STATE(2451),
    [sym_heading] = STATE(2451),
    [sym_list] = STATE(2451),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1604),
    [sym_table] = STATE(2451),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2451),
    [sym_div] = STATE(2451),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2451),
    [sym_raw_block] = STATE(2451),
    [sym_thematic_break] = STATE(2451),
    [sym_block_quote] = STATE(2451),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2451),
    [sym_block_attribute] = STATE(2451),
    [sym__paragraph] = STATE(2451),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(605),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [39] = {
    [sym__block_with_heading] = STATE(2452),
    [sym__block_element] = STATE(2452),
    [sym_heading] = STATE(2452),
    [sym_list] = STATE(2452),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1605),
    [sym_table] = STATE(2452),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2452),
    [sym_div] = STATE(2452),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2452),
    [sym_raw_block] = STATE(2452),
    [sym_thematic_break] = STATE(2452),
    [sym_block_quote] = STATE(2452),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2452),
    [sym_block_attribute] = STATE(2452),
    [sym__paragraph] = STATE(2452),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(607),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [40] = {
    [sym__block_with_heading] = STATE(2453),
    [sym__block_element] = STATE(2453),
    [sym_heading] = STATE(2453),
    [sym_list] = STATE(2453),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1607),
    [sym_table] = STATE(2453),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2453),
    [sym_div] = STATE(2453),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2453),
    [sym_raw_block] = STATE(2453),
    [sym_thematic_break] = STATE(2453),
    [sym_block_quote] = STATE(2453),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2453),
    [sym_block_attribute] = STATE(2453),
    [sym__paragraph] = STATE(2453),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(609),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [41] = {
    [sym__block_with_heading] = STATE(2454),
    [sym__block_element] = STATE(2454),
    [sym_heading] = STATE(2454),
    [sym_list] = STATE(2454),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1612),
    [sym_table] = STATE(2454),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2454),
    [sym_div] = STATE(2454),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2454),
    [sym_raw_block] = STATE(2454),
    [sym_thematic_break] = STATE(2454),
    [sym_block_quote] = STATE(2454),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2454),
    [sym_block_attribute] = STATE(2454),
    [sym__paragraph] = STATE(2454),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(611),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [42] = {
    [sym__block_with_heading] = STATE(2231),
    [sym__block_element] = STATE(2231),
    [sym_heading] = STATE(2231),
    [sym_list] = STATE(2231),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1539),
    [sym_table] = STATE(2231),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2231),
    [sym_div] = STATE(2231),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2231),
    [sym_raw_block] = STATE(2231),
    [sym_thematic_break] = STATE(2231),
    [sym_block_quote] = STATE(2231),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2231),
    [sym_block_attribute] = STATE(2231),
    [sym__paragraph] = STATE(2231),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(581),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [43] = {
    [sym__block_with_heading] = STATE(2400),
    [sym__block_element] = STATE(2400),
    [sym_heading] = STATE(2400),
    [sym_list] = STATE(2400),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1641),
    [sym_table] = STATE(2400),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2400),
    [sym_div] = STATE(2400),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2400),
    [sym_raw_block] = STATE(2400),
    [sym_thematic_break] = STATE(2400),
    [sym_block_quote] = STATE(2400),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2400),
    [sym_block_attribute] = STATE(2400),
    [sym__paragraph] = STATE(2400),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(597),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [44] = {
    [sym__block_with_heading] = STATE(2265),
    [sym__block_element] = STATE(2265),
    [sym_heading] = STATE(2265),
    [sym_list] = STATE(2265),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1494),
    [sym_table] = STATE(2265),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2265),
    [sym_div] = STATE(2265),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2265),
    [sym_raw_block] = STATE(2265),
    [sym_thematic_break] = STATE(2265),
    [sym_block_quote] = STATE(2265),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2265),
    [sym_block_attribute] = STATE(2265),
    [sym__paragraph] = STATE(2265),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(577),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [45] = {
    [sym__block_with_heading] = STATE(2417),
    [sym__block_element] = STATE(2417),
    [sym_heading] = STATE(2417),
    [sym_list] = STATE(2417),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1411),
    [sym_table] = STATE(2417),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2417),
    [sym_div] = STATE(2417),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2417),
    [sym_raw_block] = STATE(2417),
    [sym_thematic_break] = STATE(2417),
    [sym_block_quote] = STATE(2417),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2417),
    [sym_block_attribute] = STATE(2417),
    [sym__paragraph] = STATE(2417),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(599),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [46] = {
    [sym__block_with_heading] = STATE(2149),
    [sym__block_element] = STATE(2149),
    [sym_heading] = STATE(2149),
    [sym_list] = STATE(2149),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2149),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2149),
    [sym_footnote_content] = STATE(367),
    [sym_div] = STATE(2149),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2149),
    [sym_raw_block] = STATE(2149),
    [sym_thematic_break] = STATE(2149),
    [sym_block_quote] = STATE(2149),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2149),
    [sym_block_attribute] = STATE(2149),
    [sym__paragraph] = STATE(2149),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(613),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [47] = {
    [sym__block_with_heading] = STATE(2434),
    [sym__block_element] = STATE(2434),
    [sym_heading] = STATE(2434),
    [sym_list] = STATE(2434),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1543),
    [sym_table] = STATE(2434),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2434),
    [sym_div] = STATE(2434),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2434),
    [sym_raw_block] = STATE(2434),
    [sym_thematic_break] = STATE(2434),
    [sym_block_quote] = STATE(2434),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2434),
    [sym_block_attribute] = STATE(2434),
    [sym__paragraph] = STATE(2434),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(553),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [48] = {
    [sym__block_with_heading] = STATE(2449),
    [sym__block_element] = STATE(2449),
    [sym_heading] = STATE(2449),
    [sym_list] = STATE(2449),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1516),
    [sym_table] = STATE(2449),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2449),
    [sym_div] = STATE(2449),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2449),
    [sym_raw_block] = STATE(2449),
    [sym_thematic_break] = STATE(2449),
    [sym_block_quote] = STATE(2449),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2449),
    [sym_block_attribute] = STATE(2449),
    [sym__paragraph] = STATE(2449),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(601),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [49] = {
    [sym__block_with_heading] = STATE(2450),
    [sym__block_element] = STATE(2450),
    [sym_heading] = STATE(2450),
    [sym_list] = STATE(2450),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1507),
    [sym_table] = STATE(2450),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2450),
    [sym_div] = STATE(2450),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2450),
    [sym_raw_block] = STATE(2450),
    [sym_thematic_break] = STATE(2450),
    [sym_block_quote] = STATE(2450),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2450),
    [sym_block_attribute] = STATE(2450),
    [sym__paragraph] = STATE(2450),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(603),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [50] = {
    [sym__block_with_heading] = STATE(2451),
    [sym__block_element] = STATE(2451),
    [sym_heading] = STATE(2451),
    [sym_list] = STATE(2451),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1633),
    [sym_table] = STATE(2451),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2451),
    [sym_div] = STATE(2451),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2451),
    [sym_raw_block] = STATE(2451),
    [sym_thematic_break] = STATE(2451),
    [sym_block_quote] = STATE(2451),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2451),
    [sym_block_attribute] = STATE(2451),
    [sym__paragraph] = STATE(2451),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(605),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [51] = {
    [sym__block_with_heading] = STATE(2452),
    [sym__block_element] = STATE(2452),
    [sym_heading] = STATE(2452),
    [sym_list] = STATE(2452),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1636),
    [sym_table] = STATE(2452),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2452),
    [sym_div] = STATE(2452),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2452),
    [sym_raw_block] = STATE(2452),
    [sym_thematic_break] = STATE(2452),
    [sym_block_quote] = STATE(2452),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2452),
    [sym_block_attribute] = STATE(2452),
    [sym__paragraph] = STATE(2452),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(607),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [52] = {
    [sym__block_with_heading] = STATE(2453),
    [sym__block_element] = STATE(2453),
    [sym_heading] = STATE(2453),
    [sym_list] = STATE(2453),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1541),
    [sym_table] = STATE(2453),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2453),
    [sym_div] = STATE(2453),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2453),
    [sym_raw_block] = STATE(2453),
    [sym_thematic_break] = STATE(2453),
    [sym_block_quote] = STATE(2453),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2453),
    [sym_block_attribute] = STATE(2453),
    [sym__paragraph] = STATE(2453),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(609),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [53] = {
    [sym__block_with_heading] = STATE(2222),
    [sym__block_element] = STATE(2222),
    [sym_heading] = STATE(2222),
    [sym_list] = STATE(2222),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2222),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2222),
    [sym_footnote_content] = STATE(2191),
    [sym_div] = STATE(2222),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2222),
    [sym_raw_block] = STATE(2222),
    [sym_thematic_break] = STATE(2222),
    [sym_block_quote] = STATE(2222),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2222),
    [sym_block_attribute] = STATE(2222),
    [sym__paragraph] = STATE(2222),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(615),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [54] = {
    [sym__block_with_heading] = STATE(2261),
    [sym__block_element] = STATE(2261),
    [sym_heading] = STATE(2261),
    [sym_list] = STATE(2261),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1562),
    [sym_table] = STATE(2261),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2261),
    [sym_div] = STATE(2261),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2261),
    [sym_raw_block] = STATE(2261),
    [sym_thematic_break] = STATE(2261),
    [sym_block_quote] = STATE(2261),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2261),
    [sym_block_attribute] = STATE(2261),
    [sym__paragraph] = STATE(2261),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(583),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [55] = {
    [sym__block_with_heading] = STATE(2290),
    [sym__block_element] = STATE(2290),
    [sym_heading] = STATE(2290),
    [sym_list] = STATE(2290),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1576),
    [sym_table] = STATE(2290),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2290),
    [sym_div] = STATE(2290),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2290),
    [sym_raw_block] = STATE(2290),
    [sym_thematic_break] = STATE(2290),
    [sym_block_quote] = STATE(2290),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2290),
    [sym_block_attribute] = STATE(2290),
    [sym__paragraph] = STATE(2290),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(585),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [56] = {
    [sym__block_with_heading] = STATE(2454),
    [sym__block_element] = STATE(2454),
    [sym_heading] = STATE(2454),
    [sym_list] = STATE(2454),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1489),
    [sym_table] = STATE(2454),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2454),
    [sym_div] = STATE(2454),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2454),
    [sym_raw_block] = STATE(2454),
    [sym_thematic_break] = STATE(2454),
    [sym_block_quote] = STATE(2454),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2454),
    [sym_block_attribute] = STATE(2454),
    [sym__paragraph] = STATE(2454),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(611),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [57] = {
    [sym__block_with_heading] = STATE(2252),
    [sym__block_element] = STATE(2252),
    [sym_heading] = STATE(2252),
    [sym_list] = STATE(2252),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2252),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2252),
    [sym_footnote_content] = STATE(1681),
    [sym_div] = STATE(2252),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2252),
    [sym_raw_block] = STATE(2252),
    [sym_thematic_break] = STATE(2252),
    [sym_block_quote] = STATE(2252),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2252),
    [sym_block_attribute] = STATE(2252),
    [sym__paragraph] = STATE(2252),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(617),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [58] = {
    [sym__block_with_heading] = STATE(2315),
    [sym__block_element] = STATE(2315),
    [sym_heading] = STATE(2315),
    [sym_list] = STATE(2315),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1620),
    [sym_table] = STATE(2315),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2315),
    [sym_div] = STATE(2315),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2315),
    [sym_raw_block] = STATE(2315),
    [sym_thematic_break] = STATE(2315),
    [sym_block_quote] = STATE(2315),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2315),
    [sym_block_attribute] = STATE(2315),
    [sym__paragraph] = STATE(2315),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(587),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [59] = {
    [sym__block_with_heading] = STATE(2332),
    [sym__block_element] = STATE(2332),
    [sym_heading] = STATE(2332),
    [sym_list] = STATE(2332),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1623),
    [sym_table] = STATE(2332),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2332),
    [sym_div] = STATE(2332),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2332),
    [sym_raw_block] = STATE(2332),
    [sym_thematic_break] = STATE(2332),
    [sym_block_quote] = STATE(2332),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2332),
    [sym_block_attribute] = STATE(2332),
    [sym__paragraph] = STATE(2332),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(589),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [60] = {
    [sym__block_with_heading] = STATE(2282),
    [sym__block_element] = STATE(2282),
    [sym_heading] = STATE(2282),
    [sym_list] = STATE(2282),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2282),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2282),
    [sym_footnote_content] = STATE(414),
    [sym_div] = STATE(2282),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2282),
    [sym_raw_block] = STATE(2282),
    [sym_thematic_break] = STATE(2282),
    [sym_block_quote] = STATE(2282),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2282),
    [sym_block_attribute] = STATE(2282),
    [sym__paragraph] = STATE(2282),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(619),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [61] = {
    [sym__block_with_heading] = STATE(2349),
    [sym__block_element] = STATE(2349),
    [sym_heading] = STATE(2349),
    [sym_list] = STATE(2349),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1626),
    [sym_table] = STATE(2349),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2349),
    [sym_div] = STATE(2349),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2349),
    [sym_raw_block] = STATE(2349),
    [sym_thematic_break] = STATE(2349),
    [sym_block_quote] = STATE(2349),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2349),
    [sym_block_attribute] = STATE(2349),
    [sym__paragraph] = STATE(2349),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(591),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [62] = {
    [sym__block_with_heading] = STATE(2366),
    [sym__block_element] = STATE(2366),
    [sym_heading] = STATE(2366),
    [sym_list] = STATE(2366),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1632),
    [sym_table] = STATE(2366),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2366),
    [sym_div] = STATE(2366),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2366),
    [sym_raw_block] = STATE(2366),
    [sym_thematic_break] = STATE(2366),
    [sym_block_quote] = STATE(2366),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2366),
    [sym_block_attribute] = STATE(2366),
    [sym__paragraph] = STATE(2366),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(593),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [63] = {
    [sym__block_with_heading] = STATE(2311),
    [sym__block_element] = STATE(2311),
    [sym_heading] = STATE(2311),
    [sym_list] = STATE(2311),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2311),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2311),
    [sym_footnote_content] = STATE(1452),
    [sym_div] = STATE(2311),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2311),
    [sym_raw_block] = STATE(2311),
    [sym_thematic_break] = STATE(2311),
    [sym_block_quote] = STATE(2311),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2311),
    [sym_block_attribute] = STATE(2311),
    [sym__paragraph] = STATE(2311),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(621),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [64] = {
    [sym__block_with_heading] = STATE(2383),
    [sym__block_element] = STATE(2383),
    [sym_heading] = STATE(2383),
    [sym_list] = STATE(2383),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_list_item_content] = STATE(1634),
    [sym_table] = STATE(2383),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2383),
    [sym_div] = STATE(2383),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2383),
    [sym_raw_block] = STATE(2383),
    [sym_thematic_break] = STATE(2383),
    [sym_block_quote] = STATE(2383),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2383),
    [sym_block_attribute] = STATE(2383),
    [sym__paragraph] = STATE(2383),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(595),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [65] = {
    [sym__block_with_heading] = STATE(1534),
    [sym__block_element] = STATE(1534),
    [sym_heading] = STATE(1534),
    [sym_list] = STATE(1534),
    [sym__list_dash] = STATE(1430),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1430),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1430),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1430),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1430),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1430),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1430),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1430),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1430),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1430),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1430),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1430),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1430),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1430),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1430),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1430),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1430),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1430),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1430),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1430),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1534),
    [sym__table_row] = STATE(1030),
    [sym_table_header] = STATE(1030),
    [sym_table_separator] = STATE(1030),
    [sym_table_row] = STATE(1030),
    [sym_footnote] = STATE(1534),
    [sym_div] = STATE(1534),
    [sym__div_marker_begin] = STATE(2287),
    [sym_code_block] = STATE(1534),
    [sym_raw_block] = STATE(1534),
    [sym_thematic_break] = STATE(1534),
    [sym_block_quote] = STATE(1534),
    [sym__block_quote_prefix] = STATE(95),
    [sym_link_reference_definition] = STATE(1534),
    [sym_block_attribute] = STATE(1534),
    [sym__paragraph] = STATE(1534),
    [sym__paragraph_content] = STATE(1715),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1166),
    [aux_sym__list_plus_repeat1] = STATE(1167),
    [aux_sym__list_star_repeat1] = STATE(1168),
    [aux_sym__list_task_repeat1] = STATE(1091),
    [aux_sym__list_definition_repeat1] = STATE(1373),
    [aux_sym__list_decimal_period_repeat1] = STATE(1170),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1171),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1172),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1173),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1174),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1175),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1102),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1177),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1243),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1179),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1180),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1181),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1182),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1183),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1184),
    [aux_sym_table_repeat1] = STATE(1030),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(623),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(625),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(627),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(629),
    [sym__block_quote_continuation] = ACTIONS(631),
    [sym__thematic_break_dash] = ACTIONS(633),
    [sym__thematic_break_star] = ACTIONS(633),
    [sym__footnote_mark_begin] = ACTIONS(635),
    [sym__link_ref_def_mark_begin] = ACTIONS(637),
    [sym__table_header_begin] = ACTIONS(639),
    [sym__table_separator_begin] = ACTIONS(641),
    [sym__table_row_begin] = ACTIONS(643),
    [sym__block_attribute_begin] = ACTIONS(645),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [66] = {
    [sym__block_with_heading] = STATE(2305),
    [sym__block_element] = STATE(2305),
    [sym_heading] = STATE(2305),
    [sym_list] = STATE(2305),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2305),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2305),
    [sym_div] = STATE(2305),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2305),
    [sym_raw_block] = STATE(2305),
    [sym_thematic_break] = STATE(2305),
    [sym_block_quote] = STATE(2305),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2305),
    [sym_block_attribute] = STATE(2305),
    [sym__paragraph] = STATE(2305),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(647),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [67] = {
    [sym__block_with_heading] = STATE(1484),
    [sym__block_element] = STATE(1484),
    [sym_heading] = STATE(1484),
    [sym_list] = STATE(1484),
    [sym__list_dash] = STATE(1430),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1430),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1430),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1430),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1430),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1430),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1430),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1430),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1430),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1430),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1430),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1430),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1430),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1430),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1430),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1430),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1430),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1430),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1430),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1430),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1484),
    [sym__table_row] = STATE(1030),
    [sym_table_header] = STATE(1030),
    [sym_table_separator] = STATE(1030),
    [sym_table_row] = STATE(1030),
    [sym_footnote] = STATE(1484),
    [sym_div] = STATE(1484),
    [sym__div_marker_begin] = STATE(2287),
    [sym_code_block] = STATE(1484),
    [sym_raw_block] = STATE(1484),
    [sym_thematic_break] = STATE(1484),
    [sym_block_quote] = STATE(1484),
    [sym__block_quote_prefix] = STATE(95),
    [sym_link_reference_definition] = STATE(1484),
    [sym_block_attribute] = STATE(1484),
    [sym__paragraph] = STATE(1484),
    [sym__paragraph_content] = STATE(1715),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1166),
    [aux_sym__list_plus_repeat1] = STATE(1167),
    [aux_sym__list_star_repeat1] = STATE(1168),
    [aux_sym__list_task_repeat1] = STATE(1091),
    [aux_sym__list_definition_repeat1] = STATE(1373),
    [aux_sym__list_decimal_period_repeat1] = STATE(1170),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1171),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1172),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1173),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1174),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1175),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1102),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1177),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1243),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1179),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1180),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1181),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1182),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1183),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1184),
    [aux_sym_table_repeat1] = STATE(1030),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(649),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(625),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(627),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(629),
    [sym__block_quote_continuation] = ACTIONS(631),
    [sym__thematic_break_dash] = ACTIONS(633),
    [sym__thematic_break_star] = ACTIONS(633),
    [sym__footnote_mark_begin] = ACTIONS(635),
    [sym__link_ref_def_mark_begin] = ACTIONS(637),
    [sym__table_header_begin] = ACTIONS(639),
    [sym__table_separator_begin] = ACTIONS(641),
    [sym__table_row_begin] = ACTIONS(643),
    [sym__block_attribute_begin] = ACTIONS(645),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [68] = {
    [sym__block_with_heading] = STATE(2083),
    [sym__block_element] = STATE(2083),
    [sym_heading] = STATE(2083),
    [sym_list] = STATE(2083),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2083),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2083),
    [sym_div] = STATE(2083),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2083),
    [sym_raw_block] = STATE(2083),
    [sym_thematic_break] = STATE(2083),
    [sym_block_quote] = STATE(2083),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2083),
    [sym_block_attribute] = STATE(2083),
    [sym__paragraph] = STATE(2083),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(651),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [69] = {
    [sym__block_with_heading] = STATE(2611),
    [sym__block_element] = STATE(2611),
    [sym_heading] = STATE(2611),
    [sym_list] = STATE(2611),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2611),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2611),
    [sym_div] = STATE(2611),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2611),
    [sym_raw_block] = STATE(2611),
    [sym_thematic_break] = STATE(2611),
    [sym_block_quote] = STATE(2611),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2611),
    [sym_block_attribute] = STATE(2611),
    [sym__paragraph] = STATE(2611),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(653),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [70] = {
    [sym__block_element] = STATE(331),
    [sym_heading] = STATE(331),
    [sym_list] = STATE(331),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(331),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(331),
    [sym_div] = STATE(331),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(331),
    [sym_raw_block] = STATE(331),
    [sym_thematic_break] = STATE(331),
    [sym_block_quote] = STATE(331),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(331),
    [sym_block_attribute] = STATE(331),
    [sym__paragraph] = STATE(331),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(655),
    [sym__whitespace1] = ACTIONS(657),
    [sym_quotation_marks] = ACTIONS(657),
    [sym_ellipsis] = ACTIONS(657),
    [sym_em_dash] = ACTIONS(657),
    [sym_en_dash] = ACTIONS(655),
    [sym_backslash_escape] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(657),
    [sym_symbol] = ACTIONS(657),
    [anon_sym_LBRACE_] = ACTIONS(657),
    [anon_sym__] = ACTIONS(657),
    [anon_sym_LBRACE_STAR] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_LBRACE_CARET] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LBRACE_TILDE] = ACTIONS(657),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_LBRACE_EQ] = ACTIONS(657),
    [anon_sym_LBRACE_PLUS] = ACTIONS(657),
    [anon_sym_LBRACE_DASH] = ACTIONS(657),
    [anon_sym_LBRACK_CARET] = ACTIONS(657),
    [anon_sym_BANG_LBRACK] = ACTIONS(657),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(657),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_TODO] = ACTIONS(657),
    [anon_sym_WIP] = ACTIONS(657),
    [anon_sym_NOTE] = ACTIONS(657),
    [anon_sym_INFO] = ACTIONS(657),
    [anon_sym_XXX] = ACTIONS(657),
    [sym_fixme] = ACTIONS(657),
    [aux_sym__text_token1] = ACTIONS(655),
    [sym__block_close] = ACTIONS(657),
    [sym__newline] = ACTIONS(659),
    [sym__newline_inline] = ACTIONS(657),
    [sym_hard_line_break] = ACTIONS(657),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(657),
    [sym_list_marker_star] = ACTIONS(657),
    [sym_list_marker_plus] = ACTIONS(657),
    [sym__list_marker_task_begin] = ACTIONS(657),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(657),
    [sym_list_marker_lower_alpha_period] = ACTIONS(657),
    [sym_list_marker_upper_alpha_period] = ACTIONS(657),
    [sym_list_marker_lower_roman_period] = ACTIONS(657),
    [sym_list_marker_upper_roman_period] = ACTIONS(657),
    [sym_list_marker_decimal_paren] = ACTIONS(657),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(657),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(657),
    [sym_list_marker_lower_roman_paren] = ACTIONS(657),
    [sym_list_marker_upper_roman_paren] = ACTIONS(657),
    [sym_list_marker_decimal_parens] = ACTIONS(657),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(657),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(657),
    [sym_list_marker_lower_roman_parens] = ACTIONS(657),
    [sym_list_marker_upper_roman_parens] = ACTIONS(657),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(657),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(657),
    [sym__table_separator_begin] = ACTIONS(657),
    [sym__table_row_begin] = ACTIONS(657),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(657),
  },
  [71] = {
    [sym__block_with_heading] = STATE(2277),
    [sym__block_element] = STATE(2277),
    [sym_heading] = STATE(2277),
    [sym_list] = STATE(2277),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2277),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2277),
    [sym_div] = STATE(2277),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2277),
    [sym_raw_block] = STATE(2277),
    [sym_thematic_break] = STATE(2277),
    [sym_block_quote] = STATE(2277),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2277),
    [sym_block_attribute] = STATE(2277),
    [sym__paragraph] = STATE(2277),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline] = ACTIONS(661),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(561),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(569),
    [sym__table_separator_begin] = ACTIONS(571),
    [sym__table_row_begin] = ACTIONS(573),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [72] = {
    [sym__block_element] = STATE(331),
    [sym_heading] = STATE(331),
    [sym_list] = STATE(331),
    [sym__list_dash] = STATE(360),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(360),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(360),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(360),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(360),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(360),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(360),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(360),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(360),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(360),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(360),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(360),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(360),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(360),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(360),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(360),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(360),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(360),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(360),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(360),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(331),
    [sym__table_row] = STATE(136),
    [sym_table_header] = STATE(136),
    [sym_table_separator] = STATE(136),
    [sym_table_row] = STATE(136),
    [sym_footnote] = STATE(331),
    [sym_div] = STATE(331),
    [sym__div_marker_begin] = STATE(2258),
    [sym_code_block] = STATE(331),
    [sym_raw_block] = STATE(331),
    [sym_thematic_break] = STATE(331),
    [sym_block_quote] = STATE(331),
    [sym__block_quote_prefix] = STATE(93),
    [sym_link_reference_definition] = STATE(331),
    [sym_block_attribute] = STATE(331),
    [sym__paragraph] = STATE(331),
    [sym__paragraph_content] = STATE(1677),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1140),
    [aux_sym__list_plus_repeat1] = STATE(1141),
    [aux_sym__list_star_repeat1] = STATE(1142),
    [aux_sym__list_task_repeat1] = STATE(1084),
    [aux_sym__list_definition_repeat1] = STATE(1403),
    [aux_sym__list_decimal_period_repeat1] = STATE(1144),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1145),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1146),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1147),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1148),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1149),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1150),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1151),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1152),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1153),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1154),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1155),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1156),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1157),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1158),
    [aux_sym_table_repeat1] = STATE(136),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(655),
    [sym__whitespace1] = ACTIONS(657),
    [sym_quotation_marks] = ACTIONS(657),
    [sym_ellipsis] = ACTIONS(657),
    [sym_em_dash] = ACTIONS(657),
    [sym_en_dash] = ACTIONS(655),
    [sym_backslash_escape] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(657),
    [sym_symbol] = ACTIONS(657),
    [anon_sym_LBRACE_] = ACTIONS(657),
    [anon_sym__] = ACTIONS(657),
    [anon_sym_LBRACE_STAR] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_LBRACE_CARET] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LBRACE_TILDE] = ACTIONS(657),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_LBRACE_EQ] = ACTIONS(657),
    [anon_sym_LBRACE_PLUS] = ACTIONS(657),
    [anon_sym_LBRACE_DASH] = ACTIONS(657),
    [anon_sym_LBRACK_CARET] = ACTIONS(657),
    [anon_sym_BANG_LBRACK] = ACTIONS(657),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(657),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_TODO] = ACTIONS(657),
    [anon_sym_WIP] = ACTIONS(657),
    [anon_sym_NOTE] = ACTIONS(657),
    [anon_sym_INFO] = ACTIONS(657),
    [anon_sym_XXX] = ACTIONS(657),
    [sym_fixme] = ACTIONS(657),
    [aux_sym__text_token1] = ACTIONS(655),
    [sym__newline] = ACTIONS(659),
    [sym__newline_inline] = ACTIONS(657),
    [sym_hard_line_break] = ACTIONS(657),
    [sym__heading_begin] = ACTIONS(55),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(127),
    [sym_list_marker_dash] = ACTIONS(657),
    [sym_list_marker_star] = ACTIONS(657),
    [sym_list_marker_plus] = ACTIONS(657),
    [sym__list_marker_task_begin] = ACTIONS(657),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(657),
    [sym_list_marker_lower_alpha_period] = ACTIONS(657),
    [sym_list_marker_upper_alpha_period] = ACTIONS(657),
    [sym_list_marker_lower_roman_period] = ACTIONS(657),
    [sym_list_marker_upper_roman_period] = ACTIONS(657),
    [sym_list_marker_decimal_paren] = ACTIONS(657),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(657),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(657),
    [sym_list_marker_lower_roman_paren] = ACTIONS(657),
    [sym_list_marker_upper_roman_paren] = ACTIONS(657),
    [sym_list_marker_decimal_parens] = ACTIONS(657),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(657),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(657),
    [sym_list_marker_lower_roman_parens] = ACTIONS(657),
    [sym_list_marker_upper_roman_parens] = ACTIONS(657),
    [sym__block_quote_begin] = ACTIONS(129),
    [sym__block_quote_continuation] = ACTIONS(657),
    [sym__thematic_break_dash] = ACTIONS(131),
    [sym__thematic_break_star] = ACTIONS(131),
    [sym__footnote_mark_begin] = ACTIONS(133),
    [sym__link_ref_def_mark_begin] = ACTIONS(135),
    [sym__table_header_begin] = ACTIONS(657),
    [sym__table_separator_begin] = ACTIONS(657),
    [sym__table_row_begin] = ACTIONS(657),
    [sym__block_attribute_begin] = ACTIONS(143),
    [sym__verbatim_begin] = ACTIONS(657),
  },
  [73] = {
    [sym__block_element] = STATE(1353),
    [sym_heading] = STATE(1353),
    [sym_list] = STATE(1353),
    [sym__list_dash] = STATE(1895),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1895),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1895),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1895),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1895),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1895),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1895),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1895),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1895),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1895),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1895),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1895),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1895),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1895),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1895),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1895),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1895),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1895),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1895),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1895),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1353),
    [sym__table_row] = STATE(1031),
    [sym_table_header] = STATE(1031),
    [sym_table_separator] = STATE(1031),
    [sym_table_row] = STATE(1031),
    [sym_footnote] = STATE(1353),
    [sym_div] = STATE(1353),
    [sym__div_marker_begin] = STATE(2228),
    [sym_code_block] = STATE(1353),
    [sym_raw_block] = STATE(1353),
    [sym_thematic_break] = STATE(1353),
    [sym_block_quote] = STATE(1353),
    [sym__block_quote_content] = STATE(2008),
    [sym__block_quote_prefix] = STATE(91),
    [sym_link_reference_definition] = STATE(1353),
    [sym_block_attribute] = STATE(1353),
    [sym__paragraph] = STATE(1353),
    [sym__paragraph_content] = STATE(1959),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1110),
    [aux_sym__list_plus_repeat1] = STATE(1111),
    [aux_sym__list_star_repeat1] = STATE(1112),
    [aux_sym__list_task_repeat1] = STATE(1077),
    [aux_sym__list_definition_repeat1] = STATE(1377),
    [aux_sym__list_decimal_period_repeat1] = STATE(1114),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1115),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1116),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1117),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1118),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1119),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1120),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1121),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1122),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1123),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1124),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1125),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1126),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1127),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1128),
    [aux_sym_table_repeat1] = STATE(1031),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(663),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(665),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(667),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(669),
    [sym__thematic_break_star] = ACTIONS(669),
    [sym__footnote_mark_begin] = ACTIONS(671),
    [sym__link_ref_def_mark_begin] = ACTIONS(673),
    [sym__table_header_begin] = ACTIONS(675),
    [sym__table_separator_begin] = ACTIONS(677),
    [sym__table_row_begin] = ACTIONS(679),
    [sym__block_attribute_begin] = ACTIONS(681),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [74] = {
    [sym__block_element] = STATE(1353),
    [sym_heading] = STATE(1353),
    [sym_list] = STATE(1353),
    [sym__list_dash] = STATE(1895),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1895),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1895),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1895),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1895),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1895),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1895),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1895),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1895),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1895),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1895),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1895),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1895),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1895),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1895),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1895),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1895),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1895),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1895),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1895),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1353),
    [sym__table_row] = STATE(1031),
    [sym_table_header] = STATE(1031),
    [sym_table_separator] = STATE(1031),
    [sym_table_row] = STATE(1031),
    [sym_footnote] = STATE(1353),
    [sym_div] = STATE(1353),
    [sym__div_marker_begin] = STATE(2228),
    [sym_code_block] = STATE(1353),
    [sym_raw_block] = STATE(1353),
    [sym_thematic_break] = STATE(1353),
    [sym_block_quote] = STATE(1353),
    [sym__block_quote_content] = STATE(2301),
    [sym__block_quote_prefix] = STATE(91),
    [sym_link_reference_definition] = STATE(1353),
    [sym_block_attribute] = STATE(1353),
    [sym__paragraph] = STATE(1353),
    [sym__paragraph_content] = STATE(1959),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1110),
    [aux_sym__list_plus_repeat1] = STATE(1111),
    [aux_sym__list_star_repeat1] = STATE(1112),
    [aux_sym__list_task_repeat1] = STATE(1077),
    [aux_sym__list_definition_repeat1] = STATE(1377),
    [aux_sym__list_decimal_period_repeat1] = STATE(1114),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1115),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1116),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1117),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1118),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1119),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1120),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1121),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1122),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1123),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1124),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1125),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1126),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1127),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1128),
    [aux_sym_table_repeat1] = STATE(1031),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(663),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(665),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(667),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(669),
    [sym__thematic_break_star] = ACTIONS(669),
    [sym__footnote_mark_begin] = ACTIONS(671),
    [sym__link_ref_def_mark_begin] = ACTIONS(673),
    [sym__table_header_begin] = ACTIONS(675),
    [sym__table_separator_begin] = ACTIONS(677),
    [sym__table_row_begin] = ACTIONS(679),
    [sym__block_attribute_begin] = ACTIONS(681),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [75] = {
    [sym__block_element] = STATE(1580),
    [sym_heading] = STATE(1580),
    [sym_list] = STATE(1580),
    [sym__list_dash] = STATE(1430),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1430),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1430),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1430),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1430),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1430),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1430),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1430),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1430),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1430),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1430),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1430),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1430),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1430),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1430),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1430),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1430),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1430),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1430),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1430),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1580),
    [sym__table_row] = STATE(1030),
    [sym_table_header] = STATE(1030),
    [sym_table_separator] = STATE(1030),
    [sym_table_row] = STATE(1030),
    [sym_footnote] = STATE(1580),
    [sym_div] = STATE(1580),
    [sym__div_marker_begin] = STATE(2287),
    [sym_code_block] = STATE(1580),
    [sym_raw_block] = STATE(1580),
    [sym_thematic_break] = STATE(1580),
    [sym_block_quote] = STATE(1580),
    [sym__block_quote_prefix] = STATE(95),
    [sym_link_reference_definition] = STATE(1580),
    [sym_block_attribute] = STATE(1580),
    [sym__paragraph] = STATE(1580),
    [sym__paragraph_content] = STATE(1715),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1166),
    [aux_sym__list_plus_repeat1] = STATE(1167),
    [aux_sym__list_star_repeat1] = STATE(1168),
    [aux_sym__list_task_repeat1] = STATE(1091),
    [aux_sym__list_definition_repeat1] = STATE(1373),
    [aux_sym__list_decimal_period_repeat1] = STATE(1170),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1171),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1172),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1173),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1174),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1175),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1102),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1177),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1243),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1179),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1180),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1181),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1182),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1183),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1184),
    [aux_sym_table_repeat1] = STATE(1030),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(655),
    [sym__whitespace1] = ACTIONS(657),
    [sym_quotation_marks] = ACTIONS(657),
    [sym_ellipsis] = ACTIONS(657),
    [sym_em_dash] = ACTIONS(657),
    [sym_en_dash] = ACTIONS(655),
    [sym_backslash_escape] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(657),
    [sym_symbol] = ACTIONS(657),
    [anon_sym_LBRACE_] = ACTIONS(657),
    [anon_sym__] = ACTIONS(657),
    [anon_sym_LBRACE_STAR] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_LBRACE_CARET] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LBRACE_TILDE] = ACTIONS(657),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_LBRACE_EQ] = ACTIONS(657),
    [anon_sym_LBRACE_PLUS] = ACTIONS(657),
    [anon_sym_LBRACE_DASH] = ACTIONS(657),
    [anon_sym_LBRACK_CARET] = ACTIONS(657),
    [anon_sym_BANG_LBRACK] = ACTIONS(657),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(657),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_TODO] = ACTIONS(657),
    [anon_sym_WIP] = ACTIONS(657),
    [anon_sym_NOTE] = ACTIONS(657),
    [anon_sym_INFO] = ACTIONS(657),
    [anon_sym_XXX] = ACTIONS(657),
    [sym_fixme] = ACTIONS(657),
    [aux_sym__text_token1] = ACTIONS(655),
    [sym__newline] = ACTIONS(683),
    [sym__newline_inline] = ACTIONS(657),
    [sym_hard_line_break] = ACTIONS(657),
    [sym__heading_begin] = ACTIONS(625),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(627),
    [sym_list_marker_dash] = ACTIONS(657),
    [sym_list_marker_star] = ACTIONS(657),
    [sym_list_marker_plus] = ACTIONS(657),
    [sym__list_marker_task_begin] = ACTIONS(657),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(657),
    [sym_list_marker_lower_alpha_period] = ACTIONS(657),
    [sym_list_marker_upper_alpha_period] = ACTIONS(657),
    [sym_list_marker_lower_roman_period] = ACTIONS(657),
    [sym_list_marker_upper_roman_period] = ACTIONS(657),
    [sym_list_marker_decimal_paren] = ACTIONS(657),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(657),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(657),
    [sym_list_marker_lower_roman_paren] = ACTIONS(657),
    [sym_list_marker_upper_roman_paren] = ACTIONS(657),
    [sym_list_marker_decimal_parens] = ACTIONS(657),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(657),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(657),
    [sym_list_marker_lower_roman_parens] = ACTIONS(657),
    [sym_list_marker_upper_roman_parens] = ACTIONS(657),
    [sym__block_quote_begin] = ACTIONS(629),
    [sym__block_quote_continuation] = ACTIONS(657),
    [sym__thematic_break_dash] = ACTIONS(633),
    [sym__thematic_break_star] = ACTIONS(633),
    [sym__footnote_mark_begin] = ACTIONS(635),
    [sym__link_ref_def_mark_begin] = ACTIONS(637),
    [sym__table_header_begin] = ACTIONS(657),
    [sym__table_separator_begin] = ACTIONS(657),
    [sym__table_row_begin] = ACTIONS(657),
    [sym__block_attribute_begin] = ACTIONS(645),
    [sym__verbatim_begin] = ACTIONS(657),
  },
  [76] = {
    [sym__block_element] = STATE(2037),
    [sym_heading] = STATE(2037),
    [sym_list] = STATE(2037),
    [sym__list_dash] = STATE(2040),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(2040),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(2040),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(2040),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(2040),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(2040),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(2040),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(2040),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(2040),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(2040),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(2040),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(2040),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(2040),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(2040),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(2040),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(2040),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(2040),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(2040),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(2040),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(2040),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(2037),
    [sym__table_row] = STATE(1033),
    [sym_table_header] = STATE(1033),
    [sym_table_separator] = STATE(1033),
    [sym_table_row] = STATE(1033),
    [sym_footnote] = STATE(2037),
    [sym_div] = STATE(2037),
    [sym__div_marker_begin] = STATE(2196),
    [sym_code_block] = STATE(2037),
    [sym_raw_block] = STATE(2037),
    [sym_thematic_break] = STATE(2037),
    [sym_block_quote] = STATE(2037),
    [sym__block_quote_prefix] = STATE(94),
    [sym_link_reference_definition] = STATE(2037),
    [sym_block_attribute] = STATE(2037),
    [sym__paragraph] = STATE(2037),
    [sym__paragraph_content] = STATE(1891),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1194),
    [aux_sym__list_plus_repeat1] = STATE(1195),
    [aux_sym__list_star_repeat1] = STATE(1196),
    [aux_sym__list_task_repeat1] = STATE(1080),
    [aux_sym__list_definition_repeat1] = STATE(1359),
    [aux_sym__list_decimal_period_repeat1] = STATE(1198),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1199),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1200),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1201),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1202),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1203),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1208),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1209),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1211),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1213),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1214),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1215),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1219),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1220),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1222),
    [aux_sym_table_repeat1] = STATE(1033),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(655),
    [sym__whitespace1] = ACTIONS(657),
    [sym_quotation_marks] = ACTIONS(657),
    [sym_ellipsis] = ACTIONS(657),
    [sym_em_dash] = ACTIONS(657),
    [sym_en_dash] = ACTIONS(655),
    [sym_backslash_escape] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(657),
    [sym_symbol] = ACTIONS(657),
    [anon_sym_LBRACE_] = ACTIONS(657),
    [anon_sym__] = ACTIONS(657),
    [anon_sym_LBRACE_STAR] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_LBRACE_CARET] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LBRACE_TILDE] = ACTIONS(657),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_LBRACE_EQ] = ACTIONS(657),
    [anon_sym_LBRACE_PLUS] = ACTIONS(657),
    [anon_sym_LBRACE_DASH] = ACTIONS(657),
    [anon_sym_LBRACK_CARET] = ACTIONS(657),
    [anon_sym_BANG_LBRACK] = ACTIONS(657),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(657),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_TODO] = ACTIONS(657),
    [anon_sym_WIP] = ACTIONS(657),
    [anon_sym_NOTE] = ACTIONS(657),
    [anon_sym_INFO] = ACTIONS(657),
    [anon_sym_XXX] = ACTIONS(657),
    [sym_fixme] = ACTIONS(657),
    [aux_sym__text_token1] = ACTIONS(655),
    [sym__newline] = ACTIONS(685),
    [sym__newline_inline] = ACTIONS(657),
    [sym_hard_line_break] = ACTIONS(657),
    [sym__heading_begin] = ACTIONS(555),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(557),
    [sym_list_marker_dash] = ACTIONS(657),
    [sym_list_marker_star] = ACTIONS(657),
    [sym_list_marker_plus] = ACTIONS(657),
    [sym__list_marker_task_begin] = ACTIONS(657),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(657),
    [sym_list_marker_lower_alpha_period] = ACTIONS(657),
    [sym_list_marker_upper_alpha_period] = ACTIONS(657),
    [sym_list_marker_lower_roman_period] = ACTIONS(657),
    [sym_list_marker_upper_roman_period] = ACTIONS(657),
    [sym_list_marker_decimal_paren] = ACTIONS(657),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(657),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(657),
    [sym_list_marker_lower_roman_paren] = ACTIONS(657),
    [sym_list_marker_upper_roman_paren] = ACTIONS(657),
    [sym_list_marker_decimal_parens] = ACTIONS(657),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(657),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(657),
    [sym_list_marker_lower_roman_parens] = ACTIONS(657),
    [sym_list_marker_upper_roman_parens] = ACTIONS(657),
    [sym__block_quote_begin] = ACTIONS(559),
    [sym__block_quote_continuation] = ACTIONS(657),
    [sym__thematic_break_dash] = ACTIONS(563),
    [sym__thematic_break_star] = ACTIONS(563),
    [sym__footnote_mark_begin] = ACTIONS(565),
    [sym__link_ref_def_mark_begin] = ACTIONS(567),
    [sym__table_header_begin] = ACTIONS(657),
    [sym__table_separator_begin] = ACTIONS(657),
    [sym__table_row_begin] = ACTIONS(657),
    [sym__block_attribute_begin] = ACTIONS(575),
    [sym__verbatim_begin] = ACTIONS(657),
  },
  [77] = {
    [sym__block_element] = STATE(1353),
    [sym_heading] = STATE(1353),
    [sym_list] = STATE(1353),
    [sym__list_dash] = STATE(1895),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1895),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1895),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1895),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1895),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1895),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1895),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1895),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1895),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1895),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1895),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1895),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1895),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1895),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1895),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1895),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1895),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1895),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1895),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1895),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1353),
    [sym__table_row] = STATE(1031),
    [sym_table_header] = STATE(1031),
    [sym_table_separator] = STATE(1031),
    [sym_table_row] = STATE(1031),
    [sym_footnote] = STATE(1353),
    [sym_div] = STATE(1353),
    [sym__div_marker_begin] = STATE(2228),
    [sym_code_block] = STATE(1353),
    [sym_raw_block] = STATE(1353),
    [sym_thematic_break] = STATE(1353),
    [sym_block_quote] = STATE(1353),
    [sym__block_quote_content] = STATE(2086),
    [sym__block_quote_prefix] = STATE(91),
    [sym_link_reference_definition] = STATE(1353),
    [sym_block_attribute] = STATE(1353),
    [sym__paragraph] = STATE(1353),
    [sym__paragraph_content] = STATE(1959),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin] = STATE(2123),
    [sym_delete] = STATE(459),
    [sym_delete_begin] = STATE(2604),
    [sym_footnote_reference] = STATE(459),
    [sym_footnote_marker_begin] = STATE(2108),
    [sym__image] = STATE(459),
    [sym_full_reference_image] = STATE(459),
    [sym_collapsed_reference_image] = STATE(459),
    [sym_inline_image] = STATE(459),
    [sym_image_description] = STATE(1329),
    [sym__image_description_begin] = STATE(2260),
    [sym__link] = STATE(459),
    [sym_full_reference_link] = STATE(459),
    [sym_collapsed_reference_link] = STATE(459),
    [sym_inline_link] = STATE(459),
    [sym_link_text] = STATE(1335),
    [sym_span] = STATE(999),
    [sym__bracketed_text_begin] = STATE(2272),
    [sym_inline_comment] = STATE(467),
    [sym_raw_inline] = STATE(467),
    [sym_math] = STATE(467),
    [sym_verbatim] = STATE(467),
    [sym__todo_highlights] = STATE(467),
    [sym_todo] = STATE(467),
    [sym_note] = STATE(467),
    [sym__symbol_fallback] = STATE(467),
    [aux_sym__text] = STATE(438),
    [aux_sym__list_dash_repeat1] = STATE(1110),
    [aux_sym__list_plus_repeat1] = STATE(1111),
    [aux_sym__list_star_repeat1] = STATE(1112),
    [aux_sym__list_task_repeat1] = STATE(1077),
    [aux_sym__list_definition_repeat1] = STATE(1377),
    [aux_sym__list_decimal_period_repeat1] = STATE(1114),
    [aux_sym__list_decimal_paren_repeat1] = STATE(1115),
    [aux_sym__list_decimal_parens_repeat1] = STATE(1116),
    [aux_sym__list_lower_alpha_period_repeat1] = STATE(1117),
    [aux_sym__list_lower_alpha_paren_repeat1] = STATE(1118),
    [aux_sym__list_lower_alpha_parens_repeat1] = STATE(1119),
    [aux_sym__list_upper_alpha_period_repeat1] = STATE(1120),
    [aux_sym__list_upper_alpha_paren_repeat1] = STATE(1121),
    [aux_sym__list_upper_alpha_parens_repeat1] = STATE(1122),
    [aux_sym__list_lower_roman_period_repeat1] = STATE(1123),
    [aux_sym__list_lower_roman_paren_repeat1] = STATE(1124),
    [aux_sym__list_lower_roman_parens_repeat1] = STATE(1125),
    [aux_sym__list_upper_roman_period_repeat1] = STATE(1126),
    [aux_sym__list_upper_roman_paren_repeat1] = STATE(1127),
    [aux_sym__list_upper_roman_parens_repeat1] = STATE(1128),
    [aux_sym_table_repeat1] = STATE(1031),
    [aux_sym__block_quote_prefix_repeat1] = STATE(434),
    [aux_sym__inline_repeat1] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym__whitespace1] = ACTIONS(7),
    [sym_quotation_marks] = ACTIONS(9),
    [sym_ellipsis] = ACTIONS(9),
    [sym_em_dash] = ACTIONS(9),
    [sym_en_dash] = ACTIONS(11),
    [sym_backslash_escape] = ACTIONS(11),
    [anon_sym_LT] = ACTIONS(13),
    [sym_symbol] = ACTIONS(9),
    [anon_sym_LBRACE_] = ACTIONS(15),
    [anon_sym__] = ACTIONS(17),
    [anon_sym_LBRACE_STAR] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_LBRACE_CARET] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(23),
    [anon_sym_LBRACE_TILDE] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE_EQ] = ACTIONS(27),
    [anon_sym_LBRACE_PLUS] = ACTIONS(29),
    [anon_sym_LBRACE_DASH] = ACTIONS(31),
    [anon_sym_LBRACK_CARET] = ACTIONS(33),
    [anon_sym_BANG_LBRACK] = ACTIONS(35),
    [anon_sym_LBRACK_RBRACK2] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [anon_sym_TODO] = ACTIONS(43),
    [anon_sym_WIP] = ACTIONS(43),
    [anon_sym_NOTE] = ACTIONS(45),
    [anon_sym_INFO] = ACTIONS(45),
    [anon_sym_XXX] = ACTIONS(45),
    [sym_fixme] = ACTIONS(9),
    [aux_sym__text_token1] = ACTIONS(47),
    [sym__newline_inline] = ACTIONS(51),
    [sym_hard_line_break] = ACTIONS(9),
    [sym__heading_begin] = ACTIONS(663),
    [sym__div_begin] = ACTIONS(57),
    [sym__code_block_begin] = ACTIONS(665),
    [sym_list_marker_dash] = ACTIONS(61),
    [sym_list_marker_star] = ACTIONS(63),
    [sym_list_marker_plus] = ACTIONS(65),
    [sym__list_marker_task_begin] = ACTIONS(67),
    [sym_list_marker_definition] = ACTIONS(69),
    [sym_list_marker_decimal_period] = ACTIONS(71),
    [sym_list_marker_lower_alpha_period] = ACTIONS(73),
    [sym_list_marker_upper_alpha_period] = ACTIONS(75),
    [sym_list_marker_lower_roman_period] = ACTIONS(77),
    [sym_list_marker_upper_roman_period] = ACTIONS(79),
    [sym_list_marker_decimal_paren] = ACTIONS(81),
    [sym_list_marker_lower_alpha_paren] = ACTIONS(83),
    [sym_list_marker_upper_alpha_paren] = ACTIONS(85),
    [sym_list_marker_lower_roman_paren] = ACTIONS(87),
    [sym_list_marker_upper_roman_paren] = ACTIONS(89),
    [sym_list_marker_decimal_parens] = ACTIONS(91),
    [sym_list_marker_lower_alpha_parens] = ACTIONS(93),
    [sym_list_marker_upper_alpha_parens] = ACTIONS(95),
    [sym_list_marker_lower_roman_parens] = ACTIONS(97),
    [sym_list_marker_upper_roman_parens] = ACTIONS(99),
    [sym__block_quote_begin] = ACTIONS(667),
    [sym__block_quote_continuation] = ACTIONS(103),
    [sym__thematic_break_dash] = ACTIONS(669),
    [sym__thematic_break_star] = ACTIONS(669),
    [sym__footnote_mark_begin] = ACTIONS(671),
    [sym__link_ref_def_mark_begin] = ACTIONS(673),
    [sym__table_header_begin] = ACTIONS(675),
    [sym__table_separator_begin] = ACTIONS(677),
    [sym__table_row_begin] = ACTIONS(679),
    [sym__block_attribute_begin] = ACTIONS(681),
    [sym__verbatim_begin] = ACTIONS(119),
  },
  [78] = {
    [sym__block_element] = STATE(1353),
    [sym_heading] = STATE(1353),
    [sym_list] = STATE(1353),
    [sym__list_dash] = STATE(1895),
    [sym__list_item_dash] = STATE(1442),
    [sym__list_plus] = STATE(1895),
    [sym__list_item_plus] = STATE(1464),
    [sym__list_star] = STATE(1895),
    [sym__list_item_star] = STATE(1550),
    [sym__list_task] = STATE(1895),
    [sym__list_item_task] = STATE(1528),
    [sym_list_marker_task] = STATE(56),
    [sym__list_definition] = STATE(1895),
    [sym__list_item_definition] = STATE(1873),
    [sym__list_decimal_period] = STATE(1895),
    [sym__list_item_decimal_period] = STATE(1559),
    [sym__list_decimal_paren] = STATE(1895),
    [sym__list_item_decimal_paren] = STATE(1526),
    [sym__list_decimal_parens] = STATE(1895),
    [sym__list_item_decimal_parens] = STATE(1545),
    [sym__list_lower_alpha_period] = STATE(1895),
    [sym__list_item_lower_alpha_period] = STATE(1568),
    [sym__list_lower_alpha_paren] = STATE(1895),
    [sym__list_item_lower_alpha_paren] = STATE(1627),
    [sym__list_lower_alpha_parens] = STATE(1895),
    [sym__list_item_lower_alpha_parens] = STATE(1416),
    [sym__list_upper_alpha_period] = STATE(1895),
    [sym__list_item_upper_alpha_period] = STATE(1418),
    [sym__list_upper_alpha_paren] = STATE(1895),
    [sym__list_item_upper_alpha_paren] = STATE(1616),
    [sym__list_upper_alpha_parens] = STATE(1895),
    [sym__list_item_upper_alpha_parens] = STATE(1628),
    [sym__list_lower_roman_period] = STATE(1895),
    [sym__list_item_lower_roman_period] = STATE(1425),
    [sym__list_lower_roman_paren] = STATE(1895),
    [sym__list_item_lower_roman_paren] = STATE(1410),
    [sym__list_lower_roman_parens] = STATE(1895),
    [sym__list_item_lower_roman_parens] = STATE(1510),
    [sym__list_upper_roman_period] = STATE(1895),
    [sym__list_item_upper_roman_period] = STATE(1547),
    [sym__list_upper_roman_paren] = STATE(1895),
    [sym__list_item_upper_roman_paren] = STATE(1598),
    [sym__list_upper_roman_parens] = STATE(1895),
    [sym__list_item_upper_roman_parens] = STATE(1419),
    [sym_table] = STATE(1353),
    [sym__table_row] = STATE(1031),
    [sym_table_header] = STATE(1031),
    [sym_table_separator] = STATE(1031),
    [sym_table_row] = STATE(1031),
    [sym_footnote] = STATE(1353),
    [sym_div] = STATE(1353),
    [sym__div_marker_begin] = STATE(2228),
    [sym_code_block] = STATE(1353),
    [sym_raw_block] = STATE(1353),
    [sym_thematic_break] = STATE(1353),
    [sym_block_quote] = STATE(1353),
    [sym__block_quote_content] = STATE(2426),
    [sym__block_quote_prefix] = STATE(91),
    [sym_link_reference_definition] = STATE(1353),
    [sym_block_attribute] = STATE(1353),
    [sym__paragraph] = STATE(1353),
    [sym__paragraph_content] = STATE(1959),
    [sym__inline] = STATE(1555),
    [sym__inline_element] = STATE(999),
    [sym__smart_punctuation] = STATE(467),
    [sym_autolink] = STATE(467),
    [sym_emphasis] = STATE(459),
    [sym_emphasis_begin] = STATE(2055),
    [sym_strong] = STATE(459),
    [sym_strong_begin] = STATE(2088),
    [sym_superscript] = STATE(459),
    [sym_superscript_begin] = STATE(2091),
    [sym_subscript] = STATE(459),
    [sym_subscript_begin] = STATE(2111),
    [sym_highlighted] = STATE(459),
    [sym_highlighted_begin] = STATE(2115),
    [sym_insert] = STATE(459),
    [sym_insert_begin