/**
 * @file Debian package management control data
 * @author Wesley Hershberger <wesley.hershberger@gmail.com>
 * @license MIT
 */

/// <reference types="tree-sitter-cli/dsl" />
// @ts-check

// The control file format is documented at
// https://www.debian.org/doc/debian-policy/ch-controlfields.html
// This is a very messy parser but it should suffice for syntax highlighting
module.exports = grammar({
  name: "debian",

  extras: $ => [],

  rules: {
    source_file: $ => seq(
      optional("\n"),
      $.stanza,
      repeat(seq("\n\n", $.stanza)),
    ),

    stanza: $ => seq(
      line($),
      repeat(seq("\n", line($))),
      optional("\n"),
    ),

    field: $ => seq(
      $.field_name,
      ":",
      $.field_value,
    ),

    field_name: $ => /[!"$-,.-9;-~][!-9;-~]*/,

    field_value: $ => seq(
      choice(/.+/, continuation_line()),
      repeat(continuation_line()),
    ),

    comment: _ => token(/#.*/)
  }
});

function line($) {
  return choice($.field, $.comment)
}

function continuation_line() {
  return /\n[ \t].+/
}
