#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 372
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 95
#define ALIAS_COUNT 0
#define TOKEN_COUNT 63
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 12
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 15

enum {
  sym_comment = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_LBRACK = 4,
  anon_sym_COMMA = 5,
  anon_sym_RBRACK = 6,
  anon_sym_DOT = 7,
  anon_sym_COLON = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_if = 11,
  anon_sym_then = 12,
  anon_sym_else = 13,
  anon_sym_SEMI = 14,
  anon_sym_in = 15,
  anon_sym_function = 16,
  anon_sym_import = 17,
  anon_sym_importstr = 18,
  anon_sym_error = 19,
  sym_null = 20,
  sym_true = 21,
  sym_false = 22,
  sym_self = 23,
  sym_dollar = 24,
  sym_super = 25,
  sym_local = 26,
  anon_sym_PLUS = 27,
  anon_sym_COLON_COLON = 28,
  anon_sym_COLON_COLON_COLON = 29,
  anon_sym_for = 30,
  anon_sym_EQ = 31,
  anon_sym_assert = 32,
  sym_id = 33,
  anon_sym_STAR = 34,
  anon_sym_SLASH = 35,
  anon_sym_PERCENT = 36,
  anon_sym_DASH = 37,
  anon_sym_LT_LT = 38,
  anon_sym_GT_GT = 39,
  anon_sym_LT = 40,
  anon_sym_LT_EQ = 41,
  anon_sym_GT = 42,
  anon_sym_GT_EQ = 43,
  anon_sym_EQ_EQ = 44,
  anon_sym_BANG_EQ = 45,
  anon_sym_AMP = 46,
  anon_sym_CARET = 47,
  anon_sym_PIPE = 48,
  anon_sym_AMP_AMP = 49,
  anon_sym_PIPE_PIPE = 50,
  anon_sym_BANG = 51,
  anon_sym_TILDE = 52,
  sym_number = 53,
  anon_sym_AT = 54,
  sym__single = 55,
  sym__double = 56,
  aux_sym__str_double_token1 = 57,
  aux_sym__str_single_token1 = 58,
  sym_escape_sequence = 59,
  sym__string_start = 60,
  sym__string_content = 61,
  sym__string_end = 62,
  sym_document = 63,
  sym_expr = 64,
  sym_local_bind = 65,
  sym_anonymous_function = 66,
  sym_import = 67,
  sym_importstr = 68,
  sym_expr_error = 69,
  sym_member = 70,
  sym_field = 71,
  sym_objlocal = 72,
  sym_compspec = 73,
  sym_forspec = 74,
  sym_ifspec = 75,
  sym_fieldname = 76,
  sym_bind = 77,
  sym_params = 78,
  sym_param = 79,
  sym_assert = 80,
  sym_named_argument = 81,
  sym_args = 82,
  sym_binaryop = 83,
  sym_unaryop = 84,
  sym_string = 85,
  aux_sym__str_double = 86,
  aux_sym__str_single = 87,
  aux_sym_expr_repeat1 = 88,
  aux_sym_local_bind_repeat1 = 89,
  aux_sym_objinside_repeat1 = 90,
  aux_sym_objinside_repeat2 = 91,
  aux_sym_objinside_repeat3 = 92,
  aux_sym_compspec_repeat1 = 93,
  aux_sym_params_repeat1 = 94,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON] = ":",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_SEMI] = ";",
  [anon_sym_in] = "in",
  [anon_sym_function] = "function",
  [anon_sym_import] = "import",
  [anon_sym_importstr] = "importstr",
  [anon_sym_error] = "error",
  [sym_null] = "null",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_self] = "self",
  [sym_dollar] = "dollar",
  [sym_super] = "super",
  [sym_local] = "local",
  [anon_sym_PLUS] = "+",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [anon_sym_for] = "for",
  [anon_sym_EQ] = "=",
  [anon_sym_assert] = "assert",
  [sym_id] = "id",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [sym_number] = "number",
  [anon_sym_AT] = "@",
  [sym__single] = "string_start",
  [sym__double] = "string_start",
  [aux_sym__str_double_token1] = "_str_double_token1",
  [aux_sym__str_single_token1] = "_str_single_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__string_start] = "string_start",
  [sym__string_content] = "string_content",
  [sym__string_end] = "string_end",
  [sym_document] = "document",
  [sym_expr] = "expr",
  [sym_local_bind] = "local_bind",
  [sym_anonymous_function] = "anonymous_function",
  [sym_import] = "import",
  [sym_importstr] = "importstr",
  [sym_expr_error] = "expr_error",
  [sym_member] = "member",
  [sym_field] = "field",
  [sym_objlocal] = "objlocal",
  [sym_compspec] = "compspec",
  [sym_forspec] = "forspec",
  [sym_ifspec] = "ifspec",
  [sym_fieldname] = "fieldname",
  [sym_bind] = "bind",
  [sym_params] = "params",
  [sym_param] = "param",
  [sym_assert] = "assert",
  [sym_named_argument] = "named_argument",
  [sym_args] = "args",
  [sym_binaryop] = "binaryop",
  [sym_unaryop] = "unaryop",
  [sym_string] = "string",
  [aux_sym__str_double] = "_str_double",
  [aux_sym__str_single] = "_str_single",
  [aux_sym_expr_repeat1] = "expr_repeat1",
  [aux_sym_local_bind_repeat1] = "local_bind_repeat1",
  [aux_sym_objinside_repeat1] = "objinside_repeat1",
  [aux_sym_objinside_repeat2] = "objinside_repeat2",
  [aux_sym_objinside_repeat3] = "objinside_repeat3",
  [aux_sym_compspec_repeat1] = "compspec_repeat1",
  [aux_sym_params_repeat1] = "params_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_importstr] = anon_sym_importstr,
  [anon_sym_error] = anon_sym_error,
  [sym_null] = sym_null,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_self] = sym_self,
  [sym_dollar] = sym_dollar,
  [sym_super] = sym_super,
  [sym_local] = sym_local,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_assert] = anon_sym_assert,
  [sym_id] = sym_id,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_number] = sym_number,
  [anon_sym_AT] = anon_sym_AT,
  [sym__single] = sym__string_start,
  [sym__double] = sym__string_start,
  [aux_sym__str_double_token1] = aux_sym__str_double_token1,
  [aux_sym__str_single_token1] = aux_sym__str_single_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_end,
  [sym_document] = sym_document,
  [sym_expr] = sym_expr,
  [sym_local_bind] = sym_local_bind,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_import] = sym_import,
  [sym_importstr] = sym_importstr,
  [sym_expr_error] = sym_expr_error,
  [sym_member] = sym_member,
  [sym_field] = sym_field,
  [sym_objlocal] = sym_objlocal,
  [sym_compspec] = sym_compspec,
  [sym_forspec] = sym_forspec,
  [sym_ifspec] = sym_ifspec,
  [sym_fieldname] = sym_fieldname,
  [sym_bind] = sym_bind,
  [sym_params] = sym_params,
  [sym_param] = sym_param,
  [sym_assert] = sym_assert,
  [sym_named_argument] = sym_named_argument,
  [sym_args] = sym_args,
  [sym_binaryop] = sym_binaryop,
  [sym_unaryop] = sym_unaryop,
  [sym_string] = sym_string,
  [aux_sym__str_double] = aux_sym__str_double,
  [aux_sym__str_single] = aux_sym__str_single,
  [aux_sym_expr_repeat1] = aux_sym_expr_repeat1,
  [aux_sym_local_bind_repeat1] = aux_sym_local_bind_repeat1,
  [aux_sym_objinside_repeat1] = aux_sym_objinside_repeat1,
  [aux_sym_objinside_repeat2] = aux_sym_objinside_repeat2,
  [aux_sym_objinside_repeat3] = aux_sym_objinside_repeat3,
  [aux_sym_compspec_repeat1] = aux_sym_compspec_repeat1,
  [aux_sym_params_repeat1] = aux_sym_params_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_importstr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_local] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [sym_id] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym__single] = {
    .visible = true,
    .named = true,
  },
  [sym__double] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__str_double_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__str_single_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_local_bind] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_importstr] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_error] = {
    .visible = true,
    .named = true,
  },
  [sym_member] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_objlocal] = {
    .visible = true,
    .named = true,
  },
  [sym_compspec] = {
    .visible = true,
    .named = true,
  },
  [sym_forspec] = {
    .visible = true,
    .named = true,
  },
  [sym_ifspec] = {
    .visible = true,
    .named = true,
  },
  [sym_fieldname] = {
    .visible = true,
    .named = true,
  },
  [sym_bind] = {
    .visible = true,
    .named = true,
  },
  [sym_params] = {
    .visible = true,
    .named = true,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_args] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryop] = {
    .visible = true,
    .named = true,
  },
  [sym_unaryop] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__str_double] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__str_single] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_local_bind_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_objinside_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_objinside_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_objinside_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compspec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_params_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_function = 6,
  field_identifier = 7,
  field_left = 8,
  field_operator = 9,
  field_params = 10,
  field_right = 11,
  field_value = 12,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_identifier] = "identifier",
  [field_left] = "left",
  [field_operator] = "operator",
  [field_params] = "params",
  [field_right] = "right",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [4] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 3},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 3},
  [13] = {.index = 16, .length = 2},
  [14] = {.index = 18, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 1},
    {field_operator, 0},
  [2] =
    {field_identifier, 0},
  [3] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [6] =
    {field_condition, 1},
    {field_consequence, 3},
  [8] =
    {field_body, 3},
  [9] =
    {field_identifier, 0},
    {field_value, 2},
  [11] =
    {field_body, 4},
    {field_params, 2},
  [13] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [16] =
    {field_body, 4},
    {field_function, 0},
  [18] =
    {field_body, 5},
    {field_function, 0},
    {field_params, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = sym__string_end,
  },
  [3] = {
    [1] = sym__string_content,
    [2] = sym__string_end,
  },
  [5] = {
    [2] = sym__string_end,
  },
  [9] = {
    [2] = sym__string_content,
    [3] = sym__string_end,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__str_double, 2,
    aux_sym__str_double,
    sym__string_content,
  aux_sym__str_single, 2,
    aux_sym__str_single,
    sym__string_content,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(118);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(192);
      if (lookahead == ':') ADVANCE(87);
      if (lookahead == ';') ADVANCE(94);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(123);
      if (lookahead == '>') ADVANCE(180);
      if (lookahead == '@') ADVANCE(200);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == '^') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(64);
      if (lookahead == 's') ADVANCE(23);
      if (lookahead == 't') ADVANCE(29);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(186);
      if (lookahead == '}') ADVANCE(80);
      if (lookahead == '~') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(73)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(6)
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(203);
      if (lookahead != 0) ADVANCE(207);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(7)
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '/') ADVANCE(209);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(208);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '+') ADVANCE(118);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '0') ADVANCE(192);
      if (lookahead == ':') ADVANCE(86);
      if (lookahead == '@') ADVANCE(200);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == 'a') ADVANCE(162);
      if (lookahead == 'e') ADVANCE(159);
      if (lookahead == 'f') ADVANCE(127);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 's') ADVANCE(133);
      if (lookahead == 't') ADVANCE(157);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '~') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(194);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '+') ADVANCE(118);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '0') ADVANCE(192);
      if (lookahead == '@') ADVANCE(200);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == 'a') ADVANCE(162);
      if (lookahead == 'e') ADVANCE(159);
      if (lookahead == 'f') ADVANCE(126);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 's') ADVANCE(133);
      if (lookahead == 't') ADVANCE(157);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '~') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(194);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '@') ADVANCE(200);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(162);
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == '}') ADVANCE(80);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(78);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(183);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(182);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 16:
      if (lookahead == 'c') ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(60);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(90);
      if (lookahead == 'm') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(90);
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(110);
      END_STATE();
    case 28:
      if (lookahead == 'h') ADVANCE(21);
      END_STATE();
    case 29:
      if (lookahead == 'h') ADVANCE(21);
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(44);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(27);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(104);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(32);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(58);
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(59);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 39:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 45:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 47:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == 'p') ADVANCE(24);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 53:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 58:
      if (lookahead == 's') ADVANCE(18);
      END_STATE();
    case 59:
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 65:
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 66:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 67:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(196);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(197);
      END_STATE();
    case 69:
      if (lookahead == '"' ||
          lookahead == '/' ||
          lookahead == '\\' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'u') ADVANCE(213);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 73:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '"') ADVANCE(202);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(201);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(118);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(192);
      if (lookahead == ':') ADVANCE(87);
      if (lookahead == ';') ADVANCE(94);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(123);
      if (lookahead == '>') ADVANCE(180);
      if (lookahead == '@') ADVANCE(200);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == '^') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(64);
      if (lookahead == 's') ADVANCE(23);
      if (lookahead == 't') ADVANCE(29);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(186);
      if (lookahead == '}') ADVANCE(80);
      if (lookahead == '~') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(73)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 74:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(174);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == ':') ADVANCE(86);
      if (lookahead == ';') ADVANCE(94);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(123);
      if (lookahead == '>') ADVANCE(180);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == '^') ADVANCE(185);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'i') ADVANCE(26);
      if (lookahead == 't') ADVANCE(28);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(186);
      if (lookahead == '}') ADVANCE(80);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(74)
      END_STATE();
    case 75:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '%') ADVANCE(173);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(174);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == ':') ADVANCE(87);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(180);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '^') ADVANCE(185);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == '{') ADVANCE(79);
      if (lookahead == '|') ADVANCE(186);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(75)
      END_STATE();
    case 76:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(119);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == 's') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_importstr);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_importstr);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_error);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_self);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_dollar);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_super);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_local);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_local);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '0') ADVANCE(193);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(120);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(182);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'a') ADVANCE(142);
      if (lookahead == 'o') ADVANCE(155);
      if (lookahead == 'u') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'a') ADVANCE(142);
      if (lookahead == 'u') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'a') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'c') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'c') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'e') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'e') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'e') ADVANCE(139);
      if (lookahead == 'u') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'e') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'e') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'f') ADVANCE(91);
      if (lookahead == 'm') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'f') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'i') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'l') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'l') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'l') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'l') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'n') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'n') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'o') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'o') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'o') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'o') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'p') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'p') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'r') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 's') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 's') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 's') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 't') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 't') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 't') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 't') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'u') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == 'u') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(78);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(193);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '=') ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(181);
      if (lookahead == '>') ADVANCE(177);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(187);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(188);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(183);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(67);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(68);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(72);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__single);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym__double);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(aux_sym__str_double_token1);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(203);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(207);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(aux_sym__str_double_token1);
      if (lookahead == '*') ADVANCE(206);
      if (lookahead == '/') ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(207);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym__str_double_token1);
      if (lookahead == '*') ADVANCE(205);
      if (lookahead == '/') ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym__str_double_token1);
      if (lookahead == '*') ADVANCE(205);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym__str_double_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym__str_single_token1);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '/') ADVANCE(209);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(208);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym__str_single_token1);
      if (lookahead == '*') ADVANCE(211);
      if (lookahead == '/') ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym__str_single_token1);
      if (lookahead == '*') ADVANCE(210);
      if (lookahead == '/') ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(211);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym__str_single_token1);
      if (lookahead == '*') ADVANCE(210);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym__str_single_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 3, .external_lex_state = 2},
  [2] = {.lex_state = 3, .external_lex_state = 2},
  [3] = {.lex_state = 3, .external_lex_state = 2},
  [4] = {.lex_state = 4, .external_lex_state = 2},
  [5] = {.lex_state = 4, .external_lex_state = 2},
  [6] = {.lex_state = 3, .external_lex_state = 2},
  [7] = {.lex_state = 3, .external_lex_state = 2},
  [8] = {.lex_state = 3, .external_lex_state = 2},
  [9] = {.lex_state = 3, .external_lex_state = 2},
  [10] = {.lex_state = 3, .external_lex_state = 2},
  [11] = {.lex_state = 3, .external_lex_state = 2},
  [12] = {.lex_state = 3, .external_lex_state = 2},
  [13] = {.lex_state = 3, .external_lex_state = 2},
  [14] = {.lex_state = 3, .external_lex_state = 2},
  [15] = {.lex_state = 3, .external_lex_state = 2},
  [16] = {.lex_state = 3, .external_lex_state = 2},
  [17] = {.lex_state = 3, .external_lex_state = 2},
  [18] = {.lex_state = 3, .external_lex_state = 2},
  [19] = {.lex_state = 3, .external_lex_state = 2},
  [20] = {.lex_state = 3, .external_lex_state = 2},
  [21] = {.lex_state = 3, .external_lex_state = 2},
  [22] = {.lex_state = 3, .external_lex_state = 2},
  [23] = {.lex_state = 3, .external_lex_state = 2},
  [24] = {.lex_state = 3, .external_lex_state = 2},
  [25] = {.lex_state = 3, .external_lex_state = 2},
  [26] = {.lex_state = 3, .external_lex_state = 2},
  [27] = {.lex_state = 3, .external_lex_state = 2},
  [28] = {.lex_state = 3, .external_lex_state = 2},
  [29] = {.lex_state = 3, .external_lex_state = 2},
  [30] = {.lex_state = 3, .external_lex_state = 2},
  [31] = {.lex_state = 3, .external_lex_state = 2},
  [32] = {.lex_state = 3, .external_lex_state = 2},
  [33] = {.lex_state = 3, .external_lex_state = 2},
  [34] = {.lex_state = 3, .external_lex_state = 2},
  [35] = {.lex_state = 3, .external_lex_state = 2},
  [36] = {.lex_state = 3, .external_lex_state = 2},
  [37] = {.lex_state = 3, .external_lex_state = 2},
  [38] = {.lex_state = 3, .external_lex_state = 2},
  [39] = {.lex_state = 3, .external_lex_state = 2},
  [40] = {.lex_state = 3, .external_lex_state = 2},
  [41] = {.lex_state = 3, .external_lex_state = 2},
  [42] = {.lex_state = 3, .external_lex_state = 2},
  [43] = {.lex_state = 3, .external_lex_state = 2},
  [44] = {.lex_state = 3, .external_lex_state = 2},
  [45] = {.lex_state = 3, .external_lex_state = 2},
  [46] = {.lex_state = 3, .external_lex_state = 2},
  [47] = {.lex_state = 3, .external_lex_state = 2},
  [48] = {.lex_state = 3, .external_lex_state = 2},
  [49] = {.lex_state = 3, .external_lex_state = 2},
  [50] = {.lex_state = 3, .external_lex_state = 2},
  [51] = {.lex_state = 3, .external_lex_state = 2},
  [52] = {.lex_state = 3, .external_lex_state = 2},
  [53] = {.lex_state = 3, .external_lex_state = 2},
  [54] = {.lex_state = 3, .external_lex_state = 2},
  [55] = {.lex_state = 3, .external_lex_state = 2},
  [56] = {.lex_state = 3, .external_lex_state = 2},
  [57] = {.lex_state = 3, .external_lex_state = 2},
  [58] = {.lex_state = 3, .external_lex_state = 2},
  [59] = {.lex_state = 3, .external_lex_state = 2},
  [60] = {.lex_state = 3, .external_lex_state = 2},
  [61] = {.lex_state = 3, .external_lex_state = 2},
  [62] = {.lex_state = 3, .external_lex_state = 2},
  [63] = {.lex_state = 3, .external_lex_state = 2},
  [64] = {.lex_state = 3, .external_lex_state = 2},
  [65] = {.lex_state = 3, .external_lex_state = 2},
  [66] = {.lex_state = 3, .external_lex_state = 2},
  [67] = {.lex_state = 3, .external_lex_state = 2},
  [68] = {.lex_state = 3, .external_lex_state = 2},
  [69] = {.lex_state = 3, .external_lex_state = 2},
  [70] = {.lex_state = 3, .external_lex_state = 2},
  [71] = {.lex_state = 3, .external_lex_state = 2},
  [72] = {.lex_state = 3, .external_lex_state = 2},
  [73] = {.lex_state = 3, .external_lex_state = 2},
  [74] = {.lex_state = 3, .external_lex_state = 2},
  [75] = {.lex_state = 3, .external_lex_state = 2},
  [76] = {.lex_state = 3, .external_lex_state = 2},
  [77] = {.lex_state = 3, .external_lex_state = 2},
  [78] = {.lex_state = 74},
  [79] = {.lex_state = 74},
  [80] = {.lex_state = 74},
  [81] = {.lex_state = 74},
  [82] = {.lex_state = 74},
  [83] = {.lex_state = 74},
  [84] = {.lex_state = 74},
  [85] = {.lex_state = 74},
  [86] = {.lex_state = 74},
  [87] = {.lex_state = 74},
  [88] = {.lex_state = 74},
  [89] = {.lex_state = 74},
  [90] = {.lex_state = 74},
  [91] = {.lex_state = 74},
  [92] = {.lex_state = 74},
  [93] = {.lex_state = 74},
  [94] = {.lex_state = 74},
  [95] = {.lex_state = 74},
  [96] = {.lex_state = 74},
  [97] = {.lex_state = 74},
  [98] = {.lex_state = 74},
  [99] = {.lex_state = 74},
  [100] = {.lex_state = 74},
  [101] = {.lex_state = 74},
  [102] = {.lex_state = 74},
  [103] = {.lex_state = 74},
  [104] = {.lex_state = 74},
  [105] = {.lex_state = 74},
  [106] = {.lex_state = 74},
  [107] = {.lex_state = 74},
  [108] = {.lex_state = 74},
  [109] = {.lex_state = 74},
  [110] = {.lex_state = 75},
  [111] = {.lex_state = 74},
  [112] = {.lex_state = 74},
  [113] = {.lex_state = 75},
  [114] = {.lex_state = 74},
  [115] = {.lex_state = 74},
  [116] = {.lex_state = 74},
  [117] = {.lex_state = 74},
  [118] = {.lex_state = 74},
  [119] = {.lex_state = 74},
  [120] = {.lex_state = 75},
  [121] = {.lex_state = 74},
  [122] = {.lex_state = 74},
  [123] = {.lex_state = 74},
  [124] = {.lex_state = 75},
  [125] = {.lex_state = 74},
  [126] = {.lex_state = 74},
  [127] = {.lex_state = 74},
  [128] = {.lex_state = 74},
  [129] = {.lex_state = 74},
  [130] = {.lex_state = 3, .external_lex_state = 2},
  [131] = {.lex_state = 74},
  [132] = {.lex_state = 74},
  [133] = {.lex_state = 74},
  [134] = {.lex_state = 74},
  [135] = {.lex_state = 74},
  [136] = {.lex_state = 74},
  [137] = {.lex_state = 3, .external_lex_state = 2},
  [138] = {.lex_state = 74},
  [139] = {.lex_state = 74},
  [140] = {.lex_state = 74},
  [141] = {.lex_state = 74},
  [142] = {.lex_state = 74},
  [143] = {.lex_state = 74},
  [144] = {.lex_state = 74},
  [145] = {.lex_state = 74},
  [146] = {.lex_state = 74},
  [147] = {.lex_state = 74},
  [148] = {.lex_state = 74},
  [149] = {.lex_state = 74},
  [150] = {.lex_state = 74},
  [151] = {.lex_state = 74},
  [152] = {.lex_state = 74},
  [153] = {.lex_state = 74},
  [154] = {.lex_state = 74},
  [155] = {.lex_state = 74},
  [156] = {.lex_state = 74},
  [157] = {.lex_state = 74},
  [158] = {.lex_state = 74},
  [159] = {.lex_state = 74},
  [160] = {.lex_state = 74},
  [161] = {.lex_state = 74},
  [162] = {.lex_state = 74},
  [163] = {.lex_state = 74},
  [164] = {.lex_state = 74},
  [165] = {.lex_state = 74},
  [166] = {.lex_state = 74},
  [167] = {.lex_state = 74},
  [168] = {.lex_state = 74},
  [169] = {.lex_state = 74},
  [170] = {.lex_state = 74},
  [171] = {.lex_state = 74},
  [172] = {.lex_state = 74},
  [173] = {.lex_state = 74},
  [174] = {.lex_state = 74},
  [175] = {.lex_state = 74},
  [176] = {.lex_state = 74},
  [177] = {.lex_state = 74},
  [178] = {.lex_state = 74},
  [179] = {.lex_state = 74},
  [180] = {.lex_state = 74},
  [181] = {.lex_state = 74},
  [182] = {.lex_state = 74},
  [183] = {.lex_state = 74},
  [184] = {.lex_state = 74},
  [185] = {.lex_state = 74},
  [186] = {.lex_state = 74},
  [187] = {.lex_state = 74},
  [188] = {.lex_state = 74},
  [189] = {.lex_state = 74},
  [190] = {.lex_state = 74},
  [191] = {.lex_state = 74},
  [192] = {.lex_state = 74},
  [193] = {.lex_state = 5, .external_lex_state = 2},
  [194] = {.lex_state = 5, .external_lex_state = 2},
  [195] = {.lex_state = 5, .external_lex_state = 2},
  [196] = {.lex_state = 5, .external_lex_state = 2},
  [197] = {.lex_state = 5, .external_lex_state = 2},
  [198] = {.lex_state = 5, .external_lex_state = 2},
  [199] = {.lex_state = 5, .external_lex_state = 2},
  [200] = {.lex_state = 5, .external_lex_state = 2},
  [201] = {.lex_state = 5, .external_lex_state = 2},
  [202] = {.lex_state = 5, .external_lex_state = 2},
  [203] = {.lex_state = 5, .external_lex_state = 2},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 75},
  [221] = {.lex_state = 0, .external_lex_state = 2},
  [222] = {.lex_state = 0, .external_lex_state = 2},
  [223] = {.lex_state = 75},
  [224] = {.lex_state = 75},
  [225] = {.lex_state = 75},
  [226] = {.lex_state = 0, .external_lex_state = 2},
  [227] = {.lex_state = 75},
  [228] = {.lex_state = 0, .external_lex_state = 2},
  [229] = {.lex_state = 75},
  [230] = {.lex_state = 75},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 8},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 8},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 8},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 2},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 2},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 8},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 2},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 2},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 8},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0, .external_lex_state = 2},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 8},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0, .external_lex_state = 2},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 8},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 8},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 8},
  [310] = {.lex_state = 8},
  [311] = {.lex_state = 8},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 8},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 8},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0, .external_lex_state = 3},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0, .external_lex_state = 4},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0, .external_lex_state = 3},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0, .external_lex_state = 4},
  [343] = {.lex_state = 0, .external_lex_state = 4},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 8},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0, .external_lex_state = 3},
  [348] = {.lex_state = 8},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0, .external_lex_state = 4},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 3},
  [360] = {.lex_state = 3},
  [361] = {.lex_state = 3},
  [362] = {.lex_state = 0, .external_lex_state = 3},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
};

enum {
  ts_external_token__string_start = 0,
  ts_external_token__string_content = 1,
  ts_external_token__string_end = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static const bool ts_external_scanner_states[5][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
  },
  [3] = {
    [ts_external_token__string_end] = true,
  },
  [4] = {
    [ts_external_token__string_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_importstr] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [sym_dollar] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_local] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [sym__single] = ACTIONS(1),
    [sym__double] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(364),
    [sym_expr] = STATE(173),
    [sym_local_bind] = STATE(162),
    [sym_anonymous_function] = STATE(162),
    [sym_import] = STATE(162),
    [sym_importstr] = STATE(162),
    [sym_expr_error] = STATE(162),
    [sym_assert] = STATE(363),
    [sym_unaryop] = STATE(28),
    [sym_string] = STATE(162),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_function] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_importstr] = ACTIONS(17),
    [anon_sym_error] = ACTIONS(19),
    [sym_null] = ACTIONS(21),
    [sym_true] = ACTIONS(21),
    [sym_false] = ACTIONS(21),
    [sym_self] = ACTIONS(21),
    [sym_dollar] = ACTIONS(23),
    [sym_super] = ACTIONS(25),
    [sym_local] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_assert] = ACTIONS(31),
    [sym_id] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_number] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(35),
    [sym__single] = ACTIONS(37),
    [sym__double] = ACTIONS(39),
    [sym__string_start] = ACTIONS(41),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(69), 1,
      sym_id,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(147), 1,
      sym_expr,
    STATE(317), 1,
      sym_named_argument,
    STATE(346), 1,
      sym_args,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 4,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [96] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(69), 1,
      sym_id,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(48), 1,
      sym_unaryop,
    STATE(147), 1,
      sym_expr,
    STATE(317), 1,
      sym_named_argument,
    STATE(334), 1,
      sym_args,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 4,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [192] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(83), 1,
      anon_sym_for,
    STATE(48), 1,
      sym_unaryop,
    STATE(129), 1,
      sym_expr,
    STATE(217), 1,
      sym_forspec,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [286] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(83), 1,
      anon_sym_for,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(129), 1,
      sym_expr,
    STATE(204), 1,
      sym_forspec,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [380] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(87), 1,
      anon_sym_COLON,
    STATE(48), 1,
      sym_unaryop,
    STATE(154), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [471] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(79), 1,
      anon_sym_RBRACK,
    ACTIONS(89), 1,
      anon_sym_COLON,
    STATE(48), 1,
      sym_unaryop,
    STATE(151), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [562] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(49), 1,
      anon_sym_RBRACK,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(91), 1,
      anon_sym_COLON,
    STATE(48), 1,
      sym_unaryop,
    STATE(149), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [653] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(93), 1,
      anon_sym_RBRACK,
    ACTIONS(95), 1,
      anon_sym_COLON,
    STATE(48), 1,
      sym_unaryop,
    STATE(128), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [744] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(97), 1,
      anon_sym_COLON,
    STATE(48), 1,
      sym_unaryop,
    STATE(145), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [835] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(99), 1,
      anon_sym_RBRACK,
    ACTIONS(101), 1,
      anon_sym_COLON,
    STATE(48), 1,
      sym_unaryop,
    STATE(142), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [926] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(69), 1,
      sym_id,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(48), 1,
      sym_unaryop,
    STATE(140), 1,
      sym_expr,
    STATE(313), 1,
      sym_named_argument,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 4,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1019] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(105), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(192), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1107] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(107), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(190), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1195] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(99), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(129), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1283] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(93), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(170), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1371] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(109), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(171), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1459] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(111), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(184), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1547] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(113), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(109), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1635] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(115), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(108), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1723] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(99), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(175), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1811] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    ACTIONS(93), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      sym_unaryop,
    STATE(129), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1899] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(87), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [1984] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(138), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2069] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(150), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2154] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(85), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2239] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(84), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2324] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(139), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2409] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(158), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2494] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(174), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2579] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(181), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2664] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(86), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2749] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(112), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2834] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(115), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [2919] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(117), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3004] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(118), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3089] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(141), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3174] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(78), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3259] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(179), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3344] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(164), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3429] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(167), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3514] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(177), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3599] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(163), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3684] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(123), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3769] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(157), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3854] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(178), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [3939] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(119), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4024] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(80), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4109] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(111), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4194] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(83), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4279] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(126), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4364] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(136), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4449] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(116), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4534] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(172), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4619] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(146), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4704] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(131), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4789] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(114), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4874] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(144), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [4959] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(143), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5044] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(125), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5129] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(81), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5214] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(122), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5299] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(132), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5384] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(152), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5469] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(79), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5554] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(121), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5639] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(127), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5724] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(168), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5809] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(82), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5894] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(186), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [5979] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(188), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6064] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(155), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6149] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(135), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6234] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(43), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_importstr,
    ACTIONS(59), 1,
      anon_sym_error,
    ACTIONS(65), 1,
      sym_super,
    ACTIONS(67), 1,
      sym_local,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(48), 1,
      sym_unaryop,
    STATE(129), 1,
      sym_expr,
    STATE(349), 1,
      sym_assert,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(63), 2,
      sym_dollar,
      sym_number,
    ACTIONS(61), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(103), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6319] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(153), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6404] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(133), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6489] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      anon_sym_LBRACE,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      anon_sym_if,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_importstr,
    ACTIONS(19), 1,
      anon_sym_error,
    ACTIONS(25), 1,
      sym_super,
    ACTIONS(27), 1,
      sym_local,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(28), 1,
      sym_unaryop,
    STATE(134), 1,
      sym_expr,
    STATE(363), 1,
      sym_assert,
    ACTIONS(23), 2,
      sym_dollar,
      sym_number,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(33), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(21), 5,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_id,
    STATE(162), 6,
      sym_local_bind,
      sym_anonymous_function,
      sym_import,
      sym_importstr,
      sym_expr_error,
      sym_string,
  [6574] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(119), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6630] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(133), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6686] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(137), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(135), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6740] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(141), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(139), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6794] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(143), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6850] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(147), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(145), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6904] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(149), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [6960] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(153), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(151), 23,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7014] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(157), 1,
      anon_sym_else,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(159), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(155), 22,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7070] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(161), 10,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(163), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(167), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7208] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(171), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(175), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(179), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(183), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(187), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(191), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(197), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(195), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(199), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7536] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(203), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(207), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(211), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7659] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(217), 1,
      anon_sym_LBRACK,
    ACTIONS(219), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(215), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(221), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(215), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(225), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(229), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(151), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(233), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_if,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_for,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [7950] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(237), 1,
      anon_sym_COMMA,
    ACTIONS(239), 1,
      anon_sym_for,
    STATE(50), 1,
      sym_binaryop,
    STATE(211), 1,
      sym_forspec,
    STATE(299), 1,
      aux_sym_expr_repeat1,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8009] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(241), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(218), 1,
      sym_forspec,
    STATE(295), 1,
      aux_sym_expr_repeat1,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 7,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(167), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8104] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(243), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8154] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(245), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(219), 1,
      sym_forspec,
    STATE(237), 1,
      aux_sym_objinside_repeat3,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 7,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(199), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8246] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(247), 4,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_if,
      anon_sym_for,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8296] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(249), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(214), 1,
      sym_forspec,
    STATE(268), 1,
      aux_sym_objinside_repeat3,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8352] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(251), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(209), 1,
      sym_forspec,
    STATE(267), 1,
      aux_sym_objinside_repeat3,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8408] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(253), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(208), 1,
      sym_forspec,
    STATE(265), 1,
      aux_sym_objinside_repeat3,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8464] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(255), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(215), 1,
      sym_forspec,
    STATE(263), 1,
      aux_sym_objinside_repeat3,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8520] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(259), 1,
      anon_sym_COLON,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(257), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 7,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(225), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8608] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(261), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8658] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(263), 4,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_if,
      anon_sym_for,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8708] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(265), 1,
      anon_sym_COMMA,
    STATE(50), 1,
      sym_binaryop,
    STATE(212), 1,
      sym_forspec,
    STATE(248), 1,
      aux_sym_objinside_repeat3,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 7,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(233), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8800] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(267), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_for,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8850] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(269), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8899] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(271), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8947] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(273), 1,
      anon_sym_COLON,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8997] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(275), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 11,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_dollar,
      anon_sym_BANG,
      anon_sym_TILDE,
      sym_number,
      anon_sym_AT,
      sym__single,
      sym__double,
    ACTIONS(279), 15,
      anon_sym_if,
      anon_sym_function,
      anon_sym_import,
      anon_sym_importstr,
      anon_sym_error,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_super,
      sym_local,
      anon_sym_PLUS,
      anon_sym_assert,
      sym_id,
      anon_sym_DASH,
  [9079] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(281), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9127] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(149), 2,
      ts_builtin_sym_end,
      anon_sym_else,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9175] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    ACTIONS(293), 1,
      anon_sym_else,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(159), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(155), 14,
      ts_builtin_sym_end,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9223] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(119), 2,
      ts_builtin_sym_end,
      anon_sym_else,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9271] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(141), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(139), 15,
      ts_builtin_sym_end,
      anon_sym_else,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9317] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(161), 2,
      ts_builtin_sym_end,
      anon_sym_else,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 11,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_dollar,
      anon_sym_BANG,
      anon_sym_TILDE,
      sym_number,
      anon_sym_AT,
      sym__single,
      sym__double,
    ACTIONS(297), 15,
      anon_sym_if,
      anon_sym_function,
      anon_sym_import,
      anon_sym_importstr,
      anon_sym_error,
      sym_null,
      sym_true,
      sym_false,
      sym_self,
      sym_super,
      sym_local,
      anon_sym_PLUS,
      anon_sym_assert,
      sym_id,
      anon_sym_DASH,
  [9399] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(299), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9447] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(137), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(135), 15,
      ts_builtin_sym_end,
      anon_sym_else,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9493] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(301), 1,
      anon_sym_COMMA,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9543] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(305), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9591] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(307), 1,
      anon_sym_COLON,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9641] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(153), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(151), 15,
      ts_builtin_sym_end,
      anon_sym_else,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9687] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(147), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(145), 15,
      ts_builtin_sym_end,
      anon_sym_else,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9733] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_RBRACK,
    ACTIONS(101), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9783] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(309), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9831] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(311), 1,
      anon_sym_COMMA,
    ACTIONS(313), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9881] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 1,
      anon_sym_EQ,
    ACTIONS(219), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(215), 20,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9917] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(317), 1,
      anon_sym_COLON,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9967] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(143), 2,
      ts_builtin_sym_end,
      anon_sym_else,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10015] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(319), 1,
      anon_sym_COLON,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10065] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(321), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10113] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(133), 2,
      ts_builtin_sym_end,
      anon_sym_else,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10161] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_RBRACK,
    ACTIONS(95), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10211] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(211), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10291] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(323), 1,
      anon_sym_then,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10338] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(325), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(203), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10418] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(163), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(175), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(215), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10517] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10564] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(171), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10644] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(327), 1,
      anon_sym_LBRACK,
    ACTIONS(219), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(215), 18,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10681] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(329), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10728] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(331), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(207), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10808] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10855] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10902] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(333), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10949] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_DOT,
    ACTIONS(289), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 1,
      anon_sym_in,
    ACTIONS(335), 1,
      ts_builtin_sym_end,
    STATE(58), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10996] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(337), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11043] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(197), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(195), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11123] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(339), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11170] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11217] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(341), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11264] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(151), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11297] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(343), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(179), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(221), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11410] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(345), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(187), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11490] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(347), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(229), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11570] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(349), 1,
      anon_sym_then,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(191), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11650] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    ACTIONS(351), 1,
      anon_sym_RBRACK,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(183), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_else,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11730] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      anon_sym_RBRACK,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(121), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_in,
    STATE(50), 1,
      sym_binaryop,
    ACTIONS(131), 5,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(129), 13,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [11777] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(113), 1,
      anon_sym_RBRACE,
    ACTIONS(353), 1,
      anon_sym_LBRACK,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(260), 1,
      aux_sym_objinside_repeat2,
    STATE(273), 1,
      sym_member,
    STATE(314), 1,
      sym_objlocal,
    STATE(312), 2,
      sym_field,
      sym_assert,
  [11827] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(115), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(359), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(234), 1,
      aux_sym_objinside_repeat2,
    STATE(281), 1,
      sym_member,
    STATE(314), 1,
      sym_objlocal,
    STATE(312), 2,
      sym_field,
      sym_assert,
  [11877] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [11922] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [11967] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(363), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(233), 1,
      aux_sym_objinside_repeat2,
    STATE(305), 1,
      sym_member,
    STATE(314), 1,
      sym_objlocal,
    STATE(312), 2,
      sym_field,
      sym_assert,
  [12014] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [12059] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [12104] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(105), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [12149] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(254), 1,
      aux_sym_objinside_repeat2,
    STATE(293), 1,
      sym_member,
    STATE(314), 1,
      sym_objlocal,
    STATE(312), 2,
      sym_field,
      sym_assert,
  [12196] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [12241] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_assert,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    ACTIONS(355), 1,
      sym_local,
    ACTIONS(357), 1,
      sym_id,
    ACTIONS(361), 1,
      anon_sym_LBRACK,
    STATE(225), 1,
      sym_fieldname,
    STATE(230), 1,
      sym_string,
    STATE(319), 1,
      sym_member,
    STATE(312), 3,
      sym_field,
      sym_objlocal,
      sym_assert,
  [12283] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_RBRACK,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    STATE(325), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12304] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(369), 1,
      anon_sym_RBRACE,
    STATE(333), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12325] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(371), 1,
      anon_sym_RBRACE,
    STATE(335), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12346] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(373), 1,
      anon_sym_RBRACE,
    STATE(367), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12367] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(375), 1,
      anon_sym_RBRACE,
    STATE(329), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12388] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(377), 1,
      anon_sym_RBRACE,
    STATE(371), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12409] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(379), 1,
      anon_sym_RBRACE,
    STATE(368), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12430] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    STATE(337), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12451] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(345), 1,
      anon_sym_RBRACE,
    ACTIONS(367), 1,
      anon_sym_if,
    STATE(366), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12472] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(381), 2,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    STATE(216), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12491] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(383), 1,
      anon_sym_RBRACE,
    STATE(331), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12512] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(351), 1,
      anon_sym_RBRACE,
    ACTIONS(367), 1,
      anon_sym_if,
    STATE(328), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12533] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 1,
      anon_sym_if,
    ACTIONS(390), 1,
      anon_sym_for,
    ACTIONS(385), 2,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    STATE(216), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12552] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_RBRACK,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    STATE(356), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12573] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    STATE(352), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12594] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(367), 1,
      anon_sym_if,
    ACTIONS(393), 1,
      anon_sym_RBRACE,
    STATE(370), 1,
      sym_compspec,
    STATE(213), 3,
      sym_forspec,
      sym_ifspec,
      aux_sym_compspec_repeat1,
  [12615] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 1,
      anon_sym_COLON,
    ACTIONS(399), 1,
      anon_sym_COLON_COLON,
    ACTIONS(397), 3,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
  [12630] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(93), 1,
      sym_string,
  [12649] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 1,
      anon_sym_AT,
    ACTIONS(73), 1,
      sym__single,
    ACTIONS(75), 1,
      sym__double,
    ACTIONS(77), 1,
      sym__string_start,
    STATE(95), 1,
      sym_string,
  [12668] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_COLON_COLON,
    ACTIONS(401), 1,
      anon_sym_COLON,
    ACTIONS(397), 3,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
  [12683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_COLON_COLON,
    ACTIONS(403), 1,
      anon_sym_COLON,
    ACTIONS(397), 3,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
  [12698] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 1,
      anon_sym_LPAREN,
    ACTIONS(409), 1,
      anon_sym_PLUS,
    ACTIONS(411), 1,
      anon_sym_COLON_COLON_COLON,
    ACTIONS(405), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
  [12715] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(191), 1,
      sym_string,
  [12734] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(397), 3,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
  [12747] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_AT,
    ACTIONS(37), 1,
      sym__single,
    ACTIONS(39), 1,
      sym__double,
    ACTIONS(41), 1,
      sym__string_start,
    STATE(189), 1,
      sym_string,
  [12766] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_COLON_COLON,
    ACTIONS(413), 1,
      anon_sym_COLON,
    ACTIONS(397), 3,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
  [12781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
    ACTIONS(417), 3,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_COLON_COLON_COLON,
  [12794] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(421), 1,
      sym__double,
    STATE(253), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [12808] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 1,
      anon_sym_RPAREN,
    ACTIONS(427), 1,
      sym_id,
    STATE(303), 1,
      sym_param,
    STATE(327), 1,
      sym_params,
  [12824] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      sym_local,
    STATE(242), 1,
      aux_sym_objinside_repeat2,
    STATE(330), 1,
      sym_objlocal,
  [12840] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_local,
    ACTIONS(433), 1,
      anon_sym_LBRACK,
    STATE(242), 1,
      aux_sym_objinside_repeat2,
    STATE(330), 1,
      sym_objlocal,
  [12856] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(435), 1,
      sym__single,
    STATE(252), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [12870] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(210), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [12886] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(439), 1,
      anon_sym_COMMA,
    STATE(210), 1,
      sym_forspec,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [12902] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(435), 1,
      sym__double,
    STATE(253), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [12916] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(207), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [12932] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_id,
    ACTIONS(441), 1,
      anon_sym_RPAREN,
    STATE(303), 1,
      sym_param,
    STATE(350), 1,
      sym_params,
  [12948] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(443), 1,
      sym__single,
    STATE(235), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [12962] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      sym_local,
    STATE(242), 1,
      aux_sym_objinside_repeat2,
    STATE(330), 1,
      sym_objlocal,
  [12978] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_id,
    ACTIONS(450), 1,
      anon_sym_RPAREN,
    STATE(303), 1,
      sym_param,
    STATE(323), 1,
      sym_params,
  [12994] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(219), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [13010] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(443), 1,
      sym__double,
    STATE(238), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13024] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(452), 1,
      sym__double,
    STATE(253), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13038] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(452), 1,
      sym__single,
    STATE(252), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13052] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(251), 1,
      anon_sym_COMMA,
    STATE(209), 1,
      sym_forspec,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [13068] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(209), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [13084] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(454), 1,
      sym__single,
    STATE(251), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13098] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(421), 1,
      sym__single,
    STATE(252), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13112] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(456), 1,
      sym__single,
    STATE(252), 1,
      aux_sym__str_single,
    ACTIONS(458), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13126] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(461), 1,
      sym__double,
    STATE(253), 1,
      aux_sym__str_double,
    ACTIONS(463), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13140] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_local,
    ACTIONS(466), 1,
      anon_sym_LBRACK,
    STATE(242), 1,
      aux_sym_objinside_repeat2,
    STATE(330), 1,
      sym_objlocal,
  [13156] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(468), 1,
      sym__double,
    STATE(253), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13170] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(468), 1,
      sym__single,
    STATE(252), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13184] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(470), 1,
      sym__double,
    STATE(246), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13198] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(470), 1,
      sym__single,
    STATE(247), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13212] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_id,
    ACTIONS(472), 1,
      anon_sym_RPAREN,
    STATE(303), 1,
      sym_param,
    STATE(341), 1,
      sym_params,
  [13228] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_local,
    ACTIONS(474), 1,
      anon_sym_LBRACK,
    STATE(242), 1,
      aux_sym_objinside_repeat2,
    STATE(330), 1,
      sym_objlocal,
  [13244] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(206), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [13260] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(208), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [13276] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(253), 1,
      anon_sym_COMMA,
    STATE(208), 1,
      sym_forspec,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [13292] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(476), 1,
      sym__double,
    STATE(255), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13306] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(249), 1,
      anon_sym_COMMA,
    STATE(214), 1,
      sym_forspec,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [13322] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(214), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [13338] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(245), 1,
      anon_sym_COMMA,
    STATE(219), 1,
      sym_forspec,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [13354] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(478), 1,
      anon_sym_COMMA,
    STATE(205), 1,
      sym_forspec,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [13370] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(454), 1,
      sym__double,
    STATE(231), 1,
      aux_sym__str_double,
    ACTIONS(423), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13384] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_for,
    ACTIONS(431), 1,
      sym_local,
    STATE(205), 1,
      sym_forspec,
    STATE(308), 1,
      sym_objlocal,
  [13400] = 4,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(476), 1,
      sym__single,
    STATE(256), 1,
      aux_sym__str_single,
    ACTIONS(437), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 1,
      anon_sym_COLON_COLON_COLON,
    ACTIONS(480), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
  [13425] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      anon_sym_RBRACE,
    ACTIONS(484), 1,
      anon_sym_COMMA,
    STATE(284), 1,
      aux_sym_objinside_repeat1,
  [13438] = 3,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(486), 1,
      sym__single,
    ACTIONS(488), 2,
      aux_sym__str_single_token1,
      sym_escape_sequence,
  [13449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 1,
      anon_sym_COMMA,
    ACTIONS(492), 1,
      anon_sym_RPAREN,
    STATE(290), 1,
      aux_sym_params_repeat1,
  [13462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 1,
      anon_sym_RBRACK,
    ACTIONS(494), 1,
      anon_sym_COMMA,
    STATE(276), 1,
      aux_sym_expr_repeat1,
  [13475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 1,
      anon_sym_RBRACE,
    ACTIONS(499), 1,
      anon_sym_COMMA,
    STATE(277), 1,
      aux_sym_objinside_repeat1,
  [13488] = 3,
    ACTIONS(419), 1,
      sym_comment,
    ACTIONS(502), 1,
      sym__double,
    ACTIONS(504), 2,
      aux_sym__str_double_token1,
      sym_escape_sequence,
  [13499] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    ACTIONS(506), 1,
      anon_sym_COMMA,
    STATE(277), 1,
      aux_sym_objinside_repeat1,
  [13512] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    ACTIONS(508), 1,
      sym_id,
    STATE(313), 1,
      sym_named_argument,
  [13525] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    ACTIONS(510), 1,
      anon_sym_COMMA,
    STATE(296), 1,
      aux_sym_objinside_repeat1,
  [13538] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__single,
    ACTIONS(514), 1,
      sym__double,
    ACTIONS(516), 1,
      sym__string_start,
  [13551] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_for,
  [13560] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    ACTIONS(520), 1,
      anon_sym_COMMA,
    STATE(277), 1,
      aux_sym_objinside_repeat1,
  [13573] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_COLON_COLON_COLON,
    ACTIONS(522), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
  [13584] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(528), 1,
      anon_sym_SEMI,
    STATE(304), 1,
      aux_sym_local_bind_repeat1,
  [13597] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(530), 1,
      anon_sym_SEMI,
    STATE(302), 1,
      aux_sym_local_bind_repeat1,
  [13610] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_id,
    ACTIONS(492), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym_param,
  [13623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_id,
    ACTIONS(532), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym_param,
  [13636] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 1,
      anon_sym_COMMA,
    ACTIONS(537), 1,
      anon_sym_RPAREN,
    STATE(290), 1,
      aux_sym_params_repeat1,
  [13649] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 1,
      anon_sym_COLON_COLON_COLON,
    ACTIONS(539), 2,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
  [13660] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_COMMA,
    ACTIONS(546), 1,
      anon_sym_for,
    STATE(292), 1,
      aux_sym_objinside_repeat3,
  [13673] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    ACTIONS(520), 1,
      anon_sym_COMMA,
    STATE(279), 1,
      aux_sym_objinside_repeat1,
  [13686] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      sym__single,
    ACTIONS(550), 1,
      sym__double,
    ACTIONS(552), 1,
      sym__string_start,
  [13699] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(554), 1,
      anon_sym_COMMA,
    STATE(276), 1,
      aux_sym_expr_repeat1,
  [13712] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    STATE(277), 1,
      aux_sym_objinside_repeat1,
  [13725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_EQ,
    ACTIONS(558), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13736] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(565), 1,
      anon_sym_SEMI,
    STATE(298), 1,
      aux_sym_local_bind_repeat1,
  [13749] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(567), 1,
      anon_sym_COMMA,
    STATE(276), 1,
      aux_sym_expr_repeat1,
  [13762] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    ACTIONS(569), 1,
      anon_sym_COMMA,
    STATE(277), 1,
      aux_sym_objinside_repeat1,
  [13775] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 1,
      sym_id,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(306), 1,
      sym_named_argument,
  [13788] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(573), 1,
      anon_sym_SEMI,
    STATE(298), 1,
      aux_sym_local_bind_repeat1,
  [13801] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 1,
      anon_sym_COMMA,
    ACTIONS(577), 1,
      anon_sym_RPAREN,
    STATE(275), 1,
      aux_sym_params_repeat1,
  [13814] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(579), 1,
      anon_sym_SEMI,
    STATE(298), 1,
      aux_sym_local_bind_repeat1,
  [13827] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    STATE(300), 1,
      aux_sym_objinside_repeat1,
  [13840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_COMMA,
    ACTIONS(583), 1,
      anon_sym_RPAREN,
  [13850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_id,
    STATE(322), 1,
      sym_bind,
  [13860] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 2,
      anon_sym_COMMA,
      anon_sym_for,
  [13868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_id,
    STATE(283), 1,
      sym_bind,
  [13878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_id,
    STATE(287), 1,
      sym_bind,
  [13888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_id,
    STATE(315), 1,
      sym_param,
  [13898] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [13906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    ACTIONS(589), 1,
      anon_sym_COMMA,
  [13916] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [13924] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13932] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 2,
      anon_sym_LBRACK,
      sym_local,
  [13940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 1,
      anon_sym_RPAREN,
    ACTIONS(591), 1,
      anon_sym_COMMA,
  [13950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(595), 1,
      anon_sym_EQ,
  [13960] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [13968] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_local,
    STATE(308), 1,
      sym_objlocal,
  [13978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_id,
    STATE(286), 1,
      sym_bind,
  [13988] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [13996] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 1,
      anon_sym_RPAREN,
  [14003] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 1,
      sym_id,
  [14010] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      anon_sym_RBRACK,
  [14017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      sym_super,
  [14024] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      anon_sym_RPAREN,
  [14031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 1,
      anon_sym_RBRACE,
  [14038] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 1,
      anon_sym_RBRACE,
  [14045] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(603), 1,
      anon_sym_COMMA,
  [14052] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_RBRACE,
  [14059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      sym__string_end,
  [14066] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 1,
      anon_sym_RBRACE,
  [14073] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
  [14080] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_RBRACE,
  [14087] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      sym__string_content,
  [14094] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_RBRACK,
  [14101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_RPAREN,
  [14108] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
  [14115] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      sym__string_end,
  [14122] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      anon_sym_RPAREN,
  [14129] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 1,
      sym__string_content,
  [14136] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 1,
      sym__string_content,
  [14143] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_super,
  [14150] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_id,
  [14157] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
  [14164] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      sym__string_end,
  [14171] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      sym_id,
  [14178] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_SEMI,
  [14185] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_RPAREN,
  [14192] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 1,
      anon_sym_in,
  [14199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_RBRACK,
  [14206] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 1,
      sym__string_content,
  [14213] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_EQ,
  [14220] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      anon_sym_COLON,
  [14227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_RBRACK,
  [14234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_EQ,
  [14241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_EQ,
  [14248] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      anon_sym_COLON,
  [14255] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 1,
      anon_sym_COLON,
  [14262] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_COLON,
  [14269] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      sym__string_end,
  [14276] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 1,
      anon_sym_SEMI,
  [14283] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      ts_builtin_sym_end,
  [14290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
  [14297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 1,
      anon_sym_RBRACE,
  [14304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 1,
      anon_sym_RBRACE,
  [14311] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 1,
      anon_sym_RBRACE,
  [14318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_LPAREN,
  [14325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 1,
      anon_sym_RBRACE,
  [14332] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      anon_sym_RBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 96,
  [SMALL_STATE(4)] = 192,
  [SMALL_STATE(5)] = 286,
  [SMALL_STATE(6)] = 380,
  [SMALL_STATE(7)] = 471,
  [SMALL_STATE(8)] = 562,
  [SMALL_STATE(9)] = 653,
  [SMALL_STATE(10)] = 744,
  [SMALL_STATE(11)] = 835,
  [SMALL_STATE(12)] = 926,
  [SMALL_STATE(13)] = 1019,
  [SMALL_STATE(14)] = 1107,
  [SMALL_STATE(15)] = 1195,
  [SMALL_STATE(16)] = 1283,
  [SMALL_STATE(17)] = 1371,
  [SMALL_STATE(18)] = 1459,
  [SMALL_STATE(19)] = 1547,
  [SMALL_STATE(20)] = 1635,
  [SMALL_STATE(21)] = 1723,
  [SMALL_STATE(22)] = 1811,
  [SMALL_STATE(23)] = 1899,
  [SMALL_STATE(24)] = 1984,
  [SMALL_STATE(25)] = 2069,
  [SMALL_STATE(26)] = 2154,
  [SMALL_STATE(27)] = 2239,
  [SMALL_STATE(28)] = 2324,
  [SMALL_STATE(29)] = 2409,
  [SMALL_STATE(30)] = 2494,
  [SMALL_STATE(31)] = 2579,
  [SMALL_STATE(32)] = 2664,
  [SMALL_STATE(33)] = 2749,
  [SMALL_STATE(34)] = 2834,
  [SMALL_STATE(35)] = 2919,
  [SMALL_STATE(36)] = 3004,
  [SMALL_STATE(37)] = 3089,
  [SMALL_STATE(38)] = 3174,
  [SMALL_STATE(39)] = 3259,
  [SMALL_STATE(40)] = 3344,
  [SMALL_STATE(41)] = 3429,
  [SMALL_STATE(42)] = 3514,
  [SMALL_STATE(43)] = 3599,
  [SMALL_STATE(44)] = 3684,
  [SMALL_STATE(45)] = 3769,
  [SMALL_STATE(46)] = 3854,
  [SMALL_STATE(47)] = 3939,
  [SMALL_STATE(48)] = 4024,
  [SMALL_STATE(49)] = 4109,
  [SMALL_STATE(50)] = 4194,
  [SMALL_STATE(51)] = 4279,
  [SMALL_STATE(52)] = 4364,
  [SMALL_STATE(53)] = 4449,
  [SMALL_STATE(54)] = 4534,
  [SMALL_STATE(55)] = 4619,
  [SMALL_STATE(56)] = 4704,
  [SMALL_STATE(57)] = 4789,
  [SMALL_STATE(58)] = 4874,
  [SMALL_STATE(59)] = 4959,
  [SMALL_STATE(60)] = 5044,
  [SMALL_STATE(61)] = 5129,
  [SMALL_STATE(62)] = 5214,
  [SMALL_STATE(63)] = 5299,
  [SMALL_STATE(64)] = 5384,
  [SMALL_STATE(65)] = 5469,
  [SMALL_STATE(66)] = 5554,
  [SMALL_STATE(67)] = 5639,
  [SMALL_STATE(68)] = 5724,
  [SMALL_STATE(69)] = 5809,
  [SMALL_STATE(70)] = 5894,
  [SMALL_STATE(71)] = 5979,
  [SMALL_STATE(72)] = 6064,
  [SMALL_STATE(73)] = 6149,
  [SMALL_STATE(74)] = 6234,
  [SMALL_STATE(75)] = 6319,
  [SMALL_STATE(76)] = 6404,
  [SMALL_STATE(77)] = 6489,
  [SMALL_STATE(78)] = 6574,
  [SMALL_STATE(79)] = 6630,
  [SMALL_STATE(80)] = 6686,
  [SMALL_STATE(81)] = 6740,
  [SMALL_STATE(82)] = 6794,
  [SMALL_STATE(83)] = 6850,
  [SMALL_STATE(84)] = 6904,
  [SMALL_STATE(85)] = 6960,
  [SMALL_STATE(86)] = 7014,
  [SMALL_STATE(87)] = 7070,
  [SMALL_STATE(88)] = 7126,
  [SMALL_STATE(89)] = 7167,
  [SMALL_STATE(90)] = 7208,
  [SMALL_STATE(91)] = 7249,
  [SMALL_STATE(92)] = 7290,
  [SMALL_STATE(93)] = 7331,
  [SMALL_STATE(94)] = 7372,
  [SMALL_STATE(95)] = 7413,
  [SMALL_STATE(96)] = 7454,
  [SMALL_STATE(97)] = 7495,
  [SMALL_STATE(98)] = 7536,
  [SMALL_STATE(99)] = 7577,
  [SMALL_STATE(100)] = 7618,
  [SMALL_STATE(101)] = 7659,
  [SMALL_STATE(102)] = 7704,
  [SMALL_STATE(103)] = 7745,
  [SMALL_STATE(104)] = 7786,
  [SMALL_STATE(105)] = 7827,
  [SMALL_STATE(106)] = 7868,
  [SMALL_STATE(107)] = 7909,
  [SMALL_STATE(108)] = 7950,
  [SMALL_STATE(109)] = 8009,
  [SMALL_STATE(110)] = 8068,
  [SMALL_STATE(111)] = 8104,
  [SMALL_STATE(112)] = 8154,
  [SMALL_STATE(113)] = 8210,
  [SMALL_STATE(114)] = 8246,
  [SMALL_STATE(115)] = 8296,
  [SMALL_STATE(116)] = 8352,
  [SMALL_STATE(117)] = 8408,
  [SMALL_STATE(118)] = 8464,
  [SMALL_STATE(119)] = 8520,
  [SMALL_STATE(120)] = 8572,
  [SMALL_STATE(121)] = 8608,
  [SMALL_STATE(122)] = 8658,
  [SMALL_STATE(123)] = 8708,
  [SMALL_STATE(124)] = 8764,
  [SMALL_STATE(125)] = 8800,
  [SMALL_STATE(126)] = 8850,
  [SMALL_STATE(127)] = 8899,
  [SMALL_STATE(128)] = 8947,
  [SMALL_STATE(129)] = 8997,
  [SMALL_STATE(130)] = 9045,
  [SMALL_STATE(131)] = 9079,
  [SMALL_STATE(132)] = 9127,
  [SMALL_STATE(133)] = 9175,
  [SMALL_STATE(134)] = 9223,
  [SMALL_STATE(135)] = 9271,
  [SMALL_STATE(136)] = 9317,
  [SMALL_STATE(137)] = 9365,
  [SMALL_STATE(138)] = 9399,
  [SMALL_STATE(139)] = 9447,
  [SMALL_STATE(140)] = 9493,
  [SMALL_STATE(141)] = 9543,
  [SMALL_STATE(142)] = 9591,
  [SMALL_STATE(143)] = 9641,
  [SMALL_STATE(144)] = 9687,
  [SMALL_STATE(145)] = 9733,
  [SMALL_STATE(146)] = 9783,
  [SMALL_STATE(147)] = 9831,
  [SMALL_STATE(148)] = 9881,
  [SMALL_STATE(149)] = 9917,
  [SMALL_STATE(150)] = 9967,
  [SMALL_STATE(151)] = 10015,
  [SMALL_STATE(152)] = 10065,
  [SMALL_STATE(153)] = 10113,
  [SMALL_STATE(154)] = 10161,
  [SMALL_STATE(155)] = 10211,
  [SMALL_STATE(156)] = 10258,
  [SMALL_STATE(157)] = 10291,
  [SMALL_STATE(158)] = 10338,
  [SMALL_STATE(159)] = 10385,
  [SMALL_STATE(160)] = 10418,
  [SMALL_STATE(161)] = 10451,
  [SMALL_STATE(162)] = 10484,
  [SMALL_STATE(163)] = 10517,
  [SMALL_STATE(164)] = 10564,
  [SMALL_STATE(165)] = 10611,
  [SMALL_STATE(166)] = 10644,
  [SMALL_STATE(167)] = 10681,
  [SMALL_STATE(168)] = 10728,
  [SMALL_STATE(169)] = 10775,
  [SMALL_STATE(170)] = 10808,
  [SMALL_STATE(171)] = 10855,
  [SMALL_STATE(172)] = 10902,
  [SMALL_STATE(173)] = 10949,
  [SMALL_STATE(174)] = 10996,
  [SMALL_STATE(175)] = 11043,
  [SMALL_STATE(176)] = 11090,
  [SMALL_STATE(177)] = 11123,
  [SMALL_STATE(178)] = 11170,
  [SMALL_STATE(179)] = 11217,
  [SMALL_STATE(180)] = 11264,
  [SMALL_STATE(181)] = 11297,
  [SMALL_STATE(182)] = 11344,
  [SMALL_STATE(183)] = 11377,
  [SMALL_STATE(184)] = 11410,
  [SMALL_STATE(185)] = 11457,
  [SMALL_STATE(186)] = 11490,
  [SMALL_STATE(187)] = 11537,
  [SMALL_STATE(188)] = 11570,
  [SMALL_STATE(189)] = 11617,
  [SMALL_STATE(190)] = 11650,
  [SMALL_STATE(191)] = 11697,
  [SMALL_STATE(192)] = 11730,
  [SMALL_STATE(193)] = 11777,
  [SMALL_STATE(194)] = 11827,
  [SMALL_STATE(195)] = 11877,
  [SMALL_STATE(196)] = 11922,
  [SMALL_STATE(197)] = 11967,
  [SMALL_STATE(198)] = 12014,
  [SMALL_STATE(199)] = 12059,
  [SMALL_STATE(200)] = 12104,
  [SMALL_STATE(201)] = 12149,
  [SMALL_STATE(202)] = 12196,
  [SMALL_STATE(203)] = 12241,
  [SMALL_STATE(204)] = 12283,
  [SMALL_STATE(205)] = 12304,
  [SMALL_STATE(206)] = 12325,
  [SMALL_STATE(207)] = 12346,
  [SMALL_STATE(208)] = 12367,
  [SMALL_STATE(209)] = 12388,
  [SMALL_STATE(210)] = 12409,
  [SMALL_STATE(211)] = 12430,
  [SMALL_STATE(212)] = 12451,
  [SMALL_STATE(213)] = 12472,
  [SMALL_STATE(214)] = 12491,
  [SMALL_STATE(215)] = 12512,
  [SMALL_STATE(216)] = 12533,
  [SMALL_STATE(217)] = 12552,
  [SMALL_STATE(218)] = 12573,
  [SMALL_STATE(219)] = 12594,
  [SMALL_STATE(220)] = 12615,
  [SMALL_STATE(221)] = 12630,
  [SMALL_STATE(222)] = 12649,
  [SMALL_STATE(223)] = 12668,
  [SMALL_STATE(224)] = 12683,
  [SMALL_STATE(225)] = 12698,
  [SMALL_STATE(226)] = 12715,
  [SMALL_STATE(227)] = 12734,
  [SMALL_STATE(228)] = 12747,
  [SMALL_STATE(229)] = 12766,
  [SMALL_STATE(230)] = 12781,
  [SMALL_STATE(231)] = 12794,
  [SMALL_STATE(232)] = 12808,
  [SMALL_STATE(233)] = 12824,
  [SMALL_STATE(234)] = 12840,
  [SMALL_STATE(235)] = 12856,
  [SMALL_STATE(236)] = 12870,
  [SMALL_STATE(237)] = 12886,
  [SMALL_STATE(238)] = 12902,
  [SMALL_STATE(239)] = 12916,
  [SMALL_STATE(240)] = 12932,
  [SMALL_STATE(241)] = 12948,
  [SMALL_STATE(242)] = 12962,
  [SMALL_STATE(243)] = 12978,
  [SMALL_STATE(244)] = 12994,
  [SMALL_STATE(245)] = 13010,
  [SMALL_STATE(246)] = 13024,
  [SMALL_STATE(247)] = 13038,
  [SMALL_STATE(248)] = 13052,
  [SMALL_STATE(249)] = 13068,
  [SMALL_STATE(250)] = 13084,
  [SMALL_STATE(251)] = 13098,
  [SMALL_STATE(252)] = 13112,
  [SMALL_STATE(253)] = 13126,
  [SMALL_STATE(254)] = 13140,
  [SMALL_STATE(255)] = 13156,
  [SMALL_STATE(256)] = 13170,
  [SMALL_STATE(257)] = 13184,
  [SMALL_STATE(258)] = 13198,
  [SMALL_STATE(259)] = 13212,
  [SMALL_STATE(260)] = 13228,
  [SMALL_STATE(261)] = 13244,
  [SMALL_STATE(262)] = 13260,
  [SMALL_STATE(263)] = 13276,
  [SMALL_STATE(264)] = 13292,
  [SMALL_STATE(265)] = 13306,
  [SMALL_STATE(266)] = 13322,
  [SMALL_STATE(267)] = 13338,
  [SMALL_STATE(268)] = 13354,
  [SMALL_STATE(269)] = 13370,
  [SMALL_STATE(270)] = 13384,
  [SMALL_STATE(271)] = 13400,
  [SMALL_STATE(272)] = 13414,
  [SMALL_STATE(273)] = 13425,
  [SMALL_STATE(274)] = 13438,
  [SMALL_STATE(275)] = 13449,
  [SMALL_STATE(276)] = 13462,
  [SMALL_STATE(277)] = 13475,
  [SMALL_STATE(278)] = 13488,
  [SMALL_STATE(279)] = 13499,
  [SMALL_STATE(280)] = 13512,
  [SMALL_STATE(281)] = 13525,
  [SMALL_STATE(282)] = 13538,
  [SMALL_STATE(283)] = 13551,
  [SMALL_STATE(284)] = 13560,
  [SMALL_STATE(285)] = 13573,
  [SMALL_STATE(286)] = 13584,
  [SMALL_STATE(287)] = 13597,
  [SMALL_STATE(288)] = 13610,
  [SMALL_STATE(289)] = 13623,
  [SMALL_STATE(290)] = 13636,
  [SMALL_STATE(291)] = 13649,
  [SMALL_STATE(292)] = 13660,
  [SMALL_STATE(293)] = 13673,
  [SMALL_STATE(294)] = 13686,
  [SMALL_STATE(295)] = 13699,
  [SMALL_STATE(296)] = 13712,
  [SMALL_STATE(297)] = 13725,
  [SMALL_STATE(298)] = 13736,
  [SMALL_STATE(299)] = 13749,
  [SMALL_STATE(300)] = 13762,
  [SMALL_STATE(301)] = 13775,
  [SMALL_STATE(302)] = 13788,
  [SMALL_STATE(303)] = 13801,
  [SMALL_STATE(304)] = 13814,
  [SMALL_STATE(305)] = 13827,
  [SMALL_STATE(306)] = 13840,
  [SMALL_STATE(307)] = 13850,
  [SMALL_STATE(308)] = 13860,
  [SMALL_STATE(309)] = 13868,
  [SMALL_STATE(310)] = 13878,
  [SMALL_STATE(311)] = 13888,
  [SMALL_STATE(312)] = 13898,
  [SMALL_STATE(313)] = 13906,
  [SMALL_STATE(314)] = 13916,
  [SMALL_STATE(315)] = 13924,
  [SMALL_STATE(316)] = 13932,
  [SMALL_STATE(317)] = 13940,
  [SMALL_STATE(318)] = 13950,
  [SMALL_STATE(319)] = 13960,
  [SMALL_STATE(320)] = 13968,
  [SMALL_STATE(321)] = 13978,
  [SMALL_STATE(322)] = 13988,
  [SMALL_STATE(323)] = 13996,
  [SMALL_STATE(324)] = 14003,
  [SMALL_STATE(325)] = 14010,
  [SMALL_STATE(326)] = 14017,
  [SMALL_STATE(327)] = 14024,
  [SMALL_STATE(328)] = 14031,
  [SMALL_STATE(329)] = 14038,
  [SMALL_STATE(330)] = 14045,
  [SMALL_STATE(331)] = 14052,
  [SMALL_STATE(332)] = 14059,
  [SMALL_STATE(333)] = 14066,
  [SMALL_STATE(334)] = 14073,
  [SMALL_STATE(335)] = 14080,
  [SMALL_STATE(336)] = 14087,
  [SMALL_STATE(337)] = 14094,
  [SMALL_STATE(338)] = 14101,
  [SMALL_STATE(339)] = 14108,
  [SMALL_STATE(340)] = 14115,
  [SMALL_STATE(341)] = 14122,
  [SMALL_STATE(342)] = 14129,
  [SMALL_STATE(343)] = 14136,
  [SMALL_STATE(344)] = 14143,
  [SMALL_STATE(345)] = 14150,
  [SMALL_STATE(346)] = 14157,
  [SMALL_STATE(347)] = 14164,
  [SMALL_STATE(348)] = 14171,
  [SMALL_STATE(349)] = 14178,
  [SMALL_STATE(350)] = 14185,
  [SMALL_STATE(351)] = 14192,
  [SMALL_STATE(352)] = 14199,
  [SMALL_STATE(353)] = 14206,
  [SMALL_STATE(354)] = 14213,
  [SMALL_STATE(355)] = 14220,
  [SMALL_STATE(356)] = 14227,
  [SMALL_STATE(357)] = 14234,
  [SMALL_STATE(358)] = 14241,
  [SMALL_STATE(359)] = 14248,
  [SMALL_STATE(360)] = 14255,
  [SMALL_STATE(361)] = 14262,
  [SMALL_STATE(362)] = 14269,
  [SMALL_STATE(363)] = 14276,
  [SMALL_STATE(364)] = 14283,
  [SMALL_STATE(365)] = 14290,
  [SMALL_STATE(366)] = 14297,
  [SMALL_STATE(367)] = 14304,
  [SMALL_STATE(368)] = 14311,
  [SMALL_STATE(369)] = 14318,
  [SMALL_STATE(370)] = 14325,
  [SMALL_STATE(371)] = 14332,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 2),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_function, 4, .production_id = 8),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_function, 5, .production_id = 11),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 2, .production_id = 2),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 2, .production_id = 2),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 6, .production_id = 12),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 6, .production_id = 12),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_bind, 5),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3, .production_id = 6),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3, .production_id = 6),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_error, 2),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3),
  [153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 4, .production_id = 7),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 4, .production_id = 7),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_bind, 4),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 12),
  [165] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 12),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, .production_id = 5),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, .production_id = 5),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 10),
  [173] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 10),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 11),
  [177] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 11),
  [179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 4),
  [181] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 4),
  [183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_importstr, 2),
  [185] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_importstr, 2),
  [187] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 7),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 7),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 2),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 2),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 13),
  [197] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 13),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 4, .production_id = 9),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 4, .production_id = 9),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 5),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 5),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 9),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 9),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 2),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 2),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 1),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 1),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 8),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 8),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, .production_id = 1),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, .production_id = 1),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 6),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 6),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, .production_id = 3),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, .production_id = 3),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bind, 6, .production_id = 14),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ifspec, 2),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert, 2),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bind, 5, .production_id = 13),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_forspec, 4),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bind, 3),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert, 4),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_expr_repeat1, 2),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryop, 1),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unaryop, 1),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 6),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryop, 1),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binaryop, 1),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 3),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_argument, 3),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 1),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 3, .production_id = 10),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compspec, 1),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compspec_repeat1, 2),
  [387] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compspec_repeat1, 2), SHIFT_REPEAT(57),
  [390] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compspec_repeat1, 2), SHIFT_REPEAT(324),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fieldname, 3),
  [399] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fieldname, 3),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fieldname, 1),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fieldname, 1),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_objinside_repeat2, 2),
  [447] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_objinside_repeat2, 2), SHIFT_REPEAT(309),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__str_single, 2),
  [458] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__str_single, 2), SHIFT_REPEAT(274),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__str_double, 2),
  [463] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__str_double, 2), SHIFT_REPEAT(278),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__str_single, 1),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__str_single, 1),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_params, 2),
  [494] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_expr_repeat1, 2), SHIFT_REPEAT(74),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_objinside_repeat1, 2),
  [499] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_objinside_repeat1, 2), SHIFT_REPEAT(203),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__str_double, 1),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__str_double, 1),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objlocal, 2),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_params, 3),
  [534] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_params_repeat1, 2), SHIFT_REPEAT(311),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_params_repeat1, 2),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [543] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_objinside_repeat3, 2), SHIFT_REPEAT(320),
  [546] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_objinside_repeat3, 2),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 1, .production_id = 4),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [562] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_local_bind_repeat1, 2), SHIFT_REPEAT(307),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_local_bind_repeat1, 2),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 4),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_params, 1),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 5),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member, 1),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 6),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [651] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_jsonnet_external_scanner_create(void);
void tree_sitter_jsonnet_external_scanner_destroy(void *);
bool tree_sitter_jsonnet_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_jsonnet_external_scanner_serialize(void *, char *);
void tree_sitter_jsonnet_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_jsonnet(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_jsonnet_external_scanner_create,
      tree_sitter_jsonnet_external_scanner_destroy,
      tree_sitter_jsonnet_external_scanner_scan,
      tree_sitter_jsonnet_external_scanner_serialize,
      tree_sitter_jsonnet_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
