#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 74
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 69
#define ALIAS_COUNT 0
#define TOKEN_COUNT 38
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 13
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 12

enum {
  sym_identifier = 1,
  anon_sym_EQ = 2,
  anon_sym_PLUS_EQ = 3,
  anon_sym_DASH_EQ = 4,
  anon_sym_LPAREN = 5,
  anon_sym_RPAREN = 6,
  sym_negation_unary_op = 7,
  anon_sym_PLUS = 8,
  anon_sym_DASH = 9,
  anon_sym_LT = 10,
  anon_sym_LT_EQ = 11,
  anon_sym_GT = 12,
  anon_sym_GT_EQ = 13,
  anon_sym_EQ_EQ = 14,
  anon_sym_BANG_EQ = 15,
  sym_logical_and_binary_op = 16,
  sym_logical_or_binary_op = 17,
  anon_sym_COMMA = 18,
  anon_sym_LBRACK = 19,
  anon_sym_RBRACK = 20,
  anon_sym_DOT = 21,
  anon_sym_if = 22,
  anon_sym_else = 23,
  anon_sym_LBRACE = 24,
  anon_sym_RBRACE = 25,
  sym_integer = 26,
  anon_sym_true = 27,
  anon_sym_false = 28,
  anon_sym_DQUOTE = 29,
  aux_sym_string_content_token1 = 30,
  sym_string_escape = 31,
  sym__string_backslash = 32,
  anon_sym_DOLLAR = 33,
  aux_sym_string_expansion_token1 = 34,
  aux_sym_string_expansion_token2 = 35,
  anon_sym_DOLLAR_LBRACE = 36,
  sym_comment = 37,
  sym_source_file = 38,
  sym__statement = 39,
  sym_assign_op = 40,
  sym__lvalue = 41,
  sym_assignment = 42,
  sym_call = 43,
  sym_unary_expr = 44,
  sym_arithmetic_binary_op = 45,
  sym_comparison_binary_op = 46,
  sym_equivalence_binary_op = 47,
  sym_arithmetic_binary_expr = 48,
  sym_comparison_binary_expr = 49,
  sym_equivalence_binary_expr = 50,
  sym_logical_and_binary_expr = 51,
  sym_logical_or_binary_expr = 52,
  sym__expr = 53,
  sym__expr_list = 54,
  sym__primary_expr = 55,
  sym_array_access = 56,
  sym_scope_access = 57,
  sym_paren_expr = 58,
  sym_array_expr = 59,
  sym_condition = 60,
  sym_block = 61,
  sym_boolean = 62,
  sym_string = 63,
  sym_string_content = 64,
  sym_string_expansion = 65,
  aux_sym_source_file_repeat1 = 66,
  aux_sym_unary_expr_repeat1 = 67,
  aux_sym_string_content_repeat1 = 68,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_negation_unary_op] = "negation_unary_op",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [sym_logical_and_binary_op] = "logical_and_binary_op",
  [sym_logical_or_binary_op] = "logical_or_binary_op",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_integer] = "integer",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_content_token1] = "string_content_token1",
  [sym_string_escape] = "string_escape",
  [sym__string_backslash] = "_string_backslash",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_string_expansion_token1] = "identifier",
  [aux_sym_string_expansion_token2] = "hex",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym_assign_op] = "assign_op",
  [sym__lvalue] = "_lvalue",
  [sym_assignment] = "assignment",
  [sym_call] = "call",
  [sym_unary_expr] = "unary_expr",
  [sym_arithmetic_binary_op] = "arithmetic_binary_op",
  [sym_comparison_binary_op] = "comparison_binary_op",
  [sym_equivalence_binary_op] = "equivalence_binary_op",
  [sym_arithmetic_binary_expr] = "arithmetic_binary_expr",
  [sym_comparison_binary_expr] = "comparison_binary_expr",
  [sym_equivalence_binary_expr] = "equivalence_binary_expr",
  [sym_logical_and_binary_expr] = "logical_and_binary_expr",
  [sym_logical_or_binary_expr] = "logical_or_binary_expr",
  [sym__expr] = "_expr",
  [sym__expr_list] = "_expr_list",
  [sym__primary_expr] = "_primary_expr",
  [sym_array_access] = "array_access",
  [sym_scope_access] = "scope_access",
  [sym_paren_expr] = "paren_expr",
  [sym_array_expr] = "array_expr",
  [sym_condition] = "condition",
  [sym_block] = "block",
  [sym_boolean] = "boolean",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_string_expansion] = "string_expansion",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_unary_expr_repeat1] = "unary_expr_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_negation_unary_op] = sym_negation_unary_op,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [sym_logical_and_binary_op] = sym_logical_and_binary_op,
  [sym_logical_or_binary_op] = sym_logical_or_binary_op,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_integer] = sym_integer,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_content_token1] = aux_sym_string_content_token1,
  [sym_string_escape] = sym_string_escape,
  [sym__string_backslash] = sym__string_backslash,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_string_expansion_token1] = sym_identifier,
  [aux_sym_string_expansion_token2] = aux_sym_string_expansion_token2,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym_assign_op] = sym_assign_op,
  [sym__lvalue] = sym__lvalue,
  [sym_assignment] = sym_assignment,
  [sym_call] = sym_call,
  [sym_unary_expr] = sym_unary_expr,
  [sym_arithmetic_binary_op] = sym_arithmetic_binary_op,
  [sym_comparison_binary_op] = sym_comparison_binary_op,
  [sym_equivalence_binary_op] = sym_equivalence_binary_op,
  [sym_arithmetic_binary_expr] = sym_arithmetic_binary_expr,
  [sym_comparison_binary_expr] = sym_comparison_binary_expr,
  [sym_equivalence_binary_expr] = sym_equivalence_binary_expr,
  [sym_logical_and_binary_expr] = sym_logical_and_binary_expr,
  [sym_logical_or_binary_expr] = sym_logical_or_binary_expr,
  [sym__expr] = sym__expr,
  [sym__expr_list] = sym__expr_list,
  [sym__primary_expr] = sym__primary_expr,
  [sym_array_access] = sym_array_access,
  [sym_scope_access] = sym_scope_access,
  [sym_paren_expr] = sym_paren_expr,
  [sym_array_expr] = sym_array_expr,
  [sym_condition] = sym_condition,
  [sym_block] = sym_block,
  [sym_boolean] = sym_boolean,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_string_expansion] = sym_string_expansion,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_unary_expr_repeat1] = aux_sym_unary_expr_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_negation_unary_op] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_logical_and_binary_op] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or_binary_op] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym__string_backslash] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_expansion_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_expansion_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_assign_op] = {
    .visible = true,
    .named = true,
  },
  [sym__lvalue] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_arithmetic_binary_op] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_binary_op] = {
    .visible = true,
    .named = true,
  },
  [sym_equivalence_binary_op] = {
    .visible = true,
    .named = true,
  },
  [sym_arithmetic_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_equivalence_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_and_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym__expr_list] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_scope_access] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unary_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_args = 1,
  field_block = 2,
  field_body = 3,
  field_cond = 4,
  field_else_body = 5,
  field_else_if = 6,
  field_expr = 7,
  field_field = 8,
  field_index = 9,
  field_lhs = 10,
  field_op = 11,
  field_rhs = 12,
  field_target = 13,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_args] = "args",
  [field_block] = "block",
  [field_body] = "body",
  [field_cond] = "cond",
  [field_else_body] = "else_body",
  [field_else_if] = "else_if",
  [field_expr] = "expr",
  [field_field] = "field",
  [field_index] = "index",
  [field_lhs] = "lhs",
  [field_op] = "op",
  [field_rhs] = "rhs",
  [field_target] = "target",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 3},
  [4] = {.index = 6, .length = 2},
  [5] = {.index = 8, .length = 2},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 3},
  [9] = {.index = 17, .length = 3},
  [10] = {.index = 20, .length = 3},
  [11] = {.index = 23, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_target, 0},
  [1] =
    {field_field, 2},
    {field_target, 0},
  [3] =
    {field_expr, 2},
    {field_op, 1},
    {field_target, 0},
  [6] =
    {field_block, 3},
    {field_target, 0},
  [8] =
    {field_args, 2},
    {field_target, 0},
  [10] =
    {field_index, 2},
    {field_target, 0},
  [12] =
    {field_body, 4},
    {field_cond, 2},
  [14] =
    {field_lhs, 0},
    {field_op, 1},
    {field_rhs, 2},
  [17] =
    {field_args, 2},
    {field_block, 4},
    {field_target, 0},
  [20] =
    {field_body, 4},
    {field_cond, 2},
    {field_else_if, 6},
  [23] =
    {field_body, 4},
    {field_cond, 2},
    {field_else_body, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(28);
      if (lookahead == '"') ADVANCE(50);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(7);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(26);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '.') ADVANCE(44);
      if (lookahead == '0') ADVANCE(13);
      if (lookahead == '<') ADVANCE(33);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == '[') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '|') ADVANCE(12);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(59);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '"') ADVANCE(50);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(51);
      if (lookahead != 0) ADVANCE(52);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '"') ADVANCE(50);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(51);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(52);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '"') ADVANCE(50);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(26);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '.') ADVANCE(44);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '[') ADVANCE(42);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '0') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '&') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(38);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(24);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 12:
      if (lookahead == '|') ADVANCE(40);
      END_STATE();
    case 13:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(16);
      END_STATE();
    case 14:
      if (lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '\\' ||
          lookahead == '|') ADVANCE(53);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 16:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 17:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(28);
      if (lookahead == '"') ADVANCE(50);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(7);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(26);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '.') ADVANCE(44);
      if (lookahead == '<') ADVANCE(33);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == '[') ADVANCE(42);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '|') ADVANCE(12);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 18:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '&') ADVANCE(7);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(26);
      if (lookahead == '+') ADVANCE(29);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == '-') ADVANCE(31);
      if (lookahead == '.') ADVANCE(44);
      if (lookahead == '<') ADVANCE(33);
      if (lookahead == '=') ADVANCE(11);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == '[') ADVANCE(42);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead == '|') ADVANCE(12);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 19:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '&') ADVANCE(7);
      if (lookahead == ')') ADVANCE(26);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '<') ADVANCE(33);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '|') ADVANCE(12);
      if (lookahead == '}') ADVANCE(46);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_negation_unary_op);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_negation_unary_op);
      if (lookahead == '=') ADVANCE(38);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(23);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(24);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(34);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(36);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_logical_and_binary_op);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_logical_or_binary_op);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(aux_sym_string_content_token1);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(51);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(52);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_string_escape);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym__string_backslash);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(58);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_string_expansion_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_string_expansion_token2);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'e') ADVANCE(1);
      if (lookahead == 'f') ADVANCE(2);
      if (lookahead == 'i') ADVANCE(3);
      if (lookahead == 't') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'l') ADVANCE(5);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(6);
      END_STATE();
    case 3:
      if (lookahead == 'f') ADVANCE(7);
      END_STATE();
    case 4:
      if (lookahead == 'r') ADVANCE(8);
      END_STATE();
    case 5:
      if (lookahead == 's') ADVANCE(9);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(10);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 8:
      if (lookahead == 'u') ADVANCE(11);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(12);
      END_STATE();
    case 10:
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(14);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(15);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 4},
  [4] = {.lex_state = 4},
  [5] = {.lex_state = 4},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 4},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 18},
  [15] = {.lex_state = 18},
  [16] = {.lex_state = 18},
  [17] = {.lex_state = 18},
  [18] = {.lex_state = 18},
  [19] = {.lex_state = 19},
  [20] = {.lex_state = 19},
  [21] = {.lex_state = 18},
  [22] = {.lex_state = 18},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 18},
  [25] = {.lex_state = 18},
  [26] = {.lex_state = 18},
  [27] = {.lex_state = 18},
  [28] = {.lex_state = 18},
  [29] = {.lex_state = 18},
  [30] = {.lex_state = 18},
  [31] = {.lex_state = 18},
  [32] = {.lex_state = 18},
  [33] = {.lex_state = 18},
  [34] = {.lex_state = 18},
  [35] = {.lex_state = 18},
  [36] = {.lex_state = 18},
  [37] = {.lex_state = 18},
  [38] = {.lex_state = 18},
  [39] = {.lex_state = 18},
  [40] = {.lex_state = 18},
  [41] = {.lex_state = 18},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 4},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 2},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 2},
  [55] = {.lex_state = 2},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 5},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_negation_unary_op] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [sym_logical_and_binary_op] = ACTIONS(1),
    [sym_logical_or_binary_op] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_string_escape] = ACTIONS(1),
    [sym__string_backslash] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_string_expansion_token2] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(68),
    [sym__statement] = STATE(44),
    [sym__lvalue] = STATE(61),
    [sym_assignment] = STATE(44),
    [sym_call] = STATE(44),
    [sym_array_access] = STATE(61),
    [sym_scope_access] = STATE(61),
    [sym_condition] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_if] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    STATE(64), 1,
      sym__expr_list,
    ACTIONS(15), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(38), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [59] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    ACTIONS(29), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    STATE(67), 1,
      sym__expr_list,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(38), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [117] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    STATE(70), 1,
      sym__expr_list,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(38), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [175] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(29), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [227] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(41), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [279] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(18), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [331] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(40), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [383] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(39), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [435] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(21), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [487] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(15), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [539] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [591] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_negation_unary_op,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      sym_integer,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(14), 7,
      sym_unary_expr,
      sym_arithmetic_binary_expr,
      sym_comparison_binary_expr,
      sym_equivalence_binary_expr,
      sym_logical_and_binary_expr,
      sym_logical_or_binary_expr,
      sym__expr,
    STATE(28), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [643] = 9,
    ACTIONS(3), 1,
      sym_comment,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(35), 2,
      anon_sym_if,
      sym_identifier,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(33), 9,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [683] = 6,
    ACTIONS(3), 1,
      sym_comment,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(45), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(43), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [717] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DOT,
    ACTIONS(49), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(47), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [751] = 7,
    ACTIONS(3), 1,
      sym_comment,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(59), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(57), 11,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [787] = 10,
    ACTIONS(3), 1,
      sym_comment,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(63), 2,
      anon_sym_if,
      sym_identifier,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(61), 7,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 7,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(67), 13,
      ts_builtin_sym_end,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 7,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(71), 13,
      ts_builtin_sym_end,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [885] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_logical_and_binary_op,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(77), 2,
      anon_sym_if,
      sym_identifier,
    ACTIONS(75), 6,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [929] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(32), 1,
      sym_block,
    ACTIONS(83), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(81), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [960] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      sym_negation_unary_op,
    ACTIONS(87), 1,
      sym_integer,
    STATE(46), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(33), 9,
      sym_call,
      sym__primary_expr,
      sym_array_access,
      sym_scope_access,
      sym_paren_expr,
      sym_array_expr,
      sym_block,
      sym_boolean,
      sym_string,
  [1003] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(30), 1,
      sym_block,
    ACTIONS(91), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(89), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 5,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
    ACTIONS(93), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 5,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
    ACTIONS(97), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1086] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(101), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(105), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1136] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_logical_and_binary_op,
    ACTIONS(113), 1,
      sym_logical_or_binary_op,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(109), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(111), 2,
      anon_sym_if,
      sym_identifier,
  [1179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(115), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(119), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(123), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(127), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(131), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(135), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(141), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(139), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_if,
      sym_identifier,
    ACTIONS(143), 13,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_logical_and_binary_op,
      sym_logical_or_binary_op,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [1379] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_logical_and_binary_op,
    ACTIONS(113), 1,
      sym_logical_or_binary_op,
    ACTIONS(149), 1,
      anon_sym_COMMA,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(147), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1421] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_logical_and_binary_op,
    ACTIONS(113), 1,
      sym_logical_or_binary_op,
    ACTIONS(151), 1,
      anon_sym_RBRACK,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [1459] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_logical_and_binary_op,
    ACTIONS(113), 1,
      sym_logical_or_binary_op,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [1497] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      sym_logical_and_binary_op,
    ACTIONS(113), 1,
      sym_logical_or_binary_op,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_arithmetic_binary_op,
    STATE(12), 1,
      sym_comparison_binary_op,
    STATE(13), 1,
      sym_equivalence_binary_op,
    ACTIONS(37), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(65), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [1535] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym_if,
    ACTIONS(157), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    STATE(61), 3,
      sym__lvalue,
      sym_array_access,
      sym_scope_access,
    STATE(42), 5,
      sym__statement,
      sym_assignment,
      sym_call,
      sym_condition,
      aux_sym_source_file_repeat1,
  [1561] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_if,
    ACTIONS(165), 1,
      anon_sym_RBRACE,
    STATE(61), 3,
      sym__lvalue,
      sym_array_access,
      sym_scope_access,
    STATE(45), 5,
      sym__statement,
      sym_assignment,
      sym_call,
      sym_condition,
      aux_sym_source_file_repeat1,
  [1586] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_if,
    ACTIONS(167), 1,
      ts_builtin_sym_end,
    STATE(61), 3,
      sym__lvalue,
      sym_array_access,
      sym_scope_access,
    STATE(42), 5,
      sym__statement,
      sym_assignment,
      sym_call,
      sym_condition,
      aux_sym_source_file_repeat1,
  [1611] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_RBRACE,
    STATE(61), 3,
      sym__lvalue,
      sym_array_access,
      sym_scope_access,
    STATE(42), 5,
      sym__statement,
      sym_assignment,
      sym_call,
      sym_condition,
      aux_sym_source_file_repeat1,
  [1636] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      sym_negation_unary_op,
    STATE(46), 1,
      aux_sym_unary_expr_repeat1,
    ACTIONS(171), 3,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(173), 5,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_integer,
      anon_sym_DQUOTE,
  [1658] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(178), 3,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(180), 6,
      anon_sym_LPAREN,
      sym_negation_unary_op,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_integer,
      anon_sym_DQUOTE,
  [1675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 3,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(184), 6,
      anon_sym_LPAREN,
      sym_negation_unary_op,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_integer,
      anon_sym_DQUOTE,
  [1692] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(186), 3,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(188), 6,
      anon_sym_LPAREN,
      sym_negation_unary_op,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_integer,
      anon_sym_DQUOTE,
  [1709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(190), 3,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(192), 6,
      anon_sym_LPAREN,
      sym_negation_unary_op,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_integer,
      anon_sym_DQUOTE,
  [1726] = 7,
    ACTIONS(194), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_DOLLAR,
    ACTIONS(200), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(202), 1,
      sym_comment,
    STATE(71), 1,
      sym_string_content,
    STATE(53), 2,
      sym_string_expansion,
      aux_sym_string_content_repeat1,
    ACTIONS(196), 3,
      aux_sym_string_content_token1,
      sym_string_escape,
      sym__string_backslash,
  [1751] = 6,
    ACTIONS(202), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      anon_sym_DOLLAR,
    ACTIONS(212), 1,
      anon_sym_DOLLAR_LBRACE,
    STATE(52), 2,
      sym_string_expansion,
      aux_sym_string_content_repeat1,
    ACTIONS(206), 3,
      aux_sym_string_content_token1,
      sym_string_escape,
      sym__string_backslash,
  [1773] = 6,
    ACTIONS(198), 1,
      anon_sym_DOLLAR,
    ACTIONS(200), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(202), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DQUOTE,
    STATE(52), 2,
      sym_string_expansion,
      aux_sym_string_content_repeat1,
    ACTIONS(217), 3,
      aux_sym_string_content_token1,
      sym_string_escape,
      sym__string_backslash,
  [1795] = 3,
    ACTIONS(202), 1,
      sym_comment,
    ACTIONS(219), 3,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(221), 3,
      aux_sym_string_content_token1,
      sym_string_escape,
      sym__string_backslash,
  [1809] = 3,
    ACTIONS(202), 1,
      sym_comment,
    ACTIONS(223), 3,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 3,
      aux_sym_string_content_token1,
      sym_string_escape,
      sym__string_backslash,
  [1823] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DOT,
    ACTIONS(227), 3,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
  [1841] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 1,
      anon_sym_else,
    ACTIONS(229), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(231), 2,
      anon_sym_if,
      sym_identifier,
  [1856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(237), 2,
      anon_sym_if,
      sym_identifier,
  [1868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(241), 2,
      anon_sym_if,
      sym_identifier,
  [1880] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(243), 1,
      anon_sym_if,
    STATE(58), 1,
      sym_block,
    STATE(59), 1,
      sym_condition,
  [1896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(5), 1,
      sym_assign_op,
    ACTIONS(245), 3,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
  [1908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 1,
      sym_identifier,
    STATE(72), 2,
      sym_array_access,
      sym_scope_access,
  [1919] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DOT,
    ACTIONS(249), 1,
      anon_sym_RBRACE,
  [1932] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1940] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(253), 2,
      aux_sym_string_expansion_token1,
      aux_sym_string_expansion_token2,
  [1948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(57), 1,
      sym_block,
  [1958] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
  [1965] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(257), 1,
      ts_builtin_sym_end,
  [1972] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 1,
      sym_identifier,
  [1979] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(261), 1,
      anon_sym_RBRACK,
  [1986] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 1,
      anon_sym_DQUOTE,
  [1993] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_RBRACE,
  [2000] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(265), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 59,
  [SMALL_STATE(4)] = 117,
  [SMALL_STATE(5)] = 175,
  [SMALL_STATE(6)] = 227,
  [SMALL_STATE(7)] = 279,
  [SMALL_STATE(8)] = 331,
  [SMALL_STATE(9)] = 383,
  [SMALL_STATE(10)] = 435,
  [SMALL_STATE(11)] = 487,
  [SMALL_STATE(12)] = 539,
  [SMALL_STATE(13)] = 591,
  [SMALL_STATE(14)] = 643,
  [SMALL_STATE(15)] = 683,
  [SMALL_STATE(16)] = 717,
  [SMALL_STATE(17)] = 751,
  [SMALL_STATE(18)] = 787,
  [SMALL_STATE(19)] = 829,
  [SMALL_STATE(20)] = 857,
  [SMALL_STATE(21)] = 885,
  [SMALL_STATE(22)] = 929,
  [SMALL_STATE(23)] = 960,
  [SMALL_STATE(24)] = 1003,
  [SMALL_STATE(25)] = 1034,
  [SMALL_STATE(26)] = 1060,
  [SMALL_STATE(27)] = 1086,
  [SMALL_STATE(28)] = 1111,
  [SMALL_STATE(29)] = 1136,
  [SMALL_STATE(30)] = 1179,
  [SMALL_STATE(31)] = 1204,
  [SMALL_STATE(32)] = 1229,
  [SMALL_STATE(33)] = 1254,
  [SMALL_STATE(34)] = 1279,
  [SMALL_STATE(35)] = 1304,
  [SMALL_STATE(36)] = 1329,
  [SMALL_STATE(37)] = 1354,
  [SMALL_STATE(38)] = 1379,
  [SMALL_STATE(39)] = 1421,
  [SMALL_STATE(40)] = 1459,
  [SMALL_STATE(41)] = 1497,
  [SMALL_STATE(42)] = 1535,
  [SMALL_STATE(43)] = 1561,
  [SMALL_STATE(44)] = 1586,
  [SMALL_STATE(45)] = 1611,
  [SMALL_STATE(46)] = 1636,
  [SMALL_STATE(47)] = 1658,
  [SMALL_STATE(48)] = 1675,
  [SMALL_STATE(49)] = 1692,
  [SMALL_STATE(50)] = 1709,
  [SMALL_STATE(51)] = 1726,
  [SMALL_STATE(52)] = 1751,
  [SMALL_STATE(53)] = 1773,
  [SMALL_STATE(54)] = 1795,
  [SMALL_STATE(55)] = 1809,
  [SMALL_STATE(56)] = 1823,
  [SMALL_STATE(57)] = 1841,
  [SMALL_STATE(58)] = 1856,
  [SMALL_STATE(59)] = 1868,
  [SMALL_STATE(60)] = 1880,
  [SMALL_STATE(61)] = 1896,
  [SMALL_STATE(62)] = 1908,
  [SMALL_STATE(63)] = 1919,
  [SMALL_STATE(64)] = 1932,
  [SMALL_STATE(65)] = 1940,
  [SMALL_STATE(66)] = 1948,
  [SMALL_STATE(67)] = 1958,
  [SMALL_STATE(68)] = 1965,
  [SMALL_STATE(69)] = 1972,
  [SMALL_STATE(70)] = 1979,
  [SMALL_STATE(71)] = 1986,
  [SMALL_STATE(72)] = 1993,
  [SMALL_STATE(73)] = 2000,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [15] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_list, 2),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [33] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equivalence_binary_expr, 3, .production_id = 8),
  [35] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equivalence_binary_expr, 3, .production_id = 8),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arithmetic_binary_expr, 3, .production_id = 8),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arithmetic_binary_expr, 3, .production_id = 8),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__primary_expr, 1),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__primary_expr, 1),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comparison_binary_expr, 3, .production_id = 8),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comparison_binary_expr, 3, .production_id = 8),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_and_binary_expr, 3, .production_id = 8),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_and_binary_expr, 3, .production_id = 8),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_access, 4, .production_id = 6),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_access, 4, .production_id = 6),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scope_access, 3, .production_id = 2),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scope_access, 3, .production_id = 2),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_or_binary_expr, 3, .production_id = 8),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_or_binary_expr, 3, .production_id = 8),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 4, .production_id = 5),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 4, .production_id = 5),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 3, .production_id = 1),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 3, .production_id = 1),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paren_expr, 3),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paren_expr, 3),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expr, 1),
  [107] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expr, 1),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 3),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 3, .production_id = 3),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 4, .production_id = 4),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 4, .production_id = 4),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_expr, 2),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_expr, 2),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 5, .production_id = 9),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 5, .production_id = 9),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expr, 2),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expr, 2),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_expr, 3),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_expr, 3),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_list, 1),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [159] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(56),
  [162] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(73),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_unary_expr_repeat1, 2),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_unary_expr_repeat1, 2),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unary_expr_repeat1, 2), SHIFT_REPEAT(46),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_op, 1),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_op, 1),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arithmetic_binary_op, 1),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arithmetic_binary_op, 1),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comparison_binary_op, 1),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comparison_binary_op, 1),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equivalence_binary_op, 1),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equivalence_binary_op, 1),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_content_repeat1, 2),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_content_repeat1, 2), SHIFT_REPEAT(52),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_content_repeat1, 2), SHIFT_REPEAT(65),
  [212] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_content_repeat1, 2), SHIFT_REPEAT(62),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_content, 1),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expansion, 2),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expansion, 2),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_expansion, 3),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_expansion, 3),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lvalue, 1),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 5, .production_id = 7),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition, 5, .production_id = 7),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 7, .production_id = 11),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition, 7, .production_id = 11),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 7, .production_id = 10),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition, 7, .production_id = 10),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr_list, 3),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [257] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_gn(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
