# Announce: Rakudo compiler, Release #144 (2021.03)

On behalf of the Rakudo development team, I’m very happy to announce the
March 2021 release of Rakudo #144. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.03:

  + Additions:
    + Implement space-delimited command line interface arguments [54b6ff30][244abf6e][67143a6d]
    + Add a predicated wait for `Lock::ConditionVariable` [b4980a1c][30e07901][94c562c4]
    + The `Pod::To::Text` module's output supports rendering of multi-level lists now [76dab72f]
  + Removals:
    + Remove `utf32` from encodings lists for MoarVM. This encoding was never supported before
      and attempts to use it gave a confusing error message [9c603460]
  + Build System:
    + Avoid Azure CI failures on re-builds [58930cfb]
    + Fix `ln -nfs` on AIX platform [91ce9a29]
  + Changes:
    + Make `printf` directive error more descriptive [171d3c46]
  + Efficiency:
    + Make sorting and related infix operators about 2x as fast [70a8e366][d61d9836][b2ae599a][0ad991e4][599b6ea5][afab11e6][9ad47170][7f2dba7a]
    + Optimize coercive parameter typechecking [734e7f48][20e6f50e]
    + Make the `>>.` construct faster [412d7706][3d2940af]
    + Make `BagHash.add` a few percent faster [7c0a556e]
    + Make `xx` on a constant value about 5% faster [bf67b1f7]
  + Fixes:
    + Fix single item assignment at `List` creation (`my @l is List = 'foo'` now produces a correct result) [d40c8cd1]
    + `Kernel.signals` no longer returns unwanted extraneous data [d3aab833]
    + Fixed `.of` method on type objects [ee5244b2]
    + Set up proper precedence info for a number of infix operators [ceac5217][affdd058]
    + Fix hypering on `Map` [b21bb5ab]
    + Fix hypering when using `next` [d18653c4]
    + Fix containerization on hypering [722c2c97]
    + Tweak some tests to work on JVM backend [08345f1d]
    + Various internal documentation updates / fixes [7f0ababc][6c1b02ec][9b071642][0e957a66][9b22e51b][09d27c32]
  + Internal:
    + Update broken links to IRC logs [f395cc52]


The following people contributed to this release:

Elizabeth Mattijsen, Will "Coke" Coleda, Vadim Belman, Daniel Sockwell,
Patrick Böker, Tom Browder, Daniel Green, Leon Timmermans, Stefan Seifert,
Stoned Elipot, Ben Davies, JJ Merelo, Jonathan Worthington, Christian Bartolomäus,
Moonchild, Nicholas Clark, Salvador Ortiz, Alexander Kiryuhin

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#145), is tentatively scheduled for 2021-04-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
