/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import android.content.Context;
import android.util.Log;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import pl.com.salsoft.sqlitestudioremote.internal.AuthService;
import pl.com.salsoft.sqlitestudioremote.internal.ClientJobContainer;
import pl.com.salsoft.sqlitestudioremote.internal.JsonConverter;
import pl.com.salsoft.sqlitestudioremote.internal.QueryResults;
import pl.com.salsoft.sqlitestudioremote.internal.SQLiteStudioDbService;
import pl.com.salsoft.sqlitestudioremote.internal.Utils;

public class ClientHandler
implements Runnable {
    private static final int MAX_SIZE = 0xA00000;
    private static final String COMMAND_KEY = "cmd";
    private static final String AUTHORIZE_KEY = "auth";
    private static final String QUERY_KEY = "query";
    private static final String DBNAME_KEY = "db";
    private static final String GENERIC_ERROR_KEY = "generic_error";
    private static final String ERROR_CODE_KEY = "error_code";
    private static final String ERROR_MESSAGE_KEY = "error_message";
    private static final String COLUMNS_KEY = "columns";
    private static final String DATA_KEY = "data";
    private static final String DBLIST_KEY = "list";
    private static final String SIZE_KEY = "size";
    private static final String RESULT_KEY = "result";
    private static final String CONFIRM_VALUE = "ok";
    private static final String FAILURE_VALUE = "error";
    private static final String PONG_VALUE = "pong";
    private static final String tokenTpl = "06fn43%d3ig7ws%d53";
    private Socket clientSocket;
    private SocketChannel channel;
    private ClientJobContainer jobContainer;
    private boolean running = true;
    private InputStream inputStream;
    private OutputStream outputStream;
    private byte[] sizeBuffer = new byte[4];
    private byte[] dataBuffer = new byte[0];
    private DataInputStream dataInputStream;
    private State currentState = State.READING_SIZE;
    private Context context;
    private SQLiteStudioDbService dbService;
    private AuthService authService;
    private boolean authorized = false;
    private boolean denyAccess = false;

    public ClientHandler(Socket clientSocket, Context context, ClientJobContainer jobContainer, AuthService authService) {
        this.clientSocket = clientSocket;
        this.jobContainer = jobContainer;
        this.context = context;
        this.authService = authService;
        this.dbService = new SQLiteStudioDbService(context);
        this.authorized = !authService.isAuthRequired();
    }

    public synchronized void close() {
        this.running = false;
        try {
            this.clientSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        String ip = this.clientSocket.getInetAddress().getHostAddress();
        Log.d((String)Utils.LOG_TAG, (String)("New client from " + ip));
        if (!this.authService.isIpAllowed(ip)) {
            Log.e((String)Utils.LOG_TAG, (String)("Client's IP address not allowed: " + ip + ", disconnecting."));
            this.cleanUp();
            return;
        }
        if (!this.init()) {
            Log.e((String)Utils.LOG_TAG, (String)"Could not initialize handler for the client.");
            this.cleanUp();
            return;
        }
        while (this.isRunning() && !this.denyAccess) {
            this.readClientChannel();
        }
        this.cleanUp();
        Log.d((String)Utils.LOG_TAG, (String)("Disconnected client " + ip));
    }

    private void readClientChannel() {
        if (!this.clientSocket.isConnected()) {
            this.close();
            return;
        }
        try {
            switch (this.currentState) {
                case READING_SIZE: {
                    this.dataInputStream.readFully(this.sizeBuffer);
                    break;
                }
                case READING_DATA: {
                    this.dataInputStream.readFully(this.dataBuffer);
                }
            }
        }
        catch (EOFException e) {
            this.close();
            return;
        }
        catch (IOException e) {
            Log.e((String)Utils.LOG_TAG, (String)("Error while reading input from client: " + e.getMessage()), (Throwable)e);
            this.sendError(Error.ERROR_READING_FROM_CLIENT);
            return;
        }
        switch (this.currentState) {
            case READING_SIZE: {
                int size = ByteBuffer.wrap(this.sizeBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                if (size > 0xA00000) {
                    Log.e((String)Utils.LOG_TAG, (String)("Error while reading input from client: maximum size exceeded: " + size));
                    this.sendError(Error.ERROR_READING_FROM_CLIENT);
                    return;
                }
                this.currentState = State.READING_DATA;
                this.dataBuffer = new byte[size];
                break;
            }
            case READING_DATA: {
                String str = null;
                try {
                    str = new String(this.dataBuffer, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.e((String)Utils.LOG_TAG, (String)("Error while reading data from client: " + e.getMessage()), (Throwable)e);
                    this.sendError(Error.ERROR_READING_FROM_CLIENT);
                    return;
                }
                this.handleRequest(str);
                this.currentState = State.READING_SIZE;
                break;
            }
        }
    }

    private boolean init() {
        try {
            this.inputStream = this.clientSocket.getInputStream();
            this.outputStream = this.clientSocket.getOutputStream();
        }
        catch (IOException e) {
            return false;
        }
        this.dataInputStream = new DataInputStream(this.inputStream);
        return true;
    }

    private void handleRequest(String data) {
        Command cmd;
        JSONObject json;
        try {
            json = new JSONObject(data);
        }
        catch (JSONException e) {
            this.sendError(Error.INVALID_FORMAT);
            return;
        }
        HashMap map = (HashMap)JsonConverter.fromJsonValue(json);
        if (!this.authorized) {
            this.authorize(map);
            return;
        }
        if (!map.containsKey(COMMAND_KEY)) {
            this.sendError(Error.NO_COMMAND_SPECIFIED);
            return;
        }
        try {
            cmd = Command.valueOf("" + map.get(COMMAND_KEY));
        }
        catch (IllegalArgumentException e) {
            this.sendError(Error.UNKNOWN_COMMAND);
            return;
        }
        switch (cmd) {
            case LIST: {
                this.send(DBLIST_KEY, this.dbService.getDbList());
                break;
            }
            case QUERY: {
                this.execAndRespond(map.get(DBNAME_KEY), "" + map.get(QUERY_KEY));
                break;
            }
            case DELETE_DB: {
                this.deleteDbAndRespond(map.get(DBNAME_KEY));
            }
        }
    }

    private void authorize(HashMap<String, Object> map) {
        if (!map.containsKey(AUTHORIZE_KEY)) {
            Log.w((String)Utils.LOG_TAG, (String)"Client authorization failed - no 'auth' key in first request.");
            this.denyAccess = true;
            return;
        }
        String pass = "" + map.get(AUTHORIZE_KEY);
        if (!this.authService.authorize(pass)) {
            Log.w((String)Utils.LOG_TAG, (String)("Client authorization failed - invalid password: " + pass));
            this.denyAccess = true;
            return;
        }
        this.authorized = true;
        Log.w((String)Utils.LOG_TAG, (String)"Client authorization successful.");
        this.sendResult(CONFIRM_VALUE);
    }

    private void deleteDbAndRespond(Object dbName) {
        if (dbName == null || dbName.toString().isEmpty()) {
            this.sendError(Error.NO_DATABASE_SPECIFIED);
            return;
        }
        String dbNameStr = dbName.toString();
        this.sendResult(this.dbService.deleteDb(dbNameStr) ? CONFIRM_VALUE : FAILURE_VALUE);
    }

    private void execAndRespond(Object dbName, String data) {
        if (dbName == null || dbName.toString().isEmpty()) {
            this.sendError(Error.NO_DATABASE_SPECIFIED);
            return;
        }
        String dbNameStr = dbName.toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        QueryResults results = this.dbService.exec(dbNameStr, data);
        if (results.isError()) {
            map.put(ERROR_CODE_KEY, (Object)results.getErrorCode());
            map.put(ERROR_MESSAGE_KEY, results.getErrorMessage());
        } else {
            map.put(COLUMNS_KEY, results.getColumnNames());
            map.put(DATA_KEY, results.getData());
        }
        this.send(map);
    }

    private void sendError(Error error) {
        this.send(GENERIC_ERROR_KEY, error.ordinal());
    }

    private void sendResult(String resultValue) {
        this.send(RESULT_KEY, resultValue);
    }

    private void send(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        this.send(map);
    }

    private void send(HashMap<String, Object> map) {
        this.send(JsonConverter.toJsonValue(map).toString());
    }

    private void send(String response) {
        try {
            byte[] bytes = response.getBytes("UTF-8");
            ByteBuffer sizeBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            sizeBuffer.putInt(bytes.length);
            this.outputStream.write(sizeBuffer.array());
            this.outputStream.write(bytes);
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)Utils.LOG_TAG, (String)("Could not convert response to UTF-8: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)Utils.LOG_TAG, (String)("Could not send response to client: " + e.getMessage()), (Throwable)e);
        }
    }

    private void cleanUp() {
        if (this.dbService != null) {
            this.dbService.releaseAll();
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.dataInputStream != null) {
            try {
                this.dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.jobContainer.removeJob(this);
    }

    private static enum Command {
        LIST,
        QUERY,
        DELETE_DB;

    }

    private static enum Error {
        INVALID_FORMAT,
        NO_COMMAND_SPECIFIED,
        UNKNOWN_COMMAND,
        NO_DATABASE_SPECIFIED,
        ERROR_READING_FROM_CLIENT;

    }

    private static enum State {
        READING_SIZE,
        READING_DATA;

    }
}

