# Integration Testing

yamlfmt has integration testing that tests invocations end-to-end.

## Run

Integration tests are excluded from `go test` by default using build tags. To build and execute the integration test, use:

```shell
make integrationtest
```

## Update

The "golden" / expected output files can be (re-)generated by the test framework. To do so, run:

```shell
make integrationtest_update
```

## Add new test case

* Run the following command to create the directory structure for the new test:

  ```shell
  TESTNAME=my_new_test make command_test_case
  ```
* Add example input files to `testdata/${TESTNAME}/before`.
* Add the expected output to `testdata/${TESTNAME}/stdout/stdout.txt` if applicable.
* `make command_test_case` added a new Go test to `integrationtest/command/command_test.go`. Update the `yamlfmt` flags so the invocation uses the feature the test should cover.
* Run the following command to generate the expected "golden" output of the test:

  ```shell
  make integrationtest_update
  ```
* Review the generated output to ensure it is expected.
