#ifndef KEYRING_H
#define KEYRING_H

#include <glib.h>

// Sigh.
#include <gtk/gtk.h>
#define SECRET_API_SUBJECT_TO_CHANGE "Grr..."
#include <libsecret/secret.h>

void keyring_init(gboolean allow_core_files);
gboolean keyring_ready(void);

gboolean keyring_unlocked(void);
void keyring_unlock(GCancellable *cancel, void (*done)(GError *));
void keyring_lock(GCancellable *cancel, void (*done)(GError *));
void keyring_lock_sync();
void keyring_activate(GCancellable *cancel, void (*done)(GError *));
void keyring_deactivate(void);

typedef struct {
    const char *line1, *line2;
    GList *data;
} *password_t;
extern password_t current_password;

void password_next(void);
void password_prev(void);
void password_create(const gchar *line1, const gchar *line2, SecretValue *password, GCancellable *cancel, void (*done)(GError *));
void password_edit(GObject *pw, const gchar *line1, const gchar *line2, SecretValue *password, GCancellable *cancel, void (*done)(GError *));
void password_delete(GCancellable *cancel, void (*done)(GError *));
void keyring_delete(GCancellable *cancel, void (*done)(GError *));

void password_to_selection(GtkSelectionData *selection_data);

void password_get_edit_data(GCancellable *cancel, void (*done)(GObject *pw, const gchar *line1, const gchar *line2, SecretValue *password, GError *err));

#endif
