/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *	Author: Giacomo Galilei
 *	Nick: Matic
 *	Org:  LdPcom
 *	Mail: matic@ldpcom.com
 *
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "wmgeneral.h"
#include "wmbio-master.xpm"

#define VERSION "1.0"
#define NAMEPROGRAM "wmbio"
#define AUTHOR "Matic"

#define USLEEP          50000


typedef char stringa[256];

typedef struct {		// struct of a mouse region
	int     left;
	int     top;
	int     right;
	int     bottom;
} regioes;

regioes quadrantes[MAX_MOUSE_REGION] =  // we have 7 regions
{					  // Those are the region of
	{12, 17, 27, 27},  // In 3th screen:  sign of '<' or '>'
	{31, 18, 51, 27},  // In 3th screen: number which to increment && In 2nd screen the day's number
	{39, 29, 51, 38},  // In 2nd screen: the month's number
	{30, 38, 58, 47},  // In 2nd screen: the year's number
	{24, 49, 40, 55},  // In 1st screen: the NOW tag, and the month's number
	{7, 46, 18, 55},   // In 1st screen: the day's number
	{45, 46, 57, 55}}; // In 1st screen: the year's number

	
char    wmbio_mask_bits[64 * 64];
int     wmbio_mask_width = 64;
int     wmbio_mask_height = 64;

FILE* out;		 // where will be saved the birth's date for the next launch of application
int nextlimite;	// is the variable of the percentage in 3th screen
int nextminmag;	// 0 = '<', 1 = '>' in 3th screen
int nascitadd;	 // birth's day
int nascitamm;	 // birth's month
int nascitayy;	 // birth's year
int maxnascitayy;  // the max birth's year can be the year before the current
int giornitotali;  // it will contain the number of days really lived

stringa confile;   // for the save file
struct tm *local;  // for the local time
time_t tempo;


/* MAIN */
int	 main (int argc, char *argv[]);

/* SCHERMATA1, SCHERMATA2, SCHERMATA3: are the three dockapp's screen */
void	schermata1 (int argc, char **argv);
void	schermata2 ();
void	schermata3 ();

/* DISEGNANUMERO: draw a number on the screen. recieve as argouments:
   numero: is the number the function have to draw
   cifre : is the number of figures (for ex: if numero=4 and cifre=3, 004 will be drawn)
   x - y : are the coordinates of the top-left corner */
void	disegnanumero (int numero, int cifre, int x, int y);

/* CONTROLLABISESTILE: return 0 if the year passed as a argoument is a leap-year, 1 in the other cases */
int	 controllabisestile(int anno);

/* GIORNIVISSUTI: return the number of days lived by a person who has born in gg/mm/yy
   (the year cha be passed in 2 or 4 figures */
int	 giornivissuti(int gg, int mm, int yy);

/* BARRASCHERMO3: modify the progress of the white bar in 3th screen */
void	barraschermo3();

/* DISEGNABIORITMISCHERMOUNO: compute and draw the biorhythms' person who has lived for giornitotali days */
void	disegnabioritmischermouno(int giornitotali);

/* NEXTbiorhythm: compute the next day whit positive or negative biorimtos */
void	nextbiorhythm();

// -------------------------------------------------------------------------------------------
int main (int argc, char *argv[]) {
	
	nextlimite = 0;
	nextminmag = 1;
	nascitadd = 0;
	nascitamm = 0;
	nascitayy = 0;
	
	// open the configuration file (~/.wmbio)
	sprintf(confile, "%s/.wmbio", getenv("HOME"));
	out = fopen(confile, "r");
	
	// if it exists, read from it the birth's date
	if(out != NULL) {
		fscanf(out, "%d %d %d", &nascitadd, &nascitamm, &nascitayy);
		fclose(out);
	}
	
	/* if variables got a not-possible value, they become as 19/01/1983 (my birth's day) */
	if(!(0 < nascitadd && nascitadd < 32)) nascitadd = 19;
	if(!(0 < nascitamm && nascitamm < 13)) nascitamm = 1;
	if(!(0 < nascitayy && nascitayy < 2003)) nascitayy = 1983;
	
	// the local date
	tempo= time(NULL);
	local = localtime(&tempo);
	local->tm_year += 1900;
	local->tm_mon++;
	
	maxnascitayy = local->tm_year-1;
	
	schermata1 (argc, argv);
	return 0;
}

// This screen is for prevision of the next day with positive o negative biorhythm

void schermata3 () {
	XEvent Event;
	int i;
	while(1) {
		
		RedrawWindowXY (65,0);
		
		while (XPending (display)) {
			XNextEvent (display, &Event);
			switch (Event.type) {
				case Expose:
					RedrawWindow ();
					break;
				case DestroyNotify:
					XCloseDisplay (display);
					exit (0);
					break;
				case ButtonPress:
					i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
					switch (Event.xbutton.button) {
						case 1: // increase by 5 units the number, until 100
							if(i==2) {
							int k=0;
									do {
										if(nextlimite<100) {
											nextlimite++;
											disegnanumero(nextlimite, 3, 95, 16);
										}
										RedrawWindowXY (65,0);
										usleep(1000);
										barraschermo3();
										k++;
										if(k==5) {
											XNextEvent (display, &Event);
											k=0;
										}

									} while(k<5 && Event.type != ButtonRelease);
								}
								
								if(i==1) {
									int k=0;
									if(!nextminmag) k=16;
									copyXPMArea (65 +k, 75, 14, 9, 76,16);
									nextminmag = !nextminmag;
								}
								
								break;
						case 2: // return to the 1st screen
							while(Event.xbutton.button != ButtonRelease) {
								return;
							}
							break;
						case 3: // decrease by 5 units
							if(i==2) {
							int k=0;
									do {
										if(nextlimite>0) {
											nextlimite--;
											disegnanumero(nextlimite, 3, 95, 16);
										}
										barraschermo3();
										RedrawWindowXY (65,0);
										usleep(1000);
										k++;
										if(k==5) {
											XNextEvent (display, &Event);
											k=0;
										}
									} while(Event.type != ButtonRelease);
								}
					}
					nextbiorhythm();
			}
		}
		usleep (USLEEP);
	}
	
}

// Screen where you can set your birth's date
void schermata2 () {
	XEvent Event;
	int i, cifre;
	stringa utile;
	

	sprintf(utile, "%d", giornitotali);
	cifre = strlen(utile);
	cifre--;
	copyXPMArea (65, 111, 34, 9, 24, 107);													// delete it
	if(giornitotali < 100000) disegnanumero( giornitotali, cifre+1, 52 - (cifre * 7), 108);   // draw it
		

	while(1) {
		
		disegnanumero(nascitadd, 2, 38, 76);
		disegnanumero(nascitamm, 2, 38, 86);
		disegnanumero(nascitayy, 4, 31, 96);
		
		RedrawWindowXY (0,60);
		
		while (XPending (display)) {

			XNextEvent (display, &Event);
			switch (Event.type) {
				case Expose:
					RedrawWindow ();
					break;
				case DestroyNotify:
					XCloseDisplay (display);
					exit (0);
					break;
				case ButtonPress:
					i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
					switch (Event.xbutton.button) {
						case 1: if(i==2) { //DD
									if(nascitadd < 31) nascitadd++;
									if(nascitadd == 31 && (
									nascitamm == 2 ||
									nascitamm == 4 ||
									nascitamm == 6 ||
									nascitamm == 9 ||
									nascitamm == 11)) nascitadd--;
									if(nascitadd > 28 && nascitamm == 2) nascitadd = 29;
									
								}
								if(i==3) { //MM
									if(nascitamm < 12) nascitamm++;
									if((nascitamm == 4 ||
									nascitamm == 6 ||
									nascitamm == 9 ||
									nascitamm == 11 ) && nascitadd == 31) nascitadd--;
									
									if(nascitamm ==2 && nascitadd > 28) nascitadd=29;
									
									
								}
								if(i==4) //YYYY
									if(nascitayy < maxnascitayy) nascitayy++;
									
									break;
						case 2: 
								while(Event.xbutton.button != ButtonRelease) {
									schermata3();
									return;
								}
							break;
						case 3: if(i==2 && nascitadd > 1) nascitadd--;
								if(i==3 && nascitamm > 1) nascitamm--;
								if((nascitamm == 4 ||
								nascitamm == 6 ||
								nascitamm == 9 ||
								nascitamm == 11) && nascitadd == 31) nascitadd--;
								if(nascitadd > 28 && nascitamm == 2) nascitadd = 29;
								if(i==4 && nascitayy > 0) nascitayy--;
					}
					if(controllabisestile(nascitayy) && nascitamm == 2 && nascitadd == 29) nascitadd=28;
					out = fopen( confile, "w");
					if(out != NULL) {
						fprintf(out, "%d %d %d", nascitadd, nascitamm, nascitayy);
						fclose(out);
					}
					giornitotali = giornivissuti(local->tm_mday, local->tm_mon, local->tm_year);
					
					sprintf(utile, "%d", giornitotali);
					cifre = strlen(utile);
					cifre--;
					copyXPMArea (65, 111, 34, 9, 24, 107);												// cancella
					if(giornitotali < 100000) disegnanumero( giornitotali, cifre+1, 52 - (cifre * 7), 108);  // ridisegna
					disegnabioritmischermouno( giornitotali);
			}
		}
		usleep (USLEEP);
	}
	
}
	
// Main screen
void schermata1 (int argc, char **argv) {
	int i;
	
	// these will contain your ipotetic birth's day for the proiection of the biorhythms in the future and in the past
	int oranno=0, ormese=0, orgiorno=0;
	// it will contain the number of day lived by a person who has born in orgiorno/ormese/oranno
	int ipotetico;
	
	// it will be used for conversion of a year number, form 2 to 4 figures
	stringa utile;
	// show which modality is set: if NOW is set (0), or if you're watching the proiection of biorhythms in past and future (1)
	int modef=0;
	XEvent Event;
	
	
	// draw the dockapp on the screen
	createXBMfromXPM (wmbio_mask_bits, wmbio_master_xpm, wmbio_mask_width, wmbio_mask_height);
	openXwindow (argc, argv, wmbio_master_xpm, wmbio_mask_bits, wmbio_mask_width, wmbio_mask_height);
	
	giornitotali = giornivissuti(  local->tm_mday, local->tm_mon , local->tm_year);


	
	// mouse regions
	for (i = 0; i < MAX_MOUSE_REGION; i++)
		AddMouseRegion (i, quadrantes[i].left, quadrantes[i].top, quadrantes[i].right, quadrantes[i].bottom);

	while (1) {
		
		RedrawWindow();

		tempo= time(NULL);
		local = localtime(&tempo);
		local->tm_year += 1900;
		local->tm_mon++;
		if(!modef) {
			giornitotali = giornivissuti(  local->tm_mday, local->tm_mon , local->tm_year);
			disegnabioritmischermouno(giornitotali);
		}

		while (XPending (display)) {

			XNextEvent (display, &Event);
			
			switch (Event.type) {
				case Expose:
					RedrawWindow ();
					break;
				case DestroyNotify:
					XCloseDisplay (display);
					exit (0);
					break;
				case ButtonPress:
					
					i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
					
					switch (Event.xbutton.button) {
						case 1: 
								if(modef && i==6) {
									// increase the day by 1
									orgiorno++;
									
									/* if day has become 31, but we are in a month which contain 30 days, the month will be increased
									   or if day has become 32
									   or if it's 29 and the month is 2 and we're not in a leap-year
									   or if it's 30 and the month is 2 and we're in a leap-year */
									if(((orgiorno == 31) && (ormese == 4 ||
									ormese == 6 || ormese == 9 || ormese == 11)) ||
									(orgiorno == 32) || 
									((orgiorno==29) && (ormese==2) && controllabisestile(oranno)) ||
									( orgiorno == 30 && ormese==2 && !controllabisestile(oranno))) {
										orgiorno=1;
										ormese++;
										// if the month has become 13, the year will be incremented by 1
										if(ormese==13) {
											oranno++;
											ormese=1;
											/* if year has become 100 (2100), it will be returned to 0 (2000)
											   it only cover 100 year, becouse in the dockapp only 2 figures has entered */
											if(oranno==100) oranno=0;
										}
									}
									
									// draw the three numbers
									disegnanumero(orgiorno, 2, 5,45);
									disegnanumero(ormese, 2, 25,45);
									disegnanumero(oranno, 2, 44,45);
									
									// ipotetico takes the value of the lived-day in that date, and then will be drawn the biorhythm
									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);
								}
								// month's progress
								if(modef && i==5) {
									ormese++;
									if(ormese==13) {
										ormese= 1;
										oranno++;
										if(oranno==100) oranno=0;
									}
										
									if((orgiorno == 31) && (ormese == 4 ||
									ormese == 6 || ormese == 9 ||
									ormese || 11)) orgiorno=30;
									if(orgiorno>29 && ormese == 2) orgiorno = 29;
									if(controllabisestile(oranno) && ormese ==2
									&& orgiorno==29) orgiorno=28;

									disegnanumero(orgiorno, 2, 5,45);
									disegnanumero(ormese, 2, 25,45);
									disegnanumero(oranno, 2, 44,45);
									
									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);
								}
								// year's progress
								if(modef && i==7) {
									oranno++;
									if(oranno==100) oranno=0;
									if(!controllabisestile(oranno) &&
									ormese == 2 && orgiorno==29) orgiorno = 28;
									
									disegnanumero(orgiorno, 2, 5,45);
									disegnanumero(oranno, 2, 44,45);
									
									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);									
								}
								// clicking over NOW you enter in biorhythm future/past proiection modality
								if(!modef && i==5) {
									modef=1;
									sprintf(utile, "%d", local->tm_year);
									utile[0]=utile[2];
									utile[1]=utile[3];
									utile[2]='\0';
									oranno = atoi(utile);
									ormese = local->tm_mon;
									orgiorno = local->tm_mday;

									disegnanumero(orgiorno, 2, 5,45);
									copyXPMArea (115, 93, 5, 9, 19, 45);
									disegnanumero(ormese, 2, 25,45);
									copyXPMArea (115, 93, 5, 9, 38, 45);
									disegnanumero(oranno, 2, 44,45);
									
									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);
								}
								break;
								
						case 2: // with the middle button mouse, you can switch the 3 screens
								schermata2();
								RedrawWindowXY (0,0);
								break;
								
						case 3: // to return in NOW modality
								if(i!=5&&i!=6&&i!=7) {
									modef=0;
									copyXPMArea (65, 105, 52, 9, 5, 45);
									copyXPMArea (102, 85, 16, 6,23, 47);
									disegnabioritmischermouno( giornitotali);
								}
								// decrease the day
								if(modef && i==6) {
									orgiorno--;
									if(orgiorno==0) {
										ormese--;
										if(ormese==0) {
											ormese = 12;
											oranno--;
											if(oranno==-1) oranno=99;
										}
										
										if(ormese == 2) {
											orgiorno=29;
											if(controllabisestile(oranno)) orgiorno = 28;
										} else {
											if(ormese == 4 || ormese == 6 ||
											ormese == 9 || ormese == 11) orgiorno = 30;
											else orgiorno=31;										
										}
									}
											
									
									disegnanumero(orgiorno, 2, 5,45);
									disegnanumero(ormese, 2, 25,45);
									disegnanumero(oranno, 2, 44,45);
									
									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);
								}
								// decrease the month
								if(modef && i==5) {
									ormese--;
									
									if(ormese == 0) {
										ormese=12;
										oranno--;
										if(oranno==-1) oranno=99;
									}
									
									if((orgiorno == 31) && (ormese == 4 ||
									ormese == 6 || ormese == 9 ||
									ormese || 11)) orgiorno=30;
									if(orgiorno>29 && ormese == 2) orgiorno = 29;
									if(controllabisestile(oranno) && ormese ==2
									&& orgiorno==29) orgiorno=28;
									
									disegnanumero(orgiorno, 2, 5,45);
									disegnanumero(ormese, 2, 25,45);
									disegnanumero(oranno, 2, 44,45);

									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);
								}
								// decrease the year
								if(modef && i==7) {
									oranno--;
									if(oranno==-1) oranno=99;
									if(!controllabisestile(oranno) &&
									ormese == 2 && orgiorno==29) orgiorno = 28;
									
									disegnanumero(orgiorno, 2, 5,45);
									disegnanumero(oranno, 2, 44,45);

									ipotetico = giornivissuti( orgiorno, ormese, oranno);
									disegnabioritmischermouno( ipotetico);
								}
					}
			}
		}
		usleep (USLEEP);
	}
}

void disegnanumero (int numero, int cifre, int x, int y) {
	stringa stringanum;
	int numerocifre = 0;
	int sposta=0;	  // every time a number is written, the pointer x have to be moved on right side by 7 pixels
	int ilnum=0;
	int numciclo=0;

	// it determinate how many figures is the number
	sprintf( stringanum, "%d", numero);
	numerocifre = strlen(stringanum);
	
	// it print the 0 needed
	while( numerocifre < cifre) {
		copyXPMArea (65, 65, 6, 9, x+(sposta*7), y);
		sposta++;
		numerocifre++;
	}

	numerocifre = strlen(stringanum);
	
	// draw the number
	while( numerocifre > 0) {
		ilnum = stringanum[numciclo]-48;
		copyXPMArea (65+(ilnum*6), 65, 6, 9, x+(sposta*7), y);
		sposta++;
		numciclo++;
		numerocifre--;
	}

	return;
	
	
}


int controllabisestile(int anno) {
	stringa utile;
	int lung;
	
	// if the year si in 2 figures form, it's brought to 4 figures form ( 12 = 2012)
	sprintf(utile, "%d", anno);
	lung=strlen(utile);
	if(lung==2) {
		utile[4] = '\0';
		utile[3] = utile[1];
		utile[2] = utile[0];
		utile[1] = '0';
		utile[0] = '2';
		anno = atoi(utile);
	}
	
	
	if(anno % 4 == 0) return 0;  // is leap-year
	return 1;					// isn't leap-year
}


void barraschermo3() {
	int div;
	
	// dive takes a bar's percentuage
	div = (nextlimite * 47)/100;
	
	// delete the area with a black bar
	copyXPMArea (65, 99, 47, 6, 72, 34);
	// draw the bar, as pixels as div says
	copyXPMArea (65, 93, div, 6, 72, 34);
	return;
}

int giornivissuti(int gg, int mm, int yy) {
	int giorni=0, pran=0, prigio=0, bis=0, anni=0, tot=0, oggi=0;
	int i, cifre;
	stringa prova;
	
	// 12 = 2012
	sprintf(prova, "%d", yy);
	cifre = strlen(prova);
	if(cifre<=2) {
		prova[4] = '\0';
		
		if(cifre==2) {
			prova[3] = prova[1];
			prova[2] = prova[0];
		} else {
			prova[3] = prova[0];
			prova[2] = '0';
		}
		prova[1] = '0';
		prova[0] = '2';
		yy = atoi(prova);
	}
	
	if(mm == 1) oggi+=gg;
	if(mm == 2) oggi+= (gg + 31);
	if(mm == 3) oggi+= (gg + 31+28 + !controllabisestile(yy));
	if(mm == 4) oggi+= (gg + 31+28+31 + !controllabisestile(yy));
	if(mm == 5) oggi+= (gg + 31+28+31+30 + !controllabisestile(yy));
	if(mm == 6) oggi+= (gg + 31+28+31+30+31 + !controllabisestile(yy));
	if(mm == 7) oggi+= (gg + 31+28+31+30+31+30 + !controllabisestile(yy));
	if(mm == 8) oggi+= (gg + 31+28+31+30+31+30+31 + !controllabisestile(yy));
	if(mm == 9) oggi+= (gg + 31+28+31+30+31+30+31+31 + !controllabisestile(yy));
	if(mm ==10) oggi+= (gg + 31+28+31+30+31+30+31+31+30 + !controllabisestile(yy));
	if(mm ==11) oggi+= (gg + 31+28+31+30+31+30+31+31+30+31 + !controllabisestile(yy));
	if(mm ==12) oggi+= (gg + 31+28+31+30+31+30+31+31+30+31+30 + !controllabisestile(yy));

	if(nascitamm == 1) {giorni = 31; pran = 334;}
	if(nascitamm == 2) {giorni = 28; pran = 306;}
	if(nascitamm == 3) {giorni = 31; pran = 275;}
	if(nascitamm == 4) {giorni = 30; pran = 245;}
	if(nascitamm == 5) {giorni = 31; pran = 214;}
	if(nascitamm == 6) {giorni = 30; pran = 184;}
	if(nascitamm == 7) {giorni = 31; pran = 153;}
	if(nascitamm == 8) {giorni = 31; pran = 122;}
	if(nascitamm == 9) {giorni = 30; pran = 92;}
	if(nascitamm == 10) {giorni =31; pran = 61;}
	if(nascitamm == 11) {giorni =30; pran = 31;}
	if(nascitamm == 12) {giorni =31; pran = 0;}
	
	prigio = giorni - nascitadd - 1;

	for(i=yy; i>=nascitayy; i--) {
		if(!(controllabisestile(i))) bis++;
	}
	
	if(!(controllabisestile(yy))) {
		if( mm < 2) bis--;
		else {
			if( mm == 2) {
				if( gg < 29) bis--;
			}
		}
	}

	if(!(controllabisestile(nascitayy))) {
		if( nascitamm > 3) bis--;
	}

	anni = (((yy - nascitayy -1)*365) + bis);

	/* tot will contain the total of the lived-days. it is the sum of:
	   prigio = the days since the birth to the end of birth's month
	   pran   = the days since the end of birth's month to the end of the birth's year
	   anni   = the days since the first 31th dec. to the last one
	   oggi   = the days spent since the start of this year */
	tot = (prigio)+(pran)+(anni)+(oggi);

	tot++; // total day lived

	return tot;
}

void disegnabioritmischermouno( int ng) {
	/* it will contain the number of the day in the cycle
	   0-22 physical
	   0-27 emotional
	   0-32 intellectual */	
	int fisico, emotivo, intel;
	// percentuage of biorhythms level
	int percf, perce, perci;
	
	int bar,i;
	int k[3] = {0,0,0};
	
	// days of the cycles
	fisico = ng%23;
	emotivo = ng%28;
	intel = ng%33;
	
	
	if(fisico>5.75 && 17.25 > fisico) k[0]=7;
	if(emotivo>7 && 21 > emotivo) k[1]=7;
	if(intel>8.25 && 24.75 > intel) k[2]=7;
	
	// percf = physical
	if(fisico<=5.75) percf = (fisico*50 / 5.75 )+ 50;
	else {
		if(fisico<=17.25) percf = -(((fisico-5.75)*100 / 11.5)-100);
		else percf = ((fisico-17.25)*50 / 5.75);
	}
		
	
	// perce = emotional
	if(emotivo<=7) perce = (emotivo*50 / 7) +50;
	else {
		if(emotivo<=21) perce = -(((emotivo-7)*100 / 14)-100);
		else perce = ((emotivo-21)*50 / 7);
	}
	
	// perci = intellectual
	if(intel<=8.25) perci = (intel*50 / 8.25) +50;
	else {
		if(intel<=24.75) perci = -(((intel-8.25)*100 / 16.5)-100);
		else perci = ((intel-24.75)*50 / 8.25);
	}
	
	// draw physical cycle
	bar = percf * 37 / 100;
	copyXPMArea (65, 105, 33, 6, 14, 13);	// delete
	for(i=0; i<bar; i++)
	copyXPMArea (65+i, 86, 1, 6, 14+i, 13);  // draw

	// draw emotional cycle
	bar = perce * 37 / 100;
	copyXPMArea (65, 105, 33, 6, 14, 24);	// delete
	for(i=0; i<bar; i++) 
	copyXPMArea (65+i, 86, 1, 6, 14+i, 24);  // draw
	
	// draw intellectual cycle
	bar = perci * 37 / 100;
	copyXPMArea (65, 105, 33, 6, 14, 35);	// delete
	for(i=0; i<bar; i++) 
	copyXPMArea (65+i, 86, 1, 6, 14+i, 35);  // draw
	
	// draw the sign
	for(i=0; i<3; i++) {
		copyXPMArea (114, 77, 6, 6, 51, 13+(i*11));	 	// delete
		copyXPMArea (100+k[i], 77, 6, 6, 51, 13+(i*11));	// draw
	}
	
	
	return;
}

void nextbiorhythm() {
	int fi=0,em=0,in=0;
	int fisico, emotivo, intel;
	int ggipot,k=1;
	stringa utile;
	
	int newgg=0, newmese=0, newanno, pran=0, doan=0, left;	
	
	ggipot = giornitotali;
	
	
	if(nextminmag) {
		while(!(fi >= nextlimite && em >= nextlimite && in >= nextlimite)) {

			fisico = ggipot%23;
			emotivo = ggipot%28;
			intel = ggipot%33;

			// physical
			if(fisico<=5) fi = (fisico*50 / 5 )+ 50;
			else {
				if(fisico<=17) fi = -(((fisico-5)*100 / 11)-100);
				else fi = ((fisico-17)*50 / 5);
			}
				
			
			// emotional
			if(emotivo<=7) em = (emotivo*50 / 7) +50;
			else {
				if(emotivo<=21) em = -(((emotivo-7)*100 / 14)-100);
				else em = ((emotivo-21)*50 / 7);
			}
			
			// intellectual
			if(intel<=8) in = (intel*50 / 8) +50;
			else {
				if(intel<=24) in = -(((intel-8)*100 / 16)-100);
				else in = ((intel-24)*50 / 8);
			}
			ggipot++;
		}
	} else {
		fi=em=in=100;
		while(!(fi <= nextlimite && em <= nextlimite && in <= nextlimite)) {
			fisico = ggipot%23;
			emotivo = ggipot%28;
			intel = ggipot%33;
			// physical
			if(fisico<=5) fi = (fisico*50 / 5 )+ 50;
			else {
				if(fisico<=17) fi = -(((fisico-5)*100 / 11)-100);
				else fi = ((fisico-17)*50 / 5);
			}
				
			
			// emotional
			if(emotivo<=7) em = (emotivo*50 / 7) +50;
			else {
				if(emotivo<=21) em = -(((emotivo-7)*100 / 14)-100);
				else em = ((emotivo-21)*50 / 7);
			}
			
			// intellectual
			if(intel<=8) in = (intel*50 / 8) +50;
			else {
				if(intel<=24) in = -(((intel-8)*100 / 16)-100);
				else in = ((intel-24)*50 / 8);
			}
			ggipot++;
		}
	}
	ggipot--;
	ggipot-=giornitotali;

	// compute the date
	
	newanno = ggipot/365;
	newanno += local->tm_year;
	
	
	if(local->tm_mon == 1) {pran = 334; doan = local->tm_mday;}
	if(local->tm_mon == 2) {pran = 306; doan = 31+local->tm_mday;}
	if(local->tm_mon == 3) {pran = 275; doan = 59+local->tm_mday;}
	if(local->tm_mon == 4) {pran = 245; doan = 90+local->tm_mday;}
	if(local->tm_mon == 5) {pran = 214; doan = 120+local->tm_mday;}
	if(local->tm_mon == 6) {pran = 184; doan = 151+local->tm_mday;}
	if(local->tm_mon == 7) {pran = 153; doan = 181+local->tm_mday;}
	if(local->tm_mon == 8) {pran = 122; doan = 212+local->tm_mday;}
	if(local->tm_mon == 9) {pran = 92;  doan = 243+local->tm_mday;}
	if(local->tm_mon == 10) {pran = 61;  doan = 274+local->tm_mday;}
	if(local->tm_mon == 11) {pran = 31;  doan = 304+local->tm_mday;}
	if(local->tm_mon == 12) {pran = 0;   doan = 334+local->tm_mday;}
	
	left = ggipot%365;
	if(left>pran) {
		left-=pran;
		newanno++;
	}
	
	sprintf(utile, "%d", newanno);
	utile[0]=utile[2];
	utile[1]=utile[3];
	utile[2]='\0';
	newanno=atoi(utile);
		
	doan+=left;
	if(k&&doan <=31) {k=0; newmese= 1; newgg = doan;}
	if(k&&doan <=59) {k=0; newmese= 2; newgg = doan-31;}
	if(k&&doan <=90) {k=0; newmese= 3; newgg = doan-59;}
	if(k&&doan <=120){k=0; newmese= 4; newgg = doan-90;}
	if(k&&doan <=151){k=0; newmese= 5; newgg = doan-120;}
	if(k&&doan <=181){k=0; newmese= 6; newgg = doan-151;}
	if(k&&doan <=212){k=0; newmese= 7; newgg = doan-181;}
	if(k&&doan <=243){k=0; newmese= 8; newgg = doan-212;}
	if(k&&doan <=274){k=0; newmese= 9; newgg = doan-243;}
	if(k&&doan <=306){k=0; newmese=10; newgg = doan-274;}
	if(k&&doan <=334){k=0; newmese=11; newgg = doan-304;}
	if(k){newmese=12; newgg = doan-334;}
	
	disegnanumero(newgg, 2, 69,47);
	copyXPMArea (115, 93, 5, 9, 83, 47);
	disegnanumero(newmese, 2, 89,47);
	copyXPMArea (115, 93, 5, 9, 102, 47);
	disegnanumero(newanno, 2, 108,47);

	return;
}
