/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import {describe, expect, test} from '@gsa/testing';
import {testModel} from 'gmp/models/testing';
import Vulnerability from 'gmp/models/vulnerability';
import {parseDate} from 'gmp/parser';

testModel(Vulnerability, 'vulnerability');

describe('Vulnerability model tests', () => {
  test('should use defaults', () => {
    const model = new Vulnerability();
    expect(model.hosts).toBeUndefined();
    expect(model.results).toBeUndefined();
    expect(model.qod).toBeUndefined();
    expect(model.severity).toBeUndefined();
  });

  test('should parse empty element', () => {
    const vulnerability = Vulnerability.fromElement();
    expect(vulnerability.hosts).toBeUndefined();
    expect(vulnerability.results).toBeUndefined();
    expect(vulnerability.qod).toBeUndefined();
    expect(vulnerability.severity).toBeUndefined();
  });

  test('should parse hosts', () => {
    const vulnerability = Vulnerability.fromElement({
      hosts: {
        count: 5,
      },
    });
    expect(vulnerability.hosts).toEqual({count: 5});
  });

  test('should parse results', () => {
    const vulnerability = Vulnerability.fromElement({
      results: {
        count: 10,
        newest: '2024-01-01T00:00:00Z',
        oldest: '2023-01-01T00:00:00Z',
      },
    });
    expect(vulnerability.results).toEqual({
      count: 10,
      newest: parseDate('2024-01-01T00:00:00Z'),
      oldest: parseDate('2023-01-01T00:00:00Z'),
    });
  });

  test('should parse qod', () => {
    const vulnerability = Vulnerability.fromElement({
      qod: 75,
    });
    expect(vulnerability.qod).toBe(75);
  });

  test('should parse severity', () => {
    const vulnerability = Vulnerability.fromElement({
      severity: 3,
    });
    expect(vulnerability.severity).toBe(3);
  });
});
