(import "test")
;;;
;;;  chapter11 Number class
;;;

($ap 1 "Number class")

;;;
;;; function (NUMBERP obj) --> boolean
;;;
($ap 2 "numberp" P.67)
($test (numberp 3) t)
($test (numberp -0.3) t)
($test (numberp '(a b c)) nil)
($test (numberp "17") nil)
;;;
($argc numberp 1 0 0)
($predicate numberp $float $integer)

;;;
;;; function (PARSE-NUMBER string) --> <number>
;;;
($ap 2 "parse-number" P.67)
($test (parse-number "123.34") 123.34 eql)
($test (parse-number "#XFACE") 64206 eql)
($error (parse-number "-37.") <parse-error>)
($error (parse-number "-.5") <parse-error>)
;;;
($argc parse-number 1 0 0)
($type parse-number ($string) :target)
;;; #b[s]bb...b
($test (parse-number "#b0") 0 eql)
($test (parse-number "#b+0") 0 eql)
($test (parse-number "#b-0") 0 eql)
($test (parse-number "#b1") 1 eql)
($test (parse-number "#b+1") 1 eql)
($test (parse-number "#b-1") -1 eql)
($test (parse-number "#b1010101010") 682 eql)
($test (parse-number "#b+1010101010") 682 eql)
($test (parse-number "#b-1010101010") -682 eql)
($error (parse-number "#b") <parse-error>)
($error (parse-number "#b+") <parse-error>)
($error (parse-number "#b-") <parse-error>)
($error (parse-number "#b12") <parse-error>)
($error (parse-number "#b+12") <parse-error>)
($error (parse-number "#b-12") <parse-error>)
;;; #B[s]bb...b
($test (parse-number "#B0") 0 eql)
($test (parse-number "#B+0") 0 eql)
($test (parse-number "#B-0") 0 eql)
($test (parse-number "#B1") 1 eql)
($test (parse-number "#B+1") 1 eql)
($test (parse-number "#B-1") -1 eql)
($test (parse-number "#B1010101010") 682 eql)
($test (parse-number "#B+1010101010") 682 eql)
($test (parse-number "#B-1010101010") -682 eql)
($error (parse-number "#B") <parse-error>)
($error (parse-number "#B+") <parse-error>)
($error (parse-number "#B-") <parse-error>)
($error (parse-number "#B12") <parse-error>)
($error (parse-number "#B+12") <parse-error>)
($error (parse-number "#B-12") <parse-error>)
;;; #o[s]oo...o
($test (parse-number "#o0") 0 eql)
($test (parse-number "#o+0") 0 eql)
($test (parse-number "#o-0") 0 eql)
($test (parse-number "#o7") 7 eql)
($test (parse-number "#o+7") 7 eql)
($test (parse-number "#o-7") -7 eql)
($test (parse-number "#o12345670") 2739128 eql)
($test (parse-number "#o+12345670") 2739128 eql)
($test (parse-number "#o-12345670") -2739128 eql)
($error (parse-number "#o") <parse-error>)
($error (parse-number "#o+") <parse-error>)
($error (parse-number "#o-") <parse-error>)
($error (parse-number "#o12345678") <parse-error>)
($error (parse-number "#o+12345678") <parse-error>)
($error (parse-number "#o-12345678") <parse-error>)
;;; #O[s]oo...o
($test (parse-number "#O0") 0 eql)
($test (parse-number "#O+0") 0 eql)
($test (parse-number "#O-0") 0 eql)
($test (parse-number "#O7") 7 eql)
($test (parse-number "#O+7") 7 eql)
($test (parse-number "#O-7") -7 eql)
($test (parse-number "#O12345670") 2739128 eql)
($test (parse-number "#O+12345670") 2739128 eql)
($test (parse-number "#O-12345670") -2739128 eql)
($error (parse-number "#O") <parse-error>)
($error (parse-number "#O+") <parse-error>)
($error (parse-number "#O-") <parse-error>)
($error (parse-number "#O12345678") <parse-error>)
($error (parse-number "#O+12345678") <parse-error>)
($error (parse-number "#O-12345678") <parse-error>)
;;; [s]dd...d
($test (parse-number "0") 0 eql)
($test (parse-number "+0") 0 eql)
($test (parse-number "-0") 0 eql)
($test (parse-number "9") 9 eql)
($test (parse-number "+9") 9 eql)
($test (parse-number "-9") -9 eql)
($test (parse-number "1234567890") 1234567890 eql)
($test (parse-number "+1234567890") 1234567890 eql)
($test (parse-number "-1234567890") -1234567890 eql)
($error (parse-number "") <parse-error>)
($error (parse-number "+") <parse-error>)
($error (parse-number "-") <parse-error>)
($error (parse-number "123456789A") <parse-error>)
($error (parse-number "+123456789A") <parse-error>)
($error (parse-number "-123456789A") <parse-error>)
;;; #x[s]xx...x
($test (parse-number "#x0") 0 eql)
($test (parse-number "#x+0") 0 eql)
($test (parse-number "#x-0") 0 eql)
($test (parse-number "#xF") 15 eql)
($test (parse-number "#x+F") 15 eql)
($test (parse-number "#x-F") -15 eql)
($test (parse-number "#x1234567890abcdefABCDEF") 22007822917795467892608495 eql)
($error (parse-number "#x") <parse-error>)
($error (parse-number "#x+") <parse-error>)
($error (parse-number "#x-") <parse-error>)
($error (parse-number "#x1234567890ABCDEFG") <parse-error>)
($error (parse-number "#x+1234567890ABCDEFG") <parse-error>)
($error (parse-number "#x-1234567890ABCDEFG") <parse-error>)
;;; #X[s]xx...x
($test (parse-number "#X0") 0 eql)
($test (parse-number "#X+0") 0 eql)
($test (parse-number "#X-0") 0 eql)
($test (parse-number "#Xf") 15 eql)
($test (parse-number "#X+f") 15 eql)
($test (parse-number "#X-f") -15 eql)
($test (parse-number "#X1234567890abcdefABCDEF") 22007822917795467892608495 eql)
($error (parse-number "#X") <parse-error>)
($error (parse-number "#X+") <parse-error>)
($error (parse-number "#X-") <parse-error>)
($error (parse-number "#X1234567890abcdefg") <parse-error>)
($error (parse-number "#X+1234567890abcdefg") <parse-error>)
($error (parse-number "#X-1234567890abcdefg") <parse-error>)
;;; [s]dd...d.dd...d
($test (parse-number "0.0") 0.0 eql)
($test (parse-number "+0.0") 0.0 eql)
($test (parse-number "-0.0") 0.0 eql)
($test (parse-number "9.9") 9.9 eql)
($test (parse-number "+9.9") 9.9 eql)
($test (parse-number "-9.9") -9.9 eql)
($test (parse-number "12345.67890") 12345.67890 eql)
($test (parse-number "+12345.67890") 12345.67890 eql)
($test (parse-number "-12345.67890") -12345.67890 eql)
($error (parse-number ".") <parse-error>)
($error (parse-number "+.") <parse-error>)
($error (parse-number "-.") <parse-error>)
($error (parse-number ".0") <parse-error>)
($error (parse-number "+.0") <parse-error>)
($error (parse-number "-.0") <parse-error>)
($error (parse-number "1.") <parse-error>)
($error (parse-number "+1.") <parse-error>)
($error (parse-number "-1.") <parse-error>)
($error (parse-number "12345A.0") <parse-error>)
($error (parse-number "+12345A.0") <parse-error>)
($error (parse-number "-12345A.0") <parse-error>)
($error (parse-number "1.2345A") <parse-error>)
($error (parse-number "+1.2345A") <parse-error>)
($error (parse-number "-1.2345A") <parse-error>)
;;; [s]dd...d.dd...dE[s]dd...d
($test (parse-number "0.0E0") 0.0 eql)
($test (parse-number "0.0E+0") 0.0 eql)
($test (parse-number "0.0E-0") 0.0 eql)
($test (parse-number "+0.0E0") 0.0 eql)
($test (parse-number "+0.0E+0") 0.0 eql)
($test (parse-number "+0.0E-0") 0.0 eql)
($test (parse-number "-0.0E0") 0.0 eql)
($test (parse-number "-0.0E+0") 0.0 eql)
($test (parse-number "-0.0E-0") 0.0 eql)
($test (parse-number "9.9E9") 9.9e9 eql)
($test (parse-number "9.9E+9") 9.9e9 eql)
($test (parse-number "9.9E-9") 9.9e-9 eql)
($test (parse-number "+9.9E9") 9.9e9 eql)
($test (parse-number "+9.9E+9") 9.9e9 eql)
($test (parse-number "+9.9E-9") 9.9e-9 eql)
($test (parse-number "-9.9E9") -9.9e9 eql)
($test (parse-number "-9.9E+9") -9.9e9 eql)
($test (parse-number "-9.9E-9") -9.9e-9 eql)
($test (parse-number "1234.5678E90") 1234.5678e90 eql)
($test (parse-number "1234.5678E+90") 1234.5678e+90 eql)
($test (parse-number "1234.5678E-90") 1234.5678e-90 eql)
($test (parse-number "+1234.5678E90") 1234.5678e90 eql)
($test (parse-number "+1234.5678E+90") 1234.5678e+90 eql)
($test (parse-number "+1234.5678E-90") 1234.5678e-90 eql)
($test (parse-number "-1234.5678E90") -1234.5678e90 eql)
($test (parse-number "-1234.5678E+90") -1234.5678e+90 eql)
($test (parse-number "-1234.5678E-90") -1234.5678e-90 eql)
($error (parse-number ".2E3") <parse-error>)
($error (parse-number ".2E+3") <parse-error>)
($error (parse-number ".2E-3") <parse-error>)
($error (parse-number "+.2E3") <parse-error>)
($error (parse-number "+.2E+3") <parse-error>)
($error (parse-number "+.2E-3") <parse-error>)
($error (parse-number "-.2E3") <parse-error>)
($error (parse-number "-.2E+3") <parse-error>)
($error (parse-number "-.2E-3") <parse-error>)
($error (parse-number "1.E3") <parse-error>)
($error (parse-number "1.E+3") <parse-error>)
($error (parse-number "1.E-3") <parse-error>)
($error (parse-number "+1.E3") <parse-error>)
($error (parse-number "+1.E+3") <parse-error>)
($error (parse-number "+1.E-3") <parse-error>)
($error (parse-number "-1.E3") <parse-error>)
($error (parse-number "-1.E+3") <parse-error>)
($error (parse-number "-1.E-3") <parse-error>)
($error (parse-number "1.2E") <parse-error>)
($error (parse-number "1.2E+") <parse-error>)
($error (parse-number "1.2E-") <parse-error>)
($error (parse-number "+1.2E") <parse-error>)
($error (parse-number "+1.2E+") <parse-error>)
($error (parse-number "+1.2E-") <parse-error>)
($error (parse-number "-1.2E") <parse-error>)
($error (parse-number "-1.2E+") <parse-error>)
($error (parse-number "-1.2E-") <parse-error>)
($error (parse-number "123a.4E5") <parse-error>)
($error (parse-number "123a.4E+5") <parse-error>)
($error (parse-number "123a.4E-5") <parse-error>)
($error (parse-number "+123a.4E5") <parse-error>)
($error (parse-number "+123a.4E+5") <parse-error>)
($error (parse-number "+123a.4E-5") <parse-error>)
($error (parse-number "-123a.4E5") <parse-error>)
($error (parse-number "-123a.4E+5") <parse-error>)
($error (parse-number "-123a.4E-5") <parse-error>)
($error (parse-number "123.4aE5") <parse-error>)
($error (parse-number "123.4aE+5") <parse-error>)
($error (parse-number "123.4aE-5") <parse-error>)
($error (parse-number "+123.4aE5") <parse-error>)
($error (parse-number "+123.4aE+5") <parse-error>)
($error (parse-number "+123.4aE-5") <parse-error>)
($error (parse-number "-123.4aE5") <parse-error>)
($error (parse-number "-123.4aE+5") <parse-error>)
($error (parse-number "-123.4aE-5") <parse-error>)
($error (parse-number "123.4E5a") <parse-error>)
($error (parse-number "123.4E+5a") <parse-error>)
($error (parse-number "123.4E-5a") <parse-error>)
($error (parse-number "+123.4E5a") <parse-error>)
($error (parse-number "+123.4E+5a") <parse-error>)
($error (parse-number "+123.4E-5a") <parse-error>)
($error (parse-number "-123.4E5a") <parse-error>)
($error (parse-number "-123.4E+5a") <parse-error>)
($error (parse-number "-123.4E-5a") <parse-error>)
($error (parse-number "1.0E1000") <floating-point-overflow>)
($error (parse-number "1.0E+1000") <floating-point-overflow>)
($error (parse-number "1.0E-1000") <floating-point-underflow>)
($error (parse-number "+1.0E1000") <floating-point-overflow>)
($error (parse-number "+1.0E+1000") <floating-point-overflow>)
($error (parse-number "+1.0E-1000") <floating-point-underflow>)
($error (parse-number "-1.0E1000") <floating-point-overflow>)
($error (parse-number "-1.0E+1000") <floating-point-overflow>)
($error (parse-number "-1.0E-1000") <floating-point-underflow>)
;;; [s]dd...d.dd...de[s]dd...d
($test (parse-number "0.0e0") 0.0 eql)
($test (parse-number "0.0e+0") 0.0 eql)
($test (parse-number "0.0e-0") 0.0 eql)
($test (parse-number "+0.0e0") 0.0 eql)
($test (parse-number "+0.0e+0") 0.0 eql)
($test (parse-number "+0.0e-0") 0.0 eql)
($test (parse-number "-0.0e0") 0.0 eql)
($test (parse-number "-0.0e+0") 0.0 eql)
($test (parse-number "-0.0e-0") 0.0 eql)
($test (parse-number "9.9e9") 9.9E9 eql)
($test (parse-number "9.9e+9") 9.9E9 eql)
($test (parse-number "9.9e-9") 9.9E-9 eql)
($test (parse-number "+9.9e9") 9.9E9 eql)
($test (parse-number "+9.9e+9") 9.9E9 eql)
($test (parse-number "+9.9e-9") 9.9E-9 eql)
($test (parse-number "-9.9e9") -9.9E9 eql)
($test (parse-number "-9.9e+9") -9.9E9 eql)
($test (parse-number "-9.9e-9") -9.9E-9 eql)
($test (parse-number "1234.5678e90") 1234.5678E90 eql)
($test (parse-number "1234.5678e+90") 1234.5678E+90 eql)
($test (parse-number "1234.5678e-90") 1234.5678E-90 eql)
($test (parse-number "+1234.5678e90") 1234.5678E90 eql)
($test (parse-number "+1234.5678e+90") 1234.5678E+90 eql)
($test (parse-number "+1234.5678e-90") 1234.5678E-90 eql)
($test (parse-number "-1234.5678e90") -1234.5678E90 eql)
($test (parse-number "-1234.5678e+90") -1234.5678E+90 eql)
($test (parse-number "-1234.5678e-90") -1234.5678E-90 eql)
($error (parse-number ".2e3") <parse-error>)
($error (parse-number ".2e+3") <parse-error>)
($error (parse-number ".2e-3") <parse-error>)
($error (parse-number "+.2e3") <parse-error>)
($error (parse-number "+.2e+3") <parse-error>)
($error (parse-number "+.2e-3") <parse-error>)
($error (parse-number "-.2e3") <parse-error>)
($error (parse-number "-.2e+3") <parse-error>)
($error (parse-number "-.2e-3") <parse-error>)
($error (parse-number "1.e3") <parse-error>)
($error (parse-number "1.e+3") <parse-error>)
($error (parse-number "1.e-3") <parse-error>)
($error (parse-number "+1.e3") <parse-error>)
($error (parse-number "+1.e+3") <parse-error>)
($error (parse-number "+1.e-3") <parse-error>)
($error (parse-number "-1.e3") <parse-error>)
($error (parse-number "-1.e+3") <parse-error>)
($error (parse-number "-1.e-3") <parse-error>)
($error (parse-number "1.2e") <parse-error>)
($error (parse-number "1.2e+") <parse-error>)
($error (parse-number "1.2e-") <parse-error>)
($error (parse-number "+1.2e") <parse-error>)
($error (parse-number "+1.2e+") <parse-error>)
($error (parse-number "+1.2e-") <parse-error>)
($error (parse-number "-1.2e") <parse-error>)
($error (parse-number "-1.2e+") <parse-error>)
($error (parse-number "-1.2e-") <parse-error>)
($error (parse-number "123a.4e5") <parse-error>)
($error (parse-number "123a.4e+5") <parse-error>)
($error (parse-number "123a.4e-5") <parse-error>)
($error (parse-number "+123a.4e5") <parse-error>)
($error (parse-number "+123a.4e+5") <parse-error>)
($error (parse-number "+123a.4e-5") <parse-error>)
($error (parse-number "-123a.4e5") <parse-error>)
($error (parse-number "-123a.4e+5") <parse-error>)
($error (parse-number "-123a.4e-5") <parse-error>)
($error (parse-number "123.4ae5") <parse-error>)
($error (parse-number "123.4ae+5") <parse-error>)
($error (parse-number "123.4ae-5") <parse-error>)
($error (parse-number "+123.4ae5") <parse-error>)
($error (parse-number "+123.4ae+5") <parse-error>)
($error (parse-number "+123.4ae-5") <parse-error>)
($error (parse-number "-123.4ae5") <parse-error>)
($error (parse-number "-123.4ae+5") <parse-error>)
($error (parse-number "-123.4ae-5") <parse-error>)
($error (parse-number "123.4e5a") <parse-error>)
($error (parse-number "123.4e+5a") <parse-error>)
($error (parse-number "123.4e-5a") <parse-error>)
($error (parse-number "+123.4e5a") <parse-error>)
($error (parse-number "+123.4e+5a") <parse-error>)
($error (parse-number "+123.4e-5a") <parse-error>)
($error (parse-number "-123.4e5a") <parse-error>)
($error (parse-number "-123.4e+5a") <parse-error>)
($error (parse-number "-123.4e-5a") <parse-error>)
($error (parse-number "1.0e1000") <floating-point-overflow>)
($error (parse-number "1.0e+1000") <floating-point-overflow>)
($error (parse-number "1.0e-1000") <floating-point-underflow>)
($error (parse-number "+1.0e1000") <floating-point-overflow>)
($error (parse-number "+1.0e+1000") <floating-point-overflow>)
($error (parse-number "+1.0e-1000") <floating-point-underflow>)
($error (parse-number "-1.0e1000") <floating-point-overflow>)
($error (parse-number "-1.0e+1000") <floating-point-overflow>)
($error (parse-number "-1.0e-1000") <floating-point-underflow>)
;;; [s]dd...dE[s]dd...d
($test (parse-number "0E0") 0.0 eql)
($test (parse-number "0E+0") 0.0 eql)
($test (parse-number "0E-0") 0.0 eql)
($test (parse-number "+0E0") 0.0 eql)
($test (parse-number "+0E+0") 0.0 eql)
($test (parse-number "+0E-0") 0.0 eql)
($test (parse-number "-0E0") 0.0 eql)
($test (parse-number "-0E+0") 0.0 eql)
($test (parse-number "-0E-0") 0.0 eql)
($test (parse-number "9E9") 9e9 eql)
($test (parse-number "9E+9") 9e9 eql)
($test (parse-number "9E-9") 9e-9 eql)
($test (parse-number "+9E9") 9e9 eql)
($test (parse-number "+9E+9") 9e9 eql)
($test (parse-number "+9E-9") 9e-9 eql)
($test (parse-number "-9E9") -9e9 eql)
($test (parse-number "-9E+9") -9e9 eql)
($test (parse-number "-9E-9") -9e-9 eql)
($test (parse-number "12345678E90") 12345678e90 eql)
($test (parse-number "12345678E+90") 12345678e90 eql)
($test (parse-number "12345678E-90") 12345678e-90 eql)
($test (parse-number "+12345678E90") 12345678e90 eql)
($test (parse-number "+12345678E+90") 12345678e90 eql)
($test (parse-number "+12345678E-90") 12345678e-90 eql)
($test (parse-number "-12345678E90") -12345678e90 eql)
($test (parse-number "-12345678E+90") -12345678e90 eql)
($test (parse-number "-12345678E-90") -12345678e-90 eql)
($error (parse-number "E3") <parse-error>)
($error (parse-number "E+3") <parse-error>)
($error (parse-number "E-3") <parse-error>)
($error (parse-number "+E3") <parse-error>)
($error (parse-number "+E+3") <parse-error>)
($error (parse-number "+E-3") <parse-error>)
($error (parse-number "-E3") <parse-error>)
($error (parse-number "-E+3") <parse-error>)
($error (parse-number "-E-3") <parse-error>)
($error (parse-number "1E") <parse-error>)
($error (parse-number "1E+") <parse-error>)
($error (parse-number "1E-") <parse-error>)
($error (parse-number "+1E") <parse-error>)
($error (parse-number "+1E+") <parse-error>)
($error (parse-number "+1E-") <parse-error>)
($error (parse-number "-1E") <parse-error>)
($error (parse-number "-1E+") <parse-error>)
($error (parse-number "-1E-") <parse-error>)
($error (parse-number "123aE56") <parse-error>)
($error (parse-number "123aE+56") <parse-error>)
($error (parse-number "123aE-56") <parse-error>)
($error (parse-number "+123aE56") <parse-error>)
($error (parse-number "+123aE+56") <parse-error>)
($error (parse-number "+123aE-56") <parse-error>)
($error (parse-number "-123aE56") <parse-error>)
($error (parse-number "-123aE+56") <parse-error>)
($error (parse-number "-123aE-56") <parse-error>)
($error (parse-number "123E56a") <parse-error>)
($error (parse-number "123E+56a") <parse-error>)
($error (parse-number "123E-56a") <parse-error>)
($error (parse-number "+123E56a") <parse-error>)
($error (parse-number "+123E+56a") <parse-error>)
($error (parse-number "+123E-56a") <parse-error>)
($error (parse-number "-123E56a") <parse-error>)
($error (parse-number "-123E+56a") <parse-error>)
($error (parse-number "-123E-56a") <parse-error>)
($error (parse-number "1E1000") <floating-point-overflow>)
($error (parse-number "1E+1000") <floating-point-overflow>)
($error (parse-number "1E-1000") <floating-point-underflow>)
($error (parse-number "+1E1000") <floating-point-overflow>)
($error (parse-number "+1E+1000") <floating-point-overflow>)
($error (parse-number "+1E-1000") <floating-point-underflow>)
($error (parse-number "-1E1000") <floating-point-overflow>)
($error (parse-number "-1E+1000") <floating-point-overflow>)
($error (parse-number "-1E-1000") <floating-point-underflow>)
;;; [s]dd...de[s]dd...d
($test (parse-number "0e0") 0.0 eql)
($test (parse-number "0e+0") 0.0 eql)
($test (parse-number "0e-0") 0.0 eql)
($test (parse-number "+0e0") 0.0 eql)
($test (parse-number "+0e+0") 0.0 eql)
($test (parse-number "+0e-0") 0.0 eql)
($test (parse-number "-0e0") 0.0 eql)
($test (parse-number "-0e+0") 0.0 eql)
($test (parse-number "-0e-0") 0.0 eql)
($test (parse-number "9e9") 9E9 eql)
($test (parse-number "9e+9") 9E9 eql)
($test (parse-number "9e-9") 9E-9 eql)
($test (parse-number "+9e9") 9E9 eql)
($test (parse-number "+9e+9") 9E9 eql)
($test (parse-number "+9e-9") 9E-9 eql)
($test (parse-number "-9e9") -9E9 eql)
($test (parse-number "-9e+9") -9E9 eql)
($test (parse-number "-9e-9") -9E-9 eql)
($test (parse-number "12345678e90") 12345678E90 eql)
($test (parse-number "12345678e+90") 12345678E90 eql)
($test (parse-number "12345678e-90") 12345678E-90 eql)
($test (parse-number "+12345678e90") 12345678E90 eql)
($test (parse-number "+12345678e+90") 12345678E90 eql)
($test (parse-number "+12345678e-90") 12345678E-90 eql)
($test (parse-number "-12345678e90") -12345678E90 eql)
($test (parse-number "-12345678e+90") -12345678E90 eql)
($test (parse-number "-12345678e-90") -12345678E-90 eql)
($error (parse-number "e3") <parse-error>)
($error (parse-number "e+3") <parse-error>)
($error (parse-number "e-3") <parse-error>)
($error (parse-number "+e3") <parse-error>)
($error (parse-number "+e+3") <parse-error>)
($error (parse-number "+e-3") <parse-error>)
($error (parse-number "-e3") <parse-error>)
($error (parse-number "-e+3") <parse-error>)
($error (parse-number "-e-3") <parse-error>)
($error (parse-number "1e") <parse-error>)
($error (parse-number "1e+") <parse-error>)
($error (parse-number "1e-") <parse-error>)
($error (parse-number "+1e") <parse-error>)
($error (parse-number "+1e+") <parse-error>)
($error (parse-number "+1e-") <parse-error>)
($error (parse-number "-1e") <parse-error>)
($error (parse-number "-1e+") <parse-error>)
($error (parse-number "-1e-") <parse-error>)
($error (parse-number "123ae56") <parse-error>)
($error (parse-number "123ae+56") <parse-error>)
($error (parse-number "123ae-56") <parse-error>)
($error (parse-number "+123ae56") <parse-error>)
($error (parse-number "+123ae+56") <parse-error>)
($error (parse-number "+123ae-56") <parse-error>)
($error (parse-number "-123ae56") <parse-error>)
($error (parse-number "-123ae+56") <parse-error>)
($error (parse-number "-123ae-56") <parse-error>)
($error (parse-number "123e56a") <parse-error>)
($error (parse-number "123e+56a") <parse-error>)
($error (parse-number "123e-56a") <parse-error>)
($error (parse-number "+123e56a") <parse-error>)
($error (parse-number "+123e+56a") <parse-error>)
($error (parse-number "+123e-56a") <parse-error>)
($error (parse-number "-123e56a") <parse-error>)
($error (parse-number "-123e+56a") <parse-error>)
($error (parse-number "-123e-56a") <parse-error>)
;($error (parse-number "1e1000") <floating-point-overflow>)
;($error (parse-number "1e+1000") <floating-point-overflow>)
;($error (parse-number "1e-1000") <floating-point-underflow>)
;($error (parse-number "+1e1000") <floating-point-overflow>)
;($error (parse-number "+1e+1000") <floating-point-overflow>)
;($error (parse-number "+1e-1000") <floating-point-underflow>)
;($error (parse-number "-1e1000") <floating-point-overflow>)
;($error (parse-number "-1e+1000") <floating-point-overflow>)
;($error (parse-number "-1e-1000") <floating-point-underflow>)
;;;
($error (parse-number "#") <parse-error>)
($error (parse-number "#a") <parse-error>)
($error (parse-number "#a1") <parse-error>)
;;;
;;; function (= x1 x2) --> boolean
;;;
($ap 2 "=" P.67)
($test (= 3 4) nil)
($test (= 3 3.0) t)
($test (= (parse-number "134.54") 134.54) t)
($test (= 0.0 -0.0) t)
;;;
($argc = 2 0 0)
($type = ($integer $float) :target 1)
($type = ($integer $float) 1 :target)
;;;
($test (= -1234567890 -1234567890)   t)
($test (= -1234567890        -123) nil)
($test (= -1234567890           0) nil)
($test (= -1234567890         123) nil)
($test (= -1234567890  1234567890) nil)
($test (= -1234567890 -1234567890.0)   t)
($test (= -1234567890        -123.0) nil)
($test (= -1234567890           0.0) nil)
($test (= -1234567890         123.0) nil)
($test (= -1234567890  1234567890.0) nil)
($test (= -1234567890 *most-negative-float*) nil)
($test (= -1234567890 *most-positive-float*) nil)
($test (=        -123 -1234567890) nil)
($test (=        -123        -123)   t)
($test (=        -123           0) nil)
($test (=        -123         123) nil)
($test (=        -123  1234567890) nil)
($test (=        -123 -1234567890.0) nil)
($test (=        -123        -123.0)   t)
($test (=        -123           0.0) nil)
($test (=        -123         123.0) nil)
($test (=        -123  1234567890.0) nil)
($test (=        -123 *most-negative-float*) nil)
($test (=        -123 *most-positive-float*) nil)
($test (=           0 -1234567890) nil)
($test (=           0        -123) nil)
($test (=           0           0)   t)
($test (=           0         123) nil)
($test (=           0  1234567890) nil)
($test (=           0 -1234567890.0) nil)
($test (=           0        -123.0) nil)
($test (=           0           0.0)   t)
($test (=           0         123.0) nil)
($test (=           0  1234567890.0) nil)
($test (=           0 *most-negative-float*) nil)
($test (=           0 *most-positive-float*) nil)
($test (=         123 -1234567890) nil)
($test (=         123        -123) nil)
($test (=         123           0) nil)
($test (=         123         123)   t)
($test (=         123  1234567890) nil)
($test (=         123 -1234567890.0) nil)
($test (=         123        -123.0) nil)
($test (=         123           0.0) nil)
($test (=         123         123.0)   t)
($test (=         123  1234567890.0) nil)
($test (=         123 *most-negative-float*) nil)
($test (=         123 *most-positive-float*) nil)
($test (=  1234567890 -1234567890) nil)
($test (=  1234567890        -123) nil)
($test (=  1234567890           0) nil)
($test (=  1234567890         123) nil)
($test (=  1234567890  1234567890)   t)
($test (=  1234567890 -1234567890.0) nil)
($test (=  1234567890        -123.0) nil)
($test (=  1234567890           0.0) nil)
($test (=  1234567890         123.0) nil)
($test (=  1234567890  1234567890.0)   t)
($test (=  1234567890 *most-negative-float*) nil)
($test (=  1234567890 *most-positive-float*) nil)
($test (= -1234567890.0 -1234567890)   t)
($test (= -1234567890.0        -123) nil)
($test (= -1234567890.0           0) nil)
($test (= -1234567890.0         123) nil)
($test (= -1234567890.0  1234567890) nil)
($test (= -1234567890.0 -1234567890.0)   t)
($test (= -1234567890.0        -123.0) nil)
($test (= -1234567890.0           0.0) nil)
($test (= -1234567890.0         123.0) nil)
($test (= -1234567890.0  1234567890.0) nil)
($test (= -1234567890.0 *most-negative-float*) nil)
($test (= -1234567890.0 *most-positive-float*) nil)
($test (=        -123.0 -1234567890) nil)
($test (=        -123.0        -123)   t)
($test (=        -123.0           0) nil)
($test (=        -123.0         123) nil)
($test (=        -123.0  1234567890) nil)
($test (=        -123.0 -1234567890.0) nil)
($test (=        -123.0        -123.0)   t)
($test (=        -123.0           0.0) nil)
($test (=        -123.0         123.0) nil)
($test (=        -123.0  1234567890.0) nil)
($test (=        -123.0 *most-negative-float*) nil)
($test (=        -123.0 *most-positive-float*) nil)
($test (=           0.0 -1234567890) nil)
($test (=           0.0        -123) nil)
($test (=           0.0           0)   t)
($test (=           0.0         123) nil)
($test (=           0.0  1234567890) nil)
($test (=           0.0 -1234567890.0) nil)
($test (=           0.0        -123.0) nil)
($test (=           0.0           0.0)   t)
($test (=           0.0         123.0) nil)
($test (=           0.0  1234567890.0) nil)
($test (=           0.0 *most-negative-float*) nil)
($test (=           0.0 *most-positive-float*) nil)
($test (=         123.0 -1234567890) nil)
($test (=         123.0        -123) nil)
($test (=         123.0           0) nil)
($test (=         123.0         123)   t)
($test (=         123.0  1234567890) nil)
($test (=         123.0 -1234567890.0) nil)
($test (=         123.0        -123.0) nil)
($test (=         123.0           0.0) nil)
($test (=         123.0         123.0)   t)
($test (=         123.0  1234567890.0) nil)
($test (=         123.0 *most-negative-float*) nil)
($test (=         123.0 *most-positive-float*) nil)
($test (=  1234567890.0 -1234567890) nil)
($test (=  1234567890.0        -123) nil)
($test (=  1234567890.0           0) nil)
($test (=  1234567890.0         123) nil)
($test (=  1234567890.0  1234567890)   t)
($test (=  1234567890.0 -1234567890.0) nil)
($test (=  1234567890.0        -123.0) nil)
($test (=  1234567890.0           0.0) nil)
($test (=  1234567890.0         123.0) nil)
($test (=  1234567890.0  1234567890.0)   t)
($test (=  1234567890.0 *most-negative-float*) nil)
($test (=  1234567890.0 *most-positive-float*) nil)
($test (= *most-negative-float* -1234567890) nil)
($test (= *most-negative-float*        -123) nil)
($test (= *most-negative-float*           0) nil)
($test (= *most-negative-float*         123) nil)
($test (= *most-negative-float*  1234567890) nil)
($test (= *most-negative-float* -1234567890.0) nil)
($test (= *most-negative-float*        -123.0) nil)
($test (= *most-negative-float*           0.0) nil)
($test (= *most-negative-float*         123.0) nil)
($test (= *most-negative-float*  1234567890.0) nil)
($test (= *most-negative-float* *most-negative-float*)   t)
($test (= *most-negative-float* *most-positive-float*) nil)
($test (= *most-positive-float* -1234567890) nil)
($test (= *most-positive-float*        -123) nil)
($test (= *most-positive-float*           0) nil)
($test (= *most-positive-float*         123) nil)
($test (= *most-positive-float*  1234567890) nil)
($test (= *most-positive-float* -1234567890.0) nil)
($test (= *most-positive-float*        -123.0) nil)
($test (= *most-positive-float*           0.0) nil)
($test (= *most-positive-float*         123.0) nil)
($test (= *most-positive-float*  1234567890.0) nil)
($test (= *most-positive-float* *most-negative-float*) nil)
($test (= *most-positive-float* *most-positive-float*)   t)

;;;
;;; function (/= x1 x2) --> boolean
;;;
($ap 2 "/=" P.68)
($test (/= 3 4) t)
($test (/= 3 3.0) nil)
($test (/= (parse-number "134.54") 134.54) nil)
;;;
($argc /= 2 0 0)
($type /= ($integer $float) :target 1)
($type /= ($integer $float) 1 :target)
;;;
($test (/= -1234567890 -1234567890) nil)
($test (/= -1234567890        -123)   t)
($test (/= -1234567890           0)   t)
($test (/= -1234567890         123)   t)
($test (/= -1234567890  1234567890)   t)
($test (/= -1234567890 -1234567890.0) nil)
($test (/= -1234567890        -123.0)   t)
($test (/= -1234567890           0.0)   t)
($test (/= -1234567890         123.0)   t)
($test (/= -1234567890  1234567890.0)   t)
($test (/= -1234567890 *most-negative-float*)   t)
($test (/= -1234567890 *most-positive-float*)   t)
($test (/=        -123 -1234567890)   t)
($test (/=        -123        -123) nil)
($test (/=        -123           0)   t)
($test (/=        -123         123)   t)
($test (/=        -123  1234567890)   t)
($test (/=        -123 -1234567890.0)   t)
($test (/=        -123        -123.0) nil)
($test (/=        -123           0.0)   t)
($test (/=        -123         123.0)   t)
($test (/=        -123  1234567890.0)   t)
($test (/=        -123 *most-negative-float*)   t)
($test (/=        -123 *most-positive-float*)   t)
($test (/=           0 -1234567890)   t)
($test (/=           0        -123)   t)
($test (/=           0           0) nil)
($test (/=           0         123)   t)
($test (/=           0  1234567890)   t)
($test (/=           0 -1234567890.0)   t)
($test (/=           0        -123.0)   t)
($test (/=           0           0.0) nil)
($test (/=           0         123.0)   t)
($test (/=           0  1234567890.0)   t)
($test (/=           0 *most-negative-float*)   t)
($test (/=           0 *most-positive-float*)   t)
($test (/=         123 -1234567890)   t)
($test (/=         123        -123)   t)
($test (/=         123           0)   t)
($test (/=         123         123) nil)
($test (/=         123  1234567890)   t)
($test (/=         123 -1234567890.0)   t)
($test (/=         123        -123.0)   t)
($test (/=         123           0.0)   t)
($test (/=         123         123.0) nil)
($test (/=         123  1234567890.0)   t)
($test (/=         123 *most-negative-float*)   t)
($test (/=         123 *most-positive-float*)   t)
($test (/=  1234567890 -1234567890)   t)
($test (/=  1234567890        -123)   t)
($test (/=  1234567890           0)   t)
($test (/=  1234567890         123)   t)
($test (/=  1234567890  1234567890) nil)
($test (/=  1234567890 -1234567890.0)   t)
($test (/=  1234567890        -123.0)   t)
($test (/=  1234567890           0.0)   t)
($test (/=  1234567890         123.0)   t)
($test (/=  1234567890  1234567890.0) nil)
($test (/=  1234567890 *most-negative-float*)   t)
($test (/=  1234567890 *most-positive-float*)   t)
($test (/= -1234567890.0 -1234567890) nil)
($test (/= -1234567890.0        -123)   t)
($test (/= -1234567890.0           0)   t)
($test (/= -1234567890.0         123)   t)
($test (/= -1234567890.0  1234567890)   t)
($test (/= -1234567890.0 -1234567890.0) nil)
($test (/= -1234567890.0        -123.0)   t)
($test (/= -1234567890.0           0.0)   t)
($test (/= -1234567890.0         123.0)   t)
($test (/= -1234567890.0  1234567890.0)   t)
($test (/= -1234567890.0 *most-negative-float*)   t)
($test (/= -1234567890.0 *most-positive-float*)   t)
($test (/=        -123.0 -1234567890)   t)
($test (/=        -123.0        -123) nil)
($test (/=        -123.0           0)   t)
($test (/=        -123.0         123)   t)
($test (/=        -123.0  1234567890)   t)
($test (/=        -123.0 -1234567890.0)   t)
($test (/=        -123.0        -123.0) nil)
($test (/=        -123.0           0.0)   t)
($test (/=        -123.0         123.0)   t)
($test (/=        -123.0  1234567890.0)   t)
($test (/=        -123.0 *most-negative-float*)   t)
($test (/=        -123.0 *most-positive-float*)   t)
($test (/=           0.0 -1234567890)   t)
($test (/=           0.0        -123)   t)
($test (/=           0.0           0) nil)
($test (/=           0.0         123)   t)
($test (/=           0.0  1234567890)   t)
($test (/=           0.0 -1234567890.0)   t)
($test (/=           0.0        -123.0)   t)
($test (/=           0.0           0.0) nil)
($test (/=           0.0         123.0)   t)
($test (/=           0.0  1234567890.0)   t)
($test (/=           0.0 *most-negative-float*)   t)
($test (/=           0.0 *most-positive-float*)   t)
($test (/=         123.0 -1234567890)   t)
($test (/=         123.0        -123)   t)
($test (/=         123.0           0)   t)
($test (/=         123.0         123) nil)
($test (/=         123.0  1234567890)   t)
($test (/=         123.0 -1234567890.0)   t)
($test (/=         123.0        -123.0)   t)
($test (/=         123.0           0.0)   t)
($test (/=         123.0         123.0) nil)
($test (/=         123.0  1234567890.0)   t)
($test (/=         123.0 *most-negative-float*)   t)
($test (/=         123.0 *most-positive-float*)   t)
($test (/=  1234567890.0 -1234567890)   t)
($test (/=  1234567890.0        -123)   t)
($test (/=  1234567890.0           0)   t)
($test (/=  1234567890.0         123)   t)
($test (/=  1234567890.0  1234567890) nil)
($test (/=  1234567890.0 -1234567890.0)   t)
($test (/=  1234567890.0        -123.0)   t)
($test (/=  1234567890.0           0.0)   t)
($test (/=  1234567890.0         123.0)   t)
($test (/=  1234567890.0  1234567890.0) nil)
($test (/=  1234567890.0 *most-negative-float*)   t)
($test (/=  1234567890.0 *most-positive-float*)   t)
($test (/= *most-negative-float* -1234567890)   t)
($test (/= *most-negative-float*        -123)   t)
($test (/= *most-negative-float*           0)   t)
($test (/= *most-negative-float*         123)   t)
($test (/= *most-negative-float*  1234567890)   t)
($test (/= *most-negative-float* -1234567890.0)   t)
($test (/= *most-negative-float*        -123.0)   t)
($test (/= *most-negative-float*           0.0)   t)
($test (/= *most-negative-float*         123.0)   t)
($test (/= *most-negative-float*  1234567890.0)   t)
($test (/= *most-negative-float* *most-negative-float*) nil)
($test (/= *most-negative-float* *most-positive-float*)   t)
($test (/= *most-positive-float* -1234567890)   t)
($test (/= *most-positive-float*        -123)   t)
($test (/= *most-positive-float*           0)   t)
($test (/= *most-positive-float*         123)   t)
($test (/= *most-positive-float*  1234567890)   t)
($test (/= *most-positive-float* -1234567890.0)   t)
($test (/= *most-positive-float*        -123.0)   t)
($test (/= *most-positive-float*           0.0)   t)
($test (/= *most-positive-float*         123.0)   t)
($test (/= *most-positive-float*  1234567890.0)   t)
($test (/= *most-positive-float* *most-negative-float*)   t)
($test (/= *most-positive-float* *most-positive-float*) nil)

;;;
;;; function (>= x1 x2) --> boolean
;;;
($ap 2 ">=" P.68)
($test (>= 2 2) t)
($test (>= 2.0 2) t)
($test (>= -1 2) nil)
;;;
($argc >= 2 0 0)
($type >= ($integer $float) :target 1)
($type >= ($integer $float) 1 :target)
;;;
($test (>= -1234567890 -1234567891)   t)
($test (>= -1234567890 -1234567890)   t)
($test (>= -1234567890 -1234567889) nil)
($test (>= -1234567890        -123) nil)
($test (>= -1234567890           0) nil)
($test (>= -1234567890         123) nil)
($test (>= -1234567890  1234567889) nil)
($test (>= -1234567890  1234567890) nil)
($test (>= -1234567890  1234567891) nil)
($test (>= -1234567890 -1234567890.0)   t)
($test (>= -1234567890        -123.0) nil)
($test (>= -1234567890           0.0) nil)
($test (>= -1234567890         123.0) nil)
($test (>= -1234567890  1234567890.0) nil)
($test (>= -1234567890 *most-negative-float*)   t)
($test (>= -1234567890 *most-positive-float*) nil)
($test (>=        -123 -1234567890)   t)
($test (>=        -123        -124)   t)
($test (>=        -123        -123)   t)
($test (>=        -123        -122) nil)
($test (>=        -123           0) nil)
($test (>=        -123         122) nil)
($test (>=        -123         123) nil)
($test (>=        -123         124) nil)
($test (>=        -123  1234567890) nil)
($test (>=        -123 -1234567890.0)   t)
($test (>=        -123        -123.0)   t)
($test (>=        -123           0.0) nil)
($test (>=        -123         123.0) nil)
($test (>=        -123  1234567890.0) nil)
($test (>=        -123 *most-negative-float*)   t)
($test (>=        -123 *most-positive-float*) nil)
($test (>=           0 -1234567890)   t)
($test (>=           0        -123)   t)
($test (>=           0          -1)   t)
($test (>=           0           0)   t)
($test (>=           0           1) nil)
($test (>=           0         123) nil)
($test (>=           0  1234567890) nil)
($test (>=           0 -1234567890.0)   t)
($test (>=           0        -123.0)   t)
($test (>=           0           0.0)   t)
($test (>=           0         123.0) nil)
($test (>=           0  1234567890.0) nil)
($test (>=           0 *most-negative-float*)   t)
($test (>=           0 *most-positive-float*) nil)
($test (>=         123 -1234567890)   t)
($test (>=         123        -124)   t)
($test (>=         123        -123)   t)
($test (>=         123        -122)   t)
($test (>=         123           0)   t)
($test (>=         123         122)   t)
($test (>=         123         123)   t)
($test (>=         123         124) nil)
($test (>=         123  1234567890) nil)
($test (>=         123 -1234567890.0)   t)
($test (>=         123        -123.0)   t)
($test (>=         123           0.0)   t)
($test (>=         123         123.0)   t)
($test (>=         123  1234567890.0) nil)
($test (>=         123 *most-negative-float*)   t)
($test (>=         123 *most-positive-float*) nil)
($test (>=  1234567890 -1234567891)   t)
($test (>=  1234567890 -1234567890)   t)
($test (>=  1234567890 -1234567889)   t)
($test (>=  1234567890        -123)   t)
($test (>=  1234567890           0)   t)
($test (>=  1234567890         123)   t)
($test (>=  1234567890  1234567889)   t)
($test (>=  1234567890  1234567890)   t)
($test (>=  1234567890  1234567891) nil)
($test (>=  1234567890 -1234567890.0)   t)
($test (>=  1234567890        -123.0)   t)
($test (>=  1234567890           0.0)   t)
($test (>=  1234567890         123.0)   t)
($test (>=  1234567890  1234567890.0)   t)
($test (>=  1234567890 *most-negative-float*)   t)
($test (>=  1234567890 *most-positive-float*) nil)
($test (>= -1234567890.0 -1234567890)   t)
($test (>= -1234567890.0        -123) nil)
($test (>= -1234567890.0           0) nil)
($test (>= -1234567890.0         123) nil)
($test (>= -1234567890.0  1234567890) nil)
($test (>= -1234567890.0 -1234567890.0)   t)
($test (>= -1234567890.0        -123.0) nil)
($test (>= -1234567890.0           0.0) nil)
($test (>= -1234567890.0         123.0) nil)
($test (>= -1234567890.0  1234567890.0) nil)
($test (>= -1234567890.0 *most-negative-float*)   t)
($test (>= -1234567890.0 *most-positive-float*) nil)
($test (>=        -123.0 -1234567890)   t)
($test (>=        -123.0        -123)   t)
($test (>=        -123.0           0) nil)
($test (>=        -123.0         123) nil)
($test (>=        -123.0  1234567890) nil)
($test (>=        -123.0 -1234567890.0)   t)
($test (>=        -123.0        -123.0)   t)
($test (>=        -123.0           0.0) nil)
($test (>=        -123.0         123.0) nil)
($test (>=        -123.0  1234567890.0) nil)
($test (>=        -123.0 *most-negative-float*)   t)
($test (>=        -123.0 *most-positive-float*) nil)
($test (>=           0.0 -1234567890)   t)
($test (>=           0.0        -123)   t)
($test (>=           0.0           0)   t)
($test (>=           0.0         123) nil)
($test (>=           0.0  1234567890) nil)
($test (>=           0.0 -1234567890.0)   t)
($test (>=           0.0        -123.0)   t)
($test (>=           0.0           0.0)   t)
($test (>=           0.0         123.0) nil)
($test (>=           0.0  1234567890.0) nil)
($test (>=           0.0 *most-negative-float*)   t)
($test (>=           0.0 *most-positive-float*) nil)
($test (>=         123.0 -1234567890)   t)
($test (>=         123.0        -123)   t)
($test (>=         123.0           0)   t)
($test (>=         123.0         123)   t)
($test (>=         123.0  1234567890) nil)
($test (>=         123.0 -1234567890.0)   t)
($test (>=         123.0        -123.0)   t)
($test (>=         123.0           0.0)   t)
($test (>=         123.0         123.0)   t)
($test (>=         123.0  1234567890.0) nil)
($test (>=         123.0 *most-negative-float*)   t)
($test (>=         123.0 *most-positive-float*) nil)
($test (>=  1234567890.0 -1234567890)   t)
($test (>=  1234567890.0        -123)   t)
($test (>=  1234567890.0           0)   t)
($test (>=  1234567890.0         123)   t)
($test (>=  1234567890.0  1234567890)   t)
($test (>=  1234567890.0 -1234567890.0)   t)
($test (>=  1234567890.0        -123.0)   t)
($test (>=  1234567890.0           0.0)   t)
($test (>=  1234567890.0         123.0)   t)
($test (>=  1234567890.0  1234567890.0)   t)
($test (>=  1234567890.0 *most-negative-float*)   t)
($test (>=  1234567890.0 *most-positive-float*) nil)
($test (>= *most-negative-float* -1234567890) nil)
($test (>= *most-negative-float*        -123) nil)
($test (>= *most-negative-float*           0) nil)
($test (>= *most-negative-float*         123) nil)
($test (>= *most-negative-float*  1234567890) nil)
($test (>= *most-negative-float* -1234567890.0) nil)
($test (>= *most-negative-float*        -123.0) nil)
($test (>= *most-negative-float*           0.0) nil)
($test (>= *most-negative-float*         123.0) nil)
($test (>= *most-negative-float*  1234567890.0) nil)
($test (>= *most-negative-float* *most-negative-float*)   t)
($test (>= *most-negative-float* *most-positive-float*) nil)
($test (>= *most-positive-float* -1234567890)   t)
($test (>= *most-positive-float*        -123)   t)
($test (>= *most-positive-float*           0)   t)
($test (>= *most-positive-float*         123)   t)
($test (>= *most-positive-float*  1234567890)   t)
($test (>= *most-positive-float* -1234567890.0)   t)
($test (>= *most-positive-float*        -123.0)   t)
($test (>= *most-positive-float*           0.0)   t)
($test (>= *most-positive-float*         123.0)   t)
($test (>= *most-positive-float*  1234567890.0)   t)
($test (>= *most-positive-float* *most-negative-float*)   t)
($test (>= *most-positive-float* *most-positive-float*)   t)

;;;
;;; function (<= x1 x2) --> boolean
;;;
($ap 2 "<=" P.68)
($test (<= -1 2) t)
($test (<= 2 -1) nil)
;;;
($argc <= 2 0 0)
($type <= ($integer $float) :target 1)
($type <= ($integer $float) 1 :target)
;;;
($test (<= -1234567890 -1234567891) nil)
($test (<= -1234567890 -1234567890)   t)
($test (<= -1234567890 -1234567889)   t)
($test (<= -1234567890        -123)   t)
($test (<= -1234567890           0)   t)
($test (<= -1234567890         123)   t)
($test (<= -1234567890  1234567889)   t)
($test (<= -1234567890  1234567890)   t)
($test (<= -1234567890  1234567891)   t)
($test (<= -1234567890 -1234567890.0)   t)
($test (<= -1234567890        -123.0)   t)
($test (<= -1234567890           0.0)   t)
($test (<= -1234567890         123.0)   t)
($test (<= -1234567890  1234567890.0)   t)
($test (<= -1234567890 *most-negative-float*) nil)
($test (<= -1234567890 *most-positive-float*)   t)
($test (<=        -123 -1234567890) nil)
($test (<=        -123        -124) nil)
($test (<=        -123        -123)   t)
($test (<=        -123        -122)   t)
($test (<=        -123           0)   t)
($test (<=        -123         122)   t)
($test (<=        -123         123)   t)
($test (<=        -123         124)   t)
($test (<=        -123  1234567890)   t)
($test (<=        -123 -1234567890.0) nil)
($test (<=        -123        -123.0)   t)
($test (<=        -123           0.0)   t)
($test (<=        -123         123.0)   t)
($test (<=        -123  1234567890.0)   t)
($test (<=        -123 *most-negative-float*) nil)
($test (<=        -123 *most-positive-float*)   t)
($test (<=           0 -1234567890) nil)
($test (<=           0        -123) nil)
($test (<=           0          -1) nil)
($test (<=           0           0)   t)
($test (<=           0           1)   t)
($test (<=           0         123)   t)
($test (<=           0  1234567890)   t)
($test (<=           0 -1234567890.0) nil)
($test (<=           0        -123.0) nil)
($test (<=           0           0.0)   t)
($test (<=           0         123.0)   t)
($test (<=           0  1234567890.0)   t)
($test (<=           0 *most-negative-float*) nil)
($test (<=           0 *most-positive-float*)   t)
($test (<=         123 -1234567890) nil)
($test (<=         123        -124) nil)
($test (<=         123        -123) nil)
($test (<=         123        -122) nil)
($test (<=         123           0) nil)
($test (<=         123         122) nil)
($test (<=         123         123)   t)
($test (<=         123         124)   t)
($test (<=         123  1234567890)   t)
($test (<=         123 -1234567890.0) nil)
($test (<=         123        -123.0) nil)
($test (<=         123           0.0) nil)
($test (<=         123         123.0)   t)
($test (<=         123  1234567890.0)   t)
($test (<=         123 *most-negative-float*) nil)
($test (<=         123 *most-positive-float*)   t)
($test (<=  1234567890 -1234567891) nil)
($test (<=  1234567890 -1234567890) nil)
($test (<=  1234567890 -1234567889) nil)
($test (<=  1234567890        -123) nil)
($test (<=  1234567890           0) nil)
($test (<=  1234567890         123) nil)
($test (<=  1234567890  1234567889) nil)
($test (<=  1234567890  1234567890)   t)
($test (<=  1234567890  1234567891)   t)
($test (<=  1234567890 -1234567890.0) nil)
($test (<=  1234567890        -123.0) nil)
($test (<=  1234567890           0.0) nil)
($test (<=  1234567890         123.0) nil)
($test (<=  1234567890  1234567890.0)   t)
($test (<=  1234567890 *most-negative-float*) nil)
($test (<=  1234567890 *most-positive-float*)   t)
($test (<= -1234567890.0 -1234567890)   t)
($test (<= -1234567890.0        -123)   t)
($test (<= -1234567890.0           0)   t)
($test (<= -1234567890.0         123)   t)
($test (<= -1234567890.0  1234567890)   t)
($test (<= -1234567890.0 -1234567890.0)   t)
($test (<= -1234567890.0        -123.0)   t)
($test (<= -1234567890.0           0.0)   t)
($test (<= -1234567890.0         123.0)   t)
($test (<= -1234567890.0  1234567890.0)   t)
($test (<= -1234567890.0 *most-negative-float*) nil)
($test (<= -1234567890.0 *most-positive-float*)   t)
($test (<=        -123.0 -1234567890) nil)
($test (<=        -123.0        -123)   t)
($test (<=        -123.0           0)   t)
($test (<=        -123.0         123)   t)
($test (<=        -123.0  1234567890)   t)
($test (<=        -123.0 -1234567890.0) nil)
($test (<=        -123.0        -123.0)   t)
($test (<=        -123.0           0.0)   t)
($test (<=        -123.0         123.0)   t)
($test (<=        -123.0  1234567890.0)   t)
($test (<=        -123.0 *most-negative-float*) nil)
($test (<=        -123.0 *most-positive-float*)   t)
($test (<=           0.0 -1234567890) nil)
($test (<=           0.0        -123) nil)
($test (<=           0.0           0)   t)
($test (<=           0.0         123)   t)
($test (<=           0.0  1234567890)   t)
($test (<=           0.0 -1234567890.0) nil)
($test (<=           0.0        -123.0) nil)
($test (<=           0.0           0.0)   t)
($test (<=           0.0         123.0)   t)
($test (<=           0.0  1234567890.0)   t)
($test (<=           0.0 *most-negative-float*) nil)
($test (<=           0.0 *most-positive-float*)   t)
($test (<=         123.0 -1234567890) nil)
($test (<=         123.0        -123) nil)
($test (<=         123.0           0) nil)
($test (<=         123.0         123)   t)
($test (<=         123.0  1234567890)   t)
($test (<=         123.0 -1234567890.0) nil)
($test (<=         123.0        -123.0) nil)
($test (<=         123.0           0.0) nil)
($test (<=         123.0         123.0)   t)
($test (<=         123.0  1234567890.0)   t)
($test (<=         123.0 *most-negative-float*) nil)
($test (<=         123.0 *most-positive-float*)   t)
($test (<=  1234567890.0 -1234567890) nil)
($test (<=  1234567890.0        -123) nil)
($test (<=  1234567890.0           0) nil)
($test (<=  1234567890.0         123) nil)
($test (<=  1234567890.0  1234567890)   t)
($test (<=  1234567890.0 -1234567890.0) nil)
($test (<=  1234567890.0        -123.0) nil)
($test (<=  1234567890.0           0.0) nil)
($test (<=  1234567890.0         123.0) nil)
($test (<=  1234567890.0  1234567890.0)   t)
($test (<=  1234567890.0 *most-negative-float*) nil)
($test (<=  1234567890.0 *most-positive-float*)   t)
($test (<= *most-negative-float* -1234567890)   t)
($test (<= *most-negative-float*        -123)   t)
($test (<= *most-negative-float*           0)   t)
($test (<= *most-negative-float*         123)   t)
($test (<= *most-negative-float*  1234567890)   t)
($test (<= *most-negative-float* -1234567890.0)   t)
($test (<= *most-negative-float*        -123.0)   t)
($test (<= *most-negative-float*           0.0)   t)
($test (<= *most-negative-float*         123.0)   t)
($test (<= *most-negative-float*  1234567890.0)   t)
($test (<= *most-negative-float* *most-negative-float*)   t)
($test (<= *most-negative-float* *most-positive-float*)   t)
($test (<= *most-positive-float* -1234567890) nil)
($test (<= *most-positive-float*        -123) nil)
($test (<= *most-positive-float*           0) nil)
($test (<= *most-positive-float*         123) nil)
($test (<= *most-positive-float*  1234567890) nil)
($test (<= *most-positive-float* -1234567890.0) nil)
($test (<= *most-positive-float*        -123.0) nil)
($test (<= *most-positive-float*           0.0) nil)
($test (<= *most-positive-float*         123.0) nil)
($test (<= *most-positive-float*  1234567890.0) nil)
($test (<= *most-positive-float* *most-negative-float*) nil)
($test (<= *most-positive-float* *most-positive-float*)   t)

;;;
;;; function (> x1 x2) --> boolean
;;;
($ap 2 ">" P.68)
($test (> 2 2) nil)
($test (> 2.0 2) nil)
($test (> 2 -10) t)
($test (> 100 3) t)
;;;
($argc > 2 0 0)
($type > ($integer $float) :target 1)
($type > ($integer $float) 1 :target)
;;;
($test (> -1234567890 -1234567891)   t)
($test (> -1234567890 -1234567890) nil)
($test (> -1234567890 -1234567889) nil)
($test (> -1234567890        -123) nil)
($test (> -1234567890           0) nil)
($test (> -1234567890         123) nil)
($test (> -1234567890  1234567889) nil)
($test (> -1234567890  1234567890) nil)
($test (> -1234567890  1234567891) nil)
($test (> -1234567890 -1234567890.0) nil)
($test (> -1234567890        -123.0) nil)
($test (> -1234567890           0.0) nil)
($test (> -1234567890         123.0) nil)
($test (> -1234567890  1234567890.0) nil)
($test (> -1234567890 *most-negative-float*)   t)
($test (> -1234567890 *most-positive-float*) nil)
($test (>        -123 -1234567890)   t)
($test (>        -123        -124)   t)
($test (>        -123        -123) nil)
($test (>        -123        -122) nil)
($test (>        -123           0) nil)
($test (>        -123         122) nil)
($test (>        -123         123) nil)
($test (>        -123         124) nil)
($test (>        -123  1234567890) nil)
($test (>        -123 -1234567890.0)   t)
($test (>        -123        -123.0) nil)
($test (>        -123           0.0) nil)
($test (>        -123         123.0) nil)
($test (>        -123  1234567890.0) nil)
($test (>        -123 *most-negative-float*)   t)
($test (>        -123 *most-positive-float*) nil)
($test (>           0 -1234567890)   t)
($test (>           0        -123)   t)
($test (>           0          -1)   t)
($test (>           0           0) nil)
($test (>           0           1) nil)
($test (>           0         123) nil)
($test (>           0  1234567890) nil)
($test (>           0 -1234567890.0)   t)
($test (>           0        -123.0)   t)
($test (>           0           0.0) nil)
($test (>           0         123.0) nil)
($test (>           0  1234567890.0) nil)
($test (>           0 *most-negative-float*)   t)
($test (>           0 *most-positive-float*) nil)
($test (>         123 -1234567890)   t)
($test (>         123        -124)   t)
($test (>         123        -123)   t)
($test (>         123        -122)   t)
($test (>         123           0)   t)
($test (>         123         122)   t)
($test (>         123         123) nil)
($test (>         123         124) nil)
($test (>         123  1234567890) nil)
($test (>         123 -1234567890.0)   t)
($test (>         123        -123.0)   t)
($test (>         123           0.0)   t)
($test (>         123         123.0) nil)
($test (>         123  1234567890.0) nil)
($test (>         123 *most-negative-float*)   t)
($test (>         123 *most-positive-float*) nil)
($test (>  1234567890 -1234567891)   t)
($test (>  1234567890 -1234567890)   t)
($test (>  1234567890 -1234567889)   t)
($test (>  1234567890        -123)   t)
($test (>  1234567890           0)   t)
($test (>  1234567890         123)   t)
($test (>  1234567890  1234567889)   t)
($test (>  1234567890  1234567890) nil)
($test (>  1234567890  1234567891) nil)
($test (>  1234567890 -1234567890.0)   t)
($test (>  1234567890        -123.0)   t)
($test (>  1234567890           0.0)   t)
($test (>  1234567890         123.0)   t)
($test (>  1234567890  1234567890.0) nil)
($test (>  1234567890 *most-negative-float*)   t)
($test (>  1234567890 *most-positive-float*) nil)
($test (> -1234567890.0 -1234567890) nil)
($test (> -1234567890.0        -123) nil)
($test (> -1234567890.0           0) nil)
($test (> -1234567890.0         123) nil)
($test (> -1234567890.0  1234567890) nil)
($test (> -1234567890.0 -1234567890.0) nil)
($test (> -1234567890.0        -123.0) nil)
($test (> -1234567890.0           0.0) nil)
($test (> -1234567890.0         123.0) nil)
($test (> -1234567890.0  1234567890.0) nil)
($test (> -1234567890.0 *most-negative-float*)   t)
($test (> -1234567890.0 *most-positive-float*) nil)
($test (>        -123.0 -1234567890)   t)
($test (>        -123.0        -123) nil)
($test (>        -123.0           0) nil)
($test (>        -123.0         123) nil)
($test (>        -123.0  1234567890) nil)
($test (>        -123.0 -1234567890.0)   t)
($test (>        -123.0        -123.0) nil)
($test (>        -123.0           0.0) nil)
($test (>        -123.0         123.0) nil)
($test (>        -123.0  1234567890.0) nil)
($test (>        -123.0 *most-negative-float*)   t)
($test (>        -123.0 *most-positive-float*) nil)
($test (>           0.0 -1234567890)   t)
($test (>           0.0        -123)   t)
($test (>           0.0           0) nil)
($test (>           0.0         123) nil)
($test (>           0.0  1234567890) nil)
($test (>           0.0 -1234567890.0)   t)
($test (>           0.0        -123.0)   t)
($test (>           0.0           0.0) nil)
($test (>           0.0         123.0) nil)
($test (>           0.0  1234567890.0) nil)
($test (>           0.0 *most-negative-float*)   t)
($test (>           0.0 *most-positive-float*) nil)
($test (>         123.0 -1234567890)   t)
($test (>         123.0        -123)   t)
($test (>         123.0           0)   t)
($test (>         123.0         123) nil)
($test (>         123.0  1234567890) nil)
($test (>         123.0 -1234567890.0)   t)
($test (>         123.0        -123.0)   t)
($test (>         123.0           0.0)   t)
($test (>         123.0         123.0) nil)
($test (>         123.0  1234567890.0) nil)
($test (>         123.0 *most-negative-float*)   t)
($test (>         123.0 *most-positive-float*) nil)
($test (>  1234567890.0 -1234567890)   t)
($test (>  1234567890.0        -123)   t)
($test (>  1234567890.0           0)   t)
($test (>  1234567890.0         123)   t)
($test (>  1234567890.0  1234567890) nil)
($test (>  1234567890.0 -1234567890.0)   t)
($test (>  1234567890.0        -123.0)   t)
($test (>  1234567890.0           0.0)   t)
($test (>  1234567890.0         123.0)   t)
($test (>  1234567890.0  1234567890.0) nil)
($test (>  1234567890.0 *most-negative-float*)   t)
($test (>  1234567890.0 *most-positive-float*) nil)
($test (> *most-negative-float* -1234567890) nil)
($test (> *most-negative-float*        -123) nil)
($test (> *most-negative-float*           0) nil)
($test (> *most-negative-float*         123) nil)
($test (> *most-negative-float*  1234567890) nil)
($test (> *most-negative-float* -1234567890.0) nil)
($test (> *most-negative-float*        -123.0) nil)
($test (> *most-negative-float*           0.0) nil)
($test (> *most-negative-float*         123.0) nil)
($test (> *most-negative-float*  1234567890.0) nil)
($test (> *most-negative-float* *most-negative-float*) nil)
($test (> *most-negative-float* *most-positive-float*) nil)
($test (> *most-positive-float* -1234567890)   t)
($test (> *most-positive-float*        -123)   t)
($test (> *most-positive-float*           0)   t)
($test (> *most-positive-float*         123)   t)
($test (> *most-positive-float*  1234567890)   t)
($test (> *most-positive-float* -1234567890.0)   t)
($test (> *most-positive-float*        -123.0)   t)
($test (> *most-positive-float*           0.0)   t)
($test (> *most-positive-float*         123.0)   t)
($test (> *most-positive-float*  1234567890.0)   t)
($test (> *most-positive-float* *most-negative-float*)   t)
($test (> *most-positive-float* *most-positive-float*) nil)

;;;
;;; function (< x1 x2) --> boolean
;;;
($ap 2 "<" P.68)
($test (< 2 2) nil)
($test (< 1 2) t)
;;;
($argc < 2 0 0)
($type < ($integer $float) :target 1)
($type < ($integer $float) 1 :target)
;;;
($test (< -1234567890 -1234567891) nil)
($test (< -1234567890 -1234567890) nil)
($test (< -1234567890 -1234567889)   t)
($test (< -1234567890        -123)   t)
($test (< -1234567890           0)   t)
($test (< -1234567890         123)   t)
($test (< -1234567890  1234567889)   t)
($test (< -1234567890  1234567890)   t)
($test (< -1234567890  1234567891)   t)
($test (< -1234567890 -1234567890.0) nil)
($test (< -1234567890        -123.0)   t)
($test (< -1234567890           0.0)   t)
($test (< -1234567890         123.0)   t)
($test (< -1234567890  1234567890.0)   t)
($test (< -1234567890 *most-negative-float*) nil)
($test (< -1234567890 *most-positive-float*)   t)
($test (<        -123 -1234567890) nil)
($test (<        -123        -124) nil)
($test (<        -123        -123) nil)
($test (<        -123        -122)   t)
($test (<        -123           0)   t)
($test (<        -123         122)   t)
($test (<        -123         123)   t)
($test (<        -123         124)   t)
($test (<        -123  1234567890)   t)
($test (<        -123 -1234567890.0) nil)
($test (<        -123        -123.0) nil)
($test (<        -123           0.0)   t)
($test (<        -123         123.0)   t)
($test (<        -123  1234567890.0)   t)
($test (<        -123 *most-negative-float*) nil)
($test (<        -123 *most-positive-float*)   t)
($test (<           0 -1234567890) nil)
($test (<           0        -123) nil)
($test (<           0          -1) nil)
($test (<           0           0) nil)
($test (<           0           1)   t)
($test (<           0         123)   t)
($test (<           0  1234567890)   t)
($test (<           0 -1234567890.0) nil)
($test (<           0        -123.0) nil)
($test (<           0           0.0) nil)
($test (<           0         123.0)   t)
($test (<           0  1234567890.0)   t)
($test (<           0 *most-negative-float*) nil)
($test (<           0 *most-positive-float*)   t)
($test (<         123 -1234567890) nil)
($test (<         123        -124) nil)
($test (<         123        -123) nil)
($test (<         123        -122) nil)
($test (<         123           0) nil)
($test (<         123         122) nil)
($test (<         123         123) nil)
($test (<         123         124)   t)
($test (<         123  1234567890)   t)
($test (<         123 -1234567890.0) nil)
($test (<         123        -123.0) nil)
($test (<         123           0.0) nil)
($test (<         123         123.0) nil)
($test (<         123  1234567890.0)   t)
($test (<         123 *most-negative-float*) nil)
($test (<         123 *most-positive-float*)   t)
($test (<  1234567890 -1234567891) nil)
($test (<  1234567890 -1234567890) nil)
($test (<  1234567890 -1234567889) nil)
($test (<  1234567890        -123) nil)
($test (<  1234567890           0) nil)
($test (<  1234567890         123) nil)
($test (<  1234567890  1234567889) nil)
($test (<  1234567890  1234567890) nil)
($test (<  1234567890  1234567891)   t)
($test (<  1234567890 -1234567890.0) nil)
($test (<  1234567890        -123.0) nil)
($test (<  1234567890           0.0) nil)
($test (<  1234567890         123.0) nil)
($test (<  1234567890  1234567890.0) nil)
($test (<  1234567890 *most-negative-float*) nil)
($test (<  1234567890 *most-positive-float*)   t)
($test (< -1234567890.0 -1234567890) nil)
($test (< -1234567890.0        -123)   t)
($test (< -1234567890.0           0)   t)
($test (< -1234567890.0         123)   t)
($test (< -1234567890.0  1234567890)   t)
($test (< -1234567890.0 -1234567890.0) nil)
($test (< -1234567890.0        -123.0)   t)
($test (< -1234567890.0           0.0)   t)
($test (< -1234567890.0         123.0)   t)
($test (< -1234567890.0  1234567890.0)   t)
($test (< -1234567890.0 *most-negative-float*) nil)
($test (< -1234567890.0 *most-positive-float*)   t)
($test (<        -123.0 -1234567890) nil)
($test (<        -123.0        -123) nil)
($test (<        -123.0           0)   t)
($test (<        -123.0         123)   t)
($test (<        -123.0  1234567890)   t)
($test (<        -123.0 -1234567890.0) nil)
($test (<        -123.0        -123.0) nil)
($test (<        -123.0           0.0)   t)
($test (<        -123.0         123.0)   t)
($test (<        -123.0  1234567890.0)   t)
($test (<        -123.0 *most-negative-float*) nil)
($test (<        -123.0 *most-positive-float*)   t)
($test (<           0.0 -1234567890) nil)
($test (<           0.0        -123) nil)
($test (<           0.0           0) nil)
($test (<           0.0         123)   t)
($test (<           0.0  1234567890)   t)
($test (<           0.0 -1234567890.0) nil)
($test (<           0.0        -123.0) nil)
($test (<           0.0           0.0) nil)
($test (<           0.0         123.0)   t)
($test (<           0.0  1234567890.0)   t)
($test (<           0.0 *most-negative-float*) nil)
($test (<           0.0 *most-positive-float*)   t)
($test (<         123.0 -1234567890) nil)
($test (<         123.0        -123) nil)
($test (<         123.0           0) nil)
($test (<         123.0         123) nil)
($test (<         123.0  1234567890)   t)
($test (<         123.0 -1234567890.0) nil)
($test (<         123.0        -123.0) nil)
($test (<         123.0           0.0) nil)
($test (<         123.0         123.0) nil)
($test (<         123.0  1234567890.0)   t)
($test (<         123.0 *most-negative-float*) nil)
($test (<         123.0 *most-positive-float*)   t)
($test (<  1234567890.0 -1234567890) nil)
($test (<  1234567890.0        -123) nil)
($test (<  1234567890.0           0) nil)
($test (<  1234567890.0         123) nil)
($test (<  1234567890.0  1234567890) nil)
($test (<  1234567890.0 -1234567890.0) nil)
($test (<  1234567890.0        -123.0) nil)
($test (<  1234567890.0           0.0) nil)
($test (<  1234567890.0         123.0) nil)
($test (<  1234567890.0  1234567890.0) nil)
($test (<  1234567890.0 *most-negative-float*) nil)
($test (<  1234567890.0 *most-positive-float*)   t)
($test (< *most-negative-float* -1234567890)   t)
($test (< *most-negative-float*        -123)   t)
($test (< *most-negative-float*           0)   t)
($test (< *most-negative-float*         123)   t)
($test (< *most-negative-float*  1234567890)   t)
($test (< *most-negative-float* -1234567890.0)   t)
($test (< *most-negative-float*        -123.0)   t)
($test (< *most-negative-float*           0.0)   t)
($test (< *most-negative-float*         123.0)   t)
($test (< *most-negative-float*  1234567890.0)   t)
($test (< *most-negative-float* *most-negative-float*) nil)
($test (< *most-negative-float* *most-positive-float*)   t)
($test (< *most-positive-float* -1234567890) nil)
($test (< *most-positive-float*        -123) nil)
($test (< *most-positive-float*           0) nil)
($test (< *most-positive-float*         123) nil)
($test (< *most-positive-float*  1234567890) nil)
($test (< *most-positive-float* -1234567890.0) nil)
($test (< *most-positive-float*        -123.0) nil)
($test (< *most-positive-float*           0.0) nil)
($test (< *most-positive-float*         123.0) nil)
($test (< *most-positive-float*  1234567890.0) nil)
($test (< *most-positive-float* *most-negative-float*) nil)
($test (< *most-positive-float* *most-positive-float*) nil)
($eval (defun eval-eql (x y) (eql x (eval y))))

;;;
;;; function (+ x*) --> <number>
;;;
($ap 2 "+" P.69)
($test (+ 12 3) 15 eql)
($test (+ 1 2 3) 6 eql)
($test (+ 12 3.0) 15.0 eql)
($test (+ 4 0.0) 4.0 eql)
($test (+) 0 eql)
;;;
($argc + 0 0 1)
($type + ($integer $float) :target)
($type + ($integer $float) 0 :target)
($type + ($integer $float) 0 0 :target)
;;; 1 argument
($test (+ -8388609) -8388609 eql)
($test (+ -8388608) -8388608 eql)
($test (+        0)        0 eql)
($test (+  8388607)  8388607 eql)
($test (+  8388608)  8388608 eql)
($test (+ -123.45) -123.45 eql)
($test (+    0.0)     0.0  eql)
($test (+  123.45)  123.45 eql)
($test (+ *most-negative-float*) *most-negative-float* eval-eql)
($test (+ *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 arguments
($test (+ -10000000000 -10000000000)   -20000000000 eql)
($test (+ -10000000000     -8388609)   -10008388609 eql)
($test (+ -10000000000     -8388608)   -10008388608 eql)
($test (+ -10000000000           -1)   -10000000001 eql)
($test (+ -10000000000            0)   -10000000000 eql)
($test (+ -10000000000            1)    -9999999999 eql)
($test (+ -10000000000      8388607)    -9991611393 eql)
($test (+ -10000000000      8388608)    -9991611392 eql)
($test (+ -10000000000  10000000000)              0 eql)
($test (+ -10000000000 -10000000000.0) -20000000000.0 eql)
($test (+ -10000000000           -1.0) -10000000001.0 eql)
($test (+ -10000000000            0.0) -10000000000.0 eql)
($test (+ -10000000000            1.0)  -9999999999.0 eql)
($test (+ -10000000000  10000000000.0)            0.0 eql)
($test (+     -8388609 -10000000000)   -10008388609 eql)
($test (+     -8388609     -8388609)      -16777218 eql)
($test (+     -8388609     -8388608)      -16777217 eql)
($test (+     -8388609           -1)       -8388610 eql)
($test (+     -8388609            0)       -8388609 eql)
($test (+     -8388609            1)       -8388608 eql)
($test (+     -8388609      8388607)             -2 eql)
($test (+     -8388609      8388608)             -1 eql)
($test (+     -8388609  10000000000)     9991611391 eql)
($test (+     -8388609 -10000000000.0) -10008388609.0 eql)
($test (+     -8388609           -1.0)     -8388610.0 eql)
($test (+     -8388609            0.0)     -8388609.0 eql)
($test (+     -8388609            1.0)     -8388608.0 eql)
($test (+     -8388609  10000000000.0)   9991611391.0 eql)
($test (+     -8388608 -10000000000)   -10008388608 eql)
($test (+     -8388608     -8388609)      -16777217 eql)
($test (+     -8388608     -8388608)      -16777216 eql)
($test (+     -8388608           -1)       -8388609 eql)
($test (+     -8388608            0)       -8388608 eql)
($test (+     -8388608            1)       -8388607 eql)
($test (+     -8388608      8388607)             -1 eql)
($test (+     -8388608      8388608)              0 eql)
($test (+     -8388608  10000000000)     9991611392 eql)
($test (+     -8388608 -10000000000.0) -10008388608.0 eql)
($test (+     -8388608           -1.0)     -8388609.0 eql)
($test (+     -8388608            0.0)     -8388608.0 eql)
($test (+     -8388608            1.0)     -8388607.0 eql)
($test (+     -8388608  10000000000.0)   9991611392.0 eql)
($test (+           -1 -10000000000)   -10000000001 eql)
($test (+           -1     -8388609)       -8388610 eql)
($test (+           -1     -8388608)       -8388609 eql)
($test (+           -1           -1)             -2 eql)
($test (+           -1            0)             -1 eql)
($test (+           -1            1)              0 eql)
($test (+           -1      8388607)        8388606 eql)
($test (+           -1      8388608)        8388607 eql)
($test (+           -1  10000000000)     9999999999 eql)
($test (+           -1 -10000000000.0) -10000000001.0 eql)
($test (+           -1           -1.0)           -2.0 eql)
($test (+           -1            0.0)           -1.0 eql)
($test (+           -1            1.0)            0.0 eql)
($test (+           -1  10000000000.0)   9999999999.0 eql)
($test (+            0 -10000000000)   -10000000000 eql)
($test (+            0     -8388609)       -8388609 eql)
($test (+            0     -8388608)       -8388608 eql)
($test (+            0           -1)             -1 eql)
($test (+            0            0)              0 eql)
($test (+            0            1)              1 eql)
($test (+            0      8388607)        8388607 eql)
($test (+            0      8388608)        8388608 eql)
($test (+            0  10000000000)    10000000000 eql)
($test (+            0 -10000000000.0) -10000000000.0 eql)
($test (+            0           -1.0)           -1.0 eql)
($test (+            0            0.0)            0.0 eql)
($test (+            0            1.0)            1.0 eql)
($test (+            0  10000000000.0)  10000000000.0 eql)
($test (+            0 *most-negative-float*) *most-negative-float* eval-eql)
($test (+            0 *most-positive-float*) *most-positive-float* eval-eql)
($test (+            1 -10000000000)    -9999999999 eql)
($test (+            1     -8388609)       -8388608 eql)
($test (+            1     -8388608)       -8388607 eql)
($test (+            1           -1)              0 eql)
($test (+            1            0)              1 eql)
($test (+            1            1)              2 eql)
($test (+            1      8388607)        8388608 eql)
($test (+            1      8388608)        8388609 eql)
($test (+            1  10000000000)    10000000001 eql)
($test (+            1 -10000000000.0)  -9999999999.0 eql)
($test (+            1           -1.0)            0.0 eql)
($test (+            1            0.0)            1.0 eql)
($test (+            1            1.0)            2.0 eql)
($test (+            1  10000000000.0)  10000000001.0 eql)
($test (+      8388607 -10000000000)    -9991611393 eql)
($test (+      8388607     -8388609)             -2 eql)
($test (+      8388607     -8388608)             -1 eql)
($test (+      8388607           -1)        8388606 eql)
($test (+      8388607            0)        8388607 eql)
($test (+      8388607            1)        8388608 eql)
($test (+      8388607      8388607)       16777214 eql)
($test (+      8388607      8388608)       16777215 eql)
($test (+      8388607  10000000000)    10008388607 eql)
($test (+      8388607 -10000000000.0)  -9991611393.0 eql)
($test (+      8388607           -1.0)      8388606.0 eql)
($test (+      8388607            0.0)      8388607.0 eql)
($test (+      8388607            1.0)      8388608.0 eql)
($test (+      8388607  10000000000.0)  10008388607.0 eql)
($test (+      8388608 -10000000000)    -9991611392 eql)
($test (+      8388608     -8388609)             -1 eql)
($test (+      8388608     -8388608)              0 eql)
($test (+      8388608           -1)        8388607 eql)
($test (+      8388608            0)        8388608 eql)
($test (+      8388608            1)        8388609 eql)
($test (+      8388608      8388607)       16777215 eql)
($test (+      8388608      8388608)       16777216 eql)
($test (+      8388608  10000000000)    10008388608 eql)
($test (+      8388608 -10000000000.0)  -9991611392.0 eql)
($test (+      8388608           -1.0)      8388607.0 eql)
($test (+      8388608            0.0)      8388608.0 eql)
($test (+      8388608            1.0)      8388609.0 eql)
($test (+      8388608  10000000000.0)  10008388608.0 eql)
($test (+  10000000000 -10000000000)              0 eql)
($test (+  10000000000     -8388609)     9991611391 eql)
($test (+  10000000000     -8388608)     9991611392 eql)
($test (+  10000000000           -1)     9999999999 eql)
($test (+  10000000000            0)    10000000000 eql)
($test (+  10000000000            1)    10000000001 eql)
($test (+  10000000000      8388607)    10008388607 eql)
($test (+  10000000000      8388608)    10008388608 eql)
($test (+  10000000000  10000000000)    20000000000 eql)
($test (+  10000000000 -10000000000.0)              0.0 eql)
($test (+  10000000000           -1.0)     9999999999.0 eql)
($test (+  10000000000            0.0)    10000000000.0 eql)
($test (+  10000000000            1.0)    10000000001.0 eql)
($test (+  10000000000  10000000000.0)    20000000000.0 eql)
($test (+ -10000000000.0 -10000000000)   -20000000000.0 eql)
($test (+ -10000000000.0     -8388609)   -10008388609.0 eql)
($test (+ -10000000000.0     -8388608)   -10008388608.0 eql)
($test (+ -10000000000.0           -1)   -10000000001.0 eql)
($test (+ -10000000000.0            0)   -10000000000.0 eql)
($test (+ -10000000000.0            1)    -9999999999.0 eql)
($test (+ -10000000000.0      8388607)    -9991611393.0 eql)
($test (+ -10000000000.0      8388608)    -9991611392.0 eql)
($test (+ -10000000000.0  10000000000)              0.0 eql)
($test (+ -10000000000.0 -10000000000.0) -20000000000.0 eql)
($test (+ -10000000000.0           -1.0) -10000000001.0 eql)
($test (+ -10000000000.0            0.0) -10000000000.0 eql)
($test (+ -10000000000.0            1.0)  -9999999999.0 eql)
($test (+ -10000000000.0  10000000000.0)            0.0 eql)
($test (+           -1.0 -10000000000)   -10000000001.0 eql)
($test (+           -1.0     -8388609)       -8388610.0 eql)
($test (+           -1.0     -8388608)       -8388609.0 eql)
($test (+           -1.0           -1)             -2.0 eql)
($test (+           -1.0            0)             -1.0 eql)
($test (+           -1.0            1)              0.0 eql)
($test (+           -1.0      8388607)        8388606.0 eql)
($test (+           -1.0      8388608)        8388607.0 eql)
($test (+           -1.0  10000000000)     9999999999.0 eql)
($test (+           -1.0 -10000000000.0) -10000000001.0 eql)
($test (+           -1.0           -1.0)           -2.0 eql)
($test (+           -1.0            0.0)           -1.0 eql)
($test (+           -1.0            1.0)            0.0 eql)
($test (+           -1.0  10000000000.0)   9999999999.0 eql)
($test (+            0.0 -10000000000)   -10000000000.0 eql)
($test (+            0.0     -8388609)       -8388609.0 eql)
($test (+            0.0     -8388608)       -8388608.0 eql)
($test (+            0.0           -1)             -1.0 eql)
($test (+            0.0            0)              0.0 eql)
($test (+            0.0            1)              1.0 eql)
($test (+            0.0      8388607)        8388607.0 eql)
($test (+            0.0      8388608)        8388608.0 eql)
($test (+            0.0  10000000000)    10000000000.0 eql)
($test (+            0.0 -10000000000.0) -10000000000.0 eql)
($test (+            0.0           -1.0)           -1.0 eql)
($test (+            0.0            0.0)            0.0 eql)
($test (+            0.0            1.0)            1.0 eql)
($test (+            0.0  10000000000.0)  10000000000.0 eql)
($test (+            0.0 *most-negative-float*) *most-negative-float* eval-eql)
($test (+            0.0 *most-positive-float*) *most-positive-float* eval-eql)
($test (+            1.0 -10000000000)    -9999999999.0 eql)
($test (+            1.0     -8388609)       -8388608.0 eql)
($test (+            1.0     -8388608)       -8388607.0 eql)
($test (+            1.0           -1)              0.0 eql)
($test (+            1.0            0)              1.0 eql)
($test (+            1.0            1)              2.0 eql)
($test (+            1.0      8388607)        8388608.0 eql)
($test (+            1.0      8388608)        8388609.0 eql)
($test (+            1.0  10000000000)    10000000001.0 eql)
($test (+            1.0 -10000000000.0)  -9999999999.0 eql)
($test (+            1.0           -1.0)            0.0 eql)
($test (+            1.0            0.0)            1.0 eql)
($test (+            1.0            1.0)            2.0 eql)
($test (+            1.0  10000000000.0)  10000000001.0 eql)
($test (+  10000000000.0 -10000000000)              0.0 eql)
($test (+  10000000000.0     -8388609)     9991611391.0 eql)
($test (+  10000000000.0     -8388608)     9991611392.0 eql)
($test (+  10000000000.0           -1)     9999999999.0 eql)
($test (+  10000000000.0            0)    10000000000.0 eql)
($test (+  10000000000.0            1)    10000000001.0 eql)
($test (+  10000000000.0      8388607)    10008388607.0 eql)
($test (+  10000000000.0      8388608)    10008388608.0 eql)
($test (+  10000000000.0  10000000000)    20000000000.0 eql)
($test (+  10000000000.0 -10000000000.0)            0.0 eql)
($test (+  10000000000.0           -1.0)   9999999999.0 eql)
($test (+  10000000000.0            0.0)  10000000000.0 eql)
($test (+  10000000000.0            1.0)  10000000001.0 eql)
($test (+  10000000000.0  10000000000.0)  20000000000.0 eql)
($test (+ *most-negative-float* 0)   *most-negative-float* eval-eql)
($test (+ *most-negative-float* 0.0) *most-negative-float* eval-eql)
($error (+ *most-negative-float* *most-negative-float*) <floating-point-overflow>)
($test (+ *most-negative-float* *most-positive-float*) 0.0 eql)
($test (+ *most-positive-float* 0)   *most-positive-float* eval-eql)
($test (+ *most-positive-float* 0.0) *most-positive-float* eval-eql)
($test (+ *most-positive-float* *most-negative-float*) 0.0 eql)
($error (+ *most-positive-float* *most-positive-float*) <floating-point-overflow>)
;;; 3 arguments
($test (+ 0 0 0) 0 eql)
($test (+ 0.0 0.0 0.0) 0.0 eql)
($test (+ 10 20 30) 60 eql)
($test (+ 10.0 20.0 30.0) 60.0 eql)

;;;
;;; function (* x*) --> <number>
;;;
($ap 2 "*" P.69)
($test (* 12 3) 36 eql)
($test (* 12 3.0) 36.0 eql)
($test (* 4.0 0) 0.0 eql)
($test (* 2 3 4) 24 eql)
($test (*) 1 eql)
;;;
($argc * 0 0 1)
($type * ($integer $float) :target)
($type * ($integer $float) 0 :target)
($type * ($integer $float) 0 0 :target)
;;; 1 argument
($test (* -8388609) -8388609 eql)
($test (* -8388608) -8388608 eql)
($test (*        0)        0 eql)
($test (*  8388607)  8388607 eql)
($test (*  8388608)  8388608 eql)
($test (* -123.45) -123.45 eql)
($test (*    0.0)     0.0  eql)
($test (*  123.45)  123.45 eql)
($test (* *most-negative-float*) *most-negative-float* eval-eql)
($test (* *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 arguments
($test (* -10000000000 -10000000000)    100000000000000000000 eql)
($test (* -10000000000     -8388609)        83886090000000000 eql)
($test (* -10000000000     -8388608)        83886080000000000 eql)
($test (* -10000000000           -1)              10000000000 eql)
($test (* -10000000000            0)                        0 eql)
($test (* -10000000000            1)             -10000000000 eql)
($test (* -10000000000      8388607)       -83886070000000000 eql)
($test (* -10000000000      8388608)       -83886080000000000 eql)
($test (* -10000000000  10000000000)   -100000000000000000000 eql)
($test (* -10000000000 -10000000000.0)  100000000000000000000.0 eql)
($test (* -10000000000           -1.0)            10000000000.0 eql)
($test (* -10000000000            0.0)                      0.0 eql)
($test (* -10000000000            1.0)           -10000000000.0 eql)
($test (* -10000000000  10000000000.0) -100000000000000000000.0 eql)
($error (* -10000000000 *most-negative-float*) <floating-point-overflow>)
($error (* -10000000000 *most-positive-float*) <floating-point-overflow>)
($test (*     -8388609 -10000000000)        83886090000000000 eql)
($test (*     -8388609     -8388609)           70368760954881 eql)
($test (*     -8388609     -8388608)           70368752566272 eql)
($test (*     -8388609           -1)                  8388609 eql)
($test (*     -8388609            0)                        0 eql)
($test (*     -8388609            1)                 -8388609 eql)
($test (*     -8388609      8388607)          -70368744177663 eql)
($test (*     -8388609      8388608)          -70368752566272 eql)
($test (*     -8388609  10000000000)       -83886090000000000 eql)
($test (*     -8388609 -10000000000.0)      83886090000000000.0 eql)
($test (*     -8388609           -1.0)                8388609.0 eql)
($test (*     -8388609            0.0)                      0.0 eql)
($test (*     -8388609            1.0)               -8388609.0 eql)
($test (*     -8388609  10000000000.0)     -83886090000000000.0 eql)
($error (* -8388609 *most-negative-float*) <floating-point-overflow>)
($error (* -8388609 *most-positive-float*) <floating-point-overflow>)
($test (*     -8388608 -10000000000)        83886080000000000 eql)
($test (*     -8388608     -8388609)           70368752566272 eql)
($test (*     -8388608     -8388608)           70368744177664 eql)
($test (*     -8388608           -1)                  8388608 eql)
($test (*     -8388608            0)                        0 eql)
($test (*     -8388608            1)                 -8388608 eql)
($test (*     -8388608      8388607)          -70368735789056 eql)
($test (*     -8388608      8388608)          -70368744177664 eql)
($test (*     -8388608  10000000000)       -83886080000000000 eql)
($test (*     -8388608 -10000000000.0)      83886080000000000.0 eql)
($test (*     -8388608           -1.0)                8388608.0 eql)
($test (*     -8388608            0.0)                      0.0 eql)
($test (*     -8388608            1.0)               -8388608.0 eql)
($test (*     -8388608  10000000000.0)     -83886080000000000.0 eql)
($error (* -8388608 *most-negative-float*) <floating-point-overflow>)
($error (* -8388608 *most-positive-float*) <floating-point-overflow>)
($test (*           -1 -10000000000)              10000000000 eql)
($test (*           -1     -8388609)                  8388609 eql)
($test (*           -1     -8388608)                  8388608 eql)
($test (*           -1           -1)                        1 eql)
($test (*           -1            0)                        0 eql)
($test (*           -1            1)                       -1 eql)
($test (*           -1      8388607)                 -8388607 eql)
($test (*           -1      8388608)                 -8388608 eql)
($test (*           -1  10000000000)             -10000000000 eql)
($test (*           -1 -10000000000.0)            10000000000.0 eql)
($test (*           -1           -1.0)                      1.0 eql)
($test (*           -1            0.0)                      0.0 eql)
($test (*           -1            1.0)                     -1.0 eql)
($test (*           -1  10000000000.0)           -10000000000.0 eql)
($test (*           -1 *most-negative-float*) *most-positive-float* eval-eql)
($test (*           -1 *most-positive-float*) *most-negative-float* eval-eql)
($test (*            0 -10000000000)                        0 eql)
($test (*            0     -8388609)                        0 eql)
($test (*            0     -8388608)                        0 eql)
($test (*            0           -1)                        0 eql)
($test (*            0            0)                        0 eql)
($test (*            0            1)                        0 eql)
($test (*            0      8388607)                        0 eql)
($test (*            0      8388608)                        0 eql)
($test (*            0  10000000000)                        0 eql)
($test (*            0 -10000000000.0)                      0.0 eql)
($test (*            0           -1.0)                      0.0 eql)
($test (*            0            0.0)                      0.0 eql)
($test (*            0            1.0)                      0.0 eql)
($test (*            0  10000000000.0)                      0.0 eql)
($test (*            0 *most-negative-float*)               0.0 eql)
($test (*            0 *most-positive-float*)               0.0 eql)
($test (*            1 -10000000000)             -10000000000 eql)
($test (*            1     -8388609)                 -8388609 eql)
($test (*            1     -8388608)                 -8388608 eql)
($test (*            1           -1)                       -1 eql)
($test (*            1            0)                        0 eql)
($test (*            1            1)                        1 eql)
($test (*            1      8388607)                  8388607 eql)
($test (*            1      8388608)                  8388608 eql)
($test (*            1  10000000000)              10000000000 eql)
($test (*            1 -10000000000.0)           -10000000000.0 eql)
($test (*            1           -1.0)                     -1.0 eql)
($test (*            1            0.0)                      0.0 eql)
($test (*            1            1.0)                      1.0 eql)
($test (*            1  10000000000.0)            10000000000.0 eql)
($test (*            1 *most-negative-float*) *most-negative-float* eval-eql)
($test (*            1 *most-positive-float*) *most-positive-float* eval-eql)
($test (*      8388607 -10000000000)       -83886070000000000 eql)
($test (*      8388607     -8388609)          -70368744177663 eql)
($test (*      8388607     -8388608)          -70368735789056 eql)
($test (*      8388607           -1)                 -8388607 eql)
($test (*      8388607            0)                        0 eql)
($test (*      8388607            1)                  8388607 eql)
($test (*      8388607      8388607)           70368727400449 eql)
($test (*      8388607      8388608)           70368735789056 eql)
($test (*      8388607  10000000000)        83886070000000000 eql)
($test (*      8388607 -10000000000.0)     -83886070000000000.0 eql)
($test (*      8388607           -1.0)               -8388607.0 eql)
($test (*      8388607            0.0)                      0.0 eql)
($test (*      8388607            1.0)                8388607.0 eql)
($test (*      8388607  10000000000.0)      83886070000000000.0 eql)
($error (* 8388607 *most-negative-float*) <floating-point-overflow>)
($error (* 8388607 *most-positive-float*) <floating-point-overflow>)
($test (*      8388608 -10000000000)       -83886080000000000 eql)
($test (*      8388608     -8388609)          -70368752566272 eql)
($test (*      8388608     -8388608)          -70368744177664 eql)
($test (*      8388608           -1)                 -8388608 eql)
($test (*      8388608            0)                        0 eql)
($test (*      8388608            1)                  8388608 eql)
($test (*      8388608      8388607)           70368735789056 eql)
($test (*      8388608      8388608)           70368744177664 eql)
($test (*      8388608  10000000000)        83886080000000000 eql)
($test (*      8388608 -10000000000.0)     -83886080000000000.0 eql)
($test (*      8388608           -1.0)               -8388608.0 eql)
($test (*      8388608            0.0)                      0.0 eql)
($test (*      8388608            1.0)                8388608.0 eql)
($test (*      8388608  10000000000.0)      83886080000000000.0 eql)
($error (* 8388608 *most-negative-float*) <floating-point-overflow>)
($error (* 8388608 *most-positive-float*) <floating-point-overflow>)
($test (*  10000000000 -10000000000)   -100000000000000000000 eql)
($test (*  10000000000     -8388609)       -83886090000000000 eql)
($test (*  10000000000     -8388608)       -83886080000000000 eql)
($test (*  10000000000           -1)             -10000000000 eql)
($test (*  10000000000            0)                        0 eql)
($test (*  10000000000            1)              10000000000 eql)
($test (*  10000000000      8388607)        83886070000000000 eql)
($test (*  10000000000      8388608)        83886080000000000 eql)
($test (*  10000000000  10000000000)    100000000000000000000 eql)
($test (*  10000000000 -10000000000.0) -100000000000000000000.0 eql)
($test (*  10000000000           -1.0)           -10000000000.0 eql)
($test (*  10000000000            0.0)                      0.0 eql)
($test (*  10000000000            1.0)            10000000000.0 eql)
($test (*  10000000000  10000000000.0)  100000000000000000000.0 eql)
($error (* 10000000000 *most-negative-float*) <floating-point-overflow>)
($error (* 10000000000 *most-positive-float*) <floating-point-overflow>)
($test (* -10000000000.0 -10000000000)  100000000000000000000.0 eql)
($test (* -10000000000.0     -8388609)      83886090000000000.0 eql)
($test (* -10000000000.0     -8388608)      83886080000000000.0 eql)
($test (* -10000000000.0           -1)            10000000000.0 eql)
($test (* -10000000000.0            0)                      0.0 eql)
($test (* -10000000000.0            1)           -10000000000.0 eql)
($test (* -10000000000.0      8388607)     -83886070000000000.0 eql)
($test (* -10000000000.0      8388608)     -83886080000000000.0 eql)
($test (* -10000000000.0  10000000000) -100000000000000000000.0 eql)
($test (* -10000000000.0 -10000000000.0)  100000000000000000000.0 eql)
($test (* -10000000000.0           -1.0)            10000000000.0 eql)
($test (* -10000000000.0            0.0)                      0.0 eql)
($test (* -10000000000.0            1.0)           -10000000000.0 eql)
($test (* -10000000000.0  10000000000.0) -100000000000000000000.0 eql)
($error (* -10000000000.0 *most-negative-float*) <floating-point-overflow>)
($error (* -10000000000.0 *most-positive-float*) <floating-point-overflow>)
($test (*           -1.0 -10000000000)              10000000000.0 eql)
($test (*           -1.0     -8388609)                  8388609.0 eql)
($test (*           -1.0     -8388608)                  8388608.0 eql)
($test (*           -1.0           -1)                        1.0 eql)
($test (*           -1.0            0)                        0.0 eql)
($test (*           -1.0            1)                       -1.0 eql)
($test (*           -1.0      8388607)                 -8388607.0 eql)
($test (*           -1.0      8388608)                 -8388608.0 eql)
($test (*           -1.0  10000000000)             -10000000000.0 eql)
($test (*           -1.0 -10000000000.0)            10000000000.0 eql)
($test (*           -1.0           -1.0)                      1.0 eql)
($test (*           -1.0            0.0)                      0.0 eql)
($test (*           -1.0            1.0)                     -1.0 eql)
($test (*           -1.0  10000000000.0)           -10000000000.0 eql)
($test (*           -1.0 *most-negative-float*) *most-positive-float* eval-eql)
($test (*           -1.0 *most-positive-float*) *most-negative-float* eval-eql)
($test (*            0.0 -10000000000)                        0.0 eql)
($test (*            0.0     -8388609)                        0.0 eql)
($test (*            0.0     -8388608)                        0.0 eql)
($test (*            0.0           -1)                        0.0 eql)
($test (*            0.0            0)                        0.0 eql)
($test (*            0.0            1)                        0.0 eql)
($test (*            0.0      8388607)                        0.0 eql)
($test (*            0.0      8388608)                        0.0 eql)
($test (*            0.0  10000000000)                        0.0 eql)
($test (*            0.0 -10000000000.0)                      0.0 eql)
($test (*            0.0           -1.0)                      0.0 eql)
($test (*            0.0            0.0)                      0.0 eql)
($test (*            0.0            1.0)                      0.0 eql)
($test (*            0.0  10000000000.0)                      0.0 eql)
($test (*            0.0 *most-negative-float*)               0.0 eql)
($test (*            0.0 *most-positive-float*)               0.0 eql)
($test (*            1.0 -10000000000)             -10000000000.0 eql)
($test (*            1.0     -8388609)                 -8388609.0 eql)
($test (*            1.0     -8388608)                 -8388608.0 eql)
($test (*            1.0           -1)                       -1.0 eql)
($test (*            1.0            0)                        0.0 eql)
($test (*            1.0            1)                        1.0 eql)
($test (*            1.0      8388607)                  8388607.0 eql)
($test (*            1.0      8388608)                  8388608.0 eql)
($test (*            1.0  10000000000)              10000000000.0 eql)
($test (*            1.0 -10000000000.0)           -10000000000.0 eql)
($test (*            1.0           -1.0)                     -1.0 eql)
($test (*            1.0            0.0)                      0.0 eql)
($test (*            1.0            1.0)                      1.0 eql)
($test (*            1.0  10000000000.0)            10000000000.0 eql)
($test (*            1.0 *most-negative-float*) *most-negative-float* eval-eql)
($test (*            1.0 *most-positive-float*) *most-positive-float* eval-eql)
($test (*  10000000000.0 -10000000000)   -100000000000000000000.0 eql)
($test (*  10000000000.0     -8388609)       -83886090000000000.0 eql)
($test (*  10000000000.0     -8388608)       -83886080000000000.0 eql)
($test (*  10000000000.0           -1)             -10000000000.0 eql)
($test (*  10000000000.0            0)                        0.0 eql)
($test (*  10000000000.0            1)              10000000000.0 eql)
($test (*  10000000000.0      8388607)        83886070000000000.0 eql)
($test (*  10000000000.0      8388608)        83886080000000000.0 eql)
($test (*  10000000000.0  10000000000)    100000000000000000000.0 eql)
($test (*  10000000000.0 -10000000000.0) -100000000000000000000.0 eql)
($test (*  10000000000.0           -1.0)           -10000000000.0 eql)
($test (*  10000000000.0            0.0)                      0.0 eql)
($test (*  10000000000.0            1.0)            10000000000.0 eql)
($test (*  10000000000.0  10000000000.0)  100000000000000000000.0 eql)
($error (* 10000000000.0 *most-negative-float*) <floating-point-overflow>)
($error (* 10000000000.0 *most-positive-float*) <floating-point-overflow>)
($error (* *most-negative-float* -10000000000) <floating-point-overflow>)
($error (* *most-negative-float*     -8388609) <floating-point-overflow>)
($error (* *most-negative-float*     -8388608) <floating-point-overflow>)
($test (* *most-negative-float*           -1) *most-positive-float* eval-eql)
($test (* *most-negative-float*            0) 0.0 eql)
($test (* *most-negative-float*            1) *most-negative-float* eval-eql)
($error (* *most-negative-float*      8388607) <floating-point-overflow>)
($error (* *most-negative-float*      8388608) <floating-point-overflow>)
($error (* *most-negative-float*  10000000000) <floating-point-overflow>)
($error (* *most-negative-float* *most-negative-float*) <floating-point-overflow>)
($error (* *most-negative-float* *most-positive-float*) <floating-point-overflow>)
($error (* *most-positive-float* -10000000000) <floating-point-overflow>)
($error (* *most-positive-float*     -8388609) <floating-point-overflow>)
($error (* *most-positive-float*     -8388608) <floating-point-overflow>)
($test (* *most-positive-float*           -1) *most-negative-float* eval-eql)
($test (* *most-positive-float*            0) 0.0 eql)
($test (* *most-positive-float*            1) *most-positive-float* eval-eql)
($error (* *most-positive-float*      8388607) <floating-point-overflow>)
($error (* *most-positive-float*      8388608) <floating-point-overflow>)
($error (* *most-positive-float*  10000000000) <floating-point-overflow>)
($error (* *most-positive-float* *most-negative-float*) <floating-point-overflow>)
($error (* *most-positive-float* *most-positive-float*) <floating-point-overflow>)
;;;
($error (* -1e-300 -1e-300) <floating-point-underflow>)
($error (* -1e-300  1e-300) <floating-point-underflow>)
($error (*  1e-300 -1e-300) <floating-point-underflow>)
($error (*  1e-300  1e-300) <floating-point-underflow>)
;;; 3 arguments
($test (* 0 0 0) 0 eql)
($test (* 0.0 0.0 0.0) 0.0 eql)
($test (* 10 20 30) 6000 eql)
($test (* 10.0 20.0 30.0) 6000.0 eql)

;;;
;;; function (- x+) --> <number>
;;;
($ap 2 "-" P.69)
($test (- 1) -1 eql)
($test (- -4.0) 4.0 eql)
($test (- 4.0) -4.0 eql)
($test (eql (- 0.0) -0.0) t)
($test (eql (- -0.0) 0.0) t)
($test (- 1 2) -1 eql)
($test (- 92 43) 49 eql)
($test (- 2.3 -3.0) 5.3 eql)
($test (- 0.0 0.0) 0.0 eql)
($test (- 3 4 5) -6 eql)
;;;
($argc - 1 0 1)
($type - ($integer $float) :target)
($type - ($integer $float) 0 :target)
($type - ($integer $float) 0 0 :target)
;;; 1 argument
($test (- -10000000000)  10000000000 eql)
($test (-     -8388609)      8388609 eql)
($test (-     -8388608)      8388608 eql)
($test (-     -8388607)      8388607 eql)
($test (-            0)            0 eql)
($test (-      8388607)     -8388607 eql)
($test (-      8388608)     -8388608 eql)
($test (-      8388609)     -8388609 eql)
($test (-  10000000000) -10000000000 eql)
($test (- -123.45)  123.45 eql)
($test (-    0.0)     0.0  eql)
($test (-  123.45) -123.45 eql)
($test (- *most-negative-float*) *most-positive-float* eval-eql)
($test (- *most-positive-float*) *most-negative-float* eval-eql)
;;; 2 arguments
($test (- -10000000000 -10000000000)              0 eql)
($test (- -10000000000     -8388609)    -9991611391 eql)
($test (- -10000000000     -8388608)    -9991611392 eql)
($test (- -10000000000           -1)    -9999999999 eql)
($test (- -10000000000            0)   -10000000000 eql)
($test (- -10000000000            1)   -10000000001 eql)
($test (- -10000000000      8388607)   -10008388607 eql)
($test (- -10000000000      8388608)   -10008388608 eql)
($test (- -10000000000  10000000000)   -20000000000 eql)
($test (- -10000000000 -10000000000.0)            0.0 eql)
($test (- -10000000000           -1.0)  -9999999999.0 eql)
($test (- -10000000000            0.0) -10000000000.0 eql)
($test (- -10000000000            1.0) -10000000001.0 eql)
($test (- -10000000000  10000000000.0) -20000000000.0 eql)
($test (-     -8388609 -10000000000)     9991611391 eql)
($test (-     -8388609     -8388609)              0 eql)
($test (-     -8388609     -8388608)             -1 eql)
($test (-     -8388609           -1)       -8388608 eql)
($test (-     -8388609            0)       -8388609 eql)
($test (-     -8388609            1)       -8388610 eql)
($test (-     -8388609      8388607)      -16777216 eql)
($test (-     -8388609      8388608)      -16777217 eql)
($test (-     -8388609  10000000000)   -10008388609 eql)
($test (-     -8388609 -10000000000.0)   9991611391.0 eql)
($test (-     -8388609           -1.0)     -8388608.0 eql)
($test (-     -8388609            0.0)     -8388609.0 eql)
($test (-     -8388609            1.0)     -8388610.0 eql)
($test (-     -8388609  10000000000.0) -10008388609.0 eql)
($test (-     -8388608 -10000000000)     9991611392 eql)
($test (-     -8388608     -8388609)              1 eql)
($test (-     -8388608     -8388608)              0 eql)
($test (-     -8388608           -1)       -8388607 eql)
($test (-     -8388608            0)       -8388608 eql)
($test (-     -8388608            1)       -8388609 eql)
($test (-     -8388608      8388607)      -16777215 eql)
($test (-     -8388608      8388608)      -16777216 eql)
($test (-     -8388608  10000000000)   -10008388608 eql)
($test (-     -8388608 -10000000000.0)   9991611392.0 eql)
($test (-     -8388608           -1.0)     -8388607.0 eql)
($test (-     -8388608            0.0)     -8388608.0 eql)
($test (-     -8388608            1.0)     -8388609.0 eql)
($test (-     -8388608  10000000000.0) -10008388608.0 eql)
($test (-           -1 -10000000000)     9999999999 eql)
($test (-           -1     -8388609)        8388608 eql)
($test (-           -1     -8388608)        8388607 eql)
($test (-           -1           -1)              0 eql)
($test (-           -1            0)             -1 eql)
($test (-           -1            1)             -2 eql)
($test (-           -1      8388607)       -8388608 eql)
($test (-           -1      8388608)       -8388609 eql)
($test (-           -1  10000000000)   -10000000001 eql)
($test (-           -1 -10000000000.0)   9999999999.0 eql)
($test (-           -1           -1.0)            0.0 eql)
($test (-           -1            0.0)           -1.0 eql)
($test (-           -1            1.0)           -2.0 eql)
($test (-           -1  10000000000.0) -10000000001.0 eql)
($test (-            0 -10000000000)    10000000000 eql)
($test (-            0     -8388609)        8388609 eql)
($test (-            0     -8388608)        8388608 eql)
($test (-            0           -1)              1 eql)
($test (-            0            0)              0 eql)
($test (-            0            1)             -1 eql)
($test (-            0      8388607)       -8388607 eql)
($test (-            0      8388608)       -8388608 eql)
($test (-            0  10000000000)   -10000000000 eql)
($test (-            0 -10000000000.0)  10000000000.0 eql)
($test (-            0           -1.0)            1.0 eql)
($test (-            0            0.0)            0.0 eql)
($test (-            0            1.0)           -1.0 eql)
($test (-            0  10000000000.0) -10000000000.0 eql)
($test (-            0 *most-negative-float*) *most-positive-float* eval-eql)
($test (-            0 *most-positive-float*) *most-negative-float* eval-eql)
($test (-            1 -10000000000)    10000000001 eql)
($test (-            1     -8388609)        8388610 eql)
($test (-            1     -8388608)        8388609 eql)
($test (-            1           -1)              2 eql)
($test (-            1            0)              1 eql)
($test (-            1            1)              0 eql)
($test (-            1      8388607)       -8388606 eql)
($test (-            1      8388608)       -8388607 eql)
($test (-            1  10000000000)    -9999999999 eql)
($test (-            1 -10000000000.0)  10000000001.0 eql)
($test (-            1           -1.0)            2.0 eql)
($test (-            1            0.0)            1.0 eql)
($test (-            1            1.0)            0.0 eql)
($test (-            1  10000000000.0)  -9999999999.0 eql)
($test (-      8388607 -10000000000)    10008388607 eql)
($test (-      8388607     -8388609)       16777216 eql)
($test (-      8388607     -8388608)       16777215 eql)
($test (-      8388607           -1)        8388608 eql)
($test (-      8388607            0)        8388607 eql)
($test (-      8388607            1)        8388606 eql)
($test (-      8388607      8388607)              0 eql)
($test (-      8388607      8388608)             -1 eql)
($test (-      8388607  10000000000)    -9991611393 eql)
($test (-      8388607 -10000000000.0)  10008388607.0 eql)
($test (-      8388607           -1.0)      8388608.0 eql)
($test (-      8388607            0.0)      8388607.0 eql)
($test (-      8388607            1.0)      8388606.0 eql)
($test (-      8388607  10000000000.0)  -9991611393.0 eql)
($test (-      8388608 -10000000000)    10008388608 eql)
($test (-      8388608     -8388609)       16777217 eql)
($test (-      8388608     -8388608)       16777216 eql)
($test (-      8388608           -1)        8388609 eql)
($test (-      8388608            0)        8388608 eql)
($test (-      8388608            1)        8388607 eql)
($test (-      8388608      8388607)              1 eql)
($test (-      8388608      8388608)              0 eql)
($test (-      8388608  10000000000)    -9991611392 eql)
($test (-      8388608 -10000000000.0)  10008388608.0 eql)
($test (-      8388608           -1.0)      8388609.0 eql)
($test (-      8388608            0.0)      8388608.0 eql)
($test (-      8388608            1.0)      8388607.0 eql)
($test (-      8388608  10000000000.0)  -9991611392.0 eql)
($test (-  10000000000 -10000000000)    20000000000 eql)
($test (-  10000000000     -8388609)    10008388609 eql)
($test (-  10000000000     -8388608)    10008388608 eql)
($test (-  10000000000           -1)    10000000001 eql)
($test (-  10000000000            0)    10000000000 eql)
($test (-  10000000000            1)     9999999999 eql)
($test (-  10000000000      8388607)     9991611393 eql)
($test (-  10000000000      8388608)     9991611392 eql)
($test (-  10000000000  10000000000)              0 eql)
($test (-  10000000000 -10000000000.0)    20000000000.0 eql)
($test (-  10000000000           -1.0)    10000000001.0 eql)
($test (-  10000000000            0.0)    10000000000.0 eql)
($test (-  10000000000            1.0)     9999999999.0 eql)
($test (-  10000000000  10000000000.0)              0.0 eql)
($test (- -10000000000.0 -10000000000)              0.0 eql)
($test (- -10000000000.0     -8388609)    -9991611391.0 eql)
($test (- -10000000000.0     -8388608)    -9991611392.0 eql)
($test (- -10000000000.0           -1)    -9999999999.0 eql)
($test (- -10000000000.0            0)   -10000000000.0 eql)
($test (- -10000000000.0            1)   -10000000001.0 eql)
($test (- -10000000000.0      8388607)   -10008388607.0 eql)
($test (- -10000000000.0      8388608)   -10008388608.0 eql)
($test (- -10000000000.0  10000000000)   -20000000000.0 eql)
($test (- -10000000000.0 -10000000000.0)            0.0 eql)
($test (- -10000000000.0           -1.0)  -9999999999.0 eql)
($test (- -10000000000.0            0.0) -10000000000.0 eql)
($test (- -10000000000.0            1.0) -10000000001.0 eql)
($test (- -10000000000.0  10000000000.0) -20000000000.0 eql)
($test (-           -1.0 -10000000000)     9999999999.0 eql)
($test (-           -1.0     -8388609)        8388608.0 eql)
($test (-           -1.0     -8388608)        8388607.0 eql)
($test (-           -1.0           -1)              0.0 eql)
($test (-           -1.0            0)             -1.0 eql)
($test (-           -1.0            1)             -2.0 eql)
($test (-           -1.0      8388607)       -8388608.0 eql)
($test (-           -1.0      8388608)       -8388609.0 eql)
($test (-           -1.0  10000000000)   -10000000001.0 eql)
($test (-           -1.0 -10000000000.0)   9999999999.0 eql)
($test (-           -1.0           -1.0)            0.0 eql)
($test (-           -1.0            0.0)           -1.0 eql)
($test (-           -1.0            1.0)           -2.0 eql)
($test (-           -1.0  10000000000.0) -10000000001.0 eql)
($test (-            0.0 -10000000000)    10000000000.0 eql)
($test (-            0.0     -8388609)        8388609.0 eql)
($test (-            0.0     -8388608)        8388608.0 eql)
($test (-            0.0           -1)              1.0 eql)
($test (-            0.0            0)              0.0 eql)
($test (-            0.0            1)             -1.0 eql)
($test (-            0.0      8388607)       -8388607.0 eql)
($test (-            0.0      8388608)       -8388608.0 eql)
($test (-            0.0  10000000000)   -10000000000.0 eql)
($test (-            0.0 -10000000000.0)  10000000000.0 eql)
($test (-            0.0           -1.0)            1.0 eql)
($test (-            0.0            0.0)            0.0 eql)
($test (-            0.0            1.0)           -1.0 eql)
($test (-            0.0  10000000000.0) -10000000000.0 eql)
($test (-            0.0 *most-negative-float*) *most-positive-float* eval-eql)
($test (-            0.0 *most-positive-float*) *most-negative-float* eval-eql)
($test (-            1.0 -10000000000)    10000000001.0 eql)
($test (-            1.0     -8388609)        8388610.0 eql)
($test (-            1.0     -8388608)        8388609.0 eql)
($test (-            1.0           -1)              2.0 eql)
($test (-            1.0            0)              1.0 eql)
($test (-            1.0            1)              0.0 eql)
($test (-            1.0      8388607)       -8388606.0 eql)
($test (-            1.0      8388608)       -8388607.0 eql)
($test (-            1.0  10000000000)    -9999999999.0 eql)
($test (-            1.0 -10000000000.0)  10000000001.0 eql)
($test (-            1.0           -1.0)            2.0 eql)
($test (-            1.0            0.0)            1.0 eql)
($test (-            1.0            1.0)            0.0 eql)
($test (-            1.0  10000000000.0)  -9999999999.0 eql)
($test (-  10000000000.0 -10000000000)    20000000000.0 eql)
($test (-  10000000000.0     -8388609)    10008388609.0 eql)
($test (-  10000000000.0     -8388608)    10008388608.0 eql)
($test (-  10000000000.0           -1)    10000000001.0 eql)
($test (-  10000000000.0            0)    10000000000.0 eql)
($test (-  10000000000.0            1)     9999999999.0 eql)
($test (-  10000000000.0      8388607)     9991611393.0 eql)
($test (-  10000000000.0      8388608)     9991611392.0 eql)
($test (-  10000000000.0  10000000000)              0.0 eql)
($test (-  10000000000.0 -10000000000.0)  20000000000.0 eql)
($test (-  10000000000.0           -1.0)  10000000001.0 eql)
($test (-  10000000000.0            0.0)  10000000000.0 eql)
($test (-  10000000000.0            1.0)   9999999999.0 eql)
($test (-  10000000000.0  10000000000.0)            0.0 eql)
($test (- *most-negative-float* 0)   *most-negative-float* eval-eql)
($test (- *most-negative-float* 0.0) *most-negative-float* eval-eql)
($test (- *most-negative-float* *most-negative-float*) 0.0 eql)
($error (- *most-negative-float* *most-positive-float*) <floating-point-overflow>)
($test (- *most-positive-float* 0)   *most-positive-float* eval-eql)
($test (- *most-positive-float* 0.0) *most-positive-float* eval-eql)
($error (- *most-positive-float* *most-negative-float*) <floating-point-overflow>)
($test (- *most-positive-float* *most-positive-float*) 0.0 eql)
;;; 3 arguments
($test (- 0 0 0) 0 eql)
($test (- 0.0 0.0 0.0) 0.0 eql)
($test (- 10 20 30) -40 eql)
($test (- 10.0 20.0 30.0) -40.0 eql)


;;;
;;; function (QUOTIENT dividend divisor+) --> <number>
;;;
($ap 2 "quotient" P.70)
($test (quotient 10 5) 2 eql)
($test (quotient 1 2) 0.5 eql)
($test (quotient 2 -0.5) -4.0 eql)
;($error (quotient 0 0.0) <division-by-zero>)
($test (quotient 2 3 4) 0.16666666666666666 eql)
;;;
($argc quotient 2 0 1)
($type quotient ($integer $float) :target 1)
($type quotient ($integer $float) 0 :target)
($type quotient ($integer $float) 0 1 :target)

;;; 2 arguments
($test (quotient -300000000000000000000   -400000000000000000000)                        0.75 eql)
($test (quotient -300000000000000000000   -300000000000000000000)                        1 eql)
($test (quotient -300000000000000000000   -200000000000000000000)                        1.5 eql)
;($test (quotient -300000000000000000000             -30000000000)              10000000000 eql)
($test (quotient -300000000000000000000                       -3)    100000000000000000000 eql)
($test (quotient -300000000000000000000                        3)   -100000000000000000000 eql)
($test (quotient -300000000000000000000              30000000000)             -10000000000 eql)
($test (quotient -300000000000000000000    200000000000000000000)                       -1.5 eql)
($test (quotient -300000000000000000000    300000000000000000000)                       -1 eql)
($test (quotient -300000000000000000000    400000000000000000000)                       -0.75 eql)
($test (quotient -300000000000000000000   -300000000000000000000.0)                      1.0 eql)
($test (quotient -300000000000000000000             -30000000000.0)                      1.0e10 eql)
($test (quotient -300000000000000000000                       -3.0)                      1.0e20 eql)
($test (quotient -300000000000000000000                        3.0)                     -1.0e20 eql)
($test (quotient -300000000000000000000              30000000000.0)                     -1.0e10 eql)

($test (quotient -300000000000000000000    300000000000000000000.0)                     -1.0 eql)
($test (quotient           -30000000000   -300000000000000000000)                        1.0e-10 eql)
($test (quotient           -30000000000             -40000000000)                        0.75 eql)
($test (quotient           -30000000000             -30000000000)                        1 eql)
($test (quotient           -30000000000             -20000000000)                        1.5 eql)
($test (quotient           -30000000000                       -3)              10000000000 eql)
($test (quotient           -30000000000                        3)             -10000000000 eql)
($test (quotient           -30000000000              20000000000)                       -1.5 eql)
($test (quotient           -30000000000              30000000000)                       -1 eql)
($test (quotient           -30000000000              40000000000)                       -0.75 eql)
($test (quotient           -30000000000    300000000000000000000)                       -1.0e-10 eql)
($test (quotient           -30000000000   -300000000000000000000.0)                      1.0e-10 eql)
($test (quotient           -30000000000             -30000000000.0)                      1.0 eql)
($test (quotient           -30000000000                       -3.0)                      1.0e10 eql)
($test (quotient           -30000000000                        3.0)                     -1.0e10 eql)
($test (quotient           -30000000000              30000000000.0)                     -1.0 eql)
($test (quotient           -30000000000    300000000000000000000.0)                     -1.0e-10 eql)
($test (quotient                     -3   -300000000000000000000)                        1.0e-20 eql)
($test (quotient                     -3             -30000000000)                        1.0e-10 eql)
($test (quotient                     -3                       -4)                        0.75 eql)
($test (quotient                     -3                       -3)                        1 eql)
($test (quotient                     -3                       -2)                        1.5 eql)
($test (quotient                     -3                        2)                       -1.5 eql)
($test (quotient                     -3                        3)                       -1 eql)
($test (quotient                     -3                        4)                       -0.75 eql)
($test (quotient                     -3              30000000000)                       -1.0e-10 eql)
($test (quotient                     -3    300000000000000000000)                       -1.0e-20 eql)
($test (quotient                     -3   -300000000000000000000.0)                      1.0e-20 eql)
($test (quotient                     -3             -30000000000.0)                      1.0e-10 eql)
($test (quotient                     -3                       -3.0)                      1.0 eql)
($test (quotient                     -3                        3.0)                     -1.0 eql)
($test (quotient                     -3              30000000000.0)                     -1.0e-10 eql)
($test (quotient                     -3    300000000000000000000.0)                     -1.0e-20 eql)
($test (quotient                      0   -300000000000000000000)                        0 eql)
($test (quotient                      0             -30000000000)                        0 eql)
($test (quotient                      0                       -3)                        0 eql)
($test (quotient                      0                        3)                        0 eql)
($test (quotient                      0              30000000000)                        0 eql)
($test (quotient                      0    300000000000000000000)                        0 eql)
($test (quotient                      0   -300000000000000000000.0)                      0.0 eql)
($test (quotient                      0                       -3.0)                      0.0 eql)
($test (quotient                      0                        3.0)                      0.0 eql)
($test (quotient                      0    300000000000000000000.0)                      0.0 eql)
($test (quotient                      0 *most-negative-float*) 0.0 eql)
($test (quotient                      0 *most-positive-float*) 0.0 eql)
($test (quotient                      3   -300000000000000000000)                       -1.0e-20 eql)
($test (quotient                      3             -30000000000)                       -1.0e-10 eql)
($test (quotient                      3                       -4)                       -0.75 eql)
($test (quotient                      3                       -3)                       -1 eql)
($test (quotient                      3                       -2)                       -1.5 eql)
($test (quotient                      3                        2)                        1.5 eql)
($test (quotient                      3                        3)                        1 eql)
($test (quotient                      3                        4)                        0.75 eql)
($test (quotient                      3              30000000000)                        1.0e-10 eql)
($test (quotient                      3    300000000000000000000)                        1.0e-20 eql)
($test (quotient                      3   -300000000000000000000.0)                     -1.0e-20 eql)
($test (quotient                      3             -30000000000.0)                     -1.0e-10 eql)
($test (quotient                      3                       -3.0)                     -1.0 eql)
($test (quotient                      3                        3.0)                      1.0 eql)
($test (quotient                      3              30000000000.0)                      1.0e-10 eql)
($test (quotient                      3    300000000000000000000.0)                      1.0e-20 eql)
($test (quotient            30000000000   -300000000000000000000)                       -1.0e-10 eql)
($test (quotient            30000000000             -40000000000)                       -0.75 eql)
($test (quotient            30000000000             -30000000000)                       -1 eql)
($test (quotient            30000000000             -20000000000)                       -1.5 eql)
($test (quotient            30000000000                       -3)             -10000000000 eql)
($test (quotient            30000000000                        3)              10000000000 eql)

($test (quotient            30000000000              20000000000)                        1.5 eql)
($test (quotient            30000000000              30000000000)                        1 eql)
($test (quotient            30000000000              40000000000)                        0.75 eql)
($test (quotient            30000000000    300000000000000000000)                        1.0e-10 eql)
($test (quotient            30000000000   -300000000000000000000.0)                     -1.0e-10 eql)
($test (quotient            30000000000             -30000000000.0)                     -1.0 eql)
($test (quotient            30000000000                       -3.0)                     -1.0e10 eql)
($test (quotient            30000000000                        3.0)                      1.0e10 eql)
($test (quotient            30000000000              30000000000.0)                      1.0 eql)
($test (quotient            30000000000    300000000000000000000.0)                      1.0e-10 eql)
($test (quotient  300000000000000000000   -400000000000000000000)                       -0.75 eql)
($test (quotient  300000000000000000000   -300000000000000000000)                       -1 eql)
($test (quotient  300000000000000000000   -200000000000000000000)                       -1.5 eql)
($test (quotient  300000000000000000000             -30000000000)             -10000000000 eql)
($test (quotient  300000000000000000000                       -3)   -100000000000000000000 eql)
($test (quotient  300000000000000000000                        3)    100000000000000000000 eql)
($test (quotient  300000000000000000000              30000000000)              10000000000 eql)
($test (quotient  300000000000000000000    200000000000000000000)                        1.5 eql)
($test (quotient  300000000000000000000    300000000000000000000)                        1 eql)
($test (quotient  300000000000000000000    400000000000000000000)                        0.75 eql)
($test (quotient  300000000000000000000   -300000000000000000000.0)                     -1.0 eql)
($test (quotient  300000000000000000000             -30000000000.0)                     -1.0e10 eql)
($test (quotient  300000000000000000000                       -3.0)                     -1.0e20 eql)
($test (quotient  300000000000000000000                        3.0)                      1.0e20 eql)
($test (quotient  300000000000000000000              30000000000.0)                      1.0e10 eql)
($test (quotient  300000000000000000000    300000000000000000000.0)                      1.0 eql)
($test (quotient -300000000000000000000.0 -400000000000000000000)                        0.75 eql)
($test (quotient -300000000000000000000.0 -300000000000000000000)                        1.0 eql)
($test (quotient -300000000000000000000.0 -200000000000000000000)                        1.5 eql)
($test (quotient -300000000000000000000.0           -30000000000)              10000000000.0 eql)
($test (quotient -300000000000000000000.0                     -3)    100000000000000000000.0 eql)
($test (quotient -300000000000000000000.0                      3)   -100000000000000000000.0 eql)
($test (quotient -300000000000000000000.0            30000000000)             -10000000000.0 eql)
($test (quotient -300000000000000000000.0  200000000000000000000)                       -1.5 eql)
($test (quotient -300000000000000000000.0  300000000000000000000)                       -1.0 eql)
($test (quotient -300000000000000000000.0  400000000000000000000)                       -0.75 eql)
($test (quotient -300000000000000000000.0 -300000000000000000000.0)                      1.0 eql)
($test (quotient -300000000000000000000.0           -30000000000.0)                      1.0e10 eql)
($test (quotient -300000000000000000000.0                     -3.0)                      1.0e20 eql)
($test (quotient -300000000000000000000.0                      3.0)                     -1.0e20 eql)
($test (quotient -300000000000000000000.0            30000000000.0)                     -1.0e10 eql)
($test (quotient -300000000000000000000.0  300000000000000000000.0)                     -1.0 eql)
($test (quotient           -30000000000.0 -300000000000000000000)                        1.0e-10 eql)
($test (quotient           -30000000000.0           -40000000000)                        0.75 eql)
($test (quotient           -30000000000.0           -30000000000)                        1.0 eql)
($test (quotient           -30000000000.0           -20000000000)                        1.5 eql)
($test (quotient           -30000000000.0                     -3)              10000000000.0 eql)
($test (quotient           -30000000000.0                      3)             -10000000000.0 eql)
($test (quotient           -30000000000.0            20000000000)                       -1.5 eql)
($test (quotient           -30000000000.0            30000000000)                       -1.0 eql)
($test (quotient           -30000000000.0            40000000000)                       -0.75 eql)
($test (quotient           -30000000000.0  300000000000000000000)                       -1.0e-10 eql)
($test (quotient           -30000000000.0 -300000000000000000000.0)                      1.0e-10 eql)
($test (quotient           -30000000000.0           -30000000000.0)                      1.0 eql)
($test (quotient           -30000000000.0                     -3.0)                      1.0e10 eql)
($test (quotient           -30000000000.0                      3.0)                     -1.0e10 eql)
($test (quotient           -30000000000.0            30000000000.0)                     -1.0 eql)
($test (quotient           -30000000000.0  300000000000000000000.0)                     -1.0e-10 eql)
($test (quotient                     -3.0 -300000000000000000000)                        1.0e-20 eql)
($test (quotient                     -3.0           -30000000000)                        1.0e-10 eql)
($test (quotient                     -3.0                     -4)                        0.75 eql)
($test (quotient                     -3.0                     -3)                        1.0 eql)
($test (quotient                     -3.0                     -2)                        1.5 eql)
($test (quotient                     -3.0                      2)                       -1.5 eql)
($test (quotient                     -3.0                      3)                       -1.0 eql)
($test (quotient                     -3.0                      4)                       -0.75 eql)
($test (quotient                     -3.0            30000000000)                       -1.0e-10 eql)
($test (quotient                     -3.0  300000000000000000000)                       -1.0e-20 eql)
($test (quotient                     -3.0 -300000000000000000000.0)                      1.0e-20 eql)
($test (quotient                     -3.0           -30000000000.0)                      1.0e-10 eql)
($test (quotient                     -3.0                     -3.0)                      1.0 eql)
($test (quotient                     -3.0                      3.0)                     -1.0 eql)
($test (quotient                     -3.0            30000000000.0)                     -1.0e-10 eql)
($test (quotient                     -3.0  300000000000000000000.0)                     -1.0e-20 eql)
($test (quotient                      0.0 -300000000000000000000)                        0.0 eql)
($test (quotient                      0.0           -30000000000)                        0.0 eql)
($test (quotient                      0.0                     -3)                        0.0 eql)
($test (quotient                      0.0                      3)                        0.0 eql)
($test (quotient                      0.0            30000000000)                        0.0 eql)
($test (quotient                      0.0  300000000000000000000)                        0.0 eql)
($test (quotient                      0.0 -300000000000000000000.0)                      0.0 eql)
($test (quotient                      0.0                     -3.0)                      0.0 eql)
($test (quotient                      0.0                      3.0)                      0.0 eql)
($test (quotient                      0.0  300000000000000000000.0)                      0.0 eql)
($test (quotient                      0.0 *most-negative-float*) 0.0 eql)
($test (quotient                      0.0 *most-positive-float*) 0.0 eql)
($test (quotient                      3.0 -300000000000000000000)                       -1.0e-20 eql)
($test (quotient                      3.0           -30000000000)                       -1.0e-10 eql)
($test (quotient                      3.0                     -4)                       -0.75 eql)
($test (quotient                      3.0                     -3)                       -1.0 eql)
($test (quotient                      3.0                     -2)                       -1.5 eql)
($test (quotient                      3.0                      2)                        1.5 eql)
($test (quotient                      3.0                      3)                        1.0 eql)
($test (quotient                      3.0                      4)                        0.75 eql)
($test (quotient                      3.0            30000000000)                        1.0e-10 eql)
($test (quotient                      3.0  300000000000000000000)                        1.0e-20 eql)
($test (quotient                      3.0 -300000000000000000000.0)                     -1.0e-20 eql)
($test (quotient                      3.0           -30000000000.0)                     -1.0e-10 eql)
($test (quotient                      3.0                     -3.0)                     -1.0 eql)
($test (quotient                      3.0                      3.0)                      1.0 eql)
($test (quotient                      3.0            30000000000.0)                      1.0e-10 eql)
($test (quotient                      3.0  300000000000000000000.0)                      1.0e-20 eql)
($test (quotient            30000000000.0 -300000000000000000000)                       -1.0e-10 eql)
($test (quotient            30000000000.0           -40000000000)                       -0.75 eql)
($test (quotient            30000000000.0           -30000000000)                       -1.0 eql)
($test (quotient            30000000000.0           -20000000000)                       -1.5 eql)
($test (quotient            30000000000.0                     -3)             -10000000000.0 eql)
($test (quotient            30000000000.0                      3)              10000000000.0 eql)
($test (quotient            30000000000.0            20000000000)                        1.5 eql)
($test (quotient            30000000000.0            30000000000)                        1.0 eql)
($test (quotient            30000000000.0            40000000000)                        0.75 eql)
($test (quotient            30000000000.0  300000000000000000000)                        1.0e-10 eql)
($test (quotient            30000000000.0 -300000000000000000000.0)                     -1.0e-10 eql)
($test (quotient            30000000000.0           -30000000000.0)                     -1.0 eql)
($test (quotient            30000000000.0                     -3.0)                     -1.0e10 eql)
($test (quotient            30000000000.0                      3.0)                      1.0e10 eql)
($test (quotient            30000000000.0            30000000000.0)                      1.0 eql)
($test (quotient            30000000000.0  300000000000000000000.0)                      1.0e-10 eql)
($test (quotient  300000000000000000000.0 -400000000000000000000)                       -0.75 eql)
($test (quotient  300000000000000000000.0 -300000000000000000000)                       -1.0 eql)
($test (quotient  300000000000000000000.0 -200000000000000000000)                       -1.5 eql)
($test (quotient  300000000000000000000.0           -30000000000)             -10000000000.0 eql)
($test (quotient  300000000000000000000.0                     -3)   -100000000000000000000.0 eql)
($test (quotient  300000000000000000000.0                      3)    100000000000000000000.0 eql)
($test (quotient  300000000000000000000.0            30000000000)              10000000000.0 eql)
($test (quotient  300000000000000000000.0  200000000000000000000)                        1.5 eql)
($test (quotient  300000000000000000000.0  300000000000000000000)                        1.0 eql)
($test (quotient  300000000000000000000.0  400000000000000000000)                        0.75 eql)
($test (quotient  300000000000000000000.0 -300000000000000000000.0)                     -1.0 eql)
($test (quotient  300000000000000000000.0           -30000000000.0)                     -1.0e10 eql)
($test (quotient  300000000000000000000.0                     -3.0)                     -1.0e20 eql)
($test (quotient  300000000000000000000.0                      3.0)                      1.0e20 eql)
($test (quotient  300000000000000000000.0            30000000000.0)                      1.0e10 eql)
($test (quotient  300000000000000000000.0  300000000000000000000.0)                      1.0 eql)
;;;
($error (quotient -300000000000000000000   0)   <division-by-zero>)
($error (quotient           -30000000000   0)   <division-by-zero>)
($error (quotient                     -3   0)   <division-by-zero>)
($error (quotient                      0   0)   <division-by-zero>)
($error (quotient                      3   0)   <division-by-zero>)
($error (quotient            30000000000   0)   <division-by-zero>)
($error (quotient  300000000000000000000   0)   <division-by-zero>)
($error (quotient -300000000000000000000.0 0)   <division-by-zero>)
($error (quotient                     -3.0 0)   <division-by-zero>)
($error (quotient                      0.0 0)   <division-by-zero>)
($error (quotient                      3.0 0)   <division-by-zero>)
($error (quotient  300000000000000000000.0 0)   <division-by-zero>)
($error (quotient *most-negative-float*    0)   <division-by-zero>)
($error (quotient *most-positive-float*    0)   <division-by-zero>)
;;;
($error (quotient -300000000000000000000   0.0) <division-by-zero>)
($error (quotient           -30000000000   0.0) <division-by-zero>)
($error (quotient                     -3   0.0) <division-by-zero>)
($error (quotient                      0   0.0) <division-by-zero>)
($error (quotient                      3   0.0) <division-by-zero>)
($error (quotient            30000000000   0.0) <division-by-zero>)
($error (quotient  300000000000000000000   0.0) <division-by-zero>)
($error (quotient -300000000000000000000.0 0.0) <division-by-zero>)
($error (quotient                     -3.0 0.0) <division-by-zero>)
($error (quotient                      0.0 0.0) <division-by-zero>)
($error (quotient                      3.0 0.0) <division-by-zero>)
($error (quotient  300000000000000000000.0 0.0) <division-by-zero>)
($error (quotient *most-negative-float*    0.0) <division-by-zero>)
($error (quotient *most-positive-float*    0.0) <division-by-zero>)
;;;
($test (quotient *most-negative-float* -1) *most-positive-float* eval-eql)
($test (quotient *most-negative-float*  1) *most-negative-float* eval-eql)
($test (quotient *most-negative-float* *most-negative-float*)  1.0 eql)
($test (quotient *most-negative-float* *most-positive-float*) -1.0 eql)
;;;
($test (quotient *most-positive-float* -1) *most-negative-float* eval-eql)
($test (quotient *most-positive-float*  1) *most-positive-float* eval-eql)
($test (quotient *most-positive-float* *most-negative-float*) -1.0 eql)
($test (quotient *most-positive-float* *most-positive-float*)  1.0 eql)
;;;
($error (quotient   1 *most-negative-float*) <floating-point-underflow>)
($error (quotient   1 *most-positive-float*) <floating-point-underflow>)
;($error (quotient  -1 *most-negative-float*) <floating-point-underflow>)
;($error (quotient  -1 *most-positive-float*) <floating-point-underflow>)
($error (quotient   1.0 *most-negative-float*) <floating-point-underflow>)
($error (quotient   1.0 *most-positive-float*) <floating-point-underflow>)
($error (quotient  -1.0 *most-negative-float*) <floating-point-underflow>)
($error (quotient  -1.0 *most-positive-float*) <floating-point-underflow>)
;;;
($error (quotient *most-negative-float*  0.1) <floating-point-overflow>)
($error (quotient *most-negative-float* -0.1) <floating-point-overflow>)
($error (quotient *most-positive-float*  0.1) <floating-point-overflow>)
($error (quotient *most-positive-float* -0.1) <floating-point-overflow>)

;;;
;;; function (RECIPROCAL x) --> <number>
;;;
($ap 2 "reciprocal" P.70)
($test (reciprocal 2) 0.5 eql)
;;;
($argc reciprocal 1 0 0)
($type reciprocal ($integer $float) :target)
;;;
($test (reciprocal -10000000000) -1.0e-10 eql)
($test (reciprocal         -100) -0.01 eql)
($test (reciprocal           -1) -1 eql)
($error (reciprocal            0) <division-by-zero>)
($test (reciprocal            1)  1 eql)
($test (reciprocal          100)  0.01 eql)
($test (reciprocal  10000000000)  1.0e-10 eql)
($test (reciprocal         -100.0) -0.01 eql)
($test (reciprocal           -1.0) -1.0 eql)
($error (reciprocal            0.0) <division-by-zero>)
($test (reciprocal            1.0)  1.0 eql)
($test (reciprocal          100.0)  0.01 eql)
($error (reciprocal *negative-infinity*) <floating-point-underflow>)
($error (reciprocal *positive-infinity*) <floating-point-underflow>)

;; modified by sasagawa888
(defun ~eql (x y)
     (or (~eql2 x y)
         (~eql1 x y)))
(defun ~eql1 (x y)
         (let* ((str1 (convert x <string>))
                (str2 (convert y <string>))
                (len (- (min (length str1) (length str2)) 1 0)))
           (string= (subseq str1 0 len) (subseq str2 0 len))))

(defun ~eql2 (x y)
     (and (< (abs x) (+ (abs y) 0.00000001))
          (> (abs x) (- (abs y) 0.00000001))))


;;;
;;; function (MAX x+) --> <number>
;;;
($ap 2 "max" P.70)
($test (max -5 3) 3 eql)
($test (max 2.0 3) 3 eql)
;;($test (max 2 2.0) 2 =)					; 2 or 2.0 (IDEF)
($test (max 1 5 2 4 3) 5 eql)
;;;
($argc max 1 0 1)
($type max ($integer $float) :target)
($type max ($integer $float) 0 :target)
;;; 1 argument
($test (max -10000000000) -10000000000 eql)
($test (max     -8388609)     -8388609 eql)
($test (max     -8388608)     -8388608 eql)
($test (max           -1)           -1 eql)
($test (max            0)            0 eql)
($test (max            1)            1 eql)
($test (max      8388607)      8388607 eql)
($test (max      8388608)      8388608 eql)
($test (max  10000000000)  10000000000 eql)
($test (max      -1234.5)      -1234.5 eql)
($test (max          0.0)          0.0 eql)
($test (max       1234.5)       1234.5 eql)
($test (max *most-negative-float*) *most-negative-float* eval-eql)
($test (max *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 arguments
($test (max -10000000000 -10000000000) -10000000000 eql)
($test (max -10000000000     -8388609)     -8388609 eql)
($test (max -10000000000     -8388608)     -8388608 eql)
($test (max -10000000000           -1)           -1 eql)
($test (max -10000000000            0)            0 eql)
($test (max -10000000000            1)            1 eql)
($test (max -10000000000      8388607)      8388607 eql)
($test (max -10000000000      8388608)      8388608 eql)
($test (max -10000000000  10000000000)  10000000000 eql)
($test (max -10000000000      -1234.5)      -1234.5 eql)
($test (max -10000000000          0.0)          0.0 eql)
($test (max -10000000000       1234.5)       1234.5 eql)
($test (max -10000000000 *most-negative-float*) -10000000000 eql)
($test (max -10000000000 *most-positive-float*) *most-positive-float* eval-eql)
($test (max     -8388609 -10000000000)     -8388609 eql)
($test (max     -8388609     -8388609)     -8388609 eql)
($test (max     -8388609     -8388608)     -8388608 eql)
($test (max     -8388609           -1)           -1 eql)
($test (max     -8388609            0)            0 eql)
($test (max     -8388609            1)            1 eql)
($test (max     -8388609      8388607)      8388607 eql)
($test (max     -8388609      8388608)      8388608 eql)
($test (max     -8388609  10000000000)  10000000000 eql)
($test (max     -8388609      -1234.5)      -1234.5 eql)
($test (max     -8388609          0.0)          0.0 eql)
($test (max     -8388609       1234.5)       1234.5 eql)
($test (max     -8388609 *most-negative-float*) -8388609 eql)
($test (max     -8388609 *most-positive-float*) *most-positive-float* eval-eql)
($test (max     -8388608 -10000000000)     -8388608 eql)
($test (max     -8388608     -8388609)     -8388608 eql)
($test (max     -8388608     -8388608)     -8388608 eql)
($test (max     -8388608           -1)           -1 eql)
($test (max     -8388608            0)            0 eql)
($test (max     -8388608            1)            1 eql)
($test (max     -8388608      8388607)      8388607 eql)
($test (max     -8388608      8388608)      8388608 eql)
($test (max     -8388608  10000000000)  10000000000 eql)
($test (max     -8388608      -1234.5)      -1234.5 eql)
($test (max     -8388608          0.0)          0.0 eql)
($test (max     -8388608       1234.5)       1234.5 eql)
($test (max     -8388608 *most-negative-float*) -8388608 eql)
($test (max     -8388608 *most-positive-float*) *most-positive-float* eval-eql)
($test (max           -1 -10000000000)           -1 eql)
($test (max           -1     -8388609)           -1 eql)
($test (max           -1     -8388608)           -1 eql)
($test (max           -1           -1)           -1 eql)
($test (max           -1            0)            0 eql)
($test (max           -1            1)            1 eql)
($test (max           -1      8388607)      8388607 eql)
($test (max           -1      8388608)      8388608 eql)
($test (max           -1  10000000000)  10000000000 eql)
($test (max           -1      -1234.5)           -1 eql)
($test (max           -1          0.0)          0.0 eql)
($test (max           -1       1234.5)       1234.5 eql)
($test (max           -1 *most-negative-float*) -1 eql)
($test (max           -1 *most-positive-float*) *most-positive-float* eval-eql)
($test (max            0 -10000000000)            0 eql)
($test (max            0     -8388609)            0 eql)
($test (max            0     -8388608)            0 eql)
($test (max            0           -1)            0 eql)
($test (max            0            0)            0 eql)
($test (max            0            1)            1 eql)
($test (max            0      8388607)      8388607 eql)
($test (max            0      8388608)      8388608 eql)
($test (max            0  10000000000)  10000000000 eql)
($test (max            0      -1234.5)            0 eql)
($test (max            0          0.0)            0 =)
($test (max            0       1234.5)       1234.5 eql)
($test (max            0 *most-negative-float*) 0 eql)
($test (max            0 *most-positive-float*) *most-positive-float* eval-eql)
($test (max            1 -10000000000)            1 eql)
($test (max            1     -8388609)            1 eql)
($test (max            1     -8388608)            1 eql)
($test (max            1           -1)            1 eql)
($test (max            1            0)            1 eql)
($test (max            1            1)            1 eql)
($test (max            1      8388607)      8388607 eql)
($test (max            1      8388608)      8388608 eql)
($test (max            1  10000000000)  10000000000 eql)
($test (max            1      -1234.5)            1 eql)
($test (max            1          0.0)            1 eql)
($test (max            1       1234.5)       1234.5 eql)
($test (max            1 *most-negative-float*) 1 eql)
($test (max            1 *most-positive-float*) *most-positive-float* eval-eql)
($test (max      8388607 -10000000000)      8388607 eql)
($test (max      8388607     -8388609)      8388607 eql)
($test (max      8388607     -8388608)      8388607 eql)
($test (max      8388607           -1)      8388607 eql)
($test (max      8388607            0)      8388607 eql)
($test (max      8388607            1)      8388607 eql)
($test (max      8388607      8388607)      8388607 eql)
($test (max      8388607      8388608)      8388608 eql)
($test (max      8388607  10000000000)  10000000000 eql)
($test (max      8388607      -1234.5)      8388607 eql)
($test (max      8388607          0.0)      8388607 eql)
($test (max      8388607       1234.5)      8388607 eql)
($test (max      8388607 *most-negative-float*) 8388607 eql)
($test (max      8388607 *most-positive-float*) *most-positive-float* eval-eql)
($test (max      8388608 -10000000000)      8388608 eql)
($test (max      8388608     -8388609)      8388608 eql)
($test (max      8388608     -8388608)      8388608 eql)
($test (max      8388608           -1)      8388608 eql)
($test (max      8388608            0)      8388608 eql)
($test (max      8388608            1)      8388608 eql)
($test (max      8388608      8388607)      8388608 eql)
($test (max      8388608      8388608)      8388608 eql)
($test (max      8388608  10000000000)  10000000000 eql)
($test (max      8388608      -1234.5)      8388608 eql)
($test (max      8388608          0.0)      8388608 eql)
($test (max      8388608       1234.5)      8388608 eql)
($test (max      8388608 *most-negative-float*) 8388608 eql)
($test (max      8388608 *most-positive-float*) *most-positive-float* eval-eql)
($test (max  10000000000 -10000000000)  10000000000 eql)
($test (max  10000000000     -8388609)  10000000000 eql)
($test (max  10000000000     -8388608)  10000000000 eql)
($test (max  10000000000           -1)  10000000000 eql)
($test (max  10000000000            0)  10000000000 eql)
($test (max  10000000000            1)  10000000000 eql)
($test (max  10000000000      8388607)  10000000000 eql)
($test (max  10000000000      8388608)  10000000000 eql)
($test (max  10000000000  10000000000)  10000000000 eql)
($test (max  10000000000      -1234.5)  10000000000 eql)
($test (max  10000000000          0.0)  10000000000 eql)
($test (max  10000000000       1234.5)  10000000000 eql)
($test (max  10000000000 *most-negative-float*) 10000000000 eql)
($test (max  10000000000 *most-positive-float*) *most-positive-float* eval-eql)
($test (max      -1234.5 -10000000000)      -1234.5 eql)
($test (max      -1234.5     -8388609)      -1234.5 eql)
($test (max      -1234.5     -8388608)      -1234.5 eql)
($test (max      -1234.5           -1)           -1 eql)
($test (max      -1234.5            0)            0 eql)
($test (max      -1234.5            1)            1 eql)
($test (max      -1234.5      8388607)      8388607 eql)
($test (max      -1234.5      8388608)      8388608 eql)
($test (max      -1234.5  10000000000)  10000000000 eql)
($test (max      -1234.5      -1234.5)      -1234.5 eql)
($test (max      -1234.5          0.0)          0.0 eql)
($test (max      -1234.5       1234.5)       1234.5 eql)
($test (max      -1234.5 *most-negative-float*) -1234.5 eql)
($test (max      -1234.5 *most-positive-float*) *most-positive-float* eval-eql)
($test (max          0.0 -10000000000)          0.0 eql)
($test (max          0.0     -8388609)          0.0 eql)
($test (max          0.0     -8388608)          0.0 eql)
($test (max          0.0           -1)          0.0 eql)
($test (max          0.0            0)            0 =)
($test (max          0.0            1)            1 eql)
($test (max          0.0      8388607)      8388607 eql)
($test (max          0.0      8388608)      8388608 eql)
($test (max          0.0  10000000000)  10000000000 eql)
($test (max          0.0      -1234.5)          0.0 eql)
($test (max          0.0          0.0)          0.0 eql)
($test (max          0.0       1234.5)       1234.5 eql)
($test (max          0.0 *most-negative-float*) 0.0 eql)
($test (max          0.0 *most-positive-float*) *most-positive-float* eval-eql)
($test (max       1234.5 -10000000000)       1234.5 eql)
($test (max       1234.5     -8388609)       1234.5 eql)
($test (max       1234.5     -8388608)       1234.5 eql)
($test (max       1234.5           -1)       1234.5 eql)
($test (max       1234.5            0)       1234.5 eql)
($test (max       1234.5            1)       1234.5 eql)
($test (max       1234.5      8388607)      8388607 eql)
($test (max       1234.5      8388608)      8388608 eql)
($test (max       1234.5  10000000000)  10000000000 eql)
($test (max       1234.5      -1234.5)       1234.5 eql)
($test (max       1234.5          0.0)       1234.5 eql)
($test (max       1234.5       1234.5)       1234.5 eql)
($test (max       1234.5 *most-negative-float*) 1234.5 eql)
($test (max       1234.5 *most-positive-float*) *most-positive-float* eval-eql)
($test (max *most-negative-float* -10000000000) -10000000000 eql)
($test (max *most-negative-float*     -8388609)     -8388609 eql)
($test (max *most-negative-float*     -8388608)     -8388608 eql)
($test (max *most-negative-float*           -1)           -1 eql)
($test (max *most-negative-float*            0)            0 eql)
($test (max *most-negative-float*            1)            1 eql)
($test (max *most-negative-float*      8388607)      8388607 eql)
($test (max *most-negative-float*      8388608)      8388608 eql)
($test (max *most-negative-float*  10000000000)  10000000000 eql)
($test (max *most-negative-float*      -1234.5)      -1234.5 eql)
($test (max *most-negative-float*          0.0)          0.0 eql)
($test (max *most-negative-float*       1234.5)       1234.5 eql)
($test (max *most-negative-float* *most-negative-float*) *most-negative-float* eval-eql)
($test (max *most-negative-float* *most-positive-float*) *most-positive-float* eval-eql)
($test (max *most-positive-float* -10000000000) *most-positive-float* eval-eql)
($test (max *most-positive-float*     -8388609) *most-positive-float* eval-eql)
($test (max *most-positive-float*     -8388608) *most-positive-float* eval-eql)
($test (max *most-positive-float*           -1) *most-positive-float* eval-eql)
($test (max *most-positive-float*            0) *most-positive-float* eval-eql)
($test (max *most-positive-float*            1) *most-positive-float* eval-eql)
($test (max *most-positive-float*      8388607) *most-positive-float* eval-eql)
($test (max *most-positive-float*      8388608) *most-positive-float* eval-eql)
($test (max *most-positive-float*  10000000000) *most-positive-float* eval-eql)
($test (max *most-positive-float*      -1234.5) *most-positive-float* eval-eql)
($test (max *most-positive-float*          0.0) *most-positive-float* eval-eql)
($test (max *most-positive-float*       1234.5) *most-positive-float* eval-eql)
($test (max *most-positive-float* *most-negative-float*) *most-positive-float* eval-eql)
($test (max *most-positive-float* *most-positive-float*) *most-positive-float* eval-eql)
;;; 3 arguments
($test (max 0 0 0) 0 eql)
($test (max 0.0 0.0 0.0) 0.0 eql)
($test (max 10 20 30) 30 eql)
($test (max 10.0 20.0 30.0) 30.0 eql)

;;;
;;; function (MIN x+) --> <number>
;;;
($ap 2 "min" P.70)
($test (min 3 1) 1 eql)
($test (min 1 2.0) 1 eql)
;;($test (min 2 2.0) 2 =)					; 2 or 2.0 (IDEF)
($test (min 1 5 2 4 3) 1 eql)
;;;
($argc min 1 0 1)
($type min ($integer $float) :target)
($type min ($integer $float) 0 :target)
;;; 1 argument
($test (min -10000000000) -10000000000 eql)
($test (min     -8388609)     -8388609 eql)
($test (min     -8388608)     -8388608 eql)
($test (min           -1)           -1 eql)
($test (min            0)            0 eql)
($test (min            1)            1 eql)
($test (min      8388607)      8388607 eql)
($test (min      8388608)      8388608 eql)
($test (min  10000000000)  10000000000 eql)
($test (min      -1234.5)      -1234.5 eql)
($test (min          0.0)          0.0 eql)
($test (min       1234.5)       1234.5 eql)
($test (min *most-negative-float*) *most-negative-float* eval-eql)
($test (min *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 arguments
($test (min -10000000000 -10000000000) -10000000000 eql)
($test (min -10000000000     -8388609) -10000000000 eql)
($test (min -10000000000     -8388608) -10000000000 eql)
($test (min -10000000000           -1) -10000000000 eql)
($test (min -10000000000            0) -10000000000 eql)
($test (min -10000000000            1) -10000000000 eql)
($test (min -10000000000      8388607) -10000000000 eql)
($test (min -10000000000      8388608) -10000000000 eql)
($test (min -10000000000  10000000000) -10000000000 eql)
($test (min -10000000000      -1234.5) -10000000000 eql)
($test (min -10000000000          0.0) -10000000000 eql)
($test (min -10000000000       1234.5) -10000000000 eql)
($test (min -10000000000 *most-negative-float*) *most-negative-float* eval-eql)
($test (min -10000000000 *most-positive-float*) -10000000000 eql)
($test (min     -8388609 -10000000000) -10000000000 eql)
($test (min     -8388609     -8388609)     -8388609 eql)
($test (min     -8388609     -8388608)     -8388609 eql)
($test (min     -8388609           -1)     -8388609 eql)
($test (min     -8388609            0)     -8388609 eql)
($test (min     -8388609            1)     -8388609 eql)
($test (min     -8388609      8388607)     -8388609 eql)
($test (min     -8388609      8388608)     -8388609 eql)
($test (min     -8388609  10000000000)     -8388609 eql)
($test (min     -8388609      -1234.5)     -8388609 eql)
($test (min     -8388609          0.0)     -8388609 eql)
($test (min     -8388609       1234.5)     -8388609 eql)
($test (min     -8388609 *most-negative-float*) *most-negative-float* eval-eql)
($test (min     -8388609 *most-positive-float*) -8388609 eql)
($test (min     -8388608 -10000000000) -10000000000 eql)
($test (min     -8388608     -8388609)     -8388609 eql)
($test (min     -8388608     -8388608)     -8388608 eql)
($test (min     -8388608           -1)     -8388608 eql)
($test (min     -8388608            0)     -8388608 eql)
($test (min     -8388608            1)     -8388608 eql)
($test (min     -8388608      8388607)     -8388608 eql)
($test (min     -8388608      8388608)     -8388608 eql)
($test (min     -8388608  10000000000)     -8388608 eql)
($test (min     -8388608      -1234.5)     -8388608 eql)
($test (min     -8388608          0.0)     -8388608 eql)
($test (min     -8388608       1234.5)     -8388608 eql)
($test (min     -8388608 *most-negative-float*) *most-negative-float* eval-eql)
($test (min     -8388608 *most-positive-float*) -8388608 eql)
($test (min           -1 -10000000000) -10000000000 eql)
($test (min           -1     -8388609)     -8388609 eql)
($test (min           -1     -8388608)     -8388608 eql)
($test (min           -1           -1)           -1 eql)
($test (min           -1            0)           -1 eql)
($test (min           -1            1)           -1 eql)
($test (min           -1      8388607)           -1 eql)
($test (min           -1      8388608)           -1 eql)
($test (min           -1  10000000000)           -1 eql)
($test (min           -1      -1234.5)      -1234.5 eql)
($test (min           -1          0.0)           -1 eql)
($test (min           -1       1234.5)           -1 eql)
($test (min           -1 *most-negative-float*) *most-negative-float* eval-eql)
($test (min           -1 *most-positive-float*) -1 eql)
($test (min            0 -10000000000) -10000000000 eql)
($test (min            0     -8388609)     -8388609 eql)
($test (min            0     -8388608)     -8388608 eql)
($test (min            0           -1)           -1 eql)
($test (min            0            0)            0 eql)
($test (min            0            1)            0 eql)
($test (min            0      8388607)            0 eql)
($test (min            0      8388608)            0 eql)
($test (min            0  10000000000)            0 eql)
($test (min            0      -1234.5)      -1234.5 eql)
($test (min            0          0.0)            0 =)
($test (min            0       1234.5)            0 eql)
($test (min            0 *most-negative-float*) *most-negative-float* eval-eql)
($test (min            0 *most-positive-float*) 0 eql)
($test (min            1 -10000000000) -10000000000 eql)
($test (min            1     -8388609)     -8388609 eql)
($test (min            1     -8388608)     -8388608 eql)
($test (min            1           -1)           -1 eql)
($test (min            1            0)            0 eql)
($test (min            1            1)            1 eql)
($test (min            1      8388607)            1 eql)
($test (min            1      8388608)            1 eql)
($test (min            1  10000000000)            1 eql)
($test (min            1      -1234.5)      -1234.5 eql)
($test (min            1          0.0)          0.0 eql)
($test (min            1       1234.5)            1 eql)
($test (min            1 *most-negative-float*) *most-negative-float* eval-eql)
($test (min            1 *most-positive-float*) 1 eql)
($test (min      8388607 -10000000000) -10000000000 eql)
($test (min      8388607     -8388609)     -8388609 eql)
($test (min      8388607     -8388608)     -8388608 eql)
($test (min      8388607           -1)           -1 eql)
($test (min      8388607            0)            0 eql)
($test (min      8388607            1)            1 eql)
($test (min      8388607      8388607)      8388607 eql)
($test (min      8388607      8388608)      8388607 eql)
($test (min      8388607  10000000000)      8388607 eql)
($test (min      8388607      -1234.5)      -1234.5 eql)
($test (min      8388607          0.0)          0.0 eql)
($test (min      8388607       1234.5)       1234.5 eql)
($test (min      8388607 *most-negative-float*) *most-negative-float* eval-eql)
($test (min      8388607 *most-positive-float*) 8388607 eql)
($test (min      8388608 -10000000000) -10000000000 eql)
($test (min      8388608     -8388609)     -8388609 eql)
($test (min      8388608     -8388608)     -8388608 eql)
($test (min      8388608           -1)           -1 eql)
($test (min      8388608            0)            0 eql)
($test (min      8388608            1)            1 eql)
($test (min      8388608      8388607)      8388607 eql)
($test (min      8388608      8388608)      8388608 eql)
($test (min      8388608  10000000000)      8388608 eql)
($test (min      8388608      -1234.5)      -1234.5 eql)
($test (min      8388608          0.0)          0.0 eql)
($test (min      8388608       1234.5)       1234.5 eql)
($test (min      8388608 *most-negative-float*) *most-negative-float* eval-eql)
($test (min      8388608 *most-positive-float*) 8388608 eql)
($test (min  10000000000 -10000000000) -10000000000 eql)
($test (min  10000000000     -8388609)     -8388609 eql)
($test (min  10000000000     -8388608)     -8388608 eql)
($test (min  10000000000           -1)           -1 eql)
($test (min  10000000000            0)            0 eql)
($test (min  10000000000            1)            1 eql)
($test (min  10000000000      8388607)      8388607 eql)
($test (min  10000000000      8388608)      8388608 eql)
($test (min  10000000000  10000000000)  10000000000 eql)
($test (min  10000000000      -1234.5)      -1234.5 eql)
($test (min  10000000000          0.0)          0.0 eql)
($test (min  10000000000       1234.5)       1234.5 eql)
($test (min  10000000000 *most-negative-float*) *most-negative-float* eval-eql)
($test (min  10000000000 *most-positive-float*) 10000000000 eql)
($test (min      -1234.5 -10000000000) -10000000000 eql)
($test (min      -1234.5     -8388609)     -8388609 eql)
($test (min      -1234.5     -8388608)     -8388608 eql)
($test (min      -1234.5           -1)      -1234.5 eql)
($test (min      -1234.5            0)      -1234.5 eql)
($test (min      -1234.5            1)      -1234.5 eql)
($test (min      -1234.5      8388607)      -1234.5 eql)
($test (min      -1234.5      8388608)      -1234.5 eql)
($test (min      -1234.5  10000000000)      -1234.5 eql)
($test (min      -1234.5      -1234.5)      -1234.5 eql)
($test (min      -1234.5          0.0)      -1234.5 eql)
($test (min      -1234.5       1234.5)      -1234.5 eql)
($test (min      -1234.5 *most-negative-float*) *most-negative-float* eval-eql)
($test (min      -1234.5 *most-positive-float*) -1234.5 eql)
($test (min          0.0 -10000000000) -10000000000 eql)
($test (min          0.0     -8388609)     -8388609 eql)
($test (min          0.0     -8388608)     -8388608 eql)
($test (min          0.0           -1)           -1 eql)
($test (min          0.0            0)            0 =)
($test (min          0.0            1)          0.0 eql)
($test (min          0.0      8388607)          0.0 eql)
($test (min          0.0      8388608)          0.0 eql)
($test (min          0.0  10000000000)          0.0 eql)
($test (min          0.0      -1234.5)      -1234.5 eql)
($test (min          0.0          0.0)          0.0 eql)
($test (min          0.0       1234.5)          0.0 eql)
($test (min          0.0 *most-negative-float*) *most-negative-float* eval-eql)
($test (min          0.0 *most-positive-float*) 0.0 eql)
($test (min       1234.5 -10000000000) -10000000000 eql)
($test (min       1234.5     -8388609)     -8388609 eql)
($test (min       1234.5     -8388608)     -8388608 eql)
($test (min       1234.5           -1)           -1 eql)
($test (min       1234.5            0)            0 eql)
($test (min       1234.5            1)            1 eql)
($test (min       1234.5      8388607)       1234.5 eql)
($test (min       1234.5      8388608)       1234.5 eql)
($test (min       1234.5  10000000000)       1234.5 eql)
($test (min       1234.5      -1234.5)      -1234.5 eql)
($test (min       1234.5          0.0)          0.0 eql)
($test (min       1234.5       1234.5)       1234.5 eql)
($test (min       1234.5 *most-negative-float*) *most-negative-float* eval-eql)
($test (min       1234.5 *most-positive-float*) 1234.5 eql)
($test (min *most-negative-float* -10000000000) *most-negative-float* eval-eql)
($test (min *most-negative-float*     -8388609) *most-negative-float* eval-eql)
($test (min *most-negative-float*     -8388608) *most-negative-float* eval-eql)
($test (min *most-negative-float*           -1) *most-negative-float* eval-eql)
($test (min *most-negative-float*            0) *most-negative-float* eval-eql)
($test (min *most-negative-float*            1) *most-negative-float* eval-eql)
($test (min *most-negative-float*      8388607) *most-negative-float* eval-eql)
($test (min *most-negative-float*      8388608) *most-negative-float* eval-eql)
($test (min *most-negative-float*  10000000000) *most-negative-float* eval-eql)
($test (min *most-negative-float*      -1234.5) *most-negative-float* eval-eql)
($test (min *most-negative-float*          0.0) *most-negative-float* eval-eql)
($test (min *most-negative-float*       1234.5) *most-negative-float* eval-eql)
($test (min *most-negative-float* *most-negative-float*) *most-negative-float* eval-eql)
($test (min *most-negative-float* *most-positive-float*) *most-negative-float* eval-eql)
($test (min *most-positive-float* -10000000000) -10000000000 eql)
($test (min *most-positive-float*     -8388609)     -8388609 eql)
($test (min *most-positive-float*     -8388608)     -8388608 eql)
($test (min *most-positive-float*           -1)           -1 eql)
($test (min *most-positive-float*            0)            0 eql)
($test (min *most-positive-float*            1)            1 eql)
($test (min *most-positive-float*      8388607)      8388607 eql)
($test (min *most-positive-float*      8388608)      8388608 eql)
($test (min *most-positive-float*  10000000000)  10000000000 eql)
($test (min *most-positive-float*      -1234.5)      -1234.5 eql)
($test (min *most-positive-float*          0.0)          0.0 eql)
($test (min *most-positive-float*       1234.5)       1234.5 eql)
($test (min *most-positive-float* *most-negative-float*) *most-negative-float* eval-eql)
($test (min *most-positive-float* *most-positive-float*) *most-positive-float* eval-eql)
;;; 3 arguments
($test (min 0 0 0) 0 eql)
($test (min 0.0 0.0 0.0) 0.0 eql)
($test (min 10 20 30) 10 eql)
($test (min 10.0 20.0 30.0) 10.0 eql)

;;;
;;; function (ABS x) --> <number>
;;;
($ap 2 "abs" P.71)
($test (abs -3) 3 eql)
($test (abs 2.0) 2.0 eql)
($test (abs -0.0) 0.0 eql)
;;;
($argc abs 1 0 0)
($type abs ($integer $float) :target)
;;;
($test (abs -10000000000) 10000000000 eql)
($test (abs     -8388609)     8388609 eql)
($test (abs     -8388608)     8388608 eql)
($test (abs     -8388607)     8388607 eql)
($test (abs           -1)           1 eql)
($test (abs            0)           0 eql)
($test (abs            1)           1 eql)
($test (abs      8388607)     8388607 eql)
($test (abs      8388608)     8388608 eql)
($test (abs  10000000000) 10000000000 eql)
($test (abs      -1234.5)      1234.5 eql)
($test (abs          0.0)         0.0 eql)
($test (abs       1234.5)      1234.5 eql)
($test (abs *most-negative-float*) *most-positive-float* eval-eql)
($test (abs *most-positive-float*) *most-positive-float* eval-eql)

;;;
;;; function (EXP x) --> <number>
;;;
($ap 2 "exp" P.71)
($test (exp 1) 2.718281828459045 ~eql)
($test (exp 2) 7.38905609893065 eql)
($test (exp 1.23) 3.4212295362896734 ~eql)
;;($test (exp 0) 1 =)						; 1 or 1.0 (IDEF)
;;;
($argc exp 1 0 0)
($type exp ($integer $float) :target)
;;;
($test (exp 1.0) 2.718281828459045 ~eql)
($test (exp 2.0) 7.38905609893065 eql)
($test (exp 0.0) 1.0 eql)
($error (exp  10000000000) <floating-point-overflow>)
($error (exp *negative-infinity*) <floating-point-underflow>)
($error (exp *most-positive-float*) <floating-point-overflow>)

;;;
;;; function (LOG x) --> <number>
;;;
($ap 2 "log" P.71)
($test (log 2.718281828459045) 1.0 ~eql)
($test (log 10) 2.302585092994046 eql)
;;($test (log 1) 0 =)						; 0 or 0.0 (IDEF)
;;;
($argc log 1 0 0)
($type log ($integer $float) :target)
;;;
($test (log 10.0) 2.302585092994046 eql)
($test (log 1.0) 0.0 eql)
($test (log  10000000000) 23.02585092994046 ~eql)
($test (log *most-positive-float*) 709.782712893384 eql)
($error (log -10000000000) <error>)
($error (log           -1) <error>)
($error (log            0) <error>)
($error (log      -1234.5) <error>)
($error (log          0.0) <error>)
($error (log *most-negative-float*) <error>)

;;;
;;; function (EXPT x1 x2) --> <number>
;;;
($ap 2 "expt" P.72)
($test (expt 2 3) 8 eql)
($test (expt -100 2) 10000 eql)
($test (expt 4 -2) 0.0625 eql)
($test (expt 0.5 2) 0.25 eql)
($test (expt 100 0) 1 eql)
($test (expt 1234567890 0) 1 eql)
($test (expt 100.0 0) 1.0 eql)
($test (expt -0.25 -1) -4.0 eql)
($test (expt 100 0.5) 10.0 eql)
($test (expt 100 -1.5) 0.001 eql)
($test (expt 100.0 0.0) 1.0 eql)
;($error (expt 0.0 0.0) <error>)
;;;
($argc expt 2 0 0)
($type expt ($integer $float) :target 1)
($type expt ($integer $float) 1 :target)
;;; If x1 is integer and x2 is not minus integer, result is integer.
;;; +Integer  +Integer
;;; +Integer         0
;;;        0  +Integer
;;;        0         0
;;; -Integer  +Integer
;;; -Integer         0
;($test (integerp (expt  10000000000 10000000000)) t)
($test (expt  10000000000           2)  100000000000000000000 eql)
($test (expt  10000000000           1)            10000000000 eql)
;($test (integerp (expt            2 10000000000)) t)
($test (expt            2           2)                      4 eql)
($test (expt            2           1)                      2 eql)
($test (expt            1 10000000000)                      1 eql)
($test (expt            1           2)                      1 eql)
($test (expt            1           1)                      1 eql)
($test (expt  10000000000           0)                      1 eql)
($test (expt            2           0)                      1 eql)
($test (expt            1           0)                      1 eql)
($test (expt            0 10000000000)                      0 eql)
($test (expt            0           2)                      0 eql)
($test (expt            0           1)                      0 eql)
($test (expt            0           0)                      1 eql)
($test (expt           -1 10000000000)                      1 eql)
($test (expt           -1           2)                      1 eql)
($test (expt           -1           1)                     -1 eql)
;($test (integerp (expt           -2 10000000000)) t)
($test (expt           -2           2)                      4 eql)
($test (expt           -2           1)                     -2 eql)
;;($test (integerp (expt -10000000000 10000000000)) t)
($test (expt -10000000000           2)  100000000000000000000 eql)
($test (expt -10000000000           1)           -10000000000 eql)
($test (expt           -1           0)                      1 eql)
($test (expt           -2           0)                      1 eql)
($test (expt -10000000000           0)                      1 eql)
;;; If x1 is zero and x2 is minus, error.
;;;        0  -Integer
;;;        0    -Float
;;;      0.0  -Integer
;;;      0.0    -Float
($error (expt 0   -10000000000) <error>)
($error (expt 0             -1) <error>)
($error (expt 0        -1234.5) <error>)
($error (expt 0 *most-negative-float*) <error>)
($error (expt 0.0 -10000000000) <error>)
($error (expt 0.0           -1) <error>)
($error (expt 0.0      -1234.5) <error>)
($error (expt 0.0 *most-negative-float*) <error>)
;;; If x1 is zero and x2 is 0.0, error
;;;        0       0.0
;;;      0.0       0.0
($error (expt 0 0.0) <error>)
;;; If x1 is minus and x2 is not integer, error.
;;; -Integer    +Float
;;; -Integer       0.0
;;; -Integer    -Float
;;;   -Float    +Float
;;;   -Float       0.0
;;;   -Float    -Float
($error (expt -10000000000  1234.5) <error>)
($error (expt -10000000000 *most-positive-float*) <error>)
($error (expt           -1  1234.5) <error>)
($error (expt           -1 *most-positive-float*) <error>)
($error (expt -10000000000     0.0) <error>)
($error (expt           -1     0.0) <error>)
($error (expt -10000000000 -1234.5) <error>)
($error (expt -10000000000 *most-negative-float*) <error>)
($error (expt           -1 -1234.5) <error>)
($error (expt           -1 *most-negative-float*) <error>)
($error (expt      -1234.5  1234.5) <error>)
($error (expt      -1234.5 *most-positive-float*) <error>)
($error (expt *most-negative-float*  1234.5) <error>)
($error (expt *most-negative-float* *most-positive-float*) <error>)
($error (expt      -1234.5     0.0) <error>)
($error (expt *most-negative-float*     0.0) <error>)
($error (expt      -1234.5 -1234.5) <error>)
($error (expt      -1234.5 *most-negative-float*) <error>)
($error (expt *most-negative-float* -1234.5) <error>)
($error (expt *most-negative-float* *most-negative-float*) <error>)
;;; Other cases
;;; +Integer  -Integer
;;; +Integer    +Float
;;; +Integer       0.0
;;; +Integer    -Float
;;;        0    +Float
;;; -Integer  -Integer
;;;   +Float  +Integer
;;;   +Float         0
;;;   +Float  -Integer
;;;   +Float    +Float
;;;   +Float       0.0
;;;   +Float    -Float
;;;      0.0  +Integer
;;;      0.0         0
;;;      0.0    +Float
;;;   -Float  +Integer
;;;   -Float         0
;;;   -Float  -Integer
($error (expt  10000000000 -10000000000) <floating-point-underflow>)
($test (expt  10000000000           -2) 1.0e-20 ~eql)
($test (expt  10000000000           -1) 1.0e-10 eql)
($error (expt            2 -10000000000) <floating-point-underflow>)
($test (expt            2           -2) 0.25 eql)
($test (expt            2           -1) 0.5 eql)
($test (expt            1 -10000000000) 1.0 eql)
($test (expt            1           -2) 1.0 eql)
($test (expt            1           -1) 1.0 eql)
($test (expt  10000000000          2.0) 1.0e+20 eql)
($test (expt  10000000000          1.0) 1.0e+10 eql)
($error (expt  10000000000 *most-positive-float*) <floating-point-overflow>)
($test (expt            2          2.0) 4.0 eql)
($test (expt            2          1.0) 2.0 eql)
($error (expt            2 *most-positive-float*) <floating-point-overflow>)
($test (expt            1          2.0) 1.0 eql)
($test (expt            1          1.0) 1.0 eql)
($test (expt            1 *most-positive-float*) 1.0 eql)
($test (expt  10000000000          0.0) 1.0 eql)
($test (expt            2          0.0) 1.0 eql)
($test (expt            1          0.0) 1.0 eql)
($test (expt  10000000000         -2.0) 1.0e-20 ~eql)
($test (expt  10000000000         -1.0) 1.0e-10 eql)
($error (expt  10000000000 *most-negative-float*) <floating-point-underflow>)
($test (expt            2         -2.0) 0.25 eql)
($test (expt            2         -1.0) 0.5 eql)
($error (expt            2 *most-negative-float*) <floating-point-underflow>)
($test (expt            1         -2.0) 1.0 eql)
($test (expt            1         -1.0) 1.0 eql)
($test (expt            1 *most-negative-float*) 1.0 eql)
($test (expt            0          2.0) 0.0 eql)
($test (expt            0          1.0) 0.0 eql)
($test (expt            0 *most-positive-float*) 0.0 eql)
($error (expt -10000000000 -10000000000) <floating-point-underflow>)
($test (expt -10000000000           -2)  1.0e-20 ~eql)
($test (expt -10000000000           -1) -1.0e-10 eql)
($error (expt           -2 -10000000000) <floating-point-underflow>)
($test (expt           -2           -2)  0.25 eql)
($test (expt           -2           -1) -0.5 eql)
($test (expt           -1 -10000000000)  1.0 eql)
($test (expt           -1           -2)  1.0 eql)
($test (expt           -1           -1) -1.0 eql)
($error (expt          2.0  10000000000) <floating-point-overflow>)
($test (expt          2.0            2)  4.0 eql)
($test (expt          2.0            1)  2.0 eql)
($test (expt          2.0            0)  1.0 eql)
($test (expt          2.0           -1)  0.5 eql)
($test (expt          2.0           -2)  0.25 eql)
($error (expt          2.0 -10000000000) <floating-point-underflow>)
($test (expt          2.0           2.0) 4.0 eql)
($test (expt          2.0           1.0) 2.0 eql)
($error (expt          2.0 *most-positive-float*) <floating-point-overflow>)
($test (expt          2.0           0.0) 1.0 eql)
($test (expt          2.0          -1.0) 0.5 eql)
($test (expt          2.0          -2.0) 0.25 eql)
($error (expt          2.0 *most-negative-float*) <floating-point-underflow>)
($test (expt          1.0  10000000000)  1.0 eql)
($test (expt          1.0            2)  1.0 eql)
($test (expt          1.0            1)  1.0 eql)
($test (expt          1.0            0)  1.0 eql)
($test (expt          1.0           -1)  1.0 eql)
($test (expt          1.0           -2)  1.0 eql)
($test (expt          1.0 -10000000000)  1.0 eql)
($test (expt          1.0           2.0) 1.0 eql)
($test (expt          1.0           1.0) 1.0 eql)
($test (expt          1.0 *most-positive-float*) 1.0 eql)
($test (expt          1.0           0.0) 1.0 eql)
($test (expt          1.0          -1.0) 1.0 eql)
($test (expt          1.0          -2.0) 1.0 eql)
($test (expt          1.0 *most-negative-float*) 1.0 eql)
($error (expt *most-positive-float*  10000000000) <floating-point-overflow>)
($error (expt *most-positive-float*            2) <floating-point-overflow>)
($test (expt *most-positive-float*            1) *most-positive-float* eval-eql)
($test (expt *most-positive-float*            0)  1.0 eql)
($error (expt *most-positive-float*           -1) <floating-point-underflow>)
($error (expt *most-positive-float*           -2) <floating-point-underflow>)
($error (expt *most-positive-float* -10000000000) <floating-point-underflow>)
($error (expt *most-positive-float*           2.0) <floating-point-overflow>)
($test (expt *most-positive-float*           1.0) *most-positive-float* eval-eql)
($error (expt *most-positive-float* *most-positive-float*) <floating-point-overflow>)
($test (expt *most-positive-float*           0.0) 1.0 eql)
($error (expt *most-positive-float*          -1.0) <floating-point-underflow>)
($error (expt *most-positive-float*          -2.0) <floating-point-underflow>)
($error (expt *most-positive-float* *most-negative-float*) <floating-point-underflow>)
($test (expt 0.0 10000000000) 0.0 eql)
($test (expt 0.0           2) 0.0 eql)
($test (expt 0.0           1) 0.0 eql)
($test (expt 0.0           0) 1.0 eql)
($test (expt 0.0         2.0) 0.0 eql)
($test (expt 0.0         1.0) 0.0 eql)
($test (expt 0.0 *most-positive-float*) 0.0 eql)
($error (expt -2.0  10000000000) <floating-point-overflow>)
($test (expt -2.0            2)  4.0 eql)
($test (expt -2.0            1) -2.0 eql)
($test (expt -1.0  10000000000)  1.0 eql)
($test (expt -1.0            2)  1.0 eql)
($test (expt -1.0            1) -1.0 eql)
($error (expt *most-negative-float* 10000000000) <floating-point-overflow>)
($error (expt *most-negative-float*           2) <floating-point-overflow>)
($test (expt *most-negative-float*          1) *most-negative-float* eval-eql)
($test (expt -2.0            0) 1.0 eql)
($test (expt -1.0            0) 1.0 eql)
($test (expt *most-negative-float* 0) 1.0 eql)
($error (expt -2.0 -10000000000) <floating-point-underflow>)
($test (expt -2.0           -2)  0.25 eql)
($test (expt -2.0           -1) -0.5 eql)
($test (expt -1.0 -10000000000)  1.0 eql)
($test (expt -1.0           -2)  1.0 eql)
($test (expt -1.0           -1) -1.0 eql)
($error (expt *most-negative-float* -10000000000) <floating-point-underflow>)
($error (expt *most-negative-float*           -2) <floating-point-underflow>)
($error (expt *most-negative-float*           -1) <floating-point-underflow>)

;;;
;;; function (SQRT x) --> <number>
;;;
($ap 2 "sqrt" P.72)
($test (sqrt 4) 2 eql)
($test (sqrt 2) 1.4142135623730951 eql)
($error (sqrt -1) <domain-error>)
;;;
($argc sqrt 1 0 0)
($type sqrt ($integer $float) :target)
;;;
($test (sqrt 100000000000000000000)   10000000000 eql)
($test (sqrt           10000000000)        100000 eql)
($test (sqrt                     1)             1 eql)
($test (sqrt                     0)             0 eql)
($test (sqrt 100000000000000000000.0) 10000000000.0 eql)
($test (sqrt           10000000000.0)      100000.0 eql)
($test (sqrt                     1.0)           1.0 eql)
($test (sqrt                     0.0)           0.0 eql)
($test (sqrt *most-positive-float*) 1.34078079299426e154 ~eql)
($error (sqrt -10000000000) <domain-error>)
($error (sqrt     -8388609) <domain-error>)
($error (sqrt     -8388608) <domain-error>)
($error (sqrt      -1234.5) <domain-error>)
($error (sqrt *most-negative-float*) <domain-error>)
($eval (defconstant *pi*/2 (quotient *pi* 2)))
($eval (defconstant -*pi*/2 (- *pi*/2)))

;;;
;;; function (SIN x) --> <number>
;;;
($ap 2 "sin" P.73)
($test (sin 1) 0.8414709848078965 ~eql)
;;($test (sin 0) 0 =)						; 0 or 0.0 (IDEF)
($test (sin 0.001) 9.999998333333417E-4 ~eql)
;;;
($argc sin 1 0 0)
($type sin ($integer $float) :target)
;;;
($test (sin -10000000000)  0.4875060250763 ~eql)
($test (sin          -10)  0.54402111088936977 ~eql)
($test (sin           -1) -0.8414709848078965 ~eql)
($test (sin           10) -0.54402111088936977 ~eql)
($test (sin  10000000000) -0.4875060250763 ~eql)
($test (sin -10000000000.0)    0.4875060250763 ~eql)
($test (sin          -10.0)    0.54402111088936977 ~eql)
($test (sin           -1.0)   -0.8414709848078965 ~eql)
($test (sin           -0.001) -9.999998333333417E-4 ~eql)
($test (sin            0.0)    0.0 eql)
($test (sin            1.0)    0.8414709848078965 ~eql)
($test (sin           10.0)   -0.54402111088936977 ~eql)
($test (sin  10000000000.0)   -0.4875060250763 ~eql)
($test (sin (- (quotient *pi* 2))) -1.0 eql)
($test (sin (quotient *pi* 2)) 1.0 eql)
;($test (sin *most-negative-float*) ? ~eql)
;($test (sin *most-positive-float*) ? ~eql)

;;;
;;; function (COS x) --> <number>
;;;
($ap 2 "cos" P.73)
($test (cos 1) 0.5403023058681398 ~eql)
;;($test (cos 0) 1 =)						; 1 or 1.0 (IDEF)
($test (cos 0.001) 0.9999995000000417 ~eql)
;;;
($argc cos 1 0 0)
($type cos ($integer $float) :target)
;;;
($test (cos -10000000000)  0.8731196226831 ~eql)
($test (cos          -10) -0.8390715290764524 ~eql)
($test (cos           -1)  0.5403023058681398 ~eql)
($test (cos           10) -0.8390715290764524 ~eql)
($test (cos  10000000000)  0.8731196226831 ~eql)
($test (cos -10000000000.0)    0.8731196226831 ~eql)
($test (cos          -10.0)   -0.8390715290764524 ~eql)
($test (cos           -1.0)    0.5403023058681398 ~eql)
($test (cos           -0.001)  0.9999995000000417 ~eql)
($test (cos            0.0)    1.0 eql)
($test (cos            0.001)  0.9999995000000417 ~eql)
($test (cos            1.0)    0.5403023058681398 ~eql)
($test (cos           10.0)   -0.8390715290764524 ~eql)
($test (cos  10000000000.0)    0.8731196226831 ~eql)
($test (cos (- *pi*)) -1.0 eql)
($test (cos *pi*) -1.0 eql)
;($test (cos *most-negative-float*) ? eql)
;($test (cos *most-positive-float*) ? eql)

;;;
;;; function (TAN x) --> <number>
;;;
($ap 2 "tan" P.73)
($test (tan 1) 1.557407724654902 ~eql)
;;($test (tan 0) 0 =)						; 0 or 0.0 (IDEF)
($test (tan 0.001) 0.0010000003333334668 ~eql)
;;;
($argc tan 1 0 0)
($type tan ($integer $float) :target)
;;;
($test (tan -10000000000)  0.5583496377944 ~eql)
($test (tan          -10) -0.6483608274590866 ~eql)
($test (tan           -1) -1.557407724654902 ~eql)
($test (tan           10)  0.6483608274590866 ~eql)
($test (tan  10000000000) -0.5583496377944 ~eql)
($test (tan -10000000000.0)    0.5583496377944 ~eql)
($test (tan          -10.0)   -0.6483608274590866 ~eql)
($test (tan           -1.0)   -1.557407724654902 ~eql)
($test (tan           -0.001) -0.0010000003333334668 ~eql)
($test (tan            0.0)    0.0 eql)
($test (tan            1.0)    1.557407724654902 ~eql)
($test (tan           10.0)    0.6483608274590866 ~eql)
($test (tan  10000000000.0)   -0.5583496377944 ~eql)
($test (tan (- (quotient *pi* 4))) -1.0 ~eql)
($test (tan (quotient *pi* 4)) 1.0 ~eql)
;($test (tan *most-negative-float*) ? eql)
;($test (tan *most-positive-float*) ? eql)

;;;
;;; function (ATAN x) --> <number>
;;;
($ap 2 "atan" P.73)
;;;
($argc atan 1 0 0)
($type atan ($integer $float) :target)
;;;
($test (atan -10000000000) -1.570796326694897 ~eql)
($test (atan          -10) -1.471127674303735 ~eql)
($test (atan           -1) -0.7853981633974483 ~eql)
($test (atan            0)  0 =)
($test (atan            1)  0.7853981633974483 ~eql)
($test (atan           10)  1.471127674303735 ~eql)
($test (atan  10000000000)  1.570796326694897 ~eql)
($test (atan -10000000000.0)   -1.570796326694897 ~eql)
($test (atan          -10.0)   -1.471127674303735 ~eql)
($test (atan           -1.0)   -0.7853981633974483 ~eql)
($test (atan           -0.001) -0.001 ~eql)
($test (atan            0.0)    0.0 eql)
($test (atan            0.001)  0.001 ~eql)
($test (atan            1.0)    0.7853981633974483 ~eql)
($test (atan           10.0)    1.471127674303735 ~eql)
($test (atan  10000000000.0)    1.570796326694897 ~eql)
($test (atan *most-negative-float*) -1.570796326794897 ~eql)
($test (atan *most-positive-float*)  1.570796326794897 ~eql)

;;;
;;; function (ATAN2 x1 x2) --> <number>
;;;
($ap 2 "atan2" P.74)
;;($test (atan2 0 3.0) 0 =)					; 0 or 0.0 (IDEF)
($test (atan2 1 1) 0.7853981633974483 ~eql)
($test (atan2 1.0 -0.3) 1.8622531212727635 ~eql)
($test (atan2 0.0 -0.5) 3.141592653589793 ~eql)
($test (atan2 -1 -1) -2.356194490192345 ~eql)
($test (atan2 -1.0 0.3) -1.2793396 ~eql)
($test (atan2 0.0 0.5) 0.0 eql)
;;;
($argc atan2 2 0 0)
($type atan2 ($integer $float) :target 1)
($type atan2 ($integer $float) 1 :target)
;;; y = 0, x > 0 --> 0
($test (atan2 0 10000000000) 0 =)
($test (atan2 0          10) 0 =)
($test (atan2 0 10000000000.0) 0 =)
($test (atan2 0          10.0) 0 =)
($test (atan2 0 *most-positive-float*) 0 =)
($test (atan2 0.0 10000000000) 0 =)
($test (atan2 0.0          10) 0 =)
($test (atan2 0.0 10000000000.0) 0 =)
($test (atan2 0.0          10.0) 0 =)
($test (atan2 0.0 *most-positive-float*) 0 =)
;;; y > 0, x > 0 --> 0 < result < *pi*/2
($test (atan2 10000000000 10000000000) 0.7853981633974483 ~eql)
($test (atan2 10000000000          10) 1.570796325794897 ~eql)
($test (atan2 10000000000 10000000000.0) 0.7853981633974483 ~eql)
($test (atan2 10000000000          10.0) 1.570796325794897 ~eql)
($test (atan2 10000000000 *most-positive-float*) 5.562684646268005e-299 ~eql)
($test (atan2          10 10000000000) 1.0e-9 ~eql)
($test (atan2          10          10) 0.7853981633974483 ~eql)
($test (atan2          10 10000000000.0) 1.0e-9 ~eql)
($test (atan2          10          10.0) 0.7853981633974483 ~eql)
($test (atan2          10 *most-positive-float*) 5.562684646268004e-308 ~eql)
($test (atan2 10000000000.0 10000000000) 0.7853981633974483 ~eql)
($test (atan2 10000000000.0          10) 1.570796325794897 ~eql)
($test (atan2 10000000000.0 10000000000.0) 0.7853981633974483 ~eql)
($test (atan2 10000000000.0          10.0) 1.570796325794897 ~eql)
($test (atan2 10000000000.0 *most-positive-float*) 5.562684646268005e-299 ~eql)
($test (atan2          10.0 10000000000) 1.0e-9 ~eql)
($test (atan2          10.0          10) 0.7853981633974483 ~eql)
($test (atan2          10.0 10000000000.0) 1.0e-9 ~eql)
($test (atan2          10.0          10.0) 0.7853981633974483 ~eql)
($test (atan2          10.0 *most-positive-float*) 5.562684646268004e-308 ~eql)
($test (atan2 *most-positive-float* 10000000000) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float*          10) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float* 10000000000.0) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float*          10.0) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float* *most-positive-float*) 0.7853981633974483 ~eql)
;;; y > 0, x = 0 --> *pi*/2
($test (atan2 10000000000 0) *pi*/2 eval-eql)
($test (atan2          10 0) *pi*/2 eval-eql)
($test (atan2 10000000000.0 0) *pi*/2 eval-eql)
($test (atan2          10.0 0) *pi*/2 eval-eql)
($test (atan2 *most-positive-float* 0) *pi*/2 eval-eql)
($test (atan2 10000000000 0.0) *pi*/2 eval-eql)
($test (atan2          10 0.0) *pi*/2 eval-eql)
($test (atan2 10000000000.0 0.0) *pi*/2 eval-eql)
($test (atan2          10.0 0.0) *pi*/2 eval-eql)
($test (atan2 *most-positive-float* 0.0) *pi*/2 eval-eql)
;;; y > 0, x < 0 --> *pi*/2 < result < *pi*
($test (atan2 10000000000 -10000000000) 2.356194490192345 ~eql)
($test (atan2 10000000000          -10) 1.570796327794897 ~eql)
($test (atan2 10000000000 -10000000000.0) 2.356194490192345 ~eql)
($test (atan2 10000000000          -10.0) 1.570796327794897 ~eql)
($test (atan2 10000000000 *most-negative-float*) 3.141592653589793 ~eql)
($test (atan2          10 -10000000000) 3.141592652589793 ~eql)
($test (atan2          10          -10) 2.356194490192345 ~eql)
($test (atan2          10 -10000000000.0) 3.141592652589793 ~eql)
($test (atan2          10          -10.0) 2.356194490192345 ~eql)
($test (atan2          10 *most-negative-float*) 3.141592653589793 ~eql)
($test (atan2 10000000000.0 -10000000000) 2.356194490192345 ~eql)
($test (atan2 10000000000.0          -10) 1.570796327794897 ~eql)
($test (atan2 10000000000.0 -10000000000.0) 2.356194490192345 ~eql)
($test (atan2 10000000000.0          -10.0) 1.570796327794897 ~eql)
($test (atan2 10000000000.0 *most-negative-float*) 3.141592653589793 ~eql)
($test (atan2          10.0 -10000000000) 3.141592652589793 ~eql)
($test (atan2          10.0          -10) 2.356194490192345 ~eql)
($test (atan2          10.0 -10000000000.0) 3.141592652589793 ~eql)
($test (atan2          10.0          -10.0) 2.356194490192345 ~eql)
($test (atan2          10.0 *most-negative-float*) 3.141592653589793 ~eql)
($test (atan2 *most-positive-float* -10000000000) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float*          -10) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float* -10000000000.0) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float*          -10.0) 1.570796326794897 ~eql)
($test (atan2 *most-positive-float* *most-negative-float*) 2.356194490192345 ~eql)
;;; y = 0, x < 0 --> *pi*
($test (atan2 0 -10000000000) *pi* eval-eql)
($test (atan2 0          -10) *pi* eval-eql)
($test (atan2 0 -10000000000.0) *pi* eval-eql)
($test (atan2 0          -10.0) *pi* eval-eql)
($test (atan2 0 *most-negative-float*) *pi* eval-eql)
($test (atan2 0.0 -10000000000) *pi* eval-eql)
($test (atan2 0.0          -10) *pi* eval-eql)
($test (atan2 0.0 -10000000000.0) *pi* eval-eql)
($test (atan2 0.0          -10.0) *pi* eval-eql)
($test (atan2 0.0 *most-negative-float*) *pi* eval-eql)
;;; y < 0, x < 0 --> -*pi* < result < -*pi*/2
($test (atan2 -10000000000 -10000000000) -2.356194490192345 ~eql)
($test (atan2 -10000000000          -10) -1.570796327794897 ~eql)
($test (atan2 -10000000000 -10000000000.0) -2.356194490192345 ~eql)
($test (atan2 -10000000000          -10.0) -1.570796327794897 ~eql)
($test (atan2 -10000000000 *most-negative-float*) -3.141592653589793 ~eql)
($test (atan2          -10 -10000000000) -3.141592652589793 ~eql)
($test (atan2          -10          -10) -2.356194490192345 ~eql)
($test (atan2          -10 -10000000000.0) -3.141592652589793 ~eql)
($test (atan2          -10          -10.0) -2.356194490192345 ~eql)
($test (atan2          -10 *most-negative-float*) -3.141592653589793 ~eql)
($test (atan2 -10000000000.0 -10000000000) -2.356194490192345 ~eql)
($test (atan2 -10000000000.0          -10) -1.570796327794897 ~eql)
($test (atan2 -10000000000.0 -10000000000.0) -2.356194490192345 ~eql)
($test (atan2 -10000000000.0          -10.0) -1.570796327794897 ~eql)
($test (atan2 -10000000000.0 *most-negative-float*) -3.141592653589793 ~eql)
($test (atan2          -10.0 -10000000000) -3.141592652589793 ~eql)
($test (atan2          -10.0          -10) -2.356194490192345 ~eql)
($test (atan2          -10.0 -10000000000.0) -3.141592652589793 ~eql)
($test (atan2          -10.0          -10.0) -2.356194490192345 ~eql)
($test (atan2          -10.0 *most-negative-float*) -3.141592653589793 ~eql)
($test (atan2 *most-negative-float* -10000000000) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float*          -10) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float* -10000000000.0) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float*          -10.0) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float* *most-negative-float*) -2.356194490192345 ~eql)
;;; y < 0, x = 0 --> -*pi*/2
($test (atan2 -10000000000 0) -*pi*/2 eval-eql)
($test (atan2          -10 0) -*pi*/2 eval-eql)
($test (atan2 -10000000000.0 0) -*pi*/2 eval-eql)
($test (atan2          -10.0 0) -*pi*/2 eval-eql)
($test (atan2 *most-negative-float* 0) -*pi*/2 eval-eql)
($test (atan2 -10000000000 0.0) -*pi*/2 eval-eql)
($test (atan2          -10 0.0) -*pi*/2 eval-eql)
($test (atan2 -10000000000.0 0.0) -*pi*/2 eval-eql)
($test (atan2          -10.0 0.0) -*pi*/2 eval-eql)
($test (atan2 *most-negative-float* 0.0) -*pi*/2 eval-eql)
;;; y < 0, x > 0 --> -*pi*/2 < result < 0
($test (atan2 -10000000000 10000000000) -0.7853981633974483 ~eql)
($test (atan2 -10000000000          10) -1.570796325794897 ~eql)
($test (atan2 -10000000000 10000000000.0) -0.7853981633974483 ~eql)
($test (atan2 -10000000000          10.0) -1.570796325794897 ~eql)
($test (atan2 -10000000000 *most-positive-float*) -5.562684646268005e-299 ~eql)
($test (atan2          -10 10000000000) -1.0e-9 ~eql)
($test (atan2          -10          10) -0.7853981633974483 ~eql)
($test (atan2          -10 10000000000.0) -1.0e-9 ~eql)
($test (atan2          -10          10.0) -0.7853981633974483 ~eql)
($test (atan2          -10 *most-positive-float*) -5.562684646268004e-308 ~eql)
($test (atan2 -10000000000.0 10000000000) -0.7853981633974483 ~eql)
($test (atan2 -10000000000.0          10) -1.570796325794897 ~eql)
($test (atan2 -10000000000.0 10000000000.0) -0.7853981633974483 ~eql)
($test (atan2 -10000000000.0          10.0) -1.570796325794897 ~eql)
($test (atan2 -10000000000.0 *most-positive-float*) -5.562684646268005e-299 ~eql)
($test (atan2          -10.0 10000000000) -1.0e-9 ~eql)
($test (atan2          -10.0          10) -0.7853981633974483 ~eql)
($test (atan2          -10.0 10000000000.0) -1.0e-9 ~eql)
($test (atan2          -10.0          10.0) -0.7853981633974483 ~eql)
($test (atan2          -10.0 *most-positive-float*) -5.562684646268004e-308 ~eql)
($test (atan2 *most-negative-float* 10000000000) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float*          10) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float* 10000000000.0) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float*          10.0) -1.570796326794897 ~eql)
($test (atan2 *most-negative-float* *most-positive-float*) -0.7853981633974483 ~eql)
;;; y = 0, x = 0 --> undefined consequences

;;;
;;; function (SINH x) --> <number>
;;;
($ap 2 "sinh" P.75)
($test (sinh 1) 1.1752011936438014 ~eql)
;;($test (sinh 0) 0 =)					; 0 or 0.0 (IDEF)
($test (sinh 0.001) 0.001000000166666675 ~eql)
;;;
($argc sinh 1 0 0)
($type sinh ($integer $float) :target)
;;;
;($error (sinh -10000000000) <floating-point-underflow>)
($test (sinh -10) -11013.23287470339 ~eql)
($test (sinh  -1)     -1.1752011936438014 ~eql)
($test (sinh  10)  11013.23287470339 ~eql)
($error (sinh  10000000000) <floating-point-overflow>)
($error (sinh -10000000000.0) <floating-point-overflow>)
($test (sinh -10.0) -11013.23287470339 ~eql)
($test (sinh  -1.0)     -1.1752011936438014 ~eql)
($test (sinh   0.0)      0.0 eql)
($test (sinh   1.0)      1.1752011936438014 ~eql)
($test (sinh  10.0)  11013.23287470339 ~eql)
($error (sinh  10000000000.0) <floating-point-overflow>)
($error (sinh *most-negative-float*) <floating-point-overflow>)
($error (sinh *most-positive-float*) <floating-point-overflow>)

;;;
;;; function (COSH x) --> <number>
;;;
($ap 2 "cosh" P.75)
($test (cosh 1) 1.5430806348152437 ~eql)
;;($test (cosh 0) 1 =)					; 1 or 1.0 (IDEF)
($test (cosh 0.001) 1.0000005000000416 ~eql)
;;;
($argc cosh 1 0 0)
($type cosh ($integer $float) :target)
;;;
($error (cosh -10000000000) <floating-point-overflow>)
($test (cosh -10) 11013.23292010332 ~eql)
($test (cosh  -1)     1.5430806348152437 ~eql)
($test (cosh  10) 11013.23292010332 ~eql)
($error (cosh  10000000000) <floating-point-overflow>)
($error (cosh -10000000000.0) <floating-point-overflow>)
($test (cosh -10.0) 11013.23292010332 ~eql)
($test (cosh  -1.0)     1.5430806348152437 ~eql)
($test (cosh  -0.001)   1.0000005000000416 ~eql)
($test (cosh   0.0)     1.0 eql)
($test (cosh   1.0)     1.5430806348152437 ~eql)
($test (cosh  10.0) 11013.23292010332 ~eql)
($error (cosh  10000000000.0) <floating-point-overflow>)
($error (cosh *most-negative-float*) <floating-point-overflow>)
($error (cosh *most-positive-float*) <floating-point-overflow>)

;;;
;;; function (TANH x) --> <number>
;;;
($ap 2 "tanh" P.75)
($test (tanh 1) 0.7615941559557649 ~eql)
;;($test (tanh 0) 0 =)					; 0 or 0.0 (IDEF)
($test (tanh 0.001) 9.999996666668002E-4 ~eql)
;;;
($argc tanh 1 0 0)
($type tanh ($integer $float) :target)
;;;
($test (tanh          -10) -0.9999999958776926 ~eql)
($test (tanh           -1) -0.7615941559557649 ~eql)
($test (tanh           10)  0.9999999958776926 ~eql)
($test (tanh           -1.0) -0.7615941559557649 ~eql)
($test (tanh            0.0)  0.0 eql)
($test (tanh            1.0)  0.7615941559557649 ~eql)
($test (tanh           10.0)  0.9999999958776926 ~eql)

;;;
;;; function (ATANH x) --> <number>
;;;
($ap 2 "atanh" P.75)
($test (atanh 0.5) 0.5493061443340549 ~eql)
;;($test (atanh 0) 0 =)					; 0 or 0.0 (IDEF)
($test (atanh 0.001) 0.0010000003333335335 ~eql)
;;;
($argc atanh 1 0 0)
($type atanh ($integer $float) :target)
;;;
($error (atanh -10000000000) <error>)
($error (atanh           -1) <error>)
($error (atanh            1) <error>)
($error (atanh  10000000000) <error>)
($error (atanh -10000000000.0) <error>)
($error (atanh           -1.0) <error>)
($test (atanh -0.9)   -1.472219489583221 ~eql)
($test (atanh -0.5)   -0.5493061443340549 ~eql)
($test (atanh -0.001) -0.0010000003333335335 ~eql)
($test (atanh  0.0)    0.0 eql)
($test (atanh  0.9)    1.472219489583221 ~eql)
($error (atanh *most-negative-float*) <error>)
($error (atanh *most-positive-float*) <error>)
($eval (defconstant *most-negative-float-integer*
         (* -17976931348623157 (expt 10 (- 308 16)))))
($eval (defconstant *most-positive-float-integer*
         (* 17976931348623157 (expt 10 (- 308 16)))))

;;;
;;; function (FLOATP obj) --> boolean
;;;
($ap 2 "floatp" P.76)
($test (floatp "2.4") nil)
($test (floatp 2) nil)
($test (floatp 2.0) t)
;;;
($argc floatp 1 0 0)
($predicate floatp $float)
;;;
($test (floatp *pi*) t)
($test (floatp *most-negative-float*) t)
($test (floatp *most-positive-float*) t)

;;;
;;; function (FLOAT x) --> <float>
;;;
($ap 2 "float" P.77)
($test (float 0) 0.0 eql)
($test (float 2) 2.0 eql)
($test (float -2.0) -2.0 eql)
($test (float 123456789123456789123456789) 1.2345678912345679E26 eql)
;;;
($argc float 1 0 0)
($type float ($integer $float) :target)
;;;
($test (float -10000000000) -10000000000.0 eql)
($test (float     -8388609)     -8388609.0 eql)
($test (float     -8388608)     -8388608.0 eql)
($test (float           -1)           -1.0 eql)
($test (float            1)            1.0 eql)
($test (float      8388607)      8388607.0 eql)
($test (float      8388608)      8388608.0 eql)
($test (float  10000000000)  10000000000.0 eql)
($test (float -1.0e10)   -1.0e10 eql)
($test (float -123.4)  -123.4 eql)
($test (float   -1.0)    -1.0 eql)
($test (float    0.0)     0.0 eql)
($test (float    1.0)     1.0 eql)
($test (float  123.4)   123.4 eql)
($test (float  1.0e10)    1.0e10 eql)
($test (float *pi*) *pi* eval-eql)
($test (float *most-negative-float*) *most-negative-float* eval-eql)
($test (float *most-positive-float*) *most-positive-float* eval-eql)

;;;
;;; function (FLOOR x) --> <integer>
;;;
($ap 2 "floor" P.77)
($test (floor 3.0) 3 eql)
($test (floor 3.4) 3 eql)
($test (floor 3.9) 3 eql)
($test (floor -3.9) -4 eql)
($test (floor -3.4) -4 eql)
($test (floor -3.0) -3 eql)
;;;
($argc floor 1 0 0)
($type floor ($integer $float) :target)
;;;
($test (floor -10000000000) -10000000000 eql)
($test (floor     -8388609)     -8388609 eql)
($test (floor     -8388608)     -8388608 eql)
($test (floor           -1)           -1 eql)
($test (floor            0)            0 eql)
($test (floor            1)            1 eql)
($test (floor      8388607)      8388607 eql)
($test (floor      8388608)      8388608 eql)
($test (floor  10000000000)  10000000000 eql)
($test (floor -10000000000.5) -10000000001 eql)
($test (floor -10000000000.0) -10000000000 eql)
($test (floor  -9999999999.5) -10000000000 eql)
($test (floor     -8388609.5)     -8388610 eql)
($test (floor     -8388609.0)     -8388609 eql)
($test (floor     -8388608.5)     -8388609 eql)
($test (floor     -8388608.0)     -8388608 eql)
($test (floor     -8388607.5)     -8388608 eql)
($test (floor           -1.5)           -2 eql)
($test (floor           -1.0)           -1 eql)
($test (floor           -0.5)           -1 eql)
($test (floor            0.0)            0 eql)
($test (floor            0.5)            0 eql)
($test (floor            1.0)            1 eql)
($test (floor            1.5)            1 eql)
($test (floor      8388606.5)      8388606 eql)
($test (floor      8388607.0)      8388607 eql)
($test (floor      8388607.5)      8388607 eql)
($test (floor      8388608.0)      8388608 eql)
($test (floor      8388608.5)      8388608 eql)
($test (floor   9999999999.5)   9999999999 eql)
($test (floor  10000000000.0)  10000000000 eql)
($test (floor  10000000000.5)  10000000000 eql)
($test (floor *pi*) 3 eql)

;;;
;;; function (CEILING x) --> <integer>
;;;
($ap 2 "ceiling" P.77)
($test (ceiling 3.0) 3 eql)
($test (ceiling 3.4) 4 eql)
($test (ceiling 3.9) 4 eql)
($test (ceiling -3.9) -3 eql)
($test (ceiling -3.4) -3 eql)
($test (ceiling -3.0) -3 eql)
;;;
($argc ceiling 1 0 0)
($type ceiling ($integer $float) :target)
;;;
($test (ceiling -10000000000) -10000000000 eql)
($test (ceiling     -8388609)     -8388609 eql)
($test (ceiling     -8388608)     -8388608 eql)
($test (ceiling           -1)           -1 eql)
($test (ceiling            0)            0 eql)
($test (ceiling            1)            1 eql)
($test (ceiling      8388607)      8388607 eql)
($test (ceiling      8388608)      8388608 eql)
($test (ceiling  10000000000)  10000000000 eql)
($test (ceiling -10000000000.5) -10000000000 eql)
($test (ceiling -10000000000.0) -10000000000 eql)
($test (ceiling  -9999999999.5)  -9999999999 eql)
($test (ceiling     -8388609.5)     -8388609 eql)
($test (ceiling     -8388609.0)     -8388609 eql)
($test (ceiling     -8388608.5)     -8388608 eql)
($test (ceiling     -8388608.0)     -8388608 eql)
($test (ceiling     -8388607.5)     -8388607 eql)
($test (ceiling           -1.5)           -1 eql)
($test (ceiling           -1.0)           -1 eql)
($test (ceiling           -0.5)            0 eql)
($test (ceiling            0.0)            0 eql)
($test (ceiling            0.5)            1 eql)
($test (ceiling            1.0)            1 eql)
($test (ceiling            1.5)            2 eql)
($test (ceiling      8388606.5)      8388607 eql)
($test (ceiling      8388607.0)      8388607 eql)
($test (ceiling      8388607.5)      8388608 eql)
($test (ceiling      8388608.0)      8388608 eql)
($test (ceiling      8388608.5)      8388609 eql)
($test (ceiling   9999999999.5)  10000000000 eql)
($test (ceiling  10000000000.0)  10000000000 eql)
($test (ceiling  10000000000.5)  10000000001 eql)
($test (ceiling *pi*) 4 eql)

;;;
;;; function (TRUNCATE x) --> <integer>
;;;
($ap 2 "truncate" P.78)
($test (truncate 3.0) 3 eql)
($test (truncate 3.4) 3 eql)
($test (truncate 3.9) 3 eql)
($test (truncate -3.9) -3 eql)
($test (truncate -3.4) -3 eql)
($test (truncate -3.0) -3 eql)
;;;
($argc truncate 1 0 0)
($type truncate ($integer $float) :target)
;;;
($test (truncate -10000000000) -10000000000 eql)
($test (truncate     -8388609)     -8388609 eql)
($test (truncate     -8388608)     -8388608 eql)
($test (truncate           -1)           -1 eql)
($test (truncate            0)            0 eql)
($test (truncate            1)            1 eql)
($test (truncate      8388607)      8388607 eql)
($test (truncate      8388608)      8388608 eql)
($test (truncate  10000000000)  10000000000 eql)
($test (truncate -10000000000.5) -10000000000 eql)
($test (truncate -10000000000.0) -10000000000 eql)
($test (truncate  -9999999999.5)  -9999999999 eql)
($test (truncate     -8388609.5)     -8388609 eql)
($test (truncate     -8388609.0)     -8388609 eql)
($test (truncate     -8388608.5)     -8388608 eql)
($test (truncate     -8388608.0)     -8388608 eql)
($test (truncate     -8388607.5)     -8388607 eql)
($test (truncate           -1.5)           -1 eql)
($test (truncate           -1.0)           -1 eql)
($test (truncate           -0.5)            0 eql)
($test (truncate            0.0)            0 eql)
($test (truncate            0.5)            0 eql)
($test (truncate            1.0)            1 eql)
($test (truncate            1.5)            1 eql)
($test (truncate      8388606.5)      8388606 eql)
($test (truncate      8388607.0)      8388607 eql)
($test (truncate      8388607.5)      8388607 eql)
($test (truncate      8388608.0)      8388608 eql)
($test (truncate      8388608.5)      8388608 eql)
($test (truncate   9999999999.5)   9999999999 eql)
($test (truncate  10000000000.0)  10000000000 eql)
($test (truncate  10000000000.5)  10000000000 eql)
($test (truncate *pi*) 3 eql)

;;;
;;; function (ROUND x) --> <integer>
;;;
($ap 2 "round" P.78)
($test (round 3.0) 3 eql)
($test (round 3.4) 3 eql)
($test (round -3.4) -3 eql)
($test (round 3.6) 4 eql)
($test (round -3.6) -4 eql)
($test (round 3.5) 4 eql)
($test (round -3.5) -4 eql)
($test (round 2.5) 2 eql)
($test (round -0.5) 0 eql)
;;;
($argc round 1 0 0)
($type round ($integer $float) :target)
;;;
($test (round -10000000000) -10000000000 eql)
($test (round     -8388609)     -8388609 eql)
($test (round     -8388608)     -8388608 eql)
($test (round           -1)           -1 eql)
($test (round            0)            0 eql)
($test (round            1)            1 eql)
($test (round      8388607)      8388607 eql)
($test (round      8388608)      8388608 eql)
($test (round  10000000000)  10000000000 eql)
($test (round -10000000001.6) -10000000002 eql)
($test (round -10000000001.5) -10000000002 eql)
($test (round -10000000001.4) -10000000001 eql)
($test (round -10000000000.6) -10000000001 eql)
($test (round -10000000000.5) -10000000000 eql)
($test (round -10000000000.4) -10000000000 eql)
($test (round -10000000000.0) -10000000000 eql)
($test (round  -9999999999.6) -10000000000 eql)
($test (round  -9999999999.5) -10000000000 eql)
($test (round  -9999999999.4)  -9999999999 eql)
($test (round     -8388609.6)     -8388610 eql)
($test (round     -8388609.5)     -8388610 eql)
($test (round     -8388609.4)     -8388609 eql)
($test (round     -8388609.0)     -8388609 eql)
($test (round     -8388608.6)     -8388609 eql)
($test (round     -8388608.5)     -8388608 eql)
($test (round     -8388608.4)     -8388608 eql)
($test (round     -8388608.0)     -8388608 eql)
($test (round     -8388607.6)     -8388608 eql)
($test (round     -8388607.5)     -8388608 eql)
($test (round     -8388607.4)     -8388607 eql)
($test (round           -1.6)           -2 eql)
($test (round           -1.5)           -2 eql)
($test (round           -1.4)           -1 eql)
($test (round           -1.0)           -1 eql)
($test (round           -0.6)           -1 eql)
($test (round           -0.5)            0 eql)
($test (round           -0.4)            0 eql)
($test (round            0.0)            0 eql)
($test (round            0.4)            0 eql)
($test (round            0.5)            0 eql)
($test (round            0.6)            1 eql)
($test (round            1.0)            1 eql)
($test (round            1.4)            1 eql)
($test (round            1.5)            2 eql)
($test (round            1.6)            2 eql)
($test (round      8388606.4)      8388606 eql)
($test (round      8388606.5)      8388606 eql)
($test (round      8388606.6)      8388607 eql)
($test (round      8388607.0)      8388607 eql)
($test (round      8388607.4)      8388607 eql)
($test (round      8388607.5)      8388608 eql)
($test (round      8388607.6)      8388608 eql)
($test (round      8388608.0)      8388608 eql)
($test (round      8388608.4)      8388608 eql)
($test (round      8388608.5)      8388608 eql)
($test (round      8388608.6)      8388609 eql)
($test (round   9999999999.4)   9999999999 eql)
($test (round   9999999999.5)  10000000000 eql)
($test (round   9999999999.6)  10000000000 eql)
($test (round  10000000000.0)  10000000000 eql)
($test (round  10000000000.4)  10000000000 eql)
($test (round  10000000000.5)  10000000000 eql)
($test (round  10000000000.6)  10000000001 eql)
($test (round  10000000001.4)  10000000001 eql)
($test (round  10000000001.5)  10000000002 eql)
($test (round  10000000001.6)  10000000002 eql)
($test (round *pi*) 3 eql)

;;;
;;; function (INTEGERP obj) --> boolean
;;;
($ap 2 "integerp" P.79)
($test (integerp 3) t)
($test (integerp 3.4) nil)
($test (integerp "4") nil)
($test (integerp '(a b c)) nil)
;;;
($argc integerp 1 0 0)
($predicate integerp $integer)

;;;
;;; function (DIV z1 z2) --> <integer>
;;;
($ap 2 "div" P.79)
($test (div 12 3) 4 eql)
($test (div 14 3) 4 eql)
($test (div -12 3) -4 eql)
($test (div -14 3) -5 eql)
($test (div 12 -3) -4 eql)
($test (div 14 -3) -5 eql)
($test (div -12 -3) 4 eql)
($test (div -14 -3) 4 eql)
;;;
($argc div 2 0 0)
($type div ($integer) :target 0)
($type div ($integer) 0 :target)
;;;
($test (div -10000000000000001 -10000000000000000)  1 eql)
($test (div -10000000000000000 -10000000000000000)  1 eql)
($test (div  -9999999999999999 -10000000000000000)  0 eql)
($test (div           -8388609 -10000000000000000)  0 eql)
($test (div           -8388608 -10000000000000000)  0 eql)
($test (div                 -1 -10000000000000000)  0 eql)
($test (div                  0 -10000000000000000)  0 eql)
($test (div                  1 -10000000000000000) -1 eql)
($test (div            8388607 -10000000000000000) -1 eql)
($test (div            8388608 -10000000000000000) -1 eql)
($test (div   9999999999999999 -10000000000000000) -1 eql)
($test (div  10000000000000000 -10000000000000000) -1 eql)
($test (div  10000000000000001 -10000000000000000) -2 eql)
;;;
($test (div -83886090000000001 -8388609)  10000000000 eql)
($test (div -83886090000000000 -8388609)  10000000000 eql)
($test (div -83886089999999999 -8388609)   9999999999 eql)
($test (div           -8388610 -8388609)            1 eql)
($test (div           -8388609 -8388609)            1 eql)
($test (div           -8388608 -8388609)            0 eql)
($test (div                 -1 -8388609)            0 eql)
($test (div                  0 -8388609)            0 eql)
($test (div                  1 -8388609)           -1 eql)
($test (div            8388607 -8388609)           -1 eql)
($test (div            8388608 -8388609)           -1 eql)
($test (div            8388609 -8388609)           -1 eql)
($test (div            8388610 -8388609)           -2 eql)
($test (div  83886089999999999 -8388609) -10000000000 eql)
($test (div  83886090000000000 -8388609) -10000000000 eql)
($test (div  83886090000000001 -8388609) -10000000001 eql)
;;;
($test (div -83886080000000001 -8388608)  10000000000 eql)
($test (div -83886080000000000 -8388608)  10000000000 eql)
($test (div -83886079999999999 -8388608)   9999999999 eql)
($test (div           -8388609 -8388608)            1 eql)
($test (div           -8388608 -8388608)            1 eql)
($test (div           -8388607 -8388608)            0 eql)
($test (div                 -1 -8388608)            0 eql)
($test (div                  0 -8388608)            0 eql)
($test (div                  1 -8388608)           -1 eql)
($test (div            8388607 -8388608)           -1 eql)
($test (div            8388608 -8388608)           -1 eql)
($test (div            8388609 -8388608)           -2 eql)
($test (div  83886079999999999 -8388608) -10000000000 eql)
($test (div  83886080000000000 -8388608) -10000000000 eql)
($test (div  83886080000000001 -8388608) -10000000001 eql)
;;;
($test (div -10000000000000000 -1)  10000000000000000 eql)
($test (div           -8388609 -1)            8388609 eql)
($test (div           -8388608 -1)            8388608 eql)
($test (div           -8388607 -1)            8388607 eql)
($test (div                 -1 -1)                  1 eql)
($test (div                  0 -1)                  0 eql)
($test (div                  1 -1)                 -1 eql)
($test (div            8388607 -1)           -8388607 eql)
($test (div            8388608 -1)           -8388608 eql)
($test (div            8388609 -1)           -8388609 eql)
($test (div  10000000000000000 -1) -10000000000000000 eql)
;;;
($error (div -10000000000000000 0) <division-by-zero>)
($error (div           -8388608 0) <division-by-zero>)
($error (div           -8388607 0) <division-by-zero>)
($error (div                 -1 0) <division-by-zero>)
($error (div                  0 0) <division-by-zero>)
($error (div                  1 0) <division-by-zero>)
($error (div            8388607 0) <division-by-zero>)
($error (div            8388608 0) <division-by-zero>)
($error (div  10000000000000000 0) <division-by-zero>)
;;;
($test (div -10000000000000000 1) -10000000000000000 eql)
($test (div           -8388609 1)           -8388609 eql)
($test (div           -8388608 1)           -8388608 eql)
($test (div           -8388607 1)           -8388607 eql)
($test (div                 -1 1)                 -1 eql)
($test (div                  0 1)                  0 eql)
($test (div                  1 1)                  1 eql)
($test (div            8388607 1)            8388607 eql)
($test (div            8388608 1)            8388608 eql)
($test (div            8388609 1)            8388609 eql)
($test (div  10000000000000000 1)  10000000000000000 eql)
;;;
($test (div -83886070000000001 8388607) -10000000001 eql)
($test (div -83886070000000000 8388607) -10000000000 eql)
($test (div -83886069999999999 8388607) -10000000000 eql)
($test (div           -8388609 8388607)           -2 eql)
($test (div           -8388608 8388607)           -2 eql)
($test (div           -8388607 8388607)           -1 eql)
($test (div           -8388606 8388607)           -1 eql)
($test (div                 -1 8388607)           -1 eql)
($test (div                  0 8388607)            0 eql)
($test (div                  1 8388607)            0 eql)
($test (div            8388606 8388607)            0 eql)
($test (div            8388607 8388607)            1 eql)
($test (div            8388608 8388607)            1 eql)
($test (div  83886069999999999 8388607)   9999999999 eql)
($test (div  83886070000000000 8388607)  10000000000 eql)
($test (div  83886070000000001 8388607)  10000000000 eql)
;;;
($test (div -83886080000000001 8388608) -10000000001 eql)
($test (div -83886080000000000 8388608) -10000000000 eql)
($test (div -83886079999999999 8388608) -10000000000 eql)
($test (div           -8388609 8388608)           -2 eql)
($test (div           -8388608 8388608)           -1 eql)
($test (div           -8388607 8388608)           -1 eql)
($test (div                 -1 8388608)           -1 eql)
($test (div                  0 8388608)            0 eql)
($test (div                  1 8388608)            0 eql)
($test (div            8388607 8388608)            0 eql)
($test (div            8388608 8388608)            1 eql)
($test (div            8388609 8388608)            1 eql)
($test (div  83886079999999999 8388608)   9999999999 eql)
($test (div  83886080000000000 8388608)  10000000000 eql)
($test (div  83886080000000001 8388608)  10000000000 eql)
;;;
($test (div -10000000000000001 10000000000000000) -2 eql)
($test (div -10000000000000000 10000000000000000) -1 eql)
($test (div  -9999999999999999 10000000000000000) -1 eql)
($test (div           -8388609 10000000000000000) -1 eql)
($test (div           -8388608 10000000000000000) -1 eql)
($test (div                 -1 10000000000000000) -1 eql)
($test (div                  0 10000000000000000)  0 eql)
($test (div                  1 10000000000000000)  0 eql)
($test (div            8388607 10000000000000000)  0 eql)
($test (div            8388608 10000000000000000)  0 eql)
($test (div   9999999999999999 10000000000000000)  0 eql)
($test (div  10000000000000000 10000000000000000)  1 eql)
($test (div  10000000000000001 10000000000000000)  1 eql)

;;;
;;; function (MOD z1 z2) --> <integer>
;;;
($ap 2 "mod" P.79)
($test (mod 12 3) 0 eql)
($test (mod 7 247) 7 eql)
($test (mod 247 7) 2 eql)
($test (mod 14 3) 2 eql)
($test (mod -12 3) 0 eql)
($test (mod -14 3) 1 eql)
($test (mod 12 -3) 0 eql)
($test (mod 14 -3) -1 eql)
($test (mod -12 -3) 0 eql)
($test (mod -14 -3) -2 eql)
;;;
($argc mod 2 0 0)
($type mod ($integer) :target 1)
($type mod ($integer) 1 :target)
;;;
($test (mod -10000000000000001 -10000000000000000)                -1 eql)
($test (mod -10000000000000000 -10000000000000000)                 0 eql)
($test (mod  -9999999999999999 -10000000000000000) -9999999999999999 eql)
($test (mod           -8388609 -10000000000000000)          -8388609 eql)
($test (mod           -8388608 -10000000000000000)          -8388608 eql)
($test (mod                 -1 -10000000000000000)                -1 eql)
($test (mod                  0 -10000000000000000)                 0 eql)
($test (mod                  1 -10000000000000000) -9999999999999999 eql)
($test (mod            8388607 -10000000000000000) -9999999991611393 eql)
($test (mod            8388608 -10000000000000000) -9999999991611392 eql)
($test (mod   9999999999999999 -10000000000000000)                -1 eql)
($test (mod  10000000000000000 -10000000000000000)                 0 eql)
($test (mod  10000000000000001 -10000000000000000) -9999999999999999 eql)
;;;
($test (mod -83886090000000001 -8388609)       -1 eql)
($test (mod -83886090000000000 -8388609)        0 eql)
($test (mod -83886089999999999 -8388609) -8388608 eql)
($test (mod           -8388610 -8388609)       -1 eql)
($test (mod           -8388609 -8388609)        0 eql)
($test (mod           -8388608 -8388609) -8388608 eql)
($test (mod                 -1 -8388609)       -1 eql)
($test (mod                  0 -8388609)        0 eql)
($test (mod                  1 -8388609) -8388608 eql)
($test (mod            8388607 -8388609)       -2 eql)
($test (mod            8388608 -8388609)       -1 eql)
($test (mod            8388609 -8388609)        0 eql)
($test (mod            8388610 -8388609) -8388608 eql)
($test (mod  83886089999999999 -8388609)       -1 eql)
($test (mod  83886090000000000 -8388609)        0 eql)
($test (mod  83886090000000001 -8388609) -8388608 eql)
;;;
($test (mod -83886080000000001 -8388608)       -1 eql)
($test (mod -83886080000000000 -8388608)        0 eql)
($test (mod -83886079999999999 -8388608) -8388607 eql)
($test (mod           -8388609 -8388608)       -1 eql)
($test (mod           -8388608 -8388608)        0 eql)
($test (mod           -8388607 -8388608) -8388607 eql)
($test (mod                 -1 -8388608)       -1 eql)
($test (mod                  0 -8388608)        0 eql)
($test (mod                  1 -8388608) -8388607 eql)
($test (mod            8388607 -8388608)       -1 eql)
($test (mod            8388608 -8388608)        0 eql)
($test (mod            8388609 -8388608) -8388607 eql)
($test (mod  83886079999999999 -8388608)       -1 eql)
($test (mod  83886080000000000 -8388608)        0 eql)
($test (mod  83886080000000001 -8388608) -8388607 eql)
;;;
($test (mod -10000000000000000 -1) 0 eql)
($test (mod           -8388609 -1) 0 eql)
($test (mod           -8388608 -1) 0 eql)
($test (mod           -8388607 -1) 0 eql)
($test (mod                 -1 -1) 0 eql)
($test (mod                  0 -1) 0 eql)
($test (mod                  1 -1) 0 eql)
($test (mod            8388607 -1) 0 eql)
($test (mod            8388608 -1) 0 eql)
($test (mod            8388609 -1) 0 eql)
($test (mod  10000000000000000 -1) 0 eql)
;;;
($error (mod -10000000000000000 0) <division-by-zero>)
($error (mod           -8388608 0) <division-by-zero>)
($error (mod           -8388607 0) <division-by-zero>)
($error (mod                 -1 0) <division-by-zero>)
($error (mod                  0 0) <division-by-zero>)
($error (mod                  1 0) <division-by-zero>)
($error (mod            8388607 0) <division-by-zero>)
($error (mod            8388608 0) <division-by-zero>)
($error (mod  10000000000000000 0) <division-by-zero>)
;;;
($test (mod -10000000000000000 1) 0 eql)
($test (mod           -8388609 1) 0 eql)
($test (mod           -8388608 1) 0 eql)
($test (mod           -8388607 1) 0 eql)
($test (mod                 -1 1) 0 eql)
($test (mod                  0 1) 0 eql)
($test (mod                  1 1) 0 eql)
($test (mod            8388607 1) 0 eql)
($test (mod            8388608 1) 0 eql)
($test (mod            8388609 1) 0 eql)
($test (mod  10000000000000000 1) 0 eql)
;;;
($test (mod -83886070000000001 8388607) 8388606 eql)
($test (mod -83886070000000000 8388607)       0 eql)
($test (mod -83886069999999999 8388607)       1 eql)
($test (mod           -8388609 8388607) 8388605 eql)
($test (mod           -8388608 8388607) 8388606 eql)
($test (mod           -8388607 8388607)       0 eql)
($test (mod           -8388606 8388607)       1 eql)
($test (mod                 -1 8388607) 8388606 eql)
($test (mod                  0 8388607)       0 eql)
($test (mod                  1 8388607)       1 eql)
($test (mod            8388606 8388607) 8388606 eql)
($test (mod            8388607 8388607)       0 eql)
($test (mod            8388608 8388607)       1 eql)
($test (mod  83886069999999999 8388607) 8388606 eql)
($test (mod  83886070000000000 8388607)       0 eql)
($test (mod  83886070000000001 8388607)       1 eql)
;;;
($test (mod -83886080000000001 8388608) 8388607 eql)
($test (mod -83886080000000000 8388608)       0 eql)
($test (mod -83886079999999999 8388608)       1 eql)
($test (mod           -8388609 8388608) 8388607 eql)
($test (mod           -8388608 8388608)       0 eql)
($test (mod           -8388607 8388608)       1 eql)
($test (mod                 -1 8388608) 8388607 eql)
($test (mod                  0 8388608)       0 eql)
($test (mod                  1 8388608)       1 eql)
($test (mod            8388607 8388608) 8388607 eql)
($test (mod            8388608 8388608)       0 eql)
($test (mod            8388609 8388608)       1 eql)
($test (mod  83886079999999999 8388608) 8388607 eql)
($test (mod  83886080000000000 8388608)       0 eql)
($test (mod  83886080000000001 8388608)       1 eql)
;;;
($test (mod -10000000000000001 10000000000000000) 9999999999999999 eql)
($test (mod -10000000000000000 10000000000000000)                0 eql)
($test (mod  -9999999999999999 10000000000000000)                1 eql)
($test (mod           -8388609 10000000000000000) 9999999991611391 eql)
($test (mod           -8388608 10000000000000000) 9999999991611392 eql)
($test (mod                 -1 10000000000000000) 9999999999999999 eql)
($test (mod                  0 10000000000000000)                0 eql)
($test (mod                  1 10000000000000000)                1 eql)
($test (mod            8388607 10000000000000000)          8388607 eql)
($test (mod            8388608 10000000000000000)          8388608 eql)
($test (mod   9999999999999999 10000000000000000) 9999999999999999 eql)
($test (mod  10000000000000000 10000000000000000)                0 eql)
($test (mod  10000000000000001 10000000000000000)                1 eql)

;;;
;;; function (GCD z1 z2) --> <integer>
;;;
($ap 2 "gcd" P.80)
($test (gcd 12 5) 1 eql)
($test (gcd 15 24) 3 eql)
($test (gcd -15 24) 3 eql)
($test (gcd 15 -24) 3 eql)
($test (gcd -15 -24) 3 eql)
($test (gcd 0 -4) 4 eql)
($test (gcd 0 0) 0 eql)
;;;
($argc gcd 2 0 0)
($type gcd ($integer) :target 1)
($type gcd ($integer) 1 :target)
;;;
($test (gcd -10000000000000001 -10000000000000000)                 1 eql)
($test (gcd -10000000000000000 -10000000000000000) 10000000000000000 eql)
($test (gcd  -9999999999999999 -10000000000000000)                 1 eql)
($test (gcd           -8388609 -10000000000000000)                 1 eql)
($test (gcd           -8388608 -10000000000000000)             65536 eql)
($test (gcd                 -1 -10000000000000000)                 1 eql)
($test (gcd                  0 -10000000000000000) 10000000000000000 eql)
($test (gcd                  1 -10000000000000000)                 1 eql)
($test (gcd            8388607 -10000000000000000)                 1 eql)
($test (gcd            8388608 -10000000000000000)             65536 eql)
($test (gcd   9999999999999999 -10000000000000000)                 1 eql)
($test (gcd  10000000000000000 -10000000000000000) 10000000000000000 eql)
($test (gcd  10000000000000001 -10000000000000000)                 1 eql)
;;;
($test (gcd -83886090000000001 -8388609)       1 eql)
($test (gcd -83886090000000000 -8388609) 8388609 eql)
($test (gcd -83886089999999999 -8388609)       1 eql)
($test (gcd           -8388610 -8388609)       1 eql)
($test (gcd           -8388609 -8388609) 8388609 eql)
($test (gcd           -8388608 -8388609)       1 eql)
($test (gcd                 -1 -8388609)       1 eql)
($test (gcd                  0 -8388609) 8388609 eql)
($test (gcd                  1 -8388609)       1 eql)
($test (gcd            8388607 -8388609)       1 eql)
($test (gcd            8388608 -8388609)       1 eql)
($test (gcd            8388609 -8388609) 8388609 eql)
($test (gcd            8388610 -8388609)       1 eql)
($test (gcd  83886089999999999 -8388609)       1 eql)
($test (gcd  83886090000000000 -8388609) 8388609 eql)
($test (gcd  83886090000000001 -8388609)       1 eql)
;;;
($test (gcd -83886080000000001 -8388608)       1 eql)
($test (gcd -83886080000000000 -8388608) 8388608 eql)
($test (gcd -83886079999999999 -8388608)       1 eql)
($test (gcd           -8388609 -8388608)       1 eql)
($test (gcd           -8388608 -8388608) 8388608 eql)
($test (gcd           -8388607 -8388608)       1 eql)
($test (gcd                 -1 -8388608)       1 eql)
($test (gcd                  0 -8388608) 8388608 eql)
($test (gcd                  1 -8388608)       1 eql)
($test (gcd            8388607 -8388608)       1 eql)
($test (gcd            8388608 -8388608) 8388608 eql)
($test (gcd            8388609 -8388608)       1 eql)
($test (gcd  83886079999999999 -8388608)       1 eql)
($test (gcd  83886080000000000 -8388608) 8388608 eql)
($test (gcd  83886080000000001 -8388608)       1 eql)
;;;
($test (gcd -10000000000000000 -1) 1 eql)
($test (gcd           -8388609 -1) 1 eql)
($test (gcd           -8388608 -1) 1 eql)
($test (gcd           -8388607 -1) 1 eql)
($test (gcd                 -1 -1) 1 eql)
($test (gcd                  0 -1) 1 eql)
($test (gcd                  1 -1) 1 eql)
($test (gcd            8388607 -1) 1 eql)
($test (gcd            8388608 -1) 1 eql)
($test (gcd            8388609 -1) 1 eql)
($test (gcd  10000000000000000 -1) 1 eql)
;;;
($test (gcd -10000000000000000 0) 10000000000000000 eql)
($test (gcd           -8388608 0)           8388608 eql)
($test (gcd           -8388607 0)           8388607 eql)
($test (gcd                 -1 0)                 1 eql)
($test (gcd                  0 0)                 0 eql)
($test (gcd                  1 0)                 1 eql)
($test (gcd            8388607 0)           8388607 eql)
($test (gcd            8388608 0)           8388608 eql)
($test (gcd  10000000000000000 0) 10000000000000000 eql)
;;;
($test (gcd -10000000000000000 1) 1 eql)
($test (gcd           -8388609 1) 1 eql)
($test (gcd           -8388608 1) 1 eql)
($test (gcd           -8388607 1) 1 eql)
($test (gcd                 -1 1) 1 eql)
($test (gcd                  0 1) 1 eql)
($test (gcd                  1 1) 1 eql)
($test (gcd            8388607 1) 1 eql)
($test (gcd            8388608 1) 1 eql)
($test (gcd            8388609 1) 1 eql)
($test (gcd  10000000000000000 1) 1 eql)
;;;
($test (gcd -83886070000000001 8388607)       1 eql)
($test (gcd -83886070000000000 8388607) 8388607 eql)
($test (gcd -83886069999999999 8388607)       1 eql)
($test (gcd           -8388609 8388607)       1 eql)
($test (gcd           -8388608 8388607)       1 eql)
($test (gcd           -8388607 8388607) 8388607 eql)
($test (gcd           -8388606 8388607)       1 eql)
($test (gcd                 -1 8388607)       1 eql)
($test (gcd                  0 8388607) 8388607 eql)
($test (gcd                  1 8388607)       1 eql)
($test (gcd            8388606 8388607)       1 eql)
($test (gcd            8388607 8388607) 8388607 eql)
($test (gcd            8388608 8388607)       1 eql)
($test (gcd  83886069999999999 8388607)       1 eql)
($test (gcd  83886070000000000 8388607) 8388607 eql)
($test (gcd  83886070000000001 8388607)       1 eql)
;;;
($test (gcd -83886080000000001 8388608)       1 eql)
($test (gcd -83886080000000000 8388608) 8388608 eql)
($test (gcd -83886079999999999 8388608)       1 eql)
($test (gcd           -8388609 8388608)       1 eql)
($test (gcd           -8388608 8388608) 8388608 eql)
($test (gcd           -8388607 8388608)       1 eql)
($test (gcd                 -1 8388608)       1 eql)
($test (gcd                  0 8388608) 8388608 eql)
($test (gcd                  1 8388608)       1 eql)
($test (gcd            8388607 8388608)       1 eql)
($test (gcd            8388608 8388608) 8388608 eql)
($test (gcd            8388609 8388608)       1 eql)
($test (gcd  83886079999999999 8388608)       1 eql)
($test (gcd  83886080000000000 8388608) 8388608 eql)
($test (gcd  83886080000000001 8388608)       1 eql)
;;;
($test (gcd -10000000000000001 10000000000000000)                 1 eql)
($test (gcd -10000000000000000 10000000000000000) 10000000000000000 eql)
($test (gcd  -9999999999999999 10000000000000000)                 1 eql)
($test (gcd           -8388609 10000000000000000)                 1 eql)
($test (gcd           -8388608 10000000000000000)             65536 eql)
($test (gcd                 -1 10000000000000000)                 1 eql)
($test (gcd                  0 10000000000000000) 10000000000000000 eql)
($test (gcd                  1 10000000000000000)                 1 eql)
($test (gcd            8388607 10000000000000000)                 1 eql)
($test (gcd            8388608 10000000000000000)             65536 eql)
($test (gcd   9999999999999999 10000000000000000)                 1 eql)
($test (gcd  10000000000000000 10000000000000000) 10000000000000000 eql)
($test (gcd  10000000000000001 10000000000000000)                 1 eql)

;;;
;;; function (LCM z1 z2) --> <integer>
;;;
($ap 2 "lcm" P.80)
($test (lcm 2 3) 6 eql)
($test (lcm 15 24) 120 eql)
($test (lcm 15 -24) 120 eql)
($test (lcm -15 24) 120 eql)
($test (lcm -15 -24) 120 eql)
($test (lcm 0 -4) 0 eql)
($test (lcm 0 0) 0 eql)
;;;
($argc lcm 2 0 0)
($type lcm ($integer) :target 1)
($type lcm ($integer) 1 :target)
;;;
($test (lcm -10000000000000001 -10000000000000000) 100000000000000010000000000000000 eql)
($test (lcm -10000000000000000 -10000000000000000)                 10000000000000000 eql)
($test (lcm  -9999999999999999 -10000000000000000)  99999999999999990000000000000000 eql)
($test (lcm           -8388609 -10000000000000000)           83886090000000000000000 eql)
($test (lcm           -8388608 -10000000000000000)               1280000000000000000 eql)
($test (lcm                 -1 -10000000000000000)                 10000000000000000 eql)
($test (lcm                  0 -10000000000000000)                                 0 eql)
($test (lcm                  1 -10000000000000000)                 10000000000000000 eql)
($test (lcm            8388607 -10000000000000000)           83886070000000000000000 eql)
($test (lcm            8388608 -10000000000000000)               1280000000000000000 eql)
($test (lcm   9999999999999999 -10000000000000000)  99999999999999990000000000000000 eql)
($test (lcm  10000000000000000 -10000000000000000)                 10000000000000000 eql)
($test (lcm  10000000000000001 -10000000000000000) 100000000000000010000000000000000 eql)
;;;
($test (lcm -83886090000000001 -8388609) 703687609548810008388609 eql)
($test (lcm -83886090000000000 -8388609)        83886090000000000 eql)
($test (lcm -83886089999999999 -8388609) 703687609548809991611391 eql)
($test (lcm           -8388610 -8388609)           70368769343490 eql)
($test (lcm           -8388609 -8388609)                  8388609 eql)
($test (lcm           -8388608 -8388609)           70368752566272 eql)
($test (lcm                 -1 -8388609)                  8388609 eql)
($test (lcm                  0 -8388609)                        0 eql)
($test (lcm                  1 -8388609)                  8388609 eql)
($test (lcm            8388607 -8388609)           70368744177663 eql)
($test (lcm            8388608 -8388609)           70368752566272 eql)
($test (lcm            8388609 -8388609)                  8388609 eql)
($test (lcm            8388610 -8388609)           70368769343490 eql)
($test (lcm  83886089999999999 -8388609) 703687609548809991611391 eql)
($test (lcm  83886090000000000 -8388609)        83886090000000000 eql)
($test (lcm  83886090000000001 -8388609) 703687609548810008388609 eql)
;;;
($test (lcm -83886080000000001 -8388608) 703687441776640008388608 eql)
($test (lcm -83886080000000000 -8388608)        83886080000000000 eql)
($test (lcm -83886079999999999 -8388608) 703687441776639991611392 eql)
($test (lcm           -8388609 -8388608)           70368752566272 eql)
($test (lcm           -8388608 -8388608)                  8388608 eql)
($test (lcm           -8388607 -8388608)           70368735789056 eql)
($test (lcm                 -1 -8388608)                  8388608 eql)
($test (lcm                  0 -8388608)                        0 eql)
($test (lcm                  1 -8388608)                  8388608 eql)
($test (lcm            8388607 -8388608)           70368735789056 eql)
($test (lcm            8388608 -8388608)                  8388608 eql)
($test (lcm            8388609 -8388608)           70368752566272 eql)
($test (lcm  83886079999999999 -8388608) 703687441776639991611392 eql)
($test (lcm  83886080000000000 -8388608)        83886080000000000 eql)
($test (lcm  83886080000000001 -8388608) 703687441776640008388608 eql)
;;;
($test (lcm -10000000000000000 -1) 10000000000000000 eql)
($test (lcm           -8388609 -1)           8388609 eql)
($test (lcm           -8388608 -1)           8388608 eql)
($test (lcm           -8388607 -1)           8388607 eql)
($test (lcm                 -1 -1)                 1 eql)
($test (lcm                  0 -1)                 0 eql)
($test (lcm                  1 -1)                 1 eql)
($test (lcm            8388607 -1)           8388607 eql)
($test (lcm            8388608 -1)           8388608 eql)
($test (lcm            8388609 -1)           8388609 eql)
($test (lcm  10000000000000000 -1) 10000000000000000 eql)
;;;
($test (lcm -10000000000000000 0) 0 eql)
($test (lcm           -8388608 0) 0 eql)
($test (lcm           -8388607 0) 0 eql)
($test (lcm                 -1 0) 0 eql)
($test (lcm                  0 0) 0 eql)
($test (lcm                  1 0) 0 eql)
($test (lcm            8388607 0) 0 eql)
($test (lcm            8388608 0) 0 eql)
($test (lcm  10000000000000000 0) 0 eql)
;;;
($test (lcm -10000000000000000 1) 10000000000000000 eql)
($test (lcm           -8388609 1)           8388609 eql)
($test (lcm           -8388608 1)           8388608 eql)
($test (lcm           -8388607 1)           8388607 eql)
($test (lcm                 -1 1)                 1 eql)
($test (lcm                  0 1)                 0 eql)
($test (lcm                  1 1)                 1 eql)
($test (lcm            8388607 1)           8388607 eql)
($test (lcm            8388608 1)           8388608 eql)
($test (lcm            8388609 1)           8388609 eql)
($test (lcm  10000000000000000 1) 10000000000000000 eql)
;;;
($test (lcm -83886070000000001 8388607) 703687274004490008388607 eql)
($test (lcm -83886070000000000 8388607)        83886070000000000 eql)
($test (lcm -83886069999999999 8388607) 703687274004489991611393 eql)
($test (lcm           -8388609 8388607)           70368744177663 eql)
($test (lcm           -8388608 8388607)           70368735789056 eql)
($test (lcm           -8388607 8388607)                  8388607 eql)
($test (lcm           -8388606 8388607)           70368719011842 eql)
($test (lcm                 -1 8388607)                  8388607 eql)
($test (lcm                  0 8388607)                        0 eql)
($test (lcm                  1 8388607)                  8388607 eql)
($test (lcm            8388606 8388607)           70368719011842 eql)
($test (lcm            8388607 8388607)                  8388607 eql)
($test (lcm            8388608 8388607)           70368735789056 eql)
($test (lcm  83886069999999999 8388607) 703687274004489991611393 eql)
($test (lcm  83886070000000000 8388607)        83886070000000000 eql)
($test (lcm  83886070000000001 8388607) 703687274004490008388607 eql)
;;;
($test (lcm -83886080000000001 8388608) 703687441776640008388608 eql)
($test (lcm -83886080000000000 8388608)        83886080000000000 eql)
($test (lcm -83886079999999999 8388608) 703687441776639991611392 eql)
($test (lcm           -8388609 8388608)           70368752566272 eql)
($test (lcm           -8388608 8388608)                  8388608 eql)
($test (lcm           -8388607 8388608)           70368735789056 eql)
($test (lcm                 -1 8388608)                  8388608 eql)
($test (lcm                  0 8388608)                        0 eql)
($test (lcm                  1 8388608)                  8388608 eql)
($test (lcm            8388607 8388608)           70368735789056 eql)
($test (lcm            8388608 8388608)                  8388608 eql)
($test (lcm            8388609 8388608)           70368752566272 eql)
($test (lcm  83886079999999999 8388608) 703687441776639991611392 eql)
($test (lcm  83886080000000000 8388608)        83886080000000000 eql)
($test (lcm  83886080000000001 8388608) 703687441776640008388608 eql)
;;;
($test (lcm -10000000000000001 10000000000000000) 100000000000000010000000000000000 eql)
($test (lcm -10000000000000000 10000000000000000)                 10000000000000000 eql)
($test (lcm  -9999999999999999 10000000000000000)  99999999999999990000000000000000 eql)
($test (lcm           -8388609 10000000000000000)           83886090000000000000000 eql)
($test (lcm           -8388608 10000000000000000)               1280000000000000000 eql)
($test (lcm                 -1 10000000000000000)                 10000000000000000 eql)
($test (lcm                  0 10000000000000000)                                 0 eql)
($test (lcm                  1 10000000000000000)                 10000000000000000 eql)
($test (lcm            8388607 10000000000000000)           83886070000000000000000 eql)
($test (lcm            8388608 10000000000000000)               1280000000000000000 eql)
($test (lcm   9999999999999999 10000000000000000)  99999999999999990000000000000000 eql)
($test (lcm  10000000000000000 10000000000000000)                 10000000000000000 eql)
($test (lcm  10000000000000001 10000000000000000) 100000000000000010000000000000000 eql)

;;;
;;; function (ISQRT z) --> <integer>
;;;
($ap 2 "isqrt" P.81)
($test (isqrt 49) 7 eql)
($test (isqrt 63) 7 eql)
($test (isqrt 1000000000000002000000000000000) 1000000000000000 eql)
;;;
($argc isqrt 1 0 0)
($type isqrt ($integer) :target)
;;;
($error (isqrt -1234567890) <domain-error>)
($error (isqrt -1) <domain-error>)
($test (isqrt                 0)         0 eql)
($test (isqrt                 1)         1 eql)
($test (isqrt           8388607)      2896 eql)
($test (isqrt           8388608)      2896 eql)
($test (isqrt        9999999999)     99999 eql)
($test (isqrt       10000000000)    100000 eql)
($test (isqrt       10000000001)    100000 eql)
($test (isqrt    70368727400448)   8388606 eql)
($test (isqrt    70368727400449)   8388607 eql)
($test (isqrt    70368727400450)   8388607 eql)
($test (isqrt    70368744177663)   8388607 eql)
($test (isqrt    70368744177664)   8388608 eql)
($test (isqrt    70368744177665)   8388608 eql)
($test (isqrt  9999999999999999)  99999999 eql)
($test (isqrt 10000000000000000) 100000000 eql)
($test (isqrt 10000000000000001) 100000000 eql)

