/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class SideBandInputStream
extends InputStream {
    static final int CH_DATA = 1;
    static final int CH_PROGRESS = 2;
    static final int CH_ERROR = 3;
    private static Pattern P_UNBOUNDED = Pattern.compile("^([\\w ]+): +(\\d+)(?:, done\\.)? *[\r\n]$");
    private static Pattern P_BOUNDED = Pattern.compile("^([\\w ]+): +\\d+% +\\( *(\\d+)/ *(\\d+)\\)(?:, done\\.)? *[\r\n]$");
    private final InputStream rawIn;
    private final PacketLineIn pckIn;
    private final ProgressMonitor monitor;
    private final Writer messages;
    private final OutputStream out;
    private String progressBuffer = "";
    private String currentTask;
    private int lastCnt;
    private boolean eof;
    private int channel;
    private int available;

    SideBandInputStream(InputStream in, ProgressMonitor progress, Writer messageStream, OutputStream outputStream) {
        this.rawIn = in;
        this.pckIn = new PacketLineIn(this.rawIn);
        this.monitor = progress;
        this.messages = messageStream;
        this.currentTask = "";
        this.out = outputStream;
    }

    @Override
    public int read() throws IOException {
        this.needDataPacket();
        if (this.eof) {
            return -1;
        }
        --this.available;
        return this.rawIn.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        while (len > 0) {
            int n;
            this.needDataPacket();
            if (this.eof || (n = this.rawIn.read(b, off, Math.min(len, this.available))) < 0) break;
            r += n;
            off += n;
            len -= n;
            this.available -= n;
        }
        return this.eof && r == 0 ? -1 : r;
    }

    private void needDataPacket() throws IOException {
        if (this.eof || this.channel == 1 && this.available > 0) {
            return;
        }
        block5: while (true) {
            this.available = this.pckIn.readLength();
            if (this.available == 0) {
                this.eof = true;
                return;
            }
            this.channel = this.rawIn.read() & 0xFF;
            this.available -= 5;
            if (this.available == 0) continue;
            switch (this.channel) {
                case 1: {
                    return;
                }
                case 2: {
                    this.progress(this.readString(this.available));
                    continue block5;
                }
                case 3: {
                    this.eof = true;
                    throw new TransportException(SideBandInputStream.remote(this.readString(this.available)));
                }
            }
            break;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidChannel, this.channel));
    }

    /*
     * WARNING - void declaration
     */
    private void progress(String pkt) throws IOException {
        pkt = this.progressBuffer + pkt;
        while (true) {
            void var4_4;
            int s2;
            int lf = pkt.indexOf(10);
            int cr = pkt.indexOf(13);
            if (0 <= lf && 0 <= cr) {
                s2 = Math.min(lf, cr);
            } else if (0 <= lf) {
                s2 = lf;
            } else {
                if (0 > cr) break;
                s2 = cr;
            }
            this.doProgressLine(pkt.substring(0, (int)(var4_4 + true)));
            pkt = pkt.substring((int)(var4_4 + true));
        }
        this.progressBuffer = pkt;
    }

    private void doProgressLine(String msg) throws IOException {
        Matcher matcher = P_BOUNDED.matcher(msg);
        if (matcher.matches()) {
            String taskname = matcher.group(1);
            if (!this.currentTask.equals(taskname)) {
                this.currentTask = taskname;
                this.lastCnt = 0;
                this.beginTask(Integer.parseInt(matcher.group(3)));
            }
            int cnt = Integer.parseInt(matcher.group(2));
            this.monitor.update(cnt - this.lastCnt);
            this.lastCnt = cnt;
            return;
        }
        matcher = P_UNBOUNDED.matcher(msg);
        if (matcher.matches()) {
            String taskname = matcher.group(1);
            if (!this.currentTask.equals(taskname)) {
                this.currentTask = taskname;
                this.lastCnt = 0;
                this.beginTask(0);
            }
            int cnt = Integer.parseInt(matcher.group(2));
            this.monitor.update(cnt - this.lastCnt);
            this.lastCnt = cnt;
            return;
        }
        this.messages.write(msg);
        if (this.out != null) {
            this.out.write(msg.getBytes());
        }
    }

    private void beginTask(int totalWorkUnits) {
        this.monitor.beginTask(SideBandInputStream.remote(this.currentTask), totalWorkUnits);
    }

    private static String remote(String msg) {
        String prefix = JGitText.get().prefixRemote;
        StringBuilder r = new StringBuilder(prefix.length() + msg.length() + 1);
        r.append(prefix);
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != ' ') {
            r.append(' ');
        }
        r.append(msg);
        return r.toString();
    }

    private String readString(int len) throws IOException {
        byte[] raw = new byte[len];
        IO.readFully(this.rawIn, raw, 0, len);
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }
}

