/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.benchmark.Benchmark;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import com.googlecode.javaewah32.IteratorUtil32;
import java.text.DecimalFormat;
import java.util.List;

public class Benchmark32 {
    public static void main(String[] args) {
        Benchmark32.test(100, 16, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; sparsity += 2) {
            int k;
            int r;
            long bogus = 0L;
            String line = "";
            line = line + sparsity;
            int[][] data = new int[N][];
            int Max2 = 1 << nbr + sparsity;
            System.out.println("# generating random data...");
            int[] inter = cdg.generateClustered(1 << nbr / 2, Max2);
            for (int k2 = 0; k2 < N; ++k2) {
                data[k2] = Benchmark.unite2by2(cdg.generateClustered(1 << nbr, Max2), inter);
            }
            System.out.println("# generating random data... ok.");
            long bef = System.currentTimeMillis();
            EWAHCompressedBitmap32[] ewah = new EWAHCompressedBitmap32[N];
            int size = 0;
            for (r = 0; r < repeat; ++r) {
                size = 0;
                for (k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap32();
                    for (int x = 0; x < data[k].length; ++x) {
                        ewah[k].set(data[k][x]);
                    }
                    size += ewah[k].sizeInBytes();
                }
            }
            long aft = System.currentTimeMillis();
            line = line + "\t" + size;
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    int[] array = ewah[k].toArray();
                    bogus += (long)array.length;
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    int[] array = new int[ewah[k].cardinality()];
                    int c = 0;
                    for (int x : ewah[k]) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    List<Integer> L = ewah[k].getPositions();
                    int[] array = new int[L.size()];
                    int c = 0;
                    for (int x : L) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    IntIterator iter = ewah[k].intIterator();
                    while (iter.hasNext()) {
                        bogus += (long)iter.next();
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            line = line + "\t\t\t";
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap32 ewahor = ewah[0];
                    for (int j = 1; j < k + 1; ++j) {
                        ewahor = ewahor.or(ewah[j]);
                    }
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap32[] ewahcp = new EWAHCompressedBitmap32[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap32 ewahor = EWAHCompressedBitmap32.or(ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    LogicalElement[] ewahcp = new EWAHCompressedBitmap32[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap32 ewahor = (EWAHCompressedBitmap32)FastAggregation.or((LogicalElement[])ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    IteratingRLW32[] ewahcp = new IteratingRLW32[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j].getIteratingRLW();
                    }
                    IteratingRLW32 ewahor = IteratorAggregation32.bufferedor(ewahcp);
                    bogus += (long)IteratorUtil32.materialize(ewahor).sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            line = line + "\t\t\t";
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap32 ewahand = ewah[0];
                    for (int j = 1; j < k + 1; ++j) {
                        ewahand = ewahand.and(ewah[j]);
                    }
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    EWAHCompressedBitmap32[] ewahcp = new EWAHCompressedBitmap32[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap32 ewahand = EWAHCompressedBitmap32.and(ewahcp);
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k = 0; k < N; ++k) {
                    IteratingRLW32[] ewahcp = new IteratingRLW32[k + 1];
                    for (int j = 0; j < k + 1; ++j) {
                        ewahcp[j] = ewah[j].getIteratingRLW();
                    }
                    IteratingRLW32 ewahand = IteratorAggregation32.bufferedand(ewahcp);
                    bogus += (long)IteratorUtil32.materialize(ewahand).sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            System.out.println("time for building, toArray(), Java iterator, intIterator,\t\t\t logical or (2-by-2), logical or (grouped), FastAggregation.or, iterator-based or, \t\t\t (2-by-2) and,  logical and (grouped), iterator-based and");
            System.out.println(line);
            System.out.println("# bogus =" + bogus);
        }
    }
}

