/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class ElementImpl
extends ParentNodeImpl
implements NamespaceResolver {
    private NodeName nodeName;
    private SchemaType type = Untyped.getInstance();
    private AttributeCollection attributeList;
    private NamespaceBinding[] namespaceList = null;

    public void setAttributeList(AttributeCollection atts) {
        this.attributeList = atts;
    }

    public void setNamespaceList(NamespaceBinding[] namespaces) {
        this.namespaceList = namespaces;
    }

    public void setNodeName(NodeName name) {
        this.nodeName = name;
    }

    public void initialise(NodeName elemName, SchemaType elementType, AttributeCollectionImpl atts, NodeInfo parent, int sequenceNumber) {
        this.nodeName = elemName;
        this.type = elementType;
        this.setRawParent((ParentNodeImpl)parent);
        this.setRawSequenceNumber(sequenceNumber);
        this.attributeList = atts;
    }

    @Override
    public NodeName getNodeName() {
        return this.nodeName;
    }

    public void setLocation(String systemId, int line, int column) {
        DocumentImpl root = this.getRawParent().getPhysicalRoot();
        root.setLineAndColumn(this.getRawSequenceNumber(), line, column);
        root.setSystemId(this.getRawSequenceNumber(), systemId);
    }

    @Override
    public void setSystemId(String uri) {
        this.getPhysicalRoot().setSystemId(this.getRawSequenceNumber(), uri);
    }

    @Override
    public NodeInfo getRoot() {
        ParentNodeImpl up = this.getRawParent();
        if (up == null || up instanceof DocumentImpl && ((DocumentImpl)up).isImaginary()) {
            return this;
        }
        return up.getRoot();
    }

    @Override
    public final String getSystemId() {
        DocumentImpl root = this.getPhysicalRoot();
        return root == null ? null : root.getSystemId(this.getRawSequenceNumber());
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this, n -> this.getPhysicalRoot().isTopWithinEntity((ElementImpl)n));
    }

    public AttributeCollection gsetAttributeCollection() {
        return this.attributeList;
    }

    @Override
    public boolean isNilled() {
        return this.getPhysicalRoot().isNilledElement(this);
    }

    @Override
    public void setTypeAnnotation(SchemaType type) {
        this.type = type;
    }

    public void setNilled() {
        this.getPhysicalRoot().addNilledElement(this);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.type;
    }

    @Override
    public int getLineNumber() {
        DocumentImpl root = this.getPhysicalRoot();
        if (root == null) {
            return -1;
        }
        return root.getLineNumber(this.getRawSequenceNumber());
    }

    @Override
    public int getColumnNumber() {
        DocumentImpl root = this.getPhysicalRoot();
        if (root == null) {
            return -1;
        }
        return root.getColumnNumber(this.getRawSequenceNumber());
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        int sequence = this.getRawSequenceNumber();
        if (sequence >= 0) {
            this.getPhysicalRoot().generateId(buffer);
            buffer.append("e");
            buffer.append(Integer.toString(sequence));
        } else {
            this.getRawParent().generateId(buffer);
            buffer.append("f");
            buffer.append(Integer.toString(this.getSiblingPosition()));
        }
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location location) throws XPathException {
        Object o;
        SchemaType typeCode = CopyOptions.includes(copyOptions, 4) ? this.getSchemaType() : Untyped.getInstance();
        CopyInformee informee = (CopyInformee)out.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        if (informee != null && (o = informee.notifyElementNode(this)) instanceof Location) {
            location = (Location)o;
        }
        out.startElement(NameOfNode.makeName(this), typeCode, location, 0);
        int childCopyOptions = copyOptions & 0xFFFFFFFD;
        if ((copyOptions & 1) != 0) {
            NamespaceBinding[] localNamespaces;
            for (NamespaceBinding ns : localNamespaces = this.getDeclaredNamespaces(null)) {
                if (ns == null) break;
                out.namespace(ns, 0);
            }
        } else if ((copyOptions & 2) != 0) {
            NamespaceIterator.sendNamespaces(this, out);
            childCopyOptions |= 1;
        }
        if (this.attributeList != null) {
            for (int i = 0; i < this.attributeList.getLength(); ++i) {
                NodeName nc = this.attributeList.getNodeName(i);
                if (nc == null) continue;
                out.attribute(nc, BuiltInAtomicType.UNTYPED_ATOMIC, this.attributeList.getValue(i), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
        }
        out.startContent();
        for (NodeImpl next = this.getFirstChild(); next != null; next = next.getNextSibling()) {
            next.copy(out, childCopyOptions, location);
        }
        out.endElement();
    }

    @Override
    public void delete() {
        DocumentImpl root = this.getPhysicalRoot();
        super.delete();
        if (root != null) {
            AxisIterator iter = this.iterateAxis((byte)5, NodeKindTest.ELEMENT);
            while (true) {
                ElementImpl n = (ElementImpl)iter.next();
                int atts = this.attributeList.getLength();
                for (int index = 0; index < atts; ++index) {
                    if (!this.attributeList.isId(index)) continue;
                    root.deregisterID(this.attributeList.getValue(index));
                }
                if (n == null) break;
                root.deIndex(n);
            }
        }
    }

    @Override
    public void rename(NodeName newName) {
        String prefix = newName.getPrefix();
        String uri = newName.getURI();
        NamespaceBinding ns = new NamespaceBinding(prefix, uri);
        String uc = this.getURIForPrefix(prefix, true);
        if (uc == null) {
            uc = "";
        }
        if (!uc.equals(uri)) {
            if (uc.isEmpty()) {
                this.addNamespace(ns, false);
            } else {
                throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
            }
        }
        this.nodeName = newName;
    }

    @Override
    public void addNamespace(NamespaceBinding nscode, boolean unused) {
        if (nscode.getURI().isEmpty()) {
            throw new IllegalArgumentException("Cannot add a namespace undeclaration");
        }
        this.addNamespaceInternal(nscode, true);
    }

    private void addNamespaceInternal(NamespaceBinding nscode, boolean externalCall) {
        if (this.namespaceList == null) {
            this.namespaceList = new NamespaceBinding[]{nscode};
        } else {
            NamespaceBinding[] nsList = this.namespaceList;
            for (int i = 0; i < nsList.length; ++i) {
                if (nsList[i].equals(nscode)) {
                    return;
                }
                if (!nsList[i].getPrefix().equals(nscode.getPrefix())) continue;
                if (nsList[i].getURI().isEmpty()) {
                    nsList[i] = nscode;
                    return;
                }
                if (externalCall) {
                    throw new IllegalArgumentException("New namespace conflicts with existing namespace binding");
                }
                return;
            }
            int len = nsList.length;
            NamespaceBinding[] ns2 = new NamespaceBinding[len + 1];
            System.arraycopy(nsList, 0, ns2, 0, len);
            ns2[len] = nscode;
            this.namespaceList = ns2;
        }
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        if (stringValue.length() == 0) {
            this.setChildren(null);
        } else {
            TextImpl text = new TextImpl(stringValue.toString());
            text.setRawParent(this);
            this.setChildren(text);
        }
    }

    @Override
    public void addAttribute(NodeName nameCode, SimpleType attType, CharSequence value, int properties) {
        DocumentImpl root;
        AttributeCollectionImpl atts;
        int index;
        if (this.attributeList == null || this.attributeList.getLength() == 0) {
            this.attributeList = new AttributeCollectionImpl(this.getConfiguration());
        }
        if ((index = (atts = (AttributeCollectionImpl)this.attributeList).findByNodeName(nameCode)) != -1) {
            throw new IllegalStateException("Cannot add an attribute to an element as it already has an attribute with the specified name");
        }
        atts.addAttribute(nameCode, attType, value.toString(), ExplicitLocation.UNKNOWN_LOCATION, 0);
        if (!nameCode.hasURI("")) {
            NamespaceBinding binding = nameCode.getNamespaceBinding();
            String prefix = binding.getPrefix();
            String uc = this.getURIForPrefix(prefix, false);
            if (uc == null) {
                this.addNamespace(binding, false);
            } else if (!uc.equals(binding.getURI())) {
                throw new IllegalStateException("Namespace binding of new name conflicts with existing namespace binding");
            }
        }
        if ((properties & 0x800) != 0 && (root = this.getPhysicalRoot()) != null) {
            root.registerID(this, Whitespace.trim(value));
        }
    }

    @Override
    public void removeAttribute(NodeInfo attribute) {
        if (!(attribute instanceof AttributeImpl)) {
            return;
        }
        AttributeCollectionImpl atts = (AttributeCollectionImpl)this.getAttributeList();
        int index = ((AttributeImpl)attribute).getSiblingPosition();
        if (index >= 0 && atts.isId(index)) {
            DocumentImpl root = this.getPhysicalRoot();
            root.deregisterID(atts.getValue(index));
        }
        atts.removeAttribute(index);
        ((AttributeImpl)attribute).setRawParent(null);
    }

    @Override
    public void removeTypeAnnotation() {
        if (this.getSchemaType() != Untyped.getInstance()) {
            this.type = AnyType.getInstance();
            this.getRawParent().removeTypeAnnotation();
        }
    }

    public void setNamespaceDeclarations(NamespaceBinding[] namespaces, int namespacesUsed) {
        this.namespaceList = new NamespaceBinding[namespacesUsed];
        System.arraycopy(namespaces, 0, this.namespaceList, 0, namespacesUsed);
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        ParentNodeImpl next;
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.isEmpty() && !useDefault) {
            return "";
        }
        if (this.namespaceList != null) {
            for (NamespaceBinding aNamespaceList : this.namespaceList) {
                if (!aNamespaceList.getPrefix().equals(prefix)) continue;
                String uri = aNamespaceList.getURI();
                return uri.isEmpty() && prefix.length() != 0 ? null : uri;
            }
        }
        if ((next = this.getRawParent()).getNodeKind() == 9) {
            return prefix.isEmpty() ? "" : null;
        }
        return ((ElementImpl)next).getURIForPrefix(prefix, useDefault);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        return new Iterator<String>(){
            private NamePool pool = null;
            private Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(ElementImpl.this);

            @Override
            public boolean hasNext() {
                return this.pool == null || this.iter.hasNext();
            }

            @Override
            public String next() {
                if (this.pool == null) {
                    this.pool = ElementImpl.this.getNamePool();
                    return "xml";
                }
                return this.iter.next().getPrefix();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public boolean isInScopeNamespace(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        for (NamespaceBinding b : this.namespaceList) {
            if (!b.getURI().equals(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return this.namespaceList == null ? NamespaceBinding.EMPTY_ARRAY : this.namespaceList;
    }

    protected void fixupInsertedNamespaces(boolean inherit) {
        if (this.getRawParent().getNodeKind() == 9) {
            return;
        }
        HashSet<NamespaceBinding> childNamespaces = new HashSet<NamespaceBinding>();
        if (this.namespaceList != null) {
            childNamespaces.addAll(Arrays.asList(this.namespaceList));
        }
        InscopeNamespaceResolver inscope = new InscopeNamespaceResolver(this.getRawParent());
        if (this.getURI().isEmpty() && inscope.getURIForPrefix("", true).length() != 0) {
            childNamespaces.add(NamespaceBinding.DEFAULT_UNDECLARATION);
        }
        if (!inherit) {
            NamespaceBinding[] it = inscope.iteratePrefixes();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                if (prefix.equals("xml")) continue;
                boolean found = false;
                if (this.namespaceList != null) {
                    for (NamespaceBinding aNamespaceList : this.namespaceList) {
                        if (!aNamespaceList.getPrefix().equals(prefix)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                childNamespaces.add(new NamespaceBinding(prefix, ""));
            }
        }
        if (this.namespaceList != null) {
            for (NamespaceBinding nscode : this.namespaceList) {
                String prefix = nscode.getPrefix();
                String uri = nscode.getURI();
                String parentUri = inscope.getURIForPrefix(prefix, true);
                if (parentUri == null || !parentUri.equals(uri)) continue;
                childNamespaces.remove(nscode);
            }
        }
        NamespaceBinding[] n2 = new NamespaceBinding[childNamespaces.size()];
        int j = 0;
        for (NamespaceBinding childNamespace : childNamespaces) {
            n2[j++] = childNamespace;
        }
        this.namespaceList = n2;
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList == null ? AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION : this.attributeList;
    }

    public NamespaceBinding[] getNamespaceList() {
        return this.namespaceList;
    }

    @Override
    public String getAttributeValue(String uri, String localName) {
        return this.attributeList == null ? null : this.attributeList.getValue(uri, localName);
    }

    @Override
    public boolean isId() {
        try {
            SchemaType type = this.getSchemaType();
            return type.getFingerprint() == 560 || type.isIdType() && NameChecker.isValidNCName(this.getStringValueCS());
        }
        catch (MissingComponentException e) {
            return false;
        }
    }
}

