/* File:      pitaposs.P
** Author(s): Fabrizio Riguzzi
** 
*/

% PITA for possibilistic logic

:-dynamic '$p'/2,setting/2.

:- import length/2,append/3,nth/3 from lists.
:- import member_eq/2, list2and/2, list2or/2, get_var_n/4, builtin/1
    from pitautils.

:- set_prolog_flag(unknown,fail).

setting(compiling,false).
/* compiling: true, failse */
setting(tabling_output,video).
/* video, call */
setting(pretty_print,true).

myor(A,B,C):-C is max(A,B).
myequality(Probs,N,P):-N1 is N+1,nth(N1,Probs,P).
myand(A,B,C):-C is min(A,B).
myret_prob(B,B).
myzero(0.0).
myone(1.0).
mybdd_not(A,P):-P is 1-A.

myinit:-
	abolish_all_tables.

myend.

poss(Goal,P):-
	myinit,
	add_bdd_arg(Goal,BDD,Goal1),
	(call(Goal1)->
		myret_prob(BDD,P)
	;
		P=0.0
	),
	myend.

poss(Goal,P,CPUTime1,WallTime1):-
        cputime(CT0),
	walltime(WT0),
	myinit,
	add_bdd_arg(Goal,BDD,Goal1),
	(call(Goal1)->
		myret_prob(BDD,P)
	;
		P=0.0
	),
	myend,
	cputime(CT1),
	CPUTime1 is CT1-CT0,
	walltime(WT1),
	WallTime1 is WT1-WT0.

s(Goal,P,CPUTime1,0,WallTime1,0):-
        cputime(CT0),
	walltime(WT0),
	myinit,
	add_bdd_arg(Goal,BDD,Goal1),
	(call(Goal1)->
		myret_prob(BDD,P)
	;
		P=0.0
	),
	myend,
	cputime(CT1),
	CPUTime1 is CT1-CT0,
	walltime(WT1),
	WallTime1 is WT1-WT0.

%----------------------

generate_clause(Head,Body,Probs,BDDAnd,N,Clause):-
	add_bdd_arg(Head,BDD,Head1),
	Clause=(Head1:-(Body,myequality(Probs,N,B),myand(BDDAnd,B,BDD))).

process_body_def([],BDD,BDD,[]).

process_body_def([findall(V,H,L)|T],BDD,BDD1,[findall(V,H1,L)|Rest]):-!,
	add_bdd_arg(H,_BDDH,H1),
	process_body_def(T,BDD,BDD1,Rest).

process_body_def([\+ H|T],BDD,BDD1,[\+ H|Rest]):-
	builtin(H),!,
	process_body_def(T,BDD,BDD1,Rest).
	
process_body_def([H|T],BDD,BDD1,[H|Rest]):-
	builtin(H),!,
	process_body_def(T,BDD,BDD1,Rest).

process_body_def([\+H|T],BDD,BDD1,
	[(H1->mybdd_not(BDDH,BDDN);myone(BDDN)),
	myand(BDD,BDDN,BDD2)|Rest]):-!,
	add_bdd_arg(H,BDDH,H1),
	process_body_def(T,BDD2,BDD1,Rest).

process_body_def([H|T],BDD,BDD1,[H1,myand(BDD,BDDH,BDD2)|Rest]):-!,
	add_bdd_arg(H,BDDH,H1),
	process_body_def(T,BDD2,BDD1,Rest).





process_body([],BDD,BDD,[]).

process_body([findall(V,H,L)|T],BDD,BDD1,[findall(V,H1,L)|Rest]):-!,
	add_bdd_arg(H,_BDDH,H1),
	builtin(H),!,
	process_body(T,BDD,BDD1,Rest).
	
process_body([\+ H|T],BDD,BDD1,[\+ H|Rest]):-
	builtin(H),!,
	process_body(T,BDD,BDD1,Rest).
	
process_body([H|T],BDD,BDD1,[H|Rest]):-
	builtin(H),!,
	process_body(T,BDD,BDD1,Rest).

process_body([\+ H|T],BDD,BDD1,
[(H1->mybdd_not(BDDH,BDDN);myone(BDDN)),
	myand(BDD,BDDN,BDD2)|Rest]):-!,
	add_bdd_arg(H,BDDH,H1),
	process_body(T,BDD2,BDD1,Rest).

process_body([H|T],BDD,BDD1,
[H1,myand(BDD,BDDH,BDD2)|Rest]):-
	add_bdd_arg(H,BDDH,H1),
	process_body(T,BDD2,BDD1,Rest).


and_list([],B,B).
and_list([H|T],B0,B1):-
	and(B0,H,B2),
	and_list(T,B2,B1).

or_list([H],H):-!.

or_list([H|T],B):-
	or_list1(T,H,B).
		
or_list1([],B,B).
or_list1([H|T],B0,B1):-
	myor(B0,H,B2),
	or_list1(T,B2,B1).

/* set(Par,Value) can be used to set the value of a parameter */
set(Parameter,Value):-
	retract(setting(Parameter,_)),
	assert(setting(Parameter,Value)).



extract_vars(Variable, Var0, Var1) :- 
	var(Variable), !, 
	(member_eq(Variable, Var0) ->
		Var1 = Var0;
		append(Var0, [Variable], Var1)).

extract_vars(Term, Var0, Var1) :- 
	Term=..[_F|Args], 
	extract_vars_list(Args, Var0, Var1).



extract_vars_list([], Var, Var).

extract_vars_list([Term|Tail], Var0, Var1) :- 
	extract_vars(Term, Var0, Var), 
	extract_vars_list(Tail, Var, Var1).


difference([],_,[]).

difference([H|T],L2,L3):-
	member_eq(H,L2),!,
	difference(T,L2,L3).
	
difference([H|T],L2,[H|L3]):-
	difference(T,L2,L3).
	
add_bdd_arg(A,BDD,A1):-
	A=..[P|Args],
	append(Args,[BDD],Args1),
	A1=..[P|Args1],
	functor(A1,_,Arity),
	('$p'(P,Arity)->
		true
	;
		assert('$p'(P,Arity))
	).

add_bdd_arg_extra(A,BDD,A1,Cl):-
	A=..[P|Args],
	append(Args,[BDD],Args1),
	atom_concat(P,'$',P1),
	functor(A,_,Arity),
	A1=..[P1|Args1],
	(p(P,Arity)->
		Cl=[]
	;
		assert(p(P,Arity)),
		length(L,Arity),
		append(L,[B],L1),
		Head=..[P1|L1],
		append(L,[B1],L2),
		Body=..[P|L2],
		Cl=[(Head:- (bagof(B1,Body,List),or_list(List,B)))],
		(setting(tabling,on)->
			table_pred(A),
			A2=..[P1|Args],
			table_pred(A2)
		;
			true
		)
	).

table_pred(A):-	
	functor(A,P,Arity),
	Arity1 is Arity +1,
	functor(A1,P,Arity1),
	A1=..[_|Args],
	last(Args,myor/3-myzero/1),
	(setting(tabling_output,call)->
		call(table(A1))
	;
		write((:- table A1)),
		writeln('.')
	).

table_dir(P,Arity,Atom):-
        functor(Atom,P,Arity),
        Atom=..[_|Args],
        last(Args,myor/3-myzero/1).

last([H],H):-!.

last([_H|T],L):-
	last(T,L).

process_head([Head:ProbHead], [Head:ProbH,'':ProbLast]) :-
	ProbH is ProbHead,
	ProbLast is 1 - ProbH.

get_probs([], []).

get_probs([_H:P|T], [P1|T1]) :- 
	P1 is P, 
	get_probs(T, T1).

load(File):-
        atom_concat(File,'_poss.P',FileP),
        atom_concat(File,'.cpl',FileCpl),
        parse(FileCpl,FileP),
        consult(FileP).

parse(FileIn,FileOut):-
        retractall('$p'(_,_)),
        open(FileIn,read,SI),
        read_clauses(SI,C),
        close(SI),
        set(compiling,true),
        process_clauses(C,[],C1),
        set(compiling,false),
        open(FileOut,write,SO),
        findall(p(P,A),'$p'(P,A),L),
	write(SO,':- compiler_options([spec_off]).'),nl(SO),
        write_tab_dir(L,SO),
        write_clauses(C1,SO),
        close(SO).

process_clauses([end_of_file],C,C).

process_clauses([H|T],C0,C1):-
	(term_expansion(H,H1)->
		true
	;
		H1=H
	),
	(H1=[_|_]->
		append(C0,H1,C2)
	;
		append(C0,[H1],C2)
	),
	process_clauses(T,C2,C1).

read_clauses(S,[Cl|Out]):-
        read_term(S,Cl,[]),
	(Cl=end_of_file->
		Out=[]
	;
		read_clauses(S,Out)
	).
/* output predicates */
write_tab_dir([],S):-
        nl(S).

write_tab_dir([p(P,A)|T],S):-
        table_dir(P,A,Atom),
        write(S,':-table '),
        writeq(S,Atom),
        write(S,'.'),
        nl(S),
        write_tab_dir(T,S).

write_clauses(List,Stream):-
	(setting(pretty_print,true) ->
	   write_clauses_pretty(List,Stream)
 	 ; write_clauses_plain(List,Stream) ).
  
write_clauses_plain([],_).
write_clauses_plain([H|T],S):-
	writeq(S,H),
	write(S,'.'),
	nl(S),
	write_clauses_plain(T,S).

:- import pretty_print/2 from pretty_print.
write_clauses_pretty([],_).
write_clauses_pretty([H|T],S):-
	pretty_print(S,H),
	nl(S),
	write_clauses_pretty(T,S).

term_expansion((Head :- Body), Clauses) :- 
% disjunctive clause with a single head atom
	setting(compiling,true),
	((Head:-Body) \= ((user:term_expansion(_,_) ):- _ )),
	Head = (H:_), !, 
	list2or(HeadListOr, Head), 
	process_head(HeadListOr, HeadList), 
	list2and(BodyList, Body), 
	process_body(BodyList,One,BDDAnd,BodyList2),
	list2and(BodyList2,Body2),
	get_probs(HeadList,Probs),
	generate_clause(H,(myone(One),Body2),Probs,BDDAnd,0,Clauses).


term_expansion((Head :- Body),Clauses) :- 
% definite clause
	setting(compiling,true),
	((Head:-Body) \= ((user:term_expansion(_,_)) :- _ )),!,
	list2and(BodyList, Body), 
	process_body_def(BodyList,One,BDD,BodyList2),
	list2and(BodyList2,Body2),
	add_bdd_arg(Head,BDD,Head1),
	Clauses=(Head1 :- myone(One),Body2).
	
term_expansion(Head,Clause) :- 
% disjunctive fact with a single head atom
	setting(compiling,true),
	(Head \= ((term_expansion(_,_)) :- _ )),
	Head = (H:_), !, 
	list2or(HeadListOr, Head), 
	process_head(HeadListOr, HeadList),
	get_probs(HeadList,Probs),
	add_bdd_arg(H,BDD,Head1),
	Clause=(Head1:-(myequality(Probs,0,BDD))).

term_expansion(Head, (Head1:-myone(One))) :- 
% definite fact
	setting(compiling,true),
	(Head \= ((term_expansion(_,_) ):- _ )),
	Head \= (:- table _ ),
	Head \= (:- import _),
	(Head\= end_of_file),!,
	add_bdd_arg(Head,One,Head1).

