/* File:      plmchshell.P
** Author(s): Jin Yu
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1998
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**      http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
** 
*/


%------------------------------------------------------------------------------
% This module imports all the external C functions, and loads the compiler
% configuration module. 
%
%------------------------------------------------------------------------------

%------------------------------------------------------------------------------
% import XSB-Perl C interface
%------------------------------------------------------------------------------

:- export bulk_match__/3, get_match_result__/2.

:- import do_bulk_match__/3, get_match_resultC__/2,
	  get_bulk_match_result__/3, do_bulk_match__/3
   from xsbpattern. 

% configure package is necessary (construct xsbpattern.H and compile)
:- [plmchconfig].


%-----------------------------------------------------------------------------
% bulk matching
%
% output is a list.
%-----------------------------------------------------------------------------

bulk_match__(Str,Pattern,List) :-
	do_bulk_match__(Str,Pattern,NumOfMatches), 
        get_list(NumOfMatches,NumOfMatches,List).          
%% Collect all matches into a list
get_list(0,0,[]).
get_list(NumOfMatches,0,[]) :-
        NumOfMatches > 0.
get_list(NumOfMatches, Counter, [MatchVal | Rest]) :-
	Counter > 0,
	Counter1 is Counter - 1,
        MatchSeqNumber is NumOfMatches - Counter, 
	%% we need to pass NumOfMatches so get_bulk_match_result__ will
	%% know when to stop and not coredump
	get_bulk_match_result__( MatchSeqNumber, MatchVal, NumOfMatches ),
        get_list(NumOfMatches, Counter1, Rest).  
         

%-----------------------------------------------------------------------------
% get_match_result__
%
% Getting the perl pattern match results:
%	$1,$2,...:input is the digital number,
%  	PREMATCH,MATCH,POSTMATCH, LAST_PAREN_MATCH:
%		 input is the atom,
% This uses the following mapping:
%	MATCH --> -1
%       PREMATCH --> -2
%	POSTMATCH --> -3
%	LAST_PAREN_MATCH --> -4  
%-----------------------------------------------------------------------------

get_match_result__(A,X) :- 
	integer(A),
	A>0,
	get_match_resultC__(A,X).
get_match_result__(match,X) :- 
     	get_match_resultC__(-1,X).
get_match_result__(prematch,X) :- 
	get_match_resultC__(-2,X).
get_match_result__(postmatch,X) :-
	get_match_resultC__(-3,X).
get_match_result__(last_paren_match,X) :- 
	get_match_resultC__(-4,X).
get_match_result__(A,X) :- 
	integer(A), 
	A<0, 
	X = 0,
	fail.
get_match_result__(A,X) :- 
	not integer(A), 
	X = 0,
	fail.
