/* File:      directory.P
** Author(s): Swift
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1998
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: directry.P,v 1.19 2010-08-19 15:03:38 spyrosh Exp $
** 
*/


:- export
	 short_directory/2,
	 find_file/1,
	 get_file_name/2, get_file_date/2,
	 is_directory/1,
	 whats_new/3,
	 split_dirs/3,
	 rel_path/2, rel_path/3,
	 canonical_pathname/2.

:- import  ca/2, date/1, sysin/2 from scrptutl.
:- import concat_atom/2, concat_atom/3 from string.
:- import member/2, ground/1 from basics.
:- import atom_codes/2, arg/3, number_codes/2, name/2, integer/1,
	throw/1, atom/1, \= /2
	from standard.
:- import cwd/1, cd/1 from shell.

:- import flatten/2 from basics.

:- import slash/1 from machine.

:- import writeln/1 from standard.

:- import 'C'/3 from dcg.
:- import list_directory/2 from shell.

% I always want this in UNIX.
:- mode whats_new(+,+,?).
whats_new(Directory,Date,List):-
	directory(Directory,List1),
	transform_date(Date,Date1),
	date_filter(List1,Date1,List).

transform_date(date(Y,M_in,D,H,Mi,S),date(Y,M,D,H,Mi,S)):-
	(integer(M_in) -> M = M_in ; month(M_in,M)).
transform_date(date(Y,M_in,D),date(Y,M,D,0,0,0)):-
	(integer(M_in) -> M = M_in ; month(M_in,M)).

month('Jan',0).
month('Feb',1).
month('Mar',2).
month('Apr',3).
month('May',4).
month('Jun',5).
month('Jul',6).
month('Aug',7).
month('Sep',8).
month('Oct',9).
month('Nov',10).
month('Dec',11).

date_filter([],_,[]).
date_filter([Entry|Rest],Date,[Entry|Rest1]):-
	get_file_date(Entry,Edate),
	dt_gt(Edate,Date),!,
	date_filter(Rest,Date,Rest1).
date_filter([_Entry|Rest],Date,Rest1):-
	date_filter(Rest,Date,Rest1).
	
dt_gt(Date1,Date2):- Date1 @> Date2.


% replicates some functionality of unix find command.
:- mode find_file(?).
find_file(File):-
	find_file_1('.',File).
	
find_file_1(Argument,File):- 
	directory(Argument,Dir),
	member(File1,Dir),
	(is_directory(File1) -> 
		get_file_name(File1,File2),
		concat_atom([Argument,'/',File2],Newarg),
		find_file_1(Newarg,File)
	; 
	 	File = File1).

:- mode get_file_name(+,?).
get_file_name(File,Name):- arg(7,File,Name).

:- mode get_file_date(+,?).
get_file_date(File,Date):- arg(6,File,Date).

:- mode is_directory(+).
is_directory(File):-
	arg(1,File,Permissions),
	atom(Permissions),
	atom_codes(Permissions,[100|_]).

directory(Argument,Dir):-
	writeln(directory_called),
	ca(['ls -l',Argument],Command),
	sysin(Command,List),
	date(date(Year,Month,Day,_,_,_)),
	directory_1(List,date(Year,Month,Day),Dir).

:- mode short_directory(+,?).
short_directory(Arg,Out) :-
	list_directory(Arg,Out).

% short_directory(Arg,Out):-
% 	(   xsb_configuration(host_os,windows)
% 	->  ca(['dir /B ',Arg], Command)
% 	;   ca(['\ls',Arg],Command)
% 	),
% 	sysin(Command,List1),
% 	member(L,List1),
% 	concat_atom(L,' ',Out).

directory_1([],_,[]):-!.
directory_1([H|T],Year,List):-!,
	process_toklist(H,Year,Entry),
	(Entry == [] -> List = T1 ; List = [Entry|T1]),
	directory_1(T,Year,T1).

process_toklist([Permissions,Links,Owner,Group,Size,
					 Month,Date,TY|N],Year,
		entry(Permissions,Links,Owner,Group,Size,Dateout,Name)):-!,
	process_date(Year,Month,Date,TY,Dateout),
	process_name(N,Name).
process_toklist(_,_,[]).

process_name([Name],Name):-!.
process_name([One,'->',Two],'->'(One,Two)):-!.
process_name(List,List).

process_date(date(Tyear,Tmonth,Tday),
			M_in,D,TY,date(Year,Month,D,Hour,Min,0)):- 
	name(TY,[H1,H2,58,M1,M2]),!,
	month(M_in,Month),
%	aton(D,Day),
	number_codes(Hour,[H1,H2]),
	number_codes(Min,[M1,M2]),
	(d(Month,D) @> d(Tmonth,Tday) 
		-> Year is Tyear-1 ; Year = Tyear).
process_date(_,M_in,D,Y,date(Y,Month,D,0,0,0)):- 
%	aton(Y,Year),
	month(M_in,Month).
%	aton(D,Day)

%process_time_year(TY,time(Hour,Minute)):- 
%	name(TY,[H1,H2,58,M1,M2]),!,
%	number_codes(Hour,[H1,H2]),
%	number_codes(Minute,[M1,M2]).
%process_time_year(TY,year(TY1)):- aton(TY,TY1).

:- mode canonical_pathname(+,?).
canonical_pathname(Path,CPath) :-
	(   var(CPath),
	    ground(Path)
	->  cwd(OldCWD),
%	    sys_chdir(Path,_),
	    cd(Path),
	    cwd(CPath),
%	    sys_chdir(OldCWD,_)
	    cd(OldCWD)
	;   throw(instantiation_error(canonical_pathname(Path,CPath)))
	).


%% split_dirs(+Path,-Drive,-LDirs)
%% accepts a (canonical) path, and returns the list of directories
%% that form the path.
:- mode split_dirs(+,?,?).
split_dirs(Path,Drive,LDirs) :-
	(   atom(Path)
	->  atom_codes(Path,CPath)
	;   CPath = Path
	),
	path(Drive,LDirs,CPath,[]),
	!.

path(Drive,LDirs) -->
	disk(Drive),
	!,
	dirs(LDirs).
path([],LDirs) -->
	dirs(LDirs).
path([],[Dir|LDirs]) -->
	dir(DirL),
	dirs(LDirs),
	{ground(DirL),atom_codes(Dir,DirL)}.

disk(Drive) -->
	[LDrive], ":",
	{(LDrive > 90 -> LDriveUC is LDrive - 32 ; integer(LDrive),LDriveUC = LDrive),
	 atom_codes(Drive,[LDriveUC])}.

dirs([]) --> opt_slash, [].
dirs([Dir|Dirs]) -->
	slash,
	dir(LDir),
	dirs(Dirs),
	{ground(LDir),atom_codes(Dir,LDir)}.

slash --> [92], opt_slash. % 0'\
slash --> [47], opt_slash. % 0'/

opt_slash --> slash.
opt_slash --> [].

dir([X]) --> letter(X).
dir([X|Y]) --> letter(X), dir(Y).

letter(X) --> [X], {X \= 92, X \= 47, X \= 58}.

%% rel_path(+Dest, -RelPath) makes filename +Dest relative to the
%%  current directory
:- mode rel_path(+,?).
rel_path(Dest, RelPath) :-
	cwd(Orig),
	rel_path(Orig, Dest, RelPath).

%% rel_path(+Orig, +Dest, -RelPath)
%% Makes RelPath a relative path to Dest from Orig. If drive names are
%% given, and they are different, RelPath = Dest.
:- mode rel_path(+,+,?).
rel_path(Orig, Dest, RelPath) :-
	split_dirs(Orig,ODrive,ODirs),
	split_dirs(Dest,DDrive,DDirs),
	(   ODrive = DDrive
	->  make_relative(ODirs,DDirs,RelPath)
	;   RelPath = Dest
	).

make_relative([],[],'.') :- !.
make_relative([],D,CD) :- !,
	slash(Slash),
	concat_atom(D,Slash,CD).
make_relative(O,[],R) :- !,
	down_n(O,Dots),
	slash(Slash),
	concat_atom(Dots,Slash,R).
make_relative([H|O],[H|D],R) :- !,
	make_relative(O,D,R).
make_relative(O,D,R) :-
	down_n(O,Dots),
	flatten([Dots,D],LPath),
	slash(Slash),
	concat_atom(LPath,Slash,R).

down_n([],[]) :- !.
down_n([_H|T],['..'|TT]) :-
	down_n(T,TT).

