/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQuick module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#version 150 core

in vec2 sampleCoord;
in vec2 shiftedSampleCoord;

out vec4 fragColor;

uniform sampler2D _qt_texture;
uniform vec4 color;
uniform vec4 styleColor;
uniform float alphaMin;
uniform float alphaMax;

void main()
{
    float a = smoothstep(alphaMin, alphaMax, texture(_qt_texture, sampleCoord).r);
    vec4 shifted = styleColor * smoothstep(alphaMin, alphaMax,
                                           texture(_qt_texture, shiftedSampleCoord).r);
    fragColor = mix(shifted, color, a);
}