/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram.ditaa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.asciidoctor.diagram.DiagramGeneratorFunction;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;
import org.stathissideris.ditaa.core.ConversionOptions;
import org.stathissideris.ditaa.core.RenderingOptions;
import org.stathissideris.ditaa.graphics.BitmapRenderer;
import org.stathissideris.ditaa.graphics.Diagram;
import org.stathissideris.ditaa.graphics.SVGRenderer;
import org.stathissideris.ditaa.text.TextGrid;

public class Ditaa
implements DiagramGeneratorFunction {
    public static final MimeType DEFAULT_OUTPUT_FORMAT = MimeType.PNG;
    public static final MimeType DEFAULT_CONTENT_TYPE = MimeType.TEXT_PLAIN_UTF8;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public ResponseData generate(Request request) throws IOException {
        String optionString;
        MimeType format = (MimeType)request.headers.getValue(HTTPHeader.ACCEPT);
        if (format == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (!format.equals((Object)MimeType.PNG) && !format.equals((Object)MimeType.SVG)) {
            throw new IOException("Unsupported output format: " + format);
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("--encoding");
        options.add(StandardCharsets.UTF_8.name());
        if (format.equals((Object)MimeType.SVG)) {
            options.add("--svg");
        }
        if ((optionString = (String)request.headers.getValue(HTTPHeader.OPTIONS)) != null) {
            options.addAll(Arrays.asList(optionString.split(" ")));
        }
        ConversionOptions conversionOptions = ConversionOptions.parseCommandLineOptions((String[])options.toArray(new String[0]));
        ByteArrayInputStream input = new ByteArrayInputStream(request.asString().getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Ditaa.doConvert(input, output, conversionOptions);
        output.close();
        return new ResponseData(format, output.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doConvert(InputStream input, OutputStream output, ConversionOptions options) throws IOException {
        Diagram diagram = Ditaa.convertToImage(input, options);
        RenderingOptions.ImageType imageType = options.renderingOptions.getImageType();
        if (imageType == RenderingOptions.ImageType.SVG) {
            String content = new SVGRenderer().renderToImage(diagram, options.renderingOptions);
            OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);
            try {
                writer.write(content);
            }
            finally {
                writer.flush();
            }
        } else {
            BufferedImage image = new BitmapRenderer().renderToImage(diagram, options.renderingOptions);
            MemoryCacheImageOutputStream memCache = new MemoryCacheImageOutputStream(output);
            ImageIO.write((RenderedImage)image, imageType.getFormatName(), memCache);
            memCache.flush();
        }
    }

    private static Diagram convertToImage(InputStream input, ConversionOptions options) throws IOException {
        TextGrid grid = new TextGrid();
        if (options.processingOptions.getCustomShapes() != null) {
            grid.addToMarkupTags(options.processingOptions.getCustomShapes().keySet());
        }
        grid.loadFrom(input, options.processingOptions);
        if (options.processingOptions.printDebugOutput()) {
            grid.printDebug(System.out);
        }
        return new Diagram(grid, options);
    }
}

