"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNNAMED_LOCATION = exports.SYNTHETIC_CHECK_STEPS_ROUTE = exports.STEP_DETAIL_ROUTE = exports.STATUS = exports.SHORT_TS_LOCALE = exports.SHORT_TIMESPAN_LOCALE = exports.SETTINGS_ROUTE = exports.OVERVIEW_ROUTE = exports.MONITOR_TYPES = exports.MONITOR_ROUTE = exports.ML_MODULE_ID = exports.ML_JOB_ID = exports.MAPPING_ERROR_ROUTE = exports.KQL_SYNTAX_LOCAL_STORAGE = exports.FILTER_FIELDS = exports.CERT_STATUS = exports.CERTIFICATES_ROUTE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_ROUTE = exports.MONITOR_ROUTE = '/monitor/:monitorId?';
const OVERVIEW_ROUTE = exports.OVERVIEW_ROUTE = '/';
const SETTINGS_ROUTE = exports.SETTINGS_ROUTE = '/settings';
const CERTIFICATES_ROUTE = exports.CERTIFICATES_ROUTE = '/certificates';
const STEP_DETAIL_ROUTE = exports.STEP_DETAIL_ROUTE = '/journey/:checkGroupId/step/:stepIndex';
const SYNTHETIC_CHECK_STEPS_ROUTE = exports.SYNTHETIC_CHECK_STEPS_ROUTE = '/journey/:checkGroupId/steps';
const MAPPING_ERROR_ROUTE = exports.MAPPING_ERROR_ROUTE = '/mapping-error';
let STATUS = exports.STATUS = /*#__PURE__*/function (STATUS) {
  STATUS["UP"] = "up";
  STATUS["DOWN"] = "down";
  STATUS["COMPLETE"] = "complete";
  STATUS["FAILED"] = "failed";
  STATUS["SKIPPED"] = "skipped";
  return STATUS;
}({});
let MONITOR_TYPES = exports.MONITOR_TYPES = /*#__PURE__*/function (MONITOR_TYPES) {
  MONITOR_TYPES["HTTP"] = "http";
  MONITOR_TYPES["TCP"] = "tcp";
  MONITOR_TYPES["ICMP"] = "icmp";
  MONITOR_TYPES["BROWSER"] = "browser";
  return MONITOR_TYPES;
}({});
const ML_JOB_ID = exports.ML_JOB_ID = 'high_latency_by_geo';
const ML_MODULE_ID = exports.ML_MODULE_ID = 'uptime_heartbeat';
const UNNAMED_LOCATION = exports.UNNAMED_LOCATION = 'Unnamed-location';
const SHORT_TS_LOCALE = exports.SHORT_TS_LOCALE = 'en-short-locale';
const SHORT_TIMESPAN_LOCALE = exports.SHORT_TIMESPAN_LOCALE = {
  relativeTime: {
    future: 'in %s',
    past: '%s ago',
    s: '%ds',
    ss: '%ss',
    m: '%dm',
    mm: '%dm',
    h: '%dh',
    hh: '%dh',
    d: '%dd',
    dd: '%dd',
    M: '%d Mon',
    MM: '%d Mon',
    y: '%d Yr',
    yy: '%d Yr'
  }
};
let CERT_STATUS = exports.CERT_STATUS = /*#__PURE__*/function (CERT_STATUS) {
  CERT_STATUS["OK"] = "OK";
  CERT_STATUS["EXPIRING_SOON"] = "EXPIRING_SOON";
  CERT_STATUS["EXPIRED"] = "EXPIRED";
  CERT_STATUS["TOO_OLD"] = "TOO_OLD";
  return CERT_STATUS;
}({});
const KQL_SYNTAX_LOCAL_STORAGE = exports.KQL_SYNTAX_LOCAL_STORAGE = 'xpack.uptime.kql.syntax';
const FILTER_FIELDS = exports.FILTER_FIELDS = {
  TAGS: 'tags',
  PORT: 'url.port',
  LOCATION: 'observer.geo.name',
  TYPE: 'monitor.type'
};