"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelinesQuerySchema = exports.getTimelinesArgsSchema = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _timeline = require("../../../../../common/types/timeline");
var _utility_types = require("../../../../../common/utility_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BoolFromString = rt.union([rt.literal('true'), rt.literal('false')]);
const getTimelinesQuerySchema = exports.getTimelinesQuerySchema = rt.partial({
  only_user_favorite: (0, _utility_types.unionWithNullType)(BoolFromString),
  page_index: (0, _utility_types.unionWithNullType)(rt.string),
  page_size: (0, _utility_types.unionWithNullType)(rt.string),
  search: (0, _utility_types.unionWithNullType)(rt.string),
  sort_field: _timeline.sortFieldTimeline,
  sort_order: _timeline.direction,
  status: (0, _utility_types.unionWithNullType)(_timeline.TimelineStatusLiteralRt),
  timeline_type: (0, _utility_types.unionWithNullType)(_timeline.TimelineTypeLiteralRt)
});
const getTimelinesArgsSchema = exports.getTimelinesArgsSchema = rt.partial({
  onlyUserFavorite: (0, _utility_types.unionWithNullType)(BoolFromString),
  pageIndex: (0, _utility_types.unionWithNullType)(rt.string),
  pageSize: (0, _utility_types.unionWithNullType)(rt.string),
  search: (0, _utility_types.unionWithNullType)(rt.string),
  sortField: _timeline.sortFieldTimeline,
  sortOrder: _timeline.direction,
  status: (0, _utility_types.unionWithNullType)(_timeline.TimelineStatusLiteralRt),
  timelineType: (0, _utility_types.unionWithNullType)(_timeline.TimelineTypeLiteralRt)
});