"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRedirectAppPath = exports.USES_HEADLESS_JOB_TYPES = exports.UNVERSIONED_VERSION = exports.UI_SETTINGS_SEARCH_INCLUDE_FROZEN = exports.UI_SETTINGS_DATEFORMAT_TZ = exports.UI_SETTINGS_CUSTOM_PDF_LOGO = exports.UI_SETTINGS_CSV_SEPARATOR = exports.UI_SETTINGS_CSV_QUOTE_VALUES = exports.REPORT_TABLE_ROW_ID = exports.REPORT_TABLE_ID = exports.REPORTING_TRANSACTION_TYPE = exports.REPORTING_REDIRECT_LOCATOR_STORE_KEY = exports.REPORTING_MANAGEMENT_HOME = exports.PNG_REPORT_TYPE_V2 = exports.PNG_REPORT_TYPE = exports.PNG_JOB_TYPE_V2 = exports.PNG_JOB_TYPE = exports.PLUGIN_ID = exports.PDF_REPORT_TYPE_V2 = exports.PDF_REPORT_TYPE = exports.PDF_JOB_TYPE_V2 = exports.PDF_JOB_TYPE = exports.LICENSE_TYPE_TRIAL = exports.LICENSE_TYPE_PLATINUM = exports.LICENSE_TYPE_GOLD = exports.LICENSE_TYPE_ENTERPRISE = exports.LICENSE_TYPE_CLOUD_STANDARD = exports.LICENSE_TYPE_BASIC = exports.LAYOUT_TYPES = exports.KBN_SCREENSHOT_HEADER_BLOCK_LIST_STARTS_WITH_PATTERN = exports.KBN_SCREENSHOT_HEADER_BLOCK_LIST = exports.JOB_STATUSES = exports.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = exports.ILM_POLICY_NAME = exports.DEPRECATED_JOB_TYPES = exports.DEFAULT_VIEWPORT = exports.CSV_SEARCHSOURCE_IMMEDIATE_TYPE = exports.CSV_SAVED_OBJECT_JOB_TYPE = exports.CSV_REPORT_TYPE_DEPRECATED = exports.CSV_REPORT_TYPE = exports.CSV_REPORTING_ACTION = exports.CSV_JOB_TYPE_DEPRECATED = exports.CSV_JOB_TYPE = exports.CSV_FORMULA_CHARS = exports.CSV_BOM_CHARS = exports.CONTENT_TYPE_CSV = exports.API_MIGRATE_ILM_POLICY_URL = exports.API_LIST_URL = exports.API_GET_ILM_POLICY_STATUS = exports.API_GENERATE_IMMEDIATE = exports.API_DIAGNOSE_URL = exports.API_BASE_URL_V1 = exports.API_BASE_URL = exports.API_BASE_GENERATE = exports.ALLOWED_JOB_CONTENT_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'reporting';
const REPORTING_TRANSACTION_TYPE = exports.REPORTING_TRANSACTION_TYPE = PLUGIN_ID;
const JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = exports.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = 'xpack.reporting.jobCompletionNotifications';
const CONTENT_TYPE_CSV = exports.CONTENT_TYPE_CSV = 'text/csv';
const CSV_REPORTING_ACTION = exports.CSV_REPORTING_ACTION = 'downloadCsvReport';
const CSV_BOM_CHARS = exports.CSV_BOM_CHARS = '\ufeff';
const CSV_FORMULA_CHARS = exports.CSV_FORMULA_CHARS = ['=', '+', '-', '@'];
const ALLOWED_JOB_CONTENT_TYPES = exports.ALLOWED_JOB_CONTENT_TYPES = ['application/json', 'application/pdf', CONTENT_TYPE_CSV, 'image/png', 'text/plain'];

// See:
// https://github.com/chromium/chromium/blob/3611052c055897e5ebbc5b73ea295092e0c20141/services/network/public/cpp/header_util_unittest.cc#L50
// For a list of headers that chromium doesn't like
const KBN_SCREENSHOT_HEADER_BLOCK_LIST = exports.KBN_SCREENSHOT_HEADER_BLOCK_LIST = ['accept-encoding', 'connection', 'content-length', 'content-type', 'host', 'referer',
// `Transfer-Encoding` is hop-by-hop header that is meaningful
// only for a single transport-level connection, and shouldn't
// be stored by caches or forwarded by proxies.
'transfer-encoding', 'trailer', 'te', 'upgrade', 'keep-alive'];
const KBN_SCREENSHOT_HEADER_BLOCK_LIST_STARTS_WITH_PATTERN = exports.KBN_SCREENSHOT_HEADER_BLOCK_LIST_STARTS_WITH_PATTERN = ['proxy-'];
const UI_SETTINGS_SEARCH_INCLUDE_FROZEN = exports.UI_SETTINGS_SEARCH_INCLUDE_FROZEN = 'search:includeFrozen';
const UI_SETTINGS_CUSTOM_PDF_LOGO = exports.UI_SETTINGS_CUSTOM_PDF_LOGO = 'xpackReporting:customPdfLogo';
const UI_SETTINGS_CSV_SEPARATOR = exports.UI_SETTINGS_CSV_SEPARATOR = 'csv:separator';
const UI_SETTINGS_CSV_QUOTE_VALUES = exports.UI_SETTINGS_CSV_QUOTE_VALUES = 'csv:quoteValues';
const UI_SETTINGS_DATEFORMAT_TZ = exports.UI_SETTINGS_DATEFORMAT_TZ = 'dateFormat:tz';
const LAYOUT_TYPES = exports.LAYOUT_TYPES = {
  CANVAS: 'canvas',
  PRESERVE_LAYOUT: 'preserve_layout',
  PRINT: 'print'
};
const DEFAULT_VIEWPORT = exports.DEFAULT_VIEWPORT = {
  width: 1950,
  height: 1200,
  deviceScaleFactor: 1
};

// Export Type Definitions
const CSV_SAVED_OBJECT_JOB_TYPE = exports.CSV_SAVED_OBJECT_JOB_TYPE = 'csv_saved_object';
const CSV_REPORT_TYPE = exports.CSV_REPORT_TYPE = 'CSV';
const CSV_JOB_TYPE = exports.CSV_JOB_TYPE = 'csv_searchsource';
const PDF_REPORT_TYPE = exports.PDF_REPORT_TYPE = 'printablePdf';
const PDF_REPORT_TYPE_V2 = exports.PDF_REPORT_TYPE_V2 = 'printablePdfV2';
const PDF_JOB_TYPE = exports.PDF_JOB_TYPE = 'printable_pdf';
const PDF_JOB_TYPE_V2 = exports.PDF_JOB_TYPE_V2 = 'printable_pdf_v2';
const PNG_REPORT_TYPE = exports.PNG_REPORT_TYPE = 'PNG';
const PNG_REPORT_TYPE_V2 = exports.PNG_REPORT_TYPE_V2 = 'pngV2';
const PNG_JOB_TYPE = exports.PNG_JOB_TYPE = 'PNG';
const PNG_JOB_TYPE_V2 = exports.PNG_JOB_TYPE_V2 = 'PNGV2';
const CSV_SEARCHSOURCE_IMMEDIATE_TYPE = exports.CSV_SEARCHSOURCE_IMMEDIATE_TYPE = 'csv_searchsource_immediate';

// This is deprecated because it lacks support for runtime fields
// but the extension points are still needed for pre-existing scripted automation, until 8.0
const CSV_REPORT_TYPE_DEPRECATED = exports.CSV_REPORT_TYPE_DEPRECATED = 'CSV';
const CSV_JOB_TYPE_DEPRECATED = exports.CSV_JOB_TYPE_DEPRECATED = 'csv';
const USES_HEADLESS_JOB_TYPES = exports.USES_HEADLESS_JOB_TYPES = [PDF_JOB_TYPE, PNG_JOB_TYPE];
const DEPRECATED_JOB_TYPES = exports.DEPRECATED_JOB_TYPES = [CSV_JOB_TYPE_DEPRECATED];

// Licenses
const LICENSE_TYPE_TRIAL = exports.LICENSE_TYPE_TRIAL = 'trial';
const LICENSE_TYPE_BASIC = exports.LICENSE_TYPE_BASIC = 'basic';
const LICENSE_TYPE_CLOUD_STANDARD = exports.LICENSE_TYPE_CLOUD_STANDARD = 'standard';
const LICENSE_TYPE_GOLD = exports.LICENSE_TYPE_GOLD = 'gold';
const LICENSE_TYPE_PLATINUM = exports.LICENSE_TYPE_PLATINUM = 'platinum';
const LICENSE_TYPE_ENTERPRISE = exports.LICENSE_TYPE_ENTERPRISE = 'enterprise';

// Routes
const API_BASE_URL = exports.API_BASE_URL = '/api/reporting'; // "Generation URL" from share menu
const API_BASE_GENERATE = exports.API_BASE_GENERATE = `${API_BASE_URL}/generate`;
const API_LIST_URL = exports.API_LIST_URL = `${API_BASE_URL}/jobs`;
const API_DIAGNOSE_URL = exports.API_DIAGNOSE_URL = `${API_BASE_URL}/diagnose`;
const API_GET_ILM_POLICY_STATUS = exports.API_GET_ILM_POLICY_STATUS = `${API_BASE_URL}/ilm_policy_status`;
const API_MIGRATE_ILM_POLICY_URL = exports.API_MIGRATE_ILM_POLICY_URL = `${API_BASE_URL}/deprecations/migrate_ilm_policy`;
const API_BASE_URL_V1 = exports.API_BASE_URL_V1 = '/api/reporting/v1'; //

const ILM_POLICY_NAME = exports.ILM_POLICY_NAME = 'kibana-reporting';

// Management UI route
const REPORTING_MANAGEMENT_HOME = exports.REPORTING_MANAGEMENT_HOME = '/app/management/insightsAndAlerting/reporting';
const REPORTING_REDIRECT_LOCATOR_STORE_KEY = exports.REPORTING_REDIRECT_LOCATOR_STORE_KEY = '__REPORTING_REDIRECT_LOCATOR_STORE_KEY__';

/**
 * A way to get the client side route for the reporting redirect app.
 *
 * TODO: Add a job ID and a locator to use so that we can redirect without expecting state to
 * be injected to the page
 */
const getRedirectAppPath = () => {
  return '/app/management/insightsAndAlerting/reporting/r';
};

// Statuses
exports.getRedirectAppPath = getRedirectAppPath;
let JOB_STATUSES = exports.JOB_STATUSES = /*#__PURE__*/function (JOB_STATUSES) {
  JOB_STATUSES["PENDING"] = "pending";
  JOB_STATUSES["PROCESSING"] = "processing";
  JOB_STATUSES["COMPLETED"] = "completed";
  JOB_STATUSES["FAILED"] = "failed";
  JOB_STATUSES["WARNINGS"] = "completed_with_warnings";
  return JOB_STATUSES;
}({}); // Test Subjects
const REPORT_TABLE_ID = exports.REPORT_TABLE_ID = 'reportJobListing';
const REPORT_TABLE_ROW_ID = exports.REPORT_TABLE_ROW_ID = 'reportJobRow';

// Job params require a `version` field as of 7.15.0. For older jobs set with
// automation that have no version value in the job params, we assume the
// intended version is 7.14.0
const UNVERSIONED_VERSION = exports.UNVERSIONED_VERSION = '7.14.0';

// hacky endpoint: download CSV without queueing a report
// FIXME: find a way to make these endpoints "generic" instead of hardcoded, as are the queued report export types
const API_GENERATE_IMMEDIATE = exports.API_GENERATE_IMMEDIATE = `${API_BASE_URL_V1}/generate/immediate/csv_searchsource`;