"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XPACK_DEFAULT_ADMIN_EMAIL_UI_SETTING = exports.USAGE_FETCH_INTERVAL = exports.TELEMETRY_QUERY_SOURCE = exports.TELEMETRY_METRIC_BUTTON_CLICK = exports.TELEMETRY_COLLECTION_INTERVAL = exports.STORAGE_KEY = exports.STANDALONE_CLUSTER_CLUSTER_UUID = exports.SORT_DESCENDING = exports.SORT_ASCENDING = exports.SAVED_OBJECT_TELEMETRY = exports.RULE_THREAD_POOL_WRITE_REJECTIONS = exports.RULE_THREAD_POOL_SEARCH_REJECTIONS = exports.RULE_REQUIRES_APP_CONTEXT = exports.RULE_PREFIX = exports.RULE_PANEL_MENU = exports.RULE_NODES_CHANGED = exports.RULE_MISSING_MONITORING_DATA = exports.RULE_MEMORY_USAGE = exports.RULE_LOGSTASH_VERSION_MISMATCH = exports.RULE_LICENSE_EXPIRATION = exports.RULE_LARGE_SHARD_SIZE = exports.RULE_KIBANA_VERSION_MISMATCH = exports.RULE_ELASTICSEARCH_VERSION_MISMATCH = exports.RULE_DISK_USAGE = exports.RULE_DETAILS = exports.RULE_CPU_USAGE = exports.RULE_CLUSTER_HEALTH = exports.RULE_CCR_READ_EXCEPTIONS = exports.RULES = exports.REPORTING_SYSTEM_ID = exports.NORMALIZED_DERIVATIVE_UNIT = exports.MONITORING_SYSTEM_API_VERSION = exports.MONITORING_CONFIG_ALERTING_EMAIL_ADDRESS = exports.ML_SUPPORTED_LICENSES = exports.METRICBEAT_INDEX_NAME_UNIQUE_TOKEN = exports.LOGSTASH_SYSTEM_ID = exports.LOGSTASH = exports.LOGGING_TAG = exports.LEGACY_RULE_DETAILS = exports.LEGACY_RULES = exports.KIBANA_SYSTEM_ID = exports.KIBANA_STATS_TYPE_MONITORING = exports.KIBANA_SETTINGS_TYPE = exports.KIBANA_MONITORING_LOGGING_TAG = exports.INFRA_SOURCE_ID = exports.INDEX_PATTERN_LOGSTASH = exports.INDEX_PATTERN_KIBANA = exports.INDEX_PATTERN_ELASTICSEARCH = exports.INDEX_PATTERN_BEATS = exports.INDEX_PATTERN = exports.INDEX_ALERTS = exports.FORMAT_DURATION_TEMPLATE_TINY = exports.FORMAT_DURATION_TEMPLATE_SHORT = exports.FORMAT_DURATION_TEMPLATE_LONG = exports.EUI_SORT_DESCENDING = exports.EUI_SORT_ASCENDING = exports.ELASTICSEARCH_SYSTEM_ID = exports.DEBOUNCE_SLOW_MS = exports.DEBOUNCE_FAST_MS = exports.CODE_PATH_ML = exports.CODE_PATH_LOGSTASH = exports.CODE_PATH_LOGS = exports.CODE_PATH_LICENSE = exports.CODE_PATH_KIBANA = exports.CODE_PATH_ELASTICSEARCH = exports.CODE_PATH_BEATS = exports.CODE_PATH_APM = exports.CODE_PATH_ALL = exports.CODE_PATH_ALERTS = exports.CLUSTER_DETAILS_FETCH_INTERVAL = exports.CLUSTER_ALERTS_SEARCH_SIZE = exports.CLUSTER_ALERTS_ADDRESS_CONFIG_KEY = exports.CHART_TEXT_COLOR = exports.CHART_LINE_COLOR = exports.CALCULATE_DURATION_UNTIL = exports.CALCULATE_DURATION_SINCE = exports.BEATS_SYSTEM_ID = exports.APM_SYSTEM_ID = exports.ALERT_EMAIL_SERVICES = exports.ALERT_ACTION_TYPE_LOG = exports.ALERT_ACTION_TYPE_EMAIL = void 0;
var _i18n = require("@kbn/i18n");
var _enums = require("./enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper string to add as a tag in every logging call
 */
const LOGGING_TAG = exports.LOGGING_TAG = 'monitoring';
/**
 * Helper string to add as a tag in every logging call related to Kibana monitoring
 */
const KIBANA_MONITORING_LOGGING_TAG = exports.KIBANA_MONITORING_LOGGING_TAG = 'kibana-monitoring';

/**
 * The Monitoring API version is the expected API format that we export and expect to import.
 * @type {string}
 */
const MONITORING_SYSTEM_API_VERSION = exports.MONITORING_SYSTEM_API_VERSION = '7';
/**
 * The type name used within the Monitoring index to publish Kibana ops stats.
 * @type {string}
 */
const KIBANA_STATS_TYPE_MONITORING = exports.KIBANA_STATS_TYPE_MONITORING = 'kibana_stats'; // similar to KIBANA_STATS_TYPE but rolled up into 10s stats from 5s intervals through ops_buffer
/**
 * The type name used within the Monitoring index to publish Kibana stats.
 * @type {string}
 */
const KIBANA_SETTINGS_TYPE = exports.KIBANA_SETTINGS_TYPE = 'kibana_settings';

/*
 * Key for the localStorage service
 */
const STORAGE_KEY = exports.STORAGE_KEY = 'xpack.monitoring.data';

/**
 * Units for derivative metric values
 */
const NORMALIZED_DERIVATIVE_UNIT = exports.NORMALIZED_DERIVATIVE_UNIT = '1s';

/*
 * Values for column sorting in table options
 * @type {number} 1 or -1
 */
const EUI_SORT_ASCENDING = exports.EUI_SORT_ASCENDING = 'asc';
const EUI_SORT_DESCENDING = exports.EUI_SORT_DESCENDING = 'desc';
const SORT_ASCENDING = exports.SORT_ASCENDING = 1;
const SORT_DESCENDING = exports.SORT_DESCENDING = -1;

/*
 * Chart colors
 * @type {string}
 */
const CHART_LINE_COLOR = exports.CHART_LINE_COLOR = '#d2d2d2';
const CHART_TEXT_COLOR = exports.CHART_TEXT_COLOR = '#9c9c9c';

/*
 * Number of cluster alerts to show on overview page
 * @type {number}
 */
const CLUSTER_ALERTS_SEARCH_SIZE = exports.CLUSTER_ALERTS_SEARCH_SIZE = 3;

/*
 * Format for moment-duration-format timestamp-to-duration template if the time diffs are gte 1 month
 * @type {string}
 */
const FORMAT_DURATION_TEMPLATE_LONG = exports.FORMAT_DURATION_TEMPLATE_LONG = 'M [months] d [days]';

/*
 * Format for moment-duration-format timestamp-to-duration template if the time diffs are lt 1 month but gt 1 minute
 * @type {string}
 */
const FORMAT_DURATION_TEMPLATE_SHORT = exports.FORMAT_DURATION_TEMPLATE_SHORT = ' d [days] h [hrs] m [min]';

/*
 * Format for moment-duration-format timestamp-to-duration template if the time diffs are lt 1 minute
 * @type {string}
 */
const FORMAT_DURATION_TEMPLATE_TINY = exports.FORMAT_DURATION_TEMPLATE_TINY = ' s [seconds]';

/*
 * Simple unique values for Timestamp to duration flags. These are used for
 * determining if calculation should be formatted as "time until" (now to
 * timestamp) or "time since" (timestamp to now)
 */
const CALCULATE_DURATION_SINCE = exports.CALCULATE_DURATION_SINCE = 'since';
const CALCULATE_DURATION_UNTIL = exports.CALCULATE_DURATION_UNTIL = 'until';

/**
 * In order to show ML Jobs tab in the Elasticsearch section / tab navigation, license must be supported
 */
const ML_SUPPORTED_LICENSES = exports.ML_SUPPORTED_LICENSES = ['trial', 'platinum', 'enterprise'];

/**
 * Constants used by Logstash monitoring code
 */
const LOGSTASH = exports.LOGSTASH = {
  MAJOR_VER_REQD_FOR_PIPELINES: 6,
  /*
   * Names ES keys on for different Logstash pipeline queues.
   * @type {string}
   */
  QUEUE_TYPES: {
    MEMORY: 'memory',
    PERSISTED: 'persisted'
  }
};
const DEBOUNCE_SLOW_MS = exports.DEBOUNCE_SLOW_MS = 17; // roughly how long it takes to render a frame at 60fps
const DEBOUNCE_FAST_MS = exports.DEBOUNCE_FAST_MS = 10; // roughly how long it takes to render a frame at 100fps

/**
 * Configuration key for setting the email address used for cluster alert notifications.
 */
const CLUSTER_ALERTS_ADDRESS_CONFIG_KEY = exports.CLUSTER_ALERTS_ADDRESS_CONFIG_KEY = 'cluster_alerts.email_notifications.email_address';
const STANDALONE_CLUSTER_CLUSTER_UUID = exports.STANDALONE_CLUSTER_CLUSTER_UUID = '__standalone_cluster__';
const INDEX_PATTERN = exports.INDEX_PATTERN = '.monitoring-*-6-*,.monitoring-*-7-*';
const INDEX_PATTERN_KIBANA = exports.INDEX_PATTERN_KIBANA = '.monitoring-kibana-6-*,.monitoring-kibana-7-*';
const INDEX_PATTERN_LOGSTASH = exports.INDEX_PATTERN_LOGSTASH = '.monitoring-logstash-6-*,.monitoring-logstash-7-*';
const INDEX_PATTERN_BEATS = exports.INDEX_PATTERN_BEATS = '.monitoring-beats-6-*,.monitoring-beats-7-*';
const INDEX_ALERTS = exports.INDEX_ALERTS = '.monitoring-alerts-6*,.monitoring-alerts-7*';
const INDEX_PATTERN_ELASTICSEARCH = exports.INDEX_PATTERN_ELASTICSEARCH = '.monitoring-es-6-*,.monitoring-es-7-*';

// This is the unique token that exists in monitoring indices collected by metricbeat
const METRICBEAT_INDEX_NAME_UNIQUE_TOKEN = exports.METRICBEAT_INDEX_NAME_UNIQUE_TOKEN = '-mb-';

// We use this for metricbeat migration to identify specific products that we do not have constants for
const ELASTICSEARCH_SYSTEM_ID = exports.ELASTICSEARCH_SYSTEM_ID = 'elasticsearch';

/**
 * The id of the infra source owned by the monitoring plugin.
 */
const INFRA_SOURCE_ID = exports.INFRA_SOURCE_ID = 'internal-stack-monitoring';

/*
 * These constants represent code paths within `getClustersFromRequest`
 * that an api call wants to invoke. This is meant as an optimization to
 * avoid unnecessary ES queries (looking at you logstash) when the data
 * is not used. In the long term, it'd be nice to have separate api calls
 * instead of this path logic.
 */
const CODE_PATH_ALL = exports.CODE_PATH_ALL = 'all';
const CODE_PATH_ALERTS = exports.CODE_PATH_ALERTS = 'alerts';
const CODE_PATH_KIBANA = exports.CODE_PATH_KIBANA = 'kibana';
const CODE_PATH_ELASTICSEARCH = exports.CODE_PATH_ELASTICSEARCH = 'elasticsearch';
const CODE_PATH_ML = exports.CODE_PATH_ML = 'ml';
const CODE_PATH_BEATS = exports.CODE_PATH_BEATS = 'beats';
const CODE_PATH_LOGSTASH = exports.CODE_PATH_LOGSTASH = 'logstash';
const CODE_PATH_APM = exports.CODE_PATH_APM = 'apm';
const CODE_PATH_LICENSE = exports.CODE_PATH_LICENSE = 'license';
const CODE_PATH_LOGS = exports.CODE_PATH_LOGS = 'logs';

/**
 * The header sent by telemetry service when hitting Elasticsearch to identify query source
 * @type {string}
 */
const TELEMETRY_QUERY_SOURCE = exports.TELEMETRY_QUERY_SOURCE = 'TELEMETRY';

/**
 * The name of the Kibana System ID used to publish and look up Kibana stats through the Monitoring system.
 * @type {string}
 */
const KIBANA_SYSTEM_ID = exports.KIBANA_SYSTEM_ID = 'kibana';

/**
 * The name of the Beats System ID used to publish and look up Beats stats through the Monitoring system.
 * @type {string}
 */
const BEATS_SYSTEM_ID = exports.BEATS_SYSTEM_ID = 'beats';

/**
 * The name of the Apm System ID used to publish and look up Apm stats through the Monitoring system.
 * @type {string}
 */
const APM_SYSTEM_ID = exports.APM_SYSTEM_ID = 'apm';

/**
 * The name of the Kibana System ID used to look up Logstash stats through the Monitoring system.
 * @type {string}
 */
const LOGSTASH_SYSTEM_ID = exports.LOGSTASH_SYSTEM_ID = 'logstash';

/**
 * The name of the Kibana System ID used to look up Reporting stats through the Monitoring system.
 * @type {string}
 */
const REPORTING_SYSTEM_ID = exports.REPORTING_SYSTEM_ID = 'reporting';

/**
 * The amount of time, in milliseconds, to wait between collecting kibana stats from es.
 *
 * Currently 24 hours kept in sync with reporting interval.
 * @type {Number}
 */
const TELEMETRY_COLLECTION_INTERVAL = exports.TELEMETRY_COLLECTION_INTERVAL = 86400000;

/**
 * The amount of time, in milliseconds, to fetch the cluster uuids from es.
 *
 * Currently 3 hours.
 * @type {Number}
 */
const CLUSTER_DETAILS_FETCH_INTERVAL = exports.CLUSTER_DETAILS_FETCH_INTERVAL = 10800000;

/**
 * The amount of time, in milliseconds, to fetch the usage data from es.
 *
 * Currently 20 minutes.
 * @type {Number}
 */
const USAGE_FETCH_INTERVAL = exports.USAGE_FETCH_INTERVAL = 1200000;

/**
 * The prefix for all rule types used by monitoring
 */
const RULE_PREFIX = exports.RULE_PREFIX = 'monitoring_';
const RULE_LICENSE_EXPIRATION = exports.RULE_LICENSE_EXPIRATION = `${RULE_PREFIX}alert_license_expiration`;
const RULE_CLUSTER_HEALTH = exports.RULE_CLUSTER_HEALTH = `${RULE_PREFIX}alert_cluster_health`;
const RULE_CPU_USAGE = exports.RULE_CPU_USAGE = `${RULE_PREFIX}alert_cpu_usage`;
const RULE_DISK_USAGE = exports.RULE_DISK_USAGE = `${RULE_PREFIX}alert_disk_usage`;
const RULE_NODES_CHANGED = exports.RULE_NODES_CHANGED = `${RULE_PREFIX}alert_nodes_changed`;
const RULE_ELASTICSEARCH_VERSION_MISMATCH = exports.RULE_ELASTICSEARCH_VERSION_MISMATCH = `${RULE_PREFIX}alert_elasticsearch_version_mismatch`;
const RULE_KIBANA_VERSION_MISMATCH = exports.RULE_KIBANA_VERSION_MISMATCH = `${RULE_PREFIX}alert_kibana_version_mismatch`;
const RULE_LOGSTASH_VERSION_MISMATCH = exports.RULE_LOGSTASH_VERSION_MISMATCH = `${RULE_PREFIX}alert_logstash_version_mismatch`;
const RULE_MEMORY_USAGE = exports.RULE_MEMORY_USAGE = `${RULE_PREFIX}alert_jvm_memory_usage`;
const RULE_MISSING_MONITORING_DATA = exports.RULE_MISSING_MONITORING_DATA = `${RULE_PREFIX}alert_missing_monitoring_data`;
const RULE_THREAD_POOL_SEARCH_REJECTIONS = exports.RULE_THREAD_POOL_SEARCH_REJECTIONS = `${RULE_PREFIX}alert_thread_pool_search_rejections`;
const RULE_THREAD_POOL_WRITE_REJECTIONS = exports.RULE_THREAD_POOL_WRITE_REJECTIONS = `${RULE_PREFIX}alert_thread_pool_write_rejections`;
const RULE_CCR_READ_EXCEPTIONS = exports.RULE_CCR_READ_EXCEPTIONS = `${RULE_PREFIX}ccr_read_exceptions`;
const RULE_LARGE_SHARD_SIZE = exports.RULE_LARGE_SHARD_SIZE = `${RULE_PREFIX}shard_size`;

/**
 * Legacy rules details/label for server and public use
 */
const LEGACY_RULE_DETAILS = exports.LEGACY_RULE_DETAILS = {
  [RULE_CLUSTER_HEALTH]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.clusterHealth.label', {
      defaultMessage: 'Cluster health'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.clusterHealth.description', {
      defaultMessage: 'Alert when the health of the cluster changes.'
    })
  },
  [RULE_ELASTICSEARCH_VERSION_MISMATCH]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.elasticsearchVersionMismatch.label', {
      defaultMessage: 'Elasticsearch version mismatch'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.elasticsearchVersionMismatch.description', {
      defaultMessage: 'Alert when the cluster has multiple versions of Elasticsearch.'
    })
  },
  [RULE_KIBANA_VERSION_MISMATCH]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.kibanaVersionMismatch.label', {
      defaultMessage: 'Kibana version mismatch'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.kibanaVersionMismatch.description', {
      defaultMessage: 'Alert when the cluser has multiple versions of Kibana.'
    })
  },
  [RULE_LICENSE_EXPIRATION]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.licenseExpiration.label', {
      defaultMessage: 'License expiration'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.licenseExpiration.description', {
      defaultMessage: 'Alert when the cluster license is about to expire.'
    })
  },
  [RULE_LOGSTASH_VERSION_MISMATCH]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.logstashVersionMismatch.label', {
      defaultMessage: 'Logstash version mismatch'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.logstashVersionMismatch.description', {
      defaultMessage: 'Alert when the cluster has multiple versions of Logstash.'
    })
  },
  [RULE_NODES_CHANGED]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.nodesChanged.label', {
      defaultMessage: 'Nodes changed'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.nodesChanged.description', {
      defaultMessage: 'Alert when adding, removing, or restarting a node.'
    })
  }
};

/**
 * Rules details/label for server and public use
 */
const RULE_DETAILS = exports.RULE_DETAILS = {
  [RULE_CPU_USAGE]: {
    label: _i18n.i18n.translate('xpack.monitoring.alerts.cpuUsage.label', {
      defaultMessage: 'CPU Usage'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.cpuUsage.description', {
      defaultMessage: 'Alert when the CPU load for a node is consistently high.'
    }),
    paramDetails: {
      threshold: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.cpuUsage.paramDetails.threshold.label', {
          defaultMessage: `Notify when CPU is over`
        }),
        type: _enums.AlertParamType.Percentage
      },
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.cpuUsage.paramDetails.duration.label', {
          defaultMessage: `Look at the average over`
        }),
        type: _enums.AlertParamType.Duration
      }
    }
  },
  [RULE_DISK_USAGE]: {
    paramDetails: {
      threshold: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.diskUsage.paramDetails.threshold.label', {
          defaultMessage: `Notify when disk capacity is over`
        }),
        type: _enums.AlertParamType.Percentage
      },
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.diskUsage.paramDetails.duration.label', {
          defaultMessage: `Look at the average over`
        }),
        type: _enums.AlertParamType.Duration
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.diskUsage.label', {
      defaultMessage: 'Disk Usage'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.diskUsage.description', {
      defaultMessage: 'Alert when the disk usage for a node is consistently high.'
    })
  },
  [RULE_MEMORY_USAGE]: {
    paramDetails: {
      threshold: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.memoryUsage.paramDetails.threshold.label', {
          defaultMessage: `Notify when memory usage is over`
        }),
        type: _enums.AlertParamType.Percentage
      },
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.memoryUsage.paramDetails.duration.label', {
          defaultMessage: `Look at the average over`
        }),
        type: _enums.AlertParamType.Duration
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.memoryUsage.label', {
      defaultMessage: 'Memory Usage (JVM)'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.memoryUsage.description', {
      defaultMessage: 'Alert when a node reports high memory usage.'
    })
  },
  [RULE_MISSING_MONITORING_DATA]: {
    paramDetails: {
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.missingData.paramDetails.duration.label', {
          defaultMessage: `Notify if monitoring data is missing for the last`
        }),
        type: _enums.AlertParamType.Duration
      },
      limit: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.missingData.paramDetails.limit.label', {
          defaultMessage: `looking back`
        }),
        type: _enums.AlertParamType.Duration
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.missingData.label', {
      defaultMessage: 'Missing monitoring data'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.missingData.description', {
      defaultMessage: 'Alert when monitoring data is missing.'
    })
  },
  [RULE_THREAD_POOL_SEARCH_REJECTIONS]: {
    paramDetails: {
      threshold: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.rejection.paramDetails.threshold.label', {
          defaultMessage: `Notify when {type} rejection count is over`,
          values: {
            type: 'search'
          }
        }),
        type: _enums.AlertParamType.Number
      },
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.rejection.paramDetails.duration.label', {
          defaultMessage: `In the last`
        }),
        type: _enums.AlertParamType.Duration
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.threadPoolRejections.label', {
      defaultMessage: 'Thread pool {type} rejections',
      values: {
        type: 'search'
      }
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.searchThreadPoolRejections.description', {
      defaultMessage: 'Alert when the number of rejections in the search thread pool exceeds the threshold.'
    })
  },
  [RULE_THREAD_POOL_WRITE_REJECTIONS]: {
    paramDetails: {
      threshold: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.rejection.paramDetails.threshold.label', {
          defaultMessage: `Notify when {type} rejection count is over`,
          values: {
            type: 'write'
          }
        }),
        type: _enums.AlertParamType.Number
      },
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.rejection.paramDetails.duration.label', {
          defaultMessage: `In the last`
        }),
        type: _enums.AlertParamType.Duration
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.threadPoolRejections.label', {
      defaultMessage: 'Thread pool {type} rejections',
      values: {
        type: 'write'
      }
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.writeThreadPoolRejections.description', {
      defaultMessage: 'Alert when the number of rejections in the write thread pool exceeds the threshold.'
    })
  },
  [RULE_CCR_READ_EXCEPTIONS]: {
    paramDetails: {
      duration: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.ccrReadExceptions.paramDetails.duration.label', {
          defaultMessage: `In the last`
        }),
        type: _enums.AlertParamType.Duration
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.ccrReadExceptions.label', {
      defaultMessage: 'CCR read exceptions'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.ccrReadExceptions.description', {
      defaultMessage: 'Alert if any CCR read exceptions have been detected.'
    })
  },
  [RULE_LARGE_SHARD_SIZE]: {
    paramDetails: {
      threshold: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.shardSize.paramDetails.threshold.label', {
          defaultMessage: `Notify when average shard size exceeds this value`
        }),
        type: _enums.AlertParamType.Number,
        append: 'GB'
      },
      indexPattern: {
        label: _i18n.i18n.translate('xpack.monitoring.alerts.shardSize.paramDetails.indexPattern.label', {
          defaultMessage: `Check the following index patterns`
        }),
        placeholder: 'eg: data-*, *prod-data, -.internal-data*',
        type: _enums.AlertParamType.TextField
      }
    },
    label: _i18n.i18n.translate('xpack.monitoring.alerts.shardSize.label', {
      defaultMessage: 'Shard size'
    }),
    description: _i18n.i18n.translate('xpack.monitoring.alerts.shardSize.description', {
      defaultMessage: 'Alert if the average shard size is larger than the configured threshold.'
    })
  }
};
const RULE_PANEL_MENU = exports.RULE_PANEL_MENU = [{
  label: _i18n.i18n.translate('xpack.monitoring.alerts.badge.panelCategory.clusterHealth', {
    defaultMessage: 'Cluster health'
  }),
  rules: [{
    ruleName: RULE_NODES_CHANGED
  }, {
    ruleName: RULE_CLUSTER_HEALTH
  }, {
    ruleName: RULE_ELASTICSEARCH_VERSION_MISMATCH
  }, {
    ruleName: RULE_KIBANA_VERSION_MISMATCH
  }, {
    ruleName: RULE_LOGSTASH_VERSION_MISMATCH
  }]
}, {
  label: _i18n.i18n.translate('xpack.monitoring.alerts.badge.panelCategory.resourceUtilization', {
    defaultMessage: 'Resource utilization'
  }),
  rules: [{
    ruleName: RULE_CPU_USAGE
  }, {
    ruleName: RULE_DISK_USAGE
  }, {
    ruleName: RULE_MEMORY_USAGE
  }, {
    ruleName: RULE_LARGE_SHARD_SIZE
  }]
}, {
  label: _i18n.i18n.translate('xpack.monitoring.alerts.badge.panelCategory.errors', {
    defaultMessage: 'Errors and exceptions'
  }),
  rules: [{
    ruleName: RULE_MISSING_MONITORING_DATA
  }, {
    ruleName: RULE_LICENSE_EXPIRATION
  }, {
    ruleName: RULE_THREAD_POOL_SEARCH_REJECTIONS
  }, {
    ruleName: RULE_THREAD_POOL_WRITE_REJECTIONS
  }, {
    ruleName: RULE_CCR_READ_EXCEPTIONS
  }]
}];

/**
 * A listing of all rule types
 */
const RULES = exports.RULES = [RULE_LICENSE_EXPIRATION, RULE_CLUSTER_HEALTH, RULE_CPU_USAGE, RULE_DISK_USAGE, RULE_NODES_CHANGED, RULE_ELASTICSEARCH_VERSION_MISMATCH, RULE_KIBANA_VERSION_MISMATCH, RULE_LOGSTASH_VERSION_MISMATCH, RULE_MEMORY_USAGE, RULE_MISSING_MONITORING_DATA, RULE_THREAD_POOL_SEARCH_REJECTIONS, RULE_THREAD_POOL_WRITE_REJECTIONS, RULE_CCR_READ_EXCEPTIONS, RULE_LARGE_SHARD_SIZE];

/**
 * A list of all legacy rules, which means they are powered by watcher
 */
const LEGACY_RULES = exports.LEGACY_RULES = [RULE_LICENSE_EXPIRATION, RULE_CLUSTER_HEALTH, RULE_NODES_CHANGED, RULE_ELASTICSEARCH_VERSION_MISMATCH, RULE_KIBANA_VERSION_MISMATCH, RULE_LOGSTASH_VERSION_MISMATCH];

/**
 * Matches the id for the built-in in email action type
 * See x-pack/plugins/actions/server/builtin_action_types/email.ts
 */
const ALERT_ACTION_TYPE_EMAIL = exports.ALERT_ACTION_TYPE_EMAIL = '.email';
/**
 * Matches the id for the built-in in log action type
 * See x-pack/plugins/actions/server/builtin_action_types/log.ts
 */
const ALERT_ACTION_TYPE_LOG = exports.ALERT_ACTION_TYPE_LOG = '.server-log';

/**
 * To enable modifing of rules in under actions
 */
const RULE_REQUIRES_APP_CONTEXT = exports.RULE_REQUIRES_APP_CONTEXT = false;
const ALERT_EMAIL_SERVICES = exports.ALERT_EMAIL_SERVICES = ['gmail', 'hotmail', 'icloud', 'outlook365', 'ses', 'yahoo'];
const MONITORING_CONFIG_ALERTING_EMAIL_ADDRESS = exports.MONITORING_CONFIG_ALERTING_EMAIL_ADDRESS = 'monitoring:alertingEmailAddress';
const XPACK_DEFAULT_ADMIN_EMAIL_UI_SETTING = exports.XPACK_DEFAULT_ADMIN_EMAIL_UI_SETTING = 'xPack:defaultAdminEmail';

/**
 * The saved object type for various monitoring data
 */
const SAVED_OBJECT_TELEMETRY = exports.SAVED_OBJECT_TELEMETRY = 'monitoring-telemetry';
const TELEMETRY_METRIC_BUTTON_CLICK = exports.TELEMETRY_METRIC_BUTTON_CLICK = 'btnclick__';